(function(f){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=f()}else if(typeof define==="function"&&define.amd){define([],f)}else{var g;if(typeof window!=="undefined"){g=window}else if(typeof global!=="undefined"){g=global}else if(typeof self!=="undefined"){g=self}else{g=this}g.interact = f()}})(function(){var define,module,exports;
var createModuleFactory = function createModuleFactory(t){var e;return function(r){return e||t(e={exports:{},parent:r},e.exports),e.exports}};
var _$Interactable_16 = createModuleFactory(function (module, exports) {
"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.Interactable = void 0;

var arr = _interopRequireWildcard(_$arr_49);

var _browser = _interopRequireDefault(_$browser_50);

var _clone = _interopRequireDefault(_$clone_51);

/* removed: var _$domUtils_53 = require("@interactjs/utils/domUtils"); */;

var _events = _interopRequireDefault(_$events_54);

var _extend = _interopRequireDefault(_$extend_55);

var is = _interopRequireWildcard(_$is_59);

var _normalizeListeners = _interopRequireDefault(_$normalizeListeners_61);

/* removed: var _$window_68 = require("@interactjs/utils/window"); */;

var _Eventable = _interopRequireDefault(_$Eventable_14);

var _scope = _$scope_24({});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/** */
var Interactable = /*#__PURE__*/function () {
  _createClass(Interactable, [{
    key: "_defaults",
    get: function get() {
      return {
        base: {},
        perAction: {},
        actions: {}
      };
    }
  }]);

  /** */
  function Interactable(target, options, defaultContext) {
    _classCallCheck(this, Interactable);

    _defineProperty(this, "options", void 0);

    _defineProperty(this, "_actions", void 0);

    _defineProperty(this, "target", void 0);

    _defineProperty(this, "events", new _Eventable["default"]());

    _defineProperty(this, "_context", void 0);

    _defineProperty(this, "_win", void 0);

    _defineProperty(this, "_doc", void 0);

    this._actions = options.actions;
    this.target = target;
    this._context = options.context || defaultContext;
    this._win = (0, _$window_68.getWindow)((0, _$domUtils_53.trySelector)(target) ? this._context : target);
    this._doc = this._win.document;
    this.set(options);
  }

  _createClass(Interactable, [{
    key: "setOnEvents",
    value: function setOnEvents(actionName, phases) {
      if (is.func(phases.onstart)) {
        this.on("".concat(actionName, "start"), phases.onstart);
      }

      if (is.func(phases.onmove)) {
        this.on("".concat(actionName, "move"), phases.onmove);
      }

      if (is.func(phases.onend)) {
        this.on("".concat(actionName, "end"), phases.onend);
      }

      if (is.func(phases.oninertiastart)) {
        this.on("".concat(actionName, "inertiastart"), phases.oninertiastart);
      }

      return this;
    }
  }, {
    key: "updatePerActionListeners",
    value: function updatePerActionListeners(actionName, prev, cur) {
      if (is.array(prev) || is.object(prev)) {
        this.off(actionName, prev);
      }

      if (is.array(cur) || is.object(cur)) {
        this.on(actionName, cur);
      }
    }
  }, {
    key: "setPerAction",
    value: function setPerAction(actionName, options) {
      var defaults = this._defaults; // for all the default per-action options

      for (var optionName_ in options) {
        var optionName = optionName_;
        var actionOptions = this.options[actionName];
        var optionValue = options[optionName]; // remove old event listeners and add new ones

        if (optionName === 'listeners') {
          this.updatePerActionListeners(actionName, actionOptions.listeners, optionValue);
        } // if the option value is an array


        if (is.array(optionValue)) {
          actionOptions[optionName] = arr.from(optionValue);
        } // if the option value is an object
        else if (is.plainObject(optionValue)) {
            // copy the object
            actionOptions[optionName] = (0, _extend["default"])(actionOptions[optionName] || {}, (0, _clone["default"])(optionValue)); // set anabled field to true if it exists in the defaults

            if (is.object(defaults.perAction[optionName]) && 'enabled' in defaults.perAction[optionName]) {
              actionOptions[optionName].enabled = optionValue.enabled !== false;
            }
          } // if the option value is a boolean and the default is an object
          else if (is.bool(optionValue) && is.object(defaults.perAction[optionName])) {
              actionOptions[optionName].enabled = optionValue;
            } // if it's anything else, do a plain assignment
            else {
                actionOptions[optionName] = optionValue;
              }
      }
    }
    /**
     * The default function to get an Interactables bounding rect. Can be
     * overridden using {@link Interactable.rectChecker}.
     *
     * @param {Element} [element] The element to measure.
     * @return {object} The object's bounding rectangle.
     */

  }, {
    key: "getRect",
    value: function getRect(element) {
      element = element || (is.element(this.target) ? this.target : null);

      if (is.string(this.target)) {
        element = element || this._context.querySelector(this.target);
      }

      return (0, _$domUtils_53.getElementRect)(element);
    }
    /**
     * Returns or sets the function used to calculate the interactable's
     * element's rectangle
     *
     * @param {function} [checker] A function which returns this Interactable's
     * bounding rectangle. See {@link Interactable.getRect}
     * @return {function | object} The checker function or this Interactable
     */

  }, {
    key: "rectChecker",
    value: function rectChecker(checker) {
      if (is.func(checker)) {
        this.getRect = checker;
        return this;
      }

      if (checker === null) {
        delete this.getRect;
        return this;
      }

      return this.getRect;
    }
  }, {
    key: "_backCompatOption",
    value: function _backCompatOption(optionName, newValue) {
      if ((0, _$domUtils_53.trySelector)(newValue) || is.object(newValue)) {
        this.options[optionName] = newValue;

        for (var action in this._actions.map) {
          this.options[action][optionName] = newValue;
        }

        return this;
      }

      return this.options[optionName];
    }
    /**
     * Gets or sets the origin of the Interactable's element.  The x and y
     * of the origin will be subtracted from action event coordinates.
     *
     * @param {Element | object | string} [origin] An HTML or SVG Element whose
     * rect will be used, an object eg. { x: 0, y: 0 } or string 'parent', 'self'
     * or any CSS selector
     *
     * @return {object} The current origin or this Interactable
     */

  }, {
    key: "origin",
    value: function origin(newValue) {
      return this._backCompatOption('origin', newValue);
    }
    /**
     * Returns or sets the mouse coordinate types used to calculate the
     * movement of the pointer.
     *
     * @param {string} [newValue] Use 'client' if you will be scrolling while
     * interacting; Use 'page' if you want autoScroll to work
     * @return {string | object} The current deltaSource or this Interactable
     */

  }, {
    key: "deltaSource",
    value: function deltaSource(newValue) {
      if (newValue === 'page' || newValue === 'client') {
        this.options.deltaSource = newValue;
        return this;
      }

      return this.options.deltaSource;
    }
    /**
     * Gets the selector context Node of the Interactable. The default is
     * `window.document`.
     *
     * @return {Node} The context Node of this Interactable
     */

  }, {
    key: "context",
    value: function context() {
      return this._context;
    }
  }, {
    key: "inContext",
    value: function inContext(element) {
      return this._context === element.ownerDocument || (0, _$domUtils_53.nodeContains)(this._context, element);
    }
  }, {
    key: "testIgnoreAllow",
    value: function testIgnoreAllow(options, targetNode, eventTarget) {
      return !this.testIgnore(options.ignoreFrom, targetNode, eventTarget) && this.testAllow(options.allowFrom, targetNode, eventTarget);
    }
  }, {
    key: "testAllow",
    value: function testAllow(allowFrom, targetNode, element) {
      if (!allowFrom) {
        return true;
      }

      if (!is.element(element)) {
        return false;
      }

      if (is.string(allowFrom)) {
        return (0, _$domUtils_53.matchesUpTo)(element, allowFrom, targetNode);
      } else if (is.element(allowFrom)) {
        return (0, _$domUtils_53.nodeContains)(allowFrom, element);
      }

      return false;
    }
  }, {
    key: "testIgnore",
    value: function testIgnore(ignoreFrom, targetNode, element) {
      if (!ignoreFrom || !is.element(element)) {
        return false;
      }

      if (is.string(ignoreFrom)) {
        return (0, _$domUtils_53.matchesUpTo)(element, ignoreFrom, targetNode);
      } else if (is.element(ignoreFrom)) {
        return (0, _$domUtils_53.nodeContains)(ignoreFrom, element);
      }

      return false;
    }
    /**
     * Calls listeners for the given InteractEvent type bound globally
     * and directly to this Interactable
     *
     * @param {InteractEvent} iEvent The InteractEvent object to be fired on this
     * Interactable
     * @return {Interactable} this Interactable
     */

  }, {
    key: "fire",
    value: function fire(iEvent) {
      this.events.fire(iEvent);
      return this;
    }
  }, {
    key: "_onOff",
    value: function _onOff(method, typeArg, listenerArg, options) {
      if (is.object(typeArg) && !is.array(typeArg)) {
        options = listenerArg;
        listenerArg = null;
      }

      var addRemove = method === 'on' ? 'add' : 'remove';
      var listeners = (0, _normalizeListeners["default"])(typeArg, listenerArg);

      for (var type in listeners) {
        if (type === 'wheel') {
          type = _browser["default"].wheelEvent;
        }

        for (var _i = 0; _i < listeners[type].length; _i++) {
          var _ref;

          _ref = listeners[type][_i];
          var listener = _ref;

          // if it is an action event type
          if ((0, _scope.isNonNativeEvent)(type, this._actions)) {
            this.events[method](type, listener);
          } // delegated event
          else if (is.string(this.target)) {
              _events["default"]["".concat(addRemove, "Delegate")](this.target, this._context, type, listener, options);
            } // remove listener from this Interactable's element
            else {
                _events["default"][addRemove](this.target, type, listener, options);
              }
        }
      }

      return this;
    }
    /**
     * Binds a listener for an InteractEvent, pointerEvent or DOM event.
     *
     * @param {string | array | object} types The types of events to listen
     * for
     * @param {function | array | object} [listener] The event listener function(s)
     * @param {object | boolean} [options] options object or useCapture flag for
     * addEventListener
     * @return {Interactable} This Interactable
     */

  }, {
    key: "on",
    value: function on(types, listener, options) {
      return this._onOff('on', types, listener, options);
    }
    /**
     * Removes an InteractEvent, pointerEvent or DOM event listener.
     *
     * @param {string | array | object} types The types of events that were
     * listened for
     * @param {function | array | object} [listener] The event listener function(s)
     * @param {object | boolean} [options] options object or useCapture flag for
     * removeEventListener
     * @return {Interactable} This Interactable
     */

  }, {
    key: "off",
    value: function off(types, listener, options) {
      return this._onOff('off', types, listener, options);
    }
    /**
     * Reset the options of this Interactable
     *
     * @param {object} options The new settings to apply
     * @return {object} This Interactable
     */

  }, {
    key: "set",
    value: function set(options) {
      var defaults = this._defaults;

      if (!is.object(options)) {
        options = {};
      }

      this.options = (0, _clone["default"])(defaults.base);

      for (var actionName_ in this._actions.methodDict) {
        var actionName = actionName_;
        var methodName = this._actions.methodDict[actionName];
        this.options[actionName] = {};
        this.setPerAction(actionName, (0, _extend["default"])((0, _extend["default"])({}, defaults.perAction), defaults.actions[actionName]));
        this[methodName](options[actionName]);
      }

      for (var setting in options) {
        if (is.func(this[setting])) {
          this[setting](options[setting]);
        }
      }

      return this;
    }
    /**
     * Remove this interactable from the list of interactables and remove it's
     * action capabilities and event listeners
     *
     * @return {interact}
     */

  }, {
    key: "unset",
    value: function unset() {
      _events["default"].remove(this.target, 'all');

      if (is.string(this.target)) {
        // remove delegated events
        for (var type in _events["default"].delegatedEvents) {
          var delegated = _events["default"].delegatedEvents[type];

          if (delegated.selectors[0] === this.target && delegated.contexts[0] === this._context) {
            delegated.selectors.splice(0, 1);
            delegated.contexts.splice(0, 1);
            delegated.listeners.splice(0, 1);
          }

          _events["default"].remove(this._context, type, _events["default"].delegateListener);

          _events["default"].remove(this._context, type, _events["default"].delegateUseCapture, true);
        }
      } else {
        _events["default"].remove(this.target, 'all');
      }
    }
  }]);

  return Interactable;
}();

exports.Interactable = Interactable;
var _default = Interactable;
exports["default"] = _default;

});
var _$scope_24 = createModuleFactory(function (module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
/* common-shake removed: exports.createScope = */ void createScope;
exports.isNonNativeEvent = isNonNativeEvent;
/* common-shake removed: exports.initScope = */ void initScope;
exports.Scope = void 0;

var _domObjects = _interopRequireDefault(_$domObjects_52);

var utils = _interopRequireWildcard(_$index_58);

var _defaultOptions = _interopRequireDefault(_$defaultOptions_20);

var _Eventable = _interopRequireDefault(_$Eventable_14);

var _Interactable = _interopRequireDefault(_$Interactable_16({}));

var _InteractableSet = _interopRequireDefault(_$InteractableSet_17);

var _InteractEvent = _interopRequireDefault(_$InteractEvent_15);

var _interactions = _interopRequireDefault(_$interactions_23({}));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var win = utils.win,
    browser = utils.browser,
    raf = utils.raf,
    events = utils.events; // eslint-disable-next-line @typescript-eslint/no-empty-interface

function createScope() {
  return new Scope();
}

var Scope = /*#__PURE__*/function () {
  // main window
  // main document
  // main window
  // all documents being listened to
  function Scope() {
    var _this = this;

    _classCallCheck(this, Scope);

    _defineProperty(this, "id", "__interact_scope_".concat(Math.floor(Math.random() * 100)));

    _defineProperty(this, "isInitialized", false);

    _defineProperty(this, "listenerMaps", []);

    _defineProperty(this, "browser", browser);

    _defineProperty(this, "events", events);

    _defineProperty(this, "utils", utils);

    _defineProperty(this, "defaults", utils.clone(_defaultOptions["default"]));

    _defineProperty(this, "Eventable", _Eventable["default"]);

    _defineProperty(this, "actions", {
      map: {},
      phases: {
        start: true,
        move: true,
        end: true
      },
      methodDict: {},
      phaselessTypes: {}
    });

    _defineProperty(this, "InteractEvent", _InteractEvent["default"]);

    _defineProperty(this, "Interactable", void 0);

    _defineProperty(this, "interactables", new _InteractableSet["default"](this));

    _defineProperty(this, "_win", void 0);

    _defineProperty(this, "document", void 0);

    _defineProperty(this, "window", void 0);

    _defineProperty(this, "documents", []);

    _defineProperty(this, "_plugins", {
      list: [],
      map: {}
    });

    _defineProperty(this, "onWindowUnload", function (event) {
      return _this.removeDocument(event.target);
    });

    var scope = this;

    this.Interactable = /*#__PURE__*/function (_InteractableBase) {
      _inherits(_class, _InteractableBase);

      function _class() {
        _classCallCheck(this, _class);

        return _possibleConstructorReturn(this, _getPrototypeOf(_class).apply(this, arguments));
      }

      _createClass(_class, [{
        key: "set",
        value: function set(options) {
          _get(_getPrototypeOf(_class.prototype), "set", this).call(this, options);

          scope.fire('interactable:set', {
            options: options,
            interactable: this
          });
          return this;
        }
      }, {
        key: "unset",
        value: function unset() {
          _get(_getPrototypeOf(_class.prototype), "unset", this).call(this);

          scope.interactables.list.splice(scope.interactables.list.indexOf(this), 1);
          scope.fire('interactable:unset', {
            interactable: this
          });
        }
      }, {
        key: "_defaults",
        get: function get() {
          return scope.defaults;
        }
      }]);

      return _class;
    }(_Interactable["default"]);
  }

  _createClass(Scope, [{
    key: "addListeners",
    value: function addListeners(map, id) {
      this.listenerMaps.push({
        id: id,
        map: map
      });
    }
  }, {
    key: "fire",
    value: function fire(name, arg) {
      for (var _i = 0; _i < this.listenerMaps.length; _i++) {
        var _ref;

        _ref = this.listenerMaps[_i];
        var _ref2 = _ref,
            listener = _ref2.map[name];

        if (!!listener && listener(arg, this, name) === false) {
          return false;
        }
      }
    }
  }, {
    key: "init",
    value: function init(window) {
      return this.isInitialized ? this : initScope(this, window);
    }
  }, {
    key: "pluginIsInstalled",
    value: function pluginIsInstalled(plugin) {
      return this._plugins.map[plugin.id] || this._plugins.list.indexOf(plugin) !== -1;
    }
  }, {
    key: "usePlugin",
    value: function usePlugin(plugin, options) {
      if (this.pluginIsInstalled(plugin)) {
        return this;
      }

      if (plugin.id) {
        this._plugins.map[plugin.id] = plugin;
      }

      this._plugins.list.push(plugin);

      if (plugin.install) {
        plugin.install(this, options);
      }

      if (plugin.listeners && plugin.before) {
        var _index = 0;
        var len = this.listenerMaps.length;
        var before = plugin.before.reduce(function (acc, id) {
          acc[id] = true;
          return acc;
        }, {});

        for (; _index < len; _index++) {
          var otherId = this.listenerMaps[_index].id;

          if (before[otherId]) {
            break;
          }
        }

        this.listenerMaps.splice(_index, 0, {
          id: plugin.id,
          map: plugin.listeners
        });
      } else if (plugin.listeners) {
        this.listenerMaps.push({
          id: plugin.id,
          map: plugin.listeners
        });
      }

      return this;
    }
  }, {
    key: "addDocument",
    value: function addDocument(doc, options) {
      // do nothing if document is already known
      if (this.getDocIndex(doc) !== -1) {
        return false;
      }

      var window = win.getWindow(doc);
      options = options ? utils.extend({}, options) : {};
      this.documents.push({
        doc: doc,
        options: options
      });
      events.documents.push(doc); // don't add an unload event for the main document
      // so that the page may be cached in browser history

      if (doc !== this.document) {
        events.add(window, 'unload', this.onWindowUnload);
      }

      this.fire('scope:add-document', {
        doc: doc,
        window: window,
        scope: this,
        options: options
      });
    }
  }, {
    key: "removeDocument",
    value: function removeDocument(doc) {
      var index = this.getDocIndex(doc);
      var window = win.getWindow(doc);
      var options = this.documents[index].options;
      events.remove(window, 'unload', this.onWindowUnload);
      this.documents.splice(index, 1);
      events.documents.splice(index, 1);
      this.fire('scope:remove-document', {
        doc: doc,
        window: window,
        scope: this,
        options: options
      });
    }
  }, {
    key: "getDocIndex",
    value: function getDocIndex(doc) {
      for (var i = 0; i < this.documents.length; i++) {
        if (this.documents[i].doc === doc) {
          return i;
        }
      }

      return -1;
    }
  }, {
    key: "getDocOptions",
    value: function getDocOptions(doc) {
      var docIndex = this.getDocIndex(doc);
      return docIndex === -1 ? null : this.documents[docIndex].options;
    }
  }, {
    key: "now",
    value: function now() {
      return (this.window.Date || Date).now();
    }
  }]);

  return Scope;
}();

exports.Scope = Scope;

function isNonNativeEvent(type, actions) {
  if (actions.phaselessTypes[type]) {
    return true;
  }

  for (var name in actions.map) {
    if (type.indexOf(name) === 0 && type.substr(name.length) in actions.phases) {
      return true;
    }
  }

  return false;
}

function initScope(scope, window) {
  scope.isInitialized = true;
  win.init(window);

  _domObjects["default"].init(window);

  browser.init(window);
  raf.init(window);
  events.init(window);
  scope.usePlugin(_interactions["default"]);
  scope.document = window.document;
  scope.window = window;
  return scope;
}

});
var _$interactions_23 = createModuleFactory(function (module, exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _browser = _interopRequireDefault(_$browser_50);

var _domObjects = _interopRequireDefault(_$domObjects_52);

/* removed: var _$domUtils_53 = require("@interactjs/utils/domUtils"); */;

var _events = _interopRequireDefault(_$events_54);

var pointerUtils = _interopRequireWildcard(_$pointerUtils_63);

var _Interaction = _interopRequireDefault(_$Interaction_18);

var _interactionFinder = _interopRequireDefault(_$interactionFinder_22);

var _scope = _$scope_24({});

var _interactablePreventDefault = _interopRequireDefault(_$interactablePreventDefault_21);

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

var methodNames = ['pointerDown', 'pointerMove', 'pointerUp', 'updatePointer', 'removePointer', 'windowBlur'];

function install(scope) {
  var listeners = {};

  for (var _i = 0; _i < methodNames.length; _i++) {
    var _ref;

    _ref = methodNames[_i];
    var method = _ref;
    listeners[method] = doOnInteractions(method, scope);
  }

  var pEventTypes = _browser["default"].pEventTypes;
  var docEvents;

  if (_domObjects["default"].PointerEvent) {
    docEvents = [{
      type: pEventTypes.down,
      listener: releasePointersOnRemovedEls
    }, {
      type: pEventTypes.down,
      listener: listeners.pointerDown
    }, {
      type: pEventTypes.move,
      listener: listeners.pointerMove
    }, {
      type: pEventTypes.up,
      listener: listeners.pointerUp
    }, {
      type: pEventTypes.cancel,
      listener: listeners.pointerUp
    }];
  } else {
    docEvents = [{
      type: 'mousedown',
      listener: listeners.pointerDown
    }, {
      type: 'mousemove',
      listener: listeners.pointerMove
    }, {
      type: 'mouseup',
      listener: listeners.pointerUp
    }, {
      type: 'touchstart',
      listener: releasePointersOnRemovedEls
    }, {
      type: 'touchstart',
      listener: listeners.pointerDown
    }, {
      type: 'touchmove',
      listener: listeners.pointerMove
    }, {
      type: 'touchend',
      listener: listeners.pointerUp
    }, {
      type: 'touchcancel',
      listener: listeners.pointerUp
    }];
  }

  docEvents.push({
    type: 'blur',
    listener: function listener(event) {
      for (var _i2 = 0; _i2 < scope.interactions.list.length; _i2++) {
        var _ref2;

        _ref2 = scope.interactions.list[_i2];
        var interaction = _ref2;
        interaction.documentBlur(event);
      }
    }
  }); // for ignoring browser's simulated mouse events

  scope.prevTouchTime = 0;

  scope.Interaction = /*#__PURE__*/function (_InteractionBase) {
    _inherits(_class, _InteractionBase);

    function _class() {
      _classCallCheck(this, _class);

      return _possibleConstructorReturn(this, _getPrototypeOf(_class).apply(this, arguments));
    }

    _createClass(_class, [{
      key: "_now",
      value: function _now() {
        return scope.now();
      }
    }, {
      key: "pointerMoveTolerance",
      get: function get() {
        return scope.interactions.pointerMoveTolerance;
      },
      set: function set(value) {
        scope.interactions.pointerMoveTolerance = value;
      }
    }]);

    return _class;
  }(_Interaction["default"]);

  scope.interactions = {
    // all active and idle interactions
    list: [],
    "new": function _new(options) {
      options.scopeFire = function (name, arg) {
        return scope.fire(name, arg);
      };

      var interaction = new scope.Interaction(options);
      scope.interactions.list.push(interaction);
      return interaction;
    },
    listeners: listeners,
    docEvents: docEvents,
    pointerMoveTolerance: 1
  };

  function releasePointersOnRemovedEls() {
    // for all inactive touch interactions with pointers down
    for (var _i3 = 0; _i3 < scope.interactions.list.length; _i3++) {
      var _ref3;

      _ref3 = scope.interactions.list[_i3];
      var interaction = _ref3;

      if (!interaction.pointerIsDown || interaction.pointerType !== 'touch' || interaction._interacting) {
        continue;
      } // if a pointer is down on an element that is no longer in the DOM tree


      var _loop = function _loop() {
        _ref4 = interaction.pointers[_i4];
        var pointer = _ref4;

        if (!scope.documents.some(function (_ref5) {
          var doc = _ref5.doc;
          return (0, _$domUtils_53.nodeContains)(doc, pointer.downTarget);
        })) {
          // remove the pointer from the interaction
          interaction.removePointer(pointer.pointer, pointer.event);
        }
      };

      for (var _i4 = 0; _i4 < interaction.pointers.length; _i4++) {
        var _ref4;

        _loop();
      }
    }
  }

  scope.usePlugin(_interactablePreventDefault["default"]);
}

function doOnInteractions(method, scope) {
  return function (event) {
    var interactions = scope.interactions.list;
    var pointerType = pointerUtils.getPointerType(event);

    var _pointerUtils$getEven = pointerUtils.getEventTargets(event),
        _pointerUtils$getEven2 = _slicedToArray(_pointerUtils$getEven, 2),
        eventTarget = _pointerUtils$getEven2[0],
        curEventTarget = _pointerUtils$getEven2[1];

    var matches = []; // [ [pointer, interaction], ...]

    if (/^touch/.test(event.type)) {
      scope.prevTouchTime = scope.now();

      for (var _i5 = 0; _i5 < event.changedTouches.length; _i5++) {
        var _ref6;

        _ref6 = event.changedTouches[_i5];
        var changedTouch = _ref6;
        var pointer = changedTouch;
        var pointerId = pointerUtils.getPointerId(pointer);
        var searchDetails = {
          pointer: pointer,
          pointerId: pointerId,
          pointerType: pointerType,
          eventType: event.type,
          eventTarget: eventTarget,
          curEventTarget: curEventTarget,
          scope: scope
        };
        var interaction = getInteraction(searchDetails);
        matches.push([searchDetails.pointer, searchDetails.eventTarget, searchDetails.curEventTarget, interaction]);
      }
    } else {
      var invalidPointer = false;

      if (!_browser["default"].supportsPointerEvent && /mouse/.test(event.type)) {
        // ignore mouse events while touch interactions are active
        for (var i = 0; i < interactions.length && !invalidPointer; i++) {
          invalidPointer = interactions[i].pointerType !== 'mouse' && interactions[i].pointerIsDown;
        } // try to ignore mouse events that are simulated by the browser
        // after a touch event


        invalidPointer = invalidPointer || scope.now() - scope.prevTouchTime < 500 || // on iOS and Firefox Mobile, MouseEvent.timeStamp is zero if simulated
        event.timeStamp === 0;
      }

      if (!invalidPointer) {
        var _searchDetails = {
          pointer: event,
          pointerId: pointerUtils.getPointerId(event),
          pointerType: pointerType,
          eventType: event.type,
          curEventTarget: curEventTarget,
          eventTarget: eventTarget,
          scope: scope
        };

        var _interaction = getInteraction(_searchDetails);

        matches.push([_searchDetails.pointer, _searchDetails.eventTarget, _searchDetails.curEventTarget, _interaction]);
      }
    } // eslint-disable-next-line no-shadow


    for (var _i6 = 0; _i6 < matches.length; _i6++) {
      var _matches$_i = _slicedToArray(matches[_i6], 4),
          _pointer = _matches$_i[0],
          _eventTarget = _matches$_i[1],
          _curEventTarget = _matches$_i[2],
          _interaction2 = _matches$_i[3];

      _interaction2[method](_pointer, event, _eventTarget, _curEventTarget);
    }
  };
}

function getInteraction(searchDetails) {
  var pointerType = searchDetails.pointerType,
      scope = searchDetails.scope;

  var foundInteraction = _interactionFinder["default"].search(searchDetails);

  var signalArg = {
    interaction: foundInteraction,
    searchDetails: searchDetails
  };
  scope.fire('interactions:find', signalArg);
  return signalArg.interaction || scope.interactions["new"]({
    pointerType: pointerType
  });
}

function onDocSignal(_ref7, eventMethodName) {
  var doc = _ref7.doc,
      scope = _ref7.scope,
      options = _ref7.options;
  var docEvents = scope.interactions.docEvents;
  var eventMethod = _events["default"][eventMethodName];

  if (scope.browser.isIOS && !options.events) {
    options.events = {
      passive: false
    };
  } // delegate event listener


  for (var eventType in _events["default"].delegatedEvents) {
    eventMethod(doc, eventType, _events["default"].delegateListener);
    eventMethod(doc, eventType, _events["default"].delegateUseCapture, true);
  }

  var eventOptions = options && options.events;

  for (var _i7 = 0; _i7 < docEvents.length; _i7++) {
    var _ref8;

    _ref8 = docEvents[_i7];
    var _ref9 = _ref8,
        _type = _ref9.type,
        listener = _ref9.listener;
    eventMethod(doc, _type, listener, eventOptions);
  }
}

var interactions = {
  id: 'core/interactions',
  install: install,
  listeners: {
    'scope:add-document': function scopeAddDocument(arg) {
      return onDocSignal(arg, 'add');
    },
    'scope:remove-document': function scopeRemoveDocument(arg) {
      return onDocSignal(arg, 'remove');
    },
    'interactable:unset': function interactableUnset(_ref10, scope) {
      var interactable = _ref10.interactable;

      // Stop and destroy related interactions when an Interactable is unset
      for (var i = scope.interactions.list.length - 1; i >= 0; i--) {
        var interaction = scope.interactions.list[i];

        if (interaction.interactable !== interactable) {
          continue;
        }

        interaction.stop();
        scope.fire('interactions:destroy', {
          interaction: interaction
        });
        interaction.destroy();

        if (scope.interactions.list.length > 2) {
          scope.interactions.list.splice(i, 1);
        }
      }
    }
  },
  onDocSignal: onDocSignal,
  doOnInteractions: doOnInteractions,
  methodNames: methodNames
};
var _default = interactions;
exports["default"] = _default;

});
var _$index_48 = {};
/// <reference path="./types.d.ts" />
"use strict";

var _$isWindow_60 = {};
"use strict";

Object.defineProperty(_$isWindow_60, "__esModule", {
  value: true
});
_$isWindow_60["default"] = void 0;

var _default = function _default(thing) {
  return !!(thing && thing.Window) && thing instanceof thing.Window;
};

_$isWindow_60["default"] = _default;

var _$window_68 = {};
"use strict";

Object.defineProperty(_$window_68, "__esModule", {
  value: true
});
_$window_68.init = init;
_$window_68.getWindow = getWindow;
_$window_68["default"] = void 0;

var _isWindow = _interopRequireDefault(_$isWindow_60);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var win = {
  realWindow: undefined,
  window: undefined,
  getWindow: getWindow,
  init: init
};

function init(window) {
  // get wrapped window if using Shadow DOM polyfill
  win.realWindow = window; // create a TextNode

  var el = window.document.createTextNode(''); // check if it's wrapped by a polyfill

  if (el.ownerDocument !== window.document && typeof window.wrap === 'function' && window.wrap(el) === el) {
    // use wrapped window
    window = window.wrap(window);
  }

  win.window = window;
}

if (typeof window === 'undefined') {
  win.window = undefined;
  win.realWindow = undefined;
} else {
  init(window);
}

function getWindow(node) {
  if ((0, _isWindow["default"])(node)) {
    return node;
  }

  var rootNode = node.ownerDocument || node;
  return rootNode.defaultView || win.window;
}

win.init = init;
var ___default_68 = win;
_$window_68["default"] = ___default_68;

var _$is_59 = {};
"use strict";

Object.defineProperty(_$is_59, "__esModule", {
  value: true
});
_$is_59.array = _$is_59.plainObject = _$is_59.element = _$is_59.string = _$is_59.bool = _$is_59.number = _$is_59.func = _$is_59.object = _$is_59.docFrag = _$is_59.window = void 0;

var ___isWindow_59 = ___interopRequireDefault_59(_$isWindow_60);

var _window2 = ___interopRequireDefault_59(_$window_68);

function ___interopRequireDefault_59(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var __window_59 = function window(thing) {
  return thing === _window2["default"].window || (0, ___isWindow_59["default"])(thing);
};

_$is_59.window = __window_59;

var docFrag = function docFrag(thing) {
  return object(thing) && thing.nodeType === 11;
};

_$is_59.docFrag = docFrag;

var object = function object(thing) {
  return !!thing && _typeof(thing) === 'object';
};

_$is_59.object = object;

var func = function func(thing) {
  return typeof thing === 'function';
};

_$is_59.func = func;

var number = function number(thing) {
  return typeof thing === 'number';
};

_$is_59.number = number;

var bool = function bool(thing) {
  return typeof thing === 'boolean';
};

_$is_59.bool = bool;

var string = function string(thing) {
  return typeof thing === 'string';
};

_$is_59.string = string;

var element = function element(thing) {
  if (!thing || _typeof(thing) !== 'object') {
    return false;
  }

  var _window = _window2["default"].getWindow(thing) || _window2["default"].window;

  return /object|function/.test(_typeof(_window.Element)) ? thing instanceof _window.Element // DOM2
  : thing.nodeType === 1 && typeof thing.nodeName === 'string';
};

_$is_59.element = element;

var plainObject = function plainObject(thing) {
  return object(thing) && !!thing.constructor && /function Object\b/.test(thing.constructor.toString());
};

_$is_59.plainObject = plainObject;

var array = function array(thing) {
  return object(thing) && typeof thing.length !== 'undefined' && func(thing.splice);
};

_$is_59.array = array;

var _$drag_1 = {};
"use strict";

function ___typeof_1(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_1 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_1 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_1(obj); }

Object.defineProperty(_$drag_1, "__esModule", {
  value: true
});
_$drag_1["default"] = void 0;

var is = _interopRequireWildcard(_$is_59);

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_1(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function install(scope) {
  var actions = scope.actions,
      Interactable = scope.Interactable,
      defaults = scope.defaults;
  Interactable.prototype.draggable = drag.draggable;
  actions.map.drag = drag;
  actions.methodDict.drag = 'draggable';
  defaults.actions.drag = drag.defaults;
}

function beforeMove(_ref) {
  var interaction = _ref.interaction;

  if (interaction.prepared.name !== 'drag') {
    return;
  }

  var axis = interaction.prepared.axis;

  if (axis === 'x') {
    interaction.coords.cur.page.y = interaction.coords.start.page.y;
    interaction.coords.cur.client.y = interaction.coords.start.client.y;
    interaction.coords.velocity.client.y = 0;
    interaction.coords.velocity.page.y = 0;
  } else if (axis === 'y') {
    interaction.coords.cur.page.x = interaction.coords.start.page.x;
    interaction.coords.cur.client.x = interaction.coords.start.client.x;
    interaction.coords.velocity.client.x = 0;
    interaction.coords.velocity.page.x = 0;
  }
}

function move(_ref2) {
  var iEvent = _ref2.iEvent,
      interaction = _ref2.interaction;

  if (interaction.prepared.name !== 'drag') {
    return;
  }

  var axis = interaction.prepared.axis;

  if (axis === 'x' || axis === 'y') {
    var opposite = axis === 'x' ? 'y' : 'x';
    iEvent.page[opposite] = interaction.coords.start.page[opposite];
    iEvent.client[opposite] = interaction.coords.start.client[opposite];
    iEvent.delta[opposite] = 0;
  }
}
/**
 * ```js
 * interact(element).draggable({
 *     onstart: function (event) {},
 *     onmove : function (event) {},
 *     onend  : function (event) {},
 *
 *     // the axis in which the first movement must be
 *     // for the drag sequence to start
 *     // 'xy' by default - any direction
 *     startAxis: 'x' || 'y' || 'xy',
 *
 *     // 'xy' by default - don't restrict to one axis (move in any direction)
 *     // 'x' or 'y' to restrict movement to either axis
 *     // 'start' to restrict movement to the axis the drag started in
 *     lockAxis: 'x' || 'y' || 'xy' || 'start',
 *
 *     // max number of drags that can happen concurrently
 *     // with elements of this Interactable. Infinity by default
 *     max: Infinity,
 *
 *     // max number of drags that can target the same element+Interactable
 *     // 1 by default
 *     maxPerElement: 2
 * })
 *
 * var isDraggable = interact('element').draggable(); // true
 * ```
 *
 * Get or set whether drag actions can be performed on the target
 *
 * @alias Interactable.prototype.draggable
 *
 * @param {boolean | object} [options] true/false or An object with event
 * listeners to be fired on drag events (object makes the Interactable
 * draggable)
 * @return {boolean | Interactable} boolean indicating if this can be the
 * target of drag events, or this Interctable
 */


var draggable = function draggable(options) {
  if (is.object(options)) {
    this.options.drag.enabled = options.enabled !== false;
    this.setPerAction('drag', options);
    this.setOnEvents('drag', options);

    if (/^(xy|x|y|start)$/.test(options.lockAxis)) {
      this.options.drag.lockAxis = options.lockAxis;
    }

    if (/^(xy|x|y)$/.test(options.startAxis)) {
      this.options.drag.startAxis = options.startAxis;
    }

    return this;
  }

  if (is.bool(options)) {
    this.options.drag.enabled = options;
    return this;
  }

  return this.options.drag;
};

var drag = {
  id: 'actions/drag',
  install: install,
  listeners: {
    'interactions:before-action-move': beforeMove,
    'interactions:action-resume': beforeMove,
    // dragmove
    'interactions:action-move': move,
    'auto-start:check': function autoStartCheck(arg) {
      var interaction = arg.interaction,
          interactable = arg.interactable,
          buttons = arg.buttons;
      var dragOptions = interactable.options.drag;

      if (!(dragOptions && dragOptions.enabled) || // check mouseButton setting if the pointer is down
      interaction.pointerIsDown && /mouse|pointer/.test(interaction.pointerType) && (buttons & interactable.options.drag.mouseButtons) === 0) {
        return undefined;
      }

      arg.action = {
        name: 'drag',
        axis: dragOptions.lockAxis === 'start' ? dragOptions.startAxis : dragOptions.lockAxis
      };
      return false;
    }
  },
  draggable: draggable,
  beforeMove: beforeMove,
  move: move,
  defaults: {
    startAxis: 'xy',
    lockAxis: 'xy'
  },
  getCursor: function getCursor() {
    return 'move';
  }
};
var ___default_1 = drag;
_$drag_1["default"] = ___default_1;

var _$arr_49 = {};
"use strict";

Object.defineProperty(_$arr_49, "__esModule", {
  value: true
});
_$arr_49.find = _$arr_49.findIndex = _$arr_49.from = _$arr_49.merge = _$arr_49.remove = _$arr_49.contains = void 0;

var contains = function contains(array, target) {
  return array.indexOf(target) !== -1;
};

_$arr_49.contains = contains;

var remove = function remove(array, target) {
  return array.splice(array.indexOf(target), 1);
};

_$arr_49.remove = remove;

var merge = function merge(target, source) {
  for (var _i = 0; _i < source.length; _i++) {
    var _ref;

    _ref = source[_i];
    var item = _ref;
    target.push(item);
  }

  return target;
};

_$arr_49.merge = merge;

var from = function from(source) {
  return merge([], source);
};

_$arr_49.from = from;

var findIndex = function findIndex(array, func) {
  for (var i = 0; i < array.length; i++) {
    if (func(array[i], i, array)) {
      return i;
    }
  }

  return -1;
};

_$arr_49.findIndex = findIndex;

var find = function find(array, func) {
  return array[findIndex(array, func)];
};

_$arr_49.find = find;

var _$domObjects_52 = {};
"use strict";

Object.defineProperty(_$domObjects_52, "__esModule", {
  value: true
});
_$domObjects_52["default"] = void 0;
var domObjects = {
  init: __init_52,
  document: null,
  DocumentFragment: null,
  SVGElement: null,
  SVGSVGElement: null,
  SVGElementInstance: null,
  Element: null,
  HTMLElement: null,
  Event: null,
  Touch: null,
  PointerEvent: null
};

function blank() {}

var ___default_52 = domObjects;
_$domObjects_52["default"] = ___default_52;

function __init_52(window) {
  var win = window;
  domObjects.document = win.document;
  domObjects.DocumentFragment = win.DocumentFragment || blank;
  domObjects.SVGElement = win.SVGElement || blank;
  domObjects.SVGSVGElement = win.SVGSVGElement || blank;
  domObjects.SVGElementInstance = win.SVGElementInstance || blank;
  domObjects.Element = win.Element || blank;
  domObjects.HTMLElement = win.HTMLElement || domObjects.Element;
  domObjects.Event = win.Event;
  domObjects.Touch = win.Touch || blank;
  domObjects.PointerEvent = win.PointerEvent || win.MSPointerEvent;
}

var _$browser_50 = {};
"use strict";

function ___typeof_50(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_50 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_50 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_50(obj); }

Object.defineProperty(_$browser_50, "__esModule", {
  value: true
});
_$browser_50["default"] = void 0;

var _domObjects = ___interopRequireDefault_50(_$domObjects_52);

var __is_50 = ___interopRequireWildcard_50(_$is_59);

var _window = ___interopRequireDefault_50(_$window_68);

function ___getRequireWildcardCache_50() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_50 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_50(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_50(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_50(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_50(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var browser = {
  init: __init_50,
  supportsTouch: null,
  supportsPointerEvent: null,
  isIOS7: null,
  isIOS: null,
  isIe9: null,
  isOperaMobile: null,
  prefixedMatchesSelector: null,
  pEventTypes: null,
  wheelEvent: null
};

function __init_50(window) {
  var Element = _domObjects["default"].Element;
  var navigator = _window["default"].window.navigator; // Does the browser support touch input?

  browser.supportsTouch = 'ontouchstart' in window || __is_50.func(window.DocumentTouch) && _domObjects["default"].document instanceof window.DocumentTouch; // Does the browser support PointerEvents

  browser.supportsPointerEvent = navigator.pointerEnabled !== false && !!_domObjects["default"].PointerEvent;
  browser.isIOS = /iP(hone|od|ad)/.test(navigator.platform); // scrolling doesn't change the result of getClientRects on iOS 7

  browser.isIOS7 = /iP(hone|od|ad)/.test(navigator.platform) && /OS 7[^\d]/.test(navigator.appVersion);
  browser.isIe9 = /MSIE 9/.test(navigator.userAgent); // Opera Mobile must be handled differently

  browser.isOperaMobile = navigator.appName === 'Opera' && browser.supportsTouch && /Presto/.test(navigator.userAgent); // prefix matchesSelector

  browser.prefixedMatchesSelector = 'matches' in Element.prototype ? 'matches' : 'webkitMatchesSelector' in Element.prototype ? 'webkitMatchesSelector' : 'mozMatchesSelector' in Element.prototype ? 'mozMatchesSelector' : 'oMatchesSelector' in Element.prototype ? 'oMatchesSelector' : 'msMatchesSelector';
  browser.pEventTypes = browser.supportsPointerEvent ? _domObjects["default"].PointerEvent === window.MSPointerEvent ? {
    up: 'MSPointerUp',
    down: 'MSPointerDown',
    over: 'mouseover',
    out: 'mouseout',
    move: 'MSPointerMove',
    cancel: 'MSPointerCancel'
  } : {
    up: 'pointerup',
    down: 'pointerdown',
    over: 'pointerover',
    out: 'pointerout',
    move: 'pointermove',
    cancel: 'pointercancel'
  } : null; // because Webkit and Opera still use 'mousewheel' event type

  browser.wheelEvent = 'onmousewheel' in _domObjects["default"].document ? 'mousewheel' : 'wheel';
}

var ___default_50 = browser;
_$browser_50["default"] = ___default_50;

var _$clone_51 = {};
"use strict";

function ___typeof_51(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_51 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_51 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_51(obj); }

Object.defineProperty(_$clone_51, "__esModule", {
  value: true
});
_$clone_51["default"] = clone;

var arr = ___interopRequireWildcard_51(_$arr_49);

var __is_51 = ___interopRequireWildcard_51(_$is_59);

function ___getRequireWildcardCache_51() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_51 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_51(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_51(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_51(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

// tslint:disable-next-line ban-types
function clone(source) {
  var dest = {};

  for (var prop in source) {
    var value = source[prop];

    if (__is_51.plainObject(value)) {
      dest[prop] = clone(value);
    } else if (__is_51.array(value)) {
      dest[prop] = arr.from(value);
    } else {
      dest[prop] = value;
    }
  }

  return dest;
}

var _$domUtils_53 = {};
"use strict";

function ___typeof_53(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_53 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_53 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_53(obj); }

Object.defineProperty(_$domUtils_53, "__esModule", {
  value: true
});
_$domUtils_53.nodeContains = nodeContains;
_$domUtils_53.closest = closest;
_$domUtils_53.parentNode = parentNode;
_$domUtils_53.matchesSelector = matchesSelector;
_$domUtils_53.indexOfDeepestElement = indexOfDeepestElement;
_$domUtils_53.matchesUpTo = matchesUpTo;
_$domUtils_53.getActualElement = getActualElement;
_$domUtils_53.getScrollXY = getScrollXY;
_$domUtils_53.getElementClientRect = getElementClientRect;
_$domUtils_53.getElementRect = getElementRect;
_$domUtils_53.getPath = getPath;
_$domUtils_53.trySelector = trySelector;

var _browser = ___interopRequireDefault_53(_$browser_50);

var ___domObjects_53 = ___interopRequireDefault_53(_$domObjects_52);

var __is_53 = ___interopRequireWildcard_53(_$is_59);

var ___window_53 = ___interopRequireWildcard_53(_$window_68);

function ___getRequireWildcardCache_53() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_53 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_53(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_53(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_53(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_53(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function nodeContains(parent, child) {
  while (child) {
    if (child === parent) {
      return true;
    }

    child = child.parentNode;
  }

  return false;
}

function closest(element, selector) {
  while (__is_53.element(element)) {
    if (matchesSelector(element, selector)) {
      return element;
    }

    element = parentNode(element);
  }

  return null;
}

function parentNode(node) {
  var parent = node.parentNode;

  if (__is_53.docFrag(parent)) {
    // skip past #shado-root fragments
    // tslint:disable-next-line
    while ((parent = parent.host) && __is_53.docFrag(parent)) {
      continue;
    }

    return parent;
  }

  return parent;
}

function matchesSelector(element, selector) {
  // remove /deep/ from selectors if shadowDOM polyfill is used
  if (___window_53["default"].window !== ___window_53["default"].realWindow) {
    selector = selector.replace(/\/deep\//g, ' ');
  }

  return element[_browser["default"].prefixedMatchesSelector](selector);
}

var getParent = function getParent(el) {
  return el.parentNode ? el.parentNode : el.host;
}; // Test for the element that's "above" all other qualifiers


function indexOfDeepestElement(elements) {
  var deepestZoneParents = [];
  var deepestZone = elements[0];
  var index = deepestZone ? 0 : -1;
  var i;
  var n;

  for (i = 1; i < elements.length; i++) {
    var dropzone = elements[i]; // an element might belong to multiple selector dropzones

    if (!dropzone || dropzone === deepestZone) {
      continue;
    }

    if (!deepestZone) {
      deepestZone = dropzone;
      index = i;
      continue;
    } // check if the deepest or current are document.documentElement or document.rootElement
    // - if the current dropzone is, do nothing and continue


    if (dropzone.parentNode === dropzone.ownerDocument) {
      continue;
    } // - if deepest is, update with the current dropzone and continue to next
    else if (deepestZone.parentNode === dropzone.ownerDocument) {
        deepestZone = dropzone;
        index = i;
        continue;
      } // compare zIndex of siblings


    if (dropzone.parentNode === deepestZone.parentNode) {
      var deepestZIndex = parseInt((0, ___window_53.getWindow)(deepestZone).getComputedStyle(deepestZone).zIndex, 10) || 0;
      var dropzoneZIndex = parseInt((0, ___window_53.getWindow)(dropzone).getComputedStyle(dropzone).zIndex, 10) || 0;

      if (dropzoneZIndex >= deepestZIndex) {
        deepestZone = dropzone;
        index = i;
      }

      continue;
    } // populate the ancestry array for the latest deepest dropzone


    if (!deepestZoneParents.length) {
      var _parent = deepestZone;
      var parentParent = void 0;

      while ((parentParent = getParent(_parent)) && parentParent !== _parent.ownerDocument) {
        deepestZoneParents.unshift(_parent);
        _parent = parentParent;
      }
    }

    var parent = void 0; // if this element is an svg element and the current deepest is an
    // HTMLElement

    if (deepestZone instanceof ___domObjects_53["default"].HTMLElement && dropzone instanceof ___domObjects_53["default"].SVGElement && !(dropzone instanceof ___domObjects_53["default"].SVGSVGElement)) {
      if (dropzone === deepestZone.parentNode) {
        continue;
      }

      parent = dropzone.ownerSVGElement;
    } else {
      parent = dropzone;
    }

    var dropzoneParents = [];

    while (parent.parentNode !== parent.ownerDocument) {
      dropzoneParents.unshift(parent);
      parent = getParent(parent);
    }

    n = 0; // get (position of last common ancestor) + 1

    while (dropzoneParents[n] && dropzoneParents[n] === deepestZoneParents[n]) {
      n++;
    }

    var parents = [dropzoneParents[n - 1], dropzoneParents[n], deepestZoneParents[n]];
    var child = parents[0].lastChild;

    while (child) {
      if (child === parents[1]) {
        deepestZone = dropzone;
        index = i;
        deepestZoneParents = dropzoneParents;
        break;
      } else if (child === parents[2]) {
        break;
      }

      child = child.previousSibling;
    }
  }

  return index;
}

function matchesUpTo(element, selector, limit) {
  while (__is_53.element(element)) {
    if (matchesSelector(element, selector)) {
      return true;
    }

    element = parentNode(element);

    if (element === limit) {
      return matchesSelector(element, selector);
    }
  }

  return false;
}

function getActualElement(element) {
  return element instanceof ___domObjects_53["default"].SVGElementInstance ? element.correspondingUseElement : element;
}

function getScrollXY(relevantWindow) {
  relevantWindow = relevantWindow || ___window_53["default"].window;
  return {
    x: relevantWindow.scrollX || relevantWindow.document.documentElement.scrollLeft,
    y: relevantWindow.scrollY || relevantWindow.document.documentElement.scrollTop
  };
}

function getElementClientRect(element) {
  var clientRect = element instanceof ___domObjects_53["default"].SVGElement ? element.getBoundingClientRect() : element.getClientRects()[0];
  return clientRect && {
    left: clientRect.left,
    right: clientRect.right,
    top: clientRect.top,
    bottom: clientRect.bottom,
    width: clientRect.width || clientRect.right - clientRect.left,
    height: clientRect.height || clientRect.bottom - clientRect.top
  };
}

function getElementRect(element) {
  var clientRect = getElementClientRect(element);

  if (!_browser["default"].isIOS7 && clientRect) {
    var scroll = getScrollXY(___window_53["default"].getWindow(element));
    clientRect.left += scroll.x;
    clientRect.right += scroll.x;
    clientRect.top += scroll.y;
    clientRect.bottom += scroll.y;
  }

  return clientRect;
}

function getPath(node) {
  var path = [];

  while (node) {
    path.push(node);
    node = parentNode(node);
  }

  return path;
}

function trySelector(value) {
  if (!__is_53.string(value)) {
    return false;
  } // an exception will be raised if it is invalid


  ___domObjects_53["default"].document.querySelector(value);

  return true;
}

var _$pointerExtend_62 = {};
"use strict";

Object.defineProperty(_$pointerExtend_62, "__esModule", {
  value: true
});
_$pointerExtend_62["default"] = void 0;

function pointerExtend(dest, source) {
  for (var prop in source) {
    var prefixedPropREs = pointerExtend.prefixedPropREs;
    var deprecated = false; // skip deprecated prefixed properties

    for (var vendor in prefixedPropREs) {
      if (prop.indexOf(vendor) === 0 && prefixedPropREs[vendor].test(prop)) {
        deprecated = true;
        break;
      }
    }

    if (!deprecated && typeof source[prop] !== 'function') {
      dest[prop] = source[prop];
    }
  }

  return dest;
}

pointerExtend.prefixedPropREs = {
  webkit: /(Movement[XY]|Radius[XY]|RotationAngle|Force)$/,
  moz: /(Pressure)$/
};
var ___default_62 = pointerExtend;
_$pointerExtend_62["default"] = ___default_62;

var _$hypot_57 = {};
"use strict";

Object.defineProperty(_$hypot_57, "__esModule", {
  value: true
});
_$hypot_57["default"] = void 0;

var ___default_57 = function _default(x, y) {
  return Math.sqrt(x * x + y * y);
};

_$hypot_57["default"] = ___default_57;

var _$pointerUtils_63 = {};
"use strict";

function ___typeof_63(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_63 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_63 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_63(obj); }

Object.defineProperty(_$pointerUtils_63, "__esModule", {
  value: true
});
_$pointerUtils_63.copyCoords = copyCoords;
_$pointerUtils_63.setCoordDeltas = setCoordDeltas;
_$pointerUtils_63.setCoordVelocity = setCoordVelocity;
_$pointerUtils_63.setZeroCoords = setZeroCoords;
_$pointerUtils_63.isNativePointer = isNativePointer;
_$pointerUtils_63.getXY = getXY;
_$pointerUtils_63.getPageXY = getPageXY;
_$pointerUtils_63.getClientXY = getClientXY;
_$pointerUtils_63.getPointerId = getPointerId;
_$pointerUtils_63.setCoords = setCoords;
_$pointerUtils_63.getTouchPair = getTouchPair;
_$pointerUtils_63.pointerAverage = pointerAverage;
_$pointerUtils_63.touchBBox = touchBBox;
_$pointerUtils_63.touchDistance = touchDistance;
_$pointerUtils_63.touchAngle = touchAngle;
_$pointerUtils_63.getPointerType = getPointerType;
_$pointerUtils_63.getEventTargets = getEventTargets;
_$pointerUtils_63.newCoords = newCoords;
_$pointerUtils_63.coordsToEvent = coordsToEvent;
Object.defineProperty(_$pointerUtils_63, "pointerExtend", {
  enumerable: true,
  get: function get() {
    return _pointerExtend["default"];
  }
});

var ___browser_63 = ___interopRequireDefault_63(_$browser_50);

var ___domObjects_63 = ___interopRequireDefault_63(_$domObjects_52);

var domUtils = ___interopRequireWildcard_63(_$domUtils_53);

var _hypot = ___interopRequireDefault_63(_$hypot_57);

var __is_63 = ___interopRequireWildcard_63(_$is_59);

var _pointerExtend = ___interopRequireDefault_63(_$pointerExtend_62);

function ___getRequireWildcardCache_63() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_63 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_63(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_63(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_63(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_63(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function copyCoords(dest, src) {
  dest.page = dest.page || {};
  dest.page.x = src.page.x;
  dest.page.y = src.page.y;
  dest.client = dest.client || {};
  dest.client.x = src.client.x;
  dest.client.y = src.client.y;
  dest.timeStamp = src.timeStamp;
}

function setCoordDeltas(targetObj, prev, cur) {
  targetObj.page.x = cur.page.x - prev.page.x;
  targetObj.page.y = cur.page.y - prev.page.y;
  targetObj.client.x = cur.client.x - prev.client.x;
  targetObj.client.y = cur.client.y - prev.client.y;
  targetObj.timeStamp = cur.timeStamp - prev.timeStamp;
}

function setCoordVelocity(targetObj, delta) {
  var dt = Math.max(delta.timeStamp / 1000, 0.001);
  targetObj.page.x = delta.page.x / dt;
  targetObj.page.y = delta.page.y / dt;
  targetObj.client.x = delta.client.x / dt;
  targetObj.client.y = delta.client.y / dt;
  targetObj.timeStamp = dt;
}

function setZeroCoords(targetObj) {
  targetObj.page.x = 0;
  targetObj.page.y = 0;
  targetObj.client.x = 0;
  targetObj.client.y = 0;
}

function isNativePointer(pointer) {
  return pointer instanceof ___domObjects_63["default"].Event || pointer instanceof ___domObjects_63["default"].Touch;
} // Get specified X/Y coords for mouse or event.touches[0]


function getXY(type, pointer, xy) {
  xy = xy || {};
  type = type || 'page';
  xy.x = pointer[type + 'X'];
  xy.y = pointer[type + 'Y'];
  return xy;
}

function getPageXY(pointer, page) {
  page = page || {
    x: 0,
    y: 0
  }; // Opera Mobile handles the viewport and scrolling oddly

  if (___browser_63["default"].isOperaMobile && isNativePointer(pointer)) {
    getXY('screen', pointer, page);
    page.x += window.scrollX;
    page.y += window.scrollY;
  } else {
    getXY('page', pointer, page);
  }

  return page;
}

function getClientXY(pointer, client) {
  client = client || {};

  if (___browser_63["default"].isOperaMobile && isNativePointer(pointer)) {
    // Opera Mobile handles the viewport and scrolling oddly
    getXY('screen', pointer, client);
  } else {
    getXY('client', pointer, client);
  }

  return client;
}

function getPointerId(pointer) {
  return __is_63.number(pointer.pointerId) ? pointer.pointerId : pointer.identifier;
}

function setCoords(targetObj, pointers, timeStamp) {
  var pointer = pointers.length > 1 ? pointerAverage(pointers) : pointers[0];
  var tmpXY = {};
  getPageXY(pointer, tmpXY);
  targetObj.page.x = tmpXY.x;
  targetObj.page.y = tmpXY.y;
  getClientXY(pointer, tmpXY);
  targetObj.client.x = tmpXY.x;
  targetObj.client.y = tmpXY.y;
  targetObj.timeStamp = timeStamp;
}

function getTouchPair(event) {
  var touches = []; // array of touches is supplied

  if (__is_63.array(event)) {
    touches[0] = event[0];
    touches[1] = event[1];
  } // an event
  else {
      if (event.type === 'touchend') {
        if (event.touches.length === 1) {
          touches[0] = event.touches[0];
          touches[1] = event.changedTouches[0];
        } else if (event.touches.length === 0) {
          touches[0] = event.changedTouches[0];
          touches[1] = event.changedTouches[1];
        }
      } else {
        touches[0] = event.touches[0];
        touches[1] = event.touches[1];
      }
    }

  return touches;
}

function pointerAverage(pointers) {
  var average = {
    pageX: 0,
    pageY: 0,
    clientX: 0,
    clientY: 0,
    screenX: 0,
    screenY: 0
  };

  for (var _i = 0; _i < pointers.length; _i++) {
    var _ref;

    _ref = pointers[_i];
    var pointer = _ref;

    for (var _prop in average) {
      average[_prop] += pointer[_prop];
    }
  }

  for (var prop in average) {
    average[prop] /= pointers.length;
  }

  return average;
}

function touchBBox(event) {
  if (!event.length && !(event.touches && event.touches.length > 1)) {
    return null;
  }

  var touches = getTouchPair(event);
  var minX = Math.min(touches[0].pageX, touches[1].pageX);
  var minY = Math.min(touches[0].pageY, touches[1].pageY);
  var maxX = Math.max(touches[0].pageX, touches[1].pageX);
  var maxY = Math.max(touches[0].pageY, touches[1].pageY);
  return {
    x: minX,
    y: minY,
    left: minX,
    top: minY,
    right: maxX,
    bottom: maxY,
    width: maxX - minX,
    height: maxY - minY
  };
}

function touchDistance(event, deltaSource) {
  var sourceX = deltaSource + 'X';
  var sourceY = deltaSource + 'Y';
  var touches = getTouchPair(event);
  var dx = touches[0][sourceX] - touches[1][sourceX];
  var dy = touches[0][sourceY] - touches[1][sourceY];
  return (0, _hypot["default"])(dx, dy);
}

function touchAngle(event, deltaSource) {
  var sourceX = deltaSource + 'X';
  var sourceY = deltaSource + 'Y';
  var touches = getTouchPair(event);
  var dx = touches[1][sourceX] - touches[0][sourceX];
  var dy = touches[1][sourceY] - touches[0][sourceY];
  var angle = 180 * Math.atan2(dy, dx) / Math.PI;
  return angle;
}

function getPointerType(pointer) {
  return __is_63.string(pointer.pointerType) ? pointer.pointerType : __is_63.number(pointer.pointerType) ? [undefined, undefined, 'touch', 'pen', 'mouse'][pointer.pointerType] // if the PointerEvent API isn't available, then the "pointer" must
  // be either a MouseEvent, TouchEvent, or Touch object
  : /touch/.test(pointer.type) || pointer instanceof ___domObjects_63["default"].Touch ? 'touch' : 'mouse';
} // [ event.target, event.currentTarget ]


function getEventTargets(event) {
  var path = __is_63.func(event.composedPath) ? event.composedPath() : event.path;
  return [domUtils.getActualElement(path ? path[0] : event.target), domUtils.getActualElement(event.currentTarget)];
}

function newCoords() {
  return {
    page: {
      x: 0,
      y: 0
    },
    client: {
      x: 0,
      y: 0
    },
    timeStamp: 0
  };
}

function coordsToEvent(coords) {
  var event = {
    coords: coords,

    get page() {
      return this.coords.page;
    },

    get client() {
      return this.coords.client;
    },

    get timeStamp() {
      return this.coords.timeStamp;
    },

    get pageX() {
      return this.coords.page.x;
    },

    get pageY() {
      return this.coords.page.y;
    },

    get clientX() {
      return this.coords.client.x;
    },

    get clientY() {
      return this.coords.client.y;
    },

    get pointerId() {
      return this.coords.pointerId;
    },

    get target() {
      return this.coords.target;
    },

    get type() {
      return this.coords.type;
    },

    get pointerType() {
      return this.coords.pointerType;
    },

    get buttons() {
      return this.coords.buttons;
    },

    preventDefault: function preventDefault() {}
  };
  return event;
}

var _$events_54 = {};
"use strict";

function ___typeof_54(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_54 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_54 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_54(obj); }

Object.defineProperty(_$events_54, "__esModule", {
  value: true
});
_$events_54["default"] = _$events_54.FakeEvent = void 0;

/* removed: var _$arr_49 = require("./arr"); */;

var __domUtils_54 = ___interopRequireWildcard_54(_$domUtils_53);

var __is_54 = ___interopRequireWildcard_54(_$is_59);

var ___pointerExtend_54 = ___interopRequireDefault_54(_$pointerExtend_62);

var pointerUtils = ___interopRequireWildcard_54(_$pointerUtils_63);

function ___interopRequireDefault_54(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___getRequireWildcardCache_54() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_54 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_54(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_54(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_54(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var elements = [];
var targets = [];
var delegatedEvents = {};
var documents = [];

function add(element, type, listener, optionalArg) {
  var options = getOptions(optionalArg);
  var elementIndex = elements.indexOf(element);
  var target = targets[elementIndex];

  if (!target) {
    target = {
      events: {},
      typeCount: 0
    };
    elementIndex = elements.push(element) - 1;
    targets.push(target);
  }

  if (!target.events[type]) {
    target.events[type] = [];
    target.typeCount++;
  }

  if (element.removeEventListener && !(0, _$arr_49.contains)(target.events[type], listener)) {
    element.addEventListener(type, listener, events.supportsOptions ? options : !!options.capture);
    target.events[type].push(listener);
  }
}

function __remove_54(element, type, listener, optionalArg) {
  var options = getOptions(optionalArg);
  var elementIndex = elements.indexOf(element);
  var target = targets[elementIndex];

  if (!target || !target.events) {
    return;
  }

  if (type === 'all') {
    for (type in target.events) {
      if (target.events.hasOwnProperty(type)) {
        __remove_54(element, type, 'all');
      }
    }

    return;
  }

  if (target.events[type]) {
    var len = target.events[type].length;

    if (listener === 'all') {
      for (var i = 0; i < len; i++) {
        __remove_54(element, type, target.events[type][i], options);
      }

      return;
    } else {
      for (var _i = 0; _i < len; _i++) {
        if (element.removeEventListener && target.events[type][_i] === listener) {
          element.removeEventListener(type, listener, events.supportsOptions ? options : !!options.capture);
          target.events[type].splice(_i, 1);
          break;
        }
      }
    }

    if (target.events[type] && target.events[type].length === 0) {
      target.events[type] = null;
      target.typeCount--;
    }
  }

  if (!target.typeCount) {
    targets.splice(elementIndex, 1);
    elements.splice(elementIndex, 1);
  }
}

function addDelegate(selector, context, type, listener, optionalArg) {
  var options = getOptions(optionalArg);

  if (!delegatedEvents[type]) {
    delegatedEvents[type] = {
      contexts: [],
      listeners: [],
      selectors: []
    }; // add delegate listener functions

    for (var _i2 = 0; _i2 < documents.length; _i2++) {
      var _ref;

      _ref = documents[_i2];
      var doc = _ref;
      add(doc, type, delegateListener);
      add(doc, type, delegateUseCapture, true);
    }
  }

  var delegated = delegatedEvents[type];
  var index;

  for (index = delegated.selectors.length - 1; index >= 0; index--) {
    if (delegated.selectors[index] === selector && delegated.contexts[index] === context) {
      break;
    }
  }

  if (index === -1) {
    index = delegated.selectors.length;
    delegated.selectors.push(selector);
    delegated.contexts.push(context);
    delegated.listeners.push([]);
  } // keep listener and capture and passive flags


  delegated.listeners[index].push([listener, !!options.capture, options.passive]);
}

function removeDelegate(selector, context, type, listener, optionalArg) {
  var options = getOptions(optionalArg);
  var delegated = delegatedEvents[type];
  var matchFound = false;
  var index;

  if (!delegated) {
    return;
  } // count from last index of delegated to 0


  for (index = delegated.selectors.length - 1; index >= 0; index--) {
    // look for matching selector and context Node
    if (delegated.selectors[index] === selector && delegated.contexts[index] === context) {
      var listeners = delegated.listeners[index]; // each item of the listeners array is an array: [function, capture, passive]

      for (var i = listeners.length - 1; i >= 0; i--) {
        var _listeners$i = _slicedToArray(listeners[i], 3),
            fn = _listeners$i[0],
            capture = _listeners$i[1],
            passive = _listeners$i[2]; // check if the listener functions and capture and passive flags match


        if (fn === listener && capture === !!options.capture && passive === options.passive) {
          // remove the listener from the array of listeners
          listeners.splice(i, 1); // if all listeners for this interactable have been removed
          // remove the interactable from the delegated arrays

          if (!listeners.length) {
            delegated.selectors.splice(index, 1);
            delegated.contexts.splice(index, 1);
            delegated.listeners.splice(index, 1); // remove delegate function from context

            __remove_54(context, type, delegateListener);
            __remove_54(context, type, delegateUseCapture, true); // remove the arrays if they are empty

            if (!delegated.selectors.length) {
              delegatedEvents[type] = null;
            }
          } // only remove one listener


          matchFound = true;
          break;
        }
      }

      if (matchFound) {
        break;
      }
    }
  }
} // bound to the interactable context when a DOM event
// listener is added to a selector interactable


function delegateListener(event, optionalArg) {
  var options = getOptions(optionalArg);
  var fakeEvent = new FakeEvent(event);
  var delegated = delegatedEvents[event.type];

  var _pointerUtils$getEven = pointerUtils.getEventTargets(event),
      _pointerUtils$getEven2 = _slicedToArray(_pointerUtils$getEven, 1),
      eventTarget = _pointerUtils$getEven2[0];

  var element = eventTarget; // climb up document tree looking for selector matches

  while (__is_54.element(element)) {
    for (var i = 0; i < delegated.selectors.length; i++) {
      var selector = delegated.selectors[i];
      var context = delegated.contexts[i];

      if (__domUtils_54.matchesSelector(element, selector) && __domUtils_54.nodeContains(context, eventTarget) && __domUtils_54.nodeContains(context, element)) {
        var listeners = delegated.listeners[i];
        fakeEvent.currentTarget = element;

        for (var _i3 = 0; _i3 < listeners.length; _i3++) {
          var _ref2;

          _ref2 = listeners[_i3];

          var _ref3 = _ref2,
              _ref4 = _slicedToArray(_ref3, 3),
              fn = _ref4[0],
              capture = _ref4[1],
              passive = _ref4[2];

          if (capture === !!options.capture && passive === options.passive) {
            fn(fakeEvent);
          }
        }
      }
    }

    element = __domUtils_54.parentNode(element);
  }
}

function delegateUseCapture(event) {
  return delegateListener.call(this, event, true);
}

function getOptions(param) {
  return __is_54.object(param) ? param : {
    capture: param
  };
}

var FakeEvent = /*#__PURE__*/function () {
  function FakeEvent(originalEvent) {
    _classCallCheck(this, FakeEvent);

    this.originalEvent = originalEvent;

    _defineProperty(this, "currentTarget", void 0);

    // duplicate the event so that currentTarget can be changed
    (0, ___pointerExtend_54["default"])(this, originalEvent);
  }

  _createClass(FakeEvent, [{
    key: "preventOriginalDefault",
    value: function preventOriginalDefault() {
      this.originalEvent.preventDefault();
    }
  }, {
    key: "stopPropagation",
    value: function stopPropagation() {
      this.originalEvent.stopPropagation();
    }
  }, {
    key: "stopImmediatePropagation",
    value: function stopImmediatePropagation() {
      this.originalEvent.stopImmediatePropagation();
    }
  }]);

  return FakeEvent;
}();

_$events_54.FakeEvent = FakeEvent;
var events = {
  add: add,
  remove: __remove_54,
  addDelegate: addDelegate,
  removeDelegate: removeDelegate,
  delegateListener: delegateListener,
  delegateUseCapture: delegateUseCapture,
  delegatedEvents: delegatedEvents,
  documents: documents,
  supportsOptions: false,
  supportsPassive: false,
  _elements: elements,
  _targets: targets,
  init: function init(window) {
    window.document.createElement('div').addEventListener('test', null, {
      get capture() {
        return events.supportsOptions = true;
      },

      get passive() {
        return events.supportsPassive = true;
      }

    });
  }
};
var ___default_54 = events;
_$events_54["default"] = ___default_54;

var _$extend_55 = {};
"use strict";

Object.defineProperty(_$extend_55, "__esModule", {
  value: true
});
_$extend_55["default"] = extend;

function extend(dest, source) {
  for (var prop in source) {
    dest[prop] = source[prop];
  }

  var ret = dest;
  return ret;
}

var _$normalizeListeners_61 = {};
"use strict";

function ___typeof_61(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_61 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_61 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_61(obj); }

Object.defineProperty(_$normalizeListeners_61, "__esModule", {
  value: true
});
_$normalizeListeners_61["default"] = normalize;

var _extend = ___interopRequireDefault_61(_$extend_55);

var __is_61 = ___interopRequireWildcard_61(_$is_59);

function ___getRequireWildcardCache_61() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_61 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_61(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_61(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_61(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_61(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function normalize(type, listeners, result) {
  result = result || {};

  if (__is_61.string(type) && type.search(' ') !== -1) {
    type = split(type);
  }

  if (__is_61.array(type)) {
    return type.reduce(function (acc, t) {
      return (0, _extend["default"])(acc, normalize(t, listeners, result));
    }, result);
  } // ({ type: fn }) -> ('', { type: fn })


  if (__is_61.object(type)) {
    listeners = type;
    type = '';
  }

  if (__is_61.func(listeners)) {
    result[type] = result[type] || [];
    result[type].push(listeners);
  } else if (__is_61.array(listeners)) {
    for (var _i = 0; _i < listeners.length; _i++) {
      var _ref;

      _ref = listeners[_i];
      var l = _ref;
      normalize(type, l, result);
    }
  } else if (__is_61.object(listeners)) {
    for (var prefix in listeners) {
      var combinedTypes = split(prefix).map(function (p) {
        return "".concat(type).concat(p);
      });
      normalize(combinedTypes, listeners[prefix], result);
    }
  }

  return result;
}

function split(type) {
  return type.trim().split(/ +/);
}

var _$Eventable_14 = {};
"use strict";

function ___typeof_14(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_14 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_14 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_14(obj); }

Object.defineProperty(_$Eventable_14, "__esModule", {
  value: true
});
_$Eventable_14["default"] = void 0;

var __arr_14 = ___interopRequireWildcard_14(_$arr_49);

var ___extend_14 = ___interopRequireDefault_14(_$extend_55);

var _normalizeListeners = ___interopRequireDefault_14(_$normalizeListeners_61);

function ___interopRequireDefault_14(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___getRequireWildcardCache_14() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_14 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_14(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_14(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_14(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___classCallCheck_14(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ___defineProperties_14(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ___createClass_14(Constructor, protoProps, staticProps) { if (protoProps) ___defineProperties_14(Constructor.prototype, protoProps); if (staticProps) ___defineProperties_14(Constructor, staticProps); return Constructor; }

function ___defineProperty_14(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function fireUntilImmediateStopped(event, listeners) {
  for (var _i = 0; _i < listeners.length; _i++) {
    var _ref;

    _ref = listeners[_i];
    var listener = _ref;

    if (event.immediatePropagationStopped) {
      break;
    }

    listener(event);
  }
}

var Eventable = /*#__PURE__*/function () {
  function Eventable(options) {
    ___classCallCheck_14(this, Eventable);

    ___defineProperty_14(this, "options", void 0);

    ___defineProperty_14(this, "types", {});

    ___defineProperty_14(this, "propagationStopped", false);

    ___defineProperty_14(this, "immediatePropagationStopped", false);

    ___defineProperty_14(this, "global", void 0);

    this.options = (0, ___extend_14["default"])({}, options || {});
  }

  ___createClass_14(Eventable, [{
    key: "fire",
    value: function fire(event) {
      var listeners;
      var global = this.global; // Interactable#on() listeners
      // tslint:disable no-conditional-assignment

      if (listeners = this.types[event.type]) {
        fireUntilImmediateStopped(event, listeners);
      } // interact.on() listeners


      if (!event.propagationStopped && global && (listeners = global[event.type])) {
        fireUntilImmediateStopped(event, listeners);
      }
    }
  }, {
    key: "on",
    value: function on(type, listener) {
      var listeners = (0, _normalizeListeners["default"])(type, listener);

      for (type in listeners) {
        this.types[type] = __arr_14.merge(this.types[type] || [], listeners[type]);
      }
    }
  }, {
    key: "off",
    value: function off(type, listener) {
      var listeners = (0, _normalizeListeners["default"])(type, listener);

      for (type in listeners) {
        var eventList = this.types[type];

        if (!eventList || !eventList.length) {
          continue;
        }

        for (var _i2 = 0; _i2 < listeners[type].length; _i2++) {
          var _ref2;

          _ref2 = listeners[type][_i2];
          var subListener = _ref2;

          var _index = eventList.indexOf(subListener);

          if (_index !== -1) {
            eventList.splice(_index, 1);
          }
        }
      }
    }
  }, {
    key: "getRect",
    value: function getRect(_element) {
      return null;
    }
  }]);

  return Eventable;
}();

var ___default_14 = Eventable;
_$Eventable_14["default"] = ___default_14;

var _$rect_65 = {};
"use strict";

function ___typeof_65(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_65 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_65 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_65(obj); }

Object.defineProperty(_$rect_65, "__esModule", {
  value: true
});
_$rect_65.getStringOptionResult = getStringOptionResult;
_$rect_65.resolveRectLike = resolveRectLike;
_$rect_65.rectToXY = rectToXY;
_$rect_65.xywhToTlbr = xywhToTlbr;
_$rect_65.tlbrToXywh = tlbrToXywh;
_$rect_65.addEdges = addEdges;

/* removed: var _$domUtils_53 = require("./domUtils"); */;

var ___extend_65 = ___interopRequireDefault_65(_$extend_55);

var __is_65 = ___interopRequireWildcard_65(_$is_59);

function ___getRequireWildcardCache_65() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_65 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_65(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_65(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_65(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_65(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function getStringOptionResult(value, target, element) {
  if (value === 'parent') {
    return (0, _$domUtils_53.parentNode)(element);
  }

  if (value === 'self') {
    return target.getRect(element);
  }

  return (0, _$domUtils_53.closest)(element, value);
}

function resolveRectLike(value, target, element, functionArgs) {
  var returnValue = value;

  if (__is_65.string(returnValue)) {
    returnValue = getStringOptionResult(returnValue, target, element);
  } else if (__is_65.func(returnValue)) {
    returnValue = returnValue.apply(void 0, _toConsumableArray(functionArgs));
  }

  if (__is_65.element(returnValue)) {
    returnValue = (0, _$domUtils_53.getElementRect)(returnValue);
  }

  return returnValue;
}

function rectToXY(rect) {
  return rect && {
    x: 'x' in rect ? rect.x : rect.left,
    y: 'y' in rect ? rect.y : rect.top
  };
}

function xywhToTlbr(rect) {
  if (rect && !('left' in rect && 'top' in rect)) {
    rect = (0, ___extend_65["default"])({}, rect);
    rect.left = rect.x || 0;
    rect.top = rect.y || 0;
    rect.right = rect.right || rect.left + rect.width;
    rect.bottom = rect.bottom || rect.top + rect.height;
  }

  return rect;
}

function tlbrToXywh(rect) {
  if (rect && !('x' in rect && 'y' in rect)) {
    rect = (0, ___extend_65["default"])({}, rect);
    rect.x = rect.left || 0;
    rect.y = rect.top || 0;
    rect.width = rect.width || rect.right || 0 - rect.x;
    rect.height = rect.height || rect.bottom || 0 - rect.y;
  }

  return rect;
}

function addEdges(edges, rect, delta) {
  if (edges.left) {
    rect.left += delta.x;
  }

  if (edges.right) {
    rect.right += delta.x;
  }

  if (edges.top) {
    rect.top += delta.y;
  }

  if (edges.bottom) {
    rect.bottom += delta.y;
  }

  rect.width = rect.right - rect.left;
  rect.height = rect.bottom - rect.top;
}

var _$getOriginXY_56 = {};
"use strict";

Object.defineProperty(_$getOriginXY_56, "__esModule", {
  value: true
});
_$getOriginXY_56["default"] = ___default_56;

/* removed: var _$rect_65 = require("./rect"); */;

function ___default_56(target, element, actionName) {
  var actionOptions = target.options[actionName];
  var actionOrigin = actionOptions && actionOptions.origin;
  var origin = actionOrigin || target.options.origin;
  var originRect = (0, _$rect_65.resolveRectLike)(origin, target, element, [target && element]);
  return (0, _$rect_65.rectToXY)(originRect) || {
    x: 0,
    y: 0
  };
}

var _$raf_64 = {};
"use strict";

Object.defineProperty(_$raf_64, "__esModule", {
  value: true
});
_$raf_64["default"] = void 0;
var lastTime = 0;

var _request;

var _cancel;

function __init_64(window) {
  _request = window.requestAnimationFrame;
  _cancel = window.cancelAnimationFrame;

  if (!_request) {
    var vendors = ['ms', 'moz', 'webkit', 'o'];

    for (var _i = 0; _i < vendors.length; _i++) {
      var vendor = vendors[_i];
      _request = window["".concat(vendor, "RequestAnimationFrame")];
      _cancel = window["".concat(vendor, "CancelAnimationFrame")] || window["".concat(vendor, "CancelRequestAnimationFrame")];
    }
  }

  if (!_request) {
    _request = function request(callback) {
      var currTime = Date.now();
      var timeToCall = Math.max(0, 16 - (currTime - lastTime)); // eslint-disable-next-line standard/no-callback-literal

      var token = setTimeout(function () {
        callback(currTime + timeToCall);
      }, timeToCall);
      lastTime = currTime + timeToCall;
      return token;
    };

    _cancel = function cancel(token) {
      return clearTimeout(token);
    };
  }
}

var ___default_64 = {
  request: function request(callback) {
    return _request(callback);
  },
  cancel: function cancel(token) {
    return _cancel(token);
  },
  init: __init_64
};
_$raf_64["default"] = ___default_64;

var _$index_58 = {};
"use strict";

function ___typeof_58(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_58 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_58 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_58(obj); }

Object.defineProperty(_$index_58, "__esModule", {
  value: true
});
_$index_58.warnOnce = warnOnce;
_$index_58.copyAction = copyAction;
Object.defineProperty(_$index_58, "win", {
  enumerable: true,
  get: function get() {
    return ___window_58["default"];
  }
});
Object.defineProperty(_$index_58, "browser", {
  enumerable: true,
  get: function get() {
    return ___browser_58["default"];
  }
});
Object.defineProperty(_$index_58, "clone", {
  enumerable: true,
  get: function get() {
    return _clone["default"];
  }
});
Object.defineProperty(_$index_58, "events", {
  enumerable: true,
  get: function get() {
    return _events["default"];
  }
});
Object.defineProperty(_$index_58, "extend", {
  enumerable: true,
  get: function get() {
    return ___extend_58["default"];
  }
});
Object.defineProperty(_$index_58, "getOriginXY", {
  enumerable: true,
  get: function get() {
    return _getOriginXY["default"];
  }
});
Object.defineProperty(_$index_58, "hypot", {
  enumerable: true,
  get: function get() {
    return ___hypot_58["default"];
  }
});
Object.defineProperty(_$index_58, "normalizeListeners", {
  enumerable: true,
  get: function get() {
    return ___normalizeListeners_58["default"];
  }
});
Object.defineProperty(_$index_58, "raf", {
  enumerable: true,
  get: function get() {
    return _raf["default"];
  }
});
_$index_58.rect = _$index_58.pointer = _$index_58.is = _$index_58.dom = _$index_58.arr = void 0;

var __arr_58 = ___interopRequireWildcard_58(_$arr_49);

_$index_58.arr = __arr_58;

var dom = ___interopRequireWildcard_58(_$domUtils_53);

_$index_58.dom = dom;

var __is_58 = ___interopRequireWildcard_58(_$is_59);

_$index_58.is = __is_58;

var pointer = ___interopRequireWildcard_58(_$pointerUtils_63);

_$index_58.pointer = pointer;

var rect = ___interopRequireWildcard_58(_$rect_65);

_$index_58.rect = rect;

var ___window_58 = ___interopRequireDefault_58(_$window_68);

var ___browser_58 = ___interopRequireDefault_58(_$browser_50);

var _clone = ___interopRequireDefault_58(_$clone_51);

var _events = ___interopRequireDefault_58(_$events_54);

var ___extend_58 = ___interopRequireDefault_58(_$extend_55);

var _getOriginXY = ___interopRequireDefault_58(_$getOriginXY_56);

var ___hypot_58 = ___interopRequireDefault_58(_$hypot_57);

var ___normalizeListeners_58 = ___interopRequireDefault_58(_$normalizeListeners_61);

var _raf = ___interopRequireDefault_58(_$raf_64);

function ___interopRequireDefault_58(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___getRequireWildcardCache_58() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_58 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_58(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_58(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_58(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function warnOnce(method, message) {
  var warned = false; // eslint-disable-next-line no-shadow

  return function () {
    if (!warned) {
      ___window_58["default"].window.console.warn(message);

      warned = true;
    }

    return method.apply(this, arguments);
  };
}

function copyAction(dest, src) {
  dest.name = src.name;
  dest.axis = src.axis;
  dest.edges = src.edges;
  return dest;
}

var _$defaultOptions_20 = {};
"use strict";

Object.defineProperty(_$defaultOptions_20, "__esModule", {
  value: true
});
_$defaultOptions_20["default"] = _$defaultOptions_20.defaults = void 0;
// tslint:disable no-empty-interface
// eslint-disable-next-line @typescript-eslint/no-empty-interface
// export interface Options extends BaseDefaults, PerActionDefaults {}
var defaults = {
  base: {
    preventDefault: 'auto',
    deltaSource: 'page'
  },
  perAction: {
    enabled: false,
    origin: {
      x: 0,
      y: 0
    }
  },
  actions: {}
};
_$defaultOptions_20.defaults = defaults;
var ___default_20 = defaults;
_$defaultOptions_20["default"] = ___default_20;

var _$InteractableSet_17 = {};
"use strict";

function ___typeof_17(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_17 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_17 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_17(obj); }

Object.defineProperty(_$InteractableSet_17, "__esModule", {
  value: true
});
_$InteractableSet_17["default"] = void 0;

var __arr_17 = ___interopRequireWildcard_17(_$arr_49);

var __domUtils_17 = ___interopRequireWildcard_17(_$domUtils_53);

var ___extend_17 = ___interopRequireDefault_17(_$extend_55);

var __is_17 = ___interopRequireWildcard_17(_$is_59);

function ___interopRequireDefault_17(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___getRequireWildcardCache_17() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_17 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_17(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_17(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_17(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___classCallCheck_17(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ___defineProperties_17(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ___createClass_17(Constructor, protoProps, staticProps) { if (protoProps) ___defineProperties_17(Constructor.prototype, protoProps); if (staticProps) ___defineProperties_17(Constructor, staticProps); return Constructor; }

function ___defineProperty_17(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var InteractableSet = /*#__PURE__*/function () {
  // all set interactables
  function InteractableSet(scope) {
    var _this = this;

    ___classCallCheck_17(this, InteractableSet);

    this.scope = scope;

    ___defineProperty_17(this, "list", []);

    ___defineProperty_17(this, "selectorMap", {});

    scope.addListeners({
      'interactable:unset': function interactableUnset(_ref) {
        var interactable = _ref.interactable;
        var target = interactable.target,
            context = interactable._context;
        var targetMappings = __is_17.string(target) ? _this.selectorMap[target] : target[_this.scope.id];
        var targetIndex = targetMappings.findIndex(function (m) {
          return m.context === context;
        });

        if (targetMappings[targetIndex]) {
          // Destroying mappingInfo's context and interactable
          targetMappings[targetIndex].context = null;
          targetMappings[targetIndex].interactable = null;
        }

        targetMappings.splice(targetIndex, 1);
      }
    });
  }

  ___createClass_17(InteractableSet, [{
    key: "new",
    value: function _new(target, options) {
      options = (0, ___extend_17["default"])(options || {}, {
        actions: this.scope.actions
      });
      var interactable = new this.scope.Interactable(target, options, this.scope.document);
      var mappingInfo = {
        context: interactable._context,
        interactable: interactable
      };
      this.scope.addDocument(interactable._doc);
      this.list.push(interactable);

      if (__is_17.string(target)) {
        if (!this.selectorMap[target]) {
          this.selectorMap[target] = [];
        }

        this.selectorMap[target].push(mappingInfo);
      } else {
        if (!interactable.target[this.scope.id]) {
          Object.defineProperty(target, this.scope.id, {
            value: [],
            configurable: true
          });
        }

        target[this.scope.id].push(mappingInfo);
      }

      this.scope.fire('interactable:new', {
        target: target,
        options: options,
        interactable: interactable,
        win: this.scope._win
      });
      return interactable;
    }
  }, {
    key: "get",
    value: function get(target, options) {
      var context = options && options.context || this.scope.document;
      var isSelector = __is_17.string(target);
      var targetMappings = isSelector ? this.selectorMap[target] : target[this.scope.id];

      if (!targetMappings) {
        return null;
      }

      var found = __arr_17.find(targetMappings, function (m) {
        return m.context === context && (isSelector || m.interactable.inContext(target));
      });
      return found && found.interactable;
    }
  }, {
    key: "forEachMatch",
    value: function forEachMatch(node, callback) {
      for (var _i = 0; _i < this.list.length; _i++) {
        var _ref2;

        _ref2 = this.list[_i];
        var _interactable = _ref2;
        var ret = void 0;

        if ((__is_17.string(_interactable.target) // target is a selector and the element matches
        ? __is_17.element(node) && __domUtils_17.matchesSelector(node, _interactable.target) : // target is the element
        node === _interactable.target) && // the element is in context
        _interactable.inContext(node)) {
          ret = callback(_interactable);
        }

        if (ret !== undefined) {
          return ret;
        }
      }
    }
  }]);

  return InteractableSet;
}();

_$InteractableSet_17["default"] = InteractableSet;

var _$BaseEvent_13 = {};
"use strict";

Object.defineProperty(_$BaseEvent_13, "__esModule", {
  value: true
});
_$BaseEvent_13["default"] = _$BaseEvent_13.BaseEvent = void 0;

function ___classCallCheck_13(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ___defineProperties_13(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ___createClass_13(Constructor, protoProps, staticProps) { if (protoProps) ___defineProperties_13(Constructor.prototype, protoProps); if (staticProps) ___defineProperties_13(Constructor, staticProps); return Constructor; }

function ___defineProperty_13(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var BaseEvent = /*#__PURE__*/function () {
  ___createClass_13(BaseEvent, [{
    key: "interaction",
    get: function get() {
      return this._interaction._proxy;
    }
  }]);

  function BaseEvent(interaction) {
    ___classCallCheck_13(this, BaseEvent);

    ___defineProperty_13(this, "type", void 0);

    ___defineProperty_13(this, "target", void 0);

    ___defineProperty_13(this, "currentTarget", void 0);

    ___defineProperty_13(this, "interactable", void 0);

    ___defineProperty_13(this, "_interaction", void 0);

    ___defineProperty_13(this, "timeStamp", void 0);

    ___defineProperty_13(this, "immediatePropagationStopped", false);

    ___defineProperty_13(this, "propagationStopped", false);

    this._interaction = interaction;
  }

  ___createClass_13(BaseEvent, [{
    key: "preventDefault",
    value: function preventDefault() {}
    /**
     * Don't call any other listeners (even on the current target)
     */

  }, {
    key: "stopPropagation",
    value: function stopPropagation() {
      this.propagationStopped = true;
    }
    /**
     * Don't call listeners on the remaining targets
     */

  }, {
    key: "stopImmediatePropagation",
    value: function stopImmediatePropagation() {
      this.immediatePropagationStopped = this.propagationStopped = true;
    }
  }]);

  return BaseEvent;
}();

_$BaseEvent_13.BaseEvent = BaseEvent;
var ___default_13 = BaseEvent;
_$BaseEvent_13["default"] = ___default_13;

var _$InteractEvent_15 = {};
"use strict";

Object.defineProperty(_$InteractEvent_15, "__esModule", {
  value: true
});
_$InteractEvent_15["default"] = _$InteractEvent_15.InteractEvent = void 0;

var ___extend_15 = ___interopRequireDefault_15(_$extend_55);

var ___getOriginXY_15 = ___interopRequireDefault_15(_$getOriginXY_56);

var ___hypot_15 = ___interopRequireDefault_15(_$hypot_57);

var _BaseEvent2 = ___interopRequireDefault_15(_$BaseEvent_13);

var _defaultOptions = ___interopRequireDefault_15(_$defaultOptions_20);

function ___interopRequireDefault_15(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___typeof_15(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_15 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_15 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_15(obj); }

function ___classCallCheck_15(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ___defineProperties_15(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ___createClass_15(Constructor, protoProps, staticProps) { if (protoProps) ___defineProperties_15(Constructor.prototype, protoProps); if (staticProps) ___defineProperties_15(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (___typeof_15(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function ___defineProperty_15(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var InteractEvent = /*#__PURE__*/function (_BaseEvent) {
  _inherits(InteractEvent, _BaseEvent);

  // drag
  // resize

  /** */
  function InteractEvent(interaction, event, actionName, phase, element, preEnd, type) {
    var _this;

    ___classCallCheck_15(this, InteractEvent);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(InteractEvent).call(this, interaction));

    ___defineProperty_15(_assertThisInitialized(_this), "target", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "currentTarget", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "relatedTarget", null);

    ___defineProperty_15(_assertThisInitialized(_this), "screenX", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "screenY", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "button", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "buttons", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "ctrlKey", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "shiftKey", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "altKey", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "metaKey", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "page", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "client", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "delta", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "rect", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "x0", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "y0", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "t0", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "dt", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "duration", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "clientX0", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "clientY0", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "velocity", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "speed", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "swipe", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "timeStamp", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "dragEnter", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "dragLeave", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "axes", void 0);

    ___defineProperty_15(_assertThisInitialized(_this), "preEnd", void 0);

    element = element || interaction.element;
    var target = interaction.interactable;
    var deltaSource = (target && target.options || _defaultOptions["default"]).deltaSource;
    var origin = (0, ___getOriginXY_15["default"])(target, element, actionName);
    var starting = phase === 'start';
    var ending = phase === 'end';
    var prevEvent = starting ? _assertThisInitialized(_this) : interaction.prevEvent;
    var coords = starting ? interaction.coords.start : ending ? {
      page: prevEvent.page,
      client: prevEvent.client,
      timeStamp: interaction.coords.cur.timeStamp
    } : interaction.coords.cur;
    _this.page = (0, ___extend_15["default"])({}, coords.page);
    _this.client = (0, ___extend_15["default"])({}, coords.client);
    _this.rect = (0, ___extend_15["default"])({}, interaction.rect);
    _this.timeStamp = coords.timeStamp;

    if (!ending) {
      _this.page.x -= origin.x;
      _this.page.y -= origin.y;
      _this.client.x -= origin.x;
      _this.client.y -= origin.y;
    }

    _this.ctrlKey = event.ctrlKey;
    _this.altKey = event.altKey;
    _this.shiftKey = event.shiftKey;
    _this.metaKey = event.metaKey;
    _this.button = event.button;
    _this.buttons = event.buttons;
    _this.target = element;
    _this.currentTarget = element;
    _this.preEnd = preEnd;
    _this.type = type || actionName + (phase || '');
    _this.interactable = target;
    _this.t0 = starting ? interaction.pointers[interaction.pointers.length - 1].downTime : prevEvent.t0;
    _this.x0 = interaction.coords.start.page.x - origin.x;
    _this.y0 = interaction.coords.start.page.y - origin.y;
    _this.clientX0 = interaction.coords.start.client.x - origin.x;
    _this.clientY0 = interaction.coords.start.client.y - origin.y;

    if (starting || ending) {
      _this.delta = {
        x: 0,
        y: 0
      };
    } else {
      _this.delta = {
        x: _this[deltaSource].x - prevEvent[deltaSource].x,
        y: _this[deltaSource].y - prevEvent[deltaSource].y
      };
    }

    _this.dt = interaction.coords.delta.timeStamp;
    _this.duration = _this.timeStamp - _this.t0; // velocity and speed in pixels per second

    _this.velocity = (0, ___extend_15["default"])({}, interaction.coords.velocity[deltaSource]);
    _this.speed = (0, ___hypot_15["default"])(_this.velocity.x, _this.velocity.y);
    _this.swipe = ending || phase === 'inertiastart' ? _this.getSwipe() : null;
    return _this;
  }

  ___createClass_15(InteractEvent, [{
    key: "getSwipe",
    value: function getSwipe() {
      var interaction = this._interaction;

      if (interaction.prevEvent.speed < 600 || this.timeStamp - interaction.prevEvent.timeStamp > 150) {
        return null;
      }

      var angle = 180 * Math.atan2(interaction.prevEvent.velocityY, interaction.prevEvent.velocityX) / Math.PI;
      var overlap = 22.5;

      if (angle < 0) {
        angle += 360;
      }

      var left = 135 - overlap <= angle && angle < 225 + overlap;
      var up = 225 - overlap <= angle && angle < 315 + overlap;
      var right = !left && (315 - overlap <= angle || angle < 45 + overlap);
      var down = !up && 45 - overlap <= angle && angle < 135 + overlap;
      return {
        up: up,
        down: down,
        left: left,
        right: right,
        angle: angle,
        speed: interaction.prevEvent.speed,
        velocity: {
          x: interaction.prevEvent.velocityX,
          y: interaction.prevEvent.velocityY
        }
      };
    }
  }, {
    key: "preventDefault",
    value: function preventDefault() {}
    /**
     * Don't call listeners on the remaining targets
     */

  }, {
    key: "stopImmediatePropagation",
    value: function stopImmediatePropagation() {
      this.immediatePropagationStopped = this.propagationStopped = true;
    }
    /**
     * Don't call any other listeners (even on the current target)
     */

  }, {
    key: "stopPropagation",
    value: function stopPropagation() {
      this.propagationStopped = true;
    }
  }, {
    key: "pageX",
    get: function get() {
      return this.page.x;
    },
    set: function set(value) {
      this.page.x = value;
    }
  }, {
    key: "pageY",
    get: function get() {
      return this.page.y;
    },
    set: function set(value) {
      this.page.y = value;
    }
  }, {
    key: "clientX",
    get: function get() {
      return this.client.x;
    },
    set: function set(value) {
      this.client.x = value;
    }
  }, {
    key: "clientY",
    get: function get() {
      return this.client.y;
    },
    set: function set(value) {
      this.client.y = value;
    }
  }, {
    key: "dx",
    get: function get() {
      return this.delta.x;
    },
    set: function set(value) {
      this.delta.x = value;
    }
  }, {
    key: "dy",
    get: function get() {
      return this.delta.y;
    },
    set: function set(value) {
      this.delta.y = value;
    }
  }, {
    key: "velocityX",
    get: function get() {
      return this.velocity.x;
    },
    set: function set(value) {
      this.velocity.x = value;
    }
  }, {
    key: "velocityY",
    get: function get() {
      return this.velocity.y;
    },
    set: function set(value) {
      this.velocity.y = value;
    }
  }]);

  return InteractEvent;
}(_BaseEvent2["default"]);

_$InteractEvent_15.InteractEvent = InteractEvent;
var ___default_15 = InteractEvent;
_$InteractEvent_15["default"] = ___default_15;

var _$PointerInfo_19 = {};
"use strict";

Object.defineProperty(_$PointerInfo_19, "__esModule", {
  value: true
});
_$PointerInfo_19["default"] = _$PointerInfo_19.PointerInfo = void 0;

function ___classCallCheck_19(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/* eslint-disable @typescript-eslint/no-parameter-properties */
var PointerInfo = function PointerInfo(id, pointer, event, downTime, downTarget) {
  ___classCallCheck_19(this, PointerInfo);

  this.id = id;
  this.pointer = pointer;
  this.event = event;
  this.downTime = downTime;
  this.downTarget = downTarget;
};

_$PointerInfo_19.PointerInfo = PointerInfo;
var ___default_19 = PointerInfo;
_$PointerInfo_19["default"] = ___default_19;

var _$Interaction_18 = {};
"use strict";

function ___typeof_18(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_18 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_18 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_18(obj); }

Object.defineProperty(_$Interaction_18, "__esModule", {
  value: true
});
Object.defineProperty(_$Interaction_18, "PointerInfo", {
  enumerable: true,
  get: function get() {
    return _PointerInfo["default"];
  }
});
_$Interaction_18["default"] = _$Interaction_18.Interaction = _$Interaction_18._ProxyMethods = _$Interaction_18._ProxyValues = void 0;

var utils = ___interopRequireWildcard_18(_$index_58);

var _InteractEvent = ___interopRequireDefault_18(_$InteractEvent_15);

var _PointerInfo = ___interopRequireDefault_18(_$PointerInfo_19);

function ___interopRequireDefault_18(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___getRequireWildcardCache_18() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_18 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_18(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_18(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_18(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___classCallCheck_18(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ___defineProperties_18(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ___createClass_18(Constructor, protoProps, staticProps) { if (protoProps) ___defineProperties_18(Constructor.prototype, protoProps); if (staticProps) ___defineProperties_18(Constructor, staticProps); return Constructor; }

function ___defineProperty_18(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var _ProxyValues;

_$Interaction_18._ProxyValues = _ProxyValues;

(function (_ProxyValues) {
  _ProxyValues["interactable"] = "";
  _ProxyValues["element"] = "";
  _ProxyValues["prepared"] = "";
  _ProxyValues["pointerIsDown"] = "";
  _ProxyValues["pointerWasMoved"] = "";
  _ProxyValues["_proxy"] = "";
})(_ProxyValues || (_$Interaction_18._ProxyValues = _ProxyValues = {}));

var _ProxyMethods;

_$Interaction_18._ProxyMethods = _ProxyMethods;

(function (_ProxyMethods) {
  _ProxyMethods["start"] = "";
  _ProxyMethods["move"] = "";
  _ProxyMethods["end"] = "";
  _ProxyMethods["stop"] = "";
  _ProxyMethods["interacting"] = "";
})(_ProxyMethods || (_$Interaction_18._ProxyMethods = _ProxyMethods = {}));

var idCounter = 0;

var Interaction = /*#__PURE__*/function () {
  ___createClass_18(Interaction, [{
    key: "pointerMoveTolerance",
    // current interactable being interacted with
    // the target element of the interactable
    // action that's ready to be fired on next move event
    // keep track of added pointers
    // pointerdown/mousedown/touchstart event
    // previous action event
    get: function get() {
      return 1;
    }
    /**
     * @alias Interaction.prototype.move
     */

  }]);

  /** */
  function Interaction(_ref) {
    var _this = this;

    var pointerType = _ref.pointerType,
        scopeFire = _ref.scopeFire;

    ___classCallCheck_18(this, Interaction);

    ___defineProperty_18(this, "interactable", null);

    ___defineProperty_18(this, "element", null);

    ___defineProperty_18(this, "rect", void 0);

    ___defineProperty_18(this, "_rects", void 0);

    ___defineProperty_18(this, "edges", void 0);

    ___defineProperty_18(this, "_scopeFire", void 0);

    ___defineProperty_18(this, "prepared", {
      name: null,
      axis: null,
      edges: null
    });

    ___defineProperty_18(this, "pointerType", void 0);

    ___defineProperty_18(this, "pointers", []);

    ___defineProperty_18(this, "downEvent", null);

    ___defineProperty_18(this, "downPointer", {});

    ___defineProperty_18(this, "_latestPointer", {
      pointer: null,
      event: null,
      eventTarget: null
    });

    ___defineProperty_18(this, "prevEvent", null);

    ___defineProperty_18(this, "pointerIsDown", false);

    ___defineProperty_18(this, "pointerWasMoved", false);

    ___defineProperty_18(this, "_interacting", false);

    ___defineProperty_18(this, "_ending", false);

    ___defineProperty_18(this, "_stopped", true);

    ___defineProperty_18(this, "_proxy", null);

    ___defineProperty_18(this, "simulation", null);

    ___defineProperty_18(this, "doMove", utils.warnOnce(function (signalArg) {
      this.move(signalArg);
    }, 'The interaction.doMove() method has been renamed to interaction.move()'));

    ___defineProperty_18(this, "coords", {
      // Starting InteractEvent pointer coordinates
      start: utils.pointer.newCoords(),
      // Previous native pointer move event coordinates
      prev: utils.pointer.newCoords(),
      // current native pointer move event coordinates
      cur: utils.pointer.newCoords(),
      // Change in coordinates and time of the pointer
      delta: utils.pointer.newCoords(),
      // pointer velocity
      velocity: utils.pointer.newCoords()
    });

    ___defineProperty_18(this, "_id", idCounter++);

    this._scopeFire = scopeFire;
    this.pointerType = pointerType;
    var that = this;
    this._proxy = {};

    var _loop = function _loop(key) {
      Object.defineProperty(_this._proxy, key, {
        get: function get() {
          return that[key];
        }
      });
    };

    for (var key in _ProxyValues) {
      _loop(key);
    }

    var _loop2 = function _loop2(_key) {
      Object.defineProperty(_this._proxy, _key, {
        value: function value() {
          return that[_key].apply(that, arguments);
        }
      });
    };

    for (var _key in _ProxyMethods) {
      _loop2(_key);
    }

    this._scopeFire('interactions:new', {
      interaction: this
    });
  }

  ___createClass_18(Interaction, [{
    key: "pointerDown",
    value: function pointerDown(pointer, event, eventTarget) {
      var pointerIndex = this.updatePointer(pointer, event, eventTarget, true);
      var pointerInfo = this.pointers[pointerIndex];

      this._scopeFire('interactions:down', {
        pointer: pointer,
        event: event,
        eventTarget: eventTarget,
        pointerIndex: pointerIndex,
        pointerInfo: pointerInfo,
        type: 'down',
        interaction: this
      });
    }
    /**
     * ```js
     * interact(target)
     *   .draggable({
     *     // disable the default drag start by down->move
     *     manualStart: true
     *   })
     *   // start dragging after the user holds the pointer down
     *   .on('hold', function (event) {
     *     var interaction = event.interaction
     *
     *     if (!interaction.interacting()) {
     *       interaction.start({ name: 'drag' },
     *                         event.interactable,
     *                         event.currentTarget)
     *     }
     * })
     * ```
     *
     * Start an action with the given Interactable and Element as tartgets. The
     * action must be enabled for the target Interactable and an appropriate
     * number of pointers must be held down - 1 for drag/resize, 2 for gesture.
     *
     * Use it with `interactable.<action>able({ manualStart: false })` to always
     * [start actions manually](https://github.com/taye/interact.js/issues/114)
     *
     * @param {object} action   The action to be performed - drag, resize, etc.
     * @param {Interactable} target  The Interactable to target
     * @param {Element} element The DOM Element to target
     * @return {object} interact
     */

  }, {
    key: "start",
    value: function start(action, interactable, element) {
      if (this.interacting() || !this.pointerIsDown || this.pointers.length < (action.name === 'gesture' ? 2 : 1) || !interactable.options[action.name].enabled) {
        return false;
      }

      utils.copyAction(this.prepared, action);
      this.interactable = interactable;
      this.element = element;
      this.rect = interactable.getRect(element);
      this.edges = this.prepared.edges ? utils.extend({}, this.prepared.edges) : {
        left: true,
        right: true,
        top: true,
        bottom: true
      };
      this._stopped = false;
      this._interacting = this._doPhase({
        interaction: this,
        event: this.downEvent,
        phase: 'start'
      }) && !this._stopped;
      return this._interacting;
    }
  }, {
    key: "pointerMove",
    value: function pointerMove(pointer, event, eventTarget) {
      if (!this.simulation && !(this.modification && this.modification.endResult)) {
        this.updatePointer(pointer, event, eventTarget, false);
      }

      var duplicateMove = this.coords.cur.page.x === this.coords.prev.page.x && this.coords.cur.page.y === this.coords.prev.page.y && this.coords.cur.client.x === this.coords.prev.client.x && this.coords.cur.client.y === this.coords.prev.client.y;
      var dx;
      var dy; // register movement greater than pointerMoveTolerance

      if (this.pointerIsDown && !this.pointerWasMoved) {
        dx = this.coords.cur.client.x - this.coords.start.client.x;
        dy = this.coords.cur.client.y - this.coords.start.client.y;
        this.pointerWasMoved = utils.hypot(dx, dy) > this.pointerMoveTolerance;
      }

      var pointerIndex = this.getPointerIndex(pointer);
      var signalArg = {
        pointer: pointer,
        pointerIndex: pointerIndex,
        pointerInfo: this.pointers[pointerIndex],
        event: event,
        type: 'move',
        eventTarget: eventTarget,
        dx: dx,
        dy: dy,
        duplicate: duplicateMove,
        interaction: this
      };

      if (!duplicateMove) {
        // set pointer coordinate, time changes and velocity
        utils.pointer.setCoordVelocity(this.coords.velocity, this.coords.delta);
      }

      this._scopeFire('interactions:move', signalArg);

      if (!duplicateMove && !this.simulation) {
        // if interacting, fire an 'action-move' signal etc
        if (this.interacting()) {
          signalArg.type = null;
          this.move(signalArg);
        }

        if (this.pointerWasMoved) {
          utils.pointer.copyCoords(this.coords.prev, this.coords.cur);
        }
      }
    }
    /**
     * ```js
     * interact(target)
     *   .draggable(true)
     *   .on('dragmove', function (event) {
     *     if (someCondition) {
     *       // change the snap settings
     *       event.interactable.draggable({ snap: { targets: [] }})
     *       // fire another move event with re-calculated snap
     *       event.interaction.move()
     *     }
     *   })
     * ```
     *
     * Force a move of the current action at the same coordinates. Useful if
     * snap/restrict has been changed and you want a movement with the new
     * settings.
     */

  }, {
    key: "move",
    value: function move(signalArg) {
      if (!signalArg || !signalArg.event) {
        utils.pointer.setZeroCoords(this.coords.delta);
      }

      signalArg = utils.extend({
        pointer: this._latestPointer.pointer,
        event: this._latestPointer.event,
        eventTarget: this._latestPointer.eventTarget,
        interaction: this
      }, signalArg || {});
      signalArg.phase = 'move';

      this._doPhase(signalArg);
    } // End interact move events and stop auto-scroll unless simulation is running

  }, {
    key: "pointerUp",
    value: function pointerUp(pointer, event, eventTarget, curEventTarget) {
      var pointerIndex = this.getPointerIndex(pointer);

      if (pointerIndex === -1) {
        pointerIndex = this.updatePointer(pointer, event, eventTarget, false);
      }

      var type = /cancel$/i.test(event.type) ? 'cancel' : 'up';

      this._scopeFire("interactions:".concat(type), {
        pointer: pointer,
        pointerIndex: pointerIndex,
        pointerInfo: this.pointers[pointerIndex],
        event: event,
        eventTarget: eventTarget,
        type: type,
        curEventTarget: curEventTarget,
        interaction: this
      });

      if (!this.simulation) {
        this.end(event);
      }

      this.pointerIsDown = false;
      this.removePointer(pointer, event);
    }
  }, {
    key: "documentBlur",
    value: function documentBlur(event) {
      this.end(event);

      this._scopeFire('interactions:blur', {
        event: event,
        type: 'blur',
        interaction: this
      });
    }
    /**
     * ```js
     * interact(target)
     *   .draggable(true)
     *   .on('move', function (event) {
     *     if (event.pageX > 1000) {
     *       // end the current action
     *       event.interaction.end()
     *       // stop all further listeners from being called
     *       event.stopImmediatePropagation()
     *     }
     *   })
     * ```
     *
     * @param {PointerEvent} [event]
     */

  }, {
    key: "end",
    value: function end(event) {
      this._ending = true;
      event = event || this._latestPointer.event;
      var endPhaseResult;

      if (this.interacting()) {
        endPhaseResult = this._doPhase({
          event: event,
          interaction: this,
          phase: 'end'
        });
      }

      this._ending = false;

      if (endPhaseResult === true) {
        this.stop();
      }
    }
  }, {
    key: "currentAction",
    value: function currentAction() {
      return this._interacting ? this.prepared.name : null;
    }
  }, {
    key: "interacting",
    value: function interacting() {
      return this._interacting;
    }
    /** */

  }, {
    key: "stop",
    value: function stop() {
      this._scopeFire('interactions:stop', {
        interaction: this
      });

      this.interactable = this.element = null;
      this._interacting = false;
      this._stopped = true;
      this.prepared.name = this.prevEvent = null;
    }
  }, {
    key: "getPointerIndex",
    value: function getPointerIndex(pointer) {
      var pointerId = utils.pointer.getPointerId(pointer); // mouse and pen interactions may have only one pointer

      return this.pointerType === 'mouse' || this.pointerType === 'pen' ? this.pointers.length - 1 : utils.arr.findIndex(this.pointers, function (curPointer) {
        return curPointer.id === pointerId;
      });
    }
  }, {
    key: "getPointerInfo",
    value: function getPointerInfo(pointer) {
      return this.pointers[this.getPointerIndex(pointer)];
    }
  }, {
    key: "updatePointer",
    value: function updatePointer(pointer, event, eventTarget, down) {
      var id = utils.pointer.getPointerId(pointer);
      var pointerIndex = this.getPointerIndex(pointer);
      var pointerInfo = this.pointers[pointerIndex];
      down = down === false ? false : down || /(down|start)$/i.test(event.type);

      if (!pointerInfo) {
        pointerInfo = new _PointerInfo["default"](id, pointer, event, null, null);
        pointerIndex = this.pointers.length;
        this.pointers.push(pointerInfo);
      } else {
        pointerInfo.pointer = pointer;
      }

      utils.pointer.setCoords(this.coords.cur, this.pointers.map(function (p) {
        return p.pointer;
      }), this._now());
      utils.pointer.setCoordDeltas(this.coords.delta, this.coords.prev, this.coords.cur);

      if (down) {
        this.pointerIsDown = true;
        pointerInfo.downTime = this.coords.cur.timeStamp;
        pointerInfo.downTarget = eventTarget;
        utils.pointer.pointerExtend(this.downPointer, pointer);

        if (!this.interacting()) {
          utils.pointer.copyCoords(this.coords.start, this.coords.cur);
          utils.pointer.copyCoords(this.coords.prev, this.coords.cur);
          this.downEvent = event;
          this.pointerWasMoved = false;
        }
      }

      this._updateLatestPointer(pointer, event, eventTarget);

      this._scopeFire('interactions:update-pointer', {
        pointer: pointer,
        event: event,
        eventTarget: eventTarget,
        down: down,
        pointerInfo: pointerInfo,
        pointerIndex: pointerIndex,
        interaction: this
      });

      return pointerIndex;
    }
  }, {
    key: "removePointer",
    value: function removePointer(pointer, event) {
      var pointerIndex = this.getPointerIndex(pointer);

      if (pointerIndex === -1) {
        return;
      }

      var pointerInfo = this.pointers[pointerIndex];

      this._scopeFire('interactions:remove-pointer', {
        pointer: pointer,
        event: event,
        eventTarget: null,
        pointerIndex: pointerIndex,
        pointerInfo: pointerInfo,
        interaction: this
      });

      this.pointers.splice(pointerIndex, 1);
    }
  }, {
    key: "_updateLatestPointer",
    value: function _updateLatestPointer(pointer, event, eventTarget) {
      this._latestPointer.pointer = pointer;
      this._latestPointer.event = event;
      this._latestPointer.eventTarget = eventTarget;
    }
  }, {
    key: "destroy",
    value: function destroy() {
      this._latestPointer.pointer = null;
      this._latestPointer.event = null;
      this._latestPointer.eventTarget = null;
    }
  }, {
    key: "_createPreparedEvent",
    value: function _createPreparedEvent(event, phase, preEnd, type) {
      return new _InteractEvent["default"](this, event, this.prepared.name, phase, this.element, preEnd, type);
    }
  }, {
    key: "_fireEvent",
    value: function _fireEvent(iEvent) {
      this.interactable.fire(iEvent);

      if (!this.prevEvent || iEvent.timeStamp >= this.prevEvent.timeStamp) {
        this.prevEvent = iEvent;
      }
    }
  }, {
    key: "_doPhase",
    value: function _doPhase(signalArg) {
      var event = signalArg.event,
          phase = signalArg.phase,
          preEnd = signalArg.preEnd,
          type = signalArg.type;
      var rect = this.rect;

      if (rect && phase === 'move') {
        // update the rect changes due to pointer move
        utils.rect.addEdges(this.edges, rect, this.coords.delta[this.interactable.options.deltaSource]);
        rect.width = rect.right - rect.left;
        rect.height = rect.bottom - rect.top;
      }

      var beforeResult = this._scopeFire("interactions:before-action-".concat(phase), signalArg);

      if (beforeResult === false) {
        return false;
      }

      var iEvent = signalArg.iEvent = this._createPreparedEvent(event, phase, preEnd, type);

      this._scopeFire("interactions:action-".concat(phase), signalArg);

      if (phase === 'start') {
        this.prevEvent = iEvent;
      }

      this._fireEvent(iEvent);

      this._scopeFire("interactions:after-action-".concat(phase), signalArg);

      return true;
    }
  }, {
    key: "_now",
    value: function _now() {
      return Date.now();
    }
  }]);

  return Interaction;
}();

_$Interaction_18.Interaction = Interaction;
var ___default_18 = Interaction;
_$Interaction_18["default"] = ___default_18;

var _$interactionFinder_22 = {};
"use strict";

function ___typeof_22(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_22 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_22 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_22(obj); }

Object.defineProperty(_$interactionFinder_22, "__esModule", {
  value: true
});
_$interactionFinder_22["default"] = void 0;

var __dom_22 = ___interopRequireWildcard_22(_$domUtils_53);

function ___getRequireWildcardCache_22() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_22 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_22(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_22(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_22(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var finder = {
  methodOrder: ['simulationResume', 'mouseOrPen', 'hasPointer', 'idle'],
  search: function search(details) {
    for (var _i = 0; _i < finder.methodOrder.length; _i++) {
      var _ref;

      _ref = finder.methodOrder[_i];
      var method = _ref;
      var interaction = finder[method](details);

      if (interaction) {
        return interaction;
      }
    }

    return null;
  },
  // try to resume simulation with a new pointer
  simulationResume: function simulationResume(_ref2) {
    var pointerType = _ref2.pointerType,
        eventType = _ref2.eventType,
        eventTarget = _ref2.eventTarget,
        scope = _ref2.scope;

    if (!/down|start/i.test(eventType)) {
      return null;
    }

    for (var _i2 = 0; _i2 < scope.interactions.list.length; _i2++) {
      var _ref3;

      _ref3 = scope.interactions.list[_i2];
      var interaction = _ref3;
      var element = eventTarget;

      if (interaction.simulation && interaction.simulation.allowResume && interaction.pointerType === pointerType) {
        while (element) {
          // if the element is the interaction element
          if (element === interaction.element) {
            return interaction;
          }

          element = __dom_22.parentNode(element);
        }
      }
    }

    return null;
  },
  // if it's a mouse or pen interaction
  mouseOrPen: function mouseOrPen(_ref4) {
    var pointerId = _ref4.pointerId,
        pointerType = _ref4.pointerType,
        eventType = _ref4.eventType,
        scope = _ref4.scope;

    if (pointerType !== 'mouse' && pointerType !== 'pen') {
      return null;
    }

    var firstNonActive;

    for (var _i3 = 0; _i3 < scope.interactions.list.length; _i3++) {
      var _ref5;

      _ref5 = scope.interactions.list[_i3];
      var interaction = _ref5;

      if (interaction.pointerType === pointerType) {
        // if it's a down event, skip interactions with running simulations
        if (interaction.simulation && !hasPointerId(interaction, pointerId)) {
          continue;
        } // if the interaction is active, return it immediately


        if (interaction.interacting()) {
          return interaction;
        } // otherwise save it and look for another active interaction
        else if (!firstNonActive) {
            firstNonActive = interaction;
          }
      }
    } // if no active mouse interaction was found use the first inactive mouse
    // interaction


    if (firstNonActive) {
      return firstNonActive;
    } // find any mouse or pen interaction.
    // ignore the interaction if the eventType is a *down, and a simulation
    // is active


    for (var _i4 = 0; _i4 < scope.interactions.list.length; _i4++) {
      var _ref6;

      _ref6 = scope.interactions.list[_i4];
      var _interaction = _ref6;

      if (_interaction.pointerType === pointerType && !(/down/i.test(eventType) && _interaction.simulation)) {
        return _interaction;
      }
    }

    return null;
  },
  // get interaction that has this pointer
  hasPointer: function hasPointer(_ref7) {
    var pointerId = _ref7.pointerId,
        scope = _ref7.scope;

    for (var _i5 = 0; _i5 < scope.interactions.list.length; _i5++) {
      var _ref8;

      _ref8 = scope.interactions.list[_i5];
      var interaction = _ref8;

      if (hasPointerId(interaction, pointerId)) {
        return interaction;
      }
    }

    return null;
  },
  // get first idle interaction with a matching pointerType
  idle: function idle(_ref9) {
    var pointerType = _ref9.pointerType,
        scope = _ref9.scope;

    for (var _i6 = 0; _i6 < scope.interactions.list.length; _i6++) {
      var _ref10;

      _ref10 = scope.interactions.list[_i6];
      var interaction = _ref10;

      // if there's already a pointer held down
      if (interaction.pointers.length === 1) {
        var target = interaction.interactable; // don't add this pointer if there is a target interactable and it
        // isn't gesturable

        if (target && !(target.options.gesture && target.options.gesture.enabled)) {
          continue;
        }
      } // maximum of 2 pointers per interaction
      else if (interaction.pointers.length >= 2) {
          continue;
        }

      if (!interaction.interacting() && pointerType === interaction.pointerType) {
        return interaction;
      }
    }

    return null;
  }
};

function hasPointerId(interaction, pointerId) {
  return interaction.pointers.some(function (_ref11) {
    var id = _ref11.id;
    return id === pointerId;
  });
}

var ___default_22 = finder;
_$interactionFinder_22["default"] = ___default_22;

var _$interactablePreventDefault_21 = {};
"use strict";

function ___typeof_21(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_21 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_21 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_21(obj); }

Object.defineProperty(_$interactablePreventDefault_21, "__esModule", {
  value: true
});
_$interactablePreventDefault_21.install = __install_21;
_$interactablePreventDefault_21["default"] = void 0;

/* removed: var _$domUtils_53 = require("@interactjs/utils/domUtils"); */;

var ___events_21 = ___interopRequireDefault_21(_$events_54);

var __is_21 = ___interopRequireWildcard_21(_$is_59);

/* removed: var _$window_68 = require("@interactjs/utils/window"); */;

function ___getRequireWildcardCache_21() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_21 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_21(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_21(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_21(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_21(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function preventDefault(newValue) {
  if (/^(always|never|auto)$/.test(newValue)) {
    this.options.preventDefault = newValue;
    return this;
  }

  if (__is_21.bool(newValue)) {
    this.options.preventDefault = newValue ? 'always' : 'never';
    return this;
  }

  return this.options.preventDefault;
}

function checkAndPreventDefault(interactable, scope, event) {
  var setting = interactable.options.preventDefault;

  if (setting === 'never') {
    return;
  }

  if (setting === 'always') {
    event.preventDefault();
    return;
  } // setting === 'auto'
  // if the browser supports passive event listeners and isn't running on iOS,
  // don't preventDefault of touch{start,move} events. CSS touch-action and
  // user-select should be used instead of calling event.preventDefault().


  if (___events_21["default"].supportsPassive && /^touch(start|move)$/.test(event.type)) {
    var doc = (0, _$window_68.getWindow)(event.target).document;
    var docOptions = scope.getDocOptions(doc);

    if (!(docOptions && docOptions.events) || docOptions.events.passive !== false) {
      return;
    }
  } // don't preventDefault of pointerdown events


  if (/^(mouse|pointer|touch)*(down|start)/i.test(event.type)) {
    return;
  } // don't preventDefault on editable elements


  if (__is_21.element(event.target) && (0, _$domUtils_53.matchesSelector)(event.target, 'input,select,textarea,[contenteditable=true],[contenteditable=true] *')) {
    return;
  }

  event.preventDefault();
}

function onInteractionEvent(_ref) {
  var interaction = _ref.interaction,
      event = _ref.event;

  if (interaction.interactable) {
    interaction.interactable.checkAndPreventDefault(event);
  }
}

function __install_21(scope) {
  /** @lends Interactable */
  var Interactable = scope.Interactable;
  /**
   * Returns or sets whether to prevent the browser's default behaviour in
   * response to pointer events. Can be set to:
   *  - `'always'` to always prevent
   *  - `'never'` to never prevent
   *  - `'auto'` to let interact.js try to determine what would be best
   *
   * @param {string} [newValue] `'always'`, `'never'` or `'auto'`
   * @return {string | Interactable} The current setting or this Interactable
   */

  Interactable.prototype.preventDefault = preventDefault;

  Interactable.prototype.checkAndPreventDefault = function (event) {
    return checkAndPreventDefault(this, scope, event);
  }; // prevent native HTML5 drag on interact.js target elements


  scope.interactions.docEvents.push({
    type: 'dragstart',
    listener: function listener(event) {
      for (var _i = 0; _i < scope.interactions.list.length; _i++) {
        var _ref2;

        _ref2 = scope.interactions.list[_i];
        var interaction = _ref2;

        if (interaction.element && (interaction.element === event.target || (0, _$domUtils_53.nodeContains)(interaction.element, event.target))) {
          interaction.interactable.checkAndPreventDefault(event);
          return;
        }
      }
    }
  });
}

var ___default_21 = {
  id: 'core/interactablePreventDefault',
  install: __install_21,
  listeners: ['down', 'move', 'up', 'cancel'].reduce(function (acc, eventType) {
    acc["interactions:".concat(eventType)] = onInteractionEvent;
    return acc;
  }, {})
};
_$interactablePreventDefault_21["default"] = ___default_21;

var _$DropEvent_2 = {};
"use strict";

Object.defineProperty(_$DropEvent_2, "__esModule", {
  value: true
});
_$DropEvent_2["default"] = void 0;

var ___BaseEvent2_2 = ___interopRequireDefault_2(_$BaseEvent_13);

var __arr_2 = ___interopRequireWildcard_2(_$arr_49);

function ___getRequireWildcardCache_2() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_2 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_2(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_2(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_2(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_2(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___typeof_2(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_2 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_2 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_2(obj); }

function ___classCallCheck_2(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ___defineProperties_2(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ___createClass_2(Constructor, protoProps, staticProps) { if (protoProps) ___defineProperties_2(Constructor.prototype, protoProps); if (staticProps) ___defineProperties_2(Constructor, staticProps); return Constructor; }

function ___possibleConstructorReturn_2(self, call) { if (call && (___typeof_2(call) === "object" || typeof call === "function")) { return call; } return ___assertThisInitialized_2(self); }

function ___getPrototypeOf_2(o) { ___getPrototypeOf_2 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return ___getPrototypeOf_2(o); }

function ___assertThisInitialized_2(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function ___inherits_2(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) ___setPrototypeOf_2(subClass, superClass); }

function ___setPrototypeOf_2(o, p) { ___setPrototypeOf_2 = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return ___setPrototypeOf_2(o, p); }

function ___defineProperty_2(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var DropEvent = /*#__PURE__*/function (_BaseEvent) {
  ___inherits_2(DropEvent, _BaseEvent);

  /**
   * Class of events fired on dropzones during drags with acceptable targets.
   */
  function DropEvent(dropState, dragEvent, type) {
    var _this;

    ___classCallCheck_2(this, DropEvent);

    _this = ___possibleConstructorReturn_2(this, ___getPrototypeOf_2(DropEvent).call(this, dragEvent._interaction));

    ___defineProperty_2(___assertThisInitialized_2(_this), "target", void 0);

    ___defineProperty_2(___assertThisInitialized_2(_this), "dropzone", void 0);

    ___defineProperty_2(___assertThisInitialized_2(_this), "dragEvent", void 0);

    ___defineProperty_2(___assertThisInitialized_2(_this), "relatedTarget", void 0);

    ___defineProperty_2(___assertThisInitialized_2(_this), "draggable", void 0);

    ___defineProperty_2(___assertThisInitialized_2(_this), "timeStamp", void 0);

    ___defineProperty_2(___assertThisInitialized_2(_this), "propagationStopped", false);

    ___defineProperty_2(___assertThisInitialized_2(_this), "immediatePropagationStopped", false);

    var _ref = type === 'dragleave' ? dropState.prev : dropState.cur,
        element = _ref.element,
        dropzone = _ref.dropzone;

    _this.type = type;
    _this.target = element;
    _this.currentTarget = element;
    _this.dropzone = dropzone;
    _this.dragEvent = dragEvent;
    _this.relatedTarget = dragEvent.target;
    _this.draggable = dragEvent.interactable;
    _this.timeStamp = dragEvent.timeStamp;
    return _this;
  }
  /**
   * If this is a `dropactivate` event, the dropzone element will be
   * deactivated.
   *
   * If this is a `dragmove` or `dragenter`, a `dragleave` will be fired on the
   * dropzone element and more.
   */


  ___createClass_2(DropEvent, [{
    key: "reject",
    value: function reject() {
      var _this2 = this;

      var dropState = this._interaction.dropState;

      if (this.type !== 'dropactivate' && (!this.dropzone || dropState.cur.dropzone !== this.dropzone || dropState.cur.element !== this.target)) {
        return;
      }

      dropState.prev.dropzone = this.dropzone;
      dropState.prev.element = this.target;
      dropState.rejected = true;
      dropState.events.enter = null;
      this.stopImmediatePropagation();

      if (this.type === 'dropactivate') {
        var activeDrops = dropState.activeDrops;
        var index = __arr_2.findIndex(activeDrops, function (_ref2) {
          var dropzone = _ref2.dropzone,
              element = _ref2.element;
          return dropzone === _this2.dropzone && element === _this2.target;
        });
        dropState.activeDrops.splice(index, 1);
        var deactivateEvent = new DropEvent(dropState, this.dragEvent, 'dropdeactivate');
        deactivateEvent.dropzone = this.dropzone;
        deactivateEvent.target = this.target;
        this.dropzone.fire(deactivateEvent);
      } else {
        this.dropzone.fire(new DropEvent(dropState, this.dragEvent, 'dragleave'));
      }
    }
  }, {
    key: "preventDefault",
    value: function preventDefault() {}
  }, {
    key: "stopPropagation",
    value: function stopPropagation() {
      this.propagationStopped = true;
    }
  }, {
    key: "stopImmediatePropagation",
    value: function stopImmediatePropagation() {
      this.immediatePropagationStopped = this.propagationStopped = true;
    }
  }]);

  return DropEvent;
}(___BaseEvent2_2["default"]);

var ___default_2 = DropEvent;
_$DropEvent_2["default"] = ___default_2;

var _$index_3 = {};
"use strict";

function ___typeof_3(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_3 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_3 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_3(obj); }

Object.defineProperty(_$index_3, "__esModule", {
  value: true
});
_$index_3["default"] = void 0;

var ___Interactable_3 = ___interopRequireDefault_3(_$Interactable_16({}));

var ___scope_3 = _$scope_24({});

var __utils_3 = ___interopRequireWildcard_3(_$index_58);

var _drag = ___interopRequireDefault_3(_$drag_1);

var _DropEvent = ___interopRequireDefault_3(_$DropEvent_2);

function ___getRequireWildcardCache_3() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_3 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_3(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_3(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_3(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_3(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function __install_3(scope) {
  var actions = scope.actions,
      interact = scope.interact,
      Interactable = scope.Interactable,
      defaults = scope.defaults;
  scope.usePlugin(_drag["default"]);
  /**
   *
   * ```js
   * interact('.drop').dropzone({
   *   accept: '.can-drop' || document.getElementById('single-drop'),
   *   overlap: 'pointer' || 'center' || zeroToOne
   * }
   * ```
   *
   * Returns or sets whether draggables can be dropped onto this target to
   * trigger drop events
   *
   * Dropzones can receive the following events:
   *  - `dropactivate` and `dropdeactivate` when an acceptable drag starts and ends
   *  - `dragenter` and `dragleave` when a draggable enters and leaves the dropzone
   *  - `dragmove` when a draggable that has entered the dropzone is moved
   *  - `drop` when a draggable is dropped into this dropzone
   *
   * Use the `accept` option to allow only elements that match the given CSS
   * selector or element. The value can be:
   *
   *  - **an Element** - only that element can be dropped into this dropzone.
   *  - **a string**, - the element being dragged must match it as a CSS selector.
   *  - **`null`** - accept options is cleared - it accepts any element.
   *
   * Use the `overlap` option to set how drops are checked for. The allowed
   * values are:
   *
   *   - `'pointer'`, the pointer must be over the dropzone (default)
   *   - `'center'`, the draggable element's center must be over the dropzone
   *   - a number from 0-1 which is the `(intersection area) / (draggable area)`.
   *   e.g. `0.5` for drop to happen when half of the area of the draggable is
   *   over the dropzone
   *
   * Use the `checker` option to specify a function to check if a dragged element
   * is over this Interactable.
   *
   * @param {boolean | object | null} [options] The new options to be set.
   * @return {boolean | Interactable} The current setting or this Interactable
   */

  Interactable.prototype.dropzone = function (options) {
    return dropzoneMethod(this, options);
  };
  /**
   * ```js
   * interact(target)
   * .dropChecker(function(dragEvent,         // related dragmove or dragend event
   *                       event,             // TouchEvent/PointerEvent/MouseEvent
   *                       dropped,           // bool result of the default checker
   *                       dropzone,          // dropzone Interactable
   *                       dropElement,       // dropzone elemnt
   *                       draggable,         // draggable Interactable
   *                       draggableElement) {// draggable element
   *
   *   return dropped && event.target.hasAttribute('allow-drop')
   * }
   * ```
   */


  Interactable.prototype.dropCheck = function (dragEvent, event, draggable, draggableElement, dropElement, rect) {
    return dropCheckMethod(this, dragEvent, event, draggable, draggableElement, dropElement, rect);
  };
  /**
   * Returns or sets whether the dimensions of dropzone elements are calculated
   * on every dragmove or only on dragstart for the default dropChecker
   *
   * @param {boolean} [newValue] True to check on each move. False to check only
   * before start
   * @return {boolean | interact} The current setting or interact
   */


  interact.dynamicDrop = function (newValue) {
    if (__utils_3.is.bool(newValue)) {
      // if (dragging && scope.dynamicDrop !== newValue && !newValue) {
      //  calcRects(dropzones)
      // }
      scope.dynamicDrop = newValue;
      return interact;
    }

    return scope.dynamicDrop;
  };

  __utils_3.extend(actions.phaselessTypes, {
    dragenter: true,
    dragleave: true,
    dropactivate: true,
    dropdeactivate: true,
    dropmove: true,
    drop: true
  });
  actions.methodDict.drop = 'dropzone';
  scope.dynamicDrop = false;
  defaults.actions.drop = drop.defaults;
}

function collectDrops(_ref, draggableElement) {
  var interactables = _ref.interactables;
  var drops = []; // collect all dropzones and their elements which qualify for a drop

  for (var _i = 0; _i < interactables.list.length; _i++) {
    var _ref2;

    _ref2 = interactables.list[_i];
    var dropzone = _ref2;

    if (!dropzone.options.drop.enabled) {
      continue;
    }

    var accept = dropzone.options.drop.accept; // test the draggable draggableElement against the dropzone's accept setting

    if (__utils_3.is.element(accept) && accept !== draggableElement || __utils_3.is.string(accept) && !__utils_3.dom.matchesSelector(draggableElement, accept) || __utils_3.is.func(accept) && !accept({
      dropzone: dropzone,
      draggableElement: draggableElement
    })) {
      continue;
    } // query for new elements if necessary


    var dropElements = __utils_3.is.string(dropzone.target) ? dropzone._context.querySelectorAll(dropzone.target) : __utils_3.is.array(dropzone.target) ? dropzone.target : [dropzone.target];

    for (var _i2 = 0; _i2 < dropElements.length; _i2++) {
      var _ref3;

      _ref3 = dropElements[_i2];
      var dropzoneElement = _ref3;

      if (dropzoneElement !== draggableElement) {
        drops.push({
          dropzone: dropzone,
          element: dropzoneElement
        });
      }
    }
  }

  return drops;
}

function fireActivationEvents(activeDrops, event) {
  // loop through all active dropzones and trigger event
  for (var _i3 = 0; _i3 < activeDrops.slice().length; _i3++) {
    var _ref4;

    _ref4 = activeDrops.slice()[_i3];
    var _ref5 = _ref4,
        dropzone = _ref5.dropzone,
        element = _ref5.element;
    event.dropzone = dropzone; // set current element as event target

    event.target = element;
    dropzone.fire(event);
    event.propagationStopped = event.immediatePropagationStopped = false;
  }
} // return a new array of possible drops. getActiveDrops should always be
// called when a drag has just started or a drag event happens while
// dynamicDrop is true


function getActiveDrops(scope, dragElement) {
  // get dropzones and their elements that could receive the draggable
  var activeDrops = collectDrops(scope, dragElement);

  for (var _i4 = 0; _i4 < activeDrops.length; _i4++) {
    var _ref6;

    _ref6 = activeDrops[_i4];
    var activeDrop = _ref6;
    activeDrop.rect = activeDrop.dropzone.getRect(activeDrop.element);
  }

  return activeDrops;
}

function getDrop(_ref7, dragEvent, pointerEvent) {
  var dropState = _ref7.dropState,
      draggable = _ref7.interactable,
      dragElement = _ref7.element;
  var validDrops = []; // collect all dropzones and their elements which qualify for a drop

  for (var _i5 = 0; _i5 < dropState.activeDrops.length; _i5++) {
    var _ref8;

    _ref8 = dropState.activeDrops[_i5];
    var _ref9 = _ref8,
        dropzone = _ref9.dropzone,
        dropzoneElement = _ref9.element,
        _rect = _ref9.rect;
    validDrops.push(dropzone.dropCheck(dragEvent, pointerEvent, draggable, dragElement, dropzoneElement, _rect) ? dropzoneElement : null);
  } // get the most appropriate dropzone based on DOM depth and order


  var dropIndex = __utils_3.dom.indexOfDeepestElement(validDrops);
  return dropState.activeDrops[dropIndex] || null;
}

function getDropEvents(interaction, _pointerEvent, dragEvent) {
  var dropState = interaction.dropState;
  var dropEvents = {
    enter: null,
    leave: null,
    activate: null,
    deactivate: null,
    move: null,
    drop: null
  };

  if (dragEvent.type === 'dragstart') {
    dropEvents.activate = new _DropEvent["default"](dropState, dragEvent, 'dropactivate');
    dropEvents.activate.target = null;
    dropEvents.activate.dropzone = null;
  }

  if (dragEvent.type === 'dragend') {
    dropEvents.deactivate = new _DropEvent["default"](dropState, dragEvent, 'dropdeactivate');
    dropEvents.deactivate.target = null;
    dropEvents.deactivate.dropzone = null;
  }

  if (dropState.rejected) {
    return dropEvents;
  }

  if (dropState.cur.element !== dropState.prev.element) {
    // if there was a previous dropzone, create a dragleave event
    if (dropState.prev.dropzone) {
      dropEvents.leave = new _DropEvent["default"](dropState, dragEvent, 'dragleave');
      dragEvent.dragLeave = dropEvents.leave.target = dropState.prev.element;
      dragEvent.prevDropzone = dropEvents.leave.dropzone = dropState.prev.dropzone;
    } // if dropzone is not null, create a dragenter event


    if (dropState.cur.dropzone) {
      dropEvents.enter = new _DropEvent["default"](dropState, dragEvent, 'dragenter');
      dragEvent.dragEnter = dropState.cur.element;
      dragEvent.dropzone = dropState.cur.dropzone;
    }
  }

  if (dragEvent.type === 'dragend' && dropState.cur.dropzone) {
    dropEvents.drop = new _DropEvent["default"](dropState, dragEvent, 'drop');
    dragEvent.dropzone = dropState.cur.dropzone;
    dragEvent.relatedTarget = dropState.cur.element;
  }

  if (dragEvent.type === 'dragmove' && dropState.cur.dropzone) {
    dropEvents.move = new _DropEvent["default"](dropState, dragEvent, 'dropmove');
    dropEvents.move.dragmove = dragEvent;
    dragEvent.dropzone = dropState.cur.dropzone;
  }

  return dropEvents;
}

function fireDropEvents(interaction, events) {
  var dropState = interaction.dropState;
  var activeDrops = dropState.activeDrops,
      cur = dropState.cur,
      prev = dropState.prev;

  if (events.leave) {
    prev.dropzone.fire(events.leave);
  }

  if (events.move) {
    cur.dropzone.fire(events.move);
  }

  if (events.enter) {
    cur.dropzone.fire(events.enter);
  }

  if (events.drop) {
    cur.dropzone.fire(events.drop);
  }

  if (events.deactivate) {
    fireActivationEvents(activeDrops, events.deactivate);
  }

  dropState.prev.dropzone = cur.dropzone;
  dropState.prev.element = cur.element;
}

function onEventCreated(_ref10, scope) {
  var interaction = _ref10.interaction,
      iEvent = _ref10.iEvent,
      event = _ref10.event;

  if (iEvent.type !== 'dragmove' && iEvent.type !== 'dragend') {
    return;
  }

  var dropState = interaction.dropState;

  if (scope.dynamicDrop) {
    dropState.activeDrops = getActiveDrops(scope, interaction.element);
  }

  var dragEvent = iEvent;
  var dropResult = getDrop(interaction, dragEvent, event); // update rejected status

  dropState.rejected = dropState.rejected && !!dropResult && dropResult.dropzone === dropState.cur.dropzone && dropResult.element === dropState.cur.element;
  dropState.cur.dropzone = dropResult && dropResult.dropzone;
  dropState.cur.element = dropResult && dropResult.element;
  dropState.events = getDropEvents(interaction, event, dragEvent);
}

function dropzoneMethod(interactable, options) {
  if (__utils_3.is.object(options)) {
    interactable.options.drop.enabled = options.enabled !== false;

    if (options.listeners) {
      var normalized = __utils_3.normalizeListeners(options.listeners); // rename 'drop' to '' as it will be prefixed with 'drop'

      var corrected = Object.keys(normalized).reduce(function (acc, type) {
        var correctedType = /^(enter|leave)/.test(type) ? "drag".concat(type) : /^(activate|deactivate|move)/.test(type) ? "drop".concat(type) : type;
        acc[correctedType] = normalized[type];
        return acc;
      }, {});
      interactable.off(interactable.options.drop.listeners);
      interactable.on(corrected);
      interactable.options.drop.listeners = corrected;
    }

    if (__utils_3.is.func(options.ondrop)) {
      interactable.on('drop', options.ondrop);
    }

    if (__utils_3.is.func(options.ondropactivate)) {
      interactable.on('dropactivate', options.ondropactivate);
    }

    if (__utils_3.is.func(options.ondropdeactivate)) {
      interactable.on('dropdeactivate', options.ondropdeactivate);
    }

    if (__utils_3.is.func(options.ondragenter)) {
      interactable.on('dragenter', options.ondragenter);
    }

    if (__utils_3.is.func(options.ondragleave)) {
      interactable.on('dragleave', options.ondragleave);
    }

    if (__utils_3.is.func(options.ondropmove)) {
      interactable.on('dropmove', options.ondropmove);
    }

    if (/^(pointer|center)$/.test(options.overlap)) {
      interactable.options.drop.overlap = options.overlap;
    } else if (__utils_3.is.number(options.overlap)) {
      interactable.options.drop.overlap = Math.max(Math.min(1, options.overlap), 0);
    }

    if ('accept' in options) {
      interactable.options.drop.accept = options.accept;
    }

    if ('checker' in options) {
      interactable.options.drop.checker = options.checker;
    }

    return interactable;
  }

  if (__utils_3.is.bool(options)) {
    interactable.options.drop.enabled = options;
    return interactable;
  }

  return interactable.options.drop;
}

function dropCheckMethod(interactable, dragEvent, event, draggable, draggableElement, dropElement, rect) {
  var dropped = false; // if the dropzone has no rect (eg. display: none)
  // call the custom dropChecker or just return false

  if (!(rect = rect || interactable.getRect(dropElement))) {
    return interactable.options.drop.checker ? interactable.options.drop.checker(dragEvent, event, dropped, interactable, dropElement, draggable, draggableElement) : false;
  }

  var dropOverlap = interactable.options.drop.overlap;

  if (dropOverlap === 'pointer') {
    var origin = __utils_3.getOriginXY(draggable, draggableElement, 'drag');
    var page = __utils_3.pointer.getPageXY(dragEvent);
    page.x += origin.x;
    page.y += origin.y;
    var horizontal = page.x > rect.left && page.x < rect.right;
    var vertical = page.y > rect.top && page.y < rect.bottom;
    dropped = horizontal && vertical;
  }

  var dragRect = draggable.getRect(draggableElement);

  if (dragRect && dropOverlap === 'center') {
    var cx = dragRect.left + dragRect.width / 2;
    var cy = dragRect.top + dragRect.height / 2;
    dropped = cx >= rect.left && cx <= rect.right && cy >= rect.top && cy <= rect.bottom;
  }

  if (dragRect && __utils_3.is.number(dropOverlap)) {
    var overlapArea = Math.max(0, Math.min(rect.right, dragRect.right) - Math.max(rect.left, dragRect.left)) * Math.max(0, Math.min(rect.bottom, dragRect.bottom) - Math.max(rect.top, dragRect.top));
    var overlapRatio = overlapArea / (dragRect.width * dragRect.height);
    dropped = overlapRatio >= dropOverlap;
  }

  if (interactable.options.drop.checker) {
    dropped = interactable.options.drop.checker(dragEvent, event, dropped, interactable, dropElement, draggable, draggableElement);
  }

  return dropped;
}

var drop = {
  id: 'actions/drop',
  install: __install_3,
  listeners: {
    'interactions:before-action-start': function interactionsBeforeActionStart(_ref11) {
      var interaction = _ref11.interaction;

      if (interaction.prepared.name !== 'drag') {
        return;
      }

      interaction.dropState = {
        cur: {
          dropzone: null,
          element: null
        },
        prev: {
          dropzone: null,
          element: null
        },
        rejected: null,
        events: null,
        activeDrops: []
      };
    },
    'interactions:after-action-start': function interactionsAfterActionStart(_ref12, scope) {
      var interaction = _ref12.interaction,
          event = _ref12.event,
          dragEvent = _ref12.iEvent;

      if (interaction.prepared.name !== 'drag') {
        return;
      }

      var dropState = interaction.dropState; // reset active dropzones

      dropState.activeDrops = null;
      dropState.events = null;
      dropState.activeDrops = getActiveDrops(scope, interaction.element);
      dropState.events = getDropEvents(interaction, event, dragEvent);

      if (dropState.events.activate) {
        fireActivationEvents(dropState.activeDrops, dropState.events.activate);
        scope.fire('actions/drop:start', {
          interaction: interaction,
          dragEvent: dragEvent
        });
      }
    },
    // FIXME proper signal types
    'interactions:action-move': onEventCreated,
    'interactions:action-end': onEventCreated,
    'interactions:after-action-move': function fireDropAfterMove(_ref13, scope) {
      var interaction = _ref13.interaction,
          dragEvent = _ref13.iEvent;

      if (interaction.prepared.name !== 'drag') {
        return;
      }

      fireDropEvents(interaction, interaction.dropState.events);
      scope.fire('actions/drop:move', {
        interaction: interaction,
        dragEvent: dragEvent
      });
      interaction.dropState.events = {};
    },
    'interactions:after-action-end': function interactionsAfterActionEnd(_ref14, scope) {
      var interaction = _ref14.interaction,
          dragEvent = _ref14.iEvent;

      if (interaction.prepared.name !== 'drag') {
        return;
      }

      fireDropEvents(interaction, interaction.dropState.events);
      scope.fire('actions/drop:end', {
        interaction: interaction,
        dragEvent: dragEvent
      });
    },
    'interactions:stop': function interactionsStop(_ref15) {
      var interaction = _ref15.interaction;

      if (interaction.prepared.name !== 'drag') {
        return;
      }

      var dropState = interaction.dropState;

      if (dropState) {
        dropState.activeDrops = null;
        dropState.events = null;
        dropState.cur.dropzone = null;
        dropState.cur.element = null;
        dropState.prev.dropzone = null;
        dropState.prev.element = null;
        dropState.rejected = false;
      }
    }
  },
  getActiveDrops: getActiveDrops,
  getDrop: getDrop,
  getDropEvents: getDropEvents,
  fireDropEvents: fireDropEvents,
  defaults: {
    enabled: false,
    accept: null,
    overlap: 'pointer'
  }
};
var ___default_3 = drop;
_$index_3["default"] = ___default_3;

var _$gesture_4 = {};
"use strict";

function ___typeof_4(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_4 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_4 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_4(obj); }

Object.defineProperty(_$gesture_4, "__esModule", {
  value: true
});
_$gesture_4["default"] = void 0;

var __utils_4 = ___interopRequireWildcard_4(_$index_58);

function ___getRequireWildcardCache_4() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_4 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_4(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_4(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_4(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function __install_4(scope) {
  var actions = scope.actions,
      Interactable = scope.Interactable,
      defaults = scope.defaults;
  /**
   * ```js
   * interact(element).gesturable({
   *     onstart: function (event) {},
   *     onmove : function (event) {},
   *     onend  : function (event) {},
   *
   *     // limit multiple gestures.
   *     // See the explanation in {@link Interactable.draggable} example
   *     max: Infinity,
   *     maxPerElement: 1,
   * })
   *
   * var isGestureable = interact(element).gesturable()
   * ```
   *
   * Gets or sets whether multitouch gestures can be performed on the target
   *
   * @param {boolean | object} [options] true/false or An object with event
   * listeners to be fired on gesture events (makes the Interactable gesturable)
   * @return {boolean | Interactable} A boolean indicating if this can be the
   * target of gesture events, or this Interactable
   */

  Interactable.prototype.gesturable = function (options) {
    if (__utils_4.is.object(options)) {
      this.options.gesture.enabled = options.enabled !== false;
      this.setPerAction('gesture', options);
      this.setOnEvents('gesture', options);
      return this;
    }

    if (__utils_4.is.bool(options)) {
      this.options.gesture.enabled = options;
      return this;
    }

    return this.options.gesture;
  };

  actions.map.gesture = gesture;
  actions.methodDict.gesture = 'gesturable';
  defaults.actions.gesture = gesture.defaults;
}

function updateGestureProps(_ref) {
  var interaction = _ref.interaction,
      iEvent = _ref.iEvent,
      phase = _ref.phase;

  if (interaction.prepared.name !== 'gesture') {
    return;
  }

  var pointers = interaction.pointers.map(function (p) {
    return p.pointer;
  });
  var starting = phase === 'start';
  var ending = phase === 'end';
  var deltaSource = interaction.interactable.options.deltaSource;
  iEvent.touches = [pointers[0], pointers[1]];

  if (starting) {
    iEvent.distance = __utils_4.pointer.touchDistance(pointers, deltaSource);
    iEvent.box = __utils_4.pointer.touchBBox(pointers);
    iEvent.scale = 1;
    iEvent.ds = 0;
    iEvent.angle = __utils_4.pointer.touchAngle(pointers, deltaSource);
    iEvent.da = 0;
    interaction.gesture.startDistance = iEvent.distance;
    interaction.gesture.startAngle = iEvent.angle;
  } else if (ending) {
    var prevEvent = interaction.prevEvent;
    iEvent.distance = prevEvent.distance;
    iEvent.box = prevEvent.box;
    iEvent.scale = prevEvent.scale;
    iEvent.ds = 0;
    iEvent.angle = prevEvent.angle;
    iEvent.da = 0;
  } else {
    iEvent.distance = __utils_4.pointer.touchDistance(pointers, deltaSource);
    iEvent.box = __utils_4.pointer.touchBBox(pointers);
    iEvent.scale = iEvent.distance / interaction.gesture.startDistance;
    iEvent.angle = __utils_4.pointer.touchAngle(pointers, deltaSource);
    iEvent.ds = iEvent.scale - interaction.gesture.scale;
    iEvent.da = iEvent.angle - interaction.gesture.angle;
  }

  interaction.gesture.distance = iEvent.distance;
  interaction.gesture.angle = iEvent.angle;

  if (__utils_4.is.number(iEvent.scale) && iEvent.scale !== Infinity && !isNaN(iEvent.scale)) {
    interaction.gesture.scale = iEvent.scale;
  }
}

var gesture = {
  id: 'actions/gesture',
  before: ['actions/drag', 'actions/resize'],
  install: __install_4,
  listeners: {
    'interactions:action-start': updateGestureProps,
    'interactions:action-move': updateGestureProps,
    'interactions:action-end': updateGestureProps,
    'interactions:new': function interactionsNew(_ref2) {
      var interaction = _ref2.interaction;
      interaction.gesture = {
        angle: 0,
        distance: 0,
        scale: 1,
        startAngle: 0,
        startDistance: 0
      };
    },
    'auto-start:check': function autoStartCheck(arg) {
      if (arg.interaction.pointers.length < 2) {
        return undefined;
      }

      var gestureOptions = arg.interactable.options.gesture;

      if (!(gestureOptions && gestureOptions.enabled)) {
        return undefined;
      }

      arg.action = {
        name: 'gesture'
      };
      return false;
    }
  },
  defaults: {},
  getCursor: function getCursor() {
    return '';
  }
};
var ___default_4 = gesture;
_$gesture_4["default"] = ___default_4;

var _$resize_6 = {};
"use strict";

function ___typeof_6(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_6 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_6 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_6(obj); }

Object.defineProperty(_$resize_6, "__esModule", {
  value: true
});
_$resize_6["default"] = void 0;

/* removed: var _$Interaction_18 = require("@interactjs/core/Interaction"); */;

var __dom_6 = ___interopRequireWildcard_6(_$domUtils_53);

var ___extend_6 = ___interopRequireDefault_6(_$extend_55);

var __is_6 = ___interopRequireWildcard_6(_$is_59);

function ___interopRequireDefault_6(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___getRequireWildcardCache_6() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_6 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_6(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_6(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_6(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function __install_6(scope) {
  var actions = scope.actions,
      browser = scope.browser,
      Interactable = scope.Interactable,
      defaults = scope.defaults; // Less Precision with touch input

  resize.cursors = initCursors(browser);
  resize.defaultMargin = browser.supportsTouch || browser.supportsPointerEvent ? 20 : 10;
  /**
   * ```js
   * interact(element).resizable({
   *   onstart: function (event) {},
   *   onmove : function (event) {},
   *   onend  : function (event) {},
   *
   *   edges: {
   *     top   : true,       // Use pointer coords to check for resize.
   *     left  : false,      // Disable resizing from left edge.
   *     bottom: '.resize-s',// Resize if pointer target matches selector
   *     right : handleEl    // Resize if pointer target is the given Element
   *   },
   *
   *     // Width and height can be adjusted independently. When `true`, width and
   *     // height are adjusted at a 1:1 ratio.
   *     square: false,
   *
   *     // Width and height can be adjusted independently. When `true`, width and
   *     // height maintain the aspect ratio they had when resizing started.
   *     preserveAspectRatio: false,
   *
   *   // a value of 'none' will limit the resize rect to a minimum of 0x0
   *   // 'negate' will allow the rect to have negative width/height
   *   // 'reposition' will keep the width/height positive by swapping
   *   // the top and bottom edges and/or swapping the left and right edges
   *   invert: 'none' || 'negate' || 'reposition'
   *
   *   // limit multiple resizes.
   *   // See the explanation in the {@link Interactable.draggable} example
   *   max: Infinity,
   *   maxPerElement: 1,
   * })
   *
   * var isResizeable = interact(element).resizable()
   * ```
   *
   * Gets or sets whether resize actions can be performed on the target
   *
   * @param {boolean | object} [options] true/false or An object with event
   * listeners to be fired on resize events (object makes the Interactable
   * resizable)
   * @return {boolean | Interactable} A boolean indicating if this can be the
   * target of resize elements, or this Interactable
   */

  Interactable.prototype.resizable = function (options) {
    return resizable(this, options, scope);
  };

  actions.map.resize = resize;
  actions.methodDict.resize = 'resizable';
  defaults.actions.resize = resize.defaults;
}

function resizeChecker(arg) {
  var interaction = arg.interaction,
      interactable = arg.interactable,
      element = arg.element,
      rect = arg.rect,
      buttons = arg.buttons;

  if (!rect) {
    return undefined;
  }

  var page = (0, ___extend_6["default"])({}, interaction.coords.cur.page);
  var resizeOptions = interactable.options.resize;

  if (!(resizeOptions && resizeOptions.enabled) || // check mouseButton setting if the pointer is down
  interaction.pointerIsDown && /mouse|pointer/.test(interaction.pointerType) && (buttons & resizeOptions.mouseButtons) === 0) {
    return undefined;
  } // if using resize.edges


  if (__is_6.object(resizeOptions.edges)) {
    var resizeEdges = {
      left: false,
      right: false,
      top: false,
      bottom: false
    };

    for (var edge in resizeEdges) {
      resizeEdges[edge] = checkResizeEdge(edge, resizeOptions.edges[edge], page, interaction._latestPointer.eventTarget, element, rect, resizeOptions.margin || resize.defaultMargin);
    }

    resizeEdges.left = resizeEdges.left && !resizeEdges.right;
    resizeEdges.top = resizeEdges.top && !resizeEdges.bottom;

    if (resizeEdges.left || resizeEdges.right || resizeEdges.top || resizeEdges.bottom) {
      arg.action = {
        name: 'resize',
        edges: resizeEdges
      };
    }
  } else {
    var right = resizeOptions.axis !== 'y' && page.x > rect.right - resize.defaultMargin;
    var bottom = resizeOptions.axis !== 'x' && page.y > rect.bottom - resize.defaultMargin;

    if (right || bottom) {
      arg.action = {
        name: 'resize',
        axes: (right ? 'x' : '') + (bottom ? 'y' : '')
      };
    }
  }

  return arg.action ? false : undefined;
}

function resizable(interactable, options, scope) {
  if (__is_6.object(options)) {
    interactable.options.resize.enabled = options.enabled !== false;
    interactable.setPerAction('resize', options);
    interactable.setOnEvents('resize', options);

    if (__is_6.string(options.axis) && /^x$|^y$|^xy$/.test(options.axis)) {
      interactable.options.resize.axis = options.axis;
    } else if (options.axis === null) {
      interactable.options.resize.axis = scope.defaults.actions.resize.axis;
    }

    if (__is_6.bool(options.preserveAspectRatio)) {
      interactable.options.resize.preserveAspectRatio = options.preserveAspectRatio;
    } else if (__is_6.bool(options.square)) {
      interactable.options.resize.square = options.square;
    }

    return interactable;
  }

  if (__is_6.bool(options)) {
    interactable.options.resize.enabled = options;
    return interactable;
  }

  return interactable.options.resize;
}

function checkResizeEdge(name, value, page, element, interactableElement, rect, margin) {
  // false, '', undefined, null
  if (!value) {
    return false;
  } // true value, use pointer coords and element rect


  if (value === true) {
    // if dimensions are negative, "switch" edges
    var width = __is_6.number(rect.width) ? rect.width : rect.right - rect.left;
    var height = __is_6.number(rect.height) ? rect.height : rect.bottom - rect.top; // don't use margin greater than half the relevent dimension

    margin = Math.min(margin, (name === 'left' || name === 'right' ? width : height) / 2);

    if (width < 0) {
      if (name === 'left') {
        name = 'right';
      } else if (name === 'right') {
        name = 'left';
      }
    }

    if (height < 0) {
      if (name === 'top') {
        name = 'bottom';
      } else if (name === 'bottom') {
        name = 'top';
      }
    }

    if (name === 'left') {
      return page.x < (width >= 0 ? rect.left : rect.right) + margin;
    }

    if (name === 'top') {
      return page.y < (height >= 0 ? rect.top : rect.bottom) + margin;
    }

    if (name === 'right') {
      return page.x > (width >= 0 ? rect.right : rect.left) - margin;
    }

    if (name === 'bottom') {
      return page.y > (height >= 0 ? rect.bottom : rect.top) - margin;
    }
  } // the remaining checks require an element


  if (!__is_6.element(element)) {
    return false;
  }

  return __is_6.element(value) // the value is an element to use as a resize handle
  ? value === element // otherwise check if element matches value as selector
  : __dom_6.matchesUpTo(element, value, interactableElement);
}

function initCursors(browser) {
  return browser.isIe9 ? {
    x: 'e-resize',
    y: 's-resize',
    xy: 'se-resize',
    top: 'n-resize',
    left: 'w-resize',
    bottom: 's-resize',
    right: 'e-resize',
    topleft: 'se-resize',
    bottomright: 'se-resize',
    topright: 'ne-resize',
    bottomleft: 'ne-resize'
  } : {
    x: 'ew-resize',
    y: 'ns-resize',
    xy: 'nwse-resize',
    top: 'ns-resize',
    left: 'ew-resize',
    bottom: 'ns-resize',
    right: 'ew-resize',
    topleft: 'nwse-resize',
    bottomright: 'nwse-resize',
    topright: 'nesw-resize',
    bottomleft: 'nesw-resize'
  };
}

function start(_ref) {
  var iEvent = _ref.iEvent,
      interaction = _ref.interaction;

  if (interaction.prepared.name !== 'resize' || !interaction.prepared.edges) {
    return;
  }

  var resizeEvent = iEvent;
  var rect = interaction.rect;
  interaction._rects = {
    start: (0, ___extend_6["default"])({}, rect),
    corrected: (0, ___extend_6["default"])({}, rect),
    previous: (0, ___extend_6["default"])({}, rect),
    delta: {
      left: 0,
      right: 0,
      width: 0,
      top: 0,
      bottom: 0,
      height: 0
    }
  };
  resizeEvent.edges = interaction.prepared.edges;
  resizeEvent.rect = interaction._rects.corrected;
  resizeEvent.deltaRect = interaction._rects.delta;
}

function __move_6(_ref2) {
  var iEvent = _ref2.iEvent,
      interaction = _ref2.interaction;

  if (interaction.prepared.name !== 'resize' || !interaction.prepared.edges) {
    return;
  }

  var resizeEvent = iEvent;
  var resizeOptions = interaction.interactable.options.resize;
  var invert = resizeOptions.invert;
  var invertible = invert === 'reposition' || invert === 'negate'; // eslint-disable-next-line no-shadow

  var current = interaction.rect;
  var _interaction$_rects = interaction._rects,
      startRect = _interaction$_rects.start,
      corrected = _interaction$_rects.corrected,
      deltaRect = _interaction$_rects.delta,
      previous = _interaction$_rects.previous;
  (0, ___extend_6["default"])(previous, corrected);

  if (invertible) {
    // if invertible, copy the current rect
    (0, ___extend_6["default"])(corrected, current);

    if (invert === 'reposition') {
      // swap edge values if necessary to keep width/height positive
      if (corrected.top > corrected.bottom) {
        var swap = corrected.top;
        corrected.top = corrected.bottom;
        corrected.bottom = swap;
      }

      if (corrected.left > corrected.right) {
        var _swap = corrected.left;
        corrected.left = corrected.right;
        corrected.right = _swap;
      }
    }
  } else {
    // if not invertible, restrict to minimum of 0x0 rect
    corrected.top = Math.min(current.top, startRect.bottom);
    corrected.bottom = Math.max(current.bottom, startRect.top);
    corrected.left = Math.min(current.left, startRect.right);
    corrected.right = Math.max(current.right, startRect.left);
  }

  corrected.width = corrected.right - corrected.left;
  corrected.height = corrected.bottom - corrected.top;

  for (var edge in corrected) {
    deltaRect[edge] = corrected[edge] - previous[edge];
  }

  resizeEvent.edges = interaction.prepared.edges;
  resizeEvent.rect = corrected;
  resizeEvent.deltaRect = deltaRect;
}

function end(_ref3) {
  var iEvent = _ref3.iEvent,
      interaction = _ref3.interaction;

  if (interaction.prepared.name !== 'resize' || !interaction.prepared.edges) {
    return;
  }

  var resizeEvent = iEvent;
  resizeEvent.edges = interaction.prepared.edges;
  resizeEvent.rect = interaction._rects.corrected;
  resizeEvent.deltaRect = interaction._rects.delta;
}

function updateEventAxes(_ref4) {
  var iEvent = _ref4.iEvent,
      interaction = _ref4.interaction;

  if (interaction.prepared.name !== 'resize' || !interaction.resizeAxes) {
    return;
  }

  var options = interaction.interactable.options;
  var resizeEvent = iEvent;

  if (options.resize.square) {
    if (interaction.resizeAxes === 'y') {
      resizeEvent.delta.x = resizeEvent.delta.y;
    } else {
      resizeEvent.delta.y = resizeEvent.delta.x;
    }

    resizeEvent.axes = 'xy';
  } else {
    resizeEvent.axes = interaction.resizeAxes;

    if (interaction.resizeAxes === 'x') {
      resizeEvent.delta.y = 0;
    } else if (interaction.resizeAxes === 'y') {
      resizeEvent.delta.x = 0;
    }
  }
}

var resize = {
  id: 'actions/resize',
  before: ['actions/drag'],
  install: __install_6,
  listeners: {
    'interactions:new': function interactionsNew(_ref5) {
      var interaction = _ref5.interaction;
      interaction.resizeAxes = 'xy';
    },
    'interactions:action-start': function interactionsActionStart(arg) {
      start(arg);
      updateEventAxes(arg);
    },
    'interactions:action-move': function interactionsActionMove(arg) {
      __move_6(arg);
      updateEventAxes(arg);
    },
    'interactions:action-end': end,
    'auto-start:check': resizeChecker
  },
  defaults: {
    square: false,
    preserveAspectRatio: false,
    axis: 'xy',
    // use default margin
    margin: NaN,
    // object with props left, right, top, bottom which are
    // true/false values to resize when the pointer is over that edge,
    // CSS selectors to match the handles for each direction
    // or the Elements for each handle
    edges: null,
    // a value of 'none' will limit the resize rect to a minimum of 0x0
    // 'negate' will alow the rect to have negative width/height
    // 'reposition' will keep the width/height positive by swapping
    // the top and bottom edges and/or swapping the left and right edges
    invert: 'none'
  },
  cursors: null,
  getCursor: function getCursor(_ref6) {
    var edges = _ref6.edges,
        axis = _ref6.axis,
        name = _ref6.name;
    var cursors = resize.cursors;
    var result = null;

    if (axis) {
      result = cursors[name + axis];
    } else if (edges) {
      var cursorKey = '';
      var _arr = ['top', 'bottom', 'left', 'right'];

      for (var _i = 0; _i < _arr.length; _i++) {
        var edge = _arr[_i];

        if (edges[edge]) {
          cursorKey += edge;
        }
      }

      result = cursors[cursorKey];
    }

    return result;
  },
  defaultMargin: null
};
var ___default_6 = resize;
_$resize_6["default"] = ___default_6;

var _$index_5 = {};
"use strict";

Object.defineProperty(_$index_5, "__esModule", {
  value: true
});
Object.defineProperty(_$index_5, "drag", {
  enumerable: true,
  get: function get() {
    return ___drag_5["default"];
  }
});
Object.defineProperty(_$index_5, "drop", {
  enumerable: true,
  get: function get() {
    return _index["default"];
  }
});
Object.defineProperty(_$index_5, "gesture", {
  enumerable: true,
  get: function get() {
    return _gesture["default"];
  }
});
Object.defineProperty(_$index_5, "resize", {
  enumerable: true,
  get: function get() {
    return _resize["default"];
  }
});
_$index_5["default"] = void 0;

var ___drag_5 = ___interopRequireDefault_5(_$drag_1);

var _index = ___interopRequireDefault_5(_$index_3);

var _gesture = ___interopRequireDefault_5(_$gesture_4);

var _resize = ___interopRequireDefault_5(_$resize_6);

function ___interopRequireDefault_5(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var ___default_5 = {
  id: 'actions',
  install: function install(scope) {
    scope.usePlugin(_gesture["default"]);
    scope.usePlugin(_resize["default"]);
    scope.usePlugin(___drag_5["default"]);
    scope.usePlugin(_index["default"]);
  }
};
_$index_5["default"] = ___default_5;

var _$index_7 = {};
"use strict";

function ___typeof_7(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_7 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_7 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_7(obj); }

Object.defineProperty(_$index_7, "__esModule", {
  value: true
});
_$index_7.getContainer = getContainer;
_$index_7.getScroll = getScroll;
_$index_7.getScrollSize = getScrollSize;
_$index_7.getScrollSizeDelta = getScrollSizeDelta;
_$index_7["default"] = void 0;

var __domUtils_7 = ___interopRequireWildcard_7(_$domUtils_53);

var __is_7 = ___interopRequireWildcard_7(_$is_59);

var ___raf_7 = ___interopRequireDefault_7(_$raf_64);

/* removed: var _$rect_65 = require("@interactjs/utils/rect"); */;

/* removed: var _$window_68 = require("@interactjs/utils/window"); */;

function ___interopRequireDefault_7(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___getRequireWildcardCache_7() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_7 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_7(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_7(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_7(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function __install_7(scope) {
  var defaults = scope.defaults,
      actions = scope.actions;
  scope.autoScroll = autoScroll;

  autoScroll.now = function () {
    return scope.now();
  };

  actions.phaselessTypes.autoscroll = true;
  defaults.perAction.autoScroll = autoScroll.defaults;
}

var autoScroll = {
  defaults: {
    enabled: false,
    margin: 60,
    // the item that is scrolled (Window or HTMLElement)
    container: null,
    // the scroll speed in pixels per second
    speed: 300
  },
  now: Date.now,
  interaction: null,
  i: 0,
  // the handle returned by window.setInterval
  // Direction each pulse is to scroll in
  x: 0,
  y: 0,
  isScrolling: false,
  prevTime: 0,
  margin: 0,
  speed: 0,
  start: function start(interaction) {
    autoScroll.isScrolling = true;

    ___raf_7["default"].cancel(autoScroll.i);

    interaction.autoScroll = autoScroll;
    autoScroll.interaction = interaction;
    autoScroll.prevTime = autoScroll.now();
    autoScroll.i = ___raf_7["default"].request(autoScroll.scroll);
  },
  stop: function stop() {
    autoScroll.isScrolling = false;

    if (autoScroll.interaction) {
      autoScroll.interaction.autoScroll = null;
    }

    ___raf_7["default"].cancel(autoScroll.i);
  },
  // scroll the window by the values in scroll.x/y
  scroll: function scroll() {
    var interaction = autoScroll.interaction;
    var interactable = interaction.interactable,
        element = interaction.element;
    var actionName = interaction.prepared.name;
    var options = interactable.options[actionName].autoScroll;
    var container = getContainer(options.container, interactable, element);
    var now = autoScroll.now(); // change in time in seconds

    var dt = (now - autoScroll.prevTime) / 1000; // displacement

    var s = options.speed * dt;

    if (s >= 1) {
      var scrollBy = {
        x: autoScroll.x * s,
        y: autoScroll.y * s
      };

      if (scrollBy.x || scrollBy.y) {
        var prevScroll = getScroll(container);

        if (__is_7.window(container)) {
          container.scrollBy(scrollBy.x, scrollBy.y);
        } else if (container) {
          container.scrollLeft += scrollBy.x;
          container.scrollTop += scrollBy.y;
        }

        var curScroll = getScroll(container);
        var delta = {
          x: curScroll.x - prevScroll.x,
          y: curScroll.y - prevScroll.y
        };

        if (delta.x || delta.y) {
          interactable.fire({
            type: 'autoscroll',
            target: element,
            interactable: interactable,
            delta: delta,
            interaction: interaction,
            container: container
          });
        }
      }

      autoScroll.prevTime = now;
    }

    if (autoScroll.isScrolling) {
      ___raf_7["default"].cancel(autoScroll.i);

      autoScroll.i = ___raf_7["default"].request(autoScroll.scroll);
    }
  },
  check: function check(interactable, actionName) {
    var options = interactable.options;
    return options[actionName].autoScroll && options[actionName].autoScroll.enabled;
  },
  onInteractionMove: function onInteractionMove(_ref) {
    var interaction = _ref.interaction,
        pointer = _ref.pointer;

    if (!(interaction.interacting() && autoScroll.check(interaction.interactable, interaction.prepared.name))) {
      return;
    }

    if (interaction.simulation) {
      autoScroll.x = autoScroll.y = 0;
      return;
    }

    var top;
    var right;
    var bottom;
    var left;
    var interactable = interaction.interactable,
        element = interaction.element;
    var actionName = interaction.prepared.name;
    var options = interactable.options[actionName].autoScroll;
    var container = getContainer(options.container, interactable, element);

    if (__is_7.window(container)) {
      left = pointer.clientX < autoScroll.margin;
      top = pointer.clientY < autoScroll.margin;
      right = pointer.clientX > container.innerWidth - autoScroll.margin;
      bottom = pointer.clientY > container.innerHeight - autoScroll.margin;
    } else {
      var rect = __domUtils_7.getElementClientRect(container);
      left = pointer.clientX < rect.left + autoScroll.margin;
      top = pointer.clientY < rect.top + autoScroll.margin;
      right = pointer.clientX > rect.right - autoScroll.margin;
      bottom = pointer.clientY > rect.bottom - autoScroll.margin;
    }

    autoScroll.x = right ? 1 : left ? -1 : 0;
    autoScroll.y = bottom ? 1 : top ? -1 : 0;

    if (!autoScroll.isScrolling) {
      // set the autoScroll properties to those of the target
      autoScroll.margin = options.margin;
      autoScroll.speed = options.speed;
      autoScroll.start(interaction);
    }
  }
};

function getContainer(value, interactable, element) {
  return (__is_7.string(value) ? (0, _$rect_65.getStringOptionResult)(value, interactable, element) : value) || (0, _$window_68.getWindow)(element);
}

function getScroll(container) {
  if (__is_7.window(container)) {
    container = window.document.body;
  }

  return {
    x: container.scrollLeft,
    y: container.scrollTop
  };
}

function getScrollSize(container) {
  if (__is_7.window(container)) {
    container = window.document.body;
  }

  return {
    x: container.scrollWidth,
    y: container.scrollHeight
  };
}

function getScrollSizeDelta(_ref2, func) {
  var interaction = _ref2.interaction,
      element = _ref2.element;
  var scrollOptions = interaction && interaction.interactable.options[interaction.prepared.name].autoScroll;

  if (!scrollOptions || !scrollOptions.enabled) {
    func();
    return {
      x: 0,
      y: 0
    };
  }

  var scrollContainer = getContainer(scrollOptions.container, interaction.interactable, element);
  var prevSize = getScroll(scrollContainer);
  func();
  var curSize = getScroll(scrollContainer);
  return {
    x: curSize.x - prevSize.x,
    y: curSize.y - prevSize.y
  };
}

var autoScrollPlugin = {
  id: 'auto-scroll',
  install: __install_7,
  listeners: {
    'interactions:new': function interactionsNew(_ref3) {
      var interaction = _ref3.interaction;
      interaction.autoScroll = null;
    },
    'interactions:destroy': function interactionsDestroy(_ref4) {
      var interaction = _ref4.interaction;
      interaction.autoScroll = null;
      autoScroll.stop();

      if (autoScroll.interaction) {
        autoScroll.interaction = null;
      }
    },
    'interactions:stop': autoScroll.stop,
    'interactions:action-move': function interactionsActionMove(arg) {
      return autoScroll.onInteractionMove(arg);
    }
  }
};
var ___default_7 = autoScrollPlugin;
_$index_7["default"] = ___default_7;

var _$InteractableMethods_8 = {};
"use strict";

function ___typeof_8(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_8 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_8 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_8(obj); }

Object.defineProperty(_$InteractableMethods_8, "__esModule", {
  value: true
});
_$InteractableMethods_8["default"] = void 0;

/* removed: var _$index_58 = require("@interactjs/utils/index"); */;

var __is_8 = ___interopRequireWildcard_8(_$is_59);

function ___getRequireWildcardCache_8() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_8 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_8(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_8(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_8(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function __install_8(scope) {
  var Interactable = scope.Interactable;

  Interactable.prototype.getAction = function getAction(pointer, event, interaction, element) {
    var action = defaultActionChecker(this, event, interaction, element, scope);

    if (this.options.actionChecker) {
      return this.options.actionChecker(pointer, event, action, this, element, interaction);
    }

    return action;
  };
  /**
   * ```js
   * interact(element, { ignoreFrom: document.getElementById('no-action') })
   * // or
   * interact(element).ignoreFrom('input, textarea, a')
   * ```
   * @deprecated
   * If the target of the `mousedown`, `pointerdown` or `touchstart` event or any
   * of it's parents match the given CSS selector or Element, no
   * drag/resize/gesture is started.
   *
   * Don't use this method. Instead set the `ignoreFrom` option for each action
   * or for `pointerEvents`
   *
   * @example
   * interact(targett)
   *   .draggable({
   *     ignoreFrom: 'input, textarea, a[href]'',
   *   })
   *   .pointerEvents({
   *     ignoreFrom: '[no-pointer]',
   *   })
   *
   * @param {string | Element | null} [newValue] a CSS selector string, an
   * Element or `null` to not ignore any elements
   * @return {string | Element | object} The current ignoreFrom value or this
   * Interactable
   */


  Interactable.prototype.ignoreFrom = (0, _$index_58.warnOnce)(function (newValue) {
    return this._backCompatOption('ignoreFrom', newValue);
  }, 'Interactable.ignoreFrom() has been deprecated. Use Interactble.draggable({ignoreFrom: newValue}).');
  /**
   * @deprecated
   *
   * A drag/resize/gesture is started only If the target of the `mousedown`,
   * `pointerdown` or `touchstart` event or any of it's parents match the given
   * CSS selector or Element.
   *
   * Don't use this method. Instead set the `allowFrom` option for each action
   * or for `pointerEvents`
   *
   * @example
   * interact(targett)
   *   .resizable({
   *     allowFrom: '.resize-handle',
   *   .pointerEvents({
   *     allowFrom: '.handle',,
   *   })
   *
   * @param {string | Element | null} [newValue] a CSS selector string, an
   * Element or `null` to allow from any element
   * @return {string | Element | object} The current allowFrom value or this
   * Interactable
   */

  Interactable.prototype.allowFrom = (0, _$index_58.warnOnce)(function (newValue) {
    return this._backCompatOption('allowFrom', newValue);
  }, 'Interactable.allowFrom() has been deprecated. Use Interactble.draggable({allowFrom: newValue}).');
  /**
   * ```js
   * interact('.resize-drag')
   *   .resizable(true)
   *   .draggable(true)
   *   .actionChecker(function (pointer, event, action, interactable, element, interaction) {
   *
   *   if (interact.matchesSelector(event.target, '.drag-handle')) {
   *     // force drag with handle target
   *     action.name = drag
   *   }
   *   else {
   *     // resize from the top and right edges
   *     action.name  = 'resize'
   *     action.edges = { top: true, right: true }
   *   }
   *
   *   return action
   * })
   * ```
   *
   * Returns or sets the function used to check action to be performed on
   * pointerDown
   *
   * @param {function | null} [checker] A function which takes a pointer event,
   * defaultAction string, interactable, element and interaction as parameters
   * and returns an object with name property 'drag' 'resize' or 'gesture' and
   * optionally an `edges` object with boolean 'top', 'left', 'bottom' and right
   * props.
   * @return {Function | Interactable} The checker function or this Interactable
   */

  Interactable.prototype.actionChecker = actionChecker;
  /**
   * Returns or sets whether the the cursor should be changed depending on the
   * action that would be performed if the mouse were pressed and dragged.
   *
   * @param {boolean} [newValue]
   * @return {boolean | Interactable} The current setting or this Interactable
   */

  Interactable.prototype.styleCursor = styleCursor;
}

function defaultActionChecker(interactable, event, interaction, element, scope) {
  var rect = interactable.getRect(element);
  var buttons = event.buttons || {
    0: 1,
    1: 4,
    3: 8,
    4: 16
  }[event.button];
  var arg = {
    action: null,
    interactable: interactable,
    interaction: interaction,
    element: element,
    rect: rect,
    buttons: buttons
  };
  scope.fire('auto-start:check', arg);
  return arg.action;
}

function styleCursor(newValue) {
  if (__is_8.bool(newValue)) {
    this.options.styleCursor = newValue;
    return this;
  }

  if (newValue === null) {
    delete this.options.styleCursor;
    return this;
  }

  return this.options.styleCursor;
}

function actionChecker(checker) {
  if (__is_8.func(checker)) {
    this.options.actionChecker = checker;
    return this;
  }

  if (checker === null) {
    delete this.options.actionChecker;
    return this;
  }

  return this.options.actionChecker;
}

var ___default_8 = {
  id: 'auto-start/interactableMethods',
  install: __install_8
};
_$InteractableMethods_8["default"] = ___default_8;

var _$base_9 = {};
"use strict";

function ___typeof_9(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_9 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_9 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_9(obj); }

Object.defineProperty(_$base_9, "__esModule", {
  value: true
});
_$base_9["default"] = void 0;

var __utils_9 = ___interopRequireWildcard_9(_$index_58);

var _InteractableMethods = ___interopRequireDefault_9(_$InteractableMethods_8);

function ___interopRequireDefault_9(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___getRequireWildcardCache_9() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_9 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_9(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_9(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_9(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function __install_9(scope) {
  var interact = scope.interact,
      defaults = scope.defaults;
  scope.usePlugin(_InteractableMethods["default"]);
  defaults.base.actionChecker = null;
  defaults.base.styleCursor = true;
  __utils_9.extend(defaults.perAction, {
    manualStart: false,
    max: Infinity,
    maxPerElement: 1,
    allowFrom: null,
    ignoreFrom: null,
    // only allow left button by default
    // see https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/buttons#Return_value
    mouseButtons: 1
  });
  /**
   * Returns or sets the maximum number of concurrent interactions allowed.  By
   * default only 1 interaction is allowed at a time (for backwards
   * compatibility). To allow multiple interactions on the same Interactables and
   * elements, you need to enable it in the draggable, resizable and gesturable
   * `'max'` and `'maxPerElement'` options.
   *
   * @alias module:interact.maxInteractions
   *
   * @param {number} [newValue] Any number. newValue <= 0 means no interactions.
   */

  interact.maxInteractions = function (newValue) {
    return maxInteractions(newValue, scope);
  };

  scope.autoStart = {
    // Allow this many interactions to happen simultaneously
    maxInteractions: Infinity,
    withinInteractionLimit: withinInteractionLimit,
    cursorElement: null
  };
}

function prepareOnDown(_ref, scope) {
  var interaction = _ref.interaction,
      pointer = _ref.pointer,
      event = _ref.event,
      eventTarget = _ref.eventTarget;

  if (interaction.interacting()) {
    return;
  }

  var actionInfo = getActionInfo(interaction, pointer, event, eventTarget, scope);
  prepare(interaction, actionInfo, scope);
}

function prepareOnMove(_ref2, scope) {
  var interaction = _ref2.interaction,
      pointer = _ref2.pointer,
      event = _ref2.event,
      eventTarget = _ref2.eventTarget;

  if (interaction.pointerType !== 'mouse' || interaction.pointerIsDown || interaction.interacting()) {
    return;
  }

  var actionInfo = getActionInfo(interaction, pointer, event, eventTarget, scope);
  prepare(interaction, actionInfo, scope);
}

function startOnMove(arg, scope) {
  var interaction = arg.interaction;

  if (!interaction.pointerIsDown || interaction.interacting() || !interaction.pointerWasMoved || !interaction.prepared.name) {
    return;
  }

  scope.fire('autoStart:before-start', arg);
  var interactable = interaction.interactable;
  var actionName = interaction.prepared.name;

  if (actionName && interactable) {
    // check manualStart and interaction limit
    if (interactable.options[actionName].manualStart || !withinInteractionLimit(interactable, interaction.element, interaction.prepared, scope)) {
      interaction.stop();
    } else {
      interaction.start(interaction.prepared, interactable, interaction.element);
      setInteractionCursor(interaction, scope);
    }
  }
}

function clearCursorOnStop(_ref3, scope) {
  var interaction = _ref3.interaction;
  var interactable = interaction.interactable;

  if (interactable && interactable.options.styleCursor) {
    setCursor(interaction.element, '', scope);
  }
} // Check if the current interactable supports the action.
// If so, return the validated action. Otherwise, return null


function validateAction(action, interactable, element, eventTarget, scope) {
  if (interactable.testIgnoreAllow(interactable.options[action.name], element, eventTarget) && interactable.options[action.name].enabled && withinInteractionLimit(interactable, element, action, scope)) {
    return action;
  }

  return null;
}

function validateMatches(interaction, pointer, event, matches, matchElements, eventTarget, scope) {
  for (var i = 0, len = matches.length; i < len; i++) {
    var match = matches[i];
    var matchElement = matchElements[i];
    var matchAction = match.getAction(pointer, event, interaction, matchElement);

    if (!matchAction) {
      continue;
    }

    var action = validateAction(matchAction, match, matchElement, eventTarget, scope);

    if (action) {
      return {
        action: action,
        interactable: match,
        element: matchElement
      };
    }
  }

  return {
    action: null,
    interactable: null,
    element: null
  };
}

function getActionInfo(interaction, pointer, event, eventTarget, scope) {
  var matches = [];
  var matchElements = [];
  var element = eventTarget;

  function pushMatches(interactable) {
    matches.push(interactable);
    matchElements.push(element);
  }

  while (__utils_9.is.element(element)) {
    matches = [];
    matchElements = [];
    scope.interactables.forEachMatch(element, pushMatches);
    var actionInfo = validateMatches(interaction, pointer, event, matches, matchElements, eventTarget, scope);

    if (actionInfo.action && !actionInfo.interactable.options[actionInfo.action.name].manualStart) {
      return actionInfo;
    }

    element = __utils_9.dom.parentNode(element);
  }

  return {
    action: null,
    interactable: null,
    element: null
  };
}

function prepare(interaction, _ref4, scope) {
  var action = _ref4.action,
      interactable = _ref4.interactable,
      element = _ref4.element;
  action = action || {
    name: null
  };
  interaction.interactable = interactable;
  interaction.element = element;
  __utils_9.copyAction(interaction.prepared, action);
  interaction.rect = interactable && action.name ? interactable.getRect(element) : null;
  setInteractionCursor(interaction, scope);
  scope.fire('autoStart:prepared', {
    interaction: interaction
  });
}

function withinInteractionLimit(interactable, element, action, scope) {
  var options = interactable.options;
  var maxActions = options[action.name].max;
  var maxPerElement = options[action.name].maxPerElement;
  var autoStartMax = scope.autoStart.maxInteractions;
  var activeInteractions = 0;
  var interactableCount = 0;
  var elementCount = 0; // no actions if any of these values == 0

  if (!(maxActions && maxPerElement && autoStartMax)) {
    return false;
  }

  for (var _i = 0; _i < scope.interactions.list.length; _i++) {
    var _ref5;

    _ref5 = scope.interactions.list[_i];
    var interaction = _ref5;
    var otherAction = interaction.prepared.name;

    if (!interaction.interacting()) {
      continue;
    }

    activeInteractions++;

    if (activeInteractions >= autoStartMax) {
      return false;
    }

    if (interaction.interactable !== interactable) {
      continue;
    }

    interactableCount += otherAction === action.name ? 1 : 0;

    if (interactableCount >= maxActions) {
      return false;
    }

    if (interaction.element === element) {
      elementCount++;

      if (otherAction === action.name && elementCount >= maxPerElement) {
        return false;
      }
    }
  }

  return autoStartMax > 0;
}

function maxInteractions(newValue, scope) {
  if (__utils_9.is.number(newValue)) {
    scope.autoStart.maxInteractions = newValue;
    return this;
  }

  return scope.autoStart.maxInteractions;
}

function setCursor(element, cursor, scope) {
  var prevCursorElement = scope.autoStart.cursorElement;

  if (prevCursorElement && prevCursorElement !== element) {
    prevCursorElement.style.cursor = '';
  }

  element.ownerDocument.documentElement.style.cursor = cursor;
  element.style.cursor = cursor;
  scope.autoStart.cursorElement = cursor ? element : null;
}

function setInteractionCursor(interaction, scope) {
  var interactable = interaction.interactable,
      element = interaction.element,
      prepared = interaction.prepared;

  if (!(interaction.pointerType === 'mouse' && interactable && interactable.options.styleCursor)) {
    // clear previous target element cursor
    if (scope.autoStart.cursorElement) {
      setCursor(scope.autoStart.cursorElement, '', scope);
    }

    return;
  }

  var cursor = '';

  if (prepared.name) {
    var cursorChecker = interactable.options[prepared.name].cursorChecker;

    if (__utils_9.is.func(cursorChecker)) {
      cursor = cursorChecker(prepared, interactable, element, interaction._interacting);
    } else {
      cursor = scope.actions.map[prepared.name].getCursor(prepared);
    }
  }

  setCursor(interaction.element, cursor || '', scope);
}

var autoStart = {
  id: 'auto-start/base',
  before: ['actions', 'actions/drag', 'actions/resize', 'actions/gesture'],
  install: __install_9,
  listeners: {
    'interactions:down': prepareOnDown,
    'interactions:move': function interactionsMove(arg, scope) {
      prepareOnMove(arg, scope);
      startOnMove(arg, scope);
    },
    'interactions:stop': clearCursorOnStop
  },
  maxInteractions: maxInteractions,
  withinInteractionLimit: withinInteractionLimit,
  validateAction: validateAction
};
var ___default_9 = autoStart;
_$base_9["default"] = ___default_9;

var _$dragAxis_10 = {};
"use strict";

function ___typeof_10(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_10 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_10 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_10(obj); }

Object.defineProperty(_$dragAxis_10, "__esModule", {
  value: true
});
_$dragAxis_10["default"] = void 0;

/* removed: var _$domUtils_53 = require("@interactjs/utils/domUtils"); */;

var __is_10 = ___interopRequireWildcard_10(_$is_59);

var _base = ___interopRequireDefault_10(_$base_9);

function ___interopRequireDefault_10(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___getRequireWildcardCache_10() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_10 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_10(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_10(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_10(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function beforeStart(_ref, scope) {
  var interaction = _ref.interaction,
      eventTarget = _ref.eventTarget,
      dx = _ref.dx,
      dy = _ref.dy;

  if (interaction.prepared.name !== 'drag') {
    return;
  } // check if a drag is in the correct axis


  var absX = Math.abs(dx);
  var absY = Math.abs(dy);
  var targetOptions = interaction.interactable.options.drag;
  var startAxis = targetOptions.startAxis;
  var currentAxis = absX > absY ? 'x' : absX < absY ? 'y' : 'xy';
  interaction.prepared.axis = targetOptions.lockAxis === 'start' ? currentAxis[0] // always lock to one axis even if currentAxis === 'xy'
  : targetOptions.lockAxis; // if the movement isn't in the startAxis of the interactable

  if (currentAxis !== 'xy' && startAxis !== 'xy' && startAxis !== currentAxis) {
    // cancel the prepared action
    interaction.prepared.name = null; // then try to get a drag from another ineractable

    var element = eventTarget;

    var getDraggable = function getDraggable(interactable) {
      if (interactable === interaction.interactable) {
        return;
      }

      var options = interaction.interactable.options.drag;

      if (!options.manualStart && interactable.testIgnoreAllow(options, element, eventTarget)) {
        var action = interactable.getAction(interaction.downPointer, interaction.downEvent, interaction, element);

        if (action && action.name === 'drag' && checkStartAxis(currentAxis, interactable) && _base["default"].validateAction(action, interactable, element, eventTarget, scope)) {
          return interactable;
        }
      }
    }; // check all interactables


    while (__is_10.element(element)) {
      var interactable = scope.interactables.forEachMatch(element, getDraggable);

      if (interactable) {
        interaction.prepared.name = 'drag';
        interaction.interactable = interactable;
        interaction.element = element;
        break;
      }

      element = (0, _$domUtils_53.parentNode)(element);
    }
  }
}

function checkStartAxis(startAxis, interactable) {
  if (!interactable) {
    return false;
  }

  var thisAxis = interactable.options.drag.startAxis;
  return startAxis === 'xy' || thisAxis === 'xy' || thisAxis === startAxis;
}

var ___default_10 = {
  id: 'auto-start/dragAxis',
  listeners: {
    'autoStart:before-start': beforeStart
  }
};
_$dragAxis_10["default"] = ___default_10;

var _$hold_11 = {};
"use strict";

Object.defineProperty(_$hold_11, "__esModule", {
  value: true
});
_$hold_11["default"] = void 0;

var ___base_11 = ___interopRequireDefault_11(_$base_9);

function ___interopRequireDefault_11(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function __install_11(scope) {
  var defaults = scope.defaults;
  scope.usePlugin(___base_11["default"]);
  defaults.perAction.hold = 0;
  defaults.perAction.delay = 0;
}

function getHoldDuration(interaction) {
  var actionName = interaction.prepared && interaction.prepared.name;

  if (!actionName) {
    return null;
  }

  var options = interaction.interactable.options;
  return options[actionName].hold || options[actionName].delay;
}

var ___default_11 = {
  id: 'auto-start/hold',
  install: __install_11,
  listeners: {
    'interactions:new': function interactionsNew(_ref) {
      var interaction = _ref.interaction;
      interaction.autoStartHoldTimer = null;
    },
    'autoStart:prepared': function autoStartPrepared(_ref2) {
      var interaction = _ref2.interaction;
      var hold = getHoldDuration(interaction);

      if (hold > 0) {
        interaction.autoStartHoldTimer = setTimeout(function () {
          interaction.start(interaction.prepared, interaction.interactable, interaction.element);
        }, hold);
      }
    },
    'interactions:move': function interactionsMove(_ref3) {
      var interaction = _ref3.interaction,
          duplicate = _ref3.duplicate;

      if (interaction.pointerWasMoved && !duplicate) {
        clearTimeout(interaction.autoStartHoldTimer);
      }
    },
    // prevent regular down->move autoStart
    'autoStart:before-start': function autoStartBeforeStart(_ref4) {
      var interaction = _ref4.interaction;
      var hold = getHoldDuration(interaction);

      if (hold > 0) {
        interaction.prepared.name = null;
      }
    }
  },
  getHoldDuration: getHoldDuration
};
_$hold_11["default"] = ___default_11;

var _$index_12 = {};
"use strict";

Object.defineProperty(_$index_12, "__esModule", {
  value: true
});
Object.defineProperty(_$index_12, "autoStart", {
  enumerable: true,
  get: function get() {
    return ___base_12["default"];
  }
});
Object.defineProperty(_$index_12, "dragAxis", {
  enumerable: true,
  get: function get() {
    return _dragAxis["default"];
  }
});
Object.defineProperty(_$index_12, "hold", {
  enumerable: true,
  get: function get() {
    return _hold["default"];
  }
});
_$index_12["default"] = void 0;

var ___base_12 = ___interopRequireDefault_12(_$base_9);

var _dragAxis = ___interopRequireDefault_12(_$dragAxis_10);

var _hold = ___interopRequireDefault_12(_$hold_11);

function ___interopRequireDefault_12(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var ___default_12 = {
  id: 'auto-start',
  install: function install(scope) {
    scope.usePlugin(___base_12["default"]);
    scope.usePlugin(_hold["default"]);
    scope.usePlugin(_dragAxis["default"]);
  }
};
_$index_12["default"] = ___default_12;

var _$index_25 = {};
"use strict";

function ___typeof_25(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_25 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_25 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_25(obj); }

Object.defineProperty(_$index_25, "__esModule", {
  value: true
});
_$index_25["default"] = void 0;

var ___domObjects_25 = ___interopRequireDefault_25(_$domObjects_52);

/* removed: var _$domUtils_53 = require("@interactjs/utils/domUtils"); */;

var ___extend_25 = ___interopRequireDefault_25(_$extend_55);

var __is_25 = ___interopRequireWildcard_25(_$is_59);

var ___window_25 = ___interopRequireDefault_25(_$window_68);

function ___getRequireWildcardCache_25() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_25 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_25(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_25(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_25(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_25(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___toConsumableArray_25(arr) { return ___arrayWithoutHoles_25(arr) || ___iterableToArray_25(arr) || ___nonIterableSpread_25(); }

function ___nonIterableSpread_25() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function ___iterableToArray_25(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function ___arrayWithoutHoles_25(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

var CheckName;

(function (CheckName) {
  CheckName["touchAction"] = "touchAction";
  CheckName["boxSizing"] = "boxSizing";
  CheckName["noListeners"] = "noListeners";
})(CheckName || (CheckName = {}));

var prefix = '[interact.js] ';
var links = {
  touchAction: 'https://developer.mozilla.org/en-US/docs/Web/CSS/touch-action',
  boxSizing: 'https://developer.mozilla.org/en-US/docs/Web/CSS/box-sizing'
};
var isProduction = "production" === 'production'; // eslint-disable-next-line no-restricted-syntax

function __install_25(scope) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      logger = _ref.logger;

  var Interactable = scope.Interactable,
      defaults = scope.defaults;
  scope.logger = logger || console;
  defaults.base.devTools = {
    ignore: {}
  };

  Interactable.prototype.devTools = function (options) {
    if (options) {
      (0, ___extend_25["default"])(this.options.devTools, options);
      return this;
    }

    return this.options.devTools;
  };
}

var checks = [{
  name: CheckName.touchAction,
  perform: function perform(_ref2) {
    var element = _ref2.element;
    return !parentHasStyle(element, 'touchAction', /pan-|pinch|none/);
  },
  getInfo: function getInfo(_ref3) {
    var element = _ref3.element;
    return [element, links.touchAction];
  },
  text: 'Consider adding CSS "touch-action: none" to this element\n'
}, {
  name: CheckName.boxSizing,
  perform: function perform(interaction) {
    var element = interaction.element;
    return interaction.prepared.name === 'resize' && element instanceof ___domObjects_25["default"].HTMLElement && !hasStyle(element, 'boxSizing', /border-box/);
  },
  text: 'Consider adding CSS "box-sizing: border-box" to this resizable element',
  getInfo: function getInfo(_ref4) {
    var element = _ref4.element;
    return [element, links.boxSizing];
  }
}, {
  name: CheckName.noListeners,
  perform: function perform(interaction) {
    var actionName = interaction.prepared.name;
    var moveListeners = interaction.interactable.events.types["".concat(actionName, "move")] || [];
    return !moveListeners.length;
  },
  getInfo: function getInfo(interaction) {
    return [interaction.prepared.name, interaction.interactable];
  },
  text: 'There are no listeners set for this action'
}];

function hasStyle(element, prop, styleRe) {
  return styleRe.test(element.style[prop] || ___window_25["default"].window.getComputedStyle(element)[prop]);
}

function parentHasStyle(element, prop, styleRe) {
  var parent = element;

  while (__is_25.element(parent)) {
    if (hasStyle(parent, prop, styleRe)) {
      return true;
    }

    parent = (0, _$domUtils_53.parentNode)(parent);
  }

  return false;
}

var id = 'dev-tools';
var defaultExport = isProduction ? {
  id: id,
  install: function install() {}
} : {
  id: id,
  install: __install_25,
  listeners: {
    'interactions:action-start': function interactionsActionStart(_ref5, scope) {
      var interaction = _ref5.interaction;

      for (var _i = 0; _i < checks.length; _i++) {
        var _ref6;

        _ref6 = checks[_i];
        var check = _ref6;
        var options = interaction.interactable && interaction.interactable.options;

        if (!(options && options.devTools && options.devTools.ignore[check.name]) && check.perform(interaction)) {
          var _scope$logger;

          (_scope$logger = scope.logger).warn.apply(_scope$logger, [prefix + check.text].concat(___toConsumableArray_25(check.getInfo(interaction))));
        }
      }
    }
  },
  checks: checks,
  CheckName: CheckName,
  links: links,
  prefix: prefix
};
var ___default_25 = defaultExport;
_$index_25["default"] = ___default_25;

var _$Modification_29 = {};
"use strict";

function ___typeof_29(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_29 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_29 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_29(obj); }

Object.defineProperty(_$Modification_29, "__esModule", {
  value: true
});
_$Modification_29.getRectOffset = getRectOffset;
_$Modification_29["default"] = void 0;

var ___clone_29 = ___interopRequireDefault_29(_$clone_51);

var ___extend_29 = ___interopRequireDefault_29(_$extend_55);

var rectUtils = ___interopRequireWildcard_29(_$rect_65);

function ___getRequireWildcardCache_29() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_29 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_29(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_29(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_29(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_29(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___slicedToArray_29(arr, i) { return ___arrayWithHoles_29(arr) || ___iterableToArrayLimit_29(arr, i) || ___nonIterableRest_29(); }

function ___nonIterableRest_29() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function ___iterableToArrayLimit_29(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function ___arrayWithHoles_29(arr) { if (Array.isArray(arr)) return arr; }

function ___classCallCheck_29(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ___defineProperties_29(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ___createClass_29(Constructor, protoProps, staticProps) { if (protoProps) ___defineProperties_29(Constructor.prototype, protoProps); if (staticProps) ___defineProperties_29(Constructor, staticProps); return Constructor; }

function ___defineProperty_29(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Modification = /*#__PURE__*/function () {
  function Modification(interaction) {
    ___classCallCheck_29(this, Modification);

    this.interaction = interaction;

    ___defineProperty_29(this, "states", []);

    ___defineProperty_29(this, "startOffset", {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    });

    ___defineProperty_29(this, "startDelta", null);

    ___defineProperty_29(this, "result", null);

    ___defineProperty_29(this, "endResult", null);

    ___defineProperty_29(this, "edges", void 0);

    this.result = createResult();
  }

  ___createClass_29(Modification, [{
    key: "start",
    value: function start(_ref, pageCoords) {
      var phase = _ref.phase;
      var interaction = this.interaction;
      var modifierList = getModifierList(interaction);
      this.prepareStates(modifierList);
      this.edges = (0, ___extend_29["default"])({}, interaction.edges);
      this.startOffset = getRectOffset(interaction.rect, pageCoords);
      this.startDelta = {
        x: 0,
        y: 0
      };
      var arg = {
        phase: phase,
        pageCoords: pageCoords,
        preEnd: false
      };
      this.result = createResult();
      this.startAll(arg);
      var result = this.result = this.setAll(arg);
      return result;
    }
  }, {
    key: "fillArg",
    value: function fillArg(arg) {
      var interaction = this.interaction;
      arg.interaction = interaction;
      arg.interactable = interaction.interactable;
      arg.element = interaction.element;
      arg.rect = arg.rect || interaction.rect;
      arg.edges = this.edges;
      arg.startOffset = this.startOffset;
    }
  }, {
    key: "startAll",
    value: function startAll(arg) {
      this.fillArg(arg);

      for (var _i = 0; _i < this.states.length; _i++) {
        var _ref2;

        _ref2 = this.states[_i];
        var state = _ref2;

        if (state.methods.start) {
          arg.state = state;
          state.methods.start(arg);
        }
      }
    }
  }, {
    key: "setAll",
    value: function setAll(arg) {
      this.fillArg(arg);
      var phase = arg.phase,
          preEnd = arg.preEnd,
          skipModifiers = arg.skipModifiers,
          unmodifiedRect = arg.rect;
      arg.coords = (0, ___extend_29["default"])({}, arg.pageCoords);
      arg.rect = (0, ___extend_29["default"])({}, unmodifiedRect);
      var states = skipModifiers ? this.states.slice(skipModifiers) : this.states;
      var newResult = createResult(arg.coords, arg.rect);

      for (var _i2 = 0; _i2 < states.length; _i2++) {
        var _ref3;

        _ref3 = states[_i2];
        var state = _ref3;
        var options = state.options;
        var lastModifierCoords = (0, ___extend_29["default"])({}, arg.coords);
        var returnValue = null;

        if (state.methods.set && this.shouldDo(options, preEnd, phase)) {
          arg.state = state;
          returnValue = state.methods.set(arg);
          rectUtils.addEdges(this.interaction.edges, arg.rect, {
            x: arg.coords.x - lastModifierCoords.x,
            y: arg.coords.y - lastModifierCoords.y
          });
        }

        newResult.eventProps.push(returnValue);
      }

      newResult.delta.x = arg.coords.x - arg.pageCoords.x;
      newResult.delta.y = arg.coords.y - arg.pageCoords.y;
      newResult.rectDelta.left = arg.rect.left - unmodifiedRect.left;
      newResult.rectDelta.right = arg.rect.right - unmodifiedRect.right;
      newResult.rectDelta.top = arg.rect.top - unmodifiedRect.top;
      newResult.rectDelta.bottom = arg.rect.bottom - unmodifiedRect.bottom;
      var prevCoords = this.result.coords;
      var prevRect = this.result.rect;

      if (prevCoords && prevRect) {
        var rectChanged = newResult.rect.left !== prevRect.left || newResult.rect.right !== prevRect.right || newResult.rect.top !== prevRect.top || newResult.rect.bottom !== prevRect.bottom;
        newResult.changed = rectChanged || prevCoords.x !== newResult.coords.x || prevCoords.y !== newResult.coords.y;
      }

      return newResult;
    }
  }, {
    key: "applyToInteraction",
    value: function applyToInteraction(arg) {
      var interaction = this.interaction;
      var phase = arg.phase;
      var curCoords = interaction.coords.cur;
      var startCoords = interaction.coords.start;
      var result = this.result,
          startDelta = this.startDelta;
      var curDelta = result.delta;

      if (phase === 'start') {
        (0, ___extend_29["default"])(this.startDelta, result.delta);
      }

      for (var _i3 = 0; _i3 < [[startCoords, startDelta], [curCoords, curDelta]].length; _i3++) {
        var _ref4;

        _ref4 = [[startCoords, startDelta], [curCoords, curDelta]][_i3];

        var _ref5 = _ref4,
            _ref6 = ___slicedToArray_29(_ref5, 2),
            coordsSet = _ref6[0],
            delta = _ref6[1];

        coordsSet.page.x += delta.x;
        coordsSet.page.y += delta.y;
        coordsSet.client.x += delta.x;
        coordsSet.client.y += delta.y;
      }

      var rectDelta = this.result.rectDelta;
      var rect = arg.rect || interaction.rect;
      rect.left += rectDelta.left;
      rect.right += rectDelta.right;
      rect.top += rectDelta.top;
      rect.bottom += rectDelta.bottom;
      rect.width = rect.right - rect.left;
      rect.height = rect.bottom - rect.top;
    }
  }, {
    key: "setAndApply",
    value: function setAndApply(arg) {
      var interaction = this.interaction;
      var phase = arg.phase,
          preEnd = arg.preEnd,
          skipModifiers = arg.skipModifiers;
      var result = this.setAll({
        preEnd: preEnd,
        phase: phase,
        pageCoords: arg.modifiedCoords || interaction.coords.cur.page
      });
      this.result = result; // don't fire an action move if a modifier would keep the event in the same
      // cordinates as before

      if (!result.changed && (!skipModifiers || skipModifiers < this.states.length) && interaction.interacting()) {
        return false;
      }

      if (arg.modifiedCoords) {
        var page = interaction.coords.cur.page;
        var adjustment = {
          x: arg.modifiedCoords.x - page.x,
          y: arg.modifiedCoords.y - page.y
        };
        result.coords.x += adjustment.x;
        result.coords.y += adjustment.y;
        result.delta.x += adjustment.x;
        result.delta.y += adjustment.y;
      }

      this.applyToInteraction(arg);
    }
  }, {
    key: "beforeEnd",
    value: function beforeEnd(arg) {
      var interaction = arg.interaction,
          event = arg.event;
      var states = this.states;

      if (!states || !states.length) {
        return;
      }

      var doPreend = false;

      for (var _i4 = 0; _i4 < states.length; _i4++) {
        var _ref7;

        _ref7 = states[_i4];
        var state = _ref7;
        arg.state = state;
        var options = state.options,
            methods = state.methods;
        var endPosition = methods.beforeEnd && methods.beforeEnd(arg);

        if (endPosition) {
          this.endResult = endPosition;
          return false;
        }

        doPreend = doPreend || !doPreend && this.shouldDo(options, true, arg.phase, true);
      }

      if (doPreend) {
        // trigger a final modified move before ending
        interaction.move({
          event: event,
          preEnd: true
        });
      }
    }
  }, {
    key: "stop",
    value: function stop(arg) {
      var interaction = arg.interaction;

      if (!this.states || !this.states.length) {
        return;
      }

      var modifierArg = (0, ___extend_29["default"])({
        states: this.states,
        interactable: interaction.interactable,
        element: interaction.element,
        rect: null
      }, arg);
      this.fillArg(modifierArg);

      for (var _i5 = 0; _i5 < this.states.length; _i5++) {
        var _ref8;

        _ref8 = this.states[_i5];
        var state = _ref8;
        modifierArg.state = state;

        if (state.methods.stop) {
          state.methods.stop(modifierArg);
        }
      }

      this.states = null;
      this.endResult = null;
    }
  }, {
    key: "prepareStates",
    value: function prepareStates(modifierList) {
      this.states = [];

      for (var index = 0; index < modifierList.length; index++) {
        var _modifierList$index = modifierList[index],
            options = _modifierList$index.options,
            methods = _modifierList$index.methods,
            name = _modifierList$index.name;

        if (options && options.enabled === false) {
          continue;
        }

        this.states.push({
          options: options,
          methods: methods,
          index: index,
          name: name
        });
      }

      return this.states;
    }
  }, {
    key: "restoreInteractionCoords",
    value: function restoreInteractionCoords(_ref9) {
      var _ref9$interaction = _ref9.interaction,
          coords = _ref9$interaction.coords,
          rect = _ref9$interaction.rect,
          modification = _ref9$interaction.modification;

      if (!modification.result) {
        return;
      }

      var startDelta = modification.startDelta;
      var _modification$result = modification.result,
          curDelta = _modification$result.delta,
          rectDelta = _modification$result.rectDelta;
      var coordsAndDeltas = [[coords.start, startDelta], [coords.cur, curDelta]];

      for (var _i6 = 0; _i6 < coordsAndDeltas.length; _i6++) {
        var _ref10;

        _ref10 = coordsAndDeltas[_i6];

        var _ref11 = _ref10,
            _ref12 = ___slicedToArray_29(_ref11, 2),
            coordsSet = _ref12[0],
            delta = _ref12[1];

        coordsSet.page.x -= delta.x;
        coordsSet.page.y -= delta.y;
        coordsSet.client.x -= delta.x;
        coordsSet.client.y -= delta.y;
      }

      rect.left -= rectDelta.left;
      rect.right -= rectDelta.right;
      rect.top -= rectDelta.top;
      rect.bottom -= rectDelta.bottom;
    }
  }, {
    key: "shouldDo",
    value: function shouldDo(options, preEnd, phase, requireEndOnly) {
      if ( // ignore disabled modifiers
      !options || options.enabled === false || // check if we require endOnly option to fire move before end
      requireEndOnly && !options.endOnly || // don't apply endOnly modifiers when not ending
      options.endOnly && !preEnd || // check if modifier should run be applied on start
      phase === 'start' && !options.setStart) {
        return false;
      }

      return true;
    }
  }, {
    key: "copyFrom",
    value: function copyFrom(other) {
      this.startOffset = other.startOffset;
      this.startDelta = other.startDelta;
      this.edges = other.edges;
      this.states = other.states.map(function (s) {
        return (0, ___clone_29["default"])(s);
      });
      this.result = createResult((0, ___extend_29["default"])({}, other.result.coords), (0, ___extend_29["default"])({}, other.result.rect));
    }
  }, {
    key: "destroy",
    value: function destroy() {
      for (var prop in this) {
        this[prop] = null;
      }
    }
  }]);

  return Modification;
}();

_$Modification_29["default"] = Modification;

function createResult(coords, rect) {
  return {
    rect: rect,
    coords: coords,
    delta: {
      x: 0,
      y: 0
    },
    rectDelta: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    eventProps: [],
    changed: true
  };
}

function getModifierList(interaction) {
  var actionOptions = interaction.interactable.options[interaction.prepared.name];
  var actionModifiers = actionOptions.modifiers;

  if (actionModifiers && actionModifiers.length) {
    return actionModifiers.filter(function (modifier) {
      return !modifier.options || modifier.options.enabled !== false;
    });
  }

  return ['snap', 'snapSize', 'snapEdges', 'restrict', 'restrictEdges', 'restrictSize'].map(function (type) {
    var options = actionOptions[type];
    return options && options.enabled && {
      options: options,
      methods: options._methods
    };
  }).filter(function (m) {
    return !!m;
  });
}

function getRectOffset(rect, coords) {
  return rect ? {
    left: coords.x - rect.left,
    top: coords.y - rect.top,
    right: rect.right - coords.x,
    bottom: rect.bottom - coords.y
  } : {
    left: 0,
    top: 0,
    right: 0,
    bottom: 0
  };
}

var _$base_32 = {};
"use strict";

Object.defineProperty(_$base_32, "__esModule", {
  value: true
});
_$base_32.makeModifier = makeModifier;
_$base_32.addEventModifiers = addEventModifiers;
_$base_32["default"] = void 0;

var _Modification = ___interopRequireDefault_32(_$Modification_29);

function ___interopRequireDefault_32(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function makeModifier(module, name) {
  var defaults = module.defaults;
  var methods = {
    start: module.start,
    set: module.set,
    beforeEnd: module.beforeEnd,
    stop: module.stop
  };

  var modifier = function modifier(_options) {
    var options = _options || {};
    options.enabled = options.enabled !== false; // add missing defaults to options

    for (var _prop in defaults) {
      if (!(_prop in options)) {
        options[_prop] = defaults[_prop];
      }
    }

    var m = {
      options: options,
      methods: methods,
      name: name
    };
    return m;
  };

  if (name && typeof name === 'string') {
    // for backwrads compatibility
    modifier._defaults = defaults;
    modifier._methods = methods;
  }

  return modifier;
}

function addEventModifiers(_ref) {
  var iEvent = _ref.iEvent,
      result = _ref.interaction.modification.result;

  if (result) {
    iEvent.modifiers = result.eventProps;
  }
}

var modifiersBase = {
  id: 'modifiers/base',
  install: function install(scope) {
    scope.defaults.perAction.modifiers = [];
  },
  listeners: {
    'interactions:new': function interactionsNew(_ref2) {
      var interaction = _ref2.interaction;
      interaction.modification = new _Modification["default"](interaction);
    },
    'interactions:before-action-start': function interactionsBeforeActionStart(arg) {
      var modification = arg.interaction.modification;
      modification.start(arg, arg.interaction.coords.start.page);
      arg.interaction.edges = modification.edges;
      modification.applyToInteraction(arg);
    },
    'interactions:before-action-move': function interactionsBeforeActionMove(arg) {
      return arg.interaction.modification.setAndApply(arg);
    },
    'interactions:before-action-end': function interactionsBeforeActionEnd(arg) {
      return arg.interaction.modification.beforeEnd(arg);
    },
    'interactions:action-start': addEventModifiers,
    'interactions:action-move': addEventModifiers,
    'interactions:action-end': addEventModifiers,
    'interactions:after-action-start': function interactionsAfterActionStart(arg) {
      return arg.interaction.modification.restoreInteractionCoords(arg);
    },
    'interactions:after-action-move': function interactionsAfterActionMove(arg) {
      return arg.interaction.modification.restoreInteractionCoords(arg);
    },
    'interactions:stop': function interactionsStop(arg) {
      return arg.interaction.modification.stop(arg);
    }
  },
  before: ['actions', 'action/drag', 'actions/resize', 'actions/gesture']
};
var ___default_32 = modifiersBase;
_$base_32["default"] = ___default_32;

var _$index_41 = {};
"use strict";

function ___typeof_41(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_41 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_41 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_41(obj); }

Object.defineProperty(_$index_41, "__esModule", {
  value: true
});
_$index_41.addTotal = addTotal;
_$index_41.applyPending = applyPending;
_$index_41["default"] = void 0;

/* removed: var _$Interaction_18 = require("@interactjs/core/Interaction"); */;

var __rectUtils_41 = ___interopRequireWildcard_41(_$rect_65);

function ___getRequireWildcardCache_41() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_41 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_41(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_41(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_41(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

_$Interaction_18._ProxyMethods.offsetBy = '';

function addTotal(interaction) {
  if (!interaction.pointerIsDown) {
    return;
  }

  addToCoords(interaction.coords.cur, interaction.offset.total);
  interaction.offset.pending.x = 0;
  interaction.offset.pending.y = 0;
}

function beforeAction(_ref) {
  var interaction = _ref.interaction;
  applyPending(interaction);
}

function beforeEnd(_ref2) {
  var interaction = _ref2.interaction;
  var hadPending = applyPending(interaction);

  if (!hadPending) {
    return;
  }

  interaction.move({
    offset: true
  });
  interaction.end();
  return false;
}

function __end_41(_ref3) {
  var interaction = _ref3.interaction;
  interaction.offset.total.x = 0;
  interaction.offset.total.y = 0;
  interaction.offset.pending.x = 0;
  interaction.offset.pending.y = 0;
}

function applyPending(interaction) {
  if (!hasPending(interaction)) {
    return false;
  }

  var pending = interaction.offset.pending;
  addToCoords(interaction.coords.cur, pending);
  addToCoords(interaction.coords.delta, pending);
  __rectUtils_41.addEdges(interaction.edges, interaction.rect, pending);
  pending.x = 0;
  pending.y = 0;
  return true;
}

function offsetBy(_ref4) {
  var x = _ref4.x,
      y = _ref4.y;
  this.offset.pending.x += x;
  this.offset.pending.y += y;
  this.offset.total.x += x;
  this.offset.total.y += y;
}

function addToCoords(_ref5, _ref6) {
  var page = _ref5.page,
      client = _ref5.client;
  var x = _ref6.x,
      y = _ref6.y;
  page.x += x;
  page.y += y;
  client.x += x;
  client.y += y;
}

function hasPending(interaction) {
  return !!(interaction.offset.pending.x || interaction.offset.pending.y);
}

var offset = {
  id: 'offset',
  install: function install(scope) {
    scope.Interaction.prototype.offsetBy = offsetBy;
  },
  listeners: {
    'interactions:new': function interactionsNew(_ref7) {
      var interaction = _ref7.interaction;
      interaction.offset = {
        total: {
          x: 0,
          y: 0
        },
        pending: {
          x: 0,
          y: 0
        }
      };
    },
    'interactions:update-pointer': function interactionsUpdatePointer(_ref8) {
      var interaction = _ref8.interaction;
      return addTotal(interaction);
    },
    'interactions:before-action-start': beforeAction,
    'interactions:before-action-move': beforeAction,
    'interactions:before-action-end': beforeEnd,
    'interactions:stop': __end_41
  }
};
var ___default_41 = offset;
_$index_41["default"] = ___default_41;

var _$index_26 = {};
"use strict";

function ___typeof_26(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_26 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_26 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_26(obj); }

Object.defineProperty(_$index_26, "__esModule", {
  value: true
});
_$index_26["default"] = _$index_26.InertiaState = void 0;

var modifiers = ___interopRequireWildcard_26(_$base_32);

var ___Modification_26 = ___interopRequireDefault_26(_$Modification_29);

var ___index_26 = ___interopRequireDefault_26(_$index_41);

var __dom_26 = ___interopRequireWildcard_26(_$domUtils_53);

var ___hypot_26 = ___interopRequireDefault_26(_$hypot_57);

var __is_26 = ___interopRequireWildcard_26(_$is_59);

/* removed: var _$pointerUtils_63 = require("@interactjs/utils/pointerUtils"); */;

var ___raf_26 = ___interopRequireDefault_26(_$raf_64);

function ___interopRequireDefault_26(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___getRequireWildcardCache_26() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_26 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_26(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_26(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_26(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___classCallCheck_26(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ___defineProperties_26(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ___createClass_26(Constructor, protoProps, staticProps) { if (protoProps) ___defineProperties_26(Constructor.prototype, protoProps); if (staticProps) ___defineProperties_26(Constructor, staticProps); return Constructor; }

function ___defineProperty_26(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function __install_26(scope) {
  var defaults = scope.defaults;
  scope.usePlugin(___index_26["default"]);
  scope.usePlugin(modifiers["default"]);
  scope.actions.phases.inertiastart = true;
  scope.actions.phases.resume = true;
  defaults.perAction.inertia = {
    enabled: false,
    resistance: 10,
    // the lambda in exponential decay
    minSpeed: 100,
    // target speed must be above this for inertia to start
    endSpeed: 10,
    // the speed at which inertia is slow enough to stop
    allowResume: true,
    // allow resuming an action in inertia phase
    smoothEndDuration: 300 // animate to snap/restrict endOnly if there's no inertia

  };
}

var InertiaState = /*#__PURE__*/function () {
  // eslint-disable-line camelcase
  // eslint-disable-line camelcase
  function InertiaState(interaction) {
    ___classCallCheck_26(this, InertiaState);

    this.interaction = interaction;

    ___defineProperty_26(this, "active", false);

    ___defineProperty_26(this, "isModified", false);

    ___defineProperty_26(this, "smoothEnd", false);

    ___defineProperty_26(this, "allowResume", false);

    ___defineProperty_26(this, "modification", null);

    ___defineProperty_26(this, "modifierCount", 0);

    ___defineProperty_26(this, "modifierArg", null);

    ___defineProperty_26(this, "startCoords", null);

    ___defineProperty_26(this, "t0", 0);

    ___defineProperty_26(this, "v0", 0);

    ___defineProperty_26(this, "te", 0);

    ___defineProperty_26(this, "targetOffset", null);

    ___defineProperty_26(this, "modifiedOffset", null);

    ___defineProperty_26(this, "currentOffset", null);

    ___defineProperty_26(this, "lambda_v0", 0);

    ___defineProperty_26(this, "one_ve_v0", 0);

    ___defineProperty_26(this, "timeout", null);
  }

  ___createClass_26(InertiaState, [{
    key: "start",
    value: function start(event) {
      var interaction = this.interaction;
      var options = __getOptions_26(interaction);

      if (!options || !options.enabled) {
        return false;
      }

      var velocityClient = interaction.coords.velocity.client;
      var pointerSpeed = (0, ___hypot_26["default"])(velocityClient.x, velocityClient.y);
      var modification = this.modification || (this.modification = new ___Modification_26["default"](interaction));
      modification.copyFrom(interaction.modification);
      this.t0 = interaction._now();
      this.allowResume = options.allowResume;
      this.v0 = pointerSpeed;
      this.currentOffset = {
        x: 0,
        y: 0
      };
      this.startCoords = interaction.coords.cur.page;
      this.modifierArg = {
        interaction: interaction,
        interactable: interaction.interactable,
        element: interaction.element,
        rect: interaction.rect,
        edges: interaction.edges,
        pageCoords: this.startCoords,
        preEnd: true,
        phase: 'inertiastart'
      };
      var thrown = this.t0 - interaction.coords.cur.timeStamp < 50 && pointerSpeed > options.minSpeed && pointerSpeed > options.endSpeed;

      if (thrown) {
        this.startInertia();
      } else {
        modification.result = modification.setAll(this.modifierArg);

        if (!modification.result.changed) {
          return false;
        }

        this.startSmoothEnd();
      } // force modification change


      interaction.modification.result.rect = null; // bring inertiastart event to the target coords

      interaction.offsetBy(this.targetOffset);

      interaction._doPhase({
        interaction: interaction,
        event: event,
        phase: 'inertiastart'
      });

      interaction.offsetBy({
        x: -this.targetOffset.x,
        y: -this.targetOffset.y
      }); // force modification change

      interaction.modification.result.rect = null;
      this.active = true;
      interaction.simulation = this;
      return true;
    }
  }, {
    key: "startInertia",
    value: function startInertia() {
      var _this = this;

      var startVelocity = this.interaction.coords.velocity.client;
      var options = __getOptions_26(this.interaction);
      var lambda = options.resistance;
      var inertiaDur = -Math.log(options.endSpeed / this.v0) / lambda;
      this.targetOffset = {
        x: (startVelocity.x - inertiaDur) / lambda,
        y: (startVelocity.y - inertiaDur) / lambda
      };
      this.te = inertiaDur;
      this.lambda_v0 = lambda / this.v0;
      this.one_ve_v0 = 1 - options.endSpeed / this.v0;
      var modification = this.modification,
          modifierArg = this.modifierArg;
      modifierArg.pageCoords = {
        x: this.startCoords.x + this.targetOffset.x,
        y: this.startCoords.y + this.targetOffset.y
      };
      modification.result = modification.setAll(modifierArg);

      if (modification.result.changed) {
        this.isModified = true;
        this.modifiedOffset = {
          x: this.targetOffset.x + modification.result.delta.x,
          y: this.targetOffset.y + modification.result.delta.y
        };
      }

      this.timeout = ___raf_26["default"].request(function () {
        return _this.inertiaTick();
      });
    }
  }, {
    key: "startSmoothEnd",
    value: function startSmoothEnd() {
      var _this2 = this;

      this.smoothEnd = true;
      this.isModified = true;
      this.targetOffset = {
        x: this.modification.result.delta.x,
        y: this.modification.result.delta.y
      };
      this.timeout = ___raf_26["default"].request(function () {
        return _this2.smoothEndTick();
      });
    }
  }, {
    key: "inertiaTick",
    value: function inertiaTick() {
      var _this3 = this;

      var interaction = this.interaction;
      var options = __getOptions_26(interaction);
      var lambda = options.resistance;
      var t = (interaction._now() - this.t0) / 1000;

      if (t < this.te) {
        var progress = 1 - (Math.exp(-lambda * t) - this.lambda_v0) / this.one_ve_v0;
        var newOffset;

        if (this.isModified) {
          newOffset = getQuadraticCurvePoint(0, 0, this.targetOffset.x, this.targetOffset.y, this.modifiedOffset.x, this.modifiedOffset.y, progress);
        } else {
          newOffset = {
            x: this.targetOffset.x * progress,
            y: this.targetOffset.y * progress
          };
        }

        var delta = {
          x: newOffset.x - this.currentOffset.x,
          y: newOffset.y - this.currentOffset.y
        };
        this.currentOffset.x += delta.x;
        this.currentOffset.y += delta.y;
        interaction.offsetBy(delta);
        interaction.move();
        this.timeout = ___raf_26["default"].request(function () {
          return _this3.inertiaTick();
        });
      } else {
        interaction.offsetBy({
          x: this.modifiedOffset.x - this.currentOffset.x,
          y: this.modifiedOffset.y - this.currentOffset.y
        });
        this.end();
      }
    }
  }, {
    key: "smoothEndTick",
    value: function smoothEndTick() {
      var _this4 = this;

      var interaction = this.interaction;
      var t = interaction._now() - this.t0;

      var _getOptions = __getOptions_26(interaction),
          duration = _getOptions.smoothEndDuration;

      if (t < duration) {
        var newOffset = {
          x: easeOutQuad(t, 0, this.targetOffset.x, duration),
          y: easeOutQuad(t, 0, this.targetOffset.y, duration)
        };
        var delta = {
          x: newOffset.x - this.currentOffset.x,
          y: newOffset.y - this.currentOffset.y
        };
        this.currentOffset.x += delta.x;
        this.currentOffset.y += delta.y;
        interaction.offsetBy(delta);
        interaction.move({
          skipModifiers: this.modifierCount
        });
        this.timeout = ___raf_26["default"].request(function () {
          return _this4.smoothEndTick();
        });
      } else {
        interaction.offsetBy({
          x: this.targetOffset.x - this.currentOffset.x,
          y: this.targetOffset.y - this.currentOffset.y
        });
        this.end();
      }
    }
  }, {
    key: "resume",
    value: function resume(_ref) {
      var pointer = _ref.pointer,
          event = _ref.event,
          eventTarget = _ref.eventTarget;
      var interaction = this.interaction; // undo inertia changes to interaction coords

      interaction.offsetBy({
        x: -this.currentOffset.x,
        y: -this.currentOffset.y
      }); // update pointer at pointer down position

      interaction.updatePointer(pointer, event, eventTarget, true); // fire resume signals and event

      interaction._doPhase({
        interaction: interaction,
        event: event,
        phase: 'resume'
      });

      (0, _$pointerUtils_63.copyCoords)(interaction.coords.prev, interaction.coords.cur);
      this.stop();
    }
  }, {
    key: "end",
    value: function end() {
      this.interaction.move();
      this.interaction.end();
      this.stop();
    }
  }, {
    key: "stop",
    value: function stop() {
      this.active = this.smoothEnd = false;
      this.interaction.simulation = null;

      ___raf_26["default"].cancel(this.timeout);
    }
  }]);

  return InertiaState;
}();

_$index_26.InertiaState = InertiaState;

function __start_26(_ref2) {
  var interaction = _ref2.interaction,
      event = _ref2.event;

  if (!interaction._interacting || interaction.simulation) {
    return null;
  }

  var started = interaction.inertia.start(event); // prevent action end if inertia or smoothEnd

  return started ? false : null;
} // Check if the down event hits the current inertia target
// control should be return to the user


function resume(arg) {
  var interaction = arg.interaction,
      eventTarget = arg.eventTarget;
  var state = interaction.inertia;

  if (!state.active) {
    return;
  }

  var element = eventTarget; // climb up the DOM tree from the event target

  while (__is_26.element(element)) {
    // if interaction element is the current inertia target element
    if (element === interaction.element) {
      state.resume(arg);
      break;
    }

    element = __dom_26.parentNode(element);
  }
}

function stop(_ref3) {
  var interaction = _ref3.interaction;
  var state = interaction.inertia;

  if (state.active) {
    state.stop();
  }
}

function __getOptions_26(_ref4) {
  var interactable = _ref4.interactable,
      prepared = _ref4.prepared;
  return interactable && interactable.options && prepared.name && interactable.options[prepared.name].inertia;
}

var inertia = {
  id: 'inertia',
  before: ['modifiers/base'],
  install: __install_26,
  listeners: {
    'interactions:new': function interactionsNew(_ref5) {
      var interaction = _ref5.interaction;
      interaction.inertia = new InertiaState(interaction);
    },
    'interactions:before-action-end': __start_26,
    'interactions:down': resume,
    'interactions:stop': stop,
    'interactions:before-action-resume': function interactionsBeforeActionResume(arg) {
      var modification = arg.interaction.modification;
      modification.stop(arg);
      modification.start(arg, arg.interaction.coords.cur.page);
      modification.applyToInteraction(arg);
    },
    'interactions:before-action-inertiastart': function interactionsBeforeActionInertiastart(arg) {
      return arg.interaction.modification.setAndApply(arg);
    },
    'interactions:action-resume': modifiers.addEventModifiers,
    'interactions:action-inertiastart': modifiers.addEventModifiers,
    'interactions:after-action-inertiastart': function interactionsAfterActionInertiastart(arg) {
      return arg.interaction.modification.restoreInteractionCoords(arg);
    },
    'interactions:after-action-resume': function interactionsAfterActionResume(arg) {
      return arg.interaction.modification.restoreInteractionCoords(arg);
    }
  }
}; // http://stackoverflow.com/a/5634528/2280888

function _getQBezierValue(t, p1, p2, p3) {
  var iT = 1 - t;
  return iT * iT * p1 + 2 * iT * t * p2 + t * t * p3;
}

function getQuadraticCurvePoint(startX, startY, cpX, cpY, endX, endY, position) {
  return {
    x: _getQBezierValue(position, startX, cpX, endX),
    y: _getQBezierValue(position, startY, cpY, endY)
  };
} // http://gizma.com/easing/


function easeOutQuad(t, b, c, d) {
  t /= d;
  return -c * t * (t - 2) + b;
}

var ___default_26 = inertia;
_$index_26["default"] = ___default_26;

var _$aspectRatio_31 = {};
"use strict";

Object.defineProperty(_$aspectRatio_31, "__esModule", {
  value: true
});
_$aspectRatio_31.aspectRatio = _$aspectRatio_31["default"] = void 0;

var ___extend_31 = ___interopRequireDefault_31(_$extend_55);

/* removed: var _$rect_65 = require("@interactjs/utils/rect"); */;

var ___Modification_31 = ___interopRequireDefault_31(_$Modification_29);

/* removed: var _$base_32 = require("./base"); */;

function ___interopRequireDefault_31(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { ___defineProperty_31(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function ___defineProperty_31(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var aspectRatio = {
  start: function start(arg) {
    var state = arg.state,
        rect = arg.rect,
        originalEdges = arg.edges,
        coords = arg.pageCoords;
    var ratio = state.options.ratio;
    var _state$options = state.options,
        equalDelta = _state$options.equalDelta,
        modifiers = _state$options.modifiers;

    if (ratio === 'preserve') {
      ratio = rect.width / rect.height;
    }

    state.startCoords = (0, ___extend_31["default"])({}, coords);
    state.startRect = (0, ___extend_31["default"])({}, rect);
    state.ratio = ratio;
    state.equalDelta = equalDelta;
    var linkedEdges = state.linkedEdges = {
      top: originalEdges.top || originalEdges.left && !originalEdges.bottom,
      left: originalEdges.left || originalEdges.top && !originalEdges.right,
      bottom: originalEdges.bottom || originalEdges.right && !originalEdges.top,
      right: originalEdges.right || originalEdges.bottom && !originalEdges.left
    };
    state.xIsPrimaryAxis = !!(originalEdges.left || originalEdges.right);

    if (state.equalDelta) {
      state.edgeSign = (linkedEdges.left ? 1 : -1) * (linkedEdges.top ? 1 : -1);
    } else {
      var negativeSecondaryEdge = state.xIsPrimaryAxis ? linkedEdges.top : linkedEdges.left;
      state.edgeSign = negativeSecondaryEdge ? -1 : 1;
    }

    (0, ___extend_31["default"])(arg.edges, linkedEdges);

    if (!modifiers || !modifiers.length) {
      return;
    }

    var subModification = new ___Modification_31["default"](arg.interaction);
    subModification.copyFrom(arg.interaction.modification);
    subModification.prepareStates(modifiers);
    state.subModification = subModification;
    subModification.startAll(_objectSpread({}, arg));
  },
  set: function set(arg) {
    var state = arg.state,
        rect = arg.rect,
        coords = arg.coords;
    var initialCoords = (0, ___extend_31["default"])({}, coords);
    var aspectMethod = state.equalDelta ? setEqualDelta : setRatio;
    aspectMethod(state, state.xIsPrimaryAxis, coords, rect);

    if (!state.subModification) {
      return null;
    }

    var correctedRect = (0, ___extend_31["default"])({}, rect);
    (0, _$rect_65.addEdges)(state.linkedEdges, correctedRect, {
      x: coords.x - initialCoords.x,
      y: coords.y - initialCoords.y
    });
    var result = state.subModification.setAll(_objectSpread({}, arg, {
      rect: correctedRect,
      edges: state.linkedEdges,
      pageCoords: coords,
      prevCoords: coords,
      prevRect: correctedRect
    }));
    var delta = result.delta;

    if (result.changed) {
      var xIsCriticalAxis = Math.abs(delta.x) > Math.abs(delta.y); // do aspect modification again with critical edge axis as primary

      aspectMethod(state, xIsCriticalAxis, result.coords, result.rect);
      (0, ___extend_31["default"])(coords, result.coords);
    }

    return result.eventProps;
  },
  defaults: {
    ratio: 'preserve',
    equalDelta: false,
    modifiers: [],
    enabled: false
  }
};
_$aspectRatio_31.aspectRatio = aspectRatio;

function setEqualDelta(_ref, xIsPrimaryAxis, coords) {
  var startCoords = _ref.startCoords,
      edgeSign = _ref.edgeSign;

  if (xIsPrimaryAxis) {
    coords.y = startCoords.y + (coords.x - startCoords.x) * edgeSign;
  } else {
    coords.x = startCoords.x + (coords.y - startCoords.y) * edgeSign;
  }
}

function setRatio(_ref2, xIsPrimaryAxis, coords, rect) {
  var startRect = _ref2.startRect,
      startCoords = _ref2.startCoords,
      ratio = _ref2.ratio,
      edgeSign = _ref2.edgeSign;

  if (xIsPrimaryAxis) {
    var newHeight = rect.width / ratio;
    coords.y = startCoords.y + (newHeight - startRect.height) * edgeSign;
  } else {
    var newWidth = rect.height * ratio;
    coords.x = startCoords.x + (newWidth - startRect.width) * edgeSign;
  }
}

var ___default_31 = (0, _$base_32.makeModifier)(aspectRatio, 'aspectRatio');

_$aspectRatio_31["default"] = ___default_31;

var _$pointer_35 = {};
"use strict";

function ___typeof_35(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_35 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_35 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_35(obj); }

Object.defineProperty(_$pointer_35, "__esModule", {
  value: true
});
_$pointer_35.getRestrictionRect = getRestrictionRect;
_$pointer_35.restrict = _$pointer_35["default"] = void 0;

var ___extend_35 = ___interopRequireDefault_35(_$extend_55);

var __is_35 = ___interopRequireWildcard_35(_$is_59);

var __rectUtils_35 = ___interopRequireWildcard_35(_$rect_65);

/* removed: var _$base_32 = require("../base"); */;

function ___getRequireWildcardCache_35() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_35 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_35(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_35(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_35(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_35(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function __start_35(_ref) {
  var rect = _ref.rect,
      startOffset = _ref.startOffset,
      state = _ref.state,
      interaction = _ref.interaction,
      pageCoords = _ref.pageCoords;
  var options = state.options;
  var elementRect = options.elementRect;
  var offset = (0, ___extend_35["default"])({
    left: 0,
    top: 0,
    right: 0,
    bottom: 0
  }, options.offset || {});

  if (rect && elementRect) {
    var restriction = getRestrictionRect(options.restriction, interaction, pageCoords);

    if (restriction) {
      var widthDiff = restriction.right - restriction.left - rect.width;
      var heightDiff = restriction.bottom - restriction.top - rect.height;

      if (widthDiff < 0) {
        offset.left += widthDiff;
        offset.right += widthDiff;
      }

      if (heightDiff < 0) {
        offset.top += heightDiff;
        offset.bottom += heightDiff;
      }
    }

    offset.left += startOffset.left - rect.width * elementRect.left;
    offset.top += startOffset.top - rect.height * elementRect.top;
    offset.right += startOffset.right - rect.width * (1 - elementRect.right);
    offset.bottom += startOffset.bottom - rect.height * (1 - elementRect.bottom);
  }

  state.offset = offset;
}

function set(_ref2) {
  var coords = _ref2.coords,
      interaction = _ref2.interaction,
      state = _ref2.state;
  var options = state.options,
      offset = state.offset;
  var restriction = getRestrictionRect(options.restriction, interaction, coords);

  if (!restriction) {
    return;
  }

  var rect = __rectUtils_35.xywhToTlbr(restriction);
  coords.x = Math.max(Math.min(rect.right - offset.right, coords.x), rect.left + offset.left);
  coords.y = Math.max(Math.min(rect.bottom - offset.bottom, coords.y), rect.top + offset.top);
}

function getRestrictionRect(value, interaction, coords) {
  if (__is_35.func(value)) {
    return __rectUtils_35.resolveRectLike(value, interaction.interactable, interaction.element, [coords.x, coords.y, interaction]);
  } else {
    return __rectUtils_35.resolveRectLike(value, interaction.interactable, interaction.element);
  }
}

var __defaults_35 = {
  restriction: null,
  elementRect: null,
  offset: null,
  endOnly: false,
  enabled: false
};
var restrict = {
  start: __start_35,
  set: set,
  defaults: __defaults_35
};
_$pointer_35.restrict = restrict;

var ___default_35 = (0, _$base_32.makeModifier)(restrict, 'restrict');

_$pointer_35["default"] = ___default_35;

var _$edges_34 = {};
"use strict";

function ___typeof_34(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_34 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_34 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_34(obj); }

Object.defineProperty(_$edges_34, "__esModule", {
  value: true
});
_$edges_34.restrictEdges = _$edges_34["default"] = void 0;

var ___extend_34 = ___interopRequireDefault_34(_$extend_55);

var __rectUtils_34 = ___interopRequireWildcard_34(_$rect_65);

/* removed: var _$base_32 = require("../base"); */;

/* removed: var _$pointer_35 = require("./pointer"); */;

function ___getRequireWildcardCache_34() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_34 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_34(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_34(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_34(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_34(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

// This module adds the options.resize.restrictEdges setting which sets min and
// max for the top, left, bottom and right edges of the target being resized.
//
// interact(target).resize({
//   edges: { top: true, left: true },
//   restrictEdges: {
//     inner: { top: 200, left: 200, right: 400, bottom: 400 },
//     outer: { top:   0, left:   0, right: 600, bottom: 600 },
//   },
// })
var noInner = {
  top: +Infinity,
  left: +Infinity,
  bottom: -Infinity,
  right: -Infinity
};
var noOuter = {
  top: -Infinity,
  left: -Infinity,
  bottom: +Infinity,
  right: +Infinity
};

function __start_34(_ref) {
  var interaction = _ref.interaction,
      startOffset = _ref.startOffset,
      state = _ref.state;
  var options = state.options;
  var offset;

  if (options) {
    var offsetRect = (0, _$pointer_35.getRestrictionRect)(options.offset, interaction, interaction.coords.start.page);
    offset = __rectUtils_34.rectToXY(offsetRect);
  }

  offset = offset || {
    x: 0,
    y: 0
  };
  state.offset = {
    top: offset.y + startOffset.top,
    left: offset.x + startOffset.left,
    bottom: offset.y - startOffset.bottom,
    right: offset.x - startOffset.right
  };
}

function __set_34(_ref2) {
  var coords = _ref2.coords,
      edges = _ref2.edges,
      interaction = _ref2.interaction,
      state = _ref2.state;
  var offset = state.offset,
      options = state.options;

  if (!edges) {
    return;
  }

  var page = (0, ___extend_34["default"])({}, coords);
  var inner = (0, _$pointer_35.getRestrictionRect)(options.inner, interaction, page) || {};
  var outer = (0, _$pointer_35.getRestrictionRect)(options.outer, interaction, page) || {};
  fixRect(inner, noInner);
  fixRect(outer, noOuter);

  if (edges.top) {
    coords.y = Math.min(Math.max(outer.top + offset.top, page.y), inner.top + offset.top);
  } else if (edges.bottom) {
    coords.y = Math.max(Math.min(outer.bottom + offset.bottom, page.y), inner.bottom + offset.bottom);
  }

  if (edges.left) {
    coords.x = Math.min(Math.max(outer.left + offset.left, page.x), inner.left + offset.left);
  } else if (edges.right) {
    coords.x = Math.max(Math.min(outer.right + offset.right, page.x), inner.right + offset.right);
  }
}

function fixRect(rect, defaults) {
  var _arr = ['top', 'left', 'bottom', 'right'];

  for (var _i = 0; _i < _arr.length; _i++) {
    var edge = _arr[_i];

    if (!(edge in rect)) {
      rect[edge] = defaults[edge];
    }
  }

  return rect;
}

var __defaults_34 = {
  inner: null,
  outer: null,
  offset: null,
  endOnly: false,
  enabled: false
};
var restrictEdges = {
  noInner: noInner,
  noOuter: noOuter,
  start: __start_34,
  set: __set_34,
  defaults: __defaults_34
};
_$edges_34.restrictEdges = restrictEdges;

var ___default_34 = (0, _$base_32.makeModifier)(restrictEdges, 'restrictEdges');

_$edges_34["default"] = ___default_34;

var _$rect_36 = {};
"use strict";

Object.defineProperty(_$rect_36, "__esModule", {
  value: true
});
_$rect_36.restrictRect = _$rect_36["default"] = void 0;

var ___extend_36 = ___interopRequireDefault_36(_$extend_55);

/* removed: var _$pointer_35 = require("./pointer"); */;

/* removed: var _$base_32 = require("../base"); */;

function ___interopRequireDefault_36(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var __defaults_36 = (0, ___extend_36["default"])({
  get elementRect() {
    return {
      top: 0,
      left: 0,
      bottom: 1,
      right: 1
    };
  },

  set elementRect(_) {}

}, _$pointer_35.restrict.defaults);
var restrictRect = {
  start: _$pointer_35.restrict.start,
  set: _$pointer_35.restrict.set,
  defaults: __defaults_36
};
_$rect_36.restrictRect = restrictRect;

var ___default_36 = (0, _$base_32.makeModifier)(restrictRect, 'restrictRect');

_$rect_36["default"] = ___default_36;

var _$size_37 = {};
"use strict";

function ___typeof_37(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_37 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_37 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_37(obj); }

Object.defineProperty(_$size_37, "__esModule", {
  value: true
});
_$size_37.restrictSize = _$size_37["default"] = void 0;

var ___extend_37 = ___interopRequireDefault_37(_$extend_55);

var __rectUtils_37 = ___interopRequireWildcard_37(_$rect_65);

/* removed: var _$base_32 = require("../base"); */;

/* removed: var _$edges_34 = require("./edges"); */;

/* removed: var _$pointer_35 = require("./pointer"); */;

function ___getRequireWildcardCache_37() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_37 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_37(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_37(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_37(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_37(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var noMin = {
  width: -Infinity,
  height: -Infinity
};
var noMax = {
  width: +Infinity,
  height: +Infinity
};

function __start_37(arg) {
  return _$edges_34.restrictEdges.start(arg);
}

function __set_37(arg) {
  var interaction = arg.interaction,
      state = arg.state,
      rect = arg.rect,
      edges = arg.edges;
  var options = state.options;

  if (!edges) {
    return;
  }

  var minSize = __rectUtils_37.tlbrToXywh((0, _$pointer_35.getRestrictionRect)(options.min, interaction, arg.coords)) || noMin;
  var maxSize = __rectUtils_37.tlbrToXywh((0, _$pointer_35.getRestrictionRect)(options.max, interaction, arg.coords)) || noMax;
  state.options = {
    endOnly: options.endOnly,
    inner: (0, ___extend_37["default"])({}, _$edges_34.restrictEdges.noInner),
    outer: (0, ___extend_37["default"])({}, _$edges_34.restrictEdges.noOuter)
  };

  if (edges.top) {
    state.options.inner.top = rect.bottom - minSize.height;
    state.options.outer.top = rect.bottom - maxSize.height;
  } else if (edges.bottom) {
    state.options.inner.bottom = rect.top + minSize.height;
    state.options.outer.bottom = rect.top + maxSize.height;
  }

  if (edges.left) {
    state.options.inner.left = rect.right - minSize.width;
    state.options.outer.left = rect.right - maxSize.width;
  } else if (edges.right) {
    state.options.inner.right = rect.left + minSize.width;
    state.options.outer.right = rect.left + maxSize.width;
  }

  _$edges_34.restrictEdges.set(arg);

  state.options = options;
}

var __defaults_37 = {
  min: null,
  max: null,
  endOnly: false,
  enabled: false
};
var restrictSize = {
  start: __start_37,
  set: __set_37,
  defaults: __defaults_37
};
_$size_37.restrictSize = restrictSize;

var ___default_37 = (0, _$base_32.makeModifier)(restrictSize, 'restrictSize');

_$size_37["default"] = ___default_37;

var _$pointer_39 = {};
"use strict";

function ___typeof_39(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_39 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_39 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_39(obj); }

Object.defineProperty(_$pointer_39, "__esModule", {
  value: true
});
_$pointer_39.snap = _$pointer_39["default"] = void 0;

var __utils_39 = ___interopRequireWildcard_39(_$index_58);

/* removed: var _$base_32 = require("../base"); */;

function ___getRequireWildcardCache_39() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_39 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_39(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_39(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_39(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function __start_39(arg) {
  var interaction = arg.interaction,
      interactable = arg.interactable,
      element = arg.element,
      rect = arg.rect,
      state = arg.state,
      startOffset = arg.startOffset;
  var options = state.options;
  var origin = options.offsetWithOrigin ? getOrigin(arg) : {
    x: 0,
    y: 0
  };
  var snapOffset;

  if (options.offset === 'startCoords') {
    snapOffset = {
      x: interaction.coords.start.page.x,
      y: interaction.coords.start.page.y
    };
  } else {
    var offsetRect = __utils_39.rect.resolveRectLike(options.offset, interactable, element, [interaction]);
    snapOffset = __utils_39.rect.rectToXY(offsetRect) || {
      x: 0,
      y: 0
    };
    snapOffset.x += origin.x;
    snapOffset.y += origin.y;
  }

  var relativePoints = options.relativePoints;
  state.offsets = rect && relativePoints && relativePoints.length ? relativePoints.map(function (relativePoint, index) {
    return {
      index: index,
      relativePoint: relativePoint,
      x: startOffset.left - rect.width * relativePoint.x + snapOffset.x,
      y: startOffset.top - rect.height * relativePoint.y + snapOffset.y
    };
  }) : [__utils_39.extend({
    index: 0,
    relativePoint: null
  }, snapOffset)];
}

function __set_39(arg) {
  var interaction = arg.interaction,
      coords = arg.coords,
      state = arg.state;
  var options = state.options,
      offsets = state.offsets;
  var origin = __utils_39.getOriginXY(interaction.interactable, interaction.element, interaction.prepared.name);
  var page = __utils_39.extend({}, coords);
  var targets = [];

  if (!options.offsetWithOrigin) {
    page.x -= origin.x;
    page.y -= origin.y;
  }

  for (var _i = 0; _i < offsets.length; _i++) {
    var _ref;

    _ref = offsets[_i];
    var _offset = _ref;
    var relativeX = page.x - _offset.x;
    var relativeY = page.y - _offset.y;

    for (var _index = 0, len = options.targets.length; _index < len; _index++) {
      var snapTarget = options.targets[_index];
      var target = void 0;

      if (__utils_39.is.func(snapTarget)) {
        target = snapTarget(relativeX, relativeY, interaction, _offset, _index);
      } else {
        target = snapTarget;
      }

      if (!target) {
        continue;
      }

      targets.push({
        x: (__utils_39.is.number(target.x) ? target.x : relativeX) + _offset.x,
        y: (__utils_39.is.number(target.y) ? target.y : relativeY) + _offset.y,
        range: __utils_39.is.number(target.range) ? target.range : options.range,
        source: snapTarget,
        index: _index,
        offset: _offset
      });
    }
  }

  var closest = {
    target: null,
    inRange: false,
    distance: 0,
    range: 0,
    delta: {
      x: 0,
      y: 0
    }
  };

  for (var _i2 = 0; _i2 < targets.length; _i2++) {
    var _target = targets[_i2];
    var range = _target.range;
    var dx = _target.x - page.x;
    var dy = _target.y - page.y;
    var distance = __utils_39.hypot(dx, dy);
    var inRange = distance <= range; // Infinite targets count as being out of range
    // compared to non infinite ones that are in range

    if (range === Infinity && closest.inRange && closest.range !== Infinity) {
      inRange = false;
    }

    if (!closest.target || (inRange // is the closest target in range?
    ? closest.inRange && range !== Infinity // the pointer is relatively deeper in this target
    ? distance / range < closest.distance / closest.range // this target has Infinite range and the closest doesn't
    : range === Infinity && closest.range !== Infinity || // OR this target is closer that the previous closest
    distance < closest.distance : // The other is not in range and the pointer is closer to this target
    !closest.inRange && distance < closest.distance)) {
      closest.target = _target;
      closest.distance = distance;
      closest.range = range;
      closest.inRange = inRange;
      closest.delta.x = dx;
      closest.delta.y = dy;
    }
  }

  if (closest.inRange) {
    coords.x = closest.target.x;
    coords.y = closest.target.y;
  }

  state.closest = closest;
  return closest;
}

function getOrigin(arg) {
  var element = arg.interaction.element;
  var optionsOrigin = __utils_39.rect.rectToXY(__utils_39.rect.resolveRectLike(arg.state.options.origin, null, null, [element]));
  var origin = optionsOrigin || __utils_39.getOriginXY(arg.interactable, element, arg.interaction.prepared.name);
  return origin;
}

var __defaults_39 = {
  range: Infinity,
  targets: null,
  offset: null,
  offsetWithOrigin: true,
  origin: null,
  relativePoints: null,
  endOnly: false,
  enabled: false
};
var snap = {
  start: __start_39,
  set: __set_39,
  defaults: __defaults_39
};
_$pointer_39.snap = snap;

var ___default_39 = (0, _$base_32.makeModifier)(snap, 'snap');

_$pointer_39["default"] = ___default_39;

var _$size_40 = {};
"use strict";

function ___typeof_40(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_40 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_40 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_40(obj); }

Object.defineProperty(_$size_40, "__esModule", {
  value: true
});
_$size_40.snapSize = _$size_40["default"] = void 0;

var ___extend_40 = ___interopRequireDefault_40(_$extend_55);

var __is_40 = ___interopRequireWildcard_40(_$is_59);

/* removed: var _$base_32 = require("../base"); */;

/* removed: var _$pointer_39 = require("./pointer"); */;

function ___getRequireWildcardCache_40() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_40 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_40(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_40(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_40(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_40(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___slicedToArray_40(arr, i) { return ___arrayWithHoles_40(arr) || ___iterableToArrayLimit_40(arr, i) || ___nonIterableRest_40(); }

function ___nonIterableRest_40() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function ___iterableToArrayLimit_40(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function ___arrayWithHoles_40(arr) { if (Array.isArray(arr)) return arr; }

function __start_40(arg) {
  var state = arg.state,
      edges = arg.edges;
  var options = state.options;

  if (!edges) {
    return null;
  }

  arg.state = {
    options: {
      targets: null,
      relativePoints: [{
        x: edges.left ? 0 : 1,
        y: edges.top ? 0 : 1
      }],
      offset: options.offset || 'self',
      origin: {
        x: 0,
        y: 0
      },
      range: options.range
    }
  };
  state.targetFields = state.targetFields || [['width', 'height'], ['x', 'y']];

  _$pointer_39.snap.start(arg);

  state.offsets = arg.state.offsets;
  arg.state = state;
}

function __set_40(arg) {
  var interaction = arg.interaction,
      state = arg.state,
      coords = arg.coords;
  var options = state.options,
      offsets = state.offsets;
  var relative = {
    x: coords.x - offsets[0].x,
    y: coords.y - offsets[0].y
  };
  state.options = (0, ___extend_40["default"])({}, options);
  state.options.targets = [];

  for (var _i = 0; _i < (options.targets || []).length; _i++) {
    var _ref;

    _ref = (options.targets || [])[_i];
    var snapTarget = _ref;
    var target = void 0;

    if (__is_40.func(snapTarget)) {
      target = snapTarget(relative.x, relative.y, interaction);
    } else {
      target = snapTarget;
    }

    if (!target) {
      continue;
    }

    for (var _i2 = 0; _i2 < state.targetFields.length; _i2++) {
      var _ref2;

      _ref2 = state.targetFields[_i2];

      var _ref3 = _ref2,
          _ref4 = ___slicedToArray_40(_ref3, 2),
          xField = _ref4[0],
          yField = _ref4[1];

      if (xField in target || yField in target) {
        target.x = target[xField];
        target.y = target[yField];
        break;
      }
    }

    state.options.targets.push(target);
  }

  var returnValue = _$pointer_39.snap.set(arg);

  state.options = options;
  return returnValue;
}

var __defaults_40 = {
  range: Infinity,
  targets: null,
  offset: null,
  endOnly: false,
  enabled: false
};
var snapSize = {
  start: __start_40,
  set: __set_40,
  defaults: __defaults_40
};
_$size_40.snapSize = snapSize;

var ___default_40 = (0, _$base_32.makeModifier)(snapSize, 'snapSize');

_$size_40["default"] = ___default_40;

var _$edges_38 = {};
"use strict";

Object.defineProperty(_$edges_38, "__esModule", {
  value: true
});
_$edges_38.snapEdges = _$edges_38["default"] = void 0;

var ___clone_38 = ___interopRequireDefault_38(_$clone_51);

var ___extend_38 = ___interopRequireDefault_38(_$extend_55);

/* removed: var _$base_32 = require("../base"); */;

/* removed: var _$size_40 = require("./size"); */;

function ___interopRequireDefault_38(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * @module modifiers/snapEdges
 *
 * @description
 * This module allows snapping of the edges of targets during resize
 * interactions.
 *
 * @example
 * interact(target).resizable({
 *   snapEdges: {
 *     targets: [interact.snappers.grid({ x: 100, y: 50 })],
 *   },
 * })
 *
 * interact(target).resizable({
 *   snapEdges: {
 *     targets: [
 *       interact.snappers.grid({
 *        top: 50,
 *        left: 50,
 *        bottom: 100,
 *        right: 100,
 *       }),
 *     ],
 *   },
 * })
 */
function __start_38(arg) {
  var edges = arg.edges;

  if (!edges) {
    return null;
  }

  arg.state.targetFields = arg.state.targetFields || [[edges.left ? 'left' : 'right', edges.top ? 'top' : 'bottom']];
  return _$size_40.snapSize.start(arg);
}

var snapEdges = {
  start: __start_38,
  set: _$size_40.snapSize.set,
  defaults: (0, ___extend_38["default"])((0, ___clone_38["default"])(_$size_40.snapSize.defaults), {
    targets: null,
    range: null,
    offset: {
      x: 0,
      y: 0
    }
  })
};
_$edges_38.snapEdges = snapEdges;

var ___default_38 = (0, _$base_32.makeModifier)(snapEdges, 'snapEdges');

_$edges_38["default"] = ___default_38;

var _$all_30 = {};
"use strict";

Object.defineProperty(_$all_30, "__esModule", {
  value: true
});
Object.defineProperty(_$all_30, "aspectRatio", {
  enumerable: true,
  get: function get() {
    return _aspectRatio["default"];
  }
});
Object.defineProperty(_$all_30, "restrictEdges", {
  enumerable: true,
  get: function get() {
    return ___edges_30["default"];
  }
});
Object.defineProperty(_$all_30, "restrict", {
  enumerable: true,
  get: function get() {
    return ___pointer_30["default"];
  }
});
Object.defineProperty(_$all_30, "restrictRect", {
  enumerable: true,
  get: function get() {
    return ___rect_30["default"];
  }
});
Object.defineProperty(_$all_30, "restrictSize", {
  enumerable: true,
  get: function get() {
    return ___size_30["default"];
  }
});
Object.defineProperty(_$all_30, "snapEdges", {
  enumerable: true,
  get: function get() {
    return _edges2["default"];
  }
});
Object.defineProperty(_$all_30, "snap", {
  enumerable: true,
  get: function get() {
    return _pointer2["default"];
  }
});
Object.defineProperty(_$all_30, "snapSize", {
  enumerable: true,
  get: function get() {
    return _size2["default"];
  }
});

var _aspectRatio = ___interopRequireDefault_30(_$aspectRatio_31);

var ___edges_30 = ___interopRequireDefault_30(_$edges_34);

var ___pointer_30 = ___interopRequireDefault_30(_$pointer_35);

var ___rect_30 = ___interopRequireDefault_30(_$rect_36);

var ___size_30 = ___interopRequireDefault_30(_$size_37);

var _edges2 = ___interopRequireDefault_30(_$edges_38);

var _pointer2 = ___interopRequireDefault_30(_$pointer_39);

var _size2 = ___interopRequireDefault_30(_$size_40);

function ___interopRequireDefault_30(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _$grid_66 = {};
"use strict";

Object.defineProperty(_$grid_66, "__esModule", {
  value: true
});
_$grid_66["default"] = void 0;

function ___slicedToArray_66(arr, i) { return ___arrayWithHoles_66(arr) || ___iterableToArrayLimit_66(arr, i) || ___nonIterableRest_66(); }

function ___nonIterableRest_66() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function ___iterableToArrayLimit_66(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function ___arrayWithHoles_66(arr) { if (Array.isArray(arr)) return arr; }

function createGrid(grid) {
  var coordFields = [['x', 'y'], ['left', 'top'], ['right', 'bottom'], ['width', 'height']].filter(function (_ref) {
    var _ref2 = ___slicedToArray_66(_ref, 2),
        xField = _ref2[0],
        yField = _ref2[1];

    return xField in grid || yField in grid;
  });

  var gridFunc = function gridFunc(x, y) {
    var range = grid.range,
        _grid$limits = grid.limits,
        limits = _grid$limits === void 0 ? {
      left: -Infinity,
      right: Infinity,
      top: -Infinity,
      bottom: Infinity
    } : _grid$limits,
        _grid$offset = grid.offset,
        offset = _grid$offset === void 0 ? {
      x: 0,
      y: 0
    } : _grid$offset;
    var result = {
      range: range,
      grid: grid,
      x: null,
      y: null
    };

    for (var _i2 = 0; _i2 < coordFields.length; _i2++) {
      var _ref3;

      _ref3 = coordFields[_i2];

      var _ref4 = _ref3,
          _ref5 = ___slicedToArray_66(_ref4, 2),
          xField = _ref5[0],
          yField = _ref5[1];

      var gridx = Math.round((x - offset.x) / grid[xField]);
      var gridy = Math.round((y - offset.y) / grid[yField]);
      result[xField] = Math.max(limits.left, Math.min(limits.right, gridx * grid[xField] + offset.x));
      result[yField] = Math.max(limits.top, Math.min(limits.bottom, gridy * grid[yField] + offset.y));
    }

    return result;
  };

  gridFunc.grid = grid;
  gridFunc.coordFields = coordFields;
  return gridFunc;
}

var ___default_66 = createGrid;
_$grid_66["default"] = ___default_66;

var _$index_67 = {};
"use strict";

Object.defineProperty(_$index_67, "__esModule", {
  value: true
});
Object.defineProperty(_$index_67, "grid", {
  enumerable: true,
  get: function get() {
    return _grid["default"];
  }
});

var _grid = ___interopRequireDefault_67(_$grid_66);

function ___interopRequireDefault_67(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _$index_33 = {};
"use strict";

function ___typeof_33(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_33 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_33 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_33(obj); }

Object.defineProperty(_$index_33, "__esModule", {
  value: true
});
_$index_33["default"] = void 0;

var ___base_33 = ___interopRequireDefault_33(_$base_32);

var all = ___interopRequireWildcard_33(_$all_30);

var ___extend_33 = ___interopRequireDefault_33(_$extend_55);

var snappers = ___interopRequireWildcard_33(_$index_67);

function ___getRequireWildcardCache_33() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_33 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_33(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_33(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_33(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_33(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var __modifiers_33 = {
  id: 'modifiers',
  install: function install(scope) {
    var interact = scope.interact;
    scope.usePlugin(___base_33["default"]);
    interact.modifiers = (0, ___extend_33["default"])(interact.modifiers || {}, all);
    interact.snappers = (0, ___extend_33["default"])(interact.snappers || {}, snappers);
    interact.createSnapGrid = interact.snappers.grid; // for backwrads compatibility

    for (var type in all) {
      var _all = all[type],
          _defaults = _all._defaults,
          _methods = _all._methods;
      _defaults._methods = _methods;
      scope.defaults.perAction[type] = _defaults;
    }
  }
};
var ___default_33 = __modifiers_33;
_$index_33["default"] = ___default_33;

var _$PointerEvent_42 = {};
"use strict";

Object.defineProperty(_$PointerEvent_42, "__esModule", {
  value: true
});
_$PointerEvent_42.PointerEvent = _$PointerEvent_42["default"] = void 0;

var ___BaseEvent2_42 = ___interopRequireDefault_42(_$BaseEvent_13);

var __pointerUtils_42 = ___interopRequireWildcard_42(_$pointerUtils_63);

function ___getRequireWildcardCache_42() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_42 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_42(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_42(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_42(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_42(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___typeof_42(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_42 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_42 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_42(obj); }

function ___classCallCheck_42(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function ___defineProperties_42(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function ___createClass_42(Constructor, protoProps, staticProps) { if (protoProps) ___defineProperties_42(Constructor.prototype, protoProps); if (staticProps) ___defineProperties_42(Constructor, staticProps); return Constructor; }

function ___possibleConstructorReturn_42(self, call) { if (call && (___typeof_42(call) === "object" || typeof call === "function")) { return call; } return ___assertThisInitialized_42(self); }

function ___getPrototypeOf_42(o) { ___getPrototypeOf_42 = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return ___getPrototypeOf_42(o); }

function ___assertThisInitialized_42(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function ___inherits_42(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) ___setPrototypeOf_42(subClass, superClass); }

function ___setPrototypeOf_42(o, p) { ___setPrototypeOf_42 = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return ___setPrototypeOf_42(o, p); }

function ___defineProperty_42(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var PointerEvent = /*#__PURE__*/function (_BaseEvent) {
  ___inherits_42(PointerEvent, _BaseEvent);

  /** */
  function PointerEvent(type, pointer, event, eventTarget, interaction, timeStamp) {
    var _this;

    ___classCallCheck_42(this, PointerEvent);

    _this = ___possibleConstructorReturn_42(this, ___getPrototypeOf_42(PointerEvent).call(this, interaction));

    ___defineProperty_42(___assertThisInitialized_42(_this), "type", void 0);

    ___defineProperty_42(___assertThisInitialized_42(_this), "originalEvent", void 0);

    ___defineProperty_42(___assertThisInitialized_42(_this), "pointerId", void 0);

    ___defineProperty_42(___assertThisInitialized_42(_this), "pointerType", void 0);

    ___defineProperty_42(___assertThisInitialized_42(_this), "double", void 0);

    ___defineProperty_42(___assertThisInitialized_42(_this), "pageX", void 0);

    ___defineProperty_42(___assertThisInitialized_42(_this), "pageY", void 0);

    ___defineProperty_42(___assertThisInitialized_42(_this), "clientX", void 0);

    ___defineProperty_42(___assertThisInitialized_42(_this), "clientY", void 0);

    ___defineProperty_42(___assertThisInitialized_42(_this), "dt", void 0);

    ___defineProperty_42(___assertThisInitialized_42(_this), "eventable", void 0);

    __pointerUtils_42.pointerExtend(___assertThisInitialized_42(_this), event);

    if (event !== pointer) {
      __pointerUtils_42.pointerExtend(___assertThisInitialized_42(_this), pointer);
    }

    _this.timeStamp = timeStamp;
    _this.originalEvent = event;
    _this.type = type;
    _this.pointerId = __pointerUtils_42.getPointerId(pointer);
    _this.pointerType = __pointerUtils_42.getPointerType(pointer);
    _this.target = eventTarget;
    _this.currentTarget = null;

    if (type === 'tap') {
      var pointerIndex = interaction.getPointerIndex(pointer);
      _this.dt = _this.timeStamp - interaction.pointers[pointerIndex].downTime;
      var interval = _this.timeStamp - interaction.tapTime;
      _this["double"] = !!(interaction.prevTap && interaction.prevTap.type !== 'doubletap' && interaction.prevTap.target === _this.target && interval < 500);
    } else if (type === 'doubletap') {
      _this.dt = pointer.timeStamp - interaction.tapTime;
    }

    return _this;
  }

  ___createClass_42(PointerEvent, [{
    key: "_subtractOrigin",
    value: function _subtractOrigin(_ref) {
      var originX = _ref.x,
          originY = _ref.y;
      this.pageX -= originX;
      this.pageY -= originY;
      this.clientX -= originX;
      this.clientY -= originY;
      return this;
    }
  }, {
    key: "_addOrigin",
    value: function _addOrigin(_ref2) {
      var originX = _ref2.x,
          originY = _ref2.y;
      this.pageX += originX;
      this.pageY += originY;
      this.clientX += originX;
      this.clientY += originY;
      return this;
    }
    /**
     * Prevent the default behaviour of the original Event
     */

  }, {
    key: "preventDefault",
    value: function preventDefault() {
      this.originalEvent.preventDefault();
    }
  }]);

  return PointerEvent;
}(___BaseEvent2_42["default"]);

_$PointerEvent_42.PointerEvent = _$PointerEvent_42["default"] = PointerEvent;

var _$base_43 = {};
"use strict";

function ___typeof_43(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_43 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_43 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_43(obj); }

Object.defineProperty(_$base_43, "__esModule", {
  value: true
});
_$base_43["default"] = void 0;

var ___Interaction_43 = ___interopRequireDefault_43(_$Interaction_18);

var ___scope_43 = _$scope_24({});

var __utils_43 = ___interopRequireWildcard_43(_$index_58);

var _PointerEvent = ___interopRequireDefault_43(_$PointerEvent_42);

function ___getRequireWildcardCache_43() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_43 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_43(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_43(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_43(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_43(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var __defaults_43 = {
  holdDuration: 600,
  ignoreFrom: null,
  allowFrom: null,
  origin: {
    x: 0,
    y: 0
  }
};
var pointerEvents = {
  id: 'pointer-events/base',
  install: __install_43,
  listeners: {
    'interactions:new': addInteractionProps,
    'interactions:update-pointer': addHoldInfo,
    'interactions:move': moveAndClearHold,
    'interactions:down': function interactionsDown(arg, scope) {
      downAndStartHold(arg, scope);
      fire(arg, scope);
    },
    'interactions:up': function interactionsUp(arg, scope) {
      clearHold(arg);
      fire(arg, scope);
      tapAfterUp(arg, scope);
    },
    'interactions:cancel': function interactionsCancel(arg, scope) {
      clearHold(arg);
      fire(arg, scope);
    }
  },
  PointerEvent: _PointerEvent["default"],
  fire: fire,
  collectEventTargets: collectEventTargets,
  defaults: __defaults_43,
  types: {
    down: true,
    move: true,
    up: true,
    cancel: true,
    tap: true,
    doubletap: true,
    hold: true
  }
};

function fire(arg, scope) {
  var interaction = arg.interaction,
      pointer = arg.pointer,
      event = arg.event,
      eventTarget = arg.eventTarget,
      type = arg.type,
      _arg$targets = arg.targets,
      targets = _arg$targets === void 0 ? collectEventTargets(arg, scope) : _arg$targets;
  var pointerEvent = new _PointerEvent["default"](type, pointer, event, eventTarget, interaction, scope.now());
  scope.fire('pointerEvents:new', {
    pointerEvent: pointerEvent
  });
  var signalArg = {
    interaction: interaction,
    pointer: pointer,
    event: event,
    eventTarget: eventTarget,
    targets: targets,
    type: type,
    pointerEvent: pointerEvent
  };

  for (var i = 0; i < targets.length; i++) {
    var target = targets[i];

    for (var prop in target.props || {}) {
      pointerEvent[prop] = target.props[prop];
    }

    var origin = __utils_43.getOriginXY(target.eventable, target.node);

    pointerEvent._subtractOrigin(origin);

    pointerEvent.eventable = target.eventable;
    pointerEvent.currentTarget = target.node;
    target.eventable.fire(pointerEvent);

    pointerEvent._addOrigin(origin);

    if (pointerEvent.immediatePropagationStopped || pointerEvent.propagationStopped && i + 1 < targets.length && targets[i + 1].node !== pointerEvent.currentTarget) {
      break;
    }
  }

  scope.fire('pointerEvents:fired', signalArg);

  if (type === 'tap') {
    // if pointerEvent should make a double tap, create and fire a doubletap
    // PointerEvent and use that as the prevTap
    var prevTap = pointerEvent["double"] ? fire({
      interaction: interaction,
      pointer: pointer,
      event: event,
      eventTarget: eventTarget,
      type: 'doubletap'
    }, scope) : pointerEvent;
    interaction.prevTap = prevTap;
    interaction.tapTime = prevTap.timeStamp;
  }

  return pointerEvent;
}

function collectEventTargets(_ref, scope) {
  var interaction = _ref.interaction,
      pointer = _ref.pointer,
      event = _ref.event,
      eventTarget = _ref.eventTarget,
      type = _ref.type;
  var pointerIndex = interaction.getPointerIndex(pointer);
  var pointerInfo = interaction.pointers[pointerIndex]; // do not fire a tap event if the pointer was moved before being lifted

  if (type === 'tap' && (interaction.pointerWasMoved || // or if the pointerup target is different to the pointerdown target
  !(pointerInfo && pointerInfo.downTarget === eventTarget))) {
    return [];
  }

  var path = __utils_43.dom.getPath(eventTarget);
  var signalArg = {
    interaction: interaction,
    pointer: pointer,
    event: event,
    eventTarget: eventTarget,
    type: type,
    path: path,
    targets: [],
    node: null
  };

  for (var _i = 0; _i < path.length; _i++) {
    var _ref2;

    _ref2 = path[_i];
    var node = _ref2;
    signalArg.node = node;
    scope.fire('pointerEvents:collect-targets', signalArg);
  }

  if (type === 'hold') {
    signalArg.targets = signalArg.targets.filter(function (target) {
      return target.eventable.options.holdDuration === interaction.pointers[pointerIndex].hold.duration;
    });
  }

  return signalArg.targets;
}

function addInteractionProps(_ref3) {
  var interaction = _ref3.interaction;
  interaction.prevTap = null; // the most recent tap event on this interaction

  interaction.tapTime = 0; // time of the most recent tap event
}

function addHoldInfo(_ref4) {
  var down = _ref4.down,
      pointerInfo = _ref4.pointerInfo;

  if (!down && pointerInfo.hold) {
    return;
  }

  pointerInfo.hold = {
    duration: Infinity,
    timeout: null
  };
}

function clearHold(_ref5) {
  var interaction = _ref5.interaction,
      pointerIndex = _ref5.pointerIndex;

  if (interaction.pointers[pointerIndex].hold) {
    clearTimeout(interaction.pointers[pointerIndex].hold.timeout);
  }
}

function moveAndClearHold(_ref6, scope) {
  var interaction = _ref6.interaction,
      pointer = _ref6.pointer,
      event = _ref6.event,
      eventTarget = _ref6.eventTarget,
      duplicate = _ref6.duplicate;
  var pointerIndex = interaction.getPointerIndex(pointer);

  if (!duplicate && (!interaction.pointerIsDown || interaction.pointerWasMoved)) {
    if (interaction.pointerIsDown) {
      clearTimeout(interaction.pointers[pointerIndex].hold.timeout);
    }

    fire({
      interaction: interaction,
      pointer: pointer,
      event: event,
      eventTarget: eventTarget,
      type: 'move'
    }, scope);
  }
}

function downAndStartHold(_ref7, scope) {
  var interaction = _ref7.interaction,
      pointer = _ref7.pointer,
      event = _ref7.event,
      eventTarget = _ref7.eventTarget,
      pointerIndex = _ref7.pointerIndex;
  var timer = interaction.pointers[pointerIndex].hold;
  var path = __utils_43.dom.getPath(eventTarget);
  var signalArg = {
    interaction: interaction,
    pointer: pointer,
    event: event,
    eventTarget: eventTarget,
    type: 'hold',
    targets: [],
    path: path,
    node: null
  };

  for (var _i2 = 0; _i2 < path.length; _i2++) {
    var _ref8;

    _ref8 = path[_i2];
    var node = _ref8;
    signalArg.node = node;
    scope.fire('pointerEvents:collect-targets', signalArg);
  }

  if (!signalArg.targets.length) {
    return;
  }

  var minDuration = Infinity;

  for (var _i3 = 0; _i3 < signalArg.targets.length; _i3++) {
    var _ref9;

    _ref9 = signalArg.targets[_i3];
    var target = _ref9;
    var holdDuration = target.eventable.options.holdDuration;

    if (holdDuration < minDuration) {
      minDuration = holdDuration;
    }
  }

  timer.duration = minDuration;
  timer.timeout = setTimeout(function () {
    fire({
      interaction: interaction,
      eventTarget: eventTarget,
      pointer: pointer,
      event: event,
      type: 'hold'
    }, scope);
  }, minDuration);
}

function tapAfterUp(_ref10, scope) {
  var interaction = _ref10.interaction,
      pointer = _ref10.pointer,
      event = _ref10.event,
      eventTarget = _ref10.eventTarget;

  if (!interaction.pointerWasMoved) {
    fire({
      interaction: interaction,
      eventTarget: eventTarget,
      pointer: pointer,
      event: event,
      type: 'tap'
    }, scope);
  }
}

function __install_43(scope) {
  scope.pointerEvents = pointerEvents;
  scope.defaults.actions.pointerEvents = pointerEvents.defaults;
  __utils_43.extend(scope.actions.phaselessTypes, pointerEvents.types);
}

var ___default_43 = pointerEvents;
_$base_43["default"] = ___default_43;

var _$holdRepeat_44 = {};
"use strict";

Object.defineProperty(_$holdRepeat_44, "__esModule", {
  value: true
});
_$holdRepeat_44["default"] = void 0;

var ___base_44 = ___interopRequireDefault_44(_$base_43);

var ___PointerEvent_44 = ___interopRequireDefault_44(_$PointerEvent_42);

function ___interopRequireDefault_44(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function __install_44(scope) {
  scope.usePlugin(___base_44["default"]);
  var pointerEvents = scope.pointerEvents; // don't repeat by default

  pointerEvents.defaults.holdRepeatInterval = 0;
  pointerEvents.types.holdrepeat = scope.actions.phaselessTypes.holdrepeat = true;
}

function onNew(_ref) {
  var pointerEvent = _ref.pointerEvent;

  if (pointerEvent.type !== 'hold') {
    return;
  }

  pointerEvent.count = (pointerEvent.count || 0) + 1;
}

function onFired(_ref2, scope) {
  var interaction = _ref2.interaction,
      pointerEvent = _ref2.pointerEvent,
      eventTarget = _ref2.eventTarget,
      targets = _ref2.targets;

  if (pointerEvent.type !== 'hold' || !targets.length) {
    return;
  } // get the repeat interval from the first eventable


  var interval = targets[0].eventable.options.holdRepeatInterval; // don't repeat if the interval is 0 or less

  if (interval <= 0) {
    return;
  } // set a timeout to fire the holdrepeat event


  interaction.holdIntervalHandle = setTimeout(function () {
    scope.pointerEvents.fire({
      interaction: interaction,
      eventTarget: eventTarget,
      type: 'hold',
      pointer: pointerEvent,
      event: pointerEvent
    }, scope);
  }, interval);
}

function endHoldRepeat(_ref3) {
  var interaction = _ref3.interaction;

  // set the interaction's holdStopTime property
  // to stop further holdRepeat events
  if (interaction.holdIntervalHandle) {
    clearInterval(interaction.holdIntervalHandle);
    interaction.holdIntervalHandle = null;
  }
}

var holdRepeat = {
  id: 'pointer-events/holdRepeat',
  install: __install_44,
  listeners: ['move', 'up', 'cancel', 'endall'].reduce(function (acc, enderTypes) {
    acc["pointerEvents:".concat(enderTypes)] = endHoldRepeat;
    return acc;
  }, {
    'pointerEvents:new': onNew,
    'pointerEvents:fired': onFired
  })
};
var ___default_44 = holdRepeat;
_$holdRepeat_44["default"] = ___default_44;

var _$interactableTargets_46 = {};
"use strict";

Object.defineProperty(_$interactableTargets_46, "__esModule", {
  value: true
});
_$interactableTargets_46["default"] = void 0;

var ___extend_46 = ___interopRequireDefault_46(_$extend_55);

function ___interopRequireDefault_46(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function __install_46(scope) {
  var Interactable = scope.Interactable;
  Interactable.prototype.pointerEvents = pointerEventsMethod;
  var __backCompatOption = Interactable.prototype._backCompatOption;

  Interactable.prototype._backCompatOption = function (optionName, newValue) {
    var ret = __backCompatOption.call(this, optionName, newValue);

    if (ret === this) {
      this.events.options[optionName] = newValue;
    }

    return ret;
  };
}

function pointerEventsMethod(options) {
  (0, ___extend_46["default"])(this.events.options, options);
  return this;
}

var plugin = {
  id: 'pointer-events/interactableTargets',
  install: __install_46,
  listeners: {
    'pointerEvents:collect-targets': function pointerEventsCollectTargets(_ref, scope) {
      var targets = _ref.targets,
          node = _ref.node,
          type = _ref.type,
          eventTarget = _ref.eventTarget;
      scope.interactables.forEachMatch(node, function (interactable) {
        var eventable = interactable.events;
        var options = eventable.options;

        if (eventable.types[type] && eventable.types[type].length && interactable.testIgnoreAllow(options, node, eventTarget)) {
          targets.push({
            node: node,
            eventable: eventable,
            props: {
              interactable: interactable
            }
          });
        }
      });
    },
    'interactable:new': function interactableNew(_ref2) {
      var interactable = _ref2.interactable;

      interactable.events.getRect = function (element) {
        return interactable.getRect(element);
      };
    },
    'interactable:set': function interactableSet(_ref3, scope) {
      var interactable = _ref3.interactable,
          options = _ref3.options;
      (0, ___extend_46["default"])(interactable.events.options, scope.pointerEvents.defaults);
      (0, ___extend_46["default"])(interactable.events.options, options.pointerEvents || {});
    }
  }
};
var ___default_46 = plugin;
_$interactableTargets_46["default"] = ___default_46;

var _$index_45 = {};
"use strict";

function ___typeof_45(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_45 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_45 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_45(obj); }

Object.defineProperty(_$index_45, "__esModule", {
  value: true
});
Object.defineProperty(_$index_45, "holdRepeat", {
  enumerable: true,
  get: function get() {
    return _holdRepeat["default"];
  }
});
Object.defineProperty(_$index_45, "interactableTargets", {
  enumerable: true,
  get: function get() {
    return _interactableTargets["default"];
  }
});
_$index_45.pointerEvents = _$index_45["default"] = void 0;

var __pointerEvents_45 = ___interopRequireWildcard_45(_$base_43);

_$index_45.pointerEvents = __pointerEvents_45;

var _holdRepeat = ___interopRequireDefault_45(_$holdRepeat_44);

var _interactableTargets = ___interopRequireDefault_45(_$interactableTargets_46);

function ___interopRequireDefault_45(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___getRequireWildcardCache_45() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_45 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_45(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_45(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_45(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var ___default_45 = {
  id: 'pointer-events',
  install: function install(scope) {
    scope.usePlugin(__pointerEvents_45);
    scope.usePlugin(_holdRepeat["default"]);
    scope.usePlugin(_interactableTargets["default"]);
  }
};
_$index_45["default"] = ___default_45;

var _$index_47 = {};
"use strict";

Object.defineProperty(_$index_47, "__esModule", {
  value: true
});
_$index_47.install = __install_47;
_$index_47["default"] = void 0;

var ___Interactable_47 = ___interopRequireDefault_47(_$Interactable_16({}));

/* removed: var _$Interaction_18 = require("@interactjs/core/Interaction"); */;

/* removed: var _$index_58 = require("@interactjs/utils/index"); */;

function ___interopRequireDefault_47(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function __install_47(scope) {
  var Interactable = scope.Interactable;
  scope.actions.phases.reflow = true;
  /**
   * ```js
   * const interactable = interact(target)
   * const drag = { name: drag, axis: 'x' }
   * const resize = { name: resize, edges: { left: true, bottom: true }
   *
   * interactable.reflow(drag)
   * interactable.reflow(resize)
   * ```
   *
   * Start an action sequence to re-apply modifiers, check drops, etc.
   *
   * @param { Object } action The action to begin
   * @param { string } action.name The name of the action
   * @returns { Promise } A promise that resolves to the `Interactable` when actions on all targets have ended
   */

  Interactable.prototype.reflow = function (action) {
    return reflow(this, action, scope);
  };
}

function reflow(interactable, action, scope) {
  var elements = _$index_58.is.string(interactable.target) ? _$index_58.arr.from(interactable._context.querySelectorAll(interactable.target)) : [interactable.target]; // tslint:disable-next-line variable-name

  var Promise = _$index_58.win.window.Promise;
  var promises = Promise ? [] : null;

  var _loop = function _loop() {
    _ref = elements[_i];
    var element = _ref;
    var rect = interactable.getRect(element);

    if (!rect) {
      return "break";
    }

    var runningInteraction = _$index_58.arr.find(scope.interactions.list, function (interaction) {
      return interaction.interacting() && interaction.interactable === interactable && interaction.element === element && interaction.prepared.name === action.name;
    });

    var reflowPromise = void 0;

    if (runningInteraction) {
      runningInteraction.move();

      if (promises) {
        reflowPromise = runningInteraction._reflowPromise || new Promise(function (resolve) {
          runningInteraction._reflowResolve = resolve;
        });
      }
    } else {
      var xywh = _$index_58.rect.tlbrToXywh(rect);

      var coords = {
        page: {
          x: xywh.x,
          y: xywh.y
        },
        client: {
          x: xywh.x,
          y: xywh.y
        },
        timeStamp: scope.now()
      };

      var event = _$index_58.pointer.coordsToEvent(coords);

      reflowPromise = startReflow(scope, interactable, element, action, event);
    }

    if (promises) {
      promises.push(reflowPromise);
    }
  };

  for (var _i = 0; _i < elements.length; _i++) {
    var _ref;

    var _ret = _loop();

    if (_ret === "break") break;
  }

  return promises && Promise.all(promises).then(function () {
    return interactable;
  });
}

function startReflow(scope, interactable, element, action, event) {
  var interaction = scope.interactions["new"]({
    pointerType: 'reflow'
  });
  var signalArg = {
    interaction: interaction,
    event: event,
    pointer: event,
    eventTarget: element,
    phase: 'reflow'
  };
  interaction.interactable = interactable;
  interaction.element = element;
  interaction.prepared = (0, _$index_58.extend)({}, action);
  interaction.prevEvent = event;
  interaction.updatePointer(event, event, element, true);

  interaction._doPhase(signalArg);

  var reflowPromise = _$index_58.win.window.Promise ? new _$index_58.win.window.Promise(function (resolve) {
    interaction._reflowResolve = resolve;
  }) : null;
  interaction._reflowPromise = reflowPromise;
  interaction.start(action, interactable, element);

  if (interaction._interacting) {
    interaction.move(signalArg);
    interaction.end(event);
  } else {
    interaction.stop();
  }

  interaction.removePointer(event, event);
  interaction.pointerIsDown = false;
  return reflowPromise;
}

var ___default_47 = {
  id: 'reflow',
  install: __install_47,
  listeners: {
    // remove completed reflow interactions
    'interactions:stop': function interactionsStop(_ref2, scope) {
      var interaction = _ref2.interaction;

      if (interaction.pointerType === 'reflow') {
        if (interaction._reflowResolve) {
          interaction._reflowResolve();
        }

        _$index_58.arr.remove(scope.interactions.list, interaction);
      }
    }
  }
};
_$index_47["default"] = ___default_47;

var _$index_27 = {};
"use strict";

function ___typeof_27(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_27 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_27 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_27(obj); }

Object.defineProperty(_$index_27, "__esModule", {
  value: true
});
_$index_27.init = __init_27;
_$index_27["default"] = _$index_27.scope = _$index_27.interact = void 0;

_$index_48;

var ___scope_27 = _$scope_24({});

var ___browser_27 = ___interopRequireDefault_27(_$browser_50);

var ___events_27 = ___interopRequireDefault_27(_$events_54);

var __utils_27 = ___interopRequireWildcard_27(_$index_58);

function ___getRequireWildcardCache_27() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_27 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_27(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_27(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_27(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_27(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/** @module interact */
var globalEvents = {};
var scope = new ___scope_27.Scope();
_$index_27.scope = scope;

function __init_27(win) {
  scope.init(win);
  return interact;
}
/**
 * ```js
 * interact('#draggable').draggable(true)
 *
 * var rectables = interact('rect')
 * rectables
 *   .gesturable(true)
 *   .on('gesturemove', function (event) {
 *       // ...
 *   })
 * ```
 *
 * The methods of this variable can be used to set elements as interactables
 * and also to change various default settings.
 *
 * Calling it as a function and passing an element or a valid CSS selector
 * string returns an Interactable object which has various methods to configure
 * it.
 *
 * @global
 *
 * @param {Element | string} target The HTML or SVG Element to interact with
 * or CSS selector
 * @return {Interactable}
 */


var interact = function interact(target, options) {
  var interactable = scope.interactables.get(target, options);

  if (!interactable) {
    interactable = scope.interactables["new"](target, options);
    interactable.events.global = globalEvents;
  }

  return interactable;
};
/**
 * Use a plugin
 *
 * @alias module:interact.use
 *
 * @param {Object} plugin
 * @param {function} plugin.install
 * @return {interact}
 */


_$index_27.interact = interact;
interact.use = use;

function use(plugin, options) {
  scope.usePlugin(plugin, options);
  return interact;
}
/**
 * Check if an element or selector has been set with the {@link interact}
 * function
 *
 * @alias module:interact.isSet
 *
 * @param {Element} element The Element being searched for
 * @return {boolean} Indicates if the element or CSS selector was previously
 * passed to interact
 */


interact.isSet = isSet;

function isSet(target, options) {
  return !!scope.interactables.get(target, options && options.context);
}
/**
 * Add a global listener for an InteractEvent or adds a DOM event to `document`
 *
 * @alias module:interact.on
 *
 * @param {string | array | object} type The types of events to listen for
 * @param {function} listener The function event (s)
 * @param {object | boolean} [options] object or useCapture flag for
 * addEventListener
 * @return {object} interact
 */


interact.on = on;

function on(type, listener, options) {
  if (__utils_27.is.string(type) && type.search(' ') !== -1) {
    type = type.trim().split(/ +/);
  }

  if (__utils_27.is.array(type)) {
    for (var _i = 0; _i < type.length; _i++) {
      var _ref;

      _ref = type[_i];
      var eventType = _ref;
      interact.on(eventType, listener, options);
    }

    return interact;
  }

  if (__utils_27.is.object(type)) {
    for (var prop in type) {
      interact.on(prop, type[prop], listener);
    }

    return interact;
  } // if it is an InteractEvent type, add listener to globalEvents


  if ((0, ___scope_27.isNonNativeEvent)(type, scope.actions)) {
    // if this type of event was never bound
    if (!globalEvents[type]) {
      globalEvents[type] = [listener];
    } else {
      globalEvents[type].push(listener);
    }
  } // If non InteractEvent type, addEventListener to document
  else {
      ___events_27["default"].add(scope.document, type, listener, {
        options: options
      });
    }

  return interact;
}
/**
 * Removes a global InteractEvent listener or DOM event from `document`
 *
 * @alias module:interact.off
 *
 * @param {string | array | object} type The types of events that were listened
 * for
 * @param {function} listener The listener function to be removed
 * @param {object | boolean} options [options] object or useCapture flag for
 * removeEventListener
 * @return {object} interact
 */


interact.off = off;

function off(type, listener, options) {
  if (__utils_27.is.string(type) && type.search(' ') !== -1) {
    type = type.trim().split(/ +/);
  }

  if (__utils_27.is.array(type)) {
    for (var _i2 = 0; _i2 < type.length; _i2++) {
      var _ref2;

      _ref2 = type[_i2];
      var eventType = _ref2;
      interact.off(eventType, listener, options);
    }

    return interact;
  }

  if (__utils_27.is.object(type)) {
    for (var prop in type) {
      interact.off(prop, type[prop], listener);
    }

    return interact;
  }

  if ((0, ___scope_27.isNonNativeEvent)(type, scope.actions)) {
    var index;

    if (type in globalEvents && (index = globalEvents[type].indexOf(listener)) !== -1) {
      globalEvents[type].splice(index, 1);
    }
  } else {
    ___events_27["default"].remove(scope.document, type, listener, options);
  }

  return interact;
}

interact.debug = debug;

function debug() {
  return scope;
} // expose the functions used to calculate multi-touch properties


interact.getPointerAverage = __utils_27.pointer.pointerAverage;
interact.getTouchBBox = __utils_27.pointer.touchBBox;
interact.getTouchDistance = __utils_27.pointer.touchDistance;
interact.getTouchAngle = __utils_27.pointer.touchAngle;
interact.getElementRect = __utils_27.dom.getElementRect;
interact.getElementClientRect = __utils_27.dom.getElementClientRect;
interact.matchesSelector = __utils_27.dom.matchesSelector;
interact.closest = __utils_27.dom.closest;
/**
 * @alias module:interact.supportsTouch
 *
 * @return {boolean} Whether or not the browser supports touch input
 */

interact.supportsTouch = supportsTouch;

function supportsTouch() {
  return ___browser_27["default"].supportsTouch;
}
/**
 * @alias module:interact.supportsPointerEvent
 *
 * @return {boolean} Whether or not the browser supports PointerEvents
 */


interact.supportsPointerEvent = supportsPointerEvent;

function supportsPointerEvent() {
  return ___browser_27["default"].supportsPointerEvent;
}
/**
 * Cancels all interactions (end events are not fired)
 *
 * @alias module:interact.stop
 *
 * @return {object} interact
 */


interact.stop = __stop_27;

function __stop_27() {
  for (var _i3 = 0; _i3 < scope.interactions.list.length; _i3++) {
    var _ref3;

    _ref3 = scope.interactions.list[_i3];
    var interaction = _ref3;
    interaction.stop();
  }

  return interact;
}
/**
 * Returns or sets the distance the pointer must be moved before an action
 * sequence occurs. This also affects tolerance for tap events.
 *
 * @alias module:interact.pointerMoveTolerance
 *
 * @param {number} [newValue] The movement from the start position must be greater than this value
 * @return {interact | number}
 */


interact.pointerMoveTolerance = pointerMoveTolerance;

function pointerMoveTolerance(newValue) {
  if (__utils_27.is.number(newValue)) {
    scope.interactions.pointerMoveTolerance = newValue;
    return interact;
  }

  return scope.interactions.pointerMoveTolerance;
}

interact.addDocument = function (doc, options) {
  return scope.addDocument(doc, options);
};

interact.removeDocument = function (doc) {
  return scope.removeDocument(doc);
}; // eslint-disable-next-line no-undef


interact.version = "1.9.4";
scope.interact = interact;
var ___default_27 = interact;
_$index_27["default"] = ___default_27;

var _$index_28 = {};
"use strict";

Object.defineProperty(_$index_28, "__esModule", {
  value: true
});
_$index_28.init = __init_28;
_$index_28["default"] = void 0;

_$index_48;

var _index2 = ___interopRequireDefault_28(_$index_5);

var _index3 = ___interopRequireDefault_28(_$index_7);

var _index4 = ___interopRequireDefault_28(_$index_12);

var _index5 = ___interopRequireDefault_28(_$index_25);

var _index6 = ___interopRequireDefault_28(_$index_26);

var _index7 = ___interopRequireDefault_28(_$index_33);

var _offset = ___interopRequireDefault_28(_$index_41);

var _index8 = ___interopRequireDefault_28(_$index_45);

var _index9 = ___interopRequireDefault_28(_$index_47);

var _index10 = ___interopRequireWildcard_28(_$index_27);

function ___getRequireWildcardCache_28() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_28 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_28(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_28(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_28(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___interopRequireDefault_28(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ___typeof_28(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_28 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_28 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_28(obj); }

if ((typeof window === "undefined" ? "undefined" : ___typeof_28(window)) === 'object' && !!window) {
  __init_28(window);
}

var ___default_28 = _index10["default"];
_$index_28["default"] = ___default_28;

function __init_28(win) {
  (0, _index10.init)(win);

  _index10["default"].use(_offset["default"]); // pointerEvents


  _index10["default"].use(_index8["default"]); // inertia


  _index10["default"].use(_index6["default"]); // snap, resize, etc.


  _index10["default"].use(_index7["default"]); // autoStart, hold


  _index10["default"].use(_index4["default"]); // drag and drop, resize, gesture


  _index10["default"].use(_index2["default"]); // autoScroll


  _index10["default"].use(_index3["default"]); // reflow


  _index10["default"].use(_index9["default"]); // eslint-disable-next-line no-undef


  if ("production" !== 'production') {
    _index10["default"].use(_index5["default"]);
  }

  return _index10["default"];
}

var _$index_69 = { exports: {} };
"use strict";

Object.defineProperty(_$index_69.exports, "__esModule", {
  value: true
});
Object.defineProperty(_$index_69.exports, "init", {
  enumerable: true,
  get: function get() {
    return ___index_69.init;
  }
});
_$index_69.exports["default"] = void 0;

var ___index_69 = ___interopRequireWildcard_69(_$index_28);

function ___getRequireWildcardCache_69() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); ___getRequireWildcardCache_69 = function _getRequireWildcardCache() { return cache; }; return cache; }

function ___interopRequireWildcard_69(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || ___typeof_69(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = ___getRequireWildcardCache_69(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ___typeof_69(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { ___typeof_69 = function _typeof(obj) { return typeof obj; }; } else { ___typeof_69 = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return ___typeof_69(obj); }

if (("object" === "undefined" ? "undefined" : ___typeof_69(_$index_69)) === 'object' && !!_$index_69) {
  try {
    _$index_69.exports = ___index_69["default"];
  } catch (_unused) {}
}

___index_69["default"]["default"] = ___index_69["default"];
___index_69["default"].init = ___index_69.init;
var ___default_69 = ___index_69["default"];
_$index_69.exports["default"] = ___default_69;

_$index_69 = _$index_69.exports
return _$index_69;

});

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL25vZGVfbW9kdWxlcy9icm93c2VyLXBhY2stZmxhdC9fcHJlbHVkZSIsIi4uL0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3RhYmxlLnRzIiwiLi4vQGludGVyYWN0anMvY29yZS9zY29wZS50cyIsIi4uL0BpbnRlcmFjdGpzL2NvcmUvaW50ZXJhY3Rpb25zLnRzIiwiLi4vQGludGVyYWN0anMvdHlwZXMvaW5kZXgudHMiLCIuLi9AaW50ZXJhY3Rqcy91dGlscy9pc1dpbmRvdy50cyIsIi4uL0BpbnRlcmFjdGpzL3V0aWxzL3dpbmRvdy50cyIsIi4uL0BpbnRlcmFjdGpzL3V0aWxzL2lzLnRzIiwiLi4vQGludGVyYWN0anMvYWN0aW9ucy9kcmFnLnRzIiwiLi4vQGludGVyYWN0anMvdXRpbHMvYXJyLnRzIiwiLi4vQGludGVyYWN0anMvdXRpbHMvZG9tT2JqZWN0cy50cyIsIi4uL0BpbnRlcmFjdGpzL3V0aWxzL2Jyb3dzZXIudHMiLCIuLi9AaW50ZXJhY3Rqcy91dGlscy9jbG9uZS50cyIsIi4uL0BpbnRlcmFjdGpzL3V0aWxzL2RvbVV0aWxzLnRzIiwiLi4vQGludGVyYWN0anMvdXRpbHMvcG9pbnRlckV4dGVuZC50cyIsIi4uL0BpbnRlcmFjdGpzL3V0aWxzL2h5cG90LnRzIiwiLi4vQGludGVyYWN0anMvdXRpbHMvcG9pbnRlclV0aWxzLnRzIiwiLi4vQGludGVyYWN0anMvdXRpbHMvZXZlbnRzLnRzIiwiLi4vQGludGVyYWN0anMvdXRpbHMvZXh0ZW5kLnRzIiwiLi4vQGludGVyYWN0anMvdXRpbHMvbm9ybWFsaXplTGlzdGVuZXJzLnRzIiwiLi4vQGludGVyYWN0anMvY29yZS9FdmVudGFibGUudHMiLCIuLi9AaW50ZXJhY3Rqcy91dGlscy9yZWN0LnRzIiwiLi4vQGludGVyYWN0anMvdXRpbHMvZ2V0T3JpZ2luWFkudHMiLCIuLi9AaW50ZXJhY3Rqcy91dGlscy9yYWYudHMiLCIuLi9AaW50ZXJhY3Rqcy91dGlscy9pbmRleC50cyIsIi4uL0BpbnRlcmFjdGpzL2NvcmUvZGVmYXVsdE9wdGlvbnMudHMiLCIuLi9AaW50ZXJhY3Rqcy9jb3JlL0ludGVyYWN0YWJsZVNldC50cyIsIi4uL0BpbnRlcmFjdGpzL2NvcmUvQmFzZUV2ZW50LnRzIiwiLi4vQGludGVyYWN0anMvY29yZS9JbnRlcmFjdEV2ZW50LnRzIiwiLi4vQGludGVyYWN0anMvY29yZS9Qb2ludGVySW5mby50cyIsIi4uL0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3Rpb24udHMiLCIuLi9AaW50ZXJhY3Rqcy9jb3JlL2ludGVyYWN0aW9uRmluZGVyLnRzIiwiLi4vQGludGVyYWN0anMvY29yZS9pbnRlcmFjdGFibGVQcmV2ZW50RGVmYXVsdC50cyIsIi4uL0BpbnRlcmFjdGpzL2FjdGlvbnMvZHJvcC9Ecm9wRXZlbnQudHMiLCIuLi9AaW50ZXJhY3Rqcy9hY3Rpb25zL2Ryb3AvaW5kZXgudHMiLCIuLi9AaW50ZXJhY3Rqcy9hY3Rpb25zL2dlc3R1cmUudHMiLCIuLi9AaW50ZXJhY3Rqcy9hY3Rpb25zL3Jlc2l6ZS50cyIsIi4uL0BpbnRlcmFjdGpzL2FjdGlvbnMvaW5kZXgudHMiLCIuLi9AaW50ZXJhY3Rqcy9hdXRvLXNjcm9sbC9pbmRleC50cyIsIi4uL0BpbnRlcmFjdGpzL2F1dG8tc3RhcnQvSW50ZXJhY3RhYmxlTWV0aG9kcy50cyIsIi4uL0BpbnRlcmFjdGpzL2F1dG8tc3RhcnQvYmFzZS50cyIsIi4uL0BpbnRlcmFjdGpzL2F1dG8tc3RhcnQvZHJhZ0F4aXMudHMiLCIuLi9AaW50ZXJhY3Rqcy9hdXRvLXN0YXJ0L2hvbGQudHMiLCIuLi9AaW50ZXJhY3Rqcy9hdXRvLXN0YXJ0L2luZGV4LnRzIiwiLi4vQGludGVyYWN0anMvZGV2LXRvb2xzL2luZGV4LnRzIiwiLi4vQGludGVyYWN0anMvbW9kaWZpZXJzL01vZGlmaWNhdGlvbi50cyIsIi4uL0BpbnRlcmFjdGpzL21vZGlmaWVycy9iYXNlLnRzIiwiLi4vQGludGVyYWN0anMvb2Zmc2V0L2luZGV4LnRzIiwiLi4vQGludGVyYWN0anMvaW5lcnRpYS9pbmRleC50cyIsIi4uL0BpbnRlcmFjdGpzL21vZGlmaWVycy9hc3BlY3RSYXRpby50cyIsIi4uL0BpbnRlcmFjdGpzL21vZGlmaWVycy9yZXN0cmljdC9wb2ludGVyLnRzIiwiLi4vQGludGVyYWN0anMvbW9kaWZpZXJzL3Jlc3RyaWN0L2VkZ2VzLnRzIiwiLi4vQGludGVyYWN0anMvbW9kaWZpZXJzL3Jlc3RyaWN0L3JlY3QudHMiLCIuLi9AaW50ZXJhY3Rqcy9tb2RpZmllcnMvcmVzdHJpY3Qvc2l6ZS50cyIsIi4uL0BpbnRlcmFjdGpzL21vZGlmaWVycy9zbmFwL3BvaW50ZXIudHMiLCIuLi9AaW50ZXJhY3Rqcy9tb2RpZmllcnMvc25hcC9zaXplLnRzIiwiLi4vQGludGVyYWN0anMvbW9kaWZpZXJzL3NuYXAvZWRnZXMudHMiLCIuLi9AaW50ZXJhY3Rqcy9tb2RpZmllcnMvYWxsLnRzIiwiLi4vQGludGVyYWN0anMvdXRpbHMvc25hcHBlcnMvZ3JpZC50cyIsIi4uL0BpbnRlcmFjdGpzL3V0aWxzL3NuYXBwZXJzL2luZGV4LnRzIiwiLi4vQGludGVyYWN0anMvbW9kaWZpZXJzL2luZGV4LnRzIiwiLi4vQGludGVyYWN0anMvcG9pbnRlci1ldmVudHMvUG9pbnRlckV2ZW50LnRzIiwiLi4vQGludGVyYWN0anMvcG9pbnRlci1ldmVudHMvYmFzZS50cyIsIi4uL0BpbnRlcmFjdGpzL3BvaW50ZXItZXZlbnRzL2hvbGRSZXBlYXQudHMiLCIuLi9AaW50ZXJhY3Rqcy9wb2ludGVyLWV2ZW50cy9pbnRlcmFjdGFibGVUYXJnZXRzLnRzIiwiLi4vQGludGVyYWN0anMvcG9pbnRlci1ldmVudHMvaW5kZXgudHMiLCIuLi9AaW50ZXJhY3Rqcy9yZWZsb3cvaW5kZXgudHMiLCIuLi9AaW50ZXJhY3Rqcy9pbnRlcmFjdC9pbmRleC50cyIsIi4uL0BpbnRlcmFjdGpzL2ludGVyYWN0anMvaW5kZXgudHMiLCJpbmRleC50cyIsIi4uL25vZGVfbW9kdWxlcy9icm93c2VyLXBhY2stZmxhdC9fcG9zdGx1ZGUiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7QUFDQTtBQUNBOzs7Ozs7Ozs7O0FDRkEsSUFBQSxHQUFBLEdBQUEsdUJBQUEsQ0FBQSxRQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFFBQUEsR0FBQSxzQkFBQSxDQUFBLFlBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsTUFBQSxHQUFBLHNCQUFBLENBQUEsVUFBQSxDQUFBLENBQUE7O0FBQ0EsMEVBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsc0JBQUEsQ0FBQSxXQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLE9BQUEsR0FBQSxzQkFBQSxDQUFBLFdBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsRUFBQSxHQUFBLHVCQUFBLENBQUEsT0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxtQkFBQSxHQUFBLHNCQUFBLENBQUEsdUJBQUEsQ0FBQSxDQUFBOztBQUNBLHNFQUFBOztBQUVBLElBQUEsVUFBQSxHQUFBLHNCQUFBLENBQUEsY0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxNQUFBLEdBQUEsY0FBQSxDQUFBOzs7Ozs7Ozs7Ozs7Ozs7OztJQUthOzs7d0JBQzBCO01BQ25DLE9BQU87UUFDTCxJQUFJLEVBQUUsRUFERDtRQUVMLFNBQVMsRUFBRSxFQUZOO1FBR0wsT0FBTyxFQUFFLEVBQUE7T0FIWCxDQUFBO0tBS0Q7Ozs7RUFXRCxTQUFBLFlBQUEsQ0FBYSxNQUFiLEVBQXNDLE9BQXRDLEVBQW9ELGNBQXBELEVBQWlHO0lBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxZQUFBLENBQUEsQ0FBQTs7SUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLFNBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLGVBQUEsQ0FBQSxJQUFBLEVBQUEsVUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxRQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLFFBQUEsRUFOL0UsSUFBSSxVQUFBLENBQUEsU0FBQSxDQUFKLEVBTStFLENBQUEsQ0FBQTs7SUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLFVBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLGVBQUEsQ0FBQSxJQUFBLEVBQUEsTUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxNQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFDL0YsSUFBQSxDQUFLLFFBQUwsR0FBZ0IsT0FBTyxDQUFDLE9BQXhCLENBQUE7SUFDQSxJQUFBLENBQUssTUFBTCxHQUFnQixNQUFoQixDQUFBO0lBQ0EsSUFBQSxDQUFLLFFBQUwsR0FBZ0IsT0FBTyxDQUFDLE9BQVIsSUFBbUIsY0FBbkMsQ0FBQTtJQUNBLElBQUEsQ0FBSyxJQUFMLEdBQWdCLENBQUEsQ0FBQSxFQUFBLFdBQUEsQ0FBQSxTQUFBLEVBQVUsQ0FBQSxDQUFBLEVBQUEsYUFBQSxDQUFBLFdBQUEsRUFBWSxNQUFaLENBQUEsR0FBc0IsSUFBQSxDQUFLLFFBQTNCLEdBQXNDLE1BQWhELENBQWhCLENBQUE7SUFDQSxJQUFBLENBQUssSUFBTCxHQUFnQixJQUFBLENBQUssSUFBTCxDQUFVLFFBQTFCLENBQUE7SUFFQSxJQUFBLENBQUssR0FBTCxDQUFTLE9BQVQsQ0FBQSxDQUFBO0dBQ0Q7Ozs7Z0NBRVksWUFBaUMsUUFBMEI7TUFDdEUsSUFBSSxFQUFFLENBQUMsSUFBSCxDQUFRLE1BQU0sQ0FBQyxPQUFmLENBQUosRUFBNkI7UUFBRSxJQUFBLENBQUssRUFBTCxDQUFBLEVBQUEsQ0FBQSxNQUFBLENBQVcsVUFBWCxFQUFBLE9BQUEsQ0FBQSxFQUE4QixNQUFNLENBQUMsT0FBckMsQ0FBQSxDQUFBO09BQStDOztNQUM5RSxJQUFJLEVBQUUsQ0FBQyxJQUFILENBQVEsTUFBTSxDQUFDLE1BQWYsQ0FBSixFQUE0QjtRQUFFLElBQUEsQ0FBSyxFQUFMLENBQUEsRUFBQSxDQUFBLE1BQUEsQ0FBVyxVQUFYLEVBQUEsTUFBQSxDQUFBLEVBQTZCLE1BQU0sQ0FBQyxNQUFwQyxDQUFBLENBQUE7T0FBNkM7O01BQzNFLElBQUksRUFBRSxDQUFDLElBQUgsQ0FBUSxNQUFNLENBQUMsS0FBZixDQUFKLEVBQTJCO1FBQUUsSUFBQSxDQUFLLEVBQUwsQ0FBQSxFQUFBLENBQUEsTUFBQSxDQUFXLFVBQVgsRUFBQSxLQUFBLENBQUEsRUFBNEIsTUFBTSxDQUFDLEtBQW5DLENBQUEsQ0FBQTtPQUEyQzs7TUFDeEUsSUFBSSxFQUFFLENBQUMsSUFBSCxDQUFRLE1BQU0sQ0FBQyxjQUFmLENBQUosRUFBb0M7UUFBRSxJQUFBLENBQUssRUFBTCxDQUFBLEVBQUEsQ0FBQSxNQUFBLENBQVcsVUFBWCxFQUFBLGNBQUEsQ0FBQSxFQUFxQyxNQUFNLENBQUMsY0FBNUMsQ0FBQSxDQUFBO09BQTZEOztNQUVuRyxPQUFPLElBQVAsQ0FBQTtLQUNEOzs7NkNBRXlCLFlBQWlDLE1BQTBCLEtBQXlCO01BQzVHLElBQUksRUFBRSxDQUFDLEtBQUgsQ0FBUyxJQUFULENBQUEsSUFBa0IsRUFBRSxDQUFDLE1BQUgsQ0FBVSxJQUFWLENBQXRCLEVBQXVDO1FBQ3JDLElBQUEsQ0FBSyxHQUFMLENBQVMsVUFBVCxFQUFxQixJQUFyQixDQUFBLENBQUE7T0FDRDs7TUFFRCxJQUFJLEVBQUUsQ0FBQyxLQUFILENBQVMsR0FBVCxDQUFBLElBQWlCLEVBQUUsQ0FBQyxNQUFILENBQVUsR0FBVixDQUFyQixFQUFxQztRQUNuQyxJQUFBLENBQUssRUFBTCxDQUFRLFVBQVIsRUFBb0IsR0FBcEIsQ0FBQSxDQUFBO09BQ0Q7S0FDRjs7O2lDQUVhLFlBQWlDLFNBQXNDO01BQ25GLElBQU0sUUFBUSxHQUFHLElBQUEsQ0FBSyxTQUF0QixDQURtRjs7TUFJbkYsS0FBSyxJQUFNLFdBQVgsSUFBMEIsT0FBMUIsRUFBbUM7UUFDakMsSUFBTSxVQUFVLEdBQUcsV0FBbkIsQ0FBQTtRQUNBLElBQU0sYUFBYSxHQUFHLElBQUEsQ0FBSyxPQUFMLENBQWEsVUFBYixDQUF0QixDQUFBO1FBQ0EsSUFBTSxXQUFnQixHQUFHLE9BQU8sQ0FBQyxVQUFELENBQWhDLENBSGlDOztRQU1qQyxJQUFJLFVBQVUsS0FBSyxXQUFuQixFQUFnQztVQUM5QixJQUFBLENBQUssd0JBQUwsQ0FBOEIsVUFBOUIsRUFBMEMsYUFBYSxDQUFDLFNBQXhELEVBQW1FLFdBQW5FLENBQUEsQ0FBQTtTQVArQjs7O1FBV2pDLElBQUksRUFBRSxDQUFDLEtBQUgsQ0FBYyxXQUFkLENBQUosRUFBZ0M7VUFDN0IsYUFBYSxDQUFDLFVBQUQsQ0FBZCxHQUFxQyxHQUFHLENBQUMsSUFBSixDQUFTLFdBQVQsQ0FBckMsQ0FBQTtTQURGO2FBSUssSUFBSSxFQUFFLENBQUMsV0FBSCxDQUFlLFdBQWYsQ0FBSixFQUFpQzs7WUFFbkMsYUFBYSxDQUFDLFVBQUQsQ0FBZCxHQUFxQyxDQUFBLENBQUEsRUFBQSxPQUFBLENBQUEsU0FBQSxDQUFBLEVBQ25DLGFBQWEsQ0FBQyxVQUFELENBQWIsSUFBNkIsRUFETSxFQUVuQyxDQUFBLENBQUEsRUFBQSxNQUFBLENBQUEsU0FBQSxDQUFBLEVBQU0sV0FBTixDQUZtQyxDQUFyQyxDQUZvQzs7WUFPcEMsSUFBSSxFQUFFLENBQUMsTUFBSCxDQUFVLFFBQVEsQ0FBQyxTQUFULENBQW1CLFVBQW5CLENBQVYsQ0FBQSxJQUE2QyxTQUFBLElBQWMsUUFBUSxDQUFDLFNBQVQsQ0FBbUIsVUFBbkIsQ0FBL0QsRUFBdUc7Y0FDcEcsYUFBYSxDQUFDLFVBQUQsQ0FBZCxDQUFtQyxPQUFuQyxHQUE2QyxXQUFXLENBQUMsT0FBWixLQUF3QixLQUFyRSxDQUFBO2FBQ0Q7V0FURTtlQVlBLElBQUksRUFBRSxDQUFDLElBQUgsQ0FBUSxXQUFSLENBQUEsSUFBd0IsRUFBRSxDQUFDLE1BQUgsQ0FBVSxRQUFRLENBQUMsU0FBVCxDQUFtQixVQUFuQixDQUFWLENBQTVCLEVBQXVFO2NBQ3pFLGFBQWEsQ0FBQyxVQUFELENBQWQsQ0FBbUMsT0FBbkMsR0FBNkMsV0FBN0MsQ0FBQTthQURHO2lCQUlBO2dCQUNGLGFBQWEsQ0FBQyxVQUFELENBQWQsR0FBcUMsV0FBckMsQ0FBQTtlQUNEO09BQ0Y7S0FDRjs7Ozs7Ozs7Ozs7NEJBU1EsU0FBMkI7TUFDbEMsT0FBTyxHQUFHLE9BQU8sS0FBSyxFQUFFLENBQUMsT0FBSCxDQUFXLElBQUEsQ0FBSyxNQUFoQixDQUFBLEdBQ2xCLElBQUEsQ0FBSyxNQURhLEdBRWxCLElBRmEsQ0FBakIsQ0FBQTs7TUFJQSxJQUFJLEVBQUUsQ0FBQyxNQUFILENBQVUsSUFBQSxDQUFLLE1BQWYsQ0FBSixFQUE0QjtRQUMxQixPQUFPLEdBQUcsT0FBTyxJQUFJLElBQUEsQ0FBSyxRQUFMLENBQWMsYUFBZCxDQUE0QixJQUFBLENBQUssTUFBakMsQ0FBckIsQ0FBQTtPQUNEOztNQUVELE9BQU8sQ0FBQSxDQUFBLEVBQUEsYUFBQSxDQUFBLGNBQUEsRUFBZSxPQUFmLENBQVAsQ0FBQTtLQUNEOzs7Ozs7Ozs7Ozs7Z0NBVVksU0FBNkM7TUFDeEQsSUFBSSxFQUFFLENBQUMsSUFBSCxDQUFRLE9BQVIsQ0FBSixFQUFzQjtRQUNwQixJQUFBLENBQUssT0FBTCxHQUFlLE9BQWYsQ0FBQTtRQUVBLE9BQU8sSUFBUCxDQUFBO09BQ0Q7O01BRUQsSUFBSSxPQUFPLEtBQUssSUFBaEIsRUFBc0I7UUFDcEIsT0FBTyxJQUFBLENBQUssT0FBWixDQUFBO1FBRUEsT0FBTyxJQUFQLENBQUE7T0FDRDs7TUFFRCxPQUFPLElBQUEsQ0FBSyxPQUFaLENBQUE7S0FDRDs7O3NDQUVrQixZQUFvQyxVQUFlO01BQ3BFLElBQUksQ0FBQSxDQUFBLEVBQUEsYUFBQSxDQUFBLFdBQUEsRUFBWSxRQUFaLENBQUEsSUFBeUIsRUFBRSxDQUFDLE1BQUgsQ0FBVSxRQUFWLENBQTdCLEVBQWtEO1FBQy9DLElBQUEsQ0FBSyxPQUFMLENBQWEsVUFBYixDQUFELEdBQW9DLFFBQXBDLENBQUE7O1FBRUEsS0FBSyxJQUFNLE1BQVgsSUFBcUIsSUFBQSxDQUFLLFFBQUwsQ0FBYyxHQUFuQyxFQUF3QztVQUNyQyxJQUFBLENBQUssT0FBTCxDQUFhLE1BQWIsQ0FBQSxDQUFxQixVQUFyQixDQUFELEdBQTRDLFFBQTVDLENBQUE7U0FDRDs7UUFFRCxPQUFPLElBQVAsQ0FBQTtPQUNEOztNQUVELE9BQU8sSUFBQSxDQUFLLE9BQUwsQ0FBYSxVQUFiLENBQVAsQ0FBQTtLQUNEOzs7Ozs7Ozs7Ozs7OzsyQkFZTyxVQUFlO01BQ3JCLE9BQU8sSUFBQSxDQUFLLGlCQUFMLENBQXVCLFFBQXZCLEVBQWlDLFFBQWpDLENBQVAsQ0FBQTtLQUNEOzs7Ozs7Ozs7Ozs7Z0NBVVksVUFBbUI7TUFDOUIsSUFBSSxRQUFRLEtBQUssTUFBYixJQUF1QixRQUFRLEtBQUssUUFBeEMsRUFBa0Q7UUFDaEQsSUFBQSxDQUFLLE9BQUwsQ0FBYSxXQUFiLEdBQTJCLFFBQTNCLENBQUE7UUFFQSxPQUFPLElBQVAsQ0FBQTtPQUNEOztNQUVELE9BQU8sSUFBQSxDQUFLLE9BQUwsQ0FBYSxXQUFwQixDQUFBO0tBQ0Q7Ozs7Ozs7Ozs7OEJBUVU7TUFDVCxPQUFPLElBQUEsQ0FBSyxRQUFaLENBQUE7S0FDRDs7OzhCQUVVLFNBQTBCO01BQ25DLE9BQVEsSUFBQSxDQUFLLFFBQUwsS0FBa0IsT0FBTyxDQUFDLGFBQTFCLElBQ0EsQ0FBQSxDQUFBLEVBQUEsYUFBQSxDQUFBLFlBQUEsRUFBYSxJQUFBLENBQUssUUFBbEIsRUFBNEIsT0FBNUIsQ0FEUixDQUFBO0tBRUQ7OztvQ0FJQyxTQUNBLFlBQ0EsYUFDQTtNQUNBLE9BQVEsQ0FBQyxJQUFBLENBQUssVUFBTCxDQUFnQixPQUFPLENBQUMsVUFBeEIsRUFBb0MsVUFBcEMsRUFBZ0QsV0FBaEQsQ0FBRCxJQUNBLElBQUEsQ0FBSyxTQUFMLENBQWUsT0FBTyxDQUFDLFNBQXZCLEVBQWtDLFVBQWxDLEVBQThDLFdBQTlDLENBRFIsQ0FBQTtLQUVEOzs7OEJBSUMsV0FDQSxZQUNBLFNBQ0E7TUFDQSxJQUFJLENBQUMsU0FBTCxFQUFnQjtRQUFFLE9BQU8sSUFBUCxDQUFBO09BQWE7O01BRS9CLElBQUksQ0FBQyxFQUFFLENBQUMsT0FBSCxDQUFXLE9BQVgsQ0FBTCxFQUEwQjtRQUFFLE9BQU8sS0FBUCxDQUFBO09BQWM7O01BRTFDLElBQUksRUFBRSxDQUFDLE1BQUgsQ0FBVSxTQUFWLENBQUosRUFBMEI7UUFDeEIsT0FBTyxDQUFBLENBQUEsRUFBQSxhQUFBLENBQUEsV0FBQSxFQUFZLE9BQVosRUFBcUIsU0FBckIsRUFBZ0MsVUFBaEMsQ0FBUCxDQUFBO09BREYsTUFHSyxJQUFJLEVBQUUsQ0FBQyxPQUFILENBQVcsU0FBWCxDQUFKLEVBQTJCO1FBQzlCLE9BQU8sQ0FBQSxDQUFBLEVBQUEsYUFBQSxDQUFBLFlBQUEsRUFBYSxTQUFiLEVBQXdCLE9BQXhCLENBQVAsQ0FBQTtPQUNEOztNQUVELE9BQU8sS0FBUCxDQUFBO0tBQ0Q7OzsrQkFJQyxZQUNBLFlBQ0EsU0FDQTtNQUNBLElBQUksQ0FBQyxVQUFELElBQWUsQ0FBQyxFQUFFLENBQUMsT0FBSCxDQUFXLE9BQVgsQ0FBcEIsRUFBeUM7UUFBRSxPQUFPLEtBQVAsQ0FBQTtPQUFjOztNQUV6RCxJQUFJLEVBQUUsQ0FBQyxNQUFILENBQVUsVUFBVixDQUFKLEVBQTJCO1FBQ3pCLE9BQU8sQ0FBQSxDQUFBLEVBQUEsYUFBQSxDQUFBLFdBQUEsRUFBWSxPQUFaLEVBQXFCLFVBQXJCLEVBQWlDLFVBQWpDLENBQVAsQ0FBQTtPQURGLE1BR0ssSUFBSSxFQUFFLENBQUMsT0FBSCxDQUFXLFVBQVgsQ0FBSixFQUE0QjtRQUMvQixPQUFPLENBQUEsQ0FBQSxFQUFBLGFBQUEsQ0FBQSxZQUFBLEVBQWEsVUFBYixFQUF5QixPQUF6QixDQUFQLENBQUE7T0FDRDs7TUFFRCxPQUFPLEtBQVAsQ0FBQTtLQUNEOzs7Ozs7Ozs7Ozs7eUJBVUssUUFBZ0I7TUFDcEIsSUFBQSxDQUFLLE1BQUwsQ0FBWSxJQUFaLENBQWlCLE1BQWpCLENBQUEsQ0FBQTtNQUVBLE9BQU8sSUFBUCxDQUFBO0tBQ0Q7OzsyQkFFTyxRQUFzQixTQUE4QixhQUE0QyxTQUFlO01BQ3JILElBQUksRUFBRSxDQUFDLE1BQUgsQ0FBVSxPQUFWLENBQUEsSUFBc0IsQ0FBQyxFQUFFLENBQUMsS0FBSCxDQUFTLE9BQVQsQ0FBM0IsRUFBOEM7UUFDNUMsT0FBTyxHQUFHLFdBQVYsQ0FBQTtRQUNBLFdBQVcsR0FBRyxJQUFkLENBQUE7T0FDRDs7TUFFRCxJQUFNLFNBQVMsR0FBRyxNQUFNLEtBQUssSUFBWCxHQUFrQixLQUFsQixHQUEwQixRQUE1QyxDQUFBO01BQ0EsSUFBTSxTQUFTLEdBQUcsQ0FBQSxDQUFBLEVBQUEsbUJBQUEsQ0FBQSxTQUFBLENBQUEsRUFBbUIsT0FBbkIsRUFBNEIsV0FBNUIsQ0FBbEIsQ0FBQTs7TUFFQSxLQUFLLElBQUksSUFBVCxJQUFpQixTQUFqQixFQUE0QjtRQUMxQixJQUFJLElBQUksS0FBSyxPQUFiLEVBQXNCO1VBQUUsSUFBSSxHQUFHLFFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBUSxVQUFmLENBQUE7U0FBMkI7O1FBRW5ELEtBQUEsSUFBQSxFQUFBLEdBQUEsQ0FBQSxFQUFBLEVBQUEsR0FBdUIsU0FBUyxDQUFDLElBQUQsQ0FBaEMsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQXdDO1VBQUEsSUFBQSxJQUFBLENBQUE7O1VBQUEsSUFBQSxHQUFqQixTQUFTLENBQUMsSUFBRCxDQUFRLENBQUEsRUFBQSxDQUFBLENBQUE7VUFBQSxJQUE3QixRQUE2QixHQUFBLElBQUEsQ0FBQTs7O1VBRXRDLElBQUksQ0FBQSxDQUFBLEVBQUEsTUFBQSxDQUFBLGdCQUFBLEVBQWlCLElBQWpCLEVBQXVCLElBQUEsQ0FBSyxRQUE1QixDQUFKLEVBQTJDO1lBQ3pDLElBQUEsQ0FBSyxNQUFMLENBQVksTUFBWixDQUFBLENBQW9CLElBQXBCLEVBQTBCLFFBQTFCLENBQUEsQ0FBQTtXQURGO2VBSUssSUFBSSxFQUFFLENBQUMsTUFBSCxDQUFVLElBQUEsQ0FBSyxNQUFmLENBQUosRUFBNEI7Y0FDL0IsT0FBQSxDQUFBLFNBQUEsQ0FBQSxDQUFBLEVBQUEsQ0FBQSxNQUFBLENBQVUsU0FBVixFQUFBLFVBQUEsQ0FBQSxDQUFBLENBQW1FLElBQUEsQ0FBSyxNQUF4RSxFQUFnRixJQUFBLENBQUssUUFBckYsRUFBK0YsSUFBL0YsRUFBcUcsUUFBckcsRUFBK0csT0FBL0csQ0FBQSxDQUFBO2FBREc7aUJBSUE7Z0JBQ0YsT0FBQSxDQUFBLFNBQUEsQ0FBQSxDQUFPLFNBQVAsQ0FBRCxDQUE0QyxJQUFBLENBQUssTUFBakQsRUFBeUQsSUFBekQsRUFBK0QsUUFBL0QsRUFBeUUsT0FBekUsQ0FBQSxDQUFBO2VBQ0Q7U0FDRjtPQUNGOztNQUVELE9BQU8sSUFBUCxDQUFBO0tBQ0Q7Ozs7Ozs7Ozs7Ozs7O3VCQVlHLE9BQTRCLFVBQWtDLFNBQWU7TUFDL0UsT0FBTyxJQUFBLENBQUssTUFBTCxDQUFZLElBQVosRUFBa0IsS0FBbEIsRUFBeUIsUUFBekIsRUFBbUMsT0FBbkMsQ0FBUCxDQUFBO0tBQ0Q7Ozs7Ozs7Ozs7Ozs7O3dCQVlJLE9BQWdELFVBQWtDLFNBQWU7TUFDcEcsT0FBTyxJQUFBLENBQUssTUFBTCxDQUFZLEtBQVosRUFBbUIsS0FBbkIsRUFBMEIsUUFBMUIsRUFBb0MsT0FBcEMsQ0FBUCxDQUFBO0tBQ0Q7Ozs7Ozs7Ozs7d0JBUUksU0FBOEI7TUFDakMsSUFBTSxRQUFRLEdBQUcsSUFBQSxDQUFLLFNBQXRCLENBQUE7O01BRUEsSUFBSSxDQUFDLEVBQUUsQ0FBQyxNQUFILENBQVUsT0FBVixDQUFMLEVBQXlCO1FBQ3ZCLE9BQU8sR0FBRyxFQUFWLENBQUE7T0FDRDs7TUFFQSxJQUFBLENBQUssT0FBTixHQUFzQyxDQUFBLENBQUEsRUFBQSxNQUFBLENBQUEsU0FBQSxDQUFBLEVBQU0sUUFBUSxDQUFDLElBQWYsQ0FBdEMsQ0FBQTs7TUFFQSxLQUFLLElBQU0sV0FBWCxJQUEwQixJQUFBLENBQUssUUFBTCxDQUFjLFVBQXhDLEVBQW9EO1FBQ2xELElBQU0sVUFBVSxHQUFHLFdBQW5CLENBQUE7UUFDQSxJQUFNLFVBQVUsR0FBRyxJQUFBLENBQUssUUFBTCxDQUFjLFVBQWQsQ0FBeUIsVUFBekIsQ0FBbkIsQ0FBQTtRQUVBLElBQUEsQ0FBSyxPQUFMLENBQWEsVUFBYixDQUFBLEdBQTJCLEVBQTNCLENBQUE7UUFDQSxJQUFBLENBQUssWUFBTCxDQUFrQixVQUFsQixFQUE4QixDQUFBLENBQUEsRUFBQSxPQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sQ0FBQSxDQUFBLEVBQUEsT0FBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLEVBQVAsRUFBVyxRQUFRLENBQUMsU0FBcEIsQ0FBUCxFQUF1QyxRQUFRLENBQUMsT0FBVCxDQUFpQixVQUFqQixDQUF2QyxDQUE5QixDQUFBLENBQUE7UUFFQSxJQUFBLENBQUssVUFBTCxDQUFBLENBQWlCLE9BQU8sQ0FBQyxVQUFELENBQXhCLENBQUEsQ0FBQTtPQUNEOztNQUVELEtBQUssSUFBTSxPQUFYLElBQXNCLE9BQXRCLEVBQStCO1FBQzdCLElBQUksRUFBRSxDQUFDLElBQUgsQ0FBUSxJQUFBLENBQUssT0FBTCxDQUFSLENBQUosRUFBNEI7VUFDMUIsSUFBQSxDQUFLLE9BQUwsQ0FBQSxDQUFjLE9BQU8sQ0FBQyxPQUFELENBQXJCLENBQUEsQ0FBQTtTQUNEO09BQ0Y7O01BRUQsT0FBTyxJQUFQLENBQUE7S0FDRDs7Ozs7Ozs7Ozs0QkFRUTtNQUNQLE9BQUEsQ0FBQSxTQUFBLENBQUEsQ0FBTyxNQUFQLENBQWMsSUFBQSxDQUFLLE1BQW5CLEVBQW1DLEtBQW5DLENBQUEsQ0FBQTs7TUFFQSxJQUFJLEVBQUUsQ0FBQyxNQUFILENBQVUsSUFBQSxDQUFLLE1BQWYsQ0FBSixFQUE0Qjs7UUFFMUIsS0FBSyxJQUFNLElBQVgsSUFBbUIsT0FBQSxDQUFBLFNBQUEsQ0FBQSxDQUFPLGVBQTFCLEVBQTJDO1VBQ3pDLElBQU0sU0FBUyxHQUFHLE9BQUEsQ0FBQSxTQUFBLENBQUEsQ0FBTyxlQUFQLENBQXVCLElBQXZCLENBQWxCLENBQUE7O1VBRUEsSUFBSSxTQUFTLENBQUMsU0FBVixDQUFvQixDQUFwQixDQUFBLEtBQTJCLElBQUEsQ0FBSyxNQUFoQyxJQUNBLFNBQVMsQ0FBQyxRQUFWLENBQW1CLENBQW5CLENBQUEsS0FBMEIsSUFBQSxDQUFLLFFBRG5DLEVBQzZDO1lBQzNDLFNBQVMsQ0FBQyxTQUFWLENBQW9CLE1BQXBCLENBQTJCLENBQTNCLEVBQThCLENBQTlCLENBQUEsQ0FBQTtZQUNBLFNBQVMsQ0FBQyxRQUFWLENBQW1CLE1BQW5CLENBQTBCLENBQTFCLEVBQTZCLENBQTdCLENBQUEsQ0FBQTtZQUNBLFNBQVMsQ0FBQyxTQUFWLENBQW9CLE1BQXBCLENBQTJCLENBQTNCLEVBQThCLENBQTlCLENBQUEsQ0FBQTtXQUNEOztVQUVELE9BQUEsQ0FBQSxTQUFBLENBQUEsQ0FBTyxNQUFQLENBQWMsSUFBQSxDQUFLLFFBQW5CLEVBQTZCLElBQTdCLEVBQW1DLE9BQUEsQ0FBQSxTQUFBLENBQUEsQ0FBTyxnQkFBMUMsQ0FBQSxDQUFBOztVQUNBLE9BQUEsQ0FBQSxTQUFBLENBQUEsQ0FBTyxNQUFQLENBQWMsSUFBQSxDQUFLLFFBQW5CLEVBQTZCLElBQTdCLEVBQW1DLE9BQUEsQ0FBQSxTQUFBLENBQUEsQ0FBTyxrQkFBMUMsRUFBOEQsSUFBOUQsQ0FBQSxDQUFBO1NBQ0Q7T0FkSCxNQWdCSztRQUNILE9BQUEsQ0FBQSxTQUFBLENBQUEsQ0FBTyxNQUFQLENBQWMsSUFBQSxDQUFLLE1BQW5CLEVBQW1DLEtBQW5DLENBQUEsQ0FBQTtPQUNEO0tBQ0Y7Ozs7Ozs7ZUFHWTs7Ozs7Ozs7Ozs7Ozs7O0FDMVlmLElBQUEsV0FBQSxHQUFBLHNCQUFBLENBQUEsZUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxLQUFBLEdBQUEsdUJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLGVBQUEsR0FBQSxzQkFBQSxDQUFBLG1CQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFVBQUEsR0FBQSxzQkFBQSxDQUFBLGNBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsYUFBQSxHQUFBLHNCQUFBLENBQUEscUJBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsZ0JBQUEsR0FBQSxzQkFBQSxDQUFBLG9CQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLGNBQUEsR0FBQSxzQkFBQSxDQUFBLGtCQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLGFBQUEsR0FBQSxzQkFBQSxDQUFBLHFCQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7SUF3QkUsR0FBQSxHQUlFLEtBQUEsQ0FKRixHQUFBO0lBQ0EsT0FBQSxHQUdFLEtBQUEsQ0FIRixPQUFBO0lBQ0EsR0FBQSxHQUVFLEtBQUEsQ0FGRixHQUFBO0lBQ0EsTUFBQSxHQUNFLEtBQUEsQ0FERixNQUFBLENBQUE7O0FBZ0JLLFNBQVMsV0FBVCxHQUF3QjtFQUM3QixPQUFPLElBQUksS0FBSixFQUFQLENBQUE7Q0FDRDs7SUFZWSxLQUFBLGdCQUFBLFlBQUE7Ozs7O0VBZ0RYLFNBQUEsS0FBQSxHQUFlO0lBQUEsSUFBQSxLQUFBLEdBQUEsSUFBQSxDQUFBOztJQUFBLGVBQUEsQ0FBQSxJQUFBLEVBQUEsS0FBQSxDQUFBLENBQUE7O0lBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxJQUFBLEVBQUEsbUJBQUEsQ0FBQSxNQUFBLENBL0NVLElBQUksQ0FBQyxLQUFMLENBQVcsSUFBSSxDQUFDLE1BQUwsRUFBQSxHQUFnQixHQUEzQixDQStDVixDQUFBLENBQUEsQ0FBQTs7SUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLGVBQUEsRUE5Q0MsS0E4Q0QsQ0FBQSxDQUFBOztJQUFBLGVBQUEsQ0FBQSxJQUFBLEVBQUEsY0FBQSxFQTFDVixFQTBDVSxDQUFBLENBQUE7O0lBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxTQUFBLEVBeENMLE9Bd0NLLENBQUEsQ0FBQTs7SUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLFFBQUEsRUF2Q04sTUF1Q00sQ0FBQSxDQUFBOztJQUFBLGVBQUEsQ0FBQSxJQUFBLEVBQUEsT0FBQSxFQXRDUCxLQXNDTyxDQUFBLENBQUE7O0lBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxVQUFBLEVBckNNLEtBQUssQ0FBQyxLQUFOLENBQVksZUFBQSxDQUFBLFNBQUEsQ0FBWixDQXFDTixDQUFBLENBQUE7O0lBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxXQUFBLEVBcENILFVBQUEsQ0FBQSxTQUFBLENBb0NHLENBQUEsQ0FBQTs7SUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLFNBQUEsRUFuQ0k7TUFDakIsR0FBRyxFQUFFLEVBRFk7TUFFakIsTUFBTSxFQUFFO1FBQ04sS0FBSyxFQUFFLElBREQ7UUFFTixJQUFJLEVBQUUsSUFGQTtRQUdOLEdBQUcsRUFBRSxJQUFBO09BTFU7TUFPakIsVUFBVSxFQUFFLEVBUEs7TUFRakIsY0FBYyxFQUFFLEVBQUE7S0EyQkgsQ0FBQSxDQUFBOztJQUFBLGVBQUEsQ0FBQSxJQUFBLEVBQUEsZUFBQSxFQXhCQyxjQUFBLENBQUEsU0FBQSxDQXdCRCxDQUFBLENBQUE7O0lBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxjQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLGVBQUEsRUF0QkMsSUFBSSxnQkFBQSxDQUFBLFNBQUEsQ0FBSixDQUFvQixJQUFwQixDQXNCRCxDQUFBLENBQUE7O0lBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxNQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLFVBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLGVBQUEsQ0FBQSxJQUFBLEVBQUEsUUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxXQUFBLEVBVnFDLEVBVXJDLENBQUEsQ0FBQTs7SUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLFVBQUEsRUFMWDtNQUNGLElBQUksRUFBRSxFQURKO01BRUYsR0FBRyxFQUFFLEVBQUE7S0FHUSxDQUFBLENBQUE7O0lBQUEsZUFBQSxDQUFBLElBQUEsRUFBQSxnQkFBQSxFQXNDRSxVQUFDLEtBQUQsRUFBQTtNQUFBLE9BQThCLEtBQUksQ0FBQyxjQUFMLENBQW9CLEtBQUssQ0FBQyxNQUExQixDQUE5QixDQUFBO0tBdENGLENBQUEsQ0FBQTs7SUFDYixJQUFNLEtBQUssR0FBRyxJQUFkLENBQUE7O0lBRUEsSUFBQSxDQUFLLFlBQUwsZ0JBQUEsVUFBQSxpQkFBQSxFQUFBO01BQUEsU0FBQSxDQUFBLE1BQUEsRUFBQSxpQkFBQSxDQUFBLENBQUE7O01BQUEsU0FBQSxNQUFBLEdBQUE7UUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLE1BQUEsQ0FBQSxDQUFBOztRQUFBLE9BQUEsMEJBQUEsQ0FBQSxJQUFBLEVBQUEsZUFBQSxDQUFBLE1BQUEsQ0FBQSxDQUFBLEtBQUEsQ0FBQSxJQUFBLEVBQUEsU0FBQSxDQUFBLENBQUEsQ0FBQTtPQUFBOztNQUFBLFlBQUEsQ0FBQSxNQUFBLEVBQUEsQ0FBQTtRQUFBLEdBQUEsRUFBQSxLQUFBO1FBQUEsS0FBQSxFQUFBLFNBQUEsR0FBQSxDQUdPLE9BSFAsRUFHa0M7VUFDOUIsSUFBQSxDQUFBLGVBQUEsQ0FBQSxNQUFBLENBQUEsU0FBQSxDQUFBLEVBQUEsS0FBQSxFQUFBLElBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBQSxJQUFBLEVBQVUsT0FBVixDQUFBLENBQUE7O1VBRUEsS0FBSyxDQUFDLElBQU4sQ0FBVyxrQkFBWCxFQUErQjtZQUM3QixPQUFPLEVBQVAsT0FENkI7WUFFN0IsWUFBWSxFQUFFLElBQUE7V0FGaEIsQ0FBQSxDQUFBO1VBS0EsT0FBTyxJQUFQLENBQUE7U0FDRDtPQVpILEVBQUE7UUFBQSxHQUFBLEVBQUEsT0FBQTtRQUFBLEtBQUEsRUFBQSxTQUFBLEtBQUEsR0FjVztVQUNQLElBQUEsQ0FBQSxlQUFBLENBQUEsTUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFBLE9BQUEsRUFBQSxJQUFBLENBQUEsQ0FBQSxJQUFBLENBQUEsSUFBQSxDQUFBLENBQUE7O1VBQ0EsS0FBSyxDQUFDLGFBQU4sQ0FBb0IsSUFBcEIsQ0FBeUIsTUFBekIsQ0FBZ0MsS0FBSyxDQUFDLGFBQU4sQ0FBb0IsSUFBcEIsQ0FBeUIsT0FBekIsQ0FBaUMsSUFBakMsQ0FBaEMsRUFBd0UsQ0FBeEUsQ0FBQSxDQUFBO1VBRUEsS0FBSyxDQUFDLElBQU4sQ0FBVyxvQkFBWCxFQUFpQztZQUFFLFlBQVksRUFBRSxJQUFBO1dBQWpELENBQUEsQ0FBQTtTQUNEO09BbkJILEVBQUE7UUFBQSxHQUFBLEVBQUEsV0FBQTtRQUFBLEdBQUEsRUFBQSxTQUFBLEdBQUEsR0FDbUI7VUFBRSxPQUFPLEtBQUssQ0FBQyxRQUFiLENBQUE7U0FBdUI7T0FENUMsQ0FBQSxDQUFBLENBQUE7O01BQUEsT0FBQSxNQUFBLENBQUE7S0FBQSxDQUFrQyxhQUFBLENBQUEsU0FBQSxDQUFsQyxDQUFBLENBQUE7R0FxQkQ7Ozs7aUNBRWEsR0FBQSxFQUFrQixFQUFBLEVBQWE7TUFDM0MsSUFBQSxDQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUI7UUFBRSxFQUFFLEVBQUYsRUFBRjtRQUFNLEdBQUcsRUFBSCxHQUFBO09BQTdCLENBQUEsQ0FBQTtLQUNEOzs7eUJBRTZCLElBQUEsRUFBUyxHQUFBLEVBQWtDO01BQ3ZFLEtBQUEsSUFBQSxFQUFBLEdBQUEsQ0FBQSxFQUFBLEVBQUEsR0FBNEMsSUFBQSxDQUFLLFlBQWpELENBQUEsTUFBQSxFQUFBLEVBQUEsRUFBQSxFQUErRDtRQUFBLElBQUEsSUFBQSxDQUFBOztRQUFBLElBQUEsR0FBbkIsSUFBQSxDQUFLLFlBQWMsQ0FBQSxFQUFBLENBQUEsQ0FBQTtRQUFBLElBQUEsS0FBQSxHQUFBLElBQUE7WUFBbkMsUUFBbUMsR0FBQSxLQUFBLENBQWxELEdBQWtELENBQTFDLElBQTBDLENBQUEsQ0FBQTs7UUFDN0QsSUFBSSxDQUFDLENBQUMsUUFBRixJQUFjLFFBQVEsQ0FBQyxHQUFELEVBQWEsSUFBYixFQUFtQixJQUFuQixDQUFSLEtBQThDLEtBQWhFLEVBQXVFO1VBQ3JFLE9BQU8sS0FBUCxDQUFBO1NBQ0Q7T0FDRjtLQUNGOzs7eUJBSUssTUFBQSxFQUFnQjtNQUNwQixPQUFPLElBQUEsQ0FBSyxhQUFMLEdBQ0gsSUFERyxHQUVILFNBQVMsQ0FBQyxJQUFELEVBQU8sTUFBUCxDQUZiLENBQUE7S0FHRDs7O3NDQUVrQixNQUFBLEVBQWdCO01BQ2pDLE9BQU8sSUFBQSxDQUFLLFFBQUwsQ0FBYyxHQUFkLENBQWtCLE1BQU0sQ0FBQyxFQUF6QixDQUFBLElBQWdDLElBQUEsQ0FBSyxRQUFMLENBQWMsSUFBZCxDQUFtQixPQUFuQixDQUEyQixNQUEzQixDQUFBLEtBQXVDLENBQUMsQ0FBL0UsQ0FBQTtLQUNEOzs7OEJBRVUsTUFBQSxFQUFnQixPQUFBLEVBQWtDO01BQzNELElBQUksSUFBQSxDQUFLLGlCQUFMLENBQXVCLE1BQXZCLENBQUosRUFBb0M7UUFDbEMsT0FBTyxJQUFQLENBQUE7T0FDRDs7TUFFRCxJQUFJLE1BQU0sQ0FBQyxFQUFYLEVBQWU7UUFBRSxJQUFBLENBQUssUUFBTCxDQUFjLEdBQWQsQ0FBa0IsTUFBTSxDQUFDLEVBQXpCLENBQUEsR0FBK0IsTUFBL0IsQ0FBQTtPQUF1Qzs7TUFDeEQsSUFBQSxDQUFLLFFBQUwsQ0FBYyxJQUFkLENBQW1CLElBQW5CLENBQXdCLE1BQXhCLENBQUEsQ0FBQTs7TUFFQSxJQUFJLE1BQU0sQ0FBQyxPQUFYLEVBQW9CO1FBQ2xCLE1BQU0sQ0FBQyxPQUFQLENBQWUsSUFBZixFQUFxQixPQUFyQixDQUFBLENBQUE7T0FDRDs7TUFFRCxJQUFJLE1BQU0sQ0FBQyxTQUFQLElBQW9CLE1BQU0sQ0FBQyxNQUEvQixFQUF1QztRQUNyQyxJQUFJLE1BQUssR0FBRyxDQUFaLENBQUE7UUFDQSxJQUFNLEdBQUcsR0FBRyxJQUFBLENBQUssWUFBTCxDQUFrQixNQUE5QixDQUFBO1FBQ0EsSUFBTSxNQUFNLEdBQUcsTUFBTSxDQUFDLE1BQVAsQ0FBYyxNQUFkLENBQXFCLFVBQUMsR0FBRCxFQUFNLEVBQU4sRUFBYTtVQUMvQyxHQUFHLENBQUMsRUFBRCxDQUFILEdBQVUsSUFBVixDQUFBO1VBQ0EsT0FBTyxHQUFQLENBQUE7U0FGYSxFQUdaLEVBSFksQ0FBZixDQUFBOztRQUtBLE9BQU8sTUFBSyxHQUFHLEdBQWYsRUFBb0IsTUFBSyxFQUF6QixFQUE2QjtVQUMzQixJQUFNLE9BQU8sR0FBRyxJQUFBLENBQUssWUFBTCxDQUFrQixNQUFsQixDQUFBLENBQXlCLEVBQXpDLENBQUE7O1VBRUEsSUFBSSxNQUFNLENBQUMsT0FBRCxDQUFWLEVBQXFCO1lBQUUsTUFBQTtXQUFPO1NBQy9COztRQUVELElBQUEsQ0FBSyxZQUFMLENBQWtCLE1BQWxCLENBQXlCLE1BQXpCLEVBQWdDLENBQWhDLEVBQW1DO1VBQUUsRUFBRSxFQUFFLE1BQU0sQ0FBQyxFQUFiO1VBQWlCLEdBQUcsRUFBRSxNQUFNLENBQUMsU0FBQTtTQUFoRSxDQUFBLENBQUE7T0FkRixNQWdCSyxJQUFJLE1BQU0sQ0FBQyxTQUFYLEVBQXNCO1FBQ3pCLElBQUEsQ0FBSyxZQUFMLENBQWtCLElBQWxCLENBQXVCO1VBQUUsRUFBRSxFQUFFLE1BQU0sQ0FBQyxFQUFiO1VBQWlCLEdBQUcsRUFBRSxNQUFNLENBQUMsU0FBQTtTQUFwRCxDQUFBLENBQUE7T0FDRDs7TUFFRCxPQUFPLElBQVAsQ0FBQTtLQUNEOzs7Z0NBRVksR0FBQSxFQUFlLE9BQUEsRUFBNkI7O01BRXZELElBQUksSUFBQSxDQUFLLFdBQUwsQ0FBaUIsR0FBakIsQ0FBQSxLQUEwQixDQUFDLENBQS9CLEVBQWtDO1FBQUUsT0FBTyxLQUFQLENBQUE7T0FBYzs7TUFFbEQsSUFBTSxNQUFNLEdBQUcsR0FBRyxDQUFDLFNBQUosQ0FBYyxHQUFkLENBQWYsQ0FBQTtNQUVBLE9BQU8sR0FBRyxPQUFPLEdBQUcsS0FBSyxDQUFDLE1BQU4sQ0FBYSxFQUFiLEVBQWlCLE9BQWpCLENBQUgsR0FBK0IsRUFBaEQsQ0FBQTtNQUVBLElBQUEsQ0FBSyxTQUFMLENBQWUsSUFBZixDQUFvQjtRQUFFLEdBQUcsRUFBSCxHQUFGO1FBQU8sT0FBTyxFQUFQLE9BQUE7T0FBM0IsQ0FBQSxDQUFBO01BQ0EsTUFBTSxDQUFDLFNBQVAsQ0FBaUIsSUFBakIsQ0FBc0IsR0FBdEIsQ0FBQSxDQVR1RDs7O01BYXZELElBQUksR0FBRyxLQUFLLElBQUEsQ0FBSyxRQUFqQixFQUEyQjtRQUN6QixNQUFNLENBQUMsR0FBUCxDQUFXLE1BQVgsRUFBbUIsUUFBbkIsRUFBNkIsSUFBQSxDQUFLLGNBQWxDLENBQUEsQ0FBQTtPQUNEOztNQUVELElBQUEsQ0FBSyxJQUFMLENBQVUsb0JBQVYsRUFBZ0M7UUFBRSxHQUFHLEVBQUgsR0FBRjtRQUFPLE1BQU0sRUFBTixNQUFQO1FBQWUsS0FBSyxFQUFFLElBQXRCO1FBQTRCLE9BQU8sRUFBUCxPQUFBO09BQTVELENBQUEsQ0FBQTtLQUNEOzs7bUNBRWUsR0FBQSxFQUFlO01BQzdCLElBQU0sS0FBSyxHQUFHLElBQUEsQ0FBSyxXQUFMLENBQWlCLEdBQWpCLENBQWQsQ0FBQTtNQUVBLElBQU0sTUFBTSxHQUFHLEdBQUcsQ0FBQyxTQUFKLENBQWMsR0FBZCxDQUFmLENBQUE7TUFDQSxJQUFNLE9BQU8sR0FBRyxJQUFBLENBQUssU0FBTCxDQUFlLEtBQWYsQ0FBQSxDQUFzQixPQUF0QyxDQUFBO01BRUEsTUFBTSxDQUFDLE1BQVAsQ0FBYyxNQUFkLEVBQXNCLFFBQXRCLEVBQWdDLElBQUEsQ0FBSyxjQUFyQyxDQUFBLENBQUE7TUFFQSxJQUFBLENBQUssU0FBTCxDQUFlLE1BQWYsQ0FBc0IsS0FBdEIsRUFBNkIsQ0FBN0IsQ0FBQSxDQUFBO01BQ0EsTUFBTSxDQUFDLFNBQVAsQ0FBaUIsTUFBakIsQ0FBd0IsS0FBeEIsRUFBK0IsQ0FBL0IsQ0FBQSxDQUFBO01BRUEsSUFBQSxDQUFLLElBQUwsQ0FBVSx1QkFBVixFQUFtQztRQUFFLEdBQUcsRUFBSCxHQUFGO1FBQU8sTUFBTSxFQUFOLE1BQVA7UUFBZSxLQUFLLEVBQUUsSUFBdEI7UUFBNEIsT0FBTyxFQUFQLE9BQUE7T0FBL0QsQ0FBQSxDQUFBO0tBQ0Q7OztnQ0FFWSxHQUFBLEVBQWU7TUFDMUIsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFiLEVBQWdCLENBQUMsR0FBRyxJQUFBLENBQUssU0FBTCxDQUFlLE1BQW5DLEVBQTJDLENBQUMsRUFBNUMsRUFBZ0Q7UUFDOUMsSUFBSSxJQUFBLENBQUssU0FBTCxDQUFlLENBQWYsQ0FBQSxDQUFrQixHQUFsQixLQUEwQixHQUE5QixFQUFtQztVQUNqQyxPQUFPLENBQVAsQ0FBQTtTQUNEO09BQ0Y7O01BRUQsT0FBTyxDQUFDLENBQVIsQ0FBQTtLQUNEOzs7a0NBRWMsR0FBQSxFQUFlO01BQzVCLElBQU0sUUFBUSxHQUFHLElBQUEsQ0FBSyxXQUFMLENBQWlCLEdBQWpCLENBQWpCLENBQUE7TUFFQSxPQUFPLFFBQVEsS0FBSyxDQUFDLENBQWQsR0FBa0IsSUFBbEIsR0FBeUIsSUFBQSxDQUFLLFNBQUwsQ0FBZSxRQUFmLENBQUEsQ0FBeUIsT0FBekQsQ0FBQTtLQUNEOzs7MEJBRU07TUFDTCxPQUFPLENBQUUsSUFBQSxDQUFLLE1BQU4sQ0FBcUIsSUFBckIsSUFBNEMsSUFBN0MsRUFBbUQsR0FBbkQsRUFBUCxDQUFBO0tBQ0Q7Ozs7Ozs7O0FBR0ksU0FBUyxnQkFBVCxDQUEyQixJQUEzQixFQUF5QyxPQUF6QyxFQUEyRDtFQUNoRSxJQUFJLE9BQU8sQ0FBQyxjQUFSLENBQXVCLElBQXZCLENBQUosRUFBa0M7SUFBRSxPQUFPLElBQVAsQ0FBQTtHQUFhOztFQUVqRCxLQUFLLElBQU0sSUFBWCxJQUFtQixPQUFPLENBQUMsR0FBM0IsRUFBZ0M7SUFDOUIsSUFBSSxJQUFJLENBQUMsT0FBTCxDQUFhLElBQWIsQ0FBQSxLQUF1QixDQUF2QixJQUE0QixJQUFJLENBQUMsTUFBTCxDQUFZLElBQUksQ0FBQyxNQUFqQixDQUFBLElBQTRCLE9BQU8sQ0FBQyxNQUFwRSxFQUE0RTtNQUMxRSxPQUFPLElBQVAsQ0FBQTtLQUNEO0dBQ0Y7O0VBRUQsT0FBTyxLQUFQLENBQUE7Q0FDRDs7QUFFTSxTQUFTLFNBQVQsQ0FBb0IsS0FBcEIsRUFBa0MsTUFBbEMsRUFBa0Q7RUFDdkQsS0FBSyxDQUFDLGFBQU4sR0FBc0IsSUFBdEIsQ0FBQTtFQUNBLEdBQUcsQ0FBQyxJQUFKLENBQVMsTUFBVCxDQUFBLENBQUE7O0VBQ0EsV0FBQSxDQUFBLFNBQUEsQ0FBQSxDQUFXLElBQVgsQ0FBZ0IsTUFBaEIsQ0FBQSxDQUFBOztFQUNBLE9BQU8sQ0FBQyxJQUFSLENBQWEsTUFBYixDQUFBLENBQUE7RUFDQSxHQUFHLENBQUMsSUFBSixDQUFTLE1BQVQsQ0FBQSxDQUFBO0VBQ0EsTUFBTSxDQUFDLElBQVAsQ0FBWSxNQUFaLENBQUEsQ0FBQTtFQUVBLEtBQUssQ0FBQyxTQUFOLENBQWdCLGFBQUEsQ0FBQSxTQUFBLENBQWhCLENBQUEsQ0FBQTtFQUNBLEtBQUssQ0FBQyxRQUFOLEdBQWlCLE1BQU0sQ0FBQyxRQUF4QixDQUFBO0VBQ0EsS0FBSyxDQUFDLE1BQU4sR0FBZSxNQUFmLENBQUE7RUFFQSxPQUFPLEtBQVAsQ0FBQTtDQUNEOzs7Ozs7Ozs7OztBQ3JSRCxJQUFBLFFBQUEsR0FBQSxzQkFBQSxDQUFBLFlBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsV0FBQSxHQUFBLHNCQUFBLENBQUEsZUFBQSxDQUFBLENBQUE7O0FBQ0EsMEVBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsc0JBQUEsQ0FBQSxXQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFlBQUEsR0FBQSx1QkFBQSxDQUFBLGlCQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFlBQUEsR0FBQSxzQkFBQSxDQUFBLGdCQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLGtCQUFBLEdBQUEsc0JBQUEsQ0FBQSxzQkFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxNQUFBLEdBQUEsY0FBQSxDQUFBOztBQUNBLElBQUEsMkJBQUEsR0FBQSxzQkFBQSxDQUFBLCtCQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQXlCQSxJQUFNLFdBQVcsR0FBRyxDQUNsQixhQURrQixFQUNILGFBREcsRUFDWSxXQURaLEVBRWxCLGVBRmtCLEVBRUQsZUFGQyxFQUVnQixZQUZoQixDQUFwQixDQUFBOztBQUtBLFNBQVMsT0FBVCxDQUFrQixLQUFsQixFQUFnQztFQUM5QixJQUFNLFNBQVMsR0FBRyxFQUFsQixDQUFBOztFQUVBLEtBQUEsSUFBQSxFQUFBLEdBQUEsQ0FBQSxFQUFBLEVBQUEsR0FBcUIsV0FBckIsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQWtDO0lBQUEsSUFBQSxJQUFBLENBQUE7O0lBQUEsSUFBQSxHQUFiLFdBQWEsQ0FBQSxFQUFBLENBQUEsQ0FBQTtJQUFBLElBQXZCLE1BQXVCLEdBQUEsSUFBQSxDQUFBO0lBQ2hDLFNBQVMsQ0FBQyxNQUFELENBQVQsR0FBb0IsZ0JBQWdCLENBQUMsTUFBRCxFQUFTLEtBQVQsQ0FBcEMsQ0FBQTtHQUNEOztFQUVELElBQU0sV0FBVyxHQUFHLFFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBUSxXQUE1QixDQUFBO0VBQ0EsSUFBSSxTQUFKLENBQUE7O0VBRUEsSUFBSSxXQUFBLENBQUEsU0FBQSxDQUFBLENBQVcsWUFBZixFQUE2QjtJQUMzQixTQUFTLEdBQUcsQ0FDVjtNQUFFLElBQUksRUFBRSxXQUFXLENBQUMsSUFBcEI7TUFBNEIsUUFBUSxFQUFFLDJCQUFBO0tBRDVCLEVBRVY7TUFBRSxJQUFJLEVBQUUsV0FBVyxDQUFDLElBQXBCO01BQTRCLFFBQVEsRUFBRSxTQUFTLENBQUMsV0FBQTtLQUZ0QyxFQUdWO01BQUUsSUFBSSxFQUFFLFdBQVcsQ0FBQyxJQUFwQjtNQUE0QixRQUFRLEVBQUUsU0FBUyxDQUFDLFdBQUE7S0FIdEMsRUFJVjtNQUFFLElBQUksRUFBRSxXQUFXLENBQUMsRUFBcEI7TUFBNEIsUUFBUSxFQUFFLFNBQVMsQ0FBQyxTQUFBO0tBSnRDLEVBS1Y7TUFBRSxJQUFJLEVBQUUsV0FBVyxDQUFDLE1BQXBCO01BQTRCLFFBQVEsRUFBRSxTQUFTLENBQUMsU0FBQTtLQUx0QyxDQUFaLENBQUE7R0FERixNQVNLO0lBQ0gsU0FBUyxHQUFHLENBQ1Y7TUFBRSxJQUFJLEVBQUUsV0FBUjtNQUFxQixRQUFRLEVBQUUsU0FBUyxDQUFDLFdBQUE7S0FEL0IsRUFFVjtNQUFFLElBQUksRUFBRSxXQUFSO01BQXFCLFFBQVEsRUFBRSxTQUFTLENBQUMsV0FBQTtLQUYvQixFQUdWO01BQUUsSUFBSSxFQUFFLFNBQVI7TUFBbUIsUUFBUSxFQUFFLFNBQVMsQ0FBQyxTQUFBO0tBSDdCLEVBS1Y7TUFBRSxJQUFJLEVBQUUsWUFBUjtNQUFzQixRQUFRLEVBQUUsMkJBQUE7S0FMdEIsRUFNVjtNQUFFLElBQUksRUFBRSxZQUFSO01BQXNCLFFBQVEsRUFBRSxTQUFTLENBQUMsV0FBQTtLQU5oQyxFQU9WO01BQUUsSUFBSSxFQUFFLFdBQVI7TUFBcUIsUUFBUSxFQUFFLFNBQVMsQ0FBQyxXQUFBO0tBUC9CLEVBUVY7TUFBRSxJQUFJLEVBQUUsVUFBUjtNQUFvQixRQUFRLEVBQUUsU0FBUyxDQUFDLFNBQUE7S0FSOUIsRUFTVjtNQUFFLElBQUksRUFBRSxhQUFSO01BQXVCLFFBQVEsRUFBRSxTQUFTLENBQUMsU0FBQTtLQVRqQyxDQUFaLENBQUE7R0FXRDs7RUFFRCxTQUFTLENBQUMsSUFBVixDQUFlO0lBQ2IsSUFBSSxFQUFFLE1BRE87SUFFYixRQUZhLEVBQUEsU0FBQSxRQUFBLENBRUgsS0FGRyxFQUVJO01BQ2YsS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUEwQixLQUFLLENBQUMsWUFBTixDQUFtQixJQUE3QyxDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBbUQ7UUFBQSxJQUFBLEtBQUEsQ0FBQTs7UUFBQSxLQUFBLEdBQXpCLEtBQUssQ0FBQyxZQUFOLENBQW1CLElBQU0sQ0FBQSxHQUFBLENBQUEsQ0FBQTtRQUFBLElBQXhDLFdBQXdDLEdBQUEsS0FBQSxDQUFBO1FBQ2pELFdBQVcsQ0FBQyxZQUFaLENBQXlCLEtBQXpCLENBQUEsQ0FBQTtPQUNEO0tBQ0Y7R0FOSCxDQUFBLENBakM4Qjs7RUEyQzlCLEtBQUssQ0FBQyxhQUFOLEdBQXNCLENBQXRCLENBQUE7O0VBRUEsS0FBSyxDQUFDLFdBQU4sZ0JBQUEsVUFBQSxnQkFBQSxFQUFBO0lBQUEsU0FBQSxDQUFBLE1BQUEsRUFBQSxnQkFBQSxDQUFBLENBQUE7O0lBQUEsU0FBQSxNQUFBLEdBQUE7TUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLE1BQUEsQ0FBQSxDQUFBOztNQUFBLE9BQUEsMEJBQUEsQ0FBQSxJQUFBLEVBQUEsZUFBQSxDQUFBLE1BQUEsQ0FBQSxDQUFBLEtBQUEsQ0FBQSxJQUFBLEVBQUEsU0FBQSxDQUFBLENBQUEsQ0FBQTtLQUFBOztJQUFBLFlBQUEsQ0FBQSxNQUFBLEVBQUEsQ0FBQTtNQUFBLEdBQUEsRUFBQSxNQUFBO01BQUEsS0FBQSxFQUFBLFNBQUEsSUFBQSxHQVNVO1FBQUUsT0FBTyxLQUFLLENBQUMsR0FBTixFQUFQLENBQUE7T0FBb0I7S0FUaEMsRUFBQTtNQUFBLEdBQUEsRUFBQSxzQkFBQTtNQUFBLEdBQUEsRUFBQSxTQUFBLEdBQUEsR0FDOEI7UUFDMUIsT0FBTyxLQUFLLENBQUMsWUFBTixDQUFtQixvQkFBMUIsQ0FBQTtPQUZKO01BQUEsR0FBQSxFQUFBLFNBQUEsR0FBQSxDQUs0QixLQUw1QixFQUttQztRQUMvQixLQUFLLENBQUMsWUFBTixDQUFtQixvQkFBbkIsR0FBMEMsS0FBMUMsQ0FBQTtPQUNEO0tBUEgsQ0FBQSxDQUFBLENBQUE7O0lBQUEsT0FBQSxNQUFBLENBQUE7R0FBQSxDQUFrRSxZQUFBLENBQUEsU0FBQSxDQUFsRSxDQUFBLENBQUE7O0VBWUEsS0FBSyxDQUFDLFlBQU4sR0FBcUI7O0lBRW5CLElBQUksRUFBRSxFQUZhO0lBQUEsS0FBQSxFQUFBLFNBQUEsSUFBQSxDQUdpQixPQUhqQixFQUcrRTtNQUNoRyxPQUFPLENBQUMsU0FBUixHQUFvQixVQUFDLElBQUQsRUFBTyxHQUFQLEVBQUE7UUFBQSxPQUFlLEtBQUssQ0FBQyxJQUFOLENBQVcsSUFBWCxFQUFpQixHQUFqQixDQUFmLENBQUE7T0FBcEIsQ0FBQTs7TUFFQSxJQUFNLFdBQVcsR0FBRyxJQUFJLEtBQUssQ0FBQyxXQUFWLENBQXlCLE9BQXpCLENBQXBCLENBQUE7TUFFQSxLQUFLLENBQUMsWUFBTixDQUFtQixJQUFuQixDQUF3QixJQUF4QixDQUE2QixXQUE3QixDQUFBLENBQUE7TUFDQSxPQUFPLFdBQVAsQ0FBQTtLQVRpQjtJQVduQixTQUFTLEVBQVQsU0FYbUI7SUFZbkIsU0FBUyxFQUFULFNBWm1CO0lBYW5CLG9CQUFvQixFQUFFLENBQUE7R0FieEIsQ0FBQTs7RUFnQkEsU0FBUywyQkFBVCxHQUF3Qzs7SUFFdEMsS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUEwQixLQUFLLENBQUMsWUFBTixDQUFtQixJQUE3QyxDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBbUQ7TUFBQSxJQUFBLEtBQUEsQ0FBQTs7TUFBQSxLQUFBLEdBQXpCLEtBQUssQ0FBQyxZQUFOLENBQW1CLElBQU0sQ0FBQSxHQUFBLENBQUEsQ0FBQTtNQUFBLElBQXhDLFdBQXdDLEdBQUEsS0FBQSxDQUFBOztNQUNqRCxJQUFJLENBQUMsV0FBVyxDQUFDLGFBQWIsSUFDRixXQUFXLENBQUMsV0FBWixLQUE0QixPQUQxQixJQUVGLFdBQVcsQ0FBQyxZQUZkLEVBRTRCO1FBQzFCLFNBQUE7T0FKK0M7OztNQUFBLElBQUEsS0FBQSxHQUFBLFNBQUEsS0FBQSxHQUFBO1FBQUEsS0FBQSxHQVEzQixXQUFXLENBQUMsUUFSZSxDQUFBLEdBQUEsQ0FBQSxDQUFBO1FBQUEsSUFRdEMsT0FSc0MsR0FBQSxLQUFBLENBQUE7O1FBUy9DLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBTixDQUFnQixJQUFoQixDQUFxQixVQUFBLEtBQUEsRUFBQTtVQUFBLElBQUcsR0FBSCxHQUFBLEtBQUEsQ0FBRyxHQUFILENBQUE7VUFBQSxPQUFhLENBQUEsQ0FBQSxFQUFBLGFBQUEsQ0FBQSxZQUFBLEVBQWEsR0FBYixFQUFrQixPQUFPLENBQUMsVUFBMUIsQ0FBYixDQUFBO1NBQXJCLENBQUwsRUFBK0U7O1VBRTdFLFdBQVcsQ0FBQyxhQUFaLENBQTBCLE9BQU8sQ0FBQyxPQUFsQyxFQUEyQyxPQUFPLENBQUMsS0FBbkQsQ0FBQSxDQUFBO1NBQ0Q7T0FaOEMsQ0FBQTs7TUFRakQsS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUFzQixXQUFXLENBQUMsUUFBbEMsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQTRDO1FBQUEsSUFBQSxLQUFBLENBQUE7O1FBQUEsS0FBQSxFQUFBLENBQUE7T0FLM0M7S0FDRjtHQUNGOztFQUVELEtBQUssQ0FBQyxTQUFOLENBQWdCLDJCQUFBLENBQUEsU0FBQSxDQUFoQixDQUFBLENBQUE7Q0FDRDs7QUFFRCxTQUFTLGdCQUFULENBQTJCLE1BQTNCLEVBQW1DLEtBQW5DLEVBQTBDO0VBQ3hDLE9BQU8sVUFBVSxLQUFWLEVBQWlCO0lBQ3RCLElBQU0sWUFBWSxHQUFHLEtBQUssQ0FBQyxZQUFOLENBQW1CLElBQXhDLENBQUE7SUFFQSxJQUFNLFdBQVcsR0FBRyxZQUFZLENBQUMsY0FBYixDQUE0QixLQUE1QixDQUFwQixDQUFBOztJQUhzQixJQUFBLHFCQUFBLEdBSWdCLFlBQVksQ0FBQyxlQUFiLENBQTZCLEtBQTdCLENBSmhCO1FBQUEsc0JBQUEsR0FBQSxjQUFBLENBQUEscUJBQUEsRUFBQSxDQUFBLENBQUE7UUFJZixXQUplLEdBQUEsc0JBQUEsQ0FBQSxDQUFBLENBQUE7UUFJRixjQUpFLEdBQUEsc0JBQUEsQ0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFLdEIsSUFBTSxPQUFPLEdBQUcsRUFBaEIsQ0FMc0I7O0lBT3RCLElBQUksUUFBQSxDQUFTLElBQVQsQ0FBYyxLQUFLLENBQUMsSUFBcEIsQ0FBSixFQUErQjtNQUM3QixLQUFLLENBQUMsYUFBTixHQUFzQixLQUFLLENBQUMsR0FBTixFQUF0QixDQUFBOztNQUVBLEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBMkIsS0FBSyxDQUFDLGNBQWpDLENBQUEsTUFBQSxFQUFBLEdBQUEsRUFBQSxFQUFpRDtRQUFBLElBQUEsS0FBQSxDQUFBOztRQUFBLEtBQUEsR0FBdEIsS0FBSyxDQUFDLGNBQWdCLENBQUEsR0FBQSxDQUFBLENBQUE7UUFBQSxJQUF0QyxZQUFzQyxHQUFBLEtBQUEsQ0FBQTtRQUMvQyxJQUFNLE9BQU8sR0FBRyxZQUFoQixDQUFBO1FBQ0EsSUFBTSxTQUFTLEdBQUcsWUFBWSxDQUFDLFlBQWIsQ0FBMEIsT0FBMUIsQ0FBbEIsQ0FBQTtRQUNBLElBQU0sYUFBNEIsR0FBRztVQUNuQyxPQUFPLEVBQVAsT0FEbUM7VUFFbkMsU0FBUyxFQUFULFNBRm1DO1VBR25DLFdBQVcsRUFBWCxXQUhtQztVQUluQyxTQUFTLEVBQUUsS0FBSyxDQUFDLElBSmtCO1VBS25DLFdBQVcsRUFBWCxXQUxtQztVQU1uQyxjQUFjLEVBQWQsY0FObUM7VUFPbkMsS0FBSyxFQUFMLEtBQUE7U0FQRixDQUFBO1FBU0EsSUFBTSxXQUFXLEdBQUcsY0FBYyxDQUFDLGFBQUQsQ0FBbEMsQ0FBQTtRQUVBLE9BQU8sQ0FBQyxJQUFSLENBQWEsQ0FDWCxhQUFhLENBQUMsT0FESCxFQUVYLGFBQWEsQ0FBQyxXQUZILEVBR1gsYUFBYSxDQUFDLGNBSEgsRUFJWCxXQUpXLENBQWIsQ0FBQSxDQUFBO09BTUQ7S0F2QkgsTUF5Qks7TUFDSCxJQUFJLGNBQWMsR0FBRyxLQUFyQixDQUFBOztNQUVBLElBQUksQ0FBQyxRQUFBLENBQUEsU0FBQSxDQUFBLENBQVEsb0JBQVQsSUFBaUMsT0FBQSxDQUFRLElBQVIsQ0FBYSxLQUFLLENBQUMsSUFBbkIsQ0FBckMsRUFBK0Q7O1FBRTdELEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBYixFQUFnQixDQUFDLEdBQUcsWUFBWSxDQUFDLE1BQWpCLElBQTJCLENBQUMsY0FBNUMsRUFBNEQsQ0FBQyxFQUE3RCxFQUFpRTtVQUMvRCxjQUFjLEdBQUcsWUFBWSxDQUFDLENBQUQsQ0FBWixDQUFnQixXQUFoQixLQUFnQyxPQUFoQyxJQUEyQyxZQUFZLENBQUMsQ0FBRCxDQUFaLENBQWdCLGFBQTVFLENBQUE7U0FIMkQ7Ozs7UUFRN0QsY0FBYyxHQUFHLGNBQWMsSUFDNUIsS0FBSyxDQUFDLEdBQU4sRUFBQSxHQUFjLEtBQUssQ0FBQyxhQUFwQixHQUFvQyxHQUR0QjtRQUdmLEtBQUssQ0FBQyxTQUFOLEtBQW9CLENBSHRCLENBQUE7T0FJRDs7TUFFRCxJQUFJLENBQUMsY0FBTCxFQUFxQjtRQUNuQixJQUFNLGNBQWEsR0FBRztVQUNwQixPQUFPLEVBQUUsS0FEVztVQUVwQixTQUFTLEVBQUUsWUFBWSxDQUFDLFlBQWIsQ0FBMEIsS0FBMUIsQ0FGUztVQUdwQixXQUFXLEVBQVgsV0FIb0I7VUFJcEIsU0FBUyxFQUFFLEtBQUssQ0FBQyxJQUpHO1VBS3BCLGNBQWMsRUFBZCxjQUxvQjtVQU1wQixXQUFXLEVBQVgsV0FOb0I7VUFPcEIsS0FBSyxFQUFMLEtBQUE7U0FQRixDQUFBOztRQVVBLElBQU0sWUFBVyxHQUFHLGNBQWMsQ0FBQyxjQUFELENBQWxDLENBQUE7O1FBRUEsT0FBTyxDQUFDLElBQVIsQ0FBYSxDQUNYLGNBQWEsQ0FBQyxPQURILEVBRVgsY0FBYSxDQUFDLFdBRkgsRUFHWCxjQUFhLENBQUMsY0FISCxFQUlYLFlBSlcsQ0FBYixDQUFBLENBQUE7T0FNRDtLQXBFbUI7OztJQXdFdEIsS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUFrRSxPQUFsRSxDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBMkU7TUFBQSxJQUFBLFdBQUEsR0FBQSxjQUFBLENBQVQsT0FBUyxDQUFBLEdBQUEsQ0FBQSxFQUFBLENBQUEsQ0FBQTtVQUEvRCxRQUErRCxHQUFBLFdBQUEsQ0FBQSxDQUFBLENBQUE7VUFBdEQsWUFBc0QsR0FBQSxXQUFBLENBQUEsQ0FBQSxDQUFBO1VBQXpDLGVBQXlDLEdBQUEsV0FBQSxDQUFBLENBQUEsQ0FBQTtVQUF6QixhQUF5QixHQUFBLFdBQUEsQ0FBQSxDQUFBLENBQUEsQ0FBQTs7TUFDekUsYUFBVyxDQUFDLE1BQUQsQ0FBWCxDQUFvQixRQUFwQixFQUE2QixLQUE3QixFQUFvQyxZQUFwQyxFQUFpRCxlQUFqRCxDQUFBLENBQUE7S0FDRDtHQTFFSCxDQUFBO0NBNEVEOztBQUVELFNBQVMsY0FBVCxDQUF5QixhQUF6QixFQUF1RDtFQUFBLElBQzdDLFdBRDZDLEdBQ3RCLGFBRHNCLENBQzdDLFdBRDZDO01BQ2hDLEtBRGdDLEdBQ3RCLGFBRHNCLENBQ2hDLEtBRGdDLENBQUE7O0VBR3JELElBQU0sZ0JBQWdCLEdBQUcsa0JBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBTyxNQUFQLENBQWMsYUFBZCxDQUF6QixDQUFBOztFQUNBLElBQU0sU0FBUyxHQUFHO0lBQUUsV0FBVyxFQUFFLGdCQUFmO0lBQWlDLGFBQWEsRUFBYixhQUFBO0dBQW5ELENBQUE7RUFFQSxLQUFLLENBQUMsSUFBTixDQUFXLG1CQUFYLEVBQWdDLFNBQWhDLENBQUEsQ0FBQTtFQUVBLE9BQU8sU0FBUyxDQUFDLFdBQVYsSUFBeUIsS0FBSyxDQUFDLFlBQU4sQ0FBQSxLQUFBLENBQUEsQ0FBdUI7SUFBRSxXQUFXLEVBQVgsV0FBQTtHQUF6QixDQUFoQyxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxXQUFULENBQUEsS0FBQSxFQUFpSSxlQUFqSSxFQUFvSztFQUFBLElBQWxGLEdBQWtGLEdBQUEsS0FBQSxDQUFsRixHQUFrRjtNQUE3RSxLQUE2RSxHQUFBLEtBQUEsQ0FBN0UsS0FBNkU7TUFBdEUsT0FBc0UsR0FBQSxLQUFBLENBQXRFLE9BQXNFLENBQUE7RUFBQSxJQUMxSixTQUQwSixHQUM1SSxLQUFLLENBQUMsWUFEc0ksQ0FDMUosU0FEMEosQ0FBQTtFQUVsSyxJQUFNLFdBQVcsR0FBRyxPQUFBLENBQUEsU0FBQSxDQUFBLENBQU8sZUFBUCxDQUFwQixDQUFBOztFQUVBLElBQUksS0FBSyxDQUFDLE9BQU4sQ0FBYyxLQUFkLElBQXVCLENBQUMsT0FBTyxDQUFDLE1BQXBDLEVBQTRDO0lBQzFDLE9BQU8sQ0FBQyxNQUFSLEdBQWlCO01BQUUsT0FBTyxFQUFFLEtBQUE7S0FBNUIsQ0FBQTtHQUxnSzs7O0VBU2xLLEtBQUssSUFBTSxTQUFYLElBQXdCLE9BQUEsQ0FBQSxTQUFBLENBQUEsQ0FBTyxlQUEvQixFQUFnRDtJQUM5QyxXQUFXLENBQUMsR0FBRCxFQUFNLFNBQU4sRUFBaUIsT0FBQSxDQUFBLFNBQUEsQ0FBQSxDQUFPLGdCQUF4QixDQUFYLENBQUE7SUFDQSxXQUFXLENBQUMsR0FBRCxFQUFNLFNBQU4sRUFBaUIsT0FBQSxDQUFBLFNBQUEsQ0FBQSxDQUFPLGtCQUF4QixFQUE0QyxJQUE1QyxDQUFYLENBQUE7R0FDRDs7RUFFRCxJQUFNLFlBQVksR0FBRyxPQUFPLElBQUksT0FBTyxDQUFDLE1BQXhDLENBQUE7O0VBRUEsS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUFpQyxTQUFqQyxDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBNEM7SUFBQSxJQUFBLEtBQUEsQ0FBQTs7SUFBQSxLQUFBLEdBQVgsU0FBVyxDQUFBLEdBQUEsQ0FBQSxDQUFBO0lBQUEsSUFBQSxLQUFBLEdBQUEsS0FBQTtRQUEvQixLQUErQixHQUFBLEtBQUEsQ0FBL0IsSUFBK0I7UUFBekIsUUFBeUIsR0FBQSxLQUFBLENBQXpCLFFBQXlCLENBQUE7SUFDMUMsV0FBVyxDQUFDLEdBQUQsRUFBTSxLQUFOLEVBQVksUUFBWixFQUFzQixZQUF0QixDQUFYLENBQUE7R0FDRDtDQUNGOztBQUVELElBQU0sWUFBNkIsR0FBRztFQUNwQyxFQUFFLEVBQUUsbUJBRGdDO0VBRXBDLE9BQU8sRUFBUCxPQUZvQztFQUdwQyxTQUFTLEVBQUU7SUFDVCxvQkFBQSxFQUFzQixTQUFBLGdCQUFBLENBQUEsR0FBRyxFQUFBO01BQUEsT0FBSSxXQUFXLENBQUMsR0FBRCxFQUFNLEtBQU4sQ0FBZixDQUFBO0tBRGhCO0lBRVQsdUJBQUEsRUFBeUIsU0FBQSxtQkFBQSxDQUFBLEdBQUcsRUFBQTtNQUFBLE9BQUksV0FBVyxDQUFDLEdBQUQsRUFBTSxRQUFOLENBQWYsQ0FBQTtLQUZuQjtJQUdULG9CQUFBLEVBQXNCLFNBQUEsaUJBQUEsQ0FBQSxNQUFBLEVBQW1CLEtBQW5CLEVBQTZCO01BQUEsSUFBMUIsWUFBMEIsR0FBQSxNQUFBLENBQTFCLFlBQTBCLENBQUE7OztNQUVqRCxLQUFLLElBQUksQ0FBQyxHQUFHLEtBQUssQ0FBQyxZQUFOLENBQW1CLElBQW5CLENBQXdCLE1BQXhCLEdBQWlDLENBQTlDLEVBQWlELENBQUMsSUFBSSxDQUF0RCxFQUF5RCxDQUFDLEVBQTFELEVBQThEO1FBQzVELElBQU0sV0FBVyxHQUFHLEtBQUssQ0FBQyxZQUFOLENBQW1CLElBQW5CLENBQXdCLENBQXhCLENBQXBCLENBQUE7O1FBRUEsSUFBSSxXQUFXLENBQUMsWUFBWixLQUE2QixZQUFqQyxFQUErQztVQUFFLFNBQUE7U0FBVTs7UUFFM0QsV0FBVyxDQUFDLElBQVosRUFBQSxDQUFBO1FBQ0EsS0FBSyxDQUFDLElBQU4sQ0FBVyxzQkFBWCxFQUFtQztVQUFFLFdBQVcsRUFBWCxXQUFBO1NBQXJDLENBQUEsQ0FBQTtRQUNBLFdBQVcsQ0FBQyxPQUFaLEVBQUEsQ0FBQTs7UUFFQSxJQUFJLEtBQUssQ0FBQyxZQUFOLENBQW1CLElBQW5CLENBQXdCLE1BQXhCLEdBQWlDLENBQXJDLEVBQXdDO1VBQ3RDLEtBQUssQ0FBQyxZQUFOLENBQW1CLElBQW5CLENBQXdCLE1BQXhCLENBQStCLENBQS9CLEVBQWtDLENBQWxDLENBQUEsQ0FBQTtTQUNEO09BQ0Y7S0FDRjtHQXJCaUM7RUF1QnBDLFdBQVcsRUFBWCxXQXZCb0M7RUF3QnBDLGdCQUFnQixFQUFoQixnQkF4Qm9DO0VBeUJwQyxXQUFXLEVBQVgsV0FBQTtDQXpCRixDQUFBO2VBNEJlOzs7OztBQ2hSZjs7Ozs7Ozs7Ozs7ZUNBZSxTQUFBLFFBQUEsQ0FBQyxLQUFELEVBQUE7RUFBQSxPQUFnQixDQUFDLEVBQUUsS0FBSyxJQUFJLEtBQUssQ0FBQyxNQUFqQixDQUFELElBQThCLEtBQUssWUFBWSxLQUFLLENBQUMsTUFBckUsQ0FBQTs7Ozs7Ozs7Ozs7Ozs7O0FDQWYsSUFBQSxTQUFBLEdBQUEsc0JBQUEsQ0FBQSxhQUFBLENBQUEsQ0FBQTs7OztBQUVBLElBQU0sR0FBRyxHQUFHO0VBQ1YsVUFBVSxFQUFFLFNBREY7RUFFVixNQUFNLEVBQUUsU0FGRTtFQUdWLFNBQVMsRUFBVCxTQUhVO0VBSVYsSUFBSSxFQUFKLElBQUE7Q0FKRixDQUFBOztBQU9PLFNBQVMsSUFBVCxDQUFlLE1BQWYsRUFBb0U7O0VBR3pFLEdBQUcsQ0FBQyxVQUFKLEdBQWlCLE1BQWpCLENBSHlFOztFQU16RSxJQUFNLEVBQUUsR0FBRyxNQUFNLENBQUMsUUFBUCxDQUFnQixjQUFoQixDQUErQixFQUEvQixDQUFYLENBTnlFOztFQVN6RSxJQUFJLEVBQUUsQ0FBQyxhQUFILEtBQXFCLE1BQU0sQ0FBQyxRQUE1QixJQUNBLE9BQU8sTUFBTSxDQUFDLElBQWQsS0FBdUIsVUFEdkIsSUFFRixNQUFNLENBQUMsSUFBUCxDQUFZLEVBQVosQ0FBQSxLQUFvQixFQUZ0QixFQUUwQjs7SUFFeEIsTUFBTSxHQUFHLE1BQU0sQ0FBQyxJQUFQLENBQVksTUFBWixDQUFULENBQUE7R0FDRDs7RUFFRCxHQUFHLENBQUMsTUFBSixHQUFhLE1BQWIsQ0FBQTtDQUNEOztBQUVELElBQUksT0FBTyxNQUFQLEtBQWtCLFdBQXRCLEVBQW1DO0VBQ2pDLEdBQUcsQ0FBQyxNQUFKLEdBQWlCLFNBQWpCLENBQUE7RUFDQSxHQUFHLENBQUMsVUFBSixHQUFpQixTQUFqQixDQUFBO0NBRkYsTUFJSztFQUNILElBQUksQ0FBQyxNQUFELENBQUosQ0FBQTtDQUNEOztBQUVNLFNBQVMsU0FBVCxDQUFvQixJQUFwQixFQUErQjtFQUNwQyxJQUFJLENBQUEsQ0FBQSxFQUFBLFNBQUEsQ0FBQSxTQUFBLENBQUEsRUFBUyxJQUFULENBQUosRUFBb0I7SUFDbEIsT0FBTyxJQUFQLENBQUE7R0FDRDs7RUFFRCxJQUFNLFFBQVEsR0FBSSxJQUFJLENBQUMsYUFBTCxJQUFzQixJQUF4QyxDQUFBO0VBRUEsT0FBTyxRQUFRLENBQUMsV0FBVCxJQUF3QixHQUFHLENBQUMsTUFBbkMsQ0FBQTtDQUNEOztBQUVELEdBQUcsQ0FBQyxJQUFKLEdBQVcsSUFBWCxDQUFBO29CQUVlOzs7Ozs7Ozs7OztBQzlDZixJQUFBLGNBQUEsR0FBQSwyQkFBQSxDQUFBLGFBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsUUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7Ozs7OztBQUVPLElBQU0sV0FBTSxHQUFHLFNBQVQsTUFBUyxDQUFDLEtBQUQsRUFBQTtFQUFBLE9BQ3BCLEtBQUssS0FBSyxRQUFBLENBQUEsU0FBQSxDQUFBLENBQUksTUFBZCxJQUF3QixDQUFBLENBQUEsRUFBQSxjQUFBLENBQUEsU0FBQSxDQUFBLEVBQVMsS0FBVCxDQURKLENBQUE7Q0FBZixDQUFBOzs7O0FBR0EsSUFBTSxPQUFPLEdBQUcsU0FBVixPQUFVLENBQUMsS0FBRCxFQUFBO0VBQUEsT0FDckIsTUFBTSxDQUFDLEtBQUQsQ0FBTixJQUFpQixLQUFLLENBQUMsUUFBTixLQUFtQixFQURmLENBQUE7Q0FBaEIsQ0FBQTs7OztBQUdBLElBQU0sTUFBTSxHQUFHLFNBQVQsTUFBUyxDQUFDLEtBQUQsRUFBQTtFQUFBLE9BQ3BCLENBQUMsQ0FBQyxLQUFGLElBQVksT0FBQSxDQUFPLEtBQVAsQ0FBQSxLQUFpQixRQURULENBQUE7Q0FBZixDQUFBOzs7O0FBR0EsSUFBTSxJQUFJLEdBQUcsU0FBUCxJQUFPLENBQUMsS0FBRCxFQUFBO0VBQUEsT0FDbEIsT0FBTyxLQUFQLEtBQWlCLFVBREMsQ0FBQTtDQUFiLENBQUE7Ozs7QUFHQSxJQUFNLE1BQU0sR0FBRyxTQUFULE1BQVMsQ0FBQyxLQUFELEVBQUE7RUFBQSxPQUNwQixPQUFPLEtBQVAsS0FBaUIsUUFERyxDQUFBO0NBQWYsQ0FBQTs7OztBQUdBLElBQU0sSUFBSSxHQUFHLFNBQVAsSUFBTyxDQUFDLEtBQUQsRUFBQTtFQUFBLE9BQ2xCLE9BQU8sS0FBUCxLQUFpQixTQURDLENBQUE7Q0FBYixDQUFBOzs7O0FBR0EsSUFBTSxNQUFNLEdBQUcsU0FBVCxNQUFTLENBQUMsS0FBRCxFQUFBO0VBQUEsT0FDcEIsT0FBTyxLQUFQLEtBQWlCLFFBREcsQ0FBQTtDQUFmLENBQUE7Ozs7QUFHQSxJQUFNLE9BQU8sR0FBRyxTQUFWLE9BQVUsQ0FBQyxLQUFELEVBQTJDO0VBQ2hFLElBQUksQ0FBQyxLQUFELElBQVcsT0FBQSxDQUFPLEtBQVAsQ0FBQSxLQUFpQixRQUFoQyxFQUEyQztJQUFFLE9BQU8sS0FBUCxDQUFBO0dBQWM7O0VBRTNELElBQU0sT0FBTyxHQUFHLFFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBSSxTQUFKLENBQWMsS0FBZCxDQUFBLElBQXdCLFFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBSSxNQUE1QyxDQUFBOztFQUVBLE9BQVEsaUJBQUEsQ0FBa0IsSUFBbEIsQ0FBQSxPQUFBLENBQThCLE9BQU8sQ0FBQyxPQUF0QyxDQUFBLENBQUEsR0FDSixLQUFLLFlBQVksT0FBTyxDQUFDLE9BRHJCO0lBRUosS0FBSyxDQUFDLFFBQU4sS0FBbUIsQ0FBbkIsSUFBd0IsT0FBTyxLQUFLLENBQUMsUUFBYixLQUEwQixRQUZ0RCxDQUFBO0NBTEssQ0FBQTs7OztBQVVBLElBQU0sV0FBMEIsR0FBRyxTQUE3QixXQUE2QixDQUFDLEtBQUQsRUFBQTtFQUFBLE9BQ3hDLE1BQU0sQ0FBQyxLQUFELENBQU4sSUFDQSxDQUFDLENBQUMsS0FBSyxDQUFDLFdBRFIsSUFFQSxtQkFBQSxDQUFvQixJQUFwQixDQUF5QixLQUFLLENBQUMsV0FBTixDQUFrQixRQUFsQixFQUF6QixDQUh3QyxDQUFBO0NBQW5DLENBQUE7Ozs7QUFLQSxJQUFNLEtBQUssR0FBRyxTQUFSLEtBQVEsQ0FBb0IsS0FBcEIsRUFBQTtFQUFBLE9BQ2xCLE1BQU0sQ0FBQyxLQUFELENBQU4sSUFDQSxPQUFPLEtBQUssQ0FBQyxNQUFiLEtBQXdCLFdBRHhCLElBRUQsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFQLENBSGUsQ0FBQTtDQUFkLENBQUE7Ozs7Ozs7Ozs7Ozs7O0FDeENQLElBQUEsRUFBQSxHQUFBLHVCQUFBLENBQUEsT0FBQSxDQUFBLENBQUE7Ozs7OztBQXdCQSxTQUFTLE9BQVQsQ0FBa0IsS0FBbEIsRUFBZ0M7RUFBQSxJQUU1QixPQUY0QixHQUsxQixLQUwwQixDQUU1QixPQUY0QjtNQUc1QixZQUg0QixHQUsxQixLQUwwQixDQUc1QixZQUg0QjtNQUk1QixRQUo0QixHQUsxQixLQUwwQixDQUk1QixRQUo0QixDQUFBO0VBTzlCLFlBQVksQ0FBQyxTQUFiLENBQXVCLFNBQXZCLEdBQW1DLElBQUksQ0FBQyxTQUF4QyxDQUFBO0VBRUEsT0FBTyxDQUFDLEdBQVIsQ0FBWSxJQUFaLEdBQW1CLElBQW5CLENBQUE7RUFDQSxPQUFPLENBQUMsVUFBUixDQUFtQixJQUFuQixHQUEwQixXQUExQixDQUFBO0VBRUEsUUFBUSxDQUFDLE9BQVQsQ0FBaUIsSUFBakIsR0FBd0IsSUFBSSxDQUFDLFFBQTdCLENBQUE7Q0FDRDs7QUFFRCxTQUFTLFVBQVQsQ0FBQSxJQUFBLEVBQXNDO0VBQUEsSUFBZixXQUFlLEdBQUEsSUFBQSxDQUFmLFdBQWUsQ0FBQTs7RUFDcEMsSUFBSSxXQUFXLENBQUMsUUFBWixDQUFxQixJQUFyQixLQUE4QixNQUFsQyxFQUEwQztJQUFFLE9BQUE7R0FBUTs7RUFFcEQsSUFBTSxJQUFJLEdBQUcsV0FBVyxDQUFDLFFBQVosQ0FBcUIsSUFBbEMsQ0FBQTs7RUFFQSxJQUFJLElBQUksS0FBSyxHQUFiLEVBQWtCO0lBQ2hCLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEdBQW5CLENBQXVCLElBQXZCLENBQTRCLENBQTVCLEdBQWtDLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEtBQW5CLENBQXlCLElBQXpCLENBQThCLENBQWhFLENBQUE7SUFDQSxXQUFXLENBQUMsTUFBWixDQUFtQixHQUFuQixDQUF1QixNQUF2QixDQUE4QixDQUE5QixHQUFrQyxXQUFXLENBQUMsTUFBWixDQUFtQixLQUFuQixDQUF5QixNQUF6QixDQUFnQyxDQUFsRSxDQUFBO0lBRUEsV0FBVyxDQUFDLE1BQVosQ0FBbUIsUUFBbkIsQ0FBNEIsTUFBNUIsQ0FBbUMsQ0FBbkMsR0FBdUMsQ0FBdkMsQ0FBQTtJQUNBLFdBQVcsQ0FBQyxNQUFaLENBQW1CLFFBQW5CLENBQTRCLElBQTVCLENBQWlDLENBQWpDLEdBQXVDLENBQXZDLENBQUE7R0FMRixNQU9LLElBQUksSUFBSSxLQUFLLEdBQWIsRUFBa0I7SUFDckIsV0FBVyxDQUFDLE1BQVosQ0FBbUIsR0FBbkIsQ0FBdUIsSUFBdkIsQ0FBNEIsQ0FBNUIsR0FBa0MsV0FBVyxDQUFDLE1BQVosQ0FBbUIsS0FBbkIsQ0FBeUIsSUFBekIsQ0FBOEIsQ0FBaEUsQ0FBQTtJQUNBLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEdBQW5CLENBQXVCLE1BQXZCLENBQThCLENBQTlCLEdBQWtDLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEtBQW5CLENBQXlCLE1BQXpCLENBQWdDLENBQWxFLENBQUE7SUFFQSxXQUFXLENBQUMsTUFBWixDQUFtQixRQUFuQixDQUE0QixNQUE1QixDQUFtQyxDQUFuQyxHQUF1QyxDQUF2QyxDQUFBO0lBQ0EsV0FBVyxDQUFDLE1BQVosQ0FBbUIsUUFBbkIsQ0FBNEIsSUFBNUIsQ0FBaUMsQ0FBakMsR0FBdUMsQ0FBdkMsQ0FBQTtHQUNEO0NBQ0Y7O0FBRUQsU0FBUyxJQUFULENBQUEsS0FBQSxFQUF3QztFQUFBLElBQXZCLE1BQXVCLEdBQUEsS0FBQSxDQUF2QixNQUF1QjtNQUFmLFdBQWUsR0FBQSxLQUFBLENBQWYsV0FBZSxDQUFBOztFQUN0QyxJQUFJLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQXJCLEtBQThCLE1BQWxDLEVBQTBDO0lBQUUsT0FBQTtHQUFROztFQUVwRCxJQUFNLElBQUksR0FBRyxXQUFXLENBQUMsUUFBWixDQUFxQixJQUFsQyxDQUFBOztFQUVBLElBQUksSUFBSSxLQUFLLEdBQVQsSUFBZ0IsSUFBSSxLQUFLLEdBQTdCLEVBQWtDO0lBQ2hDLElBQU0sUUFBUSxHQUFHLElBQUksS0FBSyxHQUFULEdBQWUsR0FBZixHQUFxQixHQUF0QyxDQUFBO0lBRUEsTUFBTSxDQUFDLElBQVAsQ0FBWSxRQUFaLENBQUEsR0FBMEIsV0FBVyxDQUFDLE1BQVosQ0FBbUIsS0FBbkIsQ0FBeUIsSUFBekIsQ0FBOEIsUUFBOUIsQ0FBMUIsQ0FBQTtJQUNBLE1BQU0sQ0FBQyxNQUFQLENBQWMsUUFBZCxDQUFBLEdBQTBCLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEtBQW5CLENBQXlCLE1BQXpCLENBQWdDLFFBQWhDLENBQTFCLENBQUE7SUFDQSxNQUFNLENBQUMsS0FBUCxDQUFhLFFBQWIsQ0FBQSxHQUF5QixDQUF6QixDQUFBO0dBQ0Q7Q0FDRjs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBeUNELElBQU0sU0FBMEIsR0FBRyxTQUFTLFNBQVQsQ0FBaUQsT0FBakQsRUFBcUc7RUFDdEksSUFBSSxFQUFFLENBQUMsTUFBSCxDQUFVLE9BQVYsQ0FBSixFQUF3QjtJQUN0QixJQUFBLENBQUssT0FBTCxDQUFhLElBQWIsQ0FBa0IsT0FBbEIsR0FBNEIsT0FBTyxDQUFDLE9BQVIsS0FBb0IsS0FBaEQsQ0FBQTtJQUNBLElBQUEsQ0FBSyxZQUFMLENBQWtCLE1BQWxCLEVBQTBCLE9BQTFCLENBQUEsQ0FBQTtJQUNBLElBQUEsQ0FBSyxXQUFMLENBQWlCLE1BQWpCLEVBQXlCLE9BQXpCLENBQUEsQ0FBQTs7SUFFQSxJQUFJLGtCQUFBLENBQW1CLElBQW5CLENBQXdCLE9BQU8sQ0FBQyxRQUFoQyxDQUFKLEVBQStDO01BQzdDLElBQUEsQ0FBSyxPQUFMLENBQWEsSUFBYixDQUFrQixRQUFsQixHQUE2QixPQUFPLENBQUMsUUFBckMsQ0FBQTtLQUNEOztJQUNELElBQUksWUFBQSxDQUFhLElBQWIsQ0FBa0IsT0FBTyxDQUFDLFNBQTFCLENBQUosRUFBMEM7TUFDeEMsSUFBQSxDQUFLLE9BQUwsQ0FBYSxJQUFiLENBQWtCLFNBQWxCLEdBQThCLE9BQU8sQ0FBQyxTQUF0QyxDQUFBO0tBQ0Q7O0lBRUQsT0FBTyxJQUFQLENBQUE7R0FDRDs7RUFFRCxJQUFJLEVBQUUsQ0FBQyxJQUFILENBQVEsT0FBUixDQUFKLEVBQXNCO0lBQ3BCLElBQUEsQ0FBSyxPQUFMLENBQWEsSUFBYixDQUFrQixPQUFsQixHQUE0QixPQUE1QixDQUFBO0lBRUEsT0FBTyxJQUFQLENBQUE7R0FDRDs7RUFFRCxPQUFPLElBQUEsQ0FBSyxPQUFMLENBQWEsSUFBcEIsQ0FBQTtDQXRCRixDQUFBOztBQXlCQSxJQUFNLElBQXFCLEdBQUc7RUFDNUIsRUFBRSxFQUFFLGNBRHdCO0VBRTVCLE9BQU8sRUFBUCxPQUY0QjtFQUc1QixTQUFTLEVBQUU7SUFDVCxpQ0FBQSxFQUFtQyxVQUQxQjtJQUVULDRCQUFBLEVBQThCLFVBRnJCOztJQUtULDBCQUFBLEVBQTRCLElBTG5CO0lBTVQsa0JBQUEsRUFBb0IsU0FBQSxjQUFBLENBQUEsR0FBRyxFQUFJO01BQUEsSUFDakIsV0FEaUIsR0FDc0IsR0FEdEIsQ0FDakIsV0FEaUI7VUFDSixZQURJLEdBQ3NCLEdBRHRCLENBQ0osWUFESTtVQUNVLE9BRFYsR0FDc0IsR0FEdEIsQ0FDVSxPQURWLENBQUE7TUFFekIsSUFBTSxXQUFXLEdBQUcsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsSUFBekMsQ0FBQTs7TUFFQSxJQUNFLEVBQUUsV0FBVyxJQUFJLFdBQVcsQ0FBQyxPQUE3QixDQUFBO01BRUMsV0FBVyxDQUFDLGFBQVosSUFDQSxlQUFBLENBQWdCLElBQWhCLENBQXFCLFdBQVcsQ0FBQyxXQUFqQyxDQURBLElBRUYsQ0FBQyxPQUFPLEdBQUcsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsSUFBckIsQ0FBMEIsWUFBckMsTUFBdUQsQ0FMeEQsRUFNRTtRQUNBLE9BQU8sU0FBUCxDQUFBO09BQ0Q7O01BRUQsR0FBRyxDQUFDLE1BQUosR0FBYTtRQUNYLElBQUksRUFBRSxNQURLO1FBRVgsSUFBSSxFQUFHLFdBQVcsQ0FBQyxRQUFaLEtBQXlCLE9BQXpCLEdBQ0gsV0FBVyxDQUFDLFNBRFQsR0FFSCxXQUFXLENBQUMsUUFBQTtPQUpsQixDQUFBO01BT0EsT0FBTyxLQUFQLENBQUE7S0FDRDtHQS9CeUI7RUFpQzVCLFNBQVMsRUFBVCxTQWpDNEI7RUFrQzVCLFVBQVUsRUFBVixVQWxDNEI7RUFtQzVCLElBQUksRUFBSixJQW5DNEI7RUFvQzVCLFFBQVEsRUFBRTtJQUNSLFNBQVMsRUFBRyxJQURKO0lBRVIsUUFBUSxFQUFJLElBQUE7R0F0Q2M7RUF5QzVCLFNBekM0QixFQUFBLFNBQUEsU0FBQSxHQXlDZjtJQUNYLE9BQU8sTUFBUCxDQUFBO0dBQ0Q7Q0EzQ0gsQ0FBQTttQkE4Q2U7Ozs7Ozs7Ozs7O0FDdkxSLElBQU0sUUFBUSxHQUFHLFNBQVgsUUFBVyxDQUFJLEtBQUosRUFBZ0IsTUFBaEIsRUFBQTtFQUFBLE9BQThCLEtBQUssQ0FBQyxPQUFOLENBQWMsTUFBZCxDQUFBLEtBQTBCLENBQUMsQ0FBekQsQ0FBQTtDQUFqQixDQUFBOzs7O0FBRUEsSUFBTSxNQUFNLEdBQUcsU0FBVCxNQUFTLENBQUksS0FBSixFQUFnQixNQUFoQixFQUFBO0VBQUEsT0FBOEIsS0FBSyxDQUFDLE1BQU4sQ0FBYSxLQUFLLENBQUMsT0FBTixDQUFjLE1BQWQsQ0FBYixFQUFvQyxDQUFwQyxDQUE5QixDQUFBO0NBQWYsQ0FBQTs7OztBQUVBLElBQU0sS0FBSyxHQUFHLFNBQVIsS0FBUSxDQUFPLE1BQVAsRUFBNkIsTUFBN0IsRUFBNkM7RUFDaEUsS0FBQSxJQUFBLEVBQUEsR0FBQSxDQUFBLEVBQUEsRUFBQSxHQUFtQixNQUFuQixDQUFBLE1BQUEsRUFBQSxFQUFBLEVBQUEsRUFBMkI7SUFBQSxJQUFBLElBQUEsQ0FBQTs7SUFBQSxJQUFBLEdBQVIsTUFBUSxDQUFBLEVBQUEsQ0FBQSxDQUFBO0lBQUEsSUFBaEIsSUFBZ0IsR0FBQSxJQUFBLENBQUE7SUFDekIsTUFBTSxDQUFDLElBQVAsQ0FBWSxJQUFaLENBQUEsQ0FBQTtHQUNEOztFQUVELE9BQU8sTUFBUCxDQUFBO0NBTEssQ0FBQTs7OztBQVFBLElBQU0sSUFBSSxHQUFHLFNBQVAsSUFBTyxDQUFVLE1BQVYsRUFBQTtFQUFBLE9BQW1DLEtBQUssQ0FBQyxFQUFELEVBQVksTUFBWixDQUF4QyxDQUFBO0NBQWIsQ0FBQTs7OztBQUVBLElBQU0sU0FBUyxHQUFHLFNBQVosU0FBWSxDQUFJLEtBQUosRUFBZ0IsSUFBaEIsRUFBb0M7RUFDM0QsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFiLEVBQWdCLENBQUMsR0FBRyxLQUFLLENBQUMsTUFBMUIsRUFBa0MsQ0FBQyxFQUFuQyxFQUF1QztJQUNyQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBRCxDQUFOLEVBQVcsQ0FBWCxFQUFjLEtBQWQsQ0FBUixFQUE4QjtNQUM1QixPQUFPLENBQVAsQ0FBQTtLQUNEO0dBQ0Y7O0VBRUQsT0FBTyxDQUFDLENBQVIsQ0FBQTtDQVBLLENBQUE7Ozs7QUFVQSxJQUFNLElBQUksR0FBRyxTQUFQLElBQU8sQ0FBVSxLQUFWLEVBQXNCLElBQXRCLEVBQUE7RUFBQSxPQUEwQyxLQUFLLENBQUMsU0FBUyxDQUFDLEtBQUQsRUFBUSxJQUFSLENBQVYsQ0FBL0MsQ0FBQTtDQUFiLENBQUE7Ozs7Ozs7Ozs7O0FDMUJQLElBQU0sVUFZTCxHQUNEO0VBQ0UsSUFBSSxFQUFKLFNBREY7RUFFRSxRQUFRLEVBQUUsSUFGWjtFQUdFLGdCQUFnQixFQUFFLElBSHBCO0VBSUUsVUFBVSxFQUFFLElBSmQ7RUFLRSxhQUFhLEVBQUUsSUFMakI7RUFNRSxrQkFBa0IsRUFBRSxJQU50QjtFQU9FLE9BQU8sRUFBRSxJQVBYO0VBUUUsV0FBVyxFQUFFLElBUmY7RUFTRSxLQUFLLEVBQUUsSUFUVDtFQVVFLEtBQUssRUFBRSxJQVZUO0VBV0UsWUFBWSxFQUFFLElBQUE7Q0F4QmhCLENBQUE7O0FBMkJBLFNBQVMsS0FBVCxHQUFrQixFQUFFOztvQkFFTDs7O0FBRWYsU0FBUyxTQUFULENBQWUsTUFBZixFQUErQjtFQUM3QixJQUFNLEdBQUcsR0FBRyxNQUFaLENBQUE7RUFFQSxVQUFVLENBQUMsUUFBWCxHQUFnQyxHQUFHLENBQUMsUUFBcEMsQ0FBQTtFQUNBLFVBQVUsQ0FBQyxnQkFBWCxHQUFnQyxHQUFHLENBQUMsZ0JBQUosSUFBMEIsS0FBMUQsQ0FBQTtFQUNBLFVBQVUsQ0FBQyxVQUFYLEdBQWdDLEdBQUcsQ0FBQyxVQUFKLElBQTBCLEtBQTFELENBQUE7RUFDQSxVQUFVLENBQUMsYUFBWCxHQUFnQyxHQUFHLENBQUMsYUFBSixJQUEwQixLQUExRCxDQUFBO0VBQ0EsVUFBVSxDQUFDLGtCQUFYLEdBQWdDLEdBQUcsQ0FBQyxrQkFBSixJQUEwQixLQUExRCxDQUFBO0VBQ0EsVUFBVSxDQUFDLE9BQVgsR0FBZ0MsR0FBRyxDQUFDLE9BQUosSUFBMEIsS0FBMUQsQ0FBQTtFQUNBLFVBQVUsQ0FBQyxXQUFYLEdBQWdDLEdBQUcsQ0FBQyxXQUFKLElBQTBCLFVBQVUsQ0FBQyxPQUFyRSxDQUFBO0VBRUEsVUFBVSxDQUFDLEtBQVgsR0FBMEIsR0FBRyxDQUFDLEtBQTlCLENBQUE7RUFDQSxVQUFVLENBQUMsS0FBWCxHQUEwQixHQUFHLENBQUMsS0FBSixJQUFhLEtBQXZDLENBQUE7RUFDQSxVQUFVLENBQUMsWUFBWCxHQUEyQixHQUFHLENBQUMsWUFBSixJQUFvQixHQUFHLENBQUMsY0FBbkQsQ0FBQTtDQUNEOzs7Ozs7Ozs7Ozs7QUM3Q0QsSUFBQSxXQUFBLEdBQUEsMkJBQUEsQ0FBQSxlQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLE9BQUEsR0FBQSw0QkFBQSxDQUFBLE9BQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsT0FBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7Ozs7Ozs7O0FBRUEsSUFBTSxPQUFPLEdBQUc7RUFDZCxJQUFJLEVBQUosU0FEYztFQUVkLGFBQWEsRUFBRSxJQUZEO0VBR2Qsb0JBQW9CLEVBQUUsSUFIUjtFQUlkLE1BQU0sRUFBRSxJQUpNO0VBS2QsS0FBSyxFQUFFLElBTE87RUFNZCxLQUFLLEVBQUUsSUFOTztFQU9kLGFBQWEsRUFBRSxJQVBEO0VBUWQsdUJBQXVCLEVBQUUsSUFSWDtFQVNkLFdBQVcsRUFBRSxJQVRDO0VBaUJkLFVBQVUsRUFBRSxJQUFBO0NBakJkLENBQUE7O0FBb0JBLFNBQVMsU0FBVCxDQUFlLE1BQWYsRUFBNEI7RUFDMUIsSUFBTSxPQUFPLEdBQUcsV0FBQSxDQUFBLFNBQUEsQ0FBQSxDQUFXLE9BQTNCLENBQUE7RUFDQSxJQUFNLFNBQVMsR0FBSSxPQUFBLENBQUEsU0FBQSxDQUFBLENBQUksTUFBSixDQUFXLFNBQTlCLENBRjBCOztFQUsxQixPQUFPLENBQUMsYUFBUixHQUF5QixjQUFBLElBQWtCLE1BQW5CLElBQ3JCLE9BQUUsQ0FBQyxJQUFILENBQVEsTUFBTSxDQUFDLGFBQWYsQ0FBQSxJQUFpQyxXQUFBLENBQUEsU0FBQSxDQUFBLENBQVcsUUFBWCxZQUErQixNQUFNLENBQUMsYUFEMUUsQ0FMMEI7O0VBUzFCLE9BQU8sQ0FBQyxvQkFBUixHQUErQixTQUFTLENBQUMsY0FBVixLQUE2QixLQUE3QixJQUFzQyxDQUFDLENBQUMsV0FBQSxDQUFBLFNBQUEsQ0FBQSxDQUFXLFlBQWxGLENBQUE7RUFFQSxPQUFPLENBQUMsS0FBUixHQUFpQixnQkFBQSxDQUFpQixJQUFqQixDQUFzQixTQUFTLENBQUMsUUFBaEMsQ0FBakIsQ0FYMEI7O0VBYzFCLE9BQU8sQ0FBQyxNQUFSLEdBQWtCLGdCQUFBLENBQWlCLElBQWpCLENBQXNCLFNBQVMsQ0FBQyxRQUFoQyxDQUFBLElBQ1QsV0FBQSxDQUFZLElBQVosQ0FBaUIsU0FBUyxDQUFDLFVBQTNCLENBRFQsQ0FBQTtFQUdBLE9BQU8sQ0FBQyxLQUFSLEdBQWdCLFFBQUEsQ0FBUyxJQUFULENBQWMsU0FBUyxDQUFDLFNBQXhCLENBQWhCLENBakIwQjs7RUFvQjFCLE9BQU8sQ0FBQyxhQUFSLEdBQXlCLFNBQVMsQ0FBQyxPQUFWLEtBQXNCLE9BQXRCLElBQ3ZCLE9BQU8sQ0FBQyxhQURlLElBRXZCLFFBQUEsQ0FBUyxJQUFULENBQWMsU0FBUyxDQUFDLFNBQXhCLENBRkYsQ0FwQjBCOztFQXlCMUIsT0FBTyxDQUFDLHVCQUFSLEdBQWtDLFNBQUEsSUFBYSxPQUFPLENBQUMsU0FBckIsR0FDOUIsU0FEOEIsR0FFOUIsdUJBQUEsSUFBMkIsT0FBTyxDQUFDLFNBQW5DLEdBQ0UsdUJBREYsR0FFRSxvQkFBQSxJQUF3QixPQUFPLENBQUMsU0FBaEMsR0FDRSxvQkFERixHQUVFLGtCQUFBLElBQXNCLE9BQU8sQ0FBQyxTQUE5QixHQUNFLGtCQURGLEdBRUUsbUJBUlYsQ0FBQTtFQVVBLE9BQU8sQ0FBQyxXQUFSLEdBQXVCLE9BQU8sQ0FBQyxvQkFBUixHQUNsQixXQUFBLENBQUEsU0FBQSxDQUFBLENBQVcsWUFBWCxLQUE0QixNQUFNLENBQUMsY0FBbkMsR0FDQztJQUNBLEVBQUUsRUFBTSxhQURSO0lBRUEsSUFBSSxFQUFJLGVBRlI7SUFHQSxJQUFJLEVBQUksV0FIUjtJQUlBLEdBQUcsRUFBSyxVQUpSO0lBS0EsSUFBSSxFQUFJLGVBTFI7SUFNQSxNQUFNLEVBQUUsaUJBQUE7R0FQVCxHQVNDO0lBQ0EsRUFBRSxFQUFNLFdBRFI7SUFFQSxJQUFJLEVBQUksYUFGUjtJQUdBLElBQUksRUFBSSxhQUhSO0lBSUEsR0FBRyxFQUFLLFlBSlI7SUFLQSxJQUFJLEVBQUksYUFMUjtJQU1BLE1BQU0sRUFBRSxlQUFBO0dBaEJTLEdBa0JuQixJQWxCSixDQW5DMEI7O0VBd0QxQixPQUFPLENBQUMsVUFBUixHQUFxQixjQUFBLElBQWtCLFdBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBVyxRQUE3QixHQUF3QyxZQUF4QyxHQUF1RCxPQUE1RSxDQUFBO0NBQ0Q7O29CQUVjOzs7Ozs7Ozs7Ozs7O0FDbkZmLElBQUEsR0FBQSxHQUFBLDRCQUFBLENBQUEsUUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsNEJBQUEsQ0FBQSxPQUFBLENBQUEsQ0FBQTs7Ozs7OztBQUdlLFNBQVMsS0FBVCxDQUFrQyxNQUFsQyxFQUF5RDtFQUN0RSxJQUFNLElBQUksR0FBRyxFQUFiLENBQUE7O0VBRUEsS0FBSyxJQUFNLElBQVgsSUFBbUIsTUFBbkIsRUFBMkI7SUFDekIsSUFBTSxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUQsQ0FBcEIsQ0FBQTs7SUFFQSxJQUFJLE9BQUUsQ0FBQyxXQUFILENBQWUsS0FBZixDQUFKLEVBQTJCO01BQ3pCLElBQUksQ0FBQyxJQUFELENBQUosR0FBYSxLQUFLLENBQUMsS0FBRCxDQUFsQixDQUFBO0tBREYsTUFHSyxJQUFJLE9BQUUsQ0FBQyxLQUFILENBQVMsS0FBVCxDQUFKLEVBQXFCO01BQ3hCLElBQUksQ0FBQyxJQUFELENBQUosR0FBYSxHQUFHLENBQUMsSUFBSixDQUFTLEtBQVQsQ0FBYixDQUFBO0tBREcsTUFHQTtNQUNILElBQUksQ0FBQyxJQUFELENBQUosR0FBYSxLQUFiLENBQUE7S0FDRDtHQUNGOztFQUVELE9BQU8sSUFBUCxDQUFBO0NBQ0Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDdEJELElBQUEsUUFBQSxHQUFBLDJCQUFBLENBQUEsWUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxnQkFBQSxHQUFBLDJCQUFBLENBQUEsZUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsNEJBQUEsQ0FBQSxPQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFlBQUEsR0FBQSw0QkFBQSxDQUFBLFdBQUEsQ0FBQSxDQUFBOzs7Ozs7OztBQUVPLFNBQVMsWUFBVCxDQUF1QixNQUF2QixFQUE0RCxLQUE1RCxFQUFnRztFQUNyRyxPQUFPLEtBQVAsRUFBYztJQUNaLElBQUksS0FBSyxLQUFLLE1BQWQsRUFBc0I7TUFDcEIsT0FBTyxJQUFQLENBQUE7S0FDRDs7SUFFRCxLQUFLLEdBQUksS0FBRCxDQUFnQixVQUF4QixDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxLQUFQLENBQUE7Q0FDRDs7QUFFTSxTQUFTLE9BQVQsQ0FBa0IsT0FBbEIsRUFBaUMsUUFBakMsRUFBbUQ7RUFDeEQsT0FBTyxPQUFFLENBQUMsT0FBSCxDQUFXLE9BQVgsQ0FBUCxFQUE0QjtJQUMxQixJQUFJLGVBQWUsQ0FBQyxPQUFELEVBQVUsUUFBVixDQUFuQixFQUF3QztNQUFFLE9BQU8sT0FBUCxDQUFBO0tBQWdCOztJQUUxRCxPQUFPLEdBQUcsVUFBVSxDQUFDLE9BQUQsQ0FBcEIsQ0FBQTtHQUNEOztFQUVELE9BQU8sSUFBUCxDQUFBO0NBQ0Q7O0FBRU0sU0FBUyxVQUFULENBQXFCLElBQXJCLEVBQTRDO0VBQ2pELElBQUksTUFBTSxHQUFHLElBQUksQ0FBQyxVQUFsQixDQUFBOztFQUVBLElBQUksT0FBRSxDQUFDLE9BQUgsQ0FBVyxNQUFYLENBQUosRUFBd0I7OztJQUd0QixPQUFPLENBQUMsTUFBTSxHQUFJLE1BQUQsQ0FBZ0IsSUFBMUIsS0FBbUMsT0FBRSxDQUFDLE9BQUgsQ0FBVyxNQUFYLENBQTFDLEVBQThEO01BQzVELFNBQUE7S0FDRDs7SUFFRCxPQUFPLE1BQVAsQ0FBQTtHQUNEOztFQUVELE9BQU8sTUFBUCxDQUFBO0NBQ0Q7O0FBRU0sU0FBUyxlQUFULENBQTBCLE9BQTFCLEVBQXFELFFBQXJELEVBQXVFOztFQUU1RSxJQUFJLFlBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBSSxNQUFKLEtBQWUsWUFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFJLFVBQXZCLEVBQW1DO0lBQ2pDLFFBQVEsR0FBRyxRQUFRLENBQUMsT0FBVCxDQUFpQixXQUFqQixFQUE4QixHQUE5QixDQUFYLENBQUE7R0FDRDs7RUFFRCxPQUFPLE9BQU8sQ0FBQyxRQUFBLENBQUEsU0FBQSxDQUFBLENBQVEsdUJBQVQsQ0FBUCxDQUF5QyxRQUF6QyxDQUFQLENBQUE7Q0FDRDs7QUFFRCxJQUFNLFNBQVMsR0FBRyxTQUFaLFNBQVksQ0FBQSxFQUFFLEVBQUE7RUFBQSxPQUFJLEVBQUUsQ0FBQyxVQUFILEdBQWdCLEVBQUUsQ0FBQyxVQUFuQixHQUFnQyxFQUFFLENBQUMsSUFBdkMsQ0FBQTtDQUFwQjs7O0FBR08sU0FBUyxxQkFBVCxDQUFnQyxRQUFoQyxFQUFvRjtFQUN6RixJQUFJLGtCQUFrQixHQUFHLEVBQXpCLENBQUE7RUFDQSxJQUFJLFdBQVcsR0FBRyxRQUFRLENBQUMsQ0FBRCxDQUExQixDQUFBO0VBQ0EsSUFBSSxLQUFLLEdBQUcsV0FBVyxHQUFHLENBQUgsR0FBTyxDQUFDLENBQS9CLENBQUE7RUFDQSxJQUFJLENBQUosQ0FBQTtFQUNBLElBQUksQ0FBSixDQUFBOztFQUVBLEtBQUssQ0FBQyxHQUFHLENBQVQsRUFBWSxDQUFDLEdBQUcsUUFBUSxDQUFDLE1BQXpCLEVBQWlDLENBQUMsRUFBbEMsRUFBc0M7SUFDcEMsSUFBTSxRQUFRLEdBQUcsUUFBUSxDQUFDLENBQUQsQ0FBekIsQ0FEb0M7O0lBSXBDLElBQUksQ0FBQyxRQUFELElBQWEsUUFBUSxLQUFLLFdBQTlCLEVBQTJDO01BQ3pDLFNBQUE7S0FDRDs7SUFFRCxJQUFJLENBQUMsV0FBTCxFQUFrQjtNQUNoQixXQUFXLEdBQUcsUUFBZCxDQUFBO01BQ0EsS0FBSyxHQUFHLENBQVIsQ0FBQTtNQUNBLFNBQUE7S0FYa0M7Ozs7SUFnQnBDLElBQUksUUFBUSxDQUFDLFVBQVQsS0FBd0IsUUFBUSxDQUFDLGFBQXJDLEVBQW9EO01BQ2xELFNBQUE7S0FERjtTQUlLLElBQUksV0FBVyxDQUFDLFVBQVosS0FBMkIsUUFBUSxDQUFDLGFBQXhDLEVBQXVEO1FBQzFELFdBQVcsR0FBRyxRQUFkLENBQUE7UUFDQSxLQUFLLEdBQUcsQ0FBUixDQUFBO1FBQ0EsU0FBQTtPQXZCa0M7OztJQTJCcEMsSUFBSSxRQUFRLENBQUMsVUFBVCxLQUF3QixXQUFXLENBQUMsVUFBeEMsRUFBb0Q7TUFDbEQsSUFBTSxhQUFhLEdBQUcsUUFBUSxDQUFDLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLEVBQVUsV0FBVixDQUFBLENBQXVCLGdCQUF2QixDQUF3QyxXQUF4QyxDQUFBLENBQXFELE1BQXRELEVBQThELEVBQTlELENBQVIsSUFBNkUsQ0FBbkcsQ0FBQTtNQUNBLElBQU0sY0FBYyxHQUFHLFFBQVEsQ0FBQyxDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxFQUFVLFFBQVYsQ0FBQSxDQUFvQixnQkFBcEIsQ0FBcUMsUUFBckMsQ0FBQSxDQUErQyxNQUFoRCxFQUF3RCxFQUF4RCxDQUFSLElBQXVFLENBQTlGLENBQUE7O01BRUEsSUFBSSxjQUFjLElBQUksYUFBdEIsRUFBcUM7UUFDbkMsV0FBVyxHQUFHLFFBQWQsQ0FBQTtRQUNBLEtBQUssR0FBRyxDQUFSLENBQUE7T0FDRDs7TUFFRCxTQUFBO0tBcENrQzs7O0lBd0NwQyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBeEIsRUFBZ0M7TUFDOUIsSUFBSSxPQUFNLEdBQUcsV0FBYixDQUFBO01BQ0EsSUFBSSxZQUFZLEdBQUEsS0FBQSxDQUFoQixDQUFBOztNQUVBLE9BQU8sQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDLE9BQUQsQ0FBekIsS0FBc0MsWUFBWSxLQUFLLE9BQU0sQ0FBQyxhQUFyRSxFQUFvRjtRQUNsRixrQkFBa0IsQ0FBQyxPQUFuQixDQUEyQixPQUEzQixDQUFBLENBQUE7UUFDQSxPQUFNLEdBQUcsWUFBVCxDQUFBO09BQ0Q7S0FDRjs7SUFFRCxJQUFJLE1BQU0sR0FBQSxLQUFBLENBQVYsQ0FsRG9DOzs7SUFzRHBDLElBQUksV0FBVyxZQUFZLGdCQUFBLENBQUEsU0FBQSxDQUFBLENBQVcsV0FBbEMsSUFDQSxRQUFRLFlBQVksZ0JBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBVyxVQUQvQixJQUVBLEVBQUUsUUFBUSxZQUFZLGdCQUFBLENBQUEsU0FBQSxDQUFBLENBQVcsYUFBakMsQ0FGSixFQUVxRDtNQUNuRCxJQUFJLFFBQVEsS0FBSyxXQUFXLENBQUMsVUFBN0IsRUFBeUM7UUFDdkMsU0FBQTtPQUNEOztNQUVELE1BQU0sR0FBRyxRQUFRLENBQUMsZUFBbEIsQ0FBQTtLQVBGLE1BU0s7TUFDSCxNQUFNLEdBQUcsUUFBVCxDQUFBO0tBQ0Q7O0lBRUQsSUFBTSxlQUFlLEdBQUcsRUFBeEIsQ0FBQTs7SUFFQSxPQUFPLE1BQU0sQ0FBQyxVQUFQLEtBQXNCLE1BQU0sQ0FBQyxhQUFwQyxFQUFtRDtNQUNqRCxlQUFlLENBQUMsT0FBaEIsQ0FBd0IsTUFBeEIsQ0FBQSxDQUFBO01BQ0EsTUFBTSxHQUFHLFNBQVMsQ0FBQyxNQUFELENBQWxCLENBQUE7S0FDRDs7SUFFRCxDQUFDLEdBQUcsQ0FBSixDQTFFb0M7O0lBNkVwQyxPQUFPLGVBQWUsQ0FBQyxDQUFELENBQWYsSUFBc0IsZUFBZSxDQUFDLENBQUQsQ0FBZixLQUF1QixrQkFBa0IsQ0FBQyxDQUFELENBQXRFLEVBQTJFO01BQ3pFLENBQUMsRUFBQSxDQUFBO0tBQ0Y7O0lBRUQsSUFBTSxPQUFPLEdBQUcsQ0FDZCxlQUFlLENBQUMsQ0FBQyxHQUFHLENBQUwsQ0FERCxFQUVkLGVBQWUsQ0FBQyxDQUFELENBRkQsRUFHZCxrQkFBa0IsQ0FBQyxDQUFELENBSEosQ0FBaEIsQ0FBQTtJQU1BLElBQUksS0FBSyxHQUFHLE9BQU8sQ0FBQyxDQUFELENBQVAsQ0FBVyxTQUF2QixDQUFBOztJQUVBLE9BQU8sS0FBUCxFQUFjO01BQ1osSUFBSSxLQUFLLEtBQUssT0FBTyxDQUFDLENBQUQsQ0FBckIsRUFBMEI7UUFDeEIsV0FBVyxHQUFHLFFBQWQsQ0FBQTtRQUNBLEtBQUssR0FBRyxDQUFSLENBQUE7UUFDQSxrQkFBa0IsR0FBRyxlQUFyQixDQUFBO1FBRUEsTUFBQTtPQUxGLE1BT0ssSUFBSSxLQUFLLEtBQUssT0FBTyxDQUFDLENBQUQsQ0FBckIsRUFBMEI7UUFDN0IsTUFBQTtPQUNEOztNQUVELEtBQUssR0FBRyxLQUFLLENBQUMsZUFBZCxDQUFBO0tBQ0Q7R0FDRjs7RUFFRCxPQUFPLEtBQVAsQ0FBQTtDQUNEOztBQUVNLFNBQVMsV0FBVCxDQUFzQixPQUF0QixFQUFpRCxRQUFqRCxFQUFtRSxLQUFuRSxFQUFnRjtFQUNyRixPQUFPLE9BQUUsQ0FBQyxPQUFILENBQVcsT0FBWCxDQUFQLEVBQTRCO0lBQzFCLElBQUksZUFBZSxDQUFDLE9BQUQsRUFBVSxRQUFWLENBQW5CLEVBQXdDO01BQ3RDLE9BQU8sSUFBUCxDQUFBO0tBQ0Q7O0lBRUQsT0FBTyxHQUFHLFVBQVUsQ0FBQyxPQUFELENBQXBCLENBQUE7O0lBRUEsSUFBSSxPQUFPLEtBQUssS0FBaEIsRUFBdUI7TUFDckIsT0FBTyxlQUFlLENBQUMsT0FBRCxFQUFVLFFBQVYsQ0FBdEIsQ0FBQTtLQUNEO0dBQ0Y7O0VBRUQsT0FBTyxLQUFQLENBQUE7Q0FDRDs7QUFFTSxTQUFTLGdCQUFULENBQTJCLE9BQTNCLEVBQXNEO0VBQzNELE9BQVEsT0FBTyxZQUFZLGdCQUFBLENBQUEsU0FBQSxDQUFBLENBQVcsa0JBQTlCLEdBQ0gsT0FBRCxDQUF3Qix1QkFEcEIsR0FFSixPQUZKLENBQUE7Q0FHRDs7QUFFTSxTQUFTLFdBQVQsQ0FBc0IsY0FBdEIsRUFBc0M7RUFDM0MsY0FBYyxHQUFHLGNBQWMsSUFBSSxZQUFBLENBQUEsU0FBQSxDQUFBLENBQUksTUFBdkMsQ0FBQTtFQUNBLE9BQU87SUFDTCxDQUFDLEVBQUUsY0FBYyxDQUFDLE9BQWYsSUFBMEIsY0FBYyxDQUFDLFFBQWYsQ0FBd0IsZUFBeEIsQ0FBd0MsVUFEaEU7SUFFTCxDQUFDLEVBQUUsY0FBYyxDQUFDLE9BQWYsSUFBMEIsY0FBYyxDQUFDLFFBQWYsQ0FBd0IsZUFBeEIsQ0FBd0MsU0FBQTtHQUZ2RSxDQUFBO0NBSUQ7O0FBRU0sU0FBUyxvQkFBVCxDQUErQixPQUEvQixFQUEwRDtFQUMvRCxJQUFNLFVBQVUsR0FBSSxPQUFPLFlBQVksZ0JBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBVyxVQUE5QixHQUNoQixPQUFPLENBQUMscUJBQVIsRUFEZ0IsR0FFaEIsT0FBTyxDQUFDLGNBQVIsRUFBQSxDQUF5QixDQUF6QixDQUZKLENBQUE7RUFJQSxPQUFPLFVBQVUsSUFBSTtJQUNuQixJQUFJLEVBQUksVUFBVSxDQUFDLElBREE7SUFFbkIsS0FBSyxFQUFHLFVBQVUsQ0FBQyxLQUZBO0lBR25CLEdBQUcsRUFBSyxVQUFVLENBQUMsR0FIQTtJQUluQixNQUFNLEVBQUUsVUFBVSxDQUFDLE1BSkE7SUFLbkIsS0FBSyxFQUFHLFVBQVUsQ0FBQyxLQUFYLElBQXFCLFVBQVUsQ0FBQyxLQUFYLEdBQW9CLFVBQVUsQ0FBQyxJQUx6QztJQU1uQixNQUFNLEVBQUUsVUFBVSxDQUFDLE1BQVgsSUFBcUIsVUFBVSxDQUFDLE1BQVgsR0FBb0IsVUFBVSxDQUFDLEdBQUE7R0FOOUQsQ0FBQTtDQVFEOztBQUVNLFNBQVMsY0FBVCxDQUF5QixPQUF6QixFQUFvRDtFQUN6RCxJQUFNLFVBQVUsR0FBRyxvQkFBb0IsQ0FBQyxPQUFELENBQXZDLENBQUE7O0VBRUEsSUFBSSxDQUFDLFFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBUSxNQUFULElBQW1CLFVBQXZCLEVBQW1DO0lBQ2pDLElBQU0sTUFBTSxHQUFHLFdBQVcsQ0FBQyxZQUFBLENBQUEsU0FBQSxDQUFBLENBQUksU0FBSixDQUFjLE9BQWQsQ0FBRCxDQUExQixDQUFBO0lBRUEsVUFBVSxDQUFDLElBQVgsSUFBcUIsTUFBTSxDQUFDLENBQTVCLENBQUE7SUFDQSxVQUFVLENBQUMsS0FBWCxJQUFxQixNQUFNLENBQUMsQ0FBNUIsQ0FBQTtJQUNBLFVBQVUsQ0FBQyxHQUFYLElBQXFCLE1BQU0sQ0FBQyxDQUE1QixDQUFBO0lBQ0EsVUFBVSxDQUFDLE1BQVgsSUFBcUIsTUFBTSxDQUFDLENBQTVCLENBQUE7R0FDRDs7RUFFRCxPQUFPLFVBQVAsQ0FBQTtDQUNEOztBQUVNLFNBQVMsT0FBVCxDQUFrQixJQUFsQixFQUF5QztFQUM5QyxJQUFNLElBQUksR0FBRyxFQUFiLENBQUE7O0VBRUEsT0FBTyxJQUFQLEVBQWE7SUFDWCxJQUFJLENBQUMsSUFBTCxDQUFVLElBQVYsQ0FBQSxDQUFBO0lBQ0EsSUFBSSxHQUFHLFVBQVUsQ0FBQyxJQUFELENBQWpCLENBQUE7R0FDRDs7RUFFRCxPQUFPLElBQVAsQ0FBQTtDQUNEOztBQUVNLFNBQVMsV0FBVCxDQUFzQixLQUF0QixFQUE2QjtFQUNsQyxJQUFJLENBQUMsT0FBRSxDQUFDLE1BQUgsQ0FBVSxLQUFWLENBQUwsRUFBdUI7SUFBRSxPQUFPLEtBQVAsQ0FBQTtHQURTOzs7RUFJbEMsZ0JBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBVyxRQUFYLENBQW9CLGFBQXBCLENBQWtDLEtBQWxDLENBQUEsQ0FBQTs7RUFDQSxPQUFPLElBQVAsQ0FBQTtDQUNEOzs7Ozs7Ozs7O0FDbFBELFNBQVMsYUFBVCxDQUF3QixJQUF4QixFQUE4QixNQUE5QixFQUFzQztFQUNwQyxLQUFLLElBQU0sSUFBWCxJQUFtQixNQUFuQixFQUEyQjtJQUN6QixJQUFNLGVBQWUsR0FBRyxhQUFhLENBQUMsZUFBdEMsQ0FBQTtJQUNBLElBQUksVUFBVSxHQUFHLEtBQWpCLENBRnlCOztJQUt6QixLQUFLLElBQU0sTUFBWCxJQUFxQixlQUFyQixFQUFzQztNQUNwQyxJQUFJLElBQUksQ0FBQyxPQUFMLENBQWEsTUFBYixDQUFBLEtBQXlCLENBQXpCLElBQThCLGVBQWUsQ0FBQyxNQUFELENBQWYsQ0FBd0IsSUFBeEIsQ0FBNkIsSUFBN0IsQ0FBbEMsRUFBc0U7UUFDcEUsVUFBVSxHQUFHLElBQWIsQ0FBQTtRQUNBLE1BQUE7T0FDRDtLQUNGOztJQUVELElBQUksQ0FBQyxVQUFELElBQWUsT0FBTyxNQUFNLENBQUMsSUFBRCxDQUFiLEtBQXdCLFVBQTNDLEVBQXVEO01BQ3JELElBQUksQ0FBQyxJQUFELENBQUosR0FBYSxNQUFNLENBQUMsSUFBRCxDQUFuQixDQUFBO0tBQ0Q7R0FDRjs7RUFDRCxPQUFPLElBQVAsQ0FBQTtDQUNEOztBQUVELGFBQWEsQ0FBQyxlQUFkLEdBQWdDO0VBQzlCLE1BQU0sRUFBRSxnREFEc0I7RUFFOUIsR0FBRyxFQUFFLGFBQUE7Q0FGUCxDQUFBO29CQUtlOzs7Ozs7Ozs7OztvQkM5QkEsU0FBQSxRQUFBLENBQUMsQ0FBRCxFQUFZLENBQVosRUFBQTtFQUFBLE9BQTJCLElBQUksQ0FBQyxJQUFMLENBQVUsQ0FBQyxHQUFHLENBQUosR0FBUSxDQUFDLEdBQUcsQ0FBdEIsQ0FBM0IsQ0FBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDQWYsSUFBQSxhQUFBLEdBQUEsMkJBQUEsQ0FBQSxZQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLGdCQUFBLEdBQUEsMkJBQUEsQ0FBQSxlQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFFBQUEsR0FBQSw0QkFBQSxDQUFBLGFBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsTUFBQSxHQUFBLDJCQUFBLENBQUEsVUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsNEJBQUEsQ0FBQSxPQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLGNBQUEsR0FBQSwyQkFBQSxDQUFBLGtCQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7QUFFTyxTQUFTLFVBQVQsQ0FBcUIsSUFBckIsRUFBcUQsR0FBckQsRUFBb0Y7RUFDekYsSUFBSSxDQUFDLElBQUwsR0FBWSxJQUFJLENBQUMsSUFBTCxJQUFhLEVBQXpCLENBQUE7RUFDQSxJQUFJLENBQUMsSUFBTCxDQUFVLENBQVYsR0FBYyxHQUFHLENBQUMsSUFBSixDQUFTLENBQXZCLENBQUE7RUFDQSxJQUFJLENBQUMsSUFBTCxDQUFVLENBQVYsR0FBYyxHQUFHLENBQUMsSUFBSixDQUFTLENBQXZCLENBQUE7RUFFQSxJQUFJLENBQUMsTUFBTCxHQUFjLElBQUksQ0FBQyxNQUFMLElBQWUsRUFBN0IsQ0FBQTtFQUNBLElBQUksQ0FBQyxNQUFMLENBQVksQ0FBWixHQUFnQixHQUFHLENBQUMsTUFBSixDQUFXLENBQTNCLENBQUE7RUFDQSxJQUFJLENBQUMsTUFBTCxDQUFZLENBQVosR0FBZ0IsR0FBRyxDQUFDLE1BQUosQ0FBVyxDQUEzQixDQUFBO0VBRUEsSUFBSSxDQUFDLFNBQUwsR0FBaUIsR0FBRyxDQUFDLFNBQXJCLENBQUE7Q0FDRDs7QUFFTSxTQUFTLGNBQVQsQ0FBeUIsU0FBekIsRUFBOEQsSUFBOUQsRUFBOEYsR0FBOUYsRUFBNkg7RUFDbEksU0FBUyxDQUFDLElBQVYsQ0FBZSxDQUFmLEdBQXNCLEdBQUcsQ0FBQyxJQUFKLENBQVMsQ0FBVCxHQUFnQixJQUFJLENBQUMsSUFBTCxDQUFVLENBQWhELENBQUE7RUFDQSxTQUFTLENBQUMsSUFBVixDQUFlLENBQWYsR0FBc0IsR0FBRyxDQUFDLElBQUosQ0FBUyxDQUFULEdBQWdCLElBQUksQ0FBQyxJQUFMLENBQVUsQ0FBaEQsQ0FBQTtFQUNBLFNBQVMsQ0FBQyxNQUFWLENBQWlCLENBQWpCLEdBQXNCLEdBQUcsQ0FBQyxNQUFKLENBQVcsQ0FBWCxHQUFnQixJQUFJLENBQUMsTUFBTCxDQUFZLENBQWxELENBQUE7RUFDQSxTQUFTLENBQUMsTUFBVixDQUFpQixDQUFqQixHQUFzQixHQUFHLENBQUMsTUFBSixDQUFXLENBQVgsR0FBZ0IsSUFBSSxDQUFDLE1BQUwsQ0FBWSxDQUFsRCxDQUFBO0VBQ0EsU0FBUyxDQUFDLFNBQVYsR0FBc0IsR0FBRyxDQUFDLFNBQUosR0FBZ0IsSUFBSSxDQUFDLFNBQTNDLENBQUE7Q0FDRDs7QUFFTSxTQUFTLGdCQUFULENBQTJCLFNBQTNCLEVBQWdFLEtBQWhFLEVBQWlHO0VBQ3RHLElBQU0sRUFBRSxHQUFHLElBQUksQ0FBQyxHQUFMLENBQVMsS0FBSyxDQUFDLFNBQU4sR0FBa0IsSUFBM0IsRUFBaUMsS0FBakMsQ0FBWCxDQUFBO0VBRUEsU0FBUyxDQUFDLElBQVYsQ0FBZSxDQUFmLEdBQXFCLEtBQUssQ0FBQyxJQUFOLENBQVcsQ0FBWCxHQUFlLEVBQXBDLENBQUE7RUFDQSxTQUFTLENBQUMsSUFBVixDQUFlLENBQWYsR0FBcUIsS0FBSyxDQUFDLElBQU4sQ0FBVyxDQUFYLEdBQWUsRUFBcEMsQ0FBQTtFQUNBLFNBQVMsQ0FBQyxNQUFWLENBQWlCLENBQWpCLEdBQXFCLEtBQUssQ0FBQyxNQUFOLENBQWEsQ0FBYixHQUFpQixFQUF0QyxDQUFBO0VBQ0EsU0FBUyxDQUFDLE1BQVYsQ0FBaUIsQ0FBakIsR0FBcUIsS0FBSyxDQUFDLE1BQU4sQ0FBYSxDQUFiLEdBQWlCLEVBQXRDLENBQUE7RUFDQSxTQUFTLENBQUMsU0FBVixHQUFzQixFQUF0QixDQUFBO0NBQ0Q7O0FBRU0sU0FBUyxhQUFULENBQXdCLFNBQXhCLEVBQTZEO0VBQ2xFLFNBQVMsQ0FBQyxJQUFWLENBQWUsQ0FBZixHQUFtQixDQUFuQixDQUFBO0VBQ0EsU0FBUyxDQUFDLElBQVYsQ0FBZSxDQUFmLEdBQW1CLENBQW5CLENBQUE7RUFDQSxTQUFTLENBQUMsTUFBVixDQUFpQixDQUFqQixHQUFxQixDQUFyQixDQUFBO0VBQ0EsU0FBUyxDQUFDLE1BQVYsQ0FBaUIsQ0FBakIsR0FBcUIsQ0FBckIsQ0FBQTtDQUNEOztBQUVNLFNBQVMsZUFBVCxDQUEyQixPQUEzQixFQUF5QztFQUM5QyxPQUFRLE9BQU8sWUFBWSxnQkFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFJLEtBQXZCLElBQWdDLE9BQU8sWUFBWSxnQkFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFJLEtBQS9ELENBQUE7Ozs7QUFJSyxTQUFTLEtBQVQsQ0FBZ0IsSUFBaEIsRUFBc0IsT0FBdEIsRUFBK0IsRUFBL0IsRUFBbUM7RUFDeEMsRUFBRSxHQUFHLEVBQUUsSUFBSSxFQUFYLENBQUE7RUFDQSxJQUFJLEdBQUcsSUFBSSxJQUFJLE1BQWYsQ0FBQTtFQUVBLEVBQUUsQ0FBQyxDQUFILEdBQU8sT0FBTyxDQUFDLElBQUksR0FBRyxHQUFSLENBQWQsQ0FBQTtFQUNBLEVBQUUsQ0FBQyxDQUFILEdBQU8sT0FBTyxDQUFDLElBQUksR0FBRyxHQUFSLENBQWQsQ0FBQTtFQUVBLE9BQU8sRUFBUCxDQUFBO0NBQ0Q7O0FBRU0sU0FBUyxTQUFULENBQW9CLE9BQXBCLEVBQTRFLElBQTVFLEVBQW1HO0VBQ3hHLElBQUksR0FBRyxJQUFJLElBQUk7SUFBRSxDQUFDLEVBQUUsQ0FBTDtJQUFRLENBQUMsRUFBRSxDQUFBO0dBQTFCLENBRHdHOztFQUl4RyxJQUFJLGFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBUSxhQUFSLElBQXlCLGVBQWUsQ0FBQyxPQUFELENBQTVDLEVBQXVEO0lBQ3JELEtBQUssQ0FBQyxRQUFELEVBQVcsT0FBWCxFQUFvQixJQUFwQixDQUFMLENBQUE7SUFFQSxJQUFJLENBQUMsQ0FBTCxJQUFVLE1BQU0sQ0FBQyxPQUFqQixDQUFBO0lBQ0EsSUFBSSxDQUFDLENBQUwsSUFBVSxNQUFNLENBQUMsT0FBakIsQ0FBQTtHQUpGLE1BTUs7SUFDSCxLQUFLLENBQUMsTUFBRCxFQUFTLE9BQVQsRUFBa0IsSUFBbEIsQ0FBTCxDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxJQUFQLENBQUE7Q0FDRDs7QUFFTSxTQUFTLFdBQVQsQ0FBc0IsT0FBdEIsRUFBK0IsTUFBL0IsRUFBdUM7RUFDNUMsTUFBTSxHQUFHLE1BQU0sSUFBSSxFQUFuQixDQUFBOztFQUVBLElBQUksYUFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFRLGFBQVIsSUFBeUIsZUFBZSxDQUFDLE9BQUQsQ0FBNUMsRUFBdUQ7O0lBRXJELEtBQUssQ0FBQyxRQUFELEVBQVcsT0FBWCxFQUFvQixNQUFwQixDQUFMLENBQUE7R0FGRixNQUlLO0lBQ0gsS0FBSyxDQUFDLFFBQUQsRUFBVyxPQUFYLEVBQW9CLE1BQXBCLENBQUwsQ0FBQTtHQUNEOztFQUVELE9BQU8sTUFBUCxDQUFBO0NBQ0Q7O0FBRU0sU0FBUyxZQUFULENBQXVCLE9BQXZCLEVBQWdDO0VBQ3JDLE9BQU8sT0FBRSxDQUFDLE1BQUgsQ0FBVSxPQUFPLENBQUMsU0FBbEIsQ0FBQSxHQUErQixPQUFPLENBQUMsU0FBdkMsR0FBbUQsT0FBTyxDQUFDLFVBQWxFLENBQUE7Q0FDRDs7QUFFTSxTQUFTLFNBQVQsQ0FBb0IsU0FBcEIsRUFBK0IsUUFBL0IsRUFBZ0QsU0FBaEQsRUFBbUU7RUFDeEUsSUFBTSxPQUFPLEdBQUksUUFBUSxDQUFDLE1BQVQsR0FBa0IsQ0FBbEIsR0FDYixjQUFjLENBQUMsUUFBRCxDQURELEdBRWIsUUFBUSxDQUFDLENBQUQsQ0FGWixDQUFBO0VBSUEsSUFBTSxLQUFLLEdBQUcsRUFBZCxDQUFBO0VBRUEsU0FBUyxDQUFDLE9BQUQsRUFBVSxLQUFWLENBQVQsQ0FBQTtFQUNBLFNBQVMsQ0FBQyxJQUFWLENBQWUsQ0FBZixHQUFtQixLQUFLLENBQUMsQ0FBekIsQ0FBQTtFQUNBLFNBQVMsQ0FBQyxJQUFWLENBQWUsQ0FBZixHQUFtQixLQUFLLENBQUMsQ0FBekIsQ0FBQTtFQUVBLFdBQVcsQ0FBQyxPQUFELEVBQVUsS0FBVixDQUFYLENBQUE7RUFDQSxTQUFTLENBQUMsTUFBVixDQUFpQixDQUFqQixHQUFxQixLQUFLLENBQUMsQ0FBM0IsQ0FBQTtFQUNBLFNBQVMsQ0FBQyxNQUFWLENBQWlCLENBQWpCLEdBQXFCLEtBQUssQ0FBQyxDQUEzQixDQUFBO0VBRUEsU0FBUyxDQUFDLFNBQVYsR0FBc0IsU0FBdEIsQ0FBQTtDQUNEOztBQUVNLFNBQVMsWUFBVCxDQUF1QixLQUF2QixFQUE4QjtFQUNuQyxJQUFNLE9BQU8sR0FBRyxFQUFoQixDQURtQzs7RUFJbkMsSUFBSSxPQUFFLENBQUMsS0FBSCxDQUFTLEtBQVQsQ0FBSixFQUFxQjtJQUNuQixPQUFPLENBQUMsQ0FBRCxDQUFQLEdBQWEsS0FBSyxDQUFDLENBQUQsQ0FBbEIsQ0FBQTtJQUNBLE9BQU8sQ0FBQyxDQUFELENBQVAsR0FBYSxLQUFLLENBQUMsQ0FBRCxDQUFsQixDQUFBO0dBRkY7T0FLSztNQUNILElBQUksS0FBSyxDQUFDLElBQU4sS0FBZSxVQUFuQixFQUErQjtRQUM3QixJQUFJLEtBQUssQ0FBQyxPQUFOLENBQWMsTUFBZCxLQUF5QixDQUE3QixFQUFnQztVQUM5QixPQUFPLENBQUMsQ0FBRCxDQUFQLEdBQWEsS0FBSyxDQUFDLE9BQU4sQ0FBYyxDQUFkLENBQWIsQ0FBQTtVQUNBLE9BQU8sQ0FBQyxDQUFELENBQVAsR0FBYSxLQUFLLENBQUMsY0FBTixDQUFxQixDQUFyQixDQUFiLENBQUE7U0FGRixNQUlLLElBQUksS0FBSyxDQUFDLE9BQU4sQ0FBYyxNQUFkLEtBQXlCLENBQTdCLEVBQWdDO1VBQ25DLE9BQU8sQ0FBQyxDQUFELENBQVAsR0FBYSxLQUFLLENBQUMsY0FBTixDQUFxQixDQUFyQixDQUFiLENBQUE7VUFDQSxPQUFPLENBQUMsQ0FBRCxDQUFQLEdBQWEsS0FBSyxDQUFDLGNBQU4sQ0FBcUIsQ0FBckIsQ0FBYixDQUFBO1NBQ0Q7T0FSSCxNQVVLO1FBQ0gsT0FBTyxDQUFDLENBQUQsQ0FBUCxHQUFhLEtBQUssQ0FBQyxPQUFOLENBQWMsQ0FBZCxDQUFiLENBQUE7UUFDQSxPQUFPLENBQUMsQ0FBRCxDQUFQLEdBQWEsS0FBSyxDQUFDLE9BQU4sQ0FBYyxDQUFkLENBQWIsQ0FBQTtPQUNEO0tBQ0Y7O0VBRUQsT0FBTyxPQUFQLENBQUE7Q0FDRDs7QUFFTSxTQUFTLGNBQVQsQ0FBeUIsUUFBekIsRUFBNkQ7RUFDbEUsSUFBTSxPQUFPLEdBQUc7SUFDZCxLQUFLLEVBQUksQ0FESztJQUVkLEtBQUssRUFBSSxDQUZLO0lBR2QsT0FBTyxFQUFFLENBSEs7SUFJZCxPQUFPLEVBQUUsQ0FKSztJQUtkLE9BQU8sRUFBRSxDQUxLO0lBTWQsT0FBTyxFQUFFLENBQUE7R0FOWCxDQUFBOztFQVNBLEtBQUEsSUFBQSxFQUFBLEdBQUEsQ0FBQSxFQUFBLEVBQUEsR0FBc0IsUUFBdEIsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQWdDO0lBQUEsSUFBQSxJQUFBLENBQUE7O0lBQUEsSUFBQSxHQUFWLFFBQVUsQ0FBQSxFQUFBLENBQUEsQ0FBQTtJQUFBLElBQXJCLE9BQXFCLEdBQUEsSUFBQSxDQUFBOztJQUM5QixLQUFLLElBQU0sS0FBWCxJQUFtQixPQUFuQixFQUE0QjtNQUMxQixPQUFPLENBQUMsS0FBRCxDQUFQLElBQWlCLE9BQU8sQ0FBQyxLQUFELENBQXhCLENBQUE7S0FDRDtHQUNGOztFQUNELEtBQUssSUFBTSxJQUFYLElBQW1CLE9BQW5CLEVBQTRCO0lBQzFCLE9BQU8sQ0FBQyxJQUFELENBQVAsSUFBaUIsUUFBUSxDQUFDLE1BQTFCLENBQUE7R0FDRDs7RUFFRCxPQUFPLE9BQVAsQ0FBQTtDQUNEOztBQUVNLFNBQVMsU0FBVCxDQUFvQixLQUFwQixFQUErRTtFQUNwRixJQUFJLENBQUUsS0FBRCxDQUFlLE1BQWhCLElBQ0EsRUFBRyxLQUFELENBQXNCLE9BQXRCLElBQ0MsS0FBRCxDQUFzQixPQUF0QixDQUE4QixNQUE5QixHQUF1QyxDQUR6QyxDQURKLEVBRWlEO0lBQy9DLE9BQU8sSUFBUCxDQUFBO0dBQ0Q7O0VBRUQsSUFBTSxPQUFPLEdBQUcsWUFBWSxDQUFDLEtBQUQsQ0FBNUIsQ0FBQTtFQUNBLElBQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxHQUFMLENBQVMsT0FBTyxDQUFDLENBQUQsQ0FBUCxDQUFXLEtBQXBCLEVBQTJCLE9BQU8sQ0FBQyxDQUFELENBQVAsQ0FBVyxLQUF0QyxDQUFiLENBQUE7RUFDQSxJQUFNLElBQUksR0FBRyxJQUFJLENBQUMsR0FBTCxDQUFTLE9BQU8sQ0FBQyxDQUFELENBQVAsQ0FBVyxLQUFwQixFQUEyQixPQUFPLENBQUMsQ0FBRCxDQUFQLENBQVcsS0FBdEMsQ0FBYixDQUFBO0VBQ0EsSUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLEdBQUwsQ0FBUyxPQUFPLENBQUMsQ0FBRCxDQUFQLENBQVcsS0FBcEIsRUFBMkIsT0FBTyxDQUFDLENBQUQsQ0FBUCxDQUFXLEtBQXRDLENBQWIsQ0FBQTtFQUNBLElBQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxHQUFMLENBQVMsT0FBTyxDQUFDLENBQUQsQ0FBUCxDQUFXLEtBQXBCLEVBQTJCLE9BQU8sQ0FBQyxDQUFELENBQVAsQ0FBVyxLQUF0QyxDQUFiLENBQUE7RUFFQSxPQUFPO0lBQ0wsQ0FBQyxFQUFFLElBREU7SUFFTCxDQUFDLEVBQUUsSUFGRTtJQUdMLElBQUksRUFBRSxJQUhEO0lBSUwsR0FBRyxFQUFFLElBSkE7SUFLTCxLQUFLLEVBQUUsSUFMRjtJQU1MLE1BQU0sRUFBRSxJQU5IO0lBT0wsS0FBSyxFQUFFLElBQUksR0FBRyxJQVBUO0lBUUwsTUFBTSxFQUFFLElBQUksR0FBRyxJQUFBO0dBUmpCLENBQUE7Q0FVRDs7QUFFTSxTQUFTLGFBQVQsQ0FBd0IsS0FBeEIsRUFBK0IsV0FBL0IsRUFBNEM7RUFDakQsSUFBTSxPQUFPLEdBQUcsV0FBVyxHQUFHLEdBQTlCLENBQUE7RUFDQSxJQUFNLE9BQU8sR0FBRyxXQUFXLEdBQUcsR0FBOUIsQ0FBQTtFQUNBLElBQU0sT0FBTyxHQUFHLFlBQVksQ0FBQyxLQUFELENBQTVCLENBQUE7RUFFQSxJQUFNLEVBQUUsR0FBRyxPQUFPLENBQUMsQ0FBRCxDQUFQLENBQVcsT0FBWCxDQUFBLEdBQXNCLE9BQU8sQ0FBQyxDQUFELENBQVAsQ0FBVyxPQUFYLENBQWpDLENBQUE7RUFDQSxJQUFNLEVBQUUsR0FBRyxPQUFPLENBQUMsQ0FBRCxDQUFQLENBQVcsT0FBWCxDQUFBLEdBQXNCLE9BQU8sQ0FBQyxDQUFELENBQVAsQ0FBVyxPQUFYLENBQWpDLENBQUE7RUFFQSxPQUFPLENBQUEsQ0FBQSxFQUFBLE1BQUEsQ0FBQSxTQUFBLENBQUEsRUFBTSxFQUFOLEVBQVUsRUFBVixDQUFQLENBQUE7Q0FDRDs7QUFFTSxTQUFTLFVBQVQsQ0FBcUIsS0FBckIsRUFBNEIsV0FBNUIsRUFBeUM7RUFDOUMsSUFBTSxPQUFPLEdBQUcsV0FBVyxHQUFHLEdBQTlCLENBQUE7RUFDQSxJQUFNLE9BQU8sR0FBRyxXQUFXLEdBQUcsR0FBOUIsQ0FBQTtFQUNBLElBQU0sT0FBTyxHQUFHLFlBQVksQ0FBQyxLQUFELENBQTVCLENBQUE7RUFDQSxJQUFNLEVBQUUsR0FBRyxPQUFPLENBQUMsQ0FBRCxDQUFQLENBQVcsT0FBWCxDQUFBLEdBQXNCLE9BQU8sQ0FBQyxDQUFELENBQVAsQ0FBVyxPQUFYLENBQWpDLENBQUE7RUFDQSxJQUFNLEVBQUUsR0FBRyxPQUFPLENBQUMsQ0FBRCxDQUFQLENBQVcsT0FBWCxDQUFBLEdBQXNCLE9BQU8sQ0FBQyxDQUFELENBQVAsQ0FBVyxPQUFYLENBQWpDLENBQUE7RUFDQSxJQUFNLEtBQUssR0FBRyxHQUFBLEdBQU0sSUFBSSxDQUFDLEtBQUwsQ0FBVyxFQUFYLEVBQWUsRUFBZixDQUFOLEdBQTJCLElBQUksQ0FBQyxFQUE5QyxDQUFBO0VBRUEsT0FBUSxLQUFSLENBQUE7Q0FDRDs7QUFFTSxTQUFTLGNBQVQsQ0FBeUIsT0FBekIsRUFBa0M7RUFDdkMsT0FBTyxPQUFFLENBQUMsTUFBSCxDQUFVLE9BQU8sQ0FBQyxXQUFsQixDQUFBLEdBQ0gsT0FBTyxDQUFDLFdBREwsR0FFSCxPQUFFLENBQUMsTUFBSCxDQUFVLE9BQU8sQ0FBQyxXQUFsQixDQUFBLEdBQ0UsQ0FBQyxTQUFELEVBQVksU0FBWixFQUF1QixPQUF2QixFQUFnQyxLQUFoQyxFQUF1QyxPQUF2QyxDQUFBLENBQWdELE9BQU8sQ0FBQyxXQUF4RCxDQURGOztJQUlFLE9BQUEsQ0FBUSxJQUFSLENBQWEsT0FBTyxDQUFDLElBQXJCLENBQUEsSUFBOEIsT0FBTyxZQUFZLGdCQUFBLENBQUEsU0FBQSxDQUFBLENBQUksS0FBckQsR0FDRSxPQURGLEdBRUUsT0FSUixDQUFBOzs7O0FBWUssU0FBUyxlQUFULENBQTBCLEtBQTFCLEVBQWlDO0VBQ3RDLElBQU0sSUFBSSxHQUFHLE9BQUUsQ0FBQyxJQUFILENBQVEsS0FBSyxDQUFDLFlBQWQsQ0FBQSxHQUE4QixLQUFLLENBQUMsWUFBTixFQUE5QixHQUFxRCxLQUFLLENBQUMsSUFBeEUsQ0FBQTtFQUVBLE9BQU8sQ0FDTCxRQUFRLENBQUMsZ0JBQVQsQ0FBMEIsSUFBSSxHQUFHLElBQUksQ0FBQyxDQUFELENBQVAsR0FBYSxLQUFLLENBQUMsTUFBakQsQ0FESyxFQUVMLFFBQVEsQ0FBQyxnQkFBVCxDQUEwQixLQUFLLENBQUMsYUFBaEMsQ0FGSyxDQUFQLENBQUE7Q0FJRDs7QUFFTSxTQUFTLFNBQVQsR0FBZ0Q7RUFDckQsT0FBTztJQUNMLElBQUksRUFBTztNQUFFLENBQUMsRUFBRSxDQUFMO01BQVEsQ0FBQyxFQUFFLENBQUE7S0FEakI7SUFFTCxNQUFNLEVBQUs7TUFBRSxDQUFDLEVBQUUsQ0FBTDtNQUFRLENBQUMsRUFBRSxDQUFBO0tBRmpCO0lBR0wsU0FBUyxFQUFFLENBQUE7R0FIYixDQUFBO0NBS0Q7O0FBRU0sU0FBUyxhQUFULENBQXdCLE1BQXhCLEVBQTRDO0VBQ2pELElBQU0sS0FBSyxHQUFHO0lBQ1osTUFBTSxFQUFOLE1BRFk7O0lBRVosSUFBSSxJQUFKLEdBQVk7TUFBRSxPQUFPLElBQUEsQ0FBSyxNQUFMLENBQVksSUFBbkIsQ0FBQTtLQUZGOztJQUdaLElBQUksTUFBSixHQUFjO01BQUUsT0FBTyxJQUFBLENBQUssTUFBTCxDQUFZLE1BQW5CLENBQUE7S0FISjs7SUFJWixJQUFJLFNBQUosR0FBaUI7TUFBRSxPQUFPLElBQUEsQ0FBSyxNQUFMLENBQVksU0FBbkIsQ0FBQTtLQUpQOztJQUtaLElBQUksS0FBSixHQUFhO01BQUUsT0FBTyxJQUFBLENBQUssTUFBTCxDQUFZLElBQVosQ0FBaUIsQ0FBeEIsQ0FBQTtLQUxIOztJQU1aLElBQUksS0FBSixHQUFhO01BQUUsT0FBTyxJQUFBLENBQUssTUFBTCxDQUFZLElBQVosQ0FBaUIsQ0FBeEIsQ0FBQTtLQU5IOztJQU9aLElBQUksT0FBSixHQUFlO01BQUUsT0FBTyxJQUFBLENBQUssTUFBTCxDQUFZLE1BQVosQ0FBbUIsQ0FBMUIsQ0FBQTtLQVBMOztJQVFaLElBQUksT0FBSixHQUFlO01BQUUsT0FBTyxJQUFBLENBQUssTUFBTCxDQUFZLE1BQVosQ0FBbUIsQ0FBMUIsQ0FBQTtLQVJMOztJQVNaLElBQUksU0FBSixHQUFpQjtNQUFFLE9BQU8sSUFBQSxDQUFLLE1BQUwsQ0FBWSxTQUFuQixDQUFBO0tBVFA7O0lBVVosSUFBSSxNQUFKLEdBQWM7TUFBRSxPQUFPLElBQUEsQ0FBSyxNQUFMLENBQVksTUFBbkIsQ0FBQTtLQVZKOztJQVdaLElBQUksSUFBSixHQUFZO01BQUUsT0FBTyxJQUFBLENBQUssTUFBTCxDQUFZLElBQW5CLENBQUE7S0FYRjs7SUFZWixJQUFJLFdBQUosR0FBbUI7TUFBRSxPQUFPLElBQUEsQ0FBSyxNQUFMLENBQVksV0FBbkIsQ0FBQTtLQVpUOztJQWFaLElBQUksT0FBSixHQUFlO01BQUUsT0FBTyxJQUFBLENBQUssTUFBTCxDQUFZLE9BQW5CLENBQUE7S0FiTDs7SUFjWixjQWRZLEVBQUEsU0FBQSxjQUFBLEdBY00sRUFBRTtHQWR0QixDQUFBO0VBaUJBLE9BQU8sS0FBUCxDQUFBO0NBQ0Q7Ozs7Ozs7Ozs7OztBQ25RRCxnREFBQTs7QUFDQSxJQUFBLGFBQUEsR0FBQSw0QkFBQSxDQUFBLGFBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsT0FBQSxHQUFBLDRCQUFBLENBQUEsT0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxtQkFBQSxHQUFBLDJCQUFBLENBQUEsa0JBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsWUFBQSxHQUFBLDRCQUFBLENBQUEsaUJBQUEsQ0FBQSxDQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFJQSxJQUFNLFFBQXVCLEdBQUcsRUFBaEMsQ0FBQTtBQUNBLElBQU0sT0FHSixHQUFHLEVBSEwsQ0FBQTtBQUtBLElBQU0sZUFNTCxHQUFHLEVBTkosQ0FBQTtBQU9BLElBQU0sU0FBcUIsR0FBRyxFQUE5QixDQUFBOztBQUVBLFNBQVMsR0FBVCxDQUFjLE9BQWQsRUFBb0MsSUFBcEMsRUFBa0QsUUFBbEQsRUFBc0UsV0FBdEUsRUFBbUc7RUFDakcsSUFBTSxPQUFPLEdBQUcsVUFBVSxDQUFDLFdBQUQsQ0FBMUIsQ0FBQTtFQUNBLElBQUksWUFBWSxHQUFHLFFBQVEsQ0FBQyxPQUFULENBQWlCLE9BQWpCLENBQW5CLENBQUE7RUFDQSxJQUFJLE1BQU0sR0FBRyxPQUFPLENBQUMsWUFBRCxDQUFwQixDQUFBOztFQUVBLElBQUksQ0FBQyxNQUFMLEVBQWE7SUFDWCxNQUFNLEdBQUc7TUFDUCxNQUFNLEVBQUUsRUFERDtNQUVQLFNBQVMsRUFBRSxDQUFBO0tBRmIsQ0FBQTtJQUtBLFlBQVksR0FBRyxRQUFRLENBQUMsSUFBVCxDQUFjLE9BQWQsQ0FBQSxHQUF5QixDQUF4QyxDQUFBO0lBQ0EsT0FBTyxDQUFDLElBQVIsQ0FBYSxNQUFiLENBQUEsQ0FBQTtHQUNEOztFQUVELElBQUksQ0FBQyxNQUFNLENBQUMsTUFBUCxDQUFjLElBQWQsQ0FBTCxFQUEwQjtJQUN4QixNQUFNLENBQUMsTUFBUCxDQUFjLElBQWQsQ0FBQSxHQUFzQixFQUF0QixDQUFBO0lBQ0EsTUFBTSxDQUFDLFNBQVAsRUFBQSxDQUFBO0dBQ0Q7O0VBRUQsSUFBSSxPQUFPLENBQUMsbUJBQVIsSUFBK0IsQ0FBQyxDQUFBLENBQUEsRUFBQSxRQUFBLENBQUEsUUFBQSxFQUFTLE1BQU0sQ0FBQyxNQUFQLENBQWMsSUFBZCxDQUFULEVBQThCLFFBQTlCLENBQXBDLEVBQTZFO0lBQzNFLE9BQU8sQ0FBQyxnQkFBUixDQUF5QixJQUF6QixFQUErQixRQUEvQixFQUFnRCxNQUFNLENBQUMsZUFBUCxHQUF5QixPQUF6QixHQUFtQyxDQUFDLENBQUMsT0FBTyxDQUFDLE9BQTdGLENBQUEsQ0FBQTtJQUNBLE1BQU0sQ0FBQyxNQUFQLENBQWMsSUFBZCxDQUFBLENBQW9CLElBQXBCLENBQXlCLFFBQXpCLENBQUEsQ0FBQTtHQUNEO0NBQ0Y7O0FBRUQsU0FBUyxXQUFULENBQWlCLE9BQWpCLEVBQXVDLElBQXZDLEVBQXFELFFBQXJELEVBQWtGLFdBQWxGLEVBQStHO0VBQzdHLElBQU0sT0FBTyxHQUFHLFVBQVUsQ0FBQyxXQUFELENBQTFCLENBQUE7RUFDQSxJQUFNLFlBQVksR0FBRyxRQUFRLENBQUMsT0FBVCxDQUFpQixPQUFqQixDQUFyQixDQUFBO0VBQ0EsSUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLFlBQUQsQ0FBdEIsQ0FBQTs7RUFFQSxJQUFJLENBQUMsTUFBRCxJQUFXLENBQUMsTUFBTSxDQUFDLE1BQXZCLEVBQStCO0lBQzdCLE9BQUE7R0FDRDs7RUFFRCxJQUFJLElBQUksS0FBSyxLQUFiLEVBQW9CO0lBQ2xCLEtBQUssSUFBTCxJQUFhLE1BQU0sQ0FBQyxNQUFwQixFQUE0QjtNQUMxQixJQUFJLE1BQU0sQ0FBQyxNQUFQLENBQWMsY0FBZCxDQUE2QixJQUE3QixDQUFKLEVBQXdDO1FBQ3RDLFdBQU0sQ0FBQyxPQUFELEVBQVUsSUFBVixFQUFnQixLQUFoQixDQUFOLENBQUE7T0FDRDtLQUNGOztJQUNELE9BQUE7R0FDRDs7RUFFRCxJQUFJLE1BQU0sQ0FBQyxNQUFQLENBQWMsSUFBZCxDQUFKLEVBQXlCO0lBQ3ZCLElBQU0sR0FBRyxHQUFHLE1BQU0sQ0FBQyxNQUFQLENBQWMsSUFBZCxDQUFBLENBQW9CLE1BQWhDLENBQUE7O0lBRUEsSUFBSSxRQUFRLEtBQUssS0FBakIsRUFBd0I7TUFDdEIsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFiLEVBQWdCLENBQUMsR0FBRyxHQUFwQixFQUF5QixDQUFDLEVBQTFCLEVBQThCO1FBQzVCLFdBQU0sQ0FBQyxPQUFELEVBQVUsSUFBVixFQUFnQixNQUFNLENBQUMsTUFBUCxDQUFjLElBQWQsQ0FBQSxDQUFvQixDQUFwQixDQUFoQixFQUF3QyxPQUF4QyxDQUFOLENBQUE7T0FDRDs7TUFDRCxPQUFBO0tBSkYsTUFNSztNQUNILEtBQUssSUFBSSxFQUFDLEdBQUcsQ0FBYixFQUFnQixFQUFDLEdBQUcsR0FBcEIsRUFBeUIsRUFBQyxFQUExQixFQUE4QjtRQUM1QixJQUFJLE9BQU8sQ0FBQyxtQkFBUixJQUErQixNQUFNLENBQUMsTUFBUCxDQUFjLElBQWQsQ0FBQSxDQUFvQixFQUFwQixDQUFBLEtBQTJCLFFBQTlELEVBQXdFO1VBQ3RFLE9BQU8sQ0FBQyxtQkFBUixDQUE0QixJQUE1QixFQUFrQyxRQUFsQyxFQUFtRCxNQUFNLENBQUMsZUFBUCxHQUF5QixPQUF6QixHQUFtQyxDQUFDLENBQUMsT0FBTyxDQUFDLE9BQWhHLENBQUEsQ0FBQTtVQUNBLE1BQU0sQ0FBQyxNQUFQLENBQWMsSUFBZCxDQUFBLENBQW9CLE1BQXBCLENBQTJCLEVBQTNCLEVBQThCLENBQTlCLENBQUEsQ0FBQTtVQUVBLE1BQUE7U0FDRDtPQUNGO0tBQ0Y7O0lBRUQsSUFBSSxNQUFNLENBQUMsTUFBUCxDQUFjLElBQWQsQ0FBQSxJQUF1QixNQUFNLENBQUMsTUFBUCxDQUFjLElBQWQsQ0FBQSxDQUFvQixNQUFwQixLQUErQixDQUExRCxFQUE2RDtNQUMxRCxNQUFNLENBQUMsTUFBUCxDQUFjLElBQWQsQ0FBRCxHQUErQixJQUEvQixDQUFBO01BQ0EsTUFBTSxDQUFDLFNBQVAsRUFBQSxDQUFBO0tBQ0Q7R0FDRjs7RUFFRCxJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVosRUFBdUI7SUFDckIsT0FBTyxDQUFDLE1BQVIsQ0FBZSxZQUFmLEVBQTZCLENBQTdCLENBQUEsQ0FBQTtJQUNBLFFBQVEsQ0FBQyxNQUFULENBQWdCLFlBQWhCLEVBQThCLENBQTlCLENBQUEsQ0FBQTtHQUNEO0NBQ0Y7O0FBRUQsU0FBUyxXQUFULENBQXNCLFFBQXRCLEVBQXdDLE9BQXhDLEVBQXVELElBQXZELEVBQXFFLFFBQXJFLEVBQXlGLFdBQXpGLEVBQTRHO0VBQzFHLElBQU0sT0FBTyxHQUFHLFVBQVUsQ0FBQyxXQUFELENBQTFCLENBQUE7O0VBQ0EsSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFELENBQXBCLEVBQTRCO0lBQzFCLGVBQWUsQ0FBQyxJQUFELENBQWYsR0FBd0I7TUFDdEIsUUFBUSxFQUFHLEVBRFc7TUFFdEIsU0FBUyxFQUFFLEVBRlc7TUFHdEIsU0FBUyxFQUFFLEVBQUE7S0FIYixDQUQwQjs7SUFRMUIsS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUFrQixTQUFsQixDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBNkI7TUFBQSxJQUFBLElBQUEsQ0FBQTs7TUFBQSxJQUFBLEdBQVgsU0FBVyxDQUFBLEdBQUEsQ0FBQSxDQUFBO01BQUEsSUFBbEIsR0FBa0IsR0FBQSxJQUFBLENBQUE7TUFDM0IsR0FBRyxDQUFDLEdBQUQsRUFBTSxJQUFOLEVBQVksZ0JBQVosQ0FBSCxDQUFBO01BQ0EsR0FBRyxDQUFDLEdBQUQsRUFBTSxJQUFOLEVBQVksa0JBQVosRUFBZ0MsSUFBaEMsQ0FBSCxDQUFBO0tBQ0Q7R0FDRjs7RUFFRCxJQUFNLFNBQVMsR0FBRyxlQUFlLENBQUMsSUFBRCxDQUFqQyxDQUFBO0VBQ0EsSUFBSSxLQUFKLENBQUE7O0VBRUEsS0FBSyxLQUFLLEdBQUcsU0FBUyxDQUFDLFNBQVYsQ0FBb0IsTUFBcEIsR0FBNkIsQ0FBMUMsRUFBNkMsS0FBSyxJQUFJLENBQXRELEVBQXlELEtBQUssRUFBOUQsRUFBa0U7SUFDaEUsSUFBSSxTQUFTLENBQUMsU0FBVixDQUFvQixLQUFwQixDQUFBLEtBQStCLFFBQS9CLElBQ0EsU0FBUyxDQUFDLFFBQVYsQ0FBbUIsS0FBbkIsQ0FBQSxLQUE4QixPQURsQyxFQUMyQztNQUN6QyxNQUFBO0tBQ0Q7R0FDRjs7RUFFRCxJQUFJLEtBQUssS0FBSyxDQUFDLENBQWYsRUFBa0I7SUFDaEIsS0FBSyxHQUFHLFNBQVMsQ0FBQyxTQUFWLENBQW9CLE1BQTVCLENBQUE7SUFFQSxTQUFTLENBQUMsU0FBVixDQUFvQixJQUFwQixDQUF5QixRQUF6QixDQUFBLENBQUE7SUFDQSxTQUFTLENBQUMsUUFBVixDQUFtQixJQUFuQixDQUF3QixPQUF4QixDQUFBLENBQUE7SUFDQSxTQUFTLENBQUMsU0FBVixDQUFvQixJQUFwQixDQUF5QixFQUF6QixDQUFBLENBQUE7R0EvQndHOzs7RUFtQzFHLFNBQVMsQ0FBQyxTQUFWLENBQW9CLEtBQXBCLENBQUEsQ0FBMkIsSUFBM0IsQ0FBZ0MsQ0FBQyxRQUFELEVBQVcsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxPQUFyQixFQUE4QixPQUFPLENBQUMsT0FBdEMsQ0FBaEMsQ0FBQSxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxjQUFULENBQ0UsUUFERixFQUVFLE9BRkYsRUFHRSxJQUhGLEVBSUUsUUFKRixFQUtFLFdBTEYsRUFNRTtFQUNBLElBQU0sT0FBTyxHQUFHLFVBQVUsQ0FBQyxXQUFELENBQTFCLENBQUE7RUFDQSxJQUFNLFNBQVMsR0FBRyxlQUFlLENBQUMsSUFBRCxDQUFqQyxDQUFBO0VBQ0EsSUFBSSxVQUFVLEdBQUcsS0FBakIsQ0FBQTtFQUNBLElBQUksS0FBSixDQUFBOztFQUVBLElBQUksQ0FBQyxTQUFMLEVBQWdCO0lBQUUsT0FBQTtHQU5sQjs7O0VBU0EsS0FBSyxLQUFLLEdBQUcsU0FBUyxDQUFDLFNBQVYsQ0FBb0IsTUFBcEIsR0FBNkIsQ0FBMUMsRUFBNkMsS0FBSyxJQUFJLENBQXRELEVBQXlELEtBQUssRUFBOUQsRUFBa0U7O0lBRWhFLElBQUksU0FBUyxDQUFDLFNBQVYsQ0FBb0IsS0FBcEIsQ0FBQSxLQUErQixRQUEvQixJQUNBLFNBQVMsQ0FBQyxRQUFWLENBQW1CLEtBQW5CLENBQUEsS0FBOEIsT0FEbEMsRUFDMkM7TUFDekMsSUFBTSxTQUFTLEdBQUcsU0FBUyxDQUFDLFNBQVYsQ0FBb0IsS0FBcEIsQ0FBbEIsQ0FEeUM7O01BSXpDLEtBQUssSUFBSSxDQUFDLEdBQUcsU0FBUyxDQUFDLE1BQVYsR0FBbUIsQ0FBaEMsRUFBbUMsQ0FBQyxJQUFJLENBQXhDLEVBQTJDLENBQUMsRUFBNUMsRUFBZ0Q7UUFBQSxJQUFBLFlBQUEsR0FBQSxjQUFBLENBQ2YsU0FBUyxDQUFDLENBQUQsQ0FETSxFQUFBLENBQUEsQ0FBQTtZQUN2QyxFQUR1QyxHQUFBLFlBQUEsQ0FBQSxDQUFBLENBQUE7WUFDbkMsT0FEbUMsR0FBQSxZQUFBLENBQUEsQ0FBQSxDQUFBO1lBQzFCLE9BRDBCLEdBQUEsWUFBQSxDQUFBLENBQUEsQ0FBQSxDQUFBOzs7UUFJOUMsSUFBSSxFQUFFLEtBQUssUUFBUCxJQUFtQixPQUFPLEtBQUssQ0FBQyxDQUFDLE9BQU8sQ0FBQyxPQUF6QyxJQUFvRCxPQUFPLEtBQUssT0FBTyxDQUFDLE9BQTVFLEVBQXFGOztVQUVuRixTQUFTLENBQUMsTUFBVixDQUFpQixDQUFqQixFQUFvQixDQUFwQixDQUFBLENBRm1GOzs7VUFNbkYsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFmLEVBQXVCO1lBQ3JCLFNBQVMsQ0FBQyxTQUFWLENBQW9CLE1BQXBCLENBQTJCLEtBQTNCLEVBQWtDLENBQWxDLENBQUEsQ0FBQTtZQUNBLFNBQVMsQ0FBQyxRQUFWLENBQW1CLE1BQW5CLENBQTBCLEtBQTFCLEVBQWlDLENBQWpDLENBQUEsQ0FBQTtZQUNBLFNBQVMsQ0FBQyxTQUFWLENBQW9CLE1BQXBCLENBQTJCLEtBQTNCLEVBQWtDLENBQWxDLENBQUEsQ0FIcUI7O1lBTXJCLFdBQU0sQ0FBQyxPQUFELEVBQVUsSUFBVixFQUFnQixnQkFBaEIsQ0FBTixDQUFBO1lBQ0EsV0FBTSxDQUFDLE9BQUQsRUFBVSxJQUFWLEVBQWdCLGtCQUFoQixFQUFvQyxJQUFwQyxDQUFOLENBUHFCOztZQVVyQixJQUFJLENBQUMsU0FBUyxDQUFDLFNBQVYsQ0FBb0IsTUFBekIsRUFBaUM7Y0FDL0IsZUFBZSxDQUFDLElBQUQsQ0FBZixHQUF3QixJQUF4QixDQUFBO2FBQ0Q7V0FsQmdGOzs7VUFzQm5GLFVBQVUsR0FBRyxJQUFiLENBQUE7VUFDQSxNQUFBO1NBQ0Q7T0FDRjs7TUFFRCxJQUFJLFVBQUosRUFBZ0I7UUFBRSxNQUFBO09BQU87S0FDMUI7R0FDRjs7Ozs7QUFLSCxTQUFTLGdCQUFULENBQTJCLEtBQTNCLEVBQXlDLFdBQXpDLEVBQTREO0VBQzFELElBQU0sT0FBTyxHQUFHLFVBQVUsQ0FBQyxXQUFELENBQTFCLENBQUE7RUFDQSxJQUFNLFNBQVMsR0FBRyxJQUFJLFNBQUosQ0FBYyxLQUFkLENBQWxCLENBQUE7RUFDQSxJQUFNLFNBQVMsR0FBRyxlQUFlLENBQUMsS0FBSyxDQUFDLElBQVAsQ0FBakMsQ0FBQTs7RUFIMEQsSUFBQSxxQkFBQSxHQUluQyxZQUFZLENBQUMsZUFBYixDQUE2QixLQUE3QixDQUptQztNQUFBLHNCQUFBLEdBQUEsY0FBQSxDQUFBLHFCQUFBLEVBQUEsQ0FBQSxDQUFBO01BSW5ELFdBSm1ELEdBQUEsc0JBQUEsQ0FBQSxDQUFBLENBQUEsQ0FBQTs7RUFLMUQsSUFBSSxPQUFhLEdBQUcsV0FBcEIsQ0FMMEQ7O0VBUTFELE9BQU8sT0FBRSxDQUFDLE9BQUgsQ0FBVyxPQUFYLENBQVAsRUFBNEI7SUFDMUIsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFiLEVBQWdCLENBQUMsR0FBRyxTQUFTLENBQUMsU0FBVixDQUFvQixNQUF4QyxFQUFnRCxDQUFDLEVBQWpELEVBQXFEO01BQ25ELElBQU0sUUFBUSxHQUFHLFNBQVMsQ0FBQyxTQUFWLENBQW9CLENBQXBCLENBQWpCLENBQUE7TUFDQSxJQUFNLE9BQU8sR0FBRyxTQUFTLENBQUMsUUFBVixDQUFtQixDQUFuQixDQUFoQixDQUFBOztNQUVBLElBQUksYUFBUSxDQUFDLGVBQVQsQ0FBeUIsT0FBekIsRUFBa0MsUUFBbEMsQ0FBQSxJQUNBLGFBQVEsQ0FBQyxZQUFULENBQXNCLE9BQXRCLEVBQStCLFdBQS9CLENBREEsSUFFQSxhQUFRLENBQUMsWUFBVCxDQUFzQixPQUF0QixFQUErQixPQUEvQixDQUZKLEVBRTZDO1FBQzNDLElBQU0sU0FBUyxHQUFHLFNBQVMsQ0FBQyxTQUFWLENBQW9CLENBQXBCLENBQWxCLENBQUE7UUFFQSxTQUFTLENBQUMsYUFBVixHQUEwQixPQUExQixDQUFBOztRQUVBLEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBcUMsU0FBckMsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQWdEO1VBQUEsSUFBQSxLQUFBLENBQUE7O1VBQUEsS0FBQSxHQUFYLFNBQVcsQ0FBQSxHQUFBLENBQUEsQ0FBQTs7VUFBQSxJQUFBLEtBQUEsR0FBQSxLQUFBO2NBQUEsS0FBQSxHQUFBLGNBQUEsQ0FBQSxLQUFBLEVBQUEsQ0FBQSxDQUFBO2NBQXBDLEVBQW9DLEdBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTtjQUFoQyxPQUFnQyxHQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7Y0FBdkIsT0FBdUIsR0FBQSxLQUFBLENBQUEsQ0FBQSxDQUFBLENBQUE7O1VBQzlDLElBQUksT0FBTyxLQUFLLENBQUMsQ0FBQyxPQUFPLENBQUMsT0FBdEIsSUFBaUMsT0FBTyxLQUFLLE9BQU8sQ0FBQyxPQUF6RCxFQUFrRTtZQUNoRSxFQUFFLENBQUMsU0FBRCxDQUFGLENBQUE7V0FDRDtTQUNGO09BQ0Y7S0FDRjs7SUFFRCxPQUFPLEdBQUcsYUFBUSxDQUFDLFVBQVQsQ0FBb0IsT0FBcEIsQ0FBVixDQUFBO0dBQ0Q7Q0FDRjs7QUFFRCxTQUFTLGtCQUFULENBQTZCLEtBQTdCLEVBQTJDO0VBQ3pDLE9BQU8sZ0JBQWdCLENBQUMsSUFBakIsQ0FBc0IsSUFBdEIsRUFBNEIsS0FBNUIsRUFBbUMsSUFBbkMsQ0FBUCxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxVQUFULENBQXFCLEtBQXJCLEVBQW9DO0VBQ2xDLE9BQU8sT0FBRSxDQUFDLE1BQUgsQ0FBVSxLQUFWLENBQUEsR0FBbUIsS0FBbkIsR0FBMkI7SUFBRSxPQUFPLEVBQUUsS0FBQTtHQUE3QyxDQUFBO0NBQ0Q7O0lBRVk7RUFHWCxTQUFBLFNBQUEsQ0FBb0IsYUFBcEIsRUFBMEM7SUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLFNBQUEsQ0FBQSxDQUFBOztJQUFBLElBQUEsQ0FBdEIsYUFBc0IsR0FBdEIsYUFBc0IsQ0FBQTs7SUFBQSxlQUFBLENBQUEsSUFBQSxFQUFBLGVBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOzs7SUFFeEMsQ0FBQSxDQUFBLEVBQUEsbUJBQUEsQ0FBQSxTQUFBLENBQUEsRUFBUSxJQUFSLEVBQWMsYUFBZCxDQUFBLENBQUE7R0FDRDs7Ozs2Q0FFeUI7TUFDeEIsSUFBQSxDQUFLLGFBQUwsQ0FBbUIsY0FBbkIsRUFBQSxDQUFBO0tBQ0Q7OztzQ0FFa0I7TUFDakIsSUFBQSxDQUFLLGFBQUwsQ0FBbUIsZUFBbkIsRUFBQSxDQUFBO0tBQ0Q7OzsrQ0FFMkI7TUFDMUIsSUFBQSxDQUFLLGFBQUwsQ0FBbUIsd0JBQW5CLEVBQUEsQ0FBQTtLQUNEOzs7Ozs7O0FBR0gsSUFBTSxNQUFNLEdBQUc7RUFDYixHQUFHLEVBQUgsR0FEYTtFQUViLE1BQU0sRUFBTixXQUZhO0VBSWIsV0FBVyxFQUFYLFdBSmE7RUFLYixjQUFjLEVBQWQsY0FMYTtFQU9iLGdCQUFnQixFQUFoQixnQkFQYTtFQVFiLGtCQUFrQixFQUFsQixrQkFSYTtFQVNiLGVBQWUsRUFBZixlQVRhO0VBVWIsU0FBUyxFQUFULFNBVmE7RUFZYixlQUFlLEVBQUUsS0FaSjtFQWFiLGVBQWUsRUFBRSxLQWJKO0VBZWIsU0FBUyxFQUFFLFFBZkU7RUFnQmIsUUFBUSxFQUFFLE9BaEJHO0VBa0JiLElBbEJhLEVBQUEsU0FBQSxJQUFBLENBa0JQLE1BbEJPLEVBa0JTO0lBQ3BCLE1BQU0sQ0FBQyxRQUFQLENBQWdCLGFBQWhCLENBQThCLEtBQTlCLENBQUEsQ0FBcUMsZ0JBQXJDLENBQXNELE1BQXRELEVBQThELElBQTlELEVBQW9FO01BQ2xFLElBQUksT0FBSixHQUFlO1FBQUUsT0FBUSxNQUFNLENBQUMsZUFBUCxHQUF5QixJQUFqQyxDQUFBO09BRGlEOztNQUVsRSxJQUFJLE9BQUosR0FBZTtRQUFFLE9BQVEsTUFBTSxDQUFDLGVBQVAsR0FBeUIsSUFBakMsQ0FBQTtPQUF3Qzs7S0FGM0QsQ0FBQSxDQUFBO0dBSUQ7Q0F2QkgsQ0FBQTtvQkEwQmU7Ozs7Ozs7Ozs7O0FDNVJBLFNBQVMsTUFBVCxDQUFzQyxJQUF0QyxFQUE0RCxNQUE1RCxFQUE4RTtFQUMzRixLQUFLLElBQU0sSUFBWCxJQUFtQixNQUFuQixFQUEyQjtJQUN4QixJQUFELENBQXVCLElBQXZCLENBQUEsR0FBK0IsTUFBTSxDQUFDLElBQUQsQ0FBckMsQ0FBQTtHQUNEOztFQUVELElBQU0sR0FBRyxHQUFHLElBQVosQ0FBQTtFQUVBLE9BQU8sR0FBUCxDQUFBO0NBQ0Q7Ozs7Ozs7Ozs7OztBQ1JELElBQUEsT0FBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsNEJBQUEsQ0FBQSxPQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7QUFNZSxTQUFTLFNBQVQsQ0FDYixJQURhLEVBRWIsU0FGYSxFQUdiLE1BSGEsRUFJUTtFQUNyQixNQUFNLEdBQUcsTUFBTSxJQUFJLEVBQW5CLENBQUE7O0VBRUEsSUFBSSxPQUFFLENBQUMsTUFBSCxDQUFVLElBQVYsQ0FBQSxJQUFtQixJQUFJLENBQUMsTUFBTCxDQUFZLEdBQVosQ0FBQSxLQUFxQixDQUFDLENBQTdDLEVBQWdEO0lBQzlDLElBQUksR0FBRyxLQUFLLENBQUMsSUFBRCxDQUFaLENBQUE7R0FDRDs7RUFFRCxJQUFJLE9BQUUsQ0FBQyxLQUFILENBQVMsSUFBVCxDQUFKLEVBQW9CO0lBQ2xCLE9BQU8sSUFBSSxDQUFDLE1BQUwsQ0FDTCxVQUFDLEdBQUQsRUFBTSxDQUFOLEVBQUE7TUFBQSxPQUFZLENBQUEsQ0FBQSxFQUFBLE9BQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxHQUFQLEVBQVksU0FBUyxDQUFDLENBQUQsRUFBSSxTQUFKLEVBQWUsTUFBZixDQUFyQixDQUFaLENBQUE7S0FESyxFQUVMLE1BRkssQ0FBUCxDQUFBO0dBUm1COzs7RUFlckIsSUFBSSxPQUFFLENBQUMsTUFBSCxDQUFVLElBQVYsQ0FBSixFQUFxQjtJQUNuQixTQUFTLEdBQUcsSUFBWixDQUFBO0lBQ0EsSUFBSSxHQUFHLEVBQVAsQ0FBQTtHQUNEOztFQUVELElBQUksT0FBRSxDQUFDLElBQUgsQ0FBUSxTQUFSLENBQUosRUFBd0I7SUFDdEIsTUFBTSxDQUFDLElBQUQsQ0FBTixHQUFlLE1BQU0sQ0FBQyxJQUFELENBQU4sSUFBZ0IsRUFBL0IsQ0FBQTtJQUNBLE1BQU0sQ0FBQyxJQUFELENBQU4sQ0FBYSxJQUFiLENBQWtCLFNBQWxCLENBQUEsQ0FBQTtHQUZGLE1BSUssSUFBSSxPQUFFLENBQUMsS0FBSCxDQUFTLFNBQVQsQ0FBSixFQUF5QjtJQUM1QixLQUFBLElBQUEsRUFBQSxHQUFBLENBQUEsRUFBQSxFQUFBLEdBQWdCLFNBQWhCLENBQUEsTUFBQSxFQUFBLEVBQUEsRUFBQSxFQUEyQjtNQUFBLElBQUEsSUFBQSxDQUFBOztNQUFBLElBQUEsR0FBWCxTQUFXLENBQUEsRUFBQSxDQUFBLENBQUE7TUFBQSxJQUFoQixDQUFnQixHQUFBLElBQUEsQ0FBQTtNQUN6QixTQUFTLENBQUMsSUFBRCxFQUFPLENBQVAsRUFBVSxNQUFWLENBQVQsQ0FBQTtLQUNEO0dBSEUsTUFLQSxJQUFJLE9BQUUsQ0FBQyxNQUFILENBQVUsU0FBVixDQUFKLEVBQTBCO0lBQzdCLEtBQUssSUFBTSxNQUFYLElBQXFCLFNBQXJCLEVBQWdDO01BQzlCLElBQU0sYUFBYSxHQUFHLEtBQUssQ0FBQyxNQUFELENBQUwsQ0FBYyxHQUFkLENBQWtCLFVBQUEsQ0FBQyxFQUFBO1FBQUEsT0FBQSxFQUFBLENBQUEsTUFBQSxDQUFPLElBQVAsQ0FBQSxDQUFBLE1BQUEsQ0FBYyxDQUFkLENBQUEsQ0FBQTtPQUFuQixDQUF0QixDQUFBO01BRUEsU0FBUyxDQUFDLGFBQUQsRUFBZ0IsU0FBUyxDQUFDLE1BQUQsQ0FBekIsRUFBbUMsTUFBbkMsQ0FBVCxDQUFBO0tBQ0Q7R0FDRjs7RUFFRCxPQUFPLE1BQVAsQ0FBQTtDQUNEOztBQUVELFNBQVMsS0FBVCxDQUFnQixJQUFoQixFQUE4QjtFQUM1QixPQUFPLElBQUksQ0FBQyxJQUFMLEVBQUEsQ0FBWSxLQUFaLENBQWtCLElBQWxCLENBQVAsQ0FBQTtDQUNEOzs7Ozs7Ozs7Ozs7QUNyREQsSUFBQSxRQUFBLEdBQUEsNEJBQUEsQ0FBQSxRQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFlBQUEsR0FBQSwyQkFBQSxDQUFBLFdBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsbUJBQUEsR0FBQSwyQkFBQSxDQUFBLHVCQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7Ozs7Ozs7OztBQUVBLFNBQVMseUJBQVQsQ0FHRyxLQUhILEVBR3dDLFNBSHhDLEVBR3dFO0VBQ3RFLEtBQUEsSUFBQSxFQUFBLEdBQUEsQ0FBQSxFQUFBLEVBQUEsR0FBdUIsU0FBdkIsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQWtDO0lBQUEsSUFBQSxJQUFBLENBQUE7O0lBQUEsSUFBQSxHQUFYLFNBQVcsQ0FBQSxFQUFBLENBQUEsQ0FBQTtJQUFBLElBQXZCLFFBQXVCLEdBQUEsSUFBQSxDQUFBOztJQUNoQyxJQUFJLEtBQUssQ0FBQywyQkFBVixFQUF1QztNQUFFLE1BQUE7S0FBTzs7SUFFaEQsUUFBUSxDQUFDLEtBQUQsQ0FBUixDQUFBO0dBQ0Q7Q0FDRjs7SUFFSztFQU9KLFNBQUEsU0FBQSxDQUFhLE9BQWIsRUFBaUQ7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxTQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxTQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxPQUFBLEVBTHBCLEVBS29CLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxvQkFBQSxFQUo1QixLQUk0QixDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsNkJBQUEsRUFIbkIsS0FHbUIsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLFFBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUMvQyxJQUFBLENBQUssT0FBTCxHQUFlLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxFQUFQLEVBQVcsT0FBTyxJQUFJLEVBQXRCLENBQWYsQ0FBQTtHQUNEOzs7O3lCQUVLLE9BQVk7TUFDaEIsSUFBSSxTQUFKLENBQUE7TUFDQSxJQUFNLE1BQU0sR0FBRyxJQUFBLENBQUssTUFBcEIsQ0FGZ0I7OztNQU1oQixJQUFLLFNBQVMsR0FBRyxJQUFBLENBQUssS0FBTCxDQUFXLEtBQUssQ0FBQyxJQUFqQixDQUFqQixFQUEwQztRQUN4Qyx5QkFBeUIsQ0FBQyxLQUFELEVBQVEsU0FBUixDQUF6QixDQUFBO09BUGM7OztNQVdoQixJQUFJLENBQUMsS0FBSyxDQUFDLGtCQUFQLElBQTZCLE1BQTdCLEtBQXdDLFNBQVMsR0FBRyxNQUFNLENBQUMsS0FBSyxDQUFDLElBQVAsQ0FBMUQsQ0FBSixFQUE4RTtRQUM1RSx5QkFBeUIsQ0FBQyxLQUFELEVBQVEsU0FBUixDQUF6QixDQUFBO09BQ0Q7S0FDRjs7O3VCQUVHLE1BQWMsVUFBaUM7TUFDakQsSUFBTSxTQUFTLEdBQUcsQ0FBQSxDQUFBLEVBQUEsbUJBQUEsQ0FBQSxTQUFBLENBQUEsRUFBVSxJQUFWLEVBQWdCLFFBQWhCLENBQWxCLENBQUE7O01BRUEsS0FBSyxJQUFMLElBQWEsU0FBYixFQUF3QjtRQUN0QixJQUFBLENBQUssS0FBTCxDQUFXLElBQVgsQ0FBQSxHQUFtQixRQUFHLENBQUMsS0FBSixDQUFVLElBQUEsQ0FBSyxLQUFMLENBQVcsSUFBWCxDQUFBLElBQW9CLEVBQTlCLEVBQWtDLFNBQVMsQ0FBQyxJQUFELENBQTNDLENBQW5CLENBQUE7T0FDRDtLQUNGOzs7d0JBRUksTUFBYyxVQUFpQztNQUNsRCxJQUFNLFNBQVMsR0FBRyxDQUFBLENBQUEsRUFBQSxtQkFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFVLElBQVYsRUFBZ0IsUUFBaEIsQ0FBbEIsQ0FBQTs7TUFFQSxLQUFLLElBQUwsSUFBYSxTQUFiLEVBQXdCO1FBQ3RCLElBQU0sU0FBUyxHQUFHLElBQUEsQ0FBSyxLQUFMLENBQVcsSUFBWCxDQUFsQixDQUFBOztRQUVBLElBQUksQ0FBQyxTQUFELElBQWMsQ0FBQyxTQUFTLENBQUMsTUFBN0IsRUFBcUM7VUFBRSxTQUFBO1NBQVU7O1FBRWpELEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBMEIsU0FBUyxDQUFDLElBQUQsQ0FBbkMsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQTJDO1VBQUEsSUFBQSxLQUFBLENBQUE7O1VBQUEsS0FBQSxHQUFqQixTQUFTLENBQUMsSUFBRCxDQUFRLENBQUEsR0FBQSxDQUFBLENBQUE7VUFBQSxJQUFoQyxXQUFnQyxHQUFBLEtBQUEsQ0FBQTs7VUFDekMsSUFBTSxNQUFLLEdBQUcsU0FBUyxDQUFDLE9BQVYsQ0FBa0IsV0FBbEIsQ0FBZCxDQUFBOztVQUVBLElBQUksTUFBSyxLQUFLLENBQUMsQ0FBZixFQUFrQjtZQUNoQixTQUFTLENBQUMsTUFBVixDQUFpQixNQUFqQixFQUF3QixDQUF4QixDQUFBLENBQUE7V0FDRDtTQUNGO09BQ0Y7S0FDRjs7OzRCQUVRLFVBQTJDO01BQ2xELE9BQU8sSUFBUCxDQUFBO0tBQ0Q7Ozs7OztvQkFHWTs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDekVmLDBEQUFBOztBQUNBLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsNEJBQUEsQ0FBQSxPQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7Ozs7Ozs7OztBQUVPLFNBQVMscUJBQVQsQ0FBZ0MsS0FBaEMsRUFBNEMsTUFBNUMsRUFBeUUsT0FBekUsRUFBa0Y7RUFDdkYsSUFBSSxLQUFLLEtBQUssUUFBZCxFQUF3QjtJQUFFLE9BQU8sQ0FBQSxDQUFBLEVBQUEsYUFBQSxDQUFBLFVBQUEsRUFBVyxPQUFYLENBQVAsQ0FBQTtHQUE0Qjs7RUFFdEQsSUFBSSxLQUFLLEtBQUssTUFBZCxFQUFzQjtJQUFFLE9BQU8sTUFBTSxDQUFDLE9BQVAsQ0FBZSxPQUFmLENBQVAsQ0FBQTtHQUFnQzs7RUFFeEQsT0FBTyxDQUFBLENBQUEsRUFBQSxhQUFBLENBQUEsT0FBQSxFQUFRLE9BQVIsRUFBaUIsS0FBakIsQ0FBUCxDQUFBO0NBQ0Q7O0FBRU0sU0FBUyxlQUFULENBQ0wsS0FESyxFQUVMLE1BRkssRUFHTCxPQUhLLEVBSUwsWUFKSyxFQUtMO0VBQ0EsSUFBSSxXQUFnQixHQUFHLEtBQXZCLENBQUE7O0VBQ0EsSUFBSSxPQUFFLENBQUMsTUFBSCxDQUFVLFdBQVYsQ0FBSixFQUE0QjtJQUMxQixXQUFXLEdBQUcscUJBQXFCLENBQUMsV0FBRCxFQUFjLE1BQWQsRUFBc0IsT0FBdEIsQ0FBbkMsQ0FBQTtHQURGLE1BR0ssSUFBSSxPQUFFLENBQUMsSUFBSCxDQUFRLFdBQVIsQ0FBSixFQUEwQjtJQUM3QixXQUFXLEdBQUcsV0FBVyxDQUFBLEtBQVgsQ0FBQSxLQUFBLENBQUEsRUFBQSxrQkFBQSxDQUFlLFlBQWYsQ0FBQSxDQUFkLENBQUE7R0FDRDs7RUFFRCxJQUFJLE9BQUUsQ0FBQyxPQUFILENBQVcsV0FBWCxDQUFKLEVBQTZCO0lBQzNCLFdBQVcsR0FBRyxDQUFBLENBQUEsRUFBQSxhQUFBLENBQUEsY0FBQSxFQUFlLFdBQWYsQ0FBZCxDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxXQUFQLENBQUE7Q0FDRDs7QUFFTSxTQUFTLFFBQVQsQ0FBbUIsSUFBbkIsRUFBeUI7RUFDOUIsT0FBUSxJQUFJLElBQUk7SUFDZCxDQUFDLEVBQUUsR0FBQSxJQUFPLElBQVAsR0FBYyxJQUFJLENBQUMsQ0FBbkIsR0FBdUIsSUFBSSxDQUFDLElBRGpCO0lBRWQsQ0FBQyxFQUFFLEdBQUEsSUFBTyxJQUFQLEdBQWMsSUFBSSxDQUFDLENBQW5CLEdBQXVCLElBQUksQ0FBQyxHQUFBO0dBRmpDLENBQUE7Q0FJRDs7QUFFTSxTQUFTLFVBQVQsQ0FBcUIsSUFBckIsRUFBMkI7RUFDaEMsSUFBSSxJQUFJLElBQUksRUFBRSxNQUFBLElBQVUsSUFBVixJQUFrQixLQUFBLElBQVMsSUFBN0IsQ0FBWixFQUFnRDtJQUM5QyxJQUFJLEdBQUcsQ0FBQSxDQUFBLEVBQUEsWUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLEVBQVAsRUFBVyxJQUFYLENBQVAsQ0FBQTtJQUVBLElBQUksQ0FBQyxJQUFMLEdBQWMsSUFBSSxDQUFDLENBQUwsSUFBVSxDQUF4QixDQUFBO0lBQ0EsSUFBSSxDQUFDLEdBQUwsR0FBYyxJQUFJLENBQUMsQ0FBTCxJQUFVLENBQXhCLENBQUE7SUFDQSxJQUFJLENBQUMsS0FBTCxHQUFjLElBQUksQ0FBQyxLQUFMLElBQWlCLElBQUksQ0FBQyxJQUFMLEdBQVksSUFBSSxDQUFDLEtBQWhELENBQUE7SUFDQSxJQUFJLENBQUMsTUFBTCxHQUFjLElBQUksQ0FBQyxNQUFMLElBQWlCLElBQUksQ0FBQyxHQUFMLEdBQVcsSUFBSSxDQUFDLE1BQS9DLENBQUE7R0FDRDs7RUFFRCxPQUFPLElBQVAsQ0FBQTtDQUNEOztBQUVNLFNBQVMsVUFBVCxDQUFxQixJQUFyQixFQUEyQjtFQUNoQyxJQUFJLElBQUksSUFBSSxFQUFFLEdBQUEsSUFBTyxJQUFQLElBQWUsR0FBQSxJQUFPLElBQXhCLENBQVosRUFBMkM7SUFDekMsSUFBSSxHQUFHLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxFQUFQLEVBQVcsSUFBWCxDQUFQLENBQUE7SUFFQSxJQUFJLENBQUMsQ0FBTCxHQUFjLElBQUksQ0FBQyxJQUFMLElBQWEsQ0FBM0IsQ0FBQTtJQUNBLElBQUksQ0FBQyxDQUFMLEdBQWMsSUFBSSxDQUFDLEdBQUwsSUFBYSxDQUEzQixDQUFBO0lBQ0EsSUFBSSxDQUFDLEtBQUwsR0FBYyxJQUFJLENBQUMsS0FBTCxJQUFnQixJQUFJLENBQUMsS0FBTCxJQUFjLENBQUEsR0FBSyxJQUFJLENBQUMsQ0FBdEQsQ0FBQTtJQUNBLElBQUksQ0FBQyxNQUFMLEdBQWMsSUFBSSxDQUFDLE1BQUwsSUFBZ0IsSUFBSSxDQUFDLE1BQUwsSUFBZSxDQUFBLEdBQUksSUFBSSxDQUFDLENBQXRELENBQUE7R0FDRDs7RUFFRCxPQUFPLElBQVAsQ0FBQTtDQUNEOztBQUVNLFNBQVMsUUFBVCxDQUFtQixLQUFuQixFQUFnRCxJQUFoRCxFQUFxRSxLQUFyRSxFQUE0RjtFQUNqRyxJQUFJLEtBQUssQ0FBQyxJQUFWLEVBQWtCO0lBQUUsSUFBSSxDQUFDLElBQUwsSUFBZSxLQUFLLENBQUMsQ0FBckIsQ0FBQTtHQUF3Qjs7RUFDNUMsSUFBSSxLQUFLLENBQUMsS0FBVixFQUFrQjtJQUFFLElBQUksQ0FBQyxLQUFMLElBQWUsS0FBSyxDQUFDLENBQXJCLENBQUE7R0FBd0I7O0VBQzVDLElBQUksS0FBSyxDQUFDLEdBQVYsRUFBa0I7SUFBRSxJQUFJLENBQUMsR0FBTCxJQUFlLEtBQUssQ0FBQyxDQUFyQixDQUFBO0dBQXdCOztFQUM1QyxJQUFJLEtBQUssQ0FBQyxNQUFWLEVBQWtCO0lBQUUsSUFBSSxDQUFDLE1BQUwsSUFBZSxLQUFLLENBQUMsQ0FBckIsQ0FBQTtHQUF3Qjs7RUFFNUMsSUFBSSxDQUFDLEtBQUwsR0FBYSxJQUFJLENBQUMsS0FBTCxHQUFhLElBQUksQ0FBQyxJQUEvQixDQUFBO0VBQ0EsSUFBSSxDQUFDLE1BQUwsR0FBYyxJQUFJLENBQUMsTUFBTCxHQUFjLElBQUksQ0FBQyxHQUFqQyxDQUFBO0NBQ0Q7Ozs7Ozs7Ozs7QUMxRUQsa0RBQUE7O0FBRWUsU0FBQSxhQUFBLENBQ2IsTUFEYSxFQUViLE9BRmEsRUFHYixVQUhhLEVBSWI7RUFDQSxJQUFNLGFBQWEsR0FBSSxNQUFNLENBQUMsT0FBUixDQUF3QixVQUF4QixDQUF0QixDQUFBO0VBQ0EsSUFBTSxZQUFZLEdBQUcsYUFBYSxJQUFJLGFBQWEsQ0FBQyxNQUFwRCxDQUFBO0VBQ0EsSUFBTSxNQUFNLEdBQUcsWUFBWSxJQUFJLE1BQU0sQ0FBQyxPQUFQLENBQWUsTUFBOUMsQ0FBQTtFQUVBLElBQU0sVUFBVSxHQUFHLENBQUEsQ0FBQSxFQUFBLFNBQUEsQ0FBQSxlQUFBLEVBQWdCLE1BQWhCLEVBQXdCLE1BQXhCLEVBQWdDLE9BQWhDLEVBQXlDLENBQUMsTUFBTSxJQUFJLE9BQVgsQ0FBekMsQ0FBbkIsQ0FBQTtFQUVBLE9BQU8sQ0FBQSxDQUFBLEVBQUEsU0FBQSxDQUFBLFFBQUEsRUFBUyxVQUFULENBQUEsSUFBd0I7SUFBRSxDQUFDLEVBQUUsQ0FBTDtJQUFRLENBQUMsRUFBRSxDQUFBO0dBQTFDLENBQUE7Q0FDRDs7Ozs7Ozs7O0FDZEQsSUFBSSxRQUFRLEdBQUcsQ0FBZixDQUFBOztBQUNBLElBQUksUUFBSixDQUFBOztBQUNBLElBQUksT0FBSixDQUFBOztBQUVBLFNBQVMsU0FBVCxDQUFlLE1BQWYsRUFBdUI7RUFDckIsUUFBTyxHQUFHLE1BQU0sQ0FBQyxxQkFBakIsQ0FBQTtFQUNBLE9BQU0sR0FBRyxNQUFNLENBQUMsb0JBQWhCLENBQUE7O0VBRUEsSUFBSSxDQUFDLFFBQUwsRUFBYztJQUNaLElBQU0sT0FBTyxHQUFHLENBQUMsSUFBRCxFQUFPLEtBQVAsRUFBYyxRQUFkLEVBQXdCLEdBQXhCLENBQWhCLENBQUE7O0lBRUEsS0FBQSxJQUFBLEVBQUEsR0FBQSxDQUFBLEVBQUEsRUFBQSxHQUFxQixPQUFyQixDQUFBLE1BQUEsRUFBQSxFQUFBLEVBQUEsRUFBOEI7TUFBekIsSUFBTSxNQUFNLEdBQUksT0FBSixDQUFBLEVBQUEsQ0FBWixDQUFBO01BQ0gsUUFBTyxHQUFHLE1BQU0sQ0FBQSxFQUFBLENBQUEsTUFBQSxDQUFJLE1BQUosRUFBQSx1QkFBQSxDQUFBLENBQWhCLENBQUE7TUFDQSxPQUFNLEdBQUcsTUFBTSxDQUFBLEVBQUEsQ0FBQSxNQUFBLENBQUksTUFBSixFQUFBLHNCQUFBLENBQUEsQ0FBTixJQUEyQyxNQUFNLENBQUEsRUFBQSxDQUFBLE1BQUEsQ0FBSSxNQUFKLEVBQUEsNkJBQUEsQ0FBQSxDQUExRCxDQUFBO0tBQ0Q7R0FDRjs7RUFFRCxJQUFJLENBQUMsUUFBTCxFQUFjO0lBQ1osUUFBTyxHQUFHLFNBQUEsT0FBQSxDQUFBLFFBQVEsRUFBSTtNQUNwQixJQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsR0FBTCxFQUFqQixDQUFBO01BQ0EsSUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLEdBQUwsQ0FBUyxDQUFULEVBQVksRUFBQSxJQUFNLFFBQVEsR0FBRyxRQUFqQixDQUFaLENBQW5CLENBRm9COztNQUlwQixJQUFNLEtBQUssR0FBRyxVQUFVLENBQUMsWUFBTTtRQUFFLFFBQVEsQ0FBQyxRQUFRLEdBQUcsVUFBWixDQUFSLENBQUE7T0FBVCxFQUN0QixVQURzQixDQUF4QixDQUFBO01BR0EsUUFBUSxHQUFHLFFBQVEsR0FBRyxVQUF0QixDQUFBO01BQ0EsT0FBTyxLQUFQLENBQUE7S0FSRixDQUFBOztJQVdBLE9BQU0sR0FBRyxTQUFBLE1BQUEsQ0FBQSxLQUFLLEVBQUE7TUFBQSxPQUFJLFlBQVksQ0FBQyxLQUFELENBQWhCLENBQUE7S0FBZCxDQUFBO0dBQ0Q7Q0FDRjs7b0JBRWM7RUFDYixPQUFPLEVBQUUsU0FBQSxPQUFBLENBQUEsUUFBUSxFQUFBO0lBQUEsT0FBSSxRQUFPLENBQUMsUUFBRCxDQUFYLENBQUE7R0FESjtFQUViLE1BQU0sRUFBRSxTQUFBLE1BQUEsQ0FBQSxLQUFLLEVBQUE7SUFBQSxPQUFJLE9BQU0sQ0FBQyxLQUFELENBQVYsQ0FBQTtHQUZBO0VBR2IsSUFBSSxFQUFKLFNBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNwQ0YsSUFBQSxRQUFBLEdBQUEsNEJBQUEsQ0FBQSxRQUFBLENBQUEsQ0FBQTs7OztBQUNBLElBQUEsR0FBQSxHQUFBLDRCQUFBLENBQUEsYUFBQSxDQUFBLENBQUE7Ozs7QUFDQSxJQUFBLE9BQUEsR0FBQSw0QkFBQSxDQUFBLE9BQUEsQ0FBQSxDQUFBOzs7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsNEJBQUEsQ0FBQSxpQkFBQSxDQUFBLENBQUE7Ozs7QUFDQSxJQUFBLElBQUEsR0FBQSw0QkFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFBOzs7O0FBQ0EsSUFBQSxZQUFBLEdBQUEsMkJBQUEsQ0FBQSxXQUFBLENBQUEsQ0FBQTs7QUF3QkEsSUFBQSxhQUFBLEdBQUEsMkJBQUEsQ0FBQSxZQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLE1BQUEsR0FBQSwyQkFBQSxDQUFBLFVBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsT0FBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxZQUFBLEdBQUEsMkJBQUEsQ0FBQSxXQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFlBQUEsR0FBQSwyQkFBQSxDQUFBLGdCQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFdBQUEsR0FBQSwyQkFBQSxDQUFBLFVBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsd0JBQUEsR0FBQSwyQkFBQSxDQUFBLHVCQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLElBQUEsR0FBQSwyQkFBQSxDQUFBLFFBQUEsQ0FBQSxDQUFBOzs7Ozs7OztBQTdCTyxTQUFTLFFBQVQsQ0FBK0IsTUFBL0IsRUFBZ0UsT0FBaEUsRUFBaUY7RUFDdEYsSUFBSSxNQUFNLEdBQUcsS0FBYixDQURzRjs7RUFJdEYsT0FBTyxZQUFtQjtJQUN4QixJQUFJLENBQUMsTUFBTCxFQUFhO01BQ1YsWUFBQSxDQUFBLFNBQUEsQ0FBRCxDQUFhLE1BQWIsQ0FBb0IsT0FBcEIsQ0FBNEIsSUFBNUIsQ0FBaUMsT0FBakMsQ0FBQSxDQUFBOztNQUNBLE1BQU0sR0FBRyxJQUFULENBQUE7S0FDRDs7SUFFRCxPQUFPLE1BQU0sQ0FBQyxLQUFQLENBQWEsSUFBYixFQUFtQixTQUFuQixDQUFQLENBQUE7R0FORixDQUFBO0NBUUQ7O0FBRU0sU0FBUyxVQUFULENBQXFCLElBQXJCLEVBQWlELEdBQWpELEVBQTRFO0VBQ2pGLElBQUksQ0FBQyxJQUFMLEdBQWEsR0FBRyxDQUFDLElBQWpCLENBQUE7RUFDQSxJQUFJLENBQUMsSUFBTCxHQUFhLEdBQUcsQ0FBQyxJQUFqQixDQUFBO0VBQ0EsSUFBSSxDQUFDLEtBQUwsR0FBYSxHQUFHLENBQUMsS0FBakIsQ0FBQTtFQUVBLE9BQU8sSUFBUCxDQUFBO0NBQ0Q7Ozs7Ozs7Ozs7OztBQ09NLElBQU0sUUFBa0IsR0FBRztFQUNoQyxJQUFJLEVBQUU7SUFDSixjQUFjLEVBQUUsTUFEWjtJQUVKLFdBQVcsRUFBRSxNQUFBO0dBSGlCO0VBTWhDLFNBQVMsRUFBRTtJQUNULE9BQU8sRUFBRSxLQURBO0lBRVQsTUFBTSxFQUFFO01BQUUsQ0FBQyxFQUFFLENBQUw7TUFBUSxDQUFDLEVBQUUsQ0FBQTtLQUFYO0dBUnNCO0VBV2hDLE9BQU8sRUFBRSxFQUFBO0NBWEosQ0FBQTs7b0JBY1E7Ozs7Ozs7Ozs7Ozs7QUNoRGYsSUFBQSxRQUFBLEdBQUEsNEJBQUEsQ0FBQSxRQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLGFBQUEsR0FBQSw0QkFBQSxDQUFBLGFBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsNEJBQUEsQ0FBQSxPQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7Ozs7Ozs7OztJQWtCcUI7O0VBUW5CLFNBQUEsZUFBQSxDQUF1QixLQUF2QixFQUE4QztJQUFBLElBQUEsS0FBQSxHQUFBLElBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxlQUFBLENBQUEsQ0FBQTs7SUFBQSxJQUFBLENBQXZCLEtBQXVCLEdBQXZCLEtBQXVCLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsTUFBQSxFQU5kLEVBTWMsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLGFBQUEsRUFGMUMsRUFFMEMsQ0FBQSxDQUFBOztJQUM1QyxLQUFLLENBQUMsWUFBTixDQUFtQjtNQUNqQixvQkFBQSxFQUFzQixTQUFBLGlCQUFBLENBQUEsSUFBQSxFQUFzQjtRQUFBLElBQW5CLFlBQW1CLEdBQUEsSUFBQSxDQUFuQixZQUFtQixDQUFBO1FBQUEsSUFDbEMsTUFEa0MsR0FDSixZQURJLENBQ2xDLE1BRGtDO1lBQ2hCLE9BRGdCLEdBQ0osWUFESSxDQUMxQixRQUQwQixDQUFBO1FBRTFDLElBQU0sY0FBdUMsR0FBRyxPQUFFLENBQUMsTUFBSCxDQUFVLE1BQVYsQ0FBQSxHQUM1QyxLQUFJLENBQUMsV0FBTCxDQUFpQixNQUFqQixDQUQ0QyxHQUUzQyxNQUFELENBQWdCLEtBQUksQ0FBQyxLQUFMLENBQVcsRUFBM0IsQ0FGSixDQUFBO1FBSUEsSUFBTSxXQUFXLEdBQUcsY0FBYyxDQUFDLFNBQWYsQ0FBeUIsVUFBQSxDQUFDLEVBQUE7VUFBQSxPQUFJLENBQUMsQ0FBQyxPQUFGLEtBQWMsT0FBbEIsQ0FBQTtTQUExQixDQUFwQixDQUFBOztRQUNBLElBQUksY0FBYyxDQUFDLFdBQUQsQ0FBbEIsRUFBaUM7O1VBRS9CLGNBQWMsQ0FBQyxXQUFELENBQWQsQ0FBNEIsT0FBNUIsR0FBc0MsSUFBdEMsQ0FBQTtVQUNBLGNBQWMsQ0FBQyxXQUFELENBQWQsQ0FBNEIsWUFBNUIsR0FBMkMsSUFBM0MsQ0FBQTtTQUNEOztRQUNELGNBQWMsQ0FBQyxNQUFmLENBQXNCLFdBQXRCLEVBQW1DLENBQW5DLENBQUEsQ0FBQTtPQUNEO0tBZEgsQ0FBQSxDQUFBO0dBZ0JEOzs7O3lCQUVJLFFBQXlCLFNBQXNDO01BQ2xFLE9BQU8sR0FBRyxDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sT0FBTyxJQUFJLEVBQWxCLEVBQXNCO1FBQzlCLE9BQU8sRUFBRSxJQUFBLENBQUssS0FBTCxDQUFXLE9BQUE7T0FEWixDQUFWLENBQUE7TUFHQSxJQUFNLFlBQVksR0FBRyxJQUFJLElBQUEsQ0FBSyxLQUFMLENBQVcsWUFBZixDQUE0QixNQUE1QixFQUFvQyxPQUFwQyxFQUE2QyxJQUFBLENBQUssS0FBTCxDQUFXLFFBQXhELENBQXJCLENBQUE7TUFDQSxJQUFNLFdBQVcsR0FBRztRQUFFLE9BQU8sRUFBRSxZQUFZLENBQUMsUUFBeEI7UUFBa0MsWUFBWSxFQUFaLFlBQUE7T0FBdEQsQ0FBQTtNQUVBLElBQUEsQ0FBSyxLQUFMLENBQVcsV0FBWCxDQUF1QixZQUFZLENBQUMsSUFBcEMsQ0FBQSxDQUFBO01BQ0EsSUFBQSxDQUFLLElBQUwsQ0FBVSxJQUFWLENBQWUsWUFBZixDQUFBLENBQUE7O01BRUEsSUFBSSxPQUFFLENBQUMsTUFBSCxDQUFVLE1BQVYsQ0FBSixFQUF1QjtRQUNyQixJQUFJLENBQUMsSUFBQSxDQUFLLFdBQUwsQ0FBaUIsTUFBakIsQ0FBTCxFQUErQjtVQUFFLElBQUEsQ0FBSyxXQUFMLENBQWlCLE1BQWpCLENBQUEsR0FBMkIsRUFBM0IsQ0FBQTtTQUErQjs7UUFDaEUsSUFBQSxDQUFLLFdBQUwsQ0FBaUIsTUFBakIsQ0FBQSxDQUF5QixJQUF6QixDQUE4QixXQUE5QixDQUFBLENBQUE7T0FGRixNQUdPO1FBQ0wsSUFBSSxDQUFHLFlBQVksQ0FBQyxNQUFkLENBQTZCLElBQUEsQ0FBSyxLQUFMLENBQVcsRUFBeEMsQ0FBTixFQUFvRDtVQUNsRCxNQUFNLENBQUMsY0FBUCxDQUFzQixNQUF0QixFQUE4QixJQUFBLENBQUssS0FBTCxDQUFXLEVBQXpDLEVBQTZDO1lBQzNDLEtBQUssRUFBRSxFQURvQztZQUUzQyxZQUFZLEVBQUUsSUFBQTtXQUZoQixDQUFBLENBQUE7U0FJRDs7UUFFQSxNQUFELENBQWdCLElBQUEsQ0FBSyxLQUFMLENBQVcsRUFBM0IsQ0FBQSxDQUErQixJQUEvQixDQUFvQyxXQUFwQyxDQUFBLENBQUE7T0FDRDs7TUFFRCxJQUFBLENBQUssS0FBTCxDQUFXLElBQVgsQ0FBZ0Isa0JBQWhCLEVBQW9DO1FBQ2xDLE1BQU0sRUFBTixNQURrQztRQUVsQyxPQUFPLEVBQVAsT0FGa0M7UUFHbEMsWUFBWSxFQUFaLFlBSGtDO1FBSWxDLEdBQUcsRUFBRSxJQUFBLENBQUssS0FBTCxDQUFXLElBQUE7T0FKbEIsQ0FBQSxDQUFBO01BT0EsT0FBTyxZQUFQLENBQUE7S0FDRDs7O3dCQUVJLFFBQXlCLFNBQTRCO01BQ3hELElBQU0sT0FBTyxHQUFJLE9BQU8sSUFBSSxPQUFPLENBQUMsT0FBcEIsSUFBZ0MsSUFBQSxDQUFLLEtBQUwsQ0FBVyxRQUEzRCxDQUFBO01BQ0EsSUFBTSxVQUFVLEdBQUcsT0FBRSxDQUFDLE1BQUgsQ0FBVSxNQUFWLENBQW5CLENBQUE7TUFDQSxJQUFNLGNBQXVDLEdBQUcsVUFBVSxHQUN0RCxJQUFBLENBQUssV0FBTCxDQUFpQixNQUFqQixDQURzRCxHQUVyRCxNQUFELENBQWdCLElBQUEsQ0FBSyxLQUFMLENBQVcsRUFBM0IsQ0FGSixDQUFBOztNQUlBLElBQUksQ0FBQyxjQUFMLEVBQXFCO1FBQUUsT0FBTyxJQUFQLENBQUE7T0FBYTs7TUFFcEMsSUFBTSxLQUFLLEdBQUcsUUFBRyxDQUFDLElBQUosQ0FDWixjQURZLEVBRVosVUFBQSxDQUFDLEVBQUE7UUFBQSxPQUFJLENBQUMsQ0FBQyxPQUFGLEtBQWMsT0FBZCxLQUNGLFVBQVUsSUFBSSxDQUFDLENBQUMsWUFBRixDQUFlLFNBQWYsQ0FBeUIsTUFBekIsQ0FEWixDQUFKLENBQUE7T0FGVyxDQUFkLENBQUE7TUFLQSxPQUFPLEtBQUssSUFBSSxLQUFLLENBQUMsWUFBdEIsQ0FBQTtLQUNEOzs7aUNBRWdCLE1BQVksVUFBZ0U7TUFDM0YsS0FBQSxJQUFBLEVBQUEsR0FBQSxDQUFBLEVBQUEsRUFBQSxHQUEyQixJQUFBLENBQUssSUFBaEMsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQXNDO1FBQUEsSUFBQSxLQUFBLENBQUE7O1FBQUEsS0FBQSxHQUFYLElBQUEsQ0FBSyxJQUFNLENBQUEsRUFBQSxDQUFBLENBQUE7UUFBQSxJQUEzQixhQUEyQixHQUFBLEtBQUEsQ0FBQTtRQUNwQyxJQUFJLEdBQUcsR0FBQSxLQUFBLENBQVAsQ0FBQTs7UUFFQSxJQUFJLENBQUMsT0FBRSxDQUFDLE1BQUgsQ0FBVSxhQUFZLENBQUMsTUFBdkIsQ0FBQTtVQUVBLE9BQUUsQ0FBQyxPQUFILENBQVcsSUFBWCxDQUFBLElBQW9CLGFBQVEsQ0FBQyxlQUFULENBQXlCLElBQXpCLEVBQStCLGFBQVksQ0FBQyxNQUE1QyxDQUZwQjtRQUlELElBQUksS0FBSyxhQUFZLENBQUMsTUFKdEI7UUFNRCxhQUFZLENBQUMsU0FBYixDQUF1QixJQUF2QixDQU5ILEVBTWtDO1VBQ2hDLEdBQUcsR0FBRyxRQUFRLENBQUMsYUFBRCxDQUFkLENBQUE7U0FDRDs7UUFFRCxJQUFJLEdBQUcsS0FBSyxTQUFaLEVBQXVCO1VBQ3JCLE9BQU8sR0FBUCxDQUFBO1NBQ0Q7T0FDRjtLQUNGOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7SUNySFU7Ozt3QkFVc0M7TUFDL0MsT0FBTyxJQUFBLENBQUssWUFBTCxDQUFrQixNQUF6QixDQUFBO0tBQ0Q7OztFQUVELFNBQUEsU0FBQSxDQUFhLFdBQWIsRUFBZ0Q7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxTQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxNQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxRQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxlQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxjQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxjQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxXQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSw2QkFBQSxFQVBsQixLQU9rQixDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsb0JBQUEsRUFOM0IsS0FNMkIsQ0FBQSxDQUFBOztJQUM5QyxJQUFBLENBQUssWUFBTCxHQUFvQixXQUFwQixDQUFBO0dBQ0Q7Ozs7cUNBRWlCLEVBQUU7Ozs7Ozs7c0NBS0Q7TUFDakIsSUFBQSxDQUFLLGtCQUFMLEdBQTBCLElBQTFCLENBQUE7S0FDRDs7Ozs7OzsrQ0FLMkI7TUFDMUIsSUFBQSxDQUFLLDJCQUFMLEdBQW1DLElBQUEsQ0FBSyxrQkFBTCxHQUEwQixJQUE3RCxDQUFBO0tBQ0Q7Ozs7Ozs7b0JBR1k7Ozs7Ozs7Ozs7O0FDbkNmLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxpQkFBQSxHQUFBLDJCQUFBLENBQUEsZ0JBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsV0FBQSxHQUFBLDJCQUFBLENBQUEsVUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxXQUFBLEdBQUEsMkJBQUEsQ0FBQSxjQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLGVBQUEsR0FBQSwyQkFBQSxDQUFBLG1CQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0lBV2E7Ozs7Ozs7RUFzQ1gsU0FBQSxhQUFBLENBQ0UsV0FERixFQUVFLEtBRkYsRUFHRSxVQUhGLEVBSUUsS0FKRixFQUtFLE9BTEYsRUFNRSxNQU5GLEVBT0UsSUFQRixFQVFFO0lBQUEsSUFBQSxLQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsYUFBQSxDQUFBLENBQUE7O0lBQ0EsS0FBQSxHQUFBLDBCQUFBLENBQUEsSUFBQSxFQUFBLGVBQUEsQ0FBQSxhQUFBLENBQUEsQ0FBQSxJQUFBLENBQUEsSUFBQSxFQUFNLFdBQU4sQ0FBQSxDQUFBLENBQUE7O0lBREEsb0JBQUEsQ0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLFFBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxlQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLHNCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsZUFBQSxFQXhDb0IsSUF3Q3BCLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLHNCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsU0FBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLFNBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxRQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLHNCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsU0FBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLFNBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxVQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLHNCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsUUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLFNBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxNQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLHNCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsUUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLE9BQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxNQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLHNCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsSUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLElBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxJQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLHNCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsSUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLFVBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxVQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLHNCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsVUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLFVBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxPQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLHNCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsT0FBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLFdBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxXQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLHNCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsV0FBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLE1BQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsc0JBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxRQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFHQSxPQUFPLEdBQUcsT0FBTyxJQUFJLFdBQVcsQ0FBQyxPQUFqQyxDQUFBO0lBRUEsSUFBTSxNQUFNLEdBQVEsV0FBVyxDQUFDLFlBQWhDLENBQUE7SUFDQSxJQUFNLFdBQVcsR0FBRyxDQUFHLE1BQU0sSUFBSSxNQUFNLENBQUMsT0FBbEIsSUFBOEIsZUFBQSxDQUFBLFNBQUEsQ0FBaEMsRUFBa0QsV0FBdEUsQ0FBQTtJQUNBLElBQU0sTUFBTSxHQUFRLENBQUEsQ0FBQSxFQUFBLGlCQUFBLENBQUEsU0FBQSxDQUFBLEVBQVksTUFBWixFQUFvQixPQUFwQixFQUE2QixVQUE3QixDQUFwQixDQUFBO0lBQ0EsSUFBTSxRQUFRLEdBQU0sS0FBSyxLQUFLLE9BQTlCLENBQUE7SUFDQSxJQUFNLE1BQU0sR0FBUSxLQUFLLEtBQUssS0FBOUIsQ0FBQTtJQUNBLElBQU0sU0FBUyxHQUFLLFFBQVEsR0FBQSxzQkFBQSxDQUFBLEtBQUEsQ0FBQSxHQUFVLFdBQVcsQ0FBQyxTQUFsRCxDQUFBO0lBQ0EsSUFBTSxNQUFNLEdBQVEsUUFBUSxHQUN4QixXQUFXLENBQUMsTUFBWixDQUFtQixLQURLLEdBRXhCLE1BQU0sR0FDSjtNQUFFLElBQUksRUFBRSxTQUFTLENBQUMsSUFBbEI7TUFBd0IsTUFBTSxFQUFFLFNBQVMsQ0FBQyxNQUExQztNQUFrRCxTQUFTLEVBQUUsV0FBVyxDQUFDLE1BQVosQ0FBbUIsR0FBbkIsQ0FBdUIsU0FBQTtLQURoRixHQUVKLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEdBSnpCLENBQUE7SUFNQSxLQUFBLENBQUssSUFBTCxHQUFpQixDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sRUFBUCxFQUFXLE1BQU0sQ0FBQyxJQUFsQixDQUFqQixDQUFBO0lBQ0EsS0FBQSxDQUFLLE1BQUwsR0FBaUIsQ0FBQSxDQUFBLEVBQUEsWUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLEVBQVAsRUFBVyxNQUFNLENBQUMsTUFBbEIsQ0FBakIsQ0FBQTtJQUNBLEtBQUEsQ0FBSyxJQUFMLEdBQWlCLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxFQUFQLEVBQVcsV0FBVyxDQUFDLElBQXZCLENBQWpCLENBQUE7SUFDQSxLQUFBLENBQUssU0FBTCxHQUFpQixNQUFNLENBQUMsU0FBeEIsQ0FBQTs7SUFFQSxJQUFJLENBQUMsTUFBTCxFQUFhO01BQ1gsS0FBQSxDQUFLLElBQUwsQ0FBVSxDQUFWLElBQWUsTUFBTSxDQUFDLENBQXRCLENBQUE7TUFDQSxLQUFBLENBQUssSUFBTCxDQUFVLENBQVYsSUFBZSxNQUFNLENBQUMsQ0FBdEIsQ0FBQTtNQUVBLEtBQUEsQ0FBSyxNQUFMLENBQVksQ0FBWixJQUFpQixNQUFNLENBQUMsQ0FBeEIsQ0FBQTtNQUNBLEtBQUEsQ0FBSyxNQUFMLENBQVksQ0FBWixJQUFpQixNQUFNLENBQUMsQ0FBeEIsQ0FBQTtLQUNEOztJQUVELEtBQUEsQ0FBSyxPQUFMLEdBQXFCLEtBQUssQ0FBQyxPQUEzQixDQUFBO0lBQ0EsS0FBQSxDQUFLLE1BQUwsR0FBcUIsS0FBSyxDQUFDLE1BQTNCLENBQUE7SUFDQSxLQUFBLENBQUssUUFBTCxHQUFxQixLQUFLLENBQUMsUUFBM0IsQ0FBQTtJQUNBLEtBQUEsQ0FBSyxPQUFMLEdBQXFCLEtBQUssQ0FBQyxPQUEzQixDQUFBO0lBQ0EsS0FBQSxDQUFLLE1BQUwsR0FBc0IsS0FBRCxDQUFzQixNQUEzQyxDQUFBO0lBQ0EsS0FBQSxDQUFLLE9BQUwsR0FBc0IsS0FBRCxDQUFzQixPQUEzQyxDQUFBO0lBQ0EsS0FBQSxDQUFLLE1BQUwsR0FBcUIsT0FBckIsQ0FBQTtJQUNBLEtBQUEsQ0FBSyxhQUFMLEdBQXFCLE9BQXJCLENBQUE7SUFDQSxLQUFBLENBQUssTUFBTCxHQUFxQixNQUFyQixDQUFBO0lBQ0EsS0FBQSxDQUFLLElBQUwsR0FBcUIsSUFBSSxJQUFLLFVBQVUsSUFBSSxLQUFLLElBQUksRUFBYixDQUF4QyxDQUFBO0lBQ0EsS0FBQSxDQUFLLFlBQUwsR0FBcUIsTUFBckIsQ0FBQTtJQUVBLEtBQUEsQ0FBSyxFQUFMLEdBQVUsUUFBUSxHQUNkLFdBQVcsQ0FBQyxRQUFaLENBQXFCLFdBQVcsQ0FBQyxRQUFaLENBQXFCLE1BQXJCLEdBQThCLENBQW5ELENBQUEsQ0FBc0QsUUFEeEMsR0FFZCxTQUFTLENBQUMsRUFGZCxDQUFBO0lBSUEsS0FBQSxDQUFLLEVBQUwsR0FBZ0IsV0FBVyxDQUFDLE1BQVosQ0FBbUIsS0FBbkIsQ0FBeUIsSUFBekIsQ0FBOEIsQ0FBOUIsR0FBa0MsTUFBTSxDQUFDLENBQXpELENBQUE7SUFDQSxLQUFBLENBQUssRUFBTCxHQUFnQixXQUFXLENBQUMsTUFBWixDQUFtQixLQUFuQixDQUF5QixJQUF6QixDQUE4QixDQUE5QixHQUFrQyxNQUFNLENBQUMsQ0FBekQsQ0FBQTtJQUNBLEtBQUEsQ0FBSyxRQUFMLEdBQWdCLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEtBQW5CLENBQXlCLE1BQXpCLENBQWdDLENBQWhDLEdBQW9DLE1BQU0sQ0FBQyxDQUEzRCxDQUFBO0lBQ0EsS0FBQSxDQUFLLFFBQUwsR0FBZ0IsV0FBVyxDQUFDLE1BQVosQ0FBbUIsS0FBbkIsQ0FBeUIsTUFBekIsQ0FBZ0MsQ0FBaEMsR0FBb0MsTUFBTSxDQUFDLENBQTNELENBQUE7O0lBRUEsSUFBSSxRQUFRLElBQUksTUFBaEIsRUFBd0I7TUFDdEIsS0FBQSxDQUFLLEtBQUwsR0FBYTtRQUFFLENBQUMsRUFBRSxDQUFMO1FBQVEsQ0FBQyxFQUFFLENBQUE7T0FBeEIsQ0FBQTtLQURGLE1BR0s7TUFDSCxLQUFBLENBQUssS0FBTCxHQUFhO1FBQ1gsQ0FBQyxFQUFFLEtBQUEsQ0FBSyxXQUFMLENBQUEsQ0FBa0IsQ0FBbEIsR0FBc0IsU0FBUyxDQUFDLFdBQUQsQ0FBVCxDQUF1QixDQURyQztRQUVYLENBQUMsRUFBRSxLQUFBLENBQUssV0FBTCxDQUFBLENBQWtCLENBQWxCLEdBQXNCLFNBQVMsQ0FBQyxXQUFELENBQVQsQ0FBdUIsQ0FBQTtPQUZsRCxDQUFBO0tBSUQ7O0lBRUQsS0FBQSxDQUFLLEVBQUwsR0FBaUIsV0FBVyxDQUFDLE1BQVosQ0FBbUIsS0FBbkIsQ0FBeUIsU0FBMUMsQ0FBQTtJQUNBLEtBQUEsQ0FBSyxRQUFMLEdBQWlCLEtBQUEsQ0FBSyxTQUFMLEdBQWlCLEtBQUEsQ0FBSyxFQUF2QyxDQTlEQTs7SUFpRUEsS0FBQSxDQUFLLFFBQUwsR0FBZ0IsQ0FBQSxDQUFBLEVBQUEsWUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLEVBQVAsRUFBVyxXQUFXLENBQUMsTUFBWixDQUFtQixRQUFuQixDQUE0QixXQUE1QixDQUFYLENBQWhCLENBQUE7SUFDQSxLQUFBLENBQUssS0FBTCxHQUFhLENBQUEsQ0FBQSxFQUFBLFdBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTSxLQUFBLENBQUssUUFBTCxDQUFjLENBQXBCLEVBQXVCLEtBQUEsQ0FBSyxRQUFMLENBQWMsQ0FBckMsQ0FBYixDQUFBO0lBRUEsS0FBQSxDQUFLLEtBQUwsR0FBYyxNQUFNLElBQUksS0FBSyxLQUFLLGNBQXJCLEdBQXVDLEtBQUEsQ0FBSyxRQUFMLEVBQXZDLEdBQXlELElBQXRFLENBQUE7SUFwRUEsT0FBQSxLQUFBLENBQUE7R0FxRUQ7Ozs7K0JBc0JXO01BQ1YsSUFBTSxXQUFXLEdBQUcsSUFBQSxDQUFLLFlBQXpCLENBQUE7O01BRUEsSUFBSSxXQUFXLENBQUMsU0FBWixDQUFzQixLQUF0QixHQUE4QixHQUE5QixJQUNBLElBQUEsQ0FBSyxTQUFMLEdBQWlCLFdBQVcsQ0FBQyxTQUFaLENBQXNCLFNBQXZDLEdBQW1ELEdBRHZELEVBQzREO1FBQzFELE9BQU8sSUFBUCxDQUFBO09BQ0Q7O01BRUQsSUFBSSxLQUFLLEdBQUcsR0FBQSxHQUFNLElBQUksQ0FBQyxLQUFMLENBQVcsV0FBVyxDQUFDLFNBQVosQ0FBc0IsU0FBakMsRUFBNEMsV0FBVyxDQUFDLFNBQVosQ0FBc0IsU0FBbEUsQ0FBTixHQUFxRixJQUFJLENBQUMsRUFBdEcsQ0FBQTtNQUNBLElBQU0sT0FBTyxHQUFHLElBQWhCLENBQUE7O01BRUEsSUFBSSxLQUFLLEdBQUcsQ0FBWixFQUFlO1FBQ2IsS0FBSyxJQUFJLEdBQVQsQ0FBQTtPQUNEOztNQUVELElBQU0sSUFBSSxHQUFHLEdBQUEsR0FBTSxPQUFOLElBQWlCLEtBQWpCLElBQTBCLEtBQUssR0FBRyxHQUFBLEdBQU0sT0FBckQsQ0FBQTtNQUNBLElBQU0sRUFBRSxHQUFLLEdBQUEsR0FBTSxPQUFOLElBQWlCLEtBQWpCLElBQTBCLEtBQUssR0FBRyxHQUFBLEdBQU0sT0FBckQsQ0FBQTtNQUVBLElBQU0sS0FBSyxHQUFHLENBQUMsSUFBRCxLQUFVLEdBQUEsR0FBTSxPQUFOLElBQWlCLEtBQWpCLElBQTBCLEtBQUssR0FBSSxFQUFBLEdBQUssT0FBbEQsQ0FBZCxDQUFBO01BQ0EsSUFBTSxJQUFJLEdBQUksQ0FBQyxFQUFELElBQVcsRUFBQSxHQUFLLE9BQUwsSUFBZ0IsS0FBM0IsSUFBb0MsS0FBSyxHQUFHLEdBQUEsR0FBTSxPQUFoRSxDQUFBO01BRUEsT0FBTztRQUNMLEVBQUUsRUFBRixFQURLO1FBRUwsSUFBSSxFQUFKLElBRks7UUFHTCxJQUFJLEVBQUosSUFISztRQUlMLEtBQUssRUFBTCxLQUpLO1FBS0wsS0FBSyxFQUFMLEtBTEs7UUFNTCxLQUFLLEVBQUUsV0FBVyxDQUFDLFNBQVosQ0FBc0IsS0FOeEI7UUFPTCxRQUFRLEVBQUU7VUFDUixDQUFDLEVBQUUsV0FBVyxDQUFDLFNBQVosQ0FBc0IsU0FEakI7VUFFUixDQUFDLEVBQUUsV0FBVyxDQUFDLFNBQVosQ0FBc0IsU0FBQTtTQUZqQjtPQVBaLENBQUE7S0FZRDs7O3FDQUVpQixFQUFFOzs7Ozs7OytDQUtRO01BQzFCLElBQUEsQ0FBSywyQkFBTCxHQUFtQyxJQUFBLENBQUssa0JBQUwsR0FBMEIsSUFBN0QsQ0FBQTtLQUNEOzs7Ozs7O3NDQUtrQjtNQUNqQixJQUFBLENBQUssa0JBQUwsR0FBMEIsSUFBMUIsQ0FBQTtLQUNEOzs7d0JBckVZO01BQUUsT0FBTyxJQUFBLENBQUssSUFBTCxDQUFVLENBQWpCLENBQUE7O3NCQUNKLE9BQU87TUFBRSxJQUFBLENBQUssSUFBTCxDQUFVLENBQVYsR0FBYyxLQUFkLENBQUE7S0FBcUI7Ozt3QkFDNUI7TUFBRSxPQUFPLElBQUEsQ0FBSyxJQUFMLENBQVUsQ0FBakIsQ0FBQTs7c0JBQ0osT0FBTztNQUFFLElBQUEsQ0FBSyxJQUFMLENBQVUsQ0FBVixHQUFjLEtBQWQsQ0FBQTtLQUFxQjs7O3dCQUUxQjtNQUFFLE9BQU8sSUFBQSxDQUFLLE1BQUwsQ0FBWSxDQUFuQixDQUFBOztzQkFDSixPQUFPO01BQUUsSUFBQSxDQUFLLE1BQUwsQ0FBWSxDQUFaLEdBQWdCLEtBQWhCLENBQUE7S0FBdUI7Ozt3QkFDOUI7TUFBRSxPQUFPLElBQUEsQ0FBSyxNQUFMLENBQVksQ0FBbkIsQ0FBQTs7c0JBQ0osT0FBTztNQUFFLElBQUEsQ0FBSyxNQUFMLENBQVksQ0FBWixHQUFnQixLQUFoQixDQUFBO0tBQXVCOzs7d0JBRW5DO01BQUUsT0FBTyxJQUFBLENBQUssS0FBTCxDQUFXLENBQWxCLENBQUE7O3NCQUNKLE9BQU87TUFBRSxJQUFBLENBQUssS0FBTCxDQUFXLENBQVgsR0FBZSxLQUFmLENBQUE7S0FBc0I7Ozt3QkFDN0I7TUFBRSxPQUFPLElBQUEsQ0FBSyxLQUFMLENBQVcsQ0FBbEIsQ0FBQTs7c0JBQ0osT0FBTztNQUFFLElBQUEsQ0FBSyxLQUFMLENBQVcsQ0FBWCxHQUFlLEtBQWYsQ0FBQTtLQUFzQjs7O3dCQUV0QjtNQUFFLE9BQU8sSUFBQSxDQUFLLFFBQUwsQ0FBYyxDQUFyQixDQUFBOztzQkFDSixPQUFPO01BQUUsSUFBQSxDQUFLLFFBQUwsQ0FBYyxDQUFkLEdBQWtCLEtBQWxCLENBQUE7S0FBeUI7Ozt3QkFDaEM7TUFBRSxPQUFPLElBQUEsQ0FBSyxRQUFMLENBQWMsQ0FBckIsQ0FBQTs7c0JBQ0osT0FBTztNQUFFLElBQUEsQ0FBSyxRQUFMLENBQWMsQ0FBZCxHQUFrQixLQUFsQixDQUFBO0tBQXlCOzs7O0VBcEl6QyxXQUFBLENBQUEsU0FBQTs7O29CQTBMSzs7Ozs7Ozs7Ozs7Ozs7SUMzTUYsY0FDWCxTQUFBLFdBQUEsQ0FDUyxFQURULEVBRVMsT0FGVCxFQUdTLEtBSFQsRUFJUyxRQUpULEVBS1MsVUFMVCxFQU1FO0VBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsV0FBQSxDQUFBLENBQUE7O0VBQUEsSUFBQSxDQUxPLEVBS1AsR0FMTyxFQUtQLENBQUE7RUFBQSxJQUFBLENBSk8sT0FJUCxHQUpPLE9BSVAsQ0FBQTtFQUFBLElBQUEsQ0FITyxLQUdQLEdBSE8sS0FHUCxDQUFBO0VBQUEsSUFBQSxDQUZPLFFBRVAsR0FGTyxRQUVQLENBQUE7RUFBQSxJQUFBLENBRE8sVUFDUCxHQURPLFVBQ1AsQ0FBQTs7OztvQkFHVzs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ1hmLElBQUEsS0FBQSxHQUFBLDRCQUFBLENBQUEsVUFBQSxDQUFBLENBQUE7O0FBRUEsSUFBQSxjQUFBLEdBQUEsMkJBQUEsQ0FBQSxrQkFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxZQUFBLEdBQUEsMkJBQUEsQ0FBQSxnQkFBQSxDQUFBLENBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7SUFhWTs7OztXQUFBO0VBQUE7RUFBQTtFQUFBO0VBQUE7RUFBQTtFQUFBO0dBQUEsaURBQUE7O0lBU0E7Ozs7V0FBQTtFQUFBO0VBQUE7RUFBQTtFQUFBO0VBQUE7R0FBQSxtREFBQTs7QUF1RVosSUFBSSxTQUFTLEdBQUcsQ0FBaEIsQ0FBQTs7SUFFYTs7Ozs7Ozs7O3dCQXdEaUI7TUFDMUIsT0FBTyxDQUFQLENBQUE7S0FDRDs7Ozs7Ozs7RUEyQkQsU0FBQSxXQUFBLENBQUEsSUFBQSxFQUdHO0lBQUEsSUFBQSxLQUFBLEdBQUEsSUFBQSxDQUFBOztJQUFBLElBSFksV0FHWixHQUFBLElBQUEsQ0FIWSxXQUdaO1FBSHlCLFNBR3pCLEdBQUEsSUFBQSxDQUh5QixTQUd6QixDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLFdBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLGNBQUEsRUF0RjBCLElBc0YxQixDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsU0FBQSxFQW5GeUIsSUFtRnpCLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxNQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxRQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxPQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxZQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxVQUFBLEVBdEV3QjtNQUN6QixJQUFJLEVBQUcsSUFEa0I7TUFFekIsSUFBSSxFQUFHLElBRmtCO01BR3pCLEtBQUssRUFBRSxJQUFBO0tBbUVOLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxhQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxVQUFBLEVBN0R1QixFQTZEdkIsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLFdBQUEsRUExRG9DLElBMERwQyxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsYUFBQSxFQXhEaUMsRUF3RGpDLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxnQkFBQSxFQWxEQztNQUNGLE9BQU8sRUFBRSxJQURQO01BRUYsS0FBSyxFQUFFLElBRkw7TUFHRixXQUFXLEVBQUUsSUFBQTtLQStDWixDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsV0FBQSxFQTNDdUMsSUEyQ3ZDLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxlQUFBLEVBekNhLEtBeUNiLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxpQkFBQSxFQXhDZSxLQXdDZixDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsY0FBQSxFQXZDWSxLQXVDWixDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsU0FBQSxFQXRDTyxLQXNDUCxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsVUFBQSxFQXJDUSxJQXFDUixDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsUUFBQSxFQXBDMkIsSUFvQzNCLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxZQUFBLEVBbENVLElBa0NWLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxRQUFBLEVBekJNLEtBQUssQ0FBQyxRQUFOLENBQ1AsVUFBNkIsU0FBN0IsRUFBNkM7TUFDM0MsSUFBQSxDQUFLLElBQUwsQ0FBVSxTQUFWLENBQUEsQ0FBQTtLQUZLLEVBSVAsd0VBSk8sQ0F5Qk4sQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLFFBQUEsRUFuQjBCOztNQUUzQixLQUFLLEVBQUUsS0FBSyxDQUFDLE9BQU4sQ0FBYyxTQUFkLEVBRm9COztNQUkzQixJQUFJLEVBQUUsS0FBSyxDQUFDLE9BQU4sQ0FBYyxTQUFkLEVBSnFCOztNQU0zQixHQUFHLEVBQUUsS0FBSyxDQUFDLE9BQU4sQ0FBYyxTQUFkLEVBTnNCOztNQVEzQixLQUFLLEVBQUUsS0FBSyxDQUFDLE9BQU4sQ0FBYyxTQUFkLEVBUm9COztNQVUzQixRQUFRLEVBQUUsS0FBSyxDQUFDLE9BQU4sQ0FBYyxTQUFkLEVBQUE7S0FTVCxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsS0FBQSxFQU5vQixTQUFTLEVBTTdCLENBQUEsQ0FBQTs7SUFDRCxJQUFBLENBQUssVUFBTCxHQUFrQixTQUFsQixDQUFBO0lBQ0EsSUFBQSxDQUFLLFdBQUwsR0FBbUIsV0FBbkIsQ0FBQTtJQUVBLElBQU0sSUFBSSxHQUFHLElBQWIsQ0FBQTtJQUVBLElBQUEsQ0FBSyxNQUFMLEdBQWMsRUFBZCxDQUFBOztJQU5DLElBQUEsS0FBQSxHQUFBLFNBQUEsS0FBQSxDQVFVLEdBUlYsRUFBQTtNQVNDLE1BQU0sQ0FBQyxjQUFQLENBQXNCLEtBQUksQ0FBQyxNQUEzQixFQUFtQyxHQUFuQyxFQUF3QztRQUN0QyxHQURzQyxFQUFBLFNBQUEsR0FBQSxHQUMvQjtVQUFFLE9BQU8sSUFBSSxDQUFDLEdBQUQsQ0FBWCxDQUFBO1NBQWtCO09BRDdCLENBQUEsQ0FBQTtLQVRELENBQUE7O0lBUUQsS0FBSyxJQUFNLEdBQVgsSUFBa0IsWUFBbEIsRUFBZ0M7TUFBQSxLQUFBLENBQXJCLEdBQXFCLENBQUEsQ0FBQTtLQUkvQjs7SUFaQSxJQUFBLE1BQUEsR0FBQSxTQUFBLE1BQUEsQ0FjVSxJQWRWLEVBQUE7TUFlQyxNQUFNLENBQUMsY0FBUCxDQUFzQixLQUFJLENBQUMsTUFBM0IsRUFBbUMsSUFBbkMsRUFBd0M7UUFDdEMsS0FBSyxFQUFFLFNBQUEsS0FBQSxHQUFBO1VBQUEsT0FBYSxJQUFJLENBQUMsSUFBRCxDQUFKLENBQUEsS0FBQSxDQUFBLElBQUksRUFBQSxTQUFBLENBQWpCLENBQUE7U0FBQTtPQURULENBQUEsQ0FBQTtLQWZELENBQUE7O0lBY0QsS0FBSyxJQUFNLElBQVgsSUFBa0IsYUFBbEIsRUFBaUM7TUFBQSxNQUFBLENBQXRCLElBQXNCLENBQUEsQ0FBQTtLQUloQzs7SUFFRCxJQUFBLENBQUssVUFBTCxDQUFnQixrQkFBaEIsRUFBb0M7TUFBRSxXQUFXLEVBQUUsSUFBQTtLQUFuRCxDQUFBLENBQUE7R0FDRDs7OztnQ0FFWSxTQUErQixPQUFrQyxhQUFtQztNQUMvRyxJQUFNLFlBQVksR0FBRyxJQUFBLENBQUssYUFBTCxDQUFtQixPQUFuQixFQUE0QixLQUE1QixFQUFtQyxXQUFuQyxFQUFnRCxJQUFoRCxDQUFyQixDQUFBO01BQ0EsSUFBTSxXQUFXLEdBQUcsSUFBQSxDQUFLLFFBQUwsQ0FBYyxZQUFkLENBQXBCLENBQUE7O01BRUEsSUFBQSxDQUFLLFVBQUwsQ0FBZ0IsbUJBQWhCLEVBQXFDO1FBQ25DLE9BQU8sRUFBUCxPQURtQztRQUVuQyxLQUFLLEVBQUwsS0FGbUM7UUFHbkMsV0FBVyxFQUFYLFdBSG1DO1FBSW5DLFlBQVksRUFBWixZQUptQztRQUtuQyxXQUFXLEVBQVgsV0FMbUM7UUFNbkMsSUFBSSxFQUFFLE1BTjZCO1FBT25DLFdBQVcsRUFBRSxJQUFBO09BUGYsQ0FBQSxDQUFBO0tBU0Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OzBCQWlDTSxRQUFxQixjQUE0QixTQUEyQjtNQUNqRixJQUFJLElBQUEsQ0FBSyxXQUFMLEVBQUEsSUFDQSxDQUFDLElBQUEsQ0FBSyxhQUROLElBRUEsSUFBQSxDQUFLLFFBQUwsQ0FBYyxNQUFkLElBQXdCLE1BQU0sQ0FBQyxJQUFQLEtBQWdCLFNBQWhCLEdBQTRCLENBQTVCLEdBQWdDLENBQXhELENBRkEsSUFHQSxDQUFDLFlBQVksQ0FBQyxPQUFiLENBQXFCLE1BQU0sQ0FBQyxJQUE1QixDQUFBLENBQWtDLE9BSHZDLEVBR2dEO1FBQzlDLE9BQU8sS0FBUCxDQUFBO09BQ0Q7O01BRUQsS0FBSyxDQUFDLFVBQU4sQ0FBaUIsSUFBQSxDQUFLLFFBQXRCLEVBQWdDLE1BQWhDLENBQUEsQ0FBQTtNQUVBLElBQUEsQ0FBSyxZQUFMLEdBQW9CLFlBQXBCLENBQUE7TUFDQSxJQUFBLENBQUssT0FBTCxHQUFvQixPQUFwQixDQUFBO01BQ0EsSUFBQSxDQUFLLElBQUwsR0FBb0IsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsT0FBckIsQ0FBcEIsQ0FBQTtNQUNBLElBQUEsQ0FBSyxLQUFMLEdBQW9CLElBQUEsQ0FBSyxRQUFMLENBQWMsS0FBZCxHQUNoQixLQUFLLENBQUMsTUFBTixDQUFhLEVBQWIsRUFBaUIsSUFBQSxDQUFLLFFBQUwsQ0FBYyxLQUEvQixDQURnQixHQUVoQjtRQUFFLElBQUksRUFBRSxJQUFSO1FBQWMsS0FBSyxFQUFFLElBQXJCO1FBQTJCLEdBQUcsRUFBRSxJQUFoQztRQUFzQyxNQUFNLEVBQUUsSUFBQTtPQUZsRCxDQUFBO01BR0EsSUFBQSxDQUFLLFFBQUwsR0FBb0IsS0FBcEIsQ0FBQTtNQUNBLElBQUEsQ0FBSyxZQUFMLEdBQW9CLElBQUEsQ0FBSyxRQUFMLENBQWM7UUFDaEMsV0FBVyxFQUFFLElBRG1CO1FBRWhDLEtBQUssRUFBRSxJQUFBLENBQUssU0FGb0I7UUFHaEMsS0FBSyxFQUFFLE9BQUE7T0FIVyxDQUFBLElBSWQsQ0FBQyxJQUFBLENBQUssUUFKWixDQUFBO01BTUEsT0FBTyxJQUFBLENBQUssWUFBWixDQUFBO0tBQ0Q7OztnQ0FFWSxTQUErQixPQUFrQyxhQUFtQztNQUMvRyxJQUFJLENBQUMsSUFBQSxDQUFLLFVBQU4sSUFBb0IsRUFBRSxJQUFBLENBQUssWUFBTCxJQUFxQixJQUFBLENBQUssWUFBTCxDQUFrQixTQUF6QyxDQUF4QixFQUE2RTtRQUMzRSxJQUFBLENBQUssYUFBTCxDQUFtQixPQUFuQixFQUE0QixLQUE1QixFQUFtQyxXQUFuQyxFQUFnRCxLQUFoRCxDQUFBLENBQUE7T0FDRDs7TUFFRCxJQUFNLGFBQWEsR0FBSSxJQUFBLENBQUssTUFBTCxDQUFZLEdBQVosQ0FBZ0IsSUFBaEIsQ0FBcUIsQ0FBckIsS0FBMkIsSUFBQSxDQUFLLE1BQUwsQ0FBWSxJQUFaLENBQWlCLElBQWpCLENBQXNCLENBQWpELElBQ0EsSUFBQSxDQUFLLE1BQUwsQ0FBWSxHQUFaLENBQWdCLElBQWhCLENBQXFCLENBQXJCLEtBQTJCLElBQUEsQ0FBSyxNQUFMLENBQVksSUFBWixDQUFpQixJQUFqQixDQUFzQixDQURqRCxJQUVBLElBQUEsQ0FBSyxNQUFMLENBQVksR0FBWixDQUFnQixNQUFoQixDQUF1QixDQUF2QixLQUE2QixJQUFBLENBQUssTUFBTCxDQUFZLElBQVosQ0FBaUIsTUFBakIsQ0FBd0IsQ0FGckQsSUFHQSxJQUFBLENBQUssTUFBTCxDQUFZLEdBQVosQ0FBZ0IsTUFBaEIsQ0FBdUIsQ0FBdkIsS0FBNkIsSUFBQSxDQUFLLE1BQUwsQ0FBWSxJQUFaLENBQWlCLE1BQWpCLENBQXdCLENBSDVFLENBQUE7TUFLQSxJQUFJLEVBQUosQ0FBQTtNQUNBLElBQUksRUFBSixDQVgrRzs7TUFjL0csSUFBSSxJQUFBLENBQUssYUFBTCxJQUFzQixDQUFDLElBQUEsQ0FBSyxlQUFoQyxFQUFpRDtRQUMvQyxFQUFFLEdBQUcsSUFBQSxDQUFLLE1BQUwsQ0FBWSxHQUFaLENBQWdCLE1BQWhCLENBQXVCLENBQXZCLEdBQTJCLElBQUEsQ0FBSyxNQUFMLENBQVksS0FBWixDQUFrQixNQUFsQixDQUF5QixDQUF6RCxDQUFBO1FBQ0EsRUFBRSxHQUFHLElBQUEsQ0FBSyxNQUFMLENBQVksR0FBWixDQUFnQixNQUFoQixDQUF1QixDQUF2QixHQUEyQixJQUFBLENBQUssTUFBTCxDQUFZLEtBQVosQ0FBa0IsTUFBbEIsQ0FBeUIsQ0FBekQsQ0FBQTtRQUVBLElBQUEsQ0FBSyxlQUFMLEdBQXVCLEtBQUssQ0FBQyxLQUFOLENBQVksRUFBWixFQUFnQixFQUFoQixDQUFBLEdBQXNCLElBQUEsQ0FBSyxvQkFBbEQsQ0FBQTtPQUNEOztNQUVELElBQU0sWUFBWSxHQUFHLElBQUEsQ0FBSyxlQUFMLENBQXFCLE9BQXJCLENBQXJCLENBQUE7TUFDQSxJQUFNLFNBQVMsR0FBRztRQUNoQixPQUFPLEVBQVAsT0FEZ0I7UUFFaEIsWUFBWSxFQUFaLFlBRmdCO1FBR2hCLFdBQVcsRUFBRSxJQUFBLENBQUssUUFBTCxDQUFjLFlBQWQsQ0FIRztRQUloQixLQUFLLEVBQUwsS0FKZ0I7UUFLaEIsSUFBSSxFQUFFLE1BTFU7UUFNaEIsV0FBVyxFQUFYLFdBTmdCO1FBT2hCLEVBQUUsRUFBRixFQVBnQjtRQVFoQixFQUFFLEVBQUYsRUFSZ0I7UUFTaEIsU0FBUyxFQUFFLGFBVEs7UUFVaEIsV0FBVyxFQUFFLElBQUE7T0FWZixDQUFBOztNQWFBLElBQUksQ0FBQyxhQUFMLEVBQW9COztRQUVsQixLQUFLLENBQUMsT0FBTixDQUFjLGdCQUFkLENBQStCLElBQUEsQ0FBSyxNQUFMLENBQVksUUFBM0MsRUFBcUQsSUFBQSxDQUFLLE1BQUwsQ0FBWSxLQUFqRSxDQUFBLENBQUE7T0FDRDs7TUFFRCxJQUFBLENBQUssVUFBTCxDQUFnQixtQkFBaEIsRUFBcUMsU0FBckMsQ0FBQSxDQUFBOztNQUVBLElBQUksQ0FBQyxhQUFELElBQWtCLENBQUMsSUFBQSxDQUFLLFVBQTVCLEVBQXdDOztRQUV0QyxJQUFJLElBQUEsQ0FBSyxXQUFMLEVBQUosRUFBd0I7VUFDdEIsU0FBUyxDQUFDLElBQVYsR0FBaUIsSUFBakIsQ0FBQTtVQUNBLElBQUEsQ0FBSyxJQUFMLENBQVUsU0FBVixDQUFBLENBQUE7U0FDRDs7UUFFRCxJQUFJLElBQUEsQ0FBSyxlQUFULEVBQTBCO1VBQ3hCLEtBQUssQ0FBQyxPQUFOLENBQWMsVUFBZCxDQUF5QixJQUFBLENBQUssTUFBTCxDQUFZLElBQXJDLEVBQTJDLElBQUEsQ0FBSyxNQUFMLENBQVksR0FBdkQsQ0FBQSxDQUFBO1NBQ0Q7T0FDRjtLQUNGOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O3lCQW9CSyxXQUFZO01BQ2hCLElBQUksQ0FBQyxTQUFELElBQWMsQ0FBQyxTQUFTLENBQUMsS0FBN0IsRUFBb0M7UUFDbEMsS0FBSyxDQUFDLE9BQU4sQ0FBYyxhQUFkLENBQTRCLElBQUEsQ0FBSyxNQUFMLENBQVksS0FBeEMsQ0FBQSxDQUFBO09BQ0Q7O01BRUQsU0FBUyxHQUFHLEtBQUssQ0FBQyxNQUFOLENBQWE7UUFDdkIsT0FBTyxFQUFFLElBQUEsQ0FBSyxjQUFMLENBQW9CLE9BRE47UUFFdkIsS0FBSyxFQUFFLElBQUEsQ0FBSyxjQUFMLENBQW9CLEtBRko7UUFHdkIsV0FBVyxFQUFFLElBQUEsQ0FBSyxjQUFMLENBQW9CLFdBSFY7UUFJdkIsV0FBVyxFQUFFLElBQUE7T0FKSCxFQUtULFNBQVMsSUFBSSxFQUxKLENBQVosQ0FBQTtNQU9BLFNBQVMsQ0FBQyxLQUFWLEdBQWtCLE1BQWxCLENBQUE7O01BRUEsSUFBQSxDQUFLLFFBQUwsQ0FBYyxTQUFkLENBQUEsQ0FBQTs7Ozs7OEJBSVMsU0FBK0IsT0FBa0MsYUFBbUMsZ0JBQXNDO01BQ25KLElBQUksWUFBWSxHQUFHLElBQUEsQ0FBSyxlQUFMLENBQXFCLE9BQXJCLENBQW5CLENBQUE7O01BRUEsSUFBSSxZQUFZLEtBQUssQ0FBQyxDQUF0QixFQUF5QjtRQUN2QixZQUFZLEdBQUcsSUFBQSxDQUFLLGFBQUwsQ0FBbUIsT0FBbkIsRUFBNEIsS0FBNUIsRUFBbUMsV0FBbkMsRUFBZ0QsS0FBaEQsQ0FBZixDQUFBO09BQ0Q7O01BRUQsSUFBTSxJQUFJLEdBQUcsVUFBQSxDQUFXLElBQVgsQ0FBZ0IsS0FBSyxDQUFDLElBQXRCLENBQUEsR0FBOEIsUUFBOUIsR0FBeUMsSUFBdEQsQ0FBQTs7TUFFQSxJQUFBLENBQUssVUFBTCxDQUFBLGVBQUEsQ0FBQSxNQUFBLENBQWdDLElBQWhDLENBQUEsRUFBcUY7UUFDbkYsT0FBTyxFQUFQLE9BRG1GO1FBRW5GLFlBQVksRUFBWixZQUZtRjtRQUduRixXQUFXLEVBQUUsSUFBQSxDQUFLLFFBQUwsQ0FBYyxZQUFkLENBSHNFO1FBSW5GLEtBQUssRUFBTCxLQUptRjtRQUtuRixXQUFXLEVBQVgsV0FMbUY7UUFNbkYsSUFBSSxFQUFFLElBTjZFO1FBT25GLGNBQWMsRUFBZCxjQVBtRjtRQVFuRixXQUFXLEVBQUUsSUFBQTtPQVJmLENBQUEsQ0FBQTs7TUFXQSxJQUFJLENBQUMsSUFBQSxDQUFLLFVBQVYsRUFBc0I7UUFDcEIsSUFBQSxDQUFLLEdBQUwsQ0FBUyxLQUFULENBQUEsQ0FBQTtPQUNEOztNQUVELElBQUEsQ0FBSyxhQUFMLEdBQXFCLEtBQXJCLENBQUE7TUFDQSxJQUFBLENBQUssYUFBTCxDQUFtQixPQUFuQixFQUE0QixLQUE1QixDQUFBLENBQUE7S0FDRDs7O2lDQUVhLE9BQU87TUFDbkIsSUFBQSxDQUFLLEdBQUwsQ0FBUyxLQUFULENBQUEsQ0FBQTs7TUFDQSxJQUFBLENBQUssVUFBTCxDQUFnQixtQkFBaEIsRUFBcUM7UUFBRSxLQUFLLEVBQUwsS0FBRjtRQUFTLElBQUksRUFBRSxNQUFmO1FBQXVCLFdBQVcsRUFBRSxJQUFBO09BQXpFLENBQUEsQ0FBQTtLQUNEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozt3QkFrQkksT0FBbUM7TUFDdEMsSUFBQSxDQUFLLE9BQUwsR0FBZSxJQUFmLENBQUE7TUFDQSxLQUFLLEdBQUcsS0FBSyxJQUFJLElBQUEsQ0FBSyxjQUFMLENBQW9CLEtBQXJDLENBQUE7TUFDQSxJQUFJLGNBQUosQ0FBQTs7TUFFQSxJQUFJLElBQUEsQ0FBSyxXQUFMLEVBQUosRUFBd0I7UUFDdEIsY0FBYyxHQUFHLElBQUEsQ0FBSyxRQUFMLENBQWM7VUFDN0IsS0FBSyxFQUFMLEtBRDZCO1VBRTdCLFdBQVcsRUFBRSxJQUZnQjtVQUc3QixLQUFLLEVBQUUsS0FBQTtTQUhRLENBQWpCLENBQUE7T0FLRDs7TUFFRCxJQUFBLENBQUssT0FBTCxHQUFlLEtBQWYsQ0FBQTs7TUFFQSxJQUFJLGNBQWMsS0FBSyxJQUF2QixFQUE2QjtRQUMzQixJQUFBLENBQUssSUFBTCxFQUFBLENBQUE7T0FDRDtLQUNGOzs7b0NBRWdCO01BQ2YsT0FBTyxJQUFBLENBQUssWUFBTCxHQUFvQixJQUFBLENBQUssUUFBTCxDQUFjLElBQWxDLEdBQXlDLElBQWhELENBQUE7S0FDRDs7O2tDQUVjO01BQ2IsT0FBTyxJQUFBLENBQUssWUFBWixDQUFBO0tBQ0Q7Ozs7OzJCQUdPO01BQ04sSUFBQSxDQUFLLFVBQUwsQ0FBZ0IsbUJBQWhCLEVBQXFDO1FBQUUsV0FBVyxFQUFFLElBQUE7T0FBcEQsQ0FBQSxDQUFBOztNQUVBLElBQUEsQ0FBSyxZQUFMLEdBQW9CLElBQUEsQ0FBSyxPQUFMLEdBQWUsSUFBbkMsQ0FBQTtNQUVBLElBQUEsQ0FBSyxZQUFMLEdBQW9CLEtBQXBCLENBQUE7TUFDQSxJQUFBLENBQUssUUFBTCxHQUFnQixJQUFoQixDQUFBO01BQ0EsSUFBQSxDQUFLLFFBQUwsQ0FBYyxJQUFkLEdBQXFCLElBQUEsQ0FBSyxTQUFMLEdBQWlCLElBQXRDLENBQUE7S0FDRDs7O29DQUVnQixTQUFTO01BQ3hCLElBQU0sU0FBUyxHQUFHLEtBQUssQ0FBQyxPQUFOLENBQWMsWUFBZCxDQUEyQixPQUEzQixDQUFsQixDQUR3Qjs7TUFJeEIsT0FBUSxJQUFBLENBQUssV0FBTCxLQUFxQixPQUFyQixJQUFnQyxJQUFBLENBQUssV0FBTCxLQUFxQixLQUF0RCxHQUNILElBQUEsQ0FBSyxRQUFMLENBQWMsTUFBZCxHQUF1QixDQURwQixHQUVILEtBQUssQ0FBQyxHQUFOLENBQVUsU0FBVixDQUFvQixJQUFBLENBQUssUUFBekIsRUFBbUMsVUFBQSxVQUFVLEVBQUE7UUFBQSxPQUFJLFVBQVUsQ0FBQyxFQUFYLEtBQWtCLFNBQXRCLENBQUE7T0FBN0MsQ0FGSixDQUFBO0tBR0Q7OzttQ0FFZSxTQUFTO01BQ3ZCLE9BQU8sSUFBQSxDQUFLLFFBQUwsQ0FBYyxJQUFBLENBQUssZUFBTCxDQUFxQixPQUFyQixDQUFkLENBQVAsQ0FBQTtLQUNEOzs7a0NBRWMsU0FBK0IsT0FBa0MsYUFBbUMsTUFBZ0I7TUFDakksSUFBTSxFQUFFLEdBQUcsS0FBSyxDQUFDLE9BQU4sQ0FBYyxZQUFkLENBQTJCLE9BQTNCLENBQVgsQ0FBQTtNQUNBLElBQUksWUFBWSxHQUFHLElBQUEsQ0FBSyxlQUFMLENBQXFCLE9BQXJCLENBQW5CLENBQUE7TUFDQSxJQUFJLFdBQVcsR0FBRyxJQUFBLENBQUssUUFBTCxDQUFjLFlBQWQsQ0FBbEIsQ0FBQTtNQUVBLElBQUksR0FBRyxJQUFJLEtBQUssS0FBVCxHQUNILEtBREcsR0FFSCxJQUFJLElBQUksZ0JBQUEsQ0FBaUIsSUFBakIsQ0FBc0IsS0FBSyxDQUFDLElBQTVCLENBRlosQ0FBQTs7TUFJQSxJQUFJLENBQUMsV0FBTCxFQUFrQjtRQUNoQixXQUFXLEdBQUcsSUFBSSxZQUFBLENBQUEsU0FBQSxDQUFKLENBQ1osRUFEWSxFQUVaLE9BRlksRUFHWixLQUhZLEVBSVosSUFKWSxFQUtaLElBTFksQ0FBZCxDQUFBO1FBUUEsWUFBWSxHQUFHLElBQUEsQ0FBSyxRQUFMLENBQWMsTUFBN0IsQ0FBQTtRQUNBLElBQUEsQ0FBSyxRQUFMLENBQWMsSUFBZCxDQUFtQixXQUFuQixDQUFBLENBQUE7T0FWRixNQVlLO1FBQ0gsV0FBVyxDQUFDLE9BQVosR0FBc0IsT0FBdEIsQ0FBQTtPQUNEOztNQUVELEtBQUssQ0FBQyxPQUFOLENBQWMsU0FBZCxDQUF3QixJQUFBLENBQUssTUFBTCxDQUFZLEdBQXBDLEVBQXlDLElBQUEsQ0FBSyxRQUFMLENBQWMsR0FBZCxDQUFrQixVQUFBLENBQUMsRUFBQTtRQUFBLE9BQUksQ0FBQyxDQUFDLE9BQU4sQ0FBQTtPQUFuQixDQUF6QyxFQUE0RSxJQUFBLENBQUssSUFBTCxFQUE1RSxDQUFBLENBQUE7TUFDQSxLQUFLLENBQUMsT0FBTixDQUFjLGNBQWQsQ0FBNkIsSUFBQSxDQUFLLE1BQUwsQ0FBWSxLQUF6QyxFQUFnRCxJQUFBLENBQUssTUFBTCxDQUFZLElBQTVELEVBQWtFLElBQUEsQ0FBSyxNQUFMLENBQVksR0FBOUUsQ0FBQSxDQUFBOztNQUVBLElBQUksSUFBSixFQUFVO1FBQ1IsSUFBQSxDQUFLLGFBQUwsR0FBcUIsSUFBckIsQ0FBQTtRQUVBLFdBQVcsQ0FBQyxRQUFaLEdBQXVCLElBQUEsQ0FBSyxNQUFMLENBQVksR0FBWixDQUFnQixTQUF2QyxDQUFBO1FBQ0EsV0FBVyxDQUFDLFVBQVosR0FBeUIsV0FBekIsQ0FBQTtRQUNBLEtBQUssQ0FBQyxPQUFOLENBQWMsYUFBZCxDQUE0QixJQUFBLENBQUssV0FBakMsRUFBOEMsT0FBOUMsQ0FBQSxDQUFBOztRQUVBLElBQUksQ0FBQyxJQUFBLENBQUssV0FBTCxFQUFMLEVBQXlCO1VBQ3ZCLEtBQUssQ0FBQyxPQUFOLENBQWMsVUFBZCxDQUF5QixJQUFBLENBQUssTUFBTCxDQUFZLEtBQXJDLEVBQTRDLElBQUEsQ0FBSyxNQUFMLENBQVksR0FBeEQsQ0FBQSxDQUFBO1VBQ0EsS0FBSyxDQUFDLE9BQU4sQ0FBYyxVQUFkLENBQXlCLElBQUEsQ0FBSyxNQUFMLENBQVksSUFBckMsRUFBMkMsSUFBQSxDQUFLLE1BQUwsQ0FBWSxHQUF2RCxDQUFBLENBQUE7VUFFQSxJQUFBLENBQUssU0FBTCxHQUFpQixLQUFqQixDQUFBO1VBQ0EsSUFBQSxDQUFLLGVBQUwsR0FBdUIsS0FBdkIsQ0FBQTtTQUNEO09BQ0Y7O01BRUQsSUFBQSxDQUFLLG9CQUFMLENBQTBCLE9BQTFCLEVBQW1DLEtBQW5DLEVBQTBDLFdBQTFDLENBQUEsQ0FBQTs7TUFFQSxJQUFBLENBQUssVUFBTCxDQUFnQiw2QkFBaEIsRUFBK0M7UUFDN0MsT0FBTyxFQUFQLE9BRDZDO1FBRTdDLEtBQUssRUFBTCxLQUY2QztRQUc3QyxXQUFXLEVBQVgsV0FINkM7UUFJN0MsSUFBSSxFQUFKLElBSjZDO1FBSzdDLFdBQVcsRUFBWCxXQUw2QztRQU03QyxZQUFZLEVBQVosWUFONkM7UUFPN0MsV0FBVyxFQUFFLElBQUE7T0FQZixDQUFBLENBQUE7O01BVUEsT0FBTyxZQUFQLENBQUE7S0FDRDs7O2tDQUVjLFNBQStCLE9BQWtDO01BQzlFLElBQU0sWUFBWSxHQUFHLElBQUEsQ0FBSyxlQUFMLENBQXFCLE9BQXJCLENBQXJCLENBQUE7O01BRUEsSUFBSSxZQUFZLEtBQUssQ0FBQyxDQUF0QixFQUF5QjtRQUFFLE9BQUE7T0FBUTs7TUFFbkMsSUFBTSxXQUFXLEdBQUcsSUFBQSxDQUFLLFFBQUwsQ0FBYyxZQUFkLENBQXBCLENBQUE7O01BRUEsSUFBQSxDQUFLLFVBQUwsQ0FBZ0IsNkJBQWhCLEVBQStDO1FBQzdDLE9BQU8sRUFBUCxPQUQ2QztRQUU3QyxLQUFLLEVBQUwsS0FGNkM7UUFHN0MsV0FBVyxFQUFFLElBSGdDO1FBSTdDLFlBQVksRUFBWixZQUo2QztRQUs3QyxXQUFXLEVBQVgsV0FMNkM7UUFNN0MsV0FBVyxFQUFFLElBQUE7T0FOZixDQUFBLENBQUE7O01BU0EsSUFBQSxDQUFLLFFBQUwsQ0FBYyxNQUFkLENBQXFCLFlBQXJCLEVBQW1DLENBQW5DLENBQUEsQ0FBQTtLQUNEOzs7eUNBRXFCLFNBQVMsT0FBTyxhQUFhO01BQ2pELElBQUEsQ0FBSyxjQUFMLENBQW9CLE9BQXBCLEdBQThCLE9BQTlCLENBQUE7TUFDQSxJQUFBLENBQUssY0FBTCxDQUFvQixLQUFwQixHQUE0QixLQUE1QixDQUFBO01BQ0EsSUFBQSxDQUFLLGNBQUwsQ0FBb0IsV0FBcEIsR0FBa0MsV0FBbEMsQ0FBQTtLQUNEOzs7OEJBRVU7TUFDVCxJQUFBLENBQUssY0FBTCxDQUFvQixPQUFwQixHQUE4QixJQUE5QixDQUFBO01BQ0EsSUFBQSxDQUFLLGNBQUwsQ0FBb0IsS0FBcEIsR0FBNEIsSUFBNUIsQ0FBQTtNQUNBLElBQUEsQ0FBSyxjQUFMLENBQW9CLFdBQXBCLEdBQWtDLElBQWxDLENBQUE7S0FDRDs7O3lDQUUyQyxPQUFrQyxPQUFVLFFBQWtCLE1BQWU7TUFDdkgsT0FBTyxJQUFJLGNBQUEsQ0FBQSxTQUFBLENBQUosQ0FBd0IsSUFBeEIsRUFBOEIsS0FBOUIsRUFBcUMsSUFBQSxDQUFLLFFBQUwsQ0FBYyxJQUFuRCxFQUF5RCxLQUF6RCxFQUFnRSxJQUFBLENBQUssT0FBckUsRUFBOEUsTUFBOUUsRUFBc0YsSUFBdEYsQ0FBUCxDQUFBO0tBQ0Q7OzsrQkFFaUMsUUFBNkI7TUFDN0QsSUFBQSxDQUFLLFlBQUwsQ0FBa0IsSUFBbEIsQ0FBdUIsTUFBdkIsQ0FBQSxDQUFBOztNQUVBLElBQUksQ0FBQyxJQUFBLENBQUssU0FBTixJQUFtQixNQUFNLENBQUMsU0FBUCxJQUFvQixJQUFBLENBQUssU0FBTCxDQUFlLFNBQTFELEVBQXFFO1FBQ25FLElBQUEsQ0FBSyxTQUFMLEdBQWlCLE1BQWpCLENBQUE7T0FDRDtLQUNGOzs7NkJBRStCLFdBQWdGO01BQUEsSUFDdEcsS0FEc0csR0FDdkUsU0FEdUUsQ0FDdEcsS0FEc0c7VUFDL0YsS0FEK0YsR0FDdkUsU0FEdUUsQ0FDL0YsS0FEK0Y7VUFDeEYsTUFEd0YsR0FDdkUsU0FEdUUsQ0FDeEYsTUFEd0Y7VUFDaEYsSUFEZ0YsR0FDdkUsU0FEdUUsQ0FDaEYsSUFEZ0YsQ0FBQTtNQUFBLElBRXRHLElBRnNHLEdBRTdGLElBRjZGLENBRXRHLElBRnNHLENBQUE7O01BSTlHLElBQUksSUFBSSxJQUFJLEtBQUssS0FBSyxNQUF0QixFQUE4Qjs7UUFFNUIsS0FBSyxDQUFDLElBQU4sQ0FBVyxRQUFYLENBQW9CLElBQUEsQ0FBSyxLQUF6QixFQUFnQyxJQUFoQyxFQUFzQyxJQUFBLENBQUssTUFBTCxDQUFZLEtBQVosQ0FBa0IsSUFBQSxDQUFLLFlBQUwsQ0FBa0IsT0FBbEIsQ0FBMEIsV0FBNUMsQ0FBdEMsQ0FBQSxDQUFBO1FBRUEsSUFBSSxDQUFDLEtBQUwsR0FBYSxJQUFJLENBQUMsS0FBTCxHQUFhLElBQUksQ0FBQyxJQUEvQixDQUFBO1FBQ0EsSUFBSSxDQUFDLE1BQUwsR0FBYyxJQUFJLENBQUMsTUFBTCxHQUFjLElBQUksQ0FBQyxHQUFqQyxDQUFBO09BQ0Q7O01BRUQsSUFBTSxZQUFZLEdBQUcsSUFBQSxDQUFLLFVBQUwsQ0FBQSw2QkFBQSxDQUFBLE1BQUEsQ0FBOEMsS0FBOUMsQ0FBQSxFQUE4RCxTQUE5RCxDQUFyQixDQUFBOztNQUVBLElBQUksWUFBWSxLQUFLLEtBQXJCLEVBQTRCO1FBQzFCLE9BQU8sS0FBUCxDQUFBO09BQ0Q7O01BRUQsSUFBTSxNQUFNLEdBQUcsU0FBUyxDQUFDLE1BQVYsR0FBbUIsSUFBQSxDQUFLLG9CQUFMLENBQTBCLEtBQTFCLEVBQWlDLEtBQWpDLEVBQXdDLE1BQXhDLEVBQWdELElBQWhELENBQWxDLENBQUE7O01BRUEsSUFBQSxDQUFLLFVBQUwsQ0FBQSxzQkFBQSxDQUFBLE1BQUEsQ0FBdUMsS0FBdkMsQ0FBQSxFQUF1RCxTQUF2RCxDQUFBLENBQUE7O01BRUEsSUFBSSxLQUFLLEtBQUssT0FBZCxFQUF1QjtRQUFFLElBQUEsQ0FBSyxTQUFMLEdBQWlCLE1BQWpCLENBQUE7T0FBeUI7O01BRWxELElBQUEsQ0FBSyxVQUFMLENBQWdCLE1BQWhCLENBQUEsQ0FBQTs7TUFFQSxJQUFBLENBQUssVUFBTCxDQUFBLDRCQUFBLENBQUEsTUFBQSxDQUE2QyxLQUE3QyxDQUFBLEVBQTZELFNBQTdELENBQUEsQ0FBQTs7TUFFQSxPQUFPLElBQVAsQ0FBQTtLQUNEOzs7MkJBRU87TUFBRSxPQUFPLElBQUksQ0FBQyxHQUFMLEVBQVAsQ0FBQTtLQUFtQjs7Ozs7OztvQkFHaEI7Ozs7Ozs7Ozs7Ozs7QUNqbUJmLElBQUEsUUFBQSxHQUFBLDRCQUFBLENBQUEsYUFBQSxDQUFBLENBQUE7Ozs7OztBQVlBLElBQU0sTUFBTSxHQUFHO0VBQ2IsV0FBVyxFQUFFLENBQUMsa0JBQUQsRUFBcUIsWUFBckIsRUFBbUMsWUFBbkMsRUFBaUQsTUFBakQsQ0FEQTtFQUdiLE1BSGEsRUFBQSxTQUFBLE1BQUEsQ0FHTCxPQUhLLEVBR21CO0lBQzlCLEtBQUEsSUFBQSxFQUFBLEdBQUEsQ0FBQSxFQUFBLEVBQUEsR0FBcUIsTUFBTSxDQUFDLFdBQTVCLENBQUEsTUFBQSxFQUFBLEVBQUEsRUFBQSxFQUF5QztNQUFBLElBQUEsSUFBQSxDQUFBOztNQUFBLElBQUEsR0FBcEIsTUFBTSxDQUFDLFdBQWEsQ0FBQSxFQUFBLENBQUEsQ0FBQTtNQUFBLElBQTlCLE1BQThCLEdBQUEsSUFBQSxDQUFBO01BQ3ZDLElBQU0sV0FBVyxHQUFHLE1BQU0sQ0FBQyxNQUFELENBQU4sQ0FBZSxPQUFmLENBQXBCLENBQUE7O01BRUEsSUFBSSxXQUFKLEVBQWlCO1FBQ2YsT0FBTyxXQUFQLENBQUE7T0FDRDtLQUNGOztJQUVELE9BQU8sSUFBUCxDQUFBO0dBWlc7O0VBZ0JiLGdCQWhCYSxFQUFBLFNBQUEsZ0JBQUEsQ0FBQSxLQUFBLEVBZ0JvRTtJQUFBLElBQTdELFdBQTZELEdBQUEsS0FBQSxDQUE3RCxXQUE2RDtRQUFoRCxTQUFnRCxHQUFBLEtBQUEsQ0FBaEQsU0FBZ0Q7UUFBckMsV0FBcUMsR0FBQSxLQUFBLENBQXJDLFdBQXFDO1FBQXhCLEtBQXdCLEdBQUEsS0FBQSxDQUF4QixLQUF3QixDQUFBOztJQUMvRSxJQUFJLENBQUMsYUFBQSxDQUFjLElBQWQsQ0FBbUIsU0FBbkIsQ0FBTCxFQUFvQztNQUNsQyxPQUFPLElBQVAsQ0FBQTtLQUNEOztJQUVELEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBMEIsS0FBSyxDQUFDLFlBQU4sQ0FBbUIsSUFBN0MsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQW1EO01BQUEsSUFBQSxLQUFBLENBQUE7O01BQUEsS0FBQSxHQUF6QixLQUFLLENBQUMsWUFBTixDQUFtQixJQUFNLENBQUEsR0FBQSxDQUFBLENBQUE7TUFBQSxJQUF4QyxXQUF3QyxHQUFBLEtBQUEsQ0FBQTtNQUNqRCxJQUFJLE9BQU8sR0FBRyxXQUFkLENBQUE7O01BRUEsSUFBSSxXQUFXLENBQUMsVUFBWixJQUEwQixXQUFXLENBQUMsVUFBWixDQUF1QixXQUFqRCxJQUNDLFdBQVcsQ0FBQyxXQUFaLEtBQTRCLFdBRGpDLEVBQytDO1FBQzdDLE9BQU8sT0FBUCxFQUFnQjs7VUFFZCxJQUFJLE9BQU8sS0FBSyxXQUFXLENBQUMsT0FBNUIsRUFBcUM7WUFDbkMsT0FBTyxXQUFQLENBQUE7V0FDRDs7VUFDRCxPQUFPLEdBQUcsUUFBRyxDQUFDLFVBQUosQ0FBZSxPQUFmLENBQVYsQ0FBQTtTQUNEO09BQ0Y7S0FDRjs7SUFFRCxPQUFPLElBQVAsQ0FBQTtHQXBDVzs7RUF3Q2IsVUF4Q2EsRUFBQSxTQUFBLFVBQUEsQ0FBQSxLQUFBLEVBd0M0RDtJQUFBLElBQTNELFNBQTJELEdBQUEsS0FBQSxDQUEzRCxTQUEyRDtRQUFoRCxXQUFnRCxHQUFBLEtBQUEsQ0FBaEQsV0FBZ0Q7UUFBbkMsU0FBbUMsR0FBQSxLQUFBLENBQW5DLFNBQW1DO1FBQXhCLEtBQXdCLEdBQUEsS0FBQSxDQUF4QixLQUF3QixDQUFBOztJQUN2RSxJQUFJLFdBQVcsS0FBSyxPQUFoQixJQUEyQixXQUFXLEtBQUssS0FBL0MsRUFBc0Q7TUFDcEQsT0FBTyxJQUFQLENBQUE7S0FDRDs7SUFFRCxJQUFJLGNBQUosQ0FBQTs7SUFFQSxLQUFBLElBQUEsR0FBQSxHQUFBLENBQUEsRUFBQSxHQUFBLEdBQTBCLEtBQUssQ0FBQyxZQUFOLENBQW1CLElBQTdDLENBQUEsTUFBQSxFQUFBLEdBQUEsRUFBQSxFQUFtRDtNQUFBLElBQUEsS0FBQSxDQUFBOztNQUFBLEtBQUEsR0FBekIsS0FBSyxDQUFDLFlBQU4sQ0FBbUIsSUFBTSxDQUFBLEdBQUEsQ0FBQSxDQUFBO01BQUEsSUFBeEMsV0FBd0MsR0FBQSxLQUFBLENBQUE7O01BQ2pELElBQUksV0FBVyxDQUFDLFdBQVosS0FBNEIsV0FBaEMsRUFBNkM7O1FBRTNDLElBQUksV0FBVyxDQUFDLFVBQVosSUFBMEIsQ0FBQyxZQUFZLENBQUMsV0FBRCxFQUFjLFNBQWQsQ0FBM0MsRUFBcUU7VUFBRSxTQUFBO1NBRjVCOzs7UUFLM0MsSUFBSSxXQUFXLENBQUMsV0FBWixFQUFKLEVBQStCO1VBQzdCLE9BQU8sV0FBUCxDQUFBO1NBREY7YUFJSyxJQUFJLENBQUMsY0FBTCxFQUFxQjtZQUN4QixjQUFjLEdBQUcsV0FBakIsQ0FBQTtXQUNEO09BQ0Y7S0FwQm9FOzs7O0lBeUJ2RSxJQUFJLGNBQUosRUFBb0I7TUFDbEIsT0FBTyxjQUFQLENBQUE7S0ExQnFFOzs7OztJQWdDdkUsS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUEwQixLQUFLLENBQUMsWUFBTixDQUFtQixJQUE3QyxDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBbUQ7TUFBQSxJQUFBLEtBQUEsQ0FBQTs7TUFBQSxLQUFBLEdBQXpCLEtBQUssQ0FBQyxZQUFOLENBQW1CLElBQU0sQ0FBQSxHQUFBLENBQUEsQ0FBQTtNQUFBLElBQXhDLFlBQXdDLEdBQUEsS0FBQSxDQUFBOztNQUNqRCxJQUFJLFlBQVcsQ0FBQyxXQUFaLEtBQTRCLFdBQTVCLElBQTJDLEVBQUUsT0FBQSxDQUFRLElBQVIsQ0FBYSxTQUFiLENBQUEsSUFBMkIsWUFBVyxDQUFDLFVBQXpDLENBQS9DLEVBQXFHO1FBQ25HLE9BQU8sWUFBUCxDQUFBO09BQ0Q7S0FDRjs7SUFFRCxPQUFPLElBQVAsQ0FBQTtHQTlFVzs7RUFrRmIsVUFsRmEsRUFBQSxTQUFBLFVBQUEsQ0FBQSxLQUFBLEVBa0ZvQztJQUFBLElBQW5DLFNBQW1DLEdBQUEsS0FBQSxDQUFuQyxTQUFtQztRQUF4QixLQUF3QixHQUFBLEtBQUEsQ0FBeEIsS0FBd0IsQ0FBQTs7SUFDL0MsS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUEwQixLQUFLLENBQUMsWUFBTixDQUFtQixJQUE3QyxDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBbUQ7TUFBQSxJQUFBLEtBQUEsQ0FBQTs7TUFBQSxLQUFBLEdBQXpCLEtBQUssQ0FBQyxZQUFOLENBQW1CLElBQU0sQ0FBQSxHQUFBLENBQUEsQ0FBQTtNQUFBLElBQXhDLFdBQXdDLEdBQUEsS0FBQSxDQUFBOztNQUNqRCxJQUFJLFlBQVksQ0FBQyxXQUFELEVBQWMsU0FBZCxDQUFoQixFQUEwQztRQUN4QyxPQUFPLFdBQVAsQ0FBQTtPQUNEO0tBQ0Y7O0lBRUQsT0FBTyxJQUFQLENBQUE7R0F6Rlc7O0VBNkZiLElBN0ZhLEVBQUEsU0FBQSxJQUFBLENBQUEsS0FBQSxFQTZGZ0M7SUFBQSxJQUFyQyxXQUFxQyxHQUFBLEtBQUEsQ0FBckMsV0FBcUM7UUFBeEIsS0FBd0IsR0FBQSxLQUFBLENBQXhCLEtBQXdCLENBQUE7O0lBQzNDLEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBMEIsS0FBSyxDQUFDLFlBQU4sQ0FBbUIsSUFBN0MsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQW1EO01BQUEsSUFBQSxNQUFBLENBQUE7O01BQUEsTUFBQSxHQUF6QixLQUFLLENBQUMsWUFBTixDQUFtQixJQUFNLENBQUEsR0FBQSxDQUFBLENBQUE7TUFBQSxJQUF4QyxXQUF3QyxHQUFBLE1BQUEsQ0FBQTs7O01BRWpELElBQUksV0FBVyxDQUFDLFFBQVosQ0FBcUIsTUFBckIsS0FBZ0MsQ0FBcEMsRUFBdUM7UUFDckMsSUFBTSxNQUFNLEdBQUcsV0FBVyxDQUFDLFlBQTNCLENBRHFDOzs7UUFJckMsSUFBSSxNQUFNLElBQUksRUFBRSxNQUFNLENBQUMsT0FBUCxDQUFlLE9BQWYsSUFBMEIsTUFBTSxDQUFDLE9BQVAsQ0FBZSxPQUFmLENBQXVCLE9BQW5ELENBQWQsRUFBMkU7VUFDekUsU0FBQTtTQUNEO09BTkg7V0FTSyxJQUFJLFdBQVcsQ0FBQyxRQUFaLENBQXFCLE1BQXJCLElBQStCLENBQW5DLEVBQXNDO1VBQ3pDLFNBQUE7U0FDRDs7TUFFRCxJQUFJLENBQUMsV0FBVyxDQUFDLFdBQVosRUFBRCxJQUErQixXQUFXLEtBQUssV0FBVyxDQUFDLFdBQS9ELEVBQTZFO1FBQzNFLE9BQU8sV0FBUCxDQUFBO09BQ0Q7S0FDRjs7SUFFRCxPQUFPLElBQVAsQ0FBQTtHQUNEO0NBbkhILENBQUE7O0FBc0hBLFNBQVMsWUFBVCxDQUF1QixXQUF2QixFQUEwRCxTQUExRCxFQUE2RTtFQUMzRSxPQUFPLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQXJCLENBQTBCLFVBQUEsTUFBQSxFQUFBO0lBQUEsSUFBRyxFQUFILEdBQUEsTUFBQSxDQUFHLEVBQUgsQ0FBQTtJQUFBLE9BQVksRUFBRSxLQUFLLFNBQW5CLENBQUE7R0FBMUIsQ0FBUCxDQUFBO0NBQ0Q7O29CQUVjOzs7Ozs7Ozs7Ozs7OztBQ3RJZiwwRUFBQTs7QUFDQSxJQUFBLFlBQUEsR0FBQSwyQkFBQSxDQUFBLFdBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsT0FBQSxHQUFBLDRCQUFBLENBQUEsT0FBQSxDQUFBLENBQUE7O0FBQ0Esc0VBQUE7Ozs7Ozs7O0FBWUEsU0FBUyxjQUFULENBQXNELFFBQXRELEVBQXNGO0VBQ3BGLElBQUksdUJBQUEsQ0FBd0IsSUFBeEIsQ0FBNkIsUUFBN0IsQ0FBSixFQUE0QztJQUMxQyxJQUFBLENBQUssT0FBTCxDQUFhLGNBQWIsR0FBOEIsUUFBOUIsQ0FBQTtJQUNBLE9BQU8sSUFBUCxDQUFBO0dBQ0Q7O0VBRUQsSUFBSSxPQUFFLENBQUMsSUFBSCxDQUFRLFFBQVIsQ0FBSixFQUF1QjtJQUNyQixJQUFBLENBQUssT0FBTCxDQUFhLGNBQWIsR0FBOEIsUUFBUSxHQUFHLFFBQUgsR0FBYyxPQUFwRCxDQUFBO0lBQ0EsT0FBTyxJQUFQLENBQUE7R0FDRDs7RUFFRCxPQUFPLElBQUEsQ0FBSyxPQUFMLENBQWEsY0FBcEIsQ0FBQTtDQUNEOztBQUVELFNBQVMsc0JBQVQsQ0FBaUMsWUFBakMsRUFBc0UsS0FBdEUsRUFBNkYsS0FBN0YsRUFBMkc7RUFDekcsSUFBTSxPQUFPLEdBQUcsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsY0FBckMsQ0FBQTs7RUFFQSxJQUFJLE9BQU8sS0FBSyxPQUFoQixFQUF5QjtJQUFFLE9BQUE7R0FBUTs7RUFFbkMsSUFBSSxPQUFPLEtBQUssUUFBaEIsRUFBMEI7SUFDeEIsS0FBSyxDQUFDLGNBQU4sRUFBQSxDQUFBO0lBQ0EsT0FBQTtHQVB1Rzs7Ozs7O0VBZXpHLElBQUksWUFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFPLGVBQVAsSUFBMEIscUJBQUEsQ0FBc0IsSUFBdEIsQ0FBMkIsS0FBSyxDQUFDLElBQWpDLENBQTlCLEVBQXNFO0lBQ3BFLElBQU0sR0FBRyxHQUFHLENBQUEsQ0FBQSxFQUFBLFdBQUEsQ0FBQSxTQUFBLEVBQVUsS0FBSyxDQUFDLE1BQWhCLENBQUEsQ0FBd0IsUUFBcEMsQ0FBQTtJQUNBLElBQU0sVUFBVSxHQUFHLEtBQUssQ0FBQyxhQUFOLENBQW9CLEdBQXBCLENBQW5CLENBQUE7O0lBRUEsSUFBSSxFQUFFLFVBQVUsSUFBSSxVQUFVLENBQUMsTUFBM0IsQ0FBQSxJQUFzQyxVQUFVLENBQUMsTUFBWCxDQUFrQixPQUFsQixLQUE4QixLQUF4RSxFQUErRTtNQUM3RSxPQUFBO0tBQ0Q7R0FyQnNHOzs7RUF5QnpHLElBQUksc0NBQUEsQ0FBdUMsSUFBdkMsQ0FBNEMsS0FBSyxDQUFDLElBQWxELENBQUosRUFBNkQ7SUFDM0QsT0FBQTtHQTFCdUc7OztFQThCekcsSUFBSSxPQUFFLENBQUMsT0FBSCxDQUFXLEtBQUssQ0FBQyxNQUFqQixDQUFBLElBQ0EsQ0FBQSxDQUFBLEVBQUEsYUFBQSxDQUFBLGVBQUEsRUFBZ0IsS0FBSyxDQUFDLE1BQXRCLEVBQThCLHVFQUE5QixDQURKLEVBQzRHO0lBQzFHLE9BQUE7R0FDRDs7RUFFRCxLQUFLLENBQUMsY0FBTixFQUFBLENBQUE7Q0FDRDs7QUFFRCxTQUFTLGtCQUFULENBQUEsSUFBQSxFQUE4SDtFQUFBLElBQS9GLFdBQStGLEdBQUEsSUFBQSxDQUEvRixXQUErRjtNQUFsRixLQUFrRixHQUFBLElBQUEsQ0FBbEYsS0FBa0YsQ0FBQTs7RUFDNUgsSUFBSSxXQUFXLENBQUMsWUFBaEIsRUFBOEI7SUFDNUIsV0FBVyxDQUFDLFlBQVosQ0FBeUIsc0JBQXpCLENBQWdELEtBQWhELENBQUEsQ0FBQTtHQUNEO0NBQ0Y7O0FBRU0sU0FBUyxZQUFULENBQWtCLEtBQWxCLEVBQXlDOztFQUFBLElBRXRDLFlBRnNDLEdBRXJCLEtBRnFCLENBRXRDLFlBRnNDLENBQUE7Ozs7Ozs7Ozs7OztFQWM5QyxZQUFZLENBQUMsU0FBYixDQUF1QixjQUF2QixHQUF3QyxjQUF4QyxDQUFBOztFQUVBLFlBQVksQ0FBQyxTQUFiLENBQXVCLHNCQUF2QixHQUFnRCxVQUFVLEtBQVYsRUFBaUI7SUFDL0QsT0FBTyxzQkFBc0IsQ0FBQyxJQUFELEVBQU8sS0FBUCxFQUFjLEtBQWQsQ0FBN0IsQ0FBQTtHQURGLENBaEI4Qzs7O0VBcUI5QyxLQUFLLENBQUMsWUFBTixDQUFtQixTQUFuQixDQUE2QixJQUE3QixDQUFrQztJQUNoQyxJQUFJLEVBQUUsV0FEMEI7SUFFaEMsUUFGZ0MsRUFBQSxTQUFBLFFBQUEsQ0FFdEIsS0FGc0IsRUFFZjtNQUNmLEtBQUEsSUFBQSxFQUFBLEdBQUEsQ0FBQSxFQUFBLEVBQUEsR0FBMEIsS0FBSyxDQUFDLFlBQU4sQ0FBbUIsSUFBN0MsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQW1EO1FBQUEsSUFBQSxLQUFBLENBQUE7O1FBQUEsS0FBQSxHQUF6QixLQUFLLENBQUMsWUFBTixDQUFtQixJQUFNLENBQUEsRUFBQSxDQUFBLENBQUE7UUFBQSxJQUF4QyxXQUF3QyxHQUFBLEtBQUEsQ0FBQTs7UUFDakQsSUFBSSxXQUFXLENBQUMsT0FBWixLQUNELFdBQVcsQ0FBQyxPQUFaLEtBQXdCLEtBQUssQ0FBQyxNQUE5QixJQUNBLENBQUEsQ0FBQSxFQUFBLGFBQUEsQ0FBQSxZQUFBLEVBQWEsV0FBVyxDQUFDLE9BQXpCLEVBQWtDLEtBQUssQ0FBQyxNQUF4QyxDQUZDLENBQUosRUFFcUQ7VUFDbkQsV0FBVyxDQUFDLFlBQVosQ0FBeUIsc0JBQXpCLENBQWdELEtBQWhELENBQUEsQ0FBQTtVQUNBLE9BQUE7U0FDRDtPQUNGO0tBQ0Y7R0FYSCxDQUFBLENBQUE7Q0FhRDs7b0JBRWM7RUFDYixFQUFFLEVBQUUsaUNBRFM7RUFFYixPQUFPLEVBQVAsWUFGYTtFQUdiLFNBQVMsRUFBRSxDQUFDLE1BQUQsRUFBUyxNQUFULEVBQWlCLElBQWpCLEVBQXVCLFFBQXZCLENBQUEsQ0FBaUMsTUFBakMsQ0FBd0MsVUFBQyxHQUFELEVBQU0sU0FBTixFQUFvQjtJQUNyRSxHQUFHLENBQUEsZUFBQSxDQUFBLE1BQUEsQ0FBaUIsU0FBakIsQ0FBQSxDQUFILEdBQW1DLGtCQUFuQyxDQUFBO0lBQ0EsT0FBTyxHQUFQLENBQUE7R0FGUyxFQUdSLEVBSFEsQ0FBQTs7Ozs7Ozs7Ozs7O0FDaEhiLElBQUEsZUFBQSxHQUFBLDBCQUFBLENBQUEsY0FBQSxDQUFBLENBQUE7O0FBR0EsSUFBQSxPQUFBLEdBQUEsMkJBQUEsQ0FBQSxRQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztJQUVNOzs7Ozs7RUFhSixTQUFBLFNBQUEsQ0FBYSxTQUFiLEVBQWdELFNBQWhELEVBQWtGLElBQWxGLEVBQWdHO0lBQUEsSUFBQSxLQUFBLENBQUE7O0lBQUEsbUJBQUEsQ0FBQSxJQUFBLEVBQUEsU0FBQSxDQUFBLENBQUE7O0lBQzlGLEtBQUEsR0FBQSw4QkFBQSxDQUFBLElBQUEsRUFBQSxtQkFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFBLElBQUEsQ0FBQSxJQUFBLEVBQU0sU0FBUyxDQUFDLFlBQWhCLENBQUEsQ0FBQSxDQUFBOztJQUQ4RixtQkFBQSxDQUFBLDBCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsUUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsbUJBQUEsQ0FBQSwwQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLFVBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG1CQUFBLENBQUEsMEJBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxXQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxtQkFBQSxDQUFBLDBCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsZUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsbUJBQUEsQ0FBQSwwQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLFdBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG1CQUFBLENBQUEsMEJBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxXQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxtQkFBQSxDQUFBLDBCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsb0JBQUEsRUFOM0UsS0FNMkUsQ0FBQSxDQUFBOztJQUFBLG1CQUFBLENBQUEsMEJBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSw2QkFBQSxFQUxsRSxLQUtrRSxDQUFBLENBQUE7O0lBQUEsSUFBQSxJQUFBLEdBR2hFLElBQUksS0FBSyxXQUFULEdBQzFCLFNBQVMsQ0FBQyxJQURnQixHQUUxQixTQUFTLENBQUMsR0FMZ0Y7UUFHdEYsT0FIc0YsR0FBQSxJQUFBLENBR3RGLE9BSHNGO1FBRzdFLFFBSDZFLEdBQUEsSUFBQSxDQUc3RSxRQUg2RSxDQUFBOztJQU85RixLQUFBLENBQUssSUFBTCxHQUFxQixJQUFyQixDQUFBO0lBQ0EsS0FBQSxDQUFLLE1BQUwsR0FBcUIsT0FBckIsQ0FBQTtJQUNBLEtBQUEsQ0FBSyxhQUFMLEdBQXFCLE9BQXJCLENBQUE7SUFDQSxLQUFBLENBQUssUUFBTCxHQUFxQixRQUFyQixDQUFBO0lBQ0EsS0FBQSxDQUFLLFNBQUwsR0FBcUIsU0FBckIsQ0FBQTtJQUNBLEtBQUEsQ0FBSyxhQUFMLEdBQXFCLFNBQVMsQ0FBQyxNQUEvQixDQUFBO0lBQ0EsS0FBQSxDQUFLLFNBQUwsR0FBcUIsU0FBUyxDQUFDLFlBQS9CLENBQUE7SUFDQSxLQUFBLENBQUssU0FBTCxHQUFxQixTQUFTLENBQUMsU0FBL0IsQ0FBQTtJQWQ4RixPQUFBLEtBQUEsQ0FBQTtHQWUvRjs7Ozs7Ozs7Ozs7OzZCQVNTO01BQUEsSUFBQSxNQUFBLEdBQUEsSUFBQSxDQUFBOztNQUFBLElBQ0EsU0FEQSxHQUNjLElBQUEsQ0FBSyxZQURuQixDQUNBLFNBREEsQ0FBQTs7TUFHUixJQUNHLElBQUEsQ0FBSyxJQUFMLEtBQWMsY0FBZixLQUNFLENBQUMsSUFBQSxDQUFLLFFBQU4sSUFDQSxTQUFTLENBQUMsR0FBVixDQUFjLFFBQWQsS0FBMkIsSUFBQSxDQUFLLFFBRGhDLElBRUEsU0FBUyxDQUFDLEdBQVYsQ0FBYyxPQUFkLEtBQTBCLElBQUEsQ0FBSyxNQUhqQyxDQURGLEVBSTRDO1FBQzFDLE9BQUE7T0FDRDs7TUFFRCxTQUFTLENBQUMsSUFBVixDQUFlLFFBQWYsR0FBMEIsSUFBQSxDQUFLLFFBQS9CLENBQUE7TUFDQSxTQUFTLENBQUMsSUFBVixDQUFlLE9BQWYsR0FBeUIsSUFBQSxDQUFLLE1BQTlCLENBQUE7TUFFQSxTQUFTLENBQUMsUUFBVixHQUFxQixJQUFyQixDQUFBO01BQ0EsU0FBUyxDQUFDLE1BQVYsQ0FBaUIsS0FBakIsR0FBeUIsSUFBekIsQ0FBQTtNQUVBLElBQUEsQ0FBSyx3QkFBTCxFQUFBLENBQUE7O01BRUEsSUFBSSxJQUFBLENBQUssSUFBTCxLQUFjLGNBQWxCLEVBQWtDO1FBQ2hDLElBQU0sV0FBVyxHQUFHLFNBQVMsQ0FBQyxXQUE5QixDQUFBO1FBQ0EsSUFBTSxLQUFLLEdBQUcsT0FBRyxDQUFDLFNBQUosQ0FBYyxXQUFkLEVBQTJCLFVBQUEsS0FBQSxFQUFBO1VBQUEsSUFBRyxRQUFILEdBQUEsS0FBQSxDQUFHLFFBQUg7Y0FBYSxPQUFiLEdBQUEsS0FBQSxDQUFhLE9BQWIsQ0FBQTtVQUFBLE9BQ3ZDLFFBQVEsS0FBSyxNQUFJLENBQUMsUUFBbEIsSUFBOEIsT0FBTyxLQUFLLE1BQUksQ0FBQyxNQURSLENBQUE7U0FBM0IsQ0FBZCxDQUFBO1FBR0EsU0FBUyxDQUFDLFdBQVYsQ0FBc0IsTUFBdEIsQ0FBNkIsS0FBN0IsRUFBb0MsQ0FBcEMsQ0FBQSxDQUFBO1FBRUEsSUFBTSxlQUFlLEdBQUcsSUFBSSxTQUFKLENBQWMsU0FBZCxFQUF5QixJQUFBLENBQUssU0FBOUIsRUFBeUMsZ0JBQXpDLENBQXhCLENBQUE7UUFFQSxlQUFlLENBQUMsUUFBaEIsR0FBMkIsSUFBQSxDQUFLLFFBQWhDLENBQUE7UUFDQSxlQUFlLENBQUMsTUFBaEIsR0FBeUIsSUFBQSxDQUFLLE1BQTlCLENBQUE7UUFFQSxJQUFBLENBQUssUUFBTCxDQUFjLElBQWQsQ0FBbUIsZUFBbkIsQ0FBQSxDQUFBO09BWkYsTUFjSztRQUNILElBQUEsQ0FBSyxRQUFMLENBQWMsSUFBZCxDQUFtQixJQUFJLFNBQUosQ0FBYyxTQUFkLEVBQXlCLElBQUEsQ0FBSyxTQUE5QixFQUF5QyxXQUF6QyxDQUFuQixDQUFBLENBQUE7T0FDRDtLQUNGOzs7cUNBRWlCLEVBQUU7OztzQ0FFRDtNQUNqQixJQUFBLENBQUssa0JBQUwsR0FBMEIsSUFBMUIsQ0FBQTtLQUNEOzs7K0NBRTJCO01BQzFCLElBQUEsQ0FBSywyQkFBTCxHQUFtQyxJQUFBLENBQUssa0JBQUwsR0FBMEIsSUFBN0QsQ0FBQTtLQUNEOzs7O0VBbkZxQixlQUFBLENBQUEsU0FBQTs7bUJBc0ZUOzs7Ozs7Ozs7Ozs7O0FDM0ZmLElBQUEsaUJBQUEsR0FBQSwwQkFBQSxDQUFBLHFCQUFBLENBQUEsQ0FBQTs7QUFFQSxJQUFBLFVBQUEsR0FBQSxjQUFBLENBQUE7O0FBQ0EsSUFBQSxTQUFBLEdBQUEsMkJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLEtBQUEsR0FBQSwwQkFBQSxDQUFBLFFBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsVUFBQSxHQUFBLDBCQUFBLENBQUEsYUFBQSxDQUFBLENBQUE7Ozs7Ozs7O0FBd0VBLFNBQVMsV0FBVCxDQUFrQixLQUFsQixFQUFnQztFQUFBLElBRTVCLE9BRjRCLEdBUTFCLEtBUjBCLENBRTVCLE9BRjRCO01BSTVCLFFBSjRCLEdBUTFCLEtBUjBCLENBSTVCLFFBSjRCO01BTTVCLFlBTjRCLEdBUTFCLEtBUjBCLENBTTVCLFlBTjRCO01BTzVCLFFBUDRCLEdBUTFCLEtBUjBCLENBTzVCLFFBUDRCLENBQUE7RUFVOUIsS0FBSyxDQUFDLFNBQU4sQ0FBZ0IsS0FBQSxDQUFBLFNBQUEsQ0FBaEIsQ0FBQSxDQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7RUEwQ0EsWUFBWSxDQUFDLFNBQWIsQ0FBdUIsUUFBdkIsR0FBa0MsVUFBdUMsT0FBdkMsRUFBcUY7SUFDckgsT0FBTyxjQUFjLENBQUMsSUFBRCxFQUFPLE9BQVAsQ0FBckIsQ0FBQTtHQURGLENBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7OztFQW1CQSxZQUFZLENBQUMsU0FBYixDQUF1QixTQUF2QixHQUFtQyxVQUF1QyxTQUF2QyxFQUFrRCxLQUFsRCxFQUF5RCxTQUF6RCxFQUFvRSxnQkFBcEUsRUFBc0YsV0FBdEYsRUFBbUcsSUFBbkcsRUFBeUc7SUFDMUksT0FBTyxlQUFlLENBQUMsSUFBRCxFQUFPLFNBQVAsRUFBa0IsS0FBbEIsRUFBeUIsU0FBekIsRUFBb0MsZ0JBQXBDLEVBQXNELFdBQXRELEVBQW1FLElBQW5FLENBQXRCLENBQUE7R0FERixDQUFBOzs7Ozs7Ozs7OztFQVlBLFFBQVEsQ0FBQyxXQUFULEdBQXVCLFVBQVUsUUFBVixFQUE4QjtJQUNuRCxJQUFJLFNBQUssQ0FBQyxFQUFOLENBQVMsSUFBVCxDQUFjLFFBQWQsQ0FBSixFQUE2Qjs7OztNQUszQixLQUFLLENBQUMsV0FBTixHQUFvQixRQUFwQixDQUFBO01BRUEsT0FBTyxRQUFQLENBQUE7S0FDRDs7SUFDRCxPQUFPLEtBQUssQ0FBQyxXQUFiLENBQUE7R0FWRixDQUFBOztFQWFBLFNBQUssQ0FBQyxNQUFOLENBQWEsT0FBTyxDQUFDLGNBQXJCLEVBQXFDO0lBQ25DLFNBQVMsRUFBRSxJQUR3QjtJQUVuQyxTQUFTLEVBQUUsSUFGd0I7SUFHbkMsWUFBWSxFQUFFLElBSHFCO0lBSW5DLGNBQWMsRUFBRSxJQUptQjtJQUtuQyxRQUFRLEVBQUUsSUFMeUI7SUFNbkMsSUFBSSxFQUFFLElBQUE7R0FOUixDQUFBLENBQUE7RUFRQSxPQUFPLENBQUMsVUFBUixDQUFtQixJQUFuQixHQUEwQixVQUExQixDQUFBO0VBRUEsS0FBSyxDQUFDLFdBQU4sR0FBb0IsS0FBcEIsQ0FBQTtFQUVBLFFBQVEsQ0FBQyxPQUFULENBQWlCLElBQWpCLEdBQXdCLElBQUksQ0FBQyxRQUE3QixDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxZQUFULENBQUEsSUFBQSxFQUEwQyxnQkFBMUMsRUFBNEQ7RUFBQSxJQUFuQyxhQUFtQyxHQUFBLElBQUEsQ0FBbkMsYUFBbUMsQ0FBQTtFQUMxRCxJQUFNLEtBQUssR0FBRyxFQUFkLENBRDBEOztFQUkxRCxLQUFBLElBQUEsRUFBQSxHQUFBLENBQUEsRUFBQSxFQUFBLEdBQXVCLGFBQWEsQ0FBQyxJQUFyQyxDQUFBLE1BQUEsRUFBQSxFQUFBLEVBQUEsRUFBMkM7SUFBQSxJQUFBLEtBQUEsQ0FBQTs7SUFBQSxLQUFBLEdBQXBCLGFBQWEsQ0FBQyxJQUFNLENBQUEsRUFBQSxDQUFBLENBQUE7SUFBQSxJQUFoQyxRQUFnQyxHQUFBLEtBQUEsQ0FBQTs7SUFDekMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFULENBQWlCLElBQWpCLENBQXNCLE9BQTNCLEVBQW9DO01BQUUsU0FBQTtLQUFVOztJQUVoRCxJQUFNLE1BQU0sR0FBRyxRQUFRLENBQUMsT0FBVCxDQUFpQixJQUFqQixDQUFzQixNQUFyQyxDQUh5Qzs7SUFNekMsSUFBSyxTQUFLLENBQUMsRUFBTixDQUFTLE9BQVQsQ0FBaUIsTUFBakIsQ0FBQSxJQUE0QixNQUFNLEtBQUssZ0JBQXhDLElBQ0MsU0FBSyxDQUFDLEVBQU4sQ0FBUyxNQUFULENBQWdCLE1BQWhCLENBQUEsSUFDRCxDQUFDLFNBQUssQ0FBQyxHQUFOLENBQVUsZUFBVixDQUEwQixnQkFBMUIsRUFBNEMsTUFBNUMsQ0FGRCxJQUdDLFNBQUssQ0FBQyxFQUFOLENBQVMsSUFBVCxDQUFjLE1BQWQsQ0FBQSxJQUF5QixDQUFDLE1BQU0sQ0FBQztNQUFFLFFBQVEsRUFBUixRQUFGO01BQVksZ0JBQWdCLEVBQWhCLGdCQUFBO0tBQWIsQ0FIckMsRUFHd0U7TUFDdEUsU0FBQTtLQVZ1Qzs7O0lBY3pDLElBQU0sWUFBWSxHQUFHLFNBQUssQ0FBQyxFQUFOLENBQVMsTUFBVCxDQUFnQixRQUFRLENBQUMsTUFBekIsQ0FBQSxHQUNqQixRQUFRLENBQUMsUUFBVCxDQUFrQixnQkFBbEIsQ0FBbUMsUUFBUSxDQUFDLE1BQTVDLENBRGlCLEdBRWpCLFNBQUssQ0FBQyxFQUFOLENBQVMsS0FBVCxDQUFlLFFBQVEsQ0FBQyxNQUF4QixDQUFBLEdBQWtDLFFBQVEsQ0FBQyxNQUEzQyxHQUFvRCxDQUFDLFFBQVEsQ0FBQyxNQUFWLENBRnhELENBQUE7O0lBSUEsS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUE4QixZQUE5QixDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBNEM7TUFBQSxJQUFBLEtBQUEsQ0FBQTs7TUFBQSxLQUFBLEdBQWQsWUFBYyxDQUFBLEdBQUEsQ0FBQSxDQUFBO01BQUEsSUFBakMsZUFBaUMsR0FBQSxLQUFBLENBQUE7O01BQzFDLElBQUksZUFBZSxLQUFLLGdCQUF4QixFQUEwQztRQUN4QyxLQUFLLENBQUMsSUFBTixDQUFXO1VBQ1QsUUFBUSxFQUFSLFFBRFM7VUFFVCxPQUFPLEVBQUUsZUFBQTtTQUZYLENBQUEsQ0FBQTtPQUlEO0tBQ0Y7R0FDRjs7RUFFRCxPQUFPLEtBQVAsQ0FBQTtDQUNEOztBQUVELFNBQVMsb0JBQVQsQ0FBK0IsV0FBL0IsRUFBNEMsS0FBNUMsRUFBbUQ7O0VBRWpELEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBb0MsV0FBVyxDQUFDLEtBQVosRUFBcEMsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQXlEO0lBQUEsSUFBQSxLQUFBLENBQUE7O0lBQUEsS0FBQSxHQUFyQixXQUFXLENBQUMsS0FBWixFQUFxQixDQUFBLEdBQUEsQ0FBQSxDQUFBO0lBQUEsSUFBQSxLQUFBLEdBQUEsS0FBQTtRQUE1QyxRQUE0QyxHQUFBLEtBQUEsQ0FBNUMsUUFBNEM7UUFBbEMsT0FBa0MsR0FBQSxLQUFBLENBQWxDLE9BQWtDLENBQUE7SUFDdkQsS0FBSyxDQUFDLFFBQU4sR0FBaUIsUUFBakIsQ0FEdUQ7O0lBSXZELEtBQUssQ0FBQyxNQUFOLEdBQWUsT0FBZixDQUFBO0lBQ0EsUUFBUSxDQUFDLElBQVQsQ0FBYyxLQUFkLENBQUEsQ0FBQTtJQUNBLEtBQUssQ0FBQyxrQkFBTixHQUEyQixLQUFLLENBQUMsMkJBQU4sR0FBb0MsS0FBL0QsQ0FBQTtHQUNEOzs7Ozs7QUFNSCxTQUFTLGNBQVQsQ0FBeUIsS0FBekIsRUFBdUMsV0FBdkMsRUFBc0U7O0VBRXBFLElBQU0sV0FBVyxHQUFHLFlBQVksQ0FBQyxLQUFELEVBQVEsV0FBUixDQUFoQyxDQUFBOztFQUVBLEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBeUIsV0FBekIsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQXNDO0lBQUEsSUFBQSxLQUFBLENBQUE7O0lBQUEsS0FBQSxHQUFiLFdBQWEsQ0FBQSxHQUFBLENBQUEsQ0FBQTtJQUFBLElBQTNCLFVBQTJCLEdBQUEsS0FBQSxDQUFBO0lBQ3BDLFVBQVUsQ0FBQyxJQUFYLEdBQWtCLFVBQVUsQ0FBQyxRQUFYLENBQW9CLE9BQXBCLENBQTRCLFVBQVUsQ0FBQyxPQUF2QyxDQUFsQixDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxXQUFQLENBQUE7Q0FDRDs7QUFFRCxTQUFTLE9BQVQsQ0FBQSxLQUFBLEVBQStHLFNBQS9HLEVBQTBILFlBQTFILEVBQXdJO0VBQUEsSUFBcEgsU0FBb0gsR0FBQSxLQUFBLENBQXBILFNBQW9IO01BQTNGLFNBQTJGLEdBQUEsS0FBQSxDQUF6RyxZQUF5RztNQUF2RSxXQUF1RSxHQUFBLEtBQUEsQ0FBaEYsT0FBZ0YsQ0FBQTtFQUN0SSxJQUFNLFVBQVUsR0FBRyxFQUFuQixDQURzSTs7RUFJdEksS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUEyRCxTQUFTLENBQUMsV0FBckUsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQWtGO0lBQUEsSUFBQSxLQUFBLENBQUE7O0lBQUEsS0FBQSxHQUF2QixTQUFTLENBQUMsV0FBYSxDQUFBLEdBQUEsQ0FBQSxDQUFBO0lBQUEsSUFBQSxLQUFBLEdBQUEsS0FBQTtRQUFyRSxRQUFxRSxHQUFBLEtBQUEsQ0FBckUsUUFBcUU7UUFBbEQsZUFBa0QsR0FBQSxLQUFBLENBQTNELE9BQTJEO1FBQWpDLEtBQWlDLEdBQUEsS0FBQSxDQUFqQyxJQUFpQyxDQUFBO0lBQ2hGLFVBQVUsQ0FBQyxJQUFYLENBQWdCLFFBQVEsQ0FBQyxTQUFULENBQW1CLFNBQW5CLEVBQThCLFlBQTlCLEVBQTRDLFNBQTVDLEVBQXVELFdBQXZELEVBQW9FLGVBQXBFLEVBQXFGLEtBQXJGLENBQUEsR0FDWixlQURZLEdBRVosSUFGSixDQUFBLENBQUE7R0FMb0k7OztFQVd0SSxJQUFNLFNBQVMsR0FBRyxTQUFLLENBQUMsR0FBTixDQUFVLHFCQUFWLENBQWdDLFVBQWhDLENBQWxCLENBQUE7RUFFQSxPQUFPLFNBQVMsQ0FBQyxXQUFWLENBQXNCLFNBQXRCLENBQUEsSUFBb0MsSUFBM0MsQ0FBQTtDQUNEOztBQUVELFNBQVMsYUFBVCxDQUF3QixXQUF4QixFQUEyRCxhQUEzRCxFQUEwRSxTQUExRSxFQUFxRjtFQUFBLElBQzNFLFNBRDJFLEdBQzdELFdBRDZELENBQzNFLFNBRDJFLENBQUE7RUFFbkYsSUFBTSxVQUFVLEdBQUc7SUFDakIsS0FBSyxFQUFPLElBREs7SUFFakIsS0FBSyxFQUFPLElBRks7SUFHakIsUUFBUSxFQUFJLElBSEs7SUFJakIsVUFBVSxFQUFFLElBSks7SUFLakIsSUFBSSxFQUFRLElBTEs7SUFNakIsSUFBSSxFQUFRLElBQUE7R0FOZCxDQUFBOztFQVNBLElBQUksU0FBUyxDQUFDLElBQVYsS0FBbUIsV0FBdkIsRUFBb0M7SUFDbEMsVUFBVSxDQUFDLFFBQVgsR0FBc0IsSUFBSSxVQUFBLENBQUEsU0FBQSxDQUFKLENBQWMsU0FBZCxFQUF5QixTQUF6QixFQUFvQyxjQUFwQyxDQUF0QixDQUFBO0lBRUEsVUFBVSxDQUFDLFFBQVgsQ0FBb0IsTUFBcEIsR0FBK0IsSUFBL0IsQ0FBQTtJQUNBLFVBQVUsQ0FBQyxRQUFYLENBQW9CLFFBQXBCLEdBQStCLElBQS9CLENBQUE7R0FDRDs7RUFDRCxJQUFJLFNBQVMsQ0FBQyxJQUFWLEtBQW1CLFNBQXZCLEVBQWtDO0lBQ2hDLFVBQVUsQ0FBQyxVQUFYLEdBQXdCLElBQUksVUFBQSxDQUFBLFNBQUEsQ0FBSixDQUFjLFNBQWQsRUFBeUIsU0FBekIsRUFBb0MsZ0JBQXBDLENBQXhCLENBQUE7SUFFQSxVQUFVLENBQUMsVUFBWCxDQUFzQixNQUF0QixHQUFpQyxJQUFqQyxDQUFBO0lBQ0EsVUFBVSxDQUFDLFVBQVgsQ0FBc0IsUUFBdEIsR0FBaUMsSUFBakMsQ0FBQTtHQUNEOztFQUVELElBQUksU0FBUyxDQUFDLFFBQWQsRUFBd0I7SUFDdEIsT0FBTyxVQUFQLENBQUE7R0FDRDs7RUFFRCxJQUFJLFNBQVMsQ0FBQyxHQUFWLENBQWMsT0FBZCxLQUEwQixTQUFTLENBQUMsSUFBVixDQUFlLE9BQTdDLEVBQXNEOztJQUVwRCxJQUFJLFNBQVMsQ0FBQyxJQUFWLENBQWUsUUFBbkIsRUFBNkI7TUFDM0IsVUFBVSxDQUFDLEtBQVgsR0FBbUIsSUFBSSxVQUFBLENBQUEsU0FBQSxDQUFKLENBQWMsU0FBZCxFQUF5QixTQUF6QixFQUFvQyxXQUFwQyxDQUFuQixDQUFBO01BRUEsU0FBUyxDQUFDLFNBQVYsR0FBeUIsVUFBVSxDQUFDLEtBQVgsQ0FBaUIsTUFBakIsR0FBNEIsU0FBUyxDQUFDLElBQVYsQ0FBZSxPQUFwRSxDQUFBO01BQ0EsU0FBUyxDQUFDLFlBQVYsR0FBeUIsVUFBVSxDQUFDLEtBQVgsQ0FBaUIsUUFBakIsR0FBNEIsU0FBUyxDQUFDLElBQVYsQ0FBZSxRQUFwRSxDQUFBO0tBTmtEOzs7SUFTcEQsSUFBSSxTQUFTLENBQUMsR0FBVixDQUFjLFFBQWxCLEVBQTRCO01BQzFCLFVBQVUsQ0FBQyxLQUFYLEdBQW1CLElBQUksVUFBQSxDQUFBLFNBQUEsQ0FBSixDQUFjLFNBQWQsRUFBeUIsU0FBekIsRUFBb0MsV0FBcEMsQ0FBbkIsQ0FBQTtNQUVBLFNBQVMsQ0FBQyxTQUFWLEdBQXNCLFNBQVMsQ0FBQyxHQUFWLENBQWMsT0FBcEMsQ0FBQTtNQUNBLFNBQVMsQ0FBQyxRQUFWLEdBQXFCLFNBQVMsQ0FBQyxHQUFWLENBQWMsUUFBbkMsQ0FBQTtLQUNEO0dBQ0Y7O0VBRUQsSUFBSSxTQUFTLENBQUMsSUFBVixLQUFtQixTQUFuQixJQUFnQyxTQUFTLENBQUMsR0FBVixDQUFjLFFBQWxELEVBQTREO0lBQzFELFVBQVUsQ0FBQyxJQUFYLEdBQWtCLElBQUksVUFBQSxDQUFBLFNBQUEsQ0FBSixDQUFjLFNBQWQsRUFBeUIsU0FBekIsRUFBb0MsTUFBcEMsQ0FBbEIsQ0FBQTtJQUVBLFNBQVMsQ0FBQyxRQUFWLEdBQXFCLFNBQVMsQ0FBQyxHQUFWLENBQWMsUUFBbkMsQ0FBQTtJQUNBLFNBQVMsQ0FBQyxhQUFWLEdBQTBCLFNBQVMsQ0FBQyxHQUFWLENBQWMsT0FBeEMsQ0FBQTtHQUNEOztFQUNELElBQUksU0FBUyxDQUFDLElBQVYsS0FBbUIsVUFBbkIsSUFBaUMsU0FBUyxDQUFDLEdBQVYsQ0FBYyxRQUFuRCxFQUE2RDtJQUMzRCxVQUFVLENBQUMsSUFBWCxHQUFrQixJQUFJLFVBQUEsQ0FBQSxTQUFBLENBQUosQ0FBYyxTQUFkLEVBQXlCLFNBQXpCLEVBQW9DLFVBQXBDLENBQWxCLENBQUE7SUFFQSxVQUFVLENBQUMsSUFBWCxDQUFnQixRQUFoQixHQUEyQixTQUEzQixDQUFBO0lBQ0EsU0FBUyxDQUFDLFFBQVYsR0FBcUIsU0FBUyxDQUFDLEdBQVYsQ0FBYyxRQUFuQyxDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxVQUFQLENBQUE7Q0FDRDs7QUFFRCxTQUFTLGNBQVQsQ0FBeUIsV0FBekIsRUFBNEQsTUFBNUQsRUFBb0U7RUFBQSxJQUMxRCxTQUQwRCxHQUM1QyxXQUQ0QyxDQUMxRCxTQUQwRCxDQUFBO0VBQUEsSUFHaEUsV0FIZ0UsR0FNOUQsU0FOOEQsQ0FHaEUsV0FIZ0U7TUFJaEUsR0FKZ0UsR0FNOUQsU0FOOEQsQ0FJaEUsR0FKZ0U7TUFLaEUsSUFMZ0UsR0FNOUQsU0FOOEQsQ0FLaEUsSUFMZ0UsQ0FBQTs7RUFRbEUsSUFBSSxNQUFNLENBQUMsS0FBWCxFQUFrQjtJQUFFLElBQUksQ0FBQyxRQUFMLENBQWMsSUFBZCxDQUFtQixNQUFNLENBQUMsS0FBMUIsQ0FBQSxDQUFBO0dBQWtDOztFQUN0RCxJQUFJLE1BQU0sQ0FBQyxJQUFYLEVBQWlCO0lBQUUsR0FBRyxDQUFDLFFBQUosQ0FBYSxJQUFiLENBQWtCLE1BQU0sQ0FBQyxJQUF6QixDQUFBLENBQUE7R0FBZ0M7O0VBQ25ELElBQUksTUFBTSxDQUFDLEtBQVgsRUFBa0I7SUFBRSxHQUFHLENBQUMsUUFBSixDQUFhLElBQWIsQ0FBa0IsTUFBTSxDQUFDLEtBQXpCLENBQUEsQ0FBQTtHQUFpQzs7RUFDckQsSUFBSSxNQUFNLENBQUMsSUFBWCxFQUFpQjtJQUFFLEdBQUcsQ0FBQyxRQUFKLENBQWEsSUFBYixDQUFrQixNQUFNLENBQUMsSUFBekIsQ0FBQSxDQUFBO0dBQWdDOztFQUVuRCxJQUFJLE1BQU0sQ0FBQyxVQUFYLEVBQXVCO0lBQ3JCLG9CQUFvQixDQUFDLFdBQUQsRUFBYyxNQUFNLENBQUMsVUFBckIsQ0FBcEIsQ0FBQTtHQUNEOztFQUVELFNBQVMsQ0FBQyxJQUFWLENBQWUsUUFBZixHQUEyQixHQUFHLENBQUMsUUFBL0IsQ0FBQTtFQUNBLFNBQVMsQ0FBQyxJQUFWLENBQWUsT0FBZixHQUF5QixHQUFHLENBQUMsT0FBN0IsQ0FBQTtDQUNEOztBQUVELFNBQVMsY0FBVCxDQUFBLE1BQUEsRUFBMkcsS0FBM0csRUFBa0g7RUFBQSxJQUF2RixXQUF1RixHQUFBLE1BQUEsQ0FBdkYsV0FBdUY7TUFBMUUsTUFBMEUsR0FBQSxNQUFBLENBQTFFLE1BQTBFO01BQWxFLEtBQWtFLEdBQUEsTUFBQSxDQUFsRSxLQUFrRSxDQUFBOztFQUNoSCxJQUFJLE1BQU0sQ0FBQyxJQUFQLEtBQWdCLFVBQWhCLElBQThCLE1BQU0sQ0FBQyxJQUFQLEtBQWdCLFNBQWxELEVBQTZEO0lBQUUsT0FBQTtHQUFROztFQUR5QyxJQUd4RyxTQUh3RyxHQUcxRixXQUgwRixDQUd4RyxTQUh3RyxDQUFBOztFQUtoSCxJQUFJLEtBQUssQ0FBQyxXQUFWLEVBQXVCO0lBQ3JCLFNBQVMsQ0FBQyxXQUFWLEdBQXdCLGNBQWMsQ0FBQyxLQUFELEVBQVEsV0FBVyxDQUFDLE9BQXBCLENBQXRDLENBQUE7R0FDRDs7RUFFRCxJQUFNLFNBQVMsR0FBRyxNQUFsQixDQUFBO0VBQ0EsSUFBTSxVQUFVLEdBQUcsT0FBTyxDQUFDLFdBQUQsRUFBYyxTQUFkLEVBQXlCLEtBQXpCLENBQTFCLENBVmdIOztFQWFoSCxTQUFTLENBQUMsUUFBVixHQUFxQixTQUFTLENBQUMsUUFBVixJQUNuQixDQUFDLENBQUMsVUFEaUIsSUFFbkIsVUFBVSxDQUFDLFFBQVgsS0FBd0IsU0FBUyxDQUFDLEdBQVYsQ0FBYyxRQUZuQixJQUduQixVQUFVLENBQUMsT0FBWCxLQUF1QixTQUFTLENBQUMsR0FBVixDQUFjLE9BSHZDLENBQUE7RUFLQSxTQUFTLENBQUMsR0FBVixDQUFjLFFBQWQsR0FBMEIsVUFBVSxJQUFJLFVBQVUsQ0FBQyxRQUFuRCxDQUFBO0VBQ0EsU0FBUyxDQUFDLEdBQVYsQ0FBYyxPQUFkLEdBQXdCLFVBQVUsSUFBSSxVQUFVLENBQUMsT0FBakQsQ0FBQTtFQUVBLFNBQVMsQ0FBQyxNQUFWLEdBQW1CLGFBQWEsQ0FBQyxXQUFELEVBQWMsS0FBZCxFQUFxQixTQUFyQixDQUFoQyxDQUFBO0NBQ0Q7O0FBSUQsU0FBUyxjQUFULENBQXlCLFlBQXpCLEVBQThELE9BQTlELEVBQTRHO0VBQzFHLElBQUksU0FBSyxDQUFDLEVBQU4sQ0FBUyxNQUFULENBQWdCLE9BQWhCLENBQUosRUFBOEI7SUFDNUIsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsSUFBckIsQ0FBMEIsT0FBMUIsR0FBb0MsT0FBTyxDQUFDLE9BQVIsS0FBb0IsS0FBeEQsQ0FBQTs7SUFFQSxJQUFJLE9BQU8sQ0FBQyxTQUFaLEVBQXVCO01BQ3JCLElBQU0sVUFBVSxHQUFHLFNBQUssQ0FBQyxrQkFBTixDQUF5QixPQUFPLENBQUMsU0FBakMsQ0FBbkIsQ0FEcUI7O01BR3JCLElBQU0sU0FBUyxHQUFHLE1BQU0sQ0FBQyxJQUFQLENBQVksVUFBWixDQUFBLENBQXdCLE1BQXhCLENBQStCLFVBQUMsR0FBRCxFQUFNLElBQU4sRUFBZTtRQUM5RCxJQUFNLGFBQWEsR0FBRyxnQkFBQSxDQUFpQixJQUFqQixDQUFzQixJQUF0QixDQUFBLEdBQUEsTUFBQSxDQUFBLE1BQUEsQ0FDWCxJQURXLENBQUEsR0FFbEIsNkJBQUEsQ0FBOEIsSUFBOUIsQ0FBbUMsSUFBbkMsQ0FBQSxHQUFBLE1BQUEsQ0FBQSxNQUFBLENBQ1MsSUFEVCxDQUFBLEdBRUUsSUFKTixDQUFBO1FBTUEsR0FBRyxDQUFDLGFBQUQsQ0FBSCxHQUFxQixVQUFVLENBQUMsSUFBRCxDQUEvQixDQUFBO1FBRUEsT0FBTyxHQUFQLENBQUE7T0FUZ0IsRUFVZixFQVZlLENBQWxCLENBQUE7TUFZQSxZQUFZLENBQUMsR0FBYixDQUFpQixZQUFZLENBQUMsT0FBYixDQUFxQixJQUFyQixDQUEwQixTQUEzQyxDQUFBLENBQUE7TUFDQSxZQUFZLENBQUMsRUFBYixDQUFnQixTQUFoQixDQUFBLENBQUE7TUFDQSxZQUFZLENBQUMsT0FBYixDQUFxQixJQUFyQixDQUEwQixTQUExQixHQUFzQyxTQUF0QyxDQUFBO0tBQ0Q7O0lBRUQsSUFBSSxTQUFLLENBQUMsRUFBTixDQUFTLElBQVQsQ0FBYyxPQUFPLENBQUMsTUFBdEIsQ0FBSixFQUFtQztNQUFFLFlBQVksQ0FBQyxFQUFiLENBQWdCLE1BQWhCLEVBQXdCLE9BQU8sQ0FBQyxNQUFoQyxDQUFBLENBQUE7S0FBeUM7O0lBQzlFLElBQUksU0FBSyxDQUFDLEVBQU4sQ0FBUyxJQUFULENBQWMsT0FBTyxDQUFDLGNBQXRCLENBQUosRUFBMkM7TUFBRSxZQUFZLENBQUMsRUFBYixDQUFnQixjQUFoQixFQUFnQyxPQUFPLENBQUMsY0FBeEMsQ0FBQSxDQUFBO0tBQXlEOztJQUN0RyxJQUFJLFNBQUssQ0FBQyxFQUFOLENBQVMsSUFBVCxDQUFjLE9BQU8sQ0FBQyxnQkFBdEIsQ0FBSixFQUE2QztNQUFFLFlBQVksQ0FBQyxFQUFiLENBQWdCLGdCQUFoQixFQUFrQyxPQUFPLENBQUMsZ0JBQTFDLENBQUEsQ0FBQTtLQUE2RDs7SUFDNUcsSUFBSSxTQUFLLENBQUMsRUFBTixDQUFTLElBQVQsQ0FBYyxPQUFPLENBQUMsV0FBdEIsQ0FBSixFQUF3QztNQUFFLFlBQVksQ0FBQyxFQUFiLENBQWdCLFdBQWhCLEVBQTZCLE9BQU8sQ0FBQyxXQUFyQyxDQUFBLENBQUE7S0FBbUQ7O0lBQzdGLElBQUksU0FBSyxDQUFDLEVBQU4sQ0FBUyxJQUFULENBQWMsT0FBTyxDQUFDLFdBQXRCLENBQUosRUFBd0M7TUFBRSxZQUFZLENBQUMsRUFBYixDQUFnQixXQUFoQixFQUE2QixPQUFPLENBQUMsV0FBckMsQ0FBQSxDQUFBO0tBQW1EOztJQUM3RixJQUFJLFNBQUssQ0FBQyxFQUFOLENBQVMsSUFBVCxDQUFjLE9BQU8sQ0FBQyxVQUF0QixDQUFKLEVBQXVDO01BQUUsWUFBWSxDQUFDLEVBQWIsQ0FBZ0IsVUFBaEIsRUFBNEIsT0FBTyxDQUFDLFVBQXBDLENBQUEsQ0FBQTtLQUFpRDs7SUFFMUYsSUFBSSxvQkFBQSxDQUFxQixJQUFyQixDQUEwQixPQUFPLENBQUMsT0FBbEMsQ0FBSixFQUEwRDtNQUN4RCxZQUFZLENBQUMsT0FBYixDQUFxQixJQUFyQixDQUEwQixPQUExQixHQUFvQyxPQUFPLENBQUMsT0FBNUMsQ0FBQTtLQURGLE1BR0ssSUFBSSxTQUFLLENBQUMsRUFBTixDQUFTLE1BQVQsQ0FBZ0IsT0FBTyxDQUFDLE9BQXhCLENBQUosRUFBc0M7TUFDekMsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsSUFBckIsQ0FBMEIsT0FBMUIsR0FBb0MsSUFBSSxDQUFDLEdBQUwsQ0FBUyxJQUFJLENBQUMsR0FBTCxDQUFTLENBQVQsRUFBWSxPQUFPLENBQUMsT0FBcEIsQ0FBVCxFQUF1QyxDQUF2QyxDQUFwQyxDQUFBO0tBQ0Q7O0lBQ0QsSUFBSSxRQUFBLElBQVksT0FBaEIsRUFBeUI7TUFDdkIsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsSUFBckIsQ0FBMEIsTUFBMUIsR0FBbUMsT0FBTyxDQUFDLE1BQTNDLENBQUE7S0FDRDs7SUFDRCxJQUFJLFNBQUEsSUFBYSxPQUFqQixFQUEwQjtNQUN4QixZQUFZLENBQUMsT0FBYixDQUFxQixJQUFyQixDQUEwQixPQUExQixHQUFvQyxPQUFPLENBQUMsT0FBNUMsQ0FBQTtLQUNEOztJQUVELE9BQU8sWUFBUCxDQUFBO0dBQ0Q7O0VBRUQsSUFBSSxTQUFLLENBQUMsRUFBTixDQUFTLElBQVQsQ0FBYyxPQUFkLENBQUosRUFBNEI7SUFDMUIsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsSUFBckIsQ0FBMEIsT0FBMUIsR0FBb0MsT0FBcEMsQ0FBQTtJQUVBLE9BQU8sWUFBUCxDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxZQUFZLENBQUMsT0FBYixDQUFxQixJQUE1QixDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxlQUFULENBQ0UsWUFERixFQUVFLFNBRkYsRUFHRSxLQUhGLEVBSUUsU0FKRixFQUtFLGdCQUxGLEVBTUUsV0FORixFQU9FLElBUEYsRUFRRTtFQUNBLElBQUksT0FBTyxHQUFHLEtBQWQsQ0FEQTs7O0VBS0EsSUFBSSxFQUFFLElBQUksR0FBRyxJQUFJLElBQUksWUFBWSxDQUFDLE9BQWIsQ0FBcUIsV0FBckIsQ0FBakIsQ0FBSixFQUF5RDtJQUN2RCxPQUFRLFlBQVksQ0FBQyxPQUFiLENBQXFCLElBQXJCLENBQTBCLE9BQTFCLEdBQ0osWUFBWSxDQUFDLE9BQWIsQ0FBcUIsSUFBckIsQ0FBMEIsT0FBMUIsQ0FBa0MsU0FBbEMsRUFBNkMsS0FBN0MsRUFBb0QsT0FBcEQsRUFBNkQsWUFBN0QsRUFBMkUsV0FBM0UsRUFBd0YsU0FBeEYsRUFBbUcsZ0JBQW5HLENBREksR0FFSixLQUZKLENBQUE7R0FHRDs7RUFFRCxJQUFNLFdBQVcsR0FBRyxZQUFZLENBQUMsT0FBYixDQUFxQixJQUFyQixDQUEwQixPQUE5QyxDQUFBOztFQUVBLElBQUksV0FBVyxLQUFLLFNBQXBCLEVBQStCO0lBQzdCLElBQU0sTUFBTSxHQUFHLFNBQUssQ0FBQyxXQUFOLENBQWtCLFNBQWxCLEVBQTZCLGdCQUE3QixFQUErQyxNQUEvQyxDQUFmLENBQUE7SUFDQSxJQUFNLElBQUksR0FBRyxTQUFLLENBQUMsT0FBTixDQUFjLFNBQWQsQ0FBd0IsU0FBeEIsQ0FBYixDQUFBO0lBRUEsSUFBSSxDQUFDLENBQUwsSUFBVSxNQUFNLENBQUMsQ0FBakIsQ0FBQTtJQUNBLElBQUksQ0FBQyxDQUFMLElBQVUsTUFBTSxDQUFDLENBQWpCLENBQUE7SUFFQSxJQUFNLFVBQVUsR0FBSSxJQUFJLENBQUMsQ0FBTCxHQUFTLElBQUksQ0FBQyxJQUFmLElBQXlCLElBQUksQ0FBQyxDQUFMLEdBQVMsSUFBSSxDQUFDLEtBQTFELENBQUE7SUFDQSxJQUFNLFFBQVEsR0FBTSxJQUFJLENBQUMsQ0FBTCxHQUFTLElBQUksQ0FBQyxHQUFmLElBQXdCLElBQUksQ0FBQyxDQUFMLEdBQVMsSUFBSSxDQUFDLE1BQXpELENBQUE7SUFFQSxPQUFPLEdBQUcsVUFBVSxJQUFJLFFBQXhCLENBQUE7R0FDRDs7RUFFRCxJQUFNLFFBQVEsR0FBRyxTQUFTLENBQUMsT0FBVixDQUFrQixnQkFBbEIsQ0FBakIsQ0FBQTs7RUFFQSxJQUFJLFFBQVEsSUFBSSxXQUFXLEtBQUssUUFBaEMsRUFBMEM7SUFDeEMsSUFBTSxFQUFFLEdBQUcsUUFBUSxDQUFDLElBQVQsR0FBZ0IsUUFBUSxDQUFDLEtBQVQsR0FBa0IsQ0FBN0MsQ0FBQTtJQUNBLElBQU0sRUFBRSxHQUFHLFFBQVEsQ0FBQyxHQUFULEdBQWdCLFFBQVEsQ0FBQyxNQUFULEdBQWtCLENBQTdDLENBQUE7SUFFQSxPQUFPLEdBQUcsRUFBRSxJQUFJLElBQUksQ0FBQyxJQUFYLElBQW1CLEVBQUUsSUFBSSxJQUFJLENBQUMsS0FBOUIsSUFBdUMsRUFBRSxJQUFJLElBQUksQ0FBQyxHQUFsRCxJQUF5RCxFQUFFLElBQUksSUFBSSxDQUFDLE1BQTlFLENBQUE7R0FDRDs7RUFFRCxJQUFJLFFBQVEsSUFBSSxTQUFLLENBQUMsRUFBTixDQUFTLE1BQVQsQ0FBZ0IsV0FBaEIsQ0FBaEIsRUFBOEM7SUFDNUMsSUFBTSxXQUFXLEdBQUssSUFBSSxDQUFDLEdBQUwsQ0FBUyxDQUFULEVBQVksSUFBSSxDQUFDLEdBQUwsQ0FBUyxJQUFJLENBQUMsS0FBZCxFQUFxQixRQUFRLENBQUMsS0FBOUIsQ0FBQSxHQUF1QyxJQUFJLENBQUMsR0FBTCxDQUFTLElBQUksQ0FBQyxJQUFkLEVBQW9CLFFBQVEsQ0FBQyxJQUE3QixDQUFuRCxDQUFBLEdBQ0EsSUFBSSxDQUFDLEdBQUwsQ0FBUyxDQUFULEVBQVksSUFBSSxDQUFDLEdBQUwsQ0FBUyxJQUFJLENBQUMsTUFBZCxFQUFzQixRQUFRLENBQUMsTUFBL0IsQ0FBQSxHQUF5QyxJQUFJLENBQUMsR0FBTCxDQUFTLElBQUksQ0FBQyxHQUFkLEVBQW1CLFFBQVEsQ0FBQyxHQUE1QixDQUFyRCxDQUR0QixDQUFBO0lBR0EsSUFBTSxZQUFZLEdBQUcsV0FBVyxJQUFJLFFBQVEsQ0FBQyxLQUFULEdBQWlCLFFBQVEsQ0FBQyxNQUE5QixDQUFoQyxDQUFBO0lBRUEsT0FBTyxHQUFHLFlBQVksSUFBSSxXQUExQixDQUFBO0dBQ0Q7O0VBRUQsSUFBSSxZQUFZLENBQUMsT0FBYixDQUFxQixJQUFyQixDQUEwQixPQUE5QixFQUF1QztJQUNyQyxPQUFPLEdBQUcsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsSUFBckIsQ0FBMEIsT0FBMUIsQ0FBa0MsU0FBbEMsRUFBNkMsS0FBN0MsRUFBb0QsT0FBcEQsRUFBNkQsWUFBN0QsRUFBMkUsV0FBM0UsRUFBd0YsU0FBeEYsRUFBbUcsZ0JBQW5HLENBQVYsQ0FBQTtHQUNEOztFQUVELE9BQU8sT0FBUCxDQUFBO0NBQ0Q7O0FBRUQsSUFBTSxJQUFxQixHQUFHO0VBQzVCLEVBQUUsRUFBRSxjQUR3QjtFQUU1QixPQUFPLEVBQVAsV0FGNEI7RUFHNUIsU0FBUyxFQUFFO0lBQ1Qsa0NBQUEsRUFBb0MsU0FBQSw2QkFBQSxDQUFBLE1BQUEsRUFBcUI7TUFBQSxJQUFsQixXQUFrQixHQUFBLE1BQUEsQ0FBbEIsV0FBa0IsQ0FBQTs7TUFDdkQsSUFBSSxXQUFXLENBQUMsUUFBWixDQUFxQixJQUFyQixLQUE4QixNQUFsQyxFQUEwQztRQUFFLE9BQUE7T0FBUTs7TUFFcEQsV0FBVyxDQUFDLFNBQVosR0FBd0I7UUFDdEIsR0FBRyxFQUFFO1VBQ0gsUUFBUSxFQUFFLElBRFA7VUFFSCxPQUFPLEVBQUUsSUFBQTtTQUhXO1FBS3RCLElBQUksRUFBRTtVQUNKLFFBQVEsRUFBRSxJQUROO1VBRUosT0FBTyxFQUFFLElBQUE7U0FQVztRQVN0QixRQUFRLEVBQUUsSUFUWTtRQVV0QixNQUFNLEVBQUUsSUFWYztRQVd0QixXQUFXLEVBQUUsRUFBQTtPQVhmLENBQUE7S0FKTztJQW1CVCxpQ0FBQSxFQUFtQyxTQUFBLDRCQUFBLENBQUEsTUFBQSxFQUE4RixLQUE5RixFQUF3RztNQUFBLElBQXJHLFdBQXFHLEdBQUEsTUFBQSxDQUFyRyxXQUFxRztVQUF4RixLQUF3RixHQUFBLE1BQUEsQ0FBeEYsS0FBd0Y7VUFBekUsU0FBeUUsR0FBQSxNQUFBLENBQWpGLE1BQWlGLENBQUE7O01BQ3pJLElBQUksV0FBVyxDQUFDLFFBQVosQ0FBcUIsSUFBckIsS0FBOEIsTUFBbEMsRUFBMEM7UUFBRSxPQUFBO09BQVE7O01BRHFGLElBR2pJLFNBSGlJLEdBR25ILFdBSG1ILENBR2pJLFNBSGlJLENBQUE7O01BTXpJLFNBQVMsQ0FBQyxXQUFWLEdBQXdCLElBQXhCLENBQUE7TUFDQSxTQUFTLENBQUMsTUFBVixHQUFtQixJQUFuQixDQUFBO01BQ0EsU0FBUyxDQUFDLFdBQVYsR0FBd0IsY0FBYyxDQUFDLEtBQUQsRUFBUSxXQUFXLENBQUMsT0FBcEIsQ0FBdEMsQ0FBQTtNQUNBLFNBQVMsQ0FBQyxNQUFWLEdBQW1CLGFBQWEsQ0FBQyxXQUFELEVBQWMsS0FBZCxFQUFxQixTQUFyQixDQUFoQyxDQUFBOztNQUVBLElBQUksU0FBUyxDQUFDLE1BQVYsQ0FBaUIsUUFBckIsRUFBK0I7UUFDN0Isb0JBQW9CLENBQUMsU0FBUyxDQUFDLFdBQVgsRUFBd0IsU0FBUyxDQUFDLE1BQVYsQ0FBaUIsUUFBekMsQ0FBcEIsQ0FBQTtRQUNBLEtBQUssQ0FBQyxJQUFOLENBQVcsb0JBQVgsRUFBaUM7VUFBRSxXQUFXLEVBQVgsV0FBRjtVQUFlLFNBQVMsRUFBVCxTQUFBO1NBQWhELENBQUEsQ0FBQTtPQUNEO0tBakNNOztJQXFDVCwwQkFBQSxFQUE0QixjQXJDbkI7SUFzQ1QseUJBQUEsRUFBMkIsY0F0Q2xCO0lBd0NULGdDQUFBLEVBQWtDLFNBQVMsaUJBQVQsQ0FBQSxNQUFBLEVBQWtILEtBQWxILEVBQXlIO01BQUEsSUFBM0YsV0FBMkYsR0FBQSxNQUFBLENBQTNGLFdBQTJGO1VBQXRFLFNBQXNFLEdBQUEsTUFBQSxDQUE5RSxNQUE4RSxDQUFBOztNQUN6SixJQUFJLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQXJCLEtBQThCLE1BQWxDLEVBQTBDO1FBQUUsT0FBQTtPQUFROztNQUVwRCxjQUFjLENBQUMsV0FBRCxFQUFjLFdBQVcsQ0FBQyxTQUFaLENBQXNCLE1BQXBDLENBQWQsQ0FBQTtNQUVBLEtBQUssQ0FBQyxJQUFOLENBQVcsbUJBQVgsRUFBZ0M7UUFBRSxXQUFXLEVBQVgsV0FBRjtRQUFlLFNBQVMsRUFBVCxTQUFBO09BQS9DLENBQUEsQ0FBQTtNQUNBLFdBQVcsQ0FBQyxTQUFaLENBQXNCLE1BQXRCLEdBQStCLEVBQS9CLENBQUE7S0E5Q087SUFpRFQsK0JBQUEsRUFBaUMsU0FBQSwwQkFBQSxDQUFBLE1BQUEsRUFBdUYsS0FBdkYsRUFBaUc7TUFBQSxJQUE5RixXQUE4RixHQUFBLE1BQUEsQ0FBOUYsV0FBOEY7VUFBekUsU0FBeUUsR0FBQSxNQUFBLENBQWpGLE1BQWlGLENBQUE7O01BQ2hJLElBQUksV0FBVyxDQUFDLFFBQVosQ0FBcUIsSUFBckIsS0FBOEIsTUFBbEMsRUFBMEM7UUFBRSxPQUFBO09BQVE7O01BRXBELGNBQWMsQ0FBQyxXQUFELEVBQWMsV0FBVyxDQUFDLFNBQVosQ0FBc0IsTUFBcEMsQ0FBZCxDQUFBO01BQ0EsS0FBSyxDQUFDLElBQU4sQ0FBVyxrQkFBWCxFQUErQjtRQUFFLFdBQVcsRUFBWCxXQUFGO1FBQWUsU0FBUyxFQUFULFNBQUE7T0FBOUMsQ0FBQSxDQUFBO0tBckRPO0lBd0RULG1CQUFBLEVBQXFCLFNBQUEsZ0JBQUEsQ0FBQSxNQUFBLEVBQXFCO01BQUEsSUFBbEIsV0FBa0IsR0FBQSxNQUFBLENBQWxCLFdBQWtCLENBQUE7O01BQ3hDLElBQUksV0FBVyxDQUFDLFFBQVosQ0FBcUIsSUFBckIsS0FBOEIsTUFBbEMsRUFBMEM7UUFBRSxPQUFBO09BQVE7O01BRFosSUFHaEMsU0FIZ0MsR0FHbEIsV0FIa0IsQ0FHaEMsU0FIZ0MsQ0FBQTs7TUFLeEMsSUFBSSxTQUFKLEVBQWU7UUFDYixTQUFTLENBQUMsV0FBVixHQUF3QixJQUF4QixDQUFBO1FBQ0EsU0FBUyxDQUFDLE1BQVYsR0FBbUIsSUFBbkIsQ0FBQTtRQUNBLFNBQVMsQ0FBQyxHQUFWLENBQWMsUUFBZCxHQUF5QixJQUF6QixDQUFBO1FBQ0EsU0FBUyxDQUFDLEdBQVYsQ0FBYyxPQUFkLEdBQXdCLElBQXhCLENBQUE7UUFDQSxTQUFTLENBQUMsSUFBVixDQUFlLFFBQWYsR0FBMEIsSUFBMUIsQ0FBQTtRQUNBLFNBQVMsQ0FBQyxJQUFWLENBQWUsT0FBZixHQUF5QixJQUF6QixDQUFBO1FBQ0EsU0FBUyxDQUFDLFFBQVYsR0FBcUIsS0FBckIsQ0FBQTtPQUNEO0tBQ0Y7R0F6RXlCO0VBMkU1QixjQUFjLEVBQWQsY0EzRTRCO0VBNEU1QixPQUFPLEVBQVAsT0E1RTRCO0VBNkU1QixhQUFhLEVBQWIsYUE3RTRCO0VBOEU1QixjQUFjLEVBQWQsY0E5RTRCO0VBK0U1QixRQUFRLEVBQUU7SUFDUixPQUFPLEVBQUUsS0FERDtJQUVSLE1BQU0sRUFBRyxJQUZEO0lBR1IsT0FBTyxFQUFFLFNBQUE7R0FIRDtDQS9FWixDQUFBO21CQXNGZTs7Ozs7Ozs7Ozs7OztBQzlqQmYsSUFBQSxTQUFBLEdBQUEsMkJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7Ozs7O0FBaURBLFNBQVMsV0FBVCxDQUFrQixLQUFsQixFQUF5QztFQUFBLElBRXJDLE9BRnFDLEdBS25DLEtBTG1DLENBRXJDLE9BRnFDO01BR3JDLFlBSHFDLEdBS25DLEtBTG1DLENBR3JDLFlBSHFDO01BSXJDLFFBSnFDLEdBS25DLEtBTG1DLENBSXJDLFFBSnFDLENBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7RUE4QnZDLFlBQVksQ0FBQyxTQUFiLENBQXVCLFVBQXZCLEdBQW9DLFVBQXVDLE9BQXZDLEVBQXNGO0lBQ3hILElBQUksU0FBSyxDQUFDLEVBQU4sQ0FBUyxNQUFULENBQWdCLE9BQWhCLENBQUosRUFBOEI7TUFDNUIsSUFBQSxDQUFLLE9BQUwsQ0FBYSxPQUFiLENBQXFCLE9BQXJCLEdBQStCLE9BQU8sQ0FBQyxPQUFSLEtBQW9CLEtBQW5ELENBQUE7TUFDQSxJQUFBLENBQUssWUFBTCxDQUFrQixTQUFsQixFQUE2QixPQUE3QixDQUFBLENBQUE7TUFDQSxJQUFBLENBQUssV0FBTCxDQUFpQixTQUFqQixFQUE0QixPQUE1QixDQUFBLENBQUE7TUFFQSxPQUFPLElBQVAsQ0FBQTtLQUNEOztJQUVELElBQUksU0FBSyxDQUFDLEVBQU4sQ0FBUyxJQUFULENBQWMsT0FBZCxDQUFKLEVBQTRCO01BQzFCLElBQUEsQ0FBSyxPQUFMLENBQWEsT0FBYixDQUFxQixPQUFyQixHQUErQixPQUEvQixDQUFBO01BRUEsT0FBTyxJQUFQLENBQUE7S0FDRDs7SUFFRCxPQUFPLElBQUEsQ0FBSyxPQUFMLENBQWEsT0FBcEIsQ0FBQTtHQWZGLENBQUE7O0VBa0JBLE9BQU8sQ0FBQyxHQUFSLENBQVksT0FBWixHQUFzQixPQUF0QixDQUFBO0VBQ0EsT0FBTyxDQUFDLFVBQVIsQ0FBbUIsT0FBbkIsR0FBNkIsWUFBN0IsQ0FBQTtFQUVBLFFBQVEsQ0FBQyxPQUFULENBQWlCLE9BQWpCLEdBQTJCLE9BQU8sQ0FBQyxRQUFuQyxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxrQkFBVCxDQUFBLElBQUEsRUFBK0U7RUFBQSxJQUFoRCxXQUFnRCxHQUFBLElBQUEsQ0FBaEQsV0FBZ0Q7TUFBbkMsTUFBbUMsR0FBQSxJQUFBLENBQW5DLE1BQW1DO01BQTNCLEtBQTJCLEdBQUEsSUFBQSxDQUEzQixLQUEyQixDQUFBOztFQUM3RSxJQUFJLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQXJCLEtBQThCLFNBQWxDLEVBQTZDO0lBQUUsT0FBQTtHQUFROztFQUV2RCxJQUFNLFFBQVEsR0FBRyxXQUFXLENBQUMsUUFBWixDQUFxQixHQUFyQixDQUF5QixVQUFBLENBQUMsRUFBQTtJQUFBLE9BQUksQ0FBQyxDQUFDLE9BQU4sQ0FBQTtHQUExQixDQUFqQixDQUFBO0VBQ0EsSUFBTSxRQUFRLEdBQUcsS0FBSyxLQUFLLE9BQTNCLENBQUE7RUFDQSxJQUFNLE1BQU0sR0FBRyxLQUFLLEtBQUssS0FBekIsQ0FBQTtFQUNBLElBQU0sV0FBVyxHQUFHLFdBQVcsQ0FBQyxZQUFaLENBQXlCLE9BQXpCLENBQWlDLFdBQXJELENBQUE7RUFFQSxNQUFNLENBQUMsT0FBUCxHQUFpQixDQUFDLFFBQVEsQ0FBQyxDQUFELENBQVQsRUFBYyxRQUFRLENBQUMsQ0FBRCxDQUF0QixDQUFqQixDQUFBOztFQUVBLElBQUksUUFBSixFQUFjO0lBQ1osTUFBTSxDQUFDLFFBQVAsR0FBa0IsU0FBSyxDQUFDLE9BQU4sQ0FBYyxhQUFkLENBQTRCLFFBQTVCLEVBQXNDLFdBQXRDLENBQWxCLENBQUE7SUFDQSxNQUFNLENBQUMsR0FBUCxHQUFrQixTQUFLLENBQUMsT0FBTixDQUFjLFNBQWQsQ0FBd0IsUUFBeEIsQ0FBbEIsQ0FBQTtJQUNBLE1BQU0sQ0FBQyxLQUFQLEdBQWtCLENBQWxCLENBQUE7SUFDQSxNQUFNLENBQUMsRUFBUCxHQUFrQixDQUFsQixDQUFBO0lBQ0EsTUFBTSxDQUFDLEtBQVAsR0FBa0IsU0FBSyxDQUFDLE9BQU4sQ0FBYyxVQUFkLENBQXlCLFFBQXpCLEVBQW1DLFdBQW5DLENBQWxCLENBQUE7SUFDQSxNQUFNLENBQUMsRUFBUCxHQUFrQixDQUFsQixDQUFBO0lBRUEsV0FBVyxDQUFDLE9BQVosQ0FBb0IsYUFBcEIsR0FBb0MsTUFBTSxDQUFDLFFBQTNDLENBQUE7SUFDQSxXQUFXLENBQUMsT0FBWixDQUFvQixVQUFwQixHQUFpQyxNQUFNLENBQUMsS0FBeEMsQ0FBQTtHQVRGLE1BV0ssSUFBSSxNQUFKLEVBQVk7SUFDZixJQUFNLFNBQVMsR0FBRyxXQUFXLENBQUMsU0FBOUIsQ0FBQTtJQUVBLE1BQU0sQ0FBQyxRQUFQLEdBQWtCLFNBQVMsQ0FBQyxRQUE1QixDQUFBO0lBQ0EsTUFBTSxDQUFDLEdBQVAsR0FBa0IsU0FBUyxDQUFDLEdBQTVCLENBQUE7SUFDQSxNQUFNLENBQUMsS0FBUCxHQUFrQixTQUFTLENBQUMsS0FBNUIsQ0FBQTtJQUNBLE1BQU0sQ0FBQyxFQUFQLEdBQWtCLENBQWxCLENBQUE7SUFDQSxNQUFNLENBQUMsS0FBUCxHQUFrQixTQUFTLENBQUMsS0FBNUIsQ0FBQTtJQUNBLE1BQU0sQ0FBQyxFQUFQLEdBQWtCLENBQWxCLENBQUE7R0FSRyxNQVVBO0lBQ0gsTUFBTSxDQUFDLFFBQVAsR0FBa0IsU0FBSyxDQUFDLE9BQU4sQ0FBYyxhQUFkLENBQTRCLFFBQTVCLEVBQXNDLFdBQXRDLENBQWxCLENBQUE7SUFDQSxNQUFNLENBQUMsR0FBUCxHQUFrQixTQUFLLENBQUMsT0FBTixDQUFjLFNBQWQsQ0FBd0IsUUFBeEIsQ0FBbEIsQ0FBQTtJQUNBLE1BQU0sQ0FBQyxLQUFQLEdBQWtCLE1BQU0sQ0FBQyxRQUFQLEdBQWtCLFdBQVcsQ0FBQyxPQUFaLENBQW9CLGFBQXhELENBQUE7SUFDQSxNQUFNLENBQUMsS0FBUCxHQUFrQixTQUFLLENBQUMsT0FBTixDQUFjLFVBQWQsQ0FBeUIsUUFBekIsRUFBbUMsV0FBbkMsQ0FBbEIsQ0FBQTtJQUVBLE1BQU0sQ0FBQyxFQUFQLEdBQVksTUFBTSxDQUFDLEtBQVAsR0FBZSxXQUFXLENBQUMsT0FBWixDQUFvQixLQUEvQyxDQUFBO0lBQ0EsTUFBTSxDQUFDLEVBQVAsR0FBWSxNQUFNLENBQUMsS0FBUCxHQUFlLFdBQVcsQ0FBQyxPQUFaLENBQW9CLEtBQS9DLENBQUE7R0FDRDs7RUFFRCxXQUFXLENBQUMsT0FBWixDQUFvQixRQUFwQixHQUErQixNQUFNLENBQUMsUUFBdEMsQ0FBQTtFQUNBLFdBQVcsQ0FBQyxPQUFaLENBQW9CLEtBQXBCLEdBQTRCLE1BQU0sQ0FBQyxLQUFuQyxDQUFBOztFQUVBLElBQUksU0FBSyxDQUFDLEVBQU4sQ0FBUyxNQUFULENBQWdCLE1BQU0sQ0FBQyxLQUF2QixDQUFBLElBQ0EsTUFBTSxDQUFDLEtBQVAsS0FBaUIsUUFEakIsSUFFQSxDQUFDLEtBQUssQ0FBQyxNQUFNLENBQUMsS0FBUixDQUZWLEVBRTBCO0lBQ3hCLFdBQVcsQ0FBQyxPQUFaLENBQW9CLEtBQXBCLEdBQTRCLE1BQU0sQ0FBQyxLQUFuQyxDQUFBO0dBQ0Q7Q0FDRjs7QUFFRCxJQUFNLE9BQXdCLEdBQUc7RUFDL0IsRUFBRSxFQUFFLGlCQUQyQjtFQUUvQixNQUFNLEVBQUUsQ0FBQyxjQUFELEVBQWlCLGdCQUFqQixDQUZ1QjtFQUcvQixPQUFPLEVBQVAsV0FIK0I7RUFJL0IsU0FBUyxFQUFFO0lBQ1QsMkJBQUEsRUFBNkIsa0JBRHBCO0lBRVQsMEJBQUEsRUFBNEIsa0JBRm5CO0lBR1QseUJBQUEsRUFBMkIsa0JBSGxCO0lBS1Qsa0JBQUEsRUFBb0IsU0FBQSxlQUFBLENBQUEsS0FBQSxFQUFxQjtNQUFBLElBQWxCLFdBQWtCLEdBQUEsS0FBQSxDQUFsQixXQUFrQixDQUFBO01BQ3ZDLFdBQVcsQ0FBQyxPQUFaLEdBQXNCO1FBQ3BCLEtBQUssRUFBRSxDQURhO1FBRXBCLFFBQVEsRUFBRSxDQUZVO1FBR3BCLEtBQUssRUFBRSxDQUhhO1FBSXBCLFVBQVUsRUFBRSxDQUpRO1FBS3BCLGFBQWEsRUFBRSxDQUFBO09BTGpCLENBQUE7S0FOTztJQWVULGtCQUFBLEVBQW9CLFNBQUEsY0FBQSxDQUFBLEdBQUcsRUFBSTtNQUN6QixJQUFJLEdBQUcsQ0FBQyxXQUFKLENBQWdCLFFBQWhCLENBQXlCLE1BQXpCLEdBQWtDLENBQXRDLEVBQXlDO1FBQ3ZDLE9BQU8sU0FBUCxDQUFBO09BQ0Q7O01BRUQsSUFBTSxjQUFjLEdBQUcsR0FBRyxDQUFDLFlBQUosQ0FBaUIsT0FBakIsQ0FBeUIsT0FBaEQsQ0FBQTs7TUFFQSxJQUFJLEVBQUUsY0FBYyxJQUFJLGNBQWMsQ0FBQyxPQUFuQyxDQUFKLEVBQWlEO1FBQy9DLE9BQU8sU0FBUCxDQUFBO09BQ0Q7O01BRUQsR0FBRyxDQUFDLE1BQUosR0FBYTtRQUFFLElBQUksRUFBRSxTQUFBO09BQXJCLENBQUE7TUFFQSxPQUFPLEtBQVAsQ0FBQTtLQUNEO0dBakM0QjtFQW9DL0IsUUFBUSxFQUFFLEVBcENxQjtFQXVDL0IsU0F2QytCLEVBQUEsU0FBQSxTQUFBLEdBdUNsQjtJQUNYLE9BQU8sRUFBUCxDQUFBO0dBQ0Q7Q0F6Q0gsQ0FBQTttQkE0Q2U7Ozs7Ozs7Ozs7Ozs7QUN0TWYsK0VBQUE7O0FBRUEsSUFBQSxPQUFBLEdBQUEsMkJBQUEsQ0FBQSxhQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFdBQUEsR0FBQSwwQkFBQSxDQUFBLFdBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsTUFBQSxHQUFBLDJCQUFBLENBQUEsT0FBQSxDQUFBLENBQUE7Ozs7Ozs7O0FBb0NBLFNBQVMsV0FBVCxDQUFrQixLQUFsQixFQUFnQztFQUFBLElBRTVCLE9BRjRCLEdBTzFCLEtBUDBCLENBRTVCLE9BRjRCO01BRzVCLE9BSDRCLEdBTzFCLEtBUDBCLENBRzVCLE9BSDRCO01BSzVCLFlBTDRCLEdBTzFCLEtBUDBCLENBSzVCLFlBTDRCO01BTTVCLFFBTjRCLEdBTzFCLEtBUDBCLENBTTVCLFFBTjRCLENBQUE7O0VBVzlCLE1BQU0sQ0FBQyxPQUFQLEdBQWlCLFdBQVcsQ0FBQyxPQUFELENBQTVCLENBQUE7RUFDQSxNQUFNLENBQUMsYUFBUCxHQUF1QixPQUFPLENBQUMsYUFBUixJQUF5QixPQUFPLENBQUMsb0JBQWpDLEdBQXdELEVBQXhELEdBQTZELEVBQXBGLENBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0VBK0NBLFlBQVksQ0FBQyxTQUFiLENBQXVCLFNBQXZCLEdBQW1DLFVBQXVDLE9BQXZDLEVBQXFGO0lBQ3RILE9BQU8sU0FBUyxDQUFDLElBQUQsRUFBTyxPQUFQLEVBQWdCLEtBQWhCLENBQWhCLENBQUE7R0FERixDQUFBOztFQUlBLE9BQU8sQ0FBQyxHQUFSLENBQVksTUFBWixHQUFxQixNQUFyQixDQUFBO0VBQ0EsT0FBTyxDQUFDLFVBQVIsQ0FBbUIsTUFBbkIsR0FBNEIsV0FBNUIsQ0FBQTtFQUVBLFFBQVEsQ0FBQyxPQUFULENBQWlCLE1BQWpCLEdBQTBCLE1BQU0sQ0FBQyxRQUFqQyxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxhQUFULENBQXdCLEdBQXhCLEVBQTZCO0VBQUEsSUFDbkIsV0FEbUIsR0FDbUMsR0FEbkMsQ0FDbkIsV0FEbUI7TUFDTixZQURNLEdBQ21DLEdBRG5DLENBQ04sWUFETTtNQUNRLE9BRFIsR0FDbUMsR0FEbkMsQ0FDUSxPQURSO01BQ2lCLElBRGpCLEdBQ21DLEdBRG5DLENBQ2lCLElBRGpCO01BQ3VCLE9BRHZCLEdBQ21DLEdBRG5DLENBQ3VCLE9BRHZCLENBQUE7O0VBRzNCLElBQUksQ0FBQyxJQUFMLEVBQVc7SUFBRSxPQUFPLFNBQVAsQ0FBQTtHQUFrQjs7RUFFL0IsSUFBTSxJQUFJLEdBQUcsQ0FBQSxDQUFBLEVBQUEsV0FBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLEVBQVAsRUFBVyxXQUFXLENBQUMsTUFBWixDQUFtQixHQUFuQixDQUF1QixJQUFsQyxDQUFiLENBQUE7RUFDQSxJQUFNLGFBQWEsR0FBRyxZQUFZLENBQUMsT0FBYixDQUFxQixNQUEzQyxDQUFBOztFQUVBLElBQ0UsRUFBRSxhQUFhLElBQUksYUFBYSxDQUFDLE9BQWpDLENBQUE7RUFFQyxXQUFXLENBQUMsYUFBWixJQUNBLGVBQUEsQ0FBZ0IsSUFBaEIsQ0FBcUIsV0FBVyxDQUFDLFdBQWpDLENBREEsSUFFRixDQUFDLE9BQU8sR0FBRyxhQUFhLENBQUMsWUFBekIsTUFBMkMsQ0FMNUMsRUFNRTtJQUNBLE9BQU8sU0FBUCxDQUFBO0dBZnlCOzs7RUFtQjNCLElBQUksTUFBRSxDQUFDLE1BQUgsQ0FBVSxhQUFhLENBQUMsS0FBeEIsQ0FBSixFQUFvQztJQUNsQyxJQUFNLFdBQVcsR0FBRztNQUNsQixJQUFJLEVBQUUsS0FEWTtNQUVsQixLQUFLLEVBQUUsS0FGVztNQUdsQixHQUFHLEVBQUUsS0FIYTtNQUlsQixNQUFNLEVBQUUsS0FBQTtLQUpWLENBQUE7O0lBT0EsS0FBSyxJQUFNLElBQVgsSUFBbUIsV0FBbkIsRUFBZ0M7TUFDOUIsV0FBVyxDQUFDLElBQUQsQ0FBWCxHQUFvQixlQUFlLENBQUMsSUFBRCxFQUNqQyxhQUFhLENBQUMsS0FBZCxDQUFvQixJQUFwQixDQURpQyxFQUVqQyxJQUZpQyxFQUdqQyxXQUFXLENBQUMsY0FBWixDQUEyQixXQUhNLEVBSWpDLE9BSmlDLEVBS2pDLElBTGlDLEVBTWpDLGFBQWEsQ0FBQyxNQUFkLElBQXdCLE1BQU0sQ0FBQyxhQU5FLENBQW5DLENBQUE7S0FPRDs7SUFFRCxXQUFXLENBQUMsSUFBWixHQUFtQixXQUFXLENBQUMsSUFBWixJQUFvQixDQUFDLFdBQVcsQ0FBQyxLQUFwRCxDQUFBO0lBQ0EsV0FBVyxDQUFDLEdBQVosR0FBbUIsV0FBVyxDQUFDLEdBQVosSUFBb0IsQ0FBQyxXQUFXLENBQUMsTUFBcEQsQ0FBQTs7SUFFQSxJQUFJLFdBQVcsQ0FBQyxJQUFaLElBQW9CLFdBQVcsQ0FBQyxLQUFoQyxJQUF5QyxXQUFXLENBQUMsR0FBckQsSUFBNEQsV0FBVyxDQUFDLE1BQTVFLEVBQW9GO01BQ2xGLEdBQUcsQ0FBQyxNQUFKLEdBQWE7UUFDWCxJQUFJLEVBQUUsUUFESztRQUVYLEtBQUssRUFBRSxXQUFBO09BRlQsQ0FBQTtLQUlEO0dBMUJILE1BNEJLO0lBQ0gsSUFBTSxLQUFLLEdBQUksYUFBYSxDQUFDLElBQWQsS0FBdUIsR0FBdkIsSUFBOEIsSUFBSSxDQUFDLENBQUwsR0FBVSxJQUFJLENBQUMsS0FBTCxHQUFjLE1BQU0sQ0FBQyxhQUE1RSxDQUFBO0lBQ0EsSUFBTSxNQUFNLEdBQUcsYUFBYSxDQUFDLElBQWQsS0FBdUIsR0FBdkIsSUFBOEIsSUFBSSxDQUFDLENBQUwsR0FBVSxJQUFJLENBQUMsTUFBTCxHQUFjLE1BQU0sQ0FBQyxhQUE1RSxDQUFBOztJQUVBLElBQUksS0FBSyxJQUFJLE1BQWIsRUFBcUI7TUFDbkIsR0FBRyxDQUFDLE1BQUosR0FBYTtRQUNYLElBQUksRUFBRSxRQURLO1FBRVgsSUFBSSxFQUFFLENBQUMsS0FBSyxHQUFHLEdBQUgsR0FBUyxFQUFmLEtBQXNCLE1BQU0sR0FBRyxHQUFILEdBQVMsRUFBckMsQ0FBQTtPQUZSLENBQUE7S0FJRDtHQUNGOztFQUVELE9BQU8sR0FBRyxDQUFDLE1BQUosR0FBYSxLQUFiLEdBQXFCLFNBQTVCLENBQUE7Q0FDRDs7QUFFRCxTQUFTLFNBQVQsQ0FBb0IsWUFBcEIsRUFBeUQsT0FBekQsRUFBMkgsS0FBM0gsRUFBeUk7RUFDdkksSUFBSSxNQUFFLENBQUMsTUFBSCxDQUFVLE9BQVYsQ0FBSixFQUF3QjtJQUN0QixZQUFZLENBQUMsT0FBYixDQUFxQixNQUFyQixDQUE0QixPQUE1QixHQUFzQyxPQUFPLENBQUMsT0FBUixLQUFvQixLQUExRCxDQUFBO0lBQ0EsWUFBWSxDQUFDLFlBQWIsQ0FBMEIsUUFBMUIsRUFBb0MsT0FBcEMsQ0FBQSxDQUFBO0lBQ0EsWUFBWSxDQUFDLFdBQWIsQ0FBeUIsUUFBekIsRUFBbUMsT0FBbkMsQ0FBQSxDQUFBOztJQUVBLElBQUksTUFBRSxDQUFDLE1BQUgsQ0FBVSxPQUFPLENBQUMsSUFBbEIsQ0FBQSxJQUEyQixjQUFBLENBQWUsSUFBZixDQUFvQixPQUFPLENBQUMsSUFBNUIsQ0FBL0IsRUFBa0U7TUFDaEUsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsTUFBckIsQ0FBNEIsSUFBNUIsR0FBbUMsT0FBTyxDQUFDLElBQTNDLENBQUE7S0FERixNQUdLLElBQUksT0FBTyxDQUFDLElBQVIsS0FBaUIsSUFBckIsRUFBMkI7TUFDOUIsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsTUFBckIsQ0FBNEIsSUFBNUIsR0FBbUMsS0FBSyxDQUFDLFFBQU4sQ0FBZSxPQUFmLENBQXVCLE1BQXZCLENBQThCLElBQWpFLENBQUE7S0FDRDs7SUFFRCxJQUFJLE1BQUUsQ0FBQyxJQUFILENBQVEsT0FBTyxDQUFDLG1CQUFoQixDQUFKLEVBQTBDO01BQ3hDLFlBQVksQ0FBQyxPQUFiLENBQXFCLE1BQXJCLENBQTRCLG1CQUE1QixHQUFrRCxPQUFPLENBQUMsbUJBQTFELENBQUE7S0FERixNQUdLLElBQUksTUFBRSxDQUFDLElBQUgsQ0FBUSxPQUFPLENBQUMsTUFBaEIsQ0FBSixFQUE2QjtNQUNoQyxZQUFZLENBQUMsT0FBYixDQUFxQixNQUFyQixDQUE0QixNQUE1QixHQUFxQyxPQUFPLENBQUMsTUFBN0MsQ0FBQTtLQUNEOztJQUVELE9BQU8sWUFBUCxDQUFBO0dBQ0Q7O0VBQ0QsSUFBSSxNQUFFLENBQUMsSUFBSCxDQUFRLE9BQVIsQ0FBSixFQUFzQjtJQUNwQixZQUFZLENBQUMsT0FBYixDQUFxQixNQUFyQixDQUE0QixPQUE1QixHQUFzQyxPQUF0QyxDQUFBO0lBRUEsT0FBTyxZQUFQLENBQUE7R0FDRDs7RUFDRCxPQUFPLFlBQVksQ0FBQyxPQUFiLENBQXFCLE1BQTVCLENBQUE7Q0FDRDs7QUFFRCxTQUFTLGVBQVQsQ0FDRSxJQURGLEVBRUUsS0FGRixFQUdFLElBSEYsRUFJRSxPQUpGLEVBS0UsbUJBTEYsRUFNRSxJQU5GLEVBT0UsTUFQRixFQVFFOztFQUVBLElBQUksQ0FBQyxLQUFMLEVBQVk7SUFBRSxPQUFPLEtBQVAsQ0FBQTtHQUZkOzs7RUFLQSxJQUFJLEtBQUssS0FBSyxJQUFkLEVBQW9COztJQUVsQixJQUFNLEtBQUssR0FBSSxNQUFFLENBQUMsTUFBSCxDQUFVLElBQUksQ0FBQyxLQUFmLENBQUEsR0FBd0IsSUFBSSxDQUFDLEtBQTdCLEdBQXNDLElBQUksQ0FBQyxLQUFMLEdBQWMsSUFBSSxDQUFDLElBQXhFLENBQUE7SUFDQSxJQUFNLE1BQU0sR0FBRyxNQUFFLENBQUMsTUFBSCxDQUFVLElBQUksQ0FBQyxNQUFmLENBQUEsR0FBeUIsSUFBSSxDQUFDLE1BQTlCLEdBQXVDLElBQUksQ0FBQyxNQUFMLEdBQWMsSUFBSSxDQUFDLEdBQXpFLENBSGtCOztJQU1sQixNQUFNLEdBQUcsSUFBSSxDQUFDLEdBQUwsQ0FBUyxNQUFULEVBQWlCLENBQUMsSUFBSSxLQUFLLE1BQVQsSUFBbUIsSUFBSSxLQUFLLE9BQTVCLEdBQXNDLEtBQXRDLEdBQThDLE1BQS9DLElBQXlELENBQTFFLENBQVQsQ0FBQTs7SUFFQSxJQUFJLEtBQUssR0FBRyxDQUFaLEVBQWU7TUFDYixJQUFTLElBQUksS0FBSyxNQUFsQixFQUEyQjtRQUFFLElBQUksR0FBRyxPQUFQLENBQUE7T0FBN0IsTUFDSyxJQUFJLElBQUksS0FBSyxPQUFiLEVBQXNCO1FBQUUsSUFBSSxHQUFHLE1BQVAsQ0FBQTtPQUFnQjtLQUM5Qzs7SUFDRCxJQUFJLE1BQU0sR0FBRyxDQUFiLEVBQWdCO01BQ2QsSUFBUyxJQUFJLEtBQUssS0FBbEIsRUFBNEI7UUFBRSxJQUFJLEdBQUcsUUFBUCxDQUFBO09BQTlCLE1BQ0ssSUFBSSxJQUFJLEtBQUssUUFBYixFQUF1QjtRQUFFLElBQUksR0FBRyxLQUFQLENBQUE7T0FBaUI7S0FDaEQ7O0lBRUQsSUFBSSxJQUFJLEtBQUssTUFBYixFQUFxQjtNQUFFLE9BQU8sSUFBSSxDQUFDLENBQUwsR0FBVSxDQUFDLEtBQUssSUFBSyxDQUFWLEdBQWMsSUFBSSxDQUFDLElBQW5CLEdBQTBCLElBQUksQ0FBQyxLQUFoQyxJQUF5QyxNQUExRCxDQUFBO0tBQW1FOztJQUMxRixJQUFJLElBQUksS0FBSyxLQUFiLEVBQW9CO01BQUUsT0FBTyxJQUFJLENBQUMsQ0FBTCxHQUFVLENBQUMsTUFBTSxJQUFJLENBQVYsR0FBYyxJQUFJLENBQUMsR0FBbkIsR0FBeUIsSUFBSSxDQUFDLE1BQS9CLElBQXlDLE1BQTFELENBQUE7S0FBbUU7O0lBRXpGLElBQUksSUFBSSxLQUFLLE9BQWIsRUFBc0I7TUFBRSxPQUFPLElBQUksQ0FBQyxDQUFMLEdBQVUsQ0FBQyxLQUFLLElBQUssQ0FBVixHQUFjLElBQUksQ0FBQyxLQUFuQixHQUEyQixJQUFJLENBQUMsSUFBakMsSUFBeUMsTUFBMUQsQ0FBQTtLQUFtRTs7SUFDM0YsSUFBSSxJQUFJLEtBQUssUUFBYixFQUF1QjtNQUFFLE9BQU8sSUFBSSxDQUFDLENBQUwsR0FBVSxDQUFDLE1BQU0sSUFBSSxDQUFWLEdBQWMsSUFBSSxDQUFDLE1BQW5CLEdBQTRCLElBQUksQ0FBQyxHQUFsQyxJQUF5QyxNQUExRCxDQUFBO0tBQW1FO0dBMUI5Rjs7O0VBOEJBLElBQUksQ0FBQyxNQUFFLENBQUMsT0FBSCxDQUFXLE9BQVgsQ0FBTCxFQUEwQjtJQUFFLE9BQU8sS0FBUCxDQUFBO0dBQWM7O0VBRTFDLE9BQU8sTUFBRSxDQUFDLE9BQUgsQ0FBVyxLQUFYLENBQUE7SUFFSCxLQUFLLEtBQUssT0FGUDtJQUlILE9BQUcsQ0FBQyxXQUFKLENBQWdCLE9BQWhCLEVBQXlCLEtBQXpCLEVBQWdDLG1CQUFoQyxDQUpKLENBQUE7Q0FLRDs7QUFFRCxTQUFTLFdBQVQsQ0FBc0IsT0FBdEIsRUFBb0Y7RUFDbEYsT0FBUSxPQUFPLENBQUMsS0FBUixHQUFnQjtJQUN0QixDQUFDLEVBQUcsVUFEa0I7SUFFdEIsQ0FBQyxFQUFHLFVBRmtCO0lBR3RCLEVBQUUsRUFBRSxXQUhrQjtJQUt0QixHQUFHLEVBQVUsVUFMUztJQU10QixJQUFJLEVBQVMsVUFOUztJQU90QixNQUFNLEVBQU8sVUFQUztJQVF0QixLQUFLLEVBQVEsVUFSUztJQVN0QixPQUFPLEVBQU0sV0FUUztJQVV0QixXQUFXLEVBQUUsV0FWUztJQVd0QixRQUFRLEVBQUssV0FYUztJQVl0QixVQUFVLEVBQUcsV0FBQTtHQVpQLEdBYUo7SUFDRixDQUFDLEVBQUcsV0FERjtJQUVGLENBQUMsRUFBRyxXQUZGO0lBR0YsRUFBRSxFQUFFLGFBSEY7SUFLRixHQUFHLEVBQVUsV0FMWDtJQU1GLElBQUksRUFBUyxXQU5YO0lBT0YsTUFBTSxFQUFPLFdBUFg7SUFRRixLQUFLLEVBQVEsV0FSWDtJQVNGLE9BQU8sRUFBTSxhQVRYO0lBVUYsV0FBVyxFQUFFLGFBVlg7SUFXRixRQUFRLEVBQUssYUFYWDtJQVlGLFVBQVUsRUFBRyxhQUFBO0dBekJmLENBQUE7Q0EyQkQ7O0FBRUQsU0FBUyxLQUFULENBQUEsSUFBQSxFQUFpSDtFQUFBLElBQS9GLE1BQStGLEdBQUEsSUFBQSxDQUEvRixNQUErRjtNQUF2RixXQUF1RixHQUFBLElBQUEsQ0FBdkYsV0FBdUYsQ0FBQTs7RUFDL0csSUFBSSxXQUFXLENBQUMsUUFBWixDQUFxQixJQUFyQixLQUE4QixRQUE5QixJQUEwQyxDQUFDLFdBQVcsQ0FBQyxRQUFaLENBQXFCLEtBQXBFLEVBQTJFO0lBQ3pFLE9BQUE7R0FDRDs7RUFFRCxJQUFNLFdBQVcsR0FBRyxNQUFwQixDQUFBO0VBQ0EsSUFBTSxJQUFJLEdBQUcsV0FBVyxDQUFDLElBQXpCLENBQUE7RUFFQSxXQUFXLENBQUMsTUFBWixHQUFxQjtJQUNuQixLQUFLLEVBQUUsQ0FBQSxDQUFBLEVBQUEsV0FBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLEVBQVAsRUFBVyxJQUFYLENBRFk7SUFFbkIsU0FBUyxFQUFFLENBQUEsQ0FBQSxFQUFBLFdBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxFQUFQLEVBQVcsSUFBWCxDQUZRO0lBR25CLFFBQVEsRUFBRSxDQUFBLENBQUEsRUFBQSxXQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sRUFBUCxFQUFXLElBQVgsQ0FIUztJQUluQixLQUFLLEVBQUU7TUFDTCxJQUFJLEVBQUUsQ0FERDtNQUVMLEtBQUssRUFBRyxDQUZIO01BR0wsS0FBSyxFQUFHLENBSEg7TUFJTCxHQUFHLEVBQUcsQ0FKRDtNQUtMLE1BQU0sRUFBRSxDQUxIO01BTUwsTUFBTSxFQUFFLENBQUE7S0FOSDtHQUpULENBQUE7RUFjQSxXQUFXLENBQUMsS0FBWixHQUFvQixXQUFXLENBQUMsUUFBWixDQUFxQixLQUF6QyxDQUFBO0VBQ0EsV0FBVyxDQUFDLElBQVosR0FBbUIsV0FBVyxDQUFDLE1BQVosQ0FBbUIsU0FBdEMsQ0FBQTtFQUNBLFdBQVcsQ0FBQyxTQUFaLEdBQXdCLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEtBQTNDLENBQUE7Q0FDRDs7QUFFRCxTQUFTLFFBQVQsQ0FBQSxLQUFBLEVBQWdIO0VBQUEsSUFBL0YsTUFBK0YsR0FBQSxLQUFBLENBQS9GLE1BQStGO01BQXZGLFdBQXVGLEdBQUEsS0FBQSxDQUF2RixXQUF1RixDQUFBOztFQUM5RyxJQUFJLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQXJCLEtBQThCLFFBQTlCLElBQTBDLENBQUMsV0FBVyxDQUFDLFFBQVosQ0FBcUIsS0FBcEUsRUFBMkU7SUFBRSxPQUFBO0dBQVE7O0VBRXJGLElBQU0sV0FBVyxHQUFHLE1BQXBCLENBQUE7RUFDQSxJQUFNLGFBQWEsR0FBRyxXQUFXLENBQUMsWUFBWixDQUF5QixPQUF6QixDQUFpQyxNQUF2RCxDQUFBO0VBQ0EsSUFBTSxNQUFNLEdBQUcsYUFBYSxDQUFDLE1BQTdCLENBQUE7RUFDQSxJQUFNLFVBQVUsR0FBRyxNQUFNLEtBQUssWUFBWCxJQUEyQixNQUFNLEtBQUssUUFBekQsQ0FOOEc7O0VBUzlHLElBQU0sT0FBTyxHQUFHLFdBQVcsQ0FBQyxJQUE1QixDQUFBO0VBVDhHLElBQUEsbUJBQUEsR0FVMUMsV0FBVyxDQUFDLE1BVjhCO01BVS9GLFNBVitGLEdBQUEsbUJBQUEsQ0FVdEcsS0FWc0c7TUFVcEYsU0FWb0YsR0FBQSxtQkFBQSxDQVVwRixTQVZvRjtNQVVsRSxTQVZrRSxHQUFBLG1CQUFBLENBVXpFLEtBVnlFO01BVXZELFFBVnVELEdBQUEsbUJBQUEsQ0FVdkQsUUFWdUQsQ0FBQTtFQVk5RyxDQUFBLENBQUEsRUFBQSxXQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sUUFBUCxFQUFpQixTQUFqQixDQUFBLENBQUE7O0VBRUEsSUFBSSxVQUFKLEVBQWdCOztJQUVkLENBQUEsQ0FBQSxFQUFBLFdBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxTQUFQLEVBQWtCLE9BQWxCLENBQUEsQ0FBQTs7SUFFQSxJQUFJLE1BQU0sS0FBSyxZQUFmLEVBQTZCOztNQUUzQixJQUFJLFNBQVMsQ0FBQyxHQUFWLEdBQWdCLFNBQVMsQ0FBQyxNQUE5QixFQUFzQztRQUNwQyxJQUFNLElBQUksR0FBRyxTQUFTLENBQUMsR0FBdkIsQ0FBQTtRQUVBLFNBQVMsQ0FBQyxHQUFWLEdBQWdCLFNBQVMsQ0FBQyxNQUExQixDQUFBO1FBQ0EsU0FBUyxDQUFDLE1BQVYsR0FBbUIsSUFBbkIsQ0FBQTtPQUNEOztNQUNELElBQUksU0FBUyxDQUFDLElBQVYsR0FBaUIsU0FBUyxDQUFDLEtBQS9CLEVBQXNDO1FBQ3BDLElBQU0sS0FBSSxHQUFHLFNBQVMsQ0FBQyxJQUF2QixDQUFBO1FBRUEsU0FBUyxDQUFDLElBQVYsR0FBaUIsU0FBUyxDQUFDLEtBQTNCLENBQUE7UUFDQSxTQUFTLENBQUMsS0FBVixHQUFrQixLQUFsQixDQUFBO09BQ0Q7S0FDRjtHQWxCSCxNQW9CSzs7SUFFSCxTQUFTLENBQUMsR0FBVixHQUFtQixJQUFJLENBQUMsR0FBTCxDQUFTLE9BQU8sQ0FBQyxHQUFqQixFQUFzQixTQUFTLENBQUMsTUFBaEMsQ0FBbkIsQ0FBQTtJQUNBLFNBQVMsQ0FBQyxNQUFWLEdBQW1CLElBQUksQ0FBQyxHQUFMLENBQVMsT0FBTyxDQUFDLE1BQWpCLEVBQXlCLFNBQVMsQ0FBQyxHQUFuQyxDQUFuQixDQUFBO0lBQ0EsU0FBUyxDQUFDLElBQVYsR0FBbUIsSUFBSSxDQUFDLEdBQUwsQ0FBUyxPQUFPLENBQUMsSUFBakIsRUFBdUIsU0FBUyxDQUFDLEtBQWpDLENBQW5CLENBQUE7SUFDQSxTQUFTLENBQUMsS0FBVixHQUFtQixJQUFJLENBQUMsR0FBTCxDQUFTLE9BQU8sQ0FBQyxLQUFqQixFQUF3QixTQUFTLENBQUMsSUFBbEMsQ0FBbkIsQ0FBQTtHQUNEOztFQUVELFNBQVMsQ0FBQyxLQUFWLEdBQW1CLFNBQVMsQ0FBQyxLQUFWLEdBQW1CLFNBQVMsQ0FBQyxJQUFoRCxDQUFBO0VBQ0EsU0FBUyxDQUFDLE1BQVYsR0FBbUIsU0FBUyxDQUFDLE1BQVYsR0FBbUIsU0FBUyxDQUFDLEdBQWhELENBQUE7O0VBRUEsS0FBSyxJQUFNLElBQVgsSUFBbUIsU0FBbkIsRUFBOEI7SUFDNUIsU0FBUyxDQUFDLElBQUQsQ0FBVCxHQUFrQixTQUFTLENBQUMsSUFBRCxDQUFULEdBQWtCLFFBQVEsQ0FBQyxJQUFELENBQTVDLENBQUE7R0FDRDs7RUFFRCxXQUFXLENBQUMsS0FBWixHQUFvQixXQUFXLENBQUMsUUFBWixDQUFxQixLQUF6QyxDQUFBO0VBQ0EsV0FBVyxDQUFDLElBQVosR0FBbUIsU0FBbkIsQ0FBQTtFQUNBLFdBQVcsQ0FBQyxTQUFaLEdBQXdCLFNBQXhCLENBQUE7Q0FDRDs7QUFFRCxTQUFTLEdBQVQsQ0FBQSxLQUFBLEVBQStHO0VBQUEsSUFBL0YsTUFBK0YsR0FBQSxLQUFBLENBQS9GLE1BQStGO01BQXZGLFdBQXVGLEdBQUEsS0FBQSxDQUF2RixXQUF1RixDQUFBOztFQUM3RyxJQUFJLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQXJCLEtBQThCLFFBQTlCLElBQTBDLENBQUMsV0FBVyxDQUFDLFFBQVosQ0FBcUIsS0FBcEUsRUFBMkU7SUFBRSxPQUFBO0dBQVE7O0VBRXJGLElBQU0sV0FBVyxHQUFHLE1BQXBCLENBQUE7RUFFQSxXQUFXLENBQUMsS0FBWixHQUFvQixXQUFXLENBQUMsUUFBWixDQUFxQixLQUF6QyxDQUFBO0VBQ0EsV0FBVyxDQUFDLElBQVosR0FBbUIsV0FBVyxDQUFDLE1BQVosQ0FBbUIsU0FBdEMsQ0FBQTtFQUNBLFdBQVcsQ0FBQyxTQUFaLEdBQXdCLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEtBQTNDLENBQUE7Q0FDRDs7QUFFRCxTQUFTLGVBQVQsQ0FBQSxLQUFBLEVBQTJIO0VBQUEsSUFBL0YsTUFBK0YsR0FBQSxLQUFBLENBQS9GLE1BQStGO01BQXZGLFdBQXVGLEdBQUEsS0FBQSxDQUF2RixXQUF1RixDQUFBOztFQUN6SCxJQUFJLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQXJCLEtBQThCLFFBQTlCLElBQTBDLENBQUMsV0FBVyxDQUFDLFVBQTNELEVBQXVFO0lBQUUsT0FBQTtHQUFROztFQUVqRixJQUFNLE9BQU8sR0FBRyxXQUFXLENBQUMsWUFBWixDQUF5QixPQUF6QyxDQUFBO0VBQ0EsSUFBTSxXQUFXLEdBQUcsTUFBcEIsQ0FBQTs7RUFFQSxJQUFJLE9BQU8sQ0FBQyxNQUFSLENBQWUsTUFBbkIsRUFBMkI7SUFDekIsSUFBSSxXQUFXLENBQUMsVUFBWixLQUEyQixHQUEvQixFQUFvQztNQUNsQyxXQUFXLENBQUMsS0FBWixDQUFrQixDQUFsQixHQUFzQixXQUFXLENBQUMsS0FBWixDQUFrQixDQUF4QyxDQUFBO0tBREYsTUFHSztNQUNILFdBQVcsQ0FBQyxLQUFaLENBQWtCLENBQWxCLEdBQXNCLFdBQVcsQ0FBQyxLQUFaLENBQWtCLENBQXhDLENBQUE7S0FDRDs7SUFDRCxXQUFXLENBQUMsSUFBWixHQUFtQixJQUFuQixDQUFBO0dBUEYsTUFTSztJQUNILFdBQVcsQ0FBQyxJQUFaLEdBQW1CLFdBQVcsQ0FBQyxVQUEvQixDQUFBOztJQUVBLElBQUksV0FBVyxDQUFDLFVBQVosS0FBMkIsR0FBL0IsRUFBb0M7TUFDbEMsV0FBVyxDQUFDLEtBQVosQ0FBa0IsQ0FBbEIsR0FBc0IsQ0FBdEIsQ0FBQTtLQURGLE1BR0ssSUFBSSxXQUFXLENBQUMsVUFBWixLQUEyQixHQUEvQixFQUFvQztNQUN2QyxXQUFXLENBQUMsS0FBWixDQUFrQixDQUFsQixHQUFzQixDQUF0QixDQUFBO0tBQ0Q7R0FDRjtDQUNGOztBQUVELElBQU0sTUFBdUIsR0FBRztFQUM5QixFQUFFLEVBQUUsZ0JBRDBCO0VBRTlCLE1BQU0sRUFBRSxDQUFDLGNBQUQsQ0FGc0I7RUFHOUIsT0FBTyxFQUFQLFdBSDhCO0VBSTlCLFNBQVMsRUFBRTtJQUNULGtCQUFBLEVBQW9CLFNBQUEsZUFBQSxDQUFBLEtBQUEsRUFBcUI7TUFBQSxJQUFsQixXQUFrQixHQUFBLEtBQUEsQ0FBbEIsV0FBa0IsQ0FBQTtNQUN2QyxXQUFXLENBQUMsVUFBWixHQUF5QixJQUF6QixDQUFBO0tBRk87SUFLVCwyQkFBQSxFQUE2QixTQUFBLHVCQUFBLENBQUEsR0FBRyxFQUFJO01BQ2xDLEtBQUssQ0FBQyxHQUFELENBQUwsQ0FBQTtNQUNBLGVBQWUsQ0FBQyxHQUFELENBQWYsQ0FBQTtLQVBPO0lBU1QsMEJBQUEsRUFBNEIsU0FBQSxzQkFBQSxDQUFBLEdBQUcsRUFBSTtNQUNqQyxRQUFJLENBQUMsR0FBRCxDQUFKLENBQUE7TUFDQSxlQUFlLENBQUMsR0FBRCxDQUFmLENBQUE7S0FYTztJQWFULHlCQUFBLEVBQTJCLEdBYmxCO0lBY1Qsa0JBQUEsRUFBb0IsYUFBQTtHQWxCUTtFQXFCOUIsUUFBUSxFQUFFO0lBQ1IsTUFBTSxFQUFFLEtBREE7SUFFUixtQkFBbUIsRUFBRSxLQUZiO0lBR1IsSUFBSSxFQUFFLElBSEU7O0lBTVIsTUFBTSxFQUFFLEdBTkE7Ozs7O0lBWVIsS0FBSyxFQUFFLElBWkM7Ozs7O0lBa0JSLE1BQU0sRUFBRSxNQUFBO0dBdkNvQjtFQTBDOUIsT0FBTyxFQUFFLElBMUNxQjtFQTRDOUIsU0E1QzhCLEVBQUEsU0FBQSxTQUFBLENBQUEsS0FBQSxFQTRDMEI7SUFBQSxJQUEzQyxLQUEyQyxHQUFBLEtBQUEsQ0FBM0MsS0FBMkM7UUFBcEMsSUFBb0MsR0FBQSxLQUFBLENBQXBDLElBQW9DO1FBQTlCLElBQThCLEdBQUEsS0FBQSxDQUE5QixJQUE4QixDQUFBO0lBQ3RELElBQU0sT0FBTyxHQUFHLE1BQU0sQ0FBQyxPQUF2QixDQUFBO0lBQ0EsSUFBSSxNQUFjLEdBQUcsSUFBckIsQ0FBQTs7SUFFQSxJQUFJLElBQUosRUFBVTtNQUNSLE1BQU0sR0FBRyxPQUFPLENBQUMsSUFBSSxHQUFHLElBQVIsQ0FBaEIsQ0FBQTtLQURGLE1BR0ssSUFBSSxLQUFKLEVBQVc7TUFDZCxJQUFJLFNBQVMsR0FBRyxFQUFoQixDQUFBO01BRGMsSUFBQSxJQUFBLEdBR0ssQ0FBQyxLQUFELEVBQVEsUUFBUixFQUFrQixNQUFsQixFQUEwQixPQUExQixDQUhMLENBQUE7O01BR2QsS0FBQSxJQUFBLEVBQUEsR0FBQSxDQUFBLEVBQUEsRUFBQSxHQUFBLElBQUEsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQXVEO1FBQWxELElBQU0sSUFBSSxHQUFBLElBQUEsQ0FBQSxFQUFBLENBQVYsQ0FBQTs7UUFDSCxJQUFJLEtBQUssQ0FBQyxJQUFELENBQVQsRUFBaUI7VUFDZixTQUFTLElBQUksSUFBYixDQUFBO1NBQ0Q7T0FDRjs7TUFFRCxNQUFNLEdBQUcsT0FBTyxDQUFDLFNBQUQsQ0FBaEIsQ0FBQTtLQUNEOztJQUVELE9BQU8sTUFBUCxDQUFBO0dBL0Q0QjtFQWtFOUIsYUFBYSxFQUFFLElBQUE7Q0FsRWpCLENBQUE7bUJBcUVlOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2hkZixJQUFBLFNBQUEsR0FBQSwwQkFBQSxDQUFBLFFBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsTUFBQSxHQUFBLDBCQUFBLENBQUEsU0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxRQUFBLEdBQUEsMEJBQUEsQ0FBQSxXQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLE9BQUEsR0FBQSwwQkFBQSxDQUFBLFVBQUEsQ0FBQSxDQUFBOzs7O21CQUVlO0VBQ2IsRUFBRSxFQUFFLFNBRFM7RUFFYixPQUZhLEVBQUEsU0FBQSxPQUFBLENBRUosS0FGSSxFQUVVO0lBQ3JCLEtBQUssQ0FBQyxTQUFOLENBQWdCLFFBQUEsQ0FBQSxTQUFBLENBQWhCLENBQUEsQ0FBQTtJQUNBLEtBQUssQ0FBQyxTQUFOLENBQWdCLE9BQUEsQ0FBQSxTQUFBLENBQWhCLENBQUEsQ0FBQTtJQUNBLEtBQUssQ0FBQyxTQUFOLENBQWdCLFNBQUEsQ0FBQSxTQUFBLENBQWhCLENBQUEsQ0FBQTtJQUNBLEtBQUssQ0FBQyxTQUFOLENBQWdCLE1BQUEsQ0FBQSxTQUFBLENBQWhCLENBQUEsQ0FBQTtHQUNEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNiSCxJQUFBLFlBQUEsR0FBQSwyQkFBQSxDQUFBLGFBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsTUFBQSxHQUFBLDJCQUFBLENBQUEsT0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxRQUFBLEdBQUEsMEJBQUEsQ0FBQSxRQUFBLENBQUEsQ0FBQTs7QUFDQSxrRUFBQTs7QUFDQSxzRUFBQTs7Ozs7Ozs7QUErQkEsU0FBUyxXQUFULENBQWtCLEtBQWxCLEVBQWdDO0VBQUEsSUFFNUIsUUFGNEIsR0FJMUIsS0FKMEIsQ0FFNUIsUUFGNEI7TUFHNUIsT0FINEIsR0FJMUIsS0FKMEIsQ0FHNUIsT0FINEIsQ0FBQTtFQU05QixLQUFLLENBQUMsVUFBTixHQUFtQixVQUFuQixDQUFBOztFQUNBLFVBQVUsQ0FBQyxHQUFYLEdBQWlCLFlBQUE7SUFBQSxPQUFNLEtBQUssQ0FBQyxHQUFOLEVBQU4sQ0FBQTtHQUFqQixDQUFBOztFQUVBLE9BQU8sQ0FBQyxjQUFSLENBQXVCLFVBQXZCLEdBQW9DLElBQXBDLENBQUE7RUFDQSxRQUFRLENBQUMsU0FBVCxDQUFtQixVQUFuQixHQUFnQyxVQUFVLENBQUMsUUFBM0MsQ0FBQTtDQUNEOztBQUVELElBQU0sVUFBVSxHQUFHO0VBQ2pCLFFBQVEsRUFBRTtJQUNSLE9BQU8sRUFBSSxLQURIO0lBRVIsTUFBTSxFQUFLLEVBRkg7O0lBS1IsU0FBUyxFQUFFLElBTEg7O0lBUVIsS0FBSyxFQUFNLEdBQUE7R0FUSTtFQVlqQixHQUFHLEVBQUUsSUFBSSxDQUFDLEdBWk87RUFjakIsV0FBVyxFQUFFLElBZEk7RUFlakIsQ0FBQyxFQUFFLENBZmM7OztFQWtCakIsQ0FBQyxFQUFFLENBbEJjO0VBbUJqQixDQUFDLEVBQUUsQ0FuQmM7RUFxQmpCLFdBQVcsRUFBRSxLQXJCSTtFQXNCakIsUUFBUSxFQUFFLENBdEJPO0VBdUJqQixNQUFNLEVBQUUsQ0F2QlM7RUF3QmpCLEtBQUssRUFBRSxDQXhCVTtFQTBCakIsS0ExQmlCLEVBQUEsU0FBQSxLQUFBLENBMEJWLFdBMUJVLEVBMEJ5QjtJQUN4QyxVQUFVLENBQUMsV0FBWCxHQUF5QixJQUF6QixDQUFBOztJQUNBLFFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBSSxNQUFKLENBQVcsVUFBVSxDQUFDLENBQXRCLENBQUEsQ0FBQTs7SUFFQSxXQUFXLENBQUMsVUFBWixHQUF5QixVQUF6QixDQUFBO0lBQ0EsVUFBVSxDQUFDLFdBQVgsR0FBeUIsV0FBekIsQ0FBQTtJQUNBLFVBQVUsQ0FBQyxRQUFYLEdBQXNCLFVBQVUsQ0FBQyxHQUFYLEVBQXRCLENBQUE7SUFDQSxVQUFVLENBQUMsQ0FBWCxHQUFlLFFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBSSxPQUFKLENBQVksVUFBVSxDQUFDLE1BQXZCLENBQWYsQ0FBQTtHQWpDZTtFQW9DakIsSUFwQ2lCLEVBQUEsU0FBQSxJQUFBLEdBb0NUO0lBQ04sVUFBVSxDQUFDLFdBQVgsR0FBeUIsS0FBekIsQ0FBQTs7SUFDQSxJQUFJLFVBQVUsQ0FBQyxXQUFmLEVBQTRCO01BQzFCLFVBQVUsQ0FBQyxXQUFYLENBQXVCLFVBQXZCLEdBQW9DLElBQXBDLENBQUE7S0FDRDs7SUFDRCxRQUFBLENBQUEsU0FBQSxDQUFBLENBQUksTUFBSixDQUFXLFVBQVUsQ0FBQyxDQUF0QixDQUFBLENBQUE7R0F6Q2U7O0VBNkNqQixNQTdDaUIsRUFBQSxTQUFBLE1BQUEsR0E2Q1A7SUFBQSxJQUNBLFdBREEsR0FDZ0IsVUFEaEIsQ0FDQSxXQURBLENBQUE7SUFBQSxJQUVBLFlBRkEsR0FFMEIsV0FGMUIsQ0FFQSxZQUZBO1FBRWMsT0FGZCxHQUUwQixXQUYxQixDQUVjLE9BRmQsQ0FBQTtJQUdSLElBQU0sVUFBVSxHQUFHLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQXhDLENBQUE7SUFDQSxJQUFNLE9BQU8sR0FBRyxZQUFZLENBQUMsT0FBYixDQUFxQixVQUFyQixDQUFBLENBQWlDLFVBQWpELENBQUE7SUFDQSxJQUFNLFNBQVMsR0FBRyxZQUFZLENBQUMsT0FBTyxDQUFDLFNBQVQsRUFBb0IsWUFBcEIsRUFBa0MsT0FBbEMsQ0FBOUIsQ0FBQTtJQUNBLElBQU0sR0FBRyxHQUFHLFVBQVUsQ0FBQyxHQUFYLEVBQVosQ0FOUTs7SUFRUixJQUFNLEVBQUUsR0FBRyxDQUFDLEdBQUcsR0FBRyxVQUFVLENBQUMsUUFBbEIsSUFBOEIsSUFBekMsQ0FSUTs7SUFVUixJQUFNLENBQUMsR0FBRyxPQUFPLENBQUMsS0FBUixHQUFnQixFQUExQixDQUFBOztJQUVBLElBQUksQ0FBQyxJQUFJLENBQVQsRUFBWTtNQUNWLElBQU0sUUFBUSxHQUFHO1FBQ2YsQ0FBQyxFQUFFLFVBQVUsQ0FBQyxDQUFYLEdBQWUsQ0FESDtRQUVmLENBQUMsRUFBRSxVQUFVLENBQUMsQ0FBWCxHQUFlLENBQUE7T0FGcEIsQ0FBQTs7TUFLQSxJQUFJLFFBQVEsQ0FBQyxDQUFULElBQWMsUUFBUSxDQUFDLENBQTNCLEVBQThCO1FBQzVCLElBQU0sVUFBVSxHQUFHLFNBQVMsQ0FBQyxTQUFELENBQTVCLENBQUE7O1FBRUEsSUFBSSxNQUFFLENBQUMsTUFBSCxDQUFVLFNBQVYsQ0FBSixFQUEwQjtVQUN4QixTQUFTLENBQUMsUUFBVixDQUFtQixRQUFRLENBQUMsQ0FBNUIsRUFBK0IsUUFBUSxDQUFDLENBQXhDLENBQUEsQ0FBQTtTQURGLE1BR0ssSUFBSSxTQUFKLEVBQWU7VUFDbEIsU0FBUyxDQUFDLFVBQVYsSUFBd0IsUUFBUSxDQUFDLENBQWpDLENBQUE7VUFDQSxTQUFTLENBQUMsU0FBVixJQUF3QixRQUFRLENBQUMsQ0FBakMsQ0FBQTtTQUNEOztRQUVELElBQU0sU0FBUyxHQUFHLFNBQVMsQ0FBQyxTQUFELENBQTNCLENBQUE7UUFDQSxJQUFNLEtBQUssR0FBRztVQUNaLENBQUMsRUFBRSxTQUFTLENBQUMsQ0FBVixHQUFjLFVBQVUsQ0FBQyxDQURoQjtVQUVaLENBQUMsRUFBRSxTQUFTLENBQUMsQ0FBVixHQUFjLFVBQVUsQ0FBQyxDQUFBO1NBRjlCLENBQUE7O1FBS0EsSUFBSSxLQUFLLENBQUMsQ0FBTixJQUFXLEtBQUssQ0FBQyxDQUFyQixFQUF3QjtVQUN0QixZQUFZLENBQUMsSUFBYixDQUFrQjtZQUNoQixJQUFJLEVBQUUsWUFEVTtZQUVoQixNQUFNLEVBQUUsT0FGUTtZQUdoQixZQUFZLEVBQVosWUFIZ0I7WUFJaEIsS0FBSyxFQUFMLEtBSmdCO1lBS2hCLFdBQVcsRUFBWCxXQUxnQjtZQU1oQixTQUFTLEVBQVQsU0FBQTtXQU5GLENBQUEsQ0FBQTtTQVFEO09BQ0Y7O01BRUQsVUFBVSxDQUFDLFFBQVgsR0FBc0IsR0FBdEIsQ0FBQTtLQUNEOztJQUVELElBQUksVUFBVSxDQUFDLFdBQWYsRUFBNEI7TUFDMUIsUUFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFJLE1BQUosQ0FBVyxVQUFVLENBQUMsQ0FBdEIsQ0FBQSxDQUFBOztNQUNBLFVBQVUsQ0FBQyxDQUFYLEdBQWUsUUFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFJLE9BQUosQ0FBWSxVQUFVLENBQUMsTUFBdkIsQ0FBZixDQUFBO0tBQ0Q7R0FsR2M7RUFvR2pCLEtBcEdpQixFQUFBLFNBQUEsS0FBQSxDQW9HVixZQXBHVSxFQW9HMkIsVUFwRzNCLEVBb0c0RDtJQUMzRSxJQUFNLE9BQU8sR0FBRyxZQUFZLENBQUMsT0FBN0IsQ0FBQTtJQUVBLE9BQU8sT0FBTyxDQUFDLFVBQUQsQ0FBUCxDQUFvQixVQUFwQixJQUFrQyxPQUFPLENBQUMsVUFBRCxDQUFQLENBQW9CLFVBQXBCLENBQStCLE9BQXhFLENBQUE7R0F2R2U7RUF5R2pCLGlCQXpHaUIsRUFBQSxTQUFBLGlCQUFBLENBQUEsSUFBQSxFQXlHb0k7SUFBQSxJQUFqRyxXQUFpRyxHQUFBLElBQUEsQ0FBakcsV0FBaUc7UUFBcEYsT0FBb0YsR0FBQSxJQUFBLENBQXBGLE9BQW9GLENBQUE7O0lBQ25KLElBQUksRUFBRSxXQUFXLENBQUMsV0FBWixFQUFBLElBQ0EsVUFBVSxDQUFDLEtBQVgsQ0FBaUIsV0FBVyxDQUFDLFlBQTdCLEVBQTJDLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQWhFLENBREYsQ0FBSixFQUM4RTtNQUM1RSxPQUFBO0tBQ0Q7O0lBRUQsSUFBSSxXQUFXLENBQUMsVUFBaEIsRUFBNEI7TUFDMUIsVUFBVSxDQUFDLENBQVgsR0FBZSxVQUFVLENBQUMsQ0FBWCxHQUFlLENBQTlCLENBQUE7TUFDQSxPQUFBO0tBQ0Q7O0lBRUQsSUFBSSxHQUFKLENBQUE7SUFDQSxJQUFJLEtBQUosQ0FBQTtJQUNBLElBQUksTUFBSixDQUFBO0lBQ0EsSUFBSSxJQUFKLENBQUE7SUFkbUosSUFnQjNJLFlBaEIySSxHQWdCakgsV0FoQmlILENBZ0IzSSxZQWhCMkk7UUFnQjdILE9BaEI2SCxHQWdCakgsV0FoQmlILENBZ0I3SCxPQWhCNkgsQ0FBQTtJQWlCbkosSUFBTSxVQUFVLEdBQUcsV0FBVyxDQUFDLFFBQVosQ0FBcUIsSUFBeEMsQ0FBQTtJQUNBLElBQU0sT0FBTyxHQUFHLFlBQVksQ0FBQyxPQUFiLENBQXFCLFVBQXJCLENBQUEsQ0FBaUMsVUFBakQsQ0FBQTtJQUNBLElBQU0sU0FBUyxHQUFHLFlBQVksQ0FBQyxPQUFPLENBQUMsU0FBVCxFQUFvQixZQUFwQixFQUFrQyxPQUFsQyxDQUE5QixDQUFBOztJQUVBLElBQUksTUFBRSxDQUFDLE1BQUgsQ0FBVSxTQUFWLENBQUosRUFBMEI7TUFDeEIsSUFBSSxHQUFLLE9BQU8sQ0FBQyxPQUFSLEdBQWtCLFVBQVUsQ0FBQyxNQUF0QyxDQUFBO01BQ0EsR0FBRyxHQUFNLE9BQU8sQ0FBQyxPQUFSLEdBQWtCLFVBQVUsQ0FBQyxNQUF0QyxDQUFBO01BQ0EsS0FBSyxHQUFJLE9BQU8sQ0FBQyxPQUFSLEdBQWtCLFNBQVMsQ0FBQyxVQUFWLEdBQXdCLFVBQVUsQ0FBQyxNQUE5RCxDQUFBO01BQ0EsTUFBTSxHQUFHLE9BQU8sQ0FBQyxPQUFSLEdBQWtCLFNBQVMsQ0FBQyxXQUFWLEdBQXdCLFVBQVUsQ0FBQyxNQUE5RCxDQUFBO0tBSkYsTUFNSztNQUNILElBQU0sSUFBSSxHQUFHLFlBQVEsQ0FBQyxvQkFBVCxDQUE4QixTQUE5QixDQUFiLENBQUE7TUFFQSxJQUFJLEdBQUssT0FBTyxDQUFDLE9BQVIsR0FBa0IsSUFBSSxDQUFDLElBQUwsR0FBYyxVQUFVLENBQUMsTUFBcEQsQ0FBQTtNQUNBLEdBQUcsR0FBTSxPQUFPLENBQUMsT0FBUixHQUFrQixJQUFJLENBQUMsR0FBTCxHQUFjLFVBQVUsQ0FBQyxNQUFwRCxDQUFBO01BQ0EsS0FBSyxHQUFJLE9BQU8sQ0FBQyxPQUFSLEdBQWtCLElBQUksQ0FBQyxLQUFMLEdBQWMsVUFBVSxDQUFDLE1BQXBELENBQUE7TUFDQSxNQUFNLEdBQUcsT0FBTyxDQUFDLE9BQVIsR0FBa0IsSUFBSSxDQUFDLE1BQUwsR0FBYyxVQUFVLENBQUMsTUFBcEQsQ0FBQTtLQUNEOztJQUVELFVBQVUsQ0FBQyxDQUFYLEdBQWdCLEtBQUssR0FBRyxDQUFILEdBQU8sSUFBSSxHQUFHLENBQUMsQ0FBSixHQUFRLENBQXhDLENBQUE7SUFDQSxVQUFVLENBQUMsQ0FBWCxHQUFnQixNQUFNLEdBQUcsQ0FBSCxHQUFRLEdBQUcsR0FBRyxDQUFDLENBQUosR0FBUSxDQUF6QyxDQUFBOztJQUVBLElBQUksQ0FBQyxVQUFVLENBQUMsV0FBaEIsRUFBNkI7O01BRTNCLFVBQVUsQ0FBQyxNQUFYLEdBQW9CLE9BQU8sQ0FBQyxNQUE1QixDQUFBO01BQ0EsVUFBVSxDQUFDLEtBQVgsR0FBb0IsT0FBTyxDQUFDLEtBQTVCLENBQUE7TUFFQSxVQUFVLENBQUMsS0FBWCxDQUFpQixXQUFqQixDQUFBLENBQUE7S0FDRDtHQUNGO0NBdkpILENBQUE7O0FBMEpPLFNBQVMsWUFBVCxDQUF1QixLQUF2QixFQUFtQyxZQUFuQyxFQUF3RSxPQUF4RSxFQUFtRztFQUN4RyxPQUFPLENBQUMsTUFBRSxDQUFDLE1BQUgsQ0FBVSxLQUFWLENBQUEsR0FBbUIsQ0FBQSxDQUFBLEVBQUEsU0FBQSxDQUFBLHFCQUFBLEVBQXNCLEtBQXRCLEVBQTZCLFlBQTdCLEVBQTJDLE9BQTNDLENBQW5CLEdBQXlFLEtBQTFFLEtBQW9GLENBQUEsQ0FBQSxFQUFBLFdBQUEsQ0FBQSxTQUFBLEVBQVUsT0FBVixDQUEzRixDQUFBO0NBQ0Q7O0FBRU0sU0FBUyxTQUFULENBQW9CLFNBQXBCLEVBQW9DO0VBQ3pDLElBQUksTUFBRSxDQUFDLE1BQUgsQ0FBVSxTQUFWLENBQUosRUFBMEI7SUFBRSxTQUFTLEdBQUcsTUFBTSxDQUFDLFFBQVAsQ0FBZ0IsSUFBNUIsQ0FBQTtHQUFrQzs7RUFFOUQsT0FBTztJQUFFLENBQUMsRUFBRSxTQUFTLENBQUMsVUFBZjtJQUEyQixDQUFDLEVBQUUsU0FBUyxDQUFDLFNBQUE7R0FBL0MsQ0FBQTtDQUNEOztBQUVNLFNBQVMsYUFBVCxDQUF3QixTQUF4QixFQUF3QztFQUM3QyxJQUFJLE1BQUUsQ0FBQyxNQUFILENBQVUsU0FBVixDQUFKLEVBQTBCO0lBQUUsU0FBUyxHQUFHLE1BQU0sQ0FBQyxRQUFQLENBQWdCLElBQTVCLENBQUE7R0FBa0M7O0VBRTlELE9BQU87SUFBRSxDQUFDLEVBQUUsU0FBUyxDQUFDLFdBQWY7SUFBNEIsQ0FBQyxFQUFFLFNBQVMsQ0FBQyxZQUFBO0dBQWhELENBQUE7Q0FDRDs7QUFFTSxTQUFTLGtCQUFULENBQUEsS0FBQSxFQUdKLElBSEksRUFHTztFQUFBLElBSHVELFdBR3ZELEdBQUEsS0FBQSxDQUh1RCxXQUd2RDtNQUhvRSxPQUdwRSxHQUFBLEtBQUEsQ0FIb0UsT0FHcEUsQ0FBQTtFQUNaLElBQU0sYUFBYSxHQUFHLFdBQVcsSUFBSSxXQUFXLENBQUMsWUFBWixDQUF5QixPQUF6QixDQUFpQyxXQUFXLENBQUMsUUFBWixDQUFxQixJQUF0RCxDQUFBLENBQTRELFVBQWpHLENBQUE7O0VBRUEsSUFBSSxDQUFDLGFBQUQsSUFBa0IsQ0FBQyxhQUFhLENBQUMsT0FBckMsRUFBOEM7SUFDNUMsSUFBSSxFQUFBLENBQUE7SUFDSixPQUFPO01BQUUsQ0FBQyxFQUFFLENBQUw7TUFBUSxDQUFDLEVBQUUsQ0FBQTtLQUFsQixDQUFBO0dBQ0Q7O0VBRUQsSUFBTSxlQUFlLEdBQUcsWUFBWSxDQUNsQyxhQUFhLENBQUMsU0FEb0IsRUFFbEMsV0FBVyxDQUFDLFlBRnNCLEVBR2xDLE9BSGtDLENBQXBDLENBQUE7RUFNQSxJQUFNLFFBQVEsR0FBRyxTQUFTLENBQUMsZUFBRCxDQUExQixDQUFBO0VBQ0EsSUFBSSxFQUFBLENBQUE7RUFDSixJQUFNLE9BQU8sR0FBRyxTQUFTLENBQUMsZUFBRCxDQUF6QixDQUFBO0VBRUEsT0FBTztJQUNMLENBQUMsRUFBRSxPQUFPLENBQUMsQ0FBUixHQUFZLFFBQVEsQ0FBQyxDQURuQjtJQUVMLENBQUMsRUFBRSxPQUFPLENBQUMsQ0FBUixHQUFZLFFBQVEsQ0FBQyxDQUFBO0dBRjFCLENBQUE7Q0FJRDs7QUFFRCxJQUFNLGdCQUFpQyxHQUFHO0VBQ3hDLEVBQUUsRUFBRSxhQURvQztFQUV4QyxPQUFPLEVBQVAsV0FGd0M7RUFHeEMsU0FBUyxFQUFFO0lBQ1Qsa0JBQUEsRUFBb0IsU0FBQSxlQUFBLENBQUEsS0FBQSxFQUFxQjtNQUFBLElBQWxCLFdBQWtCLEdBQUEsS0FBQSxDQUFsQixXQUFrQixDQUFBO01BQ3ZDLFdBQVcsQ0FBQyxVQUFaLEdBQXlCLElBQXpCLENBQUE7S0FGTztJQUtULHNCQUFBLEVBQXdCLFNBQUEsbUJBQUEsQ0FBQSxLQUFBLEVBQXFCO01BQUEsSUFBbEIsV0FBa0IsR0FBQSxLQUFBLENBQWxCLFdBQWtCLENBQUE7TUFDM0MsV0FBVyxDQUFDLFVBQVosR0FBeUIsSUFBekIsQ0FBQTtNQUNBLFVBQVUsQ0FBQyxJQUFYLEVBQUEsQ0FBQTs7TUFDQSxJQUFJLFVBQVUsQ0FBQyxXQUFmLEVBQTRCO1FBQzFCLFVBQVUsQ0FBQyxXQUFYLEdBQXlCLElBQXpCLENBQUE7T0FDRDtLQVZNO0lBYVQsbUJBQUEsRUFBcUIsVUFBVSxDQUFDLElBYnZCO0lBZVQsMEJBQUEsRUFBNEIsU0FBQSxzQkFBQSxDQUFDLEdBQUQsRUFBQTtNQUFBLE9BQWMsVUFBVSxDQUFDLGlCQUFYLENBQTZCLEdBQTdCLENBQWQsQ0FBQTtLQUFBO0dBZm5CO0NBSGIsQ0FBQTttQkFzQmU7Ozs7Ozs7Ozs7Ozs7QUMzUWYsb0VBQUE7O0FBQ0EsSUFBQSxNQUFBLEdBQUEsMkJBQUEsQ0FBQSxPQUFBLENBQUEsQ0FBQTs7Ozs7O0FBOEJBLFNBQVMsV0FBVCxDQUFrQixLQUFsQixFQUF5QztFQUFBLElBR3JDLFlBSHFDLEdBSW5DLEtBSm1DLENBR3JDLFlBSHFDLENBQUE7O0VBTXZDLFlBQVksQ0FBQyxTQUFiLENBQXVCLFNBQXZCLEdBQW1DLFNBQVMsU0FBVCxDQUVqQyxPQUZpQyxFQUdqQyxLQUhpQyxFQUlqQyxXQUppQyxFQUtqQyxPQUxpQyxFQU1YO0lBQ3RCLElBQU0sTUFBTSxHQUFHLG9CQUFvQixDQUFDLElBQUQsRUFBTyxLQUFQLEVBQWMsV0FBZCxFQUEyQixPQUEzQixFQUFvQyxLQUFwQyxDQUFuQyxDQUFBOztJQUVBLElBQUksSUFBQSxDQUFLLE9BQUwsQ0FBYSxhQUFqQixFQUFnQztNQUM5QixPQUFPLElBQUEsQ0FBSyxPQUFMLENBQWEsYUFBYixDQUEyQixPQUEzQixFQUFvQyxLQUFwQyxFQUEyQyxNQUEzQyxFQUFtRCxJQUFuRCxFQUF5RCxPQUF6RCxFQUFrRSxXQUFsRSxDQUFQLENBQUE7S0FDRDs7SUFFRCxPQUFPLE1BQVAsQ0FBQTtHQWJGLENBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7RUE0Q0EsWUFBWSxDQUFDLFNBQWIsQ0FBdUIsVUFBdkIsR0FBb0MsQ0FBQSxDQUFBLEVBQUEsVUFBQSxDQUFBLFFBQUEsRUFBUyxVQUF1QyxRQUF2QyxFQUFpRDtJQUM1RixPQUFPLElBQUEsQ0FBSyxpQkFBTCxDQUF1QixZQUF2QixFQUFxQyxRQUFyQyxDQUFQLENBQUE7R0FEa0MsRUFFakMsbUdBRmlDLENBQXBDLENBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7RUEyQkEsWUFBWSxDQUFDLFNBQWIsQ0FBdUIsU0FBdkIsR0FBbUMsQ0FBQSxDQUFBLEVBQUEsVUFBQSxDQUFBLFFBQUEsRUFBUyxVQUF1QyxRQUF2QyxFQUFpRDtJQUMzRixPQUFPLElBQUEsQ0FBSyxpQkFBTCxDQUF1QixXQUF2QixFQUFvQyxRQUFwQyxDQUFQLENBQUE7R0FEaUMsRUFFaEMsaUdBRmdDLENBQW5DLENBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztFQW1DQSxZQUFZLENBQUMsU0FBYixDQUF1QixhQUF2QixHQUF1QyxhQUF2QyxDQUFBOzs7Ozs7Ozs7RUFTQSxZQUFZLENBQUMsU0FBYixDQUF1QixXQUF2QixHQUFxQyxXQUFyQyxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxvQkFBVCxDQUNFLFlBREYsRUFFRSxLQUZGLEVBR0UsV0FIRixFQUlFLE9BSkYsRUFLRSxLQUxGLEVBTUU7RUFDQSxJQUFNLElBQUksR0FBRyxZQUFZLENBQUMsT0FBYixDQUFxQixPQUFyQixDQUFiLENBQUE7RUFDQSxJQUFNLE9BQU8sR0FBSSxLQUFELENBQXNCLE9BQXRCLElBQWtDO0lBQ2hELENBQUEsRUFBRyxDQUQ2QztJQUVoRCxDQUFBLEVBQUcsQ0FGNkM7SUFHaEQsQ0FBQSxFQUFHLENBSDZDO0lBSWhELENBQUEsRUFBRyxFQUFBO0dBSjRDLENBSzdDLEtBQUQsQ0FBc0IsTUFMd0IsQ0FBakQsQ0FBQTtFQU1BLElBQU0sR0FBRyxHQUFHO0lBQ1YsTUFBTSxFQUFFLElBREU7SUFFVixZQUFZLEVBQVosWUFGVTtJQUdWLFdBQVcsRUFBWCxXQUhVO0lBSVYsT0FBTyxFQUFQLE9BSlU7SUFLVixJQUFJLEVBQUosSUFMVTtJQU1WLE9BQU8sRUFBUCxPQUFBO0dBTkYsQ0FBQTtFQVNBLEtBQUssQ0FBQyxJQUFOLENBQVcsa0JBQVgsRUFBK0IsR0FBL0IsQ0FBQSxDQUFBO0VBRUEsT0FBTyxHQUFHLENBQUMsTUFBWCxDQUFBO0NBQ0Q7O0FBSUQsU0FBUyxXQUFULENBQW1ELFFBQW5ELEVBQXVFO0VBQ3JFLElBQUksTUFBRSxDQUFDLElBQUgsQ0FBUSxRQUFSLENBQUosRUFBdUI7SUFDckIsSUFBQSxDQUFLLE9BQUwsQ0FBYSxXQUFiLEdBQTJCLFFBQTNCLENBQUE7SUFFQSxPQUFPLElBQVAsQ0FBQTtHQUNEOztFQUVELElBQUksUUFBUSxLQUFLLElBQWpCLEVBQXVCO0lBQ3JCLE9BQU8sSUFBQSxDQUFLLE9BQUwsQ0FBYSxXQUFwQixDQUFBO0lBRUEsT0FBTyxJQUFQLENBQUE7R0FDRDs7RUFFRCxPQUFPLElBQUEsQ0FBSyxPQUFMLENBQWEsV0FBcEIsQ0FBQTtDQUNEOztBQUVELFNBQVMsYUFBVCxDQUFxRCxPQUFyRCxFQUFtRTtFQUNqRSxJQUFJLE1BQUUsQ0FBQyxJQUFILENBQVEsT0FBUixDQUFKLEVBQXNCO0lBQ3BCLElBQUEsQ0FBSyxPQUFMLENBQWEsYUFBYixHQUE2QixPQUE3QixDQUFBO0lBRUEsT0FBTyxJQUFQLENBQUE7R0FDRDs7RUFFRCxJQUFJLE9BQU8sS0FBSyxJQUFoQixFQUFzQjtJQUNwQixPQUFPLElBQUEsQ0FBSyxPQUFMLENBQWEsYUFBcEIsQ0FBQTtJQUVBLE9BQU8sSUFBUCxDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxJQUFBLENBQUssT0FBTCxDQUFhLGFBQXBCLENBQUE7Q0FDRDs7bUJBRWM7RUFDYixFQUFFLEVBQUUsZ0NBRFM7RUFFYixPQUFPLEVBQVAsV0FBQTs7Ozs7Ozs7Ozs7Ozs7QUMzTkYsSUFBQSxTQUFBLEdBQUEsMkJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLG9CQUFBLEdBQUEsMEJBQUEsQ0FBQSx1QkFBQSxDQUFBLENBQUE7Ozs7Ozs7O0FBeURBLFNBQVMsV0FBVCxDQUFrQixLQUFsQixFQUF5QztFQUFBLElBRXJDLFFBRnFDLEdBSW5DLEtBSm1DLENBRXJDLFFBRnFDO01BR3JDLFFBSHFDLEdBSW5DLEtBSm1DLENBR3JDLFFBSHFDLENBQUE7RUFNdkMsS0FBSyxDQUFDLFNBQU4sQ0FBZ0Isb0JBQUEsQ0FBQSxTQUFBLENBQWhCLENBQUEsQ0FBQTtFQUVBLFFBQVEsQ0FBQyxJQUFULENBQWMsYUFBZCxHQUE4QixJQUE5QixDQUFBO0VBQ0EsUUFBUSxDQUFDLElBQVQsQ0FBYyxXQUFkLEdBQTRCLElBQTVCLENBQUE7RUFFQSxTQUFLLENBQUMsTUFBTixDQUFhLFFBQVEsQ0FBQyxTQUF0QixFQUFpQztJQUMvQixXQUFXLEVBQUUsS0FEa0I7SUFFL0IsR0FBRyxFQUFFLFFBRjBCO0lBRy9CLGFBQWEsRUFBRSxDQUhnQjtJQUkvQixTQUFTLEVBQUcsSUFKbUI7SUFLL0IsVUFBVSxFQUFFLElBTG1COzs7SUFTL0IsWUFBWSxFQUFFLENBQUE7R0FUaEIsQ0FBQSxDQUFBOzs7Ozs7Ozs7Ozs7O0VBdUJBLFFBQVEsQ0FBQyxlQUFULEdBQTJCLFVBQUEsUUFBUSxFQUFBO0lBQUEsT0FBSSxlQUFlLENBQUMsUUFBRCxFQUFXLEtBQVgsQ0FBbkIsQ0FBQTtHQUFuQyxDQUFBOztFQUVBLEtBQUssQ0FBQyxTQUFOLEdBQWtCOztJQUVoQixlQUFlLEVBQUUsUUFGRDtJQUdoQixzQkFBc0IsRUFBdEIsc0JBSGdCO0lBSWhCLGFBQWEsRUFBRSxJQUFBO0dBSmpCLENBQUE7Q0FNRDs7QUFFRCxTQUFTLGFBQVQsQ0FBQSxJQUFBLEVBQWdILEtBQWhILEVBQXVJO0VBQUEsSUFBN0csV0FBNkcsR0FBQSxJQUFBLENBQTdHLFdBQTZHO01BQWhHLE9BQWdHLEdBQUEsSUFBQSxDQUFoRyxPQUFnRztNQUF2RixLQUF1RixHQUFBLElBQUEsQ0FBdkYsS0FBdUY7TUFBaEYsV0FBZ0YsR0FBQSxJQUFBLENBQWhGLFdBQWdGLENBQUE7O0VBQ3JJLElBQUksV0FBVyxDQUFDLFdBQVosRUFBSixFQUErQjtJQUFFLE9BQUE7R0FBUTs7RUFFekMsSUFBTSxVQUFVLEdBQUcsYUFBYSxDQUFDLFdBQUQsRUFBYyxPQUFkLEVBQXVCLEtBQXZCLEVBQThCLFdBQTlCLEVBQTJDLEtBQTNDLENBQWhDLENBQUE7RUFDQSxPQUFPLENBQUMsV0FBRCxFQUFjLFVBQWQsRUFBMEIsS0FBMUIsQ0FBUCxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxhQUFULENBQUEsS0FBQSxFQUFnSCxLQUFoSCxFQUF1STtFQUFBLElBQTdHLFdBQTZHLEdBQUEsS0FBQSxDQUE3RyxXQUE2RztNQUFoRyxPQUFnRyxHQUFBLEtBQUEsQ0FBaEcsT0FBZ0c7TUFBdkYsS0FBdUYsR0FBQSxLQUFBLENBQXZGLEtBQXVGO01BQWhGLFdBQWdGLEdBQUEsS0FBQSxDQUFoRixXQUFnRixDQUFBOztFQUNySSxJQUFJLFdBQVcsQ0FBQyxXQUFaLEtBQTRCLE9BQTVCLElBQ0EsV0FBVyxDQUFDLGFBRFosSUFFQSxXQUFXLENBQUMsV0FBWixFQUZKLEVBRStCO0lBQUUsT0FBQTtHQUFROztFQUV6QyxJQUFNLFVBQVUsR0FBRyxhQUFhLENBQUMsV0FBRCxFQUFjLE9BQWQsRUFBdUIsS0FBdkIsRUFBOEIsV0FBOUIsRUFBK0QsS0FBL0QsQ0FBaEMsQ0FBQTtFQUNBLE9BQU8sQ0FBQyxXQUFELEVBQWMsVUFBZCxFQUEwQixLQUExQixDQUFQLENBQUE7Q0FDRDs7QUFFRCxTQUFTLFdBQVQsQ0FBc0IsR0FBdEIsRUFBcUUsS0FBckUsRUFBNEY7RUFBQSxJQUNsRixXQURrRixHQUNsRSxHQURrRSxDQUNsRixXQURrRixDQUFBOztFQUcxRixJQUFJLENBQUMsV0FBVyxDQUFDLGFBQWIsSUFDQSxXQUFXLENBQUMsV0FBWixFQURBLElBRUEsQ0FBQyxXQUFXLENBQUMsZUFGYixJQUdBLENBQUMsV0FBVyxDQUFDLFFBQVosQ0FBcUIsSUFIMUIsRUFHZ0M7SUFDOUIsT0FBQTtHQUNEOztFQUVELEtBQUssQ0FBQyxJQUFOLENBQVcsd0JBQVgsRUFBcUMsR0FBckMsQ0FBQSxDQUFBO0VBVjBGLElBWWxGLFlBWmtGLEdBWWpFLFdBWmlFLENBWWxGLFlBWmtGLENBQUE7RUFhMUYsSUFBTSxVQUFVLEdBQUcsV0FBVyxDQUFDLFFBQVosQ0FBcUIsSUFBeEMsQ0FBQTs7RUFFQSxJQUFJLFVBQVUsSUFBSSxZQUFsQixFQUFnQzs7SUFFOUIsSUFBSSxZQUFZLENBQUMsT0FBYixDQUFxQixVQUFyQixDQUFBLENBQWlDLFdBQWpDLElBQ0EsQ0FBQyxzQkFBc0IsQ0FBQyxZQUFELEVBQWUsV0FBVyxDQUFDLE9BQTNCLEVBQW9DLFdBQVcsQ0FBQyxRQUFoRCxFQUEwRCxLQUExRCxDQUQzQixFQUM2RjtNQUMzRixXQUFXLENBQUMsSUFBWixFQUFBLENBQUE7S0FGRixNQUlLO01BQ0gsV0FBVyxDQUFDLEtBQVosQ0FBa0IsV0FBVyxDQUFDLFFBQTlCLEVBQXdDLFlBQXhDLEVBQXNELFdBQVcsQ0FBQyxPQUFsRSxDQUFBLENBQUE7TUFDQSxvQkFBb0IsQ0FBQyxXQUFELEVBQWMsS0FBZCxDQUFwQixDQUFBO0tBQ0Q7R0FDRjtDQUNGOztBQUVELFNBQVMsaUJBQVQsQ0FBQSxLQUFBLEVBQW9GLEtBQXBGLEVBQTJHO0VBQUEsSUFBN0UsV0FBNkUsR0FBQSxLQUFBLENBQTdFLFdBQTZFLENBQUE7RUFBQSxJQUNqRyxZQURpRyxHQUNoRixXQURnRixDQUNqRyxZQURpRyxDQUFBOztFQUd6RyxJQUFJLFlBQVksSUFBSSxZQUFZLENBQUMsT0FBYixDQUFxQixXQUF6QyxFQUFzRDtJQUNwRCxTQUFTLENBQUMsV0FBVyxDQUFDLE9BQWIsRUFBc0IsRUFBdEIsRUFBMEIsS0FBMUIsQ0FBVCxDQUFBO0dBQ0Q7Ozs7O0FBS0gsU0FBUyxjQUFULENBQ0UsTUFERixFQUVFLFlBRkYsRUFHRSxPQUhGLEVBSUUsV0FKRixFQUtFLEtBTEYsRUFNRTtFQUNBLElBQUksWUFBWSxDQUFDLGVBQWIsQ0FBNkIsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsTUFBTSxDQUFDLElBQTVCLENBQTdCLEVBQWdFLE9BQWhFLEVBQXlFLFdBQXpFLENBQUEsSUFDQSxZQUFZLENBQUMsT0FBYixDQUFxQixNQUFNLENBQUMsSUFBNUIsQ0FBQSxDQUFrQyxPQURsQyxJQUVBLHNCQUFzQixDQUFDLFlBQUQsRUFBZSxPQUFmLEVBQXdCLE1BQXhCLEVBQWdDLEtBQWhDLENBRjFCLEVBRWtFO0lBQ2hFLE9BQU8sTUFBUCxDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxJQUFQLENBQUE7Q0FDRDs7QUFFRCxTQUFTLGVBQVQsQ0FDRSxXQURGLEVBRUUsT0FGRixFQUdFLEtBSEYsRUFJRSxPQUpGLEVBS0UsYUFMRixFQU1FLFdBTkYsRUFPRSxLQVBGLEVBUUU7RUFDQSxLQUFLLElBQUksQ0FBQyxHQUFHLENBQVIsRUFBVyxHQUFHLEdBQUcsT0FBTyxDQUFDLE1BQTlCLEVBQXNDLENBQUMsR0FBRyxHQUExQyxFQUErQyxDQUFDLEVBQWhELEVBQW9EO0lBQ2xELElBQU0sS0FBSyxHQUFHLE9BQU8sQ0FBQyxDQUFELENBQXJCLENBQUE7SUFDQSxJQUFNLFlBQVksR0FBRyxhQUFhLENBQUMsQ0FBRCxDQUFsQyxDQUFBO0lBQ0EsSUFBTSxXQUFXLEdBQUcsS0FBSyxDQUFDLFNBQU4sQ0FBZ0IsT0FBaEIsRUFBeUIsS0FBekIsRUFBZ0MsV0FBaEMsRUFBNkMsWUFBN0MsQ0FBcEIsQ0FBQTs7SUFFQSxJQUFJLENBQUMsV0FBTCxFQUFrQjtNQUFFLFNBQUE7S0FBVTs7SUFFOUIsSUFBTSxNQUFNLEdBQUcsY0FBYyxDQUMzQixXQUQyQixFQUUzQixLQUYyQixFQUczQixZQUgyQixFQUkzQixXQUoyQixFQUszQixLQUwyQixDQUE3QixDQUFBOztJQU9BLElBQUksTUFBSixFQUFZO01BQ1YsT0FBTztRQUNMLE1BQU0sRUFBTixNQURLO1FBRUwsWUFBWSxFQUFFLEtBRlQ7UUFHTCxPQUFPLEVBQUUsWUFBQTtPQUhYLENBQUE7S0FLRDtHQUNGOztFQUVELE9BQU87SUFBRSxNQUFNLEVBQUUsSUFBVjtJQUFnQixZQUFZLEVBQUUsSUFBOUI7SUFBb0MsT0FBTyxFQUFFLElBQUE7R0FBcEQsQ0FBQTtDQUNEOztBQUVELFNBQVMsYUFBVCxDQUNFLFdBREYsRUFFRSxPQUZGLEVBR0UsS0FIRixFQUlFLFdBSkYsRUFLRSxLQUxGLEVBTUU7RUFDQSxJQUFJLE9BQWdDLEdBQUcsRUFBdkMsQ0FBQTtFQUNBLElBQUksYUFBaUMsR0FBRyxFQUF4QyxDQUFBO0VBRUEsSUFBSSxPQUFPLEdBQUcsV0FBZCxDQUFBOztFQUVBLFNBQVMsV0FBVCxDQUFzQixZQUF0QixFQUEyRDtJQUN6RCxPQUFPLENBQUMsSUFBUixDQUFhLFlBQWIsQ0FBQSxDQUFBO0lBQ0EsYUFBYSxDQUFDLElBQWQsQ0FBbUIsT0FBbkIsQ0FBQSxDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxTQUFLLENBQUMsRUFBTixDQUFTLE9BQVQsQ0FBaUIsT0FBakIsQ0FBUCxFQUFrQztJQUNoQyxPQUFPLEdBQUcsRUFBVixDQUFBO0lBQ0EsYUFBYSxHQUFHLEVBQWhCLENBQUE7SUFFQSxLQUFLLENBQUMsYUFBTixDQUFvQixZQUFwQixDQUFpQyxPQUFqQyxFQUEwQyxXQUExQyxDQUFBLENBQUE7SUFFQSxJQUFNLFVBQVUsR0FBRyxlQUFlLENBQUMsV0FBRCxFQUFjLE9BQWQsRUFBdUIsS0FBdkIsRUFBOEIsT0FBOUIsRUFBdUMsYUFBdkMsRUFBc0QsV0FBdEQsRUFBbUUsS0FBbkUsQ0FBbEMsQ0FBQTs7SUFFQSxJQUFJLFVBQVUsQ0FBQyxNQUFYLElBQ0YsQ0FBQyxVQUFVLENBQUMsWUFBWCxDQUF3QixPQUF4QixDQUFnQyxVQUFVLENBQUMsTUFBWCxDQUFrQixJQUFsRCxDQUFBLENBQXdELFdBRDNELEVBQ3dFO01BQ3RFLE9BQU8sVUFBUCxDQUFBO0tBQ0Q7O0lBRUQsT0FBTyxHQUFHLFNBQUssQ0FBQyxHQUFOLENBQVUsVUFBVixDQUFxQixPQUFyQixDQUFWLENBQUE7R0FDRDs7RUFFRCxPQUFPO0lBQUUsTUFBTSxFQUFFLElBQVY7SUFBZ0IsWUFBWSxFQUFFLElBQTlCO0lBQW9DLE9BQU8sRUFBRSxJQUFBO0dBQXBELENBQUE7Q0FDRDs7QUFFRCxTQUFTLE9BQVQsQ0FDRSxXQURGLEVBQUEsS0FBQSxFQU9FLEtBUEYsRUFRRTtFQUFBLElBTkUsTUFNRixHQUFBLEtBQUEsQ0FORSxNQU1GO01BTlUsWUFNVixHQUFBLEtBQUEsQ0FOVSxZQU1WO01BTndCLE9BTXhCLEdBQUEsS0FBQSxDQU53QixPQU14QixDQUFBO0VBQ0EsTUFBTSxHQUFHLE1BQU0sSUFBSTtJQUFFLElBQUksRUFBRSxJQUFBO0dBQTNCLENBQUE7RUFFQSxXQUFXLENBQUMsWUFBWixHQUEyQixZQUEzQixDQUFBO0VBQ0EsV0FBVyxDQUFDLE9BQVosR0FBc0IsT0FBdEIsQ0FBQTtFQUNBLFNBQUssQ0FBQyxVQUFOLENBQWlCLFdBQVcsQ0FBQyxRQUE3QixFQUF1QyxNQUF2QyxDQUFBLENBQUE7RUFFQSxXQUFXLENBQUMsSUFBWixHQUFtQixZQUFZLElBQUksTUFBTSxDQUFDLElBQXZCLEdBQ2YsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsT0FBckIsQ0FEZSxHQUVmLElBRkosQ0FBQTtFQUlBLG9CQUFvQixDQUFDLFdBQUQsRUFBYyxLQUFkLENBQXBCLENBQUE7RUFFQSxLQUFLLENBQUMsSUFBTixDQUFXLG9CQUFYLEVBQWlDO0lBQUUsV0FBVyxFQUFYLFdBQUE7R0FBbkMsQ0FBQSxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxzQkFBVCxDQUNFLFlBREYsRUFFRSxPQUZGLEVBR0UsTUFIRixFQUlFLEtBSkYsRUFLRTtFQUNBLElBQU0sT0FBTyxHQUFHLFlBQVksQ0FBQyxPQUE3QixDQUFBO0VBQ0EsSUFBTSxVQUFVLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxJQUFSLENBQVAsQ0FBcUIsR0FBeEMsQ0FBQTtFQUNBLElBQU0sYUFBYSxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUMsSUFBUixDQUFQLENBQXFCLGFBQTNDLENBQUE7RUFDQSxJQUFNLFlBQVksR0FBRyxLQUFLLENBQUMsU0FBTixDQUFnQixlQUFyQyxDQUFBO0VBQ0EsSUFBSSxrQkFBa0IsR0FBRyxDQUF6QixDQUFBO0VBQ0EsSUFBSSxpQkFBaUIsR0FBRyxDQUF4QixDQUFBO0VBQ0EsSUFBSSxZQUFZLEdBQUcsQ0FBbkIsQ0FQQTs7RUFVQSxJQUFJLEVBQUUsVUFBVSxJQUFJLGFBQWQsSUFBK0IsWUFBakMsQ0FBSixFQUFvRDtJQUFFLE9BQU8sS0FBUCxDQUFBO0dBQWM7O0VBRXBFLEtBQUEsSUFBQSxFQUFBLEdBQUEsQ0FBQSxFQUFBLEVBQUEsR0FBMEIsS0FBSyxDQUFDLFlBQU4sQ0FBbUIsSUFBN0MsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQW1EO0lBQUEsSUFBQSxLQUFBLENBQUE7O0lBQUEsS0FBQSxHQUF6QixLQUFLLENBQUMsWUFBTixDQUFtQixJQUFNLENBQUEsRUFBQSxDQUFBLENBQUE7SUFBQSxJQUF4QyxXQUF3QyxHQUFBLEtBQUEsQ0FBQTtJQUNqRCxJQUFNLFdBQVcsR0FBRyxXQUFXLENBQUMsUUFBWixDQUFxQixJQUF6QyxDQUFBOztJQUVBLElBQUksQ0FBQyxXQUFXLENBQUMsV0FBWixFQUFMLEVBQWdDO01BQUUsU0FBQTtLQUFVOztJQUU1QyxrQkFBa0IsRUFBQSxDQUFBOztJQUVsQixJQUFJLGtCQUFrQixJQUFJLFlBQTFCLEVBQXdDO01BQ3RDLE9BQU8sS0FBUCxDQUFBO0tBQ0Q7O0lBRUQsSUFBSSxXQUFXLENBQUMsWUFBWixLQUE2QixZQUFqQyxFQUErQztNQUFFLFNBQUE7S0FBVTs7SUFFM0QsaUJBQWlCLElBQUksV0FBVyxLQUFLLE1BQU0sQ0FBQyxJQUF2QixHQUE4QixDQUE5QixHQUFrQyxDQUF2RCxDQUFBOztJQUVBLElBQUksaUJBQWlCLElBQUksVUFBekIsRUFBcUM7TUFDbkMsT0FBTyxLQUFQLENBQUE7S0FDRDs7SUFFRCxJQUFJLFdBQVcsQ0FBQyxPQUFaLEtBQXdCLE9BQTVCLEVBQXFDO01BQ25DLFlBQVksRUFBQSxDQUFBOztNQUVaLElBQUksV0FBVyxLQUFLLE1BQU0sQ0FBQyxJQUF2QixJQUErQixZQUFZLElBQUksYUFBbkQsRUFBa0U7UUFDaEUsT0FBTyxLQUFQLENBQUE7T0FDRDtLQUNGO0dBQ0Y7O0VBRUQsT0FBTyxZQUFZLEdBQUcsQ0FBdEIsQ0FBQTtDQUNEOztBQUVELFNBQVMsZUFBVCxDQUEwQixRQUExQixFQUF5QyxLQUF6QyxFQUFnRTtFQUM5RCxJQUFJLFNBQUssQ0FBQyxFQUFOLENBQVMsTUFBVCxDQUFnQixRQUFoQixDQUFKLEVBQStCO0lBQzdCLEtBQUssQ0FBQyxTQUFOLENBQWdCLGVBQWhCLEdBQWtDLFFBQWxDLENBQUE7SUFFQSxPQUFPLElBQVAsQ0FBQTtHQUNEOztFQUVELE9BQU8sS0FBSyxDQUFDLFNBQU4sQ0FBZ0IsZUFBdkIsQ0FBQTtDQUNEOztBQUVELFNBQVMsU0FBVCxDQUFvQixPQUFwQixFQUErQyxNQUEvQyxFQUErRCxLQUEvRCxFQUFzRjtFQUFBLElBQzdELGlCQUQ2RCxHQUN2QyxLQUFLLENBQUMsU0FEaUMsQ0FDNUUsYUFENEUsQ0FBQTs7RUFHcEYsSUFBSSxpQkFBaUIsSUFBSSxpQkFBaUIsS0FBSyxPQUEvQyxFQUF3RDtJQUN0RCxpQkFBaUIsQ0FBQyxLQUFsQixDQUF3QixNQUF4QixHQUFpQyxFQUFqQyxDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxDQUFDLGFBQVIsQ0FBc0IsZUFBdEIsQ0FBc0MsS0FBdEMsQ0FBNEMsTUFBNUMsR0FBcUQsTUFBckQsQ0FBQTtFQUNBLE9BQU8sQ0FBQyxLQUFSLENBQWMsTUFBZCxHQUF1QixNQUF2QixDQUFBO0VBQ0EsS0FBSyxDQUFDLFNBQU4sQ0FBZ0IsYUFBaEIsR0FBZ0MsTUFBTSxHQUFHLE9BQUgsR0FBYSxJQUFuRCxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxvQkFBVCxDQUE4RCxXQUE5RCxFQUFvRyxLQUFwRyxFQUEySDtFQUFBLElBQ2pILFlBRGlILEdBQzdFLFdBRDZFLENBQ2pILFlBRGlIO01BQ25HLE9BRG1HLEdBQzdFLFdBRDZFLENBQ25HLE9BRG1HO01BQzFGLFFBRDBGLEdBQzdFLFdBRDZFLENBQzFGLFFBRDBGLENBQUE7O0VBR3pILElBQUksRUFBRSxXQUFXLENBQUMsV0FBWixLQUE0QixPQUE1QixJQUF1QyxZQUF2QyxJQUF1RCxZQUFZLENBQUMsT0FBYixDQUFxQixXQUE5RSxDQUFKLEVBQWdHOztJQUU5RixJQUFJLEtBQUssQ0FBQyxTQUFOLENBQWdCLGFBQXBCLEVBQW1DO01BQ2pDLFNBQVMsQ0FBQyxLQUFLLENBQUMsU0FBTixDQUFnQixhQUFqQixFQUFnQyxFQUFoQyxFQUFvQyxLQUFwQyxDQUFULENBQUE7S0FDRDs7SUFFRCxPQUFBO0dBQ0Q7O0VBRUQsSUFBSSxNQUFNLEdBQUcsRUFBYixDQUFBOztFQUVBLElBQUksUUFBUSxDQUFDLElBQWIsRUFBbUI7SUFDakIsSUFBTSxhQUFxQyxHQUFHLFlBQVksQ0FBQyxPQUFiLENBQXFCLFFBQVEsQ0FBQyxJQUE5QixDQUFBLENBQW9DLGFBQWxGLENBQUE7O0lBRUEsSUFBSSxTQUFLLENBQUMsRUFBTixDQUFTLElBQVQsQ0FBYyxhQUFkLENBQUosRUFBa0M7TUFDaEMsTUFBTSxHQUFHLGFBQWEsQ0FBQyxRQUFELEVBQVcsWUFBWCxFQUF5QixPQUF6QixFQUFrQyxXQUFXLENBQUMsWUFBOUMsQ0FBdEIsQ0FBQTtLQURGLE1BR0s7TUFDSCxNQUFNLEdBQUcsS0FBSyxDQUFDLE9BQU4sQ0FBYyxHQUFkLENBQWtCLFFBQVEsQ0FBQyxJQUEzQixDQUFBLENBQWlDLFNBQWpDLENBQTJDLFFBQTNDLENBQVQsQ0FBQTtLQUNEO0dBQ0Y7O0VBRUQsU0FBUyxDQUFDLFdBQVcsQ0FBQyxPQUFiLEVBQXNCLE1BQU0sSUFBSSxFQUFoQyxFQUFvQyxLQUFwQyxDQUFULENBQUE7Q0FDRDs7QUFFRCxJQUFNLFNBQTBCLEdBQUc7RUFDakMsRUFBRSxFQUFFLGlCQUQ2QjtFQUVqQyxNQUFNLEVBQUUsQ0FBQyxTQUFELEVBQVksY0FBWixFQUE0QixnQkFBNUIsRUFBOEMsaUJBQTlDLENBRnlCO0VBR2pDLE9BQU8sRUFBUCxXQUhpQztFQUlqQyxTQUFTLEVBQUU7SUFDVCxtQkFBQSxFQUFxQixhQURaO0lBRVQsbUJBQUEsRUFBcUIsU0FBQSxnQkFBQSxDQUFDLEdBQUQsRUFBTSxLQUFOLEVBQWdCO01BQ25DLGFBQWEsQ0FBQyxHQUFELEVBQU0sS0FBTixDQUFiLENBQUE7TUFDQSxXQUFXLENBQUMsR0FBRCxFQUFNLEtBQU4sQ0FBWCxDQUFBO0tBSk87SUFNVCxtQkFBQSxFQUFxQixpQkFBQTtHQVZVO0VBWWpDLGVBQWUsRUFBZixlQVppQztFQWFqQyxzQkFBc0IsRUFBdEIsc0JBYmlDO0VBY2pDLGNBQWMsRUFBZCxjQUFBO0NBZEYsQ0FBQTttQkFpQmU7Ozs7Ozs7Ozs7Ozs7QUM5WGYsMEVBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsNEJBQUEsQ0FBQSxPQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLEtBQUEsR0FBQSwyQkFBQSxDQUFBLFFBQUEsQ0FBQSxDQUFBOzs7Ozs7OztBQUVBLFNBQVMsV0FBVCxDQUFBLElBQUEsRUFBc0csS0FBdEcsRUFBNkg7RUFBQSxJQUFyRyxXQUFxRyxHQUFBLElBQUEsQ0FBckcsV0FBcUc7TUFBeEYsV0FBd0YsR0FBQSxJQUFBLENBQXhGLFdBQXdGO01BQTNFLEVBQTJFLEdBQUEsSUFBQSxDQUEzRSxFQUEyRTtNQUF2RSxFQUF1RSxHQUFBLElBQUEsQ0FBdkUsRUFBdUUsQ0FBQTs7RUFDM0gsSUFBSSxXQUFXLENBQUMsUUFBWixDQUFxQixJQUFyQixLQUE4QixNQUFsQyxFQUEwQztJQUFFLE9BQUE7R0FEK0U7OztFQUkzSCxJQUFNLElBQUksR0FBRyxJQUFJLENBQUMsR0FBTCxDQUFTLEVBQVQsQ0FBYixDQUFBO0VBQ0EsSUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLEdBQUwsQ0FBUyxFQUFULENBQWIsQ0FBQTtFQUNBLElBQU0sYUFBYSxHQUFHLFdBQVcsQ0FBQyxZQUFaLENBQXlCLE9BQXpCLENBQWlDLElBQXZELENBQUE7RUFDQSxJQUFNLFNBQVMsR0FBRyxhQUFhLENBQUMsU0FBaEMsQ0FBQTtFQUNBLElBQU0sV0FBVyxHQUFJLElBQUksR0FBRyxJQUFQLEdBQWMsR0FBZCxHQUFvQixJQUFJLEdBQUcsSUFBUCxHQUFjLEdBQWQsR0FBb0IsSUFBN0QsQ0FBQTtFQUVBLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQXJCLEdBQTRCLGFBQWEsQ0FBQyxRQUFkLEtBQTJCLE9BQTNCLEdBQ3hCLFdBQVcsQ0FBQyxDQUFELENBRGE7SUFFeEIsYUFBYSxDQUFDLFFBRmxCLENBVjJIOztFQWUzSCxJQUFJLFdBQVcsS0FBSyxJQUFoQixJQUF3QixTQUFTLEtBQUssSUFBdEMsSUFBOEMsU0FBUyxLQUFLLFdBQWhFLEVBQTZFOztJQUUzRSxXQUFXLENBQUMsUUFBWixDQUFxQixJQUFyQixHQUE0QixJQUE1QixDQUYyRTs7SUFLM0UsSUFBSSxPQUFPLEdBQUcsV0FBZCxDQUFBOztJQUVBLElBQU0sWUFBWSxHQUFHLFNBQWYsWUFBZSxDQUFVLFlBQVYsRUFBNkU7TUFDaEcsSUFBSSxZQUFZLEtBQUssV0FBVyxDQUFDLFlBQWpDLEVBQStDO1FBQUUsT0FBQTtPQUFROztNQUV6RCxJQUFNLE9BQU8sR0FBRyxXQUFXLENBQUMsWUFBWixDQUF5QixPQUF6QixDQUFpQyxJQUFqRCxDQUFBOztNQUVBLElBQUksQ0FBQyxPQUFPLENBQUMsV0FBVCxJQUNBLFlBQVksQ0FBQyxlQUFiLENBQTZCLE9BQTdCLEVBQXNDLE9BQXRDLEVBQStDLFdBQS9DLENBREosRUFDaUU7UUFDL0QsSUFBTSxNQUFNLEdBQUcsWUFBWSxDQUFDLFNBQWIsQ0FDYixXQUFXLENBQUMsV0FEQyxFQUNZLFdBQVcsQ0FBQyxTQUR4QixFQUNtQyxXQURuQyxFQUNnRCxPQURoRCxDQUFmLENBQUE7O1FBR0EsSUFBSSxNQUFNLElBQ04sTUFBTSxDQUFDLElBQVAsS0FBZ0IsTUFEaEIsSUFFQSxjQUFjLENBQUMsV0FBRCxFQUFjLFlBQWQsQ0FGZCxJQUdBLEtBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBVSxjQUFWLENBQXlCLE1BQXpCLEVBQWlDLFlBQWpDLEVBQStDLE9BQS9DLEVBQXdELFdBQXhELEVBQXFFLEtBQXJFLENBSEosRUFHaUY7VUFDL0UsT0FBTyxZQUFQLENBQUE7U0FDRDtPQUNGO0tBaEJILENBUDJFOzs7SUEyQjNFLE9BQU8sT0FBRSxDQUFDLE9BQUgsQ0FBVyxPQUFYLENBQVAsRUFBNEI7TUFDMUIsSUFBTSxZQUFZLEdBQUcsS0FBSyxDQUFDLGFBQU4sQ0FBb0IsWUFBcEIsQ0FBaUMsT0FBakMsRUFBMEMsWUFBMUMsQ0FBckIsQ0FBQTs7TUFFQSxJQUFJLFlBQUosRUFBa0I7UUFDaEIsV0FBVyxDQUFDLFFBQVosQ0FBcUIsSUFBckIsR0FBNEIsTUFBNUIsQ0FBQTtRQUNBLFdBQVcsQ0FBQyxZQUFaLEdBQTJCLFlBQTNCLENBQUE7UUFDQSxXQUFXLENBQUMsT0FBWixHQUFzQixPQUF0QixDQUFBO1FBQ0EsTUFBQTtPQUNEOztNQUVELE9BQU8sR0FBRyxDQUFBLENBQUEsRUFBQSxhQUFBLENBQUEsVUFBQSxFQUFXLE9BQVgsQ0FBVixDQUFBO0tBQ0Q7R0FDRjtDQUNGOztBQUVELFNBQVMsY0FBVCxDQUF5QixTQUF6QixFQUE0QyxZQUE1QyxFQUFpRjtFQUMvRSxJQUFJLENBQUMsWUFBTCxFQUFtQjtJQUFFLE9BQU8sS0FBUCxDQUFBO0dBQWM7O0VBRW5DLElBQU0sUUFBUSxHQUFHLFlBQVksQ0FBQyxPQUFiLENBQXFCLElBQXJCLENBQTBCLFNBQTNDLENBQUE7RUFFQSxPQUFRLFNBQVMsS0FBSyxJQUFkLElBQXNCLFFBQVEsS0FBSyxJQUFuQyxJQUEyQyxRQUFRLEtBQUssU0FBaEUsQ0FBQTtDQUNEOztvQkFFYztFQUNiLEVBQUUsRUFBRSxxQkFEUztFQUViLFNBQVMsRUFBRTtJQUFFLHdCQUFBLEVBQTBCLFdBQUE7R0FBNUI7Ozs7Ozs7Ozs7OztBQ3ZFYixJQUFBLFVBQUEsR0FBQSwyQkFBQSxDQUFBLFFBQUEsQ0FBQSxDQUFBOzs7O0FBZUEsU0FBUyxZQUFULENBQWtCLEtBQWxCLEVBQXlDO0VBQUEsSUFFckMsUUFGcUMsR0FHbkMsS0FIbUMsQ0FFckMsUUFGcUMsQ0FBQTtFQUt2QyxLQUFLLENBQUMsU0FBTixDQUFnQixVQUFBLENBQUEsU0FBQSxDQUFoQixDQUFBLENBQUE7RUFFQSxRQUFRLENBQUMsU0FBVCxDQUFtQixJQUFuQixHQUEwQixDQUExQixDQUFBO0VBQ0EsUUFBUSxDQUFDLFNBQVQsQ0FBbUIsS0FBbkIsR0FBMkIsQ0FBM0IsQ0FBQTtDQUNEOztBQUVELFNBQVMsZUFBVCxDQUEwQixXQUExQixFQUF1QztFQUNyQyxJQUFNLFVBQVUsR0FBRyxXQUFXLENBQUMsUUFBWixJQUF3QixXQUFXLENBQUMsUUFBWixDQUFxQixJQUFoRSxDQUFBOztFQUVBLElBQUksQ0FBQyxVQUFMLEVBQWlCO0lBQUUsT0FBTyxJQUFQLENBQUE7R0FBYTs7RUFFaEMsSUFBTSxPQUFPLEdBQUcsV0FBVyxDQUFDLFlBQVosQ0FBeUIsT0FBekMsQ0FBQTtFQUVBLE9BQU8sT0FBTyxDQUFDLFVBQUQsQ0FBUCxDQUFvQixJQUFwQixJQUE0QixPQUFPLENBQUMsVUFBRCxDQUFQLENBQW9CLEtBQXZELENBQUE7Q0FDRDs7b0JBRWM7RUFDYixFQUFFLEVBQUUsaUJBRFM7RUFFYixPQUFPLEVBQVAsWUFGYTtFQUdiLFNBQVMsRUFBRTtJQUNULGtCQUFBLEVBQW9CLFNBQUEsZUFBQSxDQUFBLElBQUEsRUFBcUI7TUFBQSxJQUFsQixXQUFrQixHQUFBLElBQUEsQ0FBbEIsV0FBa0IsQ0FBQTtNQUN2QyxXQUFXLENBQUMsa0JBQVosR0FBaUMsSUFBakMsQ0FBQTtLQUZPO0lBS1Qsb0JBQUEsRUFBc0IsU0FBQSxpQkFBQSxDQUFBLEtBQUEsRUFBcUI7TUFBQSxJQUFsQixXQUFrQixHQUFBLEtBQUEsQ0FBbEIsV0FBa0IsQ0FBQTtNQUN6QyxJQUFNLElBQUksR0FBRyxlQUFlLENBQUMsV0FBRCxDQUE1QixDQUFBOztNQUVBLElBQUksSUFBSSxHQUFHLENBQVgsRUFBYztRQUNaLFdBQVcsQ0FBQyxrQkFBWixHQUFpQyxVQUFVLENBQUMsWUFBTTtVQUNoRCxXQUFXLENBQUMsS0FBWixDQUFrQixXQUFXLENBQUMsUUFBOUIsRUFBd0MsV0FBVyxDQUFDLFlBQXBELEVBQWtFLFdBQVcsQ0FBQyxPQUE5RSxDQUFBLENBQUE7U0FEeUMsRUFFeEMsSUFGd0MsQ0FBM0MsQ0FBQTtPQUdEO0tBWk07SUFlVCxtQkFBQSxFQUFxQixTQUFBLGdCQUFBLENBQUEsS0FBQSxFQUFnQztNQUFBLElBQTdCLFdBQTZCLEdBQUEsS0FBQSxDQUE3QixXQUE2QjtVQUFoQixTQUFnQixHQUFBLEtBQUEsQ0FBaEIsU0FBZ0IsQ0FBQTs7TUFDbkQsSUFBSSxXQUFXLENBQUMsZUFBWixJQUErQixDQUFDLFNBQXBDLEVBQStDO1FBQzdDLFlBQVksQ0FBQyxXQUFXLENBQUMsa0JBQWIsQ0FBWixDQUFBO09BQ0Q7S0FsQk07O0lBc0JULHdCQUFBLEVBQTBCLFNBQUEsb0JBQUEsQ0FBQSxLQUFBLEVBQXFCO01BQUEsSUFBbEIsV0FBa0IsR0FBQSxLQUFBLENBQWxCLFdBQWtCLENBQUE7TUFDN0MsSUFBTSxJQUFJLEdBQUcsZUFBZSxDQUFDLFdBQUQsQ0FBNUIsQ0FBQTs7TUFFQSxJQUFJLElBQUksR0FBRyxDQUFYLEVBQWM7UUFDWixXQUFXLENBQUMsUUFBWixDQUFxQixJQUFyQixHQUE0QixJQUE1QixDQUFBO09BQ0Q7S0FDRjtHQS9CVTtFQWlDYixlQUFlLEVBQWYsZUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDckVGLElBQUEsVUFBQSxHQUFBLDJCQUFBLENBQUEsUUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxTQUFBLEdBQUEsMkJBQUEsQ0FBQSxhQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLEtBQUEsR0FBQSwyQkFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFBOzs7O29CQUVlO0VBQ2IsRUFBRSxFQUFFLFlBRFM7RUFFYixPQUZhLEVBQUEsU0FBQSxPQUFBLENBRUosS0FGSSxFQUVHO0lBQ2QsS0FBSyxDQUFDLFNBQU4sQ0FBZ0IsVUFBQSxDQUFBLFNBQUEsQ0FBaEIsQ0FBQSxDQUFBO0lBQ0EsS0FBSyxDQUFDLFNBQU4sQ0FBZ0IsS0FBQSxDQUFBLFNBQUEsQ0FBaEIsQ0FBQSxDQUFBO0lBQ0EsS0FBSyxDQUFDLFNBQU4sQ0FBZ0IsU0FBQSxDQUFBLFNBQUEsQ0FBaEIsQ0FBQSxDQUFBO0dBQ0Q7Ozs7Ozs7Ozs7Ozs7O0FDUkgsSUFBQSxnQkFBQSxHQUFBLDJCQUFBLENBQUEsZUFBQSxDQUFBLENBQUE7O0FBQ0EsMEVBQUE7O0FBQ0EsSUFBQSxZQUFBLEdBQUEsMkJBQUEsQ0FBQSxXQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLE9BQUEsR0FBQSw0QkFBQSxDQUFBLE9BQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7SUFxQ0s7O1dBQUE7RUFBQTtFQUFBO0VBQUE7R0FBQSxjQUFBOztBQU1MLElBQU0sTUFBTSxHQUFJLGdCQUFoQixDQUFBO0FBQ0EsSUFBTSxLQUFLLEdBQUc7RUFDWixXQUFXLEVBQUUsK0RBREQ7RUFFWixTQUFTLEVBQUUsNkRBQUE7Q0FGYixDQUFBO0FBS0EsSUFBTSxZQUFZLEdBQUcsWUFBQSxLQUF5QixZQUE5Qzs7QUFHQSxTQUFTLFlBQVQsQ0FBa0IsS0FBbEIsRUFBK0U7RUFBQSxJQUFBLElBQUEsR0FBQSxTQUFBLENBQUEsTUFBQSxHQUFBLENBQUEsSUFBQSxTQUFBLENBQUEsQ0FBQSxDQUFBLEtBQUEsU0FBQSxHQUFBLFNBQUEsQ0FBQSxDQUFBLENBQUEsR0FBSixFQUFJO01BQXBDLE1BQW9DLEdBQUEsSUFBQSxDQUFwQyxNQUFvQyxDQUFBOztFQUFBLElBRTNFLFlBRjJFLEdBSXpFLEtBSnlFLENBRTNFLFlBRjJFO01BRzNFLFFBSDJFLEdBSXpFLEtBSnlFLENBRzNFLFFBSDJFLENBQUE7RUFNN0UsS0FBSyxDQUFDLE1BQU4sR0FBZSxNQUFNLElBQUksT0FBekIsQ0FBQTtFQUVBLFFBQVEsQ0FBQyxJQUFULENBQWMsUUFBZCxHQUF5QjtJQUN2QixNQUFNLEVBQUUsRUFBQTtHQURWLENBQUE7O0VBSUEsWUFBWSxDQUFDLFNBQWIsQ0FBdUIsUUFBdkIsR0FBa0MsVUFBVSxPQUFWLEVBQTRCO0lBQzVELElBQUksT0FBSixFQUFhO01BQ1gsQ0FBQSxDQUFBLEVBQUEsWUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLElBQUEsQ0FBSyxPQUFMLENBQWEsUUFBcEIsRUFBOEIsT0FBOUIsQ0FBQSxDQUFBO01BQ0EsT0FBTyxJQUFQLENBQUE7S0FDRDs7SUFFRCxPQUFPLElBQUEsQ0FBSyxPQUFMLENBQWEsUUFBcEIsQ0FBQTtHQU5GLENBQUE7Q0FRRDs7QUFFRCxJQUFNLE1BQWUsR0FBRyxDQUN0QjtFQUNFLElBQUksRUFBRSxTQUFTLENBQUMsV0FEbEI7RUFFRSxPQUZGLEVBQUEsU0FBQSxPQUFBLENBQUEsS0FBQSxFQUV3QjtJQUFBLElBQVgsT0FBVyxHQUFBLEtBQUEsQ0FBWCxPQUFXLENBQUE7SUFDcEIsT0FBTyxDQUFDLGNBQWMsQ0FBQyxPQUFELEVBQVUsYUFBVixFQUF5QixpQkFBekIsQ0FBdEIsQ0FBQTtHQUhKO0VBS0UsT0FMRixFQUFBLFNBQUEsT0FBQSxDQUFBLEtBQUEsRUFLd0I7SUFBQSxJQUFYLE9BQVcsR0FBQSxLQUFBLENBQVgsT0FBVyxDQUFBO0lBQ3BCLE9BQU8sQ0FDTCxPQURLLEVBRUwsS0FBSyxDQUFDLFdBRkQsQ0FBUCxDQUFBO0dBTko7RUFXRSxJQUFJLEVBQUUsNERBQUE7Q0FaYyxFQWV0QjtFQUNFLElBQUksRUFBRSxTQUFTLENBQUMsU0FEbEI7RUFFRSxPQUZGLEVBQUEsU0FBQSxPQUFBLENBRVcsV0FGWCxFQUV3QjtJQUFBLElBQ1osT0FEWSxHQUNBLFdBREEsQ0FDWixPQURZLENBQUE7SUFHcEIsT0FBTyxXQUFXLENBQUMsUUFBWixDQUFxQixJQUFyQixLQUE4QixRQUE5QixJQUNMLE9BQU8sWUFBWSxnQkFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFXLFdBRHpCLElBRUwsQ0FBQyxRQUFRLENBQUMsT0FBRCxFQUFVLFdBQVYsRUFBdUIsWUFBdkIsQ0FGWCxDQUFBO0dBTEo7RUFTRSxJQUFJLEVBQUUsd0VBVFI7RUFVRSxPQVZGLEVBQUEsU0FBQSxPQUFBLENBQUEsS0FBQSxFQVV3QjtJQUFBLElBQVgsT0FBVyxHQUFBLEtBQUEsQ0FBWCxPQUFXLENBQUE7SUFDcEIsT0FBTyxDQUNMLE9BREssRUFFTCxLQUFLLENBQUMsU0FGRCxDQUFQLENBQUE7R0FJRDtDQTlCbUIsRUFpQ3RCO0VBQ0UsSUFBSSxFQUFFLFNBQVMsQ0FBQyxXQURsQjtFQUVFLE9BRkYsRUFBQSxTQUFBLE9BQUEsQ0FFVyxXQUZYLEVBRXdCO0lBQ3BCLElBQU0sVUFBVSxHQUFHLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQXhDLENBQUE7SUFDQSxJQUFNLGFBQWEsR0FBRyxXQUFXLENBQUMsWUFBWixDQUF5QixNQUF6QixDQUFnQyxLQUFoQyxDQUFBLEVBQUEsQ0FBQSxNQUFBLENBQXlDLFVBQXpDLEVBQUEsTUFBQSxDQUFBLENBQUEsSUFBOEQsRUFBcEYsQ0FBQTtJQUVBLE9BQU8sQ0FBQyxhQUFhLENBQUMsTUFBdEIsQ0FBQTtHQU5KO0VBUUUsT0FSRixFQUFBLFNBQUEsT0FBQSxDQVFXLFdBUlgsRUFRd0I7SUFDcEIsT0FBTyxDQUNMLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBRGhCLEVBRUwsV0FBVyxDQUFDLFlBRlAsQ0FBUCxDQUFBO0dBVEo7RUFjRSxJQUFJLEVBQUUsNENBQUE7Q0EvQ2MsQ0FBeEIsQ0FBQTs7QUFtREEsU0FBUyxRQUFULENBQW1CLE9BQW5CLEVBQXlDLElBQXpDLEVBQTBFLE9BQTFFLEVBQTJGO0VBQ3pGLE9BQU8sT0FBTyxDQUFDLElBQVIsQ0FBYSxPQUFPLENBQUMsS0FBUixDQUFjLElBQWQsQ0FBQSxJQUF1QixZQUFBLENBQUEsU0FBQSxDQUFBLENBQUksTUFBSixDQUFXLGdCQUFYLENBQTRCLE9BQTVCLENBQUEsQ0FBcUMsSUFBckMsQ0FBcEMsQ0FBUCxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxjQUFULENBQXlCLE9BQXpCLEVBQW9ELElBQXBELEVBQXFGLE9BQXJGLEVBQXNHO0VBQ3BHLElBQUksTUFBTSxHQUFHLE9BQWIsQ0FBQTs7RUFFQSxPQUFPLE9BQUUsQ0FBQyxPQUFILENBQVcsTUFBWCxDQUFQLEVBQTJCO0lBQ3pCLElBQUksUUFBUSxDQUFDLE1BQUQsRUFBUyxJQUFULEVBQWUsT0FBZixDQUFaLEVBQXFDO01BQ25DLE9BQU8sSUFBUCxDQUFBO0tBQ0Q7O0lBRUQsTUFBTSxHQUFHLENBQUEsQ0FBQSxFQUFBLGFBQUEsQ0FBQSxVQUFBLEVBQVcsTUFBWCxDQUFULENBQUE7R0FDRDs7RUFFRCxPQUFPLEtBQVAsQ0FBQTtDQUNEOztBQUVELElBQU0sRUFBRSxHQUFHLFdBQVgsQ0FBQTtBQUNBLElBQU0sYUFBOEIsR0FBRyxZQUFZLEdBQy9DO0VBQUUsRUFBRSxFQUFGLEVBQUY7RUFBTSxPQUFPLEVBQUUsU0FBQSxPQUFBLEdBQU0sRUFBRTtDQUR3QixHQUUvQztFQUNBLEVBQUUsRUFBRixFQURBO0VBRUEsT0FBTyxFQUFQLFlBRkE7RUFHQSxTQUFTLEVBQUU7SUFDVCwyQkFBQSxFQUE2QixTQUFBLHVCQUFBLENBQUEsS0FBQSxFQUFrQixLQUFsQixFQUE0QjtNQUFBLElBQXpCLFdBQXlCLEdBQUEsS0FBQSxDQUF6QixXQUF5QixDQUFBOztNQUN2RCxLQUFBLElBQUEsRUFBQSxHQUFBLENBQUEsRUFBQSxFQUFBLEdBQW9CLE1BQXBCLENBQUEsTUFBQSxFQUFBLEVBQUEsRUFBQSxFQUE0QjtRQUFBLElBQUEsS0FBQSxDQUFBOztRQUFBLEtBQUEsR0FBUixNQUFRLENBQUEsRUFBQSxDQUFBLENBQUE7UUFBQSxJQUFqQixLQUFpQixHQUFBLEtBQUEsQ0FBQTtRQUMxQixJQUFNLE9BQU8sR0FBRyxXQUFXLENBQUMsWUFBWixJQUE0QixXQUFXLENBQUMsWUFBWixDQUF5QixPQUFyRSxDQUFBOztRQUVBLElBQ0UsRUFBRSxPQUFPLElBQUksT0FBTyxDQUFDLFFBQW5CLElBQStCLE9BQU8sQ0FBQyxRQUFSLENBQWlCLE1BQWpCLENBQXdCLEtBQUssQ0FBQyxJQUE5QixDQUFqQyxDQUFBLElBQ0EsS0FBSyxDQUFDLE9BQU4sQ0FBYyxXQUFkLENBRkYsRUFHRTtVQUFBLElBQUEsYUFBQSxDQUFBOztVQUNBLENBQUEsYUFBQSxHQUFBLEtBQUssQ0FBQyxNQUFOLEVBQWEsSUFBYixDQUFBLEtBQUEsQ0FBQSxhQUFBLEVBQUEsQ0FBa0IsTUFBTSxHQUFHLEtBQUssQ0FBQyxJQUFqQyxDQUFBLENBQUEsTUFBQSxDQUFBLHVCQUFBLENBQTBDLEtBQUssQ0FBQyxPQUFOLENBQWMsV0FBZCxDQUExQyxDQUFBLENBQUEsQ0FBQSxDQUFBO1NBQ0Q7T0FDRjtLQUNGO0dBZkg7RUFpQkEsTUFBTSxFQUFOLE1BakJBO0VBa0JBLFNBQVMsRUFBVCxTQWxCQTtFQW1CQSxLQUFLLEVBQUwsS0FuQkE7RUFvQkEsTUFBTSxFQUFOLE1BQUE7Q0F0QkosQ0FBQTtvQkF5QmU7Ozs7Ozs7Ozs7Ozs7O0FDL0tmLElBQUEsV0FBQSxHQUFBLDJCQUFBLENBQUEsVUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxZQUFBLEdBQUEsMkJBQUEsQ0FBQSxXQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFNBQUEsR0FBQSw0QkFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7SUFxQnFCO0VBUW5CLFNBQUEsWUFBQSxDQUFzQixXQUF0QixFQUFtRTtJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLFlBQUEsQ0FBQSxDQUFBOztJQUFBLElBQUEsQ0FBN0MsV0FBNkMsR0FBN0MsV0FBNkMsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxRQUFBLEVBUHpDLEVBT3lDLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxhQUFBLEVBTnRDO01BQUUsSUFBSSxFQUFFLENBQVI7TUFBVyxLQUFLLEVBQUUsQ0FBbEI7TUFBcUIsR0FBRyxFQUFFLENBQTFCO01BQTZCLE1BQU0sRUFBRSxDQUFBO0tBTUMsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLFlBQUEsRUFMdEMsSUFLc0MsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLFFBQUEsRUFKckMsSUFJcUMsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLFdBQUEsRUFIdEMsSUFHc0MsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLE9BQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUNqRSxJQUFBLENBQUssTUFBTCxHQUFjLFlBQVksRUFBMUIsQ0FBQTtHQUNEOzs7O2dDQUlDLFlBQ0E7TUFBQSxJQUZFLEtBRUYsR0FBQSxJQUFBLENBRkUsS0FFRixDQUFBO01BQUEsSUFDUSxXQURSLEdBQ3dCLElBRHhCLENBQ1EsV0FEUixDQUFBO01BRUEsSUFBTSxZQUFZLEdBQUcsZUFBZSxDQUFDLFdBQUQsQ0FBcEMsQ0FBQTtNQUNBLElBQUEsQ0FBSyxhQUFMLENBQW1CLFlBQW5CLENBQUEsQ0FBQTtNQUVBLElBQUEsQ0FBSyxLQUFMLEdBQWEsQ0FBQSxDQUFBLEVBQUEsWUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLEVBQVAsRUFBVyxXQUFXLENBQUMsS0FBdkIsQ0FBYixDQUFBO01BQ0EsSUFBQSxDQUFLLFdBQUwsR0FBbUIsYUFBYSxDQUFDLFdBQVcsQ0FBQyxJQUFiLEVBQW1CLFVBQW5CLENBQWhDLENBQUE7TUFDQSxJQUFBLENBQUssVUFBTCxHQUFrQjtRQUFFLENBQUMsRUFBRSxDQUFMO1FBQVEsQ0FBQyxFQUFFLENBQUE7T0FBN0IsQ0FBQTtNQUVBLElBQU0sR0FBYyxHQUFHO1FBQ3JCLEtBQUssRUFBTCxLQURxQjtRQUVyQixVQUFVLEVBQVYsVUFGcUI7UUFHckIsTUFBTSxFQUFFLEtBQUE7T0FIVixDQUFBO01BTUEsSUFBQSxDQUFLLE1BQUwsR0FBYyxZQUFZLEVBQTFCLENBQUE7TUFDQSxJQUFBLENBQUssUUFBTCxDQUFjLEdBQWQsQ0FBQSxDQUFBO01BRUEsSUFBTSxNQUFNLEdBQUcsSUFBQSxDQUFLLE1BQUwsR0FBYyxJQUFBLENBQUssTUFBTCxDQUFZLEdBQVosQ0FBN0IsQ0FBQTtNQUVBLE9BQU8sTUFBUCxDQUFBO0tBQ0Q7Ozs0QkFFUSxLQUEyQjtNQUFBLElBQzFCLFdBRDBCLEdBQ1YsSUFEVSxDQUMxQixXQUQwQixDQUFBO01BR2xDLEdBQUcsQ0FBQyxXQUFKLEdBQWtCLFdBQWxCLENBQUE7TUFDQSxHQUFHLENBQUMsWUFBSixHQUFtQixXQUFXLENBQUMsWUFBL0IsQ0FBQTtNQUNBLEdBQUcsQ0FBQyxPQUFKLEdBQWMsV0FBVyxDQUFDLE9BQTFCLENBQUE7TUFDQSxHQUFHLENBQUMsSUFBSixHQUFXLEdBQUcsQ0FBQyxJQUFKLElBQVksV0FBVyxDQUFDLElBQW5DLENBQUE7TUFDQSxHQUFHLENBQUMsS0FBSixHQUFZLElBQUEsQ0FBSyxLQUFqQixDQUFBO01BQ0EsR0FBRyxDQUFDLFdBQUosR0FBa0IsSUFBQSxDQUFLLFdBQXZCLENBQUE7S0FDRDs7OzZCQUVTLEtBQXVDO01BQy9DLElBQUEsQ0FBSyxPQUFMLENBQWEsR0FBYixDQUFBLENBQUE7O01BRUEsS0FBQSxJQUFBLEVBQUEsR0FBQSxDQUFBLEVBQUEsRUFBQSxHQUFvQixJQUFBLENBQUssTUFBekIsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQWlDO1FBQUEsSUFBQSxLQUFBLENBQUE7O1FBQUEsS0FBQSxHQUFiLElBQUEsQ0FBSyxNQUFRLENBQUEsRUFBQSxDQUFBLENBQUE7UUFBQSxJQUF0QixLQUFzQixHQUFBLEtBQUEsQ0FBQTs7UUFDL0IsSUFBSSxLQUFLLENBQUMsT0FBTixDQUFjLEtBQWxCLEVBQXlCO1VBQ3ZCLEdBQUcsQ0FBQyxLQUFKLEdBQVksS0FBWixDQUFBO1VBQ0EsS0FBSyxDQUFDLE9BQU4sQ0FBYyxLQUFkLENBQW9CLEdBQXBCLENBQUEsQ0FBQTtTQUNEO09BQ0Y7S0FDRjs7OzJCQUVPLEtBQTJEO01BQ2pFLElBQUEsQ0FBSyxPQUFMLENBQWEsR0FBYixDQUFBLENBQUE7TUFEaUUsSUFJL0QsS0FKK0QsR0FRN0QsR0FSNkQsQ0FJL0QsS0FKK0Q7VUFLL0QsTUFMK0QsR0FRN0QsR0FSNkQsQ0FLL0QsTUFMK0Q7VUFNL0QsYUFOK0QsR0FRN0QsR0FSNkQsQ0FNL0QsYUFOK0Q7VUFPekQsY0FQeUQsR0FRN0QsR0FSNkQsQ0FPL0QsSUFQK0QsQ0FBQTtNQVVqRSxHQUFHLENBQUMsTUFBSixHQUFhLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxFQUFQLEVBQVcsR0FBRyxDQUFDLFVBQWYsQ0FBYixDQUFBO01BQ0EsR0FBRyxDQUFDLElBQUosR0FBVyxDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sRUFBUCxFQUFXLGNBQVgsQ0FBWCxDQUFBO01BRUEsSUFBTSxNQUFNLEdBQUcsYUFBYSxHQUN4QixJQUFBLENBQUssTUFBTCxDQUFZLEtBQVosQ0FBa0IsYUFBbEIsQ0FEd0IsR0FFeEIsSUFBQSxDQUFLLE1BRlQsQ0FBQTtNQUlBLElBQU0sU0FBUyxHQUFHLFlBQVksQ0FBQyxHQUFHLENBQUMsTUFBTCxFQUFhLEdBQUcsQ0FBQyxJQUFqQixDQUE5QixDQUFBOztNQUVBLEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBb0IsTUFBcEIsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQTRCO1FBQUEsSUFBQSxLQUFBLENBQUE7O1FBQUEsS0FBQSxHQUFSLE1BQVEsQ0FBQSxHQUFBLENBQUEsQ0FBQTtRQUFBLElBQWpCLEtBQWlCLEdBQUEsS0FBQSxDQUFBO1FBQUEsSUFDbEIsT0FEa0IsR0FDTixLQURNLENBQ2xCLE9BRGtCLENBQUE7UUFFMUIsSUFBTSxrQkFBa0IsR0FBRyxDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sRUFBUCxFQUFXLEdBQUcsQ0FBQyxNQUFmLENBQTNCLENBQUE7UUFDQSxJQUFJLFdBQVcsR0FBRyxJQUFsQixDQUFBOztRQUVBLElBQUksS0FBSyxDQUFDLE9BQU4sQ0FBYyxHQUFkLElBQXFCLElBQUEsQ0FBSyxRQUFMLENBQWMsT0FBZCxFQUF1QixNQUF2QixFQUErQixLQUEvQixDQUF6QixFQUFnRTtVQUM5RCxHQUFHLENBQUMsS0FBSixHQUFZLEtBQVosQ0FBQTtVQUNBLFdBQVcsR0FBRyxLQUFLLENBQUMsT0FBTixDQUFjLEdBQWQsQ0FBa0IsR0FBbEIsQ0FBZCxDQUFBO1VBRUEsU0FBUyxDQUFDLFFBQVYsQ0FBbUIsSUFBQSxDQUFLLFdBQUwsQ0FBaUIsS0FBcEMsRUFBMkMsR0FBRyxDQUFDLElBQS9DLEVBQXFEO1lBQUUsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxNQUFKLENBQVcsQ0FBWCxHQUFlLGtCQUFrQixDQUFDLENBQXZDO1lBQTBDLENBQUMsRUFBRSxHQUFHLENBQUMsTUFBSixDQUFXLENBQVgsR0FBZSxrQkFBa0IsQ0FBQyxDQUFBO1dBQXBJLENBQUEsQ0FBQTtTQUNEOztRQUVELFNBQVMsQ0FBQyxVQUFWLENBQXFCLElBQXJCLENBQTBCLFdBQTFCLENBQUEsQ0FBQTtPQUNEOztNQUVELFNBQVMsQ0FBQyxLQUFWLENBQWdCLENBQWhCLEdBQW9CLEdBQUcsQ0FBQyxNQUFKLENBQVcsQ0FBWCxHQUFlLEdBQUcsQ0FBQyxVQUFKLENBQWUsQ0FBbEQsQ0FBQTtNQUNBLFNBQVMsQ0FBQyxLQUFWLENBQWdCLENBQWhCLEdBQW9CLEdBQUcsQ0FBQyxNQUFKLENBQVcsQ0FBWCxHQUFlLEdBQUcsQ0FBQyxVQUFKLENBQWUsQ0FBbEQsQ0FBQTtNQUVBLFNBQVMsQ0FBQyxTQUFWLENBQW9CLElBQXBCLEdBQTZCLEdBQUcsQ0FBQyxJQUFKLENBQVMsSUFBVCxHQUFnQixjQUFjLENBQUMsSUFBNUQsQ0FBQTtNQUNBLFNBQVMsQ0FBQyxTQUFWLENBQW9CLEtBQXBCLEdBQTZCLEdBQUcsQ0FBQyxJQUFKLENBQVMsS0FBVCxHQUFpQixjQUFjLENBQUMsS0FBN0QsQ0FBQTtNQUNBLFNBQVMsQ0FBQyxTQUFWLENBQW9CLEdBQXBCLEdBQTZCLEdBQUcsQ0FBQyxJQUFKLENBQVMsR0FBVCxHQUFlLGNBQWMsQ0FBQyxHQUEzRCxDQUFBO01BQ0EsU0FBUyxDQUFDLFNBQVYsQ0FBb0IsTUFBcEIsR0FBNkIsR0FBRyxDQUFDLElBQUosQ0FBUyxNQUFULEdBQWtCLGNBQWMsQ0FBQyxNQUE5RCxDQUFBO01BRUEsSUFBTSxVQUFVLEdBQUcsSUFBQSxDQUFLLE1BQUwsQ0FBWSxNQUEvQixDQUFBO01BQ0EsSUFBTSxRQUFRLEdBQUcsSUFBQSxDQUFLLE1BQUwsQ0FBWSxJQUE3QixDQUFBOztNQUVBLElBQUksVUFBVSxJQUFJLFFBQWxCLEVBQTRCO1FBQzFCLElBQU0sV0FBVyxHQUFHLFNBQVMsQ0FBQyxJQUFWLENBQWUsSUFBZixLQUF3QixRQUFRLENBQUMsSUFBakMsSUFDbEIsU0FBUyxDQUFDLElBQVYsQ0FBZSxLQUFmLEtBQXlCLFFBQVEsQ0FBQyxLQURoQixJQUVsQixTQUFTLENBQUMsSUFBVixDQUFlLEdBQWYsS0FBdUIsUUFBUSxDQUFDLEdBRmQsSUFHbEIsU0FBUyxDQUFDLElBQVYsQ0FBZSxNQUFmLEtBQTBCLFFBQVEsQ0FBQyxNQUhyQyxDQUFBO1FBS0EsU0FBUyxDQUFDLE9BQVYsR0FBb0IsV0FBVyxJQUM3QixVQUFVLENBQUMsQ0FBWCxLQUFpQixTQUFTLENBQUMsTUFBVixDQUFpQixDQURoQixJQUVsQixVQUFVLENBQUMsQ0FBWCxLQUFpQixTQUFTLENBQUMsTUFBVixDQUFpQixDQUZwQyxDQUFBO09BR0Q7O01BRUQsT0FBTyxTQUFQLENBQUE7S0FDRDs7O3VDQUVtQixLQUEyRDtNQUFBLElBQ3JFLFdBRHFFLEdBQ3JELElBRHFELENBQ3JFLFdBRHFFLENBQUE7TUFBQSxJQUVyRSxLQUZxRSxHQUUzRCxHQUYyRCxDQUVyRSxLQUZxRSxDQUFBO01BRzdFLElBQU0sU0FBUyxHQUFHLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEdBQXJDLENBQUE7TUFDQSxJQUFNLFdBQVcsR0FBRyxXQUFXLENBQUMsTUFBWixDQUFtQixLQUF2QyxDQUFBO01BSjZFLElBS3JFLE1BTHFFLEdBSzlDLElBTDhDLENBS3JFLE1BTHFFO1VBSzdELFVBTDZELEdBSzlDLElBTDhDLENBSzdELFVBTDZELENBQUE7TUFNN0UsSUFBTSxRQUFRLEdBQUcsTUFBTSxDQUFDLEtBQXhCLENBQUE7O01BRUEsSUFBSSxLQUFLLEtBQUssT0FBZCxFQUF1QjtRQUNyQixDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sSUFBQSxDQUFLLFVBQVosRUFBd0IsTUFBTSxDQUFDLEtBQS9CLENBQUEsQ0FBQTtPQUNEOztNQUVELEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBaUMsQ0FBQyxDQUFDLFdBQUQsRUFBYyxVQUFkLENBQUQsRUFBNEIsQ0FBQyxTQUFELEVBQVksUUFBWixDQUE1QixDQUFqQyxDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBOEY7UUFBQSxJQUFBLEtBQUEsQ0FBQTs7UUFBQSxLQUFBLEdBQTdELENBQUMsQ0FBQyxXQUFELEVBQWMsVUFBZCxDQUFELEVBQTRCLENBQUMsU0FBRCxFQUFZLFFBQVosQ0FBNUIsQ0FBNkQsQ0FBQSxHQUFBLENBQUEsQ0FBQTs7UUFBQSxJQUFBLEtBQUEsR0FBQSxLQUFBO1lBQUEsS0FBQSxHQUFBLG1CQUFBLENBQUEsS0FBQSxFQUFBLENBQUEsQ0FBQTtZQUFsRixTQUFrRixHQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7WUFBdkUsS0FBdUUsR0FBQSxLQUFBLENBQUEsQ0FBQSxDQUFBLENBQUE7O1FBQzVGLFNBQVMsQ0FBQyxJQUFWLENBQWUsQ0FBZixJQUFzQixLQUFLLENBQUMsQ0FBNUIsQ0FBQTtRQUNBLFNBQVMsQ0FBQyxJQUFWLENBQWUsQ0FBZixJQUFzQixLQUFLLENBQUMsQ0FBNUIsQ0FBQTtRQUNBLFNBQVMsQ0FBQyxNQUFWLENBQWlCLENBQWpCLElBQXNCLEtBQUssQ0FBQyxDQUE1QixDQUFBO1FBQ0EsU0FBUyxDQUFDLE1BQVYsQ0FBaUIsQ0FBakIsSUFBc0IsS0FBSyxDQUFDLENBQTVCLENBQUE7T0FDRDs7TUFqQjRFLElBbUJyRSxTQW5CcUUsR0FtQnZELElBQUEsQ0FBSyxNQW5Ca0QsQ0FtQnJFLFNBbkJxRSxDQUFBO01Bb0I3RSxJQUFNLElBQUksR0FBRyxHQUFHLENBQUMsSUFBSixJQUFZLFdBQVcsQ0FBQyxJQUFyQyxDQUFBO01BRUEsSUFBSSxDQUFDLElBQUwsSUFBZSxTQUFTLENBQUMsSUFBekIsQ0FBQTtNQUNBLElBQUksQ0FBQyxLQUFMLElBQWUsU0FBUyxDQUFDLEtBQXpCLENBQUE7TUFDQSxJQUFJLENBQUMsR0FBTCxJQUFlLFNBQVMsQ0FBQyxHQUF6QixDQUFBO01BQ0EsSUFBSSxDQUFDLE1BQUwsSUFBZSxTQUFTLENBQUMsTUFBekIsQ0FBQTtNQUVBLElBQUksQ0FBQyxLQUFMLEdBQWEsSUFBSSxDQUFDLEtBQUwsR0FBYSxJQUFJLENBQUMsSUFBL0IsQ0FBQTtNQUNBLElBQUksQ0FBQyxNQUFMLEdBQWMsSUFBSSxDQUFDLE1BQUwsR0FBYyxJQUFJLENBQUMsR0FBakMsQ0FBQTtLQUNEOzs7Z0NBRVksS0FLSTtNQUFBLElBQ1AsV0FETyxHQUNTLElBRFQsQ0FDUCxXQURPLENBQUE7TUFBQSxJQUVQLEtBRk8sR0FFMEIsR0FGMUIsQ0FFUCxLQUZPO1VBRUEsTUFGQSxHQUUwQixHQUYxQixDQUVBLE1BRkE7VUFFUSxhQUZSLEdBRTBCLEdBRjFCLENBRVEsYUFGUixDQUFBO01BSWYsSUFBTSxNQUFNLEdBQUcsSUFBQSxDQUFLLE1BQUwsQ0FBWTtRQUN6QixNQUFNLEVBQU4sTUFEeUI7UUFFekIsS0FBSyxFQUFMLEtBRnlCO1FBR3pCLFVBQVUsRUFBRSxHQUFHLENBQUMsY0FBSixJQUFzQixXQUFXLENBQUMsTUFBWixDQUFtQixHQUFuQixDQUF1QixJQUFBO09BSDVDLENBQWYsQ0FBQTtNQU1BLElBQUEsQ0FBSyxNQUFMLEdBQWMsTUFBZCxDQVZlOzs7TUFjZixJQUFJLENBQUMsTUFBTSxDQUFDLE9BQVIsS0FBb0IsQ0FBQyxhQUFELElBQWtCLGFBQWEsR0FBRyxJQUFBLENBQUssTUFBTCxDQUFZLE1BQWxFLENBQUEsSUFBNkUsV0FBVyxDQUFDLFdBQVosRUFBakYsRUFBNEc7UUFDMUcsT0FBTyxLQUFQLENBQUE7T0FDRDs7TUFFRCxJQUFJLEdBQUcsQ0FBQyxjQUFSLEVBQXdCO1FBQUEsSUFDZCxJQURjLEdBQ0wsV0FBVyxDQUFDLE1BQVosQ0FBbUIsR0FEZCxDQUNkLElBRGMsQ0FBQTtRQUV0QixJQUFNLFVBQVUsR0FBRztVQUNqQixDQUFDLEVBQUUsR0FBRyxDQUFDLGNBQUosQ0FBbUIsQ0FBbkIsR0FBdUIsSUFBSSxDQUFDLENBRGQ7VUFFakIsQ0FBQyxFQUFFLEdBQUcsQ0FBQyxjQUFKLENBQW1CLENBQW5CLEdBQXVCLElBQUksQ0FBQyxDQUFBO1NBRmpDLENBQUE7UUFLQSxNQUFNLENBQUMsTUFBUCxDQUFjLENBQWQsSUFBbUIsVUFBVSxDQUFDLENBQTlCLENBQUE7UUFDQSxNQUFNLENBQUMsTUFBUCxDQUFjLENBQWQsSUFBbUIsVUFBVSxDQUFDLENBQTlCLENBQUE7UUFDQSxNQUFNLENBQUMsS0FBUCxDQUFhLENBQWIsSUFBa0IsVUFBVSxDQUFDLENBQTdCLENBQUE7UUFDQSxNQUFNLENBQUMsS0FBUCxDQUFhLENBQWIsSUFBa0IsVUFBVSxDQUFDLENBQTdCLENBQUE7T0FDRDs7TUFFRCxJQUFBLENBQUssa0JBQUwsQ0FBd0IsR0FBeEIsQ0FBQSxDQUFBO0tBQ0Q7Ozs4QkFFVSxLQUF1RjtNQUFBLElBQ3hGLFdBRHdGLEdBQ2pFLEdBRGlFLENBQ3hGLFdBRHdGO1VBQzNFLEtBRDJFLEdBQ2pFLEdBRGlFLENBQzNFLEtBRDJFLENBQUE7TUFFaEcsSUFBTSxNQUFNLEdBQUcsSUFBQSxDQUFLLE1BQXBCLENBQUE7O01BRUEsSUFBSSxDQUFDLE1BQUQsSUFBVyxDQUFDLE1BQU0sQ0FBQyxNQUF2QixFQUErQjtRQUM3QixPQUFBO09BQ0Q7O01BRUQsSUFBSSxRQUFRLEdBQUcsS0FBZixDQUFBOztNQUVBLEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBb0IsTUFBcEIsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQTRCO1FBQUEsSUFBQSxLQUFBLENBQUE7O1FBQUEsS0FBQSxHQUFSLE1BQVEsQ0FBQSxHQUFBLENBQUEsQ0FBQTtRQUFBLElBQWpCLEtBQWlCLEdBQUEsS0FBQSxDQUFBO1FBQzFCLEdBQUcsQ0FBQyxLQUFKLEdBQVksS0FBWixDQUFBO1FBRDBCLElBRWxCLE9BRmtCLEdBRUcsS0FGSCxDQUVsQixPQUZrQjtZQUVULE9BRlMsR0FFRyxLQUZILENBRVQsT0FGUyxDQUFBO1FBSTFCLElBQU0sV0FBVyxHQUFHLE9BQU8sQ0FBQyxTQUFSLElBQXFCLE9BQU8sQ0FBQyxTQUFSLENBQWtCLEdBQWxCLENBQXpDLENBQUE7O1FBRUEsSUFBSSxXQUFKLEVBQWlCO1VBQ2YsSUFBQSxDQUFLLFNBQUwsR0FBaUIsV0FBakIsQ0FBQTtVQUNBLE9BQU8sS0FBUCxDQUFBO1NBQ0Q7O1FBRUQsUUFBUSxHQUFHLFFBQVEsSUFBSyxDQUFDLFFBQUQsSUFBYSxJQUFBLENBQUssUUFBTCxDQUFjLE9BQWQsRUFBdUIsSUFBdkIsRUFBNkIsR0FBRyxDQUFDLEtBQWpDLEVBQXdDLElBQXhDLENBQXJDLENBQUE7T0FDRDs7TUFFRCxJQUFJLFFBQUosRUFBYzs7UUFFWixXQUFXLENBQUMsSUFBWixDQUFpQjtVQUFFLEtBQUssRUFBTCxLQUFGO1VBQVMsTUFBTSxFQUFFLElBQUE7U0FBbEMsQ0FBQSxDQUFBO09BQ0Q7S0FDRjs7O3lCQUVLLEtBQTRDO01BQUEsSUFDeEMsV0FEd0MsR0FDeEIsR0FEd0IsQ0FDeEMsV0FEd0MsQ0FBQTs7TUFHaEQsSUFBSSxDQUFDLElBQUEsQ0FBSyxNQUFOLElBQWdCLENBQUMsSUFBQSxDQUFLLE1BQUwsQ0FBWSxNQUFqQyxFQUF5QztRQUN2QyxPQUFBO09BQ0Q7O01BRUQsSUFBTSxXQUFpQyxHQUFHLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTztRQUMvQyxNQUFNLEVBQUUsSUFBQSxDQUFLLE1BRGtDO1FBRS9DLFlBQVksRUFBRSxXQUFXLENBQUMsWUFGcUI7UUFHL0MsT0FBTyxFQUFFLFdBQVcsQ0FBQyxPQUgwQjtRQUkvQyxJQUFJLEVBQUUsSUFBQTtPQUprQyxFQUt2QyxHQUx1QyxDQUExQyxDQUFBO01BT0EsSUFBQSxDQUFLLE9BQUwsQ0FBYSxXQUFiLENBQUEsQ0FBQTs7TUFFQSxLQUFBLElBQUEsR0FBQSxHQUFBLENBQUEsRUFBQSxHQUFBLEdBQW9CLElBQUEsQ0FBSyxNQUF6QixDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBaUM7UUFBQSxJQUFBLEtBQUEsQ0FBQTs7UUFBQSxLQUFBLEdBQWIsSUFBQSxDQUFLLE1BQVEsQ0FBQSxHQUFBLENBQUEsQ0FBQTtRQUFBLElBQXRCLEtBQXNCLEdBQUEsS0FBQSxDQUFBO1FBQy9CLFdBQVcsQ0FBQyxLQUFaLEdBQW9CLEtBQXBCLENBQUE7O1FBRUEsSUFBSSxLQUFLLENBQUMsT0FBTixDQUFjLElBQWxCLEVBQXdCO1VBQUUsS0FBSyxDQUFDLE9BQU4sQ0FBYyxJQUFkLENBQW1CLFdBQW5CLENBQUEsQ0FBQTtTQUFnRDtPQUMzRTs7TUFFRCxJQUFBLENBQUssTUFBTCxHQUFjLElBQWQsQ0FBQTtNQUNBLElBQUEsQ0FBSyxTQUFMLEdBQWlCLElBQWpCLENBQUE7S0FDRDs7O2tDQUVjLGNBQTBCO01BQ3ZDLElBQUEsQ0FBSyxNQUFMLEdBQWMsRUFBZCxDQUFBOztNQUVBLEtBQUssSUFBSSxLQUFLLEdBQUcsQ0FBakIsRUFBb0IsS0FBSyxHQUFHLFlBQVksQ0FBQyxNQUF6QyxFQUFpRCxLQUFLLEVBQXRELEVBQTBEO1FBQUEsSUFBQSxtQkFBQSxHQUNyQixZQUFZLENBQUMsS0FBRCxDQURTO1lBQ2hELE9BRGdELEdBQUEsbUJBQUEsQ0FDaEQsT0FEZ0Q7WUFDdkMsT0FEdUMsR0FBQSxtQkFBQSxDQUN2QyxPQUR1QztZQUM5QixJQUQ4QixHQUFBLG1CQUFBLENBQzlCLElBRDhCLENBQUE7O1FBR3hELElBQUksT0FBTyxJQUFJLE9BQU8sQ0FBQyxPQUFSLEtBQW9CLEtBQW5DLEVBQTBDO1VBQUUsU0FBQTtTQUFVOztRQUV0RCxJQUFBLENBQUssTUFBTCxDQUFZLElBQVosQ0FBaUI7VUFDZixPQUFPLEVBQVAsT0FEZTtVQUVmLE9BQU8sRUFBUCxPQUZlO1VBR2YsS0FBSyxFQUFMLEtBSGU7VUFJZixJQUFJLEVBQUosSUFBQTtTQUpGLENBQUEsQ0FBQTtPQU1EOztNQUVELE9BQU8sSUFBQSxDQUFLLE1BQVosQ0FBQTtLQUNEOzs7b0RBRWlIO01BQUEsSUFBQSxpQkFBQSxHQUFBLEtBQUEsQ0FBdEYsV0FBc0Y7VUFBdkUsTUFBdUUsR0FBQSxpQkFBQSxDQUF2RSxNQUF1RTtVQUEvRCxJQUErRCxHQUFBLGlCQUFBLENBQS9ELElBQStEO1VBQXpELFlBQXlELEdBQUEsaUJBQUEsQ0FBekQsWUFBeUQsQ0FBQTs7TUFDaEgsSUFBSSxDQUFDLFlBQVksQ0FBQyxNQUFsQixFQUEwQjtRQUFFLE9BQUE7T0FBUTs7TUFENEUsSUFHeEcsVUFId0csR0FHekYsWUFIeUYsQ0FHeEcsVUFId0csQ0FBQTtNQUFBLElBQUEsb0JBQUEsR0FJekUsWUFBWSxDQUFDLE1BSjREO1VBSWpHLFFBSmlHLEdBQUEsb0JBQUEsQ0FJeEcsS0FKd0c7VUFJdkYsU0FKdUYsR0FBQSxvQkFBQSxDQUl2RixTQUp1RixDQUFBO01BTWhILElBQU0sZUFBZSxHQUFHLENBQ3RCLENBQUMsTUFBTSxDQUFDLEtBQVIsRUFBZSxVQUFmLENBRHNCLEVBRXRCLENBQUMsTUFBTSxDQUFDLEdBQVIsRUFBYSxRQUFiLENBRnNCLENBQXhCLENBQUE7O01BS0EsS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUFpQyxlQUFqQyxDQUFBLE1BQUEsRUFBQSxHQUFBLEVBQUEsRUFBeUQ7UUFBQSxJQUFBLE1BQUEsQ0FBQTs7UUFBQSxNQUFBLEdBQXhCLGVBQXdCLENBQUEsR0FBQSxDQUFBLENBQUE7O1FBQUEsSUFBQSxNQUFBLEdBQUEsTUFBQTtZQUFBLE1BQUEsR0FBQSxtQkFBQSxDQUFBLE1BQUEsRUFBQSxDQUFBLENBQUE7WUFBN0MsU0FBNkMsR0FBQSxNQUFBLENBQUEsQ0FBQSxDQUFBO1lBQWxDLEtBQWtDLEdBQUEsTUFBQSxDQUFBLENBQUEsQ0FBQSxDQUFBOztRQUN2RCxTQUFTLENBQUMsSUFBVixDQUFlLENBQWYsSUFBb0IsS0FBSyxDQUFDLENBQTFCLENBQUE7UUFDQSxTQUFTLENBQUMsSUFBVixDQUFlLENBQWYsSUFBb0IsS0FBSyxDQUFDLENBQTFCLENBQUE7UUFDQSxTQUFTLENBQUMsTUFBVixDQUFpQixDQUFqQixJQUFzQixLQUFLLENBQUMsQ0FBNUIsQ0FBQTtRQUNBLFNBQVMsQ0FBQyxNQUFWLENBQWlCLENBQWpCLElBQXNCLEtBQUssQ0FBQyxDQUE1QixDQUFBO09BQ0Q7O01BRUQsSUFBSSxDQUFDLElBQUwsSUFBYSxTQUFTLENBQUMsSUFBdkIsQ0FBQTtNQUNBLElBQUksQ0FBQyxLQUFMLElBQWMsU0FBUyxDQUFDLEtBQXhCLENBQUE7TUFDQSxJQUFJLENBQUMsR0FBTCxJQUFZLFNBQVMsQ0FBQyxHQUF0QixDQUFBO01BQ0EsSUFBSSxDQUFDLE1BQUwsSUFBZSxTQUFTLENBQUMsTUFBekIsQ0FBQTtLQUNEOzs7NkJBRVMsU0FBUyxRQUFrQixPQUFnQixnQkFBMEI7TUFDN0U7TUFFRyxDQUFDLE9BQUQsSUFBWSxPQUFPLENBQUMsT0FBUixLQUFvQixLQUFqQztNQUVDLGNBQWMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUY1QjtNQUlDLE9BQU8sQ0FBQyxPQUFSLElBQW1CLENBQUMsTUFKckI7TUFNQyxLQUFLLEtBQUssT0FBVixJQUFxQixDQUFDLE9BQU8sQ0FBQyxRQVJqQyxFQVNFO1FBQ0EsT0FBTyxLQUFQLENBQUE7T0FDRDs7TUFFRCxPQUFPLElBQVAsQ0FBQTtLQUNEOzs7NkJBRVMsT0FBcUI7TUFDN0IsSUFBQSxDQUFLLFdBQUwsR0FBbUIsS0FBSyxDQUFDLFdBQXpCLENBQUE7TUFDQSxJQUFBLENBQUssVUFBTCxHQUFrQixLQUFLLENBQUMsVUFBeEIsQ0FBQTtNQUNBLElBQUEsQ0FBSyxLQUFMLEdBQWEsS0FBSyxDQUFDLEtBQW5CLENBQUE7TUFDQSxJQUFBLENBQUssTUFBTCxHQUFjLEtBQUssQ0FBQyxNQUFOLENBQWEsR0FBYixDQUFpQixVQUFBLENBQUMsRUFBQTtRQUFBLE9BQUksQ0FBQSxDQUFBLEVBQUEsV0FBQSxDQUFBLFNBQUEsQ0FBQSxFQUFNLENBQU4sQ0FBSixDQUFBO09BQWxCLENBQWQsQ0FBQTtNQUNBLElBQUEsQ0FBSyxNQUFMLEdBQWMsWUFBWSxDQUFDLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxFQUFQLEVBQVcsS0FBSyxDQUFDLE1BQU4sQ0FBYSxNQUF4QixDQUFELEVBQWtDLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxFQUFQLEVBQVcsS0FBSyxDQUFDLE1BQU4sQ0FBYSxJQUF4QixDQUFsQyxDQUExQixDQUFBO0tBQ0Q7Ozs4QkFFVTtNQUNULEtBQUssSUFBTSxJQUFYLElBQW1CLElBQW5CLEVBQXlCO1FBQ3ZCLElBQUEsQ0FBSyxJQUFMLENBQUEsR0FBYSxJQUFiLENBQUE7T0FDRDtLQUNGOzs7Ozs7OztBQUdILFNBQVMsWUFBVCxDQUF1QixNQUF2QixFQUFnRCxJQUFoRCxFQUE4RjtFQUM1RixPQUFPO0lBQ0wsSUFBSSxFQUFKLElBREs7SUFFTCxNQUFNLEVBQU4sTUFGSztJQUdMLEtBQUssRUFBRTtNQUFFLENBQUMsRUFBRSxDQUFMO01BQVEsQ0FBQyxFQUFFLENBQUE7S0FIYjtJQUlMLFNBQVMsRUFBRTtNQUNULElBQUksRUFBSSxDQURDO01BRVQsS0FBSyxFQUFHLENBRkM7TUFHVCxHQUFHLEVBQUssQ0FIQztNQUlULE1BQU0sRUFBRSxDQUFBO0tBUkw7SUFVTCxVQUFVLEVBQUUsRUFWUDtJQVdMLE9BQU8sRUFBRSxJQUFBO0dBWFgsQ0FBQTtDQWFEOztBQUVELFNBQVMsZUFBVCxDQUEwQixXQUExQixFQUF1QztFQUNyQyxJQUFNLGFBQWEsR0FBRyxXQUFXLENBQUMsWUFBWixDQUF5QixPQUF6QixDQUFpQyxXQUFXLENBQUMsUUFBWixDQUFxQixJQUF0RCxDQUF0QixDQUFBO0VBQ0EsSUFBTSxlQUFlLEdBQUcsYUFBYSxDQUFDLFNBQXRDLENBQUE7O0VBRUEsSUFBSSxlQUFlLElBQUksZUFBZSxDQUFDLE1BQXZDLEVBQStDO0lBQzdDLE9BQU8sZUFBZSxDQUFDLE1BQWhCLENBQ0wsVUFBQSxRQUFRLEVBQUE7TUFBQSxPQUFJLENBQUMsUUFBUSxDQUFDLE9BQVYsSUFBcUIsUUFBUSxDQUFDLE9BQVQsQ0FBaUIsT0FBakIsS0FBNkIsS0FBdEQsQ0FBQTtLQURILENBQVAsQ0FBQTtHQUdEOztFQUVELE9BQU8sQ0FBQyxNQUFELEVBQVMsVUFBVCxFQUFxQixXQUFyQixFQUFrQyxVQUFsQyxFQUE4QyxlQUE5QyxFQUErRCxjQUEvRCxDQUFBLENBQ0osR0FESSxDQUNBLFVBQUEsSUFBSSxFQUFJO0lBQ1gsSUFBTSxPQUFPLEdBQUcsYUFBYSxDQUFDLElBQUQsQ0FBN0IsQ0FBQTtJQUVBLE9BQU8sT0FBTyxJQUFJLE9BQU8sQ0FBQyxPQUFuQixJQUE4QjtNQUNuQyxPQUFPLEVBQVAsT0FEbUM7TUFFbkMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxRQUFBO0tBRm5CLENBQUE7R0FKRyxDQUFBLENBU0osTUFUSSxDQVNHLFVBQUEsQ0FBQyxFQUFBO0lBQUEsT0FBSSxDQUFDLENBQUMsQ0FBTixDQUFBO0dBVEosQ0FBUCxDQUFBO0NBVUQ7O0FBRU0sU0FBUyxhQUFULENBQXdCLElBQXhCLEVBQThCLE1BQTlCLEVBQXNDO0VBQzNDLE9BQU8sSUFBSSxHQUNQO0lBQ0EsSUFBSSxFQUFJLE1BQU0sQ0FBQyxDQUFQLEdBQVcsSUFBSSxDQUFDLElBRHhCO0lBRUEsR0FBRyxFQUFLLE1BQU0sQ0FBQyxDQUFQLEdBQVcsSUFBSSxDQUFDLEdBRnhCO0lBR0EsS0FBSyxFQUFHLElBQUksQ0FBQyxLQUFMLEdBQWMsTUFBTSxDQUFDLENBSDdCO0lBSUEsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFMLEdBQWMsTUFBTSxDQUFDLENBQUE7R0FMdEIsR0FPUDtJQUNBLElBQUksRUFBSSxDQURSO0lBRUEsR0FBRyxFQUFLLENBRlI7SUFHQSxLQUFLLEVBQUcsQ0FIUjtJQUlBLE1BQU0sRUFBRSxDQUFBO0dBWFosQ0FBQTtDQWFEOzs7Ozs7Ozs7Ozs7QUMzWUQsSUFBQSxhQUFBLEdBQUEsMkJBQUEsQ0FBQSxpQkFBQSxDQUFBLENBQUE7Ozs7QUE0RU8sU0FBUyxZQUFULENBS0wsTUFMSyxFQU1MLElBTkssRUFPTDtFQUFBLElBQ1EsUUFEUixHQUNxQixNQURyQixDQUNRLFFBRFIsQ0FBQTtFQUVBLElBQU0sT0FBTyxHQUFHO0lBQ2QsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQURBO0lBRWQsR0FBRyxFQUFFLE1BQU0sQ0FBQyxHQUZFO0lBR2QsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUhKO0lBSWQsSUFBSSxFQUFFLE1BQU0sQ0FBQyxJQUFBO0dBSmYsQ0FBQTs7RUFPQSxJQUFNLFFBQVEsR0FBRyxTQUFYLFFBQVcsQ0FBQyxRQUFELEVBQWtDO0lBQ2pELElBQU0sT0FBaUIsR0FBSSxRQUFRLElBQUksRUFBdkMsQ0FBQTtJQUVBLE9BQU8sQ0FBQyxPQUFSLEdBQWtCLE9BQU8sQ0FBQyxPQUFSLEtBQW9CLEtBQXRDLENBSGlEOztJQU1qRCxLQUFLLElBQU0sS0FBWCxJQUFtQixRQUFuQixFQUE2QjtNQUMzQixJQUFJLEVBQUUsS0FBSSxJQUFJLE9BQVYsQ0FBSixFQUF3QjtRQUN0QixPQUFPLENBQUMsS0FBRCxDQUFQLEdBQWdCLFFBQVEsQ0FBQyxLQUFELENBQXhCLENBQUE7T0FDRDtLQUNGOztJQUVELElBQU0sQ0FBa0MsR0FBRztNQUFFLE9BQU8sRUFBUCxPQUFGO01BQVcsT0FBTyxFQUFQLE9BQVg7TUFBb0IsSUFBSSxFQUFKLElBQUE7S0FBL0QsQ0FBQTtJQUVBLE9BQU8sQ0FBUCxDQUFBO0dBZEYsQ0FBQTs7RUFpQkEsSUFBSSxJQUFJLElBQUksT0FBTyxJQUFQLEtBQWdCLFFBQTVCLEVBQXNDOztJQUVwQyxRQUFRLENBQUMsU0FBVCxHQUFxQixRQUFyQixDQUFBO0lBQ0EsUUFBUSxDQUFDLFFBQVQsR0FBb0IsT0FBcEIsQ0FBQTtHQUNEOztFQUVELE9BQU8sUUFBUCxDQUFBO0NBQ0Q7O0FBRU0sU0FBUyxpQkFBVCxDQUFBLElBQUEsRUFHSjtFQUFBLElBSGtDLE1BR2xDLEdBQUEsSUFBQSxDQUhrQyxNQUdsQztNQUh5RSxNQUd6RSxHQUFBLElBQUEsQ0FIMEMsV0FHMUMsQ0FIeUQsWUFHekQsQ0FIeUUsTUFHekUsQ0FBQTs7RUFDRCxJQUFJLE1BQUosRUFBWTtJQUNWLE1BQU0sQ0FBQyxTQUFQLEdBQW1CLE1BQU0sQ0FBQyxVQUExQixDQUFBO0dBQ0Q7Q0FDRjs7QUFFRCxJQUFNLGFBQThCLEdBQUc7RUFDckMsRUFBRSxFQUFFLGdCQURpQztFQUVyQyxPQUFPLEVBQUUsU0FBQSxPQUFBLENBQUEsS0FBSyxFQUFJO0lBQ2hCLEtBQUssQ0FBQyxRQUFOLENBQWUsU0FBZixDQUF5QixTQUF6QixHQUFxQyxFQUFyQyxDQUFBO0dBSG1DO0VBS3JDLFNBQVMsRUFBRTtJQUNULGtCQUFBLEVBQW9CLFNBQUEsZUFBQSxDQUFBLEtBQUEsRUFBcUI7TUFBQSxJQUFsQixXQUFrQixHQUFBLEtBQUEsQ0FBbEIsV0FBa0IsQ0FBQTtNQUN2QyxXQUFXLENBQUMsWUFBWixHQUEyQixJQUFJLGFBQUEsQ0FBQSxTQUFBLENBQUosQ0FBaUIsV0FBakIsQ0FBM0IsQ0FBQTtLQUZPO0lBS1Qsa0NBQUEsRUFBb0MsU0FBQSw2QkFBQSxDQUFBLEdBQUcsRUFBSTtNQUFBLElBQ2pDLFlBRGlDLEdBQ2hCLEdBQUcsQ0FBQyxXQURZLENBQ2pDLFlBRGlDLENBQUE7TUFHekMsWUFBWSxDQUFDLEtBQWIsQ0FBbUIsR0FBbkIsRUFBd0IsR0FBRyxDQUFDLFdBQUosQ0FBZ0IsTUFBaEIsQ0FBdUIsS0FBdkIsQ0FBNkIsSUFBckQsQ0FBQSxDQUFBO01BQ0EsR0FBRyxDQUFDLFdBQUosQ0FBZ0IsS0FBaEIsR0FBd0IsWUFBWSxDQUFDLEtBQXJDLENBQUE7TUFDQSxZQUFZLENBQUMsa0JBQWIsQ0FBZ0MsR0FBaEMsQ0FBQSxDQUFBO0tBVk87SUFhVCxpQ0FBQSxFQUFtQyxTQUFBLDRCQUFBLENBQUEsR0FBRyxFQUFBO01BQUEsT0FBSSxHQUFHLENBQUMsV0FBSixDQUFnQixZQUFoQixDQUE2QixXQUE3QixDQUF5QyxHQUF6QyxDQUFKLENBQUE7S0FiN0I7SUFlVCxnQ0FBQSxFQUFrQyxTQUFBLDJCQUFBLENBQUEsR0FBRyxFQUFBO01BQUEsT0FBSSxHQUFHLENBQUMsV0FBSixDQUFnQixZQUFoQixDQUE2QixTQUE3QixDQUF1QyxHQUF2QyxDQUFKLENBQUE7S0FmNUI7SUFpQlQsMkJBQUEsRUFBNkIsaUJBakJwQjtJQWtCVCwwQkFBQSxFQUE0QixpQkFsQm5CO0lBbUJULHlCQUFBLEVBQTJCLGlCQW5CbEI7SUFxQlQsaUNBQUEsRUFBbUMsU0FBQSw0QkFBQSxDQUFBLEdBQUcsRUFBQTtNQUFBLE9BQUksR0FBRyxDQUFDLFdBQUosQ0FBZ0IsWUFBaEIsQ0FBNkIsd0JBQTdCLENBQXNELEdBQXRELENBQUosQ0FBQTtLQXJCN0I7SUFzQlQsZ0NBQUEsRUFBa0MsU0FBQSwyQkFBQSxDQUFBLEdBQUcsRUFBQTtNQUFBLE9BQUksR0FBRyxDQUFDLFdBQUosQ0FBZ0IsWUFBaEIsQ0FBNkIsd0JBQTdCLENBQXNELEdBQXRELENBQUosQ0FBQTtLQXRCNUI7SUF3QlQsbUJBQUEsRUFBcUIsU0FBQSxnQkFBQSxDQUFBLEdBQUcsRUFBQTtNQUFBLE9BQUksR0FBRyxDQUFDLFdBQUosQ0FBZ0IsWUFBaEIsQ0FBNkIsSUFBN0IsQ0FBa0MsR0FBbEMsQ0FBSixDQUFBO0tBQUE7R0E3Qlc7RUErQnJDLE1BQU0sRUFBRSxDQUFDLFNBQUQsRUFBWSxhQUFaLEVBQTJCLGdCQUEzQixFQUE2QyxpQkFBN0MsQ0FBQTtDQS9CVixDQUFBO29CQWtDZTs7Ozs7Ozs7Ozs7Ozs7O0FDaktmLCtFQUFBOztBQUNBLElBQUEsY0FBQSxHQUFBLDRCQUFBLENBQUEsU0FBQSxDQUFBLENBQUE7Ozs7OztBQWtCQyxnQkFBQSxDQUFBLGFBQUQsQ0FBdUIsUUFBdkIsR0FBa0MsRUFBbEMsQ0FBQTs7QUFFTyxTQUFTLFFBQVQsQ0FBbUIsV0FBbkIsRUFBc0Q7RUFDM0QsSUFBSSxDQUFDLFdBQVcsQ0FBQyxhQUFqQixFQUFnQztJQUFFLE9BQUE7R0FBUTs7RUFFMUMsV0FBVyxDQUFDLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEdBQXBCLEVBQXlCLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEtBQTVDLENBQVgsQ0FBQTtFQUVBLFdBQVcsQ0FBQyxNQUFaLENBQW1CLE9BQW5CLENBQTJCLENBQTNCLEdBQStCLENBQS9CLENBQUE7RUFDQSxXQUFXLENBQUMsTUFBWixDQUFtQixPQUFuQixDQUEyQixDQUEzQixHQUErQixDQUEvQixDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxZQUFULENBQUEsSUFBQSxFQUErRTtFQUFBLElBQXRELFdBQXNELEdBQUEsSUFBQSxDQUF0RCxXQUFzRCxDQUFBO0VBQzdFLFlBQVksQ0FBQyxXQUFELENBQVosQ0FBQTtDQUNEOztBQUVELFNBQVMsU0FBVCxDQUFBLEtBQUEsRUFBNEY7RUFBQSxJQUF0RSxXQUFzRSxHQUFBLEtBQUEsQ0FBdEUsV0FBc0UsQ0FBQTtFQUMxRixJQUFNLFVBQVUsR0FBRyxZQUFZLENBQUMsV0FBRCxDQUEvQixDQUFBOztFQUVBLElBQUksQ0FBQyxVQUFMLEVBQWlCO0lBQUUsT0FBQTtHQUFROztFQUUzQixXQUFXLENBQUMsSUFBWixDQUFpQjtJQUFFLE1BQU0sRUFBRSxJQUFBO0dBQTNCLENBQUEsQ0FBQTtFQUNBLFdBQVcsQ0FBQyxHQUFaLEVBQUEsQ0FBQTtFQUVBLE9BQU8sS0FBUCxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxRQUFULENBQUEsS0FBQSxFQUFzRTtFQUFBLElBQXRELFdBQXNELEdBQUEsS0FBQSxDQUF0RCxXQUFzRCxDQUFBO0VBQ3BFLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEtBQW5CLENBQXlCLENBQXpCLEdBQTZCLENBQTdCLENBQUE7RUFDQSxXQUFXLENBQUMsTUFBWixDQUFtQixLQUFuQixDQUF5QixDQUF6QixHQUE2QixDQUE3QixDQUFBO0VBQ0EsV0FBVyxDQUFDLE1BQVosQ0FBbUIsT0FBbkIsQ0FBMkIsQ0FBM0IsR0FBK0IsQ0FBL0IsQ0FBQTtFQUNBLFdBQVcsQ0FBQyxNQUFaLENBQW1CLE9BQW5CLENBQTJCLENBQTNCLEdBQStCLENBQS9CLENBQUE7Q0FDRDs7QUFFTSxTQUFTLFlBQVQsQ0FBdUIsV0FBdkIsRUFBMEQ7RUFDL0QsSUFBSSxDQUFDLFVBQVUsQ0FBQyxXQUFELENBQWYsRUFBOEI7SUFDNUIsT0FBTyxLQUFQLENBQUE7R0FDRDs7RUFIOEQsSUFLdkQsT0FMdUQsR0FLM0MsV0FBVyxDQUFDLE1BTCtCLENBS3ZELE9BTHVELENBQUE7RUFPL0QsV0FBVyxDQUFDLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEdBQXBCLEVBQXlCLE9BQXpCLENBQVgsQ0FBQTtFQUNBLFdBQVcsQ0FBQyxXQUFXLENBQUMsTUFBWixDQUFtQixLQUFwQixFQUEyQixPQUEzQixDQUFYLENBQUE7RUFDQSxjQUFTLENBQUMsUUFBVixDQUFtQixXQUFXLENBQUMsS0FBL0IsRUFBc0MsV0FBVyxDQUFDLElBQWxELEVBQXdELE9BQXhELENBQUEsQ0FBQTtFQUVBLE9BQU8sQ0FBQyxDQUFSLEdBQVksQ0FBWixDQUFBO0VBQ0EsT0FBTyxDQUFDLENBQVIsR0FBWSxDQUFaLENBQUE7RUFFQSxPQUFPLElBQVAsQ0FBQTtDQUNEOztBQUVELFNBQVMsUUFBVCxDQUFBLEtBQUEsRUFBeUU7RUFBQSxJQUF4QixDQUF3QixHQUFBLEtBQUEsQ0FBeEIsQ0FBd0I7TUFBckIsQ0FBcUIsR0FBQSxLQUFBLENBQXJCLENBQXFCLENBQUE7RUFDdkUsSUFBQSxDQUFLLE1BQUwsQ0FBWSxPQUFaLENBQW9CLENBQXBCLElBQXlCLENBQXpCLENBQUE7RUFDQSxJQUFBLENBQUssTUFBTCxDQUFZLE9BQVosQ0FBb0IsQ0FBcEIsSUFBeUIsQ0FBekIsQ0FBQTtFQUVBLElBQUEsQ0FBSyxNQUFMLENBQVksS0FBWixDQUFrQixDQUFsQixJQUF1QixDQUF2QixDQUFBO0VBQ0EsSUFBQSxDQUFLLE1BQUwsQ0FBWSxLQUFaLENBQWtCLENBQWxCLElBQXVCLENBQXZCLENBQUE7Q0FDRDs7QUFFRCxTQUFTLFdBQVQsQ0FBQSxLQUFBLEVBQUEsS0FBQSxFQUFrRTtFQUFBLElBQTFDLElBQTBDLEdBQUEsS0FBQSxDQUExQyxJQUEwQztNQUFwQyxNQUFvQyxHQUFBLEtBQUEsQ0FBcEMsTUFBb0MsQ0FBQTtFQUFBLElBQXhCLENBQXdCLEdBQUEsS0FBQSxDQUF4QixDQUF3QjtNQUFyQixDQUFxQixHQUFBLEtBQUEsQ0FBckIsQ0FBcUIsQ0FBQTtFQUNoRSxJQUFJLENBQUMsQ0FBTCxJQUFVLENBQVYsQ0FBQTtFQUNBLElBQUksQ0FBQyxDQUFMLElBQVUsQ0FBVixDQUFBO0VBQ0EsTUFBTSxDQUFDLENBQVAsSUFBWSxDQUFaLENBQUE7RUFDQSxNQUFNLENBQUMsQ0FBUCxJQUFZLENBQVosQ0FBQTtDQUNEOztBQUVELFNBQVMsVUFBVCxDQUFxQixXQUFyQixFQUFrQztFQUNoQyxPQUFPLENBQUMsRUFBRSxXQUFXLENBQUMsTUFBWixDQUFtQixPQUFuQixDQUEyQixDQUEzQixJQUFnQyxXQUFXLENBQUMsTUFBWixDQUFtQixPQUFuQixDQUEyQixDQUE3RCxDQUFSLENBQUE7Q0FDRDs7QUFFRCxJQUFNLE1BQXVCLEdBQUc7RUFDOUIsRUFBRSxFQUFFLFFBRDBCO0VBRTlCLE9BRjhCLEVBQUEsU0FBQSxPQUFBLENBRXJCLEtBRnFCLEVBRWQ7SUFDZCxLQUFLLENBQUMsV0FBTixDQUFrQixTQUFsQixDQUE0QixRQUE1QixHQUF1QyxRQUF2QyxDQUFBO0dBSDRCO0VBSzlCLFNBQVMsRUFBRTtJQUNULGtCQUFBLEVBQW9CLFNBQUEsZUFBQSxDQUFBLEtBQUEsRUFBcUI7TUFBQSxJQUFsQixXQUFrQixHQUFBLEtBQUEsQ0FBbEIsV0FBa0IsQ0FBQTtNQUN2QyxXQUFXLENBQUMsTUFBWixHQUFxQjtRQUNuQixLQUFLLEVBQUU7VUFBRSxDQUFDLEVBQUUsQ0FBTDtVQUFRLENBQUMsRUFBRSxDQUFBO1NBREM7UUFFbkIsT0FBTyxFQUFFO1VBQUUsQ0FBQyxFQUFFLENBQUw7VUFBUSxDQUFDLEVBQUUsQ0FBQTtTQUFYO09BRlgsQ0FBQTtLQUZPO0lBT1QsNkJBQUEsRUFBK0IsU0FBQSx5QkFBQSxDQUFBLEtBQUEsRUFBQTtNQUFBLElBQUcsV0FBSCxHQUFBLEtBQUEsQ0FBRyxXQUFILENBQUE7TUFBQSxPQUFxQixRQUFRLENBQUMsV0FBRCxDQUE3QixDQUFBO0tBUHRCO0lBUVQsa0NBQUEsRUFBb0MsWUFSM0I7SUFTVCxpQ0FBQSxFQUFtQyxZQVQxQjtJQVVULGdDQUFBLEVBQWtDLFNBVnpCO0lBV1QsbUJBQUEsRUFBcUIsUUFBQTtHQVhaO0NBTGIsQ0FBQTtvQkFvQmU7Ozs7Ozs7Ozs7Ozs7QUM1R2YsSUFBQSxTQUFBLEdBQUEsNEJBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLGtCQUFBLEdBQUEsMkJBQUEsQ0FBQSxpQkFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxXQUFBLEdBQUEsMkJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFFBQUEsR0FBQSw0QkFBQSxDQUFBLGFBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsV0FBQSxHQUFBLDJCQUFBLENBQUEsVUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsNEJBQUEsQ0FBQSxPQUFBLENBQUEsQ0FBQTs7QUFDQSxrRkFBQTs7QUFDQSxJQUFBLFNBQUEsR0FBQSwyQkFBQSxDQUFBLFFBQUEsQ0FBQSxDQUFBOzs7Ozs7Ozs7Ozs7Ozs7O0FBd0NBLFNBQVMsWUFBVCxDQUFrQixLQUFsQixFQUF5QztFQUFBLElBRXJDLFFBRnFDLEdBR25DLEtBSG1DLENBRXJDLFFBRnFDLENBQUE7RUFLdkMsS0FBSyxDQUFDLFNBQU4sQ0FBZ0IsV0FBQSxDQUFBLFNBQUEsQ0FBaEIsQ0FBQSxDQUFBO0VBQ0EsS0FBSyxDQUFDLFNBQU4sQ0FBZ0IsU0FBUyxDQUFBLFNBQUEsQ0FBekIsQ0FBQSxDQUFBO0VBQ0EsS0FBSyxDQUFDLE9BQU4sQ0FBYyxNQUFkLENBQXFCLFlBQXJCLEdBQW9DLElBQXBDLENBQUE7RUFDQSxLQUFLLENBQUMsT0FBTixDQUFjLE1BQWQsQ0FBcUIsTUFBckIsR0FBOEIsSUFBOUIsQ0FBQTtFQUVBLFFBQVEsQ0FBQyxTQUFULENBQW1CLE9BQW5CLEdBQTZCO0lBQzNCLE9BQU8sRUFBWSxLQURRO0lBRTNCLFVBQVUsRUFBUyxFQUZROztJQUczQixRQUFRLEVBQVcsR0FIUTs7SUFJM0IsUUFBUSxFQUFXLEVBSlE7O0lBSzNCLFdBQVcsRUFBUSxJQUxROztJQU0zQixpQkFBaUIsRUFBRSxHQU5ROztHQUE3QixDQUFBO0NBUUQ7O0lBRVk7OztFQXVCWCxTQUFBLFlBQUEsQ0FDbUIsV0FEbkIsRUFFRTtJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLFlBQUEsQ0FBQSxDQUFBOztJQUFBLElBQUEsQ0FEaUIsV0FDakIsR0FEaUIsV0FDakIsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxRQUFBLEVBeEJPLEtBd0JQLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxZQUFBLEVBdkJXLEtBdUJYLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxXQUFBLEVBdEJVLEtBc0JWLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxhQUFBLEVBckJZLEtBcUJaLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxjQUFBLEVBbkIyQixJQW1CM0IsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLGVBQUEsRUFsQmMsQ0FrQmQsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLGFBQUEsRUFqQm1DLElBaUJuQyxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsYUFBQSxFQWY0QixJQWU1QixDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsSUFBQSxFQWRHLENBY0gsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLElBQUEsRUFiRyxDQWFILENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxJQUFBLEVBWEcsQ0FXSCxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsY0FBQSxFQVY2QixJQVU3QixDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsZ0JBQUEsRUFUK0IsSUFTL0IsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLGVBQUEsRUFSOEIsSUFROUIsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsSUFBQSxFQUFBLFdBQUEsRUFOVyxDQU1YLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLElBQUEsRUFBQSxXQUFBLEVBTFcsQ0FLWCxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsU0FBQSxFQUpnQixJQUloQixDQUFBLENBQUE7R0FBRTs7OzswQkFFRyxPQUFrQztNQUFBLElBQy9CLFdBRCtCLEdBQ2YsSUFEZSxDQUMvQixXQUQrQixDQUFBO01BRXZDLElBQU0sT0FBTyxHQUFHLGVBQVUsQ0FBQyxXQUFELENBQTFCLENBQUE7O01BRUEsSUFBSSxDQUFDLE9BQUQsSUFBWSxDQUFDLE9BQU8sQ0FBQyxPQUF6QixFQUFrQztRQUNoQyxPQUFPLEtBQVAsQ0FBQTtPQUNEOztNQU5zQyxJQVF2QixjQVJ1QixHQVFKLFdBQVcsQ0FBQyxNQUFaLENBQW1CLFFBUmYsQ0FRL0IsTUFSK0IsQ0FBQTtNQVN2QyxJQUFNLFlBQVksR0FBRyxDQUFBLENBQUEsRUFBQSxXQUFBLENBQUEsU0FBQSxDQUFBLEVBQU0sY0FBYyxDQUFDLENBQXJCLEVBQXdCLGNBQWMsQ0FBQyxDQUF2QyxDQUFyQixDQUFBO01BQ0EsSUFBTSxZQUFZLEdBQUcsSUFBQSxDQUFLLFlBQUwsS0FBc0IsSUFBQSxDQUFLLFlBQUwsR0FBb0IsSUFBSSxrQkFBQSxDQUFBLFNBQUEsQ0FBSixDQUFpQixXQUFqQixDQUExQyxDQUFyQixDQUFBO01BRUEsWUFBWSxDQUFDLFFBQWIsQ0FBc0IsV0FBVyxDQUFDLFlBQWxDLENBQUEsQ0FBQTtNQUVBLElBQUEsQ0FBSyxFQUFMLEdBQVUsV0FBVyxDQUFDLElBQVosRUFBVixDQUFBO01BQ0EsSUFBQSxDQUFLLFdBQUwsR0FBbUIsT0FBTyxDQUFDLFdBQTNCLENBQUE7TUFDQSxJQUFBLENBQUssRUFBTCxHQUFVLFlBQVYsQ0FBQTtNQUNBLElBQUEsQ0FBSyxhQUFMLEdBQXFCO1FBQUUsQ0FBQyxFQUFFLENBQUw7UUFBUSxDQUFDLEVBQUUsQ0FBQTtPQUFoQyxDQUFBO01BQ0EsSUFBQSxDQUFLLFdBQUwsR0FBbUIsV0FBVyxDQUFDLE1BQVosQ0FBbUIsR0FBbkIsQ0FBdUIsSUFBMUMsQ0FBQTtNQUVBLElBQUEsQ0FBSyxXQUFMLEdBQW1CO1FBQ2pCLFdBQVcsRUFBWCxXQURpQjtRQUVqQixZQUFZLEVBQUUsV0FBVyxDQUFDLFlBRlQ7UUFHakIsT0FBTyxFQUFFLFdBQVcsQ0FBQyxPQUhKO1FBSWpCLElBQUksRUFBRSxXQUFXLENBQUMsSUFKRDtRQUtqQixLQUFLLEVBQUUsV0FBVyxDQUFDLEtBTEY7UUFNakIsVUFBVSxFQUFFLElBQUEsQ0FBSyxXQU5BO1FBT2pCLE1BQU0sRUFBRSxJQVBTO1FBUWpCLEtBQUssRUFBRSxjQUFBO09BUlQsQ0FBQTtNQVdBLElBQU0sTUFBTSxHQUNULElBQUEsQ0FBSyxFQUFMLEdBQVUsV0FBVyxDQUFDLE1BQVosQ0FBbUIsR0FBbkIsQ0FBdUIsU0FBbEMsR0FBK0MsRUFBL0MsSUFDQSxZQUFZLEdBQUcsT0FBTyxDQUFDLFFBRHZCLElBRUEsWUFBWSxHQUFHLE9BQU8sQ0FBQyxRQUh6QixDQUFBOztNQU1BLElBQUksTUFBSixFQUFZO1FBQ1YsSUFBQSxDQUFLLFlBQUwsRUFBQSxDQUFBO09BREYsTUFFTztRQUNMLFlBQVksQ0FBQyxNQUFiLEdBQXNCLFlBQVksQ0FBQyxNQUFiLENBQW9CLElBQUEsQ0FBSyxXQUF6QixDQUF0QixDQUFBOztRQUVBLElBQUksQ0FBQyxZQUFZLENBQUMsTUFBYixDQUFvQixPQUF6QixFQUFrQztVQUNoQyxPQUFPLEtBQVAsQ0FBQTtTQUNEOztRQUVELElBQUEsQ0FBSyxjQUFMLEVBQUEsQ0FBQTtPQTlDcUM7OztNQWtEdkMsV0FBVyxDQUFDLFlBQVosQ0FBeUIsTUFBekIsQ0FBZ0MsSUFBaEMsR0FBdUMsSUFBdkMsQ0FsRHVDOztNQXFEdkMsV0FBVyxDQUFDLFFBQVosQ0FBcUIsSUFBQSxDQUFLLFlBQTFCLENBQUEsQ0FBQTs7TUFDQSxXQUFXLENBQUMsUUFBWixDQUFxQjtRQUNuQixXQUFXLEVBQVgsV0FEbUI7UUFFbkIsS0FBSyxFQUFMLEtBRm1CO1FBR25CLEtBQUssRUFBRSxjQUFBO09BSFQsQ0FBQSxDQUFBOztNQUtBLFdBQVcsQ0FBQyxRQUFaLENBQXFCO1FBQUUsQ0FBQyxFQUFFLENBQUMsSUFBQSxDQUFLLFlBQUwsQ0FBa0IsQ0FBeEI7UUFBMkIsQ0FBQyxFQUFFLENBQUMsSUFBQSxDQUFLLFlBQUwsQ0FBa0IsQ0FBQTtPQUF0RSxDQUFBLENBM0R1Qzs7TUE2RHZDLFdBQVcsQ0FBQyxZQUFaLENBQXlCLE1BQXpCLENBQWdDLElBQWhDLEdBQXVDLElBQXZDLENBQUE7TUFFQSxJQUFBLENBQUssTUFBTCxHQUFjLElBQWQsQ0FBQTtNQUNBLFdBQVcsQ0FBQyxVQUFaLEdBQXlCLElBQXpCLENBQUE7TUFFQSxPQUFPLElBQVAsQ0FBQTtLQUNEOzs7bUNBRWU7TUFBQSxJQUFBLEtBQUEsR0FBQSxJQUFBLENBQUE7O01BQ2QsSUFBTSxhQUFhLEdBQUcsSUFBQSxDQUFLLFdBQUwsQ0FBaUIsTUFBakIsQ0FBd0IsUUFBeEIsQ0FBaUMsTUFBdkQsQ0FBQTtNQUNBLElBQU0sT0FBTyxHQUFHLGVBQVUsQ0FBQyxJQUFBLENBQUssV0FBTixDQUExQixDQUFBO01BQ0EsSUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLFVBQXZCLENBQUE7TUFDQSxJQUFNLFVBQVUsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFMLENBQVMsT0FBTyxDQUFDLFFBQVIsR0FBbUIsSUFBQSxDQUFLLEVBQWpDLENBQUQsR0FBd0MsTUFBM0QsQ0FBQTtNQUVBLElBQUEsQ0FBSyxZQUFMLEdBQW9CO1FBQ2xCLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFkLEdBQWtCLFVBQW5CLElBQWlDLE1BRGxCO1FBRWxCLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFkLEdBQWtCLFVBQW5CLElBQWlDLE1BQUE7T0FGdEMsQ0FBQTtNQUtBLElBQUEsQ0FBSyxFQUFMLEdBQVUsVUFBVixDQUFBO01BQ0EsSUFBQSxDQUFLLFNBQUwsR0FBaUIsTUFBTSxHQUFHLElBQUEsQ0FBSyxFQUEvQixDQUFBO01BQ0EsSUFBQSxDQUFLLFNBQUwsR0FBaUIsQ0FBQSxHQUFJLE9BQU8sQ0FBQyxRQUFSLEdBQW1CLElBQUEsQ0FBSyxFQUE3QyxDQUFBO01BYmMsSUFlTixZQWZNLEdBZXdCLElBZnhCLENBZU4sWUFmTTtVQWVRLFdBZlIsR0Fld0IsSUFmeEIsQ0FlUSxXQWZSLENBQUE7TUFpQmQsV0FBVyxDQUFDLFVBQVosR0FBeUI7UUFDdkIsQ0FBQyxFQUFFLElBQUEsQ0FBSyxXQUFMLENBQWlCLENBQWpCLEdBQXFCLElBQUEsQ0FBSyxZQUFMLENBQWtCLENBRG5CO1FBRXZCLENBQUMsRUFBRSxJQUFBLENBQUssV0FBTCxDQUFpQixDQUFqQixHQUFxQixJQUFBLENBQUssWUFBTCxDQUFrQixDQUFBO09BRjVDLENBQUE7TUFLQSxZQUFZLENBQUMsTUFBYixHQUFzQixZQUFZLENBQUMsTUFBYixDQUFvQixXQUFwQixDQUF0QixDQUFBOztNQUVBLElBQUksWUFBWSxDQUFDLE1BQWIsQ0FBb0IsT0FBeEIsRUFBaUM7UUFDL0IsSUFBQSxDQUFLLFVBQUwsR0FBa0IsSUFBbEIsQ0FBQTtRQUNBLElBQUEsQ0FBSyxjQUFMLEdBQXNCO1VBQ3BCLENBQUMsRUFBRSxJQUFBLENBQUssWUFBTCxDQUFrQixDQUFsQixHQUFzQixZQUFZLENBQUMsTUFBYixDQUFvQixLQUFwQixDQUEwQixDQUQvQjtVQUVwQixDQUFDLEVBQUUsSUFBQSxDQUFLLFlBQUwsQ0FBa0IsQ0FBbEIsR0FBc0IsWUFBWSxDQUFDLE1BQWIsQ0FBb0IsS0FBcEIsQ0FBMEIsQ0FBQTtTQUZyRCxDQUFBO09BSUQ7O01BRUQsSUFBQSxDQUFLLE9BQUwsR0FBZSxTQUFBLENBQUEsU0FBQSxDQUFBLENBQUksT0FBSixDQUFZLFlBQUE7UUFBQSxPQUFNLEtBQUksQ0FBQyxXQUFMLEVBQU4sQ0FBQTtPQUFaLENBQWYsQ0FBQTtLQUNEOzs7cUNBRWlCO01BQUEsSUFBQSxNQUFBLEdBQUEsSUFBQSxDQUFBOztNQUNoQixJQUFBLENBQUssU0FBTCxHQUFpQixJQUFqQixDQUFBO01BQ0EsSUFBQSxDQUFLLFVBQUwsR0FBa0IsSUFBbEIsQ0FBQTtNQUNBLElBQUEsQ0FBSyxZQUFMLEdBQW9CO1FBQ2xCLENBQUMsRUFBRSxJQUFBLENBQUssWUFBTCxDQUFrQixNQUFsQixDQUF5QixLQUF6QixDQUErQixDQURoQjtRQUVsQixDQUFDLEVBQUUsSUFBQSxDQUFLLFlBQUwsQ0FBa0IsTUFBbEIsQ0FBeUIsS0FBekIsQ0FBK0IsQ0FBQTtPQUZwQyxDQUFBO01BS0EsSUFBQSxDQUFLLE9BQUwsR0FBZSxTQUFBLENBQUEsU0FBQSxDQUFBLENBQUksT0FBSixDQUFZLFlBQUE7UUFBQSxPQUFNLE1BQUksQ0FBQyxhQUFMLEVBQU4sQ0FBQTtPQUFaLENBQWYsQ0FBQTtLQUNEOzs7a0NBRWM7TUFBQSxJQUFBLE1BQUEsR0FBQSxJQUFBLENBQUE7O01BQUEsSUFDTCxXQURLLEdBQ1csSUFEWCxDQUNMLFdBREssQ0FBQTtNQUViLElBQU0sT0FBTyxHQUFHLGVBQVUsQ0FBQyxXQUFELENBQTFCLENBQUE7TUFDQSxJQUFNLE1BQU0sR0FBRyxPQUFPLENBQUMsVUFBdkIsQ0FBQTtNQUNBLElBQU0sQ0FBQyxHQUFHLENBQUMsV0FBVyxDQUFDLElBQVosRUFBQSxHQUFxQixJQUFBLENBQUssRUFBM0IsSUFBaUMsSUFBM0MsQ0FBQTs7TUFFQSxJQUFJLENBQUMsR0FBRyxJQUFBLENBQUssRUFBYixFQUFpQjtRQUNmLElBQU0sUUFBUSxHQUFJLENBQUEsR0FBSSxDQUFDLElBQUksQ0FBQyxHQUFMLENBQVMsQ0FBQyxNQUFELEdBQVUsQ0FBbkIsQ0FBQSxHQUF3QixJQUFBLENBQUssU0FBOUIsSUFBMkMsSUFBQSxDQUFLLFNBQXRFLENBQUE7UUFDQSxJQUFJLFNBQUosQ0FBQTs7UUFFQSxJQUFJLElBQUEsQ0FBSyxVQUFULEVBQXFCO1VBQ25CLFNBQVMsR0FBRyxzQkFBc0IsQ0FDaEMsQ0FEZ0MsRUFDN0IsQ0FENkIsRUFFaEMsSUFBQSxDQUFLLFlBQUwsQ0FBa0IsQ0FGYyxFQUVYLElBQUEsQ0FBSyxZQUFMLENBQWtCLENBRlAsRUFHaEMsSUFBQSxDQUFLLGNBQUwsQ0FBb0IsQ0FIWSxFQUdULElBQUEsQ0FBSyxjQUFMLENBQW9CLENBSFgsRUFJaEMsUUFKZ0MsQ0FBbEMsQ0FBQTtTQURGLE1BUUs7VUFDSCxTQUFTLEdBQUc7WUFDVixDQUFDLEVBQUUsSUFBQSxDQUFLLFlBQUwsQ0FBa0IsQ0FBbEIsR0FBc0IsUUFEZjtZQUVWLENBQUMsRUFBRSxJQUFBLENBQUssWUFBTCxDQUFrQixDQUFsQixHQUFzQixRQUFBO1dBRjNCLENBQUE7U0FJRDs7UUFFRCxJQUFNLEtBQUssR0FBRztVQUFFLENBQUMsRUFBRSxTQUFTLENBQUMsQ0FBVixHQUFjLElBQUEsQ0FBSyxhQUFMLENBQW1CLENBQXRDO1VBQXlDLENBQUMsRUFBRSxTQUFTLENBQUMsQ0FBVixHQUFjLElBQUEsQ0FBSyxhQUFMLENBQW1CLENBQUE7U0FBM0YsQ0FBQTtRQUVBLElBQUEsQ0FBSyxhQUFMLENBQW1CLENBQW5CLElBQXdCLEtBQUssQ0FBQyxDQUE5QixDQUFBO1FBQ0EsSUFBQSxDQUFLLGFBQUwsQ0FBbUIsQ0FBbkIsSUFBd0IsS0FBSyxDQUFDLENBQTlCLENBQUE7UUFFQSxXQUFXLENBQUMsUUFBWixDQUFxQixLQUFyQixDQUFBLENBQUE7UUFDQSxXQUFXLENBQUMsSUFBWixFQUFBLENBQUE7UUFFQSxJQUFBLENBQUssT0FBTCxHQUFlLFNBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBSSxPQUFKLENBQVksWUFBQTtVQUFBLE9BQU0sTUFBSSxDQUFDLFdBQUwsRUFBTixDQUFBO1NBQVosQ0FBZixDQUFBO09BM0JGLE1BNkJLO1FBQ0gsV0FBVyxDQUFDLFFBQVosQ0FBcUI7VUFDbkIsQ0FBQyxFQUFFLElBQUEsQ0FBSyxjQUFMLENBQW9CLENBQXBCLEdBQXdCLElBQUEsQ0FBSyxhQUFMLENBQW1CLENBRDNCO1VBRW5CLENBQUMsRUFBRSxJQUFBLENBQUssY0FBTCxDQUFvQixDQUFwQixHQUF3QixJQUFBLENBQUssYUFBTCxDQUFtQixDQUFBO1NBRmhELENBQUEsQ0FBQTtRQUtBLElBQUEsQ0FBSyxHQUFMLEVBQUEsQ0FBQTtPQUNEO0tBQ0Y7OztvQ0FFZ0I7TUFBQSxJQUFBLE1BQUEsR0FBQSxJQUFBLENBQUE7O01BQUEsSUFDUCxXQURPLEdBQ1MsSUFEVCxDQUNQLFdBRE8sQ0FBQTtNQUVmLElBQU0sQ0FBQyxHQUFHLFdBQVcsQ0FBQyxJQUFaLEVBQUEsR0FBcUIsSUFBQSxDQUFLLEVBQXBDLENBQUE7O01BRmUsSUFBQSxXQUFBLEdBR3lCLGVBQVUsQ0FBQyxXQUFELENBSG5DO1VBR1ksUUFIWixHQUFBLFdBQUEsQ0FHUCxpQkFITyxDQUFBOztNQUtmLElBQUksQ0FBQyxHQUFHLFFBQVIsRUFBa0I7UUFDaEIsSUFBTSxTQUFTLEdBQUc7VUFDaEIsQ0FBQyxFQUFFLFdBQVcsQ0FBQyxDQUFELEVBQUksQ0FBSixFQUFPLElBQUEsQ0FBSyxZQUFMLENBQWtCLENBQXpCLEVBQTRCLFFBQTVCLENBREU7VUFFaEIsQ0FBQyxFQUFFLFdBQVcsQ0FBQyxDQUFELEVBQUksQ0FBSixFQUFPLElBQUEsQ0FBSyxZQUFMLENBQWtCLENBQXpCLEVBQTRCLFFBQTVCLENBQUE7U0FGaEIsQ0FBQTtRQUlBLElBQU0sS0FBSyxHQUFHO1VBQ1osQ0FBQyxFQUFFLFNBQVMsQ0FBQyxDQUFWLEdBQWMsSUFBQSxDQUFLLGFBQUwsQ0FBbUIsQ0FEeEI7VUFFWixDQUFDLEVBQUUsU0FBUyxDQUFDLENBQVYsR0FBYyxJQUFBLENBQUssYUFBTCxDQUFtQixDQUFBO1NBRnRDLENBQUE7UUFLQSxJQUFBLENBQUssYUFBTCxDQUFtQixDQUFuQixJQUF3QixLQUFLLENBQUMsQ0FBOUIsQ0FBQTtRQUNBLElBQUEsQ0FBSyxhQUFMLENBQW1CLENBQW5CLElBQXdCLEtBQUssQ0FBQyxDQUE5QixDQUFBO1FBRUEsV0FBVyxDQUFDLFFBQVosQ0FBcUIsS0FBckIsQ0FBQSxDQUFBO1FBQ0EsV0FBVyxDQUFDLElBQVosQ0FBaUI7VUFBRSxhQUFhLEVBQUUsSUFBQSxDQUFLLGFBQUE7U0FBdkMsQ0FBQSxDQUFBO1FBRUEsSUFBQSxDQUFLLE9BQUwsR0FBZSxTQUFBLENBQUEsU0FBQSxDQUFBLENBQUksT0FBSixDQUFZLFlBQUE7VUFBQSxPQUFNLE1BQUksQ0FBQyxhQUFMLEVBQU4sQ0FBQTtTQUFaLENBQWYsQ0FBQTtPQWhCRixNQWtCSztRQUNILFdBQVcsQ0FBQyxRQUFaLENBQXFCO1VBQ25CLENBQUMsRUFBRSxJQUFBLENBQUssWUFBTCxDQUFrQixDQUFsQixHQUFzQixJQUFBLENBQUssYUFBTCxDQUFtQixDQUR6QjtVQUVuQixDQUFDLEVBQUUsSUFBQSxDQUFLLFlBQUwsQ0FBa0IsQ0FBbEIsR0FBc0IsSUFBQSxDQUFLLGFBQUwsQ0FBbUIsQ0FBQTtTQUY5QyxDQUFBLENBQUE7UUFLQSxJQUFBLENBQUssR0FBTCxFQUFBLENBQUE7T0FDRDtLQUNGOzs7aUNBRWtGO01BQUEsSUFBekUsT0FBeUUsR0FBQSxJQUFBLENBQXpFLE9BQXlFO1VBQWhFLEtBQWdFLEdBQUEsSUFBQSxDQUFoRSxLQUFnRTtVQUF6RCxXQUF5RCxHQUFBLElBQUEsQ0FBekQsV0FBeUQsQ0FBQTtNQUFBLElBQ3pFLFdBRHlFLEdBQ3pELElBRHlELENBQ3pFLFdBRHlFLENBQUE7O01BSWpGLFdBQVcsQ0FBQyxRQUFaLENBQXFCO1FBQ25CLENBQUMsRUFBRSxDQUFDLElBQUEsQ0FBSyxhQUFMLENBQW1CLENBREo7UUFFbkIsQ0FBQyxFQUFFLENBQUMsSUFBQSxDQUFLLGFBQUwsQ0FBbUIsQ0FBQTtPQUZ6QixDQUFBLENBSmlGOztNQVVqRixXQUFXLENBQUMsYUFBWixDQUEwQixPQUExQixFQUFtQyxLQUFuQyxFQUEwQyxXQUExQyxFQUF1RCxJQUF2RCxDQUFBLENBVmlGOztNQWFqRixXQUFXLENBQUMsUUFBWixDQUFxQjtRQUNuQixXQUFXLEVBQVgsV0FEbUI7UUFFbkIsS0FBSyxFQUFMLEtBRm1CO1FBR25CLEtBQUssRUFBRSxRQUFBO09BSFQsQ0FBQSxDQUFBOztNQUtBLENBQUEsQ0FBQSxFQUFBLGlCQUFBLENBQUEsVUFBQSxFQUFXLFdBQVcsQ0FBQyxNQUFaLENBQW1CLElBQTlCLEVBQW9DLFdBQVcsQ0FBQyxNQUFaLENBQW1CLEdBQXZELENBQUEsQ0FBQTtNQUVBLElBQUEsQ0FBSyxJQUFMLEVBQUEsQ0FBQTtLQUNEOzs7MEJBRU07TUFDTCxJQUFBLENBQUssV0FBTCxDQUFpQixJQUFqQixFQUFBLENBQUE7TUFDQSxJQUFBLENBQUssV0FBTCxDQUFpQixHQUFqQixFQUFBLENBQUE7TUFDQSxJQUFBLENBQUssSUFBTCxFQUFBLENBQUE7S0FDRDs7OzJCQUVPO01BQ04sSUFBQSxDQUFLLE1BQUwsR0FBYyxJQUFBLENBQUssU0FBTCxHQUFpQixLQUEvQixDQUFBO01BQ0EsSUFBQSxDQUFLLFdBQUwsQ0FBaUIsVUFBakIsR0FBOEIsSUFBOUIsQ0FBQTs7TUFDQSxTQUFBLENBQUEsU0FBQSxDQUFBLENBQUksTUFBSixDQUFXLElBQUEsQ0FBSyxPQUFoQixDQUFBLENBQUE7S0FDRDs7Ozs7Ozs7QUFHSCxTQUFTLFVBQVQsQ0FBQSxLQUFBLEVBQXlGO0VBQUEsSUFBdkUsV0FBdUUsR0FBQSxLQUFBLENBQXZFLFdBQXVFO01BQTFELEtBQTBELEdBQUEsS0FBQSxDQUExRCxLQUEwRCxDQUFBOztFQUN2RixJQUFJLENBQUMsV0FBVyxDQUFDLFlBQWIsSUFBNkIsV0FBVyxDQUFDLFVBQTdDLEVBQXlEO0lBQ3ZELE9BQU8sSUFBUCxDQUFBO0dBQ0Q7O0VBRUQsSUFBTSxPQUFPLEdBQUcsV0FBVyxDQUFDLE9BQVosQ0FBb0IsS0FBcEIsQ0FBMEIsS0FBMUIsQ0FBaEIsQ0FMdUY7O0VBUXZGLE9BQU8sT0FBTyxHQUFHLEtBQUgsR0FBVyxJQUF6QixDQUFBOzs7OztBQUtGLFNBQVMsTUFBVCxDQUFpQixHQUFqQixFQUFnRTtFQUFBLElBQ3RELFdBRHNELEdBQ3pCLEdBRHlCLENBQ3RELFdBRHNEO01BQ3pDLFdBRHlDLEdBQ3pCLEdBRHlCLENBQ3pDLFdBRHlDLENBQUE7RUFFOUQsSUFBTSxLQUFLLEdBQUcsV0FBVyxDQUFDLE9BQTFCLENBQUE7O0VBRUEsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFYLEVBQW1CO0lBQUUsT0FBQTtHQUFROztFQUU3QixJQUFJLE9BQU8sR0FBRyxXQUFkLENBTjhEOztFQVM5RCxPQUFPLE9BQUUsQ0FBQyxPQUFILENBQVcsT0FBWCxDQUFQLEVBQTRCOztJQUUxQixJQUFJLE9BQU8sS0FBSyxXQUFXLENBQUMsT0FBNUIsRUFBcUM7TUFDbkMsS0FBSyxDQUFDLE1BQU4sQ0FBYSxHQUFiLENBQUEsQ0FBQTtNQUNBLE1BQUE7S0FDRDs7SUFFRCxPQUFPLEdBQUcsUUFBRyxDQUFDLFVBQUosQ0FBZSxPQUFmLENBQVYsQ0FBQTtHQUNEO0NBQ0Y7O0FBRUQsU0FBUyxJQUFULENBQUEsS0FBQSxFQUF1RTtFQUFBLElBQXRELFdBQXNELEdBQUEsS0FBQSxDQUF0RCxXQUFzRCxDQUFBO0VBQ3JFLElBQU0sS0FBSyxHQUFHLFdBQVcsQ0FBQyxPQUExQixDQUFBOztFQUVBLElBQUksS0FBSyxDQUFDLE1BQVYsRUFBa0I7SUFDaEIsS0FBSyxDQUFDLElBQU4sRUFBQSxDQUFBO0dBQ0Q7Q0FDRjs7QUFFRCxTQUFTLGVBQVQsQ0FBQSxLQUFBLEVBQXVFO0VBQUEsSUFBaEQsWUFBZ0QsR0FBQSxLQUFBLENBQWhELFlBQWdEO01BQWxDLFFBQWtDLEdBQUEsS0FBQSxDQUFsQyxRQUFrQyxDQUFBO0VBQ3JFLE9BQU8sWUFBWSxJQUNqQixZQUFZLENBQUMsT0FEUixJQUVMLFFBQVEsQ0FBQyxJQUZKLElBR0wsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsUUFBUSxDQUFDLElBQTlCLENBQUEsQ0FBb0MsT0FIdEMsQ0FBQTtDQUlEOztBQUVELElBQU0sT0FBd0IsR0FBRztFQUMvQixFQUFFLEVBQUUsU0FEMkI7RUFFL0IsTUFBTSxFQUFFLENBQUMsZ0JBQUQsQ0FGdUI7RUFHL0IsT0FBTyxFQUFQLFlBSCtCO0VBSS9CLFNBQVMsRUFBRTtJQUNULGtCQUFBLEVBQW9CLFNBQUEsZUFBQSxDQUFBLEtBQUEsRUFBcUI7TUFBQSxJQUFsQixXQUFrQixHQUFBLEtBQUEsQ0FBbEIsV0FBa0IsQ0FBQTtNQUN2QyxXQUFXLENBQUMsT0FBWixHQUFzQixJQUFJLFlBQUosQ0FBaUIsV0FBakIsQ0FBdEIsQ0FBQTtLQUZPO0lBS1QsZ0NBQUEsRUFBa0MsVUFMekI7SUFNVCxtQkFBQSxFQUFxQixNQU5aO0lBT1QsbUJBQUEsRUFBcUIsSUFQWjtJQVNULG1DQUFBLEVBQXFDLFNBQUEsOEJBQUEsQ0FBQSxHQUFHLEVBQUk7TUFBQSxJQUNsQyxZQURrQyxHQUNqQixHQUFHLENBQUMsV0FEYSxDQUNsQyxZQURrQyxDQUFBO01BRzFDLFlBQVksQ0FBQyxJQUFiLENBQWtCLEdBQWxCLENBQUEsQ0FBQTtNQUNBLFlBQVksQ0FBQyxLQUFiLENBQW1CLEdBQW5CLEVBQXdCLEdBQUcsQ0FBQyxXQUFKLENBQWdCLE1BQWhCLENBQXVCLEdBQXZCLENBQTJCLElBQW5ELENBQUEsQ0FBQTtNQUNBLFlBQVksQ0FBQyxrQkFBYixDQUFnQyxHQUFoQyxDQUFBLENBQUE7S0FkTztJQWlCVCx5Q0FBQSxFQUEyQyxTQUFBLG9DQUFBLENBQUEsR0FBRyxFQUFBO01BQUEsT0FBSSxHQUFHLENBQUMsV0FBSixDQUFnQixZQUFoQixDQUE2QixXQUE3QixDQUF5QyxHQUF6QyxDQUFKLENBQUE7S0FqQnJDO0lBa0JULDRCQUFBLEVBQThCLFNBQVMsQ0FBQyxpQkFsQi9CO0lBbUJULGtDQUFBLEVBQW9DLFNBQVMsQ0FBQyxpQkFuQnJDO0lBb0JULHdDQUFBLEVBQTBDLFNBQUEsbUNBQUEsQ0FBQSxHQUFHLEVBQUE7TUFBQSxPQUFJLEdBQUcsQ0FBQyxXQUFKLENBQWdCLFlBQWhCLENBQTZCLHdCQUE3QixDQUFzRCxHQUF0RCxDQUFKLENBQUE7S0FwQnBDO0lBcUJULGtDQUFBLEVBQW9DLFNBQUEsNkJBQUEsQ0FBQSxHQUFHLEVBQUE7TUFBQSxPQUFJLEdBQUcsQ0FBQyxXQUFKLENBQWdCLFlBQWhCLENBQTZCLHdCQUE3QixDQUFzRCxHQUF0RCxDQUFKLENBQUE7S0FBQTtHQXJCOUI7Q0FKYjs7QUE4QkEsU0FBUyxnQkFBVCxDQUEyQixDQUEzQixFQUFzQyxFQUF0QyxFQUFrRCxFQUFsRCxFQUE4RCxFQUE5RCxFQUEwRTtFQUN4RSxJQUFNLEVBQUUsR0FBRyxDQUFBLEdBQUksQ0FBZixDQUFBO0VBQ0EsT0FBTyxFQUFFLEdBQUcsRUFBTCxHQUFVLEVBQVYsR0FBZSxDQUFBLEdBQUksRUFBSixHQUFTLENBQVQsR0FBYSxFQUE1QixHQUFpQyxDQUFDLEdBQUcsQ0FBSixHQUFRLEVBQWhELENBQUE7Q0FDRDs7QUFFRCxTQUFTLHNCQUFULENBQ0UsTUFERixFQUNrQixNQURsQixFQUNrQyxHQURsQyxFQUMrQyxHQUQvQyxFQUM0RCxJQUQ1RCxFQUMwRSxJQUQxRSxFQUN3RixRQUR4RixFQUMwRztFQUN4RyxPQUFPO0lBQ0wsQ0FBQyxFQUFHLGdCQUFnQixDQUFDLFFBQUQsRUFBVyxNQUFYLEVBQW1CLEdBQW5CLEVBQXdCLElBQXhCLENBRGY7SUFFTCxDQUFDLEVBQUcsZ0JBQWdCLENBQUMsUUFBRCxFQUFXLE1BQVgsRUFBbUIsR0FBbkIsRUFBd0IsSUFBeEIsQ0FBQTtHQUZ0QixDQUFBOzs7O0FBT0YsU0FBUyxXQUFULENBQXNCLENBQXRCLEVBQWlDLENBQWpDLEVBQTRDLENBQTVDLEVBQXVELENBQXZELEVBQWtFO0VBQ2hFLENBQUMsSUFBSSxDQUFMLENBQUE7RUFDQSxPQUFPLENBQUMsQ0FBRCxHQUFLLENBQUwsSUFBVSxDQUFDLEdBQUcsQ0FBZCxDQUFBLEdBQW1CLENBQTFCLENBQUE7Q0FDRDs7b0JBRWM7Ozs7Ozs7Ozs7O0FDalpmLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0FBQ0Esa0VBQUE7O0FBRUEsSUFBQSxrQkFBQSxHQUFBLDJCQUFBLENBQUEsaUJBQUEsQ0FBQSxDQUFBOztBQUNBLGtEQUFBOzs7Ozs7Ozs7O0FBb0JBLElBQU0sV0FBaUUsR0FBRztFQUN4RSxLQUR3RSxFQUFBLFNBQUEsS0FBQSxDQUNqRSxHQURpRSxFQUM1RDtJQUFBLElBQ0YsS0FERSxHQUN3RCxHQUR4RCxDQUNGLEtBREU7UUFDSyxJQURMLEdBQ3dELEdBRHhELENBQ0ssSUFETDtRQUNrQixhQURsQixHQUN3RCxHQUR4RCxDQUNXLEtBRFg7UUFDNkMsTUFEN0MsR0FDd0QsR0FEeEQsQ0FDaUMsVUFEakMsQ0FBQTtJQUFBLElBRUosS0FGSSxHQUVNLEtBQUssQ0FBQyxPQUZaLENBRUosS0FGSSxDQUFBO0lBQUEsSUFBQSxjQUFBLEdBR3dCLEtBQUssQ0FBQyxPQUg5QjtRQUdGLFVBSEUsR0FBQSxjQUFBLENBR0YsVUFIRTtRQUdVLFNBSFYsR0FBQSxjQUFBLENBR1UsU0FIVixDQUFBOztJQUtWLElBQUksS0FBSyxLQUFLLFVBQWQsRUFBMEI7TUFDeEIsS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFMLEdBQWEsSUFBSSxDQUFDLE1BQTFCLENBQUE7S0FDRDs7SUFFRCxLQUFLLENBQUMsV0FBTixHQUFvQixDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sRUFBUCxFQUFXLE1BQVgsQ0FBcEIsQ0FBQTtJQUNBLEtBQUssQ0FBQyxTQUFOLEdBQWtCLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxFQUFQLEVBQVcsSUFBWCxDQUFsQixDQUFBO0lBQ0EsS0FBSyxDQUFDLEtBQU4sR0FBYyxLQUFkLENBQUE7SUFDQSxLQUFLLENBQUMsVUFBTixHQUFtQixVQUFuQixDQUFBO0lBRUEsSUFBTSxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQU4sR0FBb0I7TUFDdEMsR0FBRyxFQUFLLGFBQWEsQ0FBQyxHQUFkLElBQXlCLGFBQWEsQ0FBQyxJQUFkLElBQXdCLENBQUMsYUFBYSxDQUFDLE1BRGxDO01BRXRDLElBQUksRUFBSSxhQUFhLENBQUMsSUFBZCxJQUF5QixhQUFhLENBQUMsR0FBZCxJQUF3QixDQUFDLGFBQWEsQ0FBQyxLQUZsQztNQUd0QyxNQUFNLEVBQUUsYUFBYSxDQUFDLE1BQWQsSUFBeUIsYUFBYSxDQUFDLEtBQWQsSUFBd0IsQ0FBQyxhQUFhLENBQUMsR0FIbEM7TUFJdEMsS0FBSyxFQUFHLGFBQWEsQ0FBQyxLQUFkLElBQXlCLGFBQWEsQ0FBQyxNQUFkLElBQXdCLENBQUMsYUFBYSxDQUFDLElBQUE7S0FKMUUsQ0FBQTtJQU9BLEtBQUssQ0FBQyxjQUFOLEdBQXVCLENBQUMsRUFBRSxhQUFhLENBQUMsSUFBZCxJQUFzQixhQUFhLENBQUMsS0FBdEMsQ0FBeEIsQ0FBQTs7SUFFQSxJQUFJLEtBQUssQ0FBQyxVQUFWLEVBQXNCO01BQ3BCLEtBQUssQ0FBQyxRQUFOLEdBQWlCLENBQUMsV0FBVyxDQUFDLElBQVosR0FBbUIsQ0FBbkIsR0FBdUIsQ0FBQyxDQUF6QixLQUErQixXQUFXLENBQUMsR0FBWixHQUFrQixDQUFsQixHQUFzQixDQUFDLENBQXRELENBQWpCLENBQUE7S0FERixNQUdLO01BQ0gsSUFBTSxxQkFBcUIsR0FBRyxLQUFLLENBQUMsY0FBTixHQUF1QixXQUFXLENBQUMsR0FBbkMsR0FBeUMsV0FBVyxDQUFDLElBQW5GLENBQUE7TUFDQSxLQUFLLENBQUMsUUFBTixHQUFpQixxQkFBcUIsR0FBRyxDQUFDLENBQUosR0FBUSxDQUE5QyxDQUFBO0tBQ0Q7O0lBRUQsQ0FBQSxDQUFBLEVBQUEsWUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLEdBQUcsQ0FBQyxLQUFYLEVBQWtCLFdBQWxCLENBQUEsQ0FBQTs7SUFFQSxJQUFJLENBQUMsU0FBRCxJQUFjLENBQUMsU0FBUyxDQUFDLE1BQTdCLEVBQXFDO01BQUUsT0FBQTtLQUFROztJQUUvQyxJQUFNLGVBQWUsR0FBRyxJQUFJLGtCQUFBLENBQUEsU0FBQSxDQUFKLENBQWlCLEdBQUcsQ0FBQyxXQUFyQixDQUF4QixDQUFBO0lBRUEsZUFBZSxDQUFDLFFBQWhCLENBQXlCLEdBQUcsQ0FBQyxXQUFKLENBQWdCLFlBQXpDLENBQUEsQ0FBQTtJQUNBLGVBQWUsQ0FBQyxhQUFoQixDQUE4QixTQUE5QixDQUFBLENBQUE7SUFFQSxLQUFLLENBQUMsZUFBTixHQUF3QixlQUF4QixDQUFBO0lBQ0EsZUFBZSxDQUFDLFFBQWhCLENBQUEsYUFBQSxDQUFBLEVBQUEsRUFBOEIsR0FBOUIsQ0FBQSxDQUFBLENBQUE7R0ExQ3NFO0VBNkN4RSxHQTdDd0UsRUFBQSxTQUFBLEdBQUEsQ0E2Q25FLEdBN0NtRSxFQTZDOUQ7SUFBQSxJQUNBLEtBREEsR0FDd0IsR0FEeEIsQ0FDQSxLQURBO1FBQ08sSUFEUCxHQUN3QixHQUR4QixDQUNPLElBRFA7UUFDYSxNQURiLEdBQ3dCLEdBRHhCLENBQ2EsTUFEYixDQUFBO0lBRVIsSUFBTSxhQUFhLEdBQUcsQ0FBQSxDQUFBLEVBQUEsWUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLEVBQVAsRUFBVyxNQUFYLENBQXRCLENBQUE7SUFDQSxJQUFNLFlBQVksR0FBRyxLQUFLLENBQUMsVUFBTixHQUFtQixhQUFuQixHQUFtQyxRQUF4RCxDQUFBO0lBRUEsWUFBWSxDQUFDLEtBQUQsRUFBUSxLQUFLLENBQUMsY0FBZCxFQUE4QixNQUE5QixFQUFzQyxJQUF0QyxDQUFaLENBQUE7O0lBRUEsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFYLEVBQTRCO01BQUUsT0FBTyxJQUFQLENBQUE7S0FBYTs7SUFFM0MsSUFBTSxhQUFhLEdBQUcsQ0FBQSxDQUFBLEVBQUEsWUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLEVBQVAsRUFBVyxJQUFYLENBQXRCLENBQUE7SUFFQSxDQUFBLENBQUEsRUFBQSxTQUFBLENBQUEsUUFBQSxFQUFTLEtBQUssQ0FBQyxXQUFmLEVBQTRCLGFBQTVCLEVBQTJDO01BQUUsQ0FBQyxFQUFFLE1BQU0sQ0FBQyxDQUFQLEdBQVcsYUFBYSxDQUFDLENBQTlCO01BQWlDLENBQUMsRUFBRSxNQUFNLENBQUMsQ0FBUCxHQUFXLGFBQWEsQ0FBQyxDQUFBO0tBQXhHLENBQUEsQ0FBQTtJQUVBLElBQU0sTUFBTSxHQUFHLEtBQUssQ0FBQyxlQUFOLENBQXNCLE1BQXRCLENBQUEsYUFBQSxDQUFBLEVBQUEsRUFDVixHQURVLEVBQUE7TUFFYixJQUFJLEVBQUUsYUFGTztNQUdiLEtBQUssRUFBRSxLQUFLLENBQUMsV0FIQTtNQUliLFVBQVUsRUFBRSxNQUpDO01BS2IsVUFBVSxFQUFFLE1BTEM7TUFNYixRQUFRLEVBQUUsYUFBQTtLQU5HLENBQUEsQ0FBZixDQUFBO0lBYlEsSUFzQkEsS0F0QkEsR0FzQlUsTUF0QlYsQ0FzQkEsS0F0QkEsQ0FBQTs7SUF3QlIsSUFBSSxNQUFNLENBQUMsT0FBWCxFQUFvQjtNQUNsQixJQUFNLGVBQWUsR0FBRyxJQUFJLENBQUMsR0FBTCxDQUFTLEtBQUssQ0FBQyxDQUFmLENBQUEsR0FBb0IsSUFBSSxDQUFDLEdBQUwsQ0FBUyxLQUFLLENBQUMsQ0FBZixDQUE1QyxDQURrQjs7TUFJbEIsWUFBWSxDQUFDLEtBQUQsRUFBUSxlQUFSLEVBQXlCLE1BQU0sQ0FBQyxNQUFoQyxFQUF3QyxNQUFNLENBQUMsSUFBL0MsQ0FBWixDQUFBO01BQ0EsQ0FBQSxDQUFBLEVBQUEsWUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLE1BQVAsRUFBZSxNQUFNLENBQUMsTUFBdEIsQ0FBQSxDQUFBO0tBQ0Q7O0lBRUQsT0FBTyxNQUFNLENBQUMsVUFBZCxDQUFBO0dBN0VzRTtFQWdGeEUsUUFBUSxFQUFFO0lBQ1IsS0FBSyxFQUFFLFVBREM7SUFFUixVQUFVLEVBQUUsS0FGSjtJQUdSLFNBQVMsRUFBRSxFQUhIO0lBSVIsT0FBTyxFQUFFLEtBQUE7R0FKRDtDQWhGWixDQUFBOzs7QUF3RkEsU0FBUyxhQUFULENBQUEsSUFBQSxFQUFxRSxjQUFyRSxFQUE4RixNQUE5RixFQUFzSDtFQUFBLElBQTVGLFdBQTRGLEdBQUEsSUFBQSxDQUE1RixXQUE0RjtNQUEvRSxRQUErRSxHQUFBLElBQUEsQ0FBL0UsUUFBK0UsQ0FBQTs7RUFDcEgsSUFBSSxjQUFKLEVBQW9CO0lBQ2xCLE1BQU0sQ0FBQyxDQUFQLEdBQVcsV0FBVyxDQUFDLENBQVosR0FBZ0IsQ0FBQyxNQUFNLENBQUMsQ0FBUCxHQUFXLFdBQVcsQ0FBQyxDQUF4QixJQUE2QixRQUF4RCxDQUFBO0dBREYsTUFHSztJQUNILE1BQU0sQ0FBQyxDQUFQLEdBQVcsV0FBVyxDQUFDLENBQVosR0FBZ0IsQ0FBQyxNQUFNLENBQUMsQ0FBUCxHQUFXLFdBQVcsQ0FBQyxDQUF4QixJQUE2QixRQUF4RCxDQUFBO0dBQ0Q7Q0FDRjs7QUFFRCxTQUFTLFFBQVQsQ0FBQSxLQUFBLEVBQWtGLGNBQWxGLEVBQTJHLE1BQTNHLEVBQW1JLElBQW5JLEVBQXdKO0VBQUEsSUFBbkksU0FBbUksR0FBQSxLQUFBLENBQW5JLFNBQW1JO01BQXhILFdBQXdILEdBQUEsS0FBQSxDQUF4SCxXQUF3SDtNQUEzRyxLQUEyRyxHQUFBLEtBQUEsQ0FBM0csS0FBMkc7TUFBcEcsUUFBb0csR0FBQSxLQUFBLENBQXBHLFFBQW9HLENBQUE7O0VBQ3RKLElBQUksY0FBSixFQUFvQjtJQUNsQixJQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsS0FBTCxHQUFhLEtBQS9CLENBQUE7SUFFQSxNQUFNLENBQUMsQ0FBUCxHQUFXLFdBQVcsQ0FBQyxDQUFaLEdBQWdCLENBQUMsU0FBUyxHQUFHLFNBQVMsQ0FBQyxNQUF2QixJQUFpQyxRQUE1RCxDQUFBO0dBSEYsTUFLSztJQUNILElBQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxNQUFMLEdBQWMsS0FBL0IsQ0FBQTtJQUVBLE1BQU0sQ0FBQyxDQUFQLEdBQVcsV0FBVyxDQUFDLENBQVosR0FBZ0IsQ0FBQyxRQUFRLEdBQUcsU0FBUyxDQUFDLEtBQXRCLElBQStCLFFBQTFELENBQUE7R0FDRDtDQUNGOztvQkFFYyxDQUFBLENBQUEsRUFBQSxTQUFBLENBQUEsWUFBQSxFQUFhLFdBQWIsRUFBMEIsYUFBMUI7Ozs7Ozs7Ozs7Ozs7OztBQ3pKZixJQUFBLFlBQUEsR0FBQSwyQkFBQSxDQUFBLFdBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsT0FBQSxHQUFBLDRCQUFBLENBQUEsT0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxjQUFBLEdBQUEsNEJBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBQTs7QUFDQSxtREFBQTs7Ozs7Ozs7QUFpQkEsU0FBUyxVQUFULENBQUEsSUFBQSxFQUFtRztFQUFBLElBQWpGLElBQWlGLEdBQUEsSUFBQSxDQUFqRixJQUFpRjtNQUEzRSxXQUEyRSxHQUFBLElBQUEsQ0FBM0UsV0FBMkU7TUFBOUQsS0FBOEQsR0FBQSxJQUFBLENBQTlELEtBQThEO01BQXZELFdBQXVELEdBQUEsSUFBQSxDQUF2RCxXQUF1RDtNQUExQyxVQUEwQyxHQUFBLElBQUEsQ0FBMUMsVUFBMEMsQ0FBQTtFQUFBLElBQ3pGLE9BRHlGLEdBQzdFLEtBRDZFLENBQ3pGLE9BRHlGLENBQUE7RUFBQSxJQUV6RixXQUZ5RixHQUV6RSxPQUZ5RSxDQUV6RixXQUZ5RixDQUFBO0VBR2pHLElBQU0sTUFBcUIsR0FBRyxDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU87SUFDbkMsSUFBSSxFQUFFLENBRDZCO0lBRW5DLEdBQUcsRUFBRSxDQUY4QjtJQUduQyxLQUFLLEVBQUUsQ0FINEI7SUFJbkMsTUFBTSxFQUFFLENBQUE7R0FKb0IsRUFLM0IsT0FBTyxDQUFDLE1BQVIsSUFBa0IsRUFMUyxDQUE5QixDQUFBOztFQU9BLElBQUksSUFBSSxJQUFJLFdBQVosRUFBeUI7SUFDdkIsSUFBTSxXQUFXLEdBQUcsa0JBQWtCLENBQUMsT0FBTyxDQUFDLFdBQVQsRUFBc0IsV0FBdEIsRUFBbUMsVUFBbkMsQ0FBdEMsQ0FBQTs7SUFFQSxJQUFJLFdBQUosRUFBaUI7TUFDZixJQUFNLFNBQVMsR0FBSSxXQUFXLENBQUMsS0FBWixHQUFvQixXQUFXLENBQUMsSUFBakMsR0FBeUMsSUFBSSxDQUFDLEtBQWhFLENBQUE7TUFDQSxJQUFNLFVBQVUsR0FBSSxXQUFXLENBQUMsTUFBWixHQUFxQixXQUFXLENBQUMsR0FBbEMsR0FBeUMsSUFBSSxDQUFDLE1BQWpFLENBQUE7O01BRUEsSUFBSSxTQUFTLEdBQUcsQ0FBaEIsRUFBbUI7UUFDakIsTUFBTSxDQUFDLElBQVAsSUFBZSxTQUFmLENBQUE7UUFDQSxNQUFNLENBQUMsS0FBUCxJQUFnQixTQUFoQixDQUFBO09BQ0Q7O01BQ0QsSUFBSSxVQUFVLEdBQUcsQ0FBakIsRUFBb0I7UUFDbEIsTUFBTSxDQUFDLEdBQVAsSUFBYyxVQUFkLENBQUE7UUFDQSxNQUFNLENBQUMsTUFBUCxJQUFpQixVQUFqQixDQUFBO09BQ0Q7S0FDRjs7SUFFRCxNQUFNLENBQUMsSUFBUCxJQUFlLFdBQVcsQ0FBQyxJQUFaLEdBQW9CLElBQUksQ0FBQyxLQUFMLEdBQWMsV0FBVyxDQUFDLElBQTdELENBQUE7SUFDQSxNQUFNLENBQUMsR0FBUCxJQUFlLFdBQVcsQ0FBQyxHQUFaLEdBQW9CLElBQUksQ0FBQyxNQUFMLEdBQWMsV0FBVyxDQUFDLEdBQTdELENBQUE7SUFFQSxNQUFNLENBQUMsS0FBUCxJQUFpQixXQUFXLENBQUMsS0FBWixHQUFzQixJQUFJLENBQUMsS0FBTCxJQUFlLENBQUEsR0FBSSxXQUFXLENBQUMsS0FBL0IsQ0FBdkMsQ0FBQTtJQUNBLE1BQU0sQ0FBQyxNQUFQLElBQWlCLFdBQVcsQ0FBQyxNQUFaLEdBQXNCLElBQUksQ0FBQyxNQUFMLElBQWUsQ0FBQSxHQUFJLFdBQVcsQ0FBQyxNQUEvQixDQUF2QyxDQUFBO0dBQ0Q7O0VBRUQsS0FBSyxDQUFDLE1BQU4sR0FBZSxNQUFmLENBQUE7Q0FDRDs7QUFFRCxTQUFTLEdBQVQsQ0FBQSxLQUFBLEVBQTBFO0VBQUEsSUFBMUQsTUFBMEQsR0FBQSxLQUFBLENBQTFELE1BQTBEO01BQWxELFdBQWtELEdBQUEsS0FBQSxDQUFsRCxXQUFrRDtNQUFyQyxLQUFxQyxHQUFBLEtBQUEsQ0FBckMsS0FBcUMsQ0FBQTtFQUFBLElBQ2hFLE9BRGdFLEdBQzVDLEtBRDRDLENBQ2hFLE9BRGdFO01BQ3ZELE1BRHVELEdBQzVDLEtBRDRDLENBQ3ZELE1BRHVELENBQUE7RUFHeEUsSUFBTSxXQUFXLEdBQUcsa0JBQWtCLENBQUMsT0FBTyxDQUFDLFdBQVQsRUFBc0IsV0FBdEIsRUFBbUMsTUFBbkMsQ0FBdEMsQ0FBQTs7RUFFQSxJQUFJLENBQUMsV0FBTCxFQUFrQjtJQUFFLE9BQUE7R0FBUTs7RUFFNUIsSUFBTSxJQUFJLEdBQUcsY0FBUyxDQUFDLFVBQVYsQ0FBcUIsV0FBckIsQ0FBYixDQUFBO0VBRUEsTUFBTSxDQUFDLENBQVAsR0FBVyxJQUFJLENBQUMsR0FBTCxDQUFTLElBQUksQ0FBQyxHQUFMLENBQVMsSUFBSSxDQUFDLEtBQUwsR0FBYyxNQUFNLENBQUMsS0FBOUIsRUFBcUMsTUFBTSxDQUFDLENBQTVDLENBQVQsRUFBeUQsSUFBSSxDQUFDLElBQUwsR0FBWSxNQUFNLENBQUMsSUFBNUUsQ0FBWCxDQUFBO0VBQ0EsTUFBTSxDQUFDLENBQVAsR0FBVyxJQUFJLENBQUMsR0FBTCxDQUFTLElBQUksQ0FBQyxHQUFMLENBQVMsSUFBSSxDQUFDLE1BQUwsR0FBYyxNQUFNLENBQUMsTUFBOUIsRUFBc0MsTUFBTSxDQUFDLENBQTdDLENBQVQsRUFBMEQsSUFBSSxDQUFDLEdBQUwsR0FBWSxNQUFNLENBQUMsR0FBN0UsQ0FBWCxDQUFBO0NBQ0Q7O0FBRU0sU0FBUyxrQkFBVCxDQUNMLEtBREssRUFFTCxXQUZLLEVBR0wsTUFISyxFQUlMO0VBQ0EsSUFBSSxPQUFFLENBQUMsSUFBSCxDQUFRLEtBQVIsQ0FBSixFQUFvQjtJQUNsQixPQUFPLGNBQVMsQ0FBQyxlQUFWLENBQTBCLEtBQTFCLEVBQWlDLFdBQVcsQ0FBQyxZQUE3QyxFQUEyRCxXQUFXLENBQUMsT0FBdkUsRUFBZ0YsQ0FBQyxNQUFNLENBQUMsQ0FBUixFQUFXLE1BQU0sQ0FBQyxDQUFsQixFQUFxQixXQUFyQixDQUFoRixDQUFQLENBQUE7R0FERixNQUVPO0lBQ0wsT0FBTyxjQUFTLENBQUMsZUFBVixDQUEwQixLQUExQixFQUFpQyxXQUFXLENBQUMsWUFBN0MsRUFBMkQsV0FBVyxDQUFDLE9BQXZFLENBQVAsQ0FBQTtHQUNEO0NBQ0Y7O0FBRUQsSUFBTSxhQUF5QixHQUFHO0VBQ2hDLFdBQVcsRUFBRSxJQURtQjtFQUVoQyxXQUFXLEVBQUUsSUFGbUI7RUFHaEMsTUFBTSxFQUFFLElBSHdCO0VBSWhDLE9BQU8sRUFBRSxLQUp1QjtFQUtoQyxPQUFPLEVBQUUsS0FBQTtDQUxYLENBQUE7QUFRQSxJQUFNLFFBQXdELEdBQUc7RUFDL0QsS0FBSyxFQUFMLFVBRCtEO0VBRS9ELEdBQUcsRUFBSCxHQUYrRDtFQUcvRCxRQUFRLEVBQVIsYUFBQTtDQUhGLENBQUE7OztvQkFNZSxDQUFBLENBQUEsRUFBQSxTQUFBLENBQUEsWUFBQSxFQUFhLFFBQWIsRUFBdUIsVUFBdkI7Ozs7Ozs7Ozs7Ozs7O0FDckZmLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxjQUFBLEdBQUEsNEJBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBQTs7QUFDQSxtREFBQTs7QUFDQSx3REFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBZ0JBLElBQU0sT0FBTyxHQUFHO0VBQUUsR0FBRyxFQUFFLENBQUMsUUFBUjtFQUFrQixJQUFJLEVBQUUsQ0FBQyxRQUF6QjtFQUFtQyxNQUFNLEVBQUUsQ0FBQyxRQUE1QztFQUFzRCxLQUFLLEVBQUUsQ0FBQyxRQUFBO0NBQTlFLENBQUE7QUFDQSxJQUFNLE9BQU8sR0FBRztFQUFFLEdBQUcsRUFBRSxDQUFDLFFBQVI7RUFBa0IsSUFBSSxFQUFFLENBQUMsUUFBekI7RUFBbUMsTUFBTSxFQUFFLENBQUMsUUFBNUM7RUFBc0QsS0FBSyxFQUFFLENBQUMsUUFBQTtDQUE5RSxDQUFBOztBQUVBLFNBQVMsVUFBVCxDQUFBLElBQUEsRUFBc0Y7RUFBQSxJQUFwRSxXQUFvRSxHQUFBLElBQUEsQ0FBcEUsV0FBb0U7TUFBdkQsV0FBdUQsR0FBQSxJQUFBLENBQXZELFdBQXVEO01BQTFDLEtBQTBDLEdBQUEsSUFBQSxDQUExQyxLQUEwQyxDQUFBO0VBQUEsSUFDNUUsT0FENEUsR0FDaEUsS0FEZ0UsQ0FDNUUsT0FENEUsQ0FBQTtFQUVwRixJQUFJLE1BQUosQ0FBQTs7RUFFQSxJQUFJLE9BQUosRUFBYTtJQUNYLElBQU0sVUFBVSxHQUFHLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxrQkFBQSxFQUFtQixPQUFPLENBQUMsTUFBM0IsRUFBbUMsV0FBbkMsRUFBZ0QsV0FBVyxDQUFDLE1BQVosQ0FBbUIsS0FBbkIsQ0FBeUIsSUFBekUsQ0FBbkIsQ0FBQTtJQUVBLE1BQU0sR0FBRyxjQUFTLENBQUMsUUFBVixDQUFtQixVQUFuQixDQUFULENBQUE7R0FDRDs7RUFFRCxNQUFNLEdBQUcsTUFBTSxJQUFJO0lBQUUsQ0FBQyxFQUFFLENBQUw7SUFBUSxDQUFDLEVBQUUsQ0FBQTtHQUE5QixDQUFBO0VBRUEsS0FBSyxDQUFDLE1BQU4sR0FBZTtJQUNiLEdBQUcsRUFBSyxNQUFNLENBQUMsQ0FBUCxHQUFXLFdBQVcsQ0FBQyxHQURsQjtJQUViLElBQUksRUFBSSxNQUFNLENBQUMsQ0FBUCxHQUFXLFdBQVcsQ0FBQyxJQUZsQjtJQUdiLE1BQU0sRUFBRSxNQUFNLENBQUMsQ0FBUCxHQUFXLFdBQVcsQ0FBQyxNQUhsQjtJQUliLEtBQUssRUFBRyxNQUFNLENBQUMsQ0FBUCxHQUFXLFdBQVcsQ0FBQyxLQUFBO0dBSmpDLENBQUE7Q0FNRDs7QUFFRCxTQUFTLFFBQVQsQ0FBQSxLQUFBLEVBQXNGO0VBQUEsSUFBdEUsTUFBc0UsR0FBQSxLQUFBLENBQXRFLE1BQXNFO01BQTlELEtBQThELEdBQUEsS0FBQSxDQUE5RCxLQUE4RDtNQUF2RCxXQUF1RCxHQUFBLEtBQUEsQ0FBdkQsV0FBdUQ7TUFBMUMsS0FBMEMsR0FBQSxLQUFBLENBQTFDLEtBQTBDLENBQUE7RUFBQSxJQUM1RSxNQUQ0RSxHQUN4RCxLQUR3RCxDQUM1RSxNQUQ0RTtNQUNwRSxPQURvRSxHQUN4RCxLQUR3RCxDQUNwRSxPQURvRSxDQUFBOztFQUdwRixJQUFJLENBQUMsS0FBTCxFQUFZO0lBQ1YsT0FBQTtHQUNEOztFQUVELElBQU0sSUFBSSxHQUFHLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxFQUFQLEVBQVcsTUFBWCxDQUFiLENBQUE7RUFDQSxJQUFNLEtBQUssR0FBRyxDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsa0JBQUEsRUFBbUIsT0FBTyxDQUFDLEtBQTNCLEVBQWtDLFdBQWxDLEVBQStDLElBQS9DLENBQUEsSUFBd0QsRUFBdEUsQ0FBQTtFQUNBLElBQU0sS0FBSyxHQUFHLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxrQkFBQSxFQUFtQixPQUFPLENBQUMsS0FBM0IsRUFBa0MsV0FBbEMsRUFBK0MsSUFBL0MsQ0FBQSxJQUF3RCxFQUF0RSxDQUFBO0VBRUEsT0FBTyxDQUFDLEtBQUQsRUFBUSxPQUFSLENBQVAsQ0FBQTtFQUNBLE9BQU8sQ0FBQyxLQUFELEVBQVEsT0FBUixDQUFQLENBQUE7O0VBRUEsSUFBSSxLQUFLLENBQUMsR0FBVixFQUFlO0lBQ2IsTUFBTSxDQUFDLENBQVAsR0FBVyxJQUFJLENBQUMsR0FBTCxDQUFTLElBQUksQ0FBQyxHQUFMLENBQVMsS0FBSyxDQUFDLEdBQU4sR0FBZSxNQUFNLENBQUMsR0FBL0IsRUFBdUMsSUFBSSxDQUFDLENBQTVDLENBQVQsRUFBeUQsS0FBSyxDQUFDLEdBQU4sR0FBZSxNQUFNLENBQUMsR0FBL0UsQ0FBWCxDQUFBO0dBREYsTUFHSyxJQUFJLEtBQUssQ0FBQyxNQUFWLEVBQWtCO0lBQ3JCLE1BQU0sQ0FBQyxDQUFQLEdBQVcsSUFBSSxDQUFDLEdBQUwsQ0FBUyxJQUFJLENBQUMsR0FBTCxDQUFTLEtBQUssQ0FBQyxNQUFOLEdBQWUsTUFBTSxDQUFDLE1BQS9CLEVBQXVDLElBQUksQ0FBQyxDQUE1QyxDQUFULEVBQXlELEtBQUssQ0FBQyxNQUFOLEdBQWUsTUFBTSxDQUFDLE1BQS9FLENBQVgsQ0FBQTtHQUNEOztFQUNELElBQUksS0FBSyxDQUFDLElBQVYsRUFBZ0I7SUFDZCxNQUFNLENBQUMsQ0FBUCxHQUFXLElBQUksQ0FBQyxHQUFMLENBQVMsSUFBSSxDQUFDLEdBQUwsQ0FBUyxLQUFLLENBQUMsSUFBTixHQUFlLE1BQU0sQ0FBQyxJQUEvQixFQUF1QyxJQUFJLENBQUMsQ0FBNUMsQ0FBVCxFQUF5RCxLQUFLLENBQUMsSUFBTixHQUFlLE1BQU0sQ0FBQyxJQUEvRSxDQUFYLENBQUE7R0FERixNQUdLLElBQUksS0FBSyxDQUFDLEtBQVYsRUFBaUI7SUFDcEIsTUFBTSxDQUFDLENBQVAsR0FBVyxJQUFJLENBQUMsR0FBTCxDQUFTLElBQUksQ0FBQyxHQUFMLENBQVMsS0FBSyxDQUFDLEtBQU4sR0FBZSxNQUFNLENBQUMsS0FBL0IsRUFBdUMsSUFBSSxDQUFDLENBQTVDLENBQVQsRUFBeUQsS0FBSyxDQUFDLEtBQU4sR0FBZSxNQUFNLENBQUMsS0FBL0UsQ0FBWCxDQUFBO0dBQ0Q7Q0FDRjs7QUFFRCxTQUFTLE9BQVQsQ0FBa0IsSUFBbEIsRUFBd0IsUUFBeEIsRUFBa0M7RUFBQSxJQUFBLElBQUEsR0FDYixDQUFDLEtBQUQsRUFBUSxNQUFSLEVBQWdCLFFBQWhCLEVBQTBCLE9BQTFCLENBRGEsQ0FBQTs7RUFDaEMsS0FBQSxJQUFBLEVBQUEsR0FBQSxDQUFBLEVBQUEsRUFBQSxHQUFBLElBQUEsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQXVEO0lBQWxELElBQU0sSUFBSSxHQUFBLElBQUEsQ0FBQSxFQUFBLENBQVYsQ0FBQTs7SUFDSCxJQUFJLEVBQUUsSUFBSSxJQUFJLElBQVYsQ0FBSixFQUFxQjtNQUNuQixJQUFJLENBQUMsSUFBRCxDQUFKLEdBQWEsUUFBUSxDQUFDLElBQUQsQ0FBckIsQ0FBQTtLQUNEO0dBQ0Y7O0VBRUQsT0FBTyxJQUFQLENBQUE7Q0FDRDs7QUFFRCxJQUFNLGFBQThCLEdBQUc7RUFDckMsS0FBSyxFQUFFLElBRDhCO0VBRXJDLEtBQUssRUFBRSxJQUY4QjtFQUdyQyxNQUFNLEVBQUUsSUFINkI7RUFJckMsT0FBTyxFQUFFLEtBSjRCO0VBS3JDLE9BQU8sRUFBRSxLQUFBO0NBTFgsQ0FBQTtBQVFBLElBQU0sYUFBYSxHQUFHO0VBQ3BCLE9BQU8sRUFBUCxPQURvQjtFQUVwQixPQUFPLEVBQVAsT0FGb0I7RUFHcEIsS0FBSyxFQUFMLFVBSG9CO0VBSXBCLEdBQUcsRUFBSCxRQUpvQjtFQUtwQixRQUFRLEVBQVIsYUFBQTtDQUxGLENBQUE7OztvQkFRZSxDQUFBLENBQUEsRUFBQSxTQUFBLENBQUEsWUFBQSxFQUFhLGFBQWIsRUFBNEIsZUFBNUI7Ozs7Ozs7Ozs7OztBQzNHZixJQUFBLFlBQUEsR0FBQSwyQkFBQSxDQUFBLFdBQUEsQ0FBQSxDQUFBOztBQUNBLHdEQUFBOztBQUNBLG1EQUFBOzs7O0FBRUEsSUFBTSxhQUFRLEdBQUcsQ0FBQSxDQUFBLEVBQUEsWUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPO0VBQ3RCLElBQUksV0FBSixHQUFtQjtJQUNqQixPQUFPO01BQUUsR0FBRyxFQUFFLENBQVA7TUFBVSxJQUFJLEVBQUUsQ0FBaEI7TUFBbUIsTUFBTSxFQUFFLENBQTNCO01BQThCLEtBQUssRUFBRSxDQUFBO0tBQTVDLENBQUE7R0FGb0I7O0VBSXRCLElBQUksV0FBSixDQUFpQixDQUFqQixFQUFvQixFQUFFOztDQUpQLEVBS2QsWUFBQSxDQUFBLFFBQUEsQ0FBUyxRQUxLLENBQWpCLENBQUE7QUFPQSxJQUFNLFlBQVksR0FBRztFQUNuQixLQUFLLEVBQUUsWUFBQSxDQUFBLFFBQUEsQ0FBUyxLQURHO0VBRW5CLEdBQUcsRUFBRSxZQUFBLENBQUEsUUFBQSxDQUFTLEdBRks7RUFHbkIsUUFBUSxFQUFSLGFBQUE7Q0FIRixDQUFBOzs7b0JBTWUsQ0FBQSxDQUFBLEVBQUEsU0FBQSxDQUFBLFlBQUEsRUFBYSxZQUFiLEVBQTJCLGNBQTNCOzs7Ozs7Ozs7Ozs7OztBQ2pCZixJQUFBLFlBQUEsR0FBQSwyQkFBQSxDQUFBLFdBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsY0FBQSxHQUFBLDRCQUFBLENBQUEsU0FBQSxDQUFBLENBQUE7O0FBQ0EsbURBQUE7O0FBQ0Esb0RBQUE7O0FBQ0Esd0RBQUE7Ozs7Ozs7O0FBRUEsSUFBTSxLQUFLLEdBQUc7RUFBRSxLQUFLLEVBQUUsQ0FBQyxRQUFWO0VBQW9CLE1BQU0sRUFBRSxDQUFDLFFBQUE7Q0FBM0MsQ0FBQTtBQUNBLElBQU0sS0FBSyxHQUFHO0VBQUUsS0FBSyxFQUFFLENBQUMsUUFBVjtFQUFvQixNQUFNLEVBQUUsQ0FBQyxRQUFBO0NBQTNDLENBQUE7O0FBU0EsU0FBUyxVQUFULENBQWdCLEdBQWhCLEVBQXNEO0VBQ3BELE9BQU8sVUFBQSxDQUFBLGFBQUEsQ0FBYyxLQUFkLENBQW9CLEdBQXBCLENBQVAsQ0FBQTtDQUNEOztBQVFELFNBQVMsUUFBVCxDQUFjLEdBQWQsRUFBbUQ7RUFBQSxJQUN6QyxXQUR5QyxHQUNMLEdBREssQ0FDekMsV0FEeUM7TUFDNUIsS0FENEIsR0FDTCxHQURLLENBQzVCLEtBRDRCO01BQ3JCLElBRHFCLEdBQ0wsR0FESyxDQUNyQixJQURxQjtNQUNmLEtBRGUsR0FDTCxHQURLLENBQ2YsS0FEZSxDQUFBO0VBQUEsSUFFekMsT0FGeUMsR0FFN0IsS0FGNkIsQ0FFekMsT0FGeUMsQ0FBQTs7RUFJakQsSUFBSSxDQUFDLEtBQUwsRUFBWTtJQUNWLE9BQUE7R0FDRDs7RUFFRCxJQUFNLE9BQU8sR0FBRyxjQUFTLENBQUMsVUFBVixDQUFxQixDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsa0JBQUEsRUFBbUIsT0FBTyxDQUFDLEdBQTNCLEVBQXVDLFdBQXZDLEVBQW9ELEdBQUcsQ0FBQyxNQUF4RCxDQUFyQixDQUFBLElBQXlGLEtBQXpHLENBQUE7RUFDQSxJQUFNLE9BQU8sR0FBRyxjQUFTLENBQUMsVUFBVixDQUFxQixDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsa0JBQUEsRUFBbUIsT0FBTyxDQUFDLEdBQTNCLEVBQXVDLFdBQXZDLEVBQW9ELEdBQUcsQ0FBQyxNQUF4RCxDQUFyQixDQUFBLElBQXlGLEtBQXpHLENBQUE7RUFFQSxLQUFLLENBQUMsT0FBTixHQUFnQjtJQUNkLE9BQU8sRUFBRSxPQUFPLENBQUMsT0FESDtJQUVkLEtBQUssRUFBRSxDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sRUFBUCxFQUFXLFVBQUEsQ0FBQSxhQUFBLENBQWMsT0FBekIsQ0FGTztJQUdkLEtBQUssRUFBRSxDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sRUFBUCxFQUFXLFVBQUEsQ0FBQSxhQUFBLENBQWMsT0FBekIsQ0FBQTtHQUhULENBQUE7O0VBTUEsSUFBSSxLQUFLLENBQUMsR0FBVixFQUFlO0lBQ2IsS0FBSyxDQUFDLE9BQU4sQ0FBYyxLQUFkLENBQW9CLEdBQXBCLEdBQTBCLElBQUksQ0FBQyxNQUFMLEdBQWMsT0FBTyxDQUFDLE1BQWhELENBQUE7SUFDQSxLQUFLLENBQUMsT0FBTixDQUFjLEtBQWQsQ0FBb0IsR0FBcEIsR0FBMEIsSUFBSSxDQUFDLE1BQUwsR0FBYyxPQUFPLENBQUMsTUFBaEQsQ0FBQTtHQUZGLE1BSUssSUFBSSxLQUFLLENBQUMsTUFBVixFQUFrQjtJQUNyQixLQUFLLENBQUMsT0FBTixDQUFjLEtBQWQsQ0FBb0IsTUFBcEIsR0FBNkIsSUFBSSxDQUFDLEdBQUwsR0FBVyxPQUFPLENBQUMsTUFBaEQsQ0FBQTtJQUNBLEtBQUssQ0FBQyxPQUFOLENBQWMsS0FBZCxDQUFvQixNQUFwQixHQUE2QixJQUFJLENBQUMsR0FBTCxHQUFXLE9BQU8sQ0FBQyxNQUFoRCxDQUFBO0dBQ0Q7O0VBQ0QsSUFBSSxLQUFLLENBQUMsSUFBVixFQUFnQjtJQUNkLEtBQUssQ0FBQyxPQUFOLENBQWMsS0FBZCxDQUFvQixJQUFwQixHQUEyQixJQUFJLENBQUMsS0FBTCxHQUFhLE9BQU8sQ0FBQyxLQUFoRCxDQUFBO0lBQ0EsS0FBSyxDQUFDLE9BQU4sQ0FBYyxLQUFkLENBQW9CLElBQXBCLEdBQTJCLElBQUksQ0FBQyxLQUFMLEdBQWEsT0FBTyxDQUFDLEtBQWhELENBQUE7R0FGRixNQUlLLElBQUksS0FBSyxDQUFDLEtBQVYsRUFBaUI7SUFDcEIsS0FBSyxDQUFDLE9BQU4sQ0FBYyxLQUFkLENBQW9CLEtBQXBCLEdBQTRCLElBQUksQ0FBQyxJQUFMLEdBQVksT0FBTyxDQUFDLEtBQWhELENBQUE7SUFDQSxLQUFLLENBQUMsT0FBTixDQUFjLEtBQWQsQ0FBb0IsS0FBcEIsR0FBNEIsSUFBSSxDQUFDLElBQUwsR0FBWSxPQUFPLENBQUMsS0FBaEQsQ0FBQTtHQUNEOztFQUVELFVBQUEsQ0FBQSxhQUFBLENBQWMsR0FBZCxDQUFrQixHQUFsQixDQUFBLENBQUE7O0VBRUEsS0FBSyxDQUFDLE9BQU4sR0FBZ0IsT0FBaEIsQ0FBQTtDQUNEOztBQUVELElBQU0sYUFBNkIsR0FBRztFQUNwQyxHQUFHLEVBQUUsSUFEK0I7RUFFcEMsR0FBRyxFQUFFLElBRitCO0VBR3BDLE9BQU8sRUFBRSxLQUgyQjtFQUlwQyxPQUFPLEVBQUUsS0FBQTtDQUpYLENBQUE7QUFPQSxJQUFNLFlBQVksR0FBRztFQUNuQixLQUFLLEVBQUwsVUFEbUI7RUFFbkIsR0FBRyxFQUFILFFBRm1CO0VBR25CLFFBQVEsRUFBUixhQUFBO0NBSEYsQ0FBQTs7O29CQU1lLENBQUEsQ0FBQSxFQUFBLFNBQUEsQ0FBQSxZQUFBLEVBQWEsWUFBYixFQUEyQixjQUEzQjs7Ozs7Ozs7Ozs7Ozs7QUM5RWYsSUFBQSxVQUFBLEdBQUEsNEJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7QUFDQSxtREFBQTs7Ozs7O0FBNkNBLFNBQVMsVUFBVCxDQUFnQixHQUFoQixFQUE2QztFQUFBLElBQ25DLFdBRG1DLEdBQzhCLEdBRDlCLENBQ25DLFdBRG1DO01BQ3RCLFlBRHNCLEdBQzhCLEdBRDlCLENBQ3RCLFlBRHNCO01BQ1IsT0FEUSxHQUM4QixHQUQ5QixDQUNSLE9BRFE7TUFDQyxJQURELEdBQzhCLEdBRDlCLENBQ0MsSUFERDtNQUNPLEtBRFAsR0FDOEIsR0FEOUIsQ0FDTyxLQURQO01BQ2MsV0FEZCxHQUM4QixHQUQ5QixDQUNjLFdBRGQsQ0FBQTtFQUFBLElBRW5DLE9BRm1DLEdBRXZCLEtBRnVCLENBRW5DLE9BRm1DLENBQUE7RUFHM0MsSUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLGdCQUFSLEdBQ1gsU0FBUyxDQUFDLEdBQUQsQ0FERSxHQUVYO0lBQUUsQ0FBQyxFQUFFLENBQUw7SUFBUSxDQUFDLEVBQUUsQ0FBQTtHQUZmLENBQUE7RUFJQSxJQUFJLFVBQUosQ0FBQTs7RUFFQSxJQUFJLE9BQU8sQ0FBQyxNQUFSLEtBQW1CLGFBQXZCLEVBQXNDO0lBQ3BDLFVBQVUsR0FBRztNQUNYLENBQUMsRUFBRSxXQUFXLENBQUMsTUFBWixDQUFtQixLQUFuQixDQUF5QixJQUF6QixDQUE4QixDQUR0QjtNQUVYLENBQUMsRUFBRSxXQUFXLENBQUMsTUFBWixDQUFtQixLQUFuQixDQUF5QixJQUF6QixDQUE4QixDQUFBO0tBRm5DLENBQUE7R0FERixNQU1NO0lBQ0osSUFBTSxVQUFVLEdBQUcsVUFBSyxDQUFDLElBQU4sQ0FBVyxlQUFYLENBQTJCLE9BQU8sQ0FBQyxNQUFuQyxFQUFrRCxZQUFsRCxFQUFnRSxPQUFoRSxFQUF5RSxDQUFDLFdBQUQsQ0FBekUsQ0FBbkIsQ0FBQTtJQUVBLFVBQVUsR0FBRyxVQUFLLENBQUMsSUFBTixDQUFXLFFBQVgsQ0FBb0IsVUFBcEIsQ0FBQSxJQUFtQztNQUFFLENBQUMsRUFBRSxDQUFMO01BQVEsQ0FBQyxFQUFFLENBQUE7S0FBM0QsQ0FBQTtJQUNBLFVBQVUsQ0FBQyxDQUFYLElBQWdCLE1BQU0sQ0FBQyxDQUF2QixDQUFBO0lBQ0EsVUFBVSxDQUFDLENBQVgsSUFBZ0IsTUFBTSxDQUFDLENBQXZCLENBQUE7R0FDRDs7RUFyQjBDLElBdUJuQyxjQXZCbUMsR0F1QmhCLE9BdkJnQixDQXVCbkMsY0F2Qm1DLENBQUE7RUF5QjNDLEtBQUssQ0FBQyxPQUFOLEdBQWdCLElBQUksSUFBSSxjQUFSLElBQTBCLGNBQWMsQ0FBQyxNQUF6QyxHQUNYLGNBQWMsQ0FBQyxHQUFmLENBQW1CLFVBQUMsYUFBRCxFQUFnQixLQUFoQixFQUFBO0lBQUEsT0FBMkI7TUFDL0MsS0FBSyxFQUFMLEtBRCtDO01BRS9DLGFBQWEsRUFBYixhQUYrQztNQUcvQyxDQUFDLEVBQUUsV0FBVyxDQUFDLElBQVosR0FBb0IsSUFBSSxDQUFDLEtBQUwsR0FBYyxhQUFhLENBQUMsQ0FBaEQsR0FBcUQsVUFBVSxDQUFDLENBSHBCO01BSS9DLENBQUMsRUFBRSxXQUFXLENBQUMsR0FBWixHQUFvQixJQUFJLENBQUMsTUFBTCxHQUFjLGFBQWEsQ0FBQyxDQUFoRCxHQUFxRCxVQUFVLENBQUMsQ0FBQTtLQUovQyxDQUFBO0dBQW5CLENBRFcsR0FPWixDQUFDLFVBQUssQ0FBQyxNQUFOLENBQWE7SUFDZCxLQUFLLEVBQUUsQ0FETztJQUVkLGFBQWEsRUFBRSxJQUFBO0dBRmQsRUFHQSxVQUhBLENBQUQsQ0FQSixDQUFBO0NBV0Q7O0FBRUQsU0FBUyxRQUFULENBQWMsR0FBZCxFQUEyQztFQUFBLElBQ2pDLFdBRGlDLEdBQ0YsR0FERSxDQUNqQyxXQURpQztNQUNwQixNQURvQixHQUNGLEdBREUsQ0FDcEIsTUFEb0I7TUFDWixLQURZLEdBQ0YsR0FERSxDQUNaLEtBRFksQ0FBQTtFQUFBLElBRWpDLE9BRmlDLEdBRVosS0FGWSxDQUVqQyxPQUZpQztNQUV4QixPQUZ3QixHQUVaLEtBRlksQ0FFeEIsT0FGd0IsQ0FBQTtFQUl6QyxJQUFNLE1BQU0sR0FBRyxVQUFLLENBQUMsV0FBTixDQUFrQixXQUFXLENBQUMsWUFBOUIsRUFBNEMsV0FBVyxDQUFDLE9BQXhELEVBQWlFLFdBQVcsQ0FBQyxRQUFaLENBQXFCLElBQXRGLENBQWYsQ0FBQTtFQUNBLElBQU0sSUFBSSxHQUFHLFVBQUssQ0FBQyxNQUFOLENBQWEsRUFBYixFQUFpQixNQUFqQixDQUFiLENBQUE7RUFDQSxJQUFNLE9BQU8sR0FBRyxFQUFoQixDQUFBOztFQUVBLElBQUksQ0FBQyxPQUFPLENBQUMsZ0JBQWIsRUFBK0I7SUFDN0IsSUFBSSxDQUFDLENBQUwsSUFBVSxNQUFNLENBQUMsQ0FBakIsQ0FBQTtJQUNBLElBQUksQ0FBQyxDQUFMLElBQVUsTUFBTSxDQUFDLENBQWpCLENBQUE7R0FDRDs7RUFFRCxLQUFBLElBQUEsRUFBQSxHQUFBLENBQUEsRUFBQSxFQUFBLEdBQXFCLE9BQXJCLENBQUEsTUFBQSxFQUFBLEVBQUEsRUFBQSxFQUE4QjtJQUFBLElBQUEsSUFBQSxDQUFBOztJQUFBLElBQUEsR0FBVCxPQUFTLENBQUEsRUFBQSxDQUFBLENBQUE7SUFBQSxJQUFuQixPQUFtQixHQUFBLElBQUEsQ0FBQTtJQUM1QixJQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsQ0FBTCxHQUFTLE9BQU0sQ0FBQyxDQUFsQyxDQUFBO0lBQ0EsSUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLENBQUwsR0FBUyxPQUFNLENBQUMsQ0FBbEMsQ0FBQTs7SUFFQSxLQUFLLElBQUksTUFBSyxHQUFHLENBQVosRUFBZSxHQUFHLEdBQUcsT0FBTyxDQUFDLE9BQVIsQ0FBZ0IsTUFBMUMsRUFBa0QsTUFBSyxHQUFHLEdBQTFELEVBQStELE1BQUssRUFBcEUsRUFBd0U7TUFDdEUsSUFBTSxVQUFVLEdBQUcsT0FBTyxDQUFDLE9BQVIsQ0FBZ0IsTUFBaEIsQ0FBbkIsQ0FBQTtNQUNBLElBQUksTUFBTSxHQUFBLEtBQUEsQ0FBVixDQUFBOztNQUVBLElBQUksVUFBSyxDQUFDLEVBQU4sQ0FBUyxJQUFULENBQWMsVUFBZCxDQUFKLEVBQStCO1FBQzdCLE1BQU0sR0FBRyxVQUFVLENBQUMsU0FBRCxFQUFZLFNBQVosRUFBdUIsV0FBdkIsRUFBb0MsT0FBcEMsRUFBNEMsTUFBNUMsQ0FBbkIsQ0FBQTtPQURGLE1BR0s7UUFDSCxNQUFNLEdBQUcsVUFBVCxDQUFBO09BQ0Q7O01BRUQsSUFBSSxDQUFDLE1BQUwsRUFBYTtRQUFFLFNBQUE7T0FBVTs7TUFFekIsT0FBTyxDQUFDLElBQVIsQ0FBYTtRQUNYLENBQUMsRUFBRSxDQUFDLFVBQUssQ0FBQyxFQUFOLENBQVMsTUFBVCxDQUFnQixNQUFNLENBQUMsQ0FBdkIsQ0FBQSxHQUE0QixNQUFNLENBQUMsQ0FBbkMsR0FBdUMsU0FBeEMsSUFBcUQsT0FBTSxDQUFDLENBRHBEO1FBRVgsQ0FBQyxFQUFFLENBQUMsVUFBSyxDQUFDLEVBQU4sQ0FBUyxNQUFULENBQWdCLE1BQU0sQ0FBQyxDQUF2QixDQUFBLEdBQTRCLE1BQU0sQ0FBQyxDQUFuQyxHQUF1QyxTQUF4QyxJQUFxRCxPQUFNLENBQUMsQ0FGcEQ7UUFJWCxLQUFLLEVBQUUsVUFBSyxDQUFDLEVBQU4sQ0FBUyxNQUFULENBQWdCLE1BQU0sQ0FBQyxLQUF2QixDQUFBLEdBQWdDLE1BQU0sQ0FBQyxLQUF2QyxHQUErQyxPQUFPLENBQUMsS0FKbkQ7UUFLWCxNQUFNLEVBQUUsVUFMRztRQU1YLEtBQUssRUFBTCxNQU5XO1FBT1gsTUFBTSxFQUFOLE9BQUE7T0FQRixDQUFBLENBQUE7S0FTRDtHQUNGOztFQUVELElBQU0sT0FBTyxHQUFHO0lBQ2QsTUFBTSxFQUFFLElBRE07SUFFZCxPQUFPLEVBQUUsS0FGSztJQUdkLFFBQVEsRUFBRSxDQUhJO0lBSWQsS0FBSyxFQUFFLENBSk87SUFLZCxLQUFLLEVBQUU7TUFBRSxDQUFDLEVBQUUsQ0FBTDtNQUFRLENBQUMsRUFBRSxDQUFBO0tBQVg7R0FMVCxDQUFBOztFQVFBLEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBcUIsT0FBckIsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQThCO0lBQXpCLElBQU0sT0FBTSxHQUFJLE9BQUosQ0FBQSxHQUFBLENBQVosQ0FBQTtJQUNILElBQU0sS0FBSyxHQUFHLE9BQU0sQ0FBQyxLQUFyQixDQUFBO0lBQ0EsSUFBTSxFQUFFLEdBQUcsT0FBTSxDQUFDLENBQVAsR0FBVyxJQUFJLENBQUMsQ0FBM0IsQ0FBQTtJQUNBLElBQU0sRUFBRSxHQUFHLE9BQU0sQ0FBQyxDQUFQLEdBQVcsSUFBSSxDQUFDLENBQTNCLENBQUE7SUFDQSxJQUFNLFFBQVEsR0FBRyxVQUFLLENBQUMsS0FBTixDQUFZLEVBQVosRUFBZ0IsRUFBaEIsQ0FBakIsQ0FBQTtJQUNBLElBQUksT0FBTyxHQUFHLFFBQVEsSUFBSSxLQUExQixDQUw0Qjs7O0lBUzVCLElBQUksS0FBSyxLQUFLLFFBQVYsSUFBc0IsT0FBTyxDQUFDLE9BQTlCLElBQXlDLE9BQU8sQ0FBQyxLQUFSLEtBQWtCLFFBQS9ELEVBQXlFO01BQ3ZFLE9BQU8sR0FBRyxLQUFWLENBQUE7S0FDRDs7SUFFRCxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQVQsS0FBb0IsT0FBTztNQUUxQixPQUFPLENBQUMsT0FBUixJQUFtQixLQUFLLEtBQUssUUFBN0I7TUFFQyxRQUFRLEdBQUcsS0FBWCxHQUFtQixPQUFPLENBQUMsUUFBUixHQUFtQixPQUFPLENBQUMsS0FGL0M7TUFJRSxLQUFLLEtBQUssUUFBVixJQUFzQixPQUFPLENBQUMsS0FBUixLQUFrQixRQUF6QztJQUVBLFFBQVEsR0FBRyxPQUFPLENBQUMsUUFSTTtJQVUxQixDQUFDLE9BQU8sQ0FBQyxPQUFULElBQW9CLFFBQVEsR0FBRyxPQUFPLENBQUMsUUFWeEMsQ0FBSixFQVV3RDtNQUN0RCxPQUFPLENBQUMsTUFBUixHQUFpQixPQUFqQixDQUFBO01BQ0EsT0FBTyxDQUFDLFFBQVIsR0FBbUIsUUFBbkIsQ0FBQTtNQUNBLE9BQU8sQ0FBQyxLQUFSLEdBQWdCLEtBQWhCLENBQUE7TUFDQSxPQUFPLENBQUMsT0FBUixHQUFrQixPQUFsQixDQUFBO01BQ0EsT0FBTyxDQUFDLEtBQVIsQ0FBYyxDQUFkLEdBQWtCLEVBQWxCLENBQUE7TUFDQSxPQUFPLENBQUMsS0FBUixDQUFjLENBQWQsR0FBa0IsRUFBbEIsQ0FBQTtLQUNEO0dBQ0Y7O0VBRUQsSUFBSSxPQUFPLENBQUMsT0FBWixFQUFxQjtJQUNuQixNQUFNLENBQUMsQ0FBUCxHQUFXLE9BQU8sQ0FBQyxNQUFSLENBQWUsQ0FBMUIsQ0FBQTtJQUNBLE1BQU0sQ0FBQyxDQUFQLEdBQVcsT0FBTyxDQUFDLE1BQVIsQ0FBZSxDQUExQixDQUFBO0dBQ0Q7O0VBRUQsS0FBSyxDQUFDLE9BQU4sR0FBZ0IsT0FBaEIsQ0FBQTtFQUNBLE9BQU8sT0FBUCxDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxTQUFULENBQW9CLEdBQXBCLEVBQTBEO0VBQUEsSUFDaEQsT0FEZ0QsR0FDcEMsR0FBRyxDQUFDLFdBRGdDLENBQ2hELE9BRGdELENBQUE7RUFFeEQsSUFBTSxhQUFhLEdBQUcsVUFBSyxDQUFDLElBQU4sQ0FBVyxRQUFYLENBQ3BCLFVBQUssQ0FBQyxJQUFOLENBQVcsZUFBWCxDQUEyQixHQUFHLENBQUMsS0FBSixDQUFVLE9BQVYsQ0FBa0IsTUFBN0MsRUFBNEQsSUFBNUQsRUFBa0UsSUFBbEUsRUFBd0UsQ0FBQyxPQUFELENBQXhFLENBRG9CLENBQXRCLENBQUE7RUFHQSxJQUFNLE1BQU0sR0FBRyxhQUFhLElBQUksVUFBSyxDQUFDLFdBQU4sQ0FDOUIsR0FBRyxDQUFDLFlBRDBCLEVBRTlCLE9BRjhCLEVBRzlCLEdBQUcsQ0FBQyxXQUFKLENBQWdCLFFBQWhCLENBQXlCLElBSEssQ0FBaEMsQ0FBQTtFQU1BLE9BQU8sTUFBUCxDQUFBO0NBQ0Q7O0FBRUQsSUFBTSxhQUFxQixHQUFHO0VBQzVCLEtBQUssRUFBSSxRQURtQjtFQUU1QixPQUFPLEVBQUUsSUFGbUI7RUFHNUIsTUFBTSxFQUFFLElBSG9CO0VBSTVCLGdCQUFnQixFQUFFLElBSlU7RUFLNUIsTUFBTSxFQUFFLElBTG9CO0VBTTVCLGNBQWMsRUFBRSxJQU5ZO0VBTzVCLE9BQU8sRUFBRSxLQVBtQjtFQVE1QixPQUFPLEVBQUUsS0FBQTtDQVJYLENBQUE7QUFVQSxJQUFNLElBQUksR0FBRztFQUNYLEtBQUssRUFBTCxVQURXO0VBRVgsR0FBRyxFQUFILFFBRlc7RUFHWCxRQUFRLEVBQVIsYUFBQTtDQUhGLENBQUE7OztvQkFNZSxDQUFBLENBQUEsRUFBQSxTQUFBLENBQUEsWUFBQSxFQUFhLElBQWIsRUFBbUIsTUFBbkI7Ozs7Ozs7Ozs7Ozs7O0FDM01mLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsNEJBQUEsQ0FBQSxPQUFBLENBQUEsQ0FBQTs7QUFDQSxtREFBQTs7QUFDQSx3REFBQTs7Ozs7Ozs7Ozs7Ozs7OztBQU9BLFNBQVMsVUFBVCxDQUFnQixHQUFoQixFQUE2QztFQUFBLElBQ25DLEtBRG1DLEdBQ2xCLEdBRGtCLENBQ25DLEtBRG1DO01BQzVCLEtBRDRCLEdBQ2xCLEdBRGtCLENBQzVCLEtBRDRCLENBQUE7RUFBQSxJQUVuQyxPQUZtQyxHQUV2QixLQUZ1QixDQUVuQyxPQUZtQyxDQUFBOztFQUkzQyxJQUFJLENBQUMsS0FBTCxFQUFZO0lBQUUsT0FBTyxJQUFQLENBQUE7R0FBYTs7RUFFM0IsR0FBRyxDQUFDLEtBQUosR0FBWTtJQUNWLE9BQU8sRUFBRTtNQUNQLE9BQU8sRUFBRSxJQURGO01BRVAsY0FBYyxFQUFFLENBQUM7UUFDZixDQUFDLEVBQUUsS0FBSyxDQUFDLElBQU4sR0FBYSxDQUFiLEdBQWlCLENBREw7UUFFZixDQUFDLEVBQUUsS0FBSyxDQUFDLEdBQU4sR0FBWSxDQUFaLEdBQWdCLENBQUE7T0FGTCxDQUZUO01BTVAsTUFBTSxFQUFFLE9BQU8sQ0FBQyxNQUFSLElBQWtCLE1BTm5CO01BT1AsTUFBTSxFQUFFO1FBQUUsQ0FBQyxFQUFFLENBQUw7UUFBUSxDQUFDLEVBQUUsQ0FBQTtPQVBaO01BUVAsS0FBSyxFQUFFLE9BQU8sQ0FBQyxLQUFBO0tBUlI7R0FEWCxDQUFBO0VBYUEsS0FBSyxDQUFDLFlBQU4sR0FBcUIsS0FBSyxDQUFDLFlBQU4sSUFBc0IsQ0FDekMsQ0FBQyxPQUFELEVBQVUsUUFBVixDQUR5QyxFQUV6QyxDQUFDLEdBQUQsRUFBTSxHQUFOLENBRnlDLENBQTNDLENBQUE7O0VBS0EsWUFBQSxDQUFBLElBQUEsQ0FBSyxLQUFMLENBQVcsR0FBWCxDQUFBLENBQUE7O0VBQ0EsS0FBSyxDQUFDLE9BQU4sR0FBZ0IsR0FBRyxDQUFDLEtBQUosQ0FBVSxPQUExQixDQUFBO0VBRUEsR0FBRyxDQUFDLEtBQUosR0FBWSxLQUFaLENBQUE7Q0FDRDs7QUFFRCxTQUFTLFFBQVQsQ0FBYyxHQUFkLEVBQW1CO0VBQUEsSUFDVCxXQURTLEdBQ3NCLEdBRHRCLENBQ1QsV0FEUztNQUNJLEtBREosR0FDc0IsR0FEdEIsQ0FDSSxLQURKO01BQ1csTUFEWCxHQUNzQixHQUR0QixDQUNXLE1BRFgsQ0FBQTtFQUFBLElBRVQsT0FGUyxHQUVZLEtBRlosQ0FFVCxPQUZTO01BRUEsT0FGQSxHQUVZLEtBRlosQ0FFQSxPQUZBLENBQUE7RUFHakIsSUFBTSxRQUFRLEdBQUc7SUFDZixDQUFDLEVBQUUsTUFBTSxDQUFDLENBQVAsR0FBVyxPQUFPLENBQUMsQ0FBRCxDQUFQLENBQVcsQ0FEVjtJQUVmLENBQUMsRUFBRSxNQUFNLENBQUMsQ0FBUCxHQUFXLE9BQU8sQ0FBQyxDQUFELENBQVAsQ0FBVyxDQUFBO0dBRjNCLENBQUE7RUFLQSxLQUFLLENBQUMsT0FBTixHQUFnQixDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sRUFBUCxFQUFXLE9BQVgsQ0FBaEIsQ0FBQTtFQUNBLEtBQUssQ0FBQyxPQUFOLENBQWMsT0FBZCxHQUF3QixFQUF4QixDQUFBOztFQUVBLEtBQUEsSUFBQSxFQUFBLEdBQUEsQ0FBQSxFQUFBLEVBQUEsR0FBQSxDQUEwQixPQUFPLENBQUMsT0FBUixJQUFtQixFQUE3QyxFQUFBLE1BQUEsRUFBQSxFQUFBLEVBQUEsRUFBa0Q7SUFBQSxJQUFBLElBQUEsQ0FBQTs7SUFBQSxJQUFBLEdBQUEsQ0FBeEIsT0FBTyxDQUFDLE9BQVIsSUFBbUIsRUFBSyxFQUFBLEVBQUEsQ0FBQSxDQUFBO0lBQUEsSUFBdkMsVUFBdUMsR0FBQSxJQUFBLENBQUE7SUFDaEQsSUFBSSxNQUFNLEdBQUEsS0FBQSxDQUFWLENBQUE7O0lBRUEsSUFBSSxPQUFFLENBQUMsSUFBSCxDQUFRLFVBQVIsQ0FBSixFQUF5QjtNQUN2QixNQUFNLEdBQUcsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFWLEVBQWEsUUFBUSxDQUFDLENBQXRCLEVBQXlCLFdBQXpCLENBQW5CLENBQUE7S0FERixNQUdLO01BQ0gsTUFBTSxHQUFHLFVBQVQsQ0FBQTtLQUNEOztJQUVELElBQUksQ0FBQyxNQUFMLEVBQWE7TUFBRSxTQUFBO0tBQVU7O0lBRXpCLEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBK0IsS0FBSyxDQUFDLFlBQXJDLENBQUEsTUFBQSxFQUFBLEdBQUEsRUFBQSxFQUFtRDtNQUFBLElBQUEsS0FBQSxDQUFBOztNQUFBLEtBQUEsR0FBcEIsS0FBSyxDQUFDLFlBQWMsQ0FBQSxHQUFBLENBQUEsQ0FBQTs7TUFBQSxJQUFBLEtBQUEsR0FBQSxLQUFBO1VBQUEsS0FBQSxHQUFBLG1CQUFBLENBQUEsS0FBQSxFQUFBLENBQUEsQ0FBQTtVQUF2QyxNQUF1QyxHQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7VUFBL0IsTUFBK0IsR0FBQSxLQUFBLENBQUEsQ0FBQSxDQUFBLENBQUE7O01BQ2pELElBQUksTUFBTSxJQUFJLE1BQVYsSUFBb0IsTUFBTSxJQUFJLE1BQWxDLEVBQTBDO1FBQ3hDLE1BQU0sQ0FBQyxDQUFQLEdBQVcsTUFBTSxDQUFDLE1BQUQsQ0FBakIsQ0FBQTtRQUNBLE1BQU0sQ0FBQyxDQUFQLEdBQVcsTUFBTSxDQUFDLE1BQUQsQ0FBakIsQ0FBQTtRQUVBLE1BQUE7T0FDRDtLQUNGOztJQUVELEtBQUssQ0FBQyxPQUFOLENBQWMsT0FBZCxDQUFzQixJQUF0QixDQUEyQixNQUEzQixDQUFBLENBQUE7R0FDRDs7RUFFRCxJQUFNLFdBQVcsR0FBRyxZQUFBLENBQUEsSUFBQSxDQUFLLEdBQUwsQ0FBUyxHQUFULENBQXBCLENBQUE7O0VBRUEsS0FBSyxDQUFDLE9BQU4sR0FBZ0IsT0FBaEIsQ0FBQTtFQUVBLE9BQU8sV0FBUCxDQUFBO0NBQ0Q7O0FBRUQsSUFBTSxhQUF5QixHQUFHO0VBQ2hDLEtBQUssRUFBRSxRQUR5QjtFQUVoQyxPQUFPLEVBQUUsSUFGdUI7RUFHaEMsTUFBTSxFQUFFLElBSHdCO0VBSWhDLE9BQU8sRUFBRSxLQUp1QjtFQUtoQyxPQUFPLEVBQUUsS0FBQTtDQUxYLENBQUE7QUFRQSxJQUFNLFFBQVEsR0FBRztFQUNmLEtBQUssRUFBTCxVQURlO0VBRWYsR0FBRyxFQUFILFFBRmU7RUFHZixRQUFRLEVBQVIsYUFBQTtDQUhGLENBQUE7OztvQkFNZSxDQUFBLENBQUEsRUFBQSxTQUFBLENBQUEsWUFBQSxFQUFhLFFBQWIsRUFBdUIsVUFBdkI7Ozs7Ozs7Ozs7OztBQ3ZFZixJQUFBLFdBQUEsR0FBQSwyQkFBQSxDQUFBLFVBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0FBQ0EsbURBQUE7O0FBRUEsa0RBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFJQSxTQUFTLFVBQVQsQ0FBZ0IsR0FBaEIsRUFBNkM7RUFBQSxJQUNuQyxLQURtQyxHQUN6QixHQUR5QixDQUNuQyxLQURtQyxDQUFBOztFQUczQyxJQUFJLENBQUMsS0FBTCxFQUFZO0lBQUUsT0FBTyxJQUFQLENBQUE7R0FBYTs7RUFFM0IsR0FBRyxDQUFDLEtBQUosQ0FBVSxZQUFWLEdBQXlCLEdBQUcsQ0FBQyxLQUFKLENBQVUsWUFBVixJQUEwQixDQUNqRCxDQUFDLEtBQUssQ0FBQyxJQUFOLEdBQWEsTUFBYixHQUFzQixPQUF2QixFQUFnQyxLQUFLLENBQUMsR0FBTixHQUFZLEtBQVosR0FBb0IsUUFBcEQsQ0FEaUQsQ0FBbkQsQ0FBQTtFQUlBLE9BQU8sU0FBQSxDQUFBLFFBQUEsQ0FBUyxLQUFULENBQWUsR0FBZixDQUFQLENBQUE7Q0FDRDs7QUFFRCxJQUFNLFNBQXNELEdBQUc7RUFDN0QsS0FBSyxFQUFMLFVBRDZEO0VBRTdELEdBQUcsRUFBRSxTQUFBLENBQUEsUUFBQSxDQUFTLEdBRitDO0VBRzdELFFBQVEsRUFBRSxDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQ1IsQ0FBQSxDQUFBLEVBQUEsV0FBQSxDQUFBLFNBQUEsQ0FBQSxFQUFNLFNBQUEsQ0FBQSxRQUFBLENBQVMsUUFBZixDQURRLEVBRVI7SUFDRSxPQUFPLEVBQUUsSUFEWDtJQUVFLEtBQUssRUFBRSxJQUZUO0lBR0UsTUFBTSxFQUFFO01BQUUsQ0FBQyxFQUFFLENBQUw7TUFBUSxDQUFDLEVBQUUsQ0FBQTtLQUFYO0dBTEYsQ0FBQTtDQUhaLENBQUE7OztvQkFhZSxDQUFBLENBQUEsRUFBQSxTQUFBLENBQUEsWUFBQSxFQUFhLFNBQWIsRUFBd0IsV0FBeEI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDN0RmLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsZ0JBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsV0FBQSxHQUFBLDJCQUFBLENBQUEsVUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxhQUFBLEdBQUEsMkJBQUEsQ0FBQSxZQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFVBQUEsR0FBQSwyQkFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsVUFBQSxHQUFBLDJCQUFBLENBQUEsU0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsMkJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFNBQUEsR0FBQSwyQkFBQSxDQUFBLFlBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsTUFBQSxHQUFBLDJCQUFBLENBQUEsU0FBQSxDQUFBLENBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDUEEsU0FBUyxVQUFULENBQXFCLElBQXJCLEVBQTRJO0VBQzFJLElBQU0sV0FBVyxHQUFJLENBQ25CLENBQUMsR0FBRCxFQUFNLEdBQU4sQ0FEbUIsRUFFbkIsQ0FBQyxNQUFELEVBQVMsS0FBVCxDQUZtQixFQUduQixDQUFDLE9BQUQsRUFBVSxRQUFWLENBSG1CLEVBSW5CLENBQUMsT0FBRCxFQUFVLFFBQVYsQ0FKbUIsQ0FBRCxDQUtSLE1BTFEsQ0FLRCxVQUFBLElBQUEsRUFBQTtJQUFBLElBQUEsS0FBQSxHQUFBLG1CQUFBLENBQUEsSUFBQSxFQUFBLENBQUEsQ0FBQTtRQUFFLE1BQUYsR0FBQSxLQUFBLENBQUEsQ0FBQSxDQUFBO1FBQVUsTUFBVixHQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxPQUFzQixNQUFNLElBQUksSUFBVixJQUFrQixNQUFNLElBQUksSUFBbEQsQ0FBQTtHQUxDLENBQXBCLENBQUE7O0VBT0EsSUFBTSxRQUdMLEdBQUcsU0FIRSxRQUdGLENBQUMsQ0FBRCxFQUFJLENBQUosRUFBVTtJQUFBLElBRVYsS0FGVSxHQVVSLElBVlEsQ0FFVixLQUZVO1FBQUEsWUFBQSxHQVVSLElBVlEsQ0FHVixNQUhVO1FBR1YsTUFIVSxHQUFBLFlBQUEsS0FBQSxLQUFBLENBQUEsR0FHRDtNQUNQLElBQUksRUFBSSxDQUFDLFFBREY7TUFFUCxLQUFLLEVBQUksUUFGRjtNQUdQLEdBQUcsRUFBSyxDQUFDLFFBSEY7TUFJUCxNQUFNLEVBQUcsUUFBQTtLQVBELEdBQUEsWUFBQTtRQUFBLFlBQUEsR0FVUixJQVZRLENBU1YsTUFUVTtRQVNWLE1BVFUsR0FBQSxZQUFBLEtBQUEsS0FBQSxDQUFBLEdBU0Q7TUFBRSxDQUFDLEVBQUUsQ0FBTDtNQUFRLENBQUMsRUFBRSxDQUFBO0tBVFYsR0FBQSxZQUFBLENBQUE7SUFZWixJQUFNLE1BRUwsR0FBRztNQUFFLEtBQUssRUFBTCxLQUFGO01BQVMsSUFBSSxFQUFKLElBQVQ7TUFBZSxDQUFDLEVBQUUsSUFBbEI7TUFBa0MsQ0FBQyxFQUFFLElBQUE7S0FGekMsQ0FBQTs7SUFJQSxLQUFBLElBQUEsR0FBQSxHQUFBLENBQUEsRUFBQSxHQUFBLEdBQStCLFdBQS9CLENBQUEsTUFBQSxFQUFBLEdBQUEsRUFBQSxFQUE0QztNQUFBLElBQUEsS0FBQSxDQUFBOztNQUFBLEtBQUEsR0FBYixXQUFhLENBQUEsR0FBQSxDQUFBLENBQUE7O01BQUEsSUFBQSxLQUFBLEdBQUEsS0FBQTtVQUFBLEtBQUEsR0FBQSxtQkFBQSxDQUFBLEtBQUEsRUFBQSxDQUFBLENBQUE7VUFBaEMsTUFBZ0MsR0FBQSxLQUFBLENBQUEsQ0FBQSxDQUFBO1VBQXhCLE1BQXdCLEdBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQSxDQUFBOztNQUMxQyxJQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBTCxDQUFXLENBQUMsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxDQUFaLElBQWtCLElBQUQsQ0FBYyxNQUFkLENBQTVCLENBQWQsQ0FBQTtNQUNBLElBQU0sS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFMLENBQVcsQ0FBQyxDQUFDLEdBQUcsTUFBTSxDQUFDLENBQVosSUFBa0IsSUFBRCxDQUFjLE1BQWQsQ0FBNUIsQ0FBZCxDQUFBO01BRUEsTUFBTSxDQUFDLE1BQUQsQ0FBTixHQUFpQixJQUFJLENBQUMsR0FBTCxDQUFTLE1BQU0sQ0FBQyxJQUFoQixFQUFzQixJQUFJLENBQUMsR0FBTCxDQUFTLE1BQU0sQ0FBQyxLQUFoQixFQUF1QixLQUFLLEdBQUksSUFBRCxDQUFjLE1BQWQsQ0FBUixHQUFnQyxNQUFNLENBQUMsQ0FBOUQsQ0FBdEIsQ0FBakIsQ0FBQTtNQUNBLE1BQU0sQ0FBQyxNQUFELENBQU4sR0FBaUIsSUFBSSxDQUFDLEdBQUwsQ0FBUyxNQUFNLENBQUMsR0FBaEIsRUFBcUIsSUFBSSxDQUFDLEdBQUwsQ0FBUyxNQUFNLENBQUMsTUFBaEIsRUFBd0IsS0FBSyxHQUFJLElBQUQsQ0FBYyxNQUFkLENBQVIsR0FBZ0MsTUFBTSxDQUFDLENBQS9ELENBQXJCLENBQWpCLENBQUE7S0FDRDs7SUFFRCxPQUFPLE1BQVAsQ0FBQTtHQTNCRixDQUFBOztFQThCQSxRQUFRLENBQUMsSUFBVCxHQUFnQixJQUFoQixDQUFBO0VBQ0EsUUFBUSxDQUFDLFdBQVQsR0FBdUIsV0FBdkIsQ0FBQTtFQUVBLE9BQU8sUUFBUCxDQUFBO0NBQ0Q7O29CQUVjOzs7Ozs7Ozs7Ozs7Ozs7O0FDNUNmLElBQUEsS0FBQSxHQUFBLDJCQUFBLENBQUEsU0FBQSxDQUFBLENBQUE7Ozs7Ozs7Ozs7Ozs7O0FDQUEsSUFBQSxVQUFBLEdBQUEsMkJBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBQTs7QUFFQSxJQUFBLEdBQUEsR0FBQSw0QkFBQSxDQUFBLFFBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxRQUFBLEdBQUEsNEJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7QUFVQSxJQUFNLGNBQTBCLEdBQUc7RUFDakMsRUFBRSxFQUFFLFdBRDZCO0VBRWpDLE9BRmlDLEVBQUEsU0FBQSxPQUFBLENBRXhCLEtBRndCLEVBRWpCO0lBQUEsSUFDTixRQURNLEdBQ08sS0FEUCxDQUNOLFFBRE0sQ0FBQTtJQUdkLEtBQUssQ0FBQyxTQUFOLENBQWdCLFVBQUEsQ0FBQSxTQUFBLENBQWhCLENBQUEsQ0FBQTtJQUVBLFFBQVEsQ0FBQyxTQUFULEdBQXFCLENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxRQUFRLENBQUMsU0FBVCxJQUFzQixFQUE3QixFQUFpQyxHQUFqQyxDQUFyQixDQUFBO0lBQ0EsUUFBUSxDQUFDLFFBQVQsR0FBb0IsQ0FBQSxDQUFBLEVBQUEsWUFBQSxDQUFBLFNBQUEsQ0FBQSxFQUFPLFFBQVEsQ0FBQyxRQUFULElBQXFCLEVBQTVCLEVBQWdDLFFBQWhDLENBQXBCLENBQUE7SUFDQSxRQUFRLENBQUMsY0FBVCxHQUEwQixRQUFRLENBQUMsUUFBVCxDQUFrQixJQUE1QyxDQVBjOztJQVVkLEtBQUssSUFBTSxJQUFYLElBQW1CLEdBQW5CLEVBQXdCO01BQUEsSUFBQSxJQUFBLEdBQ1UsR0FBRyxDQUFDLElBQUQsQ0FEYjtVQUNkLFNBRGMsR0FBQSxJQUFBLENBQ2QsU0FEYztVQUNILFFBREcsR0FBQSxJQUFBLENBQ0gsUUFERyxDQUFBO01BR3BCLFNBQUQsQ0FBbUIsUUFBbkIsR0FBOEIsUUFBOUIsQ0FBQTtNQUNDLEtBQUssQ0FBQyxRQUFOLENBQWUsU0FBaEIsQ0FBa0MsSUFBbEMsQ0FBQSxHQUEwQyxTQUExQyxDQUFBO0tBQ0Y7R0FDRjtDQWxCSCxDQUFBO29CQXFCZTs7Ozs7Ozs7Ozs7QUNuQ2YsSUFBQSxnQkFBQSxHQUFBLDJCQUFBLENBQUEsY0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxpQkFBQSxHQUFBLDRCQUFBLENBQUEsaUJBQUEsQ0FBQSxDQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0lBRXFCOzs7O0VBZW5CLFNBQUEsWUFBQSxDQUNFLElBREYsRUFFRSxPQUZGLEVBR0UsS0FIRixFQUlFLFdBSkYsRUFLRSxXQUxGLEVBTUUsU0FORixFQU9FO0lBQUEsSUFBQSxLQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSxJQUFBLEVBQUEsWUFBQSxDQUFBLENBQUE7O0lBQ0EsS0FBQSxHQUFBLCtCQUFBLENBQUEsSUFBQSxFQUFBLG9CQUFBLENBQUEsWUFBQSxDQUFBLENBQUEsSUFBQSxDQUFBLElBQUEsRUFBTSxXQUFOLENBQUEsQ0FBQSxDQUFBOztJQURBLG9CQUFBLENBQUEsMkJBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxNQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLDJCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsZUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSwyQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLFdBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsMkJBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxhQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLDJCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsUUFBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSwyQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLE9BQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsMkJBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxPQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLDJCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsU0FBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBQUEsb0JBQUEsQ0FBQSwyQkFBQSxDQUFBLEtBQUEsQ0FBQSxFQUFBLFNBQUEsRUFBQSxLQUFBLENBQUEsQ0FBQSxDQUFBOztJQUFBLG9CQUFBLENBQUEsMkJBQUEsQ0FBQSxLQUFBLENBQUEsRUFBQSxJQUFBLEVBQUEsS0FBQSxDQUFBLENBQUEsQ0FBQTs7SUFBQSxvQkFBQSxDQUFBLDJCQUFBLENBQUEsS0FBQSxDQUFBLEVBQUEsV0FBQSxFQUFBLEtBQUEsQ0FBQSxDQUFBLENBQUE7O0lBRUEsaUJBQVksQ0FBQyxhQUFiLENBQUEsMkJBQUEsQ0FBQSxLQUFBLENBQUEsRUFBaUMsS0FBakMsQ0FBQSxDQUFBOztJQUVBLElBQUksS0FBSyxLQUFLLE9BQWQsRUFBdUI7TUFDckIsaUJBQVksQ0FBQyxhQUFiLENBQUEsMkJBQUEsQ0FBQSxLQUFBLENBQUEsRUFBaUMsT0FBakMsQ0FBQSxDQUFBO0tBQ0Q7O0lBRUQsS0FBQSxDQUFLLFNBQUwsR0FBcUIsU0FBckIsQ0FBQTtJQUNBLEtBQUEsQ0FBSyxhQUFMLEdBQXFCLEtBQXJCLENBQUE7SUFDQSxLQUFBLENBQUssSUFBTCxHQUFxQixJQUFyQixDQUFBO0lBQ0EsS0FBQSxDQUFLLFNBQUwsR0FBcUIsaUJBQVksQ0FBQyxZQUFiLENBQTBCLE9BQTFCLENBQXJCLENBQUE7SUFDQSxLQUFBLENBQUssV0FBTCxHQUFxQixpQkFBWSxDQUFDLGNBQWIsQ0FBNEIsT0FBNUIsQ0FBckIsQ0FBQTtJQUNBLEtBQUEsQ0FBSyxNQUFMLEdBQXFCLFdBQXJCLENBQUE7SUFDQSxLQUFBLENBQUssYUFBTCxHQUFxQixJQUFyQixDQUFBOztJQUVBLElBQUksSUFBSSxLQUFLLEtBQWIsRUFBb0I7TUFDbEIsSUFBTSxZQUFZLEdBQUcsV0FBVyxDQUFDLGVBQVosQ0FBNEIsT0FBNUIsQ0FBckIsQ0FBQTtNQUNBLEtBQUEsQ0FBSyxFQUFMLEdBQVUsS0FBQSxDQUFLLFNBQUwsR0FBaUIsV0FBVyxDQUFDLFFBQVosQ0FBcUIsWUFBckIsQ0FBQSxDQUFtQyxRQUE5RCxDQUFBO01BRUEsSUFBTSxRQUFRLEdBQUcsS0FBQSxDQUFLLFNBQUwsR0FBaUIsV0FBVyxDQUFDLE9BQTlDLENBQUE7TUFFQSxLQUFBLENBQUEsUUFBQSxDQUFBLEdBQWMsQ0FBQyxFQUFFLFdBQVcsQ0FBQyxPQUFaLElBQ2YsV0FBVyxDQUFDLE9BQVosQ0FBb0IsSUFBcEIsS0FBNkIsV0FEZCxJQUVmLFdBQVcsQ0FBQyxPQUFaLENBQW9CLE1BQXBCLEtBQStCLEtBQUEsQ0FBSyxNQUZyQixJQUdmLFFBQVEsR0FBRyxHQUhFLENBQWYsQ0FBQTtLQU5GLE1BV0ssSUFBSSxJQUFJLEtBQUssV0FBYixFQUEwQjtNQUM3QixLQUFBLENBQUssRUFBTCxHQUFXLE9BQUQsQ0FBaUMsU0FBakMsR0FBNkMsV0FBVyxDQUFDLE9BQW5FLENBQUE7S0FDRDs7SUE3QkQsT0FBQSxLQUFBLENBQUE7R0E4QkQ7Ozs7MENBRTREO01BQUEsSUFBdkMsT0FBdUMsR0FBQSxJQUFBLENBQTFDLENBQTBDO1VBQTNCLE9BQTJCLEdBQUEsSUFBQSxDQUE5QixDQUE4QixDQUFBO01BQzNELElBQUEsQ0FBSyxLQUFMLElBQWdCLE9BQWhCLENBQUE7TUFDQSxJQUFBLENBQUssS0FBTCxJQUFnQixPQUFoQixDQUFBO01BQ0EsSUFBQSxDQUFLLE9BQUwsSUFBZ0IsT0FBaEIsQ0FBQTtNQUNBLElBQUEsQ0FBSyxPQUFMLElBQWdCLE9BQWhCLENBQUE7TUFFQSxPQUFPLElBQVAsQ0FBQTtLQUNEOzs7c0NBRXVEO01BQUEsSUFBdkMsT0FBdUMsR0FBQSxLQUFBLENBQTFDLENBQTBDO1VBQTNCLE9BQTJCLEdBQUEsS0FBQSxDQUE5QixDQUE4QixDQUFBO01BQ3RELElBQUEsQ0FBSyxLQUFMLElBQWdCLE9BQWhCLENBQUE7TUFDQSxJQUFBLENBQUssS0FBTCxJQUFnQixPQUFoQixDQUFBO01BQ0EsSUFBQSxDQUFLLE9BQUwsSUFBZ0IsT0FBaEIsQ0FBQTtNQUNBLElBQUEsQ0FBSyxPQUFMLElBQWdCLE9BQWhCLENBQUE7TUFFQSxPQUFPLElBQVAsQ0FBQTtLQUNEOzs7Ozs7O3FDQUtpQjtNQUNoQixJQUFBLENBQUssYUFBTCxDQUFtQixjQUFuQixFQUFBLENBQUE7S0FDRDs7OztFQTdFK0QsZ0JBQUEsQ0FBQSxTQUFBOzs7Ozs7Ozs7Ozs7OztBQ0RsRSxJQUFBLGlCQUFBLEdBQUEsMkJBQUEsQ0FBQSxnQkFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxXQUFBLEdBQUEsY0FBQSxDQUFBOztBQUNBLElBQUEsVUFBQSxHQUFBLDRCQUFBLENBQUEsVUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxhQUFBLEdBQUEsMkJBQUEsQ0FBQSxpQkFBQSxDQUFBLENBQUE7Ozs7Ozs7O0FBcUVBLElBQU0sYUFBNkIsR0FBRztFQUNwQyxZQUFZLEVBQUUsR0FEc0I7RUFFcEMsVUFBVSxFQUFJLElBRnNCO0VBR3BDLFNBQVMsRUFBSyxJQUhzQjtFQUlwQyxNQUFNLEVBQVE7SUFBRSxDQUFDLEVBQUUsQ0FBTDtJQUFRLENBQUMsRUFBRSxDQUFBO0dBQVg7Q0FKaEIsQ0FBQTtBQU9BLElBQU0sYUFBYSxHQUFHO0VBQ3BCLEVBQUUsRUFBRSxxQkFEZ0I7RUFFcEIsT0FBTyxFQUFQLFlBRm9CO0VBR3BCLFNBQVMsRUFBRTtJQUNULGtCQUFBLEVBQW9CLG1CQURYO0lBRVQsNkJBQUEsRUFBK0IsV0FGdEI7SUFHVCxtQkFBQSxFQUFxQixnQkFIWjtJQUlULG1CQUFBLEVBQXFCLFNBQUEsZ0JBQUEsQ0FBQyxHQUFELEVBQU0sS0FBTixFQUFnQjtNQUNuQyxnQkFBZ0IsQ0FBQyxHQUFELEVBQU0sS0FBTixDQUFoQixDQUFBO01BQ0EsSUFBSSxDQUFDLEdBQUQsRUFBTSxLQUFOLENBQUosQ0FBQTtLQU5PO0lBUVQsaUJBQUEsRUFBbUIsU0FBQSxjQUFBLENBQUMsR0FBRCxFQUFNLEtBQU4sRUFBZ0I7TUFDakMsU0FBUyxDQUFDLEdBQUQsQ0FBVCxDQUFBO01BQ0EsSUFBSSxDQUFDLEdBQUQsRUFBTSxLQUFOLENBQUosQ0FBQTtNQUNBLFVBQVUsQ0FBQyxHQUFELEVBQU0sS0FBTixDQUFWLENBQUE7S0FYTztJQWFULHFCQUFBLEVBQXVCLFNBQUEsa0JBQUEsQ0FBQyxHQUFELEVBQU0sS0FBTixFQUFnQjtNQUNyQyxTQUFTLENBQUMsR0FBRCxDQUFULENBQUE7TUFDQSxJQUFJLENBQUMsR0FBRCxFQUFNLEtBQU4sQ0FBSixDQUFBO0tBQ0Q7R0FuQmlCO0VBcUJwQixZQUFZLEVBQVosYUFBQSxDQUFBLFNBQUEsQ0FyQm9CO0VBc0JwQixJQUFJLEVBQUosSUF0Qm9CO0VBdUJwQixtQkFBbUIsRUFBbkIsbUJBdkJvQjtFQXdCcEIsUUFBUSxFQUFSLGFBeEJvQjtFQXlCcEIsS0FBSyxFQUFFO0lBQ0wsSUFBSSxFQUFFLElBREQ7SUFFTCxJQUFJLEVBQUUsSUFGRDtJQUdMLEVBQUUsRUFBRSxJQUhDO0lBSUwsTUFBTSxFQUFFLElBSkg7SUFLTCxHQUFHLEVBQUUsSUFMQTtJQU1MLFNBQVMsRUFBRSxJQU5OO0lBT0wsSUFBSSxFQUFFLElBQUE7R0FQRDtDQXpCVCxDQUFBOztBQW9DQSxTQUFTLElBQVQsQ0FDRSxHQURGLEVBU0UsS0FURixFQVVFO0VBQUEsSUFFRSxXQUZGLEdBUUksR0FSSixDQUVFLFdBRkY7TUFHRSxPQUhGLEdBUUksR0FSSixDQUdFLE9BSEY7TUFJRSxLQUpGLEdBUUksR0FSSixDQUlFLEtBSkY7TUFLRSxXQUxGLEdBUUksR0FSSixDQUtFLFdBTEY7TUFNRSxJQU5GLEdBUUksR0FSSixDQU1FLElBTkY7TUFBQSxZQUFBLEdBUUksR0FSSixDQU9FLE9BUEY7TUFPRSxPQVBGLEdBQUEsWUFBQSxLQUFBLEtBQUEsQ0FBQSxHQU9ZLG1CQUFtQixDQUFDLEdBQUQsRUFBTSxLQUFOLENBUC9CLEdBQUEsWUFBQSxDQUFBO0VBVUEsSUFBTSxZQUFZLEdBQUcsSUFBSSxhQUFBLENBQUEsU0FBQSxDQUFKLENBQWlCLElBQWpCLEVBQXVCLE9BQXZCLEVBQWdDLEtBQWhDLEVBQXVDLFdBQXZDLEVBQW9ELFdBQXBELEVBQWlFLEtBQUssQ0FBQyxHQUFOLEVBQWpFLENBQXJCLENBQUE7RUFFQSxLQUFLLENBQUMsSUFBTixDQUFXLG1CQUFYLEVBQWdDO0lBQUUsWUFBWSxFQUFaLFlBQUE7R0FBbEMsQ0FBQSxDQUFBO0VBRUEsSUFBTSxTQUFTLEdBQUc7SUFDaEIsV0FBVyxFQUFYLFdBRGdCO0lBRWhCLE9BQU8sRUFBUCxPQUZnQjtJQUdoQixLQUFLLEVBQUwsS0FIZ0I7SUFJaEIsV0FBVyxFQUFYLFdBSmdCO0lBS2hCLE9BQU8sRUFBUCxPQUxnQjtJQU1oQixJQUFJLEVBQUosSUFOZ0I7SUFPaEIsWUFBWSxFQUFaLFlBQUE7R0FQRixDQUFBOztFQVVBLEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBYixFQUFnQixDQUFDLEdBQUcsT0FBTyxDQUFDLE1BQTVCLEVBQW9DLENBQUMsRUFBckMsRUFBeUM7SUFDdkMsSUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLENBQUQsQ0FBdEIsQ0FBQTs7SUFFQSxLQUFLLElBQU0sSUFBWCxJQUFtQixNQUFNLENBQUMsS0FBUCxJQUFnQixFQUFuQyxFQUF1QztNQUNwQyxZQUFELENBQXNCLElBQXRCLENBQUEsR0FBOEIsTUFBTSxDQUFDLEtBQVAsQ0FBYSxJQUFiLENBQTlCLENBQUE7S0FDRDs7SUFFRCxJQUFNLE1BQU0sR0FBRyxVQUFLLENBQUMsV0FBTixDQUFrQixNQUFNLENBQUMsU0FBekIsRUFBb0MsTUFBTSxDQUFDLElBQTNDLENBQWYsQ0FBQTs7SUFFQSxZQUFZLENBQUMsZUFBYixDQUE2QixNQUE3QixDQUFBLENBQUE7O0lBQ0EsWUFBWSxDQUFDLFNBQWIsR0FBeUIsTUFBTSxDQUFDLFNBQWhDLENBQUE7SUFDQSxZQUFZLENBQUMsYUFBYixHQUE2QixNQUFNLENBQUMsSUFBcEMsQ0FBQTtJQUVBLE1BQU0sQ0FBQyxTQUFQLENBQWlCLElBQWpCLENBQXNCLFlBQXRCLENBQUEsQ0FBQTs7SUFFQSxZQUFZLENBQUMsVUFBYixDQUF3QixNQUF4QixDQUFBLENBQUE7O0lBRUEsSUFBSSxZQUFZLENBQUMsMkJBQWIsSUFDQyxZQUFZLENBQUMsa0JBQWIsSUFDSSxDQUFDLEdBQUcsQ0FBTCxHQUFVLE9BQU8sQ0FBQyxNQURyQixJQUMrQixPQUFPLENBQUMsQ0FBQyxHQUFHLENBQUwsQ0FBUCxDQUFlLElBQWYsS0FBd0IsWUFBWSxDQUFDLGFBRnpFLEVBRXlGO01BQ3ZGLE1BQUE7S0FDRDtHQUNGOztFQUVELEtBQUssQ0FBQyxJQUFOLENBQVcscUJBQVgsRUFBa0MsU0FBbEMsQ0FBQSxDQUFBOztFQUVBLElBQUksSUFBSSxLQUFLLEtBQWIsRUFBb0I7OztJQUdsQixJQUFNLE9BQU8sR0FBRyxZQUFZLENBQUEsUUFBQSxDQUFaLEdBQ1osSUFBSSxDQUFDO01BQ0wsV0FBVyxFQUFYLFdBREs7TUFFTCxPQUFPLEVBQVAsT0FGSztNQUdMLEtBQUssRUFBTCxLQUhLO01BSUwsV0FBVyxFQUFYLFdBSks7TUFLTCxJQUFJLEVBQUUsV0FBQTtLQUxGLEVBTUgsS0FORyxDQURRLEdBUVosWUFSSixDQUFBO0lBVUEsV0FBVyxDQUFDLE9BQVosR0FBc0IsT0FBdEIsQ0FBQTtJQUNBLFdBQVcsQ0FBQyxPQUFaLEdBQXNCLE9BQU8sQ0FBQyxTQUE5QixDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxZQUFQLENBQUE7Q0FDRDs7QUFFRCxTQUFTLG1CQUFULENBQUEsSUFBQSxFQU1HLEtBTkgsRUFNMEI7RUFBQSxJQU53QixXQU14QixHQUFBLElBQUEsQ0FOd0IsV0FNeEI7TUFOcUMsT0FNckMsR0FBQSxJQUFBLENBTnFDLE9BTXJDO01BTjhDLEtBTTlDLEdBQUEsSUFBQSxDQU44QyxLQU05QztNQU5xRCxXQU1yRCxHQUFBLElBQUEsQ0FOcUQsV0FNckQ7TUFOa0UsSUFNbEUsR0FBQSxJQUFBLENBTmtFLElBTWxFLENBQUE7RUFDeEIsSUFBTSxZQUFZLEdBQUcsV0FBVyxDQUFDLGVBQVosQ0FBNEIsT0FBNUIsQ0FBckIsQ0FBQTtFQUNBLElBQU0sV0FBVyxHQUFHLFdBQVcsQ0FBQyxRQUFaLENBQXFCLFlBQXJCLENBQXBCLENBRndCOztFQUt4QixJQUFJLElBQUksS0FBSyxLQUFULEtBQW1CLFdBQVcsQ0FBQyxlQUFaO0VBRW5CLEVBQUUsV0FBVyxJQUFJLFdBQVcsQ0FBQyxVQUFaLEtBQTJCLFdBQTVDLENBRkEsQ0FBSixFQUUrRDtJQUM3RCxPQUFPLEVBQVAsQ0FBQTtHQUNEOztFQUVELElBQU0sSUFBSSxHQUFHLFVBQUssQ0FBQyxHQUFOLENBQVUsT0FBVixDQUFrQixXQUFsQixDQUFiLENBQUE7RUFDQSxJQUFNLFNBQVMsR0FBRztJQUNoQixXQUFXLEVBQVgsV0FEZ0I7SUFFaEIsT0FBTyxFQUFQLE9BRmdCO0lBR2hCLEtBQUssRUFBTCxLQUhnQjtJQUloQixXQUFXLEVBQVgsV0FKZ0I7SUFLaEIsSUFBSSxFQUFKLElBTGdCO0lBTWhCLElBQUksRUFBSixJQU5nQjtJQU9oQixPQUFPLEVBQUUsRUFQTztJQVFoQixJQUFJLEVBQUUsSUFBQTtHQVJSLENBQUE7O0VBV0EsS0FBQSxJQUFBLEVBQUEsR0FBQSxDQUFBLEVBQUEsRUFBQSxHQUFtQixJQUFuQixDQUFBLE1BQUEsRUFBQSxFQUFBLEVBQUEsRUFBeUI7SUFBQSxJQUFBLEtBQUEsQ0FBQTs7SUFBQSxLQUFBLEdBQU4sSUFBTSxDQUFBLEVBQUEsQ0FBQSxDQUFBO0lBQUEsSUFBZCxJQUFjLEdBQUEsS0FBQSxDQUFBO0lBQ3ZCLFNBQVMsQ0FBQyxJQUFWLEdBQWlCLElBQWpCLENBQUE7SUFFQSxLQUFLLENBQUMsSUFBTixDQUFXLCtCQUFYLEVBQTRDLFNBQTVDLENBQUEsQ0FBQTtHQUNEOztFQUVELElBQUksSUFBSSxLQUFLLE1BQWIsRUFBcUI7SUFDbkIsU0FBUyxDQUFDLE9BQVYsR0FBb0IsU0FBUyxDQUFDLE9BQVYsQ0FBa0IsTUFBbEIsQ0FBeUIsVUFBQSxNQUFNLEVBQUE7TUFBQSxPQUNqRCxNQUFNLENBQUMsU0FBUCxDQUFpQixPQUFqQixDQUF5QixZQUF6QixLQUEwQyxXQUFXLENBQUMsUUFBWixDQUFxQixZQUFyQixDQUFBLENBQW1DLElBQW5DLENBQXdDLFFBRGpDLENBQUE7S0FBL0IsQ0FBcEIsQ0FBQTtHQUVEOztFQUVELE9BQU8sU0FBUyxDQUFDLE9BQWpCLENBQUE7Q0FDRDs7QUFFRCxTQUFTLG1CQUFULENBQUEsS0FBQSxFQUErQztFQUFBLElBQWYsV0FBZSxHQUFBLEtBQUEsQ0FBZixXQUFlLENBQUE7RUFDN0MsV0FBVyxDQUFDLE9BQVosR0FBc0IsSUFBdEIsQ0FENkM7O0VBRTdDLFdBQVcsQ0FBQyxPQUFaLEdBQXNCLENBQXRCLENBRjZDO0NBRzlDOztBQUVELFNBQVMsV0FBVCxDQUFBLEtBQUEsRUFBaUc7RUFBQSxJQUF6RSxJQUF5RSxHQUFBLEtBQUEsQ0FBekUsSUFBeUU7TUFBbkUsV0FBbUUsR0FBQSxLQUFBLENBQW5FLFdBQW1FLENBQUE7O0VBQy9GLElBQUksQ0FBQyxJQUFELElBQVMsV0FBVyxDQUFDLElBQXpCLEVBQStCO0lBQzdCLE9BQUE7R0FDRDs7RUFFRCxXQUFXLENBQUMsSUFBWixHQUFtQjtJQUFFLFFBQVEsRUFBRSxRQUFaO0lBQXNCLE9BQU8sRUFBRSxJQUFBO0dBQWxELENBQUE7Q0FDRDs7QUFFRCxTQUFTLFNBQVQsQ0FBQSxLQUFBLEVBQW1EO0VBQUEsSUFBN0IsV0FBNkIsR0FBQSxLQUFBLENBQTdCLFdBQTZCO01BQWhCLFlBQWdCLEdBQUEsS0FBQSxDQUFoQixZQUFnQixDQUFBOztFQUNqRCxJQUFJLFdBQVcsQ0FBQyxRQUFaLENBQXFCLFlBQXJCLENBQUEsQ0FBbUMsSUFBdkMsRUFBNkM7SUFDM0MsWUFBWSxDQUFDLFdBQVcsQ0FBQyxRQUFaLENBQXFCLFlBQXJCLENBQUEsQ0FBbUMsSUFBbkMsQ0FBd0MsT0FBekMsQ0FBWixDQUFBO0dBQ0Q7Q0FDRjs7QUFFRCxTQUFTLGdCQUFULENBQUEsS0FBQSxFQUVFLEtBRkYsRUFHRTtFQUFBLElBRkUsV0FFRixHQUFBLEtBQUEsQ0FGRSxXQUVGO01BRmUsT0FFZixHQUFBLEtBQUEsQ0FGZSxPQUVmO01BRndCLEtBRXhCLEdBQUEsS0FBQSxDQUZ3QixLQUV4QjtNQUYrQixXQUUvQixHQUFBLEtBQUEsQ0FGK0IsV0FFL0I7TUFGNEMsU0FFNUMsR0FBQSxLQUFBLENBRjRDLFNBRTVDLENBQUE7RUFDQSxJQUFNLFlBQVksR0FBRyxXQUFXLENBQUMsZUFBWixDQUE0QixPQUE1QixDQUFyQixDQUFBOztFQUVBLElBQUksQ0FBQyxTQUFELEtBQWUsQ0FBQyxXQUFXLENBQUMsYUFBYixJQUE4QixXQUFXLENBQUMsZUFBekQsQ0FBSixFQUErRTtJQUM3RSxJQUFJLFdBQVcsQ0FBQyxhQUFoQixFQUErQjtNQUM3QixZQUFZLENBQUMsV0FBVyxDQUFDLFFBQVosQ0FBcUIsWUFBckIsQ0FBQSxDQUFtQyxJQUFuQyxDQUF3QyxPQUF6QyxDQUFaLENBQUE7S0FDRDs7SUFFRCxJQUFJLENBQUM7TUFDSCxXQUFXLEVBQVgsV0FERztNQUVILE9BQU8sRUFBUCxPQUZHO01BR0gsS0FBSyxFQUFMLEtBSEc7TUFJSCxXQUFXLEVBQUUsV0FKVjtNQUtILElBQUksRUFBRSxNQUFBO0tBTEosRUFNRCxLQU5DLENBQUosQ0FBQTtHQU9EO0NBQ0Y7O0FBRUQsU0FBUyxnQkFBVCxDQUFBLEtBQUEsRUFBaUksS0FBakksRUFBd0o7RUFBQSxJQUEzSCxXQUEySCxHQUFBLEtBQUEsQ0FBM0gsV0FBMkg7TUFBOUcsT0FBOEcsR0FBQSxLQUFBLENBQTlHLE9BQThHO01BQXJHLEtBQXFHLEdBQUEsS0FBQSxDQUFyRyxLQUFxRztNQUE5RixXQUE4RixHQUFBLEtBQUEsQ0FBOUYsV0FBOEY7TUFBakYsWUFBaUYsR0FBQSxLQUFBLENBQWpGLFlBQWlGLENBQUE7RUFDdEosSUFBTSxLQUFLLEdBQUcsV0FBVyxDQUFDLFFBQVosQ0FBcUIsWUFBckIsQ0FBQSxDQUFtQyxJQUFqRCxDQUFBO0VBQ0EsSUFBTSxJQUFJLEdBQUcsVUFBSyxDQUFDLEdBQU4sQ0FBVSxPQUFWLENBQWtCLFdBQWxCLENBQWIsQ0FBQTtFQUNBLElBQU0sU0FBUyxHQUFHO0lBQ2hCLFdBQVcsRUFBWCxXQURnQjtJQUVoQixPQUFPLEVBQVAsT0FGZ0I7SUFHaEIsS0FBSyxFQUFMLEtBSGdCO0lBSWhCLFdBQVcsRUFBWCxXQUpnQjtJQUtoQixJQUFJLEVBQUUsTUFMVTtJQU1oQixPQUFPLEVBQUUsRUFOTztJQU9oQixJQUFJLEVBQUosSUFQZ0I7SUFRaEIsSUFBSSxFQUFFLElBQUE7R0FSUixDQUFBOztFQVdBLEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBbUIsSUFBbkIsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQXlCO0lBQUEsSUFBQSxLQUFBLENBQUE7O0lBQUEsS0FBQSxHQUFOLElBQU0sQ0FBQSxHQUFBLENBQUEsQ0FBQTtJQUFBLElBQWQsSUFBYyxHQUFBLEtBQUEsQ0FBQTtJQUN2QixTQUFTLENBQUMsSUFBVixHQUFpQixJQUFqQixDQUFBO0lBRUEsS0FBSyxDQUFDLElBQU4sQ0FBVywrQkFBWCxFQUE0QyxTQUE1QyxDQUFBLENBQUE7R0FDRDs7RUFFRCxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQVYsQ0FBa0IsTUFBdkIsRUFBK0I7SUFBRSxPQUFBO0dBQVE7O0VBRXpDLElBQUksV0FBVyxHQUFHLFFBQWxCLENBQUE7O0VBRUEsS0FBQSxJQUFBLEdBQUEsR0FBQSxDQUFBLEVBQUEsR0FBQSxHQUFxQixTQUFTLENBQUMsT0FBL0IsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQXdDO0lBQUEsSUFBQSxLQUFBLENBQUE7O0lBQUEsS0FBQSxHQUFuQixTQUFTLENBQUMsT0FBUyxDQUFBLEdBQUEsQ0FBQSxDQUFBO0lBQUEsSUFBN0IsTUFBNkIsR0FBQSxLQUFBLENBQUE7SUFDdEMsSUFBTSxZQUFZLEdBQUcsTUFBTSxDQUFDLFNBQVAsQ0FBaUIsT0FBakIsQ0FBeUIsWUFBOUMsQ0FBQTs7SUFFQSxJQUFJLFlBQVksR0FBRyxXQUFuQixFQUFnQztNQUM5QixXQUFXLEdBQUcsWUFBZCxDQUFBO0tBQ0Q7R0FDRjs7RUFFRCxLQUFLLENBQUMsUUFBTixHQUFpQixXQUFqQixDQUFBO0VBQ0EsS0FBSyxDQUFDLE9BQU4sR0FBZ0IsVUFBVSxDQUFDLFlBQU07SUFDL0IsSUFBSSxDQUFDO01BQ0gsV0FBVyxFQUFYLFdBREc7TUFFSCxXQUFXLEVBQVgsV0FGRztNQUdILE9BQU8sRUFBUCxPQUhHO01BSUgsS0FBSyxFQUFMLEtBSkc7TUFLSCxJQUFJLEVBQUUsTUFBQTtLQUxKLEVBTUQsS0FOQyxDQUFKLENBQUE7R0FEd0IsRUFRdkIsV0FSdUIsQ0FBMUIsQ0FBQTtDQVNEOztBQUVELFNBQVMsVUFBVCxDQUFBLE1BQUEsRUFBMkcsS0FBM0csRUFBa0k7RUFBQSxJQUEzRyxXQUEyRyxHQUFBLE1BQUEsQ0FBM0csV0FBMkc7TUFBOUYsT0FBOEYsR0FBQSxNQUFBLENBQTlGLE9BQThGO01BQXJGLEtBQXFGLEdBQUEsTUFBQSxDQUFyRixLQUFxRjtNQUE5RSxXQUE4RSxHQUFBLE1BQUEsQ0FBOUUsV0FBOEUsQ0FBQTs7RUFDaEksSUFBSSxDQUFDLFdBQVcsQ0FBQyxlQUFqQixFQUFrQztJQUNoQyxJQUFJLENBQUM7TUFBRSxXQUFXLEVBQVgsV0FBRjtNQUFlLFdBQVcsRUFBWCxXQUFmO01BQTRCLE9BQU8sRUFBUCxPQUE1QjtNQUFxQyxLQUFLLEVBQUwsS0FBckM7TUFBNEMsSUFBSSxFQUFFLEtBQUE7S0FBbkQsRUFBNEQsS0FBNUQsQ0FBSixDQUFBO0dBQ0Q7Q0FDRjs7QUFFRCxTQUFTLFlBQVQsQ0FBa0IsS0FBbEIsRUFBZ0M7RUFDOUIsS0FBSyxDQUFDLGFBQU4sR0FBc0IsYUFBdEIsQ0FBQTtFQUNBLEtBQUssQ0FBQyxRQUFOLENBQWUsT0FBZixDQUF1QixhQUF2QixHQUF1QyxhQUFhLENBQUMsUUFBckQsQ0FBQTtFQUNBLFVBQUssQ0FBQyxNQUFOLENBQWEsS0FBSyxDQUFDLE9BQU4sQ0FBYyxjQUEzQixFQUEyQyxhQUFhLENBQUMsS0FBekQsQ0FBQSxDQUFBO0NBQ0Q7O29CQUVjOzs7Ozs7Ozs7OztBQy9VZixJQUFBLFVBQUEsR0FBQSwyQkFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsa0JBQUEsR0FBQSwyQkFBQSxDQUFBLGlCQUFBLENBQUEsQ0FBQTs7OztBQW9CQSxTQUFTLFlBQVQsQ0FBa0IsS0FBbEIsRUFBeUM7RUFDdkMsS0FBSyxDQUFDLFNBQU4sQ0FBZ0IsVUFBQSxDQUFBLFNBQUEsQ0FBaEIsQ0FBQSxDQUFBO0VBRHVDLElBSXJDLGFBSnFDLEdBS25DLEtBTG1DLENBSXJDLGFBSnFDLENBQUE7O0VBUXZDLGFBQWEsQ0FBQyxRQUFkLENBQXVCLGtCQUF2QixHQUE0QyxDQUE1QyxDQUFBO0VBQ0EsYUFBYSxDQUFDLEtBQWQsQ0FBb0IsVUFBcEIsR0FBaUMsS0FBSyxDQUFDLE9BQU4sQ0FBYyxjQUFkLENBQTZCLFVBQTdCLEdBQTBDLElBQTNFLENBQUE7Q0FDRDs7QUFFRCxTQUFTLEtBQVQsQ0FBQSxJQUFBLEVBQXVFO0VBQUEsSUFBckQsWUFBcUQsR0FBQSxJQUFBLENBQXJELFlBQXFELENBQUE7O0VBQ3JFLElBQUksWUFBWSxDQUFDLElBQWIsS0FBc0IsTUFBMUIsRUFBa0M7SUFBRSxPQUFBO0dBQVE7O0VBRTVDLFlBQVksQ0FBQyxLQUFiLEdBQXFCLENBQUMsWUFBWSxDQUFDLEtBQWIsSUFBc0IsQ0FBdkIsSUFBNEIsQ0FBakQsQ0FBQTtDQUNEOztBQUVELFNBQVMsT0FBVCxDQUFBLEtBQUEsRUFFRSxLQUZGLEVBR0U7RUFBQSxJQUZFLFdBRUYsR0FBQSxLQUFBLENBRkUsV0FFRjtNQUZlLFlBRWYsR0FBQSxLQUFBLENBRmUsWUFFZjtNQUY2QixXQUU3QixHQUFBLEtBQUEsQ0FGNkIsV0FFN0I7TUFGMEMsT0FFMUMsR0FBQSxLQUFBLENBRjBDLE9BRTFDLENBQUE7O0VBQ0EsSUFBSSxZQUFZLENBQUMsSUFBYixLQUFzQixNQUF0QixJQUFnQyxDQUFDLE9BQU8sQ0FBQyxNQUE3QyxFQUFxRDtJQUFFLE9BQUE7R0FEdkQ7OztFQUlBLElBQU0sUUFBUSxHQUFHLE9BQU8sQ0FBQyxDQUFELENBQVAsQ0FBVyxTQUFYLENBQXFCLE9BQXJCLENBQTZCLGtCQUE5QyxDQUpBOztFQU9BLElBQUksUUFBUSxJQUFJLENBQWhCLEVBQW1CO0lBQUUsT0FBQTtHQVByQjs7O0VBVUEsV0FBVyxDQUFDLGtCQUFaLEdBQWlDLFVBQVUsQ0FBQyxZQUFNO0lBQ2hELEtBQUssQ0FBQyxhQUFOLENBQW9CLElBQXBCLENBQXlCO01BQ3ZCLFdBQVcsRUFBWCxXQUR1QjtNQUV2QixXQUFXLEVBQVgsV0FGdUI7TUFHdkIsSUFBSSxFQUFFLE1BSGlCO01BSXZCLE9BQU8sRUFBRSxZQUpjO01BS3ZCLEtBQUssRUFBRSxZQUFBO0tBTFQsRUFNRyxLQU5ILENBQUEsQ0FBQTtHQUR5QyxFQVF4QyxRQVJ3QyxDQUEzQyxDQUFBO0NBU0Q7O0FBRUQsU0FBUyxhQUFULENBQUEsS0FBQSxFQUFnRjtFQUFBLElBQXRELFdBQXNELEdBQUEsS0FBQSxDQUF0RCxXQUFzRCxDQUFBOzs7O0VBRzlFLElBQUksV0FBVyxDQUFDLGtCQUFoQixFQUFvQztJQUNsQyxhQUFhLENBQUMsV0FBVyxDQUFDLGtCQUFiLENBQWIsQ0FBQTtJQUNBLFdBQVcsQ0FBQyxrQkFBWixHQUFpQyxJQUFqQyxDQUFBO0dBQ0Q7Q0FDRjs7QUFFRCxJQUFNLFVBQTJCLEdBQUc7RUFDbEMsRUFBRSxFQUFFLDJCQUQ4QjtFQUVsQyxPQUFPLEVBQVAsWUFGa0M7RUFHbEMsU0FBUyxFQUFFLENBQUMsTUFBRCxFQUFTLElBQVQsRUFBZSxRQUFmLEVBQXlCLFFBQXpCLENBQUEsQ0FBbUMsTUFBbkMsQ0FDVCxVQUFDLEdBQUQsRUFBTSxVQUFOLEVBQXFCO0lBQ2xCLEdBQUQsQ0FBQSxnQkFBQSxDQUFBLE1BQUEsQ0FBOEIsVUFBOUIsQ0FBQSxDQUFBLEdBQThDLGFBQTlDLENBQUE7SUFDQSxPQUFPLEdBQVAsQ0FBQTtHQUhPLEVBS1Q7SUFDRSxtQkFBQSxFQUFxQixLQUR2QjtJQUVFLHFCQUFBLEVBQXVCLE9BQUE7R0FQaEIsQ0FBQTtDQUhiLENBQUE7b0JBZWU7Ozs7Ozs7Ozs7O0FDdkZmLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7Ozs7QUFXQSxTQUFTLFlBQVQsQ0FBa0IsS0FBbEIsRUFBZ0M7RUFBQSxJQUN0QixZQURzQixHQUNMLEtBREssQ0FDdEIsWUFEc0IsQ0FBQTtFQUc5QixZQUFZLENBQUMsU0FBYixDQUF1QixhQUF2QixHQUF1QyxtQkFBdkMsQ0FBQTtFQUVBLElBQU0sa0JBQWtCLEdBQUcsWUFBWSxDQUFDLFNBQWIsQ0FBdUIsaUJBQWxELENBQUE7O0VBRUEsWUFBWSxDQUFDLFNBQWIsQ0FBdUIsaUJBQXZCLEdBQTJDLFVBQVUsVUFBVixFQUFzQixRQUF0QixFQUFnQztJQUN6RSxJQUFNLEdBQUcsR0FBRyxrQkFBa0IsQ0FBQyxJQUFuQixDQUF3QixJQUF4QixFQUE4QixVQUE5QixFQUEwQyxRQUExQyxDQUFaLENBQUE7O0lBRUEsSUFBSSxHQUFHLEtBQUssSUFBWixFQUFrQjtNQUNoQixJQUFBLENBQUssTUFBTCxDQUFZLE9BQVosQ0FBb0IsVUFBcEIsQ0FBQSxHQUFrQyxRQUFsQyxDQUFBO0tBQ0Q7O0lBRUQsT0FBTyxHQUFQLENBQUE7R0FQRixDQUFBO0NBU0Q7O0FBRUQsU0FBUyxtQkFBVCxDQUEyRCxPQUEzRCxFQUF5RTtFQUN2RSxDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sSUFBQSxDQUFLLE1BQUwsQ0FBWSxPQUFuQixFQUE0QixPQUE1QixDQUFBLENBQUE7RUFFQSxPQUFPLElBQVAsQ0FBQTtDQUNEOztBQUVELElBQU0sTUFBdUIsR0FBRztFQUM5QixFQUFFLEVBQUUsb0NBRDBCO0VBRTlCLE9BQU8sRUFBUCxZQUY4QjtFQUc5QixTQUFTLEVBQUU7SUFDVCwrQkFBQSxFQUFpQyxTQUFBLDJCQUFBLENBQUEsSUFBQSxFQUs5QixLQUw4QixFQUtwQjtNQUFBLElBSlgsT0FJVyxHQUFBLElBQUEsQ0FKWCxPQUlXO1VBSFgsSUFHVyxHQUFBLElBQUEsQ0FIWCxJQUdXO1VBRlgsSUFFVyxHQUFBLElBQUEsQ0FGWCxJQUVXO1VBRFgsV0FDVyxHQUFBLElBQUEsQ0FEWCxXQUNXLENBQUE7TUFDWCxLQUFLLENBQUMsYUFBTixDQUFvQixZQUFwQixDQUFpQyxJQUFqQyxFQUF1QyxVQUFDLFlBQUQsRUFBZ0M7UUFDckUsSUFBTSxTQUFTLEdBQUcsWUFBWSxDQUFDLE1BQS9CLENBQUE7UUFDQSxJQUFNLE9BQU8sR0FBRyxTQUFTLENBQUMsT0FBMUIsQ0FBQTs7UUFFQSxJQUNFLFNBQVMsQ0FBQyxLQUFWLENBQWdCLElBQWhCLENBQUEsSUFDQSxTQUFTLENBQUMsS0FBVixDQUFnQixJQUFoQixDQUFBLENBQXNCLE1BRHRCLElBRUYsWUFBWSxDQUFDLGVBQWIsQ0FBNkIsT0FBN0IsRUFBc0MsSUFBdEMsRUFBNEMsV0FBNUMsQ0FIQSxFQUcwRDtVQUN4RCxPQUFPLENBQUMsSUFBUixDQUFhO1lBQ1gsSUFBSSxFQUFKLElBRFc7WUFFWCxTQUFTLEVBQVQsU0FGVztZQUdYLEtBQUssRUFBRTtjQUFFLFlBQVksRUFBWixZQUFBO2FBQUY7V0FIVCxDQUFBLENBQUE7U0FLRDtPQWJILENBQUEsQ0FBQTtLQVBPO0lBd0JULGtCQUFBLEVBQW9CLFNBQUEsZUFBQSxDQUFBLEtBQUEsRUFBc0I7TUFBQSxJQUFuQixZQUFtQixHQUFBLEtBQUEsQ0FBbkIsWUFBbUIsQ0FBQTs7TUFDeEMsWUFBWSxDQUFDLE1BQWIsQ0FBb0IsT0FBcEIsR0FBOEIsVUFBVSxPQUFWLEVBQXFDO1FBQ2pFLE9BQU8sWUFBWSxDQUFDLE9BQWIsQ0FBcUIsT0FBckIsQ0FBUCxDQUFBO09BREYsQ0FBQTtLQXpCTztJQThCVCxrQkFBQSxFQUFvQixTQUFBLGVBQUEsQ0FBQSxLQUFBLEVBQTRCLEtBQTVCLEVBQXNDO01BQUEsSUFBbkMsWUFBbUMsR0FBQSxLQUFBLENBQW5DLFlBQW1DO1VBQXJCLE9BQXFCLEdBQUEsS0FBQSxDQUFyQixPQUFxQixDQUFBO01BQ3hELENBQUEsQ0FBQSxFQUFBLFlBQUEsQ0FBQSxTQUFBLENBQUEsRUFBTyxZQUFZLENBQUMsTUFBYixDQUFvQixPQUEzQixFQUFvQyxLQUFLLENBQUMsYUFBTixDQUFvQixRQUF4RCxDQUFBLENBQUE7TUFDQSxDQUFBLENBQUEsRUFBQSxZQUFBLENBQUEsU0FBQSxDQUFBLEVBQU8sWUFBWSxDQUFDLE1BQWIsQ0FBb0IsT0FBM0IsRUFBb0MsT0FBTyxDQUFDLGFBQVIsSUFBeUIsRUFBN0QsQ0FBQSxDQUFBO0tBQ0Q7R0FqQ1E7Q0FIYixDQUFBO29CQXdDZTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQzVFZixJQUFBLGtCQUFBLEdBQUEsNEJBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBQTs7OztBQUNBLElBQUEsV0FBQSxHQUFBLDJCQUFBLENBQUEsZUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxvQkFBQSxHQUFBLDJCQUFBLENBQUEsd0JBQUEsQ0FBQSxDQUFBOzs7Ozs7OztvQkFFZTtFQUNiLEVBQUUsRUFBRSxnQkFEUztFQUViLE9BRmEsRUFBQSxTQUFBLE9BQUEsQ0FFSixLQUZJLEVBRW1CO0lBQzlCLEtBQUssQ0FBQyxTQUFOLENBQWdCLGtCQUFoQixDQUFBLENBQUE7SUFDQSxLQUFLLENBQUMsU0FBTixDQUFnQixXQUFBLENBQUEsU0FBQSxDQUFoQixDQUFBLENBQUE7SUFDQSxLQUFLLENBQUMsU0FBTixDQUFnQixvQkFBQSxDQUFBLFNBQUEsQ0FBaEIsQ0FBQSxDQUFBO0dBQ0Q7Ozs7Ozs7Ozs7Ozs7QUNWSCxJQUFBLGtCQUFBLEdBQUEsMkJBQUEsQ0FBQSxxQkFBQSxDQUFBLENBQUE7O0FBQ0EsK0VBQUE7O0FBRUEsb0VBQUE7Ozs7QUFzQk8sU0FBUyxZQUFULENBQWtCLEtBQWxCLEVBQWdDO0VBQUEsSUFJbkMsWUFKbUMsR0FLakMsS0FMaUMsQ0FJbkMsWUFKbUMsQ0FBQTtFQU9yQyxLQUFLLENBQUMsT0FBTixDQUFjLE1BQWQsQ0FBcUIsTUFBckIsR0FBOEIsSUFBOUIsQ0FBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7O0VBa0JBLFlBQVksQ0FBQyxTQUFiLENBQXVCLE1BQXZCLEdBQWdDLFVBQVUsTUFBVixFQUFrQjtJQUNoRCxPQUFPLE1BQU0sQ0FBQyxJQUFELEVBQU8sTUFBUCxFQUFlLEtBQWYsQ0FBYixDQUFBO0dBREYsQ0FBQTtDQUdEOztBQUVELFNBQVMsTUFBVCxDQUFnRCxZQUFoRCxFQUE0RSxNQUE1RSxFQUFvRyxLQUFwRyxFQUF5STtFQUN2SSxJQUFNLFFBQVEsR0FBSSxVQUFBLENBQUEsRUFBQSxDQUFHLE1BQUgsQ0FBVSxZQUFZLENBQUMsTUFBdkIsQ0FBQSxHQUNkLFVBQUEsQ0FBQSxHQUFBLENBQUksSUFBSixDQUFTLFlBQVksQ0FBQyxRQUFiLENBQXNCLGdCQUF0QixDQUF1QyxZQUFZLENBQUMsTUFBcEQsQ0FBVCxDQURjLEdBRWQsQ0FBQyxZQUFZLENBQUMsTUFBZCxDQUZKLENBRHVJOztFQU12SSxJQUFNLE9BQU8sR0FBSSxVQUFBLENBQUEsR0FBQSxDQUFJLE1BQUwsQ0FBb0IsT0FBcEMsQ0FBQTtFQUNBLElBQU0sUUFBcUMsR0FBRyxPQUFPLEdBQUcsRUFBSCxHQUFRLElBQTdELENBQUE7O0VBUHVJLElBQUEsS0FBQSxHQUFBLFNBQUEsS0FBQSxHQUFBO0lBQUEsSUFBQSxHQVNqSCxRQVRpSCxDQUFBLEVBQUEsQ0FBQSxDQUFBO0lBQUEsSUFTNUgsT0FUNEgsR0FBQSxJQUFBLENBQUE7SUFVckksSUFBTSxJQUFJLEdBQUcsWUFBWSxDQUFDLE9BQWIsQ0FBcUIsT0FBckIsQ0FBYixDQUFBOztJQUVBLElBQUksQ0FBQyxJQUFMLEVBQVc7TUFBRSxPQUFBLE9BQUEsQ0FBQTtLQUFPOztJQUVwQixJQUFNLGtCQUFrQixHQUFHLFVBQUEsQ0FBQSxHQUFBLENBQUksSUFBSixDQUN6QixLQUFLLENBQUMsWUFBTixDQUFtQixJQURNLEVBRXpCLFVBQUMsV0FBRCxFQUE4QjtNQUM1QixPQUFPLFdBQVcsQ0FBQyxXQUFaLEVBQUEsSUFDTCxXQUFXLENBQUMsWUFBWixLQUE2QixZQUR4QixJQUVMLFdBQVcsQ0FBQyxPQUFaLEtBQXdCLE9BRm5CLElBR0wsV0FBVyxDQUFDLFFBQVosQ0FBcUIsSUFBckIsS0FBOEIsTUFBTSxDQUFDLElBSHZDLENBQUE7S0FIdUIsQ0FBM0IsQ0FBQTs7SUFRQSxJQUFJLGFBQTRCLEdBQUEsS0FBQSxDQUFoQyxDQUFBOztJQUVBLElBQUksa0JBQUosRUFBd0I7TUFDdEIsa0JBQWtCLENBQUMsSUFBbkIsRUFBQSxDQUFBOztNQUVBLElBQUksUUFBSixFQUFjO1FBQ1osYUFBYSxHQUFHLGtCQUFrQixDQUFDLGNBQW5CLElBQXFDLElBQUksT0FBSixDQUFZLFVBQUMsT0FBRCxFQUFrQjtVQUNqRixrQkFBa0IsQ0FBQyxjQUFuQixHQUFvQyxPQUFwQyxDQUFBO1NBRG1ELENBQXJELENBQUE7T0FHRDtLQVBILE1BU0s7TUFDSCxJQUFNLElBQUksR0FBRyxVQUFBLENBQUEsSUFBQSxDQUFVLFVBQVYsQ0FBcUIsSUFBckIsQ0FBYixDQUFBOztNQUNBLElBQU0sTUFBTSxHQUFHO1FBQ2IsSUFBSSxFQUFPO1VBQUUsQ0FBQyxFQUFFLElBQUksQ0FBQyxDQUFWO1VBQWEsQ0FBQyxFQUFFLElBQUksQ0FBQyxDQUFBO1NBRG5CO1FBRWIsTUFBTSxFQUFLO1VBQUUsQ0FBQyxFQUFFLElBQUksQ0FBQyxDQUFWO1VBQWEsQ0FBQyxFQUFFLElBQUksQ0FBQyxDQUFBO1NBRm5CO1FBR2IsU0FBUyxFQUFFLEtBQUssQ0FBQyxHQUFOLEVBQUE7T0FIYixDQUFBOztNQU1BLElBQU0sS0FBSyxHQUFHLFVBQUEsQ0FBQSxPQUFBLENBQWEsYUFBYixDQUEyQixNQUEzQixDQUFkLENBQUE7O01BQ0EsYUFBYSxHQUFHLFdBQVcsQ0FBSSxLQUFKLEVBQVcsWUFBWCxFQUF5QixPQUF6QixFQUFrQyxNQUFsQyxFQUEwQyxLQUExQyxDQUEzQixDQUFBO0tBQ0Q7O0lBRUQsSUFBSSxRQUFKLEVBQWM7TUFDWixRQUFRLENBQUMsSUFBVCxDQUFjLGFBQWQsQ0FBQSxDQUFBO0tBQ0Q7R0EvQ29JLENBQUE7O0VBU3ZJLEtBQUEsSUFBQSxFQUFBLEdBQUEsQ0FBQSxFQUFBLEVBQUEsR0FBc0IsUUFBdEIsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQWdDO0lBQUEsSUFBQSxJQUFBLENBQUE7O0lBQUEsSUFBQSxJQUFBLEdBQUEsS0FBQSxFQUFBLENBQUE7O0lBQUEsSUFBQSxJQUFBLEtBQUEsT0FBQSxFQUdqQixNQUFBO0dBb0NkOztFQUVELE9BQU8sUUFBUSxJQUFJLE9BQU8sQ0FBQyxHQUFSLENBQVksUUFBWixDQUFBLENBQXNCLElBQXRCLENBQTJCLFlBQUE7SUFBQSxPQUFNLFlBQU4sQ0FBQTtHQUEzQixDQUFuQixDQUFBO0NBQ0Q7O0FBRUQsU0FBUyxXQUFULENBQXFELEtBQXJELEVBQW1FLFlBQW5FLEVBQStGLE9BQS9GLEVBQTBILE1BQTFILEVBQWtKLEtBQWxKLEVBQThKO0VBQzVKLElBQU0sV0FBVyxHQUFHLEtBQUssQ0FBQyxZQUFOLENBQUEsS0FBQSxDQUFBLENBQXVCO0lBQUUsV0FBVyxFQUFFLFFBQUE7R0FBdEMsQ0FBcEIsQ0FBQTtFQUNBLElBQU0sU0FBUyxHQUFHO0lBQ2hCLFdBQVcsRUFBWCxXQURnQjtJQUVoQixLQUFLLEVBQUwsS0FGZ0I7SUFHaEIsT0FBTyxFQUFFLEtBSE87SUFJaEIsV0FBVyxFQUFFLE9BSkc7SUFLaEIsS0FBSyxFQUFFLFFBQUE7R0FMVCxDQUFBO0VBUUEsV0FBVyxDQUFDLFlBQVosR0FBMkIsWUFBM0IsQ0FBQTtFQUNBLFdBQVcsQ0FBQyxPQUFaLEdBQXNCLE9BQXRCLENBQUE7RUFDQSxXQUFXLENBQUMsUUFBWixHQUF1QixDQUFBLENBQUEsRUFBQSxVQUFBLENBQUEsTUFBQSxFQUFPLEVBQVAsRUFBVyxNQUFYLENBQXZCLENBQUE7RUFDQSxXQUFXLENBQUMsU0FBWixHQUF3QixLQUF4QixDQUFBO0VBQ0EsV0FBVyxDQUFDLGFBQVosQ0FBMEIsS0FBMUIsRUFBaUMsS0FBakMsRUFBd0MsT0FBeEMsRUFBaUQsSUFBakQsQ0FBQSxDQUFBOztFQUVBLFdBQVcsQ0FBQyxRQUFaLENBQXFCLFNBQXJCLENBQUEsQ0FBQTs7RUFFQSxJQUFNLGFBQWEsR0FBSSxVQUFBLENBQUEsR0FBQSxDQUFJLE1BQUwsQ0FBK0IsT0FBL0IsR0FDbEIsSUFBSyxVQUFBLENBQUEsR0FBQSxDQUFJLE1BQUwsQ0FBK0IsT0FBbkMsQ0FBMkMsVUFBQyxPQUFELEVBQWtCO0lBQzdELFdBQVcsQ0FBQyxjQUFaLEdBQTZCLE9BQTdCLENBQUE7R0FEQSxDQURrQixHQUlsQixJQUpKLENBQUE7RUFNQSxXQUFXLENBQUMsY0FBWixHQUE2QixhQUE3QixDQUFBO0VBQ0EsV0FBVyxDQUFDLEtBQVosQ0FBa0IsTUFBbEIsRUFBMEIsWUFBMUIsRUFBd0MsT0FBeEMsQ0FBQSxDQUFBOztFQUVBLElBQUksV0FBVyxDQUFDLFlBQWhCLEVBQThCO0lBQzVCLFdBQVcsQ0FBQyxJQUFaLENBQWlCLFNBQWpCLENBQUEsQ0FBQTtJQUNBLFdBQVcsQ0FBQyxHQUFaLENBQWdCLEtBQWhCLENBQUEsQ0FBQTtHQUZGLE1BSUs7SUFDSCxXQUFXLENBQUMsSUFBWixFQUFBLENBQUE7R0FDRDs7RUFFRCxXQUFXLENBQUMsYUFBWixDQUEwQixLQUExQixFQUFpQyxLQUFqQyxDQUFBLENBQUE7RUFDQSxXQUFXLENBQUMsYUFBWixHQUE0QixLQUE1QixDQUFBO0VBRUEsT0FBTyxhQUFQLENBQUE7Q0FDRDs7b0JBRWM7RUFDYixFQUFFLEVBQUUsUUFEUztFQUViLE9BQU8sRUFBUCxZQUZhO0VBR2IsU0FBUyxFQUFFOztJQUVULG1CQUFBLEVBQXFCLFNBQUEsZ0JBQUEsQ0FBQSxLQUFBLEVBQWtCLEtBQWxCLEVBQTRCO01BQUEsSUFBekIsV0FBeUIsR0FBQSxLQUFBLENBQXpCLFdBQXlCLENBQUE7O01BQy9DLElBQUksV0FBVyxDQUFDLFdBQVosS0FBNEIsUUFBaEMsRUFBMEM7UUFDeEMsSUFBSSxXQUFXLENBQUMsY0FBaEIsRUFBZ0M7VUFDOUIsV0FBVyxDQUFDLGNBQVosRUFBQSxDQUFBO1NBQ0Q7O1FBRUQsVUFBQSxDQUFBLEdBQUEsQ0FBSSxNQUFKLENBQVcsS0FBSyxDQUFDLFlBQU4sQ0FBbUIsSUFBOUIsRUFBb0MsV0FBcEMsQ0FBQSxDQUFBO09BQ0Q7S0FDRjtHQVZROzs7Ozs7Ozs7Ozs7Ozs7QUN0SmIsVUFBQSxDQUFBOztBQUdBLElBQUEsV0FBQSxHQUFBLGNBQUEsQ0FBQTs7QUFDQSxJQUFBLGFBQUEsR0FBQSwyQkFBQSxDQUFBLFlBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsWUFBQSxHQUFBLDJCQUFBLENBQUEsV0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxVQUFBLEdBQUEsNEJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7O0FBaUNBLElBQU0sWUFBaUIsR0FBRyxFQUExQixDQUFBO0FBQ0EsSUFBTSxLQUFLLEdBQUcsSUFBSSxXQUFBLENBQUEsS0FBSixFQUFkLENBQUE7OztBQUVPLFNBQVMsU0FBVCxDQUFlLEdBQWYsRUFBNEI7RUFDakMsS0FBSyxDQUFDLElBQU4sQ0FBVyxHQUFYLENBQUEsQ0FBQTtFQUVBLE9BQU8sUUFBUCxDQUFBO0NBQ0Q7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUEyQk0sSUFBTSxRQUF3QixHQUFHLFNBQVMsUUFBVCxDQUFtQixNQUFuQixFQUE0QyxPQUE1QyxFQUEyRDtFQUNqRyxJQUFJLFlBQVksR0FBRyxLQUFLLENBQUMsYUFBTixDQUFvQixHQUFwQixDQUF3QixNQUF4QixFQUFnQyxPQUFoQyxDQUFuQixDQUFBOztFQUVBLElBQUksQ0FBQyxZQUFMLEVBQW1CO0lBQ2pCLFlBQVksR0FBRyxLQUFLLENBQUMsYUFBTixDQUFBLEtBQUEsQ0FBQSxDQUF3QixNQUF4QixFQUFnQyxPQUFoQyxDQUFmLENBQUE7SUFDQSxZQUFZLENBQUMsTUFBYixDQUFvQixNQUFwQixHQUE2QixZQUE3QixDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxZQUFQLENBQUE7Q0FSSyxDQUFBOzs7Ozs7Ozs7Ozs7O0FBb0JQLFFBQVEsQ0FBQyxHQUFULEdBQWUsR0FBZixDQUFBOztBQUNBLFNBQVMsR0FBVCxDQUFjLE1BQWQsRUFBdUMsT0FBdkMsRUFBeUU7RUFDdkUsS0FBSyxDQUFDLFNBQU4sQ0FBZ0IsTUFBaEIsRUFBd0IsT0FBeEIsQ0FBQSxDQUFBO0VBRUEsT0FBTyxRQUFQLENBQUE7Q0FDRDs7Ozs7Ozs7Ozs7OztBQVlELFFBQVEsQ0FBQyxLQUFULEdBQWlCLEtBQWpCLENBQUE7O0FBQ0EsU0FBUyxLQUFULENBQWdCLE1BQWhCLEVBQTBDLE9BQTFDLEVBQXlEO0VBQ3ZELE9BQU8sQ0FBQyxDQUFDLEtBQUssQ0FBQyxhQUFOLENBQW9CLEdBQXBCLENBQXdCLE1BQXhCLEVBQWdDLE9BQU8sSUFBSSxPQUFPLENBQUMsT0FBbkQsQ0FBVCxDQUFBO0NBQ0Q7Ozs7Ozs7Ozs7Ozs7O0FBYUQsUUFBUSxDQUFDLEVBQVQsR0FBYyxFQUFkLENBQUE7O0FBQ0EsU0FBUyxFQUFULENBQWEsSUFBYixFQUFpRCxRQUFqRCxFQUFrRixPQUFsRixFQUFvRztFQUNsRyxJQUFJLFVBQUssQ0FBQyxFQUFOLENBQVMsTUFBVCxDQUFnQixJQUFoQixDQUFBLElBQXlCLElBQUksQ0FBQyxNQUFMLENBQVksR0FBWixDQUFBLEtBQXFCLENBQUMsQ0FBbkQsRUFBc0Q7SUFDcEQsSUFBSSxHQUFHLElBQUksQ0FBQyxJQUFMLEVBQUEsQ0FBWSxLQUFaLENBQWtCLElBQWxCLENBQVAsQ0FBQTtHQUNEOztFQUVELElBQUksVUFBSyxDQUFDLEVBQU4sQ0FBUyxLQUFULENBQWUsSUFBZixDQUFKLEVBQTBCO0lBQ3hCLEtBQUEsSUFBQSxFQUFBLEdBQUEsQ0FBQSxFQUFBLEVBQUEsR0FBeUIsSUFBekIsQ0FBQSxNQUFBLEVBQUEsRUFBQSxFQUFBLEVBQXlDO01BQUEsSUFBQSxJQUFBLENBQUE7O01BQUEsSUFBQSxHQUFoQixJQUFnQixDQUFBLEVBQUEsQ0FBQSxDQUFBO01BQUEsSUFBOUIsU0FBOEIsR0FBQSxJQUFBLENBQUE7TUFDdkMsUUFBUSxDQUFDLEVBQVQsQ0FBWSxTQUFaLEVBQXVCLFFBQXZCLEVBQWlDLE9BQWpDLENBQUEsQ0FBQTtLQUNEOztJQUVELE9BQU8sUUFBUCxDQUFBO0dBQ0Q7O0VBRUQsSUFBSSxVQUFLLENBQUMsRUFBTixDQUFTLE1BQVQsQ0FBZ0IsSUFBaEIsQ0FBSixFQUEyQjtJQUN6QixLQUFLLElBQU0sSUFBWCxJQUFtQixJQUFuQixFQUF5QjtNQUN2QixRQUFRLENBQUMsRUFBVCxDQUFZLElBQVosRUFBbUIsSUFBRCxDQUFjLElBQWQsQ0FBbEIsRUFBdUMsUUFBdkMsQ0FBQSxDQUFBO0tBQ0Q7O0lBRUQsT0FBTyxRQUFQLENBQUE7R0FsQmdHOzs7RUFzQmxHLElBQUksQ0FBQSxDQUFBLEVBQUEsV0FBQSxDQUFBLGdCQUFBLEVBQWlCLElBQWpCLEVBQXVCLEtBQUssQ0FBQyxPQUE3QixDQUFKLEVBQTJDOztJQUV6QyxJQUFJLENBQUMsWUFBWSxDQUFDLElBQUQsQ0FBakIsRUFBeUI7TUFDdkIsWUFBWSxDQUFDLElBQUQsQ0FBWixHQUFxQixDQUFDLFFBQUQsQ0FBckIsQ0FBQTtLQURGLE1BR0s7TUFDSCxZQUFZLENBQUMsSUFBRCxDQUFaLENBQW1CLElBQW5CLENBQXdCLFFBQXhCLENBQUEsQ0FBQTtLQUNEO0dBUEg7T0FVSztNQUNILFlBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBTyxHQUFQLENBQVcsS0FBSyxDQUFDLFFBQWpCLEVBQTJCLElBQTNCLEVBQWlDLFFBQWpDLEVBQWdFO1FBQUUsT0FBTyxFQUFQLE9BQUE7T0FBbEUsQ0FBQSxDQUFBO0tBQ0Q7O0VBRUQsT0FBTyxRQUFQLENBQUE7Q0FDRDs7Ozs7Ozs7Ozs7Ozs7O0FBY0QsUUFBUSxDQUFDLEdBQVQsR0FBZSxHQUFmLENBQUE7O0FBQ0EsU0FBUyxHQUFULENBQWMsSUFBZCxFQUF5QyxRQUF6QyxFQUF3RCxPQUF4RCxFQUEwRTtFQUN4RSxJQUFJLFVBQUssQ0FBQyxFQUFOLENBQVMsTUFBVCxDQUFnQixJQUFoQixDQUFBLElBQXlCLElBQUksQ0FBQyxNQUFMLENBQVksR0FBWixDQUFBLEtBQXFCLENBQUMsQ0FBbkQsRUFBc0Q7SUFDcEQsSUFBSSxHQUFHLElBQUksQ0FBQyxJQUFMLEVBQUEsQ0FBWSxLQUFaLENBQWtCLElBQWxCLENBQVAsQ0FBQTtHQUNEOztFQUVELElBQUksVUFBSyxDQUFDLEVBQU4sQ0FBUyxLQUFULENBQWUsSUFBZixDQUFKLEVBQTBCO0lBQ3hCLEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBd0IsSUFBeEIsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQThCO01BQUEsSUFBQSxLQUFBLENBQUE7O01BQUEsS0FBQSxHQUFOLElBQU0sQ0FBQSxHQUFBLENBQUEsQ0FBQTtNQUFBLElBQW5CLFNBQW1CLEdBQUEsS0FBQSxDQUFBO01BQzVCLFFBQVEsQ0FBQyxHQUFULENBQWEsU0FBYixFQUF3QixRQUF4QixFQUFrQyxPQUFsQyxDQUFBLENBQUE7S0FDRDs7SUFFRCxPQUFPLFFBQVAsQ0FBQTtHQUNEOztFQUVELElBQUksVUFBSyxDQUFDLEVBQU4sQ0FBUyxNQUFULENBQWdCLElBQWhCLENBQUosRUFBMkI7SUFDekIsS0FBSyxJQUFNLElBQVgsSUFBbUIsSUFBbkIsRUFBeUI7TUFDdkIsUUFBUSxDQUFDLEdBQVQsQ0FBYSxJQUFiLEVBQW1CLElBQUksQ0FBQyxJQUFELENBQXZCLEVBQStCLFFBQS9CLENBQUEsQ0FBQTtLQUNEOztJQUVELE9BQU8sUUFBUCxDQUFBO0dBQ0Q7O0VBRUQsSUFBSSxDQUFBLENBQUEsRUFBQSxXQUFBLENBQUEsZ0JBQUEsRUFBaUIsSUFBakIsRUFBdUIsS0FBSyxDQUFDLE9BQTdCLENBQUosRUFBMkM7SUFDekMsSUFBSSxLQUFKLENBQUE7O0lBRUEsSUFBSSxJQUFJLElBQUksWUFBUixJQUNBLENBQUMsS0FBSyxHQUFHLFlBQVksQ0FBQyxJQUFELENBQVosQ0FBbUIsT0FBbkIsQ0FBMkIsUUFBM0IsQ0FBVCxNQUFtRCxDQUFDLENBRHhELEVBQzJEO01BQ3pELFlBQVksQ0FBQyxJQUFELENBQVosQ0FBbUIsTUFBbkIsQ0FBMEIsS0FBMUIsRUFBaUMsQ0FBakMsQ0FBQSxDQUFBO0tBQ0Q7R0FOSCxNQVFLO0lBQ0gsWUFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFPLE1BQVAsQ0FBYyxLQUFLLENBQUMsUUFBcEIsRUFBOEIsSUFBOUIsRUFBb0MsUUFBcEMsRUFBOEMsT0FBOUMsQ0FBQSxDQUFBO0dBQ0Q7O0VBRUQsT0FBTyxRQUFQLENBQUE7Q0FDRDs7QUFFRCxRQUFRLENBQUMsS0FBVCxHQUFpQixLQUFqQixDQUFBOztBQUNBLFNBQVMsS0FBVCxHQUFrQjtFQUNoQixPQUFPLEtBQVAsQ0FBQTs7OztBQUlGLFFBQVEsQ0FBQyxpQkFBVCxHQUE4QixVQUFLLENBQUMsT0FBTixDQUFjLGNBQTVDLENBQUE7QUFDQSxRQUFRLENBQUMsWUFBVCxHQUE4QixVQUFLLENBQUMsT0FBTixDQUFjLFNBQTVDLENBQUE7QUFDQSxRQUFRLENBQUMsZ0JBQVQsR0FBOEIsVUFBSyxDQUFDLE9BQU4sQ0FBYyxhQUE1QyxDQUFBO0FBQ0EsUUFBUSxDQUFDLGFBQVQsR0FBOEIsVUFBSyxDQUFDLE9BQU4sQ0FBYyxVQUE1QyxDQUFBO0FBRUEsUUFBUSxDQUFDLGNBQVQsR0FBZ0MsVUFBSyxDQUFDLEdBQU4sQ0FBVSxjQUExQyxDQUFBO0FBQ0EsUUFBUSxDQUFDLG9CQUFULEdBQWdDLFVBQUssQ0FBQyxHQUFOLENBQVUsb0JBQTFDLENBQUE7QUFDQSxRQUFRLENBQUMsZUFBVCxHQUFnQyxVQUFLLENBQUMsR0FBTixDQUFVLGVBQTFDLENBQUE7QUFDQSxRQUFRLENBQUMsT0FBVCxHQUFnQyxVQUFLLENBQUMsR0FBTixDQUFVLE9BQTFDLENBQUE7Ozs7Ozs7QUFPQSxRQUFRLENBQUMsYUFBVCxHQUF5QixhQUF6QixDQUFBOztBQUNBLFNBQVMsYUFBVCxHQUEwQjtFQUN4QixPQUFPLGFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBUSxhQUFmLENBQUE7Q0FDRDs7Ozs7Ozs7QUFPRCxRQUFRLENBQUMsb0JBQVQsR0FBZ0Msb0JBQWhDLENBQUE7O0FBQ0EsU0FBUyxvQkFBVCxHQUFpQztFQUMvQixPQUFPLGFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBUSxvQkFBZixDQUFBO0NBQ0Q7Ozs7Ozs7Ozs7QUFTRCxRQUFRLENBQUMsSUFBVCxHQUFnQixTQUFoQixDQUFBOztBQUNBLFNBQVMsU0FBVCxHQUFpQjtFQUNmLEtBQUEsSUFBQSxHQUFBLEdBQUEsQ0FBQSxFQUFBLEdBQUEsR0FBMEIsS0FBSyxDQUFDLFlBQU4sQ0FBbUIsSUFBN0MsQ0FBQSxNQUFBLEVBQUEsR0FBQSxFQUFBLEVBQW1EO0lBQUEsSUFBQSxLQUFBLENBQUE7O0lBQUEsS0FBQSxHQUF6QixLQUFLLENBQUMsWUFBTixDQUFtQixJQUFNLENBQUEsR0FBQSxDQUFBLENBQUE7SUFBQSxJQUF4QyxXQUF3QyxHQUFBLEtBQUEsQ0FBQTtJQUNqRCxXQUFXLENBQUMsSUFBWixFQUFBLENBQUE7R0FDRDs7RUFFRCxPQUFPLFFBQVAsQ0FBQTtDQUNEOzs7Ozs7Ozs7Ozs7QUFXRCxRQUFRLENBQUMsb0JBQVQsR0FBZ0Msb0JBQWhDLENBQUE7O0FBQ0EsU0FBUyxvQkFBVCxDQUErQixRQUEvQixFQUFrRDtFQUNoRCxJQUFJLFVBQUssQ0FBQyxFQUFOLENBQVMsTUFBVCxDQUFnQixRQUFoQixDQUFKLEVBQStCO0lBQzdCLEtBQUssQ0FBQyxZQUFOLENBQW1CLG9CQUFuQixHQUEwQyxRQUExQyxDQUFBO0lBRUEsT0FBTyxRQUFQLENBQUE7R0FDRDs7RUFFRCxPQUFPLEtBQUssQ0FBQyxZQUFOLENBQW1CLG9CQUExQixDQUFBO0NBQ0Q7O0FBRUQsUUFBUSxDQUFDLFdBQVQsR0FBdUIsVUFBQyxHQUFELEVBQU0sT0FBTixFQUFBO0VBQUEsT0FBa0IsS0FBSyxDQUFDLFdBQU4sQ0FBa0IsR0FBbEIsRUFBdUIsT0FBdkIsQ0FBbEIsQ0FBQTtDQUF2QixDQUFBOztBQUNBLFFBQVEsQ0FBQyxjQUFULEdBQTBCLFVBQUEsR0FBRyxFQUFBO0VBQUEsT0FBSSxLQUFLLENBQUMsY0FBTixDQUFxQixHQUFyQixDQUFKLENBQUE7Q0FBN0I7OztBQUdBLFFBQVEsQ0FBQyxPQUFULEdBQUEsT0FBQSxDQUFBO0FBRUEsS0FBSyxDQUFDLFFBQU4sR0FBaUIsUUFBakIsQ0FBQTtvQkFHZTs7Ozs7Ozs7Ozs7O0FDMVNmLFVBQUEsQ0FBQTs7QUFDQSxJQUFBLE9BQUEsR0FBQSwyQkFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsT0FBQSxHQUFBLDJCQUFBLENBQUEsU0FBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsMkJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLE9BQUEsR0FBQSwyQkFBQSxDQUFBLFVBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsT0FBQSxHQUFBLDJCQUFBLENBQUEsVUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsMkJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLE9BQUEsR0FBQSwyQkFBQSxDQUFBLFVBQUEsQ0FBQSxDQUFBOztBQUNBLElBQUEsT0FBQSxHQUFBLDJCQUFBLENBQUEsVUFBQSxDQUFBLENBQUE7O0FBQ0EsSUFBQSxPQUFBLEdBQUEsMkJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7QUFDQSxJQUFBLFFBQUEsR0FBQSw0QkFBQSxDQUFBLFVBQUEsQ0FBQSxDQUFBOzs7Ozs7Ozs7O0FBRUEsSUFBSSxDQUFBLE9BQU8sTUFBUCxLQUFBLFdBQUEsR0FBQSxXQUFBLEdBQUEsWUFBQSxDQUFPLE1BQVAsQ0FBQSxNQUFrQixRQUFsQixJQUE4QixDQUFDLENBQUMsTUFBcEMsRUFBNEM7RUFDMUMsU0FBSSxDQUFDLE1BQUQsQ0FBSixDQUFBO0NBQ0Q7O29CQUVjLFFBQUEsQ0FBQSxTQUFBOzs7QUFFUixTQUFTLFNBQVQsQ0FBZSxHQUFmLEVBQTRCO0VBQ2pDLENBQUEsQ0FBQSxFQUFBLFFBQUEsQ0FBQSxJQUFBLEVBQWEsR0FBYixDQUFBLENBQUE7O0VBRUEsUUFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFTLEdBQVQsQ0FBYSxPQUFBLENBQUEsU0FBQSxDQUFiLENBQUEsQ0FIaUM7OztFQU1qQyxRQUFBLENBQUEsU0FBQSxDQUFBLENBQVMsR0FBVCxDQUFhLE9BQUEsQ0FBQSxTQUFBLENBQWIsQ0FBQSxDQU5pQzs7O0VBU2pDLFFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBUyxHQUFULENBQWEsT0FBQSxDQUFBLFNBQUEsQ0FBYixDQUFBLENBVGlDOzs7RUFZakMsUUFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFTLEdBQVQsQ0FBYSxPQUFBLENBQUEsU0FBQSxDQUFiLENBQUEsQ0FaaUM7OztFQWVqQyxRQUFBLENBQUEsU0FBQSxDQUFBLENBQVMsR0FBVCxDQUFhLE9BQUEsQ0FBQSxTQUFBLENBQWIsQ0FBQSxDQWZpQzs7O0VBa0JqQyxRQUFBLENBQUEsU0FBQSxDQUFBLENBQVMsR0FBVCxDQUFhLE9BQUEsQ0FBQSxTQUFBLENBQWIsQ0FBQSxDQWxCaUM7OztFQXFCakMsUUFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFTLEdBQVQsQ0FBYSxPQUFBLENBQUEsU0FBQSxDQUFiLENBQUEsQ0FyQmlDOzs7RUF3QmpDLFFBQUEsQ0FBQSxTQUFBLENBQUEsQ0FBUyxHQUFULENBQWEsT0FBQSxDQUFBLFNBQUEsQ0FBYixDQUFBLENBeEJpQzs7O0VBMkJqQyxJQUFJLFlBQUEsS0FBeUIsWUFBN0IsRUFBMkM7SUFDekMsUUFBQSxDQUFBLFNBQUEsQ0FBQSxDQUFTLEdBQVQsQ0FBYSxPQUFBLENBQUEsU0FBQSxDQUFiLENBQUEsQ0FBQTtHQUNEOztFQUVELE9BQU8sUUFBQSxDQUFBLFNBQUEsQ0FBUCxDQUFBO0NBQ0Q7Ozs7Ozs7Ozs7Ozs7Ozs7QUNsREQsSUFBQSxXQUFBLEdBQUEsNEJBQUEsQ0FBQSxVQUFBLENBQUEsQ0FBQTs7Ozs7Ozs7QUFFQSxJQUFJLENBQUEsUUFBQSxLQUFBLFdBQUEsR0FBQSxXQUFBLEdBQUEsWUFBQSxDQUFPLFVBQVAsQ0FBQSxNQUFrQixRQUFsQixJQUE4QixDQUFDLENBQUMsVUFBcEMsRUFBNEM7RUFDMUMsSUFBSTtJQUFFLGtCQUFBLEdBQWlCLFdBQUEsQ0FBQSxTQUFBLENBQWpCLENBQUE7R0FBTixDQUNBLE9BQUEsT0FBQSxFQUFNLEVBQUU7Q0FDVDs7QUFFQSxXQUFBLENBQUEsU0FBQSxDQUFELENBQUEsU0FBQSxDQUFBLEdBQTRCLFdBQUEsQ0FBQSxTQUFBLENBQTVCLENBQUE7QUFDRSxXQUFBLENBQUEsU0FBQSxDQUFELENBQWtCLElBQWxCLEdBQXlCLFdBQUEsQ0FBQSxJQUF6QixDQUFBO29CQUVjLFdBQUEsQ0FBQSxTQUFBOzs7QUNWZjtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwiZmlsZSI6ImdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzQ29udGVudCI6WyIoZnVuY3Rpb24oZil7aWYodHlwZW9mIGV4cG9ydHM9PT1cIm9iamVjdFwiJiZ0eXBlb2YgbW9kdWxlIT09XCJ1bmRlZmluZWRcIil7bW9kdWxlLmV4cG9ydHM9ZigpfWVsc2UgaWYodHlwZW9mIGRlZmluZT09PVwiZnVuY3Rpb25cIiYmZGVmaW5lLmFtZCl7ZGVmaW5lKFtdLGYpfWVsc2V7dmFyIGc7aWYodHlwZW9mIHdpbmRvdyE9PVwidW5kZWZpbmVkXCIpe2c9d2luZG93fWVsc2UgaWYodHlwZW9mIGdsb2JhbCE9PVwidW5kZWZpbmVkXCIpe2c9Z2xvYmFsfWVsc2UgaWYodHlwZW9mIHNlbGYhPT1cInVuZGVmaW5lZFwiKXtnPXNlbGZ9ZWxzZXtnPXRoaXN9Zy5pbnRlcmFjdCA9IGYoKX19KShmdW5jdGlvbigpe3ZhciBkZWZpbmUsbW9kdWxlLGV4cG9ydHM7XG52YXIgY3JlYXRlTW9kdWxlRmFjdG9yeSA9IGZ1bmN0aW9uIGNyZWF0ZU1vZHVsZUZhY3RvcnkodCl7dmFyIGU7cmV0dXJuIGZ1bmN0aW9uKHIpe3JldHVybiBlfHx0KGU9e2V4cG9ydHM6e30scGFyZW50OnJ9LGUuZXhwb3J0cyksZS5leHBvcnRzfX07XG4iLCJpbXBvcnQgKiBhcyBhcnIgZnJvbSAnQGludGVyYWN0anMvdXRpbHMvYXJyJ1xuaW1wb3J0IGJyb3dzZXIgZnJvbSAnQGludGVyYWN0anMvdXRpbHMvYnJvd3NlcidcbmltcG9ydCBjbG9uZSBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9jbG9uZSdcbmltcG9ydCB7IGdldEVsZW1lbnRSZWN0LCBtYXRjaGVzVXBUbywgbm9kZUNvbnRhaW5zLCB0cnlTZWxlY3RvciB9IGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2RvbVV0aWxzJ1xuaW1wb3J0IGV2ZW50cyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9ldmVudHMnXG5pbXBvcnQgZXh0ZW5kIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2V4dGVuZCdcbmltcG9ydCAqIGFzIGlzIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2lzJ1xuaW1wb3J0IG5vcm1hbGl6ZUxpc3RlbmVycyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9ub3JtYWxpemVMaXN0ZW5lcnMnXG5pbXBvcnQgeyBnZXRXaW5kb3cgfSBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy93aW5kb3cnXG5pbXBvcnQgeyBBY3Rpb25EZWZhdWx0cywgRGVmYXVsdHMsIE9wdGlvbnMgfSBmcm9tICcuL2RlZmF1bHRPcHRpb25zJ1xuaW1wb3J0IEV2ZW50YWJsZSBmcm9tICcuL0V2ZW50YWJsZSdcbmltcG9ydCB7IEFjdGlvbnMsIGlzTm9uTmF0aXZlRXZlbnQgfSBmcm9tICcuL3Njb3BlJ1xuXG50eXBlIElnbm9yZVZhbHVlID0gc3RyaW5nIHwgSW50ZXJhY3QuRWxlbWVudCB8IGJvb2xlYW5cblxuLyoqICovXG5leHBvcnQgY2xhc3MgSW50ZXJhY3RhYmxlIGltcGxlbWVudHMgUGFydGlhbDxFdmVudGFibGU+IHtcbiAgcHJvdGVjdGVkIGdldCBfZGVmYXVsdHMgKCk6IERlZmF1bHRzIHtcbiAgICByZXR1cm4ge1xuICAgICAgYmFzZToge30sXG4gICAgICBwZXJBY3Rpb246IHt9LFxuICAgICAgYWN0aW9uczoge30gYXMgQWN0aW9uRGVmYXVsdHMsXG4gICAgfVxuICB9XG5cbiAgcmVhZG9ubHkgb3B0aW9ucyE6IFJlcXVpcmVkPE9wdGlvbnM+XG4gIHJlYWRvbmx5IF9hY3Rpb25zOiBBY3Rpb25zXG4gIHJlYWRvbmx5IHRhcmdldDogSW50ZXJhY3QuVGFyZ2V0XG4gIHJlYWRvbmx5IGV2ZW50cyA9IG5ldyBFdmVudGFibGUoKVxuICByZWFkb25seSBfY29udGV4dDogRG9jdW1lbnQgfCBJbnRlcmFjdC5FbGVtZW50XG4gIHJlYWRvbmx5IF93aW46IFdpbmRvd1xuICByZWFkb25seSBfZG9jOiBEb2N1bWVudFxuXG4gIC8qKiAqL1xuICBjb25zdHJ1Y3RvciAodGFyZ2V0OiBJbnRlcmFjdC5UYXJnZXQsIG9wdGlvbnM6IGFueSwgZGVmYXVsdENvbnRleHQ6IERvY3VtZW50IHwgSW50ZXJhY3QuRWxlbWVudCkge1xuICAgIHRoaXMuX2FjdGlvbnMgPSBvcHRpb25zLmFjdGlvbnNcbiAgICB0aGlzLnRhcmdldCAgID0gdGFyZ2V0XG4gICAgdGhpcy5fY29udGV4dCA9IG9wdGlvbnMuY29udGV4dCB8fCBkZWZhdWx0Q29udGV4dFxuICAgIHRoaXMuX3dpbiAgICAgPSBnZXRXaW5kb3codHJ5U2VsZWN0b3IodGFyZ2V0KSA/IHRoaXMuX2NvbnRleHQgOiB0YXJnZXQpXG4gICAgdGhpcy5fZG9jICAgICA9IHRoaXMuX3dpbi5kb2N1bWVudFxuXG4gICAgdGhpcy5zZXQob3B0aW9ucylcbiAgfVxuXG4gIHNldE9uRXZlbnRzIChhY3Rpb25OYW1lOiBJbnRlcmFjdC5BY3Rpb25OYW1lLCBwaGFzZXM6IE5vbk51bGxhYmxlPGFueT4pIHtcbiAgICBpZiAoaXMuZnVuYyhwaGFzZXMub25zdGFydCkpIHsgdGhpcy5vbihgJHthY3Rpb25OYW1lfXN0YXJ0YCwgcGhhc2VzLm9uc3RhcnQpIH1cbiAgICBpZiAoaXMuZnVuYyhwaGFzZXMub25tb3ZlKSkgeyB0aGlzLm9uKGAke2FjdGlvbk5hbWV9bW92ZWAsIHBoYXNlcy5vbm1vdmUpIH1cbiAgICBpZiAoaXMuZnVuYyhwaGFzZXMub25lbmQpKSB7IHRoaXMub24oYCR7YWN0aW9uTmFtZX1lbmRgLCBwaGFzZXMub25lbmQpIH1cbiAgICBpZiAoaXMuZnVuYyhwaGFzZXMub25pbmVydGlhc3RhcnQpKSB7IHRoaXMub24oYCR7YWN0aW9uTmFtZX1pbmVydGlhc3RhcnRgLCBwaGFzZXMub25pbmVydGlhc3RhcnQpIH1cblxuICAgIHJldHVybiB0aGlzXG4gIH1cblxuICB1cGRhdGVQZXJBY3Rpb25MaXN0ZW5lcnMgKGFjdGlvbk5hbWU6IEludGVyYWN0LkFjdGlvbk5hbWUsIHByZXY6IEludGVyYWN0Lkxpc3RlbmVycywgY3VyOiBJbnRlcmFjdC5MaXN0ZW5lcnMpIHtcbiAgICBpZiAoaXMuYXJyYXkocHJldikgfHwgaXMub2JqZWN0KHByZXYpKSB7XG4gICAgICB0aGlzLm9mZihhY3Rpb25OYW1lLCBwcmV2KVxuICAgIH1cblxuICAgIGlmIChpcy5hcnJheShjdXIpIHx8IGlzLm9iamVjdChjdXIpKSB7XG4gICAgICB0aGlzLm9uKGFjdGlvbk5hbWUsIGN1cilcbiAgICB9XG4gIH1cblxuICBzZXRQZXJBY3Rpb24gKGFjdGlvbk5hbWU6IEludGVyYWN0LkFjdGlvbk5hbWUsIG9wdGlvbnM6IEludGVyYWN0Lk9yQm9vbGVhbjxPcHRpb25zPikge1xuICAgIGNvbnN0IGRlZmF1bHRzID0gdGhpcy5fZGVmYXVsdHNcblxuICAgIC8vIGZvciBhbGwgdGhlIGRlZmF1bHQgcGVyLWFjdGlvbiBvcHRpb25zXG4gICAgZm9yIChjb25zdCBvcHRpb25OYW1lXyBpbiBvcHRpb25zKSB7XG4gICAgICBjb25zdCBvcHRpb25OYW1lID0gb3B0aW9uTmFtZV8gYXMga2V5b2YgSW50ZXJhY3QuUGVyQWN0aW9uRGVmYXVsdHNcbiAgICAgIGNvbnN0IGFjdGlvbk9wdGlvbnMgPSB0aGlzLm9wdGlvbnNbYWN0aW9uTmFtZV1cbiAgICAgIGNvbnN0IG9wdGlvblZhbHVlOiBhbnkgPSBvcHRpb25zW29wdGlvbk5hbWVdXG5cbiAgICAgIC8vIHJlbW92ZSBvbGQgZXZlbnQgbGlzdGVuZXJzIGFuZCBhZGQgbmV3IG9uZXNcbiAgICAgIGlmIChvcHRpb25OYW1lID09PSAnbGlzdGVuZXJzJykge1xuICAgICAgICB0aGlzLnVwZGF0ZVBlckFjdGlvbkxpc3RlbmVycyhhY3Rpb25OYW1lLCBhY3Rpb25PcHRpb25zLmxpc3RlbmVycywgb3B0aW9uVmFsdWUgYXMgSW50ZXJhY3QuTGlzdGVuZXJzKVxuICAgICAgfVxuXG4gICAgICAvLyBpZiB0aGUgb3B0aW9uIHZhbHVlIGlzIGFuIGFycmF5XG4gICAgICBpZiAoaXMuYXJyYXk8YW55PihvcHRpb25WYWx1ZSkpIHtcbiAgICAgICAgKGFjdGlvbk9wdGlvbnNbb3B0aW9uTmFtZV0gYXMgYW55KSA9IGFyci5mcm9tKG9wdGlvblZhbHVlKVxuICAgICAgfVxuICAgICAgLy8gaWYgdGhlIG9wdGlvbiB2YWx1ZSBpcyBhbiBvYmplY3RcbiAgICAgIGVsc2UgaWYgKGlzLnBsYWluT2JqZWN0KG9wdGlvblZhbHVlKSkge1xuICAgICAgICAvLyBjb3B5IHRoZSBvYmplY3RcbiAgICAgICAgKGFjdGlvbk9wdGlvbnNbb3B0aW9uTmFtZV0gYXMgYW55KSA9IGV4dGVuZChcbiAgICAgICAgICBhY3Rpb25PcHRpb25zW29wdGlvbk5hbWVdIHx8IHt9IGFzIGFueSxcbiAgICAgICAgICBjbG9uZShvcHRpb25WYWx1ZSkpXG5cbiAgICAgICAgLy8gc2V0IGFuYWJsZWQgZmllbGQgdG8gdHJ1ZSBpZiBpdCBleGlzdHMgaW4gdGhlIGRlZmF1bHRzXG4gICAgICAgIGlmIChpcy5vYmplY3QoZGVmYXVsdHMucGVyQWN0aW9uW29wdGlvbk5hbWVdKSAmJiAnZW5hYmxlZCcgaW4gKGRlZmF1bHRzLnBlckFjdGlvbltvcHRpb25OYW1lXSBhcyBhbnkpKSB7XG4gICAgICAgICAgKGFjdGlvbk9wdGlvbnNbb3B0aW9uTmFtZV0gYXMgYW55KS5lbmFibGVkID0gb3B0aW9uVmFsdWUuZW5hYmxlZCAhPT0gZmFsc2VcbiAgICAgICAgfVxuICAgICAgfVxuICAgICAgLy8gaWYgdGhlIG9wdGlvbiB2YWx1ZSBpcyBhIGJvb2xlYW4gYW5kIHRoZSBkZWZhdWx0IGlzIGFuIG9iamVjdFxuICAgICAgZWxzZSBpZiAoaXMuYm9vbChvcHRpb25WYWx1ZSkgJiYgaXMub2JqZWN0KGRlZmF1bHRzLnBlckFjdGlvbltvcHRpb25OYW1lXSkpIHtcbiAgICAgICAgKGFjdGlvbk9wdGlvbnNbb3B0aW9uTmFtZV0gYXMgYW55KS5lbmFibGVkID0gb3B0aW9uVmFsdWVcbiAgICAgIH1cbiAgICAgIC8vIGlmIGl0J3MgYW55dGhpbmcgZWxzZSwgZG8gYSBwbGFpbiBhc3NpZ25tZW50XG4gICAgICBlbHNlIHtcbiAgICAgICAgKGFjdGlvbk9wdGlvbnNbb3B0aW9uTmFtZV0gYXMgYW55KSA9IG9wdGlvblZhbHVlXG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBkZWZhdWx0IGZ1bmN0aW9uIHRvIGdldCBhbiBJbnRlcmFjdGFibGVzIGJvdW5kaW5nIHJlY3QuIENhbiBiZVxuICAgKiBvdmVycmlkZGVuIHVzaW5nIHtAbGluayBJbnRlcmFjdGFibGUucmVjdENoZWNrZXJ9LlxuICAgKlxuICAgKiBAcGFyYW0ge0VsZW1lbnR9IFtlbGVtZW50XSBUaGUgZWxlbWVudCB0byBtZWFzdXJlLlxuICAgKiBAcmV0dXJuIHtvYmplY3R9IFRoZSBvYmplY3QncyBib3VuZGluZyByZWN0YW5nbGUuXG4gICAqL1xuICBnZXRSZWN0IChlbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50KSB7XG4gICAgZWxlbWVudCA9IGVsZW1lbnQgfHwgKGlzLmVsZW1lbnQodGhpcy50YXJnZXQpXG4gICAgICA/IHRoaXMudGFyZ2V0XG4gICAgICA6IG51bGwpXG5cbiAgICBpZiAoaXMuc3RyaW5nKHRoaXMudGFyZ2V0KSkge1xuICAgICAgZWxlbWVudCA9IGVsZW1lbnQgfHwgdGhpcy5fY29udGV4dC5xdWVyeVNlbGVjdG9yKHRoaXMudGFyZ2V0KVxuICAgIH1cblxuICAgIHJldHVybiBnZXRFbGVtZW50UmVjdChlbGVtZW50KVxuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgb3Igc2V0cyB0aGUgZnVuY3Rpb24gdXNlZCB0byBjYWxjdWxhdGUgdGhlIGludGVyYWN0YWJsZSdzXG4gICAqIGVsZW1lbnQncyByZWN0YW5nbGVcbiAgICpcbiAgICogQHBhcmFtIHtmdW5jdGlvbn0gW2NoZWNrZXJdIEEgZnVuY3Rpb24gd2hpY2ggcmV0dXJucyB0aGlzIEludGVyYWN0YWJsZSdzXG4gICAqIGJvdW5kaW5nIHJlY3RhbmdsZS4gU2VlIHtAbGluayBJbnRlcmFjdGFibGUuZ2V0UmVjdH1cbiAgICogQHJldHVybiB7ZnVuY3Rpb24gfCBvYmplY3R9IFRoZSBjaGVja2VyIGZ1bmN0aW9uIG9yIHRoaXMgSW50ZXJhY3RhYmxlXG4gICAqL1xuICByZWN0Q2hlY2tlciAoY2hlY2tlcjogKGVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnQpID0+IGFueSkge1xuICAgIGlmIChpcy5mdW5jKGNoZWNrZXIpKSB7XG4gICAgICB0aGlzLmdldFJlY3QgPSBjaGVja2VyXG5cbiAgICAgIHJldHVybiB0aGlzXG4gICAgfVxuXG4gICAgaWYgKGNoZWNrZXIgPT09IG51bGwpIHtcbiAgICAgIGRlbGV0ZSB0aGlzLmdldFJlY3RcblxuICAgICAgcmV0dXJuIHRoaXNcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpcy5nZXRSZWN0XG4gIH1cblxuICBfYmFja0NvbXBhdE9wdGlvbiAob3B0aW9uTmFtZToga2V5b2YgSW50ZXJhY3QuT3B0aW9ucywgbmV3VmFsdWU6IGFueSkge1xuICAgIGlmICh0cnlTZWxlY3RvcihuZXdWYWx1ZSkgfHwgaXMub2JqZWN0KG5ld1ZhbHVlKSkge1xuICAgICAgKHRoaXMub3B0aW9uc1tvcHRpb25OYW1lXSBhcyBhbnkpID0gbmV3VmFsdWVcblxuICAgICAgZm9yIChjb25zdCBhY3Rpb24gaW4gdGhpcy5fYWN0aW9ucy5tYXApIHtcbiAgICAgICAgKHRoaXMub3B0aW9uc1thY3Rpb25dW29wdGlvbk5hbWVdIGFzIGFueSkgPSBuZXdWYWx1ZVxuICAgICAgfVxuXG4gICAgICByZXR1cm4gdGhpc1xuICAgIH1cblxuICAgIHJldHVybiB0aGlzLm9wdGlvbnNbb3B0aW9uTmFtZV1cbiAgfVxuXG4gIC8qKlxuICAgKiBHZXRzIG9yIHNldHMgdGhlIG9yaWdpbiBvZiB0aGUgSW50ZXJhY3RhYmxlJ3MgZWxlbWVudC4gIFRoZSB4IGFuZCB5XG4gICAqIG9mIHRoZSBvcmlnaW4gd2lsbCBiZSBzdWJ0cmFjdGVkIGZyb20gYWN0aW9uIGV2ZW50IGNvb3JkaW5hdGVzLlxuICAgKlxuICAgKiBAcGFyYW0ge0VsZW1lbnQgfCBvYmplY3QgfCBzdHJpbmd9IFtvcmlnaW5dIEFuIEhUTUwgb3IgU1ZHIEVsZW1lbnQgd2hvc2VcbiAgICogcmVjdCB3aWxsIGJlIHVzZWQsIGFuIG9iamVjdCBlZy4geyB4OiAwLCB5OiAwIH0gb3Igc3RyaW5nICdwYXJlbnQnLCAnc2VsZidcbiAgICogb3IgYW55IENTUyBzZWxlY3RvclxuICAgKlxuICAgKiBAcmV0dXJuIHtvYmplY3R9IFRoZSBjdXJyZW50IG9yaWdpbiBvciB0aGlzIEludGVyYWN0YWJsZVxuICAgKi9cbiAgb3JpZ2luIChuZXdWYWx1ZTogYW55KSB7XG4gICAgcmV0dXJuIHRoaXMuX2JhY2tDb21wYXRPcHRpb24oJ29yaWdpbicsIG5ld1ZhbHVlKVxuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgb3Igc2V0cyB0aGUgbW91c2UgY29vcmRpbmF0ZSB0eXBlcyB1c2VkIHRvIGNhbGN1bGF0ZSB0aGVcbiAgICogbW92ZW1lbnQgb2YgdGhlIHBvaW50ZXIuXG4gICAqXG4gICAqIEBwYXJhbSB7c3RyaW5nfSBbbmV3VmFsdWVdIFVzZSAnY2xpZW50JyBpZiB5b3Ugd2lsbCBiZSBzY3JvbGxpbmcgd2hpbGVcbiAgICogaW50ZXJhY3Rpbmc7IFVzZSAncGFnZScgaWYgeW91IHdhbnQgYXV0b1Njcm9sbCB0byB3b3JrXG4gICAqIEByZXR1cm4ge3N0cmluZyB8IG9iamVjdH0gVGhlIGN1cnJlbnQgZGVsdGFTb3VyY2Ugb3IgdGhpcyBJbnRlcmFjdGFibGVcbiAgICovXG4gIGRlbHRhU291cmNlIChuZXdWYWx1ZT86IHN0cmluZykge1xuICAgIGlmIChuZXdWYWx1ZSA9PT0gJ3BhZ2UnIHx8IG5ld1ZhbHVlID09PSAnY2xpZW50Jykge1xuICAgICAgdGhpcy5vcHRpb25zLmRlbHRhU291cmNlID0gbmV3VmFsdWVcblxuICAgICAgcmV0dXJuIHRoaXNcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpcy5vcHRpb25zLmRlbHRhU291cmNlXG4gIH1cblxuICAvKipcbiAgICogR2V0cyB0aGUgc2VsZWN0b3IgY29udGV4dCBOb2RlIG9mIHRoZSBJbnRlcmFjdGFibGUuIFRoZSBkZWZhdWx0IGlzXG4gICAqIGB3aW5kb3cuZG9jdW1lbnRgLlxuICAgKlxuICAgKiBAcmV0dXJuIHtOb2RlfSBUaGUgY29udGV4dCBOb2RlIG9mIHRoaXMgSW50ZXJhY3RhYmxlXG4gICAqL1xuICBjb250ZXh0ICgpIHtcbiAgICByZXR1cm4gdGhpcy5fY29udGV4dFxuICB9XG5cbiAgaW5Db250ZXh0IChlbGVtZW50OiBEb2N1bWVudCB8IE5vZGUpIHtcbiAgICByZXR1cm4gKHRoaXMuX2NvbnRleHQgPT09IGVsZW1lbnQub3duZXJEb2N1bWVudCB8fFxuICAgICAgICAgICAgbm9kZUNvbnRhaW5zKHRoaXMuX2NvbnRleHQsIGVsZW1lbnQpKVxuICB9XG5cbiAgdGVzdElnbm9yZUFsbG93IChcbiAgICB0aGlzOiBJbnRlcmFjdGFibGUsXG4gICAgb3B0aW9uczogeyBpZ25vcmVGcm9tPzogSWdub3JlVmFsdWUsIGFsbG93RnJvbT86IElnbm9yZVZhbHVlIH0sXG4gICAgdGFyZ2V0Tm9kZTogTm9kZSxcbiAgICBldmVudFRhcmdldDogSW50ZXJhY3QuRXZlbnRUYXJnZXQsXG4gICkge1xuICAgIHJldHVybiAoIXRoaXMudGVzdElnbm9yZShvcHRpb25zLmlnbm9yZUZyb20sIHRhcmdldE5vZGUsIGV2ZW50VGFyZ2V0KSAmJlxuICAgICAgICAgICAgdGhpcy50ZXN0QWxsb3cob3B0aW9ucy5hbGxvd0Zyb20sIHRhcmdldE5vZGUsIGV2ZW50VGFyZ2V0KSlcbiAgfVxuXG4gIHRlc3RBbGxvdyAoXG4gICAgdGhpczogSW50ZXJhY3RhYmxlLFxuICAgIGFsbG93RnJvbTogSWdub3JlVmFsdWUsXG4gICAgdGFyZ2V0Tm9kZTogTm9kZSxcbiAgICBlbGVtZW50OiBJbnRlcmFjdC5FdmVudFRhcmdldCxcbiAgKSB7XG4gICAgaWYgKCFhbGxvd0Zyb20pIHsgcmV0dXJuIHRydWUgfVxuXG4gICAgaWYgKCFpcy5lbGVtZW50KGVsZW1lbnQpKSB7IHJldHVybiBmYWxzZSB9XG5cbiAgICBpZiAoaXMuc3RyaW5nKGFsbG93RnJvbSkpIHtcbiAgICAgIHJldHVybiBtYXRjaGVzVXBUbyhlbGVtZW50LCBhbGxvd0Zyb20sIHRhcmdldE5vZGUpXG4gICAgfVxuICAgIGVsc2UgaWYgKGlzLmVsZW1lbnQoYWxsb3dGcm9tKSkge1xuICAgICAgcmV0dXJuIG5vZGVDb250YWlucyhhbGxvd0Zyb20sIGVsZW1lbnQpXG4gICAgfVxuXG4gICAgcmV0dXJuIGZhbHNlXG4gIH1cblxuICB0ZXN0SWdub3JlIChcbiAgICB0aGlzOiBJbnRlcmFjdGFibGUsXG4gICAgaWdub3JlRnJvbTogSWdub3JlVmFsdWUsXG4gICAgdGFyZ2V0Tm9kZTogTm9kZSxcbiAgICBlbGVtZW50OiBJbnRlcmFjdC5FdmVudFRhcmdldCxcbiAgKSB7XG4gICAgaWYgKCFpZ25vcmVGcm9tIHx8ICFpcy5lbGVtZW50KGVsZW1lbnQpKSB7IHJldHVybiBmYWxzZSB9XG5cbiAgICBpZiAoaXMuc3RyaW5nKGlnbm9yZUZyb20pKSB7XG4gICAgICByZXR1cm4gbWF0Y2hlc1VwVG8oZWxlbWVudCwgaWdub3JlRnJvbSwgdGFyZ2V0Tm9kZSlcbiAgICB9XG4gICAgZWxzZSBpZiAoaXMuZWxlbWVudChpZ25vcmVGcm9tKSkge1xuICAgICAgcmV0dXJuIG5vZGVDb250YWlucyhpZ25vcmVGcm9tLCBlbGVtZW50KVxuICAgIH1cblxuICAgIHJldHVybiBmYWxzZVxuICB9XG5cbiAgLyoqXG4gICAqIENhbGxzIGxpc3RlbmVycyBmb3IgdGhlIGdpdmVuIEludGVyYWN0RXZlbnQgdHlwZSBib3VuZCBnbG9iYWxseVxuICAgKiBhbmQgZGlyZWN0bHkgdG8gdGhpcyBJbnRlcmFjdGFibGVcbiAgICpcbiAgICogQHBhcmFtIHtJbnRlcmFjdEV2ZW50fSBpRXZlbnQgVGhlIEludGVyYWN0RXZlbnQgb2JqZWN0IHRvIGJlIGZpcmVkIG9uIHRoaXNcbiAgICogSW50ZXJhY3RhYmxlXG4gICAqIEByZXR1cm4ge0ludGVyYWN0YWJsZX0gdGhpcyBJbnRlcmFjdGFibGVcbiAgICovXG4gIGZpcmUgKGlFdmVudDogb2JqZWN0KSB7XG4gICAgdGhpcy5ldmVudHMuZmlyZShpRXZlbnQpXG5cbiAgICByZXR1cm4gdGhpc1xuICB9XG5cbiAgX29uT2ZmIChtZXRob2Q6ICdvbicgfCAnb2ZmJywgdHlwZUFyZzogSW50ZXJhY3QuRXZlbnRUeXBlcywgbGlzdGVuZXJBcmc/OiBJbnRlcmFjdC5MaXN0ZW5lcnNBcmcgfCBudWxsLCBvcHRpb25zPzogYW55KSB7XG4gICAgaWYgKGlzLm9iamVjdCh0eXBlQXJnKSAmJiAhaXMuYXJyYXkodHlwZUFyZykpIHtcbiAgICAgIG9wdGlvbnMgPSBsaXN0ZW5lckFyZ1xuICAgICAgbGlzdGVuZXJBcmcgPSBudWxsXG4gICAgfVxuXG4gICAgY29uc3QgYWRkUmVtb3ZlID0gbWV0aG9kID09PSAnb24nID8gJ2FkZCcgOiAncmVtb3ZlJ1xuICAgIGNvbnN0IGxpc3RlbmVycyA9IG5vcm1hbGl6ZUxpc3RlbmVycyh0eXBlQXJnLCBsaXN0ZW5lckFyZylcblxuICAgIGZvciAobGV0IHR5cGUgaW4gbGlzdGVuZXJzKSB7XG4gICAgICBpZiAodHlwZSA9PT0gJ3doZWVsJykgeyB0eXBlID0gYnJvd3Nlci53aGVlbEV2ZW50IH1cblxuICAgICAgZm9yIChjb25zdCBsaXN0ZW5lciBvZiBsaXN0ZW5lcnNbdHlwZV0pIHtcbiAgICAgICAgLy8gaWYgaXQgaXMgYW4gYWN0aW9uIGV2ZW50IHR5cGVcbiAgICAgICAgaWYgKGlzTm9uTmF0aXZlRXZlbnQodHlwZSwgdGhpcy5fYWN0aW9ucykpIHtcbiAgICAgICAgICB0aGlzLmV2ZW50c1ttZXRob2RdKHR5cGUsIGxpc3RlbmVyKVxuICAgICAgICB9XG4gICAgICAgIC8vIGRlbGVnYXRlZCBldmVudFxuICAgICAgICBlbHNlIGlmIChpcy5zdHJpbmcodGhpcy50YXJnZXQpKSB7XG4gICAgICAgICAgZXZlbnRzW2Ake2FkZFJlbW92ZX1EZWxlZ2F0ZWAgYXMgJ2FkZERlbGVnYXRlJyB8ICdyZW1vdmVEZWxlZ2F0ZSddKHRoaXMudGFyZ2V0LCB0aGlzLl9jb250ZXh0LCB0eXBlLCBsaXN0ZW5lciwgb3B0aW9ucylcbiAgICAgICAgfVxuICAgICAgICAvLyByZW1vdmUgbGlzdGVuZXIgZnJvbSB0aGlzIEludGVyYWN0YWJsZSdzIGVsZW1lbnRcbiAgICAgICAgZWxzZSB7XG4gICAgICAgICAgKGV2ZW50c1thZGRSZW1vdmVdIGFzIHR5cGVvZiBldmVudHMucmVtb3ZlKSh0aGlzLnRhcmdldCwgdHlwZSwgbGlzdGVuZXIsIG9wdGlvbnMpXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gdGhpc1xuICB9XG5cbiAgLyoqXG4gICAqIEJpbmRzIGEgbGlzdGVuZXIgZm9yIGFuIEludGVyYWN0RXZlbnQsIHBvaW50ZXJFdmVudCBvciBET00gZXZlbnQuXG4gICAqXG4gICAqIEBwYXJhbSB7c3RyaW5nIHwgYXJyYXkgfCBvYmplY3R9IHR5cGVzIFRoZSB0eXBlcyBvZiBldmVudHMgdG8gbGlzdGVuXG4gICAqIGZvclxuICAgKiBAcGFyYW0ge2Z1bmN0aW9uIHwgYXJyYXkgfCBvYmplY3R9IFtsaXN0ZW5lcl0gVGhlIGV2ZW50IGxpc3RlbmVyIGZ1bmN0aW9uKHMpXG4gICAqIEBwYXJhbSB7b2JqZWN0IHwgYm9vbGVhbn0gW29wdGlvbnNdIG9wdGlvbnMgb2JqZWN0IG9yIHVzZUNhcHR1cmUgZmxhZyBmb3JcbiAgICogYWRkRXZlbnRMaXN0ZW5lclxuICAgKiBAcmV0dXJuIHtJbnRlcmFjdGFibGV9IFRoaXMgSW50ZXJhY3RhYmxlXG4gICAqL1xuICBvbiAodHlwZXM6IEludGVyYWN0LkV2ZW50VHlwZXMsIGxpc3RlbmVyPzogSW50ZXJhY3QuTGlzdGVuZXJzQXJnLCBvcHRpb25zPzogYW55KSB7XG4gICAgcmV0dXJuIHRoaXMuX29uT2ZmKCdvbicsIHR5cGVzLCBsaXN0ZW5lciwgb3B0aW9ucylcbiAgfVxuXG4gIC8qKlxuICAgKiBSZW1vdmVzIGFuIEludGVyYWN0RXZlbnQsIHBvaW50ZXJFdmVudCBvciBET00gZXZlbnQgbGlzdGVuZXIuXG4gICAqXG4gICAqIEBwYXJhbSB7c3RyaW5nIHwgYXJyYXkgfCBvYmplY3R9IHR5cGVzIFRoZSB0eXBlcyBvZiBldmVudHMgdGhhdCB3ZXJlXG4gICAqIGxpc3RlbmVkIGZvclxuICAgKiBAcGFyYW0ge2Z1bmN0aW9uIHwgYXJyYXkgfCBvYmplY3R9IFtsaXN0ZW5lcl0gVGhlIGV2ZW50IGxpc3RlbmVyIGZ1bmN0aW9uKHMpXG4gICAqIEBwYXJhbSB7b2JqZWN0IHwgYm9vbGVhbn0gW29wdGlvbnNdIG9wdGlvbnMgb2JqZWN0IG9yIHVzZUNhcHR1cmUgZmxhZyBmb3JcbiAgICogcmVtb3ZlRXZlbnRMaXN0ZW5lclxuICAgKiBAcmV0dXJuIHtJbnRlcmFjdGFibGV9IFRoaXMgSW50ZXJhY3RhYmxlXG4gICAqL1xuICBvZmYgKHR5cGVzOiBzdHJpbmcgfCBzdHJpbmdbXSB8IEludGVyYWN0LkV2ZW50VHlwZXMsIGxpc3RlbmVyPzogSW50ZXJhY3QuTGlzdGVuZXJzQXJnLCBvcHRpb25zPzogYW55KSB7XG4gICAgcmV0dXJuIHRoaXMuX29uT2ZmKCdvZmYnLCB0eXBlcywgbGlzdGVuZXIsIG9wdGlvbnMpXG4gIH1cblxuICAvKipcbiAgICogUmVzZXQgdGhlIG9wdGlvbnMgb2YgdGhpcyBJbnRlcmFjdGFibGVcbiAgICpcbiAgICogQHBhcmFtIHtvYmplY3R9IG9wdGlvbnMgVGhlIG5ldyBzZXR0aW5ncyB0byBhcHBseVxuICAgKiBAcmV0dXJuIHtvYmplY3R9IFRoaXMgSW50ZXJhY3RhYmxlXG4gICAqL1xuICBzZXQgKG9wdGlvbnM6IEludGVyYWN0Lk9wdGlvbnNBcmcpIHtcbiAgICBjb25zdCBkZWZhdWx0cyA9IHRoaXMuX2RlZmF1bHRzXG5cbiAgICBpZiAoIWlzLm9iamVjdChvcHRpb25zKSkge1xuICAgICAgb3B0aW9ucyA9IHt9XG4gICAgfVxuXG4gICAgKHRoaXMub3B0aW9ucyBhcyBSZXF1aXJlZDxPcHRpb25zPikgPSBjbG9uZShkZWZhdWx0cy5iYXNlKSBhcyBSZXF1aXJlZDxPcHRpb25zPlxuXG4gICAgZm9yIChjb25zdCBhY3Rpb25OYW1lXyBpbiB0aGlzLl9hY3Rpb25zLm1ldGhvZERpY3QpIHtcbiAgICAgIGNvbnN0IGFjdGlvbk5hbWUgPSBhY3Rpb25OYW1lXyBhcyBJbnRlcmFjdC5BY3Rpb25OYW1lXG4gICAgICBjb25zdCBtZXRob2ROYW1lID0gdGhpcy5fYWN0aW9ucy5tZXRob2REaWN0W2FjdGlvbk5hbWVdXG5cbiAgICAgIHRoaXMub3B0aW9uc1thY3Rpb25OYW1lXSA9IHt9XG4gICAgICB0aGlzLnNldFBlckFjdGlvbihhY3Rpb25OYW1lLCBleHRlbmQoZXh0ZW5kKHt9LCBkZWZhdWx0cy5wZXJBY3Rpb24pLCBkZWZhdWx0cy5hY3Rpb25zW2FjdGlvbk5hbWVdKSlcblxuICAgICAgdGhpc1ttZXRob2ROYW1lXShvcHRpb25zW2FjdGlvbk5hbWVdKVxuICAgIH1cblxuICAgIGZvciAoY29uc3Qgc2V0dGluZyBpbiBvcHRpb25zKSB7XG4gICAgICBpZiAoaXMuZnVuYyh0aGlzW3NldHRpbmddKSkge1xuICAgICAgICB0aGlzW3NldHRpbmddKG9wdGlvbnNbc2V0dGluZ10pXG4gICAgICB9XG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXNcbiAgfVxuXG4gIC8qKlxuICAgKiBSZW1vdmUgdGhpcyBpbnRlcmFjdGFibGUgZnJvbSB0aGUgbGlzdCBvZiBpbnRlcmFjdGFibGVzIGFuZCByZW1vdmUgaXQnc1xuICAgKiBhY3Rpb24gY2FwYWJpbGl0aWVzIGFuZCBldmVudCBsaXN0ZW5lcnNcbiAgICpcbiAgICogQHJldHVybiB7aW50ZXJhY3R9XG4gICAqL1xuICB1bnNldCAoKSB7XG4gICAgZXZlbnRzLnJlbW92ZSh0aGlzLnRhcmdldCBhcyBOb2RlLCAnYWxsJylcblxuICAgIGlmIChpcy5zdHJpbmcodGhpcy50YXJnZXQpKSB7XG4gICAgICAvLyByZW1vdmUgZGVsZWdhdGVkIGV2ZW50c1xuICAgICAgZm9yIChjb25zdCB0eXBlIGluIGV2ZW50cy5kZWxlZ2F0ZWRFdmVudHMpIHtcbiAgICAgICAgY29uc3QgZGVsZWdhdGVkID0gZXZlbnRzLmRlbGVnYXRlZEV2ZW50c1t0eXBlXVxuXG4gICAgICAgIGlmIChkZWxlZ2F0ZWQuc2VsZWN0b3JzWzBdID09PSB0aGlzLnRhcmdldCAmJlxuICAgICAgICAgICAgZGVsZWdhdGVkLmNvbnRleHRzWzBdID09PSB0aGlzLl9jb250ZXh0KSB7XG4gICAgICAgICAgZGVsZWdhdGVkLnNlbGVjdG9ycy5zcGxpY2UoMCwgMSlcbiAgICAgICAgICBkZWxlZ2F0ZWQuY29udGV4dHMuc3BsaWNlKDAsIDEpXG4gICAgICAgICAgZGVsZWdhdGVkLmxpc3RlbmVycy5zcGxpY2UoMCwgMSlcbiAgICAgICAgfVxuXG4gICAgICAgIGV2ZW50cy5yZW1vdmUodGhpcy5fY29udGV4dCwgdHlwZSwgZXZlbnRzLmRlbGVnYXRlTGlzdGVuZXIpXG4gICAgICAgIGV2ZW50cy5yZW1vdmUodGhpcy5fY29udGV4dCwgdHlwZSwgZXZlbnRzLmRlbGVnYXRlVXNlQ2FwdHVyZSwgdHJ1ZSlcbiAgICAgIH1cbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICBldmVudHMucmVtb3ZlKHRoaXMudGFyZ2V0IGFzIE5vZGUsICdhbGwnKVxuICAgIH1cbiAgfVxufVxuXG5leHBvcnQgZGVmYXVsdCBJbnRlcmFjdGFibGVcbiIsImltcG9ydCBkb21PYmplY3RzIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2RvbU9iamVjdHMnXG5pbXBvcnQgKiBhcyB1dGlscyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9pbmRleCdcbmltcG9ydCBkZWZhdWx0cyBmcm9tICcuL2RlZmF1bHRPcHRpb25zJ1xuaW1wb3J0IEV2ZW50YWJsZSBmcm9tICcuL0V2ZW50YWJsZSdcbmltcG9ydCBJbnRlcmFjdGFibGVCYXNlIGZyb20gJy4vSW50ZXJhY3RhYmxlJ1xuaW1wb3J0IEludGVyYWN0YWJsZVNldCBmcm9tICcuL0ludGVyYWN0YWJsZVNldCdcbmltcG9ydCBJbnRlcmFjdEV2ZW50LCB7IFBoYXNlTWFwIH0gZnJvbSAnLi9JbnRlcmFjdEV2ZW50J1xuaW1wb3J0IGludGVyYWN0aW9ucyBmcm9tICcuL2ludGVyYWN0aW9ucydcblxuZXhwb3J0IGludGVyZmFjZSBTaWduYWxBcmdzIHtcbiAgJ3Njb3BlOmFkZC1kb2N1bWVudCc6IERvY1NpZ25hbEFyZ1xuICAnc2NvcGU6cmVtb3ZlLWRvY3VtZW50JzogRG9jU2lnbmFsQXJnXG4gICdpbnRlcmFjdGFibGU6dW5zZXQnOiB7IGludGVyYWN0YWJsZTogSW50ZXJhY3RhYmxlQmFzZSB9XG4gICdpbnRlcmFjdGFibGU6c2V0JzogeyBpbnRlcmFjdGFibGU6IEludGVyYWN0YWJsZUJhc2UsIG9wdGlvbnM6IEludGVyYWN0Lk9wdGlvbnMgfVxuICAnaW50ZXJhY3Rpb25zOmRlc3Ryb3knOiB7IGludGVyYWN0aW9uOiBJbnRlcmFjdC5JbnRlcmFjdGlvbiB9XG59XG5cbmV4cG9ydCB0eXBlIExpc3RlbmVyTmFtZSA9IGtleW9mIFNpZ25hbEFyZ3NcblxuZXhwb3J0IHR5cGUgTGlzdGVuZXJNYXAgPSB7XG4gIFtQIGluIExpc3RlbmVyTmFtZV0/OiAoYXJnOiBTaWduYWxBcmdzW1BdLCBzY29wZTogU2NvcGUsIHNpZ25hbE5hbWU6IFApID0+IHZvaWQgfCBib29sZWFuXG59XG5cbmludGVyZmFjZSBEb2NTaWduYWxBcmcge1xuICBkb2M6IERvY3VtZW50XG4gIHdpbmRvdzogV2luZG93XG4gIHNjb3BlOiBTY29wZVxuICBvcHRpb25zPzogeyBbaW5kZXg6IHN0cmluZ106IGFueSB9XG59XG5cbmNvbnN0IHtcbiAgd2luLFxuICBicm93c2VyLFxuICByYWYsXG4gIGV2ZW50cyxcbn0gPSB1dGlsc1xuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgQHR5cGVzY3JpcHQtZXNsaW50L25vLWVtcHR5LWludGVyZmFjZVxuZXhwb3J0IGludGVyZmFjZSBBY3Rpb25NYXAgeyAvLyB0c2xpbnQ6ZGlzYWJsZS1saW5lIG5vLWVtcHR5LWludGVyZmFjZVxufVxuXG5leHBvcnQgdHlwZSBBY3Rpb25OYW1lID0ga2V5b2YgQWN0aW9uTWFwXG5cbmV4cG9ydCBpbnRlcmZhY2UgQWN0aW9ucyB7XG4gIG1hcDogQWN0aW9uTWFwXG4gIHBoYXNlczogUGhhc2VNYXBcbiAgbWV0aG9kRGljdDogeyBbUCBpbiBBY3Rpb25OYW1lXT86IHN0cmluZyB9XG4gIHBoYXNlbGVzc1R5cGVzOiB7IFt0eXBlOiBzdHJpbmddOiB0cnVlIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNyZWF0ZVNjb3BlICgpIHtcbiAgcmV0dXJuIG5ldyBTY29wZSgpXG59XG5cbmV4cG9ydCB0eXBlIERlZmF1bHRzID0gdHlwZW9mIGRlZmF1bHRzXG5cbmV4cG9ydCBpbnRlcmZhY2UgUGx1Z2luIHtcbiAgW2tleTogc3RyaW5nXTogYW55XG4gIGlkPzogc3RyaW5nXG4gIGxpc3RlbmVycz86IExpc3RlbmVyTWFwXG4gIGJlZm9yZT86IHN0cmluZ1tdXG4gIGluc3RhbGw/IChzY29wZTogU2NvcGUsIG9wdGlvbnM/OiBhbnkpOiB2b2lkXG59XG5cbmV4cG9ydCBjbGFzcyBTY29wZSB7XG4gIGlkID0gYF9faW50ZXJhY3Rfc2NvcGVfJHtNYXRoLmZsb29yKE1hdGgucmFuZG9tKCkgKiAxMDApfWBcbiAgaXNJbml0aWFsaXplZCA9IGZhbHNlXG4gIGxpc3RlbmVyTWFwczogQXJyYXk8e1xuICAgIG1hcDogTGlzdGVuZXJNYXBcbiAgICBpZDogc3RyaW5nXG4gIH0+ID0gW11cblxuICBicm93c2VyID0gYnJvd3NlclxuICBldmVudHMgPSBldmVudHNcbiAgdXRpbHMgPSB1dGlsc1xuICBkZWZhdWx0czogRGVmYXVsdHMgPSB1dGlscy5jbG9uZShkZWZhdWx0cykgYXMgRGVmYXVsdHNcbiAgRXZlbnRhYmxlID0gRXZlbnRhYmxlXG4gIGFjdGlvbnM6IEFjdGlvbnMgPSB7XG4gICAgbWFwOiB7fSxcbiAgICBwaGFzZXM6IHtcbiAgICAgIHN0YXJ0OiB0cnVlLFxuICAgICAgbW92ZTogdHJ1ZSxcbiAgICAgIGVuZDogdHJ1ZSxcbiAgICB9LFxuICAgIG1ldGhvZERpY3Q6IHt9LFxuICAgIHBoYXNlbGVzc1R5cGVzOiB7fSxcbiAgfVxuXG4gIEludGVyYWN0RXZlbnQgPSBJbnRlcmFjdEV2ZW50XG4gIEludGVyYWN0YWJsZSE6IHR5cGVvZiBJbnRlcmFjdGFibGVCYXNlXG4gIGludGVyYWN0YWJsZXMgPSBuZXcgSW50ZXJhY3RhYmxlU2V0KHRoaXMpXG5cbiAgLy8gbWFpbiB3aW5kb3dcbiAgX3dpbiE6IFdpbmRvd1xuXG4gIC8vIG1haW4gZG9jdW1lbnRcbiAgZG9jdW1lbnQhOiBEb2N1bWVudFxuXG4gIC8vIG1haW4gd2luZG93XG4gIHdpbmRvdyE6IFdpbmRvd1xuXG4gIC8vIGFsbCBkb2N1bWVudHMgYmVpbmcgbGlzdGVuZWQgdG9cbiAgZG9jdW1lbnRzOiBBcnJheTx7IGRvYzogRG9jdW1lbnQsIG9wdGlvbnM6IGFueSB9PiA9IFtdXG5cbiAgX3BsdWdpbnM6IHtcbiAgICBsaXN0OiBQbHVnaW5bXVxuICAgIG1hcDogeyBbaWQ6IHN0cmluZ106IFBsdWdpbiB9XG4gIH0gPSB7XG4gICAgbGlzdDogW10sXG4gICAgbWFwOiB7fSxcbiAgfVxuXG4gIGNvbnN0cnVjdG9yICgpIHtcbiAgICBjb25zdCBzY29wZSA9IHRoaXNcblxuICAgIHRoaXMuSW50ZXJhY3RhYmxlID0gY2xhc3MgZXh0ZW5kcyBJbnRlcmFjdGFibGVCYXNlIHtcbiAgICAgIGdldCBfZGVmYXVsdHMgKCkgeyByZXR1cm4gc2NvcGUuZGVmYXVsdHMgfVxuXG4gICAgICBzZXQgKG9wdGlvbnM6IEludGVyYWN0Lk9wdGlvbnMpIHtcbiAgICAgICAgc3VwZXIuc2V0KG9wdGlvbnMpXG5cbiAgICAgICAgc2NvcGUuZmlyZSgnaW50ZXJhY3RhYmxlOnNldCcsIHtcbiAgICAgICAgICBvcHRpb25zLFxuICAgICAgICAgIGludGVyYWN0YWJsZTogdGhpcyxcbiAgICAgICAgfSlcblxuICAgICAgICByZXR1cm4gdGhpc1xuICAgICAgfVxuXG4gICAgICB1bnNldCAoKSB7XG4gICAgICAgIHN1cGVyLnVuc2V0KClcbiAgICAgICAgc2NvcGUuaW50ZXJhY3RhYmxlcy5saXN0LnNwbGljZShzY29wZS5pbnRlcmFjdGFibGVzLmxpc3QuaW5kZXhPZih0aGlzKSwgMSlcblxuICAgICAgICBzY29wZS5maXJlKCdpbnRlcmFjdGFibGU6dW5zZXQnLCB7IGludGVyYWN0YWJsZTogdGhpcyB9KVxuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gIGFkZExpc3RlbmVycyAobWFwOiBMaXN0ZW5lck1hcCwgaWQ/OiBzdHJpbmcpIHtcbiAgICB0aGlzLmxpc3RlbmVyTWFwcy5wdXNoKHsgaWQsIG1hcCB9KVxuICB9XG5cbiAgZmlyZTxUIGV4dGVuZHMgTGlzdGVuZXJOYW1lPiAobmFtZTogVCwgYXJnOiBTaWduYWxBcmdzW1RdKTogdm9pZCB8IGZhbHNlIHtcbiAgICBmb3IgKGNvbnN0IHsgbWFwOiB7IFtuYW1lXTogbGlzdGVuZXIgfSB9IG9mIHRoaXMubGlzdGVuZXJNYXBzKSB7XG4gICAgICBpZiAoISFsaXN0ZW5lciAmJiBsaXN0ZW5lcihhcmcgYXMgYW55LCB0aGlzLCBuYW1lIGFzIG5ldmVyKSA9PT0gZmFsc2UpIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlXG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgb25XaW5kb3dVbmxvYWQgPSAoZXZlbnQ6IEJlZm9yZVVubG9hZEV2ZW50KSA9PiB0aGlzLnJlbW92ZURvY3VtZW50KGV2ZW50LnRhcmdldCBhcyBEb2N1bWVudClcblxuICBpbml0ICh3aW5kb3c6IFdpbmRvdykge1xuICAgIHJldHVybiB0aGlzLmlzSW5pdGlhbGl6ZWRcbiAgICAgID8gdGhpc1xuICAgICAgOiBpbml0U2NvcGUodGhpcywgd2luZG93KVxuICB9XG5cbiAgcGx1Z2luSXNJbnN0YWxsZWQgKHBsdWdpbjogUGx1Z2luKSB7XG4gICAgcmV0dXJuIHRoaXMuX3BsdWdpbnMubWFwW3BsdWdpbi5pZF0gfHwgdGhpcy5fcGx1Z2lucy5saXN0LmluZGV4T2YocGx1Z2luKSAhPT0gLTFcbiAgfVxuXG4gIHVzZVBsdWdpbiAocGx1Z2luOiBQbHVnaW4sIG9wdGlvbnM/OiB7IFtrZXk6IHN0cmluZ106IGFueSB9KSB7XG4gICAgaWYgKHRoaXMucGx1Z2luSXNJbnN0YWxsZWQocGx1Z2luKSkge1xuICAgICAgcmV0dXJuIHRoaXNcbiAgICB9XG5cbiAgICBpZiAocGx1Z2luLmlkKSB7IHRoaXMuX3BsdWdpbnMubWFwW3BsdWdpbi5pZF0gPSBwbHVnaW4gfVxuICAgIHRoaXMuX3BsdWdpbnMubGlzdC5wdXNoKHBsdWdpbilcblxuICAgIGlmIChwbHVnaW4uaW5zdGFsbCkge1xuICAgICAgcGx1Z2luLmluc3RhbGwodGhpcywgb3B0aW9ucylcbiAgICB9XG5cbiAgICBpZiAocGx1Z2luLmxpc3RlbmVycyAmJiBwbHVnaW4uYmVmb3JlKSB7XG4gICAgICBsZXQgaW5kZXggPSAwXG4gICAgICBjb25zdCBsZW4gPSB0aGlzLmxpc3RlbmVyTWFwcy5sZW5ndGhcbiAgICAgIGNvbnN0IGJlZm9yZSA9IHBsdWdpbi5iZWZvcmUucmVkdWNlKChhY2MsIGlkKSA9PiB7XG4gICAgICAgIGFjY1tpZF0gPSB0cnVlXG4gICAgICAgIHJldHVybiBhY2NcbiAgICAgIH0sIHt9KVxuXG4gICAgICBmb3IgKDsgaW5kZXggPCBsZW47IGluZGV4KyspIHtcbiAgICAgICAgY29uc3Qgb3RoZXJJZCA9IHRoaXMubGlzdGVuZXJNYXBzW2luZGV4XS5pZFxuXG4gICAgICAgIGlmIChiZWZvcmVbb3RoZXJJZF0pIHsgYnJlYWsgfVxuICAgICAgfVxuXG4gICAgICB0aGlzLmxpc3RlbmVyTWFwcy5zcGxpY2UoaW5kZXgsIDAsIHsgaWQ6IHBsdWdpbi5pZCwgbWFwOiBwbHVnaW4ubGlzdGVuZXJzIH0pXG4gICAgfVxuICAgIGVsc2UgaWYgKHBsdWdpbi5saXN0ZW5lcnMpIHtcbiAgICAgIHRoaXMubGlzdGVuZXJNYXBzLnB1c2goeyBpZDogcGx1Z2luLmlkLCBtYXA6IHBsdWdpbi5saXN0ZW5lcnMgfSlcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpc1xuICB9XG5cbiAgYWRkRG9jdW1lbnQgKGRvYzogRG9jdW1lbnQsIG9wdGlvbnM/OiBhbnkpOiB2b2lkIHwgZmFsc2Uge1xuICAgIC8vIGRvIG5vdGhpbmcgaWYgZG9jdW1lbnQgaXMgYWxyZWFkeSBrbm93blxuICAgIGlmICh0aGlzLmdldERvY0luZGV4KGRvYykgIT09IC0xKSB7IHJldHVybiBmYWxzZSB9XG5cbiAgICBjb25zdCB3aW5kb3cgPSB3aW4uZ2V0V2luZG93KGRvYylcblxuICAgIG9wdGlvbnMgPSBvcHRpb25zID8gdXRpbHMuZXh0ZW5kKHt9LCBvcHRpb25zKSA6IHt9XG5cbiAgICB0aGlzLmRvY3VtZW50cy5wdXNoKHsgZG9jLCBvcHRpb25zIH0pXG4gICAgZXZlbnRzLmRvY3VtZW50cy5wdXNoKGRvYylcblxuICAgIC8vIGRvbid0IGFkZCBhbiB1bmxvYWQgZXZlbnQgZm9yIHRoZSBtYWluIGRvY3VtZW50XG4gICAgLy8gc28gdGhhdCB0aGUgcGFnZSBtYXkgYmUgY2FjaGVkIGluIGJyb3dzZXIgaGlzdG9yeVxuICAgIGlmIChkb2MgIT09IHRoaXMuZG9jdW1lbnQpIHtcbiAgICAgIGV2ZW50cy5hZGQod2luZG93LCAndW5sb2FkJywgdGhpcy5vbldpbmRvd1VubG9hZClcbiAgICB9XG5cbiAgICB0aGlzLmZpcmUoJ3Njb3BlOmFkZC1kb2N1bWVudCcsIHsgZG9jLCB3aW5kb3csIHNjb3BlOiB0aGlzLCBvcHRpb25zIH0pXG4gIH1cblxuICByZW1vdmVEb2N1bWVudCAoZG9jOiBEb2N1bWVudCkge1xuICAgIGNvbnN0IGluZGV4ID0gdGhpcy5nZXREb2NJbmRleChkb2MpXG5cbiAgICBjb25zdCB3aW5kb3cgPSB3aW4uZ2V0V2luZG93KGRvYylcbiAgICBjb25zdCBvcHRpb25zID0gdGhpcy5kb2N1bWVudHNbaW5kZXhdLm9wdGlvbnNcblxuICAgIGV2ZW50cy5yZW1vdmUod2luZG93LCAndW5sb2FkJywgdGhpcy5vbldpbmRvd1VubG9hZClcblxuICAgIHRoaXMuZG9jdW1lbnRzLnNwbGljZShpbmRleCwgMSlcbiAgICBldmVudHMuZG9jdW1lbnRzLnNwbGljZShpbmRleCwgMSlcblxuICAgIHRoaXMuZmlyZSgnc2NvcGU6cmVtb3ZlLWRvY3VtZW50JywgeyBkb2MsIHdpbmRvdywgc2NvcGU6IHRoaXMsIG9wdGlvbnMgfSlcbiAgfVxuXG4gIGdldERvY0luZGV4IChkb2M6IERvY3VtZW50KSB7XG4gICAgZm9yIChsZXQgaSA9IDA7IGkgPCB0aGlzLmRvY3VtZW50cy5sZW5ndGg7IGkrKykge1xuICAgICAgaWYgKHRoaXMuZG9jdW1lbnRzW2ldLmRvYyA9PT0gZG9jKSB7XG4gICAgICAgIHJldHVybiBpXG4gICAgICB9XG4gICAgfVxuXG4gICAgcmV0dXJuIC0xXG4gIH1cblxuICBnZXREb2NPcHRpb25zIChkb2M6IERvY3VtZW50KSB7XG4gICAgY29uc3QgZG9jSW5kZXggPSB0aGlzLmdldERvY0luZGV4KGRvYylcblxuICAgIHJldHVybiBkb2NJbmRleCA9PT0gLTEgPyBudWxsIDogdGhpcy5kb2N1bWVudHNbZG9jSW5kZXhdLm9wdGlvbnNcbiAgfVxuXG4gIG5vdyAoKSB7XG4gICAgcmV0dXJuICgodGhpcy53aW5kb3cgYXMgYW55KS5EYXRlIGFzIHR5cGVvZiBEYXRlIHx8IERhdGUpLm5vdygpXG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzTm9uTmF0aXZlRXZlbnQgKHR5cGU6IHN0cmluZywgYWN0aW9uczogQWN0aW9ucykge1xuICBpZiAoYWN0aW9ucy5waGFzZWxlc3NUeXBlc1t0eXBlXSkgeyByZXR1cm4gdHJ1ZSB9XG5cbiAgZm9yIChjb25zdCBuYW1lIGluIGFjdGlvbnMubWFwKSB7XG4gICAgaWYgKHR5cGUuaW5kZXhPZihuYW1lKSA9PT0gMCAmJiB0eXBlLnN1YnN0cihuYW1lLmxlbmd0aCkgaW4gYWN0aW9ucy5waGFzZXMpIHtcbiAgICAgIHJldHVybiB0cnVlXG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIGZhbHNlXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpbml0U2NvcGUgKHNjb3BlOiBTY29wZSwgd2luZG93OiBXaW5kb3cpIHtcbiAgc2NvcGUuaXNJbml0aWFsaXplZCA9IHRydWVcbiAgd2luLmluaXQod2luZG93KVxuICBkb21PYmplY3RzLmluaXQod2luZG93KVxuICBicm93c2VyLmluaXQod2luZG93KVxuICByYWYuaW5pdCh3aW5kb3cpXG4gIGV2ZW50cy5pbml0KHdpbmRvdylcblxuICBzY29wZS51c2VQbHVnaW4oaW50ZXJhY3Rpb25zKVxuICBzY29wZS5kb2N1bWVudCA9IHdpbmRvdy5kb2N1bWVudFxuICBzY29wZS53aW5kb3cgPSB3aW5kb3dcblxuICByZXR1cm4gc2NvcGVcbn1cbiIsImltcG9ydCBicm93c2VyIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2Jyb3dzZXInXG5pbXBvcnQgZG9tT2JqZWN0cyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9kb21PYmplY3RzJ1xuaW1wb3J0IHsgbm9kZUNvbnRhaW5zIH0gZnJvbSAnQGludGVyYWN0anMvdXRpbHMvZG9tVXRpbHMnXG5pbXBvcnQgZXZlbnRzIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2V2ZW50cydcbmltcG9ydCAqIGFzIHBvaW50ZXJVdGlscyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9wb2ludGVyVXRpbHMnXG5pbXBvcnQgSW50ZXJhY3Rpb25CYXNlIGZyb20gJy4vSW50ZXJhY3Rpb24nXG5pbXBvcnQgZmluZGVyLCB7IFNlYXJjaERldGFpbHMgfSBmcm9tICcuL2ludGVyYWN0aW9uRmluZGVyJ1xuaW1wb3J0IHsgU2NvcGUgfSBmcm9tICcuL3Njb3BlJ1xuaW1wb3J0IGludGVyYWN0YWJsZVByZXZlbnREZWZhdWx0IGZyb20gJy4vaW50ZXJhY3RhYmxlUHJldmVudERlZmF1bHQnXG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL3Njb3BlJyB7XG4gIGludGVyZmFjZSBTY29wZSB7XG4gICAgSW50ZXJhY3Rpb246IHR5cGVvZiBJbnRlcmFjdGlvbkJhc2VcbiAgICBpbnRlcmFjdGlvbnM6IHtcbiAgICAgIG5ldzogPFQgZXh0ZW5kcyBBY3Rpb25OYW1lPiAob3B0aW9uczogYW55KSA9PiBJbnRlcmFjdGlvbkJhc2U8VD5cbiAgICAgIGxpc3Q6IEludGVyYWN0aW9uQmFzZVtdXG4gICAgICBsaXN0ZW5lcnM6IHsgW3R5cGU6IHN0cmluZ106IEludGVyYWN0Lkxpc3RlbmVyIH1cbiAgICAgIGRvY0V2ZW50czogQXJyYXk8eyB0eXBlOiBzdHJpbmcsIGxpc3RlbmVyOiBJbnRlcmFjdC5MaXN0ZW5lciB9PlxuICAgICAgcG9pbnRlck1vdmVUb2xlcmFuY2U6IG51bWJlclxuICAgIH1cbiAgICBwcmV2VG91Y2hUaW1lOiBudW1iZXJcbiAgfVxufVxuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvY29yZS9zY29wZScge1xuICBpbnRlcmZhY2UgU2lnbmFsQXJncyB7XG4gICAgJ2ludGVyYWN0aW9uczpmaW5kJzoge1xuICAgICAgaW50ZXJhY3Rpb246IEludGVyYWN0aW9uQmFzZVxuICAgICAgc2VhcmNoRGV0YWlsczogU2VhcmNoRGV0YWlsc1xuICAgIH1cbiAgfVxufVxuXG5jb25zdCBtZXRob2ROYW1lcyA9IFtcbiAgJ3BvaW50ZXJEb3duJywgJ3BvaW50ZXJNb3ZlJywgJ3BvaW50ZXJVcCcsXG4gICd1cGRhdGVQb2ludGVyJywgJ3JlbW92ZVBvaW50ZXInLCAnd2luZG93Qmx1cicsXG5dXG5cbmZ1bmN0aW9uIGluc3RhbGwgKHNjb3BlOiBTY29wZSkge1xuICBjb25zdCBsaXN0ZW5lcnMgPSB7fSBhcyBhbnlcblxuICBmb3IgKGNvbnN0IG1ldGhvZCBvZiBtZXRob2ROYW1lcykge1xuICAgIGxpc3RlbmVyc1ttZXRob2RdID0gZG9PbkludGVyYWN0aW9ucyhtZXRob2QsIHNjb3BlKVxuICB9XG5cbiAgY29uc3QgcEV2ZW50VHlwZXMgPSBicm93c2VyLnBFdmVudFR5cGVzXG4gIGxldCBkb2NFdmVudHM6IHR5cGVvZiBzY29wZS5pbnRlcmFjdGlvbnMuZG9jRXZlbnRzXG5cbiAgaWYgKGRvbU9iamVjdHMuUG9pbnRlckV2ZW50KSB7XG4gICAgZG9jRXZlbnRzID0gW1xuICAgICAgeyB0eXBlOiBwRXZlbnRUeXBlcy5kb3duLCAgIGxpc3RlbmVyOiByZWxlYXNlUG9pbnRlcnNPblJlbW92ZWRFbHMgfSxcbiAgICAgIHsgdHlwZTogcEV2ZW50VHlwZXMuZG93biwgICBsaXN0ZW5lcjogbGlzdGVuZXJzLnBvaW50ZXJEb3duIH0sXG4gICAgICB7IHR5cGU6IHBFdmVudFR5cGVzLm1vdmUsICAgbGlzdGVuZXI6IGxpc3RlbmVycy5wb2ludGVyTW92ZSB9LFxuICAgICAgeyB0eXBlOiBwRXZlbnRUeXBlcy51cCwgICAgIGxpc3RlbmVyOiBsaXN0ZW5lcnMucG9pbnRlclVwIH0sXG4gICAgICB7IHR5cGU6IHBFdmVudFR5cGVzLmNhbmNlbCwgbGlzdGVuZXI6IGxpc3RlbmVycy5wb2ludGVyVXAgfSxcbiAgICBdXG4gIH1cbiAgZWxzZSB7XG4gICAgZG9jRXZlbnRzID0gW1xuICAgICAgeyB0eXBlOiAnbW91c2Vkb3duJywgbGlzdGVuZXI6IGxpc3RlbmVycy5wb2ludGVyRG93biB9LFxuICAgICAgeyB0eXBlOiAnbW91c2Vtb3ZlJywgbGlzdGVuZXI6IGxpc3RlbmVycy5wb2ludGVyTW92ZSB9LFxuICAgICAgeyB0eXBlOiAnbW91c2V1cCcsIGxpc3RlbmVyOiBsaXN0ZW5lcnMucG9pbnRlclVwIH0sXG5cbiAgICAgIHsgdHlwZTogJ3RvdWNoc3RhcnQnLCBsaXN0ZW5lcjogcmVsZWFzZVBvaW50ZXJzT25SZW1vdmVkRWxzIH0sXG4gICAgICB7IHR5cGU6ICd0b3VjaHN0YXJ0JywgbGlzdGVuZXI6IGxpc3RlbmVycy5wb2ludGVyRG93biB9LFxuICAgICAgeyB0eXBlOiAndG91Y2htb3ZlJywgbGlzdGVuZXI6IGxpc3RlbmVycy5wb2ludGVyTW92ZSB9LFxuICAgICAgeyB0eXBlOiAndG91Y2hlbmQnLCBsaXN0ZW5lcjogbGlzdGVuZXJzLnBvaW50ZXJVcCB9LFxuICAgICAgeyB0eXBlOiAndG91Y2hjYW5jZWwnLCBsaXN0ZW5lcjogbGlzdGVuZXJzLnBvaW50ZXJVcCB9LFxuICAgIF1cbiAgfVxuXG4gIGRvY0V2ZW50cy5wdXNoKHtcbiAgICB0eXBlOiAnYmx1cicsXG4gICAgbGlzdGVuZXIgKGV2ZW50KSB7XG4gICAgICBmb3IgKGNvbnN0IGludGVyYWN0aW9uIG9mIHNjb3BlLmludGVyYWN0aW9ucy5saXN0KSB7XG4gICAgICAgIGludGVyYWN0aW9uLmRvY3VtZW50Qmx1cihldmVudClcbiAgICAgIH1cbiAgICB9LFxuICB9KVxuXG4gIC8vIGZvciBpZ25vcmluZyBicm93c2VyJ3Mgc2ltdWxhdGVkIG1vdXNlIGV2ZW50c1xuICBzY29wZS5wcmV2VG91Y2hUaW1lID0gMFxuXG4gIHNjb3BlLkludGVyYWN0aW9uID0gY2xhc3MgPFQgZXh0ZW5kcyBJbnRlcmFjdC5BY3Rpb25OYW1lPiBleHRlbmRzIEludGVyYWN0aW9uQmFzZTxUPiB7XG4gICAgZ2V0IHBvaW50ZXJNb3ZlVG9sZXJhbmNlICgpIHtcbiAgICAgIHJldHVybiBzY29wZS5pbnRlcmFjdGlvbnMucG9pbnRlck1vdmVUb2xlcmFuY2VcbiAgICB9XG5cbiAgICBzZXQgcG9pbnRlck1vdmVUb2xlcmFuY2UgKHZhbHVlKSB7XG4gICAgICBzY29wZS5pbnRlcmFjdGlvbnMucG9pbnRlck1vdmVUb2xlcmFuY2UgPSB2YWx1ZVxuICAgIH1cblxuICAgIF9ub3cgKCkgeyByZXR1cm4gc2NvcGUubm93KCkgfVxuICB9XG5cbiAgc2NvcGUuaW50ZXJhY3Rpb25zID0ge1xuICAgIC8vIGFsbCBhY3RpdmUgYW5kIGlkbGUgaW50ZXJhY3Rpb25zXG4gICAgbGlzdDogW10sXG4gICAgbmV3PFQgZXh0ZW5kcyBJbnRlcmFjdC5BY3Rpb25OYW1lPiAob3B0aW9uczogeyBwb2ludGVyVHlwZT86IHN0cmluZywgc2NvcGVGaXJlPzogU2NvcGVbJ2ZpcmUnXSB9KSB7XG4gICAgICBvcHRpb25zLnNjb3BlRmlyZSA9IChuYW1lLCBhcmcpID0+IHNjb3BlLmZpcmUobmFtZSwgYXJnKVxuXG4gICAgICBjb25zdCBpbnRlcmFjdGlvbiA9IG5ldyBzY29wZS5JbnRlcmFjdGlvbjxUPihvcHRpb25zIGFzIFJlcXVpcmVkPHR5cGVvZiBvcHRpb25zPilcblxuICAgICAgc2NvcGUuaW50ZXJhY3Rpb25zLmxpc3QucHVzaChpbnRlcmFjdGlvbilcbiAgICAgIHJldHVybiBpbnRlcmFjdGlvblxuICAgIH0sXG4gICAgbGlzdGVuZXJzLFxuICAgIGRvY0V2ZW50cyxcbiAgICBwb2ludGVyTW92ZVRvbGVyYW5jZTogMSxcbiAgfVxuXG4gIGZ1bmN0aW9uIHJlbGVhc2VQb2ludGVyc09uUmVtb3ZlZEVscyAoKSB7XG4gICAgLy8gZm9yIGFsbCBpbmFjdGl2ZSB0b3VjaCBpbnRlcmFjdGlvbnMgd2l0aCBwb2ludGVycyBkb3duXG4gICAgZm9yIChjb25zdCBpbnRlcmFjdGlvbiBvZiBzY29wZS5pbnRlcmFjdGlvbnMubGlzdCkge1xuICAgICAgaWYgKCFpbnRlcmFjdGlvbi5wb2ludGVySXNEb3duIHx8XG4gICAgICAgIGludGVyYWN0aW9uLnBvaW50ZXJUeXBlICE9PSAndG91Y2gnIHx8XG4gICAgICAgIGludGVyYWN0aW9uLl9pbnRlcmFjdGluZykge1xuICAgICAgICBjb250aW51ZVxuICAgICAgfVxuXG4gICAgICAvLyBpZiBhIHBvaW50ZXIgaXMgZG93biBvbiBhbiBlbGVtZW50IHRoYXQgaXMgbm8gbG9uZ2VyIGluIHRoZSBET00gdHJlZVxuICAgICAgZm9yIChjb25zdCBwb2ludGVyIG9mIGludGVyYWN0aW9uLnBvaW50ZXJzKSB7XG4gICAgICAgIGlmICghc2NvcGUuZG9jdW1lbnRzLnNvbWUoKHsgZG9jIH0pID0+IG5vZGVDb250YWlucyhkb2MsIHBvaW50ZXIuZG93blRhcmdldCkpKSB7XG4gICAgICAgICAgLy8gcmVtb3ZlIHRoZSBwb2ludGVyIGZyb20gdGhlIGludGVyYWN0aW9uXG4gICAgICAgICAgaW50ZXJhY3Rpb24ucmVtb3ZlUG9pbnRlcihwb2ludGVyLnBvaW50ZXIsIHBvaW50ZXIuZXZlbnQpXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICBzY29wZS51c2VQbHVnaW4oaW50ZXJhY3RhYmxlUHJldmVudERlZmF1bHQpXG59XG5cbmZ1bmN0aW9uIGRvT25JbnRlcmFjdGlvbnMgKG1ldGhvZCwgc2NvcGUpIHtcbiAgcmV0dXJuIGZ1bmN0aW9uIChldmVudCkge1xuICAgIGNvbnN0IGludGVyYWN0aW9ucyA9IHNjb3BlLmludGVyYWN0aW9ucy5saXN0XG5cbiAgICBjb25zdCBwb2ludGVyVHlwZSA9IHBvaW50ZXJVdGlscy5nZXRQb2ludGVyVHlwZShldmVudClcbiAgICBjb25zdCBbZXZlbnRUYXJnZXQsIGN1ckV2ZW50VGFyZ2V0XSA9IHBvaW50ZXJVdGlscy5nZXRFdmVudFRhcmdldHMoZXZlbnQpXG4gICAgY29uc3QgbWF0Y2hlcyA9IFtdIC8vIFsgW3BvaW50ZXIsIGludGVyYWN0aW9uXSwgLi4uXVxuXG4gICAgaWYgKC9edG91Y2gvLnRlc3QoZXZlbnQudHlwZSkpIHtcbiAgICAgIHNjb3BlLnByZXZUb3VjaFRpbWUgPSBzY29wZS5ub3coKVxuXG4gICAgICBmb3IgKGNvbnN0IGNoYW5nZWRUb3VjaCBvZiBldmVudC5jaGFuZ2VkVG91Y2hlcykge1xuICAgICAgICBjb25zdCBwb2ludGVyID0gY2hhbmdlZFRvdWNoXG4gICAgICAgIGNvbnN0IHBvaW50ZXJJZCA9IHBvaW50ZXJVdGlscy5nZXRQb2ludGVySWQocG9pbnRlcilcbiAgICAgICAgY29uc3Qgc2VhcmNoRGV0YWlsczogU2VhcmNoRGV0YWlscyA9IHtcbiAgICAgICAgICBwb2ludGVyLFxuICAgICAgICAgIHBvaW50ZXJJZCxcbiAgICAgICAgICBwb2ludGVyVHlwZSxcbiAgICAgICAgICBldmVudFR5cGU6IGV2ZW50LnR5cGUsXG4gICAgICAgICAgZXZlbnRUYXJnZXQsXG4gICAgICAgICAgY3VyRXZlbnRUYXJnZXQsXG4gICAgICAgICAgc2NvcGUsXG4gICAgICAgIH1cbiAgICAgICAgY29uc3QgaW50ZXJhY3Rpb24gPSBnZXRJbnRlcmFjdGlvbihzZWFyY2hEZXRhaWxzKVxuXG4gICAgICAgIG1hdGNoZXMucHVzaChbXG4gICAgICAgICAgc2VhcmNoRGV0YWlscy5wb2ludGVyLFxuICAgICAgICAgIHNlYXJjaERldGFpbHMuZXZlbnRUYXJnZXQsXG4gICAgICAgICAgc2VhcmNoRGV0YWlscy5jdXJFdmVudFRhcmdldCxcbiAgICAgICAgICBpbnRlcmFjdGlvbixcbiAgICAgICAgXSlcbiAgICAgIH1cbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICBsZXQgaW52YWxpZFBvaW50ZXIgPSBmYWxzZVxuXG4gICAgICBpZiAoIWJyb3dzZXIuc3VwcG9ydHNQb2ludGVyRXZlbnQgJiYgL21vdXNlLy50ZXN0KGV2ZW50LnR5cGUpKSB7XG4gICAgICAgIC8vIGlnbm9yZSBtb3VzZSBldmVudHMgd2hpbGUgdG91Y2ggaW50ZXJhY3Rpb25zIGFyZSBhY3RpdmVcbiAgICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCBpbnRlcmFjdGlvbnMubGVuZ3RoICYmICFpbnZhbGlkUG9pbnRlcjsgaSsrKSB7XG4gICAgICAgICAgaW52YWxpZFBvaW50ZXIgPSBpbnRlcmFjdGlvbnNbaV0ucG9pbnRlclR5cGUgIT09ICdtb3VzZScgJiYgaW50ZXJhY3Rpb25zW2ldLnBvaW50ZXJJc0Rvd25cbiAgICAgICAgfVxuXG4gICAgICAgIC8vIHRyeSB0byBpZ25vcmUgbW91c2UgZXZlbnRzIHRoYXQgYXJlIHNpbXVsYXRlZCBieSB0aGUgYnJvd3NlclxuICAgICAgICAvLyBhZnRlciBhIHRvdWNoIGV2ZW50XG4gICAgICAgIGludmFsaWRQb2ludGVyID0gaW52YWxpZFBvaW50ZXIgfHxcbiAgICAgICAgICAoc2NvcGUubm93KCkgLSBzY29wZS5wcmV2VG91Y2hUaW1lIDwgNTAwKSB8fFxuICAgICAgICAgIC8vIG9uIGlPUyBhbmQgRmlyZWZveCBNb2JpbGUsIE1vdXNlRXZlbnQudGltZVN0YW1wIGlzIHplcm8gaWYgc2ltdWxhdGVkXG4gICAgICAgICAgZXZlbnQudGltZVN0YW1wID09PSAwXG4gICAgICB9XG5cbiAgICAgIGlmICghaW52YWxpZFBvaW50ZXIpIHtcbiAgICAgICAgY29uc3Qgc2VhcmNoRGV0YWlscyA9IHtcbiAgICAgICAgICBwb2ludGVyOiBldmVudCxcbiAgICAgICAgICBwb2ludGVySWQ6IHBvaW50ZXJVdGlscy5nZXRQb2ludGVySWQoZXZlbnQpLFxuICAgICAgICAgIHBvaW50ZXJUeXBlLFxuICAgICAgICAgIGV2ZW50VHlwZTogZXZlbnQudHlwZSxcbiAgICAgICAgICBjdXJFdmVudFRhcmdldCxcbiAgICAgICAgICBldmVudFRhcmdldCxcbiAgICAgICAgICBzY29wZSxcbiAgICAgICAgfVxuXG4gICAgICAgIGNvbnN0IGludGVyYWN0aW9uID0gZ2V0SW50ZXJhY3Rpb24oc2VhcmNoRGV0YWlscylcblxuICAgICAgICBtYXRjaGVzLnB1c2goW1xuICAgICAgICAgIHNlYXJjaERldGFpbHMucG9pbnRlcixcbiAgICAgICAgICBzZWFyY2hEZXRhaWxzLmV2ZW50VGFyZ2V0LFxuICAgICAgICAgIHNlYXJjaERldGFpbHMuY3VyRXZlbnRUYXJnZXQsXG4gICAgICAgICAgaW50ZXJhY3Rpb24sXG4gICAgICAgIF0pXG4gICAgICB9XG4gICAgfVxuXG4gICAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLXNoYWRvd1xuICAgIGZvciAoY29uc3QgW3BvaW50ZXIsIGV2ZW50VGFyZ2V0LCBjdXJFdmVudFRhcmdldCwgaW50ZXJhY3Rpb25dIG9mIG1hdGNoZXMpIHtcbiAgICAgIGludGVyYWN0aW9uW21ldGhvZF0ocG9pbnRlciwgZXZlbnQsIGV2ZW50VGFyZ2V0LCBjdXJFdmVudFRhcmdldClcbiAgICB9XG4gIH1cbn1cblxuZnVuY3Rpb24gZ2V0SW50ZXJhY3Rpb24gKHNlYXJjaERldGFpbHM6IFNlYXJjaERldGFpbHMpIHtcbiAgY29uc3QgeyBwb2ludGVyVHlwZSwgc2NvcGUgfSA9IHNlYXJjaERldGFpbHNcblxuICBjb25zdCBmb3VuZEludGVyYWN0aW9uID0gZmluZGVyLnNlYXJjaChzZWFyY2hEZXRhaWxzKVxuICBjb25zdCBzaWduYWxBcmcgPSB7IGludGVyYWN0aW9uOiBmb3VuZEludGVyYWN0aW9uLCBzZWFyY2hEZXRhaWxzIH1cblxuICBzY29wZS5maXJlKCdpbnRlcmFjdGlvbnM6ZmluZCcsIHNpZ25hbEFyZylcblxuICByZXR1cm4gc2lnbmFsQXJnLmludGVyYWN0aW9uIHx8IHNjb3BlLmludGVyYWN0aW9ucy5uZXcoeyBwb2ludGVyVHlwZSB9KVxufVxuXG5mdW5jdGlvbiBvbkRvY1NpZ25hbDxUIGV4dGVuZHMgJ3Njb3BlOmFkZC1kb2N1bWVudCcgfCAnc2NvcGU6cmVtb3ZlLWRvY3VtZW50Jz4gKHsgZG9jLCBzY29wZSwgb3B0aW9ucyB9OiBJbnRlcmFjdC5TaWduYWxBcmdzW1RdLCBldmVudE1ldGhvZE5hbWU6ICdhZGQnIHwgJ3JlbW92ZScpIHtcbiAgY29uc3QgeyBkb2NFdmVudHMgfSA9IHNjb3BlLmludGVyYWN0aW9uc1xuICBjb25zdCBldmVudE1ldGhvZCA9IGV2ZW50c1tldmVudE1ldGhvZE5hbWVdXG5cbiAgaWYgKHNjb3BlLmJyb3dzZXIuaXNJT1MgJiYgIW9wdGlvbnMuZXZlbnRzKSB7XG4gICAgb3B0aW9ucy5ldmVudHMgPSB7IHBhc3NpdmU6IGZhbHNlIH1cbiAgfVxuXG4gIC8vIGRlbGVnYXRlIGV2ZW50IGxpc3RlbmVyXG4gIGZvciAoY29uc3QgZXZlbnRUeXBlIGluIGV2ZW50cy5kZWxlZ2F0ZWRFdmVudHMpIHtcbiAgICBldmVudE1ldGhvZChkb2MsIGV2ZW50VHlwZSwgZXZlbnRzLmRlbGVnYXRlTGlzdGVuZXIpXG4gICAgZXZlbnRNZXRob2QoZG9jLCBldmVudFR5cGUsIGV2ZW50cy5kZWxlZ2F0ZVVzZUNhcHR1cmUsIHRydWUpXG4gIH1cblxuICBjb25zdCBldmVudE9wdGlvbnMgPSBvcHRpb25zICYmIG9wdGlvbnMuZXZlbnRzXG5cbiAgZm9yIChjb25zdCB7IHR5cGUsIGxpc3RlbmVyIH0gb2YgZG9jRXZlbnRzKSB7XG4gICAgZXZlbnRNZXRob2QoZG9jLCB0eXBlLCBsaXN0ZW5lciwgZXZlbnRPcHRpb25zKVxuICB9XG59XG5cbmNvbnN0IGludGVyYWN0aW9uczogSW50ZXJhY3QuUGx1Z2luID0ge1xuICBpZDogJ2NvcmUvaW50ZXJhY3Rpb25zJyxcbiAgaW5zdGFsbCxcbiAgbGlzdGVuZXJzOiB7XG4gICAgJ3Njb3BlOmFkZC1kb2N1bWVudCc6IGFyZyA9PiBvbkRvY1NpZ25hbChhcmcsICdhZGQnKSxcbiAgICAnc2NvcGU6cmVtb3ZlLWRvY3VtZW50JzogYXJnID0+IG9uRG9jU2lnbmFsKGFyZywgJ3JlbW92ZScpLFxuICAgICdpbnRlcmFjdGFibGU6dW5zZXQnOiAoeyBpbnRlcmFjdGFibGUgfSwgc2NvcGUpID0+IHtcbiAgICAgIC8vIFN0b3AgYW5kIGRlc3Ryb3kgcmVsYXRlZCBpbnRlcmFjdGlvbnMgd2hlbiBhbiBJbnRlcmFjdGFibGUgaXMgdW5zZXRcbiAgICAgIGZvciAobGV0IGkgPSBzY29wZS5pbnRlcmFjdGlvbnMubGlzdC5sZW5ndGggLSAxOyBpID49IDA7IGktLSkge1xuICAgICAgICBjb25zdCBpbnRlcmFjdGlvbiA9IHNjb3BlLmludGVyYWN0aW9ucy5saXN0W2ldXG5cbiAgICAgICAgaWYgKGludGVyYWN0aW9uLmludGVyYWN0YWJsZSAhPT0gaW50ZXJhY3RhYmxlKSB7IGNvbnRpbnVlIH1cblxuICAgICAgICBpbnRlcmFjdGlvbi5zdG9wKClcbiAgICAgICAgc2NvcGUuZmlyZSgnaW50ZXJhY3Rpb25zOmRlc3Ryb3knLCB7IGludGVyYWN0aW9uIH0pXG4gICAgICAgIGludGVyYWN0aW9uLmRlc3Ryb3koKVxuXG4gICAgICAgIGlmIChzY29wZS5pbnRlcmFjdGlvbnMubGlzdC5sZW5ndGggPiAyKSB7XG4gICAgICAgICAgc2NvcGUuaW50ZXJhY3Rpb25zLmxpc3Quc3BsaWNlKGksIDEpXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9LFxuICB9LFxuICBvbkRvY1NpZ25hbCxcbiAgZG9PbkludGVyYWN0aW9ucyxcbiAgbWV0aG9kTmFtZXMsXG59XG5cbmV4cG9ydCBkZWZhdWx0IGludGVyYWN0aW9uc1xuIiwiLy8vIDxyZWZlcmVuY2UgcGF0aD1cIi4vdHlwZXMuZC50c1wiIC8+XG4iLCJleHBvcnQgZGVmYXVsdCAodGhpbmc6IGFueSkgPT4gISEodGhpbmcgJiYgdGhpbmcuV2luZG93KSAmJiAodGhpbmcgaW5zdGFuY2VvZiB0aGluZy5XaW5kb3cpXG4iLCJpbXBvcnQgaXNXaW5kb3cgZnJvbSAnLi9pc1dpbmRvdydcblxuY29uc3Qgd2luID0ge1xuICByZWFsV2luZG93OiB1bmRlZmluZWQgYXMgV2luZG93LFxuICB3aW5kb3c6IHVuZGVmaW5lZCBhcyBXaW5kb3csXG4gIGdldFdpbmRvdyxcbiAgaW5pdCxcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGluaXQgKHdpbmRvdzogV2luZG93ICYgeyB3cmFwPzogKC4uLmFyZ3M6IGFueVtdKSA9PiBhbnkgfSkge1xuICAvLyBnZXQgd3JhcHBlZCB3aW5kb3cgaWYgdXNpbmcgU2hhZG93IERPTSBwb2x5ZmlsbFxuXG4gIHdpbi5yZWFsV2luZG93ID0gd2luZG93XG5cbiAgLy8gY3JlYXRlIGEgVGV4dE5vZGVcbiAgY29uc3QgZWwgPSB3aW5kb3cuZG9jdW1lbnQuY3JlYXRlVGV4dE5vZGUoJycpXG5cbiAgLy8gY2hlY2sgaWYgaXQncyB3cmFwcGVkIGJ5IGEgcG9seWZpbGxcbiAgaWYgKGVsLm93bmVyRG9jdW1lbnQgIT09IHdpbmRvdy5kb2N1bWVudCAmJlxuICAgICAgdHlwZW9mIHdpbmRvdy53cmFwID09PSAnZnVuY3Rpb24nICYmXG4gICAgd2luZG93LndyYXAoZWwpID09PSBlbCkge1xuICAgIC8vIHVzZSB3cmFwcGVkIHdpbmRvd1xuICAgIHdpbmRvdyA9IHdpbmRvdy53cmFwKHdpbmRvdylcbiAgfVxuXG4gIHdpbi53aW5kb3cgPSB3aW5kb3dcbn1cblxuaWYgKHR5cGVvZiB3aW5kb3cgPT09ICd1bmRlZmluZWQnKSB7XG4gIHdpbi53aW5kb3cgICAgID0gdW5kZWZpbmVkXG4gIHdpbi5yZWFsV2luZG93ID0gdW5kZWZpbmVkXG59XG5lbHNlIHtcbiAgaW5pdCh3aW5kb3cpXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRXaW5kb3cgKG5vZGU6IGFueSkge1xuICBpZiAoaXNXaW5kb3cobm9kZSkpIHtcbiAgICByZXR1cm4gbm9kZVxuICB9XG5cbiAgY29uc3Qgcm9vdE5vZGUgPSAobm9kZS5vd25lckRvY3VtZW50IHx8IG5vZGUpXG5cbiAgcmV0dXJuIHJvb3ROb2RlLmRlZmF1bHRWaWV3IHx8IHdpbi53aW5kb3dcbn1cblxud2luLmluaXQgPSBpbml0XG5cbmV4cG9ydCBkZWZhdWx0IHdpblxuIiwiLy8gdHNsaW50OmRpc2FibGUgdmFyaWFibGUtbmFtZVxuXG5pbXBvcnQgaXNXaW5kb3cgZnJvbSAnLi9pc1dpbmRvdydcbmltcG9ydCB3aW4gZnJvbSAnLi93aW5kb3cnXG5cbmV4cG9ydCBjb25zdCB3aW5kb3cgPSAodGhpbmc6IGFueSk6IHRoaW5nIGlzIFdpbmRvdyA9PlxuICB0aGluZyA9PT0gd2luLndpbmRvdyB8fCBpc1dpbmRvdyh0aGluZylcblxuZXhwb3J0IGNvbnN0IGRvY0ZyYWcgPSAodGhpbmc6IGFueSk6IHRoaW5nIGlzIERvY3VtZW50RnJhZ21lbnQgPT5cbiAgb2JqZWN0KHRoaW5nKSAmJiB0aGluZy5ub2RlVHlwZSA9PT0gMTFcblxuZXhwb3J0IGNvbnN0IG9iamVjdCA9ICh0aGluZzogYW55KTogdGhpbmcgaXMgeyBbaW5kZXg6IHN0cmluZ106IGFueSB9ID0+XG4gICEhdGhpbmcgJiYgKHR5cGVvZiB0aGluZyA9PT0gJ29iamVjdCcpXG5cbmV4cG9ydCBjb25zdCBmdW5jID0gKHRoaW5nOiBhbnkpOiB0aGluZyBpcyAoLi4uYXJnczogYW55W10pID0+IGFueSA9PlxuICB0eXBlb2YgdGhpbmcgPT09ICdmdW5jdGlvbidcblxuZXhwb3J0IGNvbnN0IG51bWJlciA9ICh0aGluZzogYW55KTogdGhpbmcgaXMgbnVtYmVyID0+XG4gIHR5cGVvZiB0aGluZyA9PT0gJ251bWJlcidcblxuZXhwb3J0IGNvbnN0IGJvb2wgPSAodGhpbmc6IGFueSk6IHRoaW5nIGlzIGJvb2xlYW4gPT5cbiAgdHlwZW9mIHRoaW5nID09PSAnYm9vbGVhbidcblxuZXhwb3J0IGNvbnN0IHN0cmluZyA9ICh0aGluZzogYW55KTogdGhpbmcgaXMgc3RyaW5nID0+XG4gIHR5cGVvZiB0aGluZyA9PT0gJ3N0cmluZydcblxuZXhwb3J0IGNvbnN0IGVsZW1lbnQgPSAodGhpbmc6IGFueSk6IHRoaW5nIGlzIEludGVyYWN0LkVsZW1lbnQgPT4ge1xuICBpZiAoIXRoaW5nIHx8ICh0eXBlb2YgdGhpbmcgIT09ICdvYmplY3QnKSkgeyByZXR1cm4gZmFsc2UgfVxuXG4gIGNvbnN0IF93aW5kb3cgPSB3aW4uZ2V0V2luZG93KHRoaW5nKSB8fCB3aW4ud2luZG93XG5cbiAgcmV0dXJuICgvb2JqZWN0fGZ1bmN0aW9uLy50ZXN0KHR5cGVvZiBfd2luZG93LkVsZW1lbnQpXG4gICAgPyB0aGluZyBpbnN0YW5jZW9mIF93aW5kb3cuRWxlbWVudCAvLyBET00yXG4gICAgOiB0aGluZy5ub2RlVHlwZSA9PT0gMSAmJiB0eXBlb2YgdGhpbmcubm9kZU5hbWUgPT09ICdzdHJpbmcnKVxufVxuXG5leHBvcnQgY29uc3QgcGxhaW5PYmplY3Q6IHR5cGVvZiBvYmplY3QgPSAodGhpbmc6IGFueSk6IHRoaW5nIGlzIHsgW2luZGV4OiBzdHJpbmddOiBhbnkgfSA9PlxuICBvYmplY3QodGhpbmcpICYmXG4gICEhdGhpbmcuY29uc3RydWN0b3IgJiZcbiAgL2Z1bmN0aW9uIE9iamVjdFxcYi8udGVzdCh0aGluZy5jb25zdHJ1Y3Rvci50b1N0cmluZygpKVxuXG5leHBvcnQgY29uc3QgYXJyYXkgPSA8VCBleHRlbmRzIHVua25vd24+KHRoaW5nOiBhbnkpOiB0aGluZyBpcyBUW10gPT5cbiAgKG9iamVjdCh0aGluZykgJiZcbiAgKHR5cGVvZiB0aGluZy5sZW5ndGggIT09ICd1bmRlZmluZWQnKSAmJlxuICBmdW5jKHRoaW5nLnNwbGljZSkpXG4iLCJpbXBvcnQgeyBTY29wZSB9IGZyb20gJ0BpbnRlcmFjdGpzL2NvcmUvc2NvcGUnXG5pbXBvcnQgKiBhcyBpcyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9pcydcblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3RhYmxlJyB7XG4gIGludGVyZmFjZSBJbnRlcmFjdGFibGUge1xuICAgIGRyYWdnYWJsZTogRHJhZ2dhYmxlTWV0aG9kXG4gIH1cbn1cblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvZGVmYXVsdE9wdGlvbnMnIHtcbiAgaW50ZXJmYWNlIEFjdGlvbkRlZmF1bHRzIHtcbiAgICBkcmFnOiBJbnRlcmFjdC5EcmFnZ2FibGVPcHRpb25zXG4gIH1cbn1cblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvc2NvcGUnIHtcbiAgaW50ZXJmYWNlIEFjdGlvbk1hcCB7XG4gICAgZHJhZz86IHR5cGVvZiBkcmFnXG4gIH1cbn1cblxuZXhwb3J0IHR5cGUgRHJhZ0V2ZW50ID0gSW50ZXJhY3QuSW50ZXJhY3RFdmVudDwnZHJhZyc+XG5cbmV4cG9ydCB0eXBlIERyYWdnYWJsZU1ldGhvZCA9IEludGVyYWN0LkFjdGlvbk1ldGhvZDxJbnRlcmFjdC5EcmFnZ2FibGVPcHRpb25zPlxuXG5mdW5jdGlvbiBpbnN0YWxsIChzY29wZTogU2NvcGUpIHtcbiAgY29uc3Qge1xuICAgIGFjdGlvbnMsXG4gICAgSW50ZXJhY3RhYmxlLFxuICAgIGRlZmF1bHRzLFxuICB9ID0gc2NvcGVcblxuICBJbnRlcmFjdGFibGUucHJvdG90eXBlLmRyYWdnYWJsZSA9IGRyYWcuZHJhZ2dhYmxlXG5cbiAgYWN0aW9ucy5tYXAuZHJhZyA9IGRyYWdcbiAgYWN0aW9ucy5tZXRob2REaWN0LmRyYWcgPSAnZHJhZ2dhYmxlJ1xuXG4gIGRlZmF1bHRzLmFjdGlvbnMuZHJhZyA9IGRyYWcuZGVmYXVsdHNcbn1cblxuZnVuY3Rpb24gYmVmb3JlTW92ZSAoeyBpbnRlcmFjdGlvbiB9KSB7XG4gIGlmIChpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lICE9PSAnZHJhZycpIHsgcmV0dXJuIH1cblxuICBjb25zdCBheGlzID0gaW50ZXJhY3Rpb24ucHJlcGFyZWQuYXhpc1xuXG4gIGlmIChheGlzID09PSAneCcpIHtcbiAgICBpbnRlcmFjdGlvbi5jb29yZHMuY3VyLnBhZ2UueSAgID0gaW50ZXJhY3Rpb24uY29vcmRzLnN0YXJ0LnBhZ2UueVxuICAgIGludGVyYWN0aW9uLmNvb3Jkcy5jdXIuY2xpZW50LnkgPSBpbnRlcmFjdGlvbi5jb29yZHMuc3RhcnQuY2xpZW50LnlcblxuICAgIGludGVyYWN0aW9uLmNvb3Jkcy52ZWxvY2l0eS5jbGllbnQueSA9IDBcbiAgICBpbnRlcmFjdGlvbi5jb29yZHMudmVsb2NpdHkucGFnZS55ICAgPSAwXG4gIH1cbiAgZWxzZSBpZiAoYXhpcyA9PT0gJ3knKSB7XG4gICAgaW50ZXJhY3Rpb24uY29vcmRzLmN1ci5wYWdlLnggICA9IGludGVyYWN0aW9uLmNvb3Jkcy5zdGFydC5wYWdlLnhcbiAgICBpbnRlcmFjdGlvbi5jb29yZHMuY3VyLmNsaWVudC54ID0gaW50ZXJhY3Rpb24uY29vcmRzLnN0YXJ0LmNsaWVudC54XG5cbiAgICBpbnRlcmFjdGlvbi5jb29yZHMudmVsb2NpdHkuY2xpZW50LnggPSAwXG4gICAgaW50ZXJhY3Rpb24uY29vcmRzLnZlbG9jaXR5LnBhZ2UueCAgID0gMFxuICB9XG59XG5cbmZ1bmN0aW9uIG1vdmUgKHsgaUV2ZW50LCBpbnRlcmFjdGlvbiB9KSB7XG4gIGlmIChpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lICE9PSAnZHJhZycpIHsgcmV0dXJuIH1cblxuICBjb25zdCBheGlzID0gaW50ZXJhY3Rpb24ucHJlcGFyZWQuYXhpc1xuXG4gIGlmIChheGlzID09PSAneCcgfHwgYXhpcyA9PT0gJ3knKSB7XG4gICAgY29uc3Qgb3Bwb3NpdGUgPSBheGlzID09PSAneCcgPyAneScgOiAneCdcblxuICAgIGlFdmVudC5wYWdlW29wcG9zaXRlXSAgID0gaW50ZXJhY3Rpb24uY29vcmRzLnN0YXJ0LnBhZ2Vbb3Bwb3NpdGVdXG4gICAgaUV2ZW50LmNsaWVudFtvcHBvc2l0ZV0gPSBpbnRlcmFjdGlvbi5jb29yZHMuc3RhcnQuY2xpZW50W29wcG9zaXRlXVxuICAgIGlFdmVudC5kZWx0YVtvcHBvc2l0ZV0gPSAwXG4gIH1cbn1cblxuLyoqXG4gKiBgYGBqc1xuICogaW50ZXJhY3QoZWxlbWVudCkuZHJhZ2dhYmxlKHtcbiAqICAgICBvbnN0YXJ0OiBmdW5jdGlvbiAoZXZlbnQpIHt9LFxuICogICAgIG9ubW92ZSA6IGZ1bmN0aW9uIChldmVudCkge30sXG4gKiAgICAgb25lbmQgIDogZnVuY3Rpb24gKGV2ZW50KSB7fSxcbiAqXG4gKiAgICAgLy8gdGhlIGF4aXMgaW4gd2hpY2ggdGhlIGZpcnN0IG1vdmVtZW50IG11c3QgYmVcbiAqICAgICAvLyBmb3IgdGhlIGRyYWcgc2VxdWVuY2UgdG8gc3RhcnRcbiAqICAgICAvLyAneHknIGJ5IGRlZmF1bHQgLSBhbnkgZGlyZWN0aW9uXG4gKiAgICAgc3RhcnRBeGlzOiAneCcgfHwgJ3knIHx8ICd4eScsXG4gKlxuICogICAgIC8vICd4eScgYnkgZGVmYXVsdCAtIGRvbid0IHJlc3RyaWN0IHRvIG9uZSBheGlzIChtb3ZlIGluIGFueSBkaXJlY3Rpb24pXG4gKiAgICAgLy8gJ3gnIG9yICd5JyB0byByZXN0cmljdCBtb3ZlbWVudCB0byBlaXRoZXIgYXhpc1xuICogICAgIC8vICdzdGFydCcgdG8gcmVzdHJpY3QgbW92ZW1lbnQgdG8gdGhlIGF4aXMgdGhlIGRyYWcgc3RhcnRlZCBpblxuICogICAgIGxvY2tBeGlzOiAneCcgfHwgJ3knIHx8ICd4eScgfHwgJ3N0YXJ0JyxcbiAqXG4gKiAgICAgLy8gbWF4IG51bWJlciBvZiBkcmFncyB0aGF0IGNhbiBoYXBwZW4gY29uY3VycmVudGx5XG4gKiAgICAgLy8gd2l0aCBlbGVtZW50cyBvZiB0aGlzIEludGVyYWN0YWJsZS4gSW5maW5pdHkgYnkgZGVmYXVsdFxuICogICAgIG1heDogSW5maW5pdHksXG4gKlxuICogICAgIC8vIG1heCBudW1iZXIgb2YgZHJhZ3MgdGhhdCBjYW4gdGFyZ2V0IHRoZSBzYW1lIGVsZW1lbnQrSW50ZXJhY3RhYmxlXG4gKiAgICAgLy8gMSBieSBkZWZhdWx0XG4gKiAgICAgbWF4UGVyRWxlbWVudDogMlxuICogfSlcbiAqXG4gKiB2YXIgaXNEcmFnZ2FibGUgPSBpbnRlcmFjdCgnZWxlbWVudCcpLmRyYWdnYWJsZSgpOyAvLyB0cnVlXG4gKiBgYGBcbiAqXG4gKiBHZXQgb3Igc2V0IHdoZXRoZXIgZHJhZyBhY3Rpb25zIGNhbiBiZSBwZXJmb3JtZWQgb24gdGhlIHRhcmdldFxuICpcbiAqIEBhbGlhcyBJbnRlcmFjdGFibGUucHJvdG90eXBlLmRyYWdnYWJsZVxuICpcbiAqIEBwYXJhbSB7Ym9vbGVhbiB8IG9iamVjdH0gW29wdGlvbnNdIHRydWUvZmFsc2Ugb3IgQW4gb2JqZWN0IHdpdGggZXZlbnRcbiAqIGxpc3RlbmVycyB0byBiZSBmaXJlZCBvbiBkcmFnIGV2ZW50cyAob2JqZWN0IG1ha2VzIHRoZSBJbnRlcmFjdGFibGVcbiAqIGRyYWdnYWJsZSlcbiAqIEByZXR1cm4ge2Jvb2xlYW4gfCBJbnRlcmFjdGFibGV9IGJvb2xlYW4gaW5kaWNhdGluZyBpZiB0aGlzIGNhbiBiZSB0aGVcbiAqIHRhcmdldCBvZiBkcmFnIGV2ZW50cywgb3IgdGhpcyBJbnRlcmN0YWJsZVxuICovXG5jb25zdCBkcmFnZ2FibGU6IERyYWdnYWJsZU1ldGhvZCA9IGZ1bmN0aW9uIGRyYWdnYWJsZSAodGhpczogSW50ZXJhY3QuSW50ZXJhY3RhYmxlLCBvcHRpb25zPzogSW50ZXJhY3QuRHJhZ2dhYmxlT3B0aW9ucyB8IGJvb2xlYW4pOiBhbnkge1xuICBpZiAoaXMub2JqZWN0KG9wdGlvbnMpKSB7XG4gICAgdGhpcy5vcHRpb25zLmRyYWcuZW5hYmxlZCA9IG9wdGlvbnMuZW5hYmxlZCAhPT0gZmFsc2VcbiAgICB0aGlzLnNldFBlckFjdGlvbignZHJhZycsIG9wdGlvbnMpXG4gICAgdGhpcy5zZXRPbkV2ZW50cygnZHJhZycsIG9wdGlvbnMpXG5cbiAgICBpZiAoL14oeHl8eHx5fHN0YXJ0KSQvLnRlc3Qob3B0aW9ucy5sb2NrQXhpcykpIHtcbiAgICAgIHRoaXMub3B0aW9ucy5kcmFnLmxvY2tBeGlzID0gb3B0aW9ucy5sb2NrQXhpc1xuICAgIH1cbiAgICBpZiAoL14oeHl8eHx5KSQvLnRlc3Qob3B0aW9ucy5zdGFydEF4aXMpKSB7XG4gICAgICB0aGlzLm9wdGlvbnMuZHJhZy5zdGFydEF4aXMgPSBvcHRpb25zLnN0YXJ0QXhpc1xuICAgIH1cblxuICAgIHJldHVybiB0aGlzXG4gIH1cblxuICBpZiAoaXMuYm9vbChvcHRpb25zKSkge1xuICAgIHRoaXMub3B0aW9ucy5kcmFnLmVuYWJsZWQgPSBvcHRpb25zXG5cbiAgICByZXR1cm4gdGhpc1xuICB9XG5cbiAgcmV0dXJuIHRoaXMub3B0aW9ucy5kcmFnXG59XG5cbmNvbnN0IGRyYWc6IEludGVyYWN0LlBsdWdpbiA9IHtcbiAgaWQ6ICdhY3Rpb25zL2RyYWcnLFxuICBpbnN0YWxsLFxuICBsaXN0ZW5lcnM6IHtcbiAgICAnaW50ZXJhY3Rpb25zOmJlZm9yZS1hY3Rpb24tbW92ZSc6IGJlZm9yZU1vdmUsXG4gICAgJ2ludGVyYWN0aW9uczphY3Rpb24tcmVzdW1lJzogYmVmb3JlTW92ZSxcblxuICAgIC8vIGRyYWdtb3ZlXG4gICAgJ2ludGVyYWN0aW9uczphY3Rpb24tbW92ZSc6IG1vdmUsXG4gICAgJ2F1dG8tc3RhcnQ6Y2hlY2snOiBhcmcgPT4ge1xuICAgICAgY29uc3QgeyBpbnRlcmFjdGlvbiwgaW50ZXJhY3RhYmxlLCBidXR0b25zIH0gPSBhcmdcbiAgICAgIGNvbnN0IGRyYWdPcHRpb25zID0gaW50ZXJhY3RhYmxlLm9wdGlvbnMuZHJhZ1xuXG4gICAgICBpZiAoXG4gICAgICAgICEoZHJhZ09wdGlvbnMgJiYgZHJhZ09wdGlvbnMuZW5hYmxlZCkgfHxcbiAgICAgICAgLy8gY2hlY2sgbW91c2VCdXR0b24gc2V0dGluZyBpZiB0aGUgcG9pbnRlciBpcyBkb3duXG4gICAgICAgIChpbnRlcmFjdGlvbi5wb2ludGVySXNEb3duICYmXG4gICAgICAgICAvbW91c2V8cG9pbnRlci8udGVzdChpbnRlcmFjdGlvbi5wb2ludGVyVHlwZSkgJiZcbiAgICAgICAoYnV0dG9ucyAmIGludGVyYWN0YWJsZS5vcHRpb25zLmRyYWcubW91c2VCdXR0b25zKSA9PT0gMClcbiAgICAgICkge1xuICAgICAgICByZXR1cm4gdW5kZWZpbmVkXG4gICAgICB9XG5cbiAgICAgIGFyZy5hY3Rpb24gPSB7XG4gICAgICAgIG5hbWU6ICdkcmFnJyxcbiAgICAgICAgYXhpczogKGRyYWdPcHRpb25zLmxvY2tBeGlzID09PSAnc3RhcnQnXG4gICAgICAgICAgPyBkcmFnT3B0aW9ucy5zdGFydEF4aXNcbiAgICAgICAgICA6IGRyYWdPcHRpb25zLmxvY2tBeGlzKSxcbiAgICAgIH1cblxuICAgICAgcmV0dXJuIGZhbHNlXG4gICAgfSxcbiAgfSxcbiAgZHJhZ2dhYmxlLFxuICBiZWZvcmVNb3ZlLFxuICBtb3ZlLFxuICBkZWZhdWx0czoge1xuICAgIHN0YXJ0QXhpcyA6ICd4eScsXG4gICAgbG9ja0F4aXMgIDogJ3h5JyxcbiAgfSBhcyBJbnRlcmFjdC5Ecm9wem9uZU9wdGlvbnMsXG5cbiAgZ2V0Q3Vyc29yICgpIHtcbiAgICByZXR1cm4gJ21vdmUnXG4gIH0sXG59XG5cbmV4cG9ydCBkZWZhdWx0IGRyYWdcbiIsInR5cGUgRmlsdGVyPFQ+ID0gKGVsZW1lbnQ6IFQsIGluZGV4OiBudW1iZXIsIGFycmF5OiBUW10pID0+IGJvb2xlYW5cblxuZXhwb3J0IGNvbnN0IGNvbnRhaW5zID0gPFQ+KGFycmF5OiBUW10sIHRhcmdldDogVCkgPT4gYXJyYXkuaW5kZXhPZih0YXJnZXQpICE9PSAtMVxuXG5leHBvcnQgY29uc3QgcmVtb3ZlID0gPFQ+KGFycmF5OiBUW10sIHRhcmdldDogVCkgPT4gYXJyYXkuc3BsaWNlKGFycmF5LmluZGV4T2YodGFyZ2V0KSwgMSlcblxuZXhwb3J0IGNvbnN0IG1lcmdlID0gPFQsIFU+KHRhcmdldDogQXJyYXk8VCB8IFU+LCBzb3VyY2U6IFVbXSkgPT4ge1xuICBmb3IgKGNvbnN0IGl0ZW0gb2Ygc291cmNlKSB7XG4gICAgdGFyZ2V0LnB1c2goaXRlbSlcbiAgfVxuXG4gIHJldHVybiB0YXJnZXRcbn1cblxuZXhwb3J0IGNvbnN0IGZyb20gPSA8VCA9IGFueT4oc291cmNlOiBBcnJheUxpa2U8VD4pID0+IG1lcmdlKFtdIGFzIFRbXSwgc291cmNlIGFzIFRbXSlcblxuZXhwb3J0IGNvbnN0IGZpbmRJbmRleCA9IDxUPihhcnJheTogVFtdLCBmdW5jOiBGaWx0ZXI8VD4pID0+IHtcbiAgZm9yIChsZXQgaSA9IDA7IGkgPCBhcnJheS5sZW5ndGg7IGkrKykge1xuICAgIGlmIChmdW5jKGFycmF5W2ldLCBpLCBhcnJheSkpIHtcbiAgICAgIHJldHVybiBpXG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIC0xXG59XG5cbmV4cG9ydCBjb25zdCBmaW5kID0gPFQgPSBhbnk+KGFycmF5OiBUW10sIGZ1bmM6IEZpbHRlcjxUPikgPT4gYXJyYXlbZmluZEluZGV4KGFycmF5LCBmdW5jKV1cbiIsImNvbnN0IGRvbU9iamVjdHM6IHtcbiAgaW5pdDogYW55XG4gIGRvY3VtZW50OiBEb2N1bWVudFxuICBEb2N1bWVudEZyYWdtZW50OiB0eXBlb2YgRG9jdW1lbnRGcmFnbWVudFxuICBTVkdFbGVtZW50OiB0eXBlb2YgU1ZHRWxlbWVudFxuICBTVkdTVkdFbGVtZW50OiB0eXBlb2YgU1ZHU1ZHRWxlbWVudFxuICBTVkdFbGVtZW50SW5zdGFuY2U6IGFueVxuICBFbGVtZW50OiB0eXBlb2YgRWxlbWVudFxuICBIVE1MRWxlbWVudDogdHlwZW9mIEhUTUxFbGVtZW50XG4gIEV2ZW50OiB0eXBlb2YgRXZlbnRcbiAgVG91Y2g6IHR5cGVvZiBUb3VjaFxuICBQb2ludGVyRXZlbnQ6IHR5cGVvZiBQb2ludGVyRXZlbnRcbn0gPVxue1xuICBpbml0LFxuICBkb2N1bWVudDogbnVsbCxcbiAgRG9jdW1lbnRGcmFnbWVudDogbnVsbCxcbiAgU1ZHRWxlbWVudDogbnVsbCxcbiAgU1ZHU1ZHRWxlbWVudDogbnVsbCxcbiAgU1ZHRWxlbWVudEluc3RhbmNlOiBudWxsLFxuICBFbGVtZW50OiBudWxsLFxuICBIVE1MRWxlbWVudDogbnVsbCxcbiAgRXZlbnQ6IG51bGwsXG4gIFRvdWNoOiBudWxsLFxuICBQb2ludGVyRXZlbnQ6IG51bGwsXG59XG5cbmZ1bmN0aW9uIGJsYW5rICgpIHt9XG5cbmV4cG9ydCBkZWZhdWx0IGRvbU9iamVjdHNcblxuZnVuY3Rpb24gaW5pdCAod2luZG93OiBXaW5kb3cpIHtcbiAgY29uc3Qgd2luID0gd2luZG93IGFzIGFueVxuXG4gIGRvbU9iamVjdHMuZG9jdW1lbnQgICAgICAgICAgID0gd2luLmRvY3VtZW50XG4gIGRvbU9iamVjdHMuRG9jdW1lbnRGcmFnbWVudCAgID0gd2luLkRvY3VtZW50RnJhZ21lbnQgICB8fCBibGFua1xuICBkb21PYmplY3RzLlNWR0VsZW1lbnQgICAgICAgICA9IHdpbi5TVkdFbGVtZW50ICAgICAgICAgfHwgYmxhbmtcbiAgZG9tT2JqZWN0cy5TVkdTVkdFbGVtZW50ICAgICAgPSB3aW4uU1ZHU1ZHRWxlbWVudCAgICAgIHx8IGJsYW5rXG4gIGRvbU9iamVjdHMuU1ZHRWxlbWVudEluc3RhbmNlID0gd2luLlNWR0VsZW1lbnRJbnN0YW5jZSB8fCBibGFua1xuICBkb21PYmplY3RzLkVsZW1lbnQgICAgICAgICAgICA9IHdpbi5FbGVtZW50ICAgICAgICAgICAgfHwgYmxhbmtcbiAgZG9tT2JqZWN0cy5IVE1MRWxlbWVudCAgICAgICAgPSB3aW4uSFRNTEVsZW1lbnQgICAgICAgIHx8IGRvbU9iamVjdHMuRWxlbWVudFxuXG4gIGRvbU9iamVjdHMuRXZlbnQgICAgICAgID0gd2luLkV2ZW50XG4gIGRvbU9iamVjdHMuVG91Y2ggICAgICAgID0gd2luLlRvdWNoIHx8IGJsYW5rXG4gIGRvbU9iamVjdHMuUG9pbnRlckV2ZW50ID0gKHdpbi5Qb2ludGVyRXZlbnQgfHwgd2luLk1TUG9pbnRlckV2ZW50KVxufVxuIiwiaW1wb3J0IGRvbU9iamVjdHMgZnJvbSAnLi9kb21PYmplY3RzJ1xuaW1wb3J0ICogYXMgaXMgZnJvbSAnLi9pcydcbmltcG9ydCB3aW4gZnJvbSAnLi93aW5kb3cnXG5cbmNvbnN0IGJyb3dzZXIgPSB7XG4gIGluaXQsXG4gIHN1cHBvcnRzVG91Y2g6IG51bGwgYXMgYm9vbGVhbixcbiAgc3VwcG9ydHNQb2ludGVyRXZlbnQ6IG51bGwgYXMgYm9vbGVhbixcbiAgaXNJT1M3OiBudWxsIGFzIGJvb2xlYW4sXG4gIGlzSU9TOiBudWxsIGFzIGJvb2xlYW4sXG4gIGlzSWU5OiBudWxsIGFzIGJvb2xlYW4sXG4gIGlzT3BlcmFNb2JpbGU6IG51bGwgYXMgYm9vbGVhbixcbiAgcHJlZml4ZWRNYXRjaGVzU2VsZWN0b3I6IG51bGwgYXMgc3RyaW5nLFxuICBwRXZlbnRUeXBlczogbnVsbCBhcyB7XG4gICAgdXA6IHN0cmluZ1xuICAgIGRvd246IHN0cmluZ1xuICAgIG92ZXI6IHN0cmluZ1xuICAgIG91dDogc3RyaW5nXG4gICAgbW92ZTogc3RyaW5nXG4gICAgY2FuY2VsOiBzdHJpbmdcbiAgfSxcbiAgd2hlZWxFdmVudDogbnVsbCBhcyBzdHJpbmcsXG59XG5cbmZ1bmN0aW9uIGluaXQgKHdpbmRvdzogYW55KSB7XG4gIGNvbnN0IEVsZW1lbnQgPSBkb21PYmplY3RzLkVsZW1lbnRcbiAgY29uc3QgbmF2aWdhdG9yICA9IHdpbi53aW5kb3cubmF2aWdhdG9yXG5cbiAgLy8gRG9lcyB0aGUgYnJvd3NlciBzdXBwb3J0IHRvdWNoIGlucHV0P1xuICBicm93c2VyLnN1cHBvcnRzVG91Y2ggPSAoJ29udG91Y2hzdGFydCcgaW4gd2luZG93KSB8fFxuICAgIChpcy5mdW5jKHdpbmRvdy5Eb2N1bWVudFRvdWNoKSAmJiBkb21PYmplY3RzLmRvY3VtZW50IGluc3RhbmNlb2Ygd2luZG93LkRvY3VtZW50VG91Y2gpXG5cbiAgLy8gRG9lcyB0aGUgYnJvd3NlciBzdXBwb3J0IFBvaW50ZXJFdmVudHNcbiAgYnJvd3Nlci5zdXBwb3J0c1BvaW50ZXJFdmVudCA9IG5hdmlnYXRvci5wb2ludGVyRW5hYmxlZCAhPT0gZmFsc2UgJiYgISFkb21PYmplY3RzLlBvaW50ZXJFdmVudFxuXG4gIGJyb3dzZXIuaXNJT1MgPSAoL2lQKGhvbmV8b2R8YWQpLy50ZXN0KG5hdmlnYXRvci5wbGF0Zm9ybSkpXG5cbiAgLy8gc2Nyb2xsaW5nIGRvZXNuJ3QgY2hhbmdlIHRoZSByZXN1bHQgb2YgZ2V0Q2xpZW50UmVjdHMgb24gaU9TIDdcbiAgYnJvd3Nlci5pc0lPUzcgPSAoL2lQKGhvbmV8b2R8YWQpLy50ZXN0KG5hdmlnYXRvci5wbGF0Zm9ybSkgJiZcbiAgICAgICAgICAgL09TIDdbXlxcZF0vLnRlc3QobmF2aWdhdG9yLmFwcFZlcnNpb24pKVxuXG4gIGJyb3dzZXIuaXNJZTkgPSAvTVNJRSA5Ly50ZXN0KG5hdmlnYXRvci51c2VyQWdlbnQpXG5cbiAgLy8gT3BlcmEgTW9iaWxlIG11c3QgYmUgaGFuZGxlZCBkaWZmZXJlbnRseVxuICBicm93c2VyLmlzT3BlcmFNb2JpbGUgPSAobmF2aWdhdG9yLmFwcE5hbWUgPT09ICdPcGVyYScgJiZcbiAgICBicm93c2VyLnN1cHBvcnRzVG91Y2ggJiZcbiAgICAvUHJlc3RvLy50ZXN0KG5hdmlnYXRvci51c2VyQWdlbnQpKVxuXG4gIC8vIHByZWZpeCBtYXRjaGVzU2VsZWN0b3JcbiAgYnJvd3Nlci5wcmVmaXhlZE1hdGNoZXNTZWxlY3RvciA9ICdtYXRjaGVzJyBpbiBFbGVtZW50LnByb3RvdHlwZVxuICAgID8gJ21hdGNoZXMnXG4gICAgOiAnd2Via2l0TWF0Y2hlc1NlbGVjdG9yJyBpbiBFbGVtZW50LnByb3RvdHlwZVxuICAgICAgPyAnd2Via2l0TWF0Y2hlc1NlbGVjdG9yJ1xuICAgICAgOiAnbW96TWF0Y2hlc1NlbGVjdG9yJyBpbiBFbGVtZW50LnByb3RvdHlwZVxuICAgICAgICA/ICdtb3pNYXRjaGVzU2VsZWN0b3InXG4gICAgICAgIDogJ29NYXRjaGVzU2VsZWN0b3InIGluIEVsZW1lbnQucHJvdG90eXBlXG4gICAgICAgICAgPyAnb01hdGNoZXNTZWxlY3RvcidcbiAgICAgICAgICA6ICdtc01hdGNoZXNTZWxlY3RvcidcblxuICBicm93c2VyLnBFdmVudFR5cGVzID0gKGJyb3dzZXIuc3VwcG9ydHNQb2ludGVyRXZlbnRcbiAgICA/IChkb21PYmplY3RzLlBvaW50ZXJFdmVudCA9PT0gd2luZG93Lk1TUG9pbnRlckV2ZW50XG4gICAgICA/IHtcbiAgICAgICAgdXA6ICAgICAnTVNQb2ludGVyVXAnLFxuICAgICAgICBkb3duOiAgICdNU1BvaW50ZXJEb3duJyxcbiAgICAgICAgb3ZlcjogICAnbW91c2VvdmVyJyxcbiAgICAgICAgb3V0OiAgICAnbW91c2VvdXQnLFxuICAgICAgICBtb3ZlOiAgICdNU1BvaW50ZXJNb3ZlJyxcbiAgICAgICAgY2FuY2VsOiAnTVNQb2ludGVyQ2FuY2VsJyxcbiAgICAgIH1cbiAgICAgIDoge1xuICAgICAgICB1cDogICAgICdwb2ludGVydXAnLFxuICAgICAgICBkb3duOiAgICdwb2ludGVyZG93bicsXG4gICAgICAgIG92ZXI6ICAgJ3BvaW50ZXJvdmVyJyxcbiAgICAgICAgb3V0OiAgICAncG9pbnRlcm91dCcsXG4gICAgICAgIG1vdmU6ICAgJ3BvaW50ZXJtb3ZlJyxcbiAgICAgICAgY2FuY2VsOiAncG9pbnRlcmNhbmNlbCcsXG4gICAgICB9KVxuICAgIDogbnVsbClcblxuICAvLyBiZWNhdXNlIFdlYmtpdCBhbmQgT3BlcmEgc3RpbGwgdXNlICdtb3VzZXdoZWVsJyBldmVudCB0eXBlXG4gIGJyb3dzZXIud2hlZWxFdmVudCA9ICdvbm1vdXNld2hlZWwnIGluIGRvbU9iamVjdHMuZG9jdW1lbnQgPyAnbW91c2V3aGVlbCcgOiAnd2hlZWwnXG59XG5cbmV4cG9ydCBkZWZhdWx0IGJyb3dzZXJcbiIsImltcG9ydCAqIGFzIGFyciBmcm9tICcuL2FycidcbmltcG9ydCAqIGFzIGlzIGZyb20gJy4vaXMnXG5cbi8vIHRzbGludDpkaXNhYmxlLW5leHQtbGluZSBiYW4tdHlwZXNcbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIGNsb25lPFQgZXh0ZW5kcyBPYmplY3Q+IChzb3VyY2U6IFQpOiBQYXJ0aWFsPFQ+IHtcbiAgY29uc3QgZGVzdCA9IHt9IGFzIFBhcnRpYWw8VD5cblxuICBmb3IgKGNvbnN0IHByb3AgaW4gc291cmNlKSB7XG4gICAgY29uc3QgdmFsdWUgPSBzb3VyY2VbcHJvcF1cblxuICAgIGlmIChpcy5wbGFpbk9iamVjdCh2YWx1ZSkpIHtcbiAgICAgIGRlc3RbcHJvcF0gPSBjbG9uZSh2YWx1ZSkgYXMgYW55XG4gICAgfVxuICAgIGVsc2UgaWYgKGlzLmFycmF5KHZhbHVlKSkge1xuICAgICAgZGVzdFtwcm9wXSA9IGFyci5mcm9tKHZhbHVlKSBhcyB0eXBlb2YgdmFsdWVcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICBkZXN0W3Byb3BdID0gdmFsdWVcbiAgICB9XG4gIH1cblxuICByZXR1cm4gZGVzdFxufVxuIiwiaW1wb3J0IGJyb3dzZXIgZnJvbSAnLi9icm93c2VyJ1xuaW1wb3J0IGRvbU9iamVjdHMgZnJvbSAnLi9kb21PYmplY3RzJ1xuaW1wb3J0ICogYXMgaXMgZnJvbSAnLi9pcydcbmltcG9ydCB3aW4sIHsgZ2V0V2luZG93IH0gZnJvbSAnLi93aW5kb3cnXG5cbmV4cG9ydCBmdW5jdGlvbiBub2RlQ29udGFpbnMgKHBhcmVudDogTm9kZSB8IEludGVyYWN0LkV2ZW50VGFyZ2V0LCBjaGlsZDogTm9kZSB8IEludGVyYWN0LkV2ZW50VGFyZ2V0KSB7XG4gIHdoaWxlIChjaGlsZCkge1xuICAgIGlmIChjaGlsZCA9PT0gcGFyZW50KSB7XG4gICAgICByZXR1cm4gdHJ1ZVxuICAgIH1cblxuICAgIGNoaWxkID0gKGNoaWxkIGFzIE5vZGUpLnBhcmVudE5vZGVcbiAgfVxuXG4gIHJldHVybiBmYWxzZVxufVxuXG5leHBvcnQgZnVuY3Rpb24gY2xvc2VzdCAoZWxlbWVudDogTm9kZSwgc2VsZWN0b3I6IHN0cmluZykge1xuICB3aGlsZSAoaXMuZWxlbWVudChlbGVtZW50KSkge1xuICAgIGlmIChtYXRjaGVzU2VsZWN0b3IoZWxlbWVudCwgc2VsZWN0b3IpKSB7IHJldHVybiBlbGVtZW50IH1cblxuICAgIGVsZW1lbnQgPSBwYXJlbnROb2RlKGVsZW1lbnQpXG4gIH1cblxuICByZXR1cm4gbnVsbFxufVxuXG5leHBvcnQgZnVuY3Rpb24gcGFyZW50Tm9kZSAobm9kZTogTm9kZSB8IERvY3VtZW50KSB7XG4gIGxldCBwYXJlbnQgPSBub2RlLnBhcmVudE5vZGVcblxuICBpZiAoaXMuZG9jRnJhZyhwYXJlbnQpKSB7XG4gICAgLy8gc2tpcCBwYXN0ICNzaGFkby1yb290IGZyYWdtZW50c1xuICAgIC8vIHRzbGludDpkaXNhYmxlLW5leHQtbGluZVxuICAgIHdoaWxlICgocGFyZW50ID0gKHBhcmVudCBhcyBhbnkpLmhvc3QpICYmIGlzLmRvY0ZyYWcocGFyZW50KSkge1xuICAgICAgY29udGludWVcbiAgICB9XG5cbiAgICByZXR1cm4gcGFyZW50XG4gIH1cblxuICByZXR1cm4gcGFyZW50XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBtYXRjaGVzU2VsZWN0b3IgKGVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnQsIHNlbGVjdG9yOiBzdHJpbmcpIHtcbiAgLy8gcmVtb3ZlIC9kZWVwLyBmcm9tIHNlbGVjdG9ycyBpZiBzaGFkb3dET00gcG9seWZpbGwgaXMgdXNlZFxuICBpZiAod2luLndpbmRvdyAhPT0gd2luLnJlYWxXaW5kb3cpIHtcbiAgICBzZWxlY3RvciA9IHNlbGVjdG9yLnJlcGxhY2UoL1xcL2RlZXBcXC8vZywgJyAnKVxuICB9XG5cbiAgcmV0dXJuIGVsZW1lbnRbYnJvd3Nlci5wcmVmaXhlZE1hdGNoZXNTZWxlY3Rvcl0oc2VsZWN0b3IpXG59XG5cbmNvbnN0IGdldFBhcmVudCA9IGVsID0+IGVsLnBhcmVudE5vZGUgPyBlbC5wYXJlbnROb2RlIDogZWwuaG9zdFxuXG4vLyBUZXN0IGZvciB0aGUgZWxlbWVudCB0aGF0J3MgXCJhYm92ZVwiIGFsbCBvdGhlciBxdWFsaWZpZXJzXG5leHBvcnQgZnVuY3Rpb24gaW5kZXhPZkRlZXBlc3RFbGVtZW50IChlbGVtZW50czogSW50ZXJhY3QuRWxlbWVudFtdIHwgTm9kZUxpc3RPZjxFbGVtZW50Pikge1xuICBsZXQgZGVlcGVzdFpvbmVQYXJlbnRzID0gW11cbiAgbGV0IGRlZXBlc3Rab25lID0gZWxlbWVudHNbMF1cbiAgbGV0IGluZGV4ID0gZGVlcGVzdFpvbmUgPyAwIDogLTFcbiAgbGV0IGlcbiAgbGV0IG5cblxuICBmb3IgKGkgPSAxOyBpIDwgZWxlbWVudHMubGVuZ3RoOyBpKyspIHtcbiAgICBjb25zdCBkcm9wem9uZSA9IGVsZW1lbnRzW2ldXG5cbiAgICAvLyBhbiBlbGVtZW50IG1pZ2h0IGJlbG9uZyB0byBtdWx0aXBsZSBzZWxlY3RvciBkcm9wem9uZXNcbiAgICBpZiAoIWRyb3B6b25lIHx8IGRyb3B6b25lID09PSBkZWVwZXN0Wm9uZSkge1xuICAgICAgY29udGludWVcbiAgICB9XG5cbiAgICBpZiAoIWRlZXBlc3Rab25lKSB7XG4gICAgICBkZWVwZXN0Wm9uZSA9IGRyb3B6b25lXG4gICAgICBpbmRleCA9IGlcbiAgICAgIGNvbnRpbnVlXG4gICAgfVxuXG4gICAgLy8gY2hlY2sgaWYgdGhlIGRlZXBlc3Qgb3IgY3VycmVudCBhcmUgZG9jdW1lbnQuZG9jdW1lbnRFbGVtZW50IG9yIGRvY3VtZW50LnJvb3RFbGVtZW50XG4gICAgLy8gLSBpZiB0aGUgY3VycmVudCBkcm9wem9uZSBpcywgZG8gbm90aGluZyBhbmQgY29udGludWVcbiAgICBpZiAoZHJvcHpvbmUucGFyZW50Tm9kZSA9PT0gZHJvcHpvbmUub3duZXJEb2N1bWVudCkge1xuICAgICAgY29udGludWVcbiAgICB9XG4gICAgLy8gLSBpZiBkZWVwZXN0IGlzLCB1cGRhdGUgd2l0aCB0aGUgY3VycmVudCBkcm9wem9uZSBhbmQgY29udGludWUgdG8gbmV4dFxuICAgIGVsc2UgaWYgKGRlZXBlc3Rab25lLnBhcmVudE5vZGUgPT09IGRyb3B6b25lLm93bmVyRG9jdW1lbnQpIHtcbiAgICAgIGRlZXBlc3Rab25lID0gZHJvcHpvbmVcbiAgICAgIGluZGV4ID0gaVxuICAgICAgY29udGludWVcbiAgICB9XG5cbiAgICAvLyBjb21wYXJlIHpJbmRleCBvZiBzaWJsaW5nc1xuICAgIGlmIChkcm9wem9uZS5wYXJlbnROb2RlID09PSBkZWVwZXN0Wm9uZS5wYXJlbnROb2RlKSB7XG4gICAgICBjb25zdCBkZWVwZXN0WkluZGV4ID0gcGFyc2VJbnQoZ2V0V2luZG93KGRlZXBlc3Rab25lKS5nZXRDb21wdXRlZFN0eWxlKGRlZXBlc3Rab25lKS56SW5kZXgsIDEwKSB8fCAwXG4gICAgICBjb25zdCBkcm9wem9uZVpJbmRleCA9IHBhcnNlSW50KGdldFdpbmRvdyhkcm9wem9uZSkuZ2V0Q29tcHV0ZWRTdHlsZShkcm9wem9uZSkuekluZGV4LCAxMCkgfHwgMFxuXG4gICAgICBpZiAoZHJvcHpvbmVaSW5kZXggPj0gZGVlcGVzdFpJbmRleCkge1xuICAgICAgICBkZWVwZXN0Wm9uZSA9IGRyb3B6b25lXG4gICAgICAgIGluZGV4ID0gaVxuICAgICAgfVxuXG4gICAgICBjb250aW51ZVxuICAgIH1cblxuICAgIC8vIHBvcHVsYXRlIHRoZSBhbmNlc3RyeSBhcnJheSBmb3IgdGhlIGxhdGVzdCBkZWVwZXN0IGRyb3B6b25lXG4gICAgaWYgKCFkZWVwZXN0Wm9uZVBhcmVudHMubGVuZ3RoKSB7XG4gICAgICBsZXQgcGFyZW50ID0gZGVlcGVzdFpvbmVcbiAgICAgIGxldCBwYXJlbnRQYXJlbnRcblxuICAgICAgd2hpbGUgKChwYXJlbnRQYXJlbnQgPSBnZXRQYXJlbnQocGFyZW50KSkgJiYgcGFyZW50UGFyZW50ICE9PSBwYXJlbnQub3duZXJEb2N1bWVudCkge1xuICAgICAgICBkZWVwZXN0Wm9uZVBhcmVudHMudW5zaGlmdChwYXJlbnQpXG4gICAgICAgIHBhcmVudCA9IHBhcmVudFBhcmVudFxuICAgICAgfVxuICAgIH1cblxuICAgIGxldCBwYXJlbnRcblxuICAgIC8vIGlmIHRoaXMgZWxlbWVudCBpcyBhbiBzdmcgZWxlbWVudCBhbmQgdGhlIGN1cnJlbnQgZGVlcGVzdCBpcyBhblxuICAgIC8vIEhUTUxFbGVtZW50XG4gICAgaWYgKGRlZXBlc3Rab25lIGluc3RhbmNlb2YgZG9tT2JqZWN0cy5IVE1MRWxlbWVudCAmJlxuICAgICAgICBkcm9wem9uZSBpbnN0YW5jZW9mIGRvbU9iamVjdHMuU1ZHRWxlbWVudCAmJlxuICAgICAgICAhKGRyb3B6b25lIGluc3RhbmNlb2YgZG9tT2JqZWN0cy5TVkdTVkdFbGVtZW50KSkge1xuICAgICAgaWYgKGRyb3B6b25lID09PSBkZWVwZXN0Wm9uZS5wYXJlbnROb2RlKSB7XG4gICAgICAgIGNvbnRpbnVlXG4gICAgICB9XG5cbiAgICAgIHBhcmVudCA9IGRyb3B6b25lLm93bmVyU1ZHRWxlbWVudFxuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHBhcmVudCA9IGRyb3B6b25lXG4gICAgfVxuXG4gICAgY29uc3QgZHJvcHpvbmVQYXJlbnRzID0gW11cblxuICAgIHdoaWxlIChwYXJlbnQucGFyZW50Tm9kZSAhPT0gcGFyZW50Lm93bmVyRG9jdW1lbnQpIHtcbiAgICAgIGRyb3B6b25lUGFyZW50cy51bnNoaWZ0KHBhcmVudClcbiAgICAgIHBhcmVudCA9IGdldFBhcmVudChwYXJlbnQpXG4gICAgfVxuXG4gICAgbiA9IDBcblxuICAgIC8vIGdldCAocG9zaXRpb24gb2YgbGFzdCBjb21tb24gYW5jZXN0b3IpICsgMVxuICAgIHdoaWxlIChkcm9wem9uZVBhcmVudHNbbl0gJiYgZHJvcHpvbmVQYXJlbnRzW25dID09PSBkZWVwZXN0Wm9uZVBhcmVudHNbbl0pIHtcbiAgICAgIG4rK1xuICAgIH1cblxuICAgIGNvbnN0IHBhcmVudHMgPSBbXG4gICAgICBkcm9wem9uZVBhcmVudHNbbiAtIDFdLFxuICAgICAgZHJvcHpvbmVQYXJlbnRzW25dLFxuICAgICAgZGVlcGVzdFpvbmVQYXJlbnRzW25dLFxuICAgIF1cblxuICAgIGxldCBjaGlsZCA9IHBhcmVudHNbMF0ubGFzdENoaWxkXG5cbiAgICB3aGlsZSAoY2hpbGQpIHtcbiAgICAgIGlmIChjaGlsZCA9PT0gcGFyZW50c1sxXSkge1xuICAgICAgICBkZWVwZXN0Wm9uZSA9IGRyb3B6b25lXG4gICAgICAgIGluZGV4ID0gaVxuICAgICAgICBkZWVwZXN0Wm9uZVBhcmVudHMgPSBkcm9wem9uZVBhcmVudHNcblxuICAgICAgICBicmVha1xuICAgICAgfVxuICAgICAgZWxzZSBpZiAoY2hpbGQgPT09IHBhcmVudHNbMl0pIHtcbiAgICAgICAgYnJlYWtcbiAgICAgIH1cblxuICAgICAgY2hpbGQgPSBjaGlsZC5wcmV2aW91c1NpYmxpbmdcbiAgICB9XG4gIH1cblxuICByZXR1cm4gaW5kZXhcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG1hdGNoZXNVcFRvIChlbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50LCBzZWxlY3Rvcjogc3RyaW5nLCBsaW1pdDogTm9kZSkge1xuICB3aGlsZSAoaXMuZWxlbWVudChlbGVtZW50KSkge1xuICAgIGlmIChtYXRjaGVzU2VsZWN0b3IoZWxlbWVudCwgc2VsZWN0b3IpKSB7XG4gICAgICByZXR1cm4gdHJ1ZVxuICAgIH1cblxuICAgIGVsZW1lbnQgPSBwYXJlbnROb2RlKGVsZW1lbnQpIGFzIEludGVyYWN0LkVsZW1lbnRcblxuICAgIGlmIChlbGVtZW50ID09PSBsaW1pdCkge1xuICAgICAgcmV0dXJuIG1hdGNoZXNTZWxlY3RvcihlbGVtZW50LCBzZWxlY3RvcilcbiAgICB9XG4gIH1cblxuICByZXR1cm4gZmFsc2Vcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdldEFjdHVhbEVsZW1lbnQgKGVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnQpIHtcbiAgcmV0dXJuIChlbGVtZW50IGluc3RhbmNlb2YgZG9tT2JqZWN0cy5TVkdFbGVtZW50SW5zdGFuY2VcbiAgICA/IChlbGVtZW50IGFzIFNWR0VsZW1lbnQpLmNvcnJlc3BvbmRpbmdVc2VFbGVtZW50XG4gICAgOiBlbGVtZW50KVxufVxuXG5leHBvcnQgZnVuY3Rpb24gZ2V0U2Nyb2xsWFkgKHJlbGV2YW50V2luZG93KSB7XG4gIHJlbGV2YW50V2luZG93ID0gcmVsZXZhbnRXaW5kb3cgfHwgd2luLndpbmRvd1xuICByZXR1cm4ge1xuICAgIHg6IHJlbGV2YW50V2luZG93LnNjcm9sbFggfHwgcmVsZXZhbnRXaW5kb3cuZG9jdW1lbnQuZG9jdW1lbnRFbGVtZW50LnNjcm9sbExlZnQsXG4gICAgeTogcmVsZXZhbnRXaW5kb3cuc2Nyb2xsWSB8fCByZWxldmFudFdpbmRvdy5kb2N1bWVudC5kb2N1bWVudEVsZW1lbnQuc2Nyb2xsVG9wLFxuICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRFbGVtZW50Q2xpZW50UmVjdCAoZWxlbWVudDogSW50ZXJhY3QuRWxlbWVudCkge1xuICBjb25zdCBjbGllbnRSZWN0ID0gKGVsZW1lbnQgaW5zdGFuY2VvZiBkb21PYmplY3RzLlNWR0VsZW1lbnRcbiAgICA/IGVsZW1lbnQuZ2V0Qm91bmRpbmdDbGllbnRSZWN0KClcbiAgICA6IGVsZW1lbnQuZ2V0Q2xpZW50UmVjdHMoKVswXSlcblxuICByZXR1cm4gY2xpZW50UmVjdCAmJiB7XG4gICAgbGVmdCAgOiBjbGllbnRSZWN0LmxlZnQsXG4gICAgcmlnaHQgOiBjbGllbnRSZWN0LnJpZ2h0LFxuICAgIHRvcCAgIDogY2xpZW50UmVjdC50b3AsXG4gICAgYm90dG9tOiBjbGllbnRSZWN0LmJvdHRvbSxcbiAgICB3aWR0aCA6IGNsaWVudFJlY3Qud2lkdGggIHx8IGNsaWVudFJlY3QucmlnaHQgIC0gY2xpZW50UmVjdC5sZWZ0LFxuICAgIGhlaWdodDogY2xpZW50UmVjdC5oZWlnaHQgfHwgY2xpZW50UmVjdC5ib3R0b20gLSBjbGllbnRSZWN0LnRvcCxcbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gZ2V0RWxlbWVudFJlY3QgKGVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnQpIHtcbiAgY29uc3QgY2xpZW50UmVjdCA9IGdldEVsZW1lbnRDbGllbnRSZWN0KGVsZW1lbnQpXG5cbiAgaWYgKCFicm93c2VyLmlzSU9TNyAmJiBjbGllbnRSZWN0KSB7XG4gICAgY29uc3Qgc2Nyb2xsID0gZ2V0U2Nyb2xsWFkod2luLmdldFdpbmRvdyhlbGVtZW50KSlcblxuICAgIGNsaWVudFJlY3QubGVmdCAgICs9IHNjcm9sbC54XG4gICAgY2xpZW50UmVjdC5yaWdodCAgKz0gc2Nyb2xsLnhcbiAgICBjbGllbnRSZWN0LnRvcCAgICArPSBzY3JvbGwueVxuICAgIGNsaWVudFJlY3QuYm90dG9tICs9IHNjcm9sbC55XG4gIH1cblxuICByZXR1cm4gY2xpZW50UmVjdFxufVxuXG5leHBvcnQgZnVuY3Rpb24gZ2V0UGF0aCAobm9kZTogTm9kZSB8IERvY3VtZW50KSB7XG4gIGNvbnN0IHBhdGggPSBbXVxuXG4gIHdoaWxlIChub2RlKSB7XG4gICAgcGF0aC5wdXNoKG5vZGUpXG4gICAgbm9kZSA9IHBhcmVudE5vZGUobm9kZSlcbiAgfVxuXG4gIHJldHVybiBwYXRoXG59XG5cbmV4cG9ydCBmdW5jdGlvbiB0cnlTZWxlY3RvciAodmFsdWUpIHtcbiAgaWYgKCFpcy5zdHJpbmcodmFsdWUpKSB7IHJldHVybiBmYWxzZSB9XG5cbiAgLy8gYW4gZXhjZXB0aW9uIHdpbGwgYmUgcmFpc2VkIGlmIGl0IGlzIGludmFsaWRcbiAgZG9tT2JqZWN0cy5kb2N1bWVudC5xdWVyeVNlbGVjdG9yKHZhbHVlKVxuICByZXR1cm4gdHJ1ZVxufVxuIiwiZXhwb3J0IGludGVyZmFjZSBQb2ludGVyRXh0ZW5kIHtcbiAgd2Via2l0OiBSZWdFeHBcbiAgW3ByZWZpeDogc3RyaW5nXTogUmVnRXhwXG59XG5cbmZ1bmN0aW9uIHBvaW50ZXJFeHRlbmQgKGRlc3QsIHNvdXJjZSkge1xuICBmb3IgKGNvbnN0IHByb3AgaW4gc291cmNlKSB7XG4gICAgY29uc3QgcHJlZml4ZWRQcm9wUkVzID0gcG9pbnRlckV4dGVuZC5wcmVmaXhlZFByb3BSRXNcbiAgICBsZXQgZGVwcmVjYXRlZCA9IGZhbHNlXG5cbiAgICAvLyBza2lwIGRlcHJlY2F0ZWQgcHJlZml4ZWQgcHJvcGVydGllc1xuICAgIGZvciAoY29uc3QgdmVuZG9yIGluIHByZWZpeGVkUHJvcFJFcykge1xuICAgICAgaWYgKHByb3AuaW5kZXhPZih2ZW5kb3IpID09PSAwICYmIHByZWZpeGVkUHJvcFJFc1t2ZW5kb3JdLnRlc3QocHJvcCkpIHtcbiAgICAgICAgZGVwcmVjYXRlZCA9IHRydWVcbiAgICAgICAgYnJlYWtcbiAgICAgIH1cbiAgICB9XG5cbiAgICBpZiAoIWRlcHJlY2F0ZWQgJiYgdHlwZW9mIHNvdXJjZVtwcm9wXSAhPT0gJ2Z1bmN0aW9uJykge1xuICAgICAgZGVzdFtwcm9wXSA9IHNvdXJjZVtwcm9wXVxuICAgIH1cbiAgfVxuICByZXR1cm4gZGVzdFxufVxuXG5wb2ludGVyRXh0ZW5kLnByZWZpeGVkUHJvcFJFcyA9IHtcbiAgd2Via2l0OiAvKE1vdmVtZW50W1hZXXxSYWRpdXNbWFldfFJvdGF0aW9uQW5nbGV8Rm9yY2UpJC8sXG4gIG1vejogLyhQcmVzc3VyZSkkLyxcbn1cblxuZXhwb3J0IGRlZmF1bHQgcG9pbnRlckV4dGVuZFxuIiwiZXhwb3J0IGRlZmF1bHQgKHg6IG51bWJlciwgeTogbnVtYmVyKSA9PiAgTWF0aC5zcXJ0KHggKiB4ICsgeSAqIHkpXG4iLCJpbXBvcnQgYnJvd3NlciBmcm9tICcuL2Jyb3dzZXInXG5pbXBvcnQgZG9tIGZyb20gJy4vZG9tT2JqZWN0cydcbmltcG9ydCAqIGFzIGRvbVV0aWxzIGZyb20gJy4vZG9tVXRpbHMnXG5pbXBvcnQgaHlwb3QgZnJvbSAnLi9oeXBvdCdcbmltcG9ydCAqIGFzIGlzIGZyb20gJy4vaXMnXG5pbXBvcnQgcG9pbnRlckV4dGVuZCBmcm9tICcuL3BvaW50ZXJFeHRlbmQnXG5cbmV4cG9ydCBmdW5jdGlvbiBjb3B5Q29vcmRzIChkZXN0OiBJbnRlcmFjdC5Db29yZHNTZXRNZW1iZXIsIHNyYzogSW50ZXJhY3QuQ29vcmRzU2V0TWVtYmVyKSB7XG4gIGRlc3QucGFnZSA9IGRlc3QucGFnZSB8fCB7fSBhcyBhbnlcbiAgZGVzdC5wYWdlLnggPSBzcmMucGFnZS54XG4gIGRlc3QucGFnZS55ID0gc3JjLnBhZ2UueVxuXG4gIGRlc3QuY2xpZW50ID0gZGVzdC5jbGllbnQgfHwge30gYXMgYW55XG4gIGRlc3QuY2xpZW50LnggPSBzcmMuY2xpZW50LnhcbiAgZGVzdC5jbGllbnQueSA9IHNyYy5jbGllbnQueVxuXG4gIGRlc3QudGltZVN0YW1wID0gc3JjLnRpbWVTdGFtcFxufVxuXG5leHBvcnQgZnVuY3Rpb24gc2V0Q29vcmREZWx0YXMgKHRhcmdldE9iajogSW50ZXJhY3QuQ29vcmRzU2V0TWVtYmVyLCBwcmV2OiBJbnRlcmFjdC5Db29yZHNTZXRNZW1iZXIsIGN1cjogSW50ZXJhY3QuQ29vcmRzU2V0TWVtYmVyKSB7XG4gIHRhcmdldE9iai5wYWdlLnggICAgPSBjdXIucGFnZS54ICAgIC0gcHJldi5wYWdlLnhcbiAgdGFyZ2V0T2JqLnBhZ2UueSAgICA9IGN1ci5wYWdlLnkgICAgLSBwcmV2LnBhZ2UueVxuICB0YXJnZXRPYmouY2xpZW50LnggID0gY3VyLmNsaWVudC54ICAtIHByZXYuY2xpZW50LnhcbiAgdGFyZ2V0T2JqLmNsaWVudC55ICA9IGN1ci5jbGllbnQueSAgLSBwcmV2LmNsaWVudC55XG4gIHRhcmdldE9iai50aW1lU3RhbXAgPSBjdXIudGltZVN0YW1wIC0gcHJldi50aW1lU3RhbXBcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHNldENvb3JkVmVsb2NpdHkgKHRhcmdldE9iajogSW50ZXJhY3QuQ29vcmRzU2V0TWVtYmVyLCBkZWx0YTogSW50ZXJhY3QuQ29vcmRzU2V0TWVtYmVyKSB7XG4gIGNvbnN0IGR0ID0gTWF0aC5tYXgoZGVsdGEudGltZVN0YW1wIC8gMTAwMCwgMC4wMDEpXG5cbiAgdGFyZ2V0T2JqLnBhZ2UueCAgID0gZGVsdGEucGFnZS54IC8gZHRcbiAgdGFyZ2V0T2JqLnBhZ2UueSAgID0gZGVsdGEucGFnZS55IC8gZHRcbiAgdGFyZ2V0T2JqLmNsaWVudC54ID0gZGVsdGEuY2xpZW50LnggLyBkdFxuICB0YXJnZXRPYmouY2xpZW50LnkgPSBkZWx0YS5jbGllbnQueSAvIGR0XG4gIHRhcmdldE9iai50aW1lU3RhbXAgPSBkdFxufVxuXG5leHBvcnQgZnVuY3Rpb24gc2V0WmVyb0Nvb3JkcyAodGFyZ2V0T2JqOiBJbnRlcmFjdC5Db29yZHNTZXRNZW1iZXIpIHtcbiAgdGFyZ2V0T2JqLnBhZ2UueCA9IDBcbiAgdGFyZ2V0T2JqLnBhZ2UueSA9IDBcbiAgdGFyZ2V0T2JqLmNsaWVudC54ID0gMFxuICB0YXJnZXRPYmouY2xpZW50LnkgPSAwXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc05hdGl2ZVBvaW50ZXIgIChwb2ludGVyOiBhbnkpIHtcbiAgcmV0dXJuIChwb2ludGVyIGluc3RhbmNlb2YgZG9tLkV2ZW50IHx8IHBvaW50ZXIgaW5zdGFuY2VvZiBkb20uVG91Y2gpXG59XG5cbi8vIEdldCBzcGVjaWZpZWQgWC9ZIGNvb3JkcyBmb3IgbW91c2Ugb3IgZXZlbnQudG91Y2hlc1swXVxuZXhwb3J0IGZ1bmN0aW9uIGdldFhZICh0eXBlLCBwb2ludGVyLCB4eSkge1xuICB4eSA9IHh5IHx8IHt9XG4gIHR5cGUgPSB0eXBlIHx8ICdwYWdlJ1xuXG4gIHh5LnggPSBwb2ludGVyW3R5cGUgKyAnWCddXG4gIHh5LnkgPSBwb2ludGVyW3R5cGUgKyAnWSddXG5cbiAgcmV0dXJuIHh5XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRQYWdlWFkgKHBvaW50ZXI6IEludGVyYWN0LlBvaW50ZXJUeXBlIHwgSW50ZXJhY3QuSW50ZXJhY3RFdmVudCwgcGFnZT86IEludGVyYWN0LlBvaW50KSB7XG4gIHBhZ2UgPSBwYWdlIHx8IHsgeDogMCwgeTogMCB9XG5cbiAgLy8gT3BlcmEgTW9iaWxlIGhhbmRsZXMgdGhlIHZpZXdwb3J0IGFuZCBzY3JvbGxpbmcgb2RkbHlcbiAgaWYgKGJyb3dzZXIuaXNPcGVyYU1vYmlsZSAmJiBpc05hdGl2ZVBvaW50ZXIocG9pbnRlcikpIHtcbiAgICBnZXRYWSgnc2NyZWVuJywgcG9pbnRlciwgcGFnZSlcblxuICAgIHBhZ2UueCArPSB3aW5kb3cuc2Nyb2xsWFxuICAgIHBhZ2UueSArPSB3aW5kb3cuc2Nyb2xsWVxuICB9XG4gIGVsc2Uge1xuICAgIGdldFhZKCdwYWdlJywgcG9pbnRlciwgcGFnZSlcbiAgfVxuXG4gIHJldHVybiBwYWdlXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRDbGllbnRYWSAocG9pbnRlciwgY2xpZW50KSB7XG4gIGNsaWVudCA9IGNsaWVudCB8fCB7fVxuXG4gIGlmIChicm93c2VyLmlzT3BlcmFNb2JpbGUgJiYgaXNOYXRpdmVQb2ludGVyKHBvaW50ZXIpKSB7XG4gICAgLy8gT3BlcmEgTW9iaWxlIGhhbmRsZXMgdGhlIHZpZXdwb3J0IGFuZCBzY3JvbGxpbmcgb2RkbHlcbiAgICBnZXRYWSgnc2NyZWVuJywgcG9pbnRlciwgY2xpZW50KVxuICB9XG4gIGVsc2Uge1xuICAgIGdldFhZKCdjbGllbnQnLCBwb2ludGVyLCBjbGllbnQpXG4gIH1cblxuICByZXR1cm4gY2xpZW50XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRQb2ludGVySWQgKHBvaW50ZXIpIHtcbiAgcmV0dXJuIGlzLm51bWJlcihwb2ludGVyLnBvaW50ZXJJZCkgPyBwb2ludGVyLnBvaW50ZXJJZCA6IHBvaW50ZXIuaWRlbnRpZmllclxufVxuXG5leHBvcnQgZnVuY3Rpb24gc2V0Q29vcmRzICh0YXJnZXRPYmosIHBvaW50ZXJzOiBhbnlbXSwgdGltZVN0YW1wOiBudW1iZXIpIHtcbiAgY29uc3QgcG9pbnRlciA9IChwb2ludGVycy5sZW5ndGggPiAxXG4gICAgPyBwb2ludGVyQXZlcmFnZShwb2ludGVycylcbiAgICA6IHBvaW50ZXJzWzBdKVxuXG4gIGNvbnN0IHRtcFhZID0ge30gYXMgeyB4OiBudW1iZXIsIHk6IG51bWJlciB9XG5cbiAgZ2V0UGFnZVhZKHBvaW50ZXIsIHRtcFhZKVxuICB0YXJnZXRPYmoucGFnZS54ID0gdG1wWFkueFxuICB0YXJnZXRPYmoucGFnZS55ID0gdG1wWFkueVxuXG4gIGdldENsaWVudFhZKHBvaW50ZXIsIHRtcFhZKVxuICB0YXJnZXRPYmouY2xpZW50LnggPSB0bXBYWS54XG4gIHRhcmdldE9iai5jbGllbnQueSA9IHRtcFhZLnlcblxuICB0YXJnZXRPYmoudGltZVN0YW1wID0gdGltZVN0YW1wXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRUb3VjaFBhaXIgKGV2ZW50KSB7XG4gIGNvbnN0IHRvdWNoZXMgPSBbXVxuXG4gIC8vIGFycmF5IG9mIHRvdWNoZXMgaXMgc3VwcGxpZWRcbiAgaWYgKGlzLmFycmF5KGV2ZW50KSkge1xuICAgIHRvdWNoZXNbMF0gPSBldmVudFswXVxuICAgIHRvdWNoZXNbMV0gPSBldmVudFsxXVxuICB9XG4gIC8vIGFuIGV2ZW50XG4gIGVsc2Uge1xuICAgIGlmIChldmVudC50eXBlID09PSAndG91Y2hlbmQnKSB7XG4gICAgICBpZiAoZXZlbnQudG91Y2hlcy5sZW5ndGggPT09IDEpIHtcbiAgICAgICAgdG91Y2hlc1swXSA9IGV2ZW50LnRvdWNoZXNbMF1cbiAgICAgICAgdG91Y2hlc1sxXSA9IGV2ZW50LmNoYW5nZWRUb3VjaGVzWzBdXG4gICAgICB9XG4gICAgICBlbHNlIGlmIChldmVudC50b3VjaGVzLmxlbmd0aCA9PT0gMCkge1xuICAgICAgICB0b3VjaGVzWzBdID0gZXZlbnQuY2hhbmdlZFRvdWNoZXNbMF1cbiAgICAgICAgdG91Y2hlc1sxXSA9IGV2ZW50LmNoYW5nZWRUb3VjaGVzWzFdXG4gICAgICB9XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdG91Y2hlc1swXSA9IGV2ZW50LnRvdWNoZXNbMF1cbiAgICAgIHRvdWNoZXNbMV0gPSBldmVudC50b3VjaGVzWzFdXG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHRvdWNoZXNcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHBvaW50ZXJBdmVyYWdlIChwb2ludGVyczogUG9pbnRlckV2ZW50W10gfCBFdmVudFtdKSB7XG4gIGNvbnN0IGF2ZXJhZ2UgPSB7XG4gICAgcGFnZVggIDogMCxcbiAgICBwYWdlWSAgOiAwLFxuICAgIGNsaWVudFg6IDAsXG4gICAgY2xpZW50WTogMCxcbiAgICBzY3JlZW5YOiAwLFxuICAgIHNjcmVlblk6IDAsXG4gIH1cblxuICBmb3IgKGNvbnN0IHBvaW50ZXIgb2YgcG9pbnRlcnMpIHtcbiAgICBmb3IgKGNvbnN0IHByb3AgaW4gYXZlcmFnZSkge1xuICAgICAgYXZlcmFnZVtwcm9wXSArPSBwb2ludGVyW3Byb3BdXG4gICAgfVxuICB9XG4gIGZvciAoY29uc3QgcHJvcCBpbiBhdmVyYWdlKSB7XG4gICAgYXZlcmFnZVtwcm9wXSAvPSBwb2ludGVycy5sZW5ndGhcbiAgfVxuXG4gIHJldHVybiBhdmVyYWdlXG59XG5cbmV4cG9ydCBmdW5jdGlvbiB0b3VjaEJCb3ggKGV2ZW50OiBFdmVudCB8IEFycmF5PChJbnRlcmFjdC5Qb2ludGVyVHlwZSkgfCBUb3VjaEV2ZW50Pikge1xuICBpZiAoIShldmVudCBhcyBhbnkpLmxlbmd0aCAmJlxuICAgICAgISgoZXZlbnQgYXMgVG91Y2hFdmVudCkudG91Y2hlcyAmJlxuICAgICAgICAoZXZlbnQgYXMgVG91Y2hFdmVudCkudG91Y2hlcy5sZW5ndGggPiAxKSkge1xuICAgIHJldHVybiBudWxsXG4gIH1cblxuICBjb25zdCB0b3VjaGVzID0gZ2V0VG91Y2hQYWlyKGV2ZW50KVxuICBjb25zdCBtaW5YID0gTWF0aC5taW4odG91Y2hlc1swXS5wYWdlWCwgdG91Y2hlc1sxXS5wYWdlWClcbiAgY29uc3QgbWluWSA9IE1hdGgubWluKHRvdWNoZXNbMF0ucGFnZVksIHRvdWNoZXNbMV0ucGFnZVkpXG4gIGNvbnN0IG1heFggPSBNYXRoLm1heCh0b3VjaGVzWzBdLnBhZ2VYLCB0b3VjaGVzWzFdLnBhZ2VYKVxuICBjb25zdCBtYXhZID0gTWF0aC5tYXgodG91Y2hlc1swXS5wYWdlWSwgdG91Y2hlc1sxXS5wYWdlWSlcblxuICByZXR1cm4ge1xuICAgIHg6IG1pblgsXG4gICAgeTogbWluWSxcbiAgICBsZWZ0OiBtaW5YLFxuICAgIHRvcDogbWluWSxcbiAgICByaWdodDogbWF4WCxcbiAgICBib3R0b206IG1heFksXG4gICAgd2lkdGg6IG1heFggLSBtaW5YLFxuICAgIGhlaWdodDogbWF4WSAtIG1pblksXG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHRvdWNoRGlzdGFuY2UgKGV2ZW50LCBkZWx0YVNvdXJjZSkge1xuICBjb25zdCBzb3VyY2VYID0gZGVsdGFTb3VyY2UgKyAnWCdcbiAgY29uc3Qgc291cmNlWSA9IGRlbHRhU291cmNlICsgJ1knXG4gIGNvbnN0IHRvdWNoZXMgPSBnZXRUb3VjaFBhaXIoZXZlbnQpXG5cbiAgY29uc3QgZHggPSB0b3VjaGVzWzBdW3NvdXJjZVhdIC0gdG91Y2hlc1sxXVtzb3VyY2VYXVxuICBjb25zdCBkeSA9IHRvdWNoZXNbMF1bc291cmNlWV0gLSB0b3VjaGVzWzFdW3NvdXJjZVldXG5cbiAgcmV0dXJuIGh5cG90KGR4LCBkeSlcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHRvdWNoQW5nbGUgKGV2ZW50LCBkZWx0YVNvdXJjZSkge1xuICBjb25zdCBzb3VyY2VYID0gZGVsdGFTb3VyY2UgKyAnWCdcbiAgY29uc3Qgc291cmNlWSA9IGRlbHRhU291cmNlICsgJ1knXG4gIGNvbnN0IHRvdWNoZXMgPSBnZXRUb3VjaFBhaXIoZXZlbnQpXG4gIGNvbnN0IGR4ID0gdG91Y2hlc1sxXVtzb3VyY2VYXSAtIHRvdWNoZXNbMF1bc291cmNlWF1cbiAgY29uc3QgZHkgPSB0b3VjaGVzWzFdW3NvdXJjZVldIC0gdG91Y2hlc1swXVtzb3VyY2VZXVxuICBjb25zdCBhbmdsZSA9IDE4MCAqIE1hdGguYXRhbjIoZHksIGR4KSAvIE1hdGguUElcblxuICByZXR1cm4gIGFuZ2xlXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRQb2ludGVyVHlwZSAocG9pbnRlcikge1xuICByZXR1cm4gaXMuc3RyaW5nKHBvaW50ZXIucG9pbnRlclR5cGUpXG4gICAgPyBwb2ludGVyLnBvaW50ZXJUeXBlXG4gICAgOiBpcy5udW1iZXIocG9pbnRlci5wb2ludGVyVHlwZSlcbiAgICAgID8gW3VuZGVmaW5lZCwgdW5kZWZpbmVkLCAndG91Y2gnLCAncGVuJywgJ21vdXNlJ11bcG9pbnRlci5wb2ludGVyVHlwZV1cbiAgICAgIC8vIGlmIHRoZSBQb2ludGVyRXZlbnQgQVBJIGlzbid0IGF2YWlsYWJsZSwgdGhlbiB0aGUgXCJwb2ludGVyXCIgbXVzdFxuICAgICAgLy8gYmUgZWl0aGVyIGEgTW91c2VFdmVudCwgVG91Y2hFdmVudCwgb3IgVG91Y2ggb2JqZWN0XG4gICAgICA6IC90b3VjaC8udGVzdChwb2ludGVyLnR5cGUpIHx8IHBvaW50ZXIgaW5zdGFuY2VvZiBkb20uVG91Y2hcbiAgICAgICAgPyAndG91Y2gnXG4gICAgICAgIDogJ21vdXNlJ1xufVxuXG4vLyBbIGV2ZW50LnRhcmdldCwgZXZlbnQuY3VycmVudFRhcmdldCBdXG5leHBvcnQgZnVuY3Rpb24gZ2V0RXZlbnRUYXJnZXRzIChldmVudCkge1xuICBjb25zdCBwYXRoID0gaXMuZnVuYyhldmVudC5jb21wb3NlZFBhdGgpID8gZXZlbnQuY29tcG9zZWRQYXRoKCkgOiBldmVudC5wYXRoXG5cbiAgcmV0dXJuIFtcbiAgICBkb21VdGlscy5nZXRBY3R1YWxFbGVtZW50KHBhdGggPyBwYXRoWzBdIDogZXZlbnQudGFyZ2V0KSxcbiAgICBkb21VdGlscy5nZXRBY3R1YWxFbGVtZW50KGV2ZW50LmN1cnJlbnRUYXJnZXQpLFxuICBdXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBuZXdDb29yZHMgKCk6IEludGVyYWN0LkNvb3Jkc1NldE1lbWJlciB7XG4gIHJldHVybiB7XG4gICAgcGFnZSAgICAgOiB7IHg6IDAsIHk6IDAgfSxcbiAgICBjbGllbnQgICA6IHsgeDogMCwgeTogMCB9LFxuICAgIHRpbWVTdGFtcDogMCxcbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gY29vcmRzVG9FdmVudCAoY29vcmRzOiBNb2NrQ29vcmRzKSB7XG4gIGNvbnN0IGV2ZW50ID0ge1xuICAgIGNvb3JkcyxcbiAgICBnZXQgcGFnZSAoKSB7IHJldHVybiB0aGlzLmNvb3Jkcy5wYWdlIH0sXG4gICAgZ2V0IGNsaWVudCAoKSB7IHJldHVybiB0aGlzLmNvb3Jkcy5jbGllbnQgfSxcbiAgICBnZXQgdGltZVN0YW1wICgpIHsgcmV0dXJuIHRoaXMuY29vcmRzLnRpbWVTdGFtcCB9LFxuICAgIGdldCBwYWdlWCAoKSB7IHJldHVybiB0aGlzLmNvb3Jkcy5wYWdlLnggfSxcbiAgICBnZXQgcGFnZVkgKCkgeyByZXR1cm4gdGhpcy5jb29yZHMucGFnZS55IH0sXG4gICAgZ2V0IGNsaWVudFggKCkgeyByZXR1cm4gdGhpcy5jb29yZHMuY2xpZW50LnggfSxcbiAgICBnZXQgY2xpZW50WSAoKSB7IHJldHVybiB0aGlzLmNvb3Jkcy5jbGllbnQueSB9LFxuICAgIGdldCBwb2ludGVySWQgKCkgeyByZXR1cm4gdGhpcy5jb29yZHMucG9pbnRlcklkIH0sXG4gICAgZ2V0IHRhcmdldCAoKSB7IHJldHVybiB0aGlzLmNvb3Jkcy50YXJnZXQgfSxcbiAgICBnZXQgdHlwZSAoKSB7IHJldHVybiB0aGlzLmNvb3Jkcy50eXBlIH0sXG4gICAgZ2V0IHBvaW50ZXJUeXBlICgpIHsgcmV0dXJuIHRoaXMuY29vcmRzLnBvaW50ZXJUeXBlIH0sXG4gICAgZ2V0IGJ1dHRvbnMgKCkgeyByZXR1cm4gdGhpcy5jb29yZHMuYnV0dG9ucyB9LFxuICAgIHByZXZlbnREZWZhdWx0ICgpIHt9LFxuICB9XG5cbiAgcmV0dXJuIGV2ZW50IGFzIHR5cGVvZiBldmVudCAmIEludGVyYWN0LlBvaW50ZXJUeXBlICYgSW50ZXJhY3QuUG9pbnRlckV2ZW50VHlwZVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIE1vY2tDb29yZHMge1xuICBwYWdlOiBJbnRlcmFjdC5Qb2ludFxuICBjbGllbnQ6IEludGVyYWN0LlBvaW50XG4gIHRpbWVTdGFtcD86IG51bWJlclxuICBwb2ludGVySWQ/OiBhbnlcbiAgdGFyZ2V0PzogYW55XG4gIHR5cGU/OiBzdHJpbmdcbiAgcG9pbnRlclR5cGU/OiBzdHJpbmdcbiAgYnV0dG9ucz86IG51bWJlclxufVxuXG5leHBvcnQgeyBwb2ludGVyRXh0ZW5kIH1cbiIsImltcG9ydCB7IGNvbnRhaW5zIH0gZnJvbSAnLi9hcnInXG5pbXBvcnQgKiBhcyBkb21VdGlscyBmcm9tICcuL2RvbVV0aWxzJ1xuaW1wb3J0ICogYXMgaXMgZnJvbSAnLi9pcydcbmltcG9ydCBwRXh0ZW5kIGZyb20gJy4vcG9pbnRlckV4dGVuZCdcbmltcG9ydCAqIGFzIHBvaW50ZXJVdGlscyBmcm9tICcuL3BvaW50ZXJVdGlscydcblxudHlwZSBMaXN0ZW5lciA9IChldmVudDogRXZlbnQgfCBGYWtlRXZlbnQpID0+IGFueVxuXG5jb25zdCBlbGVtZW50czogRXZlbnRUYXJnZXRbXSA9IFtdXG5jb25zdCB0YXJnZXRzOiBBcnJheTx7XG4gIGV2ZW50czogeyBbdHlwZTogc3RyaW5nXTogTGlzdGVuZXJbXSB9XG4gIHR5cGVDb3VudDogbnVtYmVyXG59PiA9IFtdXG5cbmNvbnN0IGRlbGVnYXRlZEV2ZW50czoge1xuICBbdHlwZTogc3RyaW5nXToge1xuICAgIHNlbGVjdG9yczogc3RyaW5nW11cbiAgICBjb250ZXh0czogTm9kZVtdXG4gICAgbGlzdGVuZXJzOiBBcnJheTxBcnJheTxbTGlzdGVuZXIsIGJvb2xlYW4sIGJvb2xlYW5dPj5cbiAgfVxufSA9IHt9XG5jb25zdCBkb2N1bWVudHM6IERvY3VtZW50W10gPSBbXVxuXG5mdW5jdGlvbiBhZGQgKGVsZW1lbnQ6IEV2ZW50VGFyZ2V0LCB0eXBlOiBzdHJpbmcsIGxpc3RlbmVyOiBMaXN0ZW5lciwgb3B0aW9uYWxBcmc/OiBib29sZWFuIHwgYW55KSB7XG4gIGNvbnN0IG9wdGlvbnMgPSBnZXRPcHRpb25zKG9wdGlvbmFsQXJnKVxuICBsZXQgZWxlbWVudEluZGV4ID0gZWxlbWVudHMuaW5kZXhPZihlbGVtZW50KVxuICBsZXQgdGFyZ2V0ID0gdGFyZ2V0c1tlbGVtZW50SW5kZXhdXG5cbiAgaWYgKCF0YXJnZXQpIHtcbiAgICB0YXJnZXQgPSB7XG4gICAgICBldmVudHM6IHt9LFxuICAgICAgdHlwZUNvdW50OiAwLFxuICAgIH1cblxuICAgIGVsZW1lbnRJbmRleCA9IGVsZW1lbnRzLnB1c2goZWxlbWVudCkgLSAxXG4gICAgdGFyZ2V0cy5wdXNoKHRhcmdldClcbiAgfVxuXG4gIGlmICghdGFyZ2V0LmV2ZW50c1t0eXBlXSkge1xuICAgIHRhcmdldC5ldmVudHNbdHlwZV0gPSBbXVxuICAgIHRhcmdldC50eXBlQ291bnQrK1xuICB9XG5cbiAgaWYgKGVsZW1lbnQucmVtb3ZlRXZlbnRMaXN0ZW5lciAmJiAhY29udGFpbnModGFyZ2V0LmV2ZW50c1t0eXBlXSwgbGlzdGVuZXIpKSB7XG4gICAgZWxlbWVudC5hZGRFdmVudExpc3RlbmVyKHR5cGUsIGxpc3RlbmVyIGFzIGFueSwgZXZlbnRzLnN1cHBvcnRzT3B0aW9ucyA/IG9wdGlvbnMgOiAhIW9wdGlvbnMuY2FwdHVyZSlcbiAgICB0YXJnZXQuZXZlbnRzW3R5cGVdLnB1c2gobGlzdGVuZXIpXG4gIH1cbn1cblxuZnVuY3Rpb24gcmVtb3ZlIChlbGVtZW50OiBFdmVudFRhcmdldCwgdHlwZTogc3RyaW5nLCBsaXN0ZW5lcj86ICdhbGwnIHwgTGlzdGVuZXIsIG9wdGlvbmFsQXJnPzogYm9vbGVhbiB8IGFueSkge1xuICBjb25zdCBvcHRpb25zID0gZ2V0T3B0aW9ucyhvcHRpb25hbEFyZylcbiAgY29uc3QgZWxlbWVudEluZGV4ID0gZWxlbWVudHMuaW5kZXhPZihlbGVtZW50KVxuICBjb25zdCB0YXJnZXQgPSB0YXJnZXRzW2VsZW1lbnRJbmRleF1cblxuICBpZiAoIXRhcmdldCB8fCAhdGFyZ2V0LmV2ZW50cykge1xuICAgIHJldHVyblxuICB9XG5cbiAgaWYgKHR5cGUgPT09ICdhbGwnKSB7XG4gICAgZm9yICh0eXBlIGluIHRhcmdldC5ldmVudHMpIHtcbiAgICAgIGlmICh0YXJnZXQuZXZlbnRzLmhhc093blByb3BlcnR5KHR5cGUpKSB7XG4gICAgICAgIHJlbW92ZShlbGVtZW50LCB0eXBlLCAnYWxsJylcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuXG4gIH1cblxuICBpZiAodGFyZ2V0LmV2ZW50c1t0eXBlXSkge1xuICAgIGNvbnN0IGxlbiA9IHRhcmdldC5ldmVudHNbdHlwZV0ubGVuZ3RoXG5cbiAgICBpZiAobGlzdGVuZXIgPT09ICdhbGwnKSB7XG4gICAgICBmb3IgKGxldCBpID0gMDsgaSA8IGxlbjsgaSsrKSB7XG4gICAgICAgIHJlbW92ZShlbGVtZW50LCB0eXBlLCB0YXJnZXQuZXZlbnRzW3R5cGVdW2ldLCBvcHRpb25zKVxuICAgICAgfVxuICAgICAgcmV0dXJuXG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCBsZW47IGkrKykge1xuICAgICAgICBpZiAoZWxlbWVudC5yZW1vdmVFdmVudExpc3RlbmVyICYmIHRhcmdldC5ldmVudHNbdHlwZV1baV0gPT09IGxpc3RlbmVyKSB7XG4gICAgICAgICAgZWxlbWVudC5yZW1vdmVFdmVudExpc3RlbmVyKHR5cGUsIGxpc3RlbmVyIGFzIGFueSwgZXZlbnRzLnN1cHBvcnRzT3B0aW9ucyA/IG9wdGlvbnMgOiAhIW9wdGlvbnMuY2FwdHVyZSlcbiAgICAgICAgICB0YXJnZXQuZXZlbnRzW3R5cGVdLnNwbGljZShpLCAxKVxuXG4gICAgICAgICAgYnJlYWtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cblxuICAgIGlmICh0YXJnZXQuZXZlbnRzW3R5cGVdICYmIHRhcmdldC5ldmVudHNbdHlwZV0ubGVuZ3RoID09PSAwKSB7XG4gICAgICAodGFyZ2V0LmV2ZW50c1t0eXBlXSBhcyBhbnkpID0gbnVsbFxuICAgICAgdGFyZ2V0LnR5cGVDb3VudC0tXG4gICAgfVxuICB9XG5cbiAgaWYgKCF0YXJnZXQudHlwZUNvdW50KSB7XG4gICAgdGFyZ2V0cy5zcGxpY2UoZWxlbWVudEluZGV4LCAxKVxuICAgIGVsZW1lbnRzLnNwbGljZShlbGVtZW50SW5kZXgsIDEpXG4gIH1cbn1cblxuZnVuY3Rpb24gYWRkRGVsZWdhdGUgKHNlbGVjdG9yOiBzdHJpbmcsIGNvbnRleHQ6IE5vZGUsIHR5cGU6IHN0cmluZywgbGlzdGVuZXI6IExpc3RlbmVyLCBvcHRpb25hbEFyZz86IGFueSkge1xuICBjb25zdCBvcHRpb25zID0gZ2V0T3B0aW9ucyhvcHRpb25hbEFyZylcbiAgaWYgKCFkZWxlZ2F0ZWRFdmVudHNbdHlwZV0pIHtcbiAgICBkZWxlZ2F0ZWRFdmVudHNbdHlwZV0gPSB7XG4gICAgICBjb250ZXh0cyA6IFtdLFxuICAgICAgbGlzdGVuZXJzOiBbXSxcbiAgICAgIHNlbGVjdG9yczogW10sXG4gICAgfVxuXG4gICAgLy8gYWRkIGRlbGVnYXRlIGxpc3RlbmVyIGZ1bmN0aW9uc1xuICAgIGZvciAoY29uc3QgZG9jIG9mIGRvY3VtZW50cykge1xuICAgICAgYWRkKGRvYywgdHlwZSwgZGVsZWdhdGVMaXN0ZW5lcilcbiAgICAgIGFkZChkb2MsIHR5cGUsIGRlbGVnYXRlVXNlQ2FwdHVyZSwgdHJ1ZSlcbiAgICB9XG4gIH1cblxuICBjb25zdCBkZWxlZ2F0ZWQgPSBkZWxlZ2F0ZWRFdmVudHNbdHlwZV1cbiAgbGV0IGluZGV4XG5cbiAgZm9yIChpbmRleCA9IGRlbGVnYXRlZC5zZWxlY3RvcnMubGVuZ3RoIC0gMTsgaW5kZXggPj0gMDsgaW5kZXgtLSkge1xuICAgIGlmIChkZWxlZ2F0ZWQuc2VsZWN0b3JzW2luZGV4XSA9PT0gc2VsZWN0b3IgJiZcbiAgICAgICAgZGVsZWdhdGVkLmNvbnRleHRzW2luZGV4XSA9PT0gY29udGV4dCkge1xuICAgICAgYnJlYWtcbiAgICB9XG4gIH1cblxuICBpZiAoaW5kZXggPT09IC0xKSB7XG4gICAgaW5kZXggPSBkZWxlZ2F0ZWQuc2VsZWN0b3JzLmxlbmd0aFxuXG4gICAgZGVsZWdhdGVkLnNlbGVjdG9ycy5wdXNoKHNlbGVjdG9yKVxuICAgIGRlbGVnYXRlZC5jb250ZXh0cy5wdXNoKGNvbnRleHQpXG4gICAgZGVsZWdhdGVkLmxpc3RlbmVycy5wdXNoKFtdKVxuICB9XG5cbiAgLy8ga2VlcCBsaXN0ZW5lciBhbmQgY2FwdHVyZSBhbmQgcGFzc2l2ZSBmbGFnc1xuICBkZWxlZ2F0ZWQubGlzdGVuZXJzW2luZGV4XS5wdXNoKFtsaXN0ZW5lciwgISFvcHRpb25zLmNhcHR1cmUsIG9wdGlvbnMucGFzc2l2ZV0pXG59XG5cbmZ1bmN0aW9uIHJlbW92ZURlbGVnYXRlIChcbiAgc2VsZWN0b3I6IHN0cmluZyxcbiAgY29udGV4dDogRG9jdW1lbnQgfCBJbnRlcmFjdC5FbGVtZW50LFxuICB0eXBlOiBzdHJpbmcsXG4gIGxpc3RlbmVyPzogTGlzdGVuZXIsXG4gIG9wdGlvbmFsQXJnPzogYW55LFxuKSB7XG4gIGNvbnN0IG9wdGlvbnMgPSBnZXRPcHRpb25zKG9wdGlvbmFsQXJnKVxuICBjb25zdCBkZWxlZ2F0ZWQgPSBkZWxlZ2F0ZWRFdmVudHNbdHlwZV1cbiAgbGV0IG1hdGNoRm91bmQgPSBmYWxzZVxuICBsZXQgaW5kZXhcblxuICBpZiAoIWRlbGVnYXRlZCkgeyByZXR1cm4gfVxuXG4gIC8vIGNvdW50IGZyb20gbGFzdCBpbmRleCBvZiBkZWxlZ2F0ZWQgdG8gMFxuICBmb3IgKGluZGV4ID0gZGVsZWdhdGVkLnNlbGVjdG9ycy5sZW5ndGggLSAxOyBpbmRleCA+PSAwOyBpbmRleC0tKSB7XG4gICAgLy8gbG9vayBmb3IgbWF0Y2hpbmcgc2VsZWN0b3IgYW5kIGNvbnRleHQgTm9kZVxuICAgIGlmIChkZWxlZ2F0ZWQuc2VsZWN0b3JzW2luZGV4XSA9PT0gc2VsZWN0b3IgJiZcbiAgICAgICAgZGVsZWdhdGVkLmNvbnRleHRzW2luZGV4XSA9PT0gY29udGV4dCkge1xuICAgICAgY29uc3QgbGlzdGVuZXJzID0gZGVsZWdhdGVkLmxpc3RlbmVyc1tpbmRleF1cblxuICAgICAgLy8gZWFjaCBpdGVtIG9mIHRoZSBsaXN0ZW5lcnMgYXJyYXkgaXMgYW4gYXJyYXk6IFtmdW5jdGlvbiwgY2FwdHVyZSwgcGFzc2l2ZV1cbiAgICAgIGZvciAobGV0IGkgPSBsaXN0ZW5lcnMubGVuZ3RoIC0gMTsgaSA+PSAwOyBpLS0pIHtcbiAgICAgICAgY29uc3QgW2ZuLCBjYXB0dXJlLCBwYXNzaXZlXSA9IGxpc3RlbmVyc1tpXVxuXG4gICAgICAgIC8vIGNoZWNrIGlmIHRoZSBsaXN0ZW5lciBmdW5jdGlvbnMgYW5kIGNhcHR1cmUgYW5kIHBhc3NpdmUgZmxhZ3MgbWF0Y2hcbiAgICAgICAgaWYgKGZuID09PSBsaXN0ZW5lciAmJiBjYXB0dXJlID09PSAhIW9wdGlvbnMuY2FwdHVyZSAmJiBwYXNzaXZlID09PSBvcHRpb25zLnBhc3NpdmUpIHtcbiAgICAgICAgICAvLyByZW1vdmUgdGhlIGxpc3RlbmVyIGZyb20gdGhlIGFycmF5IG9mIGxpc3RlbmVyc1xuICAgICAgICAgIGxpc3RlbmVycy5zcGxpY2UoaSwgMSlcblxuICAgICAgICAgIC8vIGlmIGFsbCBsaXN0ZW5lcnMgZm9yIHRoaXMgaW50ZXJhY3RhYmxlIGhhdmUgYmVlbiByZW1vdmVkXG4gICAgICAgICAgLy8gcmVtb3ZlIHRoZSBpbnRlcmFjdGFibGUgZnJvbSB0aGUgZGVsZWdhdGVkIGFycmF5c1xuICAgICAgICAgIGlmICghbGlzdGVuZXJzLmxlbmd0aCkge1xuICAgICAgICAgICAgZGVsZWdhdGVkLnNlbGVjdG9ycy5zcGxpY2UoaW5kZXgsIDEpXG4gICAgICAgICAgICBkZWxlZ2F0ZWQuY29udGV4dHMuc3BsaWNlKGluZGV4LCAxKVxuICAgICAgICAgICAgZGVsZWdhdGVkLmxpc3RlbmVycy5zcGxpY2UoaW5kZXgsIDEpXG5cbiAgICAgICAgICAgIC8vIHJlbW92ZSBkZWxlZ2F0ZSBmdW5jdGlvbiBmcm9tIGNvbnRleHRcbiAgICAgICAgICAgIHJlbW92ZShjb250ZXh0LCB0eXBlLCBkZWxlZ2F0ZUxpc3RlbmVyKVxuICAgICAgICAgICAgcmVtb3ZlKGNvbnRleHQsIHR5cGUsIGRlbGVnYXRlVXNlQ2FwdHVyZSwgdHJ1ZSlcblxuICAgICAgICAgICAgLy8gcmVtb3ZlIHRoZSBhcnJheXMgaWYgdGhleSBhcmUgZW1wdHlcbiAgICAgICAgICAgIGlmICghZGVsZWdhdGVkLnNlbGVjdG9ycy5sZW5ndGgpIHtcbiAgICAgICAgICAgICAgZGVsZWdhdGVkRXZlbnRzW3R5cGVdID0gbnVsbFxuICAgICAgICAgICAgfVxuICAgICAgICAgIH1cblxuICAgICAgICAgIC8vIG9ubHkgcmVtb3ZlIG9uZSBsaXN0ZW5lclxuICAgICAgICAgIG1hdGNoRm91bmQgPSB0cnVlXG4gICAgICAgICAgYnJlYWtcbiAgICAgICAgfVxuICAgICAgfVxuXG4gICAgICBpZiAobWF0Y2hGb3VuZCkgeyBicmVhayB9XG4gICAgfVxuICB9XG59XG5cbi8vIGJvdW5kIHRvIHRoZSBpbnRlcmFjdGFibGUgY29udGV4dCB3aGVuIGEgRE9NIGV2ZW50XG4vLyBsaXN0ZW5lciBpcyBhZGRlZCB0byBhIHNlbGVjdG9yIGludGVyYWN0YWJsZVxuZnVuY3Rpb24gZGVsZWdhdGVMaXN0ZW5lciAoZXZlbnQ6IEV2ZW50LCBvcHRpb25hbEFyZz86IGFueSkge1xuICBjb25zdCBvcHRpb25zID0gZ2V0T3B0aW9ucyhvcHRpb25hbEFyZylcbiAgY29uc3QgZmFrZUV2ZW50ID0gbmV3IEZha2VFdmVudChldmVudClcbiAgY29uc3QgZGVsZWdhdGVkID0gZGVsZWdhdGVkRXZlbnRzW2V2ZW50LnR5cGVdXG4gIGNvbnN0IFtldmVudFRhcmdldF0gPSAocG9pbnRlclV0aWxzLmdldEV2ZW50VGFyZ2V0cyhldmVudCkpXG4gIGxldCBlbGVtZW50OiBOb2RlID0gZXZlbnRUYXJnZXRcblxuICAvLyBjbGltYiB1cCBkb2N1bWVudCB0cmVlIGxvb2tpbmcgZm9yIHNlbGVjdG9yIG1hdGNoZXNcbiAgd2hpbGUgKGlzLmVsZW1lbnQoZWxlbWVudCkpIHtcbiAgICBmb3IgKGxldCBpID0gMDsgaSA8IGRlbGVnYXRlZC5zZWxlY3RvcnMubGVuZ3RoOyBpKyspIHtcbiAgICAgIGNvbnN0IHNlbGVjdG9yID0gZGVsZWdhdGVkLnNlbGVjdG9yc1tpXVxuICAgICAgY29uc3QgY29udGV4dCA9IGRlbGVnYXRlZC5jb250ZXh0c1tpXVxuXG4gICAgICBpZiAoZG9tVXRpbHMubWF0Y2hlc1NlbGVjdG9yKGVsZW1lbnQsIHNlbGVjdG9yKSAmJlxuICAgICAgICAgIGRvbVV0aWxzLm5vZGVDb250YWlucyhjb250ZXh0LCBldmVudFRhcmdldCkgJiZcbiAgICAgICAgICBkb21VdGlscy5ub2RlQ29udGFpbnMoY29udGV4dCwgZWxlbWVudCkpIHtcbiAgICAgICAgY29uc3QgbGlzdGVuZXJzID0gZGVsZWdhdGVkLmxpc3RlbmVyc1tpXVxuXG4gICAgICAgIGZha2VFdmVudC5jdXJyZW50VGFyZ2V0ID0gZWxlbWVudFxuXG4gICAgICAgIGZvciAoY29uc3QgW2ZuLCBjYXB0dXJlLCBwYXNzaXZlXSBvZiBsaXN0ZW5lcnMpIHtcbiAgICAgICAgICBpZiAoY2FwdHVyZSA9PT0gISFvcHRpb25zLmNhcHR1cmUgJiYgcGFzc2l2ZSA9PT0gb3B0aW9ucy5wYXNzaXZlKSB7XG4gICAgICAgICAgICBmbihmYWtlRXZlbnQpXG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuXG4gICAgZWxlbWVudCA9IGRvbVV0aWxzLnBhcmVudE5vZGUoZWxlbWVudClcbiAgfVxufVxuXG5mdW5jdGlvbiBkZWxlZ2F0ZVVzZUNhcHR1cmUgKGV2ZW50OiBFdmVudCkge1xuICByZXR1cm4gZGVsZWdhdGVMaXN0ZW5lci5jYWxsKHRoaXMsIGV2ZW50LCB0cnVlKVxufVxuXG5mdW5jdGlvbiBnZXRPcHRpb25zIChwYXJhbTogb2JqZWN0KSB7XG4gIHJldHVybiBpcy5vYmplY3QocGFyYW0pID8gcGFyYW0gOiB7IGNhcHR1cmU6IHBhcmFtIH1cbn1cblxuZXhwb3J0IGNsYXNzIEZha2VFdmVudCBpbXBsZW1lbnRzIFBhcnRpYWw8RXZlbnQ+IHtcbiAgY3VycmVudFRhcmdldDogRXZlbnRUYXJnZXRcblxuICBjb25zdHJ1Y3RvciAocHVibGljIG9yaWdpbmFsRXZlbnQ6IEV2ZW50KSB7XG4gICAgLy8gZHVwbGljYXRlIHRoZSBldmVudCBzbyB0aGF0IGN1cnJlbnRUYXJnZXQgY2FuIGJlIGNoYW5nZWRcbiAgICBwRXh0ZW5kKHRoaXMsIG9yaWdpbmFsRXZlbnQpXG4gIH1cblxuICBwcmV2ZW50T3JpZ2luYWxEZWZhdWx0ICgpIHtcbiAgICB0aGlzLm9yaWdpbmFsRXZlbnQucHJldmVudERlZmF1bHQoKVxuICB9XG5cbiAgc3RvcFByb3BhZ2F0aW9uICgpIHtcbiAgICB0aGlzLm9yaWdpbmFsRXZlbnQuc3RvcFByb3BhZ2F0aW9uKClcbiAgfVxuXG4gIHN0b3BJbW1lZGlhdGVQcm9wYWdhdGlvbiAoKSB7XG4gICAgdGhpcy5vcmlnaW5hbEV2ZW50LnN0b3BJbW1lZGlhdGVQcm9wYWdhdGlvbigpXG4gIH1cbn1cblxuY29uc3QgZXZlbnRzID0ge1xuICBhZGQsXG4gIHJlbW92ZSxcblxuICBhZGREZWxlZ2F0ZSxcbiAgcmVtb3ZlRGVsZWdhdGUsXG5cbiAgZGVsZWdhdGVMaXN0ZW5lcixcbiAgZGVsZWdhdGVVc2VDYXB0dXJlLFxuICBkZWxlZ2F0ZWRFdmVudHMsXG4gIGRvY3VtZW50cyxcblxuICBzdXBwb3J0c09wdGlvbnM6IGZhbHNlLFxuICBzdXBwb3J0c1Bhc3NpdmU6IGZhbHNlLFxuXG4gIF9lbGVtZW50czogZWxlbWVudHMsXG4gIF90YXJnZXRzOiB0YXJnZXRzLFxuXG4gIGluaXQgKHdpbmRvdzogV2luZG93KSB7XG4gICAgd2luZG93LmRvY3VtZW50LmNyZWF0ZUVsZW1lbnQoJ2RpdicpLmFkZEV2ZW50TGlzdGVuZXIoJ3Rlc3QnLCBudWxsLCB7XG4gICAgICBnZXQgY2FwdHVyZSAoKSB7IHJldHVybiAoZXZlbnRzLnN1cHBvcnRzT3B0aW9ucyA9IHRydWUpIH0sXG4gICAgICBnZXQgcGFzc2l2ZSAoKSB7IHJldHVybiAoZXZlbnRzLnN1cHBvcnRzUGFzc2l2ZSA9IHRydWUpIH0sXG4gICAgfSlcbiAgfSxcbn1cblxuZXhwb3J0IGRlZmF1bHQgZXZlbnRzXG4iLCJleHBvcnQgZGVmYXVsdCBmdW5jdGlvbiBleHRlbmQ8VCwgVSBleHRlbmRzIG9iamVjdD4gKGRlc3Q6IFUgJiBQYXJ0aWFsPFQ+LCBzb3VyY2U6IFQpOiBUICYgVSB7XG4gIGZvciAoY29uc3QgcHJvcCBpbiBzb3VyY2UpIHtcbiAgICAoZGVzdCBhcyB1bmtub3duIGFzIFQpW3Byb3BdID0gc291cmNlW3Byb3BdXG4gIH1cblxuICBjb25zdCByZXQgPSBkZXN0IGFzIFQgJiBVXG5cbiAgcmV0dXJuIHJldFxufVxuIiwiaW1wb3J0IGV4dGVuZCBmcm9tICcuL2V4dGVuZCdcbmltcG9ydCAqIGFzIGlzIGZyb20gJy4vaXMnXG5cbmV4cG9ydCBpbnRlcmZhY2UgTm9ybWFsaXplZExpc3RlbmVycyB7XG4gIFt0eXBlOiBzdHJpbmddOiBJbnRlcmFjdC5MaXN0ZW5lcltdXG59XG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIG5vcm1hbGl6ZSAoXG4gIHR5cGU6IEludGVyYWN0LkV2ZW50VHlwZXMsXG4gIGxpc3RlbmVycz86IEludGVyYWN0Lkxpc3RlbmVyc0FyZyB8IEludGVyYWN0Lkxpc3RlbmVyc0FyZ1tdLFxuICByZXN1bHQ/OiBOb3JtYWxpemVkTGlzdGVuZXJzLFxuKTogTm9ybWFsaXplZExpc3RlbmVycyB7XG4gIHJlc3VsdCA9IHJlc3VsdCB8fCB7fVxuXG4gIGlmIChpcy5zdHJpbmcodHlwZSkgJiYgdHlwZS5zZWFyY2goJyAnKSAhPT0gLTEpIHtcbiAgICB0eXBlID0gc3BsaXQodHlwZSlcbiAgfVxuXG4gIGlmIChpcy5hcnJheSh0eXBlKSkge1xuICAgIHJldHVybiB0eXBlLnJlZHVjZTxOb3JtYWxpemVkTGlzdGVuZXJzPihcbiAgICAgIChhY2MsIHQpID0+IGV4dGVuZChhY2MsIG5vcm1hbGl6ZSh0LCBsaXN0ZW5lcnMsIHJlc3VsdCkpLFxuICAgICAgcmVzdWx0LFxuICAgIClcbiAgfVxuXG4gIC8vICh7IHR5cGU6IGZuIH0pIC0+ICgnJywgeyB0eXBlOiBmbiB9KVxuICBpZiAoaXMub2JqZWN0KHR5cGUpKSB7XG4gICAgbGlzdGVuZXJzID0gdHlwZVxuICAgIHR5cGUgPSAnJ1xuICB9XG5cbiAgaWYgKGlzLmZ1bmMobGlzdGVuZXJzKSkge1xuICAgIHJlc3VsdFt0eXBlXSA9IHJlc3VsdFt0eXBlXSB8fCBbXVxuICAgIHJlc3VsdFt0eXBlXS5wdXNoKGxpc3RlbmVycylcbiAgfVxuICBlbHNlIGlmIChpcy5hcnJheShsaXN0ZW5lcnMpKSB7XG4gICAgZm9yIChjb25zdCBsIG9mIGxpc3RlbmVycykge1xuICAgICAgbm9ybWFsaXplKHR5cGUsIGwsIHJlc3VsdClcbiAgICB9XG4gIH1cbiAgZWxzZSBpZiAoaXMub2JqZWN0KGxpc3RlbmVycykpIHtcbiAgICBmb3IgKGNvbnN0IHByZWZpeCBpbiBsaXN0ZW5lcnMpIHtcbiAgICAgIGNvbnN0IGNvbWJpbmVkVHlwZXMgPSBzcGxpdChwcmVmaXgpLm1hcChwID0+IGAke3R5cGV9JHtwfWApXG5cbiAgICAgIG5vcm1hbGl6ZShjb21iaW5lZFR5cGVzLCBsaXN0ZW5lcnNbcHJlZml4XSwgcmVzdWx0KVxuICAgIH1cbiAgfVxuXG4gIHJldHVybiByZXN1bHQgYXMgTm9ybWFsaXplZExpc3RlbmVyc1xufVxuXG5mdW5jdGlvbiBzcGxpdCAodHlwZTogc3RyaW5nKSB7XG4gIHJldHVybiB0eXBlLnRyaW0oKS5zcGxpdCgvICsvKVxufVxuIiwiaW1wb3J0ICogYXMgYXJyIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2FycidcbmltcG9ydCBleHRlbmQgZnJvbSAnQGludGVyYWN0anMvdXRpbHMvZXh0ZW5kJ1xuaW1wb3J0IG5vcm1hbGl6ZSwgeyBOb3JtYWxpemVkTGlzdGVuZXJzIH0gZnJvbSAnQGludGVyYWN0anMvdXRpbHMvbm9ybWFsaXplTGlzdGVuZXJzJ1xuXG5mdW5jdGlvbiBmaXJlVW50aWxJbW1lZGlhdGVTdG9wcGVkPFxuICBUIGV4dGVuZHMgSW50ZXJhY3QuQWN0aW9uTmFtZSxcbiAgUCBleHRlbmRzIEludGVyYWN0LkV2ZW50UGhhc2UsXG4+IChldmVudDogSW50ZXJhY3QuSW50ZXJhY3RFdmVudDxULCBQPiwgbGlzdGVuZXJzOiBJbnRlcmFjdC5MaXN0ZW5lcltdKSB7XG4gIGZvciAoY29uc3QgbGlzdGVuZXIgb2YgbGlzdGVuZXJzKSB7XG4gICAgaWYgKGV2ZW50LmltbWVkaWF0ZVByb3BhZ2F0aW9uU3RvcHBlZCkgeyBicmVhayB9XG5cbiAgICBsaXN0ZW5lcihldmVudClcbiAgfVxufVxuXG5jbGFzcyBFdmVudGFibGUge1xuICBvcHRpb25zOiBhbnlcbiAgdHlwZXM6IE5vcm1hbGl6ZWRMaXN0ZW5lcnMgPSB7fVxuICBwcm9wYWdhdGlvblN0b3BwZWQgPSBmYWxzZVxuICBpbW1lZGlhdGVQcm9wYWdhdGlvblN0b3BwZWQgPSBmYWxzZVxuICBnbG9iYWw6IGFueVxuXG4gIGNvbnN0cnVjdG9yIChvcHRpb25zPzogeyBbaW5kZXg6IHN0cmluZ106IGFueSB9KSB7XG4gICAgdGhpcy5vcHRpb25zID0gZXh0ZW5kKHt9LCBvcHRpb25zIHx8IHt9KVxuICB9XG5cbiAgZmlyZSAoZXZlbnQ6IGFueSkge1xuICAgIGxldCBsaXN0ZW5lcnNcbiAgICBjb25zdCBnbG9iYWwgPSB0aGlzLmdsb2JhbFxuXG4gICAgLy8gSW50ZXJhY3RhYmxlI29uKCkgbGlzdGVuZXJzXG4gICAgLy8gdHNsaW50OmRpc2FibGUgbm8tY29uZGl0aW9uYWwtYXNzaWdubWVudFxuICAgIGlmICgobGlzdGVuZXJzID0gdGhpcy50eXBlc1tldmVudC50eXBlXSkpIHtcbiAgICAgIGZpcmVVbnRpbEltbWVkaWF0ZVN0b3BwZWQoZXZlbnQsIGxpc3RlbmVycylcbiAgICB9XG5cbiAgICAvLyBpbnRlcmFjdC5vbigpIGxpc3RlbmVyc1xuICAgIGlmICghZXZlbnQucHJvcGFnYXRpb25TdG9wcGVkICYmIGdsb2JhbCAmJiAobGlzdGVuZXJzID0gZ2xvYmFsW2V2ZW50LnR5cGVdKSkgIHtcbiAgICAgIGZpcmVVbnRpbEltbWVkaWF0ZVN0b3BwZWQoZXZlbnQsIGxpc3RlbmVycylcbiAgICB9XG4gIH1cblxuICBvbiAodHlwZTogc3RyaW5nLCBsaXN0ZW5lcjogSW50ZXJhY3QuTGlzdGVuZXJzQXJnKSB7XG4gICAgY29uc3QgbGlzdGVuZXJzID0gbm9ybWFsaXplKHR5cGUsIGxpc3RlbmVyKVxuXG4gICAgZm9yICh0eXBlIGluIGxpc3RlbmVycykge1xuICAgICAgdGhpcy50eXBlc1t0eXBlXSA9IGFyci5tZXJnZSh0aGlzLnR5cGVzW3R5cGVdIHx8IFtdLCBsaXN0ZW5lcnNbdHlwZV0pXG4gICAgfVxuICB9XG5cbiAgb2ZmICh0eXBlOiBzdHJpbmcsIGxpc3RlbmVyOiBJbnRlcmFjdC5MaXN0ZW5lcnNBcmcpIHtcbiAgICBjb25zdCBsaXN0ZW5lcnMgPSBub3JtYWxpemUodHlwZSwgbGlzdGVuZXIpXG5cbiAgICBmb3IgKHR5cGUgaW4gbGlzdGVuZXJzKSB7XG4gICAgICBjb25zdCBldmVudExpc3QgPSB0aGlzLnR5cGVzW3R5cGVdXG5cbiAgICAgIGlmICghZXZlbnRMaXN0IHx8ICFldmVudExpc3QubGVuZ3RoKSB7IGNvbnRpbnVlIH1cblxuICAgICAgZm9yIChjb25zdCBzdWJMaXN0ZW5lciBvZiBsaXN0ZW5lcnNbdHlwZV0pIHtcbiAgICAgICAgY29uc3QgaW5kZXggPSBldmVudExpc3QuaW5kZXhPZihzdWJMaXN0ZW5lcilcblxuICAgICAgICBpZiAoaW5kZXggIT09IC0xKSB7XG4gICAgICAgICAgZXZlbnRMaXN0LnNwbGljZShpbmRleCwgMSlcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gIGdldFJlY3QgKF9lbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50KTogSW50ZXJhY3QuUmVjdCB7XG4gICAgcmV0dXJuIG51bGxcbiAgfVxufVxuXG5leHBvcnQgZGVmYXVsdCBFdmVudGFibGVcbiIsImltcG9ydCB7IGNsb3Nlc3QsIGdldEVsZW1lbnRSZWN0LCBwYXJlbnROb2RlIH0gZnJvbSAnLi9kb21VdGlscydcbmltcG9ydCBleHRlbmQgZnJvbSAnLi9leHRlbmQnXG5pbXBvcnQgKiBhcyBpcyBmcm9tICcuL2lzJ1xuXG5leHBvcnQgZnVuY3Rpb24gZ2V0U3RyaW5nT3B0aW9uUmVzdWx0ICh2YWx1ZTogYW55LCB0YXJnZXQ6IEludGVyYWN0Lkhhc0dldFJlY3QsIGVsZW1lbnQpIHtcbiAgaWYgKHZhbHVlID09PSAncGFyZW50JykgeyByZXR1cm4gcGFyZW50Tm9kZShlbGVtZW50KSB9XG5cbiAgaWYgKHZhbHVlID09PSAnc2VsZicpIHsgcmV0dXJuIHRhcmdldC5nZXRSZWN0KGVsZW1lbnQpIH1cblxuICByZXR1cm4gY2xvc2VzdChlbGVtZW50LCB2YWx1ZSlcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHJlc29sdmVSZWN0TGlrZTxUIGV4dGVuZHMgYW55W10+IChcbiAgdmFsdWU6IEludGVyYWN0LlJlY3RSZXNvbHZhYmxlPFQ+LFxuICB0YXJnZXQ/OiBJbnRlcmFjdC5IYXNHZXRSZWN0LFxuICBlbGVtZW50PzogTm9kZSxcbiAgZnVuY3Rpb25BcmdzPzogVCxcbikge1xuICBsZXQgcmV0dXJuVmFsdWU6IGFueSA9IHZhbHVlXG4gIGlmIChpcy5zdHJpbmcocmV0dXJuVmFsdWUpKSB7XG4gICAgcmV0dXJuVmFsdWUgPSBnZXRTdHJpbmdPcHRpb25SZXN1bHQocmV0dXJuVmFsdWUsIHRhcmdldCwgZWxlbWVudClcbiAgfVxuICBlbHNlIGlmIChpcy5mdW5jKHJldHVyblZhbHVlKSkge1xuICAgIHJldHVyblZhbHVlID0gcmV0dXJuVmFsdWUoLi4uZnVuY3Rpb25BcmdzKVxuICB9XG5cbiAgaWYgKGlzLmVsZW1lbnQocmV0dXJuVmFsdWUpKSB7XG4gICAgcmV0dXJuVmFsdWUgPSBnZXRFbGVtZW50UmVjdChyZXR1cm5WYWx1ZSlcbiAgfVxuXG4gIHJldHVybiByZXR1cm5WYWx1ZSBhcyBJbnRlcmFjdC5SZWN0XG59XG5cbmV4cG9ydCBmdW5jdGlvbiByZWN0VG9YWSAocmVjdCkge1xuICByZXR1cm4gIHJlY3QgJiYge1xuICAgIHg6ICd4JyBpbiByZWN0ID8gcmVjdC54IDogcmVjdC5sZWZ0LFxuICAgIHk6ICd5JyBpbiByZWN0ID8gcmVjdC55IDogcmVjdC50b3AsXG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHh5d2hUb1RsYnIgKHJlY3QpIHtcbiAgaWYgKHJlY3QgJiYgISgnbGVmdCcgaW4gcmVjdCAmJiAndG9wJyBpbiByZWN0KSkge1xuICAgIHJlY3QgPSBleHRlbmQoe30sIHJlY3QpXG5cbiAgICByZWN0LmxlZnQgICA9IHJlY3QueCB8fCAwXG4gICAgcmVjdC50b3AgICAgPSByZWN0LnkgfHwgMFxuICAgIHJlY3QucmlnaHQgID0gcmVjdC5yaWdodCAgIHx8IChyZWN0LmxlZnQgKyByZWN0LndpZHRoKVxuICAgIHJlY3QuYm90dG9tID0gcmVjdC5ib3R0b20gIHx8IChyZWN0LnRvcCArIHJlY3QuaGVpZ2h0KVxuICB9XG5cbiAgcmV0dXJuIHJlY3Rcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHRsYnJUb1h5d2ggKHJlY3QpIHtcbiAgaWYgKHJlY3QgJiYgISgneCcgaW4gcmVjdCAmJiAneScgaW4gcmVjdCkpIHtcbiAgICByZWN0ID0gZXh0ZW5kKHt9LCByZWN0KVxuXG4gICAgcmVjdC54ICAgICAgPSByZWN0LmxlZnQgfHwgMFxuICAgIHJlY3QueSAgICAgID0gcmVjdC50b3AgIHx8IDBcbiAgICByZWN0LndpZHRoICA9IHJlY3Qud2lkdGggIHx8IChyZWN0LnJpZ2h0IHx8IDAgIC0gcmVjdC54KVxuICAgIHJlY3QuaGVpZ2h0ID0gcmVjdC5oZWlnaHQgfHwgKHJlY3QuYm90dG9tIHx8IDAgLSByZWN0LnkpXG4gIH1cblxuICByZXR1cm4gcmVjdFxufVxuXG5leHBvcnQgZnVuY3Rpb24gYWRkRWRnZXMgKGVkZ2VzOiBJbnRlcmFjdC5FZGdlT3B0aW9ucywgcmVjdDogSW50ZXJhY3QuUmVjdCwgZGVsdGE6IEludGVyYWN0LlBvaW50KSB7XG4gIGlmIChlZGdlcy5sZWZ0KSAgIHsgcmVjdC5sZWZ0ICAgKz0gZGVsdGEueCB9XG4gIGlmIChlZGdlcy5yaWdodCkgIHsgcmVjdC5yaWdodCAgKz0gZGVsdGEueCB9XG4gIGlmIChlZGdlcy50b3ApICAgIHsgcmVjdC50b3AgICAgKz0gZGVsdGEueSB9XG4gIGlmIChlZGdlcy5ib3R0b20pIHsgcmVjdC5ib3R0b20gKz0gZGVsdGEueSB9XG5cbiAgcmVjdC53aWR0aCA9IHJlY3QucmlnaHQgLSByZWN0LmxlZnRcbiAgcmVjdC5oZWlnaHQgPSByZWN0LmJvdHRvbSAtIHJlY3QudG9wXG59XG4iLCJpbXBvcnQgeyByZWN0VG9YWSwgcmVzb2x2ZVJlY3RMaWtlIH0gZnJvbSAnLi9yZWN0J1xuXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAoXG4gIHRhcmdldDogSW50ZXJhY3QuSGFzR2V0UmVjdCAmIHsgb3B0aW9uczogSW50ZXJhY3QuUGVyQWN0aW9uRGVmYXVsdHMgfSxcbiAgZWxlbWVudDogTm9kZSxcbiAgYWN0aW9uTmFtZT86IEludGVyYWN0LkFjdGlvbk5hbWUsXG4pIHtcbiAgY29uc3QgYWN0aW9uT3B0aW9ucyA9ICh0YXJnZXQub3B0aW9ucyBhcyBhbnkpW2FjdGlvbk5hbWVdXG4gIGNvbnN0IGFjdGlvbk9yaWdpbiA9IGFjdGlvbk9wdGlvbnMgJiYgYWN0aW9uT3B0aW9ucy5vcmlnaW5cbiAgY29uc3Qgb3JpZ2luID0gYWN0aW9uT3JpZ2luIHx8IHRhcmdldC5vcHRpb25zLm9yaWdpblxuXG4gIGNvbnN0IG9yaWdpblJlY3QgPSByZXNvbHZlUmVjdExpa2Uob3JpZ2luLCB0YXJnZXQsIGVsZW1lbnQsIFt0YXJnZXQgJiYgZWxlbWVudF0pXG5cbiAgcmV0dXJuIHJlY3RUb1hZKG9yaWdpblJlY3QpIHx8IHsgeDogMCwgeTogMCB9XG59XG4iLCJsZXQgbGFzdFRpbWUgPSAwXG5sZXQgcmVxdWVzdFxubGV0IGNhbmNlbFxuXG5mdW5jdGlvbiBpbml0ICh3aW5kb3cpIHtcbiAgcmVxdWVzdCA9IHdpbmRvdy5yZXF1ZXN0QW5pbWF0aW9uRnJhbWVcbiAgY2FuY2VsID0gd2luZG93LmNhbmNlbEFuaW1hdGlvbkZyYW1lXG5cbiAgaWYgKCFyZXF1ZXN0KSB7XG4gICAgY29uc3QgdmVuZG9ycyA9IFsnbXMnLCAnbW96JywgJ3dlYmtpdCcsICdvJ11cblxuICAgIGZvciAoY29uc3QgdmVuZG9yIG9mIHZlbmRvcnMpIHtcbiAgICAgIHJlcXVlc3QgPSB3aW5kb3dbYCR7dmVuZG9yfVJlcXVlc3RBbmltYXRpb25GcmFtZWBdXG4gICAgICBjYW5jZWwgPSB3aW5kb3dbYCR7dmVuZG9yfUNhbmNlbEFuaW1hdGlvbkZyYW1lYF0gfHwgd2luZG93W2Ake3ZlbmRvcn1DYW5jZWxSZXF1ZXN0QW5pbWF0aW9uRnJhbWVgXVxuICAgIH1cbiAgfVxuXG4gIGlmICghcmVxdWVzdCkge1xuICAgIHJlcXVlc3QgPSBjYWxsYmFjayA9PiB7XG4gICAgICBjb25zdCBjdXJyVGltZSA9IERhdGUubm93KClcbiAgICAgIGNvbnN0IHRpbWVUb0NhbGwgPSBNYXRoLm1heCgwLCAxNiAtIChjdXJyVGltZSAtIGxhc3RUaW1lKSlcbiAgICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBzdGFuZGFyZC9uby1jYWxsYmFjay1saXRlcmFsXG4gICAgICBjb25zdCB0b2tlbiA9IHNldFRpbWVvdXQoKCkgPT4geyBjYWxsYmFjayhjdXJyVGltZSArIHRpbWVUb0NhbGwpIH0sXG4gICAgICAgIHRpbWVUb0NhbGwpXG5cbiAgICAgIGxhc3RUaW1lID0gY3VyclRpbWUgKyB0aW1lVG9DYWxsXG4gICAgICByZXR1cm4gdG9rZW5cbiAgICB9XG5cbiAgICBjYW5jZWwgPSB0b2tlbiA9PiBjbGVhclRpbWVvdXQodG9rZW4pXG4gIH1cbn1cblxuZXhwb3J0IGRlZmF1bHQge1xuICByZXF1ZXN0OiBjYWxsYmFjayA9PiByZXF1ZXN0KGNhbGxiYWNrKSxcbiAgY2FuY2VsOiB0b2tlbiA9PiBjYW5jZWwodG9rZW4pLFxuICBpbml0LFxufVxuIiwiaW1wb3J0ICogYXMgYXJyIGZyb20gJy4vYXJyJ1xuaW1wb3J0ICogYXMgZG9tIGZyb20gJy4vZG9tVXRpbHMnXG5pbXBvcnQgKiBhcyBpcyBmcm9tICcuL2lzJ1xuaW1wb3J0ICogYXMgcG9pbnRlciBmcm9tICcuL3BvaW50ZXJVdGlscydcbmltcG9ydCAqIGFzIHJlY3QgZnJvbSAnLi9yZWN0J1xuaW1wb3J0IHdpbiBmcm9tICcuL3dpbmRvdydcblxuZXhwb3J0IGZ1bmN0aW9uIHdhcm5PbmNlPFQ+ICh0aGlzOiBULCBtZXRob2Q6ICguLi5hcmdzOiBhbnlbXSkgPT4gYW55LCBtZXNzYWdlOiBzdHJpbmcpIHtcbiAgbGV0IHdhcm5lZCA9IGZhbHNlXG5cbiAgLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLXNoYWRvd1xuICByZXR1cm4gZnVuY3Rpb24gKHRoaXM6IFQpIHtcbiAgICBpZiAoIXdhcm5lZCkge1xuICAgICAgKHdpbiBhcyBhbnkpLndpbmRvdy5jb25zb2xlLndhcm4obWVzc2FnZSlcbiAgICAgIHdhcm5lZCA9IHRydWVcbiAgICB9XG5cbiAgICByZXR1cm4gbWV0aG9kLmFwcGx5KHRoaXMsIGFyZ3VtZW50cylcbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gY29weUFjdGlvbiAoZGVzdDogSW50ZXJhY3QuQWN0aW9uUHJvcHMsIHNyYzogSW50ZXJhY3QuQWN0aW9uUHJvcHMpIHtcbiAgZGVzdC5uYW1lICA9IHNyYy5uYW1lXG4gIGRlc3QuYXhpcyAgPSBzcmMuYXhpc1xuICBkZXN0LmVkZ2VzID0gc3JjLmVkZ2VzXG5cbiAgcmV0dXJuIGRlc3Rcbn1cblxuZXhwb3J0IHsgZGVmYXVsdCBhcyBicm93c2VyIH0gZnJvbSAnLi9icm93c2VyJ1xuZXhwb3J0IHsgZGVmYXVsdCBhcyBjbG9uZSB9IGZyb20gJy4vY2xvbmUnXG5leHBvcnQgeyBkZWZhdWx0IGFzIGV2ZW50cyB9IGZyb20gJy4vZXZlbnRzJ1xuZXhwb3J0IHsgZGVmYXVsdCBhcyBleHRlbmQgfSBmcm9tICcuL2V4dGVuZCdcbmV4cG9ydCB7IGRlZmF1bHQgYXMgZ2V0T3JpZ2luWFkgfSBmcm9tICcuL2dldE9yaWdpblhZJ1xuZXhwb3J0IHsgZGVmYXVsdCBhcyBoeXBvdCB9IGZyb20gJy4vaHlwb3QnXG5leHBvcnQgeyBkZWZhdWx0IGFzIG5vcm1hbGl6ZUxpc3RlbmVycyB9IGZyb20gJy4vbm9ybWFsaXplTGlzdGVuZXJzJ1xuZXhwb3J0IHsgZGVmYXVsdCBhcyByYWYgfSBmcm9tICcuL3JhZidcbmV4cG9ydCB7IHdpbiwgYXJyLCBkb20sIGlzLCBwb2ludGVyLCByZWN0IH1cbiIsIi8vIHRzbGludDpkaXNhYmxlIG5vLWVtcHR5LWludGVyZmFjZVxuXG5leHBvcnQgaW50ZXJmYWNlIERlZmF1bHRzIHtcbiAgYmFzZTogQmFzZURlZmF1bHRzXG4gIHBlckFjdGlvbjogUGVyQWN0aW9uRGVmYXVsdHNcbiAgYWN0aW9uczogQWN0aW9uRGVmYXVsdHNcbn1cblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIEB0eXBlc2NyaXB0LWVzbGludC9uby1lbXB0eS1pbnRlcmZhY2VcbmV4cG9ydCBpbnRlcmZhY2UgQWN0aW9uRGVmYXVsdHMge1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEJhc2VEZWZhdWx0cyB7XG4gIHByZXZlbnREZWZhdWx0PzogJ2F1dG8nIHwgJ25ldmVyJyB8IHN0cmluZ1xuICBkZWx0YVNvdXJjZT86ICdwYWdlJyB8ICdjbGllbnQnXG4gIGNvbnRleHQ/OiBJbnRlcmFjdC5FdmVudFRhcmdldFxufVxuXG5leHBvcnQgaW50ZXJmYWNlIFBlckFjdGlvbkRlZmF1bHRzIHtcbiAgZW5hYmxlZD86IGJvb2xlYW5cbiAgb3JpZ2luPzogSW50ZXJhY3QuUG9pbnQgfCBzdHJpbmcgfCBJbnRlcmFjdC5FbGVtZW50XG4gIGxpc3RlbmVycz86IEludGVyYWN0Lkxpc3RlbmVyc1xuICBhbGxvd0Zyb20/OiBzdHJpbmcgfCBJbnRlcmFjdC5FbGVtZW50XG4gIGlnbm9yZUZyb20/OiBzdHJpbmcgfCBJbnRlcmFjdC5FbGVtZW50XG59XG5cbmV4cG9ydCB0eXBlIE9wdGlvbnMgPSBQYXJ0aWFsPEJhc2VEZWZhdWx0cz4gJiBQYXJ0aWFsPFBlckFjdGlvbkRlZmF1bHRzPiAmIHtcbiAgW1AgaW4ga2V5b2YgQWN0aW9uRGVmYXVsdHNdPzogUGFydGlhbDxBY3Rpb25EZWZhdWx0c1tQXT5cbn1cblxuLy8gZXhwb3J0IGludGVyZmFjZSBPcHRpb25zIGV4dGVuZHMgQmFzZURlZmF1bHRzLCBQZXJBY3Rpb25EZWZhdWx0cyB7fVxuXG5leHBvcnQgaW50ZXJmYWNlIE9wdGlvbnNBcmcgZXh0ZW5kcyBCYXNlRGVmYXVsdHMsIEludGVyYWN0Lk9yQm9vbGVhbjxQYXJ0aWFsPEFjdGlvbkRlZmF1bHRzPj4ge31cblxuZXhwb3J0IGNvbnN0IGRlZmF1bHRzOiBEZWZhdWx0cyA9IHtcbiAgYmFzZToge1xuICAgIHByZXZlbnREZWZhdWx0OiAnYXV0bycsXG4gICAgZGVsdGFTb3VyY2U6ICdwYWdlJyxcbiAgfSxcblxuICBwZXJBY3Rpb246IHtcbiAgICBlbmFibGVkOiBmYWxzZSxcbiAgICBvcmlnaW46IHsgeDogMCwgeTogMCB9LFxuICB9LFxuXG4gIGFjdGlvbnM6IHt9IGFzIEFjdGlvbkRlZmF1bHRzLFxufVxuXG5leHBvcnQgZGVmYXVsdCBkZWZhdWx0c1xuIiwiaW1wb3J0ICogYXMgYXJyIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2FycidcbmltcG9ydCAqIGFzIGRvbVV0aWxzIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2RvbVV0aWxzJ1xuaW1wb3J0IGV4dGVuZCBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9leHRlbmQnXG5pbXBvcnQgKiBhcyBpcyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9pcydcblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvc2NvcGUnIHtcbiAgaW50ZXJmYWNlIFNpZ25hbEFyZ3Mge1xuICAgICdpbnRlcmFjdGFibGU6bmV3Jzoge1xuICAgICAgaW50ZXJhY3RhYmxlOiBJbnRlcmFjdC5JbnRlcmFjdGFibGVcbiAgICAgIHRhcmdldDogSW50ZXJhY3QuVGFyZ2V0XG4gICAgICBvcHRpb25zOiBJbnRlcmFjdC5PcHRpb25zQXJnXG4gICAgICB3aW46IFdpbmRvd1xuICAgIH1cbiAgfVxufVxuXG5pbnRlcmZhY2UgSW50ZXJhY3RhYmxlU2NvcGVQcm9wIHtcbiAgY29udGV4dDogRG9jdW1lbnQgfCBJbnRlcmFjdC5FbGVtZW50XG4gIGludGVyYWN0YWJsZTogSW50ZXJhY3QuSW50ZXJhY3RhYmxlXG59XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEludGVyYWN0YWJsZVNldCB7XG4gIC8vIGFsbCBzZXQgaW50ZXJhY3RhYmxlc1xuICBsaXN0OiBJbnRlcmFjdC5JbnRlcmFjdGFibGVbXSA9IFtdXG5cbiAgc2VsZWN0b3JNYXA6IHtcbiAgICBbc2VsZWN0b3I6IHN0cmluZ106IEludGVyYWN0YWJsZVNjb3BlUHJvcFtdXG4gIH0gPSB7fVxuXG4gIGNvbnN0cnVjdG9yIChwcm90ZWN0ZWQgc2NvcGU6IEludGVyYWN0LlNjb3BlKSB7XG4gICAgc2NvcGUuYWRkTGlzdGVuZXJzKHtcbiAgICAgICdpbnRlcmFjdGFibGU6dW5zZXQnOiAoeyBpbnRlcmFjdGFibGUgfSkgPT4ge1xuICAgICAgICBjb25zdCB7IHRhcmdldCwgX2NvbnRleHQ6IGNvbnRleHQgfSA9IGludGVyYWN0YWJsZVxuICAgICAgICBjb25zdCB0YXJnZXRNYXBwaW5nczogSW50ZXJhY3RhYmxlU2NvcGVQcm9wW10gPSBpcy5zdHJpbmcodGFyZ2V0KVxuICAgICAgICAgID8gdGhpcy5zZWxlY3Rvck1hcFt0YXJnZXRdXG4gICAgICAgICAgOiAodGFyZ2V0IGFzIGFueSlbdGhpcy5zY29wZS5pZF1cblxuICAgICAgICBjb25zdCB0YXJnZXRJbmRleCA9IHRhcmdldE1hcHBpbmdzLmZpbmRJbmRleChtID0+IG0uY29udGV4dCA9PT0gY29udGV4dClcbiAgICAgICAgaWYgKHRhcmdldE1hcHBpbmdzW3RhcmdldEluZGV4XSkge1xuICAgICAgICAvLyBEZXN0cm95aW5nIG1hcHBpbmdJbmZvJ3MgY29udGV4dCBhbmQgaW50ZXJhY3RhYmxlXG4gICAgICAgICAgdGFyZ2V0TWFwcGluZ3NbdGFyZ2V0SW5kZXhdLmNvbnRleHQgPSBudWxsXG4gICAgICAgICAgdGFyZ2V0TWFwcGluZ3NbdGFyZ2V0SW5kZXhdLmludGVyYWN0YWJsZSA9IG51bGxcbiAgICAgICAgfVxuICAgICAgICB0YXJnZXRNYXBwaW5ncy5zcGxpY2UodGFyZ2V0SW5kZXgsIDEpXG4gICAgICB9LFxuICAgIH0pXG4gIH1cblxuICBuZXcgKHRhcmdldDogSW50ZXJhY3QuVGFyZ2V0LCBvcHRpb25zPzogYW55KTogSW50ZXJhY3QuSW50ZXJhY3RhYmxlIHtcbiAgICBvcHRpb25zID0gZXh0ZW5kKG9wdGlvbnMgfHwge30sIHtcbiAgICAgIGFjdGlvbnM6IHRoaXMuc2NvcGUuYWN0aW9ucyxcbiAgICB9KVxuICAgIGNvbnN0IGludGVyYWN0YWJsZSA9IG5ldyB0aGlzLnNjb3BlLkludGVyYWN0YWJsZSh0YXJnZXQsIG9wdGlvbnMsIHRoaXMuc2NvcGUuZG9jdW1lbnQpXG4gICAgY29uc3QgbWFwcGluZ0luZm8gPSB7IGNvbnRleHQ6IGludGVyYWN0YWJsZS5fY29udGV4dCwgaW50ZXJhY3RhYmxlIH1cblxuICAgIHRoaXMuc2NvcGUuYWRkRG9jdW1lbnQoaW50ZXJhY3RhYmxlLl9kb2MpXG4gICAgdGhpcy5saXN0LnB1c2goaW50ZXJhY3RhYmxlKVxuXG4gICAgaWYgKGlzLnN0cmluZyh0YXJnZXQpKSB7XG4gICAgICBpZiAoIXRoaXMuc2VsZWN0b3JNYXBbdGFyZ2V0XSkgeyB0aGlzLnNlbGVjdG9yTWFwW3RhcmdldF0gPSBbXSB9XG4gICAgICB0aGlzLnNlbGVjdG9yTWFwW3RhcmdldF0ucHVzaChtYXBwaW5nSW5mbylcbiAgICB9IGVsc2Uge1xuICAgICAgaWYgKCEoKGludGVyYWN0YWJsZS50YXJnZXQgYXMgYW55KVt0aGlzLnNjb3BlLmlkXSkpIHtcbiAgICAgICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KHRhcmdldCwgdGhpcy5zY29wZS5pZCwge1xuICAgICAgICAgIHZhbHVlOiBbXSxcbiAgICAgICAgICBjb25maWd1cmFibGU6IHRydWUsXG4gICAgICAgIH0pXG4gICAgICB9XG5cbiAgICAgICh0YXJnZXQgYXMgYW55KVt0aGlzLnNjb3BlLmlkXS5wdXNoKG1hcHBpbmdJbmZvKVxuICAgIH1cblxuICAgIHRoaXMuc2NvcGUuZmlyZSgnaW50ZXJhY3RhYmxlOm5ldycsIHtcbiAgICAgIHRhcmdldCxcbiAgICAgIG9wdGlvbnMsXG4gICAgICBpbnRlcmFjdGFibGUsXG4gICAgICB3aW46IHRoaXMuc2NvcGUuX3dpbixcbiAgICB9KVxuXG4gICAgcmV0dXJuIGludGVyYWN0YWJsZVxuICB9XG5cbiAgZ2V0ICh0YXJnZXQ6IEludGVyYWN0LlRhcmdldCwgb3B0aW9ucz86IEludGVyYWN0Lk9wdGlvbnMpIHtcbiAgICBjb25zdCBjb250ZXh0ID0gKG9wdGlvbnMgJiYgb3B0aW9ucy5jb250ZXh0KSB8fCB0aGlzLnNjb3BlLmRvY3VtZW50XG4gICAgY29uc3QgaXNTZWxlY3RvciA9IGlzLnN0cmluZyh0YXJnZXQpXG4gICAgY29uc3QgdGFyZ2V0TWFwcGluZ3M6IEludGVyYWN0YWJsZVNjb3BlUHJvcFtdID0gaXNTZWxlY3RvclxuICAgICAgPyB0aGlzLnNlbGVjdG9yTWFwW3RhcmdldCBhcyBzdHJpbmddXG4gICAgICA6ICh0YXJnZXQgYXMgYW55KVt0aGlzLnNjb3BlLmlkXVxuXG4gICAgaWYgKCF0YXJnZXRNYXBwaW5ncykgeyByZXR1cm4gbnVsbCB9XG5cbiAgICBjb25zdCBmb3VuZCA9IGFyci5maW5kKFxuICAgICAgdGFyZ2V0TWFwcGluZ3MsXG4gICAgICBtID0+IG0uY29udGV4dCA9PT0gY29udGV4dCAmJlxuICAgICAgICAoaXNTZWxlY3RvciB8fCBtLmludGVyYWN0YWJsZS5pbkNvbnRleHQodGFyZ2V0IGFzIGFueSkpKVxuXG4gICAgcmV0dXJuIGZvdW5kICYmIGZvdW5kLmludGVyYWN0YWJsZVxuICB9XG5cbiAgZm9yRWFjaE1hdGNoPFQ+IChub2RlOiBOb2RlLCBjYWxsYmFjazogKGludGVyYWN0YWJsZTogSW50ZXJhY3QuSW50ZXJhY3RhYmxlKSA9PiBUKTogVCB8IHZvaWQge1xuICAgIGZvciAoY29uc3QgaW50ZXJhY3RhYmxlIG9mIHRoaXMubGlzdCkge1xuICAgICAgbGV0IHJldFxuXG4gICAgICBpZiAoKGlzLnN0cmluZyhpbnRlcmFjdGFibGUudGFyZ2V0KVxuICAgICAgLy8gdGFyZ2V0IGlzIGEgc2VsZWN0b3IgYW5kIHRoZSBlbGVtZW50IG1hdGNoZXNcbiAgICAgICAgPyAoaXMuZWxlbWVudChub2RlKSAmJiBkb21VdGlscy5tYXRjaGVzU2VsZWN0b3Iobm9kZSwgaW50ZXJhY3RhYmxlLnRhcmdldCkpXG4gICAgICAgIC8vIHRhcmdldCBpcyB0aGUgZWxlbWVudFxuICAgICAgICA6IG5vZGUgPT09IGludGVyYWN0YWJsZS50YXJnZXQpICYmXG4gICAgICAgIC8vIHRoZSBlbGVtZW50IGlzIGluIGNvbnRleHRcbiAgICAgICAgKGludGVyYWN0YWJsZS5pbkNvbnRleHQobm9kZSkpKSB7XG4gICAgICAgIHJldCA9IGNhbGxiYWNrKGludGVyYWN0YWJsZSlcbiAgICAgIH1cblxuICAgICAgaWYgKHJldCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgIHJldHVybiByZXRcbiAgICAgIH1cbiAgICB9XG4gIH1cbn1cbiIsImV4cG9ydCBjbGFzcyBCYXNlRXZlbnQ8VCBleHRlbmRzIEludGVyYWN0LkFjdGlvbk5hbWUgPSBhbnk+IHtcbiAgdHlwZTogc3RyaW5nXG4gIHRhcmdldDogRXZlbnRUYXJnZXRcbiAgY3VycmVudFRhcmdldDogRXZlbnRUYXJnZXRcbiAgaW50ZXJhY3RhYmxlOiBJbnRlcmFjdC5JbnRlcmFjdGFibGVcbiAgX2ludGVyYWN0aW9uOiBJbnRlcmFjdC5JbnRlcmFjdGlvbjxUPlxuICB0aW1lU3RhbXA6IGFueVxuICBpbW1lZGlhdGVQcm9wYWdhdGlvblN0b3BwZWQgPSBmYWxzZVxuICBwcm9wYWdhdGlvblN0b3BwZWQgPSBmYWxzZVxuXG4gIGdldCBpbnRlcmFjdGlvbiAoKTogSW50ZXJhY3QuSW50ZXJhY3Rpb25Qcm94eTxUPiB7XG4gICAgcmV0dXJuIHRoaXMuX2ludGVyYWN0aW9uLl9wcm94eVxuICB9XG5cbiAgY29uc3RydWN0b3IgKGludGVyYWN0aW9uOiBJbnRlcmFjdC5JbnRlcmFjdGlvbikge1xuICAgIHRoaXMuX2ludGVyYWN0aW9uID0gaW50ZXJhY3Rpb25cbiAgfVxuXG4gIHByZXZlbnREZWZhdWx0ICgpIHt9XG5cbiAgLyoqXG4gICAqIERvbid0IGNhbGwgYW55IG90aGVyIGxpc3RlbmVycyAoZXZlbiBvbiB0aGUgY3VycmVudCB0YXJnZXQpXG4gICAqL1xuICBzdG9wUHJvcGFnYXRpb24gKCkge1xuICAgIHRoaXMucHJvcGFnYXRpb25TdG9wcGVkID0gdHJ1ZVxuICB9XG5cbiAgLyoqXG4gICAqIERvbid0IGNhbGwgbGlzdGVuZXJzIG9uIHRoZSByZW1haW5pbmcgdGFyZ2V0c1xuICAgKi9cbiAgc3RvcEltbWVkaWF0ZVByb3BhZ2F0aW9uICgpIHtcbiAgICB0aGlzLmltbWVkaWF0ZVByb3BhZ2F0aW9uU3RvcHBlZCA9IHRoaXMucHJvcGFnYXRpb25TdG9wcGVkID0gdHJ1ZVxuICB9XG59XG5cbmV4cG9ydCBkZWZhdWx0IEJhc2VFdmVudFxuIiwiaW1wb3J0IGV4dGVuZCBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9leHRlbmQnXG5pbXBvcnQgZ2V0T3JpZ2luWFkgZnJvbSAnQGludGVyYWN0anMvdXRpbHMvZ2V0T3JpZ2luWFknXG5pbXBvcnQgaHlwb3QgZnJvbSAnQGludGVyYWN0anMvdXRpbHMvaHlwb3QnXG5pbXBvcnQgQmFzZUV2ZW50IGZyb20gJy4vQmFzZUV2ZW50J1xuaW1wb3J0IGRlZmF1bHRzIGZyb20gJy4vZGVmYXVsdE9wdGlvbnMnXG5pbXBvcnQgSW50ZXJhY3Rpb24gZnJvbSAnLi9JbnRlcmFjdGlvbidcblxuZXhwb3J0IHR5cGUgRXZlbnRQaGFzZSA9IGtleW9mIFBoYXNlTWFwXG5cbmV4cG9ydCBpbnRlcmZhY2UgUGhhc2VNYXAge1xuICBzdGFydDogdHJ1ZVxuICBtb3ZlOiB0cnVlXG4gIGVuZDogdHJ1ZVxufVxuXG5leHBvcnQgY2xhc3MgSW50ZXJhY3RFdmVudDxcbiAgVCBleHRlbmRzIEludGVyYWN0LkFjdGlvbk5hbWUgPSBuZXZlcixcbiAgUCBleHRlbmRzIEV2ZW50UGhhc2UgPSBFdmVudFBoYXNlLFxuPiBleHRlbmRzIEJhc2VFdmVudDxUPiB7XG4gIHRhcmdldDogSW50ZXJhY3QuRWxlbWVudFxuICBjdXJyZW50VGFyZ2V0OiBJbnRlcmFjdC5FbGVtZW50XG4gIHJlbGF0ZWRUYXJnZXQ6IG51bGwgPSBudWxsXG4gIHNjcmVlblg/OiBudW1iZXJcbiAgc2NyZWVuWT86IG51bWJlclxuICBidXR0b246IG51bWJlclxuICBidXR0b25zOiBudW1iZXJcbiAgY3RybEtleTogYm9vbGVhblxuICBzaGlmdEtleTogYm9vbGVhblxuICBhbHRLZXk6IGJvb2xlYW5cbiAgbWV0YUtleTogYm9vbGVhblxuICBwYWdlOiBJbnRlcmFjdC5Qb2ludFxuICBjbGllbnQ6IEludGVyYWN0LlBvaW50XG4gIGRlbHRhOiBJbnRlcmFjdC5Qb2ludFxuICByZWN0OiBJbnRlcmFjdC5GdWxsUmVjdFxuICB4MDogbnVtYmVyXG4gIHkwOiBudW1iZXJcbiAgdDA6IG51bWJlclxuICBkdDogbnVtYmVyXG4gIGR1cmF0aW9uOiBudW1iZXJcbiAgY2xpZW50WDA6IG51bWJlclxuICBjbGllbnRZMDogbnVtYmVyXG4gIHZlbG9jaXR5OiBJbnRlcmFjdC5Qb2ludFxuICBzcGVlZDogbnVtYmVyXG4gIHN3aXBlOiBSZXR1cm5UeXBlPEludGVyYWN0RXZlbnQ8VD5bJ2dldFN3aXBlJ10+XG4gIHRpbWVTdGFtcDogYW55XG4gIC8vIGRyYWdcbiAgZHJhZ0VudGVyPzogSW50ZXJhY3QuRWxlbWVudFxuICBkcmFnTGVhdmU/OiBJbnRlcmFjdC5FbGVtZW50XG4gIC8vIHJlc2l6ZVxuICBheGVzPzogJ3gnIHwgJ3knIHwgJ3h5J1xuICBwcmVFbmQ/OiBib29sZWFuXG5cbiAgLyoqICovXG4gIGNvbnN0cnVjdG9yIChcbiAgICBpbnRlcmFjdGlvbjogSW50ZXJhY3Rpb24sXG4gICAgZXZlbnQ6IEludGVyYWN0LlBvaW50ZXJFdmVudFR5cGUsXG4gICAgYWN0aW9uTmFtZTogVCxcbiAgICBwaGFzZTogUCxcbiAgICBlbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50LFxuICAgIHByZUVuZD86IGJvb2xlYW4sXG4gICAgdHlwZT86IHN0cmluZyxcbiAgKSB7XG4gICAgc3VwZXIoaW50ZXJhY3Rpb24pXG5cbiAgICBlbGVtZW50ID0gZWxlbWVudCB8fCBpbnRlcmFjdGlvbi5lbGVtZW50XG5cbiAgICBjb25zdCB0YXJnZXQgICAgICA9IGludGVyYWN0aW9uLmludGVyYWN0YWJsZVxuICAgIGNvbnN0IGRlbHRhU291cmNlID0gKCgodGFyZ2V0ICYmIHRhcmdldC5vcHRpb25zKSB8fCBkZWZhdWx0cykgYXMgYW55KS5kZWx0YVNvdXJjZSBhcyAncGFnZScgfCAnY2xpZW50J1xuICAgIGNvbnN0IG9yaWdpbiAgICAgID0gZ2V0T3JpZ2luWFkodGFyZ2V0LCBlbGVtZW50LCBhY3Rpb25OYW1lKVxuICAgIGNvbnN0IHN0YXJ0aW5nICAgID0gcGhhc2UgPT09ICdzdGFydCdcbiAgICBjb25zdCBlbmRpbmcgICAgICA9IHBoYXNlID09PSAnZW5kJ1xuICAgIGNvbnN0IHByZXZFdmVudCAgID0gc3RhcnRpbmcgPyB0aGlzIDogaW50ZXJhY3Rpb24ucHJldkV2ZW50XG4gICAgY29uc3QgY29vcmRzICAgICAgPSBzdGFydGluZ1xuICAgICAgPyBpbnRlcmFjdGlvbi5jb29yZHMuc3RhcnRcbiAgICAgIDogZW5kaW5nXG4gICAgICAgID8geyBwYWdlOiBwcmV2RXZlbnQucGFnZSwgY2xpZW50OiBwcmV2RXZlbnQuY2xpZW50LCB0aW1lU3RhbXA6IGludGVyYWN0aW9uLmNvb3Jkcy5jdXIudGltZVN0YW1wIH1cbiAgICAgICAgOiBpbnRlcmFjdGlvbi5jb29yZHMuY3VyXG5cbiAgICB0aGlzLnBhZ2UgICAgICA9IGV4dGVuZCh7fSwgY29vcmRzLnBhZ2UpXG4gICAgdGhpcy5jbGllbnQgICAgPSBleHRlbmQoe30sIGNvb3Jkcy5jbGllbnQpXG4gICAgdGhpcy5yZWN0ICAgICAgPSBleHRlbmQoe30sIGludGVyYWN0aW9uLnJlY3QpXG4gICAgdGhpcy50aW1lU3RhbXAgPSBjb29yZHMudGltZVN0YW1wXG5cbiAgICBpZiAoIWVuZGluZykge1xuICAgICAgdGhpcy5wYWdlLnggLT0gb3JpZ2luLnhcbiAgICAgIHRoaXMucGFnZS55IC09IG9yaWdpbi55XG5cbiAgICAgIHRoaXMuY2xpZW50LnggLT0gb3JpZ2luLnhcbiAgICAgIHRoaXMuY2xpZW50LnkgLT0gb3JpZ2luLnlcbiAgICB9XG5cbiAgICB0aGlzLmN0cmxLZXkgICAgICAgPSBldmVudC5jdHJsS2V5XG4gICAgdGhpcy5hbHRLZXkgICAgICAgID0gZXZlbnQuYWx0S2V5XG4gICAgdGhpcy5zaGlmdEtleSAgICAgID0gZXZlbnQuc2hpZnRLZXlcbiAgICB0aGlzLm1ldGFLZXkgICAgICAgPSBldmVudC5tZXRhS2V5XG4gICAgdGhpcy5idXR0b24gICAgICAgID0gKGV2ZW50IGFzIE1vdXNlRXZlbnQpLmJ1dHRvblxuICAgIHRoaXMuYnV0dG9ucyAgICAgICA9IChldmVudCBhcyBNb3VzZUV2ZW50KS5idXR0b25zXG4gICAgdGhpcy50YXJnZXQgICAgICAgID0gZWxlbWVudFxuICAgIHRoaXMuY3VycmVudFRhcmdldCA9IGVsZW1lbnRcbiAgICB0aGlzLnByZUVuZCAgICAgICAgPSBwcmVFbmRcbiAgICB0aGlzLnR5cGUgICAgICAgICAgPSB0eXBlIHx8IChhY3Rpb25OYW1lICsgKHBoYXNlIHx8ICcnKSlcbiAgICB0aGlzLmludGVyYWN0YWJsZSAgPSB0YXJnZXRcblxuICAgIHRoaXMudDAgPSBzdGFydGluZ1xuICAgICAgPyBpbnRlcmFjdGlvbi5wb2ludGVyc1tpbnRlcmFjdGlvbi5wb2ludGVycy5sZW5ndGggLSAxXS5kb3duVGltZVxuICAgICAgOiBwcmV2RXZlbnQudDBcblxuICAgIHRoaXMueDAgICAgICAgPSBpbnRlcmFjdGlvbi5jb29yZHMuc3RhcnQucGFnZS54IC0gb3JpZ2luLnhcbiAgICB0aGlzLnkwICAgICAgID0gaW50ZXJhY3Rpb24uY29vcmRzLnN0YXJ0LnBhZ2UueSAtIG9yaWdpbi55XG4gICAgdGhpcy5jbGllbnRYMCA9IGludGVyYWN0aW9uLmNvb3Jkcy5zdGFydC5jbGllbnQueCAtIG9yaWdpbi54XG4gICAgdGhpcy5jbGllbnRZMCA9IGludGVyYWN0aW9uLmNvb3Jkcy5zdGFydC5jbGllbnQueSAtIG9yaWdpbi55XG5cbiAgICBpZiAoc3RhcnRpbmcgfHwgZW5kaW5nKSB7XG4gICAgICB0aGlzLmRlbHRhID0geyB4OiAwLCB5OiAwIH1cbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmRlbHRhID0ge1xuICAgICAgICB4OiB0aGlzW2RlbHRhU291cmNlXS54IC0gcHJldkV2ZW50W2RlbHRhU291cmNlXS54LFxuICAgICAgICB5OiB0aGlzW2RlbHRhU291cmNlXS55IC0gcHJldkV2ZW50W2RlbHRhU291cmNlXS55LFxuICAgICAgfVxuICAgIH1cblxuICAgIHRoaXMuZHQgICAgICAgID0gaW50ZXJhY3Rpb24uY29vcmRzLmRlbHRhLnRpbWVTdGFtcFxuICAgIHRoaXMuZHVyYXRpb24gID0gdGhpcy50aW1lU3RhbXAgLSB0aGlzLnQwXG5cbiAgICAvLyB2ZWxvY2l0eSBhbmQgc3BlZWQgaW4gcGl4ZWxzIHBlciBzZWNvbmRcbiAgICB0aGlzLnZlbG9jaXR5ID0gZXh0ZW5kKHt9LCBpbnRlcmFjdGlvbi5jb29yZHMudmVsb2NpdHlbZGVsdGFTb3VyY2VdKVxuICAgIHRoaXMuc3BlZWQgPSBoeXBvdCh0aGlzLnZlbG9jaXR5LngsIHRoaXMudmVsb2NpdHkueSlcblxuICAgIHRoaXMuc3dpcGUgPSAoZW5kaW5nIHx8IHBoYXNlID09PSAnaW5lcnRpYXN0YXJ0JykgPyB0aGlzLmdldFN3aXBlKCkgOiBudWxsXG4gIH1cblxuICBnZXQgcGFnZVggKCkgeyByZXR1cm4gdGhpcy5wYWdlLnggfVxuICBzZXQgcGFnZVggKHZhbHVlKSB7IHRoaXMucGFnZS54ID0gdmFsdWUgfVxuICBnZXQgcGFnZVkgKCkgeyByZXR1cm4gdGhpcy5wYWdlLnkgfVxuICBzZXQgcGFnZVkgKHZhbHVlKSB7IHRoaXMucGFnZS55ID0gdmFsdWUgfVxuXG4gIGdldCBjbGllbnRYICgpIHsgcmV0dXJuIHRoaXMuY2xpZW50LnggfVxuICBzZXQgY2xpZW50WCAodmFsdWUpIHsgdGhpcy5jbGllbnQueCA9IHZhbHVlIH1cbiAgZ2V0IGNsaWVudFkgKCkgeyByZXR1cm4gdGhpcy5jbGllbnQueSB9XG4gIHNldCBjbGllbnRZICh2YWx1ZSkgeyB0aGlzLmNsaWVudC55ID0gdmFsdWUgfVxuXG4gIGdldCBkeCAoKSB7IHJldHVybiB0aGlzLmRlbHRhLnggfVxuICBzZXQgZHggKHZhbHVlKSB7IHRoaXMuZGVsdGEueCA9IHZhbHVlIH1cbiAgZ2V0IGR5ICgpIHsgcmV0dXJuIHRoaXMuZGVsdGEueSB9XG4gIHNldCBkeSAodmFsdWUpIHsgdGhpcy5kZWx0YS55ID0gdmFsdWUgfVxuXG4gIGdldCB2ZWxvY2l0eVggKCkgeyByZXR1cm4gdGhpcy52ZWxvY2l0eS54IH1cbiAgc2V0IHZlbG9jaXR5WCAodmFsdWUpIHsgdGhpcy52ZWxvY2l0eS54ID0gdmFsdWUgfVxuICBnZXQgdmVsb2NpdHlZICgpIHsgcmV0dXJuIHRoaXMudmVsb2NpdHkueSB9XG4gIHNldCB2ZWxvY2l0eVkgKHZhbHVlKSB7IHRoaXMudmVsb2NpdHkueSA9IHZhbHVlIH1cblxuICBnZXRTd2lwZSAoKSB7XG4gICAgY29uc3QgaW50ZXJhY3Rpb24gPSB0aGlzLl9pbnRlcmFjdGlvblxuXG4gICAgaWYgKGludGVyYWN0aW9uLnByZXZFdmVudC5zcGVlZCA8IDYwMCB8fFxuICAgICAgICB0aGlzLnRpbWVTdGFtcCAtIGludGVyYWN0aW9uLnByZXZFdmVudC50aW1lU3RhbXAgPiAxNTApIHtcbiAgICAgIHJldHVybiBudWxsXG4gICAgfVxuXG4gICAgbGV0IGFuZ2xlID0gMTgwICogTWF0aC5hdGFuMihpbnRlcmFjdGlvbi5wcmV2RXZlbnQudmVsb2NpdHlZLCBpbnRlcmFjdGlvbi5wcmV2RXZlbnQudmVsb2NpdHlYKSAvIE1hdGguUElcbiAgICBjb25zdCBvdmVybGFwID0gMjIuNVxuXG4gICAgaWYgKGFuZ2xlIDwgMCkge1xuICAgICAgYW5nbGUgKz0gMzYwXG4gICAgfVxuXG4gICAgY29uc3QgbGVmdCA9IDEzNSAtIG92ZXJsYXAgPD0gYW5nbGUgJiYgYW5nbGUgPCAyMjUgKyBvdmVybGFwXG4gICAgY29uc3QgdXAgICA9IDIyNSAtIG92ZXJsYXAgPD0gYW5nbGUgJiYgYW5nbGUgPCAzMTUgKyBvdmVybGFwXG5cbiAgICBjb25zdCByaWdodCA9ICFsZWZ0ICYmICgzMTUgLSBvdmVybGFwIDw9IGFuZ2xlIHx8IGFuZ2xlIDwgIDQ1ICsgb3ZlcmxhcClcbiAgICBjb25zdCBkb3duICA9ICF1cCAgICYmICAgNDUgLSBvdmVybGFwIDw9IGFuZ2xlICYmIGFuZ2xlIDwgMTM1ICsgb3ZlcmxhcFxuXG4gICAgcmV0dXJuIHtcbiAgICAgIHVwLFxuICAgICAgZG93bixcbiAgICAgIGxlZnQsXG4gICAgICByaWdodCxcbiAgICAgIGFuZ2xlLFxuICAgICAgc3BlZWQ6IGludGVyYWN0aW9uLnByZXZFdmVudC5zcGVlZCxcbiAgICAgIHZlbG9jaXR5OiB7XG4gICAgICAgIHg6IGludGVyYWN0aW9uLnByZXZFdmVudC52ZWxvY2l0eVgsXG4gICAgICAgIHk6IGludGVyYWN0aW9uLnByZXZFdmVudC52ZWxvY2l0eVksXG4gICAgICB9LFxuICAgIH1cbiAgfVxuXG4gIHByZXZlbnREZWZhdWx0ICgpIHt9XG5cbiAgLyoqXG4gICAqIERvbid0IGNhbGwgbGlzdGVuZXJzIG9uIHRoZSByZW1haW5pbmcgdGFyZ2V0c1xuICAgKi9cbiAgc3RvcEltbWVkaWF0ZVByb3BhZ2F0aW9uICgpIHtcbiAgICB0aGlzLmltbWVkaWF0ZVByb3BhZ2F0aW9uU3RvcHBlZCA9IHRoaXMucHJvcGFnYXRpb25TdG9wcGVkID0gdHJ1ZVxuICB9XG5cbiAgLyoqXG4gICAqIERvbid0IGNhbGwgYW55IG90aGVyIGxpc3RlbmVycyAoZXZlbiBvbiB0aGUgY3VycmVudCB0YXJnZXQpXG4gICAqL1xuICBzdG9wUHJvcGFnYXRpb24gKCkge1xuICAgIHRoaXMucHJvcGFnYXRpb25TdG9wcGVkID0gdHJ1ZVxuICB9XG59XG5cbmV4cG9ydCBkZWZhdWx0IEludGVyYWN0RXZlbnRcbiIsIi8qIGVzbGludC1kaXNhYmxlIEB0eXBlc2NyaXB0LWVzbGludC9uby1wYXJhbWV0ZXItcHJvcGVydGllcyAqL1xuZXhwb3J0IGNsYXNzIFBvaW50ZXJJbmZvIHtcbiAgY29uc3RydWN0b3IgKFxuICAgIHB1YmxpYyBpZDogbnVtYmVyLFxuICAgIHB1YmxpYyBwb2ludGVyOiBJbnRlcmFjdC5Qb2ludGVyVHlwZSxcbiAgICBwdWJsaWMgZXZlbnQ6IEludGVyYWN0LlBvaW50ZXJFdmVudFR5cGUsXG4gICAgcHVibGljIGRvd25UaW1lOiBudW1iZXIsXG4gICAgcHVibGljIGRvd25UYXJnZXQ6IEludGVyYWN0LkV2ZW50VGFyZ2V0LFxuICApIHt9XG59XG5cbmV4cG9ydCBkZWZhdWx0IFBvaW50ZXJJbmZvXG4iLCJpbXBvcnQgKiBhcyB1dGlscyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9pbmRleCdcbmltcG9ydCBJbnRlcmFjdGFibGUgZnJvbSAnLi9JbnRlcmFjdGFibGUnXG5pbXBvcnQgSW50ZXJhY3RFdmVudCwgeyBFdmVudFBoYXNlIH0gZnJvbSAnLi9JbnRlcmFjdEV2ZW50J1xuaW1wb3J0IFBvaW50ZXJJbmZvIGZyb20gJy4vUG9pbnRlckluZm8nXG5pbXBvcnQgeyBBY3Rpb25OYW1lIH0gZnJvbSAnLi9zY29wZSdcblxuZXhwb3J0IGludGVyZmFjZSBBY3Rpb25Qcm9wczxUIGV4dGVuZHMgQWN0aW9uTmFtZSA9IEludGVyYWN0LkFjdGlvbk5hbWU+IHtcbiAgbmFtZTogVFxuICBheGlzPzogJ3gnIHwgJ3knIHwgJ3h5J1xuICBlZGdlcz86IEludGVyYWN0LkVkZ2VPcHRpb25zXG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgU3RhcnRBY3Rpb24gZXh0ZW5kcyBBY3Rpb25Qcm9wcyB7XG4gIG5hbWU6IEFjdGlvbk5hbWVcbn1cblxuZXhwb3J0IGVudW0gX1Byb3h5VmFsdWVzIHtcbiAgaW50ZXJhY3RhYmxlID0gJycsXG4gIGVsZW1lbnQgPSAnJyxcbiAgcHJlcGFyZWQgPSAnJyxcbiAgcG9pbnRlcklzRG93biA9ICcnLFxuICBwb2ludGVyV2FzTW92ZWQgPSAnJyxcbiAgX3Byb3h5ID0gJydcbn1cblxuZXhwb3J0IGVudW0gX1Byb3h5TWV0aG9kcyB7XG4gIHN0YXJ0ID0gJycsXG4gIG1vdmUgPSAnJyxcbiAgZW5kID0gJycsXG4gIHN0b3AgPSAnJyxcbiAgaW50ZXJhY3RpbmcgPSAnJ1xufVxuXG5leHBvcnQgdHlwZSBQb2ludGVyQXJnUHJvcHM8VCBleHRlbmRzIHt9ID0ge30+ID0ge1xuICBwb2ludGVyOiBJbnRlcmFjdC5Qb2ludGVyVHlwZVxuICBldmVudDogSW50ZXJhY3QuUG9pbnRlckV2ZW50VHlwZVxuICBldmVudFRhcmdldDogSW50ZXJhY3QuRXZlbnRUYXJnZXRcbiAgcG9pbnRlckluZGV4OiBudW1iZXJcbiAgcG9pbnRlckluZm86IFBvaW50ZXJJbmZvXG4gIGludGVyYWN0aW9uOiBJbnRlcmFjdGlvblxufSAmIFRcblxuZXhwb3J0IGludGVyZmFjZSBEb1BoYXNlQXJnPFQgZXh0ZW5kcyBBY3Rpb25OYW1lLCBQIGV4dGVuZHMgRXZlbnRQaGFzZT4ge1xuICBldmVudDogSW50ZXJhY3QuUG9pbnRlckV2ZW50VHlwZVxuICBwaGFzZTogRXZlbnRQaGFzZVxuICBpbnRlcmFjdGlvbjogSW50ZXJhY3Rpb248VD5cbiAgaUV2ZW50OiBJbnRlcmFjdEV2ZW50PFQsIFA+XG4gIHByZUVuZD86IGJvb2xlYW5cbiAgdHlwZT86IHN0cmluZ1xufVxuXG5leHBvcnQgdHlwZSBEb0FueVBoYXNlQXJnID0gRG9QaGFzZUFyZzxBY3Rpb25OYW1lLCBFdmVudFBoYXNlPlxuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvY29yZS9zY29wZScge1xuICBpbnRlcmZhY2UgU2lnbmFsQXJncyB7XG4gICAgJ2ludGVyYWN0aW9uczpuZXcnOiB7IGludGVyYWN0aW9uOiBJbnRlcmFjdGlvbiB9XG4gICAgJ2ludGVyYWN0aW9uczpkb3duJzogUG9pbnRlckFyZ1Byb3BzPHtcbiAgICAgIHR5cGU6ICdkb3duJ1xuICAgIH0+XG4gICAgJ2ludGVyYWN0aW9uczptb3ZlJzogUG9pbnRlckFyZ1Byb3BzPHtcbiAgICAgIHR5cGU6ICdtb3ZlJ1xuICAgICAgZHg6IG51bWJlclxuICAgICAgZHk6IG51bWJlclxuICAgICAgZHVwbGljYXRlOiBib29sZWFuXG4gICAgfT5cbiAgICAnaW50ZXJhY3Rpb25zOnVwJzogUG9pbnRlckFyZ1Byb3BzPHtcbiAgICAgIHR5cGU6ICd1cCdcbiAgICAgIGN1ckV2ZW50VGFyZ2V0OiBFdmVudFRhcmdldFxuICAgIH0+XG4gICAgJ2ludGVyYWN0aW9uczpjYW5jZWwnOiBTaWduYWxBcmdzWydpbnRlcmFjdGlvbnM6dXAnXSAmIHtcbiAgICAgIHR5cGU6ICdjYW5jZWwnXG4gICAgICBjdXJFdmVudFRhcmdldDogRXZlbnRUYXJnZXRcbiAgICB9XG4gICAgJ2ludGVyYWN0aW9uczp1cGRhdGUtcG9pbnRlcic6IFBvaW50ZXJBcmdQcm9wczx7XG4gICAgICBkb3duOiBib29sZWFuXG4gICAgfT5cbiAgICAnaW50ZXJhY3Rpb25zOnJlbW92ZS1wb2ludGVyJzogUG9pbnRlckFyZ1Byb3BzXG4gICAgJ2ludGVyYWN0aW9uczpibHVyJ1xuICAgICdpbnRlcmFjdGlvbnM6YmVmb3JlLWFjdGlvbi1zdGFydCc6IE9taXQ8RG9BbnlQaGFzZUFyZywgJ2lFdmVudCc+XG4gICAgJ2ludGVyYWN0aW9uczphY3Rpb24tc3RhcnQnOiBEb0FueVBoYXNlQXJnXG4gICAgJ2ludGVyYWN0aW9uczphZnRlci1hY3Rpb24tc3RhcnQnOiBEb0FueVBoYXNlQXJnXG4gICAgJ2ludGVyYWN0aW9uczpiZWZvcmUtYWN0aW9uLW1vdmUnOiBPbWl0PERvQW55UGhhc2VBcmcsICdpRXZlbnQnPlxuICAgICdpbnRlcmFjdGlvbnM6YWN0aW9uLW1vdmUnOiBEb0FueVBoYXNlQXJnXG4gICAgJ2ludGVyYWN0aW9uczphZnRlci1hY3Rpb24tbW92ZSc6IERvQW55UGhhc2VBcmdcbiAgICAnaW50ZXJhY3Rpb25zOmJlZm9yZS1hY3Rpb24tZW5kJzogT21pdDxEb0FueVBoYXNlQXJnLCAnaUV2ZW50Jz5cbiAgICAnaW50ZXJhY3Rpb25zOmFjdGlvbi1lbmQnOiBEb0FueVBoYXNlQXJnXG4gICAgJ2ludGVyYWN0aW9uczphZnRlci1hY3Rpb24tZW5kJzogRG9BbnlQaGFzZUFyZ1xuICAgICdpbnRlcmFjdGlvbnM6c3RvcCc6IHsgaW50ZXJhY3Rpb246IEludGVyYWN0aW9uIH1cbiAgfVxufVxuXG5leHBvcnQgdHlwZSBJbnRlcmFjdGlvblByb3h5PFQgZXh0ZW5kcyBBY3Rpb25OYW1lID0gQWN0aW9uTmFtZT4gPSBQaWNrPFxuSW50ZXJhY3Rpb248VD4sXG5rZXlvZiB0eXBlb2YgX1Byb3h5VmFsdWVzIHwga2V5b2YgdHlwZW9mIF9Qcm94eU1ldGhvZHNcbj5cblxubGV0IGlkQ291bnRlciA9IDBcblxuZXhwb3J0IGNsYXNzIEludGVyYWN0aW9uPFQgZXh0ZW5kcyBBY3Rpb25OYW1lID0gQWN0aW9uTmFtZT4ge1xuICAvLyBjdXJyZW50IGludGVyYWN0YWJsZSBiZWluZyBpbnRlcmFjdGVkIHdpdGhcbiAgaW50ZXJhY3RhYmxlOiBJbnRlcmFjdGFibGUgPSBudWxsXG5cbiAgLy8gdGhlIHRhcmdldCBlbGVtZW50IG9mIHRoZSBpbnRlcmFjdGFibGVcbiAgZWxlbWVudDogSW50ZXJhY3QuRWxlbWVudCA9IG51bGxcbiAgcmVjdDogSW50ZXJhY3QuRnVsbFJlY3RcbiAgX3JlY3RzPzoge1xuICAgIHN0YXJ0OiBJbnRlcmFjdC5GdWxsUmVjdFxuICAgIGNvcnJlY3RlZDogSW50ZXJhY3QuRnVsbFJlY3RcbiAgICBwcmV2aW91czogSW50ZXJhY3QuRnVsbFJlY3RcbiAgICBkZWx0YTogSW50ZXJhY3QuRnVsbFJlY3RcbiAgfVxuICBlZGdlczogSW50ZXJhY3QuRWRnZU9wdGlvbnNcblxuICBfc2NvcGVGaXJlOiBJbnRlcmFjdC5TY29wZVsnZmlyZSddXG5cbiAgLy8gYWN0aW9uIHRoYXQncyByZWFkeSB0byBiZSBmaXJlZCBvbiBuZXh0IG1vdmUgZXZlbnRcbiAgcHJlcGFyZWQ6IEFjdGlvblByb3BzPFQ+ID0ge1xuICAgIG5hbWUgOiBudWxsLFxuICAgIGF4aXMgOiBudWxsLFxuICAgIGVkZ2VzOiBudWxsLFxuICB9XG5cbiAgcG9pbnRlclR5cGU6IHN0cmluZ1xuXG4gIC8vIGtlZXAgdHJhY2sgb2YgYWRkZWQgcG9pbnRlcnNcbiAgcG9pbnRlcnM6IFBvaW50ZXJJbmZvW10gPSBbXVxuXG4gIC8vIHBvaW50ZXJkb3duL21vdXNlZG93bi90b3VjaHN0YXJ0IGV2ZW50XG4gIGRvd25FdmVudDogSW50ZXJhY3QuUG9pbnRlckV2ZW50VHlwZSA9IG51bGxcblxuICBkb3duUG9pbnRlcjogSW50ZXJhY3QuUG9pbnRlclR5cGUgPSB7fSBhcyBJbnRlcmFjdC5Qb2ludGVyVHlwZVxuXG4gIF9sYXRlc3RQb2ludGVyOiB7XG4gICAgcG9pbnRlcjogSW50ZXJhY3QuUG9pbnRlclR5cGVcbiAgICBldmVudDogSW50ZXJhY3QuUG9pbnRlckV2ZW50VHlwZVxuICAgIGV2ZW50VGFyZ2V0OiBOb2RlXG4gIH0gPSB7XG4gICAgcG9pbnRlcjogbnVsbCxcbiAgICBldmVudDogbnVsbCxcbiAgICBldmVudFRhcmdldDogbnVsbCxcbiAgfVxuXG4gIC8vIHByZXZpb3VzIGFjdGlvbiBldmVudFxuICBwcmV2RXZlbnQ6IEludGVyYWN0RXZlbnQ8VCwgRXZlbnRQaGFzZT4gPSBudWxsXG5cbiAgcG9pbnRlcklzRG93biA9IGZhbHNlXG4gIHBvaW50ZXJXYXNNb3ZlZCA9IGZhbHNlXG4gIF9pbnRlcmFjdGluZyA9IGZhbHNlXG4gIF9lbmRpbmcgPSBmYWxzZVxuICBfc3RvcHBlZCA9IHRydWVcbiAgX3Byb3h5OiBJbnRlcmFjdGlvblByb3h5PFQ+ID0gbnVsbFxuXG4gIHNpbXVsYXRpb24gPSBudWxsXG5cbiAgZ2V0IHBvaW50ZXJNb3ZlVG9sZXJhbmNlICgpIHtcbiAgICByZXR1cm4gMVxuICB9XG5cbiAgLyoqXG4gICAqIEBhbGlhcyBJbnRlcmFjdGlvbi5wcm90b3R5cGUubW92ZVxuICAgKi9cbiAgZG9Nb3ZlID0gdXRpbHMud2Fybk9uY2UoXG4gICAgZnVuY3Rpb24gKHRoaXM6IEludGVyYWN0aW9uLCBzaWduYWxBcmc6IGFueSkge1xuICAgICAgdGhpcy5tb3ZlKHNpZ25hbEFyZylcbiAgICB9LFxuICAgICdUaGUgaW50ZXJhY3Rpb24uZG9Nb3ZlKCkgbWV0aG9kIGhhcyBiZWVuIHJlbmFtZWQgdG8gaW50ZXJhY3Rpb24ubW92ZSgpJylcblxuICBjb29yZHM6IEludGVyYWN0LkNvb3Jkc1NldCA9IHtcbiAgICAvLyBTdGFydGluZyBJbnRlcmFjdEV2ZW50IHBvaW50ZXIgY29vcmRpbmF0ZXNcbiAgICBzdGFydDogdXRpbHMucG9pbnRlci5uZXdDb29yZHMoKSxcbiAgICAvLyBQcmV2aW91cyBuYXRpdmUgcG9pbnRlciBtb3ZlIGV2ZW50IGNvb3JkaW5hdGVzXG4gICAgcHJldjogdXRpbHMucG9pbnRlci5uZXdDb29yZHMoKSxcbiAgICAvLyBjdXJyZW50IG5hdGl2ZSBwb2ludGVyIG1vdmUgZXZlbnQgY29vcmRpbmF0ZXNcbiAgICBjdXI6IHV0aWxzLnBvaW50ZXIubmV3Q29vcmRzKCksXG4gICAgLy8gQ2hhbmdlIGluIGNvb3JkaW5hdGVzIGFuZCB0aW1lIG9mIHRoZSBwb2ludGVyXG4gICAgZGVsdGE6IHV0aWxzLnBvaW50ZXIubmV3Q29vcmRzKCksXG4gICAgLy8gcG9pbnRlciB2ZWxvY2l0eVxuICAgIHZlbG9jaXR5OiB1dGlscy5wb2ludGVyLm5ld0Nvb3JkcygpLFxuICB9XG5cbiAgcmVhZG9ubHkgX2lkOiBudW1iZXIgPSBpZENvdW50ZXIrK1xuXG4gIC8qKiAqL1xuICBjb25zdHJ1Y3RvciAoeyBwb2ludGVyVHlwZSwgc2NvcGVGaXJlIH06IHtcbiAgICBwb2ludGVyVHlwZT86IHN0cmluZ1xuICAgIHNjb3BlRmlyZTogSW50ZXJhY3QuU2NvcGVbJ2ZpcmUnXVxuICB9KSB7XG4gICAgdGhpcy5fc2NvcGVGaXJlID0gc2NvcGVGaXJlXG4gICAgdGhpcy5wb2ludGVyVHlwZSA9IHBvaW50ZXJUeXBlXG5cbiAgICBjb25zdCB0aGF0ID0gdGhpc1xuXG4gICAgdGhpcy5fcHJveHkgPSB7fSBhcyBJbnRlcmFjdGlvblByb3h5PFQ+XG5cbiAgICBmb3IgKGNvbnN0IGtleSBpbiBfUHJveHlWYWx1ZXMpIHtcbiAgICAgIE9iamVjdC5kZWZpbmVQcm9wZXJ0eSh0aGlzLl9wcm94eSwga2V5LCB7XG4gICAgICAgIGdldCAoKSB7IHJldHVybiB0aGF0W2tleV0gfSxcbiAgICAgIH0pXG4gICAgfVxuXG4gICAgZm9yIChjb25zdCBrZXkgaW4gX1Byb3h5TWV0aG9kcykge1xuICAgICAgT2JqZWN0LmRlZmluZVByb3BlcnR5KHRoaXMuX3Byb3h5LCBrZXksIHtcbiAgICAgICAgdmFsdWU6ICguLi5hcmdzKSA9PiB0aGF0W2tleV0oLi4uYXJncyksXG4gICAgICB9KVxuICAgIH1cblxuICAgIHRoaXMuX3Njb3BlRmlyZSgnaW50ZXJhY3Rpb25zOm5ldycsIHsgaW50ZXJhY3Rpb246IHRoaXMgfSlcbiAgfVxuXG4gIHBvaW50ZXJEb3duIChwb2ludGVyOiBJbnRlcmFjdC5Qb2ludGVyVHlwZSwgZXZlbnQ6IEludGVyYWN0LlBvaW50ZXJFdmVudFR5cGUsIGV2ZW50VGFyZ2V0OiBJbnRlcmFjdC5FdmVudFRhcmdldCkge1xuICAgIGNvbnN0IHBvaW50ZXJJbmRleCA9IHRoaXMudXBkYXRlUG9pbnRlcihwb2ludGVyLCBldmVudCwgZXZlbnRUYXJnZXQsIHRydWUpXG4gICAgY29uc3QgcG9pbnRlckluZm8gPSB0aGlzLnBvaW50ZXJzW3BvaW50ZXJJbmRleF1cblxuICAgIHRoaXMuX3Njb3BlRmlyZSgnaW50ZXJhY3Rpb25zOmRvd24nLCB7XG4gICAgICBwb2ludGVyLFxuICAgICAgZXZlbnQsXG4gICAgICBldmVudFRhcmdldCxcbiAgICAgIHBvaW50ZXJJbmRleCxcbiAgICAgIHBvaW50ZXJJbmZvLFxuICAgICAgdHlwZTogJ2Rvd24nLFxuICAgICAgaW50ZXJhY3Rpb246IHRoaXMsXG4gICAgfSlcbiAgfVxuXG4gIC8qKlxuICAgKiBgYGBqc1xuICAgKiBpbnRlcmFjdCh0YXJnZXQpXG4gICAqICAgLmRyYWdnYWJsZSh7XG4gICAqICAgICAvLyBkaXNhYmxlIHRoZSBkZWZhdWx0IGRyYWcgc3RhcnQgYnkgZG93bi0+bW92ZVxuICAgKiAgICAgbWFudWFsU3RhcnQ6IHRydWVcbiAgICogICB9KVxuICAgKiAgIC8vIHN0YXJ0IGRyYWdnaW5nIGFmdGVyIHRoZSB1c2VyIGhvbGRzIHRoZSBwb2ludGVyIGRvd25cbiAgICogICAub24oJ2hvbGQnLCBmdW5jdGlvbiAoZXZlbnQpIHtcbiAgICogICAgIHZhciBpbnRlcmFjdGlvbiA9IGV2ZW50LmludGVyYWN0aW9uXG4gICAqXG4gICAqICAgICBpZiAoIWludGVyYWN0aW9uLmludGVyYWN0aW5nKCkpIHtcbiAgICogICAgICAgaW50ZXJhY3Rpb24uc3RhcnQoeyBuYW1lOiAnZHJhZycgfSxcbiAgICogICAgICAgICAgICAgICAgICAgICAgICAgZXZlbnQuaW50ZXJhY3RhYmxlLFxuICAgKiAgICAgICAgICAgICAgICAgICAgICAgICBldmVudC5jdXJyZW50VGFyZ2V0KVxuICAgKiAgICAgfVxuICAgKiB9KVxuICAgKiBgYGBcbiAgICpcbiAgICogU3RhcnQgYW4gYWN0aW9uIHdpdGggdGhlIGdpdmVuIEludGVyYWN0YWJsZSBhbmQgRWxlbWVudCBhcyB0YXJ0Z2V0cy4gVGhlXG4gICAqIGFjdGlvbiBtdXN0IGJlIGVuYWJsZWQgZm9yIHRoZSB0YXJnZXQgSW50ZXJhY3RhYmxlIGFuZCBhbiBhcHByb3ByaWF0ZVxuICAgKiBudW1iZXIgb2YgcG9pbnRlcnMgbXVzdCBiZSBoZWxkIGRvd24gLSAxIGZvciBkcmFnL3Jlc2l6ZSwgMiBmb3IgZ2VzdHVyZS5cbiAgICpcbiAgICogVXNlIGl0IHdpdGggYGludGVyYWN0YWJsZS48YWN0aW9uPmFibGUoeyBtYW51YWxTdGFydDogZmFsc2UgfSlgIHRvIGFsd2F5c1xuICAgKiBbc3RhcnQgYWN0aW9ucyBtYW51YWxseV0oaHR0cHM6Ly9naXRodWIuY29tL3RheWUvaW50ZXJhY3QuanMvaXNzdWVzLzExNClcbiAgICpcbiAgICogQHBhcmFtIHtvYmplY3R9IGFjdGlvbiAgIFRoZSBhY3Rpb24gdG8gYmUgcGVyZm9ybWVkIC0gZHJhZywgcmVzaXplLCBldGMuXG4gICAqIEBwYXJhbSB7SW50ZXJhY3RhYmxlfSB0YXJnZXQgIFRoZSBJbnRlcmFjdGFibGUgdG8gdGFyZ2V0XG4gICAqIEBwYXJhbSB7RWxlbWVudH0gZWxlbWVudCBUaGUgRE9NIEVsZW1lbnQgdG8gdGFyZ2V0XG4gICAqIEByZXR1cm4ge29iamVjdH0gaW50ZXJhY3RcbiAgICovXG4gIHN0YXJ0IChhY3Rpb246IFN0YXJ0QWN0aW9uLCBpbnRlcmFjdGFibGU6IEludGVyYWN0YWJsZSwgZWxlbWVudDogSW50ZXJhY3QuRWxlbWVudCkge1xuICAgIGlmICh0aGlzLmludGVyYWN0aW5nKCkgfHxcbiAgICAgICAgIXRoaXMucG9pbnRlcklzRG93biB8fFxuICAgICAgICB0aGlzLnBvaW50ZXJzLmxlbmd0aCA8IChhY3Rpb24ubmFtZSA9PT0gJ2dlc3R1cmUnID8gMiA6IDEpIHx8XG4gICAgICAgICFpbnRlcmFjdGFibGUub3B0aW9uc1thY3Rpb24ubmFtZV0uZW5hYmxlZCkge1xuICAgICAgcmV0dXJuIGZhbHNlXG4gICAgfVxuXG4gICAgdXRpbHMuY29weUFjdGlvbih0aGlzLnByZXBhcmVkLCBhY3Rpb24pXG5cbiAgICB0aGlzLmludGVyYWN0YWJsZSA9IGludGVyYWN0YWJsZVxuICAgIHRoaXMuZWxlbWVudCAgICAgID0gZWxlbWVudFxuICAgIHRoaXMucmVjdCAgICAgICAgID0gaW50ZXJhY3RhYmxlLmdldFJlY3QoZWxlbWVudClcbiAgICB0aGlzLmVkZ2VzICAgICAgICA9IHRoaXMucHJlcGFyZWQuZWRnZXNcbiAgICAgID8gdXRpbHMuZXh0ZW5kKHt9LCB0aGlzLnByZXBhcmVkLmVkZ2VzKVxuICAgICAgOiB7IGxlZnQ6IHRydWUsIHJpZ2h0OiB0cnVlLCB0b3A6IHRydWUsIGJvdHRvbTogdHJ1ZSB9XG4gICAgdGhpcy5fc3RvcHBlZCAgICAgPSBmYWxzZVxuICAgIHRoaXMuX2ludGVyYWN0aW5nID0gdGhpcy5fZG9QaGFzZSh7XG4gICAgICBpbnRlcmFjdGlvbjogdGhpcyxcbiAgICAgIGV2ZW50OiB0aGlzLmRvd25FdmVudCxcbiAgICAgIHBoYXNlOiAnc3RhcnQnLFxuICAgIH0pICYmICF0aGlzLl9zdG9wcGVkXG5cbiAgICByZXR1cm4gdGhpcy5faW50ZXJhY3RpbmdcbiAgfVxuXG4gIHBvaW50ZXJNb3ZlIChwb2ludGVyOiBJbnRlcmFjdC5Qb2ludGVyVHlwZSwgZXZlbnQ6IEludGVyYWN0LlBvaW50ZXJFdmVudFR5cGUsIGV2ZW50VGFyZ2V0OiBJbnRlcmFjdC5FdmVudFRhcmdldCkge1xuICAgIGlmICghdGhpcy5zaW11bGF0aW9uICYmICEodGhpcy5tb2RpZmljYXRpb24gJiYgdGhpcy5tb2RpZmljYXRpb24uZW5kUmVzdWx0KSkge1xuICAgICAgdGhpcy51cGRhdGVQb2ludGVyKHBvaW50ZXIsIGV2ZW50LCBldmVudFRhcmdldCwgZmFsc2UpXG4gICAgfVxuXG4gICAgY29uc3QgZHVwbGljYXRlTW92ZSA9ICh0aGlzLmNvb3Jkcy5jdXIucGFnZS54ID09PSB0aGlzLmNvb3Jkcy5wcmV2LnBhZ2UueCAmJlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5jb29yZHMuY3VyLnBhZ2UueSA9PT0gdGhpcy5jb29yZHMucHJldi5wYWdlLnkgJiZcbiAgICAgICAgICAgICAgICAgICAgICAgICAgIHRoaXMuY29vcmRzLmN1ci5jbGllbnQueCA9PT0gdGhpcy5jb29yZHMucHJldi5jbGllbnQueCAmJlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5jb29yZHMuY3VyLmNsaWVudC55ID09PSB0aGlzLmNvb3Jkcy5wcmV2LmNsaWVudC55KVxuXG4gICAgbGV0IGR4XG4gICAgbGV0IGR5XG5cbiAgICAvLyByZWdpc3RlciBtb3ZlbWVudCBncmVhdGVyIHRoYW4gcG9pbnRlck1vdmVUb2xlcmFuY2VcbiAgICBpZiAodGhpcy5wb2ludGVySXNEb3duICYmICF0aGlzLnBvaW50ZXJXYXNNb3ZlZCkge1xuICAgICAgZHggPSB0aGlzLmNvb3Jkcy5jdXIuY2xpZW50LnggLSB0aGlzLmNvb3Jkcy5zdGFydC5jbGllbnQueFxuICAgICAgZHkgPSB0aGlzLmNvb3Jkcy5jdXIuY2xpZW50LnkgLSB0aGlzLmNvb3Jkcy5zdGFydC5jbGllbnQueVxuXG4gICAgICB0aGlzLnBvaW50ZXJXYXNNb3ZlZCA9IHV0aWxzLmh5cG90KGR4LCBkeSkgPiB0aGlzLnBvaW50ZXJNb3ZlVG9sZXJhbmNlXG4gICAgfVxuXG4gICAgY29uc3QgcG9pbnRlckluZGV4ID0gdGhpcy5nZXRQb2ludGVySW5kZXgocG9pbnRlcilcbiAgICBjb25zdCBzaWduYWxBcmcgPSB7XG4gICAgICBwb2ludGVyLFxuICAgICAgcG9pbnRlckluZGV4LFxuICAgICAgcG9pbnRlckluZm86IHRoaXMucG9pbnRlcnNbcG9pbnRlckluZGV4XSxcbiAgICAgIGV2ZW50LFxuICAgICAgdHlwZTogJ21vdmUnIGFzIGNvbnN0LFxuICAgICAgZXZlbnRUYXJnZXQsXG4gICAgICBkeCxcbiAgICAgIGR5LFxuICAgICAgZHVwbGljYXRlOiBkdXBsaWNhdGVNb3ZlLFxuICAgICAgaW50ZXJhY3Rpb246IHRoaXMsXG4gICAgfVxuXG4gICAgaWYgKCFkdXBsaWNhdGVNb3ZlKSB7XG4gICAgICAvLyBzZXQgcG9pbnRlciBjb29yZGluYXRlLCB0aW1lIGNoYW5nZXMgYW5kIHZlbG9jaXR5XG4gICAgICB1dGlscy5wb2ludGVyLnNldENvb3JkVmVsb2NpdHkodGhpcy5jb29yZHMudmVsb2NpdHksIHRoaXMuY29vcmRzLmRlbHRhKVxuICAgIH1cblxuICAgIHRoaXMuX3Njb3BlRmlyZSgnaW50ZXJhY3Rpb25zOm1vdmUnLCBzaWduYWxBcmcpXG5cbiAgICBpZiAoIWR1cGxpY2F0ZU1vdmUgJiYgIXRoaXMuc2ltdWxhdGlvbikge1xuICAgICAgLy8gaWYgaW50ZXJhY3RpbmcsIGZpcmUgYW4gJ2FjdGlvbi1tb3ZlJyBzaWduYWwgZXRjXG4gICAgICBpZiAodGhpcy5pbnRlcmFjdGluZygpKSB7XG4gICAgICAgIHNpZ25hbEFyZy50eXBlID0gbnVsbFxuICAgICAgICB0aGlzLm1vdmUoc2lnbmFsQXJnKVxuICAgICAgfVxuXG4gICAgICBpZiAodGhpcy5wb2ludGVyV2FzTW92ZWQpIHtcbiAgICAgICAgdXRpbHMucG9pbnRlci5jb3B5Q29vcmRzKHRoaXMuY29vcmRzLnByZXYsIHRoaXMuY29vcmRzLmN1cilcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICAvKipcbiAgICogYGBganNcbiAgICogaW50ZXJhY3QodGFyZ2V0KVxuICAgKiAgIC5kcmFnZ2FibGUodHJ1ZSlcbiAgICogICAub24oJ2RyYWdtb3ZlJywgZnVuY3Rpb24gKGV2ZW50KSB7XG4gICAqICAgICBpZiAoc29tZUNvbmRpdGlvbikge1xuICAgKiAgICAgICAvLyBjaGFuZ2UgdGhlIHNuYXAgc2V0dGluZ3NcbiAgICogICAgICAgZXZlbnQuaW50ZXJhY3RhYmxlLmRyYWdnYWJsZSh7IHNuYXA6IHsgdGFyZ2V0czogW10gfX0pXG4gICAqICAgICAgIC8vIGZpcmUgYW5vdGhlciBtb3ZlIGV2ZW50IHdpdGggcmUtY2FsY3VsYXRlZCBzbmFwXG4gICAqICAgICAgIGV2ZW50LmludGVyYWN0aW9uLm1vdmUoKVxuICAgKiAgICAgfVxuICAgKiAgIH0pXG4gICAqIGBgYFxuICAgKlxuICAgKiBGb3JjZSBhIG1vdmUgb2YgdGhlIGN1cnJlbnQgYWN0aW9uIGF0IHRoZSBzYW1lIGNvb3JkaW5hdGVzLiBVc2VmdWwgaWZcbiAgICogc25hcC9yZXN0cmljdCBoYXMgYmVlbiBjaGFuZ2VkIGFuZCB5b3Ugd2FudCBhIG1vdmVtZW50IHdpdGggdGhlIG5ld1xuICAgKiBzZXR0aW5ncy5cbiAgICovXG4gIG1vdmUgKHNpZ25hbEFyZz8pIHtcbiAgICBpZiAoIXNpZ25hbEFyZyB8fCAhc2lnbmFsQXJnLmV2ZW50KSB7XG4gICAgICB1dGlscy5wb2ludGVyLnNldFplcm9Db29yZHModGhpcy5jb29yZHMuZGVsdGEpXG4gICAgfVxuXG4gICAgc2lnbmFsQXJnID0gdXRpbHMuZXh0ZW5kKHtcbiAgICAgIHBvaW50ZXI6IHRoaXMuX2xhdGVzdFBvaW50ZXIucG9pbnRlcixcbiAgICAgIGV2ZW50OiB0aGlzLl9sYXRlc3RQb2ludGVyLmV2ZW50LFxuICAgICAgZXZlbnRUYXJnZXQ6IHRoaXMuX2xhdGVzdFBvaW50ZXIuZXZlbnRUYXJnZXQsXG4gICAgICBpbnRlcmFjdGlvbjogdGhpcyxcbiAgICB9LCBzaWduYWxBcmcgfHwge30pXG5cbiAgICBzaWduYWxBcmcucGhhc2UgPSAnbW92ZSdcblxuICAgIHRoaXMuX2RvUGhhc2Uoc2lnbmFsQXJnKVxuICB9XG5cbiAgLy8gRW5kIGludGVyYWN0IG1vdmUgZXZlbnRzIGFuZCBzdG9wIGF1dG8tc2Nyb2xsIHVubGVzcyBzaW11bGF0aW9uIGlzIHJ1bm5pbmdcbiAgcG9pbnRlclVwIChwb2ludGVyOiBJbnRlcmFjdC5Qb2ludGVyVHlwZSwgZXZlbnQ6IEludGVyYWN0LlBvaW50ZXJFdmVudFR5cGUsIGV2ZW50VGFyZ2V0OiBJbnRlcmFjdC5FdmVudFRhcmdldCwgY3VyRXZlbnRUYXJnZXQ6IEludGVyYWN0LkV2ZW50VGFyZ2V0KSB7XG4gICAgbGV0IHBvaW50ZXJJbmRleCA9IHRoaXMuZ2V0UG9pbnRlckluZGV4KHBvaW50ZXIpXG5cbiAgICBpZiAocG9pbnRlckluZGV4ID09PSAtMSkge1xuICAgICAgcG9pbnRlckluZGV4ID0gdGhpcy51cGRhdGVQb2ludGVyKHBvaW50ZXIsIGV2ZW50LCBldmVudFRhcmdldCwgZmFsc2UpXG4gICAgfVxuXG4gICAgY29uc3QgdHlwZSA9IC9jYW5jZWwkL2kudGVzdChldmVudC50eXBlKSA/ICdjYW5jZWwnIDogJ3VwJ1xuXG4gICAgdGhpcy5fc2NvcGVGaXJlKGBpbnRlcmFjdGlvbnM6JHt0eXBlfWAgYXMgJ2ludGVyYWN0aW9uczp1cCcgfCAnaW50ZXJhY3Rpb25zOmNhbmNlbCcsIHtcbiAgICAgIHBvaW50ZXIsXG4gICAgICBwb2ludGVySW5kZXgsXG4gICAgICBwb2ludGVySW5mbzogdGhpcy5wb2ludGVyc1twb2ludGVySW5kZXhdLFxuICAgICAgZXZlbnQsXG4gICAgICBldmVudFRhcmdldCxcbiAgICAgIHR5cGU6IHR5cGUgYXMgYW55LFxuICAgICAgY3VyRXZlbnRUYXJnZXQsXG4gICAgICBpbnRlcmFjdGlvbjogdGhpcyxcbiAgICB9KVxuXG4gICAgaWYgKCF0aGlzLnNpbXVsYXRpb24pIHtcbiAgICAgIHRoaXMuZW5kKGV2ZW50KVxuICAgIH1cblxuICAgIHRoaXMucG9pbnRlcklzRG93biA9IGZhbHNlXG4gICAgdGhpcy5yZW1vdmVQb2ludGVyKHBvaW50ZXIsIGV2ZW50KVxuICB9XG5cbiAgZG9jdW1lbnRCbHVyIChldmVudCkge1xuICAgIHRoaXMuZW5kKGV2ZW50KVxuICAgIHRoaXMuX3Njb3BlRmlyZSgnaW50ZXJhY3Rpb25zOmJsdXInLCB7IGV2ZW50LCB0eXBlOiAnYmx1cicsIGludGVyYWN0aW9uOiB0aGlzIH0pXG4gIH1cblxuICAvKipcbiAgICogYGBganNcbiAgICogaW50ZXJhY3QodGFyZ2V0KVxuICAgKiAgIC5kcmFnZ2FibGUodHJ1ZSlcbiAgICogICAub24oJ21vdmUnLCBmdW5jdGlvbiAoZXZlbnQpIHtcbiAgICogICAgIGlmIChldmVudC5wYWdlWCA+IDEwMDApIHtcbiAgICogICAgICAgLy8gZW5kIHRoZSBjdXJyZW50IGFjdGlvblxuICAgKiAgICAgICBldmVudC5pbnRlcmFjdGlvbi5lbmQoKVxuICAgKiAgICAgICAvLyBzdG9wIGFsbCBmdXJ0aGVyIGxpc3RlbmVycyBmcm9tIGJlaW5nIGNhbGxlZFxuICAgKiAgICAgICBldmVudC5zdG9wSW1tZWRpYXRlUHJvcGFnYXRpb24oKVxuICAgKiAgICAgfVxuICAgKiAgIH0pXG4gICAqIGBgYFxuICAgKlxuICAgKiBAcGFyYW0ge1BvaW50ZXJFdmVudH0gW2V2ZW50XVxuICAgKi9cbiAgZW5kIChldmVudD86IEludGVyYWN0LlBvaW50ZXJFdmVudFR5cGUpIHtcbiAgICB0aGlzLl9lbmRpbmcgPSB0cnVlXG4gICAgZXZlbnQgPSBldmVudCB8fCB0aGlzLl9sYXRlc3RQb2ludGVyLmV2ZW50XG4gICAgbGV0IGVuZFBoYXNlUmVzdWx0XG5cbiAgICBpZiAodGhpcy5pbnRlcmFjdGluZygpKSB7XG4gICAgICBlbmRQaGFzZVJlc3VsdCA9IHRoaXMuX2RvUGhhc2Uoe1xuICAgICAgICBldmVudCxcbiAgICAgICAgaW50ZXJhY3Rpb246IHRoaXMsXG4gICAgICAgIHBoYXNlOiAnZW5kJyxcbiAgICAgIH0pXG4gICAgfVxuXG4gICAgdGhpcy5fZW5kaW5nID0gZmFsc2VcblxuICAgIGlmIChlbmRQaGFzZVJlc3VsdCA9PT0gdHJ1ZSkge1xuICAgICAgdGhpcy5zdG9wKClcbiAgICB9XG4gIH1cblxuICBjdXJyZW50QWN0aW9uICgpIHtcbiAgICByZXR1cm4gdGhpcy5faW50ZXJhY3RpbmcgPyB0aGlzLnByZXBhcmVkLm5hbWUgOiBudWxsXG4gIH1cblxuICBpbnRlcmFjdGluZyAoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2ludGVyYWN0aW5nXG4gIH1cblxuICAvKiogKi9cbiAgc3RvcCAoKSB7XG4gICAgdGhpcy5fc2NvcGVGaXJlKCdpbnRlcmFjdGlvbnM6c3RvcCcsIHsgaW50ZXJhY3Rpb246IHRoaXMgfSlcblxuICAgIHRoaXMuaW50ZXJhY3RhYmxlID0gdGhpcy5lbGVtZW50ID0gbnVsbFxuXG4gICAgdGhpcy5faW50ZXJhY3RpbmcgPSBmYWxzZVxuICAgIHRoaXMuX3N0b3BwZWQgPSB0cnVlXG4gICAgdGhpcy5wcmVwYXJlZC5uYW1lID0gdGhpcy5wcmV2RXZlbnQgPSBudWxsXG4gIH1cblxuICBnZXRQb2ludGVySW5kZXggKHBvaW50ZXIpIHtcbiAgICBjb25zdCBwb2ludGVySWQgPSB1dGlscy5wb2ludGVyLmdldFBvaW50ZXJJZChwb2ludGVyKVxuXG4gICAgLy8gbW91c2UgYW5kIHBlbiBpbnRlcmFjdGlvbnMgbWF5IGhhdmUgb25seSBvbmUgcG9pbnRlclxuICAgIHJldHVybiAodGhpcy5wb2ludGVyVHlwZSA9PT0gJ21vdXNlJyB8fCB0aGlzLnBvaW50ZXJUeXBlID09PSAncGVuJylcbiAgICAgID8gdGhpcy5wb2ludGVycy5sZW5ndGggLSAxXG4gICAgICA6IHV0aWxzLmFyci5maW5kSW5kZXgodGhpcy5wb2ludGVycywgY3VyUG9pbnRlciA9PiBjdXJQb2ludGVyLmlkID09PSBwb2ludGVySWQpXG4gIH1cblxuICBnZXRQb2ludGVySW5mbyAocG9pbnRlcikge1xuICAgIHJldHVybiB0aGlzLnBvaW50ZXJzW3RoaXMuZ2V0UG9pbnRlckluZGV4KHBvaW50ZXIpXVxuICB9XG5cbiAgdXBkYXRlUG9pbnRlciAocG9pbnRlcjogSW50ZXJhY3QuUG9pbnRlclR5cGUsIGV2ZW50OiBJbnRlcmFjdC5Qb2ludGVyRXZlbnRUeXBlLCBldmVudFRhcmdldDogSW50ZXJhY3QuRXZlbnRUYXJnZXQsIGRvd24/OiBib29sZWFuKSB7XG4gICAgY29uc3QgaWQgPSB1dGlscy5wb2ludGVyLmdldFBvaW50ZXJJZChwb2ludGVyKVxuICAgIGxldCBwb2ludGVySW5kZXggPSB0aGlzLmdldFBvaW50ZXJJbmRleChwb2ludGVyKVxuICAgIGxldCBwb2ludGVySW5mbyA9IHRoaXMucG9pbnRlcnNbcG9pbnRlckluZGV4XVxuXG4gICAgZG93biA9IGRvd24gPT09IGZhbHNlXG4gICAgICA/IGZhbHNlXG4gICAgICA6IGRvd24gfHwgLyhkb3dufHN0YXJ0KSQvaS50ZXN0KGV2ZW50LnR5cGUpXG5cbiAgICBpZiAoIXBvaW50ZXJJbmZvKSB7XG4gICAgICBwb2ludGVySW5mbyA9IG5ldyBQb2ludGVySW5mbyhcbiAgICAgICAgaWQsXG4gICAgICAgIHBvaW50ZXIsXG4gICAgICAgIGV2ZW50LFxuICAgICAgICBudWxsLFxuICAgICAgICBudWxsLFxuICAgICAgKVxuXG4gICAgICBwb2ludGVySW5kZXggPSB0aGlzLnBvaW50ZXJzLmxlbmd0aFxuICAgICAgdGhpcy5wb2ludGVycy5wdXNoKHBvaW50ZXJJbmZvKVxuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHBvaW50ZXJJbmZvLnBvaW50ZXIgPSBwb2ludGVyXG4gICAgfVxuXG4gICAgdXRpbHMucG9pbnRlci5zZXRDb29yZHModGhpcy5jb29yZHMuY3VyLCB0aGlzLnBvaW50ZXJzLm1hcChwID0+IHAucG9pbnRlciksIHRoaXMuX25vdygpKVxuICAgIHV0aWxzLnBvaW50ZXIuc2V0Q29vcmREZWx0YXModGhpcy5jb29yZHMuZGVsdGEsIHRoaXMuY29vcmRzLnByZXYsIHRoaXMuY29vcmRzLmN1cilcblxuICAgIGlmIChkb3duKSB7XG4gICAgICB0aGlzLnBvaW50ZXJJc0Rvd24gPSB0cnVlXG5cbiAgICAgIHBvaW50ZXJJbmZvLmRvd25UaW1lID0gdGhpcy5jb29yZHMuY3VyLnRpbWVTdGFtcFxuICAgICAgcG9pbnRlckluZm8uZG93blRhcmdldCA9IGV2ZW50VGFyZ2V0XG4gICAgICB1dGlscy5wb2ludGVyLnBvaW50ZXJFeHRlbmQodGhpcy5kb3duUG9pbnRlciwgcG9pbnRlcilcblxuICAgICAgaWYgKCF0aGlzLmludGVyYWN0aW5nKCkpIHtcbiAgICAgICAgdXRpbHMucG9pbnRlci5jb3B5Q29vcmRzKHRoaXMuY29vcmRzLnN0YXJ0LCB0aGlzLmNvb3Jkcy5jdXIpXG4gICAgICAgIHV0aWxzLnBvaW50ZXIuY29weUNvb3Jkcyh0aGlzLmNvb3Jkcy5wcmV2LCB0aGlzLmNvb3Jkcy5jdXIpXG5cbiAgICAgICAgdGhpcy5kb3duRXZlbnQgPSBldmVudFxuICAgICAgICB0aGlzLnBvaW50ZXJXYXNNb3ZlZCA9IGZhbHNlXG4gICAgICB9XG4gICAgfVxuXG4gICAgdGhpcy5fdXBkYXRlTGF0ZXN0UG9pbnRlcihwb2ludGVyLCBldmVudCwgZXZlbnRUYXJnZXQpXG5cbiAgICB0aGlzLl9zY29wZUZpcmUoJ2ludGVyYWN0aW9uczp1cGRhdGUtcG9pbnRlcicsIHtcbiAgICAgIHBvaW50ZXIsXG4gICAgICBldmVudCxcbiAgICAgIGV2ZW50VGFyZ2V0LFxuICAgICAgZG93bixcbiAgICAgIHBvaW50ZXJJbmZvLFxuICAgICAgcG9pbnRlckluZGV4LFxuICAgICAgaW50ZXJhY3Rpb246IHRoaXMsXG4gICAgfSlcblxuICAgIHJldHVybiBwb2ludGVySW5kZXhcbiAgfVxuXG4gIHJlbW92ZVBvaW50ZXIgKHBvaW50ZXI6IEludGVyYWN0LlBvaW50ZXJUeXBlLCBldmVudDogSW50ZXJhY3QuUG9pbnRlckV2ZW50VHlwZSkge1xuICAgIGNvbnN0IHBvaW50ZXJJbmRleCA9IHRoaXMuZ2V0UG9pbnRlckluZGV4KHBvaW50ZXIpXG5cbiAgICBpZiAocG9pbnRlckluZGV4ID09PSAtMSkgeyByZXR1cm4gfVxuXG4gICAgY29uc3QgcG9pbnRlckluZm8gPSB0aGlzLnBvaW50ZXJzW3BvaW50ZXJJbmRleF1cblxuICAgIHRoaXMuX3Njb3BlRmlyZSgnaW50ZXJhY3Rpb25zOnJlbW92ZS1wb2ludGVyJywge1xuICAgICAgcG9pbnRlcixcbiAgICAgIGV2ZW50LFxuICAgICAgZXZlbnRUYXJnZXQ6IG51bGwsXG4gICAgICBwb2ludGVySW5kZXgsXG4gICAgICBwb2ludGVySW5mbyxcbiAgICAgIGludGVyYWN0aW9uOiB0aGlzLFxuICAgIH0pXG5cbiAgICB0aGlzLnBvaW50ZXJzLnNwbGljZShwb2ludGVySW5kZXgsIDEpXG4gIH1cblxuICBfdXBkYXRlTGF0ZXN0UG9pbnRlciAocG9pbnRlciwgZXZlbnQsIGV2ZW50VGFyZ2V0KSB7XG4gICAgdGhpcy5fbGF0ZXN0UG9pbnRlci5wb2ludGVyID0gcG9pbnRlclxuICAgIHRoaXMuX2xhdGVzdFBvaW50ZXIuZXZlbnQgPSBldmVudFxuICAgIHRoaXMuX2xhdGVzdFBvaW50ZXIuZXZlbnRUYXJnZXQgPSBldmVudFRhcmdldFxuICB9XG5cbiAgZGVzdHJveSAoKSB7XG4gICAgdGhpcy5fbGF0ZXN0UG9pbnRlci5wb2ludGVyID0gbnVsbFxuICAgIHRoaXMuX2xhdGVzdFBvaW50ZXIuZXZlbnQgPSBudWxsXG4gICAgdGhpcy5fbGF0ZXN0UG9pbnRlci5ldmVudFRhcmdldCA9IG51bGxcbiAgfVxuXG4gIF9jcmVhdGVQcmVwYXJlZEV2ZW50PFAgZXh0ZW5kcyBFdmVudFBoYXNlPiAoZXZlbnQ6IEludGVyYWN0LlBvaW50ZXJFdmVudFR5cGUsIHBoYXNlOiBQLCBwcmVFbmQ/OiBib29sZWFuLCB0eXBlPzogc3RyaW5nKSB7XG4gICAgcmV0dXJuIG5ldyBJbnRlcmFjdEV2ZW50PFQsIFA+KHRoaXMsIGV2ZW50LCB0aGlzLnByZXBhcmVkLm5hbWUsIHBoYXNlLCB0aGlzLmVsZW1lbnQsIHByZUVuZCwgdHlwZSlcbiAgfVxuXG4gIF9maXJlRXZlbnQ8UCBleHRlbmRzIEV2ZW50UGhhc2U+IChpRXZlbnQ6IEludGVyYWN0RXZlbnQ8VCwgUD4pIHtcbiAgICB0aGlzLmludGVyYWN0YWJsZS5maXJlKGlFdmVudClcblxuICAgIGlmICghdGhpcy5wcmV2RXZlbnQgfHwgaUV2ZW50LnRpbWVTdGFtcCA+PSB0aGlzLnByZXZFdmVudC50aW1lU3RhbXApIHtcbiAgICAgIHRoaXMucHJldkV2ZW50ID0gaUV2ZW50XG4gICAgfVxuICB9XG5cbiAgX2RvUGhhc2U8UCBleHRlbmRzIEV2ZW50UGhhc2U+IChzaWduYWxBcmc6IE9taXQ8RG9QaGFzZUFyZzxULCBQPiwgJ2lFdmVudCc+ICYgeyBpRXZlbnQ/OiBJbnRlcmFjdEV2ZW50PFQsIFA+IH0pIHtcbiAgICBjb25zdCB7IGV2ZW50LCBwaGFzZSwgcHJlRW5kLCB0eXBlIH0gPSBzaWduYWxBcmdcbiAgICBjb25zdCB7IHJlY3QgfSA9IHRoaXNcblxuICAgIGlmIChyZWN0ICYmIHBoYXNlID09PSAnbW92ZScpIHtcbiAgICAgIC8vIHVwZGF0ZSB0aGUgcmVjdCBjaGFuZ2VzIGR1ZSB0byBwb2ludGVyIG1vdmVcbiAgICAgIHV0aWxzLnJlY3QuYWRkRWRnZXModGhpcy5lZGdlcywgcmVjdCwgdGhpcy5jb29yZHMuZGVsdGFbdGhpcy5pbnRlcmFjdGFibGUub3B0aW9ucy5kZWx0YVNvdXJjZV0pXG5cbiAgICAgIHJlY3Qud2lkdGggPSByZWN0LnJpZ2h0IC0gcmVjdC5sZWZ0XG4gICAgICByZWN0LmhlaWdodCA9IHJlY3QuYm90dG9tIC0gcmVjdC50b3BcbiAgICB9XG5cbiAgICBjb25zdCBiZWZvcmVSZXN1bHQgPSB0aGlzLl9zY29wZUZpcmUoYGludGVyYWN0aW9uczpiZWZvcmUtYWN0aW9uLSR7cGhhc2V9YCBhcyBhbnksIHNpZ25hbEFyZylcblxuICAgIGlmIChiZWZvcmVSZXN1bHQgPT09IGZhbHNlKSB7XG4gICAgICByZXR1cm4gZmFsc2VcbiAgICB9XG5cbiAgICBjb25zdCBpRXZlbnQgPSBzaWduYWxBcmcuaUV2ZW50ID0gdGhpcy5fY3JlYXRlUHJlcGFyZWRFdmVudChldmVudCwgcGhhc2UsIHByZUVuZCwgdHlwZSlcblxuICAgIHRoaXMuX3Njb3BlRmlyZShgaW50ZXJhY3Rpb25zOmFjdGlvbi0ke3BoYXNlfWAgYXMgYW55LCBzaWduYWxBcmcpXG5cbiAgICBpZiAocGhhc2UgPT09ICdzdGFydCcpIHsgdGhpcy5wcmV2RXZlbnQgPSBpRXZlbnQgfVxuXG4gICAgdGhpcy5fZmlyZUV2ZW50KGlFdmVudClcblxuICAgIHRoaXMuX3Njb3BlRmlyZShgaW50ZXJhY3Rpb25zOmFmdGVyLWFjdGlvbi0ke3BoYXNlfWAgYXMgYW55LCBzaWduYWxBcmcpXG5cbiAgICByZXR1cm4gdHJ1ZVxuICB9XG5cbiAgX25vdyAoKSB7IHJldHVybiBEYXRlLm5vdygpIH1cbn1cblxuZXhwb3J0IGRlZmF1bHQgSW50ZXJhY3Rpb25cbmV4cG9ydCB7IFBvaW50ZXJJbmZvIH1cbiIsImltcG9ydCAqIGFzIGRvbSBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9kb21VdGlscydcblxuZXhwb3J0IGludGVyZmFjZSBTZWFyY2hEZXRhaWxzIHtcbiAgcG9pbnRlcjogSW50ZXJhY3QuUG9pbnRlclR5cGVcbiAgcG9pbnRlcklkOiBudW1iZXJcbiAgcG9pbnRlclR5cGU6IHN0cmluZ1xuICBldmVudFR5cGU6IHN0cmluZ1xuICBldmVudFRhcmdldDogSW50ZXJhY3QuRXZlbnRUYXJnZXRcbiAgY3VyRXZlbnRUYXJnZXQ6IEludGVyYWN0LkV2ZW50VGFyZ2V0XG4gIHNjb3BlOiBJbnRlcmFjdC5TY29wZVxufVxuXG5jb25zdCBmaW5kZXIgPSB7XG4gIG1ldGhvZE9yZGVyOiBbJ3NpbXVsYXRpb25SZXN1bWUnLCAnbW91c2VPclBlbicsICdoYXNQb2ludGVyJywgJ2lkbGUnXSBhcyBjb25zdCxcblxuICBzZWFyY2ggKGRldGFpbHM6IFNlYXJjaERldGFpbHMpIHtcbiAgICBmb3IgKGNvbnN0IG1ldGhvZCBvZiBmaW5kZXIubWV0aG9kT3JkZXIpIHtcbiAgICAgIGNvbnN0IGludGVyYWN0aW9uID0gZmluZGVyW21ldGhvZF0oZGV0YWlscylcblxuICAgICAgaWYgKGludGVyYWN0aW9uKSB7XG4gICAgICAgIHJldHVybiBpbnRlcmFjdGlvblxuICAgICAgfVxuICAgIH1cblxuICAgIHJldHVybiBudWxsXG4gIH0sXG5cbiAgLy8gdHJ5IHRvIHJlc3VtZSBzaW11bGF0aW9uIHdpdGggYSBuZXcgcG9pbnRlclxuICBzaW11bGF0aW9uUmVzdW1lICh7IHBvaW50ZXJUeXBlLCBldmVudFR5cGUsIGV2ZW50VGFyZ2V0LCBzY29wZSB9OiBTZWFyY2hEZXRhaWxzKSB7XG4gICAgaWYgKCEvZG93bnxzdGFydC9pLnRlc3QoZXZlbnRUeXBlKSkge1xuICAgICAgcmV0dXJuIG51bGxcbiAgICB9XG5cbiAgICBmb3IgKGNvbnN0IGludGVyYWN0aW9uIG9mIHNjb3BlLmludGVyYWN0aW9ucy5saXN0KSB7XG4gICAgICBsZXQgZWxlbWVudCA9IGV2ZW50VGFyZ2V0IGFzIE5vZGVcblxuICAgICAgaWYgKGludGVyYWN0aW9uLnNpbXVsYXRpb24gJiYgaW50ZXJhY3Rpb24uc2ltdWxhdGlvbi5hbGxvd1Jlc3VtZSAmJlxuICAgICAgICAgIChpbnRlcmFjdGlvbi5wb2ludGVyVHlwZSA9PT0gcG9pbnRlclR5cGUpKSB7XG4gICAgICAgIHdoaWxlIChlbGVtZW50KSB7XG4gICAgICAgICAgLy8gaWYgdGhlIGVsZW1lbnQgaXMgdGhlIGludGVyYWN0aW9uIGVsZW1lbnRcbiAgICAgICAgICBpZiAoZWxlbWVudCA9PT0gaW50ZXJhY3Rpb24uZWxlbWVudCkge1xuICAgICAgICAgICAgcmV0dXJuIGludGVyYWN0aW9uXG4gICAgICAgICAgfVxuICAgICAgICAgIGVsZW1lbnQgPSBkb20ucGFyZW50Tm9kZShlbGVtZW50KVxuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuXG4gICAgcmV0dXJuIG51bGxcbiAgfSxcblxuICAvLyBpZiBpdCdzIGEgbW91c2Ugb3IgcGVuIGludGVyYWN0aW9uXG4gIG1vdXNlT3JQZW4gKHsgcG9pbnRlcklkLCBwb2ludGVyVHlwZSwgZXZlbnRUeXBlLCBzY29wZSB9OiBTZWFyY2hEZXRhaWxzKSB7XG4gICAgaWYgKHBvaW50ZXJUeXBlICE9PSAnbW91c2UnICYmIHBvaW50ZXJUeXBlICE9PSAncGVuJykge1xuICAgICAgcmV0dXJuIG51bGxcbiAgICB9XG5cbiAgICBsZXQgZmlyc3ROb25BY3RpdmVcblxuICAgIGZvciAoY29uc3QgaW50ZXJhY3Rpb24gb2Ygc2NvcGUuaW50ZXJhY3Rpb25zLmxpc3QpIHtcbiAgICAgIGlmIChpbnRlcmFjdGlvbi5wb2ludGVyVHlwZSA9PT0gcG9pbnRlclR5cGUpIHtcbiAgICAgICAgLy8gaWYgaXQncyBhIGRvd24gZXZlbnQsIHNraXAgaW50ZXJhY3Rpb25zIHdpdGggcnVubmluZyBzaW11bGF0aW9uc1xuICAgICAgICBpZiAoaW50ZXJhY3Rpb24uc2ltdWxhdGlvbiAmJiAhaGFzUG9pbnRlcklkKGludGVyYWN0aW9uLCBwb2ludGVySWQpKSB7IGNvbnRpbnVlIH1cblxuICAgICAgICAvLyBpZiB0aGUgaW50ZXJhY3Rpb24gaXMgYWN0aXZlLCByZXR1cm4gaXQgaW1tZWRpYXRlbHlcbiAgICAgICAgaWYgKGludGVyYWN0aW9uLmludGVyYWN0aW5nKCkpIHtcbiAgICAgICAgICByZXR1cm4gaW50ZXJhY3Rpb25cbiAgICAgICAgfVxuICAgICAgICAvLyBvdGhlcndpc2Ugc2F2ZSBpdCBhbmQgbG9vayBmb3IgYW5vdGhlciBhY3RpdmUgaW50ZXJhY3Rpb25cbiAgICAgICAgZWxzZSBpZiAoIWZpcnN0Tm9uQWN0aXZlKSB7XG4gICAgICAgICAgZmlyc3ROb25BY3RpdmUgPSBpbnRlcmFjdGlvblxuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuXG4gICAgLy8gaWYgbm8gYWN0aXZlIG1vdXNlIGludGVyYWN0aW9uIHdhcyBmb3VuZCB1c2UgdGhlIGZpcnN0IGluYWN0aXZlIG1vdXNlXG4gICAgLy8gaW50ZXJhY3Rpb25cbiAgICBpZiAoZmlyc3ROb25BY3RpdmUpIHtcbiAgICAgIHJldHVybiBmaXJzdE5vbkFjdGl2ZVxuICAgIH1cblxuICAgIC8vIGZpbmQgYW55IG1vdXNlIG9yIHBlbiBpbnRlcmFjdGlvbi5cbiAgICAvLyBpZ25vcmUgdGhlIGludGVyYWN0aW9uIGlmIHRoZSBldmVudFR5cGUgaXMgYSAqZG93biwgYW5kIGEgc2ltdWxhdGlvblxuICAgIC8vIGlzIGFjdGl2ZVxuICAgIGZvciAoY29uc3QgaW50ZXJhY3Rpb24gb2Ygc2NvcGUuaW50ZXJhY3Rpb25zLmxpc3QpIHtcbiAgICAgIGlmIChpbnRlcmFjdGlvbi5wb2ludGVyVHlwZSA9PT0gcG9pbnRlclR5cGUgJiYgISgvZG93bi9pLnRlc3QoZXZlbnRUeXBlKSAmJiBpbnRlcmFjdGlvbi5zaW11bGF0aW9uKSkge1xuICAgICAgICByZXR1cm4gaW50ZXJhY3Rpb25cbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gbnVsbFxuICB9LFxuXG4gIC8vIGdldCBpbnRlcmFjdGlvbiB0aGF0IGhhcyB0aGlzIHBvaW50ZXJcbiAgaGFzUG9pbnRlciAoeyBwb2ludGVySWQsIHNjb3BlIH06IFNlYXJjaERldGFpbHMpIHtcbiAgICBmb3IgKGNvbnN0IGludGVyYWN0aW9uIG9mIHNjb3BlLmludGVyYWN0aW9ucy5saXN0KSB7XG4gICAgICBpZiAoaGFzUG9pbnRlcklkKGludGVyYWN0aW9uLCBwb2ludGVySWQpKSB7XG4gICAgICAgIHJldHVybiBpbnRlcmFjdGlvblxuICAgICAgfVxuICAgIH1cblxuICAgIHJldHVybiBudWxsXG4gIH0sXG5cbiAgLy8gZ2V0IGZpcnN0IGlkbGUgaW50ZXJhY3Rpb24gd2l0aCBhIG1hdGNoaW5nIHBvaW50ZXJUeXBlXG4gIGlkbGUgKHsgcG9pbnRlclR5cGUsIHNjb3BlIH06IFNlYXJjaERldGFpbHMpIHtcbiAgICBmb3IgKGNvbnN0IGludGVyYWN0aW9uIG9mIHNjb3BlLmludGVyYWN0aW9ucy5saXN0KSB7XG4gICAgICAvLyBpZiB0aGVyZSdzIGFscmVhZHkgYSBwb2ludGVyIGhlbGQgZG93blxuICAgICAgaWYgKGludGVyYWN0aW9uLnBvaW50ZXJzLmxlbmd0aCA9PT0gMSkge1xuICAgICAgICBjb25zdCB0YXJnZXQgPSBpbnRlcmFjdGlvbi5pbnRlcmFjdGFibGVcbiAgICAgICAgLy8gZG9uJ3QgYWRkIHRoaXMgcG9pbnRlciBpZiB0aGVyZSBpcyBhIHRhcmdldCBpbnRlcmFjdGFibGUgYW5kIGl0XG4gICAgICAgIC8vIGlzbid0IGdlc3R1cmFibGVcbiAgICAgICAgaWYgKHRhcmdldCAmJiAhKHRhcmdldC5vcHRpb25zLmdlc3R1cmUgJiYgdGFyZ2V0Lm9wdGlvbnMuZ2VzdHVyZS5lbmFibGVkKSkge1xuICAgICAgICAgIGNvbnRpbnVlXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICAgIC8vIG1heGltdW0gb2YgMiBwb2ludGVycyBwZXIgaW50ZXJhY3Rpb25cbiAgICAgIGVsc2UgaWYgKGludGVyYWN0aW9uLnBvaW50ZXJzLmxlbmd0aCA+PSAyKSB7XG4gICAgICAgIGNvbnRpbnVlXG4gICAgICB9XG5cbiAgICAgIGlmICghaW50ZXJhY3Rpb24uaW50ZXJhY3RpbmcoKSAmJiAocG9pbnRlclR5cGUgPT09IGludGVyYWN0aW9uLnBvaW50ZXJUeXBlKSkge1xuICAgICAgICByZXR1cm4gaW50ZXJhY3Rpb25cbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gbnVsbFxuICB9LFxufVxuXG5mdW5jdGlvbiBoYXNQb2ludGVySWQgKGludGVyYWN0aW9uOiBJbnRlcmFjdC5JbnRlcmFjdGlvbiwgcG9pbnRlcklkOiBudW1iZXIpIHtcbiAgcmV0dXJuIGludGVyYWN0aW9uLnBvaW50ZXJzLnNvbWUoKHsgaWQgfSkgPT4gaWQgPT09IHBvaW50ZXJJZClcbn1cblxuZXhwb3J0IGRlZmF1bHQgZmluZGVyXG4iLCJpbXBvcnQgeyBtYXRjaGVzU2VsZWN0b3IsIG5vZGVDb250YWlucyB9IGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2RvbVV0aWxzJ1xuaW1wb3J0IGV2ZW50cyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9ldmVudHMnXG5pbXBvcnQgKiBhcyBpcyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9pcydcbmltcG9ydCB7IGdldFdpbmRvdyB9IGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL3dpbmRvdydcblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3RhYmxlJyB7XG4gIGludGVyZmFjZSBJbnRlcmFjdGFibGUge1xuICAgIHByZXZlbnREZWZhdWx0OiB0eXBlb2YgcHJldmVudERlZmF1bHRcbiAgICBjaGVja0FuZFByZXZlbnREZWZhdWx0OiAoZXZlbnQ6IEV2ZW50KSA9PiB2b2lkXG4gIH1cbn1cblxudHlwZSBQcmV2ZW50RGVmYXVsdFZhbHVlID0gJ2Fsd2F5cycgfCAnbmV2ZXInIHwgJ2F1dG8nXG5mdW5jdGlvbiBwcmV2ZW50RGVmYXVsdCAodGhpczogSW50ZXJhY3QuSW50ZXJhY3RhYmxlKTogUHJldmVudERlZmF1bHRWYWx1ZVxuZnVuY3Rpb24gcHJldmVudERlZmF1bHQgKHRoaXM6IEludGVyYWN0LkludGVyYWN0YWJsZSwgbmV3VmFsdWU6IFByZXZlbnREZWZhdWx0VmFsdWUpOiB0eXBlb2YgdGhpc1xuZnVuY3Rpb24gcHJldmVudERlZmF1bHQgKHRoaXM6IEludGVyYWN0LkludGVyYWN0YWJsZSwgbmV3VmFsdWU/OiBQcmV2ZW50RGVmYXVsdFZhbHVlKSB7XG4gIGlmICgvXihhbHdheXN8bmV2ZXJ8YXV0bykkLy50ZXN0KG5ld1ZhbHVlKSkge1xuICAgIHRoaXMub3B0aW9ucy5wcmV2ZW50RGVmYXVsdCA9IG5ld1ZhbHVlXG4gICAgcmV0dXJuIHRoaXNcbiAgfVxuXG4gIGlmIChpcy5ib29sKG5ld1ZhbHVlKSkge1xuICAgIHRoaXMub3B0aW9ucy5wcmV2ZW50RGVmYXVsdCA9IG5ld1ZhbHVlID8gJ2Fsd2F5cycgOiAnbmV2ZXInXG4gICAgcmV0dXJuIHRoaXNcbiAgfVxuXG4gIHJldHVybiB0aGlzLm9wdGlvbnMucHJldmVudERlZmF1bHRcbn1cblxuZnVuY3Rpb24gY2hlY2tBbmRQcmV2ZW50RGVmYXVsdCAoaW50ZXJhY3RhYmxlOiBJbnRlcmFjdC5JbnRlcmFjdGFibGUsIHNjb3BlOiBJbnRlcmFjdC5TY29wZSwgZXZlbnQ6IEV2ZW50KSB7XG4gIGNvbnN0IHNldHRpbmcgPSBpbnRlcmFjdGFibGUub3B0aW9ucy5wcmV2ZW50RGVmYXVsdFxuXG4gIGlmIChzZXR0aW5nID09PSAnbmV2ZXInKSB7IHJldHVybiB9XG5cbiAgaWYgKHNldHRpbmcgPT09ICdhbHdheXMnKSB7XG4gICAgZXZlbnQucHJldmVudERlZmF1bHQoKVxuICAgIHJldHVyblxuICB9XG5cbiAgLy8gc2V0dGluZyA9PT0gJ2F1dG8nXG5cbiAgLy8gaWYgdGhlIGJyb3dzZXIgc3VwcG9ydHMgcGFzc2l2ZSBldmVudCBsaXN0ZW5lcnMgYW5kIGlzbid0IHJ1bm5pbmcgb24gaU9TLFxuICAvLyBkb24ndCBwcmV2ZW50RGVmYXVsdCBvZiB0b3VjaHtzdGFydCxtb3ZlfSBldmVudHMuIENTUyB0b3VjaC1hY3Rpb24gYW5kXG4gIC8vIHVzZXItc2VsZWN0IHNob3VsZCBiZSB1c2VkIGluc3RlYWQgb2YgY2FsbGluZyBldmVudC5wcmV2ZW50RGVmYXVsdCgpLlxuICBpZiAoZXZlbnRzLnN1cHBvcnRzUGFzc2l2ZSAmJiAvXnRvdWNoKHN0YXJ0fG1vdmUpJC8udGVzdChldmVudC50eXBlKSkge1xuICAgIGNvbnN0IGRvYyA9IGdldFdpbmRvdyhldmVudC50YXJnZXQpLmRvY3VtZW50XG4gICAgY29uc3QgZG9jT3B0aW9ucyA9IHNjb3BlLmdldERvY09wdGlvbnMoZG9jKVxuXG4gICAgaWYgKCEoZG9jT3B0aW9ucyAmJiBkb2NPcHRpb25zLmV2ZW50cykgfHwgZG9jT3B0aW9ucy5ldmVudHMucGFzc2l2ZSAhPT0gZmFsc2UpIHtcbiAgICAgIHJldHVyblxuICAgIH1cbiAgfVxuXG4gIC8vIGRvbid0IHByZXZlbnREZWZhdWx0IG9mIHBvaW50ZXJkb3duIGV2ZW50c1xuICBpZiAoL14obW91c2V8cG9pbnRlcnx0b3VjaCkqKGRvd258c3RhcnQpL2kudGVzdChldmVudC50eXBlKSkge1xuICAgIHJldHVyblxuICB9XG5cbiAgLy8gZG9uJ3QgcHJldmVudERlZmF1bHQgb24gZWRpdGFibGUgZWxlbWVudHNcbiAgaWYgKGlzLmVsZW1lbnQoZXZlbnQudGFyZ2V0KSAmJlxuICAgICAgbWF0Y2hlc1NlbGVjdG9yKGV2ZW50LnRhcmdldCwgJ2lucHV0LHNlbGVjdCx0ZXh0YXJlYSxbY29udGVudGVkaXRhYmxlPXRydWVdLFtjb250ZW50ZWRpdGFibGU9dHJ1ZV0gKicpKSB7XG4gICAgcmV0dXJuXG4gIH1cblxuICBldmVudC5wcmV2ZW50RGVmYXVsdCgpXG59XG5cbmZ1bmN0aW9uIG9uSW50ZXJhY3Rpb25FdmVudCAoeyBpbnRlcmFjdGlvbiwgZXZlbnQgfTogeyBpbnRlcmFjdGlvbjogSW50ZXJhY3QuSW50ZXJhY3Rpb24sIGV2ZW50OiBJbnRlcmFjdC5Qb2ludGVyRXZlbnRUeXBlIH0pIHtcbiAgaWYgKGludGVyYWN0aW9uLmludGVyYWN0YWJsZSkge1xuICAgIGludGVyYWN0aW9uLmludGVyYWN0YWJsZS5jaGVja0FuZFByZXZlbnREZWZhdWx0KGV2ZW50IGFzIEV2ZW50KVxuICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpbnN0YWxsIChzY29wZTogSW50ZXJhY3QuU2NvcGUpIHtcbiAgLyoqIEBsZW5kcyBJbnRlcmFjdGFibGUgKi9cbiAgY29uc3QgeyBJbnRlcmFjdGFibGUgfSA9IHNjb3BlXG5cbiAgLyoqXG4gICAqIFJldHVybnMgb3Igc2V0cyB3aGV0aGVyIHRvIHByZXZlbnQgdGhlIGJyb3dzZXIncyBkZWZhdWx0IGJlaGF2aW91ciBpblxuICAgKiByZXNwb25zZSB0byBwb2ludGVyIGV2ZW50cy4gQ2FuIGJlIHNldCB0bzpcbiAgICogIC0gYCdhbHdheXMnYCB0byBhbHdheXMgcHJldmVudFxuICAgKiAgLSBgJ25ldmVyJ2AgdG8gbmV2ZXIgcHJldmVudFxuICAgKiAgLSBgJ2F1dG8nYCB0byBsZXQgaW50ZXJhY3QuanMgdHJ5IHRvIGRldGVybWluZSB3aGF0IHdvdWxkIGJlIGJlc3RcbiAgICpcbiAgICogQHBhcmFtIHtzdHJpbmd9IFtuZXdWYWx1ZV0gYCdhbHdheXMnYCwgYCduZXZlcidgIG9yIGAnYXV0bydgXG4gICAqIEByZXR1cm4ge3N0cmluZyB8IEludGVyYWN0YWJsZX0gVGhlIGN1cnJlbnQgc2V0dGluZyBvciB0aGlzIEludGVyYWN0YWJsZVxuICAgKi9cbiAgSW50ZXJhY3RhYmxlLnByb3RvdHlwZS5wcmV2ZW50RGVmYXVsdCA9IHByZXZlbnREZWZhdWx0XG5cbiAgSW50ZXJhY3RhYmxlLnByb3RvdHlwZS5jaGVja0FuZFByZXZlbnREZWZhdWx0ID0gZnVuY3Rpb24gKGV2ZW50KSB7XG4gICAgcmV0dXJuIGNoZWNrQW5kUHJldmVudERlZmF1bHQodGhpcywgc2NvcGUsIGV2ZW50KVxuICB9XG5cbiAgLy8gcHJldmVudCBuYXRpdmUgSFRNTDUgZHJhZyBvbiBpbnRlcmFjdC5qcyB0YXJnZXQgZWxlbWVudHNcbiAgc2NvcGUuaW50ZXJhY3Rpb25zLmRvY0V2ZW50cy5wdXNoKHtcbiAgICB0eXBlOiAnZHJhZ3N0YXJ0JyxcbiAgICBsaXN0ZW5lciAoZXZlbnQpIHtcbiAgICAgIGZvciAoY29uc3QgaW50ZXJhY3Rpb24gb2Ygc2NvcGUuaW50ZXJhY3Rpb25zLmxpc3QpIHtcbiAgICAgICAgaWYgKGludGVyYWN0aW9uLmVsZW1lbnQgJiZcbiAgICAgICAgICAoaW50ZXJhY3Rpb24uZWxlbWVudCA9PT0gZXZlbnQudGFyZ2V0IHx8XG4gICAgICAgICAgIG5vZGVDb250YWlucyhpbnRlcmFjdGlvbi5lbGVtZW50LCBldmVudC50YXJnZXQpKSkge1xuICAgICAgICAgIGludGVyYWN0aW9uLmludGVyYWN0YWJsZS5jaGVja0FuZFByZXZlbnREZWZhdWx0KGV2ZW50KVxuICAgICAgICAgIHJldHVyblxuICAgICAgICB9XG4gICAgICB9XG4gICAgfSxcbiAgfSlcbn1cblxuZXhwb3J0IGRlZmF1bHQge1xuICBpZDogJ2NvcmUvaW50ZXJhY3RhYmxlUHJldmVudERlZmF1bHQnLFxuICBpbnN0YWxsLFxuICBsaXN0ZW5lcnM6IFsnZG93bicsICdtb3ZlJywgJ3VwJywgJ2NhbmNlbCddLnJlZHVjZSgoYWNjLCBldmVudFR5cGUpID0+IHtcbiAgICBhY2NbYGludGVyYWN0aW9uczoke2V2ZW50VHlwZX1gXSA9IG9uSW50ZXJhY3Rpb25FdmVudFxuICAgIHJldHVybiBhY2NcbiAgfSwge30gYXMgYW55KSxcbn1cbiIsImltcG9ydCBCYXNlRXZlbnQgZnJvbSAnQGludGVyYWN0anMvY29yZS9CYXNlRXZlbnQnXG5pbXBvcnQgSW50ZXJhY3RhYmxlIGZyb20gJ0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3RhYmxlJ1xuaW1wb3J0IEludGVyYWN0RXZlbnQgZnJvbSAnQGludGVyYWN0anMvY29yZS9JbnRlcmFjdEV2ZW50J1xuaW1wb3J0ICogYXMgYXJyIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2FycidcblxuY2xhc3MgRHJvcEV2ZW50IGV4dGVuZHMgQmFzZUV2ZW50IHtcbiAgdGFyZ2V0OiBJbnRlcmFjdC5FbGVtZW50XG4gIGRyb3B6b25lOiBJbnRlcmFjdGFibGVcbiAgZHJhZ0V2ZW50OiBJbnRlcmFjdEV2ZW50PCdkcmFnJz5cbiAgcmVsYXRlZFRhcmdldDogSW50ZXJhY3QuRWxlbWVudFxuICBkcmFnZ2FibGU6IEludGVyYWN0YWJsZVxuICB0aW1lU3RhbXA6IG51bWJlclxuICBwcm9wYWdhdGlvblN0b3BwZWQgPSBmYWxzZVxuICBpbW1lZGlhdGVQcm9wYWdhdGlvblN0b3BwZWQgPSBmYWxzZVxuXG4gIC8qKlxuICAgKiBDbGFzcyBvZiBldmVudHMgZmlyZWQgb24gZHJvcHpvbmVzIGR1cmluZyBkcmFncyB3aXRoIGFjY2VwdGFibGUgdGFyZ2V0cy5cbiAgICovXG4gIGNvbnN0cnVjdG9yIChkcm9wU3RhdGU6IGltcG9ydCgnLi8nKS5Ecm9wU3RhdGUsIGRyYWdFdmVudDogSW50ZXJhY3RFdmVudDwnZHJhZyc+LCB0eXBlOiBzdHJpbmcpIHtcbiAgICBzdXBlcihkcmFnRXZlbnQuX2ludGVyYWN0aW9uKVxuXG4gICAgY29uc3QgeyBlbGVtZW50LCBkcm9wem9uZSB9ID0gdHlwZSA9PT0gJ2RyYWdsZWF2ZSdcbiAgICAgID8gZHJvcFN0YXRlLnByZXZcbiAgICAgIDogZHJvcFN0YXRlLmN1clxuXG4gICAgdGhpcy50eXBlICAgICAgICAgID0gdHlwZVxuICAgIHRoaXMudGFyZ2V0ICAgICAgICA9IGVsZW1lbnRcbiAgICB0aGlzLmN1cnJlbnRUYXJnZXQgPSBlbGVtZW50XG4gICAgdGhpcy5kcm9wem9uZSAgICAgID0gZHJvcHpvbmVcbiAgICB0aGlzLmRyYWdFdmVudCAgICAgPSBkcmFnRXZlbnRcbiAgICB0aGlzLnJlbGF0ZWRUYXJnZXQgPSBkcmFnRXZlbnQudGFyZ2V0XG4gICAgdGhpcy5kcmFnZ2FibGUgICAgID0gZHJhZ0V2ZW50LmludGVyYWN0YWJsZVxuICAgIHRoaXMudGltZVN0YW1wICAgICA9IGRyYWdFdmVudC50aW1lU3RhbXBcbiAgfVxuXG4gIC8qKlxuICAgKiBJZiB0aGlzIGlzIGEgYGRyb3BhY3RpdmF0ZWAgZXZlbnQsIHRoZSBkcm9wem9uZSBlbGVtZW50IHdpbGwgYmVcbiAgICogZGVhY3RpdmF0ZWQuXG4gICAqXG4gICAqIElmIHRoaXMgaXMgYSBgZHJhZ21vdmVgIG9yIGBkcmFnZW50ZXJgLCBhIGBkcmFnbGVhdmVgIHdpbGwgYmUgZmlyZWQgb24gdGhlXG4gICAqIGRyb3B6b25lIGVsZW1lbnQgYW5kIG1vcmUuXG4gICAqL1xuICByZWplY3QgKCkge1xuICAgIGNvbnN0IHsgZHJvcFN0YXRlIH0gPSB0aGlzLl9pbnRlcmFjdGlvblxuXG4gICAgaWYgKFxuICAgICAgKHRoaXMudHlwZSAhPT0gJ2Ryb3BhY3RpdmF0ZScpICYmIChcbiAgICAgICAgIXRoaXMuZHJvcHpvbmUgfHxcbiAgICAgICAgZHJvcFN0YXRlLmN1ci5kcm9wem9uZSAhPT0gdGhpcy5kcm9wem9uZSB8fFxuICAgICAgICBkcm9wU3RhdGUuY3VyLmVsZW1lbnQgIT09IHRoaXMudGFyZ2V0KSkge1xuICAgICAgcmV0dXJuXG4gICAgfVxuXG4gICAgZHJvcFN0YXRlLnByZXYuZHJvcHpvbmUgPSB0aGlzLmRyb3B6b25lXG4gICAgZHJvcFN0YXRlLnByZXYuZWxlbWVudCA9IHRoaXMudGFyZ2V0XG5cbiAgICBkcm9wU3RhdGUucmVqZWN0ZWQgPSB0cnVlXG4gICAgZHJvcFN0YXRlLmV2ZW50cy5lbnRlciA9IG51bGxcblxuICAgIHRoaXMuc3RvcEltbWVkaWF0ZVByb3BhZ2F0aW9uKClcblxuICAgIGlmICh0aGlzLnR5cGUgPT09ICdkcm9wYWN0aXZhdGUnKSB7XG4gICAgICBjb25zdCBhY3RpdmVEcm9wcyA9IGRyb3BTdGF0ZS5hY3RpdmVEcm9wc1xuICAgICAgY29uc3QgaW5kZXggPSBhcnIuZmluZEluZGV4KGFjdGl2ZURyb3BzLCAoeyBkcm9wem9uZSwgZWxlbWVudCB9KSA9PlxuICAgICAgICBkcm9wem9uZSA9PT0gdGhpcy5kcm9wem9uZSAmJiBlbGVtZW50ID09PSB0aGlzLnRhcmdldClcblxuICAgICAgZHJvcFN0YXRlLmFjdGl2ZURyb3BzLnNwbGljZShpbmRleCwgMSlcblxuICAgICAgY29uc3QgZGVhY3RpdmF0ZUV2ZW50ID0gbmV3IERyb3BFdmVudChkcm9wU3RhdGUsIHRoaXMuZHJhZ0V2ZW50LCAnZHJvcGRlYWN0aXZhdGUnKVxuXG4gICAgICBkZWFjdGl2YXRlRXZlbnQuZHJvcHpvbmUgPSB0aGlzLmRyb3B6b25lXG4gICAgICBkZWFjdGl2YXRlRXZlbnQudGFyZ2V0ID0gdGhpcy50YXJnZXRcblxuICAgICAgdGhpcy5kcm9wem9uZS5maXJlKGRlYWN0aXZhdGVFdmVudClcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmRyb3B6b25lLmZpcmUobmV3IERyb3BFdmVudChkcm9wU3RhdGUsIHRoaXMuZHJhZ0V2ZW50LCAnZHJhZ2xlYXZlJykpXG4gICAgfVxuICB9XG5cbiAgcHJldmVudERlZmF1bHQgKCkge31cblxuICBzdG9wUHJvcGFnYXRpb24gKCkge1xuICAgIHRoaXMucHJvcGFnYXRpb25TdG9wcGVkID0gdHJ1ZVxuICB9XG5cbiAgc3RvcEltbWVkaWF0ZVByb3BhZ2F0aW9uICgpIHtcbiAgICB0aGlzLmltbWVkaWF0ZVByb3BhZ2F0aW9uU3RvcHBlZCA9IHRoaXMucHJvcGFnYXRpb25TdG9wcGVkID0gdHJ1ZVxuICB9XG59XG5cbmV4cG9ydCBkZWZhdWx0IERyb3BFdmVudFxuIiwiaW1wb3J0IEludGVyYWN0YWJsZSBmcm9tICdAaW50ZXJhY3Rqcy9jb3JlL0ludGVyYWN0YWJsZSdcbmltcG9ydCBJbnRlcmFjdEV2ZW50IGZyb20gJ0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3RFdmVudCdcbmltcG9ydCB7IFNjb3BlIH0gZnJvbSAnQGludGVyYWN0anMvY29yZS9zY29wZSdcbmltcG9ydCAqIGFzIHV0aWxzIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2luZGV4J1xuaW1wb3J0IGRyYWcgZnJvbSAnLi4vZHJhZydcbmltcG9ydCBEcm9wRXZlbnQgZnJvbSAnLi9Ecm9wRXZlbnQnXG5cbmV4cG9ydCBpbnRlcmZhY2UgRHJvcHpvbmVNZXRob2Qge1xuICAob3B0aW9uczogSW50ZXJhY3QuRHJvcHpvbmVPcHRpb25zIHwgYm9vbGVhbik6IEludGVyYWN0LkludGVyYWN0YWJsZVxuICAoKTogSW50ZXJhY3QuRHJvcHpvbmVPcHRpb25zXG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL0ludGVyYWN0YWJsZScge1xuICBpbnRlcmZhY2UgSW50ZXJhY3RhYmxlIHtcbiAgICBkcm9wem9uZTogRHJvcHpvbmVNZXRob2RcbiAgICBkcm9wQ2hlY2s6IChcbiAgICAgIGRyYWdFdmVudDogSW50ZXJhY3RFdmVudCxcbiAgICAgIGV2ZW50OiBJbnRlcmFjdC5Qb2ludGVyRXZlbnRUeXBlLFxuICAgICAgZHJhZ2dhYmxlOiBJbnRlcmFjdGFibGUsXG4gICAgICBkcmFnZ2FibGVFbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50LFxuICAgICAgZHJvcEVsZW1lbjogSW50ZXJhY3QuRWxlbWVudCxcbiAgICAgIHJlY3Q6IGFueVxuICAgICkgPT4gYm9vbGVhblxuICB9XG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL0ludGVyYWN0aW9uJyB7XG4gIGludGVyZmFjZSBJbnRlcmFjdGlvbiB7XG4gICAgZHJvcFN0YXRlPzogRHJvcFN0YXRlXG4gIH1cbn1cblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvZGVmYXVsdE9wdGlvbnMnIHtcbiAgaW50ZXJmYWNlIEFjdGlvbkRlZmF1bHRzIHtcbiAgICBkcm9wOiBJbnRlcmFjdC5Ecm9wem9uZU9wdGlvbnNcbiAgfVxufVxuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvY29yZS9zY29wZScge1xuICBpbnRlcmZhY2UgQWN0aW9uTWFwIHtcbiAgICBkcm9wPzogdHlwZW9mIGRyb3BcbiAgfVxuXG4gIGludGVyZmFjZSBTY29wZSB7XG4gICAgZHluYW1pY0Ryb3A/OiBib29sZWFuXG4gIH1cblxuICBpbnRlcmZhY2UgU2lnbmFsQXJncyB7XG4gICAgJ2FjdGlvbnMvZHJvcDpzdGFydCc6IERyb3BTaWduYWxBcmdcbiAgICAnYWN0aW9ucy9kcm9wOm1vdmUnOiBEcm9wU2lnbmFsQXJnXG4gICAgJ2FjdGlvbnMvZHJvcDplbmQnOiBEcm9wU2lnbmFsQXJnXG4gIH1cbn1cblxuaW50ZXJmYWNlIERyb3BTaWduYWxBcmcge1xuICBpbnRlcmFjdGlvbjogSW50ZXJhY3QuSW50ZXJhY3Rpb25cbiAgZHJhZ0V2ZW50OiBJbnRlcmFjdC5EcmFnRXZlbnRcbn1cblxuZXhwb3J0IGludGVyZmFjZSBEcm9wU3RhdGUge1xuICBjdXI6IHtcbiAgICBkcm9wem9uZTogSW50ZXJhY3RhYmxlICAgIC8vIHRoZSBkcm9wem9uZSBhIGRyYWcgdGFyZ2V0IG1pZ2h0IGJlIGRyb3BwZWQgaW50b1xuICAgIGVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnQgLy8gdGhlIGVsZW1lbnQgYXQgdGhlIHRpbWUgb2YgY2hlY2tpbmdcbiAgfVxuICBwcmV2OiB7XG4gICAgZHJvcHpvbmU6IEludGVyYWN0YWJsZSAgICAvLyB0aGUgZHJvcHpvbmUgdGhhdCB3YXMgcmVjZW50bHkgZHJhZ2dlZCBhd2F5IGZyb21cbiAgICBlbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50IC8vIHRoZSBlbGVtZW50IGF0IHRoZSB0aW1lIG9mIGNoZWNraW5nXG4gIH1cbiAgcmVqZWN0ZWQ6IGJvb2xlYW4gICAgICAgICAgIC8vIHdoZWF0aGVyIHRoZSBwb3RlbnRpYWwgZHJvcCB3YXMgcmVqZWN0ZWQgZnJvbSBhIGxpc3RlbmVyXG4gIGV2ZW50czogYW55ICAgICAgICAgICAgICAgICAvLyB0aGUgZHJvcCBldmVudHMgcmVsYXRlZCB0byB0aGUgY3VycmVudCBkcmFnIGV2ZW50XG4gIGFjdGl2ZURyb3BzOiBBcnJheTx7XG4gICAgZHJvcHpvbmU6IEludGVyYWN0YWJsZVxuICAgIGVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnRcbiAgICByZWN0OiBJbnRlcmFjdC5SZWN0XG4gIH0+XG59XG5cbmZ1bmN0aW9uIGluc3RhbGwgKHNjb3BlOiBTY29wZSkge1xuICBjb25zdCB7XG4gICAgYWN0aW9ucyxcbiAgICAvKiogQGxlbmRzIG1vZHVsZTppbnRlcmFjdCAqL1xuICAgIGludGVyYWN0LFxuICAgIC8qKiBAbGVuZHMgSW50ZXJhY3RhYmxlICovXG4gICAgSW50ZXJhY3RhYmxlLCAvLyBlc2xpbnQtZGlzYWJsZS1saW5lIG5vLXNoYWRvd1xuICAgIGRlZmF1bHRzLFxuICB9ID0gc2NvcGVcblxuICBzY29wZS51c2VQbHVnaW4oZHJhZylcblxuICAvKipcbiAgICpcbiAgICogYGBganNcbiAgICogaW50ZXJhY3QoJy5kcm9wJykuZHJvcHpvbmUoe1xuICAgKiAgIGFjY2VwdDogJy5jYW4tZHJvcCcgfHwgZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoJ3NpbmdsZS1kcm9wJyksXG4gICAqICAgb3ZlcmxhcDogJ3BvaW50ZXInIHx8ICdjZW50ZXInIHx8IHplcm9Ub09uZVxuICAgKiB9XG4gICAqIGBgYFxuICAgKlxuICAgKiBSZXR1cm5zIG9yIHNldHMgd2hldGhlciBkcmFnZ2FibGVzIGNhbiBiZSBkcm9wcGVkIG9udG8gdGhpcyB0YXJnZXQgdG9cbiAgICogdHJpZ2dlciBkcm9wIGV2ZW50c1xuICAgKlxuICAgKiBEcm9wem9uZXMgY2FuIHJlY2VpdmUgdGhlIGZvbGxvd2luZyBldmVudHM6XG4gICAqICAtIGBkcm9wYWN0aXZhdGVgIGFuZCBgZHJvcGRlYWN0aXZhdGVgIHdoZW4gYW4gYWNjZXB0YWJsZSBkcmFnIHN0YXJ0cyBhbmQgZW5kc1xuICAgKiAgLSBgZHJhZ2VudGVyYCBhbmQgYGRyYWdsZWF2ZWAgd2hlbiBhIGRyYWdnYWJsZSBlbnRlcnMgYW5kIGxlYXZlcyB0aGUgZHJvcHpvbmVcbiAgICogIC0gYGRyYWdtb3ZlYCB3aGVuIGEgZHJhZ2dhYmxlIHRoYXQgaGFzIGVudGVyZWQgdGhlIGRyb3B6b25lIGlzIG1vdmVkXG4gICAqICAtIGBkcm9wYCB3aGVuIGEgZHJhZ2dhYmxlIGlzIGRyb3BwZWQgaW50byB0aGlzIGRyb3B6b25lXG4gICAqXG4gICAqIFVzZSB0aGUgYGFjY2VwdGAgb3B0aW9uIHRvIGFsbG93IG9ubHkgZWxlbWVudHMgdGhhdCBtYXRjaCB0aGUgZ2l2ZW4gQ1NTXG4gICAqIHNlbGVjdG9yIG9yIGVsZW1lbnQuIFRoZSB2YWx1ZSBjYW4gYmU6XG4gICAqXG4gICAqICAtICoqYW4gRWxlbWVudCoqIC0gb25seSB0aGF0IGVsZW1lbnQgY2FuIGJlIGRyb3BwZWQgaW50byB0aGlzIGRyb3B6b25lLlxuICAgKiAgLSAqKmEgc3RyaW5nKiosIC0gdGhlIGVsZW1lbnQgYmVpbmcgZHJhZ2dlZCBtdXN0IG1hdGNoIGl0IGFzIGEgQ1NTIHNlbGVjdG9yLlxuICAgKiAgLSAqKmBudWxsYCoqIC0gYWNjZXB0IG9wdGlvbnMgaXMgY2xlYXJlZCAtIGl0IGFjY2VwdHMgYW55IGVsZW1lbnQuXG4gICAqXG4gICAqIFVzZSB0aGUgYG92ZXJsYXBgIG9wdGlvbiB0byBzZXQgaG93IGRyb3BzIGFyZSBjaGVja2VkIGZvci4gVGhlIGFsbG93ZWRcbiAgICogdmFsdWVzIGFyZTpcbiAgICpcbiAgICogICAtIGAncG9pbnRlcidgLCB0aGUgcG9pbnRlciBtdXN0IGJlIG92ZXIgdGhlIGRyb3B6b25lIChkZWZhdWx0KVxuICAgKiAgIC0gYCdjZW50ZXInYCwgdGhlIGRyYWdnYWJsZSBlbGVtZW50J3MgY2VudGVyIG11c3QgYmUgb3ZlciB0aGUgZHJvcHpvbmVcbiAgICogICAtIGEgbnVtYmVyIGZyb20gMC0xIHdoaWNoIGlzIHRoZSBgKGludGVyc2VjdGlvbiBhcmVhKSAvIChkcmFnZ2FibGUgYXJlYSlgLlxuICAgKiAgIGUuZy4gYDAuNWAgZm9yIGRyb3AgdG8gaGFwcGVuIHdoZW4gaGFsZiBvZiB0aGUgYXJlYSBvZiB0aGUgZHJhZ2dhYmxlIGlzXG4gICAqICAgb3ZlciB0aGUgZHJvcHpvbmVcbiAgICpcbiAgICogVXNlIHRoZSBgY2hlY2tlcmAgb3B0aW9uIHRvIHNwZWNpZnkgYSBmdW5jdGlvbiB0byBjaGVjayBpZiBhIGRyYWdnZWQgZWxlbWVudFxuICAgKiBpcyBvdmVyIHRoaXMgSW50ZXJhY3RhYmxlLlxuICAgKlxuICAgKiBAcGFyYW0ge2Jvb2xlYW4gfCBvYmplY3QgfCBudWxsfSBbb3B0aW9uc10gVGhlIG5ldyBvcHRpb25zIHRvIGJlIHNldC5cbiAgICogQHJldHVybiB7Ym9vbGVhbiB8IEludGVyYWN0YWJsZX0gVGhlIGN1cnJlbnQgc2V0dGluZyBvciB0aGlzIEludGVyYWN0YWJsZVxuICAgKi9cbiAgSW50ZXJhY3RhYmxlLnByb3RvdHlwZS5kcm9wem9uZSA9IGZ1bmN0aW9uICh0aGlzOiBJbnRlcmFjdC5JbnRlcmFjdGFibGUsIG9wdGlvbnM/OiBJbnRlcmFjdC5Ecm9wem9uZU9wdGlvbnMgfCBib29sZWFuKSB7XG4gICAgcmV0dXJuIGRyb3B6b25lTWV0aG9kKHRoaXMsIG9wdGlvbnMpXG4gIH1cblxuICAvKipcbiAgICogYGBganNcbiAgICogaW50ZXJhY3QodGFyZ2V0KVxuICAgKiAuZHJvcENoZWNrZXIoZnVuY3Rpb24oZHJhZ0V2ZW50LCAgICAgICAgIC8vIHJlbGF0ZWQgZHJhZ21vdmUgb3IgZHJhZ2VuZCBldmVudFxuICAgKiAgICAgICAgICAgICAgICAgICAgICAgZXZlbnQsICAgICAgICAgICAgIC8vIFRvdWNoRXZlbnQvUG9pbnRlckV2ZW50L01vdXNlRXZlbnRcbiAgICogICAgICAgICAgICAgICAgICAgICAgIGRyb3BwZWQsICAgICAgICAgICAvLyBib29sIHJlc3VsdCBvZiB0aGUgZGVmYXVsdCBjaGVja2VyXG4gICAqICAgICAgICAgICAgICAgICAgICAgICBkcm9wem9uZSwgICAgICAgICAgLy8gZHJvcHpvbmUgSW50ZXJhY3RhYmxlXG4gICAqICAgICAgICAgICAgICAgICAgICAgICBkcm9wRWxlbWVudCwgICAgICAgLy8gZHJvcHpvbmUgZWxlbW50XG4gICAqICAgICAgICAgICAgICAgICAgICAgICBkcmFnZ2FibGUsICAgICAgICAgLy8gZHJhZ2dhYmxlIEludGVyYWN0YWJsZVxuICAgKiAgICAgICAgICAgICAgICAgICAgICAgZHJhZ2dhYmxlRWxlbWVudCkgey8vIGRyYWdnYWJsZSBlbGVtZW50XG4gICAqXG4gICAqICAgcmV0dXJuIGRyb3BwZWQgJiYgZXZlbnQudGFyZ2V0Lmhhc0F0dHJpYnV0ZSgnYWxsb3ctZHJvcCcpXG4gICAqIH1cbiAgICogYGBgXG4gICAqL1xuICBJbnRlcmFjdGFibGUucHJvdG90eXBlLmRyb3BDaGVjayA9IGZ1bmN0aW9uICh0aGlzOiBJbnRlcmFjdC5JbnRlcmFjdGFibGUsIGRyYWdFdmVudCwgZXZlbnQsIGRyYWdnYWJsZSwgZHJhZ2dhYmxlRWxlbWVudCwgZHJvcEVsZW1lbnQsIHJlY3QpIHtcbiAgICByZXR1cm4gZHJvcENoZWNrTWV0aG9kKHRoaXMsIGRyYWdFdmVudCwgZXZlbnQsIGRyYWdnYWJsZSwgZHJhZ2dhYmxlRWxlbWVudCwgZHJvcEVsZW1lbnQsIHJlY3QpXG4gIH1cblxuICAvKipcbiAgICogUmV0dXJucyBvciBzZXRzIHdoZXRoZXIgdGhlIGRpbWVuc2lvbnMgb2YgZHJvcHpvbmUgZWxlbWVudHMgYXJlIGNhbGN1bGF0ZWRcbiAgICogb24gZXZlcnkgZHJhZ21vdmUgb3Igb25seSBvbiBkcmFnc3RhcnQgZm9yIHRoZSBkZWZhdWx0IGRyb3BDaGVja2VyXG4gICAqXG4gICAqIEBwYXJhbSB7Ym9vbGVhbn0gW25ld1ZhbHVlXSBUcnVlIHRvIGNoZWNrIG9uIGVhY2ggbW92ZS4gRmFsc2UgdG8gY2hlY2sgb25seVxuICAgKiBiZWZvcmUgc3RhcnRcbiAgICogQHJldHVybiB7Ym9vbGVhbiB8IGludGVyYWN0fSBUaGUgY3VycmVudCBzZXR0aW5nIG9yIGludGVyYWN0XG4gICAqL1xuICBpbnRlcmFjdC5keW5hbWljRHJvcCA9IGZ1bmN0aW9uIChuZXdWYWx1ZT86IGJvb2xlYW4pIHtcbiAgICBpZiAodXRpbHMuaXMuYm9vbChuZXdWYWx1ZSkpIHtcbiAgICAgIC8vIGlmIChkcmFnZ2luZyAmJiBzY29wZS5keW5hbWljRHJvcCAhPT0gbmV3VmFsdWUgJiYgIW5ld1ZhbHVlKSB7XG4gICAgICAvLyAgY2FsY1JlY3RzKGRyb3B6b25lcylcbiAgICAgIC8vIH1cblxuICAgICAgc2NvcGUuZHluYW1pY0Ryb3AgPSBuZXdWYWx1ZVxuXG4gICAgICByZXR1cm4gaW50ZXJhY3RcbiAgICB9XG4gICAgcmV0dXJuIHNjb3BlLmR5bmFtaWNEcm9wXG4gIH1cblxuICB1dGlscy5leHRlbmQoYWN0aW9ucy5waGFzZWxlc3NUeXBlcywge1xuICAgIGRyYWdlbnRlcjogdHJ1ZSxcbiAgICBkcmFnbGVhdmU6IHRydWUsXG4gICAgZHJvcGFjdGl2YXRlOiB0cnVlLFxuICAgIGRyb3BkZWFjdGl2YXRlOiB0cnVlLFxuICAgIGRyb3Btb3ZlOiB0cnVlLFxuICAgIGRyb3A6IHRydWUsXG4gIH0pXG4gIGFjdGlvbnMubWV0aG9kRGljdC5kcm9wID0gJ2Ryb3B6b25lJ1xuXG4gIHNjb3BlLmR5bmFtaWNEcm9wID0gZmFsc2VcblxuICBkZWZhdWx0cy5hY3Rpb25zLmRyb3AgPSBkcm9wLmRlZmF1bHRzXG59XG5cbmZ1bmN0aW9uIGNvbGxlY3REcm9wcyAoeyBpbnRlcmFjdGFibGVzIH0sIGRyYWdnYWJsZUVsZW1lbnQpIHtcbiAgY29uc3QgZHJvcHMgPSBbXVxuXG4gIC8vIGNvbGxlY3QgYWxsIGRyb3B6b25lcyBhbmQgdGhlaXIgZWxlbWVudHMgd2hpY2ggcXVhbGlmeSBmb3IgYSBkcm9wXG4gIGZvciAoY29uc3QgZHJvcHpvbmUgb2YgaW50ZXJhY3RhYmxlcy5saXN0KSB7XG4gICAgaWYgKCFkcm9wem9uZS5vcHRpb25zLmRyb3AuZW5hYmxlZCkgeyBjb250aW51ZSB9XG5cbiAgICBjb25zdCBhY2NlcHQgPSBkcm9wem9uZS5vcHRpb25zLmRyb3AuYWNjZXB0XG5cbiAgICAvLyB0ZXN0IHRoZSBkcmFnZ2FibGUgZHJhZ2dhYmxlRWxlbWVudCBhZ2FpbnN0IHRoZSBkcm9wem9uZSdzIGFjY2VwdCBzZXR0aW5nXG4gICAgaWYgKCh1dGlscy5pcy5lbGVtZW50KGFjY2VwdCkgJiYgYWNjZXB0ICE9PSBkcmFnZ2FibGVFbGVtZW50KSB8fFxuICAgICAgICAodXRpbHMuaXMuc3RyaW5nKGFjY2VwdCkgJiZcbiAgICAgICAgIXV0aWxzLmRvbS5tYXRjaGVzU2VsZWN0b3IoZHJhZ2dhYmxlRWxlbWVudCwgYWNjZXB0KSkgfHxcbiAgICAgICAgKHV0aWxzLmlzLmZ1bmMoYWNjZXB0KSAmJiAhYWNjZXB0KHsgZHJvcHpvbmUsIGRyYWdnYWJsZUVsZW1lbnQgfSkpKSB7XG4gICAgICBjb250aW51ZVxuICAgIH1cblxuICAgIC8vIHF1ZXJ5IGZvciBuZXcgZWxlbWVudHMgaWYgbmVjZXNzYXJ5XG4gICAgY29uc3QgZHJvcEVsZW1lbnRzID0gdXRpbHMuaXMuc3RyaW5nKGRyb3B6b25lLnRhcmdldClcbiAgICAgID8gZHJvcHpvbmUuX2NvbnRleHQucXVlcnlTZWxlY3RvckFsbChkcm9wem9uZS50YXJnZXQpXG4gICAgICA6IHV0aWxzLmlzLmFycmF5KGRyb3B6b25lLnRhcmdldCkgPyBkcm9wem9uZS50YXJnZXQgOiBbZHJvcHpvbmUudGFyZ2V0XVxuXG4gICAgZm9yIChjb25zdCBkcm9wem9uZUVsZW1lbnQgb2YgZHJvcEVsZW1lbnRzKSB7XG4gICAgICBpZiAoZHJvcHpvbmVFbGVtZW50ICE9PSBkcmFnZ2FibGVFbGVtZW50KSB7XG4gICAgICAgIGRyb3BzLnB1c2goe1xuICAgICAgICAgIGRyb3B6b25lLFxuICAgICAgICAgIGVsZW1lbnQ6IGRyb3B6b25lRWxlbWVudCxcbiAgICAgICAgfSlcbiAgICAgIH1cbiAgICB9XG4gIH1cblxuICByZXR1cm4gZHJvcHNcbn1cblxuZnVuY3Rpb24gZmlyZUFjdGl2YXRpb25FdmVudHMgKGFjdGl2ZURyb3BzLCBldmVudCkge1xuICAvLyBsb29wIHRocm91Z2ggYWxsIGFjdGl2ZSBkcm9wem9uZXMgYW5kIHRyaWdnZXIgZXZlbnRcbiAgZm9yIChjb25zdCB7IGRyb3B6b25lLCBlbGVtZW50IH0gb2YgYWN0aXZlRHJvcHMuc2xpY2UoKSkge1xuICAgIGV2ZW50LmRyb3B6b25lID0gZHJvcHpvbmVcblxuICAgIC8vIHNldCBjdXJyZW50IGVsZW1lbnQgYXMgZXZlbnQgdGFyZ2V0XG4gICAgZXZlbnQudGFyZ2V0ID0gZWxlbWVudFxuICAgIGRyb3B6b25lLmZpcmUoZXZlbnQpXG4gICAgZXZlbnQucHJvcGFnYXRpb25TdG9wcGVkID0gZXZlbnQuaW1tZWRpYXRlUHJvcGFnYXRpb25TdG9wcGVkID0gZmFsc2VcbiAgfVxufVxuXG4vLyByZXR1cm4gYSBuZXcgYXJyYXkgb2YgcG9zc2libGUgZHJvcHMuIGdldEFjdGl2ZURyb3BzIHNob3VsZCBhbHdheXMgYmVcbi8vIGNhbGxlZCB3aGVuIGEgZHJhZyBoYXMganVzdCBzdGFydGVkIG9yIGEgZHJhZyBldmVudCBoYXBwZW5zIHdoaWxlXG4vLyBkeW5hbWljRHJvcCBpcyB0cnVlXG5mdW5jdGlvbiBnZXRBY3RpdmVEcm9wcyAoc2NvcGU6IFNjb3BlLCBkcmFnRWxlbWVudDogSW50ZXJhY3QuRWxlbWVudCkge1xuICAvLyBnZXQgZHJvcHpvbmVzIGFuZCB0aGVpciBlbGVtZW50cyB0aGF0IGNvdWxkIHJlY2VpdmUgdGhlIGRyYWdnYWJsZVxuICBjb25zdCBhY3RpdmVEcm9wcyA9IGNvbGxlY3REcm9wcyhzY29wZSwgZHJhZ0VsZW1lbnQpXG5cbiAgZm9yIChjb25zdCBhY3RpdmVEcm9wIG9mIGFjdGl2ZURyb3BzKSB7XG4gICAgYWN0aXZlRHJvcC5yZWN0ID0gYWN0aXZlRHJvcC5kcm9wem9uZS5nZXRSZWN0KGFjdGl2ZURyb3AuZWxlbWVudClcbiAgfVxuXG4gIHJldHVybiBhY3RpdmVEcm9wc1xufVxuXG5mdW5jdGlvbiBnZXREcm9wICh7IGRyb3BTdGF0ZSwgaW50ZXJhY3RhYmxlOiBkcmFnZ2FibGUsIGVsZW1lbnQ6IGRyYWdFbGVtZW50IH06IFBhcnRpYWw8SW50ZXJhY3QuSW50ZXJhY3Rpb24+LCBkcmFnRXZlbnQsIHBvaW50ZXJFdmVudCkge1xuICBjb25zdCB2YWxpZERyb3BzID0gW11cblxuICAvLyBjb2xsZWN0IGFsbCBkcm9wem9uZXMgYW5kIHRoZWlyIGVsZW1lbnRzIHdoaWNoIHF1YWxpZnkgZm9yIGEgZHJvcFxuICBmb3IgKGNvbnN0IHsgZHJvcHpvbmUsIGVsZW1lbnQ6IGRyb3B6b25lRWxlbWVudCwgcmVjdCB9IG9mIGRyb3BTdGF0ZS5hY3RpdmVEcm9wcykge1xuICAgIHZhbGlkRHJvcHMucHVzaChkcm9wem9uZS5kcm9wQ2hlY2soZHJhZ0V2ZW50LCBwb2ludGVyRXZlbnQsIGRyYWdnYWJsZSwgZHJhZ0VsZW1lbnQsIGRyb3B6b25lRWxlbWVudCwgcmVjdClcbiAgICAgID8gZHJvcHpvbmVFbGVtZW50XG4gICAgICA6IG51bGwpXG4gIH1cblxuICAvLyBnZXQgdGhlIG1vc3QgYXBwcm9wcmlhdGUgZHJvcHpvbmUgYmFzZWQgb24gRE9NIGRlcHRoIGFuZCBvcmRlclxuICBjb25zdCBkcm9wSW5kZXggPSB1dGlscy5kb20uaW5kZXhPZkRlZXBlc3RFbGVtZW50KHZhbGlkRHJvcHMpXG5cbiAgcmV0dXJuIGRyb3BTdGF0ZS5hY3RpdmVEcm9wc1tkcm9wSW5kZXhdIHx8IG51bGxcbn1cblxuZnVuY3Rpb24gZ2V0RHJvcEV2ZW50cyAoaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uLCBfcG9pbnRlckV2ZW50LCBkcmFnRXZlbnQpIHtcbiAgY29uc3QgeyBkcm9wU3RhdGUgfSA9IGludGVyYWN0aW9uXG4gIGNvbnN0IGRyb3BFdmVudHMgPSB7XG4gICAgZW50ZXIgICAgIDogbnVsbCxcbiAgICBsZWF2ZSAgICAgOiBudWxsLFxuICAgIGFjdGl2YXRlICA6IG51bGwsXG4gICAgZGVhY3RpdmF0ZTogbnVsbCxcbiAgICBtb3ZlICAgICAgOiBudWxsLFxuICAgIGRyb3AgICAgICA6IG51bGwsXG4gIH1cblxuICBpZiAoZHJhZ0V2ZW50LnR5cGUgPT09ICdkcmFnc3RhcnQnKSB7XG4gICAgZHJvcEV2ZW50cy5hY3RpdmF0ZSA9IG5ldyBEcm9wRXZlbnQoZHJvcFN0YXRlLCBkcmFnRXZlbnQsICdkcm9wYWN0aXZhdGUnKVxuXG4gICAgZHJvcEV2ZW50cy5hY3RpdmF0ZS50YXJnZXQgICA9IG51bGxcbiAgICBkcm9wRXZlbnRzLmFjdGl2YXRlLmRyb3B6b25lID0gbnVsbFxuICB9XG4gIGlmIChkcmFnRXZlbnQudHlwZSA9PT0gJ2RyYWdlbmQnKSB7XG4gICAgZHJvcEV2ZW50cy5kZWFjdGl2YXRlID0gbmV3IERyb3BFdmVudChkcm9wU3RhdGUsIGRyYWdFdmVudCwgJ2Ryb3BkZWFjdGl2YXRlJylcblxuICAgIGRyb3BFdmVudHMuZGVhY3RpdmF0ZS50YXJnZXQgICA9IG51bGxcbiAgICBkcm9wRXZlbnRzLmRlYWN0aXZhdGUuZHJvcHpvbmUgPSBudWxsXG4gIH1cblxuICBpZiAoZHJvcFN0YXRlLnJlamVjdGVkKSB7XG4gICAgcmV0dXJuIGRyb3BFdmVudHNcbiAgfVxuXG4gIGlmIChkcm9wU3RhdGUuY3VyLmVsZW1lbnQgIT09IGRyb3BTdGF0ZS5wcmV2LmVsZW1lbnQpIHtcbiAgICAvLyBpZiB0aGVyZSB3YXMgYSBwcmV2aW91cyBkcm9wem9uZSwgY3JlYXRlIGEgZHJhZ2xlYXZlIGV2ZW50XG4gICAgaWYgKGRyb3BTdGF0ZS5wcmV2LmRyb3B6b25lKSB7XG4gICAgICBkcm9wRXZlbnRzLmxlYXZlID0gbmV3IERyb3BFdmVudChkcm9wU3RhdGUsIGRyYWdFdmVudCwgJ2RyYWdsZWF2ZScpXG5cbiAgICAgIGRyYWdFdmVudC5kcmFnTGVhdmUgICAgPSBkcm9wRXZlbnRzLmxlYXZlLnRhcmdldCAgID0gZHJvcFN0YXRlLnByZXYuZWxlbWVudFxuICAgICAgZHJhZ0V2ZW50LnByZXZEcm9wem9uZSA9IGRyb3BFdmVudHMubGVhdmUuZHJvcHpvbmUgPSBkcm9wU3RhdGUucHJldi5kcm9wem9uZVxuICAgIH1cbiAgICAvLyBpZiBkcm9wem9uZSBpcyBub3QgbnVsbCwgY3JlYXRlIGEgZHJhZ2VudGVyIGV2ZW50XG4gICAgaWYgKGRyb3BTdGF0ZS5jdXIuZHJvcHpvbmUpIHtcbiAgICAgIGRyb3BFdmVudHMuZW50ZXIgPSBuZXcgRHJvcEV2ZW50KGRyb3BTdGF0ZSwgZHJhZ0V2ZW50LCAnZHJhZ2VudGVyJylcblxuICAgICAgZHJhZ0V2ZW50LmRyYWdFbnRlciA9IGRyb3BTdGF0ZS5jdXIuZWxlbWVudFxuICAgICAgZHJhZ0V2ZW50LmRyb3B6b25lID0gZHJvcFN0YXRlLmN1ci5kcm9wem9uZVxuICAgIH1cbiAgfVxuXG4gIGlmIChkcmFnRXZlbnQudHlwZSA9PT0gJ2RyYWdlbmQnICYmIGRyb3BTdGF0ZS5jdXIuZHJvcHpvbmUpIHtcbiAgICBkcm9wRXZlbnRzLmRyb3AgPSBuZXcgRHJvcEV2ZW50KGRyb3BTdGF0ZSwgZHJhZ0V2ZW50LCAnZHJvcCcpXG5cbiAgICBkcmFnRXZlbnQuZHJvcHpvbmUgPSBkcm9wU3RhdGUuY3VyLmRyb3B6b25lXG4gICAgZHJhZ0V2ZW50LnJlbGF0ZWRUYXJnZXQgPSBkcm9wU3RhdGUuY3VyLmVsZW1lbnRcbiAgfVxuICBpZiAoZHJhZ0V2ZW50LnR5cGUgPT09ICdkcmFnbW92ZScgJiYgZHJvcFN0YXRlLmN1ci5kcm9wem9uZSkge1xuICAgIGRyb3BFdmVudHMubW92ZSA9IG5ldyBEcm9wRXZlbnQoZHJvcFN0YXRlLCBkcmFnRXZlbnQsICdkcm9wbW92ZScpXG5cbiAgICBkcm9wRXZlbnRzLm1vdmUuZHJhZ21vdmUgPSBkcmFnRXZlbnRcbiAgICBkcmFnRXZlbnQuZHJvcHpvbmUgPSBkcm9wU3RhdGUuY3VyLmRyb3B6b25lXG4gIH1cblxuICByZXR1cm4gZHJvcEV2ZW50c1xufVxuXG5mdW5jdGlvbiBmaXJlRHJvcEV2ZW50cyAoaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uLCBldmVudHMpIHtcbiAgY29uc3QgeyBkcm9wU3RhdGUgfSA9IGludGVyYWN0aW9uXG4gIGNvbnN0IHtcbiAgICBhY3RpdmVEcm9wcyxcbiAgICBjdXIsXG4gICAgcHJldixcbiAgfSA9IGRyb3BTdGF0ZVxuXG4gIGlmIChldmVudHMubGVhdmUpIHsgcHJldi5kcm9wem9uZS5maXJlKGV2ZW50cy5sZWF2ZSkgfVxuICBpZiAoZXZlbnRzLm1vdmUpIHsgY3VyLmRyb3B6b25lLmZpcmUoZXZlbnRzLm1vdmUpIH1cbiAgaWYgKGV2ZW50cy5lbnRlcikgeyBjdXIuZHJvcHpvbmUuZmlyZShldmVudHMuZW50ZXIpIH1cbiAgaWYgKGV2ZW50cy5kcm9wKSB7IGN1ci5kcm9wem9uZS5maXJlKGV2ZW50cy5kcm9wKSB9XG5cbiAgaWYgKGV2ZW50cy5kZWFjdGl2YXRlKSB7XG4gICAgZmlyZUFjdGl2YXRpb25FdmVudHMoYWN0aXZlRHJvcHMsIGV2ZW50cy5kZWFjdGl2YXRlKVxuICB9XG5cbiAgZHJvcFN0YXRlLnByZXYuZHJvcHpvbmUgID0gY3VyLmRyb3B6b25lXG4gIGRyb3BTdGF0ZS5wcmV2LmVsZW1lbnQgPSBjdXIuZWxlbWVudFxufVxuXG5mdW5jdGlvbiBvbkV2ZW50Q3JlYXRlZCAoeyBpbnRlcmFjdGlvbiwgaUV2ZW50LCBldmVudCB9OiBJbnRlcmFjdC5Eb1BoYXNlQXJnPCdkcmFnJywgSW50ZXJhY3QuRXZlbnRQaGFzZT4sIHNjb3BlKSB7XG4gIGlmIChpRXZlbnQudHlwZSAhPT0gJ2RyYWdtb3ZlJyAmJiBpRXZlbnQudHlwZSAhPT0gJ2RyYWdlbmQnKSB7IHJldHVybiB9XG5cbiAgY29uc3QgeyBkcm9wU3RhdGUgfSA9IGludGVyYWN0aW9uXG5cbiAgaWYgKHNjb3BlLmR5bmFtaWNEcm9wKSB7XG4gICAgZHJvcFN0YXRlLmFjdGl2ZURyb3BzID0gZ2V0QWN0aXZlRHJvcHMoc2NvcGUsIGludGVyYWN0aW9uLmVsZW1lbnQpXG4gIH1cblxuICBjb25zdCBkcmFnRXZlbnQgPSBpRXZlbnRcbiAgY29uc3QgZHJvcFJlc3VsdCA9IGdldERyb3AoaW50ZXJhY3Rpb24sIGRyYWdFdmVudCwgZXZlbnQpXG5cbiAgLy8gdXBkYXRlIHJlamVjdGVkIHN0YXR1c1xuICBkcm9wU3RhdGUucmVqZWN0ZWQgPSBkcm9wU3RhdGUucmVqZWN0ZWQgJiZcbiAgICAhIWRyb3BSZXN1bHQgJiZcbiAgICBkcm9wUmVzdWx0LmRyb3B6b25lID09PSBkcm9wU3RhdGUuY3VyLmRyb3B6b25lICYmXG4gICAgZHJvcFJlc3VsdC5lbGVtZW50ID09PSBkcm9wU3RhdGUuY3VyLmVsZW1lbnRcblxuICBkcm9wU3RhdGUuY3VyLmRyb3B6b25lICA9IGRyb3BSZXN1bHQgJiYgZHJvcFJlc3VsdC5kcm9wem9uZVxuICBkcm9wU3RhdGUuY3VyLmVsZW1lbnQgPSBkcm9wUmVzdWx0ICYmIGRyb3BSZXN1bHQuZWxlbWVudFxuXG4gIGRyb3BTdGF0ZS5ldmVudHMgPSBnZXREcm9wRXZlbnRzKGludGVyYWN0aW9uLCBldmVudCwgZHJhZ0V2ZW50KVxufVxuXG5mdW5jdGlvbiBkcm9wem9uZU1ldGhvZCAoaW50ZXJhY3RhYmxlOiBJbnRlcmFjdC5JbnRlcmFjdGFibGUpOiBJbnRlcmFjdC5Ecm9wem9uZU9wdGlvbnNcbmZ1bmN0aW9uIGRyb3B6b25lTWV0aG9kIChpbnRlcmFjdGFibGU6IEludGVyYWN0LkludGVyYWN0YWJsZSwgb3B0aW9uczogSW50ZXJhY3QuRHJvcHpvbmVPcHRpb25zIHwgYm9vbGVhbilcbmZ1bmN0aW9uIGRyb3B6b25lTWV0aG9kIChpbnRlcmFjdGFibGU6IEludGVyYWN0LkludGVyYWN0YWJsZSwgb3B0aW9ucz86IEludGVyYWN0LkRyb3B6b25lT3B0aW9ucyB8IGJvb2xlYW4pIHtcbiAgaWYgKHV0aWxzLmlzLm9iamVjdChvcHRpb25zKSkge1xuICAgIGludGVyYWN0YWJsZS5vcHRpb25zLmRyb3AuZW5hYmxlZCA9IG9wdGlvbnMuZW5hYmxlZCAhPT0gZmFsc2VcblxuICAgIGlmIChvcHRpb25zLmxpc3RlbmVycykge1xuICAgICAgY29uc3Qgbm9ybWFsaXplZCA9IHV0aWxzLm5vcm1hbGl6ZUxpc3RlbmVycyhvcHRpb25zLmxpc3RlbmVycylcbiAgICAgIC8vIHJlbmFtZSAnZHJvcCcgdG8gJycgYXMgaXQgd2lsbCBiZSBwcmVmaXhlZCB3aXRoICdkcm9wJ1xuICAgICAgY29uc3QgY29ycmVjdGVkID0gT2JqZWN0LmtleXMobm9ybWFsaXplZCkucmVkdWNlKChhY2MsIHR5cGUpID0+IHtcbiAgICAgICAgY29uc3QgY29ycmVjdGVkVHlwZSA9IC9eKGVudGVyfGxlYXZlKS8udGVzdCh0eXBlKVxuICAgICAgICAgID8gYGRyYWcke3R5cGV9YFxuICAgICAgICAgIDogL14oYWN0aXZhdGV8ZGVhY3RpdmF0ZXxtb3ZlKS8udGVzdCh0eXBlKVxuICAgICAgICAgICAgPyBgZHJvcCR7dHlwZX1gXG4gICAgICAgICAgICA6IHR5cGVcblxuICAgICAgICBhY2NbY29ycmVjdGVkVHlwZV0gPSBub3JtYWxpemVkW3R5cGVdXG5cbiAgICAgICAgcmV0dXJuIGFjY1xuICAgICAgfSwge30pXG5cbiAgICAgIGludGVyYWN0YWJsZS5vZmYoaW50ZXJhY3RhYmxlLm9wdGlvbnMuZHJvcC5saXN0ZW5lcnMpXG4gICAgICBpbnRlcmFjdGFibGUub24oY29ycmVjdGVkKVxuICAgICAgaW50ZXJhY3RhYmxlLm9wdGlvbnMuZHJvcC5saXN0ZW5lcnMgPSBjb3JyZWN0ZWRcbiAgICB9XG5cbiAgICBpZiAodXRpbHMuaXMuZnVuYyhvcHRpb25zLm9uZHJvcCkpIHsgaW50ZXJhY3RhYmxlLm9uKCdkcm9wJywgb3B0aW9ucy5vbmRyb3ApIH1cbiAgICBpZiAodXRpbHMuaXMuZnVuYyhvcHRpb25zLm9uZHJvcGFjdGl2YXRlKSkgeyBpbnRlcmFjdGFibGUub24oJ2Ryb3BhY3RpdmF0ZScsIG9wdGlvbnMub25kcm9wYWN0aXZhdGUpIH1cbiAgICBpZiAodXRpbHMuaXMuZnVuYyhvcHRpb25zLm9uZHJvcGRlYWN0aXZhdGUpKSB7IGludGVyYWN0YWJsZS5vbignZHJvcGRlYWN0aXZhdGUnLCBvcHRpb25zLm9uZHJvcGRlYWN0aXZhdGUpIH1cbiAgICBpZiAodXRpbHMuaXMuZnVuYyhvcHRpb25zLm9uZHJhZ2VudGVyKSkgeyBpbnRlcmFjdGFibGUub24oJ2RyYWdlbnRlcicsIG9wdGlvbnMub25kcmFnZW50ZXIpIH1cbiAgICBpZiAodXRpbHMuaXMuZnVuYyhvcHRpb25zLm9uZHJhZ2xlYXZlKSkgeyBpbnRlcmFjdGFibGUub24oJ2RyYWdsZWF2ZScsIG9wdGlvbnMub25kcmFnbGVhdmUpIH1cbiAgICBpZiAodXRpbHMuaXMuZnVuYyhvcHRpb25zLm9uZHJvcG1vdmUpKSB7IGludGVyYWN0YWJsZS5vbignZHJvcG1vdmUnLCBvcHRpb25zLm9uZHJvcG1vdmUpIH1cblxuICAgIGlmICgvXihwb2ludGVyfGNlbnRlcikkLy50ZXN0KG9wdGlvbnMub3ZlcmxhcCBhcyBzdHJpbmcpKSB7XG4gICAgICBpbnRlcmFjdGFibGUub3B0aW9ucy5kcm9wLm92ZXJsYXAgPSBvcHRpb25zLm92ZXJsYXBcbiAgICB9XG4gICAgZWxzZSBpZiAodXRpbHMuaXMubnVtYmVyKG9wdGlvbnMub3ZlcmxhcCkpIHtcbiAgICAgIGludGVyYWN0YWJsZS5vcHRpb25zLmRyb3Aub3ZlcmxhcCA9IE1hdGgubWF4KE1hdGgubWluKDEsIG9wdGlvbnMub3ZlcmxhcCksIDApXG4gICAgfVxuICAgIGlmICgnYWNjZXB0JyBpbiBvcHRpb25zKSB7XG4gICAgICBpbnRlcmFjdGFibGUub3B0aW9ucy5kcm9wLmFjY2VwdCA9IG9wdGlvbnMuYWNjZXB0XG4gICAgfVxuICAgIGlmICgnY2hlY2tlcicgaW4gb3B0aW9ucykge1xuICAgICAgaW50ZXJhY3RhYmxlLm9wdGlvbnMuZHJvcC5jaGVja2VyID0gb3B0aW9ucy5jaGVja2VyXG4gICAgfVxuXG4gICAgcmV0dXJuIGludGVyYWN0YWJsZVxuICB9XG5cbiAgaWYgKHV0aWxzLmlzLmJvb2wob3B0aW9ucykpIHtcbiAgICBpbnRlcmFjdGFibGUub3B0aW9ucy5kcm9wLmVuYWJsZWQgPSBvcHRpb25zXG5cbiAgICByZXR1cm4gaW50ZXJhY3RhYmxlXG4gIH1cblxuICByZXR1cm4gaW50ZXJhY3RhYmxlLm9wdGlvbnMuZHJvcFxufVxuXG5mdW5jdGlvbiBkcm9wQ2hlY2tNZXRob2QgKFxuICBpbnRlcmFjdGFibGU6IEludGVyYWN0LkludGVyYWN0YWJsZSxcbiAgZHJhZ0V2ZW50OiBJbnRlcmFjdEV2ZW50LFxuICBldmVudDogSW50ZXJhY3QuUG9pbnRlckV2ZW50VHlwZSxcbiAgZHJhZ2dhYmxlOiBJbnRlcmFjdC5JbnRlcmFjdGFibGUsXG4gIGRyYWdnYWJsZUVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnQsXG4gIGRyb3BFbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50LFxuICByZWN0OiBhbnksXG4pIHtcbiAgbGV0IGRyb3BwZWQgPSBmYWxzZVxuXG4gIC8vIGlmIHRoZSBkcm9wem9uZSBoYXMgbm8gcmVjdCAoZWcuIGRpc3BsYXk6IG5vbmUpXG4gIC8vIGNhbGwgdGhlIGN1c3RvbSBkcm9wQ2hlY2tlciBvciBqdXN0IHJldHVybiBmYWxzZVxuICBpZiAoIShyZWN0ID0gcmVjdCB8fCBpbnRlcmFjdGFibGUuZ2V0UmVjdChkcm9wRWxlbWVudCkpKSB7XG4gICAgcmV0dXJuIChpbnRlcmFjdGFibGUub3B0aW9ucy5kcm9wLmNoZWNrZXJcbiAgICAgID8gaW50ZXJhY3RhYmxlLm9wdGlvbnMuZHJvcC5jaGVja2VyKGRyYWdFdmVudCwgZXZlbnQsIGRyb3BwZWQsIGludGVyYWN0YWJsZSwgZHJvcEVsZW1lbnQsIGRyYWdnYWJsZSwgZHJhZ2dhYmxlRWxlbWVudClcbiAgICAgIDogZmFsc2UpXG4gIH1cblxuICBjb25zdCBkcm9wT3ZlcmxhcCA9IGludGVyYWN0YWJsZS5vcHRpb25zLmRyb3Aub3ZlcmxhcFxuXG4gIGlmIChkcm9wT3ZlcmxhcCA9PT0gJ3BvaW50ZXInKSB7XG4gICAgY29uc3Qgb3JpZ2luID0gdXRpbHMuZ2V0T3JpZ2luWFkoZHJhZ2dhYmxlLCBkcmFnZ2FibGVFbGVtZW50LCAnZHJhZycpXG4gICAgY29uc3QgcGFnZSA9IHV0aWxzLnBvaW50ZXIuZ2V0UGFnZVhZKGRyYWdFdmVudClcblxuICAgIHBhZ2UueCArPSBvcmlnaW4ueFxuICAgIHBhZ2UueSArPSBvcmlnaW4ueVxuXG4gICAgY29uc3QgaG9yaXpvbnRhbCA9IChwYWdlLnggPiByZWN0LmxlZnQpICYmIChwYWdlLnggPCByZWN0LnJpZ2h0KVxuICAgIGNvbnN0IHZlcnRpY2FsICAgPSAocGFnZS55ID4gcmVjdC50b3ApICYmIChwYWdlLnkgPCByZWN0LmJvdHRvbSlcblxuICAgIGRyb3BwZWQgPSBob3Jpem9udGFsICYmIHZlcnRpY2FsXG4gIH1cblxuICBjb25zdCBkcmFnUmVjdCA9IGRyYWdnYWJsZS5nZXRSZWN0KGRyYWdnYWJsZUVsZW1lbnQpXG5cbiAgaWYgKGRyYWdSZWN0ICYmIGRyb3BPdmVybGFwID09PSAnY2VudGVyJykge1xuICAgIGNvbnN0IGN4ID0gZHJhZ1JlY3QubGVmdCArIGRyYWdSZWN0LndpZHRoICAvIDJcbiAgICBjb25zdCBjeSA9IGRyYWdSZWN0LnRvcCAgKyBkcmFnUmVjdC5oZWlnaHQgLyAyXG5cbiAgICBkcm9wcGVkID0gY3ggPj0gcmVjdC5sZWZ0ICYmIGN4IDw9IHJlY3QucmlnaHQgJiYgY3kgPj0gcmVjdC50b3AgJiYgY3kgPD0gcmVjdC5ib3R0b21cbiAgfVxuXG4gIGlmIChkcmFnUmVjdCAmJiB1dGlscy5pcy5udW1iZXIoZHJvcE92ZXJsYXApKSB7XG4gICAgY29uc3Qgb3ZlcmxhcEFyZWEgID0gKE1hdGgubWF4KDAsIE1hdGgubWluKHJlY3QucmlnaHQsIGRyYWdSZWN0LnJpZ2h0KSAtIE1hdGgubWF4KHJlY3QubGVmdCwgZHJhZ1JlY3QubGVmdCkpICpcbiAgICAgICAgICAgICAgICAgICAgICAgICAgTWF0aC5tYXgoMCwgTWF0aC5taW4ocmVjdC5ib3R0b20sIGRyYWdSZWN0LmJvdHRvbSkgLSBNYXRoLm1heChyZWN0LnRvcCwgZHJhZ1JlY3QudG9wKSkpXG5cbiAgICBjb25zdCBvdmVybGFwUmF0aW8gPSBvdmVybGFwQXJlYSAvIChkcmFnUmVjdC53aWR0aCAqIGRyYWdSZWN0LmhlaWdodClcblxuICAgIGRyb3BwZWQgPSBvdmVybGFwUmF0aW8gPj0gZHJvcE92ZXJsYXBcbiAgfVxuXG4gIGlmIChpbnRlcmFjdGFibGUub3B0aW9ucy5kcm9wLmNoZWNrZXIpIHtcbiAgICBkcm9wcGVkID0gaW50ZXJhY3RhYmxlLm9wdGlvbnMuZHJvcC5jaGVja2VyKGRyYWdFdmVudCwgZXZlbnQsIGRyb3BwZWQsIGludGVyYWN0YWJsZSwgZHJvcEVsZW1lbnQsIGRyYWdnYWJsZSwgZHJhZ2dhYmxlRWxlbWVudClcbiAgfVxuXG4gIHJldHVybiBkcm9wcGVkXG59XG5cbmNvbnN0IGRyb3A6IEludGVyYWN0LlBsdWdpbiA9IHtcbiAgaWQ6ICdhY3Rpb25zL2Ryb3AnLFxuICBpbnN0YWxsLFxuICBsaXN0ZW5lcnM6IHtcbiAgICAnaW50ZXJhY3Rpb25zOmJlZm9yZS1hY3Rpb24tc3RhcnQnOiAoeyBpbnRlcmFjdGlvbiB9KSA9PiB7XG4gICAgICBpZiAoaW50ZXJhY3Rpb24ucHJlcGFyZWQubmFtZSAhPT0gJ2RyYWcnKSB7IHJldHVybiB9XG5cbiAgICAgIGludGVyYWN0aW9uLmRyb3BTdGF0ZSA9IHtcbiAgICAgICAgY3VyOiB7XG4gICAgICAgICAgZHJvcHpvbmU6IG51bGwsXG4gICAgICAgICAgZWxlbWVudDogbnVsbCxcbiAgICAgICAgfSxcbiAgICAgICAgcHJldjoge1xuICAgICAgICAgIGRyb3B6b25lOiBudWxsLFxuICAgICAgICAgIGVsZW1lbnQ6IG51bGwsXG4gICAgICAgIH0sXG4gICAgICAgIHJlamVjdGVkOiBudWxsLFxuICAgICAgICBldmVudHM6IG51bGwsXG4gICAgICAgIGFjdGl2ZURyb3BzOiBbXSxcbiAgICAgIH1cbiAgICB9LFxuXG4gICAgJ2ludGVyYWN0aW9uczphZnRlci1hY3Rpb24tc3RhcnQnOiAoeyBpbnRlcmFjdGlvbiwgZXZlbnQsIGlFdmVudDogZHJhZ0V2ZW50IH06IEludGVyYWN0LkRvUGhhc2VBcmc8J2RyYWcnLCBJbnRlcmFjdC5FdmVudFBoYXNlPiwgc2NvcGUpID0+IHtcbiAgICAgIGlmIChpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lICE9PSAnZHJhZycpIHsgcmV0dXJuIH1cblxuICAgICAgY29uc3QgeyBkcm9wU3RhdGUgfSA9IGludGVyYWN0aW9uXG5cbiAgICAgIC8vIHJlc2V0IGFjdGl2ZSBkcm9wem9uZXNcbiAgICAgIGRyb3BTdGF0ZS5hY3RpdmVEcm9wcyA9IG51bGxcbiAgICAgIGRyb3BTdGF0ZS5ldmVudHMgPSBudWxsXG4gICAgICBkcm9wU3RhdGUuYWN0aXZlRHJvcHMgPSBnZXRBY3RpdmVEcm9wcyhzY29wZSwgaW50ZXJhY3Rpb24uZWxlbWVudClcbiAgICAgIGRyb3BTdGF0ZS5ldmVudHMgPSBnZXREcm9wRXZlbnRzKGludGVyYWN0aW9uLCBldmVudCwgZHJhZ0V2ZW50KVxuXG4gICAgICBpZiAoZHJvcFN0YXRlLmV2ZW50cy5hY3RpdmF0ZSkge1xuICAgICAgICBmaXJlQWN0aXZhdGlvbkV2ZW50cyhkcm9wU3RhdGUuYWN0aXZlRHJvcHMsIGRyb3BTdGF0ZS5ldmVudHMuYWN0aXZhdGUpXG4gICAgICAgIHNjb3BlLmZpcmUoJ2FjdGlvbnMvZHJvcDpzdGFydCcsIHsgaW50ZXJhY3Rpb24sIGRyYWdFdmVudCB9KVxuICAgICAgfVxuICAgIH0sXG5cbiAgICAvLyBGSVhNRSBwcm9wZXIgc2lnbmFsIHR5cGVzXG4gICAgJ2ludGVyYWN0aW9uczphY3Rpb24tbW92ZSc6IG9uRXZlbnRDcmVhdGVkLFxuICAgICdpbnRlcmFjdGlvbnM6YWN0aW9uLWVuZCc6IG9uRXZlbnRDcmVhdGVkLFxuXG4gICAgJ2ludGVyYWN0aW9uczphZnRlci1hY3Rpb24tbW92ZSc6IGZ1bmN0aW9uIGZpcmVEcm9wQWZ0ZXJNb3ZlICh7IGludGVyYWN0aW9uLCBpRXZlbnQ6IGRyYWdFdmVudCB9OiBJbnRlcmFjdC5Eb1BoYXNlQXJnPCdkcmFnJywgSW50ZXJhY3QuRXZlbnRQaGFzZT4sIHNjb3BlKSB7XG4gICAgICBpZiAoaW50ZXJhY3Rpb24ucHJlcGFyZWQubmFtZSAhPT0gJ2RyYWcnKSB7IHJldHVybiB9XG5cbiAgICAgIGZpcmVEcm9wRXZlbnRzKGludGVyYWN0aW9uLCBpbnRlcmFjdGlvbi5kcm9wU3RhdGUuZXZlbnRzKVxuXG4gICAgICBzY29wZS5maXJlKCdhY3Rpb25zL2Ryb3A6bW92ZScsIHsgaW50ZXJhY3Rpb24sIGRyYWdFdmVudCB9KVxuICAgICAgaW50ZXJhY3Rpb24uZHJvcFN0YXRlLmV2ZW50cyA9IHt9XG4gICAgfSxcblxuICAgICdpbnRlcmFjdGlvbnM6YWZ0ZXItYWN0aW9uLWVuZCc6ICh7IGludGVyYWN0aW9uLCBpRXZlbnQ6IGRyYWdFdmVudCB9OiBJbnRlcmFjdC5Eb1BoYXNlQXJnPCdkcmFnJywgSW50ZXJhY3QuRXZlbnRQaGFzZT4sIHNjb3BlKSA9PiB7XG4gICAgICBpZiAoaW50ZXJhY3Rpb24ucHJlcGFyZWQubmFtZSAhPT0gJ2RyYWcnKSB7IHJldHVybiB9XG5cbiAgICAgIGZpcmVEcm9wRXZlbnRzKGludGVyYWN0aW9uLCBpbnRlcmFjdGlvbi5kcm9wU3RhdGUuZXZlbnRzKVxuICAgICAgc2NvcGUuZmlyZSgnYWN0aW9ucy9kcm9wOmVuZCcsIHsgaW50ZXJhY3Rpb24sIGRyYWdFdmVudCB9KVxuICAgIH0sXG5cbiAgICAnaW50ZXJhY3Rpb25zOnN0b3AnOiAoeyBpbnRlcmFjdGlvbiB9KSA9PiB7XG4gICAgICBpZiAoaW50ZXJhY3Rpb24ucHJlcGFyZWQubmFtZSAhPT0gJ2RyYWcnKSB7IHJldHVybiB9XG5cbiAgICAgIGNvbnN0IHsgZHJvcFN0YXRlIH0gPSBpbnRlcmFjdGlvblxuXG4gICAgICBpZiAoZHJvcFN0YXRlKSB7XG4gICAgICAgIGRyb3BTdGF0ZS5hY3RpdmVEcm9wcyA9IG51bGxcbiAgICAgICAgZHJvcFN0YXRlLmV2ZW50cyA9IG51bGxcbiAgICAgICAgZHJvcFN0YXRlLmN1ci5kcm9wem9uZSA9IG51bGxcbiAgICAgICAgZHJvcFN0YXRlLmN1ci5lbGVtZW50ID0gbnVsbFxuICAgICAgICBkcm9wU3RhdGUucHJldi5kcm9wem9uZSA9IG51bGxcbiAgICAgICAgZHJvcFN0YXRlLnByZXYuZWxlbWVudCA9IG51bGxcbiAgICAgICAgZHJvcFN0YXRlLnJlamVjdGVkID0gZmFsc2VcbiAgICAgIH1cbiAgICB9LFxuICB9LFxuICBnZXRBY3RpdmVEcm9wcyxcbiAgZ2V0RHJvcCxcbiAgZ2V0RHJvcEV2ZW50cyxcbiAgZmlyZURyb3BFdmVudHMsXG4gIGRlZmF1bHRzOiB7XG4gICAgZW5hYmxlZDogZmFsc2UsXG4gICAgYWNjZXB0IDogbnVsbCxcbiAgICBvdmVybGFwOiAncG9pbnRlcicsXG4gIH0gYXMgSW50ZXJhY3QuRHJvcHpvbmVPcHRpb25zLFxufVxuXG5leHBvcnQgZGVmYXVsdCBkcm9wXG4iLCJpbXBvcnQgKiBhcyB1dGlscyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9pbmRleCdcblxuZXhwb3J0IHR5cGUgR2VzdHVyYWJsZU1ldGhvZCA9IEludGVyYWN0LkFjdGlvbk1ldGhvZDxJbnRlcmFjdC5HZXN0dXJhYmxlT3B0aW9ucz5cblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3Rpb24nIHtcbiAgaW50ZXJmYWNlIEludGVyYWN0aW9uIHtcbiAgICBnZXN0dXJlPzoge1xuICAgICAgYW5nbGU6IG51bWJlciAgICAgICAgICAgLy8gYW5nbGUgZnJvbSBmaXJzdCB0byBzZWNvbmQgdG91Y2hcbiAgICAgIGRpc3RhbmNlOiBudW1iZXJcbiAgICAgIHNjYWxlOiBudW1iZXIgICAgICAgICAgIC8vIGdlc3R1cmUuZGlzdGFuY2UgLyBnZXN0dXJlLnN0YXJ0RGlzdGFuY2VcbiAgICAgIHN0YXJ0QW5nbGU6IG51bWJlciAgICAgIC8vIGFuZ2xlIG9mIGxpbmUgam9pbmluZyB0d28gdG91Y2hlc1xuICAgICAgc3RhcnREaXN0YW5jZTogbnVtYmVyICAgLy8gZGlzdGFuY2UgYmV0d2VlbiB0d28gdG91Y2hlcyBvZiB0b3VjaFN0YXJ0XG4gICAgfVxuICB9XG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL0ludGVyYWN0YWJsZScge1xuICBpbnRlcmZhY2UgSW50ZXJhY3RhYmxlIHtcbiAgICBnZXN0dXJhYmxlOiBHZXN0dXJhYmxlTWV0aG9kXG4gIH1cbn1cblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvZGVmYXVsdE9wdGlvbnMnIHtcbiAgaW50ZXJmYWNlIEFjdGlvbkRlZmF1bHRzIHtcbiAgICBnZXN0dXJlOiBJbnRlcmFjdC5HZXN0dXJhYmxlT3B0aW9uc1xuICB9XG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL3Njb3BlJyB7XG4gIGludGVyZmFjZSBBY3Rpb25NYXAge1xuICAgIGdlc3R1cmU/OiB0eXBlb2YgZ2VzdHVyZVxuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgR2VzdHVyZUV2ZW50IGV4dGVuZHMgSW50ZXJhY3QuSW50ZXJhY3RFdmVudDwnZ2VzdHVyZSc+IHtcbiAgZGlzdGFuY2U6IG51bWJlclxuICBhbmdsZTogbnVtYmVyXG4gIGRhOiBudW1iZXIgLy8gYW5nbGUgY2hhbmdlXG4gIHNjYWxlOiBudW1iZXIgLy8gcmF0aW8gb2YgZGlzdGFuY2Ugc3RhcnQgdG8gY3VycmVudCBldmVudFxuICBkczogbnVtYmVyIC8vIHNjYWxlIGNoYW5nZVxuICBib3g6IEludGVyYWN0LlJlY3QgLy8gZW5jbG9zaW5nIGJveCBvZiBhbGwgcG9pbnRzXG4gIHRvdWNoZXM6IEludGVyYWN0LlBvaW50ZXJUeXBlW11cbn1cblxuZXhwb3J0IGludGVyZmFjZSBHZXN0dXJlU2lnbmFsQXJnIGV4dGVuZHMgSW50ZXJhY3QuRG9QaGFzZUFyZzwnZ2VzdHVyZScsIEludGVyYWN0LkV2ZW50UGhhc2U+IHtcbiAgaUV2ZW50OiBHZXN0dXJlRXZlbnRcbiAgaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uPCdnZXN0dXJlJz5cbn1cblxuZnVuY3Rpb24gaW5zdGFsbCAoc2NvcGU6IEludGVyYWN0LlNjb3BlKSB7XG4gIGNvbnN0IHtcbiAgICBhY3Rpb25zLFxuICAgIEludGVyYWN0YWJsZSxcbiAgICBkZWZhdWx0cyxcbiAgfSA9IHNjb3BlXG5cbiAgLyoqXG4gICAqIGBgYGpzXG4gICAqIGludGVyYWN0KGVsZW1lbnQpLmdlc3R1cmFibGUoe1xuICAgKiAgICAgb25zdGFydDogZnVuY3Rpb24gKGV2ZW50KSB7fSxcbiAgICogICAgIG9ubW92ZSA6IGZ1bmN0aW9uIChldmVudCkge30sXG4gICAqICAgICBvbmVuZCAgOiBmdW5jdGlvbiAoZXZlbnQpIHt9LFxuICAgKlxuICAgKiAgICAgLy8gbGltaXQgbXVsdGlwbGUgZ2VzdHVyZXMuXG4gICAqICAgICAvLyBTZWUgdGhlIGV4cGxhbmF0aW9uIGluIHtAbGluayBJbnRlcmFjdGFibGUuZHJhZ2dhYmxlfSBleGFtcGxlXG4gICAqICAgICBtYXg6IEluZmluaXR5LFxuICAgKiAgICAgbWF4UGVyRWxlbWVudDogMSxcbiAgICogfSlcbiAgICpcbiAgICogdmFyIGlzR2VzdHVyZWFibGUgPSBpbnRlcmFjdChlbGVtZW50KS5nZXN0dXJhYmxlKClcbiAgICogYGBgXG4gICAqXG4gICAqIEdldHMgb3Igc2V0cyB3aGV0aGVyIG11bHRpdG91Y2ggZ2VzdHVyZXMgY2FuIGJlIHBlcmZvcm1lZCBvbiB0aGUgdGFyZ2V0XG4gICAqXG4gICAqIEBwYXJhbSB7Ym9vbGVhbiB8IG9iamVjdH0gW29wdGlvbnNdIHRydWUvZmFsc2Ugb3IgQW4gb2JqZWN0IHdpdGggZXZlbnRcbiAgICogbGlzdGVuZXJzIHRvIGJlIGZpcmVkIG9uIGdlc3R1cmUgZXZlbnRzIChtYWtlcyB0aGUgSW50ZXJhY3RhYmxlIGdlc3R1cmFibGUpXG4gICAqIEByZXR1cm4ge2Jvb2xlYW4gfCBJbnRlcmFjdGFibGV9IEEgYm9vbGVhbiBpbmRpY2F0aW5nIGlmIHRoaXMgY2FuIGJlIHRoZVxuICAgKiB0YXJnZXQgb2YgZ2VzdHVyZSBldmVudHMsIG9yIHRoaXMgSW50ZXJhY3RhYmxlXG4gICAqL1xuICBJbnRlcmFjdGFibGUucHJvdG90eXBlLmdlc3R1cmFibGUgPSBmdW5jdGlvbiAodGhpczogSW50ZXJhY3QuSW50ZXJhY3RhYmxlLCBvcHRpb25zOiBJbnRlcmFjdC5HZXN0dXJhYmxlT3B0aW9ucyB8IGJvb2xlYW4pIHtcbiAgICBpZiAodXRpbHMuaXMub2JqZWN0KG9wdGlvbnMpKSB7XG4gICAgICB0aGlzLm9wdGlvbnMuZ2VzdHVyZS5lbmFibGVkID0gb3B0aW9ucy5lbmFibGVkICE9PSBmYWxzZVxuICAgICAgdGhpcy5zZXRQZXJBY3Rpb24oJ2dlc3R1cmUnLCBvcHRpb25zKVxuICAgICAgdGhpcy5zZXRPbkV2ZW50cygnZ2VzdHVyZScsIG9wdGlvbnMpXG5cbiAgICAgIHJldHVybiB0aGlzXG4gICAgfVxuXG4gICAgaWYgKHV0aWxzLmlzLmJvb2wob3B0aW9ucykpIHtcbiAgICAgIHRoaXMub3B0aW9ucy5nZXN0dXJlLmVuYWJsZWQgPSBvcHRpb25zXG5cbiAgICAgIHJldHVybiB0aGlzXG4gICAgfVxuXG4gICAgcmV0dXJuIHRoaXMub3B0aW9ucy5nZXN0dXJlIGFzIEludGVyYWN0Lk9wdGlvbnNcbiAgfSBhcyBHZXN0dXJhYmxlTWV0aG9kXG5cbiAgYWN0aW9ucy5tYXAuZ2VzdHVyZSA9IGdlc3R1cmVcbiAgYWN0aW9ucy5tZXRob2REaWN0Lmdlc3R1cmUgPSAnZ2VzdHVyYWJsZSdcblxuICBkZWZhdWx0cy5hY3Rpb25zLmdlc3R1cmUgPSBnZXN0dXJlLmRlZmF1bHRzXG59XG5cbmZ1bmN0aW9uIHVwZGF0ZUdlc3R1cmVQcm9wcyAoeyBpbnRlcmFjdGlvbiwgaUV2ZW50LCBwaGFzZSB9OiBHZXN0dXJlU2lnbmFsQXJnKSB7XG4gIGlmIChpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lICE9PSAnZ2VzdHVyZScpIHsgcmV0dXJuIH1cblxuICBjb25zdCBwb2ludGVycyA9IGludGVyYWN0aW9uLnBvaW50ZXJzLm1hcChwID0+IHAucG9pbnRlcilcbiAgY29uc3Qgc3RhcnRpbmcgPSBwaGFzZSA9PT0gJ3N0YXJ0J1xuICBjb25zdCBlbmRpbmcgPSBwaGFzZSA9PT0gJ2VuZCdcbiAgY29uc3QgZGVsdGFTb3VyY2UgPSBpbnRlcmFjdGlvbi5pbnRlcmFjdGFibGUub3B0aW9ucy5kZWx0YVNvdXJjZVxuXG4gIGlFdmVudC50b3VjaGVzID0gW3BvaW50ZXJzWzBdLCBwb2ludGVyc1sxXV1cblxuICBpZiAoc3RhcnRpbmcpIHtcbiAgICBpRXZlbnQuZGlzdGFuY2UgPSB1dGlscy5wb2ludGVyLnRvdWNoRGlzdGFuY2UocG9pbnRlcnMsIGRlbHRhU291cmNlKVxuICAgIGlFdmVudC5ib3ggICAgICA9IHV0aWxzLnBvaW50ZXIudG91Y2hCQm94KHBvaW50ZXJzKVxuICAgIGlFdmVudC5zY2FsZSAgICA9IDFcbiAgICBpRXZlbnQuZHMgICAgICAgPSAwXG4gICAgaUV2ZW50LmFuZ2xlICAgID0gdXRpbHMucG9pbnRlci50b3VjaEFuZ2xlKHBvaW50ZXJzLCBkZWx0YVNvdXJjZSlcbiAgICBpRXZlbnQuZGEgICAgICAgPSAwXG5cbiAgICBpbnRlcmFjdGlvbi5nZXN0dXJlLnN0YXJ0RGlzdGFuY2UgPSBpRXZlbnQuZGlzdGFuY2VcbiAgICBpbnRlcmFjdGlvbi5nZXN0dXJlLnN0YXJ0QW5nbGUgPSBpRXZlbnQuYW5nbGVcbiAgfVxuICBlbHNlIGlmIChlbmRpbmcpIHtcbiAgICBjb25zdCBwcmV2RXZlbnQgPSBpbnRlcmFjdGlvbi5wcmV2RXZlbnQgYXMgR2VzdHVyZUV2ZW50XG5cbiAgICBpRXZlbnQuZGlzdGFuY2UgPSBwcmV2RXZlbnQuZGlzdGFuY2VcbiAgICBpRXZlbnQuYm94ICAgICAgPSBwcmV2RXZlbnQuYm94XG4gICAgaUV2ZW50LnNjYWxlICAgID0gcHJldkV2ZW50LnNjYWxlXG4gICAgaUV2ZW50LmRzICAgICAgID0gMFxuICAgIGlFdmVudC5hbmdsZSAgICA9IHByZXZFdmVudC5hbmdsZVxuICAgIGlFdmVudC5kYSAgICAgICA9IDBcbiAgfVxuICBlbHNlIHtcbiAgICBpRXZlbnQuZGlzdGFuY2UgPSB1dGlscy5wb2ludGVyLnRvdWNoRGlzdGFuY2UocG9pbnRlcnMsIGRlbHRhU291cmNlKVxuICAgIGlFdmVudC5ib3ggICAgICA9IHV0aWxzLnBvaW50ZXIudG91Y2hCQm94KHBvaW50ZXJzKVxuICAgIGlFdmVudC5zY2FsZSAgICA9IGlFdmVudC5kaXN0YW5jZSAvIGludGVyYWN0aW9uLmdlc3R1cmUuc3RhcnREaXN0YW5jZVxuICAgIGlFdmVudC5hbmdsZSAgICA9IHV0aWxzLnBvaW50ZXIudG91Y2hBbmdsZShwb2ludGVycywgZGVsdGFTb3VyY2UpXG5cbiAgICBpRXZlbnQuZHMgPSBpRXZlbnQuc2NhbGUgLSBpbnRlcmFjdGlvbi5nZXN0dXJlLnNjYWxlXG4gICAgaUV2ZW50LmRhID0gaUV2ZW50LmFuZ2xlIC0gaW50ZXJhY3Rpb24uZ2VzdHVyZS5hbmdsZVxuICB9XG5cbiAgaW50ZXJhY3Rpb24uZ2VzdHVyZS5kaXN0YW5jZSA9IGlFdmVudC5kaXN0YW5jZVxuICBpbnRlcmFjdGlvbi5nZXN0dXJlLmFuZ2xlID0gaUV2ZW50LmFuZ2xlXG5cbiAgaWYgKHV0aWxzLmlzLm51bWJlcihpRXZlbnQuc2NhbGUpICYmXG4gICAgICBpRXZlbnQuc2NhbGUgIT09IEluZmluaXR5ICYmXG4gICAgICAhaXNOYU4oaUV2ZW50LnNjYWxlKSkge1xuICAgIGludGVyYWN0aW9uLmdlc3R1cmUuc2NhbGUgPSBpRXZlbnQuc2NhbGVcbiAgfVxufVxuXG5jb25zdCBnZXN0dXJlOiBJbnRlcmFjdC5QbHVnaW4gPSB7XG4gIGlkOiAnYWN0aW9ucy9nZXN0dXJlJyxcbiAgYmVmb3JlOiBbJ2FjdGlvbnMvZHJhZycsICdhY3Rpb25zL3Jlc2l6ZSddLFxuICBpbnN0YWxsLFxuICBsaXN0ZW5lcnM6IHtcbiAgICAnaW50ZXJhY3Rpb25zOmFjdGlvbi1zdGFydCc6IHVwZGF0ZUdlc3R1cmVQcm9wcyxcbiAgICAnaW50ZXJhY3Rpb25zOmFjdGlvbi1tb3ZlJzogdXBkYXRlR2VzdHVyZVByb3BzLFxuICAgICdpbnRlcmFjdGlvbnM6YWN0aW9uLWVuZCc6IHVwZGF0ZUdlc3R1cmVQcm9wcyxcblxuICAgICdpbnRlcmFjdGlvbnM6bmV3JzogKHsgaW50ZXJhY3Rpb24gfSkgPT4ge1xuICAgICAgaW50ZXJhY3Rpb24uZ2VzdHVyZSA9IHtcbiAgICAgICAgYW5nbGU6IDAsXG4gICAgICAgIGRpc3RhbmNlOiAwLFxuICAgICAgICBzY2FsZTogMSxcbiAgICAgICAgc3RhcnRBbmdsZTogMCxcbiAgICAgICAgc3RhcnREaXN0YW5jZTogMCxcbiAgICAgIH1cbiAgICB9LFxuXG4gICAgJ2F1dG8tc3RhcnQ6Y2hlY2snOiBhcmcgPT4ge1xuICAgICAgaWYgKGFyZy5pbnRlcmFjdGlvbi5wb2ludGVycy5sZW5ndGggPCAyKSB7XG4gICAgICAgIHJldHVybiB1bmRlZmluZWRcbiAgICAgIH1cblxuICAgICAgY29uc3QgZ2VzdHVyZU9wdGlvbnMgPSBhcmcuaW50ZXJhY3RhYmxlLm9wdGlvbnMuZ2VzdHVyZVxuXG4gICAgICBpZiAoIShnZXN0dXJlT3B0aW9ucyAmJiBnZXN0dXJlT3B0aW9ucy5lbmFibGVkKSkge1xuICAgICAgICByZXR1cm4gdW5kZWZpbmVkXG4gICAgICB9XG5cbiAgICAgIGFyZy5hY3Rpb24gPSB7IG5hbWU6ICdnZXN0dXJlJyB9XG5cbiAgICAgIHJldHVybiBmYWxzZVxuICAgIH0sXG4gIH0sXG5cbiAgZGVmYXVsdHM6IHtcbiAgfSxcblxuICBnZXRDdXJzb3IgKCkge1xuICAgIHJldHVybiAnJ1xuICB9LFxufVxuXG5leHBvcnQgZGVmYXVsdCBnZXN0dXJlXG4iLCJpbXBvcnQgeyBJbnRlcmFjdGlvbiB9IGZyb20gJ0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3Rpb24nXG5pbXBvcnQgeyBTY29wZSB9IGZyb20gJ0BpbnRlcmFjdGpzL2NvcmUvc2NvcGUnXG5pbXBvcnQgKiBhcyBkb20gZnJvbSAnQGludGVyYWN0anMvdXRpbHMvZG9tVXRpbHMnXG5pbXBvcnQgZXh0ZW5kIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2V4dGVuZCdcbmltcG9ydCAqIGFzIGlzIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2lzJ1xuXG5leHBvcnQgdHlwZSBFZGdlTmFtZSA9ICd0b3AnIHwgJ2xlZnQnIHwgJ2JvdHRvbScgfCAncmlnaHQnXG5cbmV4cG9ydCB0eXBlIFJlc2l6YWJsZU1ldGhvZCA9IEludGVyYWN0LkFjdGlvbk1ldGhvZDxJbnRlcmFjdC5SZXNpemFibGVPcHRpb25zPlxuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvY29yZS9JbnRlcmFjdGFibGUnIHtcbiAgaW50ZXJmYWNlIEludGVyYWN0YWJsZSB7XG4gICAgcmVzaXphYmxlOiBSZXNpemFibGVNZXRob2RcbiAgfVxufVxuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvY29yZS9JbnRlcmFjdGlvbicge1xuICBpbnRlcmZhY2UgSW50ZXJhY3Rpb24ge1xuICAgIHJlc2l6ZUF4ZXM6ICd4JyB8ICd5JyB8ICd4eSdcbiAgICByZXNpemVTdGFydEFzcGVjdFJhdGlvOiBudW1iZXJcbiAgfVxufVxuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvY29yZS9kZWZhdWx0T3B0aW9ucycge1xuICBpbnRlcmZhY2UgQWN0aW9uRGVmYXVsdHMge1xuICAgIHJlc2l6ZTogSW50ZXJhY3QuUmVzaXphYmxlT3B0aW9uc1xuICB9XG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL3Njb3BlJyB7XG4gIGludGVyZmFjZSBBY3Rpb25NYXAge1xuICAgIHJlc2l6ZT86IHR5cGVvZiByZXNpemVcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIFJlc2l6ZUV2ZW50PFAgZXh0ZW5kcyBJbnRlcmFjdC5FdmVudFBoYXNlID0gSW50ZXJhY3QuRXZlbnRQaGFzZT4gZXh0ZW5kcyBJbnRlcmFjdC5JbnRlcmFjdEV2ZW50PCdyZXNpemUnLCBQPiB7XG4gIGRlbHRhUmVjdD86IEludGVyYWN0LkZ1bGxSZWN0XG4gIGVkZ2VzPzogSW50ZXJhY3QuQWN0aW9uUHJvcHNbJ2VkZ2VzJ11cbn1cblxuZnVuY3Rpb24gaW5zdGFsbCAoc2NvcGU6IFNjb3BlKSB7XG4gIGNvbnN0IHtcbiAgICBhY3Rpb25zLFxuICAgIGJyb3dzZXIsXG4gICAgLyoqIEBsZW5kcyBJbnRlcmFjdGFibGUgKi9cbiAgICBJbnRlcmFjdGFibGUsIC8vIHRzbGludDpkaXNhYmxlLWxpbmUgbm8tc2hhZG93ZWQtdmFyaWFibGVcbiAgICBkZWZhdWx0cyxcbiAgfSA9IHNjb3BlXG5cbiAgLy8gTGVzcyBQcmVjaXNpb24gd2l0aCB0b3VjaCBpbnB1dFxuXG4gIHJlc2l6ZS5jdXJzb3JzID0gaW5pdEN1cnNvcnMoYnJvd3NlcilcbiAgcmVzaXplLmRlZmF1bHRNYXJnaW4gPSBicm93c2VyLnN1cHBvcnRzVG91Y2ggfHwgYnJvd3Nlci5zdXBwb3J0c1BvaW50ZXJFdmVudCA/IDIwIDogMTBcblxuICAvKipcbiAgICogYGBganNcbiAgICogaW50ZXJhY3QoZWxlbWVudCkucmVzaXphYmxlKHtcbiAgICogICBvbnN0YXJ0OiBmdW5jdGlvbiAoZXZlbnQpIHt9LFxuICAgKiAgIG9ubW92ZSA6IGZ1bmN0aW9uIChldmVudCkge30sXG4gICAqICAgb25lbmQgIDogZnVuY3Rpb24gKGV2ZW50KSB7fSxcbiAgICpcbiAgICogICBlZGdlczoge1xuICAgKiAgICAgdG9wICAgOiB0cnVlLCAgICAgICAvLyBVc2UgcG9pbnRlciBjb29yZHMgdG8gY2hlY2sgZm9yIHJlc2l6ZS5cbiAgICogICAgIGxlZnQgIDogZmFsc2UsICAgICAgLy8gRGlzYWJsZSByZXNpemluZyBmcm9tIGxlZnQgZWRnZS5cbiAgICogICAgIGJvdHRvbTogJy5yZXNpemUtcycsLy8gUmVzaXplIGlmIHBvaW50ZXIgdGFyZ2V0IG1hdGNoZXMgc2VsZWN0b3JcbiAgICogICAgIHJpZ2h0IDogaGFuZGxlRWwgICAgLy8gUmVzaXplIGlmIHBvaW50ZXIgdGFyZ2V0IGlzIHRoZSBnaXZlbiBFbGVtZW50XG4gICAqICAgfSxcbiAgICpcbiAgICogICAgIC8vIFdpZHRoIGFuZCBoZWlnaHQgY2FuIGJlIGFkanVzdGVkIGluZGVwZW5kZW50bHkuIFdoZW4gYHRydWVgLCB3aWR0aCBhbmRcbiAgICogICAgIC8vIGhlaWdodCBhcmUgYWRqdXN0ZWQgYXQgYSAxOjEgcmF0aW8uXG4gICAqICAgICBzcXVhcmU6IGZhbHNlLFxuICAgKlxuICAgKiAgICAgLy8gV2lkdGggYW5kIGhlaWdodCBjYW4gYmUgYWRqdXN0ZWQgaW5kZXBlbmRlbnRseS4gV2hlbiBgdHJ1ZWAsIHdpZHRoIGFuZFxuICAgKiAgICAgLy8gaGVpZ2h0IG1haW50YWluIHRoZSBhc3BlY3QgcmF0aW8gdGhleSBoYWQgd2hlbiByZXNpemluZyBzdGFydGVkLlxuICAgKiAgICAgcHJlc2VydmVBc3BlY3RSYXRpbzogZmFsc2UsXG4gICAqXG4gICAqICAgLy8gYSB2YWx1ZSBvZiAnbm9uZScgd2lsbCBsaW1pdCB0aGUgcmVzaXplIHJlY3QgdG8gYSBtaW5pbXVtIG9mIDB4MFxuICAgKiAgIC8vICduZWdhdGUnIHdpbGwgYWxsb3cgdGhlIHJlY3QgdG8gaGF2ZSBuZWdhdGl2ZSB3aWR0aC9oZWlnaHRcbiAgICogICAvLyAncmVwb3NpdGlvbicgd2lsbCBrZWVwIHRoZSB3aWR0aC9oZWlnaHQgcG9zaXRpdmUgYnkgc3dhcHBpbmdcbiAgICogICAvLyB0aGUgdG9wIGFuZCBib3R0b20gZWRnZXMgYW5kL29yIHN3YXBwaW5nIHRoZSBsZWZ0IGFuZCByaWdodCBlZGdlc1xuICAgKiAgIGludmVydDogJ25vbmUnIHx8ICduZWdhdGUnIHx8ICdyZXBvc2l0aW9uJ1xuICAgKlxuICAgKiAgIC8vIGxpbWl0IG11bHRpcGxlIHJlc2l6ZXMuXG4gICAqICAgLy8gU2VlIHRoZSBleHBsYW5hdGlvbiBpbiB0aGUge0BsaW5rIEludGVyYWN0YWJsZS5kcmFnZ2FibGV9IGV4YW1wbGVcbiAgICogICBtYXg6IEluZmluaXR5LFxuICAgKiAgIG1heFBlckVsZW1lbnQ6IDEsXG4gICAqIH0pXG4gICAqXG4gICAqIHZhciBpc1Jlc2l6ZWFibGUgPSBpbnRlcmFjdChlbGVtZW50KS5yZXNpemFibGUoKVxuICAgKiBgYGBcbiAgICpcbiAgICogR2V0cyBvciBzZXRzIHdoZXRoZXIgcmVzaXplIGFjdGlvbnMgY2FuIGJlIHBlcmZvcm1lZCBvbiB0aGUgdGFyZ2V0XG4gICAqXG4gICAqIEBwYXJhbSB7Ym9vbGVhbiB8IG9iamVjdH0gW29wdGlvbnNdIHRydWUvZmFsc2Ugb3IgQW4gb2JqZWN0IHdpdGggZXZlbnRcbiAgICogbGlzdGVuZXJzIHRvIGJlIGZpcmVkIG9uIHJlc2l6ZSBldmVudHMgKG9iamVjdCBtYWtlcyB0aGUgSW50ZXJhY3RhYmxlXG4gICAqIHJlc2l6YWJsZSlcbiAgICogQHJldHVybiB7Ym9vbGVhbiB8IEludGVyYWN0YWJsZX0gQSBib29sZWFuIGluZGljYXRpbmcgaWYgdGhpcyBjYW4gYmUgdGhlXG4gICAqIHRhcmdldCBvZiByZXNpemUgZWxlbWVudHMsIG9yIHRoaXMgSW50ZXJhY3RhYmxlXG4gICAqL1xuICBJbnRlcmFjdGFibGUucHJvdG90eXBlLnJlc2l6YWJsZSA9IGZ1bmN0aW9uICh0aGlzOiBJbnRlcmFjdC5JbnRlcmFjdGFibGUsIG9wdGlvbnM6IEludGVyYWN0LlJlc2l6YWJsZU9wdGlvbnMgfCBib29sZWFuKSB7XG4gICAgcmV0dXJuIHJlc2l6YWJsZSh0aGlzLCBvcHRpb25zLCBzY29wZSlcbiAgfSBhcyBSZXNpemFibGVNZXRob2RcblxuICBhY3Rpb25zLm1hcC5yZXNpemUgPSByZXNpemVcbiAgYWN0aW9ucy5tZXRob2REaWN0LnJlc2l6ZSA9ICdyZXNpemFibGUnXG5cbiAgZGVmYXVsdHMuYWN0aW9ucy5yZXNpemUgPSByZXNpemUuZGVmYXVsdHNcbn1cblxuZnVuY3Rpb24gcmVzaXplQ2hlY2tlciAoYXJnKSB7XG4gIGNvbnN0IHsgaW50ZXJhY3Rpb24sIGludGVyYWN0YWJsZSwgZWxlbWVudCwgcmVjdCwgYnV0dG9ucyB9ID0gYXJnXG5cbiAgaWYgKCFyZWN0KSB7IHJldHVybiB1bmRlZmluZWQgfVxuXG4gIGNvbnN0IHBhZ2UgPSBleHRlbmQoe30sIGludGVyYWN0aW9uLmNvb3Jkcy5jdXIucGFnZSlcbiAgY29uc3QgcmVzaXplT3B0aW9ucyA9IGludGVyYWN0YWJsZS5vcHRpb25zLnJlc2l6ZVxuXG4gIGlmIChcbiAgICAhKHJlc2l6ZU9wdGlvbnMgJiYgcmVzaXplT3B0aW9ucy5lbmFibGVkKSB8fFxuICAgIC8vIGNoZWNrIG1vdXNlQnV0dG9uIHNldHRpbmcgaWYgdGhlIHBvaW50ZXIgaXMgZG93blxuICAgIChpbnRlcmFjdGlvbi5wb2ludGVySXNEb3duICYmXG4gICAgIC9tb3VzZXxwb2ludGVyLy50ZXN0KGludGVyYWN0aW9uLnBvaW50ZXJUeXBlKSAmJlxuICAgKGJ1dHRvbnMgJiByZXNpemVPcHRpb25zLm1vdXNlQnV0dG9ucykgPT09IDApXG4gICkge1xuICAgIHJldHVybiB1bmRlZmluZWRcbiAgfVxuXG4gIC8vIGlmIHVzaW5nIHJlc2l6ZS5lZGdlc1xuICBpZiAoaXMub2JqZWN0KHJlc2l6ZU9wdGlvbnMuZWRnZXMpKSB7XG4gICAgY29uc3QgcmVzaXplRWRnZXMgPSB7XG4gICAgICBsZWZ0OiBmYWxzZSxcbiAgICAgIHJpZ2h0OiBmYWxzZSxcbiAgICAgIHRvcDogZmFsc2UsXG4gICAgICBib3R0b206IGZhbHNlLFxuICAgIH1cblxuICAgIGZvciAoY29uc3QgZWRnZSBpbiByZXNpemVFZGdlcykge1xuICAgICAgcmVzaXplRWRnZXNbZWRnZV0gPSBjaGVja1Jlc2l6ZUVkZ2UoZWRnZSxcbiAgICAgICAgcmVzaXplT3B0aW9ucy5lZGdlc1tlZGdlXSxcbiAgICAgICAgcGFnZSxcbiAgICAgICAgaW50ZXJhY3Rpb24uX2xhdGVzdFBvaW50ZXIuZXZlbnRUYXJnZXQsXG4gICAgICAgIGVsZW1lbnQsXG4gICAgICAgIHJlY3QsXG4gICAgICAgIHJlc2l6ZU9wdGlvbnMubWFyZ2luIHx8IHJlc2l6ZS5kZWZhdWx0TWFyZ2luKVxuICAgIH1cblxuICAgIHJlc2l6ZUVkZ2VzLmxlZnQgPSByZXNpemVFZGdlcy5sZWZ0ICYmICFyZXNpemVFZGdlcy5yaWdodFxuICAgIHJlc2l6ZUVkZ2VzLnRvcCAgPSByZXNpemVFZGdlcy50b3AgICYmICFyZXNpemVFZGdlcy5ib3R0b21cblxuICAgIGlmIChyZXNpemVFZGdlcy5sZWZ0IHx8IHJlc2l6ZUVkZ2VzLnJpZ2h0IHx8IHJlc2l6ZUVkZ2VzLnRvcCB8fCByZXNpemVFZGdlcy5ib3R0b20pIHtcbiAgICAgIGFyZy5hY3Rpb24gPSB7XG4gICAgICAgIG5hbWU6ICdyZXNpemUnLFxuICAgICAgICBlZGdlczogcmVzaXplRWRnZXMsXG4gICAgICB9XG4gICAgfVxuICB9XG4gIGVsc2Uge1xuICAgIGNvbnN0IHJpZ2h0ICA9IHJlc2l6ZU9wdGlvbnMuYXhpcyAhPT0gJ3knICYmIHBhZ2UueCA+IChyZWN0LnJpZ2h0ICAtIHJlc2l6ZS5kZWZhdWx0TWFyZ2luKVxuICAgIGNvbnN0IGJvdHRvbSA9IHJlc2l6ZU9wdGlvbnMuYXhpcyAhPT0gJ3gnICYmIHBhZ2UueSA+IChyZWN0LmJvdHRvbSAtIHJlc2l6ZS5kZWZhdWx0TWFyZ2luKVxuXG4gICAgaWYgKHJpZ2h0IHx8IGJvdHRvbSkge1xuICAgICAgYXJnLmFjdGlvbiA9IHtcbiAgICAgICAgbmFtZTogJ3Jlc2l6ZScsXG4gICAgICAgIGF4ZXM6IChyaWdodCA/ICd4JyA6ICcnKSArIChib3R0b20gPyAneScgOiAnJyksXG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIGFyZy5hY3Rpb24gPyBmYWxzZSA6IHVuZGVmaW5lZFxufVxuXG5mdW5jdGlvbiByZXNpemFibGUgKGludGVyYWN0YWJsZTogSW50ZXJhY3QuSW50ZXJhY3RhYmxlLCBvcHRpb25zOiBJbnRlcmFjdC5PckJvb2xlYW48SW50ZXJhY3QuUmVzaXphYmxlT3B0aW9ucz4gfCBib29sZWFuLCBzY29wZTogU2NvcGUpIHtcbiAgaWYgKGlzLm9iamVjdChvcHRpb25zKSkge1xuICAgIGludGVyYWN0YWJsZS5vcHRpb25zLnJlc2l6ZS5lbmFibGVkID0gb3B0aW9ucy5lbmFibGVkICE9PSBmYWxzZVxuICAgIGludGVyYWN0YWJsZS5zZXRQZXJBY3Rpb24oJ3Jlc2l6ZScsIG9wdGlvbnMpXG4gICAgaW50ZXJhY3RhYmxlLnNldE9uRXZlbnRzKCdyZXNpemUnLCBvcHRpb25zKVxuXG4gICAgaWYgKGlzLnN0cmluZyhvcHRpb25zLmF4aXMpICYmIC9eeCR8XnkkfF54eSQvLnRlc3Qob3B0aW9ucy5heGlzKSkge1xuICAgICAgaW50ZXJhY3RhYmxlLm9wdGlvbnMucmVzaXplLmF4aXMgPSBvcHRpb25zLmF4aXNcbiAgICB9XG4gICAgZWxzZSBpZiAob3B0aW9ucy5heGlzID09PSBudWxsKSB7XG4gICAgICBpbnRlcmFjdGFibGUub3B0aW9ucy5yZXNpemUuYXhpcyA9IHNjb3BlLmRlZmF1bHRzLmFjdGlvbnMucmVzaXplLmF4aXNcbiAgICB9XG5cbiAgICBpZiAoaXMuYm9vbChvcHRpb25zLnByZXNlcnZlQXNwZWN0UmF0aW8pKSB7XG4gICAgICBpbnRlcmFjdGFibGUub3B0aW9ucy5yZXNpemUucHJlc2VydmVBc3BlY3RSYXRpbyA9IG9wdGlvbnMucHJlc2VydmVBc3BlY3RSYXRpb1xuICAgIH1cbiAgICBlbHNlIGlmIChpcy5ib29sKG9wdGlvbnMuc3F1YXJlKSkge1xuICAgICAgaW50ZXJhY3RhYmxlLm9wdGlvbnMucmVzaXplLnNxdWFyZSA9IG9wdGlvbnMuc3F1YXJlXG4gICAgfVxuXG4gICAgcmV0dXJuIGludGVyYWN0YWJsZVxuICB9XG4gIGlmIChpcy5ib29sKG9wdGlvbnMpKSB7XG4gICAgaW50ZXJhY3RhYmxlLm9wdGlvbnMucmVzaXplLmVuYWJsZWQgPSBvcHRpb25zXG5cbiAgICByZXR1cm4gaW50ZXJhY3RhYmxlXG4gIH1cbiAgcmV0dXJuIGludGVyYWN0YWJsZS5vcHRpb25zLnJlc2l6ZVxufVxuXG5mdW5jdGlvbiBjaGVja1Jlc2l6ZUVkZ2UgKFxuICBuYW1lOiBzdHJpbmcsXG4gIHZhbHVlOiBhbnksXG4gIHBhZ2U6IEludGVyYWN0LlBvaW50LFxuICBlbGVtZW50OiBOb2RlLFxuICBpbnRlcmFjdGFibGVFbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50LFxuICByZWN0OiBJbnRlcmFjdC5SZWN0LFxuICBtYXJnaW46IG51bWJlcixcbikge1xuICAvLyBmYWxzZSwgJycsIHVuZGVmaW5lZCwgbnVsbFxuICBpZiAoIXZhbHVlKSB7IHJldHVybiBmYWxzZSB9XG5cbiAgLy8gdHJ1ZSB2YWx1ZSwgdXNlIHBvaW50ZXIgY29vcmRzIGFuZCBlbGVtZW50IHJlY3RcbiAgaWYgKHZhbHVlID09PSB0cnVlKSB7XG4gICAgLy8gaWYgZGltZW5zaW9ucyBhcmUgbmVnYXRpdmUsIFwic3dpdGNoXCIgZWRnZXNcbiAgICBjb25zdCB3aWR0aCAgPSBpcy5udW1iZXIocmVjdC53aWR0aCkgPyByZWN0LndpZHRoICA6IHJlY3QucmlnaHQgIC0gcmVjdC5sZWZ0XG4gICAgY29uc3QgaGVpZ2h0ID0gaXMubnVtYmVyKHJlY3QuaGVpZ2h0KSA/IHJlY3QuaGVpZ2h0IDogcmVjdC5ib3R0b20gLSByZWN0LnRvcFxuXG4gICAgLy8gZG9uJ3QgdXNlIG1hcmdpbiBncmVhdGVyIHRoYW4gaGFsZiB0aGUgcmVsZXZlbnQgZGltZW5zaW9uXG4gICAgbWFyZ2luID0gTWF0aC5taW4obWFyZ2luLCAobmFtZSA9PT0gJ2xlZnQnIHx8IG5hbWUgPT09ICdyaWdodCcgPyB3aWR0aCA6IGhlaWdodCkgLyAyKVxuXG4gICAgaWYgKHdpZHRoIDwgMCkge1xuICAgICAgaWYgICAgICAobmFtZSA9PT0gJ2xlZnQnKSAgeyBuYW1lID0gJ3JpZ2h0JyB9XG4gICAgICBlbHNlIGlmIChuYW1lID09PSAncmlnaHQnKSB7IG5hbWUgPSAnbGVmdCcgIH1cbiAgICB9XG4gICAgaWYgKGhlaWdodCA8IDApIHtcbiAgICAgIGlmICAgICAgKG5hbWUgPT09ICd0b3AnKSAgICB7IG5hbWUgPSAnYm90dG9tJyB9XG4gICAgICBlbHNlIGlmIChuYW1lID09PSAnYm90dG9tJykgeyBuYW1lID0gJ3RvcCcgICAgfVxuICAgIH1cblxuICAgIGlmIChuYW1lID09PSAnbGVmdCcpIHsgcmV0dXJuIHBhZ2UueCA8ICgod2lkdGggID49IDAgPyByZWN0LmxlZnQgOiByZWN0LnJpZ2h0KSArIG1hcmdpbikgfVxuICAgIGlmIChuYW1lID09PSAndG9wJykgeyByZXR1cm4gcGFnZS55IDwgKChoZWlnaHQgPj0gMCA/IHJlY3QudG9wIDogcmVjdC5ib3R0b20pICsgbWFyZ2luKSB9XG5cbiAgICBpZiAobmFtZSA9PT0gJ3JpZ2h0JykgeyByZXR1cm4gcGFnZS54ID4gKCh3aWR0aCAgPj0gMCA/IHJlY3QucmlnaHQgOiByZWN0LmxlZnQpIC0gbWFyZ2luKSB9XG4gICAgaWYgKG5hbWUgPT09ICdib3R0b20nKSB7IHJldHVybiBwYWdlLnkgPiAoKGhlaWdodCA+PSAwID8gcmVjdC5ib3R0b20gOiByZWN0LnRvcCkgLSBtYXJnaW4pIH1cbiAgfVxuXG4gIC8vIHRoZSByZW1haW5pbmcgY2hlY2tzIHJlcXVpcmUgYW4gZWxlbWVudFxuICBpZiAoIWlzLmVsZW1lbnQoZWxlbWVudCkpIHsgcmV0dXJuIGZhbHNlIH1cblxuICByZXR1cm4gaXMuZWxlbWVudCh2YWx1ZSlcbiAgLy8gdGhlIHZhbHVlIGlzIGFuIGVsZW1lbnQgdG8gdXNlIGFzIGEgcmVzaXplIGhhbmRsZVxuICAgID8gdmFsdWUgPT09IGVsZW1lbnRcbiAgICAvLyBvdGhlcndpc2UgY2hlY2sgaWYgZWxlbWVudCBtYXRjaGVzIHZhbHVlIGFzIHNlbGVjdG9yXG4gICAgOiBkb20ubWF0Y2hlc1VwVG8oZWxlbWVudCwgdmFsdWUsIGludGVyYWN0YWJsZUVsZW1lbnQpXG59XG5cbmZ1bmN0aW9uIGluaXRDdXJzb3JzIChicm93c2VyOiB0eXBlb2YgaW1wb3J0ICgnQGludGVyYWN0anMvdXRpbHMvYnJvd3NlcicpLmRlZmF1bHQpIHtcbiAgcmV0dXJuIChicm93c2VyLmlzSWU5ID8ge1xuICAgIHggOiAnZS1yZXNpemUnLFxuICAgIHkgOiAncy1yZXNpemUnLFxuICAgIHh5OiAnc2UtcmVzaXplJyxcblxuICAgIHRvcCAgICAgICAgOiAnbi1yZXNpemUnLFxuICAgIGxlZnQgICAgICAgOiAndy1yZXNpemUnLFxuICAgIGJvdHRvbSAgICAgOiAncy1yZXNpemUnLFxuICAgIHJpZ2h0ICAgICAgOiAnZS1yZXNpemUnLFxuICAgIHRvcGxlZnQgICAgOiAnc2UtcmVzaXplJyxcbiAgICBib3R0b21yaWdodDogJ3NlLXJlc2l6ZScsXG4gICAgdG9wcmlnaHQgICA6ICduZS1yZXNpemUnLFxuICAgIGJvdHRvbWxlZnQgOiAnbmUtcmVzaXplJyxcbiAgfSA6IHtcbiAgICB4IDogJ2V3LXJlc2l6ZScsXG4gICAgeSA6ICducy1yZXNpemUnLFxuICAgIHh5OiAnbndzZS1yZXNpemUnLFxuXG4gICAgdG9wICAgICAgICA6ICducy1yZXNpemUnLFxuICAgIGxlZnQgICAgICAgOiAnZXctcmVzaXplJyxcbiAgICBib3R0b20gICAgIDogJ25zLXJlc2l6ZScsXG4gICAgcmlnaHQgICAgICA6ICdldy1yZXNpemUnLFxuICAgIHRvcGxlZnQgICAgOiAnbndzZS1yZXNpemUnLFxuICAgIGJvdHRvbXJpZ2h0OiAnbndzZS1yZXNpemUnLFxuICAgIHRvcHJpZ2h0ICAgOiAnbmVzdy1yZXNpemUnLFxuICAgIGJvdHRvbWxlZnQgOiAnbmVzdy1yZXNpemUnLFxuICB9KVxufVxuXG5mdW5jdGlvbiBzdGFydCAoeyBpRXZlbnQsIGludGVyYWN0aW9uIH06IHsgaUV2ZW50OiBJbnRlcmFjdC5JbnRlcmFjdEV2ZW50PGFueSwgYW55PiwgaW50ZXJhY3Rpb246IEludGVyYWN0aW9uIH0pIHtcbiAgaWYgKGludGVyYWN0aW9uLnByZXBhcmVkLm5hbWUgIT09ICdyZXNpemUnIHx8ICFpbnRlcmFjdGlvbi5wcmVwYXJlZC5lZGdlcykge1xuICAgIHJldHVyblxuICB9XG5cbiAgY29uc3QgcmVzaXplRXZlbnQgPSBpRXZlbnQgYXMgUmVzaXplRXZlbnRcbiAgY29uc3QgcmVjdCA9IGludGVyYWN0aW9uLnJlY3RcblxuICBpbnRlcmFjdGlvbi5fcmVjdHMgPSB7XG4gICAgc3RhcnQ6IGV4dGVuZCh7fSwgcmVjdCksXG4gICAgY29ycmVjdGVkOiBleHRlbmQoe30sIHJlY3QpLFxuICAgIHByZXZpb3VzOiBleHRlbmQoe30sIHJlY3QpLFxuICAgIGRlbHRhOiB7XG4gICAgICBsZWZ0OiAwLFxuICAgICAgcmlnaHQgOiAwLFxuICAgICAgd2lkdGggOiAwLFxuICAgICAgdG9wIDogMCxcbiAgICAgIGJvdHRvbTogMCxcbiAgICAgIGhlaWdodDogMCxcbiAgICB9LFxuICB9XG5cbiAgcmVzaXplRXZlbnQuZWRnZXMgPSBpbnRlcmFjdGlvbi5wcmVwYXJlZC5lZGdlc1xuICByZXNpemVFdmVudC5yZWN0ID0gaW50ZXJhY3Rpb24uX3JlY3RzLmNvcnJlY3RlZFxuICByZXNpemVFdmVudC5kZWx0YVJlY3QgPSBpbnRlcmFjdGlvbi5fcmVjdHMuZGVsdGFcbn1cblxuZnVuY3Rpb24gbW92ZSAoeyBpRXZlbnQsIGludGVyYWN0aW9uIH06IHsgaUV2ZW50OiBJbnRlcmFjdC5JbnRlcmFjdEV2ZW50PGFueSwgYW55PiwgaW50ZXJhY3Rpb246IEludGVyYWN0aW9uIH0pIHtcbiAgaWYgKGludGVyYWN0aW9uLnByZXBhcmVkLm5hbWUgIT09ICdyZXNpemUnIHx8ICFpbnRlcmFjdGlvbi5wcmVwYXJlZC5lZGdlcykgeyByZXR1cm4gfVxuXG4gIGNvbnN0IHJlc2l6ZUV2ZW50ID0gaUV2ZW50IGFzIFJlc2l6ZUV2ZW50XG4gIGNvbnN0IHJlc2l6ZU9wdGlvbnMgPSBpbnRlcmFjdGlvbi5pbnRlcmFjdGFibGUub3B0aW9ucy5yZXNpemVcbiAgY29uc3QgaW52ZXJ0ID0gcmVzaXplT3B0aW9ucy5pbnZlcnRcbiAgY29uc3QgaW52ZXJ0aWJsZSA9IGludmVydCA9PT0gJ3JlcG9zaXRpb24nIHx8IGludmVydCA9PT0gJ25lZ2F0ZSdcblxuICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tc2hhZG93XG4gIGNvbnN0IGN1cnJlbnQgPSBpbnRlcmFjdGlvbi5yZWN0XG4gIGNvbnN0IHsgc3RhcnQ6IHN0YXJ0UmVjdCwgY29ycmVjdGVkLCBkZWx0YTogZGVsdGFSZWN0LCBwcmV2aW91cyB9ID0gaW50ZXJhY3Rpb24uX3JlY3RzXG5cbiAgZXh0ZW5kKHByZXZpb3VzLCBjb3JyZWN0ZWQpXG5cbiAgaWYgKGludmVydGlibGUpIHtcbiAgICAvLyBpZiBpbnZlcnRpYmxlLCBjb3B5IHRoZSBjdXJyZW50IHJlY3RcbiAgICBleHRlbmQoY29ycmVjdGVkLCBjdXJyZW50KVxuXG4gICAgaWYgKGludmVydCA9PT0gJ3JlcG9zaXRpb24nKSB7XG4gICAgICAvLyBzd2FwIGVkZ2UgdmFsdWVzIGlmIG5lY2Vzc2FyeSB0byBrZWVwIHdpZHRoL2hlaWdodCBwb3NpdGl2ZVxuICAgICAgaWYgKGNvcnJlY3RlZC50b3AgPiBjb3JyZWN0ZWQuYm90dG9tKSB7XG4gICAgICAgIGNvbnN0IHN3YXAgPSBjb3JyZWN0ZWQudG9wXG5cbiAgICAgICAgY29ycmVjdGVkLnRvcCA9IGNvcnJlY3RlZC5ib3R0b21cbiAgICAgICAgY29ycmVjdGVkLmJvdHRvbSA9IHN3YXBcbiAgICAgIH1cbiAgICAgIGlmIChjb3JyZWN0ZWQubGVmdCA+IGNvcnJlY3RlZC5yaWdodCkge1xuICAgICAgICBjb25zdCBzd2FwID0gY29ycmVjdGVkLmxlZnRcblxuICAgICAgICBjb3JyZWN0ZWQubGVmdCA9IGNvcnJlY3RlZC5yaWdodFxuICAgICAgICBjb3JyZWN0ZWQucmlnaHQgPSBzd2FwXG4gICAgICB9XG4gICAgfVxuICB9XG4gIGVsc2Uge1xuICAgIC8vIGlmIG5vdCBpbnZlcnRpYmxlLCByZXN0cmljdCB0byBtaW5pbXVtIG9mIDB4MCByZWN0XG4gICAgY29ycmVjdGVkLnRvcCAgICA9IE1hdGgubWluKGN1cnJlbnQudG9wLCBzdGFydFJlY3QuYm90dG9tKVxuICAgIGNvcnJlY3RlZC5ib3R0b20gPSBNYXRoLm1heChjdXJyZW50LmJvdHRvbSwgc3RhcnRSZWN0LnRvcClcbiAgICBjb3JyZWN0ZWQubGVmdCAgID0gTWF0aC5taW4oY3VycmVudC5sZWZ0LCBzdGFydFJlY3QucmlnaHQpXG4gICAgY29ycmVjdGVkLnJpZ2h0ICA9IE1hdGgubWF4KGN1cnJlbnQucmlnaHQsIHN0YXJ0UmVjdC5sZWZ0KVxuICB9XG5cbiAgY29ycmVjdGVkLndpZHRoICA9IGNvcnJlY3RlZC5yaWdodCAgLSBjb3JyZWN0ZWQubGVmdFxuICBjb3JyZWN0ZWQuaGVpZ2h0ID0gY29ycmVjdGVkLmJvdHRvbSAtIGNvcnJlY3RlZC50b3BcblxuICBmb3IgKGNvbnN0IGVkZ2UgaW4gY29ycmVjdGVkKSB7XG4gICAgZGVsdGFSZWN0W2VkZ2VdID0gY29ycmVjdGVkW2VkZ2VdIC0gcHJldmlvdXNbZWRnZV1cbiAgfVxuXG4gIHJlc2l6ZUV2ZW50LmVkZ2VzID0gaW50ZXJhY3Rpb24ucHJlcGFyZWQuZWRnZXNcbiAgcmVzaXplRXZlbnQucmVjdCA9IGNvcnJlY3RlZFxuICByZXNpemVFdmVudC5kZWx0YVJlY3QgPSBkZWx0YVJlY3Rcbn1cblxuZnVuY3Rpb24gZW5kICh7IGlFdmVudCwgaW50ZXJhY3Rpb24gfTogeyBpRXZlbnQ6IEludGVyYWN0LkludGVyYWN0RXZlbnQ8YW55LCBhbnk+LCBpbnRlcmFjdGlvbjogSW50ZXJhY3Rpb24gfSkge1xuICBpZiAoaW50ZXJhY3Rpb24ucHJlcGFyZWQubmFtZSAhPT0gJ3Jlc2l6ZScgfHwgIWludGVyYWN0aW9uLnByZXBhcmVkLmVkZ2VzKSB7IHJldHVybiB9XG5cbiAgY29uc3QgcmVzaXplRXZlbnQgPSBpRXZlbnQgYXMgUmVzaXplRXZlbnRcblxuICByZXNpemVFdmVudC5lZGdlcyA9IGludGVyYWN0aW9uLnByZXBhcmVkLmVkZ2VzXG4gIHJlc2l6ZUV2ZW50LnJlY3QgPSBpbnRlcmFjdGlvbi5fcmVjdHMuY29ycmVjdGVkXG4gIHJlc2l6ZUV2ZW50LmRlbHRhUmVjdCA9IGludGVyYWN0aW9uLl9yZWN0cy5kZWx0YVxufVxuXG5mdW5jdGlvbiB1cGRhdGVFdmVudEF4ZXMgKHsgaUV2ZW50LCBpbnRlcmFjdGlvbiB9OiB7IGlFdmVudDogSW50ZXJhY3QuSW50ZXJhY3RFdmVudDxhbnksIGFueT4sIGludGVyYWN0aW9uOiBJbnRlcmFjdGlvbiB9KSB7XG4gIGlmIChpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lICE9PSAncmVzaXplJyB8fCAhaW50ZXJhY3Rpb24ucmVzaXplQXhlcykgeyByZXR1cm4gfVxuXG4gIGNvbnN0IG9wdGlvbnMgPSBpbnRlcmFjdGlvbi5pbnRlcmFjdGFibGUub3B0aW9uc1xuICBjb25zdCByZXNpemVFdmVudCA9IGlFdmVudCBhcyBSZXNpemVFdmVudFxuXG4gIGlmIChvcHRpb25zLnJlc2l6ZS5zcXVhcmUpIHtcbiAgICBpZiAoaW50ZXJhY3Rpb24ucmVzaXplQXhlcyA9PT0gJ3knKSB7XG4gICAgICByZXNpemVFdmVudC5kZWx0YS54ID0gcmVzaXplRXZlbnQuZGVsdGEueVxuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHJlc2l6ZUV2ZW50LmRlbHRhLnkgPSByZXNpemVFdmVudC5kZWx0YS54XG4gICAgfVxuICAgIHJlc2l6ZUV2ZW50LmF4ZXMgPSAneHknXG4gIH1cbiAgZWxzZSB7XG4gICAgcmVzaXplRXZlbnQuYXhlcyA9IGludGVyYWN0aW9uLnJlc2l6ZUF4ZXNcblxuICAgIGlmIChpbnRlcmFjdGlvbi5yZXNpemVBeGVzID09PSAneCcpIHtcbiAgICAgIHJlc2l6ZUV2ZW50LmRlbHRhLnkgPSAwXG4gICAgfVxuICAgIGVsc2UgaWYgKGludGVyYWN0aW9uLnJlc2l6ZUF4ZXMgPT09ICd5Jykge1xuICAgICAgcmVzaXplRXZlbnQuZGVsdGEueCA9IDBcbiAgICB9XG4gIH1cbn1cblxuY29uc3QgcmVzaXplOiBJbnRlcmFjdC5QbHVnaW4gPSB7XG4gIGlkOiAnYWN0aW9ucy9yZXNpemUnLFxuICBiZWZvcmU6IFsnYWN0aW9ucy9kcmFnJ10sXG4gIGluc3RhbGwsXG4gIGxpc3RlbmVyczoge1xuICAgICdpbnRlcmFjdGlvbnM6bmV3JzogKHsgaW50ZXJhY3Rpb24gfSkgPT4ge1xuICAgICAgaW50ZXJhY3Rpb24ucmVzaXplQXhlcyA9ICd4eSdcbiAgICB9LFxuXG4gICAgJ2ludGVyYWN0aW9uczphY3Rpb24tc3RhcnQnOiBhcmcgPT4ge1xuICAgICAgc3RhcnQoYXJnKVxuICAgICAgdXBkYXRlRXZlbnRBeGVzKGFyZylcbiAgICB9LFxuICAgICdpbnRlcmFjdGlvbnM6YWN0aW9uLW1vdmUnOiBhcmcgPT4ge1xuICAgICAgbW92ZShhcmcpXG4gICAgICB1cGRhdGVFdmVudEF4ZXMoYXJnKVxuICAgIH0sXG4gICAgJ2ludGVyYWN0aW9uczphY3Rpb24tZW5kJzogZW5kLFxuICAgICdhdXRvLXN0YXJ0OmNoZWNrJzogcmVzaXplQ2hlY2tlcixcbiAgfSxcblxuICBkZWZhdWx0czoge1xuICAgIHNxdWFyZTogZmFsc2UsXG4gICAgcHJlc2VydmVBc3BlY3RSYXRpbzogZmFsc2UsXG4gICAgYXhpczogJ3h5JyxcblxuICAgIC8vIHVzZSBkZWZhdWx0IG1hcmdpblxuICAgIG1hcmdpbjogTmFOLFxuXG4gICAgLy8gb2JqZWN0IHdpdGggcHJvcHMgbGVmdCwgcmlnaHQsIHRvcCwgYm90dG9tIHdoaWNoIGFyZVxuICAgIC8vIHRydWUvZmFsc2UgdmFsdWVzIHRvIHJlc2l6ZSB3aGVuIHRoZSBwb2ludGVyIGlzIG92ZXIgdGhhdCBlZGdlLFxuICAgIC8vIENTUyBzZWxlY3RvcnMgdG8gbWF0Y2ggdGhlIGhhbmRsZXMgZm9yIGVhY2ggZGlyZWN0aW9uXG4gICAgLy8gb3IgdGhlIEVsZW1lbnRzIGZvciBlYWNoIGhhbmRsZVxuICAgIGVkZ2VzOiBudWxsLFxuXG4gICAgLy8gYSB2YWx1ZSBvZiAnbm9uZScgd2lsbCBsaW1pdCB0aGUgcmVzaXplIHJlY3QgdG8gYSBtaW5pbXVtIG9mIDB4MFxuICAgIC8vICduZWdhdGUnIHdpbGwgYWxvdyB0aGUgcmVjdCB0byBoYXZlIG5lZ2F0aXZlIHdpZHRoL2hlaWdodFxuICAgIC8vICdyZXBvc2l0aW9uJyB3aWxsIGtlZXAgdGhlIHdpZHRoL2hlaWdodCBwb3NpdGl2ZSBieSBzd2FwcGluZ1xuICAgIC8vIHRoZSB0b3AgYW5kIGJvdHRvbSBlZGdlcyBhbmQvb3Igc3dhcHBpbmcgdGhlIGxlZnQgYW5kIHJpZ2h0IGVkZ2VzXG4gICAgaW52ZXJ0OiAnbm9uZScsXG4gIH0gYXMgSW50ZXJhY3QuUmVzaXphYmxlT3B0aW9ucyxcblxuICBjdXJzb3JzOiBudWxsIGFzIFJldHVyblR5cGU8dHlwZW9mIGluaXRDdXJzb3JzPixcblxuICBnZXRDdXJzb3IgKHsgZWRnZXMsIGF4aXMsIG5hbWUgfTogSW50ZXJhY3QuQWN0aW9uUHJvcHMpIHtcbiAgICBjb25zdCBjdXJzb3JzID0gcmVzaXplLmN1cnNvcnNcbiAgICBsZXQgcmVzdWx0OiBzdHJpbmcgPSBudWxsXG5cbiAgICBpZiAoYXhpcykge1xuICAgICAgcmVzdWx0ID0gY3Vyc29yc1tuYW1lICsgYXhpc11cbiAgICB9XG4gICAgZWxzZSBpZiAoZWRnZXMpIHtcbiAgICAgIGxldCBjdXJzb3JLZXkgPSAnJ1xuXG4gICAgICBmb3IgKGNvbnN0IGVkZ2Ugb2YgWyd0b3AnLCAnYm90dG9tJywgJ2xlZnQnLCAncmlnaHQnXSkge1xuICAgICAgICBpZiAoZWRnZXNbZWRnZV0pIHtcbiAgICAgICAgICBjdXJzb3JLZXkgKz0gZWRnZVxuICAgICAgICB9XG4gICAgICB9XG5cbiAgICAgIHJlc3VsdCA9IGN1cnNvcnNbY3Vyc29yS2V5XVxuICAgIH1cblxuICAgIHJldHVybiByZXN1bHRcbiAgfSxcblxuICBkZWZhdWx0TWFyZ2luOiBudWxsIGFzIG51bWJlcixcbn1cblxuZXhwb3J0IGRlZmF1bHQgcmVzaXplXG4iLCJpbXBvcnQgeyBTY29wZSB9IGZyb20gJ0BpbnRlcmFjdGpzL2NvcmUvc2NvcGUnXG5pbXBvcnQgZHJhZyBmcm9tICcuL2RyYWcnXG5pbXBvcnQgZHJvcCBmcm9tICcuL2Ryb3AvaW5kZXgnXG5pbXBvcnQgZ2VzdHVyZSBmcm9tICcuL2dlc3R1cmUnXG5pbXBvcnQgcmVzaXplIGZyb20gJy4vcmVzaXplJ1xuXG5leHBvcnQgZGVmYXVsdCB7XG4gIGlkOiAnYWN0aW9ucycsXG4gIGluc3RhbGwgKHNjb3BlOiBTY29wZSkge1xuICAgIHNjb3BlLnVzZVBsdWdpbihnZXN0dXJlKVxuICAgIHNjb3BlLnVzZVBsdWdpbihyZXNpemUpXG4gICAgc2NvcGUudXNlUGx1Z2luKGRyYWcpXG4gICAgc2NvcGUudXNlUGx1Z2luKGRyb3ApXG4gIH0sXG59XG5cbmV4cG9ydCB7XG4gIGdlc3R1cmUsXG4gIHJlc2l6ZSxcbiAgZHJhZyxcbiAgZHJvcCxcbn1cbiIsImltcG9ydCAqIGFzIGRvbVV0aWxzIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2RvbVV0aWxzJ1xuaW1wb3J0ICogYXMgaXMgZnJvbSAnQGludGVyYWN0anMvdXRpbHMvaXMnXG5pbXBvcnQgcmFmIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL3JhZidcbmltcG9ydCB7IGdldFN0cmluZ09wdGlvblJlc3VsdCB9IGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL3JlY3QnXG5pbXBvcnQgeyBnZXRXaW5kb3cgfSBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy93aW5kb3cnXG5cbnR5cGUgU2NvcGUgPSBpbXBvcnQgKCdAaW50ZXJhY3Rqcy9jb3JlL3Njb3BlJykuU2NvcGVcblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvc2NvcGUnIHtcbiAgaW50ZXJmYWNlIFNjb3BlIHtcbiAgICBhdXRvU2Nyb2xsOiB0eXBlb2YgYXV0b1Njcm9sbFxuICB9XG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL0ludGVyYWN0aW9uJyB7XG4gIGludGVyZmFjZSBJbnRlcmFjdGlvbiB7XG4gICAgYXV0b1Njcm9sbD86IHR5cGVvZiBhdXRvU2Nyb2xsXG4gIH1cbn1cblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvZGVmYXVsdE9wdGlvbnMnIHtcbiAgaW50ZXJmYWNlIFBlckFjdGlvbkRlZmF1bHRzIHtcbiAgICBhdXRvU2Nyb2xsPzogQXV0b1Njcm9sbE9wdGlvbnNcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIEF1dG9TY3JvbGxPcHRpb25zIHtcbiAgY29udGFpbmVyPzogV2luZG93IHwgSFRNTEVsZW1lbnRcbiAgbWFyZ2luPzogbnVtYmVyXG4gIGRpc3RhbmNlPzogbnVtYmVyXG4gIGludGVydmFsPzogbnVtYmVyXG4gIHNwZWVkPzogbnVtYmVyXG4gIGVuYWJsZWQ/OiBib29sZWFuXG59XG5cbmZ1bmN0aW9uIGluc3RhbGwgKHNjb3BlOiBTY29wZSkge1xuICBjb25zdCB7XG4gICAgZGVmYXVsdHMsXG4gICAgYWN0aW9ucyxcbiAgfSA9IHNjb3BlXG5cbiAgc2NvcGUuYXV0b1Njcm9sbCA9IGF1dG9TY3JvbGxcbiAgYXV0b1Njcm9sbC5ub3cgPSAoKSA9PiBzY29wZS5ub3coKVxuXG4gIGFjdGlvbnMucGhhc2VsZXNzVHlwZXMuYXV0b3Njcm9sbCA9IHRydWVcbiAgZGVmYXVsdHMucGVyQWN0aW9uLmF1dG9TY3JvbGwgPSBhdXRvU2Nyb2xsLmRlZmF1bHRzXG59XG5cbmNvbnN0IGF1dG9TY3JvbGwgPSB7XG4gIGRlZmF1bHRzOiB7XG4gICAgZW5hYmxlZCAgOiBmYWxzZSxcbiAgICBtYXJnaW4gICA6IDYwLFxuXG4gICAgLy8gdGhlIGl0ZW0gdGhhdCBpcyBzY3JvbGxlZCAoV2luZG93IG9yIEhUTUxFbGVtZW50KVxuICAgIGNvbnRhaW5lcjogbnVsbCBhcyBBdXRvU2Nyb2xsT3B0aW9uc1snY29udGFpbmVyJ10sXG5cbiAgICAvLyB0aGUgc2Nyb2xsIHNwZWVkIGluIHBpeGVscyBwZXIgc2Vjb25kXG4gICAgc3BlZWQgICAgOiAzMDAsXG4gIH0gYXMgQXV0b1Njcm9sbE9wdGlvbnMsXG5cbiAgbm93OiBEYXRlLm5vdyxcblxuICBpbnRlcmFjdGlvbjogbnVsbCBhcyBJbnRlcmFjdC5JbnRlcmFjdGlvbixcbiAgaTogMCwgLy8gdGhlIGhhbmRsZSByZXR1cm5lZCBieSB3aW5kb3cuc2V0SW50ZXJ2YWxcblxuICAvLyBEaXJlY3Rpb24gZWFjaCBwdWxzZSBpcyB0byBzY3JvbGwgaW5cbiAgeDogMCxcbiAgeTogMCxcblxuICBpc1Njcm9sbGluZzogZmFsc2UsXG4gIHByZXZUaW1lOiAwLFxuICBtYXJnaW46IDAsXG4gIHNwZWVkOiAwLFxuXG4gIHN0YXJ0IChpbnRlcmFjdGlvbjogSW50ZXJhY3QuSW50ZXJhY3Rpb24pIHtcbiAgICBhdXRvU2Nyb2xsLmlzU2Nyb2xsaW5nID0gdHJ1ZVxuICAgIHJhZi5jYW5jZWwoYXV0b1Njcm9sbC5pKVxuXG4gICAgaW50ZXJhY3Rpb24uYXV0b1Njcm9sbCA9IGF1dG9TY3JvbGxcbiAgICBhdXRvU2Nyb2xsLmludGVyYWN0aW9uID0gaW50ZXJhY3Rpb25cbiAgICBhdXRvU2Nyb2xsLnByZXZUaW1lID0gYXV0b1Njcm9sbC5ub3coKVxuICAgIGF1dG9TY3JvbGwuaSA9IHJhZi5yZXF1ZXN0KGF1dG9TY3JvbGwuc2Nyb2xsKVxuICB9LFxuXG4gIHN0b3AgKCkge1xuICAgIGF1dG9TY3JvbGwuaXNTY3JvbGxpbmcgPSBmYWxzZVxuICAgIGlmIChhdXRvU2Nyb2xsLmludGVyYWN0aW9uKSB7XG4gICAgICBhdXRvU2Nyb2xsLmludGVyYWN0aW9uLmF1dG9TY3JvbGwgPSBudWxsXG4gICAgfVxuICAgIHJhZi5jYW5jZWwoYXV0b1Njcm9sbC5pKVxuICB9LFxuXG4gIC8vIHNjcm9sbCB0aGUgd2luZG93IGJ5IHRoZSB2YWx1ZXMgaW4gc2Nyb2xsLngveVxuICBzY3JvbGwgKCkge1xuICAgIGNvbnN0IHsgaW50ZXJhY3Rpb24gfSA9IGF1dG9TY3JvbGxcbiAgICBjb25zdCB7IGludGVyYWN0YWJsZSwgZWxlbWVudCB9ID0gaW50ZXJhY3Rpb25cbiAgICBjb25zdCBhY3Rpb25OYW1lID0gaW50ZXJhY3Rpb24ucHJlcGFyZWQubmFtZVxuICAgIGNvbnN0IG9wdGlvbnMgPSBpbnRlcmFjdGFibGUub3B0aW9uc1thY3Rpb25OYW1lXS5hdXRvU2Nyb2xsXG4gICAgY29uc3QgY29udGFpbmVyID0gZ2V0Q29udGFpbmVyKG9wdGlvbnMuY29udGFpbmVyLCBpbnRlcmFjdGFibGUsIGVsZW1lbnQpXG4gICAgY29uc3Qgbm93ID0gYXV0b1Njcm9sbC5ub3coKVxuICAgIC8vIGNoYW5nZSBpbiB0aW1lIGluIHNlY29uZHNcbiAgICBjb25zdCBkdCA9IChub3cgLSBhdXRvU2Nyb2xsLnByZXZUaW1lKSAvIDEwMDBcbiAgICAvLyBkaXNwbGFjZW1lbnRcbiAgICBjb25zdCBzID0gb3B0aW9ucy5zcGVlZCAqIGR0XG5cbiAgICBpZiAocyA+PSAxKSB7XG4gICAgICBjb25zdCBzY3JvbGxCeSA9IHtcbiAgICAgICAgeDogYXV0b1Njcm9sbC54ICogcyxcbiAgICAgICAgeTogYXV0b1Njcm9sbC55ICogcyxcbiAgICAgIH1cblxuICAgICAgaWYgKHNjcm9sbEJ5LnggfHwgc2Nyb2xsQnkueSkge1xuICAgICAgICBjb25zdCBwcmV2U2Nyb2xsID0gZ2V0U2Nyb2xsKGNvbnRhaW5lcilcblxuICAgICAgICBpZiAoaXMud2luZG93KGNvbnRhaW5lcikpIHtcbiAgICAgICAgICBjb250YWluZXIuc2Nyb2xsQnkoc2Nyb2xsQnkueCwgc2Nyb2xsQnkueSlcbiAgICAgICAgfVxuICAgICAgICBlbHNlIGlmIChjb250YWluZXIpIHtcbiAgICAgICAgICBjb250YWluZXIuc2Nyb2xsTGVmdCArPSBzY3JvbGxCeS54XG4gICAgICAgICAgY29udGFpbmVyLnNjcm9sbFRvcCAgKz0gc2Nyb2xsQnkueVxuICAgICAgICB9XG5cbiAgICAgICAgY29uc3QgY3VyU2Nyb2xsID0gZ2V0U2Nyb2xsKGNvbnRhaW5lcilcbiAgICAgICAgY29uc3QgZGVsdGEgPSB7XG4gICAgICAgICAgeDogY3VyU2Nyb2xsLnggLSBwcmV2U2Nyb2xsLngsXG4gICAgICAgICAgeTogY3VyU2Nyb2xsLnkgLSBwcmV2U2Nyb2xsLnksXG4gICAgICAgIH1cblxuICAgICAgICBpZiAoZGVsdGEueCB8fCBkZWx0YS55KSB7XG4gICAgICAgICAgaW50ZXJhY3RhYmxlLmZpcmUoe1xuICAgICAgICAgICAgdHlwZTogJ2F1dG9zY3JvbGwnLFxuICAgICAgICAgICAgdGFyZ2V0OiBlbGVtZW50LFxuICAgICAgICAgICAgaW50ZXJhY3RhYmxlLFxuICAgICAgICAgICAgZGVsdGEsXG4gICAgICAgICAgICBpbnRlcmFjdGlvbixcbiAgICAgICAgICAgIGNvbnRhaW5lcixcbiAgICAgICAgICB9KVxuICAgICAgICB9XG4gICAgICB9XG5cbiAgICAgIGF1dG9TY3JvbGwucHJldlRpbWUgPSBub3dcbiAgICB9XG5cbiAgICBpZiAoYXV0b1Njcm9sbC5pc1Njcm9sbGluZykge1xuICAgICAgcmFmLmNhbmNlbChhdXRvU2Nyb2xsLmkpXG4gICAgICBhdXRvU2Nyb2xsLmkgPSByYWYucmVxdWVzdChhdXRvU2Nyb2xsLnNjcm9sbClcbiAgICB9XG4gIH0sXG4gIGNoZWNrIChpbnRlcmFjdGFibGU6IEludGVyYWN0LkludGVyYWN0YWJsZSwgYWN0aW9uTmFtZTogSW50ZXJhY3QuQWN0aW9uTmFtZSkge1xuICAgIGNvbnN0IG9wdGlvbnMgPSBpbnRlcmFjdGFibGUub3B0aW9uc1xuXG4gICAgcmV0dXJuIG9wdGlvbnNbYWN0aW9uTmFtZV0uYXV0b1Njcm9sbCAmJiBvcHRpb25zW2FjdGlvbk5hbWVdLmF1dG9TY3JvbGwuZW5hYmxlZFxuICB9LFxuICBvbkludGVyYWN0aW9uTW92ZTxUIGV4dGVuZHMgSW50ZXJhY3QuQWN0aW9uTmFtZT4gKHsgaW50ZXJhY3Rpb24sIHBvaW50ZXIgfTogeyBpbnRlcmFjdGlvbjogSW50ZXJhY3QuSW50ZXJhY3Rpb248VD4sIHBvaW50ZXI6IEludGVyYWN0LlBvaW50ZXJUeXBlIH0pIHtcbiAgICBpZiAoIShpbnRlcmFjdGlvbi5pbnRlcmFjdGluZygpICYmXG4gICAgICAgICAgYXV0b1Njcm9sbC5jaGVjayhpbnRlcmFjdGlvbi5pbnRlcmFjdGFibGUsIGludGVyYWN0aW9uLnByZXBhcmVkLm5hbWUpKSkge1xuICAgICAgcmV0dXJuXG4gICAgfVxuXG4gICAgaWYgKGludGVyYWN0aW9uLnNpbXVsYXRpb24pIHtcbiAgICAgIGF1dG9TY3JvbGwueCA9IGF1dG9TY3JvbGwueSA9IDBcbiAgICAgIHJldHVyblxuICAgIH1cblxuICAgIGxldCB0b3BcbiAgICBsZXQgcmlnaHRcbiAgICBsZXQgYm90dG9tXG4gICAgbGV0IGxlZnRcblxuICAgIGNvbnN0IHsgaW50ZXJhY3RhYmxlLCBlbGVtZW50IH0gPSBpbnRlcmFjdGlvblxuICAgIGNvbnN0IGFjdGlvbk5hbWUgPSBpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lXG4gICAgY29uc3Qgb3B0aW9ucyA9IGludGVyYWN0YWJsZS5vcHRpb25zW2FjdGlvbk5hbWVdLmF1dG9TY3JvbGxcbiAgICBjb25zdCBjb250YWluZXIgPSBnZXRDb250YWluZXIob3B0aW9ucy5jb250YWluZXIsIGludGVyYWN0YWJsZSwgZWxlbWVudClcblxuICAgIGlmIChpcy53aW5kb3coY29udGFpbmVyKSkge1xuICAgICAgbGVmdCAgID0gcG9pbnRlci5jbGllbnRYIDwgYXV0b1Njcm9sbC5tYXJnaW5cbiAgICAgIHRvcCAgICA9IHBvaW50ZXIuY2xpZW50WSA8IGF1dG9TY3JvbGwubWFyZ2luXG4gICAgICByaWdodCAgPSBwb2ludGVyLmNsaWVudFggPiBjb250YWluZXIuaW5uZXJXaWR0aCAgLSBhdXRvU2Nyb2xsLm1hcmdpblxuICAgICAgYm90dG9tID0gcG9pbnRlci5jbGllbnRZID4gY29udGFpbmVyLmlubmVySGVpZ2h0IC0gYXV0b1Njcm9sbC5tYXJnaW5cbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICBjb25zdCByZWN0ID0gZG9tVXRpbHMuZ2V0RWxlbWVudENsaWVudFJlY3QoY29udGFpbmVyKVxuXG4gICAgICBsZWZ0ICAgPSBwb2ludGVyLmNsaWVudFggPCByZWN0LmxlZnQgICArIGF1dG9TY3JvbGwubWFyZ2luXG4gICAgICB0b3AgICAgPSBwb2ludGVyLmNsaWVudFkgPCByZWN0LnRvcCAgICArIGF1dG9TY3JvbGwubWFyZ2luXG4gICAgICByaWdodCAgPSBwb2ludGVyLmNsaWVudFggPiByZWN0LnJpZ2h0ICAtIGF1dG9TY3JvbGwubWFyZ2luXG4gICAgICBib3R0b20gPSBwb2ludGVyLmNsaWVudFkgPiByZWN0LmJvdHRvbSAtIGF1dG9TY3JvbGwubWFyZ2luXG4gICAgfVxuXG4gICAgYXV0b1Njcm9sbC54ID0gKHJpZ2h0ID8gMSA6IGxlZnQgPyAtMSA6IDApXG4gICAgYXV0b1Njcm9sbC55ID0gKGJvdHRvbSA/IDEgOiAgdG9wID8gLTEgOiAwKVxuXG4gICAgaWYgKCFhdXRvU2Nyb2xsLmlzU2Nyb2xsaW5nKSB7XG4gICAgICAvLyBzZXQgdGhlIGF1dG9TY3JvbGwgcHJvcGVydGllcyB0byB0aG9zZSBvZiB0aGUgdGFyZ2V0XG4gICAgICBhdXRvU2Nyb2xsLm1hcmdpbiA9IG9wdGlvbnMubWFyZ2luXG4gICAgICBhdXRvU2Nyb2xsLnNwZWVkICA9IG9wdGlvbnMuc3BlZWRcblxuICAgICAgYXV0b1Njcm9sbC5zdGFydChpbnRlcmFjdGlvbilcbiAgICB9XG4gIH0sXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRDb250YWluZXIgKHZhbHVlOiBhbnksIGludGVyYWN0YWJsZTogSW50ZXJhY3QuSW50ZXJhY3RhYmxlLCBlbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50KSB7XG4gIHJldHVybiAoaXMuc3RyaW5nKHZhbHVlKSA/IGdldFN0cmluZ09wdGlvblJlc3VsdCh2YWx1ZSwgaW50ZXJhY3RhYmxlLCBlbGVtZW50KSA6IHZhbHVlKSB8fCBnZXRXaW5kb3coZWxlbWVudClcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGdldFNjcm9sbCAoY29udGFpbmVyOiBhbnkpIHtcbiAgaWYgKGlzLndpbmRvdyhjb250YWluZXIpKSB7IGNvbnRhaW5lciA9IHdpbmRvdy5kb2N1bWVudC5ib2R5IH1cblxuICByZXR1cm4geyB4OiBjb250YWluZXIuc2Nyb2xsTGVmdCwgeTogY29udGFpbmVyLnNjcm9sbFRvcCB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRTY3JvbGxTaXplIChjb250YWluZXI6IGFueSkge1xuICBpZiAoaXMud2luZG93KGNvbnRhaW5lcikpIHsgY29udGFpbmVyID0gd2luZG93LmRvY3VtZW50LmJvZHkgfVxuXG4gIHJldHVybiB7IHg6IGNvbnRhaW5lci5zY3JvbGxXaWR0aCwgeTogY29udGFpbmVyLnNjcm9sbEhlaWdodCB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRTY3JvbGxTaXplRGVsdGE8VCBleHRlbmRzIEludGVyYWN0LkFjdGlvbk5hbWU+ICh7IGludGVyYWN0aW9uLCBlbGVtZW50IH06IHtcbiAgaW50ZXJhY3Rpb246IFBhcnRpYWw8SW50ZXJhY3QuSW50ZXJhY3Rpb248VD4+XG4gIGVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnRcbn0sIGZ1bmM6IGFueSkge1xuICBjb25zdCBzY3JvbGxPcHRpb25zID0gaW50ZXJhY3Rpb24gJiYgaW50ZXJhY3Rpb24uaW50ZXJhY3RhYmxlLm9wdGlvbnNbaW50ZXJhY3Rpb24ucHJlcGFyZWQubmFtZV0uYXV0b1Njcm9sbFxuXG4gIGlmICghc2Nyb2xsT3B0aW9ucyB8fCAhc2Nyb2xsT3B0aW9ucy5lbmFibGVkKSB7XG4gICAgZnVuYygpXG4gICAgcmV0dXJuIHsgeDogMCwgeTogMCB9XG4gIH1cblxuICBjb25zdCBzY3JvbGxDb250YWluZXIgPSBnZXRDb250YWluZXIoXG4gICAgc2Nyb2xsT3B0aW9ucy5jb250YWluZXIsXG4gICAgaW50ZXJhY3Rpb24uaW50ZXJhY3RhYmxlLFxuICAgIGVsZW1lbnQsXG4gIClcblxuICBjb25zdCBwcmV2U2l6ZSA9IGdldFNjcm9sbChzY3JvbGxDb250YWluZXIpXG4gIGZ1bmMoKVxuICBjb25zdCBjdXJTaXplID0gZ2V0U2Nyb2xsKHNjcm9sbENvbnRhaW5lcilcblxuICByZXR1cm4ge1xuICAgIHg6IGN1clNpemUueCAtIHByZXZTaXplLngsXG4gICAgeTogY3VyU2l6ZS55IC0gcHJldlNpemUueSxcbiAgfVxufVxuXG5jb25zdCBhdXRvU2Nyb2xsUGx1Z2luOiBJbnRlcmFjdC5QbHVnaW4gPSB7XG4gIGlkOiAnYXV0by1zY3JvbGwnLFxuICBpbnN0YWxsLFxuICBsaXN0ZW5lcnM6IHtcbiAgICAnaW50ZXJhY3Rpb25zOm5ldyc6ICh7IGludGVyYWN0aW9uIH0pID0+IHtcbiAgICAgIGludGVyYWN0aW9uLmF1dG9TY3JvbGwgPSBudWxsXG4gICAgfSxcblxuICAgICdpbnRlcmFjdGlvbnM6ZGVzdHJveSc6ICh7IGludGVyYWN0aW9uIH0pID0+IHtcbiAgICAgIGludGVyYWN0aW9uLmF1dG9TY3JvbGwgPSBudWxsXG4gICAgICBhdXRvU2Nyb2xsLnN0b3AoKVxuICAgICAgaWYgKGF1dG9TY3JvbGwuaW50ZXJhY3Rpb24pIHtcbiAgICAgICAgYXV0b1Njcm9sbC5pbnRlcmFjdGlvbiA9IG51bGxcbiAgICAgIH1cbiAgICB9LFxuXG4gICAgJ2ludGVyYWN0aW9uczpzdG9wJzogYXV0b1Njcm9sbC5zdG9wLFxuXG4gICAgJ2ludGVyYWN0aW9uczphY3Rpb24tbW92ZSc6IChhcmc6IGFueSkgPT4gYXV0b1Njcm9sbC5vbkludGVyYWN0aW9uTW92ZShhcmcpLFxuICB9LFxufVxuXG5leHBvcnQgZGVmYXVsdCBhdXRvU2Nyb2xsUGx1Z2luXG4iLCJpbXBvcnQgeyB3YXJuT25jZSB9IGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2luZGV4J1xuaW1wb3J0ICogYXMgaXMgZnJvbSAnQGludGVyYWN0anMvdXRpbHMvaXMnXG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL0ludGVyYWN0YWJsZScge1xuICBpbnRlcmZhY2UgSW50ZXJhY3RhYmxlIHtcbiAgICBnZXRBY3Rpb246IChcbiAgICAgIHRoaXM6IEludGVyYWN0LkludGVyYWN0YWJsZSxcbiAgICAgIHBvaW50ZXI6IEludGVyYWN0LlBvaW50ZXJUeXBlLFxuICAgICAgZXZlbnQ6IEludGVyYWN0LlBvaW50ZXJFdmVudFR5cGUsXG4gICAgICBpbnRlcmFjdGlvbjogSW50ZXJhY3QuSW50ZXJhY3Rpb24sXG4gICAgICBlbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50LFxuICAgICkgPT4gSW50ZXJhY3QuQWN0aW9uUHJvcHMgfCBudWxsXG4gICAgc3R5bGVDdXJzb3I6IHR5cGVvZiBzdHlsZUN1cnNvclxuICAgIGFjdGlvbkNoZWNrZXI6IHR5cGVvZiBhY3Rpb25DaGVja2VyXG4gICAgaWdub3JlRnJvbToge1xuICAgICAgKC4uLmFyZ3M6IGFueVtdKTogSW50ZXJhY3RhYmxlXG4gICAgICAoKTogYm9vbGVhblxuICAgIH1cbiAgICBhbGxvd0Zyb206IHtcbiAgICAgICguLi5hcmdzOiBhbnlbXSk6IEludGVyYWN0YWJsZVxuICAgICAgKCk6IGJvb2xlYW5cbiAgICB9XG4gIH1cbn1cblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3Rpb24nIHtcbiAgaW50ZXJmYWNlIEludGVyYWN0aW9uIHtcbiAgICBwb2ludGVySXNEb3duOiBib29sZWFuXG4gIH1cbn1cblxuZnVuY3Rpb24gaW5zdGFsbCAoc2NvcGU6IEludGVyYWN0LlNjb3BlKSB7XG4gIGNvbnN0IHtcbiAgICAvKiogQGxlbmRzIEludGVyYWN0YWJsZSAqL1xuICAgIEludGVyYWN0YWJsZSwgLy8gdHNsaW50OmRpc2FibGUtbGluZSBuby1zaGFkb3dlZC12YXJpYWJsZVxuICB9ID0gc2NvcGVcblxuICBJbnRlcmFjdGFibGUucHJvdG90eXBlLmdldEFjdGlvbiA9IGZ1bmN0aW9uIGdldEFjdGlvbiAoXG4gICAgdGhpczogSW50ZXJhY3QuSW50ZXJhY3RhYmxlLFxuICAgIHBvaW50ZXI6IEludGVyYWN0LlBvaW50ZXJUeXBlLFxuICAgIGV2ZW50OiBJbnRlcmFjdC5Qb2ludGVyRXZlbnRUeXBlLFxuICAgIGludGVyYWN0aW9uOiBJbnRlcmFjdC5JbnRlcmFjdGlvbixcbiAgICBlbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50LFxuICApOiBJbnRlcmFjdC5BY3Rpb25Qcm9wcyB7XG4gICAgY29uc3QgYWN0aW9uID0gZGVmYXVsdEFjdGlvbkNoZWNrZXIodGhpcywgZXZlbnQsIGludGVyYWN0aW9uLCBlbGVtZW50LCBzY29wZSlcblxuICAgIGlmICh0aGlzLm9wdGlvbnMuYWN0aW9uQ2hlY2tlcikge1xuICAgICAgcmV0dXJuIHRoaXMub3B0aW9ucy5hY3Rpb25DaGVja2VyKHBvaW50ZXIsIGV2ZW50LCBhY3Rpb24sIHRoaXMsIGVsZW1lbnQsIGludGVyYWN0aW9uKVxuICAgIH1cblxuICAgIHJldHVybiBhY3Rpb25cbiAgfVxuXG4gIC8qKlxuICAgKiBgYGBqc1xuICAgKiBpbnRlcmFjdChlbGVtZW50LCB7IGlnbm9yZUZyb206IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKCduby1hY3Rpb24nKSB9KVxuICAgKiAvLyBvclxuICAgKiBpbnRlcmFjdChlbGVtZW50KS5pZ25vcmVGcm9tKCdpbnB1dCwgdGV4dGFyZWEsIGEnKVxuICAgKiBgYGBcbiAgICogQGRlcHJlY2F0ZWRcbiAgICogSWYgdGhlIHRhcmdldCBvZiB0aGUgYG1vdXNlZG93bmAsIGBwb2ludGVyZG93bmAgb3IgYHRvdWNoc3RhcnRgIGV2ZW50IG9yIGFueVxuICAgKiBvZiBpdCdzIHBhcmVudHMgbWF0Y2ggdGhlIGdpdmVuIENTUyBzZWxlY3RvciBvciBFbGVtZW50LCBub1xuICAgKiBkcmFnL3Jlc2l6ZS9nZXN0dXJlIGlzIHN0YXJ0ZWQuXG4gICAqXG4gICAqIERvbid0IHVzZSB0aGlzIG1ldGhvZC4gSW5zdGVhZCBzZXQgdGhlIGBpZ25vcmVGcm9tYCBvcHRpb24gZm9yIGVhY2ggYWN0aW9uXG4gICAqIG9yIGZvciBgcG9pbnRlckV2ZW50c2BcbiAgICpcbiAgICogQGV4YW1wbGVcbiAgICogaW50ZXJhY3QodGFyZ2V0dClcbiAgICogICAuZHJhZ2dhYmxlKHtcbiAgICogICAgIGlnbm9yZUZyb206ICdpbnB1dCwgdGV4dGFyZWEsIGFbaHJlZl0nJyxcbiAgICogICB9KVxuICAgKiAgIC5wb2ludGVyRXZlbnRzKHtcbiAgICogICAgIGlnbm9yZUZyb206ICdbbm8tcG9pbnRlcl0nLFxuICAgKiAgIH0pXG4gICAqXG4gICAqIEBwYXJhbSB7c3RyaW5nIHwgRWxlbWVudCB8IG51bGx9IFtuZXdWYWx1ZV0gYSBDU1Mgc2VsZWN0b3Igc3RyaW5nLCBhblxuICAgKiBFbGVtZW50IG9yIGBudWxsYCB0byBub3QgaWdub3JlIGFueSBlbGVtZW50c1xuICAgKiBAcmV0dXJuIHtzdHJpbmcgfCBFbGVtZW50IHwgb2JqZWN0fSBUaGUgY3VycmVudCBpZ25vcmVGcm9tIHZhbHVlIG9yIHRoaXNcbiAgICogSW50ZXJhY3RhYmxlXG4gICAqL1xuICBJbnRlcmFjdGFibGUucHJvdG90eXBlLmlnbm9yZUZyb20gPSB3YXJuT25jZShmdW5jdGlvbiAodGhpczogSW50ZXJhY3QuSW50ZXJhY3RhYmxlLCBuZXdWYWx1ZSkge1xuICAgIHJldHVybiB0aGlzLl9iYWNrQ29tcGF0T3B0aW9uKCdpZ25vcmVGcm9tJywgbmV3VmFsdWUpXG4gIH0sICdJbnRlcmFjdGFibGUuaWdub3JlRnJvbSgpIGhhcyBiZWVuIGRlcHJlY2F0ZWQuIFVzZSBJbnRlcmFjdGJsZS5kcmFnZ2FibGUoe2lnbm9yZUZyb206IG5ld1ZhbHVlfSkuJylcblxuICAvKipcbiAgICogQGRlcHJlY2F0ZWRcbiAgICpcbiAgICogQSBkcmFnL3Jlc2l6ZS9nZXN0dXJlIGlzIHN0YXJ0ZWQgb25seSBJZiB0aGUgdGFyZ2V0IG9mIHRoZSBgbW91c2Vkb3duYCxcbiAgICogYHBvaW50ZXJkb3duYCBvciBgdG91Y2hzdGFydGAgZXZlbnQgb3IgYW55IG9mIGl0J3MgcGFyZW50cyBtYXRjaCB0aGUgZ2l2ZW5cbiAgICogQ1NTIHNlbGVjdG9yIG9yIEVsZW1lbnQuXG4gICAqXG4gICAqIERvbid0IHVzZSB0aGlzIG1ldGhvZC4gSW5zdGVhZCBzZXQgdGhlIGBhbGxvd0Zyb21gIG9wdGlvbiBmb3IgZWFjaCBhY3Rpb25cbiAgICogb3IgZm9yIGBwb2ludGVyRXZlbnRzYFxuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiBpbnRlcmFjdCh0YXJnZXR0KVxuICAgKiAgIC5yZXNpemFibGUoe1xuICAgKiAgICAgYWxsb3dGcm9tOiAnLnJlc2l6ZS1oYW5kbGUnLFxuICAgKiAgIC5wb2ludGVyRXZlbnRzKHtcbiAgICogICAgIGFsbG93RnJvbTogJy5oYW5kbGUnLCxcbiAgICogICB9KVxuICAgKlxuICAgKiBAcGFyYW0ge3N0cmluZyB8IEVsZW1lbnQgfCBudWxsfSBbbmV3VmFsdWVdIGEgQ1NTIHNlbGVjdG9yIHN0cmluZywgYW5cbiAgICogRWxlbWVudCBvciBgbnVsbGAgdG8gYWxsb3cgZnJvbSBhbnkgZWxlbWVudFxuICAgKiBAcmV0dXJuIHtzdHJpbmcgfCBFbGVtZW50IHwgb2JqZWN0fSBUaGUgY3VycmVudCBhbGxvd0Zyb20gdmFsdWUgb3IgdGhpc1xuICAgKiBJbnRlcmFjdGFibGVcbiAgICovXG4gIEludGVyYWN0YWJsZS5wcm90b3R5cGUuYWxsb3dGcm9tID0gd2Fybk9uY2UoZnVuY3Rpb24gKHRoaXM6IEludGVyYWN0LkludGVyYWN0YWJsZSwgbmV3VmFsdWUpIHtcbiAgICByZXR1cm4gdGhpcy5fYmFja0NvbXBhdE9wdGlvbignYWxsb3dGcm9tJywgbmV3VmFsdWUpXG4gIH0sICdJbnRlcmFjdGFibGUuYWxsb3dGcm9tKCkgaGFzIGJlZW4gZGVwcmVjYXRlZC4gVXNlIEludGVyYWN0YmxlLmRyYWdnYWJsZSh7YWxsb3dGcm9tOiBuZXdWYWx1ZX0pLicpXG5cbiAgLyoqXG4gICAqIGBgYGpzXG4gICAqIGludGVyYWN0KCcucmVzaXplLWRyYWcnKVxuICAgKiAgIC5yZXNpemFibGUodHJ1ZSlcbiAgICogICAuZHJhZ2dhYmxlKHRydWUpXG4gICAqICAgLmFjdGlvbkNoZWNrZXIoZnVuY3Rpb24gKHBvaW50ZXIsIGV2ZW50LCBhY3Rpb24sIGludGVyYWN0YWJsZSwgZWxlbWVudCwgaW50ZXJhY3Rpb24pIHtcbiAgICpcbiAgICogICBpZiAoaW50ZXJhY3QubWF0Y2hlc1NlbGVjdG9yKGV2ZW50LnRhcmdldCwgJy5kcmFnLWhhbmRsZScpKSB7XG4gICAqICAgICAvLyBmb3JjZSBkcmFnIHdpdGggaGFuZGxlIHRhcmdldFxuICAgKiAgICAgYWN0aW9uLm5hbWUgPSBkcmFnXG4gICAqICAgfVxuICAgKiAgIGVsc2Uge1xuICAgKiAgICAgLy8gcmVzaXplIGZyb20gdGhlIHRvcCBhbmQgcmlnaHQgZWRnZXNcbiAgICogICAgIGFjdGlvbi5uYW1lICA9ICdyZXNpemUnXG4gICAqICAgICBhY3Rpb24uZWRnZXMgPSB7IHRvcDogdHJ1ZSwgcmlnaHQ6IHRydWUgfVxuICAgKiAgIH1cbiAgICpcbiAgICogICByZXR1cm4gYWN0aW9uXG4gICAqIH0pXG4gICAqIGBgYFxuICAgKlxuICAgKiBSZXR1cm5zIG9yIHNldHMgdGhlIGZ1bmN0aW9uIHVzZWQgdG8gY2hlY2sgYWN0aW9uIHRvIGJlIHBlcmZvcm1lZCBvblxuICAgKiBwb2ludGVyRG93blxuICAgKlxuICAgKiBAcGFyYW0ge2Z1bmN0aW9uIHwgbnVsbH0gW2NoZWNrZXJdIEEgZnVuY3Rpb24gd2hpY2ggdGFrZXMgYSBwb2ludGVyIGV2ZW50LFxuICAgKiBkZWZhdWx0QWN0aW9uIHN0cmluZywgaW50ZXJhY3RhYmxlLCBlbGVtZW50IGFuZCBpbnRlcmFjdGlvbiBhcyBwYXJhbWV0ZXJzXG4gICAqIGFuZCByZXR1cm5zIGFuIG9iamVjdCB3aXRoIG5hbWUgcHJvcGVydHkgJ2RyYWcnICdyZXNpemUnIG9yICdnZXN0dXJlJyBhbmRcbiAgICogb3B0aW9uYWxseSBhbiBgZWRnZXNgIG9iamVjdCB3aXRoIGJvb2xlYW4gJ3RvcCcsICdsZWZ0JywgJ2JvdHRvbScgYW5kIHJpZ2h0XG4gICAqIHByb3BzLlxuICAgKiBAcmV0dXJuIHtGdW5jdGlvbiB8IEludGVyYWN0YWJsZX0gVGhlIGNoZWNrZXIgZnVuY3Rpb24gb3IgdGhpcyBJbnRlcmFjdGFibGVcbiAgICovXG4gIEludGVyYWN0YWJsZS5wcm90b3R5cGUuYWN0aW9uQ2hlY2tlciA9IGFjdGlvbkNoZWNrZXJcblxuICAvKipcbiAgICogUmV0dXJucyBvciBzZXRzIHdoZXRoZXIgdGhlIHRoZSBjdXJzb3Igc2hvdWxkIGJlIGNoYW5nZWQgZGVwZW5kaW5nIG9uIHRoZVxuICAgKiBhY3Rpb24gdGhhdCB3b3VsZCBiZSBwZXJmb3JtZWQgaWYgdGhlIG1vdXNlIHdlcmUgcHJlc3NlZCBhbmQgZHJhZ2dlZC5cbiAgICpcbiAgICogQHBhcmFtIHtib29sZWFufSBbbmV3VmFsdWVdXG4gICAqIEByZXR1cm4ge2Jvb2xlYW4gfCBJbnRlcmFjdGFibGV9IFRoZSBjdXJyZW50IHNldHRpbmcgb3IgdGhpcyBJbnRlcmFjdGFibGVcbiAgICovXG4gIEludGVyYWN0YWJsZS5wcm90b3R5cGUuc3R5bGVDdXJzb3IgPSBzdHlsZUN1cnNvclxufVxuXG5mdW5jdGlvbiBkZWZhdWx0QWN0aW9uQ2hlY2tlciAoXG4gIGludGVyYWN0YWJsZTogSW50ZXJhY3QuSW50ZXJhY3RhYmxlLFxuICBldmVudDogSW50ZXJhY3QuUG9pbnRlckV2ZW50VHlwZSxcbiAgaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uLFxuICBlbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50LFxuICBzY29wZTogSW50ZXJhY3QuU2NvcGUsXG4pIHtcbiAgY29uc3QgcmVjdCA9IGludGVyYWN0YWJsZS5nZXRSZWN0KGVsZW1lbnQpXG4gIGNvbnN0IGJ1dHRvbnMgPSAoZXZlbnQgYXMgTW91c2VFdmVudCkuYnV0dG9ucyB8fCAoe1xuICAgIDA6IDEsXG4gICAgMTogNCxcbiAgICAzOiA4LFxuICAgIDQ6IDE2LFxuICB9KVsoZXZlbnQgYXMgTW91c2VFdmVudCkuYnV0dG9uIGFzIDAgfCAxIHwgMyB8IDRdXG4gIGNvbnN0IGFyZyA9IHtcbiAgICBhY3Rpb246IG51bGwsXG4gICAgaW50ZXJhY3RhYmxlLFxuICAgIGludGVyYWN0aW9uLFxuICAgIGVsZW1lbnQsXG4gICAgcmVjdCxcbiAgICBidXR0b25zLFxuICB9XG5cbiAgc2NvcGUuZmlyZSgnYXV0by1zdGFydDpjaGVjaycsIGFyZylcblxuICByZXR1cm4gYXJnLmFjdGlvblxufVxuXG5mdW5jdGlvbiBzdHlsZUN1cnNvciAodGhpczogSW50ZXJhY3QuSW50ZXJhY3RhYmxlKTogYm9vbGVhblxuZnVuY3Rpb24gc3R5bGVDdXJzb3IgKHRoaXM6IEludGVyYWN0LkludGVyYWN0YWJsZSwgbmV3VmFsdWU6IGJvb2xlYW4pOiB0eXBlb2YgdGhpc1xuZnVuY3Rpb24gc3R5bGVDdXJzb3IgKHRoaXM6IEludGVyYWN0LkludGVyYWN0YWJsZSwgbmV3VmFsdWU/OiBib29sZWFuKSB7XG4gIGlmIChpcy5ib29sKG5ld1ZhbHVlKSkge1xuICAgIHRoaXMub3B0aW9ucy5zdHlsZUN1cnNvciA9IG5ld1ZhbHVlXG5cbiAgICByZXR1cm4gdGhpc1xuICB9XG5cbiAgaWYgKG5ld1ZhbHVlID09PSBudWxsKSB7XG4gICAgZGVsZXRlIHRoaXMub3B0aW9ucy5zdHlsZUN1cnNvclxuXG4gICAgcmV0dXJuIHRoaXNcbiAgfVxuXG4gIHJldHVybiB0aGlzLm9wdGlvbnMuc3R5bGVDdXJzb3Jcbn1cblxuZnVuY3Rpb24gYWN0aW9uQ2hlY2tlciAodGhpczogSW50ZXJhY3QuSW50ZXJhY3RhYmxlLCBjaGVja2VyOiBhbnkpIHtcbiAgaWYgKGlzLmZ1bmMoY2hlY2tlcikpIHtcbiAgICB0aGlzLm9wdGlvbnMuYWN0aW9uQ2hlY2tlciA9IGNoZWNrZXJcblxuICAgIHJldHVybiB0aGlzXG4gIH1cblxuICBpZiAoY2hlY2tlciA9PT0gbnVsbCkge1xuICAgIGRlbGV0ZSB0aGlzLm9wdGlvbnMuYWN0aW9uQ2hlY2tlclxuXG4gICAgcmV0dXJuIHRoaXNcbiAgfVxuXG4gIHJldHVybiB0aGlzLm9wdGlvbnMuYWN0aW9uQ2hlY2tlclxufVxuXG5leHBvcnQgZGVmYXVsdCB7XG4gIGlkOiAnYXV0by1zdGFydC9pbnRlcmFjdGFibGVNZXRob2RzJyxcbiAgaW5zdGFsbCxcbn1cbiIsImltcG9ydCAqIGFzIHV0aWxzIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2luZGV4J1xuaW1wb3J0IEludGVyYWN0YWJsZU1ldGhvZHMgZnJvbSAnLi9JbnRlcmFjdGFibGVNZXRob2RzJ1xuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvaW50ZXJhY3QvaW5kZXgnIHtcbiAgaW50ZXJmYWNlIEludGVyYWN0U3RhdGljIHtcbiAgICBtYXhJbnRlcmFjdGlvbnM6IChuZXdWYWx1ZTogYW55KSA9PiBhbnlcbiAgfVxufVxuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvY29yZS9zY29wZScge1xuICBpbnRlcmZhY2UgU2NvcGUge1xuICAgIGF1dG9TdGFydDogQXV0b1N0YXJ0XG4gICAgbWF4SW50ZXJhY3Rpb25zOiAoLi4uYXJnczogYW55W10pID0+IGFueVxuICB9XG5cbiAgaW50ZXJmYWNlIFNpZ25hbEFyZ3Mge1xuICAgICdhdXRvU3RhcnQ6YmVmb3JlLXN0YXJ0JzogSW50ZXJhY3QuU2lnbmFsQXJnc1snaW50ZXJhY3Rpb25zOm1vdmUnXVxuICAgICdhdXRvU3RhcnQ6cHJlcGFyZWQnOiB7IGludGVyYWN0aW9uOiBJbnRlcmFjdC5JbnRlcmFjdGlvbiB9XG4gICAgJ2F1dG8tc3RhcnQ6Y2hlY2snOiBDaGVja1NpZ25hbEFyZ1xuICB9XG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL2RlZmF1bHRPcHRpb25zJyB7XG4gIGludGVyZmFjZSBCYXNlRGVmYXVsdHMge1xuICAgIGFjdGlvbkNoZWNrZXI/OiBhbnlcbiAgICBjdXJzb3JDaGVja2VyPzogYW55XG4gICAgc3R5bGVDdXJzb3I/OiBhbnlcbiAgfVxuXG4gIGludGVyZmFjZSBQZXJBY3Rpb25EZWZhdWx0cyB7XG4gICAgbWFudWFsU3RhcnQ/OiBib29sZWFuXG4gICAgbWF4PzogbnVtYmVyXG4gICAgbWF4UGVyRWxlbWVudD86IG51bWJlclxuICAgIGFsbG93RnJvbT86IHN0cmluZyB8IEludGVyYWN0LkVsZW1lbnRcbiAgICBpZ25vcmVGcm9tPzogc3RyaW5nIHwgSW50ZXJhY3QuRWxlbWVudFxuICAgIGN1cnNvckNoZWNrZXI/OiBJbnRlcmFjdC5DdXJzb3JDaGVja2VyXG5cbiAgICAvLyBvbmx5IGFsbG93IGxlZnQgYnV0dG9uIGJ5IGRlZmF1bHRcbiAgICAvLyBzZWUgaHR0cHM6Ly9kZXZlbG9wZXIubW96aWxsYS5vcmcvZW4tVVMvZG9jcy9XZWIvQVBJL01vdXNlRXZlbnQvYnV0dG9ucyNSZXR1cm5fdmFsdWVcbiAgICBtb3VzZUJ1dHRvbnM/OiAwIHwgMSB8IDIgfCA0IHwgMTZcbiAgfVxufVxuXG5pbnRlcmZhY2UgQ2hlY2tTaWduYWxBcmcge1xuICBpbnRlcmFjdGFibGU6IEludGVyYWN0LkludGVyYWN0YWJsZVxuICBpbnRlcmFjdGlvbjogSW50ZXJhY3QuSW50ZXJhY3Rpb25cbiAgZWxlbWVudDogSW50ZXJhY3QuRWxlbWVudFxuICBhY3Rpb246IEludGVyYWN0LkFjdGlvblByb3BzXG4gIGJ1dHRvbnM6IG51bWJlclxufVxuXG5leHBvcnQgaW50ZXJmYWNlIEF1dG9TdGFydCB7XG4gIC8vIEFsbG93IHRoaXMgbWFueSBpbnRlcmFjdGlvbnMgdG8gaGFwcGVuIHNpbXVsdGFuZW91c2x5XG4gIG1heEludGVyYWN0aW9uczogbnVtYmVyXG4gIHdpdGhpbkludGVyYWN0aW9uTGltaXQ6IHR5cGVvZiB3aXRoaW5JbnRlcmFjdGlvbkxpbWl0XG4gIGN1cnNvckVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnRcbn1cblxuZnVuY3Rpb24gaW5zdGFsbCAoc2NvcGU6IEludGVyYWN0LlNjb3BlKSB7XG4gIGNvbnN0IHtcbiAgICBpbnRlcmFjdCxcbiAgICBkZWZhdWx0cyxcbiAgfSA9IHNjb3BlXG5cbiAgc2NvcGUudXNlUGx1Z2luKEludGVyYWN0YWJsZU1ldGhvZHMpXG5cbiAgZGVmYXVsdHMuYmFzZS5hY3Rpb25DaGVja2VyID0gbnVsbFxuICBkZWZhdWx0cy5iYXNlLnN0eWxlQ3Vyc29yID0gdHJ1ZVxuXG4gIHV0aWxzLmV4dGVuZChkZWZhdWx0cy5wZXJBY3Rpb24sIHtcbiAgICBtYW51YWxTdGFydDogZmFsc2UsXG4gICAgbWF4OiBJbmZpbml0eSxcbiAgICBtYXhQZXJFbGVtZW50OiAxLFxuICAgIGFsbG93RnJvbTogIG51bGwsXG4gICAgaWdub3JlRnJvbTogbnVsbCxcblxuICAgIC8vIG9ubHkgYWxsb3cgbGVmdCBidXR0b24gYnkgZGVmYXVsdFxuICAgIC8vIHNlZSBodHRwczovL2RldmVsb3Blci5tb3ppbGxhLm9yZy9lbi1VUy9kb2NzL1dlYi9BUEkvTW91c2VFdmVudC9idXR0b25zI1JldHVybl92YWx1ZVxuICAgIG1vdXNlQnV0dG9uczogMSxcbiAgfSlcblxuICAvKipcbiAgICogUmV0dXJucyBvciBzZXRzIHRoZSBtYXhpbXVtIG51bWJlciBvZiBjb25jdXJyZW50IGludGVyYWN0aW9ucyBhbGxvd2VkLiAgQnlcbiAgICogZGVmYXVsdCBvbmx5IDEgaW50ZXJhY3Rpb24gaXMgYWxsb3dlZCBhdCBhIHRpbWUgKGZvciBiYWNrd2FyZHNcbiAgICogY29tcGF0aWJpbGl0eSkuIFRvIGFsbG93IG11bHRpcGxlIGludGVyYWN0aW9ucyBvbiB0aGUgc2FtZSBJbnRlcmFjdGFibGVzIGFuZFxuICAgKiBlbGVtZW50cywgeW91IG5lZWQgdG8gZW5hYmxlIGl0IGluIHRoZSBkcmFnZ2FibGUsIHJlc2l6YWJsZSBhbmQgZ2VzdHVyYWJsZVxuICAgKiBgJ21heCdgIGFuZCBgJ21heFBlckVsZW1lbnQnYCBvcHRpb25zLlxuICAgKlxuICAgKiBAYWxpYXMgbW9kdWxlOmludGVyYWN0Lm1heEludGVyYWN0aW9uc1xuICAgKlxuICAgKiBAcGFyYW0ge251bWJlcn0gW25ld1ZhbHVlXSBBbnkgbnVtYmVyLiBuZXdWYWx1ZSA8PSAwIG1lYW5zIG5vIGludGVyYWN0aW9ucy5cbiAgICovXG4gIGludGVyYWN0Lm1heEludGVyYWN0aW9ucyA9IG5ld1ZhbHVlID0+IG1heEludGVyYWN0aW9ucyhuZXdWYWx1ZSwgc2NvcGUpXG5cbiAgc2NvcGUuYXV0b1N0YXJ0ID0ge1xuICAgIC8vIEFsbG93IHRoaXMgbWFueSBpbnRlcmFjdGlvbnMgdG8gaGFwcGVuIHNpbXVsdGFuZW91c2x5XG4gICAgbWF4SW50ZXJhY3Rpb25zOiBJbmZpbml0eSxcbiAgICB3aXRoaW5JbnRlcmFjdGlvbkxpbWl0LFxuICAgIGN1cnNvckVsZW1lbnQ6IG51bGwsXG4gIH1cbn1cblxuZnVuY3Rpb24gcHJlcGFyZU9uRG93biAoeyBpbnRlcmFjdGlvbiwgcG9pbnRlciwgZXZlbnQsIGV2ZW50VGFyZ2V0IH06IEludGVyYWN0LlNpZ25hbEFyZ3NbJ2ludGVyYWN0aW9uczpkb3duJ10sIHNjb3BlOiBJbnRlcmFjdC5TY29wZSkge1xuICBpZiAoaW50ZXJhY3Rpb24uaW50ZXJhY3RpbmcoKSkgeyByZXR1cm4gfVxuXG4gIGNvbnN0IGFjdGlvbkluZm8gPSBnZXRBY3Rpb25JbmZvKGludGVyYWN0aW9uLCBwb2ludGVyLCBldmVudCwgZXZlbnRUYXJnZXQsIHNjb3BlKVxuICBwcmVwYXJlKGludGVyYWN0aW9uLCBhY3Rpb25JbmZvLCBzY29wZSlcbn1cblxuZnVuY3Rpb24gcHJlcGFyZU9uTW92ZSAoeyBpbnRlcmFjdGlvbiwgcG9pbnRlciwgZXZlbnQsIGV2ZW50VGFyZ2V0IH06IEludGVyYWN0LlNpZ25hbEFyZ3NbJ2ludGVyYWN0aW9uczptb3ZlJ10sIHNjb3BlOiBJbnRlcmFjdC5TY29wZSkge1xuICBpZiAoaW50ZXJhY3Rpb24ucG9pbnRlclR5cGUgIT09ICdtb3VzZScgfHxcbiAgICAgIGludGVyYWN0aW9uLnBvaW50ZXJJc0Rvd24gfHxcbiAgICAgIGludGVyYWN0aW9uLmludGVyYWN0aW5nKCkpIHsgcmV0dXJuIH1cblxuICBjb25zdCBhY3Rpb25JbmZvID0gZ2V0QWN0aW9uSW5mbyhpbnRlcmFjdGlvbiwgcG9pbnRlciwgZXZlbnQsIGV2ZW50VGFyZ2V0IGFzIEludGVyYWN0LkVsZW1lbnQsIHNjb3BlKVxuICBwcmVwYXJlKGludGVyYWN0aW9uLCBhY3Rpb25JbmZvLCBzY29wZSlcbn1cblxuZnVuY3Rpb24gc3RhcnRPbk1vdmUgKGFyZzogSW50ZXJhY3QuU2lnbmFsQXJnc1snaW50ZXJhY3Rpb25zOm1vdmUnXSwgc2NvcGU6IEludGVyYWN0LlNjb3BlKSB7XG4gIGNvbnN0IHsgaW50ZXJhY3Rpb24gfSA9IGFyZ1xuXG4gIGlmICghaW50ZXJhY3Rpb24ucG9pbnRlcklzRG93biB8fFxuICAgICAgaW50ZXJhY3Rpb24uaW50ZXJhY3RpbmcoKSB8fFxuICAgICAgIWludGVyYWN0aW9uLnBvaW50ZXJXYXNNb3ZlZCB8fFxuICAgICAgIWludGVyYWN0aW9uLnByZXBhcmVkLm5hbWUpIHtcbiAgICByZXR1cm5cbiAgfVxuXG4gIHNjb3BlLmZpcmUoJ2F1dG9TdGFydDpiZWZvcmUtc3RhcnQnLCBhcmcpXG5cbiAgY29uc3QgeyBpbnRlcmFjdGFibGUgfSA9IGludGVyYWN0aW9uXG4gIGNvbnN0IGFjdGlvbk5hbWUgPSBpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lXG5cbiAgaWYgKGFjdGlvbk5hbWUgJiYgaW50ZXJhY3RhYmxlKSB7XG4gICAgLy8gY2hlY2sgbWFudWFsU3RhcnQgYW5kIGludGVyYWN0aW9uIGxpbWl0XG4gICAgaWYgKGludGVyYWN0YWJsZS5vcHRpb25zW2FjdGlvbk5hbWVdLm1hbnVhbFN0YXJ0IHx8XG4gICAgICAgICF3aXRoaW5JbnRlcmFjdGlvbkxpbWl0KGludGVyYWN0YWJsZSwgaW50ZXJhY3Rpb24uZWxlbWVudCwgaW50ZXJhY3Rpb24ucHJlcGFyZWQsIHNjb3BlKSkge1xuICAgICAgaW50ZXJhY3Rpb24uc3RvcCgpXG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgaW50ZXJhY3Rpb24uc3RhcnQoaW50ZXJhY3Rpb24ucHJlcGFyZWQsIGludGVyYWN0YWJsZSwgaW50ZXJhY3Rpb24uZWxlbWVudClcbiAgICAgIHNldEludGVyYWN0aW9uQ3Vyc29yKGludGVyYWN0aW9uLCBzY29wZSlcbiAgICB9XG4gIH1cbn1cblxuZnVuY3Rpb24gY2xlYXJDdXJzb3JPblN0b3AgKHsgaW50ZXJhY3Rpb24gfTogeyBpbnRlcmFjdGlvbjogSW50ZXJhY3QuSW50ZXJhY3Rpb24gfSwgc2NvcGU6IEludGVyYWN0LlNjb3BlKSB7XG4gIGNvbnN0IHsgaW50ZXJhY3RhYmxlIH0gPSBpbnRlcmFjdGlvblxuXG4gIGlmIChpbnRlcmFjdGFibGUgJiYgaW50ZXJhY3RhYmxlLm9wdGlvbnMuc3R5bGVDdXJzb3IpIHtcbiAgICBzZXRDdXJzb3IoaW50ZXJhY3Rpb24uZWxlbWVudCwgJycsIHNjb3BlKVxuICB9XG59XG5cbi8vIENoZWNrIGlmIHRoZSBjdXJyZW50IGludGVyYWN0YWJsZSBzdXBwb3J0cyB0aGUgYWN0aW9uLlxuLy8gSWYgc28sIHJldHVybiB0aGUgdmFsaWRhdGVkIGFjdGlvbi4gT3RoZXJ3aXNlLCByZXR1cm4gbnVsbFxuZnVuY3Rpb24gdmFsaWRhdGVBY3Rpb248VCBleHRlbmRzIEludGVyYWN0LkFjdGlvbk5hbWU+IChcbiAgYWN0aW9uOiBJbnRlcmFjdC5BY3Rpb25Qcm9wczxUPixcbiAgaW50ZXJhY3RhYmxlOiBJbnRlcmFjdC5JbnRlcmFjdGFibGUsXG4gIGVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnQsXG4gIGV2ZW50VGFyZ2V0OiBJbnRlcmFjdC5FdmVudFRhcmdldCxcbiAgc2NvcGU6IEludGVyYWN0LlNjb3BlLFxuKSB7XG4gIGlmIChpbnRlcmFjdGFibGUudGVzdElnbm9yZUFsbG93KGludGVyYWN0YWJsZS5vcHRpb25zW2FjdGlvbi5uYW1lXSwgZWxlbWVudCwgZXZlbnRUYXJnZXQpICYmXG4gICAgICBpbnRlcmFjdGFibGUub3B0aW9uc1thY3Rpb24ubmFtZV0uZW5hYmxlZCAmJlxuICAgICAgd2l0aGluSW50ZXJhY3Rpb25MaW1pdChpbnRlcmFjdGFibGUsIGVsZW1lbnQsIGFjdGlvbiwgc2NvcGUpKSB7XG4gICAgcmV0dXJuIGFjdGlvblxuICB9XG5cbiAgcmV0dXJuIG51bGxcbn1cblxuZnVuY3Rpb24gdmFsaWRhdGVNYXRjaGVzIChcbiAgaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uLFxuICBwb2ludGVyOiBJbnRlcmFjdC5Qb2ludGVyVHlwZSxcbiAgZXZlbnQ6IEludGVyYWN0LlBvaW50ZXJFdmVudFR5cGUsXG4gIG1hdGNoZXM6IEludGVyYWN0LkludGVyYWN0YWJsZVtdLFxuICBtYXRjaEVsZW1lbnRzOiBJbnRlcmFjdC5FbGVtZW50W10sXG4gIGV2ZW50VGFyZ2V0OiBJbnRlcmFjdC5FdmVudFRhcmdldCxcbiAgc2NvcGU6IEludGVyYWN0LlNjb3BlLFxuKSB7XG4gIGZvciAobGV0IGkgPSAwLCBsZW4gPSBtYXRjaGVzLmxlbmd0aDsgaSA8IGxlbjsgaSsrKSB7XG4gICAgY29uc3QgbWF0Y2ggPSBtYXRjaGVzW2ldXG4gICAgY29uc3QgbWF0Y2hFbGVtZW50ID0gbWF0Y2hFbGVtZW50c1tpXVxuICAgIGNvbnN0IG1hdGNoQWN0aW9uID0gbWF0Y2guZ2V0QWN0aW9uKHBvaW50ZXIsIGV2ZW50LCBpbnRlcmFjdGlvbiwgbWF0Y2hFbGVtZW50KVxuXG4gICAgaWYgKCFtYXRjaEFjdGlvbikgeyBjb250aW51ZSB9XG5cbiAgICBjb25zdCBhY3Rpb24gPSB2YWxpZGF0ZUFjdGlvbihcbiAgICAgIG1hdGNoQWN0aW9uLFxuICAgICAgbWF0Y2gsXG4gICAgICBtYXRjaEVsZW1lbnQsXG4gICAgICBldmVudFRhcmdldCxcbiAgICAgIHNjb3BlKVxuXG4gICAgaWYgKGFjdGlvbikge1xuICAgICAgcmV0dXJuIHtcbiAgICAgICAgYWN0aW9uLFxuICAgICAgICBpbnRlcmFjdGFibGU6IG1hdGNoLFxuICAgICAgICBlbGVtZW50OiBtYXRjaEVsZW1lbnQsXG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHsgYWN0aW9uOiBudWxsLCBpbnRlcmFjdGFibGU6IG51bGwsIGVsZW1lbnQ6IG51bGwgfVxufVxuXG5mdW5jdGlvbiBnZXRBY3Rpb25JbmZvIChcbiAgaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uLFxuICBwb2ludGVyOiBJbnRlcmFjdC5Qb2ludGVyVHlwZSxcbiAgZXZlbnQ6IEludGVyYWN0LlBvaW50ZXJFdmVudFR5cGUsXG4gIGV2ZW50VGFyZ2V0OiBJbnRlcmFjdC5FdmVudFRhcmdldCxcbiAgc2NvcGU6IEludGVyYWN0LlNjb3BlLFxuKSB7XG4gIGxldCBtYXRjaGVzOiBJbnRlcmFjdC5JbnRlcmFjdGFibGVbXSA9IFtdXG4gIGxldCBtYXRjaEVsZW1lbnRzOiBJbnRlcmFjdC5FbGVtZW50W10gPSBbXVxuXG4gIGxldCBlbGVtZW50ID0gZXZlbnRUYXJnZXQgYXMgSW50ZXJhY3QuRWxlbWVudFxuXG4gIGZ1bmN0aW9uIHB1c2hNYXRjaGVzIChpbnRlcmFjdGFibGU6IEludGVyYWN0LkludGVyYWN0YWJsZSkge1xuICAgIG1hdGNoZXMucHVzaChpbnRlcmFjdGFibGUpXG4gICAgbWF0Y2hFbGVtZW50cy5wdXNoKGVsZW1lbnQpXG4gIH1cblxuICB3aGlsZSAodXRpbHMuaXMuZWxlbWVudChlbGVtZW50KSkge1xuICAgIG1hdGNoZXMgPSBbXVxuICAgIG1hdGNoRWxlbWVudHMgPSBbXVxuXG4gICAgc2NvcGUuaW50ZXJhY3RhYmxlcy5mb3JFYWNoTWF0Y2goZWxlbWVudCwgcHVzaE1hdGNoZXMpXG5cbiAgICBjb25zdCBhY3Rpb25JbmZvID0gdmFsaWRhdGVNYXRjaGVzKGludGVyYWN0aW9uLCBwb2ludGVyLCBldmVudCwgbWF0Y2hlcywgbWF0Y2hFbGVtZW50cywgZXZlbnRUYXJnZXQsIHNjb3BlKVxuXG4gICAgaWYgKGFjdGlvbkluZm8uYWN0aW9uICYmXG4gICAgICAhYWN0aW9uSW5mby5pbnRlcmFjdGFibGUub3B0aW9uc1thY3Rpb25JbmZvLmFjdGlvbi5uYW1lXS5tYW51YWxTdGFydCkge1xuICAgICAgcmV0dXJuIGFjdGlvbkluZm9cbiAgICB9XG5cbiAgICBlbGVtZW50ID0gdXRpbHMuZG9tLnBhcmVudE5vZGUoZWxlbWVudCkgYXMgSW50ZXJhY3QuRWxlbWVudFxuICB9XG5cbiAgcmV0dXJuIHsgYWN0aW9uOiBudWxsLCBpbnRlcmFjdGFibGU6IG51bGwsIGVsZW1lbnQ6IG51bGwgfVxufVxuXG5mdW5jdGlvbiBwcmVwYXJlIChcbiAgaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uLFxuICB7IGFjdGlvbiwgaW50ZXJhY3RhYmxlLCBlbGVtZW50IH06IHtcbiAgICBhY3Rpb246IEludGVyYWN0LkFjdGlvblByb3BzXG4gICAgaW50ZXJhY3RhYmxlOiBJbnRlcmFjdC5JbnRlcmFjdGFibGVcbiAgICBlbGVtZW50OiBJbnRlcmFjdC5FbGVtZW50XG4gIH0sXG4gIHNjb3BlOiBJbnRlcmFjdC5TY29wZSxcbikge1xuICBhY3Rpb24gPSBhY3Rpb24gfHwgeyBuYW1lOiBudWxsIH1cblxuICBpbnRlcmFjdGlvbi5pbnRlcmFjdGFibGUgPSBpbnRlcmFjdGFibGVcbiAgaW50ZXJhY3Rpb24uZWxlbWVudCA9IGVsZW1lbnRcbiAgdXRpbHMuY29weUFjdGlvbihpbnRlcmFjdGlvbi5wcmVwYXJlZCwgYWN0aW9uKVxuXG4gIGludGVyYWN0aW9uLnJlY3QgPSBpbnRlcmFjdGFibGUgJiYgYWN0aW9uLm5hbWVcbiAgICA/IGludGVyYWN0YWJsZS5nZXRSZWN0KGVsZW1lbnQpXG4gICAgOiBudWxsXG5cbiAgc2V0SW50ZXJhY3Rpb25DdXJzb3IoaW50ZXJhY3Rpb24sIHNjb3BlKVxuXG4gIHNjb3BlLmZpcmUoJ2F1dG9TdGFydDpwcmVwYXJlZCcsIHsgaW50ZXJhY3Rpb24gfSlcbn1cblxuZnVuY3Rpb24gd2l0aGluSW50ZXJhY3Rpb25MaW1pdDxUIGV4dGVuZHMgSW50ZXJhY3QuQWN0aW9uTmFtZT4gKFxuICBpbnRlcmFjdGFibGU6IEludGVyYWN0LkludGVyYWN0YWJsZSxcbiAgZWxlbWVudDogSW50ZXJhY3QuRWxlbWVudCxcbiAgYWN0aW9uOiBJbnRlcmFjdC5BY3Rpb25Qcm9wczxUPixcbiAgc2NvcGU6IEludGVyYWN0LlNjb3BlLFxuKSB7XG4gIGNvbnN0IG9wdGlvbnMgPSBpbnRlcmFjdGFibGUub3B0aW9uc1xuICBjb25zdCBtYXhBY3Rpb25zID0gb3B0aW9uc1thY3Rpb24ubmFtZV0ubWF4XG4gIGNvbnN0IG1heFBlckVsZW1lbnQgPSBvcHRpb25zW2FjdGlvbi5uYW1lXS5tYXhQZXJFbGVtZW50XG4gIGNvbnN0IGF1dG9TdGFydE1heCA9IHNjb3BlLmF1dG9TdGFydC5tYXhJbnRlcmFjdGlvbnNcbiAgbGV0IGFjdGl2ZUludGVyYWN0aW9ucyA9IDBcbiAgbGV0IGludGVyYWN0YWJsZUNvdW50ID0gMFxuICBsZXQgZWxlbWVudENvdW50ID0gMFxuXG4gIC8vIG5vIGFjdGlvbnMgaWYgYW55IG9mIHRoZXNlIHZhbHVlcyA9PSAwXG4gIGlmICghKG1heEFjdGlvbnMgJiYgbWF4UGVyRWxlbWVudCAmJiBhdXRvU3RhcnRNYXgpKSB7IHJldHVybiBmYWxzZSB9XG5cbiAgZm9yIChjb25zdCBpbnRlcmFjdGlvbiBvZiBzY29wZS5pbnRlcmFjdGlvbnMubGlzdCkge1xuICAgIGNvbnN0IG90aGVyQWN0aW9uID0gaW50ZXJhY3Rpb24ucHJlcGFyZWQubmFtZVxuXG4gICAgaWYgKCFpbnRlcmFjdGlvbi5pbnRlcmFjdGluZygpKSB7IGNvbnRpbnVlIH1cblxuICAgIGFjdGl2ZUludGVyYWN0aW9ucysrXG5cbiAgICBpZiAoYWN0aXZlSW50ZXJhY3Rpb25zID49IGF1dG9TdGFydE1heCkge1xuICAgICAgcmV0dXJuIGZhbHNlXG4gICAgfVxuXG4gICAgaWYgKGludGVyYWN0aW9uLmludGVyYWN0YWJsZSAhPT0gaW50ZXJhY3RhYmxlKSB7IGNvbnRpbnVlIH1cblxuICAgIGludGVyYWN0YWJsZUNvdW50ICs9IG90aGVyQWN0aW9uID09PSBhY3Rpb24ubmFtZSA/IDEgOiAwXG5cbiAgICBpZiAoaW50ZXJhY3RhYmxlQ291bnQgPj0gbWF4QWN0aW9ucykge1xuICAgICAgcmV0dXJuIGZhbHNlXG4gICAgfVxuXG4gICAgaWYgKGludGVyYWN0aW9uLmVsZW1lbnQgPT09IGVsZW1lbnQpIHtcbiAgICAgIGVsZW1lbnRDb3VudCsrXG5cbiAgICAgIGlmIChvdGhlckFjdGlvbiA9PT0gYWN0aW9uLm5hbWUgJiYgZWxlbWVudENvdW50ID49IG1heFBlckVsZW1lbnQpIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlXG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIGF1dG9TdGFydE1heCA+IDBcbn1cblxuZnVuY3Rpb24gbWF4SW50ZXJhY3Rpb25zIChuZXdWYWx1ZTogYW55LCBzY29wZTogSW50ZXJhY3QuU2NvcGUpIHtcbiAgaWYgKHV0aWxzLmlzLm51bWJlcihuZXdWYWx1ZSkpIHtcbiAgICBzY29wZS5hdXRvU3RhcnQubWF4SW50ZXJhY3Rpb25zID0gbmV3VmFsdWVcblxuICAgIHJldHVybiB0aGlzXG4gIH1cblxuICByZXR1cm4gc2NvcGUuYXV0b1N0YXJ0Lm1heEludGVyYWN0aW9uc1xufVxuXG5mdW5jdGlvbiBzZXRDdXJzb3IgKGVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnQsIGN1cnNvcjogc3RyaW5nLCBzY29wZTogSW50ZXJhY3QuU2NvcGUpIHtcbiAgY29uc3QgeyBjdXJzb3JFbGVtZW50OiBwcmV2Q3Vyc29yRWxlbWVudCB9ID0gc2NvcGUuYXV0b1N0YXJ0XG5cbiAgaWYgKHByZXZDdXJzb3JFbGVtZW50ICYmIHByZXZDdXJzb3JFbGVtZW50ICE9PSBlbGVtZW50KSB7XG4gICAgcHJldkN1cnNvckVsZW1lbnQuc3R5bGUuY3Vyc29yID0gJydcbiAgfVxuXG4gIGVsZW1lbnQub3duZXJEb2N1bWVudC5kb2N1bWVudEVsZW1lbnQuc3R5bGUuY3Vyc29yID0gY3Vyc29yXG4gIGVsZW1lbnQuc3R5bGUuY3Vyc29yID0gY3Vyc29yXG4gIHNjb3BlLmF1dG9TdGFydC5jdXJzb3JFbGVtZW50ID0gY3Vyc29yID8gZWxlbWVudCA6IG51bGxcbn1cblxuZnVuY3Rpb24gc2V0SW50ZXJhY3Rpb25DdXJzb3I8VCBleHRlbmRzIEludGVyYWN0LkFjdGlvbk5hbWU+IChpbnRlcmFjdGlvbjogSW50ZXJhY3QuSW50ZXJhY3Rpb248VD4sIHNjb3BlOiBJbnRlcmFjdC5TY29wZSkge1xuICBjb25zdCB7IGludGVyYWN0YWJsZSwgZWxlbWVudCwgcHJlcGFyZWQgfSA9IGludGVyYWN0aW9uXG5cbiAgaWYgKCEoaW50ZXJhY3Rpb24ucG9pbnRlclR5cGUgPT09ICdtb3VzZScgJiYgaW50ZXJhY3RhYmxlICYmIGludGVyYWN0YWJsZS5vcHRpb25zLnN0eWxlQ3Vyc29yKSkge1xuICAgIC8vIGNsZWFyIHByZXZpb3VzIHRhcmdldCBlbGVtZW50IGN1cnNvclxuICAgIGlmIChzY29wZS5hdXRvU3RhcnQuY3Vyc29yRWxlbWVudCkge1xuICAgICAgc2V0Q3Vyc29yKHNjb3BlLmF1dG9TdGFydC5jdXJzb3JFbGVtZW50LCAnJywgc2NvcGUpXG4gICAgfVxuXG4gICAgcmV0dXJuXG4gIH1cblxuICBsZXQgY3Vyc29yID0gJydcblxuICBpZiAocHJlcGFyZWQubmFtZSkge1xuICAgIGNvbnN0IGN1cnNvckNoZWNrZXI6IEludGVyYWN0LkN1cnNvckNoZWNrZXIgPSBpbnRlcmFjdGFibGUub3B0aW9uc1twcmVwYXJlZC5uYW1lXS5jdXJzb3JDaGVja2VyXG5cbiAgICBpZiAodXRpbHMuaXMuZnVuYyhjdXJzb3JDaGVja2VyKSkge1xuICAgICAgY3Vyc29yID0gY3Vyc29yQ2hlY2tlcihwcmVwYXJlZCwgaW50ZXJhY3RhYmxlLCBlbGVtZW50LCBpbnRlcmFjdGlvbi5faW50ZXJhY3RpbmcpXG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgY3Vyc29yID0gc2NvcGUuYWN0aW9ucy5tYXBbcHJlcGFyZWQubmFtZV0uZ2V0Q3Vyc29yKHByZXBhcmVkKVxuICAgIH1cbiAgfVxuXG4gIHNldEN1cnNvcihpbnRlcmFjdGlvbi5lbGVtZW50LCBjdXJzb3IgfHwgJycsIHNjb3BlKVxufVxuXG5jb25zdCBhdXRvU3RhcnQ6IEludGVyYWN0LlBsdWdpbiA9IHtcbiAgaWQ6ICdhdXRvLXN0YXJ0L2Jhc2UnLFxuICBiZWZvcmU6IFsnYWN0aW9ucycsICdhY3Rpb25zL2RyYWcnLCAnYWN0aW9ucy9yZXNpemUnLCAnYWN0aW9ucy9nZXN0dXJlJ10sXG4gIGluc3RhbGwsXG4gIGxpc3RlbmVyczoge1xuICAgICdpbnRlcmFjdGlvbnM6ZG93bic6IHByZXBhcmVPbkRvd24sXG4gICAgJ2ludGVyYWN0aW9uczptb3ZlJzogKGFyZywgc2NvcGUpID0+IHtcbiAgICAgIHByZXBhcmVPbk1vdmUoYXJnLCBzY29wZSlcbiAgICAgIHN0YXJ0T25Nb3ZlKGFyZywgc2NvcGUpXG4gICAgfSxcbiAgICAnaW50ZXJhY3Rpb25zOnN0b3AnOiBjbGVhckN1cnNvck9uU3RvcCxcbiAgfSxcbiAgbWF4SW50ZXJhY3Rpb25zLFxuICB3aXRoaW5JbnRlcmFjdGlvbkxpbWl0LFxuICB2YWxpZGF0ZUFjdGlvbixcbn0gYXMgSW50ZXJhY3QuUGx1Z2luXG5cbmV4cG9ydCBkZWZhdWx0IGF1dG9TdGFydFxuIiwiaW1wb3J0IHsgcGFyZW50Tm9kZSB9IGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2RvbVV0aWxzJ1xuaW1wb3J0ICogYXMgaXMgZnJvbSAnQGludGVyYWN0anMvdXRpbHMvaXMnXG5pbXBvcnQgYXV0b1N0YXJ0IGZyb20gJy4vYmFzZSdcblxuZnVuY3Rpb24gYmVmb3JlU3RhcnQgKHsgaW50ZXJhY3Rpb24sIGV2ZW50VGFyZ2V0LCBkeCwgZHkgfTogSW50ZXJhY3QuU2lnbmFsQXJnc1snaW50ZXJhY3Rpb25zOm1vdmUnXSwgc2NvcGU6IEludGVyYWN0LlNjb3BlKSB7XG4gIGlmIChpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lICE9PSAnZHJhZycpIHsgcmV0dXJuIH1cblxuICAvLyBjaGVjayBpZiBhIGRyYWcgaXMgaW4gdGhlIGNvcnJlY3QgYXhpc1xuICBjb25zdCBhYnNYID0gTWF0aC5hYnMoZHgpXG4gIGNvbnN0IGFic1kgPSBNYXRoLmFicyhkeSlcbiAgY29uc3QgdGFyZ2V0T3B0aW9ucyA9IGludGVyYWN0aW9uLmludGVyYWN0YWJsZS5vcHRpb25zLmRyYWdcbiAgY29uc3Qgc3RhcnRBeGlzID0gdGFyZ2V0T3B0aW9ucy5zdGFydEF4aXNcbiAgY29uc3QgY3VycmVudEF4aXMgPSAoYWJzWCA+IGFic1kgPyAneCcgOiBhYnNYIDwgYWJzWSA/ICd5JyA6ICd4eScpXG5cbiAgaW50ZXJhY3Rpb24ucHJlcGFyZWQuYXhpcyA9IHRhcmdldE9wdGlvbnMubG9ja0F4aXMgPT09ICdzdGFydCdcbiAgICA/IGN1cnJlbnRBeGlzWzBdICBhcyAneCcgfCAneScgLy8gYWx3YXlzIGxvY2sgdG8gb25lIGF4aXMgZXZlbiBpZiBjdXJyZW50QXhpcyA9PT0gJ3h5J1xuICAgIDogdGFyZ2V0T3B0aW9ucy5sb2NrQXhpc1xuXG4gIC8vIGlmIHRoZSBtb3ZlbWVudCBpc24ndCBpbiB0aGUgc3RhcnRBeGlzIG9mIHRoZSBpbnRlcmFjdGFibGVcbiAgaWYgKGN1cnJlbnRBeGlzICE9PSAneHknICYmIHN0YXJ0QXhpcyAhPT0gJ3h5JyAmJiBzdGFydEF4aXMgIT09IGN1cnJlbnRBeGlzKSB7XG4gICAgLy8gY2FuY2VsIHRoZSBwcmVwYXJlZCBhY3Rpb25cbiAgICBpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lID0gbnVsbFxuXG4gICAgLy8gdGhlbiB0cnkgdG8gZ2V0IGEgZHJhZyBmcm9tIGFub3RoZXIgaW5lcmFjdGFibGVcbiAgICBsZXQgZWxlbWVudCA9IGV2ZW50VGFyZ2V0IGFzIEludGVyYWN0LkVsZW1lbnRcblxuICAgIGNvbnN0IGdldERyYWdnYWJsZSA9IGZ1bmN0aW9uIChpbnRlcmFjdGFibGU6IEludGVyYWN0LkludGVyYWN0YWJsZSk6IEludGVyYWN0LkludGVyYWN0YWJsZSB8IHZvaWQge1xuICAgICAgaWYgKGludGVyYWN0YWJsZSA9PT0gaW50ZXJhY3Rpb24uaW50ZXJhY3RhYmxlKSB7IHJldHVybiB9XG5cbiAgICAgIGNvbnN0IG9wdGlvbnMgPSBpbnRlcmFjdGlvbi5pbnRlcmFjdGFibGUub3B0aW9ucy5kcmFnXG5cbiAgICAgIGlmICghb3B0aW9ucy5tYW51YWxTdGFydCAmJlxuICAgICAgICAgIGludGVyYWN0YWJsZS50ZXN0SWdub3JlQWxsb3cob3B0aW9ucywgZWxlbWVudCwgZXZlbnRUYXJnZXQpKSB7XG4gICAgICAgIGNvbnN0IGFjdGlvbiA9IGludGVyYWN0YWJsZS5nZXRBY3Rpb24oXG4gICAgICAgICAgaW50ZXJhY3Rpb24uZG93blBvaW50ZXIsIGludGVyYWN0aW9uLmRvd25FdmVudCwgaW50ZXJhY3Rpb24sIGVsZW1lbnQpXG5cbiAgICAgICAgaWYgKGFjdGlvbiAmJlxuICAgICAgICAgICAgYWN0aW9uLm5hbWUgPT09ICdkcmFnJyAmJlxuICAgICAgICAgICAgY2hlY2tTdGFydEF4aXMoY3VycmVudEF4aXMsIGludGVyYWN0YWJsZSkgJiZcbiAgICAgICAgICAgIGF1dG9TdGFydC52YWxpZGF0ZUFjdGlvbihhY3Rpb24sIGludGVyYWN0YWJsZSwgZWxlbWVudCwgZXZlbnRUYXJnZXQsIHNjb3BlKSkge1xuICAgICAgICAgIHJldHVybiBpbnRlcmFjdGFibGVcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cblxuICAgIC8vIGNoZWNrIGFsbCBpbnRlcmFjdGFibGVzXG4gICAgd2hpbGUgKGlzLmVsZW1lbnQoZWxlbWVudCkpIHtcbiAgICAgIGNvbnN0IGludGVyYWN0YWJsZSA9IHNjb3BlLmludGVyYWN0YWJsZXMuZm9yRWFjaE1hdGNoKGVsZW1lbnQsIGdldERyYWdnYWJsZSlcblxuICAgICAgaWYgKGludGVyYWN0YWJsZSkge1xuICAgICAgICBpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lID0gJ2RyYWcnXG4gICAgICAgIGludGVyYWN0aW9uLmludGVyYWN0YWJsZSA9IGludGVyYWN0YWJsZVxuICAgICAgICBpbnRlcmFjdGlvbi5lbGVtZW50ID0gZWxlbWVudFxuICAgICAgICBicmVha1xuICAgICAgfVxuXG4gICAgICBlbGVtZW50ID0gcGFyZW50Tm9kZShlbGVtZW50KSBhcyBJbnRlcmFjdC5FbGVtZW50XG4gICAgfVxuICB9XG59XG5cbmZ1bmN0aW9uIGNoZWNrU3RhcnRBeGlzIChzdGFydEF4aXM6IHN0cmluZywgaW50ZXJhY3RhYmxlOiBJbnRlcmFjdC5JbnRlcmFjdGFibGUpIHtcbiAgaWYgKCFpbnRlcmFjdGFibGUpIHsgcmV0dXJuIGZhbHNlIH1cblxuICBjb25zdCB0aGlzQXhpcyA9IGludGVyYWN0YWJsZS5vcHRpb25zLmRyYWcuc3RhcnRBeGlzXG5cbiAgcmV0dXJuIChzdGFydEF4aXMgPT09ICd4eScgfHwgdGhpc0F4aXMgPT09ICd4eScgfHwgdGhpc0F4aXMgPT09IHN0YXJ0QXhpcylcbn1cblxuZXhwb3J0IGRlZmF1bHQge1xuICBpZDogJ2F1dG8tc3RhcnQvZHJhZ0F4aXMnLFxuICBsaXN0ZW5lcnM6IHsgJ2F1dG9TdGFydDpiZWZvcmUtc3RhcnQnOiBiZWZvcmVTdGFydCB9LFxufVxuIiwiaW1wb3J0IGJhc2VQbHVnaW4gZnJvbSAnLi9iYXNlJ1xuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvY29yZS9kZWZhdWx0T3B0aW9ucycge1xuICBpbnRlcmZhY2UgUGVyQWN0aW9uRGVmYXVsdHMge1xuICAgIGhvbGQ/OiBudW1iZXJcbiAgICBkZWxheT86IG51bWJlclxuICB9XG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL0ludGVyYWN0aW9uJyB7XG4gIGludGVyZmFjZSBJbnRlcmFjdGlvbiB7XG4gICAgYXV0b1N0YXJ0SG9sZFRpbWVyPzogYW55XG4gIH1cbn1cblxuZnVuY3Rpb24gaW5zdGFsbCAoc2NvcGU6IEludGVyYWN0LlNjb3BlKSB7XG4gIGNvbnN0IHtcbiAgICBkZWZhdWx0cyxcbiAgfSA9IHNjb3BlXG5cbiAgc2NvcGUudXNlUGx1Z2luKGJhc2VQbHVnaW4pXG5cbiAgZGVmYXVsdHMucGVyQWN0aW9uLmhvbGQgPSAwXG4gIGRlZmF1bHRzLnBlckFjdGlvbi5kZWxheSA9IDBcbn1cblxuZnVuY3Rpb24gZ2V0SG9sZER1cmF0aW9uIChpbnRlcmFjdGlvbikge1xuICBjb25zdCBhY3Rpb25OYW1lID0gaW50ZXJhY3Rpb24ucHJlcGFyZWQgJiYgaW50ZXJhY3Rpb24ucHJlcGFyZWQubmFtZVxuXG4gIGlmICghYWN0aW9uTmFtZSkgeyByZXR1cm4gbnVsbCB9XG5cbiAgY29uc3Qgb3B0aW9ucyA9IGludGVyYWN0aW9uLmludGVyYWN0YWJsZS5vcHRpb25zXG5cbiAgcmV0dXJuIG9wdGlvbnNbYWN0aW9uTmFtZV0uaG9sZCB8fCBvcHRpb25zW2FjdGlvbk5hbWVdLmRlbGF5XG59XG5cbmV4cG9ydCBkZWZhdWx0IHtcbiAgaWQ6ICdhdXRvLXN0YXJ0L2hvbGQnLFxuICBpbnN0YWxsLFxuICBsaXN0ZW5lcnM6IHtcbiAgICAnaW50ZXJhY3Rpb25zOm5ldyc6ICh7IGludGVyYWN0aW9uIH0pID0+IHtcbiAgICAgIGludGVyYWN0aW9uLmF1dG9TdGFydEhvbGRUaW1lciA9IG51bGxcbiAgICB9LFxuXG4gICAgJ2F1dG9TdGFydDpwcmVwYXJlZCc6ICh7IGludGVyYWN0aW9uIH0pID0+IHtcbiAgICAgIGNvbnN0IGhvbGQgPSBnZXRIb2xkRHVyYXRpb24oaW50ZXJhY3Rpb24pXG5cbiAgICAgIGlmIChob2xkID4gMCkge1xuICAgICAgICBpbnRlcmFjdGlvbi5hdXRvU3RhcnRIb2xkVGltZXIgPSBzZXRUaW1lb3V0KCgpID0+IHtcbiAgICAgICAgICBpbnRlcmFjdGlvbi5zdGFydChpbnRlcmFjdGlvbi5wcmVwYXJlZCwgaW50ZXJhY3Rpb24uaW50ZXJhY3RhYmxlLCBpbnRlcmFjdGlvbi5lbGVtZW50KVxuICAgICAgICB9LCBob2xkKVxuICAgICAgfVxuICAgIH0sXG5cbiAgICAnaW50ZXJhY3Rpb25zOm1vdmUnOiAoeyBpbnRlcmFjdGlvbiwgZHVwbGljYXRlIH0pID0+IHtcbiAgICAgIGlmIChpbnRlcmFjdGlvbi5wb2ludGVyV2FzTW92ZWQgJiYgIWR1cGxpY2F0ZSkge1xuICAgICAgICBjbGVhclRpbWVvdXQoaW50ZXJhY3Rpb24uYXV0b1N0YXJ0SG9sZFRpbWVyKVxuICAgICAgfVxuICAgIH0sXG5cbiAgICAvLyBwcmV2ZW50IHJlZ3VsYXIgZG93bi0+bW92ZSBhdXRvU3RhcnRcbiAgICAnYXV0b1N0YXJ0OmJlZm9yZS1zdGFydCc6ICh7IGludGVyYWN0aW9uIH0pID0+IHtcbiAgICAgIGNvbnN0IGhvbGQgPSBnZXRIb2xkRHVyYXRpb24oaW50ZXJhY3Rpb24pXG5cbiAgICAgIGlmIChob2xkID4gMCkge1xuICAgICAgICBpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lID0gbnVsbFxuICAgICAgfVxuICAgIH0sXG4gIH0sXG4gIGdldEhvbGREdXJhdGlvbixcbn1cbiIsImltcG9ydCBhdXRvU3RhcnQgZnJvbSAnLi9iYXNlJ1xuaW1wb3J0IGRyYWdBeGlzIGZyb20gJy4vZHJhZ0F4aXMnXG5pbXBvcnQgaG9sZCBmcm9tICcuL2hvbGQnXG5cbmV4cG9ydCBkZWZhdWx0IHtcbiAgaWQ6ICdhdXRvLXN0YXJ0JyxcbiAgaW5zdGFsbCAoc2NvcGUpIHtcbiAgICBzY29wZS51c2VQbHVnaW4oYXV0b1N0YXJ0KVxuICAgIHNjb3BlLnVzZVBsdWdpbihob2xkKVxuICAgIHNjb3BlLnVzZVBsdWdpbihkcmFnQXhpcylcbiAgfSxcbn1cblxuZXhwb3J0IHtcbiAgYXV0b1N0YXJ0LFxuICBob2xkLFxuICBkcmFnQXhpcyxcbn1cbiIsIi8qIGVzbGludC1kaXNhYmxlIG5vLWNvbnNvbGUgKi9cbi8qIGdsb2JhbCBwcm9jZXNzICovXG5pbXBvcnQgZG9tT2JqZWN0cyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9kb21PYmplY3RzJ1xuaW1wb3J0IHsgcGFyZW50Tm9kZSB9IGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2RvbVV0aWxzJ1xuaW1wb3J0IGV4dGVuZCBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9leHRlbmQnXG5pbXBvcnQgKiBhcyBpcyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9pcydcbmltcG9ydCB3aW4gZnJvbSAnQGludGVyYWN0anMvdXRpbHMvd2luZG93J1xuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvY29yZS9zY29wZScge1xuICBpbnRlcmZhY2UgU2NvcGUge1xuICAgIGxvZ2dlcjogTG9nZ2VyXG4gIH1cbn1cblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvZGVmYXVsdE9wdGlvbnMnIHtcbiAgaW50ZXJmYWNlIEJhc2VEZWZhdWx0cyB7XG4gICAgZGV2VG9vbHM/OiBEZXZUb29sc09wdGlvbnNcbiAgfVxufVxuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvY29yZS9JbnRlcmFjdGFibGUnIHtcbiAgaW50ZXJmYWNlIEludGVyYWN0YWJsZSB7XG4gICAgZGV2VG9vbHM/OiBJbnRlcmFjdC5PcHRpb25NZXRob2Q8RGV2VG9vbHNPcHRpb25zPlxuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRGV2VG9vbHNPcHRpb25zIHtcbiAgaWdub3JlOiB7IFtQIGluIGtleW9mIHR5cGVvZiBDaGVja05hbWVdPzogYm9vbGVhbiB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgTG9nZ2VyIHtcbiAgd2FybjogKC4uLmFyZ3M6IGFueVtdKSA9PiB2b2lkXG4gIGVycm9yOiAoLi4uYXJnczogYW55W10pID0+IHZvaWRcbiAgbG9nOiAoLi4uYXJnczogYW55W10pID0+IHZvaWRcbn1cblxuZXhwb3J0IGludGVyZmFjZSBDaGVjayB7XG4gIG5hbWU6IENoZWNrTmFtZVxuICB0ZXh0OiBzdHJpbmdcbiAgcGVyZm9ybTogKGludGVyYWN0aW9uOiBJbnRlcmFjdC5JbnRlcmFjdGlvbikgPT4gYm9vbGVhblxuICBnZXRJbmZvOiAoaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uKSA9PiBhbnlbXVxufVxuXG5lbnVtIENoZWNrTmFtZSB7XG4gIHRvdWNoQWN0aW9uID0gJ3RvdWNoQWN0aW9uJyxcbiAgYm94U2l6aW5nID0gJ2JveFNpemluZycsXG4gIG5vTGlzdGVuZXJzID0gJ25vTGlzdGVuZXJzJyxcbn1cblxuY29uc3QgcHJlZml4ICA9ICdbaW50ZXJhY3QuanNdICdcbmNvbnN0IGxpbmtzID0ge1xuICB0b3VjaEFjdGlvbjogJ2h0dHBzOi8vZGV2ZWxvcGVyLm1vemlsbGEub3JnL2VuLVVTL2RvY3MvV2ViL0NTUy90b3VjaC1hY3Rpb24nLFxuICBib3hTaXppbmc6ICdodHRwczovL2RldmVsb3Blci5tb3ppbGxhLm9yZy9lbi1VUy9kb2NzL1dlYi9DU1MvYm94LXNpemluZycsXG59XG5cbmNvbnN0IGlzUHJvZHVjdGlvbiA9IHByb2Nlc3MuZW52Lk5PREVfRU5WID09PSAncHJvZHVjdGlvbidcblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLXJlc3RyaWN0ZWQtc3ludGF4XG5mdW5jdGlvbiBpbnN0YWxsIChzY29wZTogSW50ZXJhY3QuU2NvcGUsIHsgbG9nZ2VyIH06IHsgbG9nZ2VyPzogTG9nZ2VyIH0gPSB7fSkge1xuICBjb25zdCB7XG4gICAgSW50ZXJhY3RhYmxlLFxuICAgIGRlZmF1bHRzLFxuICB9ID0gc2NvcGVcblxuICBzY29wZS5sb2dnZXIgPSBsb2dnZXIgfHwgY29uc29sZVxuXG4gIGRlZmF1bHRzLmJhc2UuZGV2VG9vbHMgPSB7XG4gICAgaWdub3JlOiB7fSxcbiAgfVxuXG4gIEludGVyYWN0YWJsZS5wcm90b3R5cGUuZGV2VG9vbHMgPSBmdW5jdGlvbiAob3B0aW9ucz86IG9iamVjdCkge1xuICAgIGlmIChvcHRpb25zKSB7XG4gICAgICBleHRlbmQodGhpcy5vcHRpb25zLmRldlRvb2xzLCBvcHRpb25zKVxuICAgICAgcmV0dXJuIHRoaXNcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpcy5vcHRpb25zLmRldlRvb2xzXG4gIH1cbn1cblxuY29uc3QgY2hlY2tzOiBDaGVja1tdID0gW1xuICB7XG4gICAgbmFtZTogQ2hlY2tOYW1lLnRvdWNoQWN0aW9uLFxuICAgIHBlcmZvcm0gKHsgZWxlbWVudCB9KSB7XG4gICAgICByZXR1cm4gIXBhcmVudEhhc1N0eWxlKGVsZW1lbnQsICd0b3VjaEFjdGlvbicsIC9wYW4tfHBpbmNofG5vbmUvKVxuICAgIH0sXG4gICAgZ2V0SW5mbyAoeyBlbGVtZW50IH0pIHtcbiAgICAgIHJldHVybiBbXG4gICAgICAgIGVsZW1lbnQsXG4gICAgICAgIGxpbmtzLnRvdWNoQWN0aW9uLFxuICAgICAgXVxuICAgIH0sXG4gICAgdGV4dDogJ0NvbnNpZGVyIGFkZGluZyBDU1MgXCJ0b3VjaC1hY3Rpb246IG5vbmVcIiB0byB0aGlzIGVsZW1lbnRcXG4nLFxuICB9LFxuXG4gIHtcbiAgICBuYW1lOiBDaGVja05hbWUuYm94U2l6aW5nLFxuICAgIHBlcmZvcm0gKGludGVyYWN0aW9uKSB7XG4gICAgICBjb25zdCB7IGVsZW1lbnQgfSA9IGludGVyYWN0aW9uXG5cbiAgICAgIHJldHVybiBpbnRlcmFjdGlvbi5wcmVwYXJlZC5uYW1lID09PSAncmVzaXplJyAmJlxuICAgICAgICBlbGVtZW50IGluc3RhbmNlb2YgZG9tT2JqZWN0cy5IVE1MRWxlbWVudCAmJlxuICAgICAgICAhaGFzU3R5bGUoZWxlbWVudCwgJ2JveFNpemluZycsIC9ib3JkZXItYm94LylcbiAgICB9LFxuICAgIHRleHQ6ICdDb25zaWRlciBhZGRpbmcgQ1NTIFwiYm94LXNpemluZzogYm9yZGVyLWJveFwiIHRvIHRoaXMgcmVzaXphYmxlIGVsZW1lbnQnLFxuICAgIGdldEluZm8gKHsgZWxlbWVudCB9KSB7XG4gICAgICByZXR1cm4gW1xuICAgICAgICBlbGVtZW50LFxuICAgICAgICBsaW5rcy5ib3hTaXppbmcsXG4gICAgICBdXG4gICAgfSxcbiAgfSxcblxuICB7XG4gICAgbmFtZTogQ2hlY2tOYW1lLm5vTGlzdGVuZXJzLFxuICAgIHBlcmZvcm0gKGludGVyYWN0aW9uKSB7XG4gICAgICBjb25zdCBhY3Rpb25OYW1lID0gaW50ZXJhY3Rpb24ucHJlcGFyZWQubmFtZVxuICAgICAgY29uc3QgbW92ZUxpc3RlbmVycyA9IGludGVyYWN0aW9uLmludGVyYWN0YWJsZS5ldmVudHMudHlwZXNbYCR7YWN0aW9uTmFtZX1tb3ZlYF0gfHwgW11cblxuICAgICAgcmV0dXJuICFtb3ZlTGlzdGVuZXJzLmxlbmd0aFxuICAgIH0sXG4gICAgZ2V0SW5mbyAoaW50ZXJhY3Rpb24pIHtcbiAgICAgIHJldHVybiBbXG4gICAgICAgIGludGVyYWN0aW9uLnByZXBhcmVkLm5hbWUsXG4gICAgICAgIGludGVyYWN0aW9uLmludGVyYWN0YWJsZSxcbiAgICAgIF1cbiAgICB9LFxuICAgIHRleHQ6ICdUaGVyZSBhcmUgbm8gbGlzdGVuZXJzIHNldCBmb3IgdGhpcyBhY3Rpb24nLFxuICB9LFxuXVxuXG5mdW5jdGlvbiBoYXNTdHlsZSAoZWxlbWVudDogSFRNTEVsZW1lbnQsIHByb3A6IGtleW9mIENTU1N0eWxlRGVjbGFyYXRpb24sIHN0eWxlUmU6IFJlZ0V4cCkge1xuICByZXR1cm4gc3R5bGVSZS50ZXN0KGVsZW1lbnQuc3R5bGVbcHJvcF0gfHwgd2luLndpbmRvdy5nZXRDb21wdXRlZFN0eWxlKGVsZW1lbnQpW3Byb3BdKVxufVxuXG5mdW5jdGlvbiBwYXJlbnRIYXNTdHlsZSAoZWxlbWVudDogSW50ZXJhY3QuRWxlbWVudCwgcHJvcDoga2V5b2YgQ1NTU3R5bGVEZWNsYXJhdGlvbiwgc3R5bGVSZTogUmVnRXhwKSB7XG4gIGxldCBwYXJlbnQgPSBlbGVtZW50IGFzIEhUTUxFbGVtZW50XG5cbiAgd2hpbGUgKGlzLmVsZW1lbnQocGFyZW50KSkge1xuICAgIGlmIChoYXNTdHlsZShwYXJlbnQsIHByb3AsIHN0eWxlUmUpKSB7XG4gICAgICByZXR1cm4gdHJ1ZVxuICAgIH1cblxuICAgIHBhcmVudCA9IHBhcmVudE5vZGUocGFyZW50KSBhcyBIVE1MRWxlbWVudFxuICB9XG5cbiAgcmV0dXJuIGZhbHNlXG59XG5cbmNvbnN0IGlkID0gJ2Rldi10b29scydcbmNvbnN0IGRlZmF1bHRFeHBvcnQ6IEludGVyYWN0LlBsdWdpbiA9IGlzUHJvZHVjdGlvblxuICA/IHsgaWQsIGluc3RhbGw6ICgpID0+IHt9IH1cbiAgOiB7XG4gICAgaWQsXG4gICAgaW5zdGFsbCxcbiAgICBsaXN0ZW5lcnM6IHtcbiAgICAgICdpbnRlcmFjdGlvbnM6YWN0aW9uLXN0YXJ0JzogKHsgaW50ZXJhY3Rpb24gfSwgc2NvcGUpID0+IHtcbiAgICAgICAgZm9yIChjb25zdCBjaGVjayBvZiBjaGVja3MpIHtcbiAgICAgICAgICBjb25zdCBvcHRpb25zID0gaW50ZXJhY3Rpb24uaW50ZXJhY3RhYmxlICYmIGludGVyYWN0aW9uLmludGVyYWN0YWJsZS5vcHRpb25zXG5cbiAgICAgICAgICBpZiAoXG4gICAgICAgICAgICAhKG9wdGlvbnMgJiYgb3B0aW9ucy5kZXZUb29scyAmJiBvcHRpb25zLmRldlRvb2xzLmlnbm9yZVtjaGVjay5uYW1lXSkgJiZcbiAgICAgICAgICAgIGNoZWNrLnBlcmZvcm0oaW50ZXJhY3Rpb24pXG4gICAgICAgICAgKSB7XG4gICAgICAgICAgICBzY29wZS5sb2dnZXIud2FybihwcmVmaXggKyBjaGVjay50ZXh0LCAuLi5jaGVjay5nZXRJbmZvKGludGVyYWN0aW9uKSlcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH0sXG4gICAgfSxcbiAgICBjaGVja3MsXG4gICAgQ2hlY2tOYW1lLFxuICAgIGxpbmtzLFxuICAgIHByZWZpeCxcbiAgfVxuXG5leHBvcnQgZGVmYXVsdCBkZWZhdWx0RXhwb3J0XG4iLCJpbXBvcnQgY2xvbmUgZnJvbSAnQGludGVyYWN0anMvdXRpbHMvY2xvbmUnXG5pbXBvcnQgZXh0ZW5kIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2V4dGVuZCdcbmltcG9ydCAqIGFzIHJlY3RVdGlscyBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9yZWN0J1xuaW1wb3J0IHsgTW9kaWZpZXIsIE1vZGlmaWVyQXJnLCBNb2RpZmllclN0YXRlIH0gZnJvbSAnLi9iYXNlJ1xuXG5leHBvcnQgaW50ZXJmYWNlIE1vZGlmaWNhdGlvblJlc3VsdCB7XG4gIGRlbHRhOiBJbnRlcmFjdC5Qb2ludFxuICByZWN0RGVsdGE6IEludGVyYWN0LlJlY3RcbiAgY29vcmRzOiBJbnRlcmFjdC5Qb2ludFxuICByZWN0OiBJbnRlcmFjdC5GdWxsUmVjdFxuICBldmVudFByb3BzOiBhbnlbXVxuICBjaGFuZ2VkOiBib29sZWFuXG59XG5cbmludGVyZmFjZSBNZXRob2RBcmcge1xuICBwaGFzZTogSW50ZXJhY3QuRXZlbnRQaGFzZVxuICBwYWdlQ29vcmRzPzogSW50ZXJhY3QuUG9pbnRcbiAgcmVjdD86IEludGVyYWN0LkZ1bGxSZWN0XG4gIGNvb3Jkcz86IEludGVyYWN0LlBvaW50XG4gIHByZUVuZD86IGJvb2xlYW5cbiAgc2tpcE1vZGlmaWVycz86IG51bWJlclxufVxuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBNb2RpZmljYXRpb24ge1xuICBzdGF0ZXM6IE1vZGlmaWVyU3RhdGVbXSA9IFtdXG4gIHN0YXJ0T2Zmc2V0OiBJbnRlcmFjdC5SZWN0ID0geyBsZWZ0OiAwLCByaWdodDogMCwgdG9wOiAwLCBib3R0b206IDAgfVxuICBzdGFydERlbHRhOiBJbnRlcmFjdC5Qb2ludCA9IG51bGxcbiAgcmVzdWx0PzogTW9kaWZpY2F0aW9uUmVzdWx0ID0gbnVsbFxuICBlbmRSZXN1bHQ/OiBJbnRlcmFjdC5Qb2ludCA9IG51bGxcbiAgZWRnZXM6IEludGVyYWN0LkVkZ2VPcHRpb25zXG5cbiAgY29uc3RydWN0b3IgKHJlYWRvbmx5IGludGVyYWN0aW9uOiBSZWFkb25seTxJbnRlcmFjdC5JbnRlcmFjdGlvbj4pIHtcbiAgICB0aGlzLnJlc3VsdCA9IGNyZWF0ZVJlc3VsdCgpXG4gIH1cblxuICBzdGFydCAoXG4gICAgeyBwaGFzZSB9OiBNZXRob2RBcmcsXG4gICAgcGFnZUNvb3JkczogSW50ZXJhY3QuUG9pbnQsXG4gICkge1xuICAgIGNvbnN0IHsgaW50ZXJhY3Rpb24gfSA9IHRoaXNcbiAgICBjb25zdCBtb2RpZmllckxpc3QgPSBnZXRNb2RpZmllckxpc3QoaW50ZXJhY3Rpb24pXG4gICAgdGhpcy5wcmVwYXJlU3RhdGVzKG1vZGlmaWVyTGlzdClcblxuICAgIHRoaXMuZWRnZXMgPSBleHRlbmQoe30sIGludGVyYWN0aW9uLmVkZ2VzKVxuICAgIHRoaXMuc3RhcnRPZmZzZXQgPSBnZXRSZWN0T2Zmc2V0KGludGVyYWN0aW9uLnJlY3QsIHBhZ2VDb29yZHMpXG4gICAgdGhpcy5zdGFydERlbHRhID0geyB4OiAwLCB5OiAwIH1cblxuICAgIGNvbnN0IGFyZzogTWV0aG9kQXJnID0ge1xuICAgICAgcGhhc2UsXG4gICAgICBwYWdlQ29vcmRzLFxuICAgICAgcHJlRW5kOiBmYWxzZSxcbiAgICB9XG5cbiAgICB0aGlzLnJlc3VsdCA9IGNyZWF0ZVJlc3VsdCgpXG4gICAgdGhpcy5zdGFydEFsbChhcmcpXG5cbiAgICBjb25zdCByZXN1bHQgPSB0aGlzLnJlc3VsdCA9IHRoaXMuc2V0QWxsKGFyZylcblxuICAgIHJldHVybiByZXN1bHRcbiAgfVxuXG4gIGZpbGxBcmcgKGFyZzogUGFydGlhbDxNb2RpZmllckFyZz4pIHtcbiAgICBjb25zdCB7IGludGVyYWN0aW9uIH0gPSB0aGlzXG5cbiAgICBhcmcuaW50ZXJhY3Rpb24gPSBpbnRlcmFjdGlvblxuICAgIGFyZy5pbnRlcmFjdGFibGUgPSBpbnRlcmFjdGlvbi5pbnRlcmFjdGFibGVcbiAgICBhcmcuZWxlbWVudCA9IGludGVyYWN0aW9uLmVsZW1lbnRcbiAgICBhcmcucmVjdCA9IGFyZy5yZWN0IHx8IGludGVyYWN0aW9uLnJlY3RcbiAgICBhcmcuZWRnZXMgPSB0aGlzLmVkZ2VzXG4gICAgYXJnLnN0YXJ0T2Zmc2V0ID0gdGhpcy5zdGFydE9mZnNldFxuICB9XG5cbiAgc3RhcnRBbGwgKGFyZzogTWV0aG9kQXJnICYgUGFydGlhbDxNb2RpZmllckFyZz4pIHtcbiAgICB0aGlzLmZpbGxBcmcoYXJnKVxuXG4gICAgZm9yIChjb25zdCBzdGF0ZSBvZiB0aGlzLnN0YXRlcykge1xuICAgICAgaWYgKHN0YXRlLm1ldGhvZHMuc3RhcnQpIHtcbiAgICAgICAgYXJnLnN0YXRlID0gc3RhdGVcbiAgICAgICAgc3RhdGUubWV0aG9kcy5zdGFydChhcmcgYXMgTW9kaWZpZXJBcmcpXG4gICAgICB9XG4gICAgfVxuICB9XG5cbiAgc2V0QWxsIChhcmc6IE1ldGhvZEFyZyAmIFBhcnRpYWw8TW9kaWZpZXJBcmc+KTogTW9kaWZpY2F0aW9uUmVzdWx0IHtcbiAgICB0aGlzLmZpbGxBcmcoYXJnKVxuXG4gICAgY29uc3Qge1xuICAgICAgcGhhc2UsXG4gICAgICBwcmVFbmQsXG4gICAgICBza2lwTW9kaWZpZXJzLFxuICAgICAgcmVjdDogdW5tb2RpZmllZFJlY3QsXG4gICAgfSA9IGFyZ1xuXG4gICAgYXJnLmNvb3JkcyA9IGV4dGVuZCh7fSwgYXJnLnBhZ2VDb29yZHMpXG4gICAgYXJnLnJlY3QgPSBleHRlbmQoe30sIHVubW9kaWZpZWRSZWN0KVxuXG4gICAgY29uc3Qgc3RhdGVzID0gc2tpcE1vZGlmaWVyc1xuICAgICAgPyB0aGlzLnN0YXRlcy5zbGljZShza2lwTW9kaWZpZXJzKVxuICAgICAgOiB0aGlzLnN0YXRlc1xuXG4gICAgY29uc3QgbmV3UmVzdWx0ID0gY3JlYXRlUmVzdWx0KGFyZy5jb29yZHMsIGFyZy5yZWN0KVxuXG4gICAgZm9yIChjb25zdCBzdGF0ZSBvZiBzdGF0ZXMpIHtcbiAgICAgIGNvbnN0IHsgb3B0aW9ucyB9ID0gc3RhdGVcbiAgICAgIGNvbnN0IGxhc3RNb2RpZmllckNvb3JkcyA9IGV4dGVuZCh7fSwgYXJnLmNvb3JkcylcbiAgICAgIGxldCByZXR1cm5WYWx1ZSA9IG51bGxcblxuICAgICAgaWYgKHN0YXRlLm1ldGhvZHMuc2V0ICYmIHRoaXMuc2hvdWxkRG8ob3B0aW9ucywgcHJlRW5kLCBwaGFzZSkpIHtcbiAgICAgICAgYXJnLnN0YXRlID0gc3RhdGVcbiAgICAgICAgcmV0dXJuVmFsdWUgPSBzdGF0ZS5tZXRob2RzLnNldChhcmcgYXMgTW9kaWZpZXJBcmcpXG5cbiAgICAgICAgcmVjdFV0aWxzLmFkZEVkZ2VzKHRoaXMuaW50ZXJhY3Rpb24uZWRnZXMsIGFyZy5yZWN0LCB7IHg6IGFyZy5jb29yZHMueCAtIGxhc3RNb2RpZmllckNvb3Jkcy54LCB5OiBhcmcuY29vcmRzLnkgLSBsYXN0TW9kaWZpZXJDb29yZHMueSB9KVxuICAgICAgfVxuXG4gICAgICBuZXdSZXN1bHQuZXZlbnRQcm9wcy5wdXNoKHJldHVyblZhbHVlKVxuICAgIH1cblxuICAgIG5ld1Jlc3VsdC5kZWx0YS54ID0gYXJnLmNvb3Jkcy54IC0gYXJnLnBhZ2VDb29yZHMueFxuICAgIG5ld1Jlc3VsdC5kZWx0YS55ID0gYXJnLmNvb3Jkcy55IC0gYXJnLnBhZ2VDb29yZHMueVxuXG4gICAgbmV3UmVzdWx0LnJlY3REZWx0YS5sZWZ0ICAgPSBhcmcucmVjdC5sZWZ0IC0gdW5tb2RpZmllZFJlY3QubGVmdFxuICAgIG5ld1Jlc3VsdC5yZWN0RGVsdGEucmlnaHQgID0gYXJnLnJlY3QucmlnaHQgLSB1bm1vZGlmaWVkUmVjdC5yaWdodFxuICAgIG5ld1Jlc3VsdC5yZWN0RGVsdGEudG9wICAgID0gYXJnLnJlY3QudG9wIC0gdW5tb2RpZmllZFJlY3QudG9wXG4gICAgbmV3UmVzdWx0LnJlY3REZWx0YS5ib3R0b20gPSBhcmcucmVjdC5ib3R0b20gLSB1bm1vZGlmaWVkUmVjdC5ib3R0b21cblxuICAgIGNvbnN0IHByZXZDb29yZHMgPSB0aGlzLnJlc3VsdC5jb29yZHNcbiAgICBjb25zdCBwcmV2UmVjdCA9IHRoaXMucmVzdWx0LnJlY3RcblxuICAgIGlmIChwcmV2Q29vcmRzICYmIHByZXZSZWN0KSB7XG4gICAgICBjb25zdCByZWN0Q2hhbmdlZCA9IG5ld1Jlc3VsdC5yZWN0LmxlZnQgIT09IHByZXZSZWN0LmxlZnQgfHxcbiAgICAgICAgbmV3UmVzdWx0LnJlY3QucmlnaHQgIT09IHByZXZSZWN0LnJpZ2h0IHx8XG4gICAgICAgIG5ld1Jlc3VsdC5yZWN0LnRvcCAhPT0gcHJldlJlY3QudG9wIHx8XG4gICAgICAgIG5ld1Jlc3VsdC5yZWN0LmJvdHRvbSAhPT0gcHJldlJlY3QuYm90dG9tXG5cbiAgICAgIG5ld1Jlc3VsdC5jaGFuZ2VkID0gcmVjdENoYW5nZWQgfHxcbiAgICAgICAgcHJldkNvb3Jkcy54ICE9PSBuZXdSZXN1bHQuY29vcmRzLnggfHxcbiAgICAgICAgcHJldkNvb3Jkcy55ICE9PSBuZXdSZXN1bHQuY29vcmRzLnlcbiAgICB9XG5cbiAgICByZXR1cm4gbmV3UmVzdWx0XG4gIH1cblxuICBhcHBseVRvSW50ZXJhY3Rpb24gKGFyZzogeyBwaGFzZTogSW50ZXJhY3QuRXZlbnRQaGFzZSwgcmVjdD86IEludGVyYWN0LlJlY3QgfSkge1xuICAgIGNvbnN0IHsgaW50ZXJhY3Rpb24gfSA9IHRoaXNcbiAgICBjb25zdCB7IHBoYXNlIH0gPSBhcmdcbiAgICBjb25zdCBjdXJDb29yZHMgPSBpbnRlcmFjdGlvbi5jb29yZHMuY3VyXG4gICAgY29uc3Qgc3RhcnRDb29yZHMgPSBpbnRlcmFjdGlvbi5jb29yZHMuc3RhcnRcbiAgICBjb25zdCB7IHJlc3VsdCwgc3RhcnREZWx0YSB9ID0gdGhpc1xuICAgIGNvbnN0IGN1ckRlbHRhID0gcmVzdWx0LmRlbHRhXG5cbiAgICBpZiAocGhhc2UgPT09ICdzdGFydCcpIHtcbiAgICAgIGV4dGVuZCh0aGlzLnN0YXJ0RGVsdGEsIHJlc3VsdC5kZWx0YSlcbiAgICB9XG5cbiAgICBmb3IgKGNvbnN0IFtjb29yZHNTZXQsIGRlbHRhXSBvZiBbW3N0YXJ0Q29vcmRzLCBzdGFydERlbHRhXSwgW2N1ckNvb3JkcywgY3VyRGVsdGFdXSBhcyBjb25zdCkge1xuICAgICAgY29vcmRzU2V0LnBhZ2UueCAgICs9IGRlbHRhLnhcbiAgICAgIGNvb3Jkc1NldC5wYWdlLnkgICArPSBkZWx0YS55XG4gICAgICBjb29yZHNTZXQuY2xpZW50LnggKz0gZGVsdGEueFxuICAgICAgY29vcmRzU2V0LmNsaWVudC55ICs9IGRlbHRhLnlcbiAgICB9XG5cbiAgICBjb25zdCB7IHJlY3REZWx0YSB9ID0gdGhpcy5yZXN1bHRcbiAgICBjb25zdCByZWN0ID0gYXJnLnJlY3QgfHwgaW50ZXJhY3Rpb24ucmVjdFxuXG4gICAgcmVjdC5sZWZ0ICAgKz0gcmVjdERlbHRhLmxlZnRcbiAgICByZWN0LnJpZ2h0ICArPSByZWN0RGVsdGEucmlnaHRcbiAgICByZWN0LnRvcCAgICArPSByZWN0RGVsdGEudG9wXG4gICAgcmVjdC5ib3R0b20gKz0gcmVjdERlbHRhLmJvdHRvbVxuXG4gICAgcmVjdC53aWR0aCA9IHJlY3QucmlnaHQgLSByZWN0LmxlZnRcbiAgICByZWN0LmhlaWdodCA9IHJlY3QuYm90dG9tIC0gcmVjdC50b3BcbiAgfVxuXG4gIHNldEFuZEFwcGx5IChhcmc6IFBhcnRpYWw8SW50ZXJhY3QuRG9BbnlQaGFzZUFyZz4gJiB7XG4gICAgcGhhc2U6IEludGVyYWN0LkV2ZW50UGhhc2VcbiAgICBwcmVFbmQ/OiBib29sZWFuXG4gICAgc2tpcE1vZGlmaWVycz86IG51bWJlclxuICAgIG1vZGlmaWVkQ29vcmRzPzogSW50ZXJhY3QuUG9pbnRcbiAgfSk6IHZvaWQgfCBmYWxzZSB7XG4gICAgY29uc3QgeyBpbnRlcmFjdGlvbiB9ID0gdGhpc1xuICAgIGNvbnN0IHsgcGhhc2UsIHByZUVuZCwgc2tpcE1vZGlmaWVycyB9ID0gYXJnXG5cbiAgICBjb25zdCByZXN1bHQgPSB0aGlzLnNldEFsbCh7XG4gICAgICBwcmVFbmQsXG4gICAgICBwaGFzZSxcbiAgICAgIHBhZ2VDb29yZHM6IGFyZy5tb2RpZmllZENvb3JkcyB8fCBpbnRlcmFjdGlvbi5jb29yZHMuY3VyLnBhZ2UsXG4gICAgfSlcblxuICAgIHRoaXMucmVzdWx0ID0gcmVzdWx0XG5cbiAgICAvLyBkb24ndCBmaXJlIGFuIGFjdGlvbiBtb3ZlIGlmIGEgbW9kaWZpZXIgd291bGQga2VlcCB0aGUgZXZlbnQgaW4gdGhlIHNhbWVcbiAgICAvLyBjb3JkaW5hdGVzIGFzIGJlZm9yZVxuICAgIGlmICghcmVzdWx0LmNoYW5nZWQgJiYgKCFza2lwTW9kaWZpZXJzIHx8IHNraXBNb2RpZmllcnMgPCB0aGlzLnN0YXRlcy5sZW5ndGgpICYmIGludGVyYWN0aW9uLmludGVyYWN0aW5nKCkpIHtcbiAgICAgIHJldHVybiBmYWxzZVxuICAgIH1cblxuICAgIGlmIChhcmcubW9kaWZpZWRDb29yZHMpIHtcbiAgICAgIGNvbnN0IHsgcGFnZSB9ID0gaW50ZXJhY3Rpb24uY29vcmRzLmN1clxuICAgICAgY29uc3QgYWRqdXN0bWVudCA9IHtcbiAgICAgICAgeDogYXJnLm1vZGlmaWVkQ29vcmRzLnggLSBwYWdlLngsXG4gICAgICAgIHk6IGFyZy5tb2RpZmllZENvb3Jkcy55IC0gcGFnZS55LFxuICAgICAgfVxuXG4gICAgICByZXN1bHQuY29vcmRzLnggKz0gYWRqdXN0bWVudC54XG4gICAgICByZXN1bHQuY29vcmRzLnkgKz0gYWRqdXN0bWVudC55XG4gICAgICByZXN1bHQuZGVsdGEueCArPSBhZGp1c3RtZW50LnhcbiAgICAgIHJlc3VsdC5kZWx0YS55ICs9IGFkanVzdG1lbnQueVxuICAgIH1cblxuICAgIHRoaXMuYXBwbHlUb0ludGVyYWN0aW9uKGFyZylcbiAgfVxuXG4gIGJlZm9yZUVuZCAoYXJnOiBPbWl0PEludGVyYWN0LkRvQW55UGhhc2VBcmcsICdpRXZlbnQnPiAmIHsgc3RhdGU/OiBNb2RpZmllclN0YXRlIH0pOiB2b2lkIHwgZmFsc2Uge1xuICAgIGNvbnN0IHsgaW50ZXJhY3Rpb24sIGV2ZW50IH0gPSBhcmdcbiAgICBjb25zdCBzdGF0ZXMgPSB0aGlzLnN0YXRlc1xuXG4gICAgaWYgKCFzdGF0ZXMgfHwgIXN0YXRlcy5sZW5ndGgpIHtcbiAgICAgIHJldHVyblxuICAgIH1cblxuICAgIGxldCBkb1ByZWVuZCA9IGZhbHNlXG5cbiAgICBmb3IgKGNvbnN0IHN0YXRlIG9mIHN0YXRlcykge1xuICAgICAgYXJnLnN0YXRlID0gc3RhdGVcbiAgICAgIGNvbnN0IHsgb3B0aW9ucywgbWV0aG9kcyB9ID0gc3RhdGVcblxuICAgICAgY29uc3QgZW5kUG9zaXRpb24gPSBtZXRob2RzLmJlZm9yZUVuZCAmJiBtZXRob2RzLmJlZm9yZUVuZChhcmcgYXMgdW5rbm93biBhcyBNb2RpZmllckFyZylcblxuICAgICAgaWYgKGVuZFBvc2l0aW9uKSB7XG4gICAgICAgIHRoaXMuZW5kUmVzdWx0ID0gZW5kUG9zaXRpb25cbiAgICAgICAgcmV0dXJuIGZhbHNlXG4gICAgICB9XG5cbiAgICAgIGRvUHJlZW5kID0gZG9QcmVlbmQgfHwgKCFkb1ByZWVuZCAmJiB0aGlzLnNob3VsZERvKG9wdGlvbnMsIHRydWUsIGFyZy5waGFzZSwgdHJ1ZSkpXG4gICAgfVxuXG4gICAgaWYgKGRvUHJlZW5kKSB7XG4gICAgICAvLyB0cmlnZ2VyIGEgZmluYWwgbW9kaWZpZWQgbW92ZSBiZWZvcmUgZW5kaW5nXG4gICAgICBpbnRlcmFjdGlvbi5tb3ZlKHsgZXZlbnQsIHByZUVuZDogdHJ1ZSB9KVxuICAgIH1cbiAgfVxuXG4gIHN0b3AgKGFyZzogeyBpbnRlcmFjdGlvbjogSW50ZXJhY3QuSW50ZXJhY3Rpb24gfSkge1xuICAgIGNvbnN0IHsgaW50ZXJhY3Rpb24gfSA9IGFyZ1xuXG4gICAgaWYgKCF0aGlzLnN0YXRlcyB8fCAhdGhpcy5zdGF0ZXMubGVuZ3RoKSB7XG4gICAgICByZXR1cm5cbiAgICB9XG5cbiAgICBjb25zdCBtb2RpZmllckFyZzogUGFydGlhbDxNb2RpZmllckFyZz4gPSBleHRlbmQoe1xuICAgICAgc3RhdGVzOiB0aGlzLnN0YXRlcyxcbiAgICAgIGludGVyYWN0YWJsZTogaW50ZXJhY3Rpb24uaW50ZXJhY3RhYmxlLFxuICAgICAgZWxlbWVudDogaW50ZXJhY3Rpb24uZWxlbWVudCxcbiAgICAgIHJlY3Q6IG51bGwsXG4gICAgfSwgYXJnKVxuXG4gICAgdGhpcy5maWxsQXJnKG1vZGlmaWVyQXJnKVxuXG4gICAgZm9yIChjb25zdCBzdGF0ZSBvZiB0aGlzLnN0YXRlcykge1xuICAgICAgbW9kaWZpZXJBcmcuc3RhdGUgPSBzdGF0ZVxuXG4gICAgICBpZiAoc3RhdGUubWV0aG9kcy5zdG9wKSB7IHN0YXRlLm1ldGhvZHMuc3RvcChtb2RpZmllckFyZyBhcyBNb2RpZmllckFyZykgfVxuICAgIH1cblxuICAgIHRoaXMuc3RhdGVzID0gbnVsbFxuICAgIHRoaXMuZW5kUmVzdWx0ID0gbnVsbFxuICB9XG5cbiAgcHJlcGFyZVN0YXRlcyAobW9kaWZpZXJMaXN0OiBNb2RpZmllcltdKSB7XG4gICAgdGhpcy5zdGF0ZXMgPSBbXVxuXG4gICAgZm9yIChsZXQgaW5kZXggPSAwOyBpbmRleCA8IG1vZGlmaWVyTGlzdC5sZW5ndGg7IGluZGV4KyspIHtcbiAgICAgIGNvbnN0IHsgb3B0aW9ucywgbWV0aG9kcywgbmFtZSB9ID0gbW9kaWZpZXJMaXN0W2luZGV4XVxuXG4gICAgICBpZiAob3B0aW9ucyAmJiBvcHRpb25zLmVuYWJsZWQgPT09IGZhbHNlKSB7IGNvbnRpbnVlIH1cblxuICAgICAgdGhpcy5zdGF0ZXMucHVzaCh7XG4gICAgICAgIG9wdGlvbnMsXG4gICAgICAgIG1ldGhvZHMsXG4gICAgICAgIGluZGV4LFxuICAgICAgICBuYW1lLFxuICAgICAgfSlcbiAgICB9XG5cbiAgICByZXR1cm4gdGhpcy5zdGF0ZXNcbiAgfVxuXG4gIHJlc3RvcmVJbnRlcmFjdGlvbkNvb3JkcyAoeyBpbnRlcmFjdGlvbjogeyBjb29yZHMsIHJlY3QsIG1vZGlmaWNhdGlvbiB9IH06IHsgaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uIH0pIHtcbiAgICBpZiAoIW1vZGlmaWNhdGlvbi5yZXN1bHQpIHsgcmV0dXJuIH1cblxuICAgIGNvbnN0IHsgc3RhcnREZWx0YSB9ID0gbW9kaWZpY2F0aW9uXG4gICAgY29uc3QgeyBkZWx0YTogY3VyRGVsdGEsIHJlY3REZWx0YSB9ID0gbW9kaWZpY2F0aW9uLnJlc3VsdFxuXG4gICAgY29uc3QgY29vcmRzQW5kRGVsdGFzID0gW1xuICAgICAgW2Nvb3Jkcy5zdGFydCwgc3RhcnREZWx0YV0sXG4gICAgICBbY29vcmRzLmN1ciwgY3VyRGVsdGFdLFxuICAgIF1cblxuICAgIGZvciAoY29uc3QgW2Nvb3Jkc1NldCwgZGVsdGFdIG9mIGNvb3Jkc0FuZERlbHRhcyBhcyBhbnkpIHtcbiAgICAgIGNvb3Jkc1NldC5wYWdlLnggLT0gZGVsdGEueFxuICAgICAgY29vcmRzU2V0LnBhZ2UueSAtPSBkZWx0YS55XG4gICAgICBjb29yZHNTZXQuY2xpZW50LnggLT0gZGVsdGEueFxuICAgICAgY29vcmRzU2V0LmNsaWVudC55IC09IGRlbHRhLnlcbiAgICB9XG5cbiAgICByZWN0LmxlZnQgLT0gcmVjdERlbHRhLmxlZnRcbiAgICByZWN0LnJpZ2h0IC09IHJlY3REZWx0YS5yaWdodFxuICAgIHJlY3QudG9wIC09IHJlY3REZWx0YS50b3BcbiAgICByZWN0LmJvdHRvbSAtPSByZWN0RGVsdGEuYm90dG9tXG4gIH1cblxuICBzaG91bGREbyAob3B0aW9ucywgcHJlRW5kPzogYm9vbGVhbiwgcGhhc2U/OiBzdHJpbmcsIHJlcXVpcmVFbmRPbmx5PzogYm9vbGVhbikge1xuICAgIGlmIChcbiAgICAgIC8vIGlnbm9yZSBkaXNhYmxlZCBtb2RpZmllcnNcbiAgICAgICghb3B0aW9ucyB8fCBvcHRpb25zLmVuYWJsZWQgPT09IGZhbHNlKSB8fFxuICAgICAgLy8gY2hlY2sgaWYgd2UgcmVxdWlyZSBlbmRPbmx5IG9wdGlvbiB0byBmaXJlIG1vdmUgYmVmb3JlIGVuZFxuICAgICAgKHJlcXVpcmVFbmRPbmx5ICYmICFvcHRpb25zLmVuZE9ubHkpIHx8XG4gICAgICAvLyBkb24ndCBhcHBseSBlbmRPbmx5IG1vZGlmaWVycyB3aGVuIG5vdCBlbmRpbmdcbiAgICAgIChvcHRpb25zLmVuZE9ubHkgJiYgIXByZUVuZCkgfHxcbiAgICAgIC8vIGNoZWNrIGlmIG1vZGlmaWVyIHNob3VsZCBydW4gYmUgYXBwbGllZCBvbiBzdGFydFxuICAgICAgKHBoYXNlID09PSAnc3RhcnQnICYmICFvcHRpb25zLnNldFN0YXJ0KVxuICAgICkge1xuICAgICAgcmV0dXJuIGZhbHNlXG4gICAgfVxuXG4gICAgcmV0dXJuIHRydWVcbiAgfVxuXG4gIGNvcHlGcm9tIChvdGhlcjogTW9kaWZpY2F0aW9uKSB7XG4gICAgdGhpcy5zdGFydE9mZnNldCA9IG90aGVyLnN0YXJ0T2Zmc2V0XG4gICAgdGhpcy5zdGFydERlbHRhID0gb3RoZXIuc3RhcnREZWx0YVxuICAgIHRoaXMuZWRnZXMgPSBvdGhlci5lZGdlc1xuICAgIHRoaXMuc3RhdGVzID0gb3RoZXIuc3RhdGVzLm1hcChzID0+IGNsb25lKHMpIGFzIE1vZGlmaWVyU3RhdGUpXG4gICAgdGhpcy5yZXN1bHQgPSBjcmVhdGVSZXN1bHQoZXh0ZW5kKHt9LCBvdGhlci5yZXN1bHQuY29vcmRzKSwgZXh0ZW5kKHt9LCBvdGhlci5yZXN1bHQucmVjdCkpXG4gIH1cblxuICBkZXN0cm95ICgpIHtcbiAgICBmb3IgKGNvbnN0IHByb3AgaW4gdGhpcykge1xuICAgICAgdGhpc1twcm9wXSA9IG51bGxcbiAgICB9XG4gIH1cbn1cblxuZnVuY3Rpb24gY3JlYXRlUmVzdWx0IChjb29yZHM/OiBJbnRlcmFjdC5Qb2ludCwgcmVjdD86IEludGVyYWN0LkZ1bGxSZWN0KTogTW9kaWZpY2F0aW9uUmVzdWx0IHtcbiAgcmV0dXJuIHtcbiAgICByZWN0LFxuICAgIGNvb3JkcyxcbiAgICBkZWx0YTogeyB4OiAwLCB5OiAwIH0sXG4gICAgcmVjdERlbHRhOiB7XG4gICAgICBsZWZ0ICA6IDAsXG4gICAgICByaWdodCA6IDAsXG4gICAgICB0b3AgICA6IDAsXG4gICAgICBib3R0b206IDAsXG4gICAgfSxcbiAgICBldmVudFByb3BzOiBbXSxcbiAgICBjaGFuZ2VkOiB0cnVlLFxuICB9XG59XG5cbmZ1bmN0aW9uIGdldE1vZGlmaWVyTGlzdCAoaW50ZXJhY3Rpb24pIHtcbiAgY29uc3QgYWN0aW9uT3B0aW9ucyA9IGludGVyYWN0aW9uLmludGVyYWN0YWJsZS5vcHRpb25zW2ludGVyYWN0aW9uLnByZXBhcmVkLm5hbWVdXG4gIGNvbnN0IGFjdGlvbk1vZGlmaWVycyA9IGFjdGlvbk9wdGlvbnMubW9kaWZpZXJzXG5cbiAgaWYgKGFjdGlvbk1vZGlmaWVycyAmJiBhY3Rpb25Nb2RpZmllcnMubGVuZ3RoKSB7XG4gICAgcmV0dXJuIGFjdGlvbk1vZGlmaWVycy5maWx0ZXIoXG4gICAgICBtb2RpZmllciA9PiAhbW9kaWZpZXIub3B0aW9ucyB8fCBtb2RpZmllci5vcHRpb25zLmVuYWJsZWQgIT09IGZhbHNlLFxuICAgIClcbiAgfVxuXG4gIHJldHVybiBbJ3NuYXAnLCAnc25hcFNpemUnLCAnc25hcEVkZ2VzJywgJ3Jlc3RyaWN0JywgJ3Jlc3RyaWN0RWRnZXMnLCAncmVzdHJpY3RTaXplJ11cbiAgICAubWFwKHR5cGUgPT4ge1xuICAgICAgY29uc3Qgb3B0aW9ucyA9IGFjdGlvbk9wdGlvbnNbdHlwZV1cblxuICAgICAgcmV0dXJuIG9wdGlvbnMgJiYgb3B0aW9ucy5lbmFibGVkICYmIHtcbiAgICAgICAgb3B0aW9ucyxcbiAgICAgICAgbWV0aG9kczogb3B0aW9ucy5fbWV0aG9kcyxcbiAgICAgIH1cbiAgICB9KVxuICAgIC5maWx0ZXIobSA9PiAhIW0pXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBnZXRSZWN0T2Zmc2V0IChyZWN0LCBjb29yZHMpIHtcbiAgcmV0dXJuIHJlY3RcbiAgICA/IHtcbiAgICAgIGxlZnQgIDogY29vcmRzLnggLSByZWN0LmxlZnQsXG4gICAgICB0b3AgICA6IGNvb3Jkcy55IC0gcmVjdC50b3AsXG4gICAgICByaWdodCA6IHJlY3QucmlnaHQgIC0gY29vcmRzLngsXG4gICAgICBib3R0b206IHJlY3QuYm90dG9tIC0gY29vcmRzLnksXG4gICAgfVxuICAgIDoge1xuICAgICAgbGVmdCAgOiAwLFxuICAgICAgdG9wICAgOiAwLFxuICAgICAgcmlnaHQgOiAwLFxuICAgICAgYm90dG9tOiAwLFxuICAgIH1cbn1cbiIsImltcG9ydCBNb2RpZmljYXRpb24gZnJvbSAnLi9Nb2RpZmljYXRpb24nXG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL0ludGVyYWN0aW9uJyB7XG4gIGludGVyZmFjZSBJbnRlcmFjdGlvbiB7XG4gICAgbW9kaWZpY2F0aW9uPzogTW9kaWZpY2F0aW9uXG4gIH1cbn1cblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3RFdmVudCcge1xuICBpbnRlcmZhY2UgSW50ZXJhY3RFdmVudCB7XG4gICAgbW9kaWZpZXJzPzogQXJyYXk8e1xuICAgICAgbmFtZTogc3RyaW5nXG4gICAgICBba2V5OiBzdHJpbmddOiBhbnlcbiAgICB9PlxuICB9XG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL2RlZmF1bHRPcHRpb25zJyB7XG4gIGludGVyZmFjZSBQZXJBY3Rpb25EZWZhdWx0cyB7XG4gICAgbW9kaWZpZXJzPzogTW9kaWZpZXJbXVxuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgTW9kaWZpZXI8XG4gIERlZmF1bHRzID0gYW55LFxuICBTdGF0ZSBleHRlbmRzIE1vZGlmaWVyU3RhdGUgPSBhbnksXG4gIE5hbWUgZXh0ZW5kcyBzdHJpbmcgPSBhbnlcbj4ge1xuICBvcHRpb25zPzogRGVmYXVsdHNcbiAgbWV0aG9kczoge1xuICAgIHN0YXJ0PzogKGFyZzogTW9kaWZpZXJBcmc8U3RhdGU+KSA9PiB2b2lkXG4gICAgc2V0OiAoYXJnOiBNb2RpZmllckFyZzxTdGF0ZT4pID0+IHZvaWRcbiAgICBiZWZvcmVFbmQ/OiAoYXJnOiBNb2RpZmllckFyZzxTdGF0ZT4pID0+IEludGVyYWN0LlBvaW50IHwgdm9pZFxuICAgIHN0b3A/OiAoYXJnOiBNb2RpZmllckFyZzxTdGF0ZT4pID0+IHZvaWRcbiAgfVxuICBuYW1lPzogTmFtZVxufVxuXG5leHBvcnQgdHlwZSBNb2RpZmllclN0YXRlPFxuICBEZWZhdWx0cyA9IHt9LFxuICBTdGF0ZVByb3BzIGV4dGVuZHMgeyBbcHJvcDogc3RyaW5nXTogYW55IH0gPSB7fSxcbiAgTmFtZSBleHRlbmRzIHN0cmluZyA9IGFueVxuPiA9IHtcbiAgb3B0aW9uczogRGVmYXVsdHNcbiAgbWV0aG9kcz86IE1vZGlmaWVyPERlZmF1bHRzPlsnbWV0aG9kcyddXG4gIGluZGV4PzogbnVtYmVyXG4gIG5hbWU/OiBOYW1lXG59ICYgU3RhdGVQcm9wc1xuXG5leHBvcnQgaW50ZXJmYWNlIE1vZGlmaWVyQXJnPFN0YXRlIGV4dGVuZHMgTW9kaWZpZXJTdGF0ZSA9IE1vZGlmaWVyU3RhdGU+IHtcbiAgaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uXG4gIGludGVyYWN0YWJsZTogSW50ZXJhY3QuSW50ZXJhY3RhYmxlXG4gIHBoYXNlOiBJbnRlcmFjdC5FdmVudFBoYXNlXG4gIHJlY3Q6IEludGVyYWN0LkZ1bGxSZWN0XG4gIGVkZ2VzOiBJbnRlcmFjdC5FZGdlT3B0aW9uc1xuICBzdGF0ZT86IFN0YXRlXG4gIGVsZW1lbnQ6IEludGVyYWN0LkVsZW1lbnRcbiAgcGFnZUNvb3Jkcz86IEludGVyYWN0LlBvaW50XG4gIHByZXZDb29yZHM/OiBJbnRlcmFjdC5Qb2ludFxuICBwcmV2UmVjdD86IEludGVyYWN0LkZ1bGxSZWN0XG4gIGNvb3Jkcz86IEludGVyYWN0LlBvaW50XG4gIHN0YXJ0T2Zmc2V0PzogSW50ZXJhY3QuUmVjdFxuICBwcmVFbmQ/OiBib29sZWFuXG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgTW9kaWZpZXJNb2R1bGU8XG4gIERlZmF1bHRzIGV4dGVuZHMgeyBlbmFibGVkPzogYm9vbGVhbiB9LFxuICBTdGF0ZSBleHRlbmRzIE1vZGlmaWVyU3RhdGUsXG4+IHtcbiAgZGVmYXVsdHM/OiBEZWZhdWx0c1xuICBzdGFydD8gKGFyZzogTW9kaWZpZXJBcmc8U3RhdGU+KTogdm9pZFxuICBzZXQ/IChhcmc6IE1vZGlmaWVyQXJnPFN0YXRlPik6IGFueVxuICBiZWZvcmVFbmQ/IChhcmc6IE1vZGlmaWVyQXJnPFN0YXRlPik6IEludGVyYWN0LlBvaW50IHwgdm9pZFxuICBzdG9wPyAoYXJnOiBNb2RpZmllckFyZzxTdGF0ZT4pOiB2b2lkXG59XG5cbmV4cG9ydCBmdW5jdGlvbiBtYWtlTW9kaWZpZXI8XG4gIERlZmF1bHRzIGV4dGVuZHMgeyBlbmFibGVkPzogYm9vbGVhbiB9LFxuICBTdGF0ZSBleHRlbmRzIE1vZGlmaWVyU3RhdGUsXG4gIE5hbWUgZXh0ZW5kcyBzdHJpbmdcbj4gKFxuICBtb2R1bGU6IE1vZGlmaWVyTW9kdWxlPERlZmF1bHRzLCBTdGF0ZT4sXG4gIG5hbWU/OiBOYW1lLFxuKSB7XG4gIGNvbnN0IHsgZGVmYXVsdHMgfSA9IG1vZHVsZVxuICBjb25zdCBtZXRob2RzID0ge1xuICAgIHN0YXJ0OiBtb2R1bGUuc3RhcnQsXG4gICAgc2V0OiBtb2R1bGUuc2V0LFxuICAgIGJlZm9yZUVuZDogbW9kdWxlLmJlZm9yZUVuZCxcbiAgICBzdG9wOiBtb2R1bGUuc3RvcCxcbiAgfVxuXG4gIGNvbnN0IG1vZGlmaWVyID0gKF9vcHRpb25zPzogUGFydGlhbDxEZWZhdWx0cz4pID0+IHtcbiAgICBjb25zdCBvcHRpb25zOiBEZWZhdWx0cyA9IChfb3B0aW9ucyB8fCB7fSkgYXMgRGVmYXVsdHNcblxuICAgIG9wdGlvbnMuZW5hYmxlZCA9IG9wdGlvbnMuZW5hYmxlZCAhPT0gZmFsc2VcblxuICAgIC8vIGFkZCBtaXNzaW5nIGRlZmF1bHRzIHRvIG9wdGlvbnNcbiAgICBmb3IgKGNvbnN0IHByb3AgaW4gZGVmYXVsdHMpIHtcbiAgICAgIGlmICghKHByb3AgaW4gb3B0aW9ucykpIHtcbiAgICAgICAgb3B0aW9uc1twcm9wXSA9IGRlZmF1bHRzW3Byb3BdXG4gICAgICB9XG4gICAgfVxuXG4gICAgY29uc3QgbTogTW9kaWZpZXI8RGVmYXVsdHMsIFN0YXRlLCBOYW1lPiA9IHsgb3B0aW9ucywgbWV0aG9kcywgbmFtZSB9XG5cbiAgICByZXR1cm4gbVxuICB9XG5cbiAgaWYgKG5hbWUgJiYgdHlwZW9mIG5hbWUgPT09ICdzdHJpbmcnKSB7XG4gICAgLy8gZm9yIGJhY2t3cmFkcyBjb21wYXRpYmlsaXR5XG4gICAgbW9kaWZpZXIuX2RlZmF1bHRzID0gZGVmYXVsdHNcbiAgICBtb2RpZmllci5fbWV0aG9kcyA9IG1ldGhvZHNcbiAgfVxuXG4gIHJldHVybiBtb2RpZmllclxufVxuXG5leHBvcnQgZnVuY3Rpb24gYWRkRXZlbnRNb2RpZmllcnMgKHsgaUV2ZW50LCBpbnRlcmFjdGlvbjogeyBtb2RpZmljYXRpb246IHsgcmVzdWx0IH0gfSB9OiB7XG4gIGlFdmVudDogSW50ZXJhY3QuSW50ZXJhY3RFdmVudDxJbnRlcmFjdC5BY3Rpb25OYW1lLCBJbnRlcmFjdC5FdmVudFBoYXNlPlxuICBpbnRlcmFjdGlvbjogSW50ZXJhY3QuSW50ZXJhY3Rpb25cbn0pIHtcbiAgaWYgKHJlc3VsdCkge1xuICAgIGlFdmVudC5tb2RpZmllcnMgPSByZXN1bHQuZXZlbnRQcm9wc1xuICB9XG59XG5cbmNvbnN0IG1vZGlmaWVyc0Jhc2U6IEludGVyYWN0LlBsdWdpbiA9IHtcbiAgaWQ6ICdtb2RpZmllcnMvYmFzZScsXG4gIGluc3RhbGw6IHNjb3BlID0+IHtcbiAgICBzY29wZS5kZWZhdWx0cy5wZXJBY3Rpb24ubW9kaWZpZXJzID0gW11cbiAgfSxcbiAgbGlzdGVuZXJzOiB7XG4gICAgJ2ludGVyYWN0aW9uczpuZXcnOiAoeyBpbnRlcmFjdGlvbiB9KSA9PiB7XG4gICAgICBpbnRlcmFjdGlvbi5tb2RpZmljYXRpb24gPSBuZXcgTW9kaWZpY2F0aW9uKGludGVyYWN0aW9uKVxuICAgIH0sXG5cbiAgICAnaW50ZXJhY3Rpb25zOmJlZm9yZS1hY3Rpb24tc3RhcnQnOiBhcmcgPT4ge1xuICAgICAgY29uc3QgeyBtb2RpZmljYXRpb24gfSA9IGFyZy5pbnRlcmFjdGlvblxuXG4gICAgICBtb2RpZmljYXRpb24uc3RhcnQoYXJnLCBhcmcuaW50ZXJhY3Rpb24uY29vcmRzLnN0YXJ0LnBhZ2UpXG4gICAgICBhcmcuaW50ZXJhY3Rpb24uZWRnZXMgPSBtb2RpZmljYXRpb24uZWRnZXNcbiAgICAgIG1vZGlmaWNhdGlvbi5hcHBseVRvSW50ZXJhY3Rpb24oYXJnKVxuICAgIH0sXG5cbiAgICAnaW50ZXJhY3Rpb25zOmJlZm9yZS1hY3Rpb24tbW92ZSc6IGFyZyA9PiBhcmcuaW50ZXJhY3Rpb24ubW9kaWZpY2F0aW9uLnNldEFuZEFwcGx5KGFyZyksXG5cbiAgICAnaW50ZXJhY3Rpb25zOmJlZm9yZS1hY3Rpb24tZW5kJzogYXJnID0+IGFyZy5pbnRlcmFjdGlvbi5tb2RpZmljYXRpb24uYmVmb3JlRW5kKGFyZyksXG5cbiAgICAnaW50ZXJhY3Rpb25zOmFjdGlvbi1zdGFydCc6IGFkZEV2ZW50TW9kaWZpZXJzLFxuICAgICdpbnRlcmFjdGlvbnM6YWN0aW9uLW1vdmUnOiBhZGRFdmVudE1vZGlmaWVycyxcbiAgICAnaW50ZXJhY3Rpb25zOmFjdGlvbi1lbmQnOiBhZGRFdmVudE1vZGlmaWVycyxcblxuICAgICdpbnRlcmFjdGlvbnM6YWZ0ZXItYWN0aW9uLXN0YXJ0JzogYXJnID0+IGFyZy5pbnRlcmFjdGlvbi5tb2RpZmljYXRpb24ucmVzdG9yZUludGVyYWN0aW9uQ29vcmRzKGFyZyksXG4gICAgJ2ludGVyYWN0aW9uczphZnRlci1hY3Rpb24tbW92ZSc6IGFyZyA9PiBhcmcuaW50ZXJhY3Rpb24ubW9kaWZpY2F0aW9uLnJlc3RvcmVJbnRlcmFjdGlvbkNvb3JkcyhhcmcpLFxuXG4gICAgJ2ludGVyYWN0aW9uczpzdG9wJzogYXJnID0+IGFyZy5pbnRlcmFjdGlvbi5tb2RpZmljYXRpb24uc3RvcChhcmcpLFxuICB9LFxuICBiZWZvcmU6IFsnYWN0aW9ucycsICdhY3Rpb24vZHJhZycsICdhY3Rpb25zL3Jlc2l6ZScsICdhY3Rpb25zL2dlc3R1cmUnXSxcbn1cblxuZXhwb3J0IGRlZmF1bHQgbW9kaWZpZXJzQmFzZVxuIiwiaW1wb3J0IHsgX1Byb3h5TWV0aG9kcyB9IGZyb20gJ0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3Rpb24nXG5pbXBvcnQgKiBhcyByZWN0VXRpbHMgZnJvbSAnQGludGVyYWN0anMvdXRpbHMvcmVjdCdcblxuZGVjbGFyZSBtb2R1bGUgJ0BpbnRlcmFjdGpzL2NvcmUvSW50ZXJhY3Rpb24nIHtcbiAgaW50ZXJmYWNlIEludGVyYWN0aW9uIHtcbiAgICBvZmZzZXRCeT86IHR5cGVvZiBvZmZzZXRCeVxuICAgIG9mZnNldDoge1xuICAgICAgdG90YWw6IEludGVyYWN0LlBvaW50XG4gICAgICBwZW5kaW5nOiBJbnRlcmFjdC5Qb2ludFxuICAgIH1cbiAgfVxuXG4gIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1zaGFkb3dcbiAgZW51bSBfUHJveHlNZXRob2RzIHtcbiAgICAvLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tc2hhZG93XG4gICAgb2Zmc2V0QnkgPSAnJ1xuICB9XG59XG5cbihfUHJveHlNZXRob2RzIGFzIGFueSkub2Zmc2V0QnkgPSAnJ1xuXG5leHBvcnQgZnVuY3Rpb24gYWRkVG90YWwgKGludGVyYWN0aW9uOiBJbnRlcmFjdC5JbnRlcmFjdGlvbikge1xuICBpZiAoIWludGVyYWN0aW9uLnBvaW50ZXJJc0Rvd24pIHsgcmV0dXJuIH1cblxuICBhZGRUb0Nvb3JkcyhpbnRlcmFjdGlvbi5jb29yZHMuY3VyLCBpbnRlcmFjdGlvbi5vZmZzZXQudG90YWwpXG5cbiAgaW50ZXJhY3Rpb24ub2Zmc2V0LnBlbmRpbmcueCA9IDBcbiAgaW50ZXJhY3Rpb24ub2Zmc2V0LnBlbmRpbmcueSA9IDBcbn1cblxuZnVuY3Rpb24gYmVmb3JlQWN0aW9uICh7IGludGVyYWN0aW9uIH06IHsgaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uIH0pIHtcbiAgYXBwbHlQZW5kaW5nKGludGVyYWN0aW9uKVxufVxuXG5mdW5jdGlvbiBiZWZvcmVFbmQgKHsgaW50ZXJhY3Rpb24gfTogeyBpbnRlcmFjdGlvbjogSW50ZXJhY3QuSW50ZXJhY3Rpb24gfSk6IGJvb2xlYW4gfCB2b2lkIHtcbiAgY29uc3QgaGFkUGVuZGluZyA9IGFwcGx5UGVuZGluZyhpbnRlcmFjdGlvbilcblxuICBpZiAoIWhhZFBlbmRpbmcpIHsgcmV0dXJuIH1cblxuICBpbnRlcmFjdGlvbi5tb3ZlKHsgb2Zmc2V0OiB0cnVlIH0pXG4gIGludGVyYWN0aW9uLmVuZCgpXG5cbiAgcmV0dXJuIGZhbHNlXG59XG5cbmZ1bmN0aW9uIGVuZCAoeyBpbnRlcmFjdGlvbiB9OiB7IGludGVyYWN0aW9uOiBJbnRlcmFjdC5JbnRlcmFjdGlvbiB9KSB7XG4gIGludGVyYWN0aW9uLm9mZnNldC50b3RhbC54ID0gMFxuICBpbnRlcmFjdGlvbi5vZmZzZXQudG90YWwueSA9IDBcbiAgaW50ZXJhY3Rpb24ub2Zmc2V0LnBlbmRpbmcueCA9IDBcbiAgaW50ZXJhY3Rpb24ub2Zmc2V0LnBlbmRpbmcueSA9IDBcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGFwcGx5UGVuZGluZyAoaW50ZXJhY3Rpb246IEludGVyYWN0LkludGVyYWN0aW9uKSB7XG4gIGlmICghaGFzUGVuZGluZyhpbnRlcmFjdGlvbikpIHtcbiAgICByZXR1cm4gZmFsc2VcbiAgfVxuXG4gIGNvbnN0IHsgcGVuZGluZyB9ID0gaW50ZXJhY3Rpb24ub2Zmc2V0XG5cbiAgYWRkVG9Db29yZHMoaW50ZXJhY3Rpb24uY29vcmRzLmN1ciwgcGVuZGluZylcbiAgYWRkVG9Db29yZHMoaW50ZXJhY3Rpb24uY29vcmRzLmRlbHRhLCBwZW5kaW5nKVxuICByZWN0VXRpbHMuYWRkRWRnZXMoaW50ZXJhY3Rpb24uZWRnZXMsIGludGVyYWN0aW9uLnJlY3QsIHBlbmRpbmcpXG5cbiAgcGVuZGluZy54ID0gMFxuICBwZW5kaW5nLnkgPSAwXG5cbiAgcmV0dXJuIHRydWVcbn1cblxuZnVuY3Rpb24gb2Zmc2V0QnkgKHRoaXM6IEludGVyYWN0LkludGVyYWN0aW9uLCB7IHgsIHkgfTogSW50ZXJhY3QuUG9pbnQpIHtcbiAgdGhpcy5vZmZzZXQucGVuZGluZy54ICs9IHhcbiAgdGhpcy5vZmZzZXQucGVuZGluZy55ICs9IHlcblxuICB0aGlzLm9mZnNldC50b3RhbC54ICs9IHhcbiAgdGhpcy5vZmZzZXQudG90YWwueSArPSB5XG59XG5cbmZ1bmN0aW9uIGFkZFRvQ29vcmRzICh7IHBhZ2UsIGNsaWVudCB9LCB7IHgsIHkgfTogSW50ZXJhY3QuUG9pbnQpIHtcbiAgcGFnZS54ICs9IHhcbiAgcGFnZS55ICs9IHlcbiAgY2xpZW50LnggKz0geFxuICBjbGllbnQueSArPSB5XG59XG5cbmZ1bmN0aW9uIGhhc1BlbmRpbmcgKGludGVyYWN0aW9uKSB7XG4gIHJldHVybiAhIShpbnRlcmFjdGlvbi5vZmZzZXQucGVuZGluZy54IHx8IGludGVyYWN0aW9uLm9mZnNldC5wZW5kaW5nLnkpXG59XG5cbmNvbnN0IG9mZnNldDogSW50ZXJhY3QuUGx1Z2luID0ge1xuICBpZDogJ29mZnNldCcsXG4gIGluc3RhbGwgKHNjb3BlKSB7XG4gICAgc2NvcGUuSW50ZXJhY3Rpb24ucHJvdG90eXBlLm9mZnNldEJ5ID0gb2Zmc2V0QnlcbiAgfSxcbiAgbGlzdGVuZXJzOiB7XG4gICAgJ2ludGVyYWN0aW9uczpuZXcnOiAoeyBpbnRlcmFjdGlvbiB9KSA9PiB7XG4gICAgICBpbnRlcmFjdGlvbi5vZmZzZXQgPSB7XG4gICAgICAgIHRvdGFsOiB7IHg6IDAsIHk6IDAgfSxcbiAgICAgICAgcGVuZGluZzogeyB4OiAwLCB5OiAwIH0sXG4gICAgICB9XG4gICAgfSxcbiAgICAnaW50ZXJhY3Rpb25zOnVwZGF0ZS1wb2ludGVyJzogKHsgaW50ZXJhY3Rpb24gfSkgPT4gYWRkVG90YWwoaW50ZXJhY3Rpb24pLFxuICAgICdpbnRlcmFjdGlvbnM6YmVmb3JlLWFjdGlvbi1zdGFydCc6IGJlZm9yZUFjdGlvbixcbiAgICAnaW50ZXJhY3Rpb25zOmJlZm9yZS1hY3Rpb24tbW92ZSc6IGJlZm9yZUFjdGlvbixcbiAgICAnaW50ZXJhY3Rpb25zOmJlZm9yZS1hY3Rpb24tZW5kJzogYmVmb3JlRW5kLFxuICAgICdpbnRlcmFjdGlvbnM6c3RvcCc6IGVuZCxcbiAgfSxcbn1cblxuZXhwb3J0IGRlZmF1bHQgb2Zmc2V0XG4iLCJpbXBvcnQgKiBhcyBtb2RpZmllcnMgZnJvbSAnQGludGVyYWN0anMvbW9kaWZpZXJzL2Jhc2UnXG5pbXBvcnQgTW9kaWZpY2F0aW9uIGZyb20gJ0BpbnRlcmFjdGpzL21vZGlmaWVycy9Nb2RpZmljYXRpb24nXG5pbXBvcnQgb2Zmc2V0IGZyb20gJ0BpbnRlcmFjdGpzL29mZnNldC9pbmRleCdcbmltcG9ydCAqIGFzIGRvbSBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9kb21VdGlscydcbmltcG9ydCBoeXBvdCBmcm9tICdAaW50ZXJhY3Rqcy91dGlscy9oeXBvdCdcbmltcG9ydCAqIGFzIGlzIGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL2lzJ1xuaW1wb3J0IHsgY29weUNvb3JkcyB9IGZyb20gJ0BpbnRlcmFjdGpzL3V0aWxzL3BvaW50ZXJVdGlscydcbmltcG9ydCByYWYgZnJvbSAnQGludGVyYWN0anMvdXRpbHMvcmFmJ1xuXG5kZWNsYXJlIG1vZHVsZSAnQGludGVyYWN0anMvY29yZS9JbnRlcmFjdEV2ZW50JyB7XG4gIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1zaGFkb3dcbiAgaW50ZXJmYWNlIFBoYXNlTWFwIHtcbiAgICByZXN1bWU/OiB0cnVlXG4gICAgaW5lcnRpYXN0YXJ0PzogdHJ1ZVxuICB9XG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL0ludGVyYWN0aW9uJyB7XG4gIGludGVyZmFjZSBJbnRlcmFjdGlvbiB7XG4gICAgaW5lcnRpYT86IEluZXJ0aWFTdGF0ZVxuICB9XG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL2RlZmF1bHRPcHRpb25zJyB7XG4gIGludGVyZmFjZSBQZXJBY3Rpb25EZWZhdWx0cyB7XG4gICAgaW5lcnRpYT86IHtcbiAgICAgIGVuYWJsZWQ/OiBib29sZWFuXG4gICAgICByZXNpc3RhbmNlPzogbnVtYmVyICAgICAgICAvLyB0aGUgbGFtYmRhIGluIGV4cG9uZW50aWFsIGRlY2F5XG4gICAgICBtaW5TcGVlZD86IG51bWJlciAgICAgICAgICAvLyB0YXJnZXQgc3BlZWQgbXVzdCBiZSBhYm92ZSB0aGlzIGZvciBpbmVydGlhIHRvIHN0YXJ0XG4gICAgICBlbmRTcGVlZD86IG51bWJlciAgICAgICAgICAvLyB0aGUgc3BlZWQgYXQgd2hpY2ggaW5lcnRpYSBpcyBzbG93IGVub3VnaCB0byBzdG9wXG4gICAgICBhbGxvd1Jlc3VtZT86IHRydWUgICAgICAgICAvLyBhbGxvdyByZXN1bWluZyBhbiBhY3Rpb24gaW4gaW5lcnRpYSBwaGFzZVxuICAgICAgc21vb3RoRW5kRHVyYXRpb24/OiBudW1iZXIgLy8gYW5pbWF0ZSB0byBzbmFwL3Jlc3RyaWN0IGVuZE9ubHkgaWYgdGhlcmUncyBubyBpbmVydGlhXG4gICAgfVxuICB9XG59XG5cbmRlY2xhcmUgbW9kdWxlICdAaW50ZXJhY3Rqcy9jb3JlL3Njb3BlJyB7XG4gIGludGVyZmFjZSBTaWduYWxBcmdzIHtcbiAgICAnaW50ZXJhY3Rpb25zOmJlZm9yZS1hY3Rpb24taW5lcnRpYXN0YXJ0JzogT21pdDxJbnRlcmFjdC5Eb1BoYXNlQXJnPEludGVyYWN0LkFjdGlvbk5hbWUsICdpbmVydGlhc3RhcnQnPiwgJ2lFdmVudCc+XG4gICAgJ2ludGVyYWN0aW9uczphY3Rpb24taW5lcnRpYXN0YXJ0JzogSW50ZXJhY3QuRG9QaGFzZUFyZzxJbnRlcmFjdC5BY3Rpb25OYW1lLCAnaW5lcnRpYXN0YXJ0Jz5cbiAgICAnaW50ZXJhY3Rpb25zOmFmdGVyLWFjdGlvbi1pbmVydGlhc3RhcnQnOiBJbnRlcmFjdC5Eb1BoYXNlQXJnPEludGVyYWN0LkFjdGlvbk5hbWUsICdpbmVydGlhc3RhcnQnPlxuICAgICdpbnRlcmFjdGlvbnM6YmVmb3JlLWFjdGlvbi1yZXN1bWUnOiBPbWl0PEludGVyYWN0LkRvUGhhc2VBcmc8SW50ZXJhY3QuQWN0aW9uTmFtZSwgJ3Jlc3VtZSc+LCAnaUV2ZW50Jz5cbiAgICAnaW50ZXJhY3Rpb25zOmFjdGlvbi1yZXN1bWUnOiBJbnRlcmFjdC5Eb1BoYXNlQXJnPEludGVyYWN0LkFjdGlvbk5hbWUsICdyZXN1bWUnPlxuICAgICdpbnRlcmFjdGlvbnM6YWZ0ZXItYWN0aW9uLXJlc3VtZSc6IEludGVyYWN0LkRvUGhhc2VBcmc8SW50ZXJhY3QuQWN0aW9uTmFtZSwgJ3Jlc3VtZSc+XG4gIH1cbn1cblxuZnVuY3Rpb24gaW5zdGFsbCAoc2NvcGU6IEludGVyYWN0LlNjb3BlKSB7XG4gIGNvbnN0IHtcbiAgICBkZWZhdWx0cyxcbiAgfSA9IHNjb3BlXG5cbiAgc2NvcGUudXNlUGx1Z2luKG9mZnNldClcbiAgc2NvcGUudXNlUGx1Z2luKG1vZGlmaWVycy5kZWZhdWx0KVxuICBzY29wZS5hY3Rpb25zLnBoYXNlcy5pbmVydGlhc3RhcnQgPSB0cnVlXG4gIHNjb3BlLmFjdGlvbnMucGhhc2VzLnJlc3VtZSA9IHRydWVcblxuICBkZWZhdWx0cy5wZXJBY3Rpb24uaW5lcnRpYSA9IHtcbiAgICBlbmFibGVkICAgICAgICAgIDogZmFsc2UsXG4gICAgcmVzaXN0YW5jZSAgICAgICA6IDEwLCAgICAvLyB0aGUgbGFtYmRhIGluIGV4cG9uZW50aWFsIGRlY2F5XG4gICAgbWluU3BlZWQgICAgICAgICA6IDEwMCwgICAvLyB0YXJnZXQgc3BlZWQgbXVzdCBiZSBhYm92ZSB0aGlzIGZvciBpbmVydGlhIHRvIHN0YXJ0XG4gICAgZW5kU3BlZWQgICAgICAgICA6IDEwLCAgICAvLyB0aGUgc3BlZWQgYXQgd2hpY2ggaW5lcnRpYSBpcyBzbG93IGVub3VnaCB0byBzdG9wXG4gICAgYWxsb3dSZXN1bWUgICAgICA6IHRydWUsICAvLyBhbGxvdyByZXN1bWluZyBhbiBhY3Rpb24gaW4gaW5lcnRpYSBwaGFzZVxuICAgIHNtb290aEVuZER1cmF0aW9uOiAzMDAsICAgLy8gYW5pbWF0ZSB0byBzbmFwL3Jlc3RyaWN0IGVuZE9ubHkgaWYgdGhlcmUncyBubyBpbmVydGlhXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIEluZXJ0aWFTdGF0ZSB7XG4gIGFjdGl2ZSA9IGZhbHNlXG4gIGlzTW9kaWZpZWQgPSBmYWxzZVxuICBzbW9vdGhFbmQgPSBmYWxzZVxuICBhbGxvd1Jlc3VtZSA9IGZhbHNlXG5cbiAgbW9kaWZpY2F0aW9uOiBNb2RpZmljYXRpb24gPSBudWxsXG4gIG1vZGlmaWVyQ291bnQgPSAwXG4gIG1vZGlmaWVyQXJnOiBtb2RpZmllcnMuTW9kaWZpZXJBcmcgPSBudWxsXG5cbiAgc3RhcnRDb29yZHM6IEludGVyYWN0LlBvaW50ID0gbnVsbFxuICB0MCA9IDBcbiAgdjAgPSAwXG5cbiAgdGUgPSAwXG4gIHRhcmdldE9mZnNldDogSW50ZXJhY3QuUG9pbnQgPSBudWxsXG4gIG1vZGlmaWVkT2Zmc2V0OiBJbnRlcmFjdC5Qb2ludCA9IG51bGxcbiAgY3VycmVudE9mZnNldDogSW50ZXJhY3QuUG9pbnQgPSBudWxsXG5cbiAgbGFtYmRhX3YwPyA9IDAgLy8gZXNsaW50LWRpc2FibGUtbGluZSBjYW1lbGNhc2VcbiAgb25lX3ZlX3YwPyA9IDAgLy8gZXNsaW50LWRpc2FibGUtbGluZSBjYW1lbGNhc2VcbiAgdGltZW91dDogbnVtYmVyID0gbnVsbFxuXG4gIGNvbnN0cnVjdG9yIChcbiAgICBwcml2YXRlIHJlYWRvbmx5IGludGVyYWN0aW9uOiBJbnRlcmFjdC5JbnRlcmFjdGlvbixcbiAgKSB7fVxuXG4gIHN0YXJ0IChldmVudDogSW50ZXJhY3QuUG9pbnRlckV2ZW50VHlwZSkge1xuICAgIGNvbnN0IHsgaW50ZXJhY3Rpb24gfSA9IHRoaXNcbiAgICBjb25zdCBvcHRpb25zID0gZ2V0T3B0aW9ucyhpbnRlcmFjdGlvbilcblxuICAgIGlmICghb3B0aW9ucyB8fCAhb3B0aW9ucy5lbmFibGVkKSB7XG4gICAgICByZXR1cm4gZmFsc2VcbiAgICB9XG5cbiAgICBjb25zdCB7IGNsaWVudDogdmVsb2NpdHlDbGllbnQgfSA9IGludGVyYWN0aW9uLmNvb3Jkcy52ZWxvY2l0eVxuICAgIGNvbnN0IHBvaW50ZXJTcGVlZCA9IGh5cG90KHZlbG9jaXR5Q2xpZW50LngsIHZlbG9jaXR5Q2xpZW50LnkpXG4gICAgY29uc3QgbW9kaWZpY2F0aW9uID0gdGhpcy5tb2RpZmljYXRpb24gfHwgKHRoaXMubW9kaWZpY2F0aW9uID0gbmV3IE1vZGlmaWNhdGlvbihpbnRlcmFjdGlvbikpXG5cbiAgICBtb2RpZmljYXRpb24uY29weUZyb20oaW50ZXJhY3Rpb24ubW9kaWZpY2F0aW9uKVxuXG4gICAgdGhpcy50MCA9IGludGVyYWN0aW9uLl9ub3coKVxuICAgIHRoaXMuYWxsb3dSZXN1bWUgPSBvcHRpb25zLmFsbG93UmVzdW1lXG4gICAgdGhpcy52MCA9IHBvaW50ZXJTcGVlZFxuICAgIHRoaXMuY3VycmVudE9mZnNldCA9IHsgeDogMCwgeTogMCB9XG4gICAgdGhpcy5zdGFydENvb3JkcyA9IGludGVyYWN0aW9uLmNvb3Jkcy5jdXIucGFnZVxuXG4gICAgdGhpcy5tb2RpZmllckFyZyA9IHtcbiAgICAgIGludGVyYWN0aW9uLFxuICAgICAgaW50ZXJhY3RhYmxlOiBpbnRlcmFjdGlvbi5pbnRlcmFjdGFibGUsXG4gICAgICBlbGVtZW50OiBpbnRlcmFjdGlvbi5lbGVtZW50LFxuICAgICAgcmVjdDogaW50ZXJhY3Rpb24ucmVjdCxcbiAgICAgIGVkZ2VzOiBpbnRlcmFjdGlvbi5lZGdlcyxcbiAgICAgIHBhZ2VDb29yZHM6IHRoaXMuc3RhcnRDb29yZHMsXG4gICAgICBwcmVFbmQ6IHRydWUsXG4gICAgICBwaGFzZTogJ2luZXJ0aWFzdGFydCcsXG4gICAgfVxuXG4gICAgY29uc3QgdGhyb3duID0gKFxuICAgICAgKHRoaXMudDAgLSBpbnRlcmFjdGlvbi5jb29yZHMuY3VyLnRpbWVTdGFtcCkgPCA1MCAmJlxuICAgICAgcG9pbnRlclNwZWVkID4gb3B0aW9ucy5taW5TcGVlZCAmJlxuICAgICAgcG9pbnRlclNwZWVkID4gb3B0aW9ucy5lbmRTcGVlZFxuICAgIClcblxuICAgIGlmICh0aHJvd24pIHtcbiAgICAgIHRoaXMuc3RhcnRJbmVydGlhKClcbiAgICB9IGVsc2Uge1xuICAgICAgbW9kaWZpY2F0aW9uLnJlc3VsdCA9IG1vZGlmaWNhdGlvbi5zZXRBbGwodGhpcy5tb2RpZmllckFyZylcblxuICAgICAgaWYgKCFtb2RpZmljYXRpb24ucmVzdWx0LmNoYW5nZWQpIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlXG4gICAgICB9XG5cbiAgICAgIHRoaXMuc3RhcnRTbW9vdGhFbmQoKVxuICAgIH1cblxuICAgIC8vIGZvcmNlIG1vZGlmaWNhdGlvbiBjaGFuZ2VcbiAgICBpbnRlcmFjdGlvbi5tb2RpZmljYXRpb24ucmVzdWx0LnJlY3QgPSBudWxsXG5cbiAgICAvLyBicmluZyBpbmVydGlhc3RhcnQgZXZlbnQgdG8gdGhlIHRhcmdldCBjb29yZHNcbiAgICBpbnRlcmFjdGlvbi5vZmZzZXRCeSh0aGlzLnRhcmdldE9mZnNldClcbiAgICBpbnRlcmFjdGlvbi5fZG9QaGFzZSh7XG4gICAgICBpbnRlcmFjdGlvbixcbiAgICAgIGV2ZW50LFxuICAgICAgcGhhc2U6ICdpbmVydGlhc3RhcnQnLFxuICAgIH0pXG4gICAgaW50ZXJhY3Rpb24ub2Zmc2V0QnkoeyB4OiAtdGhpcy50YXJnZXRPZmZzZXQueCwgeTogLXRoaXMudGFyZ2V0T2Zmc2V0LnkgfSlcbiAgICAvLyBmb3JjZSBtb2RpZmljYXRpb24gY2hhbmdlXG4gICAgaW50ZXJhY3Rpb24ubW9kaWZpY2F0aW9uLnJlc3VsdC5yZWN0ID0gbnVsbFxuXG4gICAgdGhpcy5hY3RpdmUgPSB0cnVlXG4gICAgaW50ZXJhY3Rpb24uc2ltdWxhdGlvbiA9IHRoaXNcblxuICAgIHJldHVybiB0cnVlXG4gIH1cblxuICBzdGFydEluZXJ0aWEgKCkge1xuICAgIGNvbnN0IHN0YXJ0VmVsb2NpdHkgPSB0aGlzLmludGVyYWN0aW9uLmNvb3Jkcy52ZWxvY2l0eS5jbGllbnRcbiAgICBjb25zdCBvcHRpb25zID0gZ2V0T3B0aW9ucyh0aGlzLmludGVyYWN0aW9uKVxuICAgIGNvbnN0IGxhbWJkYSA9IG9wdGlvbnMucmVzaXN0YW5jZVxuICAgIGNvbnN0IGluZXJ0aWFEdXIgPSAtTWF0aC5sb2cob3B0aW9ucy5lbmRTcGVlZCAvIHRoaXMudjApIC8gbGFtYmRhXG5cbiAgICB0aGlzLnRhcmdldE9mZnNldCA9IHtcbiAgICAgIHg6IChzdGFydFZlbG9jaXR5LnggLSBpbmVydGlhRHVyKSAvIGxhbWJkYSxcbiAgICAgIHk6IChzdGFydFZlbG9jaXR5LnkgLSBpbmVydGlhRHVyKSAvIGxhbWJkYSxcbiAgICB9XG5cbiAgICB0aGlzLnRlID0gaW5lcnRpYUR1clxuICAgIHRoaXMubGFtYmRhX3YwID0gbGFtYmRhIC8gdGhpcy52MFxuICAgIHRoaXMub25lX3ZlX3YwID0gMSAtIG9wdGlvbnMuZW5kU3BlZWQgLyB0aGlzLnYwXG5cbiAgICBjb25zdCB7IG1vZGlmaWNhdGlvbiwgbW9kaWZpZXJBcmcgfSA9IHRoaXNcblxuICAgIG1vZGlmaWVyQXJnLnBhZ2VDb29yZHMgPSB7XG4gICAgICB4OiB0aGlzLnN0YXJ0Q29vcmRzLnggKyB0aGlzLnRhcmdldE9mZnNldC54LFxuICAgICAgeTogdGhpcy5zdGFydENvb3Jkcy55ICsgdGhpcy50YXJnZXRPZmZzZXQueSxcbiAgICB9XG5cbiAgICBtb2RpZmljYXRpb24ucmVzdWx0ID0gbW9kaWZpY2F0aW9uLnNldEFsbChtb2RpZmllckFyZylcblxuICAgIGlmIChtb2RpZmljYXRpb24ucmVzdWx0LmNoYW5nZWQpIHtcbiAgICAgIHRoaXMuaXNNb2RpZmllZCA9IHRydWVcbiAgICAgIHRoaXMubW9kaWZpZWRPZmZzZXQgPSB7XG4gICAgICAgIHg6IHRoaXMudGFyZ2V0T2Zmc2V0LnggKyBtb2RpZmljYXRpb24ucmVzdWx0LmRlbHRhLngsXG4gICAgICAgIHk6IHRoaXMudGFyZ2V0T2Zmc2V0LnkgKyBtb2RpZmljYXRpb24ucmVzdWx0LmRlbHRhLnksXG4gICAgICB9XG4gICAgfVxuXG4gICAgdGhpcy50aW1lb3V0ID0gcmFmLnJlcXVlc3QoKCkgPT4gdGhpcy5pbmVydGlhVGljaygpKVxuICB9XG5cbiAgc3RhcnRTbW9vdGhFbmQgKCkge1xuICAgIHRoaXMuc21vb3RoRW5kID0gdHJ1ZVxuICAgIHRoaXMuaXNNb2RpZmllZCA9IHRydWVcbiAgICB0aGlzLnRhcmdldE9mZnNldCA9IHtcbiAgICAgIHg6IHRoaXMubW9kaWZpY2F0aW9uLnJlc3VsdC5kZWx0YS54LFxuICAgICAgeTogdGhpcy5tb2RpZmljYXRpb24ucmVzdWx0LmRlbHRhLnksXG4gICAgfVxuXG4gICAgdGhpcy50aW1lb3V0ID0gcmFmLnJlcXVlc3QoKCkgPT4gdGhpcy5zbW9vdGhFbmRUaWNrKCkpXG4gIH1cblxuICBpbmVydGlhVGljayAoKSB7XG4gICAgY29uc3QgeyBpbnRlcmFjdGlvbiB9ID0gdGhpc1xuICAgIGNvbnN0IG9wdGlvbnMgPSBnZXRPcHRpb25zKGludGVyYWN0aW9uKVxuICAgIGNvbnN0IGxhbWJkYSA9IG9wdGlvbnMucmVzaXN0YW5jZVxuICAgIGNvbnN0IHQgPSAoaW50ZXJhY3Rpb24uX25vdygpIC0gdGhpcy50MCkgLyAxMDAwXG5cbiAgICBpZiAodCA8IHRoaXMudGUpIHtcbiAgICAgIGNvbnN0IHByb2dyZXNzID0gIDEgLSAoTWF0aC5leHAoLWxhbWJkYSAqIHQpIC0gdGhpcy5sYW1iZGFfdjApIC8gdGhpcy5vbmVfdmVfdjBcbiAgICAgIGxldCBuZXdPZmZzZXQ6IEludGVyYWN0LlBvaW50XG5cbiAgICAgIGlmICh0aGlzLmlzTW9kaWZpZWQpIHtcbiAgICAgICAgbmV3T2Zmc2V0ID0gZ2V0UXVhZHJhdGljQ3VydmVQb2ludChcbiAgICAgICAgICAwLCAwLFxuICAgICAgICAgIHRoaXMudGFyZ2V0T2Zmc2V0LngsIHRoaXMudGFyZ2V0T2Zmc2V0LnksXG4gICAgICAgICAgdGhpcy5tb2RpZmllZE9mZnNldC54LCB0aGlzLm1vZGlmaWVkT2Zmc2V0LnksXG4gICAgICAgICAgcHJvZ3Jlc3MsXG4gICAgICAgIClcbiAgICAgIH1cbiAgICAgIGVsc2Uge1xuICAgICAgICBuZXdPZmZzZXQgPSB7XG4gICAgICAgICAgeDogdGhpcy50YXJnZXRPZmZzZXQueCAqIHByb2dyZXNzLFxuICAgICAgICAgIHk6IHRoaXMudGFyZ2V0T2Zmc2V0LnkgKiBwcm9ncmVzcyxcbiAgICAgICAgfVxuICAgICAgfVxuXG4gICAgICBjb25zdCBkZWx0YSA9IHsgeDogbmV3T2Zmc2V0LnggLSB0aGlzLmN1cnJlbnRPZmZzZXQueCwgeTogbmV3T2Zmc2V0LnkgLSB0aGlzLmN1cnJlbnRPZmZzZXQueSB9XG5cbiAgICAgIHRoaXMuY3VycmVudE9mZnNldC54ICs9IGRlbHRhLnhcbiAgICAgIHRoaXMuY3VycmVudE9mZnNldC55ICs9IGRlbHRhLnlcblxuICAgICAgaW50ZXJhY3Rpb24ub2Zmc2V0QnkoZGVsdGEpXG4gICAgICBpbnRlcmFjdGlvbi5tb3ZlKClcblxuICAgICAgdGhpcy50aW1lb3V0ID0gcmFmLnJlcXVlc3QoKCkgPT4gdGhpcy5pbmVydGlhVGljaygpKVxuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIGludGVyYWN0aW9uLm9mZnNldEJ5KHtcbiAgICAgICAgeDogdGhpcy5tb2RpZmllZE9mZnNldC54IC0gdGhpcy5jdXJyZW50T2Zmc2V0LngsXG4gICAgICAgIHk6IHRoaXMubW9kaWZpZWRPZmZzZXQueSAtIHRoaXMuY3VycmVudE9mZnNldC55LFxuICAgICAgfSlcblxuICAgICAgdGhpcy5lbmQoKVxuICAgIH1cbiAgfVxuXG4gIHNtb290aEVuZFRpY2sgKCkge1xuICAgIGNvbnN0IHsgaW50ZXJhY3Rpb24gfSA9IHRoaXNcbiAgICBjb25zdCB0ID0gaW50ZXJhY3Rpb24uX25vdygpIC0gdGhpcy50MFxuICAgIGNvbnN0IHsgc21vb3RoRW5kRHVyYXRpb246IGR1cmF0aW9uIH0gPSBnZXRPcHRpb25zKGludGVyYWN0aW9uKVxuXG4gICAgaWYgKHQgPCBkdXJhdGlvbikge1xuICAgICAgY29uc3QgbmV3T2Zmc2V0ID0ge1xuICAgICAgICB4OiBlYXNlT3V0UXVhZCh0LCAwLCB0aGlzLnRhcmdldE9mZnNldC54LCBkdXJhdGlvbiksXG4gICAgICAgIHk6IGVhc2VPdXRRdWFkKHQsIDAsIHRoaXMudGFyZ2V0T2Zmc2V0LnksIGR1cmF0aW9uKSxcbiAgICAgIH1cbiAgICAgIGNvbnN0IGRlbHRhID0ge1xuICAgICAgICB4OiBuZXdPZmZzZXQueCAtIHRoaXMuY3VycmVudE9mZnNldC54LFxuICAgICAgICB5OiBuZXdPZmZzZXQueSAtIHRoaXMuY3VycmVudE9mZnNldC55LFxuICAgICAgfVxuXG4gICAgICB0aGlzLmN1cnJlbnRPZmZzZXQueCArPSBkZWx0YS54XG4gICAgICB0aGlzLmN1cnJlbnRPZmZzZXQueSArPSBkZWx0YS55XG5cbiAgICAgIGludGVyYWN0aW9uLm9mZnNldEJ5KGRlbHRhKVxuICAgICAgaW50ZXJhY3Rpb24ubW92ZSh7IHNraXBNb2RpZmllcnM6IHRoaXMubW9kaWZpZXJDb3VudCB9KVxuXG4gICAgICB0aGlzLnRpbWVvdXQgPSByYWYucmVxdWVzdCgoKSA9PiB0aGlzLnNtb290aEVuZFRpY2soKSlcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICBpbnRlcmFjdGlvbi5vZmZzZXRCeSh7XG4gICAgICAgIHg6IHRoaXMudGFyZ2V0T2Zmc2V0LnggLSB0aGlzLmN1cnJlbnRPZmZzZXQueCxcbiAgICAgICAgeTogdGhpcy50YXJnZXRPZmZzZXQueSAtIHRoaXMuY3VycmVudE9mZnNldC55LFxuICAgICAgfSlcblxuICAgICAgdGhpcy5lbmQoKVxuICAgIH1cbiAgfVxuXG4gIHJlc3VtZSAoeyBwb2ludGVyLCBldmVudCwgZXZlbnRUYXJnZXQgfTogSW50ZXJhY3QuU2lnbmFsQXJnc1snaW50ZXJhY3Rpb25zOmRvd24nXSkge1xuICAgIGNvbnN0IHsgaW50ZXJhY3Rpb24gfSA9IHRoaXNcblxuICAgIC8vIHVuZG8gaW5lcnRpYSBjaGFuZ2VzIHRvIGludGVyYWN0aW9uIGNvb3Jkc1xuICAgIGludGVyYWN0aW9uLm9mZnNldEJ5KHtcbiAgICAgIHg6IC10aGlzLmN1cnJlbnRPZmZzZXQueCxcbiAgICAgIHk6IC10aGlzLmN1cnJlbnRPZmZzZXQueSxcbiAgICB9KVxuXG4gICAgLy8gdXBkYXRlIHBvaW50ZXIgYXQgcG9pbnRlciBkb3duIHBvc2l0aW9uXG4gICAgaW50ZXJhY3Rpb24udXBkYXRlUG9pbnRlcihwb2ludGVyLCBldmVudCwgZXZlbnRUYXJnZXQsIHRydWUpXG5cbiAgICAvLyBmaXJlIHJlc3VtZSBzaWduYWxzIGFuZCBldmVudFxuICAgIGludGVyYWN0aW9uLl9kb1BoYXNlKHtcbiAgICAgIGludGVyYWN0aW9uLFxuICAgICAgZXZlbnQsXG4gICAgICBwaGFzZTogJ3Jlc3VtZScsXG4gICAgfSlcbiAgICBjb3B5Q29vcmRzKGludGVyYWN0aW9uLmNvb3Jkcy5wcmV2LCBpbnRlcmFjdGlvbi5jb29yZHMuY3VyKVxuXG4gICAgdGhpcy5zdG9wKClcbiAgfVxuXG4gIGVuZCAoKSB7XG4gICAgdGhpcy5pbnRlcmFjdGlvbi5tb3ZlKClcbiAgICB0aGlzLmludGVyYWN0aW9uLmVuZCgpXG4gICAgdGhpcy5zdG9wKClcbiAgfVxuXG4gIHN0b3AgKCkge1xuICAgIHRoaXMuYWN0aXZlID0gdGhpcy5zbW9vdGhFbmQgPSBmYWxzZVxuICAgIHRoaXMuaW50ZXJhY3Rpb24uc2ltdWxhdGlvbiA9IG51bGxcbiAgICByYWYuY2FuY2VsKHRoaXMudGltZW91dClcbiAgfVxufVxuXG5mdW5jdGlvbiBzdGFydCAoeyBpbnRlcmFjdGlvbiwgZXZlbnQgfTogSW50ZXJhY3QuRG9QaGFzZUFyZzxJbnRlcmFjdC5BY3Rpb25OYW1lLCAnZW5kJz4pIHtcbiAgaWYgKCFpbnRlcmFjdGlvbi5faW50ZXJhY3RpbmcgfHwgaW50ZXJhY3Rpb24uc2ltdWxhdGlvbikge1xuIC