/* interact.js 1.10.27 | https://raw.github.com/taye/interact.js/main/LICENSE */

import*as modifiers from"../modifiers/base.prod.js";import offset from"../offset/plugin.prod.js";import{Modification}from"../modifiers/Modification.prod.js";import*as dom from"../utils/domUtils.prod.js";import hypot from"../utils/hypot.prod.js";import is from"../utils/is.prod.js";import{copyCoords}from"../utils/pointerUtils.prod.js";import raf from"../utils/raf.prod.js";function install(t){const{defaults:i}=t;t.usePlugin(offset),t.usePlugin(modifiers.default),t.actions.phases.inertiastart=!0,t.actions.phases.resume=!0,i.perAction.inertia={enabled:!1,resistance:10,minSpeed:100,endSpeed:10,allowResume:!0,smoothEndDuration:300}}class InertiaState{constructor(t){this.active=!1,this.isModified=!1,this.smoothEnd=!1,this.allowResume=!1,this.modification=void 0,this.modifierCount=0,this.modifierArg=void 0,this.startCoords=void 0,this.t0=0,this.v0=0,this.te=0,this.targetOffset=void 0,this.modifiedOffset=void 0,this.currentOffset=void 0,this.lambda_v0=0,this.one_ve_v0=0,this.timeout=void 0,this.interaction=void 0,this.interaction=t}start(t){const{interaction:i}=this,e=getOptions(i);if(!e||!e.enabled)return!1;const{client:s}=i.coords.velocity,o=hypot(s.x,s.y),r=this.modification||(this.modification=new Modification(i));r.copyFrom(i.modification),this.t0=i._now(),this.allowResume=e.allowResume,this.v0=o,this.currentOffset={x:0,y:0},this.startCoords=i.coords.cur.page,this.modifierArg=r.fillArg({pageCoords:this.startCoords,preEnd:!0,phase:"inertiastart"});if(this.t0-i.coords.cur.timeStamp<50&&o>e.minSpeed&&o>e.endSpeed)this.startInertia();else{if(r.result=r.setAll(this.modifierArg),!r.result.changed)return!1;this.startSmoothEnd()}return i.modification.result.rect=null,i.offsetBy(this.targetOffset),i._doPhase({interaction:i,event:t,phase:"inertiastart"}),i.offsetBy({x:-this.targetOffset.x,y:-this.targetOffset.y}),i.modification.result.rect=null,this.active=!0,i.simulation=this,!0}startInertia(){const t=this.interaction.coords.velocity.client,i=getOptions(this.interaction),e=i.resistance,s=-Math.log(i.endSpeed/this.v0)/e;this.targetOffset={x:(t.x-s)/e,y:(t.y-s)/e},this.te=s,this.lambda_v0=e/this.v0,this.one_ve_v0=1-i.endSpeed/this.v0;const{modification:o,modifierArg:r}=this;r.pageCoords={x:this.startCoords.x+this.targetOffset.x,y:this.startCoords.y+this.targetOffset.y},o.result=o.setAll(r),o.result.changed&&(this.isModified=!0,this.modifiedOffset={x:this.targetOffset.x+o.result.delta.x,y:this.targetOffset.y+o.result.delta.y}),this.onNextFrame((()=>this.inertiaTick()))}startSmoothEnd(){this.smoothEnd=!0,this.isModified=!0,this.targetOffset={x:this.modification.result.delta.x,y:this.modification.result.delta.y},this.onNextFrame((()=>this.smoothEndTick()))}onNextFrame(t){this.timeout=raf.request((()=>{this.active&&t()}))}inertiaTick(){const{interaction:t}=this,i=getOptions(t).resistance,e=(t._now()-this.t0)/1e3;if(e<this.te){const s=1-(Math.exp(-i*e)-this.lambda_v0)/this.one_ve_v0;let o;o=this.isModified?getQuadraticCurvePoint(0,0,this.targetOffset.x,this.targetOffset.y,this.modifiedOffset.x,this.modifiedOffset.y,s):{x:this.targetOffset.x*s,y:this.targetOffset.y*s};const r={x:o.x-this.currentOffset.x,y:o.y-this.currentOffset.y};this.currentOffset.x+=r.x,this.currentOffset.y+=r.y,t.offsetBy(r),t.move(),this.onNextFrame((()=>this.inertiaTick()))}else t.offsetBy({x:this.modifiedOffset.x-this.currentOffset.x,y:this.modifiedOffset.y-this.currentOffset.y}),this.end()}smoothEndTick(){const{interaction:t}=this,i=t._now()-this.t0,{smoothEndDuration:e}=getOptions(t);if(i<e){const s={x:easeOutQuad(i,0,this.targetOffset.x,e),y:easeOutQuad(i,0,this.targetOffset.y,e)},o={x:s.x-this.currentOffset.x,y:s.y-this.currentOffset.y};this.currentOffset.x+=o.x,this.currentOffset.y+=o.y,t.offsetBy(o),t.move({skipModifiers:this.modifierCount}),this.onNextFrame((()=>this.smoothEndTick()))}else t.offsetBy({x:this.targetOffset.x-this.currentOffset.x,y:this.targetOffset.y-this.currentOffset.y}),this.end()}resume(t){let{pointer:i,event:e,eventTarget:s}=t;const{interaction:o}=this;o.offsetBy({x:-this.currentOffset.x,y:-this.currentOffset.y}),o.updatePointer(i,e,s,!0),o._doPhase({interaction:o,event:e,phase:"resume"}),copyCoords(o.coords.prev,o.coords.cur),this.stop()}end(){this.interaction.move(),this.interaction.end(),this.stop()}stop(){this.active=this.smoothEnd=!1,this.interaction.simulation=null,raf.cancel(this.timeout)}}function start(t){let{interaction:i,event:e}=t;if(!i._interacting||i.simulation)return null;return!i.inertia.start(e)&&null}function resume(t){const{interaction:i,eventTarget:e}=t,s=i.inertia;if(!s.active)return;let o=e;for(;is.element(o);){if(o===i.element){s.resume(t);break}o=dom.parentNode(o)}}function stop(t){let{interaction:i}=t;const e=i.inertia;e.active&&e.stop()}function getOptions(t){let{interactable:i,prepared:e}=t;return i&&i.options&&e.name&&i.options[e.name].inertia}const inertia={id:"inertia",before:["modifiers","actions"],install:install,listeners:{"interactions:new"(t){let{interaction:i}=t;i.inertia=new InertiaState(i)},"interactions:before-action-end":start,"interactions:down":resume,"interactions:stop":stop,"interactions:before-action-resume"(t){const{modification:i}=t.interaction;i.stop(t),i.start(t,t.interaction.coords.cur.page),i.applyToInteraction(t)},"interactions:before-action-inertiastart"(t){return t.interaction.modification.setAndApply(t)},"interactions:action-resume":modifiers.addEventModifiers,"interactions:action-inertiastart":modifiers.addEventModifiers,"interactions:after-action-inertiastart"(t){return t.interaction.modification.restoreInteractionCoords(t)},"interactions:after-action-resume"(t){return t.interaction.modification.restoreInteractionCoords(t)}}};function _getQBezierValue(t,i,e,s){const o=1-t;return o*o*i+2*o*t*e+t*t*s}function getQuadraticCurvePoint(t,i,e,s,o,r,n){return{x:_getQBezierValue(n,t,e,o),y:_getQBezierValue(n,i,s,r)}}function easeOutQuad(t,i,e,s){return-e*(t/=s)*(t-2)+i}export{InertiaState,inertia as default};
//# sourceMappingURL=plugin.prod.js.map
