/**
 * Created by mauricio on 5/11/15.
 */
'use strict'

// hyperbolic functions only present on es6
Math.sinh = Math.sinh || function (x) {
  var y = Math.exp(x)
  return (y - 1 / y) / 2
}

Math.cosh = Math.cosh || function (x) {
  var y = Math.exp(x)
  return (y + 1 / y) / 2
}

Math.tanh = Math.tanh || function (x) {
  if (x === Number.POSITIVE_INFINITY) {
    return 1
  } else if (x === Number.NEGATIVE_INFINITY) {
    return -1
  } else {
    var y = Math.exp(2 * x)
    return (y - 1) / (y + 1)
  }
}
