declare module "intl-tel-input/data" {
    export type Country = {
        name: string;
        iso2: string;
        dialCode: string;
        priority: number;
        areaCodes: string[] | null;
        nodeById: object;
    };
    const allCountries: Country[];
    export default allCountries;
}
declare module "i18n/en/countries" {
    namespace _default {
        export let af: string;
        export let ax: string;
        export let al: string;
        export let dz: string;
        export let as: string;
        export let ad: string;
        export let ao: string;
        export let ai: string;
        export let aq: string;
        export let ag: string;
        export let ar: string;
        export let am: string;
        export let aw: string;
        export let au: string;
        export let at: string;
        export let az: string;
        export let bs: string;
        export let bh: string;
        export let bd: string;
        export let bb: string;
        export let by: string;
        export let be: string;
        export let bz: string;
        export let bj: string;
        export let bm: string;
        export let bt: string;
        export let bo: string;
        export let ba: string;
        export let bw: string;
        export let bv: string;
        export let br: string;
        export let io: string;
        export let vg: string;
        export let bn: string;
        export let bg: string;
        export let bf: string;
        export let bi: string;
        export let kh: string;
        export let cm: string;
        export let ca: string;
        export let cv: string;
        export let bq: string;
        export let ky: string;
        export let cf: string;
        export let td: string;
        export let cl: string;
        export let cn: string;
        export let cx: string;
        export let cc: string;
        export let co: string;
        export let km: string;
        export let cg: string;
        export let cd: string;
        export let ck: string;
        export let cr: string;
        export let ci: string;
        export let hr: string;
        export let cu: string;
        export let cw: string;
        export let cy: string;
        export let cz: string;
        export let dk: string;
        export let dj: string;
        export let dm: string;
        let _do: string;
        export { _do as do };
        export let ec: string;
        export let eg: string;
        export let sv: string;
        export let gq: string;
        export let er: string;
        export let ee: string;
        export let sz: string;
        export let et: string;
        export let fk: string;
        export let fo: string;
        export let fj: string;
        export let fi: string;
        export let fr: string;
        export let gf: string;
        export let pf: string;
        export let tf: string;
        export let ga: string;
        export let gm: string;
        export let ge: string;
        export let de: string;
        export let gh: string;
        export let gi: string;
        export let gr: string;
        export let gl: string;
        export let gd: string;
        export let gp: string;
        export let gu: string;
        export let gt: string;
        export let gg: string;
        export let gn: string;
        export let gw: string;
        export let gy: string;
        export let ht: string;
        export let hm: string;
        export let hn: string;
        export let hk: string;
        export let hu: string;
        export let is: string;
        let _in: string;
        export { _in as in };
        export let id: string;
        export let ir: string;
        export let iq: string;
        export let ie: string;
        export let im: string;
        export let il: string;
        export let it: string;
        export let jm: string;
        export let jp: string;
        export let je: string;
        export let jo: string;
        export let kz: string;
        export let ke: string;
        export let ki: string;
        export let kw: string;
        export let kg: string;
        export let la: string;
        export let lv: string;
        export let lb: string;
        export let ls: string;
        export let lr: string;
        export let ly: string;
        export let li: string;
        export let lt: string;
        export let lu: string;
        export let mo: string;
        export let mg: string;
        export let mw: string;
        export let my: string;
        export let mv: string;
        export let ml: string;
        export let mt: string;
        export let mh: string;
        export let mq: string;
        export let mr: string;
        export let mu: string;
        export let yt: string;
        export let mx: string;
        export let fm: string;
        export let md: string;
        export let mc: string;
        export let mn: string;
        export let me: string;
        export let ms: string;
        export let ma: string;
        export let mz: string;
        export let mm: string;
        export let na: string;
        export let nr: string;
        export let np: string;
        export let nl: string;
        export let nc: string;
        export let nz: string;
        export let ni: string;
        export let ne: string;
        export let ng: string;
        export let nu: string;
        export let nf: string;
        export let kp: string;
        export let mk: string;
        export let mp: string;
        export let no: string;
        export let om: string;
        export let pk: string;
        export let pw: string;
        export let ps: string;
        export let pa: string;
        export let pg: string;
        export let py: string;
        export let pe: string;
        export let ph: string;
        export let pn: string;
        export let pl: string;
        export let pt: string;
        export let pr: string;
        export let qa: string;
        export let re: string;
        export let ro: string;
        export let ru: string;
        export let rw: string;
        export let ws: string;
        export let sm: string;
        export let st: string;
        export let sa: string;
        export let sn: string;
        export let rs: string;
        export let sc: string;
        export let sl: string;
        export let sg: string;
        export let sx: string;
        export let sk: string;
        export let si: string;
        export let sb: string;
        export let so: string;
        export let za: string;
        export let gs: string;
        export let kr: string;
        export let ss: string;
        export let es: string;
        export let lk: string;
        export let bl: string;
        export let sh: string;
        export let kn: string;
        export let lc: string;
        export let mf: string;
        export let pm: string;
        export let vc: string;
        export let sd: string;
        export let sr: string;
        export let sj: string;
        export let se: string;
        export let ch: string;
        export let sy: string;
        export let tw: string;
        export let tj: string;
        export let tz: string;
        export let th: string;
        export let tl: string;
        export let tg: string;
        export let tk: string;
        export let to: string;
        export let tt: string;
        export let tn: string;
        export let tr: string;
        export let tm: string;
        export let tc: string;
        export let tv: string;
        export let um: string;
        export let vi: string;
        export let ug: string;
        export let ua: string;
        export let ae: string;
        export let gb: string;
        export let us: string;
        export let uy: string;
        export let uz: string;
        export let vu: string;
        export let va: string;
        export let ve: string;
        export let vn: string;
        export let wf: string;
        export let eh: string;
        export let ye: string;
        export let zm: string;
        export let zw: string;
    }
    export default _default;
}
declare module "i18n/en/interface" {
    namespace _default {
        let selectedCountryAriaLabel: string;
        let noCountrySelected: string;
        let countryListAriaLabel: string;
        let searchPlaceholder: string;
        let zeroSearchResults: string;
        let oneSearchResult: string;
        let multipleSearchResults: string;
        let ac: string;
        let xk: string;
    }
    export default _default;
}
declare module "i18n/en/index" {
    const _default: {
        selectedCountryAriaLabel: string;
        noCountrySelected: string;
        countryListAriaLabel: string;
        searchPlaceholder: string;
        zeroSearchResults: string;
        oneSearchResult: string;
        multipleSearchResults: string;
        ac: string;
        xk: string;
        af: string;
        ax: string;
        al: string;
        dz: string;
        as: string;
        ad: string;
        ao: string;
        ai: string;
        aq: string;
        ag: string;
        ar: string;
        am: string;
        aw: string;
        au: string;
        at: string;
        az: string;
        bs: string;
        bh: string;
        bd: string;
        bb: string;
        by: string;
        be: string;
        bz: string;
        bj: string;
        bm: string;
        bt: string;
        bo: string;
        ba: string;
        bw: string;
        bv: string;
        br: string;
        io: string;
        vg: string;
        bn: string;
        bg: string;
        bf: string;
        bi: string;
        kh: string;
        cm: string;
        ca: string;
        cv: string;
        bq: string;
        ky: string;
        cf: string;
        td: string;
        cl: string;
        cn: string;
        cx: string;
        cc: string;
        co: string;
        km: string;
        cg: string;
        cd: string;
        ck: string;
        cr: string;
        ci: string;
        hr: string;
        cu: string;
        cw: string;
        cy: string;
        cz: string;
        dk: string;
        dj: string;
        dm: string;
        do: string;
        ec: string;
        eg: string;
        sv: string;
        gq: string;
        er: string;
        ee: string;
        sz: string;
        et: string;
        fk: string;
        fo: string;
        fj: string;
        fi: string;
        fr: string;
        gf: string;
        pf: string;
        tf: string;
        ga: string;
        gm: string;
        ge: string;
        de: string;
        gh: string;
        gi: string;
        gr: string;
        gl: string;
        gd: string;
        gp: string;
        gu: string;
        gt: string;
        gg: string;
        gn: string;
        gw: string;
        gy: string;
        ht: string;
        hm: string;
        hn: string;
        hk: string;
        hu: string;
        is: string;
        in: string;
        id: string;
        ir: string;
        iq: string;
        ie: string;
        im: string;
        il: string;
        it: string;
        jm: string;
        jp: string;
        je: string;
        jo: string;
        kz: string;
        ke: string;
        ki: string;
        kw: string;
        kg: string;
        la: string;
        lv: string;
        lb: string;
        ls: string;
        lr: string;
        ly: string;
        li: string;
        lt: string;
        lu: string;
        mo: string;
        mg: string;
        mw: string;
        my: string;
        mv: string;
        ml: string;
        mt: string;
        mh: string;
        mq: string;
        mr: string;
        mu: string;
        yt: string;
        mx: string;
        fm: string;
        md: string;
        mc: string;
        mn: string;
        me: string;
        ms: string;
        ma: string;
        mz: string;
        mm: string;
        na: string;
        nr: string;
        np: string;
        nl: string;
        nc: string;
        nz: string;
        ni: string;
        ne: string;
        ng: string;
        nu: string;
        nf: string;
        kp: string;
        mk: string;
        mp: string;
        no: string;
        om: string;
        pk: string;
        pw: string;
        ps: string;
        pa: string;
        pg: string;
        py: string;
        pe: string;
        ph: string;
        pn: string;
        pl: string;
        pt: string;
        pr: string;
        qa: string;
        re: string;
        ro: string;
        ru: string;
        rw: string;
        ws: string;
        sm: string;
        st: string;
        sa: string;
        sn: string;
        rs: string;
        sc: string;
        sl: string;
        sg: string;
        sx: string;
        sk: string;
        si: string;
        sb: string;
        so: string;
        za: string;
        gs: string;
        kr: string;
        ss: string;
        es: string;
        lk: string;
        bl: string;
        sh: string;
        kn: string;
        lc: string;
        mf: string;
        pm: string;
        vc: string;
        sd: string;
        sr: string;
        sj: string;
        se: string;
        ch: string;
        sy: string;
        tw: string;
        tj: string;
        tz: string;
        th: string;
        tl: string;
        tg: string;
        tk: string;
        to: string;
        tt: string;
        tn: string;
        tr: string;
        tm: string;
        tc: string;
        tv: string;
        um: string;
        vi: string;
        ug: string;
        ua: string;
        ae: string;
        gb: string;
        us: string;
        uy: string;
        uz: string;
        vu: string;
        va: string;
        ve: string;
        vn: string;
        wf: string;
        eh: string;
        ye: string;
        zm: string;
        zw: string;
    };
    export default _default;
    import countryTranslations from "i18n/en/countries.mjs";
    import interfaceTranslations from "i18n/en/interface.mjs";
    export { countryTranslations, interfaceTranslations };
}
declare module "intl-tel-input" {
    import { Country } from "intl-tel-input/data";
    type ItiGlobals = {
        autoCountry?: string;
        defaults: AllOptions;
        documentReady: () => boolean;
        getCountryData: () => Country[];
        getInstance: (input: HTMLInputElement) => Iti | null;
        instances: {
            [key: string]: Iti;
        };
        loadUtils: (path: string) => Promise<unknown> | null;
        startedLoadingAutoCountry?: boolean;
        startedLoadingUtilsScript?: boolean;
        version: string | undefined;
    };
    type ItiUtils = {
        formatNumber(number: string, iso2: string | undefined, format?: number): string;
        formatNumberAsYouType(number: string, iso2: string | undefined): string;
        getCoreNumber(number: string, iso2: string | undefined): string;
        getExampleNumber(iso2: string | undefined, nationalMode: boolean, numberType: number, useE164?: boolean): string;
        getExtension(number: string, iso2: string | undefined): string;
        getNumberType: (number: string, iso2: string | undefined) => number;
        getValidationError(number: string, iso2: string | undefined): number;
        isPossibleNumber(number: string, iso2: string | undefined, mobileOnly?: boolean): boolean;
        isValidNumber: (number: string, iso2: string | undefined) => boolean;
        numberFormat: {
            NATIONAL: number;
            INTERNATIONAL: number;
            E164: number;
            RFC3966: number;
        };
        numberType: object;
    };
    global {
        interface Window {
            intlTelInputGlobals: ItiGlobals;
            intlTelInputUtils: ItiUtils;
        }
    }
    type NumberType = "FIXED_LINE_OR_MOBILE" | "FIXED_LINE" | "MOBILE" | "PAGER" | "PERSONAL_NUMBER" | "PREMIUM_RATE" | "SHARED_COST" | "TOLL_FREE" | "UAN" | "UNKNOWN" | "VOICEMAIL" | "VOIP";
    type SelectedCountryData = Country | {
        name?: string;
        iso2?: string;
        dialCode?: string;
    };
    interface AllOptions {
        allowDropdown: boolean;
        autoPlaceholder: string;
        containerClass: string;
        countrySearch: boolean;
        customPlaceholder: ((selectedCountryPlaceholder: string, selectedCountryData: object) => string) | null;
        dropdownContainer: HTMLElement | null;
        excludeCountries: string[];
        fixDropdownWidth: boolean;
        formatAsYouType: boolean;
        formatOnDisplay: boolean;
        geoIpLookup: ((success: (iso2: string) => void, failure: () => void) => void) | null;
        hiddenInput: ((telInputName: string) => {
            phone: string;
            country?: string;
        }) | null;
        i18n: {
            af?: string;
            al?: string;
            dz?: string;
            as?: string;
            ad?: string;
            ao?: string;
            ai?: string;
            ag?: string;
            ar?: string;
            am?: string;
            aw?: string;
            ac?: string;
            au?: string;
            at?: string;
            az?: string;
            bs?: string;
            bh?: string;
            bd?: string;
            bb?: string;
            by?: string;
            be?: string;
            bz?: string;
            bj?: string;
            bm?: string;
            bt?: string;
            bo?: string;
            ba?: string;
            bw?: string;
            br?: string;
            io?: string;
            vg?: string;
            bn?: string;
            bg?: string;
            bf?: string;
            bi?: string;
            kh?: string;
            cm?: string;
            ca?: string;
            cv?: string;
            bq?: string;
            ky?: string;
            cf?: string;
            td?: string;
            cl?: string;
            cn?: string;
            cx?: string;
            cc?: string;
            co?: string;
            km?: string;
            cg?: string;
            cd?: string;
            ck?: string;
            cr?: string;
            hr?: string;
            cu?: string;
            cw?: string;
            cy?: string;
            cz?: string;
            ci?: string;
            dk?: string;
            dj?: string;
            dm?: string;
            do?: string;
            ec?: string;
            eg?: string;
            sv?: string;
            gq?: string;
            er?: string;
            ee?: string;
            sz?: string;
            et?: string;
            fk?: string;
            fo?: string;
            fj?: string;
            fi?: string;
            fr?: string;
            gf?: string;
            pf?: string;
            ga?: string;
            gm?: string;
            ge?: string;
            de?: string;
            gh?: string;
            gi?: string;
            gr?: string;
            gl?: string;
            gd?: string;
            gp?: string;
            gu?: string;
            gt?: string;
            gg?: string;
            gn?: string;
            gw?: string;
            gy?: string;
            ht?: string;
            hn?: string;
            hk?: string;
            hu?: string;
            is?: string;
            in?: string;
            id?: string;
            ir?: string;
            iq?: string;
            ie?: string;
            im?: string;
            il?: string;
            it?: string;
            jm?: string;
            jp?: string;
            je?: string;
            jo?: string;
            kz?: string;
            ke?: string;
            ki?: string;
            xk?: string;
            kw?: string;
            kg?: string;
            la?: string;
            lv?: string;
            lb?: string;
            ls?: string;
            lr?: string;
            ly?: string;
            li?: string;
            lt?: string;
            lu?: string;
            mo?: string;
            mg?: string;
            mw?: string;
            my?: string;
            mv?: string;
            ml?: string;
            mt?: string;
            mh?: string;
            mq?: string;
            mr?: string;
            mu?: string;
            yt?: string;
            mx?: string;
            fm?: string;
            md?: string;
            mc?: string;
            mn?: string;
            me?: string;
            ms?: string;
            ma?: string;
            mz?: string;
            mm?: string;
            na?: string;
            nr?: string;
            np?: string;
            nl?: string;
            nc?: string;
            nz?: string;
            ni?: string;
            ne?: string;
            ng?: string;
            nu?: string;
            nf?: string;
            kp?: string;
            mk?: string;
            mp?: string;
            no?: string;
            om?: string;
            pk?: string;
            pw?: string;
            ps?: string;
            pa?: string;
            pg?: string;
            py?: string;
            pe?: string;
            ph?: string;
            pl?: string;
            pt?: string;
            pr?: string;
            qa?: string;
            ro?: string;
            ru?: string;
            rw?: string;
            re?: string;
            ws?: string;
            sm?: string;
            sa?: string;
            sn?: string;
            rs?: string;
            sc?: string;
            sl?: string;
            sg?: string;
            sx?: string;
            sk?: string;
            si?: string;
            sb?: string;
            so?: string;
            za?: string;
            kr?: string;
            ss?: string;
            es?: string;
            lk?: string;
            bl?: string;
            sh?: string;
            kn?: string;
            lc?: string;
            mf?: string;
            pm?: string;
            vc?: string;
            sd?: string;
            sr?: string;
            sj?: string;
            se?: string;
            ch?: string;
            sy?: string;
            st?: string;
            tw?: string;
            tj?: string;
            tz?: string;
            th?: string;
            tl?: string;
            tg?: string;
            tk?: string;
            to?: string;
            tt?: string;
            tn?: string;
            tr?: string;
            tm?: string;
            tc?: string;
            tv?: string;
            vi?: string;
            ug?: string;
            ua?: string;
            ae?: string;
            gb?: string;
            us?: string;
            uy?: string;
            uz?: string;
            vu?: string;
            va?: string;
            ve?: string;
            vn?: string;
            wf?: string;
            eh?: string;
            ye?: string;
            zm?: string;
            zw?: string;
            ax?: string;
            selectedCountryAriaLabel?: string;
            searchPlaceholder?: string;
            countryListAriaLabel?: string;
            oneSearchResult?: string;
            multipleSearchResults?: string;
            noCountrySelected?: string;
            zeroSearchResults?: string;
        };
        initialCountry: string;
        nationalMode: boolean;
        onlyCountries: string[];
        placeholderNumberType: NumberType;
        preferredCountries: string[];
        showFlags: boolean;
        showSelectedDialCode: boolean;
        strictMode: boolean;
        useFullscreenPopup: boolean;
        utilsScript: string;
    }
    export type SomeOptions = Partial<AllOptions>;
    export class Iti {
        id: number;
        promise: Promise<[unknown, unknown]>;
        private telInput;
        private activeItem;
        private highlightedItem;
        private options;
        private hadInitialPlaceholder;
        private isRTL;
        private selectedCountryData;
        private countries;
        private dialCodeMaxLen;
        private dialCodeToIso2Map;
        private dialCodes;
        private preferredCountries;
        private countryContainer;
        private selectedCountry;
        private selectedCountryInner;
        private selectedCountryA11yText;
        private selectedDialCode;
        private dropdownArrow;
        private dropdownContent;
        private searchInput;
        private searchResultsA11yText;
        private countryList;
        private dropdown;
        private hiddenInput;
        private hiddenInputCountry;
        private maxCoreNumberLength;
        private defaultCountry;
        private _handleHiddenInputSubmit;
        private _handleLabelClick;
        private _handleClickSelectedCountry;
        private _handleCountryContainerKeydown;
        private _handleInputEvent;
        private _handleKeydownEvent;
        private _handleWindowScroll;
        private _handleMouseoverCountryList;
        private _handleClickCountryList;
        private _handleClickOffToClose;
        private _handleKeydownOnDropdown;
        private _handleSearchChange;
        private resolveAutoCountryPromise;
        private rejectAutoCountryPromise;
        private resolveUtilsScriptPromise;
        private rejectUtilsScriptPromise;
        constructor(input: HTMLInputElement, customOptions?: SomeOptions);
        _init(): void;
        private _processCountryData;
        private _addToDialCodeMap;
        private _processAllCountries;
        private _translateCountryNames;
        private _processDialCodes;
        private _processPreferredCountries;
        private _generateMarkup;
        private _appendListItems;
        private _setInitialState;
        private _initListeners;
        private _initHiddenInputListener;
        private _initDropdownListeners;
        private _initRequests;
        private _loadAutoCountry;
        private _initTelInputListeners;
        private _cap;
        private _trigger;
        private _openDropdown;
        private _setDropdownPosition;
        private _bindDropdownListeners;
        private _filterCountries;
        private _updateSearchResultsText;
        private _handleUpDownKey;
        private _handleEnterKey;
        private _searchForCountry;
        private _updateValFromNumber;
        private _updateCountryFromNumber;
        private _highlightListItem;
        private _getCountryData;
        private _setCountry;
        private _updateMaxLength;
        private _setSelectedCountryTitleAttribute;
        private _getHiddenSelectedCountryWidth;
        private _updatePlaceholder;
        private _selectListItem;
        private _closeDropdown;
        private _scrollTo;
        private _updateDialCode;
        private _getDialCode;
        private _getFullNumber;
        private _beforeSetNumber;
        private _triggerCountryChange;
        private _formatNumberAsYouType;
        handleAutoCountry(): void;
        handleUtils(): void;
        destroy(): void;
        getExtension(): string;
        getNumber(format?: number): string;
        getNumberType(): number;
        getSelectedCountryData(): SelectedCountryData;
        getValidationError(): number;
        isValidNumber(mobileOnly?: boolean): boolean | null;
        isValidNumberPrecise(): boolean | null;
        setCountry(iso2: string): void;
        setNumber(number: string): void;
        setPlaceholderNumberType(type: NumberType): void;
    }
    const intlTelInput: (input: HTMLInputElement, options?: SomeOptions) => Iti;
    export default intlTelInput;
}
