var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var core_1 = require('angular2/core');
var common_1 = require('angular2/common');
var nav_controller_1 = require('../nav/nav-controller');
var view_controller_1 = require('../nav/view-controller');
var config_1 = require('../../config/config');
var animation_1 = require('../../animations/animation');
var util_1 = require('../../util/util');
/**
 * @name Alert
 * @description
 * An Alert is a dialog that presents users with either information, or used
 * to receive information from the user using inputs. An alert appears on top
 * of the app's content, and must be manually dismissed by the user before
 * they can resume interaction with the app.
 *
 * An alert is created from an array of `buttons` and optionally an array of
 * `inputs`. Each button includes properties for its `text`, and optionally a
 * `handler`. If a handler returns `false` then the alert will not be dismissed.
 * An alert can also optionally have a `title`, `subTitle` and `body`.
 *
 * All buttons will show up in the order they have been added to the `buttons`
 * array, from left to right. Note: The right most button (the last one in the
 * array) is the main button.
 *
 * Alerts can also include inputs whos data can be passed back to the app.
 * Inputs can be used to prompt users for information.
 *
 * Its shorthand is to add all the alert's options from within the
 * `Alert.create(opts)` first argument. Otherwise the alert's
 * instance has methods to add options, such as `setTitle()` or `addButton()`.
 *
 * @usage
 * ```ts
 * constructor(nav: NavController) {
 *   this.nav = nav;
 * }
 *
 * presentAlert() {
 *   let alert = Alert.create({
 *     title: 'Low battery',
 *     subTitle: '10% of battery remaining',
 *     buttons: ['Dismiss']
 *   });
 *   this.nav.present(alert);
 * }
 *
 * presentConfirm() {
 *   let alert = Alert.create({
 *     title: 'Confirm purchase',
 *     body: 'Do you want to buy this book?',
 *     buttons: [
 *       {
 *         text: 'Cancel',
 *         handler: () => {
 *           console.log('Cancel clicked');
 *         }
 *       },
 *       {
 *         text: 'Buy',
 *         handler: () => {
 *           console.log('Buy clicked');
 *         }
 *       }
 *     ]
 *   });
 *   this.nav.present(alert);
 * }
 *
 * presentPrompt() {
 *   let alert = Alert.create({
 *     title: 'Login',
 *     inputs: [
 *       {
 *         name: 'username',
 *         placeholder: 'Username'
 *       },
 *       {
 *         name: 'password',
 *         placeholder: 'Password',
 *         type: 'password'
 *       }
 *     ],
 *     buttons: [
 *       {
 *         text: 'Cancel',
 *         handler: data => {
 *           console.log('Cancel clicked');
 *         }
 *       },
 *       {
 *         text: 'Login',
 *         handler: data => {
 *           if (User.isValid(data.username, data.password)) {
 *             // logged in!
 *           } else {
 *             // invalid login
 *             return false;
 *           }
 *         }
 *       }
 *     ]
 *   });
 *   this.nav.present(alert);
 * }
 * ```
 *
 */
var Alert = (function (_super) {
    __extends(Alert, _super);
    function Alert(opts) {
        if (opts === void 0) { opts = {}; }
        opts.inputs = opts.inputs || [];
        opts.buttons = opts.buttons || [];
        _super.call(this, AlertCmp, opts);
        this.viewType = 'alert';
    }
    /**
    * @private
    */
    Alert.prototype.getTransitionName = function (direction) {
        var key = (direction === 'back' ? 'alertLeave' : 'alertEnter');
        return this._nav && this._nav.config.get(key);
    };
    /**
     * @param {string} title Alert title
     */
    Alert.prototype.setTitle = function (title) {
        this.data.title = title;
    };
    /**
     * @param {string} subTitle Alert subtitle
     */
    Alert.prototype.setSubTitle = function (subTitle) {
        this.data.subTitle = subTitle;
    };
    /**
     * @param {string} body Alert body content
     */
    Alert.prototype.setBody = function (body) {
        this.data.body = body;
    };
    /**
     * @param {Object} input Alert input
     */
    Alert.prototype.addInput = function (input) {
        this.data.inputs.push(input);
    };
    /**
     * @param {Object} button Alert button
     */
    Alert.prototype.addButton = function (button) {
        this.data.buttons.push(button);
    };
    /**
     * @param {Object} opts Alert options
     */
    Alert.create = function (opts) {
        if (opts === void 0) { opts = {}; }
        return new Alert(opts);
    };
    return Alert;
})(view_controller_1.ViewController);
exports.Alert = Alert;
/**
* @private
*/
var AlertCmp = (function () {
    function AlertCmp(_viewCtrl, _elementRef, _config, params, renderer) {
        this._viewCtrl = _viewCtrl;
        this._elementRef = _elementRef;
        this._config = _config;
        this.d = params.data;
        if (this.d.cssClass) {
            renderer.setElementClass(_elementRef, this.d.cssClass, true);
        }
    }
    AlertCmp.prototype.click = function (button) {
        var _this = this;
        var shouldDismiss = true;
        if (button.handler) {
            // a handler has been provided, execute it
            // pass the handler the values from the inputs
            if (button.handler(this.getValues()) === false) {
                // if the return value of the handler is false then do not dismiss
                shouldDismiss = false;
            }
        }
        if (shouldDismiss) {
            setTimeout(function () {
                _this.dismiss();
            }, this._config.get('pageTransitionDelay'));
        }
    };
    AlertCmp.prototype.dismiss = function () {
        this._viewCtrl.dismiss(this.getValues());
    };
    AlertCmp.prototype.getValues = function () {
        var values = {};
        this.d.inputs.forEach(function (input) {
            values[input.name] = input.value;
        });
        return values;
    };
    AlertCmp.prototype.onPageLoaded = function () {
        // normalize the data
        this.d.buttons = this.d.buttons.map(function (button) {
            if (typeof button === 'string') {
                return { text: button };
            }
            return button;
        });
        this.d.inputs = this.d.inputs.map(function (input, index) {
            return {
                name: util_1.isDefined(input.name) ? input.name : index,
                placeholder: util_1.isDefined(input.placeholder) ? input.placeholder : '',
                type: input.type || 'text',
                value: util_1.isDefined(input.value) ? input.value : ''
            };
        });
        var self = this;
        self.keyUp = function (ev) {
            if (ev.keyCode === 13) {
                // enter
                console.debug('alert enter');
                var button = self.d.buttons[self.d.buttons.length - 1];
                self.click(button);
            }
            else if (ev.keyCode === 27) {
                console.debug('alert escape');
                self.dismiss();
            }
        };
        document.addEventListener('keyup', this.keyUp);
    };
    AlertCmp.prototype.onPageDidEnter = function () {
        document.activeElement && document.activeElement.blur();
        if (this.d.inputs.length) {
            var firstInput = this._elementRef.nativeElement.querySelector('input');
            if (firstInput) {
                firstInput.focus();
            }
        }
    };
    AlertCmp.prototype.onPageDidLeave = function () {
        document.removeEventListener('keyup', this.keyUp);
    };
    AlertCmp = __decorate([
        core_1.Component({
            selector: 'ion-alert',
            template: '<div (click)="dismiss()" tappable disable-activated class="backdrop" role="presentation"></div>' +
                '<div class="alert-wrapper">' +
                '<div class="alert-head">' +
                '<h2 class="alert-title" *ngIf="d.title">{{d.title}}</h2>' +
                '<h3 class="alert-sub-title" *ngIf="d.subTitle">{{d.subTitle}}</h3>' +
                '</div>' +
                '<div class="alert-body" *ngIf="d.body">{{d.body}}</div>' +
                '<div class="alert-body alert-inputs" *ngIf="d.inputs.length">' +
                '<div class="alert-input-wrapper" *ngFor="#i of d.inputs">' +
                '<input [placeholder]="i.placeholder" [(ngModel)]="i.value" [type]="i.type" class="alert-input">' +
                '</div>' +
                '</div>' +
                '<div class="alert-buttons">' +
                '<button *ngFor="#b of d.buttons" (click)="click(b)" [ngClass]="b.cssClass" class="alert-button">' +
                '{{b.text}}' +
                '</button>' +
                '</div>' +
                '</div>',
            host: {
                'role': 'dialog'
            },
            directives: [common_1.NgClass, common_1.NgIf, common_1.NgFor]
        }), 
        __metadata('design:paramtypes', [(typeof (_a = typeof view_controller_1.ViewController !== 'undefined' && view_controller_1.ViewController) === 'function' && _a) || Object, (typeof (_b = typeof core_1.ElementRef !== 'undefined' && core_1.ElementRef) === 'function' && _b) || Object, (typeof (_c = typeof config_1.Config !== 'undefined' && config_1.Config) === 'function' && _c) || Object, (typeof (_d = typeof nav_controller_1.NavParams !== 'undefined' && nav_controller_1.NavParams) === 'function' && _d) || Object, (typeof (_e = typeof core_1.Renderer !== 'undefined' && core_1.Renderer) === 'function' && _e) || Object])
    ], AlertCmp);
    return AlertCmp;
    var _a, _b, _c, _d, _e;
})();
/**
 * Animations for alerts
 */
var AlertPopIn = (function (_super) {
    __extends(AlertPopIn, _super);
    function AlertPopIn(enteringView, leavingView, opts) {
        _super.call(this, null, opts);
        var ele = enteringView.pageRef().nativeElement;
        var backdrop = new animation_1.Animation(ele.querySelector('.backdrop'));
        var wrapper = new animation_1.Animation(ele.querySelector('.alert-wrapper'));
        wrapper.fromTo('opacity', '0.01', '1').fromTo('scale', '1.1', '1');
        backdrop.fromTo('opacity', '0.01', '0.3');
        this
            .easing('ease-in-out')
            .duration(200)
            .add(backdrop, wrapper);
    }
    return AlertPopIn;
})(animation_1.Animation);
animation_1.Animation.register('alert-pop-in', AlertPopIn);
var AlertPopOut = (function (_super) {
    __extends(AlertPopOut, _super);
    function AlertPopOut(enteringView, leavingView, opts) {
        _super.call(this, null, opts);
        var ele = leavingView.pageRef().nativeElement;
        var backdrop = new animation_1.Animation(ele.querySelector('.backdrop'));
        var wrapper = new animation_1.Animation(ele.querySelector('.alert-wrapper'));
        wrapper.fromTo('opacity', '1', '0').fromTo('scale', '1', '0.9');
        backdrop.fromTo('opacity', '0.3', '0');
        this
            .easing('ease-in-out')
            .duration(200)
            .add(backdrop, wrapper);
    }
    return AlertPopOut;
})(animation_1.Animation);
animation_1.Animation.register('alert-pop-out', AlertPopOut);
var AlertMdPopIn = (function (_super) {
    __extends(AlertMdPopIn, _super);
    function AlertMdPopIn(enteringView, leavingView, opts) {
        _super.call(this, null, opts);
        var ele = enteringView.pageRef().nativeElement;
        var backdrop = new animation_1.Animation(ele.querySelector('.backdrop'));
        var wrapper = new animation_1.Animation(ele.querySelector('.alert-wrapper'));
        wrapper.fromTo('opacity', '0.01', '1').fromTo('scale', '1.1', '1');
        backdrop.fromTo('opacity', '0.01', '0.5');
        this
            .easing('ease-in-out')
            .duration(200)
            .add(backdrop, wrapper);
    }
    return AlertMdPopIn;
})(animation_1.Animation);
animation_1.Animation.register('alert-md-pop-in', AlertMdPopIn);
var AlertMdPopOut = (function (_super) {
    __extends(AlertMdPopOut, _super);
    function AlertMdPopOut(enteringView, leavingView, opts) {
        _super.call(this, null, opts);
        var ele = leavingView.pageRef().nativeElement;
        var backdrop = new animation_1.Animation(ele.querySelector('.backdrop'));
        var wrapper = new animation_1.Animation(ele.querySelector('.alert-wrapper'));
        wrapper.fromTo('opacity', '1', '0').fromTo('scale', '1', '0.9');
        backdrop.fromTo('opacity', '0.5', '0');
        this
            .easing('ease-in-out')
            .duration(200)
            .add(backdrop, wrapper);
    }
    return AlertMdPopOut;
})(animation_1.Animation);
animation_1.Animation.register('alert-md-pop-out', AlertMdPopOut);