/**
 * @name Platform
 * @description
 * Platform returns the availble information about your current platform.
 * Platforms in Ionic 2 are much more complex then in V1, returns not just a single platform,
 * but a hierarchy of information, such as a devices OS, phone vs tablet, or mobile vs browser.
 * With this information you can completely custimize your app to fit any device and platform.
 *
 * @usage
 * ```ts
 * import {Platform} 'ionic/ionic';
 * export MyClass {
 *    constructor(platform: Platform){
 *      this.platform = platform;
 *    }
 * }
 * ```
 * @demo /docs/v2/demos/platform/
 */
export declare class Platform {
    constructor(platforms?: any[]);
    /**
     * @param {string} platformName
     * @returns {bool} returns true/false based on platform you place
     * @description
     * Depending on the platform name, isPlatform will return true or flase
     *
     * ```
     * import {Platform} 'ionic/ionic';
     * export MyClass {
     *    constructor(platform: Platform){
     *      this.platform = platform;
     *      if(this.platform.is('ios'){
     *        // what ever you need to do for
     *        // if the platfomr is ios
     *      }
     *    }
     * }
     * ```
     */
    is(platformName: any): boolean;
    /**
     * @returns {array} the array of platforms
     * @description
     * Depending on what device you are on, `platforms` can return multiple values.
     * Each possible value is a hierarchy of platforms. For example, on an iPhone,
     * it would return mobile, ios, and iphone.
     *
     * ```
     * import {Platform} 'ionic/ionic';
     * export MyClass {
     *    constructor(platform: Platform){
     *      this.platform = platform;
     *      console.log(this.platform.platforms());
     *      // This will return an array of all the availble platforms
     *      // From if your on mobile, to mobile os, and device name
     *    }
     * }
     * ```
     */
    platforms(): any;
    /**
     * Returns an object containing information about the paltform
     *
     * ```
     * import {Platform} 'ionic/ionic';
     * export MyClass {
     *    constructor(platform: Platform){
     *      this.platform = platform;
     *      console.log(this.platform.versions());
     *    }
     * }
     * ```
  
     * @param {string} [platformName] optional platformName
     * @returns {object} An object with various platform info
     *
     */
    versions(platformName: any): any;
    /**
     * @private
     */
    version(): any;
    /**
     * Returns a promise when the platform is ready and native functionality can be called
     *
     * ```
     * import {Platform} 'ionic/ionic';
     * export MyClass {
     *    constructor(platform: Platform){
     *      this.platform = platform;
     *      this.platform.ready().then(() => {
     *        console.log('Platform ready');
     *        // The platform is now ready, execute any native code you want
     *       });
     *    }
     * }
     * ```
     * @returns {promise} Returns a promsie when device ready has fired
     */
    ready(): any;
    /**
     * @private
     */
    prepareReady(config: any): void;
    /**
     * Returns if this app is using right-to-left language direction or not.
     * http://www.w3.org/International/questions/qa-html-dir
     * @returns {boolean}
     */
    isRTL(): any;
    /**
    * @private
    */
    setIsRTL(val: any): void;
    /**
    * @private
    */
    on(): void;
    /**
    * @private
    */
    onHardwareBackButton(): void;
    /**
    * @private
    */
    registerBackButtonAction(): void;
    /**
    * @private
    */
    exitApp(): void;
    /**
    * @private
    */
    fullScreen(): void;
    /**
    * @private
    */
    showStatusBar(): void;
    /**
    * @private
    */
    url(val: any): any;
    /**
    * @private
    */
    query(key: any): any;
    /**
    * @private
    */
    userAgent(val: any): any;
    /**
    * @private
    */
    navigatorPlatform(val: any): any;
    /**
    * @private
    */
    width(): any;
    /**
    * @private
    */
    height(): any;
    /**
    * @private
    */
    isPortrait(): boolean;
    /**
    * @private
    */
    isLandscape(): boolean;
    /**
    * @private
    */
    windowResize(): void;
    /**
    * @private
    */
    onResize(cb: any): void;
    /**
     * @private
     */
    static register(platformConfig: any): void;
    /**
    * @private
    */
    static registry(): {};
    /**
     * @private
     */
    static get(platformName: any): any;
    /**
     * @private
     */
    static setDefault(platformName: any): void;
    /**
     * @private
     */
    testQuery(queryValue: any, queryTestValue: any): boolean;
    /**
     * @private
     */
    testUserAgent(userAgentExpression: any): boolean;
    /**
     * @private
     */
    testNavigatorPlatform(navigatorPlatformExpression: any): boolean;
    /**
     * @private
     */
    matchUserAgentVersion(userAgentExpression: any): {
        major: any;
        minor: any;
    };
    /**
     * @private
     */
    isPlatform(queryTestValue: any, userAgentExpression: any): boolean;
    /**
     * @private
     */
    load(platformOverride: any): void;
    /**
     * @private
     */
    matchPlatform(platformName: any): any;
}
