"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const node_1 = require("@ionic/cli-framework/utils/node");
const chalk_1 = require("chalk");
const Debug = require("debug");
const path = require("path");
const semver = require("semver");
if (process.argv.includes('--no-color')) {
    chalk_1.default.enabled = false;
}
const debug = Debug('ionic:bootstrap');
exports.ERROR_BASE_DIRECTORY_NOT_FOUND = 'BASE_DIRECTORY_NOT_FOUND';
exports.ERROR_LOCAL_CLI_NOT_FOUND = 'LOCAL_CLI_NOT_FOUND';
exports.ERROR_VERSION_TOO_OLD = 'VERSION_TOO_OLD';
function detectLocalCLI() {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        let pkgPath;
        try {
            pkgPath = node_1.resolve('ionic/package', { paths: node_1.compileNodeModulesPaths(process.cwd()) });
        }
        catch (e) {
            // ignore
        }
        if (pkgPath && process.env.IONIC_CLI_LIB !== path.dirname(pkgPath)) {
            const pkg = yield node_1.readPackageJsonFile(pkgPath);
            debug(`local CLI ${chalk_1.default.bold(pkg.version)} found at ${chalk_1.default.bold(pkgPath)}`);
            if (semver.lt(pkg.version, '4.0.0')) {
                throw exports.ERROR_VERSION_TOO_OLD;
            }
            return path.dirname(pkgPath);
        }
        throw exports.ERROR_LOCAL_CLI_NOT_FOUND;
    });
}
exports.detectLocalCLI = detectLocalCLI;
