"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const base_1 = require("./base");
class AddCommand extends base_1.CapacitorCommand {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'add',
                type: 'project',
                summary: 'Add a native platform to your Ionic project',
                description: `
${chalk_1.default.green('ionic capacitor add')} will do the following:
- Add a new platform specific folder to your project (ios, android, or electron)
      `,
                inputs: [
                    {
                        name: 'platform',
                        summary: `The platform to add (e.g. ${['android', 'ios', 'electron'].map(v => chalk_1.default.green(v)).join(', ')})`,
                        validators: [cli_framework_1.validators.required],
                    },
                ],
                groups: [cli_framework_1.CommandGroup.Beta],
            };
        });
    }
    preRun(inputs, options, runinfo) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield this.preRunChecks(runinfo);
            if (!inputs[0]) {
                const platform = yield this.env.prompt({
                    type: 'list',
                    name: 'platform',
                    message: 'What platform would you like to add?',
                    choices: ['android', 'ios', 'electron'],
                });
                inputs[0] = platform.trim();
            }
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [platform] = inputs;
            const args = ['add'];
            if (platform) {
                args.push(platform);
            }
            yield this.runCapacitor(args);
        });
    }
}
exports.AddCommand = AddCommand;
