"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const namespace_1 = require("../../lib/namespace");
class CapacitorNamespace extends namespace_1.Namespace {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'capacitor',
                summary: 'Capacitor functionality',
                description: `
These commands integrate with Capacitor, Ionic's new native layer project which provides an alternative to Cordova for native functionality in your app.

Learn more about Capacitor:
- Main documentation: ${chalk_1.default.bold('https://ion.link/capacitor')}
      `,
                groups: [cli_framework_1.NamespaceGroup.Beta],
            };
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['add', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { AddCommand } = yield Promise.resolve().then(() => require('./add')); return new AddCommand(this); })],
                ['copy', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { CopyCommand } = yield Promise.resolve().then(() => require('./copy')); return new CopyCommand(this); })],
                ['open', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { OpenCommand } = yield Promise.resolve().then(() => require('./open')); return new OpenCommand(this); })],
                ['run', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { RunCommand } = yield Promise.resolve().then(() => require('./run')); return new RunCommand(this); })],
                ['sync', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { SyncCommand } = yield Promise.resolve().then(() => require('./sync')); return new SyncCommand(this); })],
                ['update', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { UpdateCommand } = yield Promise.resolve().then(() => require('./update')); return new UpdateCommand(this); })],
            ]);
        });
    }
}
exports.CapacitorNamespace = CapacitorNamespace;
