"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const base_1 = require("./base");
class OpenCommand extends base_1.CapacitorCommand {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'open',
                type: 'project',
                summary: 'Open the IDE for a given native platform project',
                description: `
${chalk_1.default.green('ionic capacitor open')} will do the following:
- Open the IDE for your native project (Xcode for iOS, Android Studio for Android)
      `,
                inputs: [
                    {
                        name: 'platform',
                        summary: `The platform to open (e.g. ${['android', 'ios'].map(v => chalk_1.default.green(v)).join(', ')})`,
                        validators: [cli_framework_1.validators.required],
                    },
                ],
                groups: [cli_framework_1.CommandGroup.Beta],
            };
        });
    }
    preRun(inputs, options, runinfo) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield this.preRunChecks(runinfo);
            if (!inputs[0]) {
                const platform = yield this.env.prompt({
                    type: 'list',
                    name: 'platform',
                    message: 'What platform would you like to open?',
                    choices: ['android', 'ios'],
                });
                inputs[0] = platform.trim();
            }
            yield this.checkForPlatformInstallation(inputs[0]);
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [platform] = inputs;
            const args = ['open'];
            if (platform) {
                args.push(platform);
            }
            yield this.runCapacitor(args);
        });
    }
}
exports.OpenCommand = OpenCommand;
