"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const base_1 = require("./base");
class SyncCommand extends base_1.CapacitorCommand {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'sync',
                type: 'project',
                summary: 'Sync (copy + update) an Ionic project',
                description: `
${chalk_1.default.green('ionic capacitor sync')} will do the following:
- Copy web assets to all Capacitor native platforms
- Update each Capacitor native platforms, such as any dependencies that need updating.
- Install any discovered Capacitor or Cordova plugins.
      `,
                inputs: [
                    {
                        name: 'platform',
                        summary: `The platform to sync (e.g. ${['android', 'ios', 'electron'].map(v => chalk_1.default.green(v)).join(', ')})`,
                    },
                ],
                groups: [cli_framework_1.CommandGroup.Beta],
            };
        });
    }
    preRun(inputs, options, runinfo) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield this.preRunChecks(runinfo);
            if (inputs[0]) {
                yield this.checkForPlatformInstallation(inputs[0]);
            }
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [platform] = inputs;
            const args = ['sync'];
            if (platform) {
                args.push(platform);
            }
            yield this.runCapacitor(args);
        });
    }
}
exports.SyncCommand = SyncCommand;
