"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const base_1 = require("./base");
class UpdateCommand extends base_1.CapacitorCommand {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'update',
                type: 'project',
                summary: 'Update Capacitor native platforms, install Capacitor/Cordova plugins',
                description: `
${chalk_1.default.green('ionic capacitor update')} will do the following:
- Update each Capacitor native project, such as any dependencies that need updating.
- Install any discovered Capacitor or Cordova plugins.
      `,
                inputs: [
                    {
                        name: 'platform',
                        summary: `The platform to update (e.g. ${['android', 'ios', 'electron'].map(v => chalk_1.default.green(v)).join(', ')})`,
                    },
                ],
                groups: [cli_framework_1.CommandGroup.Beta],
            };
        });
    }
    preRun(inputs, options, runinfo) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield this.preRunChecks(runinfo);
            if (inputs[0]) {
                yield this.checkForPlatformInstallation(inputs[0]);
            }
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const [platform] = inputs;
            const args = ['update'];
            if (platform) {
                args.push(platform);
            }
            yield this.runCapacitor(args);
        });
    }
}
exports.UpdateCommand = UpdateCommand;
