"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const format_1 = require("@ionic/cli-framework/utils/format");
const chalk_1 = require("chalk");
const constants_1 = require("../../constants");
const namespace_1 = require("../../lib/namespace");
class ConfigNamespace extends namespace_1.Namespace {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const projectFile = this.project ? format_1.prettyPath(this.project.filePath) : constants_1.PROJECT_FILE;
            return {
                name: 'config',
                summary: 'Manage CLI and project config values',
                description: `
These commands are used to programmatically read, write, and delete CLI and project config values.

By default, these commands use your project's ${chalk_1.default.bold(format_1.prettyPath(projectFile))} file.

To use these commands for the global CLI config file (${chalk_1.default.bold('~/.ionic/config.json')}), use the ${chalk_1.default.green('--global')} flag.
      `,
            };
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['get', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { ConfigGetCommand } = yield Promise.resolve().then(() => require('./get')); return new ConfigGetCommand(this); })],
                ['set', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { ConfigSetCommand } = yield Promise.resolve().then(() => require('./set')); return new ConfigSetCommand(this); })],
                ['unset', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { ConfigUnsetCommand } = yield Promise.resolve().then(() => require('./unset')); return new ConfigUnsetCommand(this); })],
            ]);
        });
    }
}
exports.ConfigNamespace = ConfigNamespace;
