import { CommandInstanceInfo, CommandMetadataOption, IShellRunOptions, ProjectIntegration } from '../../definitions';
import { Command } from '../../lib/command';
export declare const CORDOVA_COMPILE_OPTIONS: CommandMetadataOption[];
export declare const CORDOVA_RUN_OPTIONS: ReadonlyArray<CommandMetadataOption>;
export declare const CORDOVA_BUILD_EXAMPLE_COMMANDS: string[];
export declare abstract class CordovaCommand extends Command {
    private _integration?;
    readonly integration: Required<ProjectIntegration>;
    checkCordova(runinfo: CommandInstanceInfo): Promise<void>;
    preRunChecks(runinfo: CommandInstanceInfo): Promise<void>;
    runCordova(argList: string[], { fatalOnNotFound, truncateErrorOutput, ...options }?: IShellRunOptions): Promise<void>;
    checkForPlatformInstallation(platform: string, { promptToInstall, promptToInstallRefusalMsg }?: {
        promptToInstall?: boolean;
        promptToInstallRefusalMsg?: string;
    }): Promise<void>;
}
