"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const utils_1 = require("../../lib/integrations/cordova/utils");
const base_1 = require("./base");
class CompileCommand extends base_1.CordovaCommand {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'compile',
                type: 'project',
                summary: 'Compile native platform code',
                description: `
Like running ${chalk_1.default.green('cordova compile')} directly, but provides friendly checks.
      `,
                exampleCommands: [
                    'ios',
                    'ios --device',
                    'android',
                ],
                inputs: [
                    {
                        name: 'platform',
                        summary: `The platform to compile (${['android', 'ios'].map(v => chalk_1.default.green(v)).join(', ')})`,
                        validators: [cli_framework_1.validators.required],
                    },
                ],
                options: [
                    ...base_1.CORDOVA_COMPILE_OPTIONS,
                ],
            };
        });
    }
    preRun(inputs, options, runinfo) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield this.preRunChecks(runinfo);
            if (!inputs[0]) {
                const platform = yield this.env.prompt({
                    type: 'input',
                    name: 'platform',
                    message: `What platform would you like to compile (${['android', 'ios'].map(v => chalk_1.default.green(v)).join(', ')}):`,
                });
                inputs[0] = platform.trim();
            }
            yield this.checkForPlatformInstallation(inputs[0]);
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const metadata = yield this.getMetadata();
            yield this.runCordova(utils_1.filterArgumentsForCordova(metadata, options), {});
        });
    }
}
exports.CompileCommand = CompileCommand;
