"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const namespace_1 = require("../../lib/namespace");
class CordovaNamespace extends namespace_1.Namespace {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'cordova',
                summary: 'Cordova functionality',
                description: `
These commands integrate with Apache Cordova, which brings native functionality to your app. Aside from ${chalk_1.default.green('ionic cordova resources')}, these commands all wrap the Cordova CLI.

Cordova Reference documentation:
- Overview: ${chalk_1.default.bold('https://cordova.apache.org/docs/en/latest/guide/overview/index.html')}
- CLI documentation: ${chalk_1.default.bold('https://cordova.apache.org/docs/en/latest/reference/cordova-cli/')}
      `,
            };
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['build', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { BuildCommand } = yield Promise.resolve().then(() => require('./build')); return new BuildCommand(this); })],
                ['compile', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { CompileCommand } = yield Promise.resolve().then(() => require('./compile')); return new CompileCommand(this); })],
                ['emulate', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { EmulateCommand } = yield Promise.resolve().then(() => require('./emulate')); return new EmulateCommand(this); })],
                ['platform', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { PlatformCommand } = yield Promise.resolve().then(() => require('./platform')); return new PlatformCommand(this); })],
                ['plugin', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { PluginCommand } = yield Promise.resolve().then(() => require('./plugin')); return new PluginCommand(this); })],
                ['prepare', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { PrepareCommand } = yield Promise.resolve().then(() => require('./prepare')); return new PrepareCommand(this); })],
                ['resources', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { ResourcesCommand } = yield Promise.resolve().then(() => require('./resources')); return new ResourcesCommand(this); })],
                ['run', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { RunCommand } = yield Promise.resolve().then(() => require('./run')); return new RunCommand(this); })],
                ['requirements', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { RequirementsCommand } = yield Promise.resolve().then(() => require('./requirements')); return new RequirementsCommand(this); })],
                ['platforms', 'platform'],
                ['plugins', 'plugin'],
            ]);
        });
    }
}
exports.CordovaNamespace = CordovaNamespace;
