"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const namespace_1 = require("../../lib/namespace");
class DeployNamespace extends namespace_1.Namespace {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'deploy',
                summary: 'Appflow Deploy functionality',
                description: `
Interface to execute commands about deploy builds on Ionic Appflow.

Appflow deploy documentation:
- Overview: ${chalk_1.default.bold('https://ion.link/appflow-deploy-docs')}
`,
            };
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['build', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { BuildCommand } = yield Promise.resolve().then(() => require('./build')); return new BuildCommand(this); })],
                ['manifest', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { DeployManifestCommand } = yield Promise.resolve().then(() => require('./manifest')); return new DeployManifestCommand(this); })],
            ]);
        });
    }
}
exports.DeployNamespace = DeployNamespace;
