"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const guards_1 = require("../guards");
const command_1 = require("../lib/command");
const open_1 = require("../lib/open");
const serve_1 = require("../lib/serve");
const http_1 = require("../lib/utils/http");
class DocsCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'docs',
                type: 'global',
                summary: 'Open the Ionic documentation website',
                options: [
                    {
                        name: 'browser',
                        summary: `Specifies the browser to use (${serve_1.BROWSERS.map(b => chalk_1.default.green(b)).join(', ')})`,
                        aliases: ['w'],
                        groups: [cli_framework_1.OptionGroup.Advanced],
                    },
                ],
            };
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const browser = options['browser'] ? String(options['browser']) : undefined;
            const homepage = 'https://ion.link/docs';
            const url = this.project ? yield this.project.getDocsUrl() : homepage;
            try {
                const { req } = yield http_1.createRequest('HEAD', url, this.env.config.getHTTPConfig());
                yield req;
            }
            catch (e) {
                if (guards_1.isSuperAgentError(e) && e.response.status === 404) {
                    this.env.log.warn(`Docs not found for your specific version of Ionic. Directing you to docs homepage.`);
                    yield open_1.open(homepage, { app: browser });
                    return;
                }
                throw e;
            }
            yield open_1.open(url, { app: browser });
            this.env.log.ok('Launched Ionic docs in your browser!');
        });
    }
}
exports.DocsCommand = DocsCommand;
