"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const namespace_1 = require("../../lib/namespace");
class DoctorNamespace extends namespace_1.Namespace {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'doctor',
                summary: 'Commands for checking the health of your Ionic project',
            };
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['check', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { DoctorCheckCommand } = yield Promise.resolve().then(() => require('./check')); return new DoctorCheckCommand(this); })],
                ['treat', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { DoctorTreatCommand } = yield Promise.resolve().then(() => require('./treat')); return new DoctorTreatCommand(this); })],
                ['list', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { DoctorListCommand } = yield Promise.resolve().then(() => require('./list')); return new DoctorListCommand(this); })],
                ['ls', 'list'],
                ['checkup', 'check'],
                ['validate', 'check'],
                ['fix', 'treat'],
            ]);
        });
    }
}
exports.DoctorNamespace = DoctorNamespace;
