"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const command_1 = require("../lib/command");
const errors_1 = require("../lib/errors");
const project_1 = require("../lib/project");
class GenerateCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const inputs = [];
            const options = [];
            const exampleCommands = [''];
            const footnotes = [];
            let groups = [cli_framework_1.CommandGroup.Hidden];
            let description = this.project
                ? chalk_1.default.red(`Generators are not supported in this project type (${chalk_1.default.bold(project_1.prettyProjectName(this.project.type))}).`)
                : chalk_1.default.red('Generators help is available within an Ionic project directory.');
            const runner = this.project && (yield this.project.getGenerateRunner());
            if (runner) {
                const libmetadata = yield runner.getCommandMetadata();
                groups = libmetadata.groups || [];
                inputs.push(...libmetadata.inputs || []);
                options.push(...libmetadata.options || []);
                description = (libmetadata.description || '').trim();
                footnotes.push(...libmetadata.footnotes || []);
                exampleCommands.push(...libmetadata.exampleCommands || []);
            }
            return {
                name: 'generate',
                type: 'project',
                summary: 'Automatically create framework features',
                description,
                footnotes,
                inputs,
                options,
                groups,
                exampleCommands,
            };
        });
    }
    preRun(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const runner = this.project && (yield this.project.getGenerateRunner());
            if (runner) {
                yield runner.ensureCommandLine(inputs, options);
            }
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (!this.project) {
                throw new errors_1.FatalException(`Cannot run ${chalk_1.default.green('ionic generate')} outside a project directory.`);
            }
            const runner = yield this.project.requireGenerateRunner();
            const opts = runner.createOptionsFromCommandLine(inputs, options);
            yield runner.run(opts);
        });
    }
}
exports.GenerateCommand = GenerateCommand;
