"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const command_1 = require("../../lib/command");
// import { formatGitRepoUrl } from '../../lib/git';
class GitCloneCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'clone',
                type: 'global',
                summary: 'Clones an Ionic app git repository to your computer',
                inputs: [
                    {
                        name: 'id',
                        summary: 'The ID of the Ionic Appflow app to clone',
                        validators: [cli_framework_1.validators.required],
                    },
                    {
                        name: 'path',
                        summary: 'The destination directory of the cloned app',
                    },
                ],
                groups: [cli_framework_1.CommandGroup.Hidden],
            };
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            // let [ id, destination ] = inputs;
            // const appLoader = new App(this.env.session.getUserToken(), this.env.client);
            // const app = await appLoader.load(id);
            // const remote = await formatGitRepoUrl(this.env.config, app.id);
            // if (!destination) {
            //   destination = app.slug ? app.slug : app.id;
            // }
            // destination = path.resolve(destination);
            // await this.env.shell.run('git', ['clone', '-o', 'ionic', remote, destination], { stdio: 'inherit' });
            // this.env.log.ok(`Your app has been cloned to ${chalk.bold(prettyPath(destination))}!`);
        });
    }
}
exports.GitCloneCommand = GitCloneCommand;
