"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const namespace_1 = require("../../lib/namespace");
class GitNamespace extends namespace_1.Namespace {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'git',
                summary: 'Commands relating to git',
            };
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['clone', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { GitCloneCommand } = yield Promise.resolve().then(() => require('./clone')); return new GitCloneCommand(this); })],
                ['remote', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { GitRemoteCommand } = yield Promise.resolve().then(() => require('./remote')); return new GitRemoteCommand(this); })],
            ]);
        });
    }
}
exports.GitNamespace = GitNamespace;
