"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const guards_1 = require("../guards");
const command_1 = require("../lib/command");
class HelpCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'help',
                type: 'global',
                summary: 'Provides help for a certain command',
                exampleCommands: ['start'],
                inputs: [
                    {
                        name: 'command',
                        summary: 'The command you desire help with',
                    },
                ],
                options: [
                    {
                        name: 'json',
                        summary: 'Print help in JSON format',
                        type: Boolean,
                    },
                ],
                groups: [cli_framework_1.CommandGroup.Hidden],
            };
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { CommandSchemaHelpFormatter, CommandStringHelpFormatter, NamespaceSchemaHelpFormatter, NamespaceStringHelpFormatter } = yield Promise.resolve().then(() => require('../lib/help'));
            const location = yield this.namespace.locate(inputs);
            if (guards_1.isCommand(location.obj)) {
                const formatterOptions = { location, command: location.obj };
                const formatter = options['json'] ? new CommandSchemaHelpFormatter(formatterOptions) : new CommandStringHelpFormatter(formatterOptions);
                this.env.log.rawmsg(yield formatter.format());
            }
            else {
                if (location.args.length > 0) {
                    this.env.log.error(`Unable to find command: ${chalk_1.default.green(inputs.join(' '))}` +
                        (this.project ? '' : '\nYou may need to be in an Ionic project directory.'));
                }
                const now = new Date();
                const version = this.env.ctx.version;
                const suffix = now.getMonth() === 9 && now.getDate() === 31 ? ' 🎃' : '';
                const formatterOptions = {
                    inProject: this.project ? true : false,
                    version: version + suffix,
                    location,
                    namespace: location.obj,
                };
                const formatter = options['json'] ? new NamespaceSchemaHelpFormatter(formatterOptions) : new NamespaceStringHelpFormatter(formatterOptions);
                this.env.log.rawmsg(yield formatter.format());
            }
        });
    }
}
exports.HelpCommand = HelpCommand;
