import { IProject, IonicEnvironment } from '../definitions';
import { CommandMap, Namespace, NamespaceMap } from '../lib/namespace';
export interface IonicEnvironmentDeps {
    readonly env: IonicEnvironment;
    readonly project?: IProject;
}
export declare class IonicNamespace extends Namespace {
    protected _env: IonicEnvironment;
    protected _project: IProject | undefined;
    constructor({ env, project }: IonicEnvironmentDeps);
    project: IProject | undefined;
    env: IonicEnvironment;
    getMetadata(): Promise<{
        name: string;
        summary: string;
    }>;
    getNamespaces(): Promise<NamespaceMap>;
    getCommands(): Promise<CommandMap>;
}
