"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const namespace_1 = require("../lib/namespace");
class IonicNamespace extends namespace_1.Namespace {
    constructor({ env, project }) {
        super(undefined);
        this._env = env;
        this._project = project;
    }
    get project() {
        return this._project;
    }
    set project(p) {
        this._project = p;
    }
    get env() {
        return this._env;
    }
    set env(env) {
        this._env = env;
    }
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'ionic',
                summary: '',
            };
        });
    }
    getNamespaces() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.NamespaceMap([
                ['config', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { ConfigNamespace } = yield Promise.resolve().then(() => require('./config/index')); return new ConfigNamespace(this); })],
                ['cordova', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { CordovaNamespace } = yield Promise.resolve().then(() => require('./cordova/index')); return new CordovaNamespace(this); })],
                ['capacitor', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { CapacitorNamespace } = yield Promise.resolve().then(() => require('./capacitor/index')); return new CapacitorNamespace(this); })],
                ['deploy', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { DeployNamespace } = yield Promise.resolve().then(() => require('./deploy/index')); return new DeployNamespace(this); })],
                ['git', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { GitNamespace } = yield Promise.resolve().then(() => require('./git/index')); return new GitNamespace(this); })],
                ['package', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { PackageNamespace } = yield Promise.resolve().then(() => require('./package/index')); return new PackageNamespace(this); })],
                ['ssl', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { SSLNamespace } = yield Promise.resolve().then(() => require('./ssl/index')); return new SSLNamespace(this); })],
                ['ssh', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { SSHNamespace } = yield Promise.resolve().then(() => require('./ssh/index')); return new SSHNamespace(this); })],
                ['monitoring', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { MonitoringNamespace } = yield Promise.resolve().then(() => require('./monitoring/index')); return new MonitoringNamespace(this); })],
                ['doctor', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { DoctorNamespace } = yield Promise.resolve().then(() => require('./doctor/index')); return new DoctorNamespace(this); })],
                ['integrations', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { IntegrationsNamespace } = yield Promise.resolve().then(() => require('./integrations/index')); return new IntegrationsNamespace(this); })],
                ['cap', 'capacitor'],
            ]);
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['build', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { BuildCommand } = yield Promise.resolve().then(() => require('./build')); return new BuildCommand(this); })],
                ['docs', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { DocsCommand } = yield Promise.resolve().then(() => require('./docs')); return new DocsCommand(this); })],
                ['generate', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { GenerateCommand } = yield Promise.resolve().then(() => require('./generate')); return new GenerateCommand(this); })],
                ['help', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { HelpCommand } = yield Promise.resolve().then(() => require('./help')); return new HelpCommand(this); })],
                ['info', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { InfoCommand } = yield Promise.resolve().then(() => require('./info')); return new InfoCommand(this); })],
                ['init', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { InitCommand } = yield Promise.resolve().then(() => require('./init')); return new InitCommand(this); })],
                ['ionitron', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { IonitronCommand } = yield Promise.resolve().then(() => require('./ionitron')); return new IonitronCommand(this); })],
                ['link', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { LinkCommand } = yield Promise.resolve().then(() => require('./link')); return new LinkCommand(this); })],
                ['login', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { LoginCommand } = yield Promise.resolve().then(() => require('./login')); return new LoginCommand(this); })],
                ['logout', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { LogoutCommand } = yield Promise.resolve().then(() => require('./logout')); return new LogoutCommand(this); })],
                ['repair', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { RepairCommand } = yield Promise.resolve().then(() => require('./repair')); return new RepairCommand(this); })],
                ['serve', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { ServeCommand } = yield Promise.resolve().then(() => require('./serve')); return new ServeCommand(this); })],
                ['share', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { ShareCommand } = yield Promise.resolve().then(() => require('./share')); return new ShareCommand(this); })],
                ['signup', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { SignupCommand } = yield Promise.resolve().then(() => require('./signup')); return new SignupCommand(this); })],
                ['start', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { StartCommand } = yield Promise.resolve().then(() => require('./start')); return new StartCommand(this); })],
                ['state', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { StateCommand } = yield Promise.resolve().then(() => require('./state')); return new StateCommand(this); })],
                ['telemetry', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { TelemetryCommand } = yield Promise.resolve().then(() => require('./telemetry')); return new TelemetryCommand(this); })],
                ['version', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { VersionCommand } = yield Promise.resolve().then(() => require('./version')); return new VersionCommand(this); })],
                ['lab', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { LabCommand } = yield Promise.resolve().then(() => require('./serve')); return new LabCommand(this); })],
                ['g', 'generate'],
                ['s', 'serve'],
            ]);
        });
    }
}
exports.IonicNamespace = IonicNamespace;
