"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const namespace_1 = require("../../lib/namespace");
class IntegrationsNamespace extends namespace_1.Namespace {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'integrations',
                summary: 'Manage various integrations in your app',
                description: 'Integrations, such as Cordova, can be enabled or disabled in your app with these commands.',
            };
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['enable', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { IntegrationsEnableCommand } = yield Promise.resolve().then(() => require('./enable')); return new IntegrationsEnableCommand(this); })],
                ['disable', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { IntegrationsDisableCommand } = yield Promise.resolve().then(() => require('./disable')); return new IntegrationsDisableCommand(this); })],
                ['list', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { IntegrationsListCommand } = yield Promise.resolve().then(() => require('./list')); return new IntegrationsListCommand(this); })],
                ['ls', 'list'],
            ]);
        });
    }
}
exports.IntegrationsNamespace = IntegrationsNamespace;
