"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const format_1 = require("@ionic/cli-framework/utils/format");
const chalk_1 = require("chalk");
const command_1 = require("../../lib/command");
const errors_1 = require("../../lib/errors");
const integrations_1 = require("../../lib/integrations");
class IntegrationsListCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'list',
                type: 'project',
                summary: 'List available and active integrations in your app',
                description: `
This command will print the status of integrations in Ionic projects. Integrations can be ${chalk_1.default.bold('enabled')} (added and enabled), ${chalk_1.default.bold('disabled')} (added but disabled), and ${chalk_1.default.bold('not added')} (never added to the project).

- To enable or add integrations, see ${chalk_1.default.green('ionic integrations enable --help')}
- To disable integrations, see ${chalk_1.default.green('ionic integrations disable --help')}
      `,
            };
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { project } = this;
            if (!project) {
                throw new errors_1.FatalException(`Cannot run ${chalk_1.default.green('ionic integrations list')} outside a project directory.`);
            }
            const integrations = yield Promise.all(integrations_1.INTEGRATION_NAMES.map((name) => tslib_1.__awaiter(this, void 0, void 0, function* () { return project.createIntegration(name); })));
            const status = (name) => {
                const c = project.config.get('integrations')[name];
                if (c) {
                    if (c.enabled === false) {
                        return chalk_1.default.dim.red('disabled');
                    }
                    return chalk_1.default.green('enabled');
                }
                return chalk_1.default.dim('not added');
            };
            this.env.log.rawmsg(format_1.columnar(integrations.map(i => [chalk_1.default.green(i.name), i.summary, status(i.name)]), { headers: ['name', 'summary', 'status'] }));
        });
    }
}
exports.IntegrationsListCommand = IntegrationsListCommand;
