"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const command_1 = require("../lib/command");
class IonitronCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'ionitron',
                type: 'global',
                summary: 'Print random ionitron messages',
                options: [
                    {
                        name: 'es',
                        summary: 'Print in spanish',
                        type: Boolean,
                    },
                ],
                groups: [cli_framework_1.CommandGroup.Hidden],
            };
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { getIonitronString, ionitronStatements } = yield Promise.resolve().then(() => require('../lib/ionitron'));
            const locale = options['es'] ? 'es' : 'en';
            const localeStatements = ionitronStatements[locale];
            const statement = localeStatements[Math.floor(Math.random() * (localeStatements.length))];
            this.env.log.rawmsg(getIonitronString(statement));
        });
    }
}
exports.IonitronCommand = IonitronCommand;
