"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const command_1 = require("../lib/command");
class LogoutCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'logout',
                type: 'global',
                summary: 'Logout of Ionic Appflow',
                description: `
Remove the Ionic Appflow user token from the CLI config.

Login again with ${chalk_1.default.green('ionic login')}.

If you need to create an Ionic Appflow account, use ${chalk_1.default.green('ionic signup')}.
      `,
            };
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (!this.env.session.isLoggedIn()) {
                this.env.log.msg('You are already logged out.');
                return;
            }
            yield this.env.session.logout();
            this.env.log.ok('You are logged out.');
        });
    }
}
exports.LogoutCommand = LogoutCommand;
