"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const namespace_1 = require("../../lib/namespace");
class MonitoringNamespace extends namespace_1.Namespace {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const groups = [];
            if (!this.project || this.project.type !== 'ionic-angular') {
                groups.push(cli_framework_1.NamespaceGroup.Hidden);
            }
            return {
                name: 'monitoring',
                summary: 'Commands relating to Ionic Appflow Error Monitoring',
                groups,
            };
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['syncmaps', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { MonitoringSyncSourcemapsCommand } = yield Promise.resolve().then(() => require('./syncmaps')); return new MonitoringSyncSourcemapsCommand(this); })],
            ]);
        });
    }
}
exports.MonitoringNamespace = MonitoringNamespace;
