"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const namespace_1 = require("../../lib/namespace");
class PackageNamespace extends namespace_1.Namespace {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'package',
                summary: 'Appflow package functionality',
                description: `
Interface to execute commands about package builds on Ionic Appflow.

Appflow package documentation:
- Overview: ${chalk_1.default.bold('https://ion.link/appflow-package-docs')}
      `,
            };
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['build', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { BuildCommand } = yield Promise.resolve().then(() => require('./build')); return new BuildCommand(this); })],
            ]);
        });
    }
}
exports.PackageNamespace = PackageNamespace;
