"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const command_1 = require("../lib/command");
const errors_1 = require("../lib/errors");
class ShareCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'share',
                type: 'global',
                summary: '',
                groups: [cli_framework_1.CommandGroup.Hidden],
            };
        });
    }
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const dashUrl = this.env.config.getDashUrl();
            throw new errors_1.FatalException(`${chalk_1.default.green('ionic share')} has been removed.\n` +
                `The functionality now exists in the Ionic Dashboard: ${chalk_1.default.bold(dashUrl)}`);
        });
    }
}
exports.ShareCommand = ShareCommand;
