"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const command_1 = require("../lib/command");
const open_1 = require("../lib/open");
class SignupCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'signup',
                type: 'global',
                summary: 'Create an account for Ionic Appflow',
                description: `
Learn more about Ionic Appflow: ${chalk_1.default.bold('https://ion.link/appflow')}

If you are having issues signing up, please get in touch with our Support[^support-request].
      `,
                footnotes: [
                    {
                        id: 'support-request',
                        url: 'https://ion.link/support-request',
                    },
                ],
            };
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const dashUrl = this.env.config.getDashUrl();
            yield open_1.open(`${dashUrl}/signup?source=cli`);
            this.env.log.ok('Launched signup form in your browser!');
        });
    }
}
exports.SignupCommand = SignupCommand;
