"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const command_1 = require("../../lib/command");
const errors_1 = require("../../lib/errors");
class SSHBaseCommand extends command_1.Command {
    checkForOpenSSH() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                yield this.env.shell.run('ssh', ['-V'], { stdio: 'ignore', showCommand: false, fatalOnNotFound: false });
            }
            catch (e) {
                if (!(e instanceof cli_framework_1.ShellCommandError && e.code === cli_framework_1.ERROR_SHELL_COMMAND_NOT_FOUND)) {
                    throw e;
                }
                this.env.log.warn('OpenSSH not found on your computer.'); // TODO: more helpful message
                throw new errors_1.FatalException(`Command not found: ${chalk_1.default.bold('ssh')}`);
            }
        });
    }
}
exports.SSHBaseCommand = SSHBaseCommand;
