"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const namespace_1 = require("../../lib/namespace");
class SSHNamespace extends namespace_1.Namespace {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const dashUrl = this.env.config.getDashUrl();
            return {
                name: 'ssh',
                summary: 'Commands for configuring SSH keys',
                description: `
These commands help automate your SSH configuration for Ionic Appflow. As an alternative, SSH configuration can be done entirely manually by visiting your Personal Settings[^dashboard-settings-ssh-keys].

To begin, run ${chalk_1.default.green('ionic ssh setup')}, which lets you use existing keys or generate new ones just for Ionic.
      `,
                footnotes: [
                    {
                        id: 'dashboard-settings-ssh-keys',
                        url: `${dashUrl}/settings/ssh-keys`,
                    },
                ],
            };
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['generate', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { SSHGenerateCommand } = yield Promise.resolve().then(() => require('./generate')); return new SSHGenerateCommand(this); })],
                ['use', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { SSHUseCommand } = yield Promise.resolve().then(() => require('./use')); return new SSHUseCommand(this); })],
                ['add', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { SSHAddCommand } = yield Promise.resolve().then(() => require('./add')); return new SSHAddCommand(this); })],
                ['delete', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { SSHDeleteCommand } = yield Promise.resolve().then(() => require('./delete')); return new SSHDeleteCommand(this); })],
                ['list', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { SSHListCommand } = yield Promise.resolve().then(() => require('./list')); return new SSHListCommand(this); })],
                ['setup', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { SSHSetupCommand } = yield Promise.resolve().then(() => require('./setup')); return new SSHSetupCommand(this); })],
                ['ls', 'list'],
                ['remove', 'delete'],
                ['rm', 'delete'],
                ['g', 'generate'],
            ]);
        });
    }
}
exports.SSHNamespace = SSHNamespace;
