"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const command_1 = require("../../lib/command");
const errors_1 = require("../../lib/errors");
class SSLBaseCommand extends command_1.Command {
    checkForOpenSSL() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                yield this.env.shell.run('openssl', ['version'], { stdio: 'ignore', showCommand: false, fatalOnNotFound: false });
            }
            catch (e) {
                if (!(e instanceof cli_framework_1.ShellCommandError && e.code === cli_framework_1.ERROR_SHELL_COMMAND_NOT_FOUND)) {
                    throw e;
                }
                this.env.log.warn('OpenSSL not found on your computer.'); // TODO: more helpful message
                throw new errors_1.FatalException(`Command not found: ${chalk_1.default.bold('openssl')}`);
            }
        });
    }
}
exports.SSLBaseCommand = SSLBaseCommand;
