"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const namespace_1 = require("../../lib/namespace");
class SSLNamespace extends namespace_1.Namespace {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'ssl',
                summary: 'Commands for managing SSL keys & certificates',
                groups: [cli_framework_1.NamespaceGroup.Experimental],
                description: `
These commands make it easy to manage SSL certificates for using HTTPS with ${chalk_1.default.green('ionic serve')}.
      `,
            };
        });
    }
    getCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return new namespace_1.CommandMap([
                ['generate', () => tslib_1.__awaiter(this, void 0, void 0, function* () { const { SSLGenerateCommand } = yield Promise.resolve().then(() => require('./generate')); return new SSLGenerateCommand(this); })],
                ['g', 'generate'],
            ]);
        });
    }
}
exports.SSLNamespace = SSLNamespace;
