import { CommandInstanceInfo, CommandLineInputs, CommandLineOptions, CommandMetadata, CommandPreRun, ResolvedStarterTemplate, StarterManifest, StarterTemplate } from '../definitions';
import { Command } from '../lib/command';
export declare class StartCommand extends Command implements CommandPreRun {
    private canRemoveExisting;
    private schema?;
    getMetadata(): Promise<CommandMetadata>;
    preRun(inputs: CommandLineInputs, options: CommandLineOptions): Promise<void>;
    run(inputs: CommandLineInputs, options: CommandLineOptions, runinfo: CommandInstanceInfo): Promise<void>;
    getStarterTemplates(): Promise<StarterTemplate[]>;
    getStarterProjectTypes(): Promise<string[]>;
    checkForExisting(projectDir: string): Promise<void>;
    findStarterTemplate(template: string, type: string, tag: string): Promise<ResolvedStarterTemplate>;
    validateProjectType(type: string): Promise<void>;
    validateProjectId(projectId: string): Promise<void>;
    loadManifest(manifestPath: string): Promise<StarterManifest | undefined>;
    performManifestOps(manifest: StarterManifest): Promise<void>;
    downloadStarterTemplate(projectDir: string, starterTemplate: ResolvedStarterTemplate): Promise<void>;
    showNextSteps(projectDir: string, cloned: boolean, linkConfirmed: boolean): Promise<void>;
}
