"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const format_1 = require("@ionic/cli-framework/utils/format");
const chalk_1 = require("chalk");
const command_1 = require("../lib/command");
const errors_1 = require("../lib/errors");
class StateCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'state',
                type: 'global',
                summary: '',
                groups: [cli_framework_1.CommandGroup.Hidden],
            };
        });
    }
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const data = [
                [`${format_1.indent(4)}${chalk_1.default.green('ionic cordova platform save')}`, `save existing installed platforms to ${chalk_1.default.bold('config.xml')}`],
                [`${format_1.indent(4)}${chalk_1.default.green('ionic cordova plugin save')}`, `save existing installed plugins to ${chalk_1.default.bold('config.xml')}`],
                [`${format_1.indent(4)}${chalk_1.default.green('ionic cordova platform --help')}`, `view help page for managing Cordova platforms`],
                [`${format_1.indent(4)}${chalk_1.default.green('ionic cordova plugin --help')}`, `view help page for managing Cordova plugins`],
                [`${format_1.indent(4)}${chalk_1.default.green('ionic cordova prepare')}`, `install platforms and plugins listed in ${chalk_1.default.bold('config.xml')}`],
            ];
            throw new errors_1.FatalException(`${chalk_1.default.green('ionic state')} has been removed.\n\n` +
                `We recommend using Cordova directly to manage Cordova plugins and platforms.\n` +
                `The following commands fulfill the old ${chalk_1.default.green('ionic state')} functionality:\n\n` +
                `${format_1.columnar(data, {})}\n\n` +
                `See ${chalk_1.default.bold('https://cordova.apache.org/docs/en/latest/platform_plugin_versioning_ref/')} for detailed information.\n`);
        });
    }
}
exports.StateCommand = StateCommand;
