"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const chalk_1 = require("chalk");
const command_1 = require("../lib/command");
const errors_1 = require("../lib/errors");
class TelemetryCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'telemetry',
                type: 'global',
                summary: 'Opt in and out of telemetry',
                groups: [cli_framework_1.CommandGroup.Hidden],
                inputs: [
                    {
                        name: 'status',
                        summary: `${chalk_1.default.green('on')} or ${chalk_1.default.green('off')}`,
                    },
                ],
            };
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            throw new errors_1.FatalException(`${chalk_1.default.green('ionic telemetry')} has been removed.\n` +
                `Please use ${chalk_1.default.green('ionic config')} directly. Examples:\n\n` +
                `    ${chalk_1.default.green('ionic config get -g telemetry')}\n` +
                `    ${chalk_1.default.green('ionic config set -g telemetry true')}\n` +
                `    ${chalk_1.default.green('ionic config set -g telemetry false')}`);
        });
    }
}
exports.TelemetryCommand = TelemetryCommand;
