"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const command_1 = require("../lib/command");
class VersionCommand extends command_1.Command {
    getMetadata() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return {
                name: 'version',
                type: 'global',
                summary: 'Returns the current CLI version',
                groups: [cli_framework_1.CommandGroup.Hidden],
            };
        });
    }
    run(inputs, options) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            // can't use logger--see https://github.com/ionic-team/ionic-cli/issues/2507
            process.stdout.write(this.env.ctx.version + '\n');
        });
    }
}
exports.VersionCommand = VersionCommand;
