import { BaseCommand, TaskChain } from '@ionic/cli-framework';
import { CommandInstanceInfo, CommandLineInputs, CommandLineOptions, CommandMetadata, CommandMetadataInput, CommandMetadataOption, ICommand, INamespace, IProject, IonicEnvironment } from '../definitions';
export declare abstract class Command extends BaseCommand<ICommand, INamespace, CommandMetadata, CommandMetadataInput, CommandMetadataOption> implements ICommand {
    namespace: INamespace;
    protected readonly taskChains: TaskChain[];
    constructor(namespace: INamespace);
    readonly env: IonicEnvironment;
    readonly project: IProject | undefined;
    createTaskChain(): TaskChain;
    execute(inputs: CommandLineInputs, options: CommandLineOptions, runinfo: CommandInstanceInfo): Promise<void>;
    getCleanInputsForTelemetry(inputs: CommandLineInputs, options: CommandLineOptions): Promise<string[]>;
}
