"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const chalk_1 = require("chalk");
const guards_1 = require("../../../guards");
function formatAilmentMessage(ailment) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const treatable = guards_1.isTreatableAilment(ailment);
        return (`${yield ailment.getMessage()}\n` +
            `${yield formatAilmentSteps(ailment)}\n\n` +
            `${chalk_1.default.dim('$')} ${chalk_1.default.green(`ionic config set -g doctor.issues.${ailment.id}.ignored true`)} ${chalk_1.default.dim('(ignore this issue in the future)')}\n` +
            `${treatable ? `${chalk_1.default.dim('$')} ${chalk_1.default.green(`ionic doctor treat ${ailment.id}`)} ${chalk_1.default.dim('(attempt to fix this issue)')}\n` : ''}`);
    });
}
exports.formatAilmentMessage = formatAilmentMessage;
function formatAilmentSteps(ailment) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const steps = yield ailment.getTreatmentSteps();
        if (steps.length === 0) {
            return '';
        }
        const treatable = guards_1.isTreatableAilment(ailment);
        const msg = treatable ? `To fix, the following step(s) need to be taken:` : `To fix, take the following step(s):`;
        return `\n${msg}\n\n${steps.map((step, i) => ` ${chalk_1.default.dim(String(i + 1) + ')')} ${step.message}`).join('\n')}`;
    });
}
