"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const utils_fs_1 = require("@ionic/utils-fs");
const path = require("path");
function isGitInstalled({ shell }) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return Boolean(yield shell.cmdinfo('git', ['--version']));
    });
}
exports.isGitInstalled = isGitInstalled;
function getTopLevel({ shell }) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return shell.cmdinfo('git', ['rev-parse', '--show-toplevel']);
    });
}
exports.getTopLevel = getTopLevel;
function isRepoInitialized(dir) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return utils_fs_1.pathExists(path.join(dir, '.git'));
    });
}
exports.isRepoInitialized = isRepoInitialized;
function initializeRepo({ shell }, dir) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        yield shell.run('git', ['init'], { cwd: dir });
    });
}
exports.initializeRepo = initializeRepo;
function getIonicRemote({ shell }, dir) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const regex = /ionic\t(.+) \(\w+\)/;
        // would like to use get-url, but not available in git 2.0.0
        const remotes = yield shell.output('git', ['remote', '-v'], { cwd: dir });
        for (const line of remotes.split('\n')) {
            const match = regex.exec(line.trim());
            if (match) {
                return match[1];
            }
        }
    });
}
exports.getIonicRemote = getIonicRemote;
function addIonicRemote({ shell }, dir, url) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        yield shell.run('git', ['remote', 'add', 'ionic', url], { cwd: dir });
    });
}
exports.addIonicRemote = addIonicRemote;
function setIonicRemote({ shell }, dir, url) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        yield shell.run('git', ['remote', 'set-url', 'ionic', url], { cwd: dir });
    });
}
exports.setIonicRemote = setIonicRemote;
