"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const array_1 = require("@ionic/cli-framework/utils/array");
const config_1 = require("./config");
const IONIC_LOGO = String.raw `
   _             _
  (_) ___  _ __ (_) ___
  | |/ _ \| '_ \| |/ __|
  | | (_) | | | | | (__
  |_|\___/|_| |_|_|\___|`;
class NamespaceStringHelpFormatter extends cli_framework_1.NamespaceStringHelpFormatter {
    constructor(_a) {
        var { version, inProject } = _a, rest = tslib_1.__rest(_a, ["version", "inProject"]);
        super(rest);
        this.inProject = inProject;
        this.version = version;
    }
    formatHeader() {
        const _super = Object.create(null, {
            formatHeader: { get: () => super.formatHeader }
        });
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return this.namespace.parent ? _super.formatHeader.call(this) : this.formatIonicHeader();
        });
    }
    formatIonicHeader() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return IONIC_LOGO + `  CLI ${this.version}\n\n`;
        });
    }
    getGlobalOptions() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const visibleOptions = yield array_1.filter(config_1.GLOBAL_OPTIONS, (opt) => tslib_1.__awaiter(this, void 0, void 0, function* () { return cli_framework_1.isOptionVisible(opt); }));
            return visibleOptions.map(opt => cli_framework_1.formatOptionName(opt, { colors: cli_framework_1.NO_COLORS, showAliases: false }));
        });
    }
    formatCommands() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { strong } = this.colors;
            const commands = yield this.namespace.getCommandMetadataList();
            const globalCmds = commands.filter(cmd => cmd.type === 'global');
            const projectCmds = commands.filter(cmd => cmd.type === 'project');
            return ((yield this.formatCommandGroup('Global Commands', globalCmds)) +
                (this.inProject ? yield this.formatCommandGroup('Project Commands', projectCmds) : `\n  ${strong('Project Commands')}:\n\n    You are not in a project directory.\n`));
        });
    }
}
exports.NamespaceStringHelpFormatter = NamespaceStringHelpFormatter;
class CommandStringHelpFormatter extends cli_framework_1.CommandStringHelpFormatter {
    formatOptions() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const metadata = yield this.getCommandMetadata();
            const options = metadata.options ? metadata.options : [];
            const basicOptions = options.filter(o => !o.groups || !o.groups.includes(cli_framework_1.OptionGroup.Advanced));
            const advancedOptions = options.filter(o => o.groups && o.groups.includes(cli_framework_1.OptionGroup.Advanced));
            return ((yield this.formatOptionsGroup('Options', basicOptions)) +
                (yield this.formatOptionsGroup('Advanced Options', advancedOptions)));
        });
    }
    formatBeforeOptionSummary(opt) {
        const _super = Object.create(null, {
            formatBeforeOptionSummary: { get: () => super.formatBeforeOptionSummary }
        });
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return (opt.hint ? `${opt.hint} ` : '') + (yield _super.formatBeforeOptionSummary.call(this, opt));
        });
    }
}
exports.CommandStringHelpFormatter = CommandStringHelpFormatter;
class NamespaceSchemaHelpFormatter extends cli_framework_1.NamespaceSchemaHelpFormatter {
    formatCommand(cmd) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { command } = cmd;
            const formatter = new CommandSchemaHelpFormatter({
                location: { path: [...cmd.path], obj: command, args: [] },
                command,
                metadata: cmd,
            });
            return Object.assign({}, yield formatter.serialize(), { type: cmd.type });
        });
    }
}
exports.NamespaceSchemaHelpFormatter = NamespaceSchemaHelpFormatter;
class CommandSchemaHelpFormatter extends cli_framework_1.CommandSchemaHelpFormatter {
    formatCommand(cmd) {
        const _super = Object.create(null, {
            formatCommand: { get: () => super.formatCommand }
        });
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const formatted = yield _super.formatCommand.call(this, cmd);
            return Object.assign({}, formatted, { type: cmd.type });
        });
    }
}
exports.CommandSchemaHelpFormatter = CommandSchemaHelpFormatter;
