"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const shell_1 = require("@ionic/cli-framework/utils/shell");
const utils_fs_1 = require("@ionic/utils-fs");
const path = require("path");
function sendMessage({ config, ctx }, msg) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const dir = path.dirname(config.p);
        yield utils_fs_1.mkdirp(dir);
        const fd = yield utils_fs_1.open(path.resolve(dir, 'helper.log'), 'a');
        const p = shell_1.fork(ctx.binPath, ['_', '--no-interactive'], { stdio: ['ignore', fd, fd, 'ipc'] });
        p.send(msg);
        p.disconnect();
        p.unref();
    });
}
exports.sendMessage = sendMessage;
