"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const cli_framework_1 = require("@ionic/cli-framework");
const format_1 = require("@ionic/cli-framework/utils/format");
const terminal_1 = require("@ionic/cli-framework/utils/terminal");
const chalk_1 = require("chalk");
const Debug = require("debug");
const path = require("path");
const bootstrap_1 = require("../bootstrap");
const config_1 = require("./config");
const environment_1 = require("./environment");
const http_1 = require("./http");
const project_1 = require("./project");
const prompts_1 = require("./prompts");
const session_1 = require("./session");
const shell_1 = require("./shell");
const http_2 = require("./utils/http");
const logger_1 = require("./utils/logger");
const debug = Debug('ionic:lib');
function generateIonicEnvironment(ctx, pargv) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        process.chdir(ctx.execPath);
        const argv = config_1.parseGlobalOptions(pargv);
        const config = new config_1.Config(path.resolve(process.env['IONIC_CONFIG_DIRECTORY'] || config_1.DEFAULT_CONFIG_DIRECTORY, config_1.CONFIG_FILE));
        debug('Terminal info: %o', terminal_1.TERMINAL_INFO);
        if (config.get('interactive') === false || !terminal_1.TERMINAL_INFO.tty || terminal_1.TERMINAL_INFO.ci) {
            argv['interactive'] = false;
        }
        const flags = argv; // TODO
        debug('CLI global options: %o', flags);
        const log = new logger_1.Logger({
            level: argv['quiet'] ? cli_framework_1.LOGGER_LEVELS.WARN : cli_framework_1.LOGGER_LEVELS.INFO,
            handlers: logger_1.createDefaultLoggerHandlers(),
        });
        const prompt = yield cli_framework_1.createPromptModule({
            interactive: argv['interactive'],
            onFallback: prompts_1.createOnFallback({ flags, log }),
        });
        const projectDir = yield project_1.findProjectDirectory(ctx.execPath);
        const proxyVars = http_2.PROXY_ENVIRONMENT_VARIABLES.map((e) => [e, process.env[e]]).filter(([, v]) => !!v);
        const getInfo = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const osName = yield Promise.resolve().then(() => require('os-name'));
            const os = osName();
            const npm = yield shell.cmdinfo('npm', ['-v']);
            const info = [
                {
                    group: 'ionic',
                    key: 'ionic',
                    flair: 'Ionic CLI',
                    value: ctx.version,
                    path: ctx.libPath,
                },
                { group: 'system', key: 'NodeJS', value: process.version, path: process.execPath },
                { group: 'system', key: 'npm', value: npm || 'not installed' },
                { group: 'system', key: 'OS', value: os },
            ];
            info.push(...proxyVars.map(([e, v]) => ({ group: 'environment', key: e, value: v || 'not set' })));
            if (project) {
                info.push(...(yield project.getInfo()));
            }
            return info;
        });
        const shell = new shell_1.Shell({ log }, { alterPath: p => projectDir ? shell_1.prependNodeModulesBinToPath(projectDir, p) : p });
        const client = new http_1.Client(config);
        const session = new session_1.ProSession({ config, client });
        const deps = { client, config, ctx, flags, log, prompt, session, shell };
        const env = new environment_1.Environment(Object.assign({ getInfo }, deps));
        if (process.env['IONIC_CLI_LOCAL_ERROR']) {
            if (process.env['IONIC_CLI_LOCAL_ERROR'] === bootstrap_1.ERROR_VERSION_TOO_OLD) {
                log.warn(`Detected locally installed Ionic CLI, but it's too old--using global CLI.`);
            }
        }
        if (typeof argv['yarn'] === 'boolean') {
            log.warn(`${chalk_1.default.green('--yarn')} / ${chalk_1.default.green('--no-yarn')} has been removed. Use ${chalk_1.default.green(`ionic config set -g npmClient ${argv['yarn'] ? 'yarn' : 'npm'}`)}.`);
        }
        const project = projectDir ? yield project_1.createProjectFromDirectory(projectDir, argv, deps, { logErrors: !['start', 'init'].includes(argv._[0]) }) : undefined;
        if (project) {
            shell.alterPath = p => shell_1.prependNodeModulesBinToPath(project.directory, p);
            if (project.config.get('pro_id') && argv._[1] !== 'unset') {
                log.warn(`The ${chalk_1.default.green('pro_id')} field in ${chalk_1.default.bold(format_1.prettyPath(project.filePath))} has been deprecated.\n` +
                    `Ionic Pro has been renamed to Ionic Appflow! We've copied the value in ${chalk_1.default.green('pro_id')} to ${chalk_1.default.green('id')}, but you may want to unset the deprecated property: ${chalk_1.default.green('ionic config unset pro_id')}\n`);
            }
        }
        return { env, project };
    });
}
exports.generateIonicEnvironment = generateIonicEnvironment;
