"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Find the command that is the equivalent of a legacy command.
 */
function mapLegacyCommand(command) {
    const commandMap = {
        'compile': 'cordova compile',
        'emulate': 'cordova emulate',
        'platform': 'cordova platform',
        'plugin': 'cordova plugin',
        'prepare': 'cordova prepare',
        'resources': 'cordova resources',
        'run': 'cordova run',
        'cordova:build': 'cordova build',
        'cordova:compile': 'cordova compile',
        'cordova:emulate': 'cordova emulate',
        'cordova:platform': 'cordova platform',
        'cordova:plugin': 'cordova plugin',
        'cordova:prepare': 'cordova prepare',
        'cordova:resources': 'cordova resources',
        'cordova:run': 'cordova run',
    };
    return commandMap[command];
}
exports.mapLegacyCommand = mapLegacyCommand;
