"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cli_framework_1 = require("@ionic/cli-framework");
const lodash = require("lodash");
exports.CAPACITOR_CONFIG_FILE = 'capacitor.config.json';
class CapacitorConfig extends cli_framework_1.BaseConfig {
    provideDefaults(config) {
        return config;
    }
    setServerUrl(url) {
        const serverConfig = this.get('server') || {};
        if (serverConfig.url) {
            serverConfig.originalUrl = serverConfig.url;
        }
        serverConfig.url = url;
        this.set('server', serverConfig);
    }
    resetServerUrl() {
        const serverConfig = this.get('server') || {};
        delete serverConfig.url;
        if (serverConfig.originalUrl) {
            serverConfig.url = serverConfig.originalUrl;
            delete serverConfig.originalUrl;
        }
        if (lodash.isEmpty(serverConfig)) {
            this.unset('server');
        }
        else {
            this.set('server', serverConfig);
        }
    }
}
exports.CapacitorConfig = CapacitorConfig;
