import { BaseIntegration } from '../';
import { InfoItem, IntegrationAddDetails, IntegrationAddHandlers, IntegrationName, ProjectPersonalizationDetails } from '../../../definitions';
export declare class Integration extends BaseIntegration {
    readonly name: IntegrationName;
    readonly summary = "Target native iOS and Android with Capacitor, Ionic's new native layer";
    readonly archiveUrl: undefined;
    add(details: IntegrationAddDetails, handlers?: IntegrationAddHandlers): Promise<void>;
    installCapacitorCore(): Promise<void>;
    installCapacitorCLI(): Promise<void>;
    personalize({ name, packageId }: ProjectPersonalizationDetails): Promise<void>;
    getInfo(): Promise<InfoItem[]>;
    getCapacitorCLIVersion(): Promise<string | undefined>;
}
